<?php

namespace App\Http\Resources\Resturant;
use App\Models\AdditionalProducts;
use App\Models\CustomersGroup;
use App\Models\DefaultDataShowHide;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Stores;
use App\Models\VAQty;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DateTime;

class ResturantVAssemblyQtyFilterResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');



        $pro=request('product_id');
        $store=request('store_id');

        $average=new Average();
        $service=new SalesService();

        $Available=0;
        $COSTpr=0;
        $yes=0;
        $kmya=0;

        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
        $AdditionsCount=AdditionalProducts::where('Product',$this->Product)->count();
        $st=Stores::find($store);
        if(app()->getLocale() == 'ar' ){
            $PrrroName=$this->Product()->first()->P_Ar_Name;
            $PrrroNameV=$this->SubV()->first()->Name;
            $UniiName=$rr->Unit()->first()->Name;
        }else{
            $PrrroName=$this->Product()->first()->P_En_Name;
            $PrrroNameV=$this->SubV()->first()->NameEn;
            $UniiName=$rr->Unit()->first()->NameEn;
        }

        $QTYs=VAQty::
        where('Product',$this->Product)
            ->where('SubV',$this->SubV)
            ->get();


        foreach($QTYs as $qty){

            $AvQty=$this->ProAvQties($store,$qty->ProductID,$qty->VAProductID()->first()->Product_Code);
            $QTYsSum=VAQty::
            where('Product',$this->Product)
                ->where('ProductID',$qty->ProductID)
                ->where('SubV',$qty->SubV)
                ->get()->sum('Qty');

            if($AvQty->Qty < $QTYsSum){

                $Available +=0;
                $yes +=1;
                $kmya =0;
            }else{

                $Available +=$AvQty->Qty/$QTYsSum;

                $AvailableTwo =$AvQty->Qty/$QTYsSum;

                if($kmya == null) {
                    $kmya = $AvailableTwo;
                }else{
                    if($kmya > $AvailableTwo) {

                        $kmya=$AvailableTwo;
                    }

                }

                $yes +=0;
            }


            $rr=ProductUnits::where('Product',$qty->ProductID)->where('Def',1)->first();
            $COSTpr +=$average->AverageCostGetUnit($qty->ProductID,$rr->Barcode,$store,$rr->Unit) * $qty->Qty;
        }



        if($yes == 0) {
            $data = [

                'row_id' => $this->id,
                'name' => $PrrroName,
                'virable' => $PrrroNameV,
                'product_ar_name' => $this->Product()->first()->P_Ar_Name,
                'product_en_name' => $this->Product()->first()->P_En_Name,
                'product_id' => $this->Product,
                'virable_one_id' => '',
                'virable_two_id' =>'',
                'virable_one_name' => '',
                'virable_two_name' => '',
                'product_code' => $rr->Barcode,
                'unit_name' => $UniiName,
                'unit_id' => $rr->Unit,
                'unit_default' => $rr->Unit,
                'units' => '',
                'code_default' => $rr->Barcode,
                'tax_rate' => $rr->Product()->first()->Tax()->first()->Rate,
                'tax_type' => $rr->Product()->first()->Tax()->first()->Type,
                'tax_id' => $rr->Product()->first()->Tax,
                'avalible_qty' => $kmya,
                'qty' => 1,
                'price' => $this->Price,
                'priceOne' => $rr->Price,
                'priceTwo' => $rr->Price_Two,
                'priceThree' => $rr->Price_Three,
                'discount' => 0,
                'total_disc_pro' => 0,
                'total_before_tax' => $this->Price,
                'tax_value' => 0,
                'total' => $this->Price,
                'store_id' => $st->id,
                'store_name' => $st->id,
                'ExpDate' => '',
                'serial' => 0,
                'high_disc' => 0,
                'cost_price' => $COSTpr,
                'weight' => '',
                'max_sales' => '',
                'unit_rate' => $rr->Rate,
                'sales_pro_desc' => '',
                'AV' => 0,
                'AdditionsCount' => '',


            ];

            return $data ;
        }




    }

}
