<?php

namespace App\Http\Resources\Resturant;


use App\Models\Coins;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\MoreProductsHall;
use App\Models\ProductSalesOrder;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnSales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class ResturantKitchensHallOrdersResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        if($lang == 'ar'){





            $data=[

                'id'=>$this->SalesOrder,
                'code'=>$this->SalesOrder()->first()->Code,
                'date'=>$this->SalesOrder()->first()->Date,
                'time'=>$this->SalesOrder()->first()->Time,
                'table'=>$this->SalesOrder()->first()->Table()->first()->Arabic_Name,
                'waiter'=>$this->SalesOrder()->first()->Witer()->first()->Name,
                'products'=>$this->when(!empty($this->id), function () {

                    $details=MoreProductsHall::orderBy('id','asc')->where('SalesOrder',$this->SalesOrder)->get();
                    $CustomersAddresses=DetailsKitchensHallOrderResources::collection($details);

                    return $CustomersAddresses;
                }),


            ];




        }else{







            $data=[

                'id'=>$this->SalesOrder,
                'code'=>$this->SalesOrder()->first()->Code,
                'date'=>$this->SalesOrder()->first()->Date,
                'time'=>$this->SalesOrder()->first()->Time,
                'table'=>$this->SalesOrder()->first()->Table()->first()->English_Name,
                'waiter'=>$this->SalesOrder()->first()->Witer()->first()->NameEn,
                'products'=>$this->when(!empty($this->id), function () {

                    $details=MoreProductsHall::orderBy('id','asc')->where('SalesOrder',$this->SalesOrder)->get();
                    $CustomersAddresses=DetailsKitchensHallOrderResources::collection($details);

                    return $CustomersAddresses;
                }),

            ];





        }





        return $data ;
    }

}
