<?php

namespace App\Http\Resources\Resturant;

use App\Models\Coins;
use App\Models\Comments;
use App\Models\Countris;
use App\Models\Customers;
use App\Models\Products;
use App\Models\ProductsVira;
use App\Models\ProductUnits;
use App\Models\Rate;
use App\Models\SalesDefaultData;
use App\Models\SubImages;
use App\Models\SubVirables;
use App\Models\VAPrice;
use Illuminate\Http\Resources\Json\JsonResource;
use DateTime;
use Str;
class ProductsResources extends JsonResource
{
    public function toArray($request)
    {

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        if(!empty($x)){
            $admin=Customers::where('token',$x)->first();
        }else{
            $admin=null;
        }



        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $coin=Coins::find($Def->CountryResturantWebsite);
        $Country=Countris::where('Coin',$coin->id)->orderBy('id','desc')->first();

        $lang = $request->header('lang', '');



            if (!empty($admin)) {

                $rate = Rate::where('User', $admin->id)->where('Product', $this->id)->first();
                if (!empty($rate->Rate)) {
                    $myRAte = $rate->Rate;
                    $myRAteID = $rate->id;
                } else {
                    $myRAte = null;
                    $myRAteID = null;
                }


            } else {
                $myRAte = null;
                $myRAteID = null;
            }

            $Price = ProductUnits::where('Product', $this->id)->where('Def', 1)->first();
            if ($this->Offer == 1) {
                $Offerprice = $this->OfferPrice;
                $price = $Price->Price;
            } else {
                $price = $Price->Price;
                $Offerprice = 0;
            }

            if ($lang == 'ar') {

                $ProName = $this->P_Ar_Name;
                $Desc = strip_tags($this->Ar_Desc);
                $Spec = strip_tags($this->Ar_Spec);

            } else {

                $ProName = $this->P_En_Name;
                $Desc = strip_tags($this->En_Desc);
                $Spec = strip_tags($this->En_Spec);

            }

            $data = [

                'image_1'=>URL::to($this->Image),
                'image_2'=>URL::to($this->Image2),
                'name'=>$ProName,
                'symbol'=>$Country->Coin()->first()->Symbol,
                'offer_price'=>$Offerprice,
                'price'=>$price,
                'rate'=>$this->rate,
                'id'=>$this->id,
                'type'=>$this->P_Type,
                'product_rate' => $this->rate,
                'product_description' => $Desc,
                'product_spection' => $Spec,
                'user_rate_id' => $myRAteID,
                'user_rate' => $myRAte,

                'comments' => $this->when(!empty($this->id), function () {

                    $Comments = Comments::where('Product', $this->id)->paginate(12);

                    $CommentsDet = CommentsProductsResources::collection($Comments);

                    return $CommentsDet;
                }),

                'rates' => $this->when(!empty($this->id), function () {

                    $Rates = Rate::where('Product', $this->id)->get();

                    $RateDet = RatesProductsResources::collection($Rates);

                    return $RateDet;
                }),



                'Variable_Aggregate' => $this->when($this->P_Type == 'Variable_Aggregate', function () {

                    $ProVira=VAPrice::where('Product',$this->id)->get();
                    $ViraDet = VariableAggregateResources::collection($ProVira);

                    return $ViraDet;
                }),



            ];

            return $data;
        }

}
