<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\ProductSales;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnPurch;
use App\Models\ReturnSales;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class SalesBillsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $details = ProductSales::where('Sales', $this->id)->get();
        $TotalReturn = ReturnSales::where('Sales', $this->id)->get()->sum('Total_Return_Value');


        if (!empty($this->Branch)) {

            if ($lang == 'ar') {
                $Branch = $this->Branch()->first()->Arabic_Name;
            } else {
                $Branch = $this->Branch()->first()->English_Name;
            }
        } else {
            $Branch = '';
        }


        if (!empty($this->Client)) {

            if ($lang == 'ar') {
                $Vendor = $this->Client()->first()->Name;
            } else {
                $Vendor = $this->Client()->first()->NameEn;
            }
        } else {
            $Vendor = '';
        }

        if ($lang == 'ar') {
            $Store = $this->Store()->first()->Name;
            $Safe = $this->Safe()->first()->Name;
        } else {
            $Store = $this->Store()->first()->NameEn;
            $Safe = $this->Safe()->first()->NameEn;
        }


        if ($this->Status == 0) {
            $status = trans('admin.Pending');
        }elseif($this->Status == 1){

            $status=trans('admin.Recived');
        }

        $resd=$this->Total_Net - $this->Pay;


        $Newresd=($this->Total_Net - $this->Pay) - $TotalReturn;


        if (!empty($this->Coin)) {

            if ($lang == 'ar') {
                $Coin = $this->Coin()->first()->Arabic_Name;
            } else {
                $Coin = $this->Coin()->first()->English_Name;
            }
        } else {
            $Coin = '';
        }


        if (!empty($this->Delegate)) {

            if ($lang == 'ar') {
                $Delegate = $this->Delegate()->first()->Name;
            } else {
                $Delegate = $this->Delegate()->first()->NameEn;
            }
        } else {
            $Delegate = '';
        }






        if (!empty($this->Executor)) {

            if ($lang == 'ar') {
                $Executor = $this->Executor()->first()->Name;
            } else {
                $Executor = $this->Executor()->first()->NameEn;
            }
        } else {
            $Executor = '';
        }

        if (!empty($this->User)) {

            if ($lang == 'ar') {
                $User = $this->User()->first()->name;
            } else {
                $User = $this->User()->first()->nameEn;
            }
        } else {
            $User = '';
        }


        if (!empty($this->Ship)) {

            if ($lang == 'ar') {
                $Ship = $this->Ship()->first()->Name;
            } else {
                $Ship = $this->Ship()->first()->NameEn;
            }
        } else {
            $Ship = '';
        }


        if (!empty($this->Cost_Center)) {

            if ($lang == 'ar') {
                $Cost_Center = $this->Cost_Center()->first()->Arabic_Name;
            } else {
                $Cost_Center = $this->Cost_Center()->first()->English_Name;
            }
        } else {
            $Cost_Center = '';
        }




        if (!empty($this->InstallCompany)) {

            if ($lang == 'ar') {
                $InstallCompany = $this->InstallCompany()->first()->Arabic_Name;
            } else {
                $InstallCompany = $this->InstallCompany()->first()->English_Name;
            }
        } else {
            $InstallCompany = '';
        }






        $data=[

            'Date'=>  $this->Date
            ,'Time'=>$this->Time
            ,'Code'=>$this->Code
            ,'Refernce_Number'=>$this->Refernce_Number
            ,'Branch'=>$Branch
            ,'Client'=>$Vendor
            ,'Store'=>$Store
            ,'Safe'=>$Safe
            ,'Type'=>$status
            ,'Total_Price'=>number_format((float)$this->Total_Price + $TotalReturn, 2, '.', '')
            ,'Total_Discount'=>$this->Total_Discount
            ,'Total_Tax'=>$this->Total_Taxes
            ,'Total_Net'=>$this->Total_Net
            ,'Total_Return'=>$TotalReturn
            ,'Total_Net_After_Return'=>$this->Total_Net - $TotalReturn
            ,'Pay'=>$this->Pay
            ,'Residual'=>number_format((float)$resd, 2, '.', '')
            ,'Due_Date'=>$this->Later_Due
            ,'Coin'=>$Coin
            ,'Shift_Code'=>$this->Shift_Code
            ,'Delegate'=>$Delegate
            ,'Executor'=>$Executor
            ,'User'=>$User
            ,'Shipping_Compaines'=>$Ship
            ,'Cost_Center'=>$Cost_Center
            ,'Note'=>$this->Note
            ,'InstallCompany'=>$InstallCompany
            ,'ContractNumber'=>$this->ContractNumber
            ,'PayFees'=>$this->PayFees
            ,'ServiceFee'=>$this->ServiceFee
            ,'CompanyPrecent'=>$this->CompanyPrecent
            ,'details'=>$this->when(!empty($this->id), function () {

                $details=ProductSalesApiResources::collection(ProductSales::where('Sales',$this->id)->get());

                return $details;
            }),



        ];


        return $data ;

    }

}
