<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ReportStartPeriodApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        if($lang == 'ar'){
            $ProoName=$this->P_Ar_Name;
            if(!empty($this->V1)){
                $ProoVName=$this->V1()->first()->Name;
            }else{
                $ProoVName='';
            }
            if(!empty($this->V2)){
                $ProoVVName=$this->V2()->first()->Name;
            }else{
                $ProoVVName='';
            }
            $UniiName=$this->Unit()->first()->Name;
            $StoName=$this->Store()->first()->Name;


        }else{
            $ProoName=$this->P_En_Name;
            if(!empty($this->V1)){
                $ProoVName=$this->V1()->first()->NameEn;
            }else{
                $ProoVName='';
            }
            if(!empty($this->V2)){
                $ProoVVName=$this->V2()->first()->NameEn;
            }else{
                $ProoVVName='';
            }
            $UniiName=$this->Unit()->first()->NameEn;
            $StoName=$this->Store()->first()->NameEn;


        }



        $data=[

            'Date'=>$this->Date
            ,'Product_Code'=>$this->P_Code
            ,'Product_Name'=>$ProoName. ($ProoVName  .'-'.  $ProoVVName )
            ,'Unit'=>$UniiName
            ,'Qty'=>$this->Qty
            ,'Price'=>$this->Price
            ,'Total'=>$this->Total
            ,'Exp_Date'=>$this->Exp_Date
            ,'Store'=>$StoName


        ];






        return $data ;
    }

}
