<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\ProductSales;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnPurch;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class PurchasesBillsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $details = ProductsPurchases::where('Purchase', $this->id)->get();
        $TotalReturn = ReturnPurch::where('Purchase', $this->id)->get()->sum('Total_Return_Value');


        if (!empty($this->Branch)) {

            if ($lang == 'ar') {
                $Branch = $this->Branch()->first()->Arabic_Name;
            } else {
                $Branch = $this->Branch()->first()->English_Name;
            }
        } else {
            $Branch = '';
        }


        if (!empty($this->Vendor)) {

            if ($lang == 'ar') {
                $Vendor = $this->Vendor()->first()->Name;
            } else {
                $Vendor = $this->Vendor()->first()->NameEn;
            }
        } else {
            $Vendor = '';
        }

        if ($lang == 'ar') {
            $Store = $this->Store()->first()->Name;
            $Safe = $this->Safe()->first()->Name;
        } else {
            $Store = $this->Store()->first()->NameEn;
            $Safe = $this->Safe()->first()->NameEn;
        }


        if ($this->Status == 0) {
            $status = trans('admin.Pending');
        }elseif($this->Status == 1){

          $status=trans('admin.Recived');
                                 }

  $resd=$this->Total_Net - $this->Pay;


    $Newresd=($this->Total_Net - $this->Pay) - $TotalReturn;


        if (!empty($this->Coin)) {

            if ($lang == 'ar') {
                $Coin = $this->Coin()->first()->Arabic_Name;
            } else {
                $Coin = $this->Coin()->first()->English_Name;
            }
        } else {
            $Coin = '';
        }


        if (!empty($this->Delegate)) {

            if ($lang == 'ar') {
                $Delegate = $this->Delegate()->first()->Name;
            } else {
                $Delegate = $this->Delegate()->first()->NameEn;
            }
        } else {
            $Delegate = '';
        }

       if (!empty($this->User)) {

            if ($lang == 'ar') {
                $User = $this->User()->first()->name;
            } else {
                $User = $this->User()->first()->nameEn;
            }
        } else {
            $User = '';
        }


        if (!empty($this->Ship)) {

            if ($lang == 'ar') {
                $Ship = $this->Ship()->first()->Name;
            } else {
                $Ship = $this->Ship()->first()->NameEn;
            }
        } else {
            $Ship = '';
        }


        if (!empty($this->Cost_Center)) {

            if ($lang == 'ar') {
                $Cost_Center = $this->Cost_Center()->first()->Arabic_Name;
            } else {
                $Cost_Center = $this->Cost_Center()->first()->English_Name;
            }
        } else {
            $Cost_Center = '';
        }



        $data=[

            'Date'=>  $this->Date
            ,'Time'=>$this->Time
            ,'Code'=>$this->Code
            ,'Refernce_Number'=>$this->Refernce_Number
            ,'Branch'=>$Branch
            ,'Vendor'=>$Vendor
            ,'Store'=>$Store
            ,'Safe'=>$Safe
            ,'Type'=>$status
            ,'Total_Price'=>number_format((float)$this->Total_Price + $TotalReturn, 2, '.', '')
            ,'Total_Discount'=>$this->Total_Discount
            ,'Total_Tax'=>$this->Total_Taxes
            ,'Total_Net'=>$this->Total_Net
            ,'Total_Return'=>$TotalReturn
            ,'Total_Net_After_Return'=>$this->Total_Net - $TotalReturn
            ,'Pay'=>$this->Pay
            ,'Residual'=>number_format((float)$resd, 2, '.', '')
            ,'Residual_After_Return'=>number_format((float)$Newresd, 2, '.', '')
            ,'Due_Date'=>$this->Later_Due
            ,'Coin'=>$Coin
            ,'Delegate'=>$Delegate
            ,'User'=>$User
            ,'Shipping_Compaines'=>$Ship
            ,'Cost_Center'=>$Cost_Center
            ,'Note'=>$this->Note
              ,'details'=>$this->when(!empty($this->id), function () {

        $details=ProductPurchResources::collection(ProductsPurchases::where('Purchase',$this->id)->get());

        return $details;
                 }),



        ];


        return $data ;

    }

}
