<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\GeneralDaily;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnSales;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class DailyShiftsDetailsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $Date = $request->get('Date');
        $Safe = $request->get('Safe');

        $RCash=0;
        $RCashh=0;
        $RLater=0;
        $RLaterr=0;


        $Sales =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','!=','Check')
            ->where('Date', $Date)
            ->where('Shift_Code', $this->Code)
            ->get();

        $ReturnSales =ReturnSales::orderBy('id','asc')
            ->where('Date', $Date)
            ->get();


        $Cash =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Cash')
            ->where('Date', $Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('Total_Net');

        $discoo =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Cash')
            ->where('Date', $Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('Pay');


        $Later =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Later')
            ->where('Date',$Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('Pay');


        $CashVisa =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Cash_Visa')
            ->where('Date',$Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('Total_Net');


        $Visa =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Visa')
            ->where('Date',$Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('Total_Net');


        $Installment =Sales::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Payment_Method','Installment')
            ->where('Date', $Date)
            ->where('Shift_Code', $this->Code)
            ->get()->sum('presenter');

        $TotSales=  $Cash + $Later +  $CashVisa+ $Installment + $Visa;

        $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Date', $Date)
            ->where('Shift', $this->Code)
            ->get();

        $ReciptTot =ReciptVoucher::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Date',$Date)
            ->where('Shift', $this->Code)
            ->get()->sum('Total_Creditor');


        $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Date', $Date)
            ->where('Shift', $this->Code)
            ->get();

        $PaymentTot =PaymentVoucher::orderBy('id','asc')
            ->where('Safe',$Safe)
            ->where('Date', $Date)
            ->where('Shift', $this->Code)
            ->get()->sum('Total_Debaitor');


        $DifRP= $ReciptTot - $PaymentTot ;
        $Amount = $DifRP +   $TotSales ;


        $Disc=$discoo;



        foreach($Sales as $sal){

            if($sal->Payment_Method == 'Cash'){

                $bill=$sal->Total_Net;
            }elseif($sal->Payment_Method == 'Later'){

                $bill=$sal->Pay;
            }elseif($sal->Payment_Method == 'Cash_Visa'){
                $bill=$sal->Total_Net;

            }elseif($sal->Payment_Method == 'Visa'){
                $bill=$sal->Total_Net;

            }elseif($sal->Payment_Method == 'Installment'){
                $bill=$sal->presenter;
            }


            $output .= '
      <tr class="Sales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$sal->Client()->first()->Name.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

        }

        foreach($ReturnSales as $sal){

            if($sal->Sales()->first()->Safe == $Safe){
                if($sal->Payment_Method == 'Cash'){

                    $RCashh +=$sal->Total_Return_Value;
                }elseif($sal->Payment_Method == 'Later'){


                    $RLaterr +=$sal->Pay;
                }

            }

        }

        $All=$TotSales + $RCashh + $RLaterr;

        foreach($ReturnSales as $sal){

            if($sal->Sales()->first()->Safe == $Safe){
                if($sal->Payment_Method == 'Cash'){

                    $bill=$sal->Total_Return_Value;
                    $RCash +=$sal->Total_Return_Value;
                }elseif($sal->Payment_Method == 'Later'){

                    $bill=$sal->Pay;
                    $RLater +=$sal->Pay;
                }


                if(app()->getLocale() == 'ar' ){
                    $txNamme=$sal->Sales()->first()->Client()->first()->Name;
                }else{

                    $txNamme=$sal->Sales()->first()->Client()->first()->NameEn;
                }
                $output .= '
      <tr class="RSales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

            }
        }

        $RTotSales=  $RCash + $RLater ;

        $DISCOUNT=$TotSales - $Disc;

        foreach($ReciptVoucher as $sal){
            $VVVVV=ReciptVoucherDetails::where('RV_ID',$sal->id)->first();
            if(app()->getLocale() == 'ar' ){
                $txNamme=$VVVVV->Account()->first()->Name;
            }else{

                $txNamme=$VVVVV->Account()->first()->NameEn;
            }
            $output .= '
      <tr class="Recipt">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$sal->Total_Creditor.'</td>

    </tr>
        ';

        }


        foreach($PaymentVoucher as $sal){

            $VVVVV=PaymentVoucherDetails::where('PV_ID',$sal->id)->first();

            if(app()->getLocale() == 'ar' ){
                $txNamme=$VVVVV->Account()->first()->Name;
            }else{

                $txNamme=$VVVVV->Account()->first()->NameEn;
            }
            $output .= '
      <tr class="Payment">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$sal->Total_Debaitor.'</td>

    </tr>
        ';

        }


        $AM=   $Amount - $Disc ;


        $data=[

            'Shift_Code'=>$this->Code
            ,'Sales'=>trans('admin.Sales')
            ,'Total_Sales'=>$All
            ,'Return_Sales'=>trans('admin.Return_Sales')
            ,'Total_return_Sales'=>$RTotSales
            ,'Discount_Allow'=>$Disc
            ,'Net_Sales'=>$DISCOUNT
            ,'Recipt_Vouchers'=>trans('admin.Recipt_Vouchers')
            ,'Total_Recipt_Vouchers'=>$ReciptTot
            ,'Payment_Vouchers'=>trans('admin.Payment_Vouchers')
            ,'Total_Payment_Vouchers'=>$PaymentTot
            ,'Safe_Value'=>$AM


        ];


        return $data ;







    }

}
