<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\Employess;
use App\Models\GeneralDaily;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class VendorDetailsStatementApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');


        if(!empty($this->Branch)) {
            if ($lang == 'en') {
                $Branch =$this->Branch()->first()->English_Name;
            } else {
                $Branch =$this->Branch()->first()->Arabic_Name;
            }
        }else{

            $Branch='';

        }



        if(!empty($this->Vendor)) {
            if ($lang == 'en') {
                $client =$this->Vendor()->first()->NameEn;
            } else {
                $client =$this->Vendor()->first()->Name;
            }
        }else{

            $client='';

        }


        if(!empty($this->Store)) {
            if ($lang == 'en') {
                $store =$this->Store()->first()->NameEn;
            } else {
                $store =$this->Store()->first()->Name;
            }
        }else{

            $store='';

        }


        if(!empty($this->Safe)) {
            if ($lang == 'en') {
                $safe =$this->Safe()->first()->NameEn;
            } else {
                $safe =$this->Safe()->first()->Name;
            }
        }else{

            $safe='';

        }




        $typeee=trans('admin.Purchase') . trans('admin.'.$this->Payment_Method) ;


        if(!empty($this->Coin)) {
            if ($lang == 'en') {
                $coin =$this->Coin()->first()->English_Name;
            } else {
                $coin =$this->Coin()->first()->Arabic_Name;
            }
        }else{

            $coin='';

        }

        if(!empty($this->Delegate)) {
            if ($lang == 'en') {
                $Delegate =$this->Delegate()->first()->NameEn;
            } else {
                $Delegate =$this->Delegate()->first()->Name;
            }
        }else{

            $Delegate='';

        }



        if(!empty($this->User)) {
            if ($lang == 'en') {
                $User =$this->User()->first()->nameEn;
            } else {
                $User =$this->User()->first()->name;
            }
        }else{

            $User='';

        }



        if(!empty($this->Ship)) {
            if ($lang == 'en') {
                $Ship =$this->Ship()->first()->NameEn;
            } else {
                $Ship =$this->Ship()->first()->Name;
            }
        }else{

            $Ship='';

        }



        if(!empty($this->Cost_Center)) {
            if ($lang == 'en') {
                $cost =$this->Cost_Center()->first()->English_Name;
            } else {
                $cost =$this->Cost_Center()->first()->Arabic_Name;
            }
        }else{

            $cost='';

        }




        $data=[

            'Date'=>$this->Date
            ,'Time'=>$this->Time
            ,'Code'=>$this->Code
            ,'Refernce_Number'=>$this->Refernce_Number
            ,'Branch'=>$Branch
            ,'Client'=>$client
            ,'Store'=>$store
            ,'Safe'=>$safe
            ,'Type'=>$typeee
            ,'Total_Price'=>$this->Total_Price
            ,'Total_Discount'=>$this->Total_Discount
            ,'Total_Tax'=>$this->Total_Taxes + $this->ProfitTax
            ,'Total_Net'=>$this->Total_Net
            ,'Pay'=>$this->Pay
            ,'Residual'=>(($this->Total_Price +  $this->Total_Taxes + $this->ProfitTax)  - $this->Total_Discount) - $this->Pay
            ,'Due_Date'=>$this->Later_Due
            ,'Coin'=>$coin
            ,'Shift_Code'=>$this->Shift_Code
            ,'Delegate'=>$Delegate
            ,'User'=>$User
            ,'Shipping_Compaines'=>$Ship
            ,'Cost_Center'=>$cost
            ,'Note'=>$this->Note



        ];




        return $data ;
    }

}
