<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\AcccountingManual;
use App\Models\Employess;
use App\Models\GeneralDaily;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class TrialBalanceFilterApiiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $from = $request->get('from');
        $to = $request->get('to');
        $type = $request->get('type');
        $zero = $request->get('zero');


        $DBBEFORE=0;
        $CRBEFORE=0;
        $DBTOTAL=0;
        $CRTOTAL=0;
        $DBBALANCE=0;
        $CRBALANCE=0;
        $SubDebBef=0;
        $SubCredBef=0;
        $SubTotalDeb=0;
        $SubTotalCred=0;


        if($type == 1){

            $apear=0;
            $DebBef =GeneralDaily::where('Account',$this->id)
                ->where('Date','<',$from)
                ->get()->sum('Debitor_Coin');


            $CredBef =GeneralDaily::where('Account',$this->id)
                ->where('Date','<',$from)
                ->get()->sum('Creditor_Coin');

            $TotalDeb =GeneralDaily::where('Account',$this->id)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Debitor_Coin');


            $TotalCred =GeneralDaily::where('Account',$this->id)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Creditor_Coin');


            $x=( $DebBef + $TotalDeb ) - ( $CredBef + $TotalCred ) ;


            if($x < 0){

                $y=0;
                $z=abs($x);
            }else{

                $y=$x;
                $z=0;

            }

            $DBBEFORE +=$DebBef;
            $CRBEFORE +=$CredBef;
            $DBTOTAL +=$TotalDeb;
            $CRTOTAL +=$TotalCred;
            $DBBALANCE +=$y;
            $CRBALANCE +=$z;

            if($zero == 1) {
                if($DebBef == 0  and $CredBef == 0 and $TotalDeb == 0  and $TotalCred == 0 and $y == 0  and $z == 0 ){
                    $apear=1;
                }
            }


            if($lang == 'ar' ){
                $xName=$this->Name;

            }else{
                $xName=$this->NameEn;

            }


            if($apear == 0){

            $data=[

                'Account_Code'=>$this->Code
                ,'Account_Name'=>$xName
                ,'Debiator_Before'=> number_format((float)$DebBef, 2, '.', '')
                ,'Creditor_Before'=>number_format((float)$CredBef, 2, '.', '')
                ,'Total_Debitor'=>number_format((float)$TotalDeb, 2, '.', '')
                ,'Total_Creditor'=>number_format((float)$TotalCred, 2, '.', '')
                ,'Credit_debitor'=>number_format((float)$y, 2, '.', '')
                ,'Credit_Creditor'=>number_format((float)$z, 2, '.', '')


            ];

                return $data ;

            }

        }else{


                $SubDebBef=0;
                $SubCredBef=0;
                $SubTotalDeb=0;
                $SubTotalCred=0;
                $suby=0;
                $subz=0;
                $count=AcccountingManual::where('Parent',$this->id)->where('Type',1)->count();

                if($count != 0){

                    $ASubs=AcccountingManual::where('Parent',$this->id)->where('Type',1)->get();


                    foreach($ASubs as $a){

                        $SubDebBef +=GeneralDaily::where('Account',$a->id)
                            ->where('Date','<',$from)
                            ->get()->sum('Debitor_Coin');


                        $SubCredBef +=GeneralDaily::where('Account',$a->id)
                            ->where('Date','<',$from)
                            ->get()->sum('Creditor_Coin');

                        $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                            ->whereBetween('Date', [$from, $to])
                            ->get()->sum('Debitor_Coin');


                        $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                            ->whereBetween('Date', [$from, $to])
                            ->get()->sum('Creditor_Coin');

                    }

                    $x=( $SubDebBef + $SubTotalDeb ) - ( $SubCredBef + $SubTotalCred ) ;


                    if($x < 0){

                        $suby =0;
                        $subz =abs($x);
                    }else{

                        $suby =$x;
                        $subz =0;

                    }

                    if($lang == 'ar' ){
                        $xName=$this->Name;

                    }else{
                        $xName=$this->NameEn;

                    }

                    $DBBEFORE +=$SubDebBef;
                    $CRBEFORE +=$SubCredBef;
                    $DBTOTAL +=$SubTotalDeb;
                    $CRTOTAL +=$SubTotalCred;
                    $DBBALANCE +=$suby;
                    $CRBALANCE +=$subz;



                    $data=[

                        'Account_Code'=>$this->Code
                        ,'Account_Name'=>$xName
                        ,'Debiator_Before'=> number_format((float)$SubDebBef, 2, '.', '')
                        ,'Creditor_Before'=>number_format((float)$SubCredBef, 2, '.', '')
                        ,'Total_Debitor'=>number_format((float)$SubTotalDeb, 2, '.', '')
                        ,'Total_Creditor'=>number_format((float)$SubTotalCred, 2, '.', '')
                        ,'Credit_debitor'=>number_format((float)$suby, 2, '.', '')
                        ,'Credit_Creditor'=>number_format((float)$subz, 2, '.', '')


                    ];
                    return $data ;


                }




        }





    }

}
