<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\Employess;
use App\Models\PaymentVoucherDetails;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class ExpensesListFilterApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $safe=$request->get('safe');
        $account=$request->get('account');
        $subAccount=$request->get('subAccount');


        $subAccount=$this->id;


        $Tot=PaymentVoucherDetails::whereBetween('Date',[$from,$to])


            ->when(!empty($subAccount), function ($query) use ($subAccount) {
                return $query->where('Account', $subAccount);
            })
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })
            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })
            ->get()->sum('Debitor');




        $data=[

            'Name'=>$this->Name
            ,'Total'=>$Tot
            ,'details'=>$this->when(!empty($this->id), function () {

                $from=request('from');
                $to=request('to');
                $branch=request('branch');
                $safe=request('safe');
                $account=request('account');
                $subAccount=request('subAccount');

                $lists=PaymentVoucherDetails::whereBetween('Date',[$from,$to])


                    ->when(!empty($subAccount), function ($query) use ($subAccount) {
                        return $query->where('Account', $subAccount);
                    })
                    ->when(!empty($branch), function ($query) use ($branch) {
                        return $query->where('Branch', $branch);
                    })
                    ->when(!empty($safe), function ($query) use ($safe) {
                        return $query->whereIn('Safe', $safe);
                    })
                    ->get();


                $dataa=ExpensesDetailsApiResources::collection($lists);


                return $dataa;
    }),

        ];




        return $data ;
    }

}
