<?php

namespace App\Http\Resources;


use App\Models\ProductSalesOrder;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProductsApiResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if($lang == 'ar'){

            $GROUP=$this ->Group()->first()->Name;

            if(!empty($this ->Brand()->first()->Name)){
                $BRAND=$this ->Brand()->first()->Name;
            }else{
                $BRAND='';
            }


        }else{

            $GROUP=$this ->Group()->first()->NameEn;
            if(!empty($this ->Brand()->first()->NameEn)){
                $BRAND=$this ->Brand()->first()->NameEn;
            }else{
                $BRAND='';
            }


        }



        $data = [

            'id'=>$this ->id,
            'P_Type'=>$this ->P_Type,
            'P_Ar_Name'=>$this ->P_Ar_Name,
            'P_En_Name'=>$this ->P_En_Name,
            'Brand'=>$GROUP,
            'Group'=>$BRAND,
            'Image'=>asset($this ->Image),
            'Minimum'=>$this ->Minimum,
            'Maximum'=>$this ->Maximum,
            'Length'=>$this ->Length,
            'Width'=>$this ->Width,
            'Height'=>$this ->Height,
            'Weight'=>$this ->Weight,
            'Saller_Point'=>$this ->Saller_Point,
            'Customer_Point'=>$this ->Customer_Point,
            'Validity'=>$this ->Validity,
            'Ar_Desc'=>strip_tags($this ->Ar_Desc),
            'En_Desc'=>strip_tags($this ->En_Desc),
            'Ar_Spec'=>strip_tags($this ->Ar_Spec),
            'En_Spec'=>strip_tags($this ->En_Spec),
            'World_Code'=>$this ->World_Code,
            'Cost_Price'=>$this ->Cost_Price,
            'Units'=>$this->when(!empty($this->id), function () {

                $CustomersAddresses=ProductUnitsResources::collection(ProductUnits::where('Product',$this->id)->get());

                return $CustomersAddresses;
            }),

        ];


        return $data ;
    }

}
