<?php

namespace App\Http\Resources;


use App\Models\GeneralDaily;
use App\Models\ReciptVoucherDetails;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class DelegateCollectionResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');
        $DBBEFORE=0;
        $CRBEFORE=0;
        $DBTOTAL=0;
        $CRTOTAL=0;
        $DBBALANCE=0;
        $CRBALANCE=0;
        $DebBef =0;
        $CredBef =0;

        $TotalDeb =GeneralDaily::where('Account',$this->Account)
            ->get()->sum('Debitor_Coin');


        $TotalCred =GeneralDaily::where('Account',$this->Account)
            ->get()->sum('Creditor_Coin');

        $lq=GeneralDaily::where('Account',$this->Account)
            ->latest('id')->first();

        $lb =Sales::where('Client',$this->Account)
            ->latest('id')->first();

        if(!empty($lq)){
            $LastQeed=$lq->Date;
        }else{
            $LastQeed=0;
        }
        if(!empty($lb)){
            $LastBill=$lb->Date;
        }else{
            $LastBill=0;
        }

        $account=$this->Account;
        $Delegate=$this->Responsible;
        $last =ReciptVoucherDetails::whereRelation('RV_ID', function ($query) use ($Delegate) {

            return $query->where('Collector',$Delegate);
        })


            ->when(!empty($account), function ($query) use ($account)  {
                return $query->where('Account',$account);

            })

            ->latest('id')->first();

        if(!empty($last)){
            $LastRecipt=$last->RV_ID()->first()->Date;
        }else{
            $LastRecipt=0;
        }


        $x= $TotalDeb  - $TotalCred  ;


        if($x < 0){

            $y=0;
            $z=abs($x);
        }else{

            $y=$x;
            $z=0;

        }

        $DBBEFORE +=$DebBef;
        $CRBEFORE +=$CredBef;
        $DBTOTAL +=$TotalDeb;
        $CRTOTAL +=$TotalCred;
        $DBBALANCE +=$y;
        $CRBALANCE +=$z;

if($lang == 'ar'){
    $name=$this->Account()->first()->Name;
}else{
    $name=$this->Account()->first()->NameEn;
}

            $data = [


                'customer_name'=>$name,
                'debitor_balance'=>$y,
                'creditor_balance'=>$z,
                'last_joun'=>$LastQeed,
                'last_bill'=>$LastBill,
                'last_recipt_voucher'=>$LastRecipt,



            ];




        return $data ;
    }

}
