<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class DefaultCompanyResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if($lang ==  'ar') {
            $data = [


                'company_name' => $this->Name,
                'phone_1' => $this->Phone1,
                'phone_2' => $this->Phone2,
                'phone_3' => $this->Phone3,
                'phone_4' => $this->Phone4,
                'address' => $this->Address,
                'seal' => asset($this->Seal),
                'logo' => asset($this->Logo_Store),
                'icon' => asset($this->Icon_Store),
                'email' => $this->Email,
                'pdf'=>asset($this->PDF),
                'welcome_word' => $this->Welcome_Arabic_Word_App,
                'name_sales_bill' => $this->Name_Sales_Bill,
                'name_sales_order_bill' => $this->Name_Sales_Order_Bill,
                'name_quote_bill' => $this->Name_Quote_Bill,
                'print_top_text' => $this->Print_Text,
                'print_footer_text' => $this->Print_Text_Footer,
                'print_footer_text_sales' => $this->Print_Text_Footer_Sales,
                'print_footer_text_quote' => $this->Print_Text_Footer_Quote,
                'Attend_Lat' => $this->Attend_Lat,
                'Attend_Lng' => $this->Attend_Lng,
                'Attend_Space' => $this->Attend_Space,
                'Attend_Time_Before' => $this->Attend_Time_Before,
                'Attend_Time_After' => $this->Attend_Time_After,
                'Departure_Time_Before' => $this->Departure_Time_Before,
                'Departure_Time_After' => $this->Departure_Time_After,
                'Backup_Time' => $this->Backup_Time,
                'Verfification_Time' => $this->Verfification_Time


            ];
        }else{


            $data = [


                'company_name'=>$this->NameEn,
                'phone_1'=>$this->Phone1,
                'phone_2'=>$this->Phone2,
                'phone_3'=>$this->Phone3,
                'phone_4'=>$this->Phone4,
                'address'=>$this->AddressEn,
                'seal'=>asset($this->Seal),
                'logo'=>asset($this->Logo_Store),
                'icon'=>asset($this->Icon_Store),
                'email'=>$this->Email,
                'welcome_word'=>$this->Welcome_English_Word_App,
                'name_sales_bill'=>$this->Name_Sales_Bill_En,
                'name_sales_order_bill'=>$this->Name_Sales_Order_Bill_En,
                'name_quote_bill'=>$this->Name_Quote_Bill_En,
                'print_top_text'=>$this->Print_Text_En,
                'print_footer_text'=>$this->Print_Text_Footer_En,
                'print_footer_text_sales'=>$this->Print_Text_Footer_Sales_En,
                'print_footer_text_quote'=>$this->Print_Text_Footer_Quote_En,
                      'Attend_Lat' => $this->Attend_Lat,
                'Attend_Lng' => $this->Attend_Lng,
                   'Attend_Space' => $this->Attend_Space,
                'Attend_Time_Before' => $this->Attend_Time_Before,
                'Attend_Time_After' => $this->Attend_Time_After,
                'Departure_Time_Before' => $this->Departure_Time_Before,
                'Departure_Time_After' => $this->Departure_Time_After,
                   'Backup_Time' => $this->Backup_Time,
                'Verfification_Time' => $this->Verfification_Time



            ];
        }



        return $data ;
    }

}
