<?php

namespace App\Http\Resources;


use App\Models\Addressses;
use App\Models\CommentsClients;
use App\Models\Sales;
use App\Models\CustomersTickets;
use App\Models\ClientRequests;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class CustomersResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');



            if(!empty($this->Activity)){
                if($lang == 'ar'){
                    $activity = $this->Activity()->first()->Arabic_Name ;
                }else{

                    $activity = $this->Activity()->first()->English_Name ;
                }
            }else{

                $activity = '';
            }

            if(!empty($this->Governrate)){
                if($lang == 'ar'){
                    $governrate = $this->Governrate()->first()->Arabic_Name ;
                }else{

                    $governrate = $this->Governrate()->first()->English_Name ;
                }
            }else{

                $governrate = '';
            }

            if(!empty($this->City)){
                if($lang == 'ar'){
                    $city = $this->City()->first()->Arabic_Name ;
                }else{
                    $city = $this->City()->first()->English_Name ;
                }
            }else{

                $city = '';
            }
            if(!empty($this->Place)){
                if($lang == 'ar'){
                    $city = $this->Place()->first()->Arabic_Name ;
                }else{
                    $city = $this->Place()->first()->English_Name ;
                }
            }else{

                $city = '';
            }

            if(!empty($this->ClientStatus)){

                if($lang == 'ar'){
                    $status = $this->ClientStatus()->first()->Arabic_Name ;
                }else{
                    $status = $this->ClientStatus()->first()->English_Name ;
                }
            }else{

                $status = '';
            }

            if(!empty($this->Platform)){
                if($lang == 'ar'){
                    $platform = $this->Platform()->first()->Arabic_Name ;
                }else{

                    $platform = $this->Platform()->first()->English_Name ;
                }
            }else{

                $platform = '';
            }
        
            if(!empty($this->Product()->first()->P_Ar_Name)){
                if($lang == 'ar'){
                    $Product = $this->Product()->first()->P_Ar_Name ;
                }else{

                    $Product = $this->Product()->first()->P_En_Name ;
                }
            }else{

                $Product = '';
            }
        
        
        
        
            if(!empty($this->Group()->first()->Arabic_Name)){
                if($lang == 'ar'){
                    $group = $this->Group()->first()->Arabic_Name ;
                }else{

                    $group = $this->Group()->first()->English_Name ;
                }
            }else{

                $group = '';
            }

            if(!empty($this->Campagin)){
                if($lang == 'ar'){
                    $campaign = $this->Campagin()->first()->Arabic_Name ;
                }else{
                    $campaign = $this->Campagin()->first()->English_Name ;

                }
            }else{

                $campaign = '';
            }

            if(!empty($this->Responsible)){
                if($lang == 'ar'){
                    $responsible = $this->Responsible()->first()->Name ;
                }else{

                    $responsible = $this->Responsible()->first()->NameEn ;
                }
            }else{

                $responsible = '';
            }

            if(!empty($this->Guarantor)){
                if($lang == 'ar'){
                    $Guarantor = $this->Guarantor()->first()->Name ;
                }else{

                    $Guarantor = $this->Guarantor()->first()->NameEn ;
                }
            }else{

                $Guarantor = '';
            }

        
        
        
            if($this->Executions_Status == 'potential_client'){
                $ex=  trans('admin.potential_client');
            }elseif($this->Executions_Status == 'new_client'){
                $ex=  trans('admin.new_client');
            }elseif($this->Executions_Status == 'pending'){
                $ex=  trans('admin.pending');
            }elseif($this->Executions_Status == 'former'){
                $ex=  trans('admin.former');
            }elseif($this->Executions_Status == 'important'){
                $ex=  trans('admin.important');
            }else{
                $ex='';

            }

        
            if($this->SecurityInquiry == 0){
                $SecurityInquiry=  trans('admin.Pending');
            }elseif($this->SecurityInquiry == 1){
                $SecurityInquiry=  trans('admin.Accept');
            }elseif($this->SecurityInquiry == 2){
                $SecurityInquiry=  trans('admin.Refused');
           
            }else{
                $SecurityInquiry='';

            }
  
            if($this->FieldInquiry == 0){
                $FieldInquiry=  trans('admin.Pending');
            }elseif($this->FieldInquiry == 1){
                $FieldInquiry=  trans('admin.Accept');
            }elseif($this->FieldInquiry == 2){
                $FieldInquiry=  trans('admin.Refused');
           
            }else{
                $FieldInquiry='';

            }



            if($lang == 'ar'){
                $Nemo=$this->Name;
            }else{
                $Nemo=$this->NameEn;

            }
        
        
        $CommentsCount=CommentsClients::where('Customer', $this->id)->count();
        $SalesBillCount=Sales::where('Client', $this->Account)->count();
        $SalesBillTotal=Sales::where('Client', $this->Account)->get()->sum('Total_Net');
        $TicketsCount=CustomersTickets::where('Customer', $this->id)->count();
        $TicketsSolvedCount=CustomersTickets::where('Customer', $this->id)->where('Status',2)->count();
        $TicketsPendingCount=CustomersTickets::where('Customer', $this->id)->where('Status',1)->count();
        
              
 

        $data = [

                'client_id'=>$this->id,
                'name'=>$Nemo,
                'name_ar'=>$this->Name,
                'name_en'=>$this->NameEn,
                'code'=>$this->Code,
                'email'=>$this->Email,
                'phone1'=>$this->Phone,
                'phone2'=>$this->Phone2,
                'phone3'=>$this->Phone3,
                'phone4'=>$this->Phone4,
                'price_level'=>$this->Price_Level,
                'address'=>$this->Address,
                'search_code'=>$this->SearchCode,
                'respon_person'=>$this->Respon_Person,
                'respon_person_phone'=>$this->Respon_Person_Phone,
                'operating_date'=>$this->Operating_Date,
                'activation_serial'=>$this->Activation_Serial,
                'activation_code'=>$this->Activation_Code,
                'account_code'=>$this->Account()->first()->Code,
                'account_id'=>$this->Account,
                'group'=>$group,
                'date'=>$this->Date,
                'activity'=>$activity,
                'activity_id'=>$this->Activity,
                'platform'=>$platform,
                'platform_id'=>$this->Platform,
                'campaign'=>$campaign,
                'campaign_id'=>$this->Campaign,
                'responsible'=>$responsible,
                'responsible_id'=>$this->Responsible,
                'Commercial_Registration_No'=>$this->Commercial_Registration_No,
                'Tax_Registration_Number'=>$this->Tax_Registration_Number,
                'Warranty'=>$this->Warranty,
                'Operating_Date'=>$this->Operating_Date,
                'Activation_Serial'=>$this->Activation_Serial,
                'Activation_Code'=>$this->Activation_Code,
                'Guarantor'=>$this->Guarantor,
                'Guarantor_Name'=>$Guarantor,
                'Product_ID'=>$this->Product,
                'Product_Name'=>$Product,
                'client_status'=>$status,
            
                'SecurityInquiry'=>$SecurityInquiry,
                'ReasonSecurityInquiry'=>$this->ReasonSecurityInquiry,
                'FieldInquiry'=>$FieldInquiry,
                'ResonFieldInquiry'=>$this->ResonFieldInquiry,
            
                'executions_status'=>$ex,
                'Comments_Count'=>$CommentsCount,
                'Sales_Bill_Count'=>$SalesBillCount,
                'Sales_Bill_Total'=>$SalesBillTotal,
                'Tickets_Count'=>$TicketsCount,
                'Tickets_Solved_Count'=>$TicketsSolvedCount,
                'Tickets_Pending_Count'=>$TicketsPendingCount,
                'addresses'=>$this->when(!empty($this->id), function () {

                    $CustomersAddresses=CustomersAddressesResources::collection(Addressses::where('Customer',$this->id)->get());

                    return $CustomersAddresses;
                }),
                'comments'=>$this->when(!empty($this->id), function () {

                $comments=CommentsClientResources::collection(CommentsClients::where('Customer',$this->id)->get());
                return $comments;
            }),

            'tickets'=>$this->when(!empty($this->id), function () {

                $tickets=TicketsClientResources::collection(CustomersTickets::where('Customer',$this->id)->where('Status','!=',2)->get());
                return $tickets;
            }),

            'requests'=>$this->when(!empty($this->id), function () {

                $tickets=ClientRequestsResources::collection(ClientRequests::where('Client',$this->Account)->get());
                return $tickets;
            }),


            

            
            ];




        return $data ;
    }

}
