<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class CrmDefaultResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');


        if($lang ==  'ar') {
            $data = [


                'price_level'=>$this->Price_Level,
                'governrate_id'=>$this->Governrate,
                'governrate'=>$this->Governrate()->first()->Arabic_Name,
                'city_id'=>$this->City,
                'city'=>$this->City()->first()->Arabic_Name,
                'responsible_id'=>$this->Responsible,
                'responsible'=>$this->Responsible()->first()->Name,
                'activity_id'=>$this->Activity,
                'activity'=>$this->Activity()->first()->Arabic_Name,
                'campagin_id'=>$this->Campagin,
                'campagin'=>$this->Campagin()->first()->Arabic_Name,
                'client_status_id'=>$this->ClientStatus,
                'client_status'=>$this->ClientStatus()->first()->Arabic_Name,
                'platforms_id'=>$this->Platforms,
                'platforms'=>$this->Platforms()->first()->Arabic_Name,
                'client_delegate_show'=>$this->Client_Delegate,
                'nationality_id'=>$this->Nationality,
                'nationality'=>$this->Nationality()->first()->Arabic_Name,
                'client_group_id'=>$this->ClientGroup,
                'client_group'=>$this->ClientGroup()->first()->Arabic_Name


            ];
        }else{


            $data = [


                'price_level'=>$this->Price_Level,
                'governrate_id'=>$this->Governrate,
                'governrate'=>$this->Governrate()->first()->English_Name,
                'city_id'=>$this->City,
                'city'=>$this->City()->first()->English_Name,
                'responsible_id'=>$this->Responsible,
                'responsible'=>$this->Responsible()->first()->NameEn,
                'activity_id'=>$this->Activity,
                'activity'=>$this->Activity()->first()->English_Name,
                'campagin_id'=>$this->Campagin,
                'campagin'=>$this->Campagin()->first()->English_Name,
                'client_status_id'=>$this->ClientStatus,
                'client_status'=>$this->ClientStatus()->first()->English_Name,
                'platforms_id'=>$this->Platforms,
                'platforms'=>$this->Platforms()->first()->English_Name,
                'client_delegate_show'=>$this->Client_Delegate,
                'nationality_id'=>$this->Nationality,
                'nationality'=>$this->Nationality()->first()->English_Name,
                'client_group_id'=>$this->ClientGroup,
                'client_group'=>$this->ClientGroup()->first()->English_Name


            ];
        }



        return $data ;
    }

}
