<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use App\Models\CustomerCommentsProducts;

class CommentsClientResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');



        if($lang == 'ar'){
            $comment=$this->Comment;
            
            if(!empty($this->Responsible()->first()->Name)){
                
                    $ResName=$this->Responsible()->first()->Name;
            }else{
                
                $ResName='';
                
            }
        

            if(!empty($this->Type()->first()->Arabic_Name)){
                $interview=$this->Type()->first()->Arabic_Name;
            }else{
                $interview='';
            }



            if(!empty($this->Rate()->first()->Arabic_Name)){
                $Rate=$this->Rate()->first()->Arabic_Name;
            }else{
                $Rate='';
            }

        }else{
            $comment=$this->CommentEn;
            $ResName=$this->Responsible()->first()->NameEn;

            if(!empty($this->Type()->first()->English_Name)){
                $interview=$this->Type()->first()->English_Name;
            }else{
                $interview='';
            }


            if(!empty($this->Rate()->first()->English_Name)){
                $Rate=$this->Rate()->first()->English_Name;
            }else{
                $Rate='';
            }



        }


        

        if ($lang == 'ar') {
            $data = [

                'id'=>$this->id,
                'code'=>$this->Code,
                'date'=>$this->Date,
                'rate'=>$Rate,
                'visit_cost'=>$this->Visit_Cost,
                'note'=>$this->Note,
                'time'=>$this->Time,
                'lat'=>$this->lat,
                'lng'=>$this->lng,
                'interview_type'=>$interview,
                'comment'=>$comment,
                'responsible'=>$ResName,
                        'voice'=>asset($this->Voice),
                    'products'=>$this->when(!empty($this->id), function () {

                $Products=CustomerCommentsProductsResources::collection(CustomerCommentsProducts::where('Comment',$this->id)->get());
                return $Products;
            }),


            ];

        }else{

            $data = [

                'id'=>$this->id,
                'code'=>$this->Code,
                'date'=>$this->Date,
                'rate'=>$Rate,
                'visit_cost'=>$this->Visit_Cost,
                'note'=>$this->Note,
                'time'=>$this->Time,
                       'lat'=>$this->lat,
                'lng'=>$this->lng,
                'interview_type'=>$interview,
                'comment'=>$comment,
                'responsible'=>$ResName,
                    'voice'=>asset($this->Voice),
                                'products'=>$this->when(!empty($this->id), function () {

                $Products=CustomerCommentsProductsResources::collection(CustomerCommentsProducts::where('Comment',$this->id)->get());
                return $Products;
            }),

            ];

        }
        return $data ;
    }

}
