<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoresTransferRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'From_Store'=>'required',
            'To_Store'=>'required',
            'Coin'=>'required',

        ];
    }


    public function messages()
    {
        return [
            'From_Store.required' => trans('admin.StoreRequired'),
            'To_Store.required' => trans('admin.StoreRequired'),
            'Coin.required' => trans('admin.CoinRequired'),

        ];
    }


}
