<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ManfacturingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'Date'=>'required',
            'Coin'=>'required',
            'Draw'=>'required',
            'Name'=>'required',

        ];
    }


    public function messages()
    {
        return [
            'Name.required' => trans('admin.NameRequired'),
            'Date.required' => trans('admin.DateRequired'),
            'Coin.required' => trans('admin.CoinRequired'),
            'Draw.required' => trans('admin.TDrawRequired'),


        ];
    }


}
