<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\CompanyData;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\Shipping\CarShipping;
use App\Models\Governrate;
use App\Models\CostCenter;
use App\Models\ShippingDefault;
use App\Models\AcccountingManual;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use File;
use DB;
use Str;
use App\Http\Requests\ArEnRequest;
use App\Http\Requests\ArRequest;

use App\Models\Shipping\ShippmentProducts;
use App\Models\Shipping\NewShippingTypes;
use App\Models\Shipping\NewShippingCategories;
use App\Models\Shipping\NewShippingRqstTypes;
use App\Models\Shipping\Shipment;
use App\Models\Shipping\ShipmentMoves;
use App\Models\Shipping\ShippingPrices;
use App\Models\Shipping\ShipmentsDistribution;
use App\Models\Shipping\ShipmentsDistributionGoods;
use App\Models\Shipping\ShipmentsDistributionWorkers;
use App\Models\Shipping\UnloadingShipments;
use App\Models\Shipping\UnloadingShipmentsGoods;
use App\Models\Shipping\UnloadingShipmentsWorkers;
use App\Models\Shipping\RecivedShipmentGoods;
use App\Models\Shipping\RecivedShipment;
use App\Models\Shipping\ShipmentRequest;
use App\Models\SecretariatStores;
use App\Models\SecretariatQty;
use App\Models\ProductUnits;
use App\Models\Measuerments;
use App\Models\TransportContractors;
use App\Models\TransportPrices;
use App\Models\TransportReceiver;
use App\Models\Transport;
use App\Models\RqstTransport;
use App\Models\EmpRatio;
use App\Models\GeneralDaily;
use App\Models\Journalizing;

use App\Models\Places;

use Illuminate\Support\Facades\Log;

use App\Traits\GeneralTrait;


use App\Services\ShippingService;



class ShippingController extends Controller
{

    use GeneralTrait;
    function __construct()
    {



        $this->middleware('permission:طلب شحنة', ['only' => ['ShipmentRequest']]);
        $this->middleware('permission:جدول طلبات الشحنات', ['only' => ['ShipmentRequestSechdule']]);
        $this->middleware('permission:الشحنة', ['only' => ['Shipment']]);
        $this->middleware('permission:جدول الشحنات', ['only' => ['ShipmentSechdule']]);
        $this->middleware('permission:توزيع الشحنات', ['only' => ['ShipmentsDistribution']]);
        $this->middleware('permission:جدول توزيع الشحنات', ['only' => ['ShipmentsDistributionSechdule']]);
        $this->middleware('permission:تفريغ الشحنات', ['only' => ['UnloadingShipments']]);
        $this->middleware('permission:جدول تفريغ الشحنات', ['only' => ['UnloadingShipmentsSechdule']]);
        $this->middleware('permission:تسليمات الشحنات', ['only' => ['RecivedShipments']]);
        $this->middleware('permission:جدول تسليمات الشحنات', ['only' => ['RecivedShipmentsSechdule']]);
        $this->middleware('permission:انواع الشحنات', ['only' => ['NewShippingTypes']]);
        $this->middleware('permission:تصنيفات الشحنات', ['only' => ['NewShippingCategories']]);
        $this->middleware('permission:انواع طلبات الشحنات', ['only' => ['NewShippingRqstTypes']]);
        $this->middleware('permission:اسعار الشحنات', ['only' => ['ShippingPricesSechdule']]);
        $this->middleware('permission:سيارات الشحنات', ['only' => ['CarShipping']]);
        $this->middleware('permission:حركات الشحنات', ['only' => ['ShipmentMoves']]);
        $this->middleware('permission:مقاولين النقل', ['only' => ['TransportContractors']]);
        $this->middleware('permission:اسعار النقل', ['only' => ['TransportPrices']]);
        $this->middleware('permission:مستلمين النقل', ['only' => ['TransportReceiver']]);
        $this->middleware('permission:طلب نقل', ['only' => ['RqstTransport']]);
        $this->middleware('permission:جدول طلبات النقل', ['only' => ['RqstTransportSechdule']]);
        $this->middleware('permission:النقل', ['only' => ['Transport']]);
        $this->middleware('permission:جدول النقل', ['only' => ['TransportSechdule']]);



    }



    //====== Shipping Types =======
    public function NewShippingTypes(){
        $items=NewShippingTypes::all();
        return view('admin.Shipping.NewShippingTypes',['items'=>$items]);
    }

    public function AddNewShippingTypes(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Code']=request('Code');
            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            NewShippingTypes::create($data);

            $dataUser=[
                'screen_ar'=>'انواع الشحنات',
                'screen_en'=>'Shipping Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditNewShippingTypes($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Code']=request('Code');
            NewShippingTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع الشحنات',
                'screen_en'=>'Shipping Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteNewShippingTypes($id){

        try {
            DB::beginTransaction();

            $del=NewShippingTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع الشحنات',
                'screen_en'=>'Shipping Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //====== Shipping Categories =======
    public function NewShippingCategories(){
        $items=NewShippingCategories::all();
        return view('admin.Shipping.NewShippingCategories',['items'=>$items]);
    }

    public function AddNewShippingCategories(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Code']=request('Code');
            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            NewShippingCategories::create($data);

            $dataUser=[
                'screen_ar'=>'تصنيفات الشحنات',
                'screen_en'=>'Shipping Categories',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditNewShippingCategories($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Code']=request('Code');
            NewShippingCategories::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'تصنيفات الشحنات',
                'screen_en'=>'Shipping Categories',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteNewShippingCategories($id){

        try {
            DB::beginTransaction();

            $del=NewShippingCategories::find($id);

            $dataUser=[
                'screen_ar'=>'تصنيفات الشحنات',
                'screen_en'=>'Shipping Categories',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingCategories::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //====== Shipping Rqsts Types =======
    public function NewShippingRqstTypes(){
        $items=NewShippingRqstTypes::all();
        return view('admin.Shipping.NewShippingRqstTypes',['items'=>$items]);
    }

    public function AddNewShippingRqstTypes(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            NewShippingRqstTypes::create($data);

            $dataUser=[
                'screen_ar'=>'انواع طلبات الشحنات',
                'screen_en'=>'Shipping Requests Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditNewShippingRqstTypes($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            NewShippingRqstTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع طلبات الشحنات',
                'screen_en'=>'Shipping Requests Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteNewShippingRqstTypes($id){

        try {
            DB::beginTransaction();

            $del=NewShippingRqstTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع طلبات الشحنات',
                'screen_en'=>'Shipping Requests Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=NewShippingRqstTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    
    //====== Car Shipping =======
    public function CarShipping(){
        $items=CarShipping::all();
        return view('admin.Shipping.CarShipping',['items'=>$items]);
    }

    public function AddCarShipping(Request $request){

        try {
            DB::beginTransaction();

           
            
            
            //2532 da 7sab el r2esy bta3 msaref syrat f DB elly fadya enma f Default 2790
          $Acc=$this->CreateAccount(request('Name'),request('Name') ,2532,null);
          $AccMerit=$this->CreateAccount('استحقاق '.request('Name'),'Accrual'.request('Name') ,2533,null);
     
            $data['Name']=request('Name');
            $data['Max_Load']=request('Max_Load');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Car_Number']=request('Car_Number');
            $data['Color']=request('Color');
            $data['Lisence_Expire_Date']=request('Lisence_Expire_Date');
            $data['GPS_Num']=request('GPS_Num');
            $data['Car_Type']=request('Car_Type');
            $data['Car_Statue']=request('Car_Statue');
            $data['Insurance']=request('Insurance');
            $data['Ownership']=request('Ownership');
            $data['Cost_Center']=request('Cost_Center');
            $data['Rent_Amount']=request('Rent_Amount');
            $data['Deal_Type']=request('Deal_Type');
            $data['Deal_Amount']=request('Deal_Amount');
            $data['Minimum']=request('Minimum');
            $data['Account']=$Acc;
            $data['AccountMerit']=$AccMerit;
         
            CarShipping::create($data);

            $dataUser=[
                'screen_ar'=>'سيارات الشحن',
                'screen_en'=>'Car Shipping',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('Name'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditCarShipping($id,Request $request){

        try {
            DB::beginTransaction();

            
            
            $CAR=CarShipping::find($id);
            $dataX['Name']=request('Name');
            $dataX['NameEn']=request('Name');
            AcccountingManual::where('id',$CAR->Account)->update($dataX);
            $dataXM['Name']='استحقاق'.request('Name');
            $dataXM['NameEn']='Accrual'.request('Name');
            AcccountingManual::where('id',$CAR->AccountMerit)->update($dataX);
            
            
        
               $data['Name']=request('Name');
            $data['Max_Load']=request('Max_Load');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Car_Number']=request('Car_Number');
            $data['Color']=request('Color');
            $data['Lisence_Expire_Date']=request('Lisence_Expire_Date');
            $data['GPS_Num']=request('GPS_Num');
            $data['Car_Type']=request('Car_Type');
            $data['Car_Statue']=request('Car_Statue');
            $data['Insurance']=request('Insurance');
            $data['Ownership']=request('Ownership');
                    $data['Cost_Center']=request('Cost_Center');
            $data['Rent_Amount']=request('Rent_Amount');
            $data['Deal_Type']=request('Deal_Type');
            $data['Deal_Amount']=request('Deal_Amount');
            $data['Minimum']=request('Minimum');
            CarShipping::where('id',$id)->update($data);

            $dataUser=[
                 'screen_ar'=>'سيارات الشحن',
                'screen_en'=>'Car Shipping',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCarShipping($id){

        try {
            DB::beginTransaction();

            $del=CarShipping::find($id);

            AcccountingManual::where('id',$del->Account)->delete();
            AcccountingManual::where('id',$del->AccountMerit)->delete();
            
            $dataUser=[
                 'screen_ar'=>'سيارات الشحن',
                'screen_en'=>'Car Shipping',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CarShipping::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

  

    //============  ShippingPrices ================

    public function ShippingPricesSechdule(){
        $items=ShippingPrices::paginate(20);
        return view('admin.Shipping.ShippingPricesSechdule',get_defined_vars());
    }

    public function FilterShippingPrices(){
        
        $city=request('City');
        $place=request('Place');
        
        
        $items=ShippingPrices::
        
        
               when(!empty($city), function ($query) use ($city) {
        return $query->where('City', $city);
    })
             
               ->when(!empty($place), function ($query) use ($place) {
        return $query->where('Place', $place);
    })
        
        
        ->paginate(20);
        
        
  

  $items->appends(request()->query());
        return view('admin.Shipping.ShippingPricesSechdule',get_defined_vars());
    }

    public function ShippingPrices(){
        $Cities=City::all();
        return view('admin.Shipping.ShippingPrices',get_defined_vars());
    }
    public function AddShippingPrices(Request $request){

        try {
            DB::beginTransaction();


            $City=request('City');
            $Place=request('Place');
            $From=request('From');
            $To=request('To');
            $Price=request('Price');

            if(!empty($City)){


                for($i=0;$i<count($City);$i++){

                    $data['From']=$From[$i];
                    $data['To']=$To[$i];
                    $data['Price']=$Price[$i];
                    $data['Place']=$Place[$i];
                    $data['City']=$City[$i];

                    ShippingPrices::create($data);

                }




            }



                $dataUser=[
                'screen_ar'=>'اسعار الشحنات',
                'screen_en'=>'Shipping Prices',
                'explain_ar'=>'',
                'explain_en'=>'',
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }
    public function EditShippingPrices($id){

        try {
            DB::beginTransaction();


            $From=request('From');
            $To=request('To');
            $Price=request('Price');


            $data['From']=$From;
            $data['To']=$To;
            $data['Price']=$Price;

            ShippingPrices::where('id',$id)->update($data);

            
            
            
            
                 $dataUser=[
                'screen_ar'=>'اسعار الشحنات',
                'screen_en'=>'Shipping Prices',
                'explain_ar'=>'',
                'explain_en'=>'',
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }
    public function DeleteShippingPrices($id){

        try {
            DB::beginTransaction();

            $del=ShippingPrices::find($id);
            
            
            
            
                 $dataUser=[
                'screen_ar'=>'اسعار الشحنات',
                'screen_en'=>'Shipping Prices',
                'explain_ar'=>$del->id,
                'explain_en'=>$del->id,
            ];
            $this->UserDeleteMoves($dataUser);

            
            
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShippingPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


//==================  Shipment  ===================


    public function ShipmentSechdule(){

        $Types=NewShippingTypes::all();
        $Categories=NewShippingCategories::all();
        $RqstTypes=NewShippingRqstTypes::all();

        
        
        //
        
        if(auth()->guard('admin')->user()->emp != 0){
            
               $items=Shipment::latest('id')->where('Driver',auth()->guard('admin')->user()->emp)->paginate(20);
            
        }else{
             $items=Shipment::latest('id')->paginate(20);  
            
        }
     

        return view('admin.Shipping.ShipmentSechdule',get_defined_vars());
    }
    
    public function FilterShipmentSechdule(){

        $Types=NewShippingTypes::all();
        $Categories=NewShippingCategories::all();
        $RqstTypes=NewShippingRqstTypes::all();

        
        
           $From=request('From');
           $To=request('To');
           $Sender=request('Sender');
           $Receiver=request('Receiver');
           $Shipment_Class=request('Shipment_Class');
           $Payment_Method=request('Payment_Method');
           $Shipment_Type=request('Shipment_Type');
           $Shipment_Category=request('Shipment_Category');
           $Shipment_Rqst_Type=request('Shipment_Rqst_Type');
           $Delegate=request('Delegate');
           $Driver=request('Driver');
           $FromStore=request('FromStore');
           $ToStore=request('ToStore');
           $Status=request('Status');
           $Barcode=request('Barcode');
        
        
        
                 if(auth()->guard('admin')->user()->emp != 0){
                     
                     
       $items=Shipment::latest('id')
            
           
    ->where('Driver',auth()->guard('admin')->user()->emp)       
            
    ->when(!empty($From), function ($query) use ($From,$To) {
        return $query->whereBetween('Date', [$From,$To]);
    })
         
                
            
  ->when(!empty($Sender), function ($query) use ($Sender) {
        return $query->where('Sender', $Sender);
    })
         
                    
            
  ->when(!empty($Receiver), function ($query) use ($Receiver) {
        return $query->where('Received', $Receiver);
    })
         
               
  ->when(!empty($Shipment_Class), function ($query) use ($Shipment_Class) {
        return $query->where('Shipment_Class', $Shipment_Class);
    })
         
                    
  ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
        return $query->where('Payment_Method', $Payment_Method);
    })
         
                    
  ->when(!empty($Shipment_Type), function ($query) use ($Shipment_Type) {
        return $query->where('Shipment_Type', $Shipment_Type);
    })
         
                    
  ->when(!empty($Shipment_Category), function ($query) use ($Shipment_Category) {
        return $query->where('Shipment_Category', $Shipment_Category);
    })
         
                    
  ->when(!empty($Shipment_Rqst_Type), function ($query) use ($Shipment_Rqst_Type) {
        return $query->where('Shipment_Rqst_Type', $Shipment_Rqst_Type);
    })
         
                    
  ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->where('Delegate', $Delegate);
    })
         
                    
  ->when(!empty($Driver), function ($query) use ($Driver) {
        return $query->where('Driver', $Driver);
    })
         
                    
  ->when(!empty($FromStore), function ($query) use ($FromStore) {
        return $query->where('Store', $FromStore);
    })
         
                    
  ->when(!empty($ToStore), function ($query) use ($ToStore) {
        return $query->where('ToStore', $ToStore);
    })
         
                    
  ->when(!empty($Status), function ($query) use ($Status) {
        return $query->where('Status', $Status);
    })
         
                    
  ->when(!empty($Barcode), function ($query) use ($Barcode) {
        return $query->where('Barcode', $Barcode);
    })
         
      
            ->paginate(20);                 
                     
                     
                     
                     
                     
                     
                 }else{
                     
               $items=Shipment::latest('id')
            
            
    ->when(!empty($From), function ($query) use ($From,$To) {
        return $query->whereBetween('Date', [$From,$To]);
    })
         
                
            
  ->when(!empty($Sender), function ($query) use ($Sender) {
        return $query->where('Sender', $Sender);
    })
         
                    
            
  ->when(!empty($Receiver), function ($query) use ($Receiver) {
        return $query->where('Received', $Receiver);
    })
         
               
  ->when(!empty($Shipment_Class), function ($query) use ($Shipment_Class) {
        return $query->where('Shipment_Class', $Shipment_Class);
    })
         
                    
  ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
        return $query->where('Payment_Method', $Payment_Method);
    })
         
                    
  ->when(!empty($Shipment_Type), function ($query) use ($Shipment_Type) {
        return $query->where('Shipment_Type', $Shipment_Type);
    })
         
                    
  ->when(!empty($Shipment_Category), function ($query) use ($Shipment_Category) {
        return $query->where('Shipment_Category', $Shipment_Category);
    })
         
                    
  ->when(!empty($Shipment_Rqst_Type), function ($query) use ($Shipment_Rqst_Type) {
        return $query->where('Shipment_Rqst_Type', $Shipment_Rqst_Type);
    })
         
                    
  ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->where('Delegate', $Delegate);
    })
         
                    
  ->when(!empty($Driver), function ($query) use ($Driver) {
        return $query->where('Driver', $Driver);
    })
         
                    
  ->when(!empty($FromStore), function ($query) use ($FromStore) {
        return $query->where('Store', $FromStore);
    })
         
                    
  ->when(!empty($ToStore), function ($query) use ($ToStore) {
        return $query->where('ToStore', $ToStore);
    })
         
                    
  ->when(!empty($Status), function ($query) use ($Status) {
        return $query->where('Status', $Status);
    })
         
                    
  ->when(!empty($Barcode), function ($query) use ($Barcode) {
        return $query->where('Barcode', $Barcode);
    })
         
      
            ->paginate(20);         
                     
                     
                     
                     
                 }
        
     
        
        
        
        
      
    
 $items->appends(request()->query());

        return view('admin.Shipping.ShipmentSechdule',get_defined_vars());
    }
    
    public function PrintShipment($id){

        $item=Shipment::find($id);
        $type=request('type');
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintShipment',get_defined_vars());
    }
    
    public function PrintShipment8($id){

        $item=Shipment::find($id);
        $type=request('type');
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintShipment8',get_defined_vars());
    }

    public function Shipment(){

        $Types=NewShippingTypes::all();
        $Categories=NewShippingCategories::all();
        $RqstTypes=NewShippingRqstTypes::all();

        $Code=$this->ReturnCode(Shipment::class);
        
        $Def=ShippingDefault::latest('id')->first();
        return view('admin.Shipping.Shipment',get_defined_vars());
    }

    public function AddNewShipment(Request $request,ShippingService $service){
        
        
           $data= $this->validate(request(),[
                'Date'=>'required',
                'Pieces_Num'=>'required',
                'Weight'=>'required',
                'Shipment_Class'=>'required',
                'Payment_Method'=>'required',
                'Breakable'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',

                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',

                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Shipment_Cost'=>'required',
                'Total'=>'required',
            ]);

        try {
            DB::beginTransaction();

         


            $Code=request('Code');
            $Breakable=request('Breakable');
            $Sender_City=request('Sender_City');
            $Receiver_City=request('Receiver_City');
            $Shipment_Type=request('Shipment_Type');
            $Shipment_Category=request('Shipment_Category');

            $Barcode=$this->BarcodeShipment($Code,$Breakable,$Sender_City,$Receiver_City,$Shipment_Type,$Shipment_Category);



            $data['Date']=request('Date');
            $data['Time']=date('H:i:s');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Barcode']=$Barcode;
            $data['Status']=0;
            $data['Pieces_Num']=request('Pieces_Num');
            $data['Desc']=request('Desc');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Length']=request('Length');
            $data['Width']=request('Width');
            $data['Height']=request('Height');
            $data['Note']=request('Note');
            $data['Shipment_Class']=request('Shipment_Class');
            $data['Payment_Method']=request('Payment_Method');
            $data['Breakable']=request('Breakable');
            $data['Delivery_To_Others']=request('Delivery_To_Others');
            $data['Shipping_Costs_Included']=request('Shipping_Costs_Included');
            $data['Opening_Package']=request('Opening_Package');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Shipment_Type']=request('Shipment_Type');
            $data['Shipment_Rqst_Type']=request('Shipment_Rqst_Type');
            $data['Shipment_Category']=request('Shipment_Category');
            $data['Shipment_Cost']=request('Shipment_Cost');
            $data['Goods_Cost']=request('Goods_Cost');
            $data['Delivery_Cost']=request('Delivery_Cost');
            $data['Overload_Weight_Cost']=request('Overload_Weight_Cost');
            $data['Collection_Commission']=request('Collection_Commission');
            $data['Delivery_Commission']=request('Delivery_Commission');
            $data['Return_Cost']=request('Return_Cost');
            $data['Total']=request('Total');
            $data['Pay']=request('Pay');
            $data['Insurance']=request('Insurance');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Store']=request('Store');
            $data['User']=auth()->guard('admin')->user()->id;
            Shipment::create($data);


            $last=Shipment::latest('id')->first()->id;


            $move['Code']=request('Code');
            $move['Barcode']=$Barcode;
            $move['Date']=request('Date');
            $move['Time']=request('Time');
            $move['Sender']=request('Sender');
            $move['Sender_Name']=request('Sender_Name');
            $move['Reciver']=request('Received');
            $move['Reciver_Name']=request('Receiver_Name');
            $move['Status']=0;
            $move['Status_Code']=0;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=request('Note');
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$last;
            ShipmentMoves::create($move);
            
            
            
            
            
            if(!empty(request('Unit'))){
               
                
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');                
                $Unit=request('Unit');                
                $P_Code=request('P_Code');
                $AvQty=request('AvQty');
                $Qty=request('Qty');
                $Price=request('Price');
                $Total=request('Total');
                $Product=request('Product');
                $VOne=request('VOne');
                $VTwo=request('VTwo');
                $V_Name=request('V_Name');
                $VV_Name=request('VV_Name');
                $StorePurch=request('StorePurch');


                for($i=0 ; $i < count($Unit) ; $i++){
                    
                  $uu['P_Code']=$P_Code[$i]; 
                  $uu['P_Ar_Name']=$P_Ar_Name[$i]; 
                  $uu['P_En_Name']=$P_En_Name[$i]; 
                  $uu['V1']=$VOne[$i]; 
                  $uu['V2']=$VTwo[$i]; 
                  $uu['V_Name']=$V_Name[$i]; 
                  $uu['VV_Name']=$VV_Name[$i]; 
                  $uu['AvQty']=$AvQty[$i]; 
                  $uu['Qty']=$Qty[$i]; 
                  $uu['Price']=$Price[$i]; 
                  $uu['Total']=$Total[$i]; 
                  $uu['Store']=$StorePurch[$i]; 
                  $uu['Product']=$Product[$i]; 
                  $uu['Unit']=$Unit[$i]; 
                  $uu['Shipment']=$last; 
                    
                    ShippmentProducts::create($uu);
                    
                    
                }
                
                
                
                
                
                
                
                
            }
            
            


            if(!empty(request('ID'))){
                
                ShipmentRequest::where('id',request('ID'))->update(['Transfer'=>1]);
            }
            
            

            
            
            
            if(request('Payment_Method') == 'Later'){
                
                          $CustSender=Customers::find(request('Sender'));
                          $Cust=Customers::find(request('Received'));
                $client=$Cust->Account;
                $sender=$CustSender->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Total_Price=request('Total');
                $CodeBill=request('Code');
            $service->ShippingJounLater($client, $sender,$Draw,$Coin ,$Safe, $Total_Price,$Pay,$CodeBill);
              
                
            }else{
                
                       $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=request('Total');
                $CodeBill=request('Code');
            $service->ShippingJoun($client, $Draw,$Coin ,$Safe, $Total_Price,$CodeBill);
            
                
                
            }
     
            
            

                $dataUser=[
                'screen_ar'=>'الشحنة',
                'screen_en'=>'Shipment',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
          
            
            
                    if(request('Status') == 1){
                
                  return back();
                
            }
                
            if(request('Status') == 2){
                
             return redirect('PrintShipment/'.$last);
                
            }
                           
            if(request('Status') == 3){
                
             return redirect('PrintShipment8/'.$last);
                
            }
            
            



        }catch(\Exception $ex){

            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteShipment($id){

        try {
            DB::beginTransaction();

            $del=Shipment::find($id);
            ShipmentMoves::where('Shipment_ID',$id)->delete();
            
          
            
     ShippmentProducts::where('Shipment',$del->id)->delete();
     GeneralDaily::where('Code_Type',$del->Code)->where('Type','شحن')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','شحن')->update(['Delete'=>1]);
            
        
            
        
    
            
            
                 $dataUser=[
                'screen_ar'=>'الشحنة',
                'screen_en'=>'Shipment',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);



            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditShipment($id){

        $Types=NewShippingTypes::all();
        $Categories=NewShippingCategories::all();
        $RqstTypes=NewShippingRqstTypes::all();
        $item=Shipment::find($id);
        
         $details=ShippmentProducts::where('Shipment',$item->id)->get();  
        
        return view('admin.Shipping.EditShipment',get_defined_vars());
    }


    public function PostEditShipment(Request $request,ShippingService $service){
        
              $data= $this->validate(request(),[
                'Date'=>'required',
                'Pieces_Num'=>'required',
                'Weight'=>'required',
                'Shipment_Class'=>'required',
                'Payment_Method'=>'required',
                'Breakable'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',

                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',

                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Shipment_Cost'=>'required',
                'Total'=>'required',
            ]);


        try {
            DB::beginTransaction();

      

            $Code=request('Code');
            $Breakable=request('Breakable');
            $Sender_City=request('Sender_City');
            $Receiver_City=request('Receiver_City');
            $Shipment_Type=request('Shipment_Type');
            $Shipment_Category=request('Shipment_Category');

            $Barcode=$this->BarcodeShipment($Code,$Breakable,$Sender_City,$Receiver_City,$Shipment_Type,$Shipment_Category);



            $data['Date']=request('Date');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Barcode']=$Barcode;
            $data['Pieces_Num']=request('Pieces_Num');
            $data['Desc']=request('Desc');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Length']=request('Length');
            $data['Width']=request('Width');
            $data['Height']=request('Height');
            $data['Note']=request('Note');
            $data['Shipment_Class']=request('Shipment_Class');
            $data['Payment_Method']=request('Payment_Method');
            $data['Breakable']=request('Breakable');
            $data['Delivery_To_Others']=request('Delivery_To_Others');
            $data['Shipping_Costs_Included']=request('Shipping_Costs_Included');
            $data['Opening_Package']=request('Opening_Package');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Shipment_Type']=request('Shipment_Type');
            $data['Shipment_Rqst_Type']=request('Shipment_Rqst_Type');
            $data['Shipment_Category']=request('Shipment_Category');
            $data['Shipment_Cost']=request('Shipment_Cost');
            $data['Goods_Cost']=request('Goods_Cost');
            $data['Delivery_Cost']=request('Delivery_Cost');
            $data['Overload_Weight_Cost']=request('Overload_Weight_Cost');
            $data['Collection_Commission']=request('Collection_Commission');
            $data['Delivery_Commission']=request('Delivery_Commission');
            $data['Return_Cost']=request('Return_Cost');
            $data['Total']=request('Total');
            $data['Pay']=request('Pay');
            $data['Insurance']=request('Insurance');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Store']=request('Store');
            Shipment::where('id',request('ID'))->update($data);


$last=request('ID');
            ShipmentMoves::where('Shipment_ID',$last)->delete();

            $move['Code']=request('Code');
            $move['Barcode']=$Barcode;
            $move['Date']=request('Date');
            $move['Time']=request('Time');
            $move['Sender']=request('Sender');
            $move['Sender_Name']=request('Sender_Name');
            $move['Reciver']=request('Received');
            $move['Reciver_Name']=request('Receiver_Name');
            $move['Status']=0;
            $move['Status_Code']=0;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=request('Note');
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$last;
            ShipmentMoves::create($move);


            
            
            
       $del=Shipment::find(request('ID'));                  
     GeneralDaily::where('Code_Type',$del->Code)->where('Type','شحن')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','شحن')->update(['Delete'=>1]);
     ShippmentProducts::where('Shipment',$del->id)->delete();        
      
            
            
                       
            if(!empty(request('Unit'))){
               
                
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');                
                $Unit=request('Unit');                
                $P_Code=request('P_Code');
                $AvQty=request('AvQty');
                $Qty=request('Qty');
                $Price=request('Price');
                $Total=request('Total');
                $Product=request('Product');
                $VOne=request('VOne');
                $VTwo=request('VTwo');
                $V_Name=request('V_Name');
                $VV_Name=request('VV_Name');
                $StorePurch=request('StorePurch');


                for($i=0 ; $i < count($Unit) ; $i++){
                    
                  $uu['P_Code']=$P_Code[$i]; 
                  $uu['P_Ar_Name']=$P_Ar_Name[$i]; 
                  $uu['P_En_Name']=$P_En_Name[$i]; 
                  $uu['V1']=$VOne[$i]; 
                  $uu['V2']=$VTwo[$i]; 
                  $uu['V_Name']=$V_Name[$i]; 
                  $uu['VV_Name']=$VV_Name[$i]; 
                  $uu['AvQty']=$AvQty[$i]; 
                  $uu['Qty']=$Qty[$i]; 
                  $uu['Price']=$Price[$i]; 
                  $uu['Total']=$Total[$i]; 
                  $uu['Store']=$StorePurch[$i]; 
                  $uu['Product']=$Product[$i]; 
                  $uu['Unit']=$Unit[$i]; 
                  $uu['Shipment']=$last; 
                    
                    ShippmentProducts::create($uu);
                    
                    
                }
                
                
                
                
                
                
                
                
            }
            
           
            
            
            
         
            if(request('Payment_Method') == 'Later'){
                
                          $CustSender=Customers::find(request('Sender'));
                          $Cust=Customers::find(request('Received'));
                $client=$Cust->Account;
                $sender=$CustSender->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Total_Price=request('Total');
                $CodeBill=request('Code');
            $service->ShippingJounLater($client, $sender,$Draw,$Coin ,$Safe, $Total_Price,$Pay,$CodeBill);
              
                
            }else{
                
                       $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=request('Total');
                $CodeBill=request('Code');
            $service->ShippingJoun($client, $Draw,$Coin ,$Safe, $Total_Price,$CodeBill);
            
                
                
            }
     
            
            
            

                     $dataUser=[
                'screen_ar'=>'الشحنة',
                'screen_en'=>'Shipment',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserUpdateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ShipmentSechdule');


        }catch(\Exception $ex){

            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Shipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    //ShipmentProductsFilter
        function ShipmentProductsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $Sender = $request->get('Sender');
            
            $Cust=Customers::find($Sender);
            $store_d = SecretariatStores::where('Account',$Cust->Account)->latest('id')->first();

            $store=$store_d->id;

            if($search != '' and $store != '')
            {

          $Prods=SecretariatQty::
                where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                    ->take(500)
                    ->get();

            }

            $total_row = $Prods->count();
            if($total_row > 0)
            {


      
                   foreach($Prods as $rows){
                    if($rows->Qty != 0){
                        if($rows->Store == $store){
                            $st=SecretariatStores::find($store);

                   if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial'){

                                if($rows->Product()->first()->Status == 0){

                                    $units=ProductUnits::where('Product',$rows->Product)->get();
                                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                                    $st=SecretariatStores::find($store);


                                    $output .= '

       <tr id="Row'.$rows->id.'">
        <td>
        '.$rows->P_Ar_Name.'
 <input type="hidden"  id="P_Ar_Name'.$rows->id.'" value="'.$rows->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$rows->id.'" value="'.$rows->P_En_Name.'">
        <input type="hidden"  id="Product'.$rows->id.'" value="'.$rows->Product.'">
        <input type="hidden"  id="VOne'.$rows->id.'" value="'.$rows->V1.'">
        <input type="hidden"  id="VTwo'.$rows->id.'" value="'.$rows->V2.'">
        <input type="hidden"  id="V_Name'.$rows->id.'" value="">
        <input type="hidden"  id="VV_Name'.$rows->id.'" value="">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$rows->id.'" onchange="UnitCodePurchh('.$rows->id.')">
                <option value=""> اختر وحده</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';


                                    }

                                    $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$rows->id.'" value="'.$rr->Unit()->first()->Name.'">
        </td>

                 <td>
        <input type="number" id="AvQty'.$rows->id.'" disabled  class="form-control" value="'.$rows->Qty.'" >

        </td>

        <td>
        <input type="number" id="Qty'.$rows->id.'" onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"   class="form-control" value="1" >

        </td>


        <td>
        <input type="number" id="Price'.$rows->id.'" onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"  class="form-control" value="'.$rr->Price.'" >

        </td>


        <td>
        <input type="text" id="Total'.$rows->id.'"   class="form-control" value="'.$rr->Price.'" readonly >

        </td>




        <td>
         <input type="hidden" id="StorePurch'.$rows->id.'"   class="form-control"  value="'.$st->id.'" >
         <input type="hidden" id="StorePurchName'.$rows->id.'"   class="form-control"  value="'.$st->Arabic_Name.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none"  id="AddBtnPur'.$rows->id.'" onclick="Fun('.$rows->id.')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';
                                }

                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    $units=ProductUnits::where('Product',$rows->Product)->get();
                                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                                    $st=SecretariatStores::find($store);

                                    $output .= '

       <tr id="Row'.$rows->id.'">
        <td>
        '.$rows->P_Ar_Name.' ('.$rows->V1()->first()->Name.')
 <input type="hidden"  id="P_Ar_Name'.$rows->id.'" value="'.$rows->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$rows->id.'" value="'.$rows->P_En_Name.'">
        <input type="hidden"  id="Product'.$rows->id.'" value="'.$rows->Product.'">
        <input type="hidden"  id="VOne'.$rows->id.'" value="'.$rows->V1.'">
        <input type="hidden"  id="VTwo'.$rows->id.'" value="'.$rows->V2.'">
        <input type="hidden"  id="V_Name'.$rows->id.'" value="'.$rows->V1()->first()->Name.'">
        <input type="hidden"  id="VV_Name'.$rows->id.'" value="">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$rows->id.'" onchange="UnitCodePurch('.$rows->id.')">
                <option value=""> اختر وحده</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';


                                    }

                                    $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$rows->id.'" class="form-control" value="'.$rows->Product_Code.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$rows->id.'" value="'.$rows->Unit()->first()->Name.'">
        </td>

           <td>
        <input type="number" id="AvQty'.$rows->id.'" disabled  class="form-control" value="'.$rows->Qty.'" >

        </td>


        <td>
        <input type="number" id="Qty'.$rows->id.'"  onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"   class="form-control" value="1"  >

        </td>



  <td>
        <input type="number" id="Price'.$rows->id.'" onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"  class="form-control" value="'.$rr->Price.'" >

        </td>


        <td>
        <input type="text" id="Total'.$rows->id.'"   class="form-control" value="'.$rr->Price.'" readonly >

        </td>




        <td>
           <input type="hidden" id="StorePurch'.$rows->id.'"   class="form-control"  value="'.$st->id.'" >
         <input type="hidden" id="StorePurchName'.$rows->id.'"   class="form-control"  value="'.$st->Arabic_Name.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none"  id="AddBtnPur'.$rows->id.'" onclick="Fun('.$rows->id.')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';
                                }

                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    $units=ProductUnits::where('Product',$rows->Product)->get();
                                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                                    $st=SecretariatStores::find($store);


                                    $output .= '

       <tr id="Row'.$rows->id.'">
        <td>
        '.$rows->P_Ar_Name.'  ('.$rows->V1()->first()->Name.') ('.$rows->V2()->first()->Name.')
 <input type="hidden"  id="P_Ar_Name'.$rows->id.'" value="'.$rows->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$rows->id.'" value="'.$rows->P_En_Name.'">
        <input type="hidden"  id="Product'.$rows->id.'" value="'.$rows->Product.'">
        <input type="hidden"  id="VOne'.$rows->id.'" value="'.$rows->V1.'">
        <input type="hidden"  id="VTwo'.$rows->id.'" value="'.$rows->V2.'">
        <input type="hidden"  id="V_Name'.$rows->id.'" value="'.$rows->V1()->first()->Name.'">
        <input type="hidden"  id="VV_Name'.$rows->id.'" value="'.$rows->V2()->first()->Name.'">

        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$rows->id.'" onchange="UnitCodePurch('.$rows->id.')">
                <option value=""> اختر وحده</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';


                                    }

                                    $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$rows->id.'" class="form-control" value="'.$rows->Product_Code.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$rows->id.'" value="'.$rows->Unit()->first()->Name.'">
        </td>


                        <td>
        <input type="number" id="AvQty'.$rows->id.'" disabled  class="form-control" value="'.$rows->Qty.'" >

        </td>
        <td>
        <input type="number" id="Qty'.$rows->id.'"  onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"   class="form-control" >

        </td>




              <td>
        <input type="number" id="Price'.$rows->id.'" onclick="TotalFun('.$rows->id.')" onkeyup="TotalFun('.$rows->id.')"  class="form-control" value="'.$rr->Price.'" >

        </td>


        <td>
        <input type="text" id="Total'.$rows->id.'"   class="form-control" value="'.$rr->Price.'" readonly >

        </td>
 
        <td>
          <input type="hidden" id="StorePurch'.$rows->id.'"   class="form-control"  value="'.$st->id.'" >
          <input type="hidden" id="StorePurchName'.$rows->id.'"   class="form-control"  value="'.$st->Arabic_Name.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none"  id="AddBtnPur'.$rows->id.'" onclick="Fun('.$rows->id.')">
          <i class="fal fa-plus"></i>
          </button>


          </td>
        </tr>


            ';
                                }

                            }




                        }
                    }

                }



            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


//==================  ShipmentRequest  ===================

    public function ShipmentRequestSechdule(){

        $items=ShipmentRequest::latest('id')->paginate(20);

        return view('admin.Shipping.ShipmentRequestSechdule',get_defined_vars());
    }
    
    public function PrintShipmentRequest($id){

        $item=ShipmentRequest::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintShipmentRequest',get_defined_vars());
    }

    public function ShipmentRequest(){

    
        $Code=$this->ReturnCode(ShipmentRequest::class);
        return view('admin.Shipping.ShipmentRequest',get_defined_vars());
    }

    public function AddNewShipmentRequest(Request $request){

               $data= $this->validate(request(),[
                'Date'=>'required',
                'Pieces_Num'=>'required',
                'Weight'=>'required',
                'Payment_Method'=>'required',
                'Breakable'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Shipment_Cost'=>'required',
                'Total'=>'required',
            ]);


         
        try {
            DB::beginTransaction();

     

            $data['Date']=request('Date');
            $data['Time']=date('H:i:s');
            $data['Status']=0;
            $data['Pieces_Num']=request('Pieces_Num');
            $data['Desc']=request('Desc');
            $data['Weight']=request('Weight');
            $data['Length']=request('Length');
            $data['Width']=request('Width');
            $data['Height']=request('Height');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Breakable']=request('Breakable');
            $data['Delivery_To_Others']=request('Delivery_To_Others');
            $data['Opening_Package']=request('Opening_Package');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Delegate']=request('Delegate');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Shipment_Cost']=request('Shipment_Cost');
            $data['Total']=request('Total');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Store']=request('Store');
            $data['Shipment_Type']=request('Shipment_Type');
            $data['Receipt_Date']=request('Receipt_Date');
            $data['Receipt_Time']=request('Receipt_Time');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['User']=auth()->guard('admin')->user()->id;
            ShipmentRequest::create($data);


            $last=ShipmentRequest::latest('id')->first()->id;







            
 

                $dataUser=[
                'screen_ar'=>'طلب شحنة',
                'screen_en'=>'Shipment Request',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            
            
       
                  return back();
                
    


        }catch(\Exception $ex){

            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteShipmentRequest($id){

        try {
            DB::beginTransaction();

            $del=ShipmentRequest::find($id);
        
              // Recipt Voucher Delete Here
            
            
            
                 $dataUser=[
                   'screen_ar'=>'طلب شحنة',
                'screen_en'=>'Shipment Request',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);



            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditShipmentRequest($id){

        $item=ShipmentRequest::find($id);
        return view('admin.Shipping.EditShipmentRequest',get_defined_vars());
    }

    public function PostEditShipmentRequest(Request $request){
        
              $data= $this->validate(request(),[
 

        'Date'=>'required',
                'Pieces_Num'=>'required',
                'Weight'=>'required',
                'Payment_Method'=>'required',
                'Breakable'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Shipment_Cost'=>'required',
                'Total'=>'required',
            ]);



        try {
            DB::beginTransaction();

      
                $data['Date']=request('Date');
            $data['Pieces_Num']=request('Pieces_Num');
            $data['Desc']=request('Desc');
            $data['Weight']=request('Weight');
            $data['Length']=request('Length');
            $data['Width']=request('Width');
            $data['Height']=request('Height');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Breakable']=request('Breakable');
            $data['Delivery_To_Others']=request('Delivery_To_Others');
            $data['Opening_Package']=request('Opening_Package');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Delegate']=request('Delegate');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Shipment_Cost']=request('Shipment_Cost');
            $data['Total']=request('Total');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
                    $data['Shipment_Type']=request('Shipment_Type');
            $data['Receipt_Date']=request('Receipt_Date');
            $data['Receipt_Time']=request('Receipt_Time');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            ShipmentRequest::where('id',request('ID'))->update($data);


$last=request('ID');
           

            
              // Recipt Voucher Delete Here
            
              // Recipt Voucher Create Here
            
            

                     $dataUser=[
                        'screen_ar'=>'طلب شحنة',
                'screen_en'=>'Shipment Request',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserUpdateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ShipmentRequestSechdule');


        }catch(\Exception $ex){

            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    //TransferShipmentRequest
    
    public function TransferShipmentRequest($id){

        $Types=NewShippingTypes::all();
        $Categories=NewShippingCategories::all();
        $RqstTypes=NewShippingRqstTypes::all();

        $Code=$this->ReturnCode(Shipment::class);
         $item=ShipmentRequest::find($id);
        return view('admin.Shipping.TransferShipmentRequest',get_defined_vars());
    }

    
    
    

//==================  ShipmentMoves  ===================


    public function ShipmentMoves(){

        $items=ShipmentMoves::latest('id')->paginate(20);

        return view('admin.Shipping.ShipmentMoves',get_defined_vars());
    }

    public function FilterShipmentMoves(){

        
     $from      = request('From');
$to        = request('To');
$barcode   = request('Barcode');
$sender    = request('Sender');
$received  = request('Received');
$delegate  = request('Delegate');
$driver    = request('Driver');
$status    = request('Status');
        
    

// بناء استعلام البحث بشكل مُحسّن
$items = ShipmentMoves::query()
    ->when($from && $to, function ($query) use ($from, $to) {
        $query->whereBetween('Date', [$from, $to]);
    })
    ->when($barcode, function ($query) use ($barcode) {
        $query->where('Barcode', $barcode);
    })
    ->when($sender, function ($query) use ($sender) {
        $query->where('Sender', $sender);
    })
    ->when($received, function ($query) use ($received) {
        $query->where('Reciver', $received);
    })
    ->when($delegate, function ($query) use ($delegate) {
        $query->where('Delegate', $delegate);
    })
    ->when($driver, function ($query) use ($driver) {
        $query->where('Driver', $driver);
    })
    ->when($status, function ($query) use ($status) {
        $query->where('Status', $status);
    })
    
    ->latest('id')
    ->paginate(20);

        $items->appends(request()->query());
        return view('admin.Shipping.ShipmentMoves',get_defined_vars());
    }

    
    

//==================  Shipments Distribution  ===================

    
      public function ShipmentsDistributionSechdule(){
          
          
          
               if(auth()->guard('admin')->user()->emp != 0){
                   
                $items=ShipmentsDistribution::latest('id')
                    
                ->where('Driver',auth()->guard('admin')->user()->emp)   
                    
                    ->paginate(20);       
                   
               }else{
                   
                $items=ShipmentsDistribution::latest('id')->paginate(20);       
                   
               }
    
                   
                   
        return view('admin.Shipping.ShipmentsDistributionSechdule',get_defined_vars());
    }
    
      public function ShipmentsDistribution(){
        $Code=$this->ReturnCode(ShipmentsDistribution::class);
          $Def=ShippingDefault::latest('id')->first();
        return view('admin.Shipping.ShipmentsDistribution',get_defined_vars());
    }
    
    
    function ShipmentsDistributionFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');


            if($store != '')
            {


                 if($search != ''){
                     
                        $data =Shipment::where('Store',$store)->where('Status',0)
                             ->where('Code','ILIKE', "%{$search}%")
                            ->limit(200)->get();
                     
                     
                 }else{
                  
                        $data =Shipment::where('Store',$store)->where('Status',0)->limit(200)->get();
                 }
             

            }

            $total_row = $data->count();
            if($total_row > 0)
            {


                foreach($data as $row){
                

                            $output .= '

       <tr id="Row'.$row->id.'">

        <td>
        '.$row->Code.'
        <input type="hidden" id="Code'.$row->id.'"   class="form-control" value="'.$row->Code.'" >
        </td>

        <td>
        '.$row->Barcode.'
        <input type="hidden" id="Barcode'.$row->id.'"   class="form-control" value="'.$row->Barcode.'" >
        </td>

        <td>
        '.$row->Pieces_Num.'
        <input type="hidden" id="Pieces_Num'.$row->id.'"   class="form-control " value="'.$row->Pieces_Num.'" >
        </td>


        <td>
        '.$row->Weight.'
        <input type="hidden" id="Weight'.$row->id.'"   class="form-control " value="'.$row->Weight.'" >
        </td>


        <td>
        '.$row->Sender_Name.'
        <input type="hidden" id="Sender_Name'.$row->id.'"   class="form-control" value="'.$row->Sender_Name.'" >
        </td>


        <td>
        '.$row->Receiver_Name.'
        <input type="hidden" id="Receiver_Name'.$row->id.'"   class="form-control" value="'.$row->Receiver_Name.'" >
        </td>


        <td>
        '.$row->Total.'
        <input type="hidden" id="Total'.$row->id.'"   class="form-control " value="'.$row->Total.'" >
        <input type="hidden" id="Shipment_ID'.$row->id.'"   class="form-control" value="'.$row->id.'" >
        </td>


        <td>
           
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$row->id.'" onclick="Fun('.$row->id.')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';
                }

            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


     public function CarShipmentsDistributionFilter() {


        $Car=request('Car');

            $item=CarShipping::find($Car);


        if(!empty($item->Delegate()->first()->Name)) {

            $Delegate=$item->Delegate()->first()->Name;

        }else{

            $Delegate='';

        }

        if(!empty($item->Driver()->first()->Name)) {

            $Driver=$item->Driver()->first()->Name;

        }else{

            $Driver='';

        }



            $states = [

                'MINI'=>$item->Minimum,
                'MAX'=>$item->Max_Load,
                'DelegateID'=>$item->Delegate,
                'DelegateValue'=>$Delegate,
                'DriverID'=>$item->Driver,
                'DriverValue'=>$Driver,
           
                
            ];

        return response()->json($states);

    }

    
     public function AddNewShipmentsDistribution(Request $request,ShippingService $service){

         
         
            $data= $this->validate(request(),[
                'Date'=>'required',
                'Car'=>'required',
              
                'Driver'=>'required',
                'FromStore'=>'required',
                'ToStore'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);



        try {
            DB::beginTransaction();



                if(request('Status') == 1){

                    $status=1;
                }

                if(request('Status') == 0){

                    $status=0;
                }




                  $ID = DB::table('shipments_distributions')->insertGetId(

        array(


            'Date' => request('Date'),
            'Time' =>date('H:i:s'),
            'Car' => request('Car'),
            'Delegate' => request('Delegate'),
            'Driver' => request('Driver'),
            'Safe' => request('Safe'),
            'Coin' => request('Coin'),
            'Draw' => request('Draw'),
            'FromStore' => request('FromStore'),
            'ToStore' => request('ToStore'),
            'Total_Pieces' => request('Total_PiecesX'),
            'Total_Weight' => request('Total_WeightX'),
            'Total_Cost' => request('Total_CostX'),
            'Count_Shipmets' => request('Count_Shipmets'),
            'DriverPrecent' => request('DriverPrecent'),
            'Status' => $status,
            'User' => auth()->guard('admin')->user()->id,
       

        )
    );

 
            if(!empty(request('Workers'))){
                
                $Worker=request('Workers');
                
                for($w=0;$w < count($Worker) ; $w++){
                    
                    $work['Worker']=$Worker[$w];
                    $work['ShipmentsDistribution']=$ID;
                    ShipmentsDistributionWorkers::create($work);
    
                }
                
                
                
            }
            
            
            if(!empty(request('Shipment_ID'))){
                
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                
                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['ShipmentsDistribution']=$ID;
                    ShipmentsDistributionGoods::create($ship);
                    
                   
                                
            
            if($status == 1){
                
                $Shipment=Shipment::find($Shipment_ID[$i]);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=1;
            $move['Status_Code']=1;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>1,'Delegate'=>request('Delegate'),'Driver'=>request('Driver'),'Car'=>request('Car')]);        
                

            }

                    
                    
                    
                    
                    
    
                }
                
                
                
            }
            
            
      
         if($status == 1){
               

                $Delegate=request('Delegate');
                $Driver=request('Driver');
                $Car=request('Car');
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=request('Total_CostX');
                $CodeBill=request('CodeX');
                $Workers=request('Workers');
                $DriverPrecent=request('DriverPrecent');
            
            $service->DistrbutionJoun($Delegate,$Driver,$Car,$Draw,$Coin,$Safe,$Total_Price,$CodeBill,$Workers,$DriverPrecent);
   
                 
             }

            
            
            
            
         $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    public function DeleteShipmentsDistribution($id){

        try {
            DB::beginTransaction();

            $del=ShipmentsDistribution::find($id);
            ShipmentMoves::where('Shipment_Dist_ID',$id)->delete();
            ShipmentsDistributionGoods::where('ShipmentsDistribution',$del->id)->delete();
            ShipmentsDistributionWorkers::where('ShipmentsDistribution',$del->id)->delete();  
            
                            
            Shipment::where('id',$del->Shipment_ID)->update(['Status'=>0]);        
                
         
            
            
              // Qyoud Here
            
  GeneralDaily::where('Code_Type',$del->Code)->where('Type','توزيع شحنات')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','توزيع شحنات')->update(['Delete'=>1]);
            
            
            
                        $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);


            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
      public function PrintShipmentsDistribution($id){

        $item=ShipmentsDistribution::find($id);
        $Def=CompanyData::latest()->first();
               $type=request('type');
        return view('admin.Shipping.PrintShipmentsDistribution',get_defined_vars());
    }
   
      public function PrintShipmentsDistribution8($id){

        $item=ShipmentsDistribution::find($id);
        $Def=CompanyData::latest()->first();
               $type=request('type');
        return view('admin.Shipping.PrintShipmentsDistribution8',get_defined_vars());
    }

    public function EditShipmentsDistribution($id){
        $item=ShipmentsDistribution::find($id);
         $Goods=ShipmentsDistributionGoods::where('ShipmentsDistribution',$item->id)->get();
  $WORKERS=ShipmentsDistributionWorkers::where('ShipmentsDistribution',$item->id)->get(); 
        return view('admin.Shipping.EditShipmentsDistribution',get_defined_vars());
    }
    
     public function PostEditShipmentsDistribution(Request $request,ShippingService $service){
         
                 $data= $this->validate(request(),[
                'Date'=>'required',
                'Car'=>'required',
              
                'Driver'=>'required',
                'FromStore'=>'required',
                'ToStore'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);


        try {
            DB::beginTransaction();

    

                if(request('Status') == 1){

                    $status=1;
                }

                if(request('Status') == 0){

                    $status=0;
                }




                  $ID =request('ID');
            
            
             $data['Date']=request('Date');
            $data['Car']=request('Car');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['FromStore']=request('FromStore');
            $data['ToStore']=request('ToStore');
            $data['Total_Pieces']=request('Total_PiecesX');
            $data['Total_Weight']=request('Total_WeightX');
            $data['Total_Cost']=request('Total_CostX');
            $data['Count_Shipmets']=request('Count_Shipmets');
            $data['DriverPrecent']=request('DriverPrecent');
            $data['Status']=$status;

            ShipmentsDistribution::where('id',$ID)->update($data);

            
 
            if(!empty(request('Workers'))){
                

            ShipmentsDistributionWorkers::where('ShipmentsDistribution',$ID)->delete();  
                
                $Worker=request('Workers');
                
                for($w=0;$w < count($Worker) ; $w++){
                    
                    $work['Worker']=$Worker[$w];
                    $work['ShipmentsDistribution']=$ID;
                    ShipmentsDistributionWorkers::create($work);
    
                }
                
                
                
            }
            
            
            if(!empty(request('Shipment_ID'))){
                
                
            ShipmentMoves::where('Shipment_Dist_ID',$ID)->delete();
            ShipmentsDistributionGoods::where('ShipmentsDistribution',$ID)->delete();
                
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                
                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['ShipmentsDistribution']=$ID;
                    ShipmentsDistributionGoods::create($ship);
                    
                   
                                
            
            if($status == 1){
                
                $Shipment=Shipment::find($Shipment_ID[$i]);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=1;
            $move['Status_Code']=1;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>1,'Delegate'=>request('Delegate'),'Driver'=>request('Driver'),'Car'=>request('Car')]);        
                

            }

                    
                    
                    
                    
                    
    
                }
                
                
                
            }
            
            
            //Qyood

            
           $del=ShipmentsDistribution::find($ID);
            
  GeneralDaily::where('Code_Type',$del->Code)->where('Type','توزيع شحنات')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','توزيع شحنات')->update(['Delete'=>1]);
            
            
            
         if($status == 1){
               

                $Delegate=request('Delegate');
                $Driver=request('Driver');
                $Car=request('Car');
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=request('Total_CostX');
                $CodeBill=request('CodeX');
                $Workers=request('Workers');
            
                 $DriverPrecent=request('DriverPrecent');
            

            $service->DistrbutionJoun($Delegate,$Driver,$Car,$Draw,$Coin,$Safe,$Total_Price,$CodeBill,$Workers,$DriverPrecent);
   
                 
             }

            
            
            

            
            
                               $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserUpdateMoves($dataUser);

            
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ShipmentsDistributionSechdule');


        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    public function MovementShipmentsDistribution($id){

        try {
            DB::beginTransaction();

            $item=ShipmentsDistribution::find($id);
            
           
            $Goods=ShipmentsDistributionGoods::where('ShipmentsDistribution',$item->id)->get();
          
                  ShipmentsDistribution::where('id',$id)->update(['Status'=>2]);   
                   
            foreach($Goods as $good){
            
                
           $Shipment=Shipment::find($good->Shipment_ID);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=date('Y-m-d');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=2;
            $move['Status_Code']=2;
            $move['Delegate']=$item->Delegate;
            $move['Driver']=$item->Driver;
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$good->Shipment_ID;
            $move['Shipment_Dist_ID']=$id;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$good->Shipment_ID)->update(['Status'=>2,'Delegate'=>$item->Delegate,'Driver'=>$item->Driver,'Car'=>$item->Car]);        
                
                
                
                
            }
            
            
        

          
            
                $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'type_ar'=>'تم التحرك',
                'type_en'=>'Shipment Moved',
                'explain_ar'=>$item->Code,
                'explain_en'=>$item->Code,
            ];
            $this->UserCustomMoves($dataUser);



            
            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }
    
    public function DeliveredShipmentsDistribution($id){

        try {
            DB::beginTransaction();

            $item=ShipmentsDistribution::find($id);
            
           
            $Goods=ShipmentsDistributionGoods::where('ShipmentsDistribution',$item->id)->get();
                ShipmentsDistribution::where('id',$id)->update(['Status'=>3]);   
                
                   
            foreach($Goods as $good){
            
                
           $Shipment=Shipment::find($good->Shipment_ID);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=date('Y-m-d');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=3;
            $move['Status_Code']=3;
            $move['Delegate']=$item->Delegate;
            $move['Driver']=$item->Driver;
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$good->Shipment_ID;
            $move['Shipment_Dist_ID']=$id;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$good->Shipment_ID)->update(['Status'=>3,'Delegate'=>$item->Delegate,'Driver'=>$item->Driver,'Car'=>$item->Car]);        
                
                
                
                
            }
            
            
            
            
            
            
            
            
                     
                $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'type_ar'=>'تم الوصول',
                'type_en'=>'Shipment Delivered',
                'explain_ar'=>$item->Code,
                'explain_en'=>$item->Code,
            ];
            $this->UserCustomMoves($dataUser);



            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

        
    public function CarBackShipmentsDistribution($id){

        try {
            DB::beginTransaction();

            $item=ShipmentsDistribution::find($id);
            
           
            $Goods=ShipmentsDistributionGoods::where('ShipmentsDistribution',$item->id)->get();
                ShipmentsDistribution::where('id',$id)->update(['Status'=>2]);   
                
                   
            foreach($Goods as $good){
            
                
           $Shipment=Shipment::find($good->Shipment_ID);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=date('Y-m-d');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=5;
            $move['Status_Code']=5;
            $move['Delegate']=$item->Delegate;
            $move['Driver']=$item->Driver;
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$good->Shipment_ID;
            $move['Shipment_Dist_ID']=$id;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$good->Shipment_ID)->update(['Status'=>2,'Delegate'=>$item->Delegate,'Driver'=>$item->Driver,'Car'=>$item->Car]);        
                
                
                
                
            }
            
            
            
            
            
            
            
            
                     
                $dataUser=[
                'screen_ar'=>'توزيع الشحنات',
                'screen_en'=>'Shipments Distribution',
                'type_ar'=>'تم عودة السيارة',
                'type_en'=>'Shipment Car Back',
                'explain_ar'=>$item->Code,
                'explain_en'=>$item->Code,
            ];
            $this->UserCustomMoves($dataUser);



            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ShipmentsDistribution::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    
//==================  Unloading Shipments  ===================

    
      public function UnloadingShipmentsSechdule(){
        $items=UnloadingShipments::latest('id')->paginate(20);
        return view('admin.Shipping.UnloadingShipmentsSechdule',get_defined_vars());
    }
    
      public function UnloadingShipments(){
        $Code=$this->ReturnCode(UnloadingShipments::class);
        return view('admin.Shipping.UnloadingShipments',get_defined_vars());
    }
    
    function UnloadingShipmentsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $car = $request->get('Car');
            $ShipmentsDistributionCode = $request->get('ShipmentsDistributionCode');


            if($car != '' and $ShipmentsDistributionCode != '')
            {


             
                 if($search != ''){
                     
                        $data =ShipmentsDistributionGoods::
                              whereRelation('ShipmentsDistribution','Code',(string)$ShipmentsDistributionCode)
                              ->whereRelation('ShipmentsDistribution','Car',$car)
                              ->whereRelation('ShipmentsDistribution','Status',3)
                              ->where('Status',0)
                             ->where('Code','ILIKE', "%{$search}%")
                            ->limit(200)->get();
                     
                     
                 }else{
                  
                        $data =ShipmentsDistributionGoods::
                       whereRelation('ShipmentsDistribution','Code',(string)$ShipmentsDistributionCode)
                     ->whereRelation('ShipmentsDistribution','Car',$car)
                          ->whereRelation('ShipmentsDistribution','Status',3)   
                           ->where('Status',0)
                           ->limit(200)->get();
                 }
             

            }

            $total_row = $data->count();
            if($total_row > 0)
            {

                   $item=ShipmentsDistribution::where('Code',$ShipmentsDistributionCode)->latest('id')->first();
                
                $FromStoreID=$item->FromStore;
                $FromStoreValue=$item->FromStore()->first()->Name;      
                $ToStoreID=$item->ToStore;
                $ToStoreValue=$item->ToStore()->first()->Name;
                $DriverID=$item->Driver;
                $DriverValue=$item->Driver()->first()->Name;
                $DelegateID=$item->Delegate;
                $DelegateValue=$item->Delegate()->first()->Name;

                

                foreach($data as $row){
                

                            $output .= '

       <tr id="Row'.$row->id.'">

        <td>
        '.$row->Code.'
        <input type="hidden" id="Code'.$row->id.'"   class="form-control CODE" value="'.$row->Code.'" >
        </td>

        <td>
        '.$row->Barcode.'
        <input type="hidden" id="Barcode'.$row->id.'"   class="form-control BARCODE" value="'.$row->Barcode.'" >
        </td>

        <td>
        '.$row->Total_Pieces.'
        <input type="hidden" id="Pieces_Num'.$row->id.'"   class="form-control TOTAL_PIECES" value="'.$row->Total_Pieces.'" >
        </td>


        <td>
        '.$row->Total_Weight.'
        <input type="hidden" id="Weight'.$row->id.'"   class="form-control TOTAL_WEIGHT" value="'.$row->Total_Weight.'" >
        </td>


        <td>
        '.$row->Shipment_ID()->first()->Sender_Name.'
        <input type="hidden" id="Sender_Name'.$row->id.'"   class="form-control SENDER_NAME" value="'.$row->Shipment_ID()->first()->Sender_Name.'" >
        </td>


        <td>
        '.$row->Shipment_ID()->first()->Receiver_Name.'
        <input type="hidden" id="Receiver_Name'.$row->id.'"   class="form-control RECEIVER_NAME" value="'.$row->Shipment_ID()->first()->Receiver_Name.'" >
        </td>




        <td>
        '.$row->Total_Cost.'
        <input type="hidden" id="Total'.$row->id.'"   class="form-control TOTAL_COST" value="'.$row->Total_Cost.'" >
        <input type="hidden" id="Shipment_ID'.$row->id.'"   class="form-control SHIPMENT_ID" value="'.$row->Shipment_ID.'" >
        <input type="hidden" id="Dist_Goods_ID'.$row->id.'"   class="form-control DIST_GOOODS_ID" value="'.$row->id.'" >
        </td>



        <td>
           
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$row->id.'" onclick="Fun('.$row->id.')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';
                }

            }else
            {
                
                
                $FromStoreID='';
$FromStoreValue='';          $ToStoreID='';
$ToStoreValue='';
$DriverID='';
$DriverValue='';
$DelegateID='';
$DelegateValue='';
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
                'FromStoreID'  => $FromStoreID,
                'FromStoreValue'  => $FromStoreValue,              
                'ToStoreID'  => $ToStoreID,
                'ToStoreValue'  => $ToStoreValue,
                'DriverID'  => $DriverID,
                'DriverValue'  => $DriverValue,
                'DelegateID'  => $DelegateID,
                'DelegateValue'  => $DelegateValue,
            );
            echo json_encode($data);
        }
    }

      public function AddNewUnloadingShipments(Request $request){
          
                    $data= $this->validate(request(),[
                'Date'=>'required',
                'Car'=>'required',
                'Delegate'=>'required',
                'Driver'=>'required',
                'FromStore'=>'required',
                'ToStore'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);



        try {
            DB::beginTransaction();

  



                  $ID = DB::table('unloading_shipments')->insertGetId(

        array(


            'Date' => request('Date'),
            'Time' =>date('H:i:s'),
            'Car' => request('Car'),
            'Delegate' => request('Delegate'),
            'Driver' => request('Driver'),
            'Safe' => request('Safe'),
            'Coin' => request('Coin'),
            'Draw' => request('Draw'),
            'FromStore' => request('FromStore'),
            'ToStore' => request('ToStore'),
            'Total_Pieces' => request('Total_PiecesX'),
            'Total_Weight' => request('Total_WeightX'),
            'Total_Cost' => request('Total_CostX'),
            'Count_Shipmets' => request('Count_Shipmets'),
            'ShipmentsDistributionCode' => request('ShipmentsDistributionCode'),
            'Status' => 0,
            'User' => auth()->guard('admin')->user()->id,
       

        )
    );

 
            if(!empty(request('Workers'))){
                
                $Worker=request('Workers');
                
                for($w=0;$w < count($Worker) ; $w++){
                    
                    $work['Worker']=$Worker[$w];
                    $work['ShipmentsUnloading']=$ID;
                    UnloadingShipmentsWorkers::create($work);
    
                }
                
                
                
            }
            

            
            if(!empty(request('Shipment_ID'))){
                
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                $Dist_Goods_ID=request('Dist_Goods_ID');
                
                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['Dist_Goods_ID']=$Dist_Goods_ID[$i];
                    $ship['ShipmentsUnloading']=$ID;
                    UnloadingShipmentsGoods::create($ship);
                    
         
                $Shipment=Shipment::find($Shipment_ID[$i]);
                $ShipmentDist=ShipmentsDistributionGoods::find($Dist_Goods_ID[$i]);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=4;
            $move['Status_Code']=4;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=$ShipmentDist->ShipmentsDistribution;
            $move['Shipment_Unload_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>4,'ToStore'=>request('ToStore')]);        
        ShipmentsDistributionGoods::where('id',$Dist_Goods_ID[$i])->update(['Status'=>1]);        
                
       
       
             
                    
                    
    
                }
                
                
                
            }
            
            
            //Qyood

            
            
            
            
                $dataUser=[
                'screen_ar'=>'تفريغ الشحنات',
                'screen_en'=>'Unloading Shipments',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    
    public function DeleteUnloadingShipments($id){

        try {
            DB::beginTransaction();

            $del=UnloadingShipments::find($id);
          
            
            $Goods=UnloadingShipmentsGoods::where('ShipmentsUnloading',$del->id)->get();
            
            
            foreach($Goods as $god){
                
                   ShipmentsDistributionGoods::where('id',$god->Dist_Goods_ID)->update(['Status'=>0]);         
                
            }
            
            Shipment::where('id',$del->Shipment_ID)->update(['Status'=>3]);       
            

              // Qyoud Here
            

            ShipmentMoves::where('Shipment_Unload_ID',$id)->delete();
            UnloadingShipmentsGoods::where('ShipmentsUnloading',$del->id)->delete();
            UnloadingShipmentsWorkers::where('ShipmentsUnloading',$del->id)->delete();  
         
            
            
                       $dataUser=[
                'screen_ar'=>'تفريغ الشحنات',
                'screen_en'=>'Unloading Shipments',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);

            
            
            
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
      public function PrintUnloadingShipments($id){

        $item=UnloadingShipments::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintUnloadingShipments',get_defined_vars());
    }

    
    
    public function EditUnloadingShipments($id){
        $item=UnloadingShipments::find($id);
         $Goods=UnloadingShipmentsGoods::where('ShipmentsUnloading',$item->id)->get();
  $WORKERS=UnloadingShipmentsWorkers::where('ShipmentsUnloading',$item->id)->get(); 
        return view('admin.Shipping.EditUnloadingShipments',get_defined_vars());
    }
    
    
       public function PostEditUnloadingShipments(Request $request){
           
                      $data= $this->validate(request(),[
                'Date'=>'required',
                'Car'=>'required',
                'Delegate'=>'required',
                'Driver'=>'required',
                'FromStore'=>'required',
                'ToStore'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);



        try {
            DB::beginTransaction();

 
       


                  $ID =request('ID');
            
            
             $data['Date']=request('Date');
            $data['Car']=request('Car');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['FromStore']=request('FromStore');
            $data['ToStore']=request('ToStore');
            $data['Total_Pieces']=request('Total_PiecesX');
            $data['Total_Weight']=request('Total_WeightX');
            $data['Total_Cost']=request('Total_CostX');
            $data['Count_Shipmets']=request('Count_Shipmets');
            $data['Status']=request('Status');
            $data['ShipmentsDistributionCode']=request('ShipmentsDistributionCode');

            UnloadingShipments::where('id',$ID)->update($data);

            
            
            //Delete
              $del=UnloadingShipments::find($ID);
          
            
            $Goods=UnloadingShipmentsGoods::where('ShipmentsUnloading',$del->id)->get();
            
            
            foreach($Goods as $god){
                
                   ShipmentsDistributionGoods::where('id',$god->Dist_Goods_ID)->update(['Status'=>0]);         
                
            }
            
            Shipment::where('id',$del->Shipment_ID)->update(['Status'=>3]);       
            
      
             
            //End Delete 
            
            
            
 
            if(!empty(request('Workers'))){
                

                 UnloadingShipmentsWorkers::where('ShipmentsUnloading',$ID)->delete();  
                
                $Worker=request('Workers');
                
                for($w=0;$w < count($Worker) ; $w++){
                    
                    $work['Worker']=$Worker[$w];
                    $work['ShipmentsUnloading']=$ID;
                    UnloadingShipmentsWorkers::create($work);
    
                }
                
                
                
            }
            
            
            if(!empty(request('Shipment_ID'))){
                
                
            ShipmentMoves::where('Shipment_Unload_ID',$ID)->delete();
            UnloadingShipmentsGoods::where('ShipmentsUnloading',$ID)->delete();
     
                
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                
                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['ShipmentsUnloading']=$ID;
                    UnloadingShipmentsGoods::create($ship);
                    
                   
         $Shipment=Shipment::find($Shipment_ID[$i]);
                $ShipmentDist=ShipmentsDistributionGoods::find($Dist_Goods_ID[$i]);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=4;
            $move['Status_Code']=4;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=$ShipmentDist->ShipmentsDistribution;
            $move['Shipment_Unload_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>4,'ToStore'=>request('ToStore')]);        
        ShipmentsDistributionGoods::where('id',$Dist_Goods_ID[$i])->update(['Status'=>1]);        
                
       
               
                    
                    
                    
                    
    
                }
                
                
                
            }
            
            
            //Qyood

            
            
            
            
                     $dataUser=[
                'screen_ar'=>'تفريغ الشحنات',
                'screen_en'=>'Unloading Shipments',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('UnloadingShipmentsSechdule');


        }catch(\Exception $ex){

            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=UnloadingShipments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
//    ShipmentsDistributionCodeFilter
    
         public function ShipmentsDistributionCodeFilter(){

             $car=request('Car');
             
        //  $states =ShipmentsDistribution::where('Status',3)->where('Car',$car)->pluck("Code","Code");
  

             $UsedCode = UnloadingShipments::where('Car', $car)->pluck('ShipmentsDistributionCode')->toArray();

$states = ShipmentsDistribution::where('Status', 3)
                               ->where('Car', $car)
                               ->whereNotIn('Code', $UsedCode)
                               ->pluck("Code", "Code");
               
        return response()->json($states);
       
    }
    


    
//==================  Recived Shipments  ===================

    
      public function RecivedShipmentsSechdule(){
        $items=RecivedShipment::latest('id')->paginate(20);
        return view('admin.Shipping.RecivedShipmentsSechdule',get_defined_vars());
    }
    
      public function RecivedShipments(){
        $Code=$this->ReturnCode(RecivedShipment::class);
                    $Def=ShippingDefault::latest('id')->first();
        return view('admin.Shipping.RecivedShipments',get_defined_vars());
    }
        
    function RecivedShipmentsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');
 


            if($store != '')
            {


             
                 if($search != ''){
                     
                        $data =UnloadingShipmentsGoods::
                              whereRelation('ShipmentsUnloading','ToStore',$store)
                              ->where('Status',0)
                             ->where('Code','ILIKE', "%{$search}%")
                            ->limit(200)->get();
                     
                     
                 }else{
                  
                        $data =UnloadingShipmentsGoods::
                            whereRelation('ShipmentsUnloading','ToStore',$store)
                           ->where('Status',0)
                           ->limit(200)->get();
                 }
                
                
                
             

            }

            $total_row = $data->count();
            if($total_row > 0)
            {

    

                foreach($data as $row){
                

                            $output .= '

       <tr id="Row'.$row->id.'">

        <td>
        '.$row->Code.'
        <input type="hidden" id="Code'.$row->id.'"   class="form-control CODE" value="'.$row->Code.'" >
        </td>

        <td>
        '.$row->Barcode.'
        <input type="hidden" id="Barcode'.$row->id.'"   class="form-control BARCODE" value="'.$row->Barcode.'" >
        </td>

        <td>
        '.$row->Total_Pieces.'
        <input type="hidden" id="Pieces_Num'.$row->id.'"   class="form-control TOTAL_PIECES" value="'.$row->Total_Pieces.'" >
        </td>


        <td>
        '.$row->Total_Weight.'
        <input type="hidden" id="Weight'.$row->id.'"   class="form-control TOTAL_WEIGHT" value="'.$row->Total_Weight.'" >
        </td>


        <td>
        '.$row->Shipment_ID()->first()->Sender_Name.'
        <input type="hidden" id="Sender_Name'.$row->id.'"   class="form-control SENDER_NAME" value="'.$row->Shipment_ID()->first()->Sender_Name.'" >
        </td>


        <td>
        '.$row->Shipment_ID()->first()->Receiver_Name.'
        <input type="hidden" id="Receiver_Name'.$row->id.'"   class="form-control RECEIVER_NAME" value="'.$row->Shipment_ID()->first()->Receiver_Name.'" >
        </td>




        <td>
        '.$row->Total_Cost.'
        <input type="hidden" id="Total'.$row->id.'"   class="form-control TOTAL_COST" value="'.$row->Total_Cost.'" >
        <input type="hidden" id="Shipment_ID'.$row->id.'"   class="form-control SHIPMENT_ID" value="'.$row->Shipment_ID.'" >
        <input type="hidden" id="Client'.$row->id.'"   class="form-control Client" value="'.$row->Shipment_ID()->first()->Received.'" >
        <input type="hidden" id="Unloading_Goods_ID'.$row->id.'"   class="form-control Unloading_Goods_ID" value="'.$row->id.'" >
        <input type="hidden" id="PayShip'.$row->id.'"   class="form-control PAY" value="'.$row->Shipment_ID()->first()->Pay.'" >
        </td>


        <td>
        '.$row->Shipment_ID()->first()->Total -  $row->Shipment_ID()->first()->Pay .'
        
         <input type="hidden" id="residual'.$row->id.'"   class="form-control" value="'.$row->Shipment_ID()->first()->Total -  $row->Shipment_ID()->first()->Pay.'" >
     </td>

        <td>
           
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$row->id.'" onclick="Fun('.$row->id.')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>

            ';
                }

            }else
            {
                
                
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
                'residual'  => '',
            );
            echo json_encode($data);
        }
    }

    
      public function AddNewRecivedShipments(Request $request,ShippingService $service){
          
                    $data= $this->validate(request(),[
                'Date'=>'required',
                'Type'=>'required',
                'Store'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);



        try {
            DB::beginTransaction();

  
  if(request('Type') == 1){
                
                $sta=0;
                
            }else{
                
                 $sta=1;
                
            }
 
            


    $ID = DB::table('recived_shipments')->insertGetId(

        array(


            'Date' => request('Date'),
            'Time' =>date('H:i:s'),
            'Delegate' => request('Delegate'),
            'Driver' => request('Driver'),
            'Safe' => request('Safe'),
            'Coin' => request('Coin'),
            'Draw' => request('Draw'),
            'Store' => request('Store'),
            'Total_Pieces' => request('Total_PiecesX'),
            'Total_Weight' => request('Total_WeightX'),
            'Total_Cost' => request('Total_CostX'),
            'Count_Shipmets' => request('Count_Shipmets'),
            'Type' => request('Type'),
            'Type' => request('Residual'),
            'Status' => $sta,
            'User' => auth()->guard('admin')->user()->id,
       

        )
    );

            
            if(request('Type') == 1){
                
                $status=6;  //Delegate
                
            }else{
                
                 $status=7;
                
            }
 
            
            if(!empty(request('Shipment_ID'))){
                
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                $Client=request('Client');
                $Unloading_Goods_ID=request('Unloading_Goods_ID');
                $PayShip=request('PayShip');
                $Res=request('RES');
      
                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['Unloading_Goods_ID']=$Unloading_Goods_ID[$i];
                    $ship['PayShip']=$PayShip[$i];
                    $ship['Client']=$Client[$i];
                    $ship['RecivedShipment']=$ID;
                    $ship['Status']=$sta;
                    RecivedShipmentGoods::create($ship);
                    
         
                $Shipment=Shipment::find($Shipment_ID[$i]);
                $ShipmentUnload=UnloadingShipmentsGoods::find($Unloading_Goods_ID[$i]);

                    
            
            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=$status;
            $move['Status_Code']=$status;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=null;
            $move['Shipment_Unload_ID']=$ShipmentUnload->ShipmentsUnloading;
            $move['Shipment_Recived_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>$status]);        
        UnloadingShipmentsGoods::where('id',$Unloading_Goods_ID[$i])->update(['Status'=>1]);        
                
       
       
                          //Qyood

            if($status == 7){
            if($Res[$i] != 0){
            
                
                   
            $Cust=Customers::find($Shipment->Received);
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=$Res[$i];
                $CodeBill=request('CodeX');
            $service->ShippingRecivedJoun($client, $Draw,$Coin ,$Safe, $Total_Price,$CodeBill);
  
                
                
                
          
            }
            }
            
            
             
                    
                    
    
                }
                
                
                
            }
            
            
      
            
            
                $dataUser=[
                'screen_ar'=>'تسليم الشحنات',
                'screen_en'=>'Recived Shipments',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


      public function PrintRecivedShipments($id){

        $item=RecivedShipment::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintRecivedShipments',get_defined_vars());
    }

     
    public function DeleteRecivedShipments($id){

        try {
            DB::beginTransaction();

            $del=RecivedShipment::find($id);
          
            
            $Goods=RecivedShipmentGoods::where('RecivedShipment',$del->id)->get();
            

            
            foreach($Goods as $god){
                
                   UnloadingShipmentsGoods::where('id',$god->Unloading_Goods_ID)->update(['Status'=>0]);         
                
            }
            
            Shipment::where('id',$del->Shipment_ID)->update(['Status'=>4]);       
            

              // Qyoud Here
                        
  GeneralDaily::where('Code_Type',$del->Code)->where('Type','استلام شحن')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','استلام شحن')->update(['Delete'=>1]);
            
         

            ShipmentMoves::where('Shipment_Recived_ID',$id)->delete();
            RecivedShipmentGoods::where('RecivedShipment',$del->id)->delete();
  
            
                       $dataUser=[
                'screen_ar'=>'تسليم الشحنات',
                'screen_en'=>'Recived Shipments',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);

            
            
            
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

      
      public function EditRecivedShipments($id){
               $item=RecivedShipment::find($id);
         $Goods=RecivedShipmentGoods::where('RecivedShipment',$item->id)->get();
        return view('admin.Shipping.EditRecivedShipments',get_defined_vars());
    }
    
    
      
       public function PostEditRecivedShipments(Request $request,ShippingService $service){

           
                    $data= $this->validate(request(),[
                'Date'=>'required',
                'Store'=>'required',
                'Type'=>'required',
                'Total_Pieces'=>'required',
                'Total_Weight'=>'required',
                'Total_Cost'=>'required',
  
            ]);

        try {
            DB::beginTransaction();

   

            
            
  if(request('Type') == 1){
                
                $sta=0;
                
            }else{
                
                 $sta=1;
                
            }
 
            
                  $ID =request('ID');
            
            
             $data['Date']=request('Date');
            $data['Delegate']=request('Delegate');
            $data['Driver']=request('Driver');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Store']=request('Store');
            $data['Total_Pieces']=request('Total_PiecesX');
            $data['Total_Weight']=request('Total_WeightX');
            $data['Total_Cost']=request('Total_CostX');
            $data['Count_Shipmets']=request('Count_Shipmets');
            $data['Type']=request('Type');
            $data['Residual']=request('Residual');
            $data['Status']=$sta;

            RecivedShipment::where('id',$ID)->update($data);

            
            
            //Delete
              $del=RecivedShipment::find($ID);
          
            
                    
            $Goods=RecivedShipmentGoods::where('RecivedShipment',$del->id)->get();
            

            
            foreach($Goods as $god){
                
                   UnloadingShipmentsGoods::where('id',$god->Unloading_Goods_ID)->update(['Status'=>0]);         
                
            }
            
            Shipment::where('id',$del->Shipment_ID)->update(['Status'=>4]);       
           
             

          
  GeneralDaily::where('Code_Type',$del->Code)->where('Type','استلام شحن')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','استلام شحن')->update(['Delete'=>1]);
            
         
            
            //End Delete 
            
            
                  if(request('Type') == 1){
                
                $status=6;
                
            }else{
                
                 $status=7;
                
            }
 
            
            
             if(!empty(request('Shipment_ID'))){
                
                 
            ShipmentMoves::where('Shipment_Recived_ID',$del->id)->delete();
            RecivedShipmentGoods::where('RecivedShipment',$del->id)->delete();
  
                 
                $Shipment_ID=request('Shipment_ID');
                $Code=request('Code');
                $Total_Weight=request('Total_Weight');
                $Total_Cost=request('Total_Cost');
                $Barcode=request('Barcode');
                $Total_Pieces=request('Total_Pieces');
                $Client=request('Client');
                $Unloading_Goods_ID=request('Unloading_Goods_ID');
        $PayShip=request('PayShip');

                for($i=0;$i < count($Shipment_ID) ; $i++){
                    
                    $ship['Shipment_ID']=$Shipment_ID[$i];
                    $ship['Code']=$Code[$i];
                    $ship['Total_Weight']=$Total_Weight[$i];
                    $ship['Total_Cost']=$Total_Cost[$i];
                    $ship['Barcode']=$Barcode[$i];
                    $ship['Total_Pieces']=$Total_Pieces[$i];
                    $ship['Unloading_Goods_ID']=$Unloading_Goods_ID[$i];
                    $ship['Client']=$Client[$i];
                    $ship['RecivedShipment']=$ID;
                        $ship['PayShip']=$PayShip[$i];
                    RecivedShipmentGoods::create($ship);
                    
         
                $Shipment=Shipment::find($Shipment_ID[$i]);
                $ShipmentUnload=UnloadingShipmentsGoods::find($Unloading_Goods_ID[$i]);

                    
            
            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=request('Date');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=$status;
            $move['Status_Code']=$status;
            $move['Delegate']=request('Delegate');
            $move['Driver']=request('Driver');
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$Shipment_ID[$i];
            $move['Shipment_Dist_ID']=null;
            $move['Shipment_Unload_ID']=$ShipmentUnload->ShipmentsUnloading;
            $move['Shipment_Recived_ID']=$ID;
            ShipmentMoves::create($move);

                
        Shipment::where('id',$Shipment_ID[$i])->update(['Status'=>$status]);        
        UnloadingShipmentsGoods::where('id',$Unloading_Goods_ID[$i])->update(['Status'=>1]);        
                
       
                               //Qyood

            if($status == 7){
            if($Res[$i] != 0){
            
                
                   
            $Cust=Customers::find($Shipment->Received);
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Total_Price=$Res[$i];
                $CodeBill=request('CodeX');
            $service->ShippingRecivedJoun($client, $Draw,$Coin ,$Safe, $Total_Price,$CodeBill);
  
                
                
                
          
            }
            }
            
            
             
                    
                    
    
                }
                
                
                
            }
           

        
   
            
            
                     $dataUser=[
               'screen_ar'=>'تسليم الشحنات',
                'screen_en'=>'Recived Shipments',
                'explain_ar'=>$ID,
                'explain_en'=>$ID,
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('UnloadingShipmentsSechdule');


        }catch(\Exception $ex){

            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    public function DeliveredShipmentToClient($id,ShippingService $service){

        try {
            DB::beginTransaction();

            $item=RecivedShipmentGoods::find($id);
            
           
            Shipment::where('id',$item->Shipment_ID)->update(['Status'=>7]);       
            
            
            
                
           $Shipment=Shipment::find($item->Shipment_ID);

            $move['Code']=$Shipment->Code;
            $move['Barcode']=$Shipment->Barcode;
            $move['Date']=date('Y-m-d');
            $move['Time']=date('H:i:s');
            $move['Sender']=$Shipment->Sender;
            $move['Sender_Name']=$Shipment->Sender_Name;
            $move['Reciver']=$Shipment->Received;
            $move['Reciver_Name']=$Shipment->Receiver_Name;
            $move['Status']=7;
            $move['Status_Code']=7;
            $move['Delegate']=$Shipment->Delegate;
            $move['Driver']=$Shipment->Driver;
            $move['Note']=$Shipment->Note;
            $move['User']=auth()->guard('admin')->user()->id;
            $move['Shipment_ID']=$item->Shipment_ID;
            $move['Shipment_Recived_ID']=$item->RecivedShipment;
            ShipmentMoves::create($move);

            RecivedShipmentGoods::where('id',$id)->update(['Status'=>1]);
                
            
            
            
               $CountAll=RecivedShipmentGoods::where('RecivedShipment',$item->RecivedShipment)->count();
               $CountStatus=RecivedShipmentGoods::where('RecivedShipment',$item->RecivedShipment)->where('Status',1)->count();
            
            if($CountAll  == $CountStatus){
                
                
                        RecivedShipment::where('id',$item->RecivedShipment)->update(['Status'=>1]);
                
                
            }
            
            
            
             

            if($item->PayShip != 0){
            if($item->PayShip != ''){
                
                   
            $Cust=Customers::find($Shipment->Sender);
                $client=$Cust->Account;
                $Draw=$item->RecivedShipment()->first()->Draw;
                $Coin=$item->RecivedShipment()->first()->Coin;
                $Safe=$item->RecivedShipment()->first()->Safe;
                $Total_Price=$item->PayShip;
                $CodeBill=$item->RecivedShipment()->first()->Code;
            $service->ShippingRecivedJoun($client, $Draw,$Coin ,$Safe, $Total_Price,$CodeBill);
  
                
                
                
            }
            }


            
            

                     
                $dataUser=[
               'screen_ar'=>'تسليم الشحنات',
                'screen_en'=>'Recived Shipments',
                'type_ar'=>'تم التوصيل للعميل',
                'type_en'=>'Delivered to Client',
                'explain_ar'=>$item->Code,
                'explain_en'=>$item->Code,
            ];
            $this->UserCustomMoves($dataUser);



            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RecivedShipment::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


        public function PrintRecivedShipmentsDet($id){

        $item=RecivedShipmentGoods::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintRecivedShipmentsDet',get_defined_vars());
    }

    
    
    
    
// ===========   Filters  =======================

    public function DelegatesShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = Employess::latest('id')->type()->where('Emp_Type','Saller')->pluck("Name","id");
        }else{
            $states = Employess::latest('id')->type()->where('Emp_Type','Saller')->pluck("NameEn","id");

        }
        return response()->json($states);

    }

      public function DriversShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = Employess::latest('id')->where('Emp_Type','Driver')->pluck("Name","id");
        }else{
            $states = Employess::latest('id')->where('Emp_Type','Driver')->pluck("NameEn","id");

        }
        return response()->json($states);

    }


    public function DelegatesShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = Employess::orderBy('id','asc')

                ->where('Name','ILIKE', "%{$id}%")
                ->type()
                ->where('Emp_Type','Saller')
                ->pluck("Name","id");
        }else{

            $states = Employess::orderBy('id','asc')

                ->where('NameEn','ILIKE', "%{$id}%")
                ->type()
                ->where('Emp_Type','Saller')
                ->pluck("NameEn","id");

        }

        return response()->json($states);

    }


    public function DriversShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = Employess::orderBy('id','asc')

                ->where('Name','ILIKE', "%{$id}%")
                
                ->where('Emp_Type','Driver')
                ->pluck("Name","id");
        }else{

            $states = Employess::orderBy('id','asc')

                ->where('NameEn','ILIKE', "%{$id}%")
                
                ->where('Emp_Type','Driver')
                ->pluck("NameEn","id");

        }

        return response()->json($states);

    }


    public function SenderShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = Customers::orderBy('id','asc')->pluck("Name","id");
        }else{

            $states = Customers::orderBy('id','asc')->pluck("NameEn","id");
        }
        return response()->json($states);

    }


    public function SenderShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = Customers::orderBy('id','asc')
                ->where('Name','ILIKE', "%{$id}%")
                ->pluck("Name","id");
        }else{

            $states = Customers::orderBy('id','asc')
                ->where('NameEn','ILIKE', "%{$id}%")
                ->pluck("NameEn","id");

        }
        return response()->json($states);

    }


    public function RecivedShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = Customers::orderBy('id','asc')->pluck("Name","id");
        }else{

            $states = Customers::orderBy('id','asc')->pluck("NameEn","id");
        }
        return response()->json($states);

    }


    public function RecivedShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = Customers::orderBy('id','asc')
                ->where('Name','ILIKE', "%{$id}%")
                ->pluck("Name","id");
        }else{

            $states = Customers::orderBy('id','asc')
                ->where('NameEn','ILIKE', "%{$id}%")
                ->pluck("NameEn","id");

        }
        return response()->json($states);

    }


    public function GovShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = Governrate::orderBy('id','asc')->pluck("Arabic_Name","id");
        }else{

            $states = Governrate::orderBy('id','asc')->pluck("English_Name","id");
        }
        return response()->json($states);

    }

    public function GovShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = Governrate::orderBy('id','asc')
                ->where('Arabic_Name','ILIKE', "%{$id}%")
                ->pluck("Arabic_Name","id");
        }else{

            $states = Governrate::orderBy('id','asc')
                ->where('English_Name','ILIKE', "%{$id}%")
                ->pluck("English_Name`","id");

        }
        return response()->json($states);

    }


    
    public function Cost_CenterShippingFilter() {

        if(app()->getLocale() == 'ar' ){
            $states = CostCenter::orderBy('id','asc')->pluck("Arabic_Name","id");
        }else{

            $states = CostCenter::orderBy('id','asc')->pluck("English_Name","id");
        }
        return response()->json($states);

    }

     public function Cost_CenterShippingFilterJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = CostCenter::orderBy('id','asc')
                ->where('Arabic_Name','ILIKE', "%{$id}%")
                ->pluck("Arabic_Name","id");
        }else{

            $states = CostCenter::orderBy('id','asc')
                ->where('English_Name','ILIKE', "%{$id}%")
                ->pluck("English_Name`","id");

        }
        return response()->json($states);

    }

     public function NewAllShippingCars(Request $request) {
        $term = $request->input('term');


        $query = CarShipping::query();

        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        }

        return response()->json($states);
    }
     
     public function NewAllWorkersEmployees(Request $request) {
        $term = $request->input('term');


        $query = Employess::type()->where('Emp_Type','Worker');

        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }

        return response()->json($states);
    }
      
      


//Sender Data
    public function SenderDataFilter() {


        $sender=request('Sender');

        $cust = Customers::find($sender);




        if(!empty($cust->Governrate()->first()->Arabic_Name)) {

            $GOVNAME=$cust->Governrate()->first()->Arabic_Name;

        }else{

            $GOVNAME='';

        }

        if(!empty($cust->City()->first()->Arabic_Name)) {

            $CITYNAME=$cust->City()->first()->Arabic_Name;

        }else{

            $CITYNAME='';

        }

        if(!empty($cust->Place()->first()->Arabic_Name)) {

            $PLACENAME=$cust->Place()->first()->Arabic_Name;

        }else{

            $PLACENAME='';

        }






            $states = [

                'name'=>$cust->Name,
                'phone'=>$cust->Phone,
                'phoneT'=>$cust->Phone2,
                'address'=>$cust->Address,
                'location'=>$cust->Lat.$cust->Lang,
                'GovVal'=>$cust->Governrate,
                'GovName'=>$GOVNAME,
                'CityVal'=>$cust->City,
                'CityName'=>$CITYNAME,
                'PlaceVal'=>$cust->Place,
                'PlaceName'=>$PLACENAME,

            ];

        return response()->json($states);

    }
    public function ReciverDataFilter() {


        $sender=request('Received');

        $cust = Customers::find($sender);




        if(!empty($cust->Governrate()->first()->Arabic_Name)) {

            $GOVNAME=$cust->Governrate()->first()->Arabic_Name;

        }else{

            $GOVNAME='';

        }

        if(!empty($cust->City()->first()->Arabic_Name)) {

            $CITYNAME=$cust->City()->first()->Arabic_Name;

        }else{

            $CITYNAME='';

        }

        if(!empty($cust->Place()->first()->Arabic_Name)) {

            $PLACENAME=$cust->Place()->first()->Arabic_Name;

        }else{

            $PLACENAME='';

        }






            $states = [

                'name'=>$cust->Name,
                'phone'=>$cust->Phone,
                'phoneT'=>$cust->Phone2,
                'address'=>$cust->Address,
                'location'=>$cust->Lat.$cust->Lang,
                'GovVal'=>$cust->Governrate,
                'GovName'=>$GOVNAME,
                'CityVal'=>$cust->City,
                'CityName'=>$CITYNAME,
                'PlaceVal'=>$cust->Place,
                'PlaceName'=>$PLACENAME,

            ];

        return response()->json($states);

    }


    //Cost
    public function CityCostShipping() {

        
$To_city = request('CIITY');
$weight = request('Weight');
$Shipment_Class = request('Shipment_Class');
$From_City = request('Sender_City');

        
        if($Shipment_Class == 'Hub'){
            $delivery_cost=0;
        }
     if($Shipment_Class == 'Stored'){
            $delivery_cost=0;
        }
        
        
        
            if($Shipment_Class == 'Door'){
                
                
        $Fcost = City::where('id', $From_City)->value('Ship_Price');        
        $Tcost = City::where('id', $To_city)->value('Ship_Price');        

            $delivery_cost= $Fcost + $Tcost;
        }
            
            if($Shipment_Class == 'HubToDoor'){

        $Tcost = City::where('id', $To_city)->value('Ship_Price');        

            $delivery_cost=  $Tcost;
        }
            
            if($Shipment_Class == 'DoorToHub'){
                
                
        $Fcost = City::where('id', $From_City)->value('Ship_Price');        
       

            $delivery_cost= $Fcost ;
        }
        
 
$cost = ShippingPrices::where('City', $To_city)
    ->where('From', '<=', $weight)
    ->where('To', '>=', $weight)
    ->value('Price');

$cost = $cost ?? 0;


$states = [
    'cost' => $cost,
    'delivery_cost' => $delivery_cost,
];

return response()->json($states);


    }

    //New Client
    public function AddNewClientShipping(Request $request){

        $data= $this->validate(request(),[
            'Name'=>'required|unique:customers',
        ],[
            'Name.required' => trans('admin.NameRequired'),
        ]);



        $Name=request('Name');
        $PriceLevel=1;
        $Phone =request('Phone1')  ;
        $Phone2 =request('Phone2')  ;
        $NameEn =request('Name') ;
        $Address =request('Address') ;
        $Governrate =request('Governrate') ;
        $City =request('City') ;
        $Place =request('Place') ;



        $Acc=$this->CreateAccount($Name,$NameEn ,24 ,null);


        $CodeUser=$this->ReturnCode(Customers::class);


        $data['Code']=$CodeUser;
        $data['Date']=date('Y-m-d');
        $data['Name']=$Name;
        $data['NameEn']=$NameEn;
        $data['Phone']=$Phone;
        $data['Phone2']=$Phone2;
        $data['Address']=$Address;
        $data['Governrate']=$Governrate;
        $data['City']=$City;
        $data['Place']=$Place;
        $data['Price_Level']=$PriceLevel;
        $data['Account']=$Acc;
        $data['User']=auth()->guard('admin')->user()->id;

        if(auth()->guard('admin')->user()->emp != 0){
            $data['Responsible']=auth()->guard('admin')->user()->emp;
        }else{
            $data['Responsible']=null;
        }

        Customers::create($data);

        $dataUser=[
            'screen_ar'=>'العملاء',
            'screen_en'=>'Clients',
            'explain_ar'=>$Name,
            'explain_en'=>$NameEn,
        ];
        $this->UserCreateMoves($dataUser);


        $states=['SUCEESS'=>'SUCEESS'];
        return response()->json($states);

    }
    
    //New Recived
    public function AddNewRecivedShipping(Request $request){

        $data= $this->validate(request(),[
            'Name'=>'required|unique:customers',
        ],[
            'Name.required' => trans('admin.NameRequired'),
        ]);



        $Name=request('Name');
        $PriceLevel=1;
        $Phone =request('Phone1')  ;
        $Phone2 =request('Phone2')  ;
        $NameEn =request('Name') ;
        $Address =request('Address') ;
        $Governrate =request('Governrate') ;
        $City =request('City') ;
        $Place =request('Place') ;


                   $data['Arabic_Name']=$Name;
            $data['English_Name']=$NameEn;
            $data['Phone']=$Phone;
            $data['Phone2']=$Phone2;
            $data['Gov']=$Governrate;
            $data['City']=$City;
            $data['Place']=$Place;
            $data['Address']=$Address;
            $data['Client']=request('Sender');
            TransportReceiver::create($data);




        $states=['SUCEESS'=>'SUCEESS'];
        return response()->json($states);

    }




    // =-================  Transport  =====================


    //====== Transport Contractors =======
    public function TransportContractors(){
        $items=TransportContractors::all();
        $Governrates=Governrate::all();
        return view('admin.Shipping.TransportContractors',get_defined_vars());
    }

    public function AddTransportContractors(Request $request){

        try {
            DB::beginTransaction();

 
            //2535 da 7sab el r2esy bta3 msaref syrat f DB elly fadya enma f Default 2813
          $Acc=$this->CreateAccount(request('Arabic_Name'),request('English_Name') ,2535,null);
            
        
            $merit_Account=AcccountingManual::where('Code',210)->orderBy('id','desc')->first();
            $AccMerit=$this->CreateAccount(request('Arabic_Name').' استحقاق مقاول  ',request('English_Name').' Contractor Merit  ' ,$merit_Account->id ,null);

            $data['Merit_Account']=$AccMerit;    
            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Phone']=request('Phone');
            $data['Gov']=request('Gov');
            $data['City']=request('City');
            $data['Place']=request('Place');
            $data['Account']=$Acc;

            TransportContractors::create($data);

            $dataUser=[
                'screen_ar'=>'مقاولين النقل',
                'screen_en'=>'Transport Contractors',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTransportContractors($id,Request $request){

        try {
            DB::beginTransaction();

            
            
            $CAR=TransportContractors::find($id);
            $dataX['Name']=request('Arabic_Name');
            $dataX['NameEn']=request('English_Name');
            AcccountingManual::where('id',$CAR->Account)->update($dataX);
                 
            $CAR=TransportContractors::find($id);
            $dataX['Name']=request('Arabic_Name').' استحقاق مقاول  ';
            $dataX['NameEn']=request('English_Name').' Contractor Merit  ';
            AcccountingManual::where('id',$CAR->Merit_Account)->update($dataX);
         
            
        
           $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Phone']=request('Phone');
            $data['Gov']=request('Gov');
            $data['City']=request('City');
            $data['Place']=request('Place');
            TransportContractors::where('id',$id)->update($data);

            $dataUser=[
           'screen_ar'=>'مقاولين النقل',
                'screen_en'=>'Transport Contractors',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteTransportContractors($id){

        try {
            DB::beginTransaction();

            $del=TransportContractors::find($id);

            AcccountingManual::where('id',$del->Account)->delete();
            AcccountingManual::where('id',$del->Merit_Account)->delete();

            
            $dataUser=[
                 'screen_ar'=>'مقاولين النقل',
                'screen_en'=>'Transport Contractors',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportContractors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

  
    //====== Transport Prices =======
    public function TransportPrices(){
        $items=TransportPrices::all();
                $Places=Places::all();
        return view('admin.Shipping.TransportPrices',get_defined_vars());
    }

    public function AddTransportPrices(Request $request){

        try {
            DB::beginTransaction();

           

     
            $data['From_Place']=request('From_Place');
            $data['To_Place']=request('To_Place');
            $data['Value']=request('Value');
  

            TransportPrices::create($data);

            $dataUser=[
                'screen_ar'=>'اسعار النقل',
                'screen_en'=>'Transport Prices',
                'explain_ar'=>'',
                'explain_en'=>'',
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTransportPrices($id,Request $request){

        try {
            DB::beginTransaction();

            
            
                   $data['From_Place']=request('From_Place');
            $data['To_Place']=request('To_Place');
            $data['Value']=request('Value');
  

        

  
            TransportPrices::where('id',$id)->update($data);

               $dataUser=[
                'screen_ar'=>'اسعار النقل',
                'screen_en'=>'Transport Prices',
                'explain_ar'=>'',
                'explain_en'=>'',
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteTransportPrices($id){

        try {
            DB::beginTransaction();

            $del=TransportPrices::find($id);


                   $dataUser=[
                'screen_ar'=>'اسعار النقل',
                'screen_en'=>'Transport Prices',
                'explain_ar'=>'',
                'explain_en'=>'',
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportPrices::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
    //====== Transport Reciver =======
    public function TransportReceiver(){
        $items=TransportReceiver::all();
                $Governrates=Governrate::all();
                $Clients=Customers::all();
        return view('admin.Shipping.TransportReceiver',get_defined_vars());
    }

    public function AddTransportReceiver(Request $request){

        try {
            DB::beginTransaction();

           

     
            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Phone']=request('Phone');
            $data['Phone2']=request('Phone2');
            $data['Gov']=request('Gov');
            $data['City']=request('City');
            $data['Place']=request('Place');
            $data['Address']=request('Address');
            $data['Location']=request('Location');
            $data['Client']=request('Client');
            TransportReceiver::create($data);

            $dataUser=[
                'screen_ar'=>'مستلمين النقل',
                'screen_en'=>'Transport Reciver',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTransportReceiver($id,Request $request){

        try {
            DB::beginTransaction();

            
            
      
  
  

                    $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Phone']=request('Phone');
            $data['Phone2']=request('Phone2');
            $data['Gov']=request('Gov');
            $data['City']=request('City');
            $data['Place']=request('Place');
            $data['Address']=request('Address');
            $data['Location']=request('Location');
            $data['Client']=request('Client');
          TransportReceiver::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'مستلمين النقل',
                'screen_en'=>'Transport Reciver',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteTransportReceiver($id){

        try {
            DB::beginTransaction();

            $del=TransportReceiver::find($id);


             $dataUser=[
                'screen_ar'=>'مستلمين النقل',
                'screen_en'=>'Transport Reciver',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TransportReceiver::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

  
    
    //Transport
    
     public function TransportSechdule(){

  
         
         
                  
               if(auth()->guard('admin')->user()->emp != 0){
                   
   
                   
                      $items=Transport::latest('id')
                          
                        ->where('Driver',auth()->guard('admin')->user()->emp)        
                          
                          ->paginate(20);   
                   
                   
                   
               }else{
                   
                 $items=Transport::latest('id')->paginate(20);    
                   
               }
    
         
         
         
         
         $Customers=Customers::all();
         $TransportReceiver=TransportReceiver::all();

        return view('admin.Shipping.TransportSechdule',get_defined_vars());
    }
       
     public function FilterTransportSechdule(){

      
         $Customers=Customers::all();
         $TransportReceiver=TransportReceiver::all();
         
           $From=request('From');
           $To=request('To');
           $Sender=request('Sender');
           $Receiver=request('Receiver');
           $Payment_Method=request('Payment_Method');
           $Arrival_Date=request('Arrival_Date');
           $Code=request('Code');
         
         
                     if(auth()->guard('admin')->user()->emp != 0){
       
                              $items=Transport::latest('id')
               
        ->where('Driver',auth()->guard('admin')->user()->emp)                
   
   ->when(!empty($From), function ($query) use ($From,$To) {
        return $query->whereBetween('Date', [$From,$To]);
    })
         
                
            
  ->when(!empty($Sender), function ($query) use ($Sender) {
        return $query->where('Sender', $Sender);
    })
         
                    
            
  ->when(!empty($Receiver), function ($query) use ($Receiver) {
        return $query->where('Received', $Receiver);
    })
               
               
  ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
        return $query->where('Payment_Method', $Payment_Method);
    })
            
                   
  ->when(!empty($Arrival_Date), function ($query) use ($Arrival_Date) {
        return $query->where('Arrival_Date', $Arrival_Date);
    })
            
                   
  ->when(!empty($Code), function ($query) use ($Code) {
        return $query->where('Code', $Code);
    })
            
               
               
               
               
               ->paginate(20);
                   
                   
                   
               }else{
                   
            $items=Transport::latest('id')
               
               
   
   ->when(!empty($From), function ($query) use ($From,$To) {
        return $query->whereBetween('Date', [$From,$To]);
    })
         
                
            
  ->when(!empty($Sender), function ($query) use ($Sender) {
        return $query->where('Sender', $Sender);
    })
         
                    
            
  ->when(!empty($Receiver), function ($query) use ($Receiver) {
        return $query->where('Received', $Receiver);
    })
               
               
  ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
        return $query->where('Payment_Method', $Payment_Method);
    })
            
                   
  ->when(!empty($Arrival_Date), function ($query) use ($Arrival_Date) {
        return $query->where('Arrival_Date', $Arrival_Date);
    })
            
                   
  ->when(!empty($Code), function ($query) use ($Code) {
        return $query->where('Code', $Code);
    })
            
               
               
               
               
               ->paginate(20);
                   
               }
    
         
         
         
         
      

        return view('admin.Shipping.TransportSechdule',get_defined_vars());
    }
    
    public function PrintTransport($id){

        $item=Transport::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintTransport',get_defined_vars());
    }
    
    public function Transport(){

        $Code=$this->ReturnCode(Transport::class);
        
        $Def=ShippingDefault::latest('id')->first();
        return view('admin.Shipping.Transport',get_defined_vars());
    }

    public function AddNewTransport(Request $request,ShippingService $service){
        
        
           $data= $this->validate(request(),[
                'Date'=>'required',
                'Payment_Method'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Value'=>'required',
                'Type'=>'required',

            ]);

        try {
            DB::beginTransaction();

         


            $data['Date']=request('Date');
            $data['Time']=date('H:i:s');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Insurance']=request('Insurance');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Cost_Center']=request('Cost_Center');
            $data['Value']=request('Value');
            $data['Type']=request('Type');
            $data['Car']=request('Car');
            $data['Driver_Precent']=request('Driver_Precent');
            $data['Driver_Value']=request('Driver_Value');
            $data['Contractor']=request('Contractor');
            $data['Contractor_Precent']=request('Contractor_Precent');
            $data['Contractor_Value']=request('Contractor_Value');
            $data['Expenses_Precent']=request('Expenses_Precent');
            $data['Expenses_Value']=request('Expenses_Value');
            $data['The_Net']=request('The_Net');
        
            Transport::create($data);


            $last=Transport::latest('id')->first()->id;



 
            
            if(request('Payment_Method') == 'Later'){
                
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounLater($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
              
                
            }else{
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounCash($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
            
                
                
            }
     
            
            

                $dataUser=[
                'screen_ar'=>'النقل',
                'screen_en'=>'Transport',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
          
            
            
                    if(request('Status') == 1){
                
                  return back();
                
            }
                
            if(request('Status') == 2){
                
             return redirect('PrintTransport/'.$last);
                
            }
   
            



        }catch(\Exception $ex){

            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteTransport($id){

        try {
            DB::beginTransaction();

            $del=Transport::find($id);

            

     GeneralDaily::where('Code_Type',$del->Code)->where('Type','مبيعات نقل')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','مبيعات نقل')->update(['Delete'=>1]);
            
        
            
                 $dataUser=[
                'screen_ar'=>'النقل',
                'screen_en'=>'Transport',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);



            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTransport($id){

        $item=Transport::find($id);
        
        return view('admin.Shipping.EditTransport',get_defined_vars());
    }

    public function PostEditTransport(Request $request,ShippingService $service){
        
            $data= $this->validate(request(),[
                'Date'=>'required',
                'Payment_Method'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Value'=>'required',
                'Type'=>'required',

            ]);


        try {
            DB::beginTransaction();

      
           $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Insurance']=request('Insurance');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Cost_Center']=request('Cost_Center');
            $data['Value']=request('Value');
            $data['Type']=request('Type');
            $data['Car']=request('Car');
            $data['Driver_Precent']=request('Driver_Precent');
            $data['Driver_Value']=request('Driver_Value');
            $data['Contractor']=request('Contractor');
            $data['Contractor_Precent']=request('Contractor_Precent');
            $data['Contractor_Value']=request('Contractor_Value');
            $data['Expenses_Precent']=request('Expenses_Precent');
            $data['Expenses_Value']=request('Expenses_Value');
            $data['The_Net']=request('The_Net');

            Transport::where('id',request('ID'))->update($data);


                      $del=Transport::find(request('ID'));
     GeneralDaily::where('Code_Type',$del->Code)->where('Type','مبيعات نقل')->delete();
     Journalizing::where('Code_Type',$del->Code)->where('Type','مبيعات نقل')->update(['Delete'=>1]);
            
         
    
            if(request('Payment_Method') == 'Later'){
                
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounLater($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
              
                
            }else{
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounCash($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
            
                
                
            }
     
            
           $dataUser=[
                'screen_ar'=>'النقل',
                'screen_en'=>'Transport',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ShipmentSechdule');


        }catch(\Exception $ex){

            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

       public function NewAllCars(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = CarShipping::query();

           

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        }

        return response()->json($states);
    }
      
       public function NewAllContractor(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = TransportContractors::query();

           

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

        return response()->json($states);
    }
     
        public function SenderDataTransportFilter() {


        $sender=request('Sender');

        $cust = Customers::find($sender);




        if(!empty($cust->Governrate()->first()->Arabic_Name)) {

            $GOVNAME=$cust->Governrate()->first()->Arabic_Name;

        }else{

            $GOVNAME='';

        }

        if(!empty($cust->City()->first()->Arabic_Name)) {

            $CITYNAME=$cust->City()->first()->Arabic_Name;

        }else{

            $CITYNAME='';

        }

        if(!empty($cust->Place()->first()->Arabic_Name)) {

            $PLACENAME=$cust->Place()->first()->Arabic_Name;

        }else{

            $PLACENAME='';

        }




            $RECIVER=TransportReceiver::where('Client',$sender)->pluck('Arabic_Name','id');


            $states = [

                'name'=>$cust->Name,
                'phone'=>$cust->Phone,
                'phoneT'=>$cust->Phone2,
                'address'=>$cust->Address,
                'location'=>$cust->Lat.$cust->Lang,
                'GovVal'=>$cust->Governrate,
                'GovName'=>$GOVNAME,
                'CityVal'=>$cust->City,
                'CityName'=>$CITYNAME,
                'PlaceVal'=>$cust->Place,
                'PlaceName'=>$PLACENAME,
                'RECIVER'=>$RECIVER,

            ];

        return response()->json($states);

    }
    
    public function ReciverDataTransportFilter() {


        $sender=request('Received');

        $cust = TransportReceiver::find($sender);



        if(!empty($cust->Gov()->first()->Arabic_Name)) {

            $GOVNAME=$cust->Gov()->first()->Arabic_Name;

        }else{

            $GOVNAME='';

        }

        if(!empty($cust->City()->first()->Arabic_Name)) {

            $CITYNAME=$cust->City()->first()->Arabic_Name;

        }else{

            $CITYNAME='';

        }

        if(!empty($cust->Place()->first()->Arabic_Name)) {

            $PLACENAME=$cust->Place()->first()->Arabic_Name;

        }else{

            $PLACENAME='';

        }






            $states = [

                'name'=>$cust->Arabic_Name,
                'phone'=>$cust->Phone,
                'phoneT'=>$cust->Phone2,
                'address'=>$cust->Address,
                'location'=>$cust->Location,
                'GovVal'=>$cust->Gov,
                'GovName'=>$GOVNAME,
                'CityVal'=>$cust->City,
                'CityName'=>$CITYNAME,
                'PlaceVal'=>$cust->Place,
                'PlaceName'=>$PLACENAME,

            ];

        return response()->json($states);

    }
    
    public function TransportPriceFilter() {


        $Sender_Place=request('Sender_Place');
        $Receiver_Place=request('Receiver_Place');

        $Value = TransportPrices::where('From_Place',$Sender_Place)->where('To_Place',$Receiver_Place)->first()->Value;

        if(empty($Value)){
            
          $Value=0;  
        }
        
            $states = [

                'Value'=>$Value,
             

            ];

        return response()->json($states);

    }
    
    public function DriverPrecentFilter() {


        $Driver=request('Driver');
        $Expenses_Value=(float)request('Expenses_Value');


        
        
                $delegate=Employess::find($Driver);
        
        
        if($delegate->ShippingCollectionType == 0){
            
             $result=$delegate->ShippingCollectionValue;
            
        }else{
            
            
            
              $Rate=EmpRatio::where('Emp',$Driver)
                 ->where('Typee',4)
                 ->where('From', '<=', $Expenses_Value)
                  ->where('To', '>=', $Expenses_Value)
                  ->value('Rate');
            
            
//            $One=$Rate / 100 ;
            
//            $result=$Expenses_Value * $One ;
            $result=$Rate ;
        
            
        }
        
        
            $states = [

                'precent'=>$result,
             

            ];

        return response()->json($states);

    }


    
    
        //RqstTransport
    
     public function RqstTransportSechdule(){

  
         
         
                  
               if(auth()->guard('admin')->user()->emp != 0){
                   
   
                   
                      $items=RqstTransport::latest('id')
                          
                        ->where('Driver',auth()->guard('admin')->user()->emp)        
                          
                          ->paginate(20);   
                   
                   
                   
               }else{
                   
                 $items=RqstTransport::latest('id')->paginate(20);    
                   
               }
    
         
         
         
         
         $Customers=Customers::all();
         $TransportReceiver=TransportReceiver::all();

        return view('admin.Shipping.RqstTransportSechdule',get_defined_vars());
    }
    
    public function PrintRqstTransport($id){

        $item=RqstTransport::find($id);
        $Def=CompanyData::latest()->first();
        return view('admin.Shipping.PrintRqstTransport',get_defined_vars());
    }
    
    public function RqstTransport(){

        $Code=$this->ReturnCode(RqstTransport::class);
        
        $Def=ShippingDefault::latest('id')->first();
        return view('admin.Shipping.RqstTransport',get_defined_vars());
    }

    public function AddNewRqstTransport(Request $request,ShippingService $service){
        
        
           $data= $this->validate(request(),[
                'Date'=>'required',
                'Payment_Method'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Value'=>'required',
                'Type'=>'required',

            ]);

        try {
            DB::beginTransaction();

         


            $data['Date']=request('Date');
            $data['Time']=date('H:i:s');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Insurance']=request('Insurance');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Cost_Center']=request('Cost_Center');
            $data['Value']=request('Value');
            $data['Type']=request('Type');
            $data['Car']=request('Car');
            $data['Driver_Precent']=request('Driver_Precent');
            $data['Driver_Value']=request('Driver_Value');
            $data['Contractor']=request('Contractor');
            $data['Contractor_Precent']=request('Contractor_Precent');
            $data['Contractor_Value']=request('Contractor_Value');
            $data['Expenses_Precent']=request('Expenses_Precent');
            $data['Expenses_Value']=request('Expenses_Value');
            $data['The_Net']=request('The_Net');
            $data['Transfer']=0;
        
            RqstTransport::create($data);


            $last=RqstTransport::latest('id')->first()->id;





                $dataUser=[
                 'screen_ar'=>'طلب نقل',
                'screen_en'=>'Rqst Transport',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
          
            
            
                    if(request('Status') == 1){
                
                  return back();
                
            }
                
            if(request('Status') == 2){
                
             return redirect('PrintTransport/'.$last);
                
            }
   
            



        }catch(\Exception $ex){

            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteRqstTransport($id){

        try {
            DB::beginTransaction();

            $del=RqstTransport::find($id);

            
                 $dataUser=[
                 'screen_ar'=>'طلب نقل',
                'screen_en'=>'Rqst Transport',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);



            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditRqstTransport($id){

        $item=RqstTransport::find($id);
        
        return view('admin.Shipping.EditRqstTransport',get_defined_vars());
    }

    public function PostEditRqstTransport(Request $request,ShippingService $service){
        
            $data= $this->validate(request(),[
                'Date'=>'required',
                'Payment_Method'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Value'=>'required',
                'Type'=>'required',

            ]);


        try {
            DB::beginTransaction();

      
           $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Insurance']=request('Insurance');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Cost_Center']=request('Cost_Center');
            $data['Value']=request('Value');
            $data['Type']=request('Type');
            $data['Car']=request('Car');
            $data['Driver_Precent']=request('Driver_Precent');
            $data['Driver_Value']=request('Driver_Value');
            $data['Contractor']=request('Contractor');
            $data['Contractor_Precent']=request('Contractor_Precent');
            $data['Contractor_Value']=request('Contractor_Value');
            $data['Expenses_Precent']=request('Expenses_Precent');
            $data['Expenses_Value']=request('Expenses_Value');
            $data['The_Net']=request('The_Net');

            RqstTransport::where('id',request('ID'))->update($data);


     
         
    
    
            
           $dataUser=[
                'screen_ar'=>'طلب نقل',
                'screen_en'=>'Rqst Transport',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ShipmentSechdule');


        }catch(\Exception $ex){

            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RqstTransport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    
        public function TransferToTransport($id){

        $item=RqstTransport::find($id);
        
        return view('admin.Shipping.TransferToTransport',get_defined_vars());
    }

        public function AddNewTransferTransport(Request $request,ShippingService $service){
        
        
           $data= $this->validate(request(),[
                'Date'=>'required',
                'Payment_Method'=>'required',
                'Sender_Name'=>'required',
                'Sender_Governorate'=>'required',
                'Sender_City'=>'required',
                'Sender_Place'=>'required',
                'Sender_Address'=>'required',
                'Sender_Phone1'=>'required',
                'Receiver_Name'=>'required',
                'Receiver_Governorate'=>'required',
                'Receiver_City'=>'required',
                'Receiver_Place'=>'required',
                'Receiver_Address'=>'required',
                'Receiver_Phone1'=>'required',
                'Sender'=>'required',
                'Received'=>'required',
                'Value'=>'required',
                'Type'=>'required',

            ]);

        try {
            DB::beginTransaction();

         RqstTransport::where('id',request('ID'))->update(['Transfer'=>1]);


            $data['Date']=request('Date');
            $data['Time']=date('H:i:s');
            $data['Arrival_Date']=request('Arrival_Date');
            $data['Arrival_Time']=request('Arrival_Time');
            $data['Reference_Num']=request('Reference_Num');
            $data['Weight']=request('Weight');
            $data['Note']=request('Note');
            $data['Payment_Method']=request('Payment_Method');
            $data['Insurance']=request('Insurance');
            $data['Sender_Name']=request('Sender_Name');
            $data['Sender_Governorate']=request('Sender_Governorate');
            $data['Sender_City']=request('Sender_City');
            $data['Sender_Place']=request('Sender_Place');
            $data['Sender_Address']=request('Sender_Address');
            $data['Sender_Phone1']=request('Sender_Phone1');
            $data['Sender_Phone2']=request('Sender_Phone2');
            $data['Sender_Location']=request('Sender_Location');
            $data['Receiver_Name']=request('Receiver_Name');
            $data['Receiver_Governorate']=request('Receiver_Governorate');
            $data['Receiver_City']=request('Receiver_City');
            $data['Receiver_Place']=request('Receiver_Place');
            $data['Receiver_Address']=request('Receiver_Address');
            $data['Receiver_Phone1']=request('Receiver_Phone1');
            $data['Receiver_Phone2']=request('Receiver_Phone2');
            $data['Receiver_Location']=request('Receiver_Location');
            $data['Driver']=request('Driver');
            $data['Sender']=request('Sender');
            $data['Received']=request('Received');
            $data['Pay']=request('Pay');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Draw']=request('Draw');
            $data['Cost_Center']=request('Cost_Center');
            $data['Value']=request('Value');
            $data['Type']=request('Type');
            $data['Car']=request('Car');
            $data['Driver_Precent']=request('Driver_Precent');
            $data['Driver_Value']=request('Driver_Value');
            $data['Contractor']=request('Contractor');
            $data['Contractor_Precent']=request('Contractor_Precent');
            $data['Contractor_Value']=request('Contractor_Value');
            $data['Expenses_Precent']=request('Expenses_Precent');
            $data['Expenses_Value']=request('Expenses_Value');
            $data['The_Net']=request('The_Net');
        
            Transport::create($data);


            $last=Transport::latest('id')->first()->id;



 
            
            if(request('Payment_Method') == 'Later'){
                
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounLater($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
              
                
            }else{
                
                $Cust=Customers::find(request('Sender'));
                $client=$Cust->Account;
                $Draw=request('Draw');
                $Coin=request('Coin');
                $Safe=request('Safe');
                $Pay=request('Pay');
                $Value=request('Value');
                $CodeBill=request('Code');
                $Driver=request('Driver');
                $Driver_Value=request('Driver_Value');
                $Contractor=request('Contractor');
                $Contractor_Value=request('Contractor_Value');
                $Type=request('Type');
            $service->TransportJounCash($client, $Draw,$Coin,$Safe ,$Pay, $Value,$CodeBill,$Driver,$Driver_Value,$Contractor,$Contractor_Value,$Type);
            
                
                
            }
     
            
            

                $dataUser=[
                'screen_ar'=>'النقل',
                'screen_en'=>'Transport',
                'explain_ar'=>$last,
                'explain_en'=>$last,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
          
            
          
                
             return redirect('TransportSechdule');
                
        
   
            



        }catch(\Exception $ex){

            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Transport::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    





    
    

}
