<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use App\Models\Modules;
use App\Models\StoreCount;
class RoleController extends Controller
{

    function __construct()
    {

        $this->middleware('permission:صلاحيات المستخدمين', ['only' => ['AdminsPremationsPage','AddPrem','DeletePrem','EditPrem']]);

    }

    //Admins Premations
    public function AdminsPremationsPage(Request $request){
        $roles = Role::orderBy('id','desc')->paginate(10);


        $Modules=Modules::orderBy('id','desc')->first();
        if($Modules->Capital == 1){
            $cR=15;
        }else{
            $cR=null;

        }

        if($Modules->Accounts == 1){
            $AR=4;
            $ARR=8;
        }else{
            $AR=null;
            $ARR=null;

        }

        if($Modules->Stores == 1){
            $SR=2;
            $SRR=3;
            $SRRR=9;
            $SRRRR=6;
            $SRRRRR=7;
        }else{
            $SR=null;
            $SRR=null;
            $SRRR=null;
            $SRRRR=null;
            $SRRRRR=null;

        }

        if($Modules->CRM == 1){
            $cmR=5;
        }else{
            $cmR=null;

        }

        if($Modules->HR == 1){
            $hR=10;
            $hRReport=22;
        }else{
            $hR=null;
            $hRReport=null;

        }

        if($Modules->Manufacturing == 1){
            $mnR=14;
        }else{
            $mnR=null;

        }

        if($Modules->Maintenance == 1){
            $mR=13;
        }else{
            $mR=null;

        }

        if($Modules->Secretariat == 1){
            $SCR=16;
        }else{
            $SCR=null;

        }

        if($Modules->Petrol == 1){
            $PPP=17;
        }else{
            $PPP=null;

        }

        if($Modules->ECommerce == 1){
            $ECOM=18;
        }else{
            $ECOM=null;

        }
        if($Modules->Shipping == 1){
            $SH=19;
        }else{
            $SH=null;

        }

        if($Modules->Bill_Electronic == 1){
            $EB=20;
        }else{
            $EB=null;

        }


        if($Modules->Hotels == 1){
            $H=21;
        }else{
            $H=null;

        }
        if($Modules->Resturant == 1){
            $Rst=23;
        }else{
            $Rst=null;

        }


        if($Modules->Traning_Center == 1){
            $traning=24;
        }else{
            $traning=null;

        }

        if($Modules->Translate == 1){
            $trans=25;
        }else{
            $trans=null;

        }


        if($Modules->Real_States == 1){
            $real_state=26;
        }else{
            $real_state=null;

        }


        if($Modules->Shipping == 1){
            $ship=19;
        }else{
            $ship=null;

        }




        $permission = Permission::orderBy('Main','asc')
            ->whereIn('Main',[1,11,12,$cR,$AR,$ARR,$SR,$SRR,$SRRR,$SRRRR,$SRRRRR,$cmR,$hR,$mnR,$mR,$SCR,$PPP,$ECOM,$SH,$EB,$H,$hRReport,$Rst,$traning,$trans,$real_state,$ship])
            ->get();



        return view('admin.AdminsPremations',['roles'=>$roles,'permission'=>$permission])
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    public function AddPrem(Request $request)
    {
        
        
             $this->validate($request, [
                'name' => 'required|unique:roles,name',
                'permission' => 'required',
            ]);
        try {
            DB::beginTransaction();

            
            

       

            $role = Role::create(['name' => $request->input('name'),'nameEn' => $request->input('nameEn')]);
            $role->syncPermissions($request->input('permission'));

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeletePrem($id)
    {
        try {
            DB::beginTransaction();

            DB::table("roles")->where('id',$id)->delete();

            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    public function EditPrem(Request $request, $id)
    {
        
              $this->validate($request, [
                'name' => 'required',
                'permission' => 'required',
            ]);
        try {
            DB::beginTransaction();

      
            $role = Role::find($id);
            $role->name = $request->input('name');
            $role->nameEn = $request->input('nameEn');
            $role->save();
            $role->syncPermissions($request->input('permission'));

            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

       public function ShowAdminPrem(Request $request,$id){
        $r = Role::find($id);

        $Premis=DB::table('permissions')->where('Parent',0)->get();

        return view('admin.ShowAdminPrem',get_defined_vars());


    }


       public function EditAdminPrem(Request $request,$id){
        $r = Role::find($id);

        $Premis=DB::table('permissions')->where('Parent',0)->get();


             $Modules=Modules::orderBy('id','desc')->first();
        if($Modules->Capital == 1){
            $cR=15;
        }else{
            $cR=null;

        }

        if($Modules->Accounts == 1){
            $AR=4;
            $ARR=8;
        }else{
            $AR=null;
            $ARR=null;

        }

        if($Modules->Stores == 1){
            $SR=2;
            $SRR=3;
            $SRRR=9;
            $SRRRR=6;
            $SRRRRR=7;
        }else{
            $SR=null;
            $SRR=null;
            $SRRR=null;
            $SRRRR=null;
            $SRRRRR=null;

        }

        if($Modules->CRM == 1){
            $cmR=5;
        }else{
            $cmR=null;

        }

        if($Modules->HR == 1){
            $hR=10;
            $hRReport=22;
        }else{
            $hR=null;
            $hRReport=null;

        }

        if($Modules->Manufacturing == 1){
            $mnR=14;
        }else{
            $mnR=null;

        }

        if($Modules->Maintenance == 1){
            $mR=13;
        }else{
            $mR=null;

        }

        if($Modules->Secretariat == 1){
            $SCR=16;
        }else{
            $SCR=null;

        }

        if($Modules->Petrol == 1){
            $PPP=17;
        }else{
            $PPP=null;

        }

        if($Modules->ECommerce == 1){
            $ECOM=18;
        }else{
            $ECOM=null;

        }
        if($Modules->Shipping == 1){
            $SH=19;
        }else{
            $SH=null;

        }

        if($Modules->Bill_Electronic == 1){
            $EB=20;
        }else{
            $EB=null;

        }


        if($Modules->Hotels == 1){
            $H=21;
        }else{
            $H=null;

        }
        if($Modules->Resturant == 1){
            $Rst=23;
        }else{
            $Rst=null;

        }


        if($Modules->Traning_Center == 1){
            $traning=24;
        }else{
            $traning=null;

        }

        if($Modules->Translate == 1){
            $trans=25;
        }else{
            $trans=null;

        }


        if($Modules->Real_States == 1){
            $real_state=26;
        }else{
            $real_state=null;

        }




        $permission = Permission::orderBy('Main','asc')
            ->whereIn('Main',[1,11,12,$cR,$AR,$ARR,$SR,$SRR,$SRRR,$SRRRR,$SRRRRR,$cmR,$hR,$mnR,$mR,$SCR,$PPP,$ECOM,$SH,$EB,$H,$hRReport,$Rst,$traning,$trans,$real_state])
            ->get();

        return view('admin.EditAdminPrem',get_defined_vars());


    }






}
