<?php

namespace App\Http\Controllers;

use App\Events\SalesEvent;
use App\Events\SalesEventApi;
use App\Events\SalesOrderEvent;
use App\Http\Resources\Resturant\ResturantTablesPOSAVResources;
use App\Http\Resources\Resturant\ResturantKitchensOrdersResources;
use App\Http\Resources\Resturant\ResturantKitchensHallOrdersResources;
use App\Http\Resources\Resturant\ResturantTablesPOSResources;
use App\Http\Resources\Resturant\ResturantVAssemblyQtyFilterResources;
use App\Http\Resources\Resturant\ResturantAdditionsProductsResources;
use App\Http\Resources\Resturant\ResturantKitchensRemoveHallOrdersResources;
use App\Http\Resources\Resturant\ResturantCartResources;
use App\Http\Resources\Resturant\EmployessWitersResources;
use App\Http\Resources\Resturant\WishlistResources;
use App\Http\Resources\Resturant\AboutResources;
use App\Http\Resources\Resturant\ArticlesDetailsResources;
use App\Http\Resources\Resturant\ArticlesResources;
use App\Http\Resources\Resturant\BranchesResources;
use App\Http\Resources\Resturant\BrandsResources;
use App\Http\Resources\Resturant\CategoriesResources;
use App\Http\Resources\Resturant\MyAddressesResources;
use App\Http\Resources\Resturant\MyOrdersResources;
use App\Http\Resources\Resturant\ProductsResources;
use App\Http\Resources\Resturant\ProfileResources;
use App\Http\Resources\Resturant\ResturantGalleryResources;
use App\Http\Resources\Resturant\ResturantHomeResources;
use App\Http\Resources\Resturant\ResturantReservationsResources;
use App\Http\Resources\Resturant\ResturantReviewsResources;
use App\Http\Resources\Resturant\ResturantStyleResources;
use App\Http\Resources\Resturant\ResturantTablesResources;
use App\Http\Resources\Resturant\ResturantVideoSectionResources;
use App\Http\Resources\Resturant\SocialResources;
use App\Http\Resources\Resturant\TermsResources;
use App\Http\Resources\Resturant\DeliveryAppsResources;
use App\Http\Resources\Resturant\WebsliderResources;
use App\Http\Resources\Resturant\ResturantTablesPOSNotAVResources;
use App\Http\Resources\Resturant\ResturantProNotePOSResources;
use App\Http\Resources\SalesOrderResources;
use App\Http\Resources\SalesResources;
use App\Models\About;
use App\Models\AcccountingManual;
use App\Models\AdditionalProducts;
use App\Models\Addressses;
use App\Models\Admin;
use App\Models\AssemblyProducts;
use App\Models\Branches;
use App\Models\Coins;
use App\Models\ProNote;
use App\Models\Comments;
use App\Models\CompanyData;
use App\Models\Countris;
use App\Models\CouponCode;
use App\Models\Customers;
use App\Models\CustomersGroup;
use App\Models\DefaultDataShowHide;
use App\Models\Employess;
use App\Models\Event;
use App\Models\GeneralDaily;
use App\Models\IncomChecks;
use App\Models\Installment;
use App\Models\InstallmentCompanies;
use App\Models\InstallmentDates;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\MoreProductsHall;
use App\Models\Notifications;
use App\Models\OutcomManufacturingModel;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductSalesOrder;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductUnits;
use App\Models\Rate;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\RemoveProductsHall;
use App\Models\ResturantAbout;
use App\Models\ResturantBlogs;
use App\Models\ResturantCart;
use App\Models\ResturantCuponCode;
use App\Models\ResturantGallery;
use App\Models\ResturantHome;
use App\Models\ResturantPrivacy;
use App\Models\ResturantReservations;
use App\Models\ResturantReviews;
use App\Models\ResturantSliders;
use App\Models\ResturantSocial;
use App\Models\ResturantStyle;
use App\Models\ResturantTables;
use App\Models\ResturantTerms;
use App\Models\ResturantVideoSection;
use App\Models\ReturnSales;
use App\Models\Sales;
use App\Models\SalesDefaultData;
use App\Models\SalesOrder;
use App\Models\Shifts;
use App\Models\StoreCountSales;
use App\Models\Stores;
use App\Models\StoresMoves;
use App\Models\Taxes;
use App\Models\UsersMoves;
use App\Models\VAPrice;
use App\Models\VAQty;
use App\Models\Vendors;
use App\Models\Webslider;
use App\Models\DeliveryApps;
use App\Models\AppsChangePrice;
use App\Models\Wishlist;
use App\Services\Average;
use App\Services\SalesService;
use App\Traits\GeneralTrait;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Str;
use File;
use Validator ;

class ResturantAppController extends Controller
{

    use GeneralTrait ;

    public function __construct(Request $request) {

        $header =!empty( $request->header('lang')) ? $request->header('lang') : "ar";
        app()->setLocale($header);

    }

    //========================= Resturant ==============================================================


    //==========================  User App  =======================================

//Resturant Slider
    public function ResturantSlider(Request $request){

        $types=ResturantSliders::where('Status',1)->where('Type',1)->get();
        $data=WebsliderResources::collection($types);
        return $this->returnData('data', $data);

    }

//Resturant About
    public function ResturantAbout(Request $request){


        $item=ResturantAbout::orderBy('id','desc')->first();
        $data=AboutResources::make($item);
        return $this->returnData('data', $data);


    }

//ResturantHomeTwo
    public function ResturantHomeTwo(Request $request){


        $item=ResturantHome::orderBy('id','desc')->first();
        $data=ResturantHomeResources::make($item);
        return $this->returnData('data', $data);



    }

//ResturantVideo
    public function ResturantVideo(Request $request){

        $item=ResturantVideoSection::orderBy('id','desc')->first();
        $data=ResturantVideoSectionResources::make($item);
        return $this->returnData('data', $data);


    }


//Resturant Gallery
    public function ResturantGallery(Request $request){


        $types=ResturantGallery::get();
        $data=ResturantGalleryResources::collection($types);
        return $this->returnData('data', $data);


    }


    //Resturant Reviews
    public function ResturantReviews(Request $request){


        $types=ResturantReviews::paginate(20);
        $data=ResturantReviewsResources::collection($types);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }


//Resturant Blogs
    public function ResturantBlogs(Request $request){


        $items=ResturantBlogs::paginate(12);


        $data=ArticlesResources::collection($items);


        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;




    }

    //Resturant Blogs Details
    public function ResturantBlogsDet(Request $request){

        $item=ResturantBlogs::find(request('article_id'));
        $data=ArticlesDetailsResources::make($item);
        return $this->returnData('data', $data);

    }


//ResturantSocial
    public function ResturantSocial(Request $request){


        $item=ResturantSocial::orderBy('id','desc')->first();
        $data=SocialResources::make($item);
        return $this->returnData('data', $data);


    }

    //Terms
    public function ResturantTerms(Request $request){

        $item=ResturantTerms::orderBy('id','desc')->first();
        $data=TermsResources::make($item);
        return $this->returnData('data', $data);


    }

//Polices
    public function ResturantPrivacy(Request $request){

        $item=ResturantPrivacy::orderBy('id','desc')->first();
        $data=TermsResources::make($item);
        return $this->returnData('data', $data);

    }


    //ResturantGroups
    public function ResturantGroups(Request $request){



        $groups=DB::table('items_groups')->whereIn('Store_Show',[1,3])->get();
        $data=CategoriesResources::collection($groups);
        return $this->returnData('data', $data);



    }

//ResturantBranches
    public function ResturantBrands(Request $request){

        $groups=DB::table('brands')->whereIn('Store_Show',[1,3])->get();
        $data=BrandsResources::collection($groups);
        return $this->returnData('data', $data);

    }


    public function ResturantBranches(Request $request){

        $groups=Branches::get();
        $data=BranchesResources::collection($groups);
        return $this->returnData('data', $data);

    }


//Resturant Tables
    public function ResturantTables(Request $request){

        $groups=ResturantTables::get();
        $data=ResturantTablesResources::collection($groups);
        return $this->returnData('data', $data);

    }


    //ResturantUse
    public function ResturantUse(Request $request){


        $item=ResturantStyle::orderBy('id','desc')->first();
        $data=ResturantStyleResources::make($item);
        return $this->returnData('data', $data);


    }

    //ResturantReservations
    public function ResturantReservations(Request $request){

        $groups=ResturantReservations::get();
        $data=ResturantReservationsResources::collection($groups);
        return $this->returnData('data', $data);


    }

    //ResturantAddReservations

    public function ResturantAddReservations(Request $request){

        try {

            DB::beginTransaction();

            $validator = Validator::make($request->all(), [
                'name'=>'required',
                'phone'=>'required',
                'persons'=>'required',
                'date'=>'required',
                'time'=>'required',

            ]);

            if ($validator->fails()) {


                return response()->json([
                    'status'=>400,
                    'message'=>$validator->errors()->all(),
                ]);


            }

            $data['Name']=request('name');
        $data['Phone']=request('phone');
        $data['Persons']=request('persons');
        $data['Date']=request('date');
        $data['Time']=request('time');
        $data['Message']=request('message');
        $data['Approve']=0;

        ResturantReservations::create($data);


            DB::commit();



            return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ]);



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }


    }

    //ResturantProducts
    public function ResturantProducts(Request $request){

        $Products=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Variable_Aggregate'])->paginate(9);

        $data=ProductsResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;



    }

    //Filter Products
    public function ResturantFilterProductGroup(Request $request){

        $Products=Products::whereIn('Store_Show',[1,3])
            ->where('Group',request('group_id'))
            ->whereIn('P_Type',['Completed','Variable_Aggregate'])
            ->orderBy('id','desc')->get();

        $data=ProductsResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

    public function ResturantFilterProductBrand(Request $request){

        $Products=Products::whereIn('Store_Show',[1,3])
            ->where('Brand',request('brand_id'))
            ->whereIn('P_Type',['Completed','Variable_Aggregate'])
            ->orderBy('id','desc')->get();

        $data=ProductsResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

    public function ResturantFilterProductName(Request $request){

        $search=request('search_name');
        $Products=Products::whereIn('Store_Show',[1,3])
            ->where('P_Ar_Name','ILIKE', "%{$search}%")
            ->orWhere('P_En_Name','ILIKE', "%{$search}%")
            ->whereIn('P_Type',['Completed','Variable_Aggregate'])
            ->orderBy('id','desc')->get();

        $data=ProductsResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

    //ResturantCuponsCheck
    public function ResturantCuponsCheck(Request $request){



        try {

            DB::beginTransaction();

            $rules = [

                "code" => "required",

            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $i=ResturantCuponCode::where('Code',request('code'))->first();

            if(!empty($i->id)){

                if($i->Status == 1){

                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }elseif($i->Expire < date('Y-m-d')){


                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }else{


                    if(request('code') != NULL){

                        $y=$i->Used + 1 ;

                        if($y == $i->Num){

                            $Status=1;
                        }else{

                            $Status=0;
                        }
                        ResturantCuponCode::where('id',$i->id)->update(['Used'=>$y,'Status'=>$Status]);

                    }

                    DB::commit();
                    return response()->json([
                        'status'=>200,
                        'message'=>trans('admin.Correct_Code'),
                        'discount'=>$i->Amount,
                    ]);

                }


            }else{


                return response()->json([
                    'status'=>400,
                    'message'=>trans('admin.Wrong_Code'),
                ]);


            }




        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }


    }


    //CartPage
    public function ResturantCartPage(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

        $Comps=ResturantCart::where('User',$admin->id)->orderBy('id','desc')->get();
        $data=ResturantCartResources::collection($Comps);
        return $this->returnData('data', $data);



    }

    public function ResturantAddCart(Request $request){

        try {

            DB::beginTransaction();

            $rules = [

                "product_id" => "required",
                "qty" => "required",
                "price" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Customers::where('token',$x)->first();

            $pro=Products::find(request('product_id'));
            $Addr['Product']=request('product_id');
            $Addr['Name']=$pro->P_Ar_Name;
            $Addr['NameEn']=$pro->P_En_Name;
            $Addr['V_ID']=request('v_id');
            $Addr['P_Code']=request('product_code');
            $Addr['Qty']=request('qty');
            $Addr['Price']=request('price');
            $Addr['Image']=$pro->Image;
            $Addr['Total']=request('qty') * request('price');
            $Addr['User']=$admin->id;

            ResturantCart::create($Addr);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),

            ]);



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    public function ResturantUpdateCart(Request $request){

        try {

            DB::beginTransaction();

            $rules = [

                "cart_id" => "required",
                "qty" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }


            $cart=ResturantCart::find(request('cart_id'));

            if($cart->AvQty < request('qty')){

                DB::rollback();
                return response()->json([
                    'status'=>404,
                    'message'=>trans('admin.AvQty_NotEnough'),
                ]);



            }

            $Addr['Qty']=request('qty');
            $Addr['Total']=request('qty') * $cart->Price;
            ResturantCart::where('id',request('cart_id'))->update($Addr);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),

            ]);



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    public function ResturantDeleteCart(Request $request){


        try {

            DB::beginTransaction();


            ResturantCart::where('id',request('cart_id'))->delete();

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.delete'),

            ]);


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    //PlaceOrder
    public function ResturantPlaceOrder(Request $request,Average $average){


        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Customers::where('token',$x)->first();
            $Carts=ResturantCart::where('User',$admin->id)->get();
            $CartsCount=ResturantCart::where('User',$admin->id)->count();
            $TotQty=ResturantCart::where('User',$admin->id)->get()->sum('Qty');

            $DEEF=SalesDefaultData::latest('id')->first();
            $Def=SalesDefaultData::latest('id')->first();
            $coin=Coins::find($Def->CountryResturantWebsite);
            $Country=Countris::where('Coin',$coin->id)->latest('id')->first();
            if(!empty($admin->id)){
                $Client=AcccountingManual::where('id',$admin->Account)->first()->id;
            }else{
                $Client=$DEEF->Client;
            }

            $ID = DB::table('sales_orders')->insertGetId(
                array(
                    'Date' => date('Y-m-d'),
                    'Draw' => $Country->Coin()->first()->Draw,
                    'Payment_Method' =>request('Payment_Method'),
                    'Status' =>1,
                    'Refernce_Number' => null,
                    'Note' => null,
                    'Product_Numbers' => $CartsCount,
                    'Total_Qty' => $TotQty,
                    'Total_Discount' => 0,
                    'Total_BF_Taxes' => request('total_price'),
                    'Total_Taxes' => 0,
                    'Total_Price' => request('total_price'),
                    'Pay' => request('total_price'),
                    'CuponCode' => request('cupon_code'),
                    'Shipping' => request('shipping'),
                    'Order_Type' => 2,
                    'Name' => request('name'),
                    'Email' => request('email'),
                    'Phone' => request('phone'),
                    'OtherPhone' => request('other_phone'),
                    'Address_Name' => request('address_name'),
                    'Special_MarkAdd' => request('special_mark'),
                    'StreetAdd' => request('street'),
                    'BulidingAdd' => request('buliding'),
                    'FloorAdd' => request('floor'),
                    'FlatAdd' => request('flat'),
                    'Governrate' => request('governrate'),
                    'City' => request('city'),
                    'Place' => request('place'),
                    'LocationAdd' => request('location'),
                    'Address_DetailsAdd' => request('address_details'),
                    'Safe' => $Country->Safe,
                    'Later_Due' => null,
                    'Sale_Date' => null,
                    'ToSales' => 0,
                    'Client' => $Client,
                    'Delegate' =>null,
                    'Executor' =>null,
                    'Store' => $Country->Store,
                    'Coin' => $Country->Coin,
                    'Cost_Center' =>null,
                    'presenter' => null,
                    'annual_interest' =>null,
                    'monthly_installment' => null,
                    'Years_Number' =>null,
                    'total' => null,
                    'Quote' => null,
                    'installment_Num' => null,
                    'Date_First_installment' => null,
                    'User' => 1,
                    'Time' => date("h:i:s a", time()),
                    'Delegate_Recived' =>0,
                    'Delegate_Recived_Time' =>null,
                    'To_Sales_Time' =>null,
                    'Cancel_Order' =>0,
                    'Cancel_Order_Time' =>null,
                    'Hold_Qty' =>0,
                    'TakeawayStatus' => 0,
                    'TakeawayTime' => null,
                    'Witer' => null,
                    'KitchenEnd' => 0,
                    'KitchenEndTime' => null,
                    'RecivedOrder' => 0,
                    'RecivedOrderTime' => null,
                    'Delivery_Status' =>0,
                    'DeliveryTime' => null,
                    'ResturantOrderType' => request('order_type'),
                    'Table' => request('table'),
                    'Total_Wight_Bill' =>0,
                    'Edit' => 0,
                    'Delete' => 0,
                    'Edit_New_Code' => 0,
                    'Current_Credit' =>0,
                    'Total_Net' => request('total_price') + request('shipping')  - request('cupon_code')  ,
                    'Residual' => 0,
                    'ProfitPrecent' =>0,
                    'Total_Cost' =>0 ,
                    'InstallCompany' =>null,
                    'ContractNumber' => null,
                    'PayFees' => null,
                    'ServiceFee' => null,
                    'CompanyPrecent' => null,
                    'DiscountBill' => 0,
                    'File' => null,
                    'Hold' =>1,
                    'Branch' => null,
                    'CustomerGroup' => null,
                    'Ship' =>null ,
                    'Check_Type' =>null,
                    'Due_Date' =>null ,
                    'TaxBill' =>null ,
                    'TaxOnTotal' =>null ,
                    'TaxOnTotalType' =>null ,
                    'ProfitTax' =>null ,
                    'TaxCode' => null,
                    'Check_Number' =>null ,
                    'Client_Address' => null,
                    'Delivery' => null,
                    'Shift_Code' =>null,


                )
            );



            $CodeT=SalesOrder::findOrFail($ID)->Code;

            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='طلب مبيعات مطعم';
            $notii['Noti_En_Name']='Resturant Online Order';
            $notii['Type']='طلب مبيعات مطعم';
            $notii['TypeEn']='Resturant Online Order';
            $notii['Type_Code']=$CodeT;
            $notii['Emp']= null;
            $notii['Client']=$Client;
            $notii['Product']=null;
            $notii['Store']=$Country->Store;
            $notii['Safe']=$Country->Safe;
            Notifications::create($notii);

            notify()->success(trans('admin.Online_Order'));

            foreach($Carts as $cart){
                $proCC=ProductUnits::where('Product',$cart->Product)->where('Def',1)->first();
                $pp=ProductUnits::where('Product',$cart->Product)->where('Unit',$proCC->Unit)->first();
                $plow=ProductUnits::where('Product',$cart->Product)->where('Rate',1)->first();
                $rr = ProductUnits::where("Unit",$proCC->Unit)->where('Product',$cart->Product)->first();
                $SS=Stores::find($Country->Store);
                $PSS=Products::find($cart->Product);
                $prooooo=Products::find($cart->Product);
                $costPrice=$average->AverageCostGetUnit($cart->Product,$cart->P_Code,$Country->Store,$proCC->Unit);

                $ii=VAPrice::find($cart->V_ID);

                VAPrice::where('id',$cart->V_ID)->update(['Added'=>0]);

                if(!empty($ii)){
                    $VV=$ii->SubV;
                }else{

                    $VV='';
                }


                Products::where('id',$cart->Product)->update(['Added'=>0]);

                $uu['Product_Code']=$cart->P_Code;
                $uu['P_Ar_Name']=$cart->Name;
                $uu['P_En_Name']=$cart->NameEn;
                $uu['V_Name']=null;
                $uu['VV_Name']=null;
                $uu['Original_Qty']=$cart->Qty;
                $uu['Qty']=$cart->Qty;
                $uu['AvQty']=0;
                $uu['Price']=$cart->Price;
                $uu['Discount']=0;
                $uu['Tax']=1;
                $uu['Total_Bf_Tax']=$cart->Total;
                $uu['Total_Tax']=0;
                $uu['Total']=$cart->Total;
                $uu['Store']=$Country->Store;
                $uu['Product']=$cart->Product;
                $uu['Unit']=$proCC->Unit;
                $uu['Exp_Date']=null;
                $uu['SalesOrder']=$ID;
                $uu['V1']=null;
                $uu['V2']=null;
                $uu['Patch_Number']=null;
                $uu['SubVID']=$VV;

                $uu['TDiscount']=0;
                $uu['Total_Net']=$cart->Price * $cart->Qty ;
                $uu['SalesProDesc']=null;
                $uu['SmallCode']=$plow->Barcode;
                $uu['weight']=0;
                $uu['Total_Wight']=0;
                $uu['SmallQty']=$cart->Qty * $pp->Rate;
                $uu['UnitRate']=$pp->Rate;
                $uu['Date']=date('Y-m-d');
                $uu['Branch']=$SS->Branch;
                $uu['Group']=$PSS->Group;
                $uu['Brand']=$PSS->Brand;
                $uu['CostPrice']=$costPrice;
                $uu['TotCostNew']=$costPrice * $cart->Qty;

                ProductSalesOrder::create($uu);



            }

            ResturantCart::where('User',$admin->id)->delete();
            DB::commit();

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
            ]);

        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //MyOrder
    public function ResturantMyOrder(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();

        $Orders=SalesOrder::where('Order_Type',2)->where('Client',$admin->Account)->paginate(12);
        $data=MyOrdersResources::collection($Orders);


        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;



    }




    //========================== End   User App  =======================================




    //========================== Delegate Resturant App  =======================================



    //  ==== . Resturant POS ============

    
    //Notes 

    public function ResturantProdsNotes(Request $request){

        $Tables=ProNote::get();
        $data=ResturantProNotePOSResources::collection($Tables);
        return $this->returnData('data', $data);


    }

    
    public function AddNewResturantProdsNote(Request $request){



        try {
            DB::beginTransaction();


           
                  $Arabic_Name = $request->get('arName');
        $English_Name = $request->get('enName');



        $PRODUCTSS['Arabic_Name']=$Arabic_Name;
        $PRODUCTSS['English_Name']=$English_Name;



        ProNote::create($PRODUCTSS);

        
            
            
            
            
            
            DB::commit();

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

        }catch(\Exception $ex){

            $MODEL=ProNote::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ProNote::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    

    
    

    //  ================  Filters  =======================

    //SerachProductFilter
    public function SerachResturantProductFilter(Request $request,SalesService $service){


        $search = $request->get('search');
        $store = $request->get('store_id');
        $client = $request->get('client_id');
        $Brand='';
        $Group='';


        $Prods=$this->FilterSalesProductQty($search,$store,$Brand,$Group);
        $data=$this->FilterSalesProductResturant($search,$Brand,$Group);
        $count= $this->FilterSalesProductQtyCount($search,$store,$Brand,$Group);
        $Get=$this->FilterSalesProductQtyGet($search,$store,$Brand,$Group);


        $total_row = $Prods->count();
        $total_row2 = $data->count();
        $total_row3 = $total_row + $total_row2;
        if($total_row3 > 0)
        {

            if(count($Prods) != 0) {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($Prods as $rows) {


                    if($rows->Store == $store) {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if (!empty($rows->Product()->first()->Weight)) {
                            $weigh = $rows->Product()->first()->Weight;
                        } else {
                            $weigh = 0;
                        }

                        if (!empty($rows->Product()->first()->Maximum_Sales_Qty)) {
                            $maxSa = $rows->Product()->first()->Maximum_Sales_Qty;
                        } else {
                            $maxSa = 0;
                        }

                        if (!empty($rows->Product()->first()->Group()->first()->Discount)) {
                            $Higher = $rows->Product()->first()->Group()->first()->Discount;
                        } else {

                            $Higher = 0;
                        }

                        if (!empty($rows->Product()->first()->Brand)) {

                            $branddX = $rows->Product()->first()->Brand;
                            if (app()->getLocale() == 'ar') {
                                $brandd = $rows->Product()->first()->Brand()->first()->Name;

                            } else {
                                $brandd = $rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        } else {

                            $brandd = "";
                            $branddX = "";

                        }


                        if ($showw->Group_Brand == 1) {

                            if (app()->getLocale() == 'ar') {
                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->Name . ') ';
                            } else {

                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->NameEn . ') ';
                            }
                        } else {
                            $ShowGrBr = '';
                        }


                        if (app()->getLocale() == 'ar') {
                            $PrrroName = $rows->P_Ar_Name;
                            $UniiName = $rr->Unit()->first()->Name;
                            $StoreNemo = $st->Name;

                        } else {
                            $PrrroName = $rows->P_En_Name;
                            $UniiName = $rr->Unit()->first()->NameEn;
                            $StoreNemo = $st->NameEn;

                        }


                        if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions') {
                            $type = 1;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rr->Barcode;
                        } elseif ($rows->Product()->first()->P_Type == 'Serial') {
                            $type = 2;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 1;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {

                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;

                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;

                            }

                            $type = 3;
                            $v_name = $PrrroVName;
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;
                                $PrrroVVName = $rows->V2()->first()->Name;
                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;
                                $PrrroVVName = $rows->V2()->first()->NameEn;
                            }

                            $type = 4;
                            $v_name = $PrrroVName;
                            $vv_name = $PrrroVVName;
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        }

                        $Filter = [

                            'client' => $client,
                            'store' => $store,
                            'product' => $rows->Product,
                            'id' => $rows->id,
                            'name_ar' => $rows->P_Ar_Name,
                            'name_en' => $rows->P_En_Name,
                            'v1' => $rows->V1,
                            'v2' => $rows->V2,
                            'type' => $type,
                            'PrrroName' => $PrrroName,
                            'UniiName' => $UniiName,
                            'StoreNemo' => $StoreNemo,
                            'weigh' => $weigh,
                            'maxSa' => $maxSa,
                            'P_Code' => $p_code,
                            'qty' => $rows->Qty / $rr->Rate,
                            'Original' => $rows->Original,
                            'Patch_Number' => $rows->Patch_Number,
                            'brandd' => $brandd,
                            'ShowGrBr' => $ShowGrBr,
                            'Higher' => $Higher,
                            'v_name' => $v_name,
                            'vv_name' => $vv_name,
                            'serial' => $serial,
                            'Exp_Date' => $rows->Exp_Date,
                            'pro_store' => $rows->Store,
                            'AdditionsCount'=>$AdditionsCount,
                            'search'=>$search,


                        ];



                        $filter = $service->ItemsFilterResturantApi($Filter);

                        if (count($filter) != 0) {
                            array_push($Array, [

                                'row_id' => $filter['row_id'],
                                'product_name' => $filter['product_name'],
                                'product_ar_name' => $filter['product_ar_name'],
                                'product_en_name' => $filter['product_en_name'],
                                'product_id' => $filter['product_id'],
                                'virable_one_id' => $filter['virable_one_id'],
                                'virable_two_id' => $filter['virable_two_id'],
                                'virable_one_name' => $filter['virable_one_name'],
                                'virable_two_name' => $filter['virable_two_name'],
                                'product_code' => $filter['product_code'],
                                'unit_name' => $filter['unit_name'],
                                'unit_id' => $filter['unit_id'],
                                'unit_default' => $filter['unit_default'],
                                'units' => $filter['units'],
                                'code_default' => $filter['code_default'],
                                'tax_rate' => $filter['tax_rate'],
                                'tax_type' => $filter['tax_type'],
                                'tax_id' => $filter['tax_id'],
                                'avalible_qty' => $filter['avalible_qty'],
                                'qty' => $filter['qty'],
                                'price' => $filter['price'],
                                'priceOne' => $filter['priceOne'],
                                'priceTwo' => $filter['priceTwo'],
                                'priceThree' => $filter['priceThree'],
                                'discount' => $filter['discount'],
                                'total_disc_pro' => $filter['total_disc_pro'],
                                'total_before_tax' => $filter['total_before_tax'],
                                'tax_value' => $filter['tax_value'],
                                'total' => $filter['total'],
                                'store_id' => $filter['store_id'],
                                'store_name' => $filter['store_name'],
                                'ExpDate' => $filter['ExpDate'],
                                'serial' => $filter['serial'],
                                'high_disc' => $filter['high_disc'],
                                'cost_price' => $filter['cost_price'],
                                'weight' => $filter['weight'],
                                'max_sales' => $filter['max_sales'],
                                'unit_rate' => $filter['unit_rate'],
                                'sales_pro_desc' => $filter['sales_pro_desc'],
                                'AdditionsCount' => $filter['AdditionsCount'],


                            ]);
                        }

                    }
                }

            }else{

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($data as $rows){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;

                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){
                            $Filter=[

                                'client'=>$client,
                                'store'=>$store,
                                'id'=>$rows->id,
                                'product'=>$rows->Product,
                                'name_ar'=>$rows->P_Ar_Name,
                                'name_en'=>$rows->P_En_Name,
                                'v1'=>$rows->V1,
                                'v2'=>$rows->V2,
                                'type'=>$type,
                                'PrrroName'=>$PrrroName,
                                'UniiName'=>$UniiName,
                                'StoreNemo'=>$StoreNemo,
                                'weigh'=>$weigh,
                                'maxSa'=>$maxSa,
                                'P_Code'=>$p_code,
                                'qty'=>$qty,
                                'Original'=>$rows->Original,
                                'Patch_Number'=>$rows->Patch_Number,
                                'brandd'=>$brandd,
                                'ShowGrBr'=>$ShowGrBr,
                                'Higher'=>$Higher,
                                'v_name'=>$v_name,
                                'vv_name'=>$vv_name,
                                'serial'=>$serial,
                                'Exp_Date'=>$rows->Exp_Date,
                                'cost'=>$cost,
                                'AdditionsCount'=>$AdditionsCount,
                                'AV'=>$avv,
                                'search'=>$search,

                            ];

                            $filter = $service->ItemsFilterTwoResturantApi($Filter);
                            if(count($filter) != 0) {
                                array_push($Array, [



                                    'product_name'=>$filter['product_name'],
                                    'product_ar_name'=>$filter['product_ar_name'],
                                    'product_en_name'=>$filter['product_en_name'],
                                    'product_id'=>$filter['product_id'],
                                    'virable_one_id'=>$filter['virable_one_id'],
                                    'virable_two_id'=>$filter['virable_two_id'],
                                    'virable_one_name'=>$filter['virable_one_name'],
                                    'virable_two_name'=>$filter['virable_two_name'],
                                    'product_code'=>$filter['product_code'],
                                    'unit_name'=>$filter['unit_name'],
                                    'unit_id'=>$filter['unit_id'],
                                    'unit_default'=>$filter['unit_default'],
                                    'units'=>$filter['units'],
                                    'code_default'=>$filter['code_default'],
                                    'tax_rate'=>$filter['tax_rate'],
                                    'tax_type'=>$filter['tax_type'],
                                    'tax_id'=>$filter['tax_id'],
                                    'avalible_qty'=>$filter['avalible_qty'],
                                    'qty'=>$filter['qty'],
                                    'price'=>$filter['price'],
                                    'priceOne'=>$filter['priceOne'],
                                    'priceTwo'=>$filter['priceTwo'],
                                    'priceThree'=>$filter['priceThree'],
                                    'discount'=>$filter['discount'],
                                    'total_disc_pro'=>$filter['total_disc_pro'],
                                    'total_before_tax'=>$filter['total_before_tax'],
                                    'tax_value'=>$filter['tax_value'],
                                    'total'=>$filter['total'],
                                    'store_id'=>$filter['store_id'],
                                    'store_name'=>$filter['store_name'],
                                    'ExpDate'=>$filter['ExpDate'],
                                    'serial'=>$filter['serial'],
                                    'high_disc'=>$filter['high_disc'],
                                    'cost_price'=>$filter['cost_price'],
                                    'weight'=>$filter['weight'],
                                    'max_sales'=>$filter['max_sales'],
                                    'unit_rate'=>$filter['unit_rate'],
                                    'sales_pro_desc'=>$filter['sales_pro_desc'],
                                    'id'=>$filter['id'],
                                    'AdditionsCount'=>$filter['AdditionsCount'],
                                    'AV'=>$filter['AV'],



                                ]);
                            }


                        }

                    }
                }

            }

        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }

    //SerachProductGroupFilter
    public function SerachResturantProductGroupFilter(Request $request,SalesService $service){


        $group = $request->get('group');
        $store = $request->get('store_id');
        $client = $request->get('client_id');
        $Brand='';
        $Group='';


        $Prods=$this->FilterSalesProductQtyGroup($group,$store);
        $data=$this->FilterSalesProductGroupResturant($group);


        $total_row = $Prods->count();
        $total_row2 = $data->count();
        $total_row3 = $total_row + $total_row2;
        if($total_row3 > 0)
        {

            if(count($Prods) != 0) {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($Prods as $rows) {


                    if($rows->Store == $store) {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if (!empty($rows->Product()->first()->Weight)) {
                            $weigh = $rows->Product()->first()->Weight;
                        } else {
                            $weigh = 0;
                        }

                        if (!empty($rows->Product()->first()->Maximum_Sales_Qty)) {
                            $maxSa = $rows->Product()->first()->Maximum_Sales_Qty;
                        } else {
                            $maxSa = 0;
                        }

                        if (!empty($rows->Product()->first()->Group()->first()->Discount)) {
                            $Higher = $rows->Product()->first()->Group()->first()->Discount;
                        } else {

                            $Higher = 0;
                        }

                        if (!empty($rows->Product()->first()->Brand)) {

                            $branddX = $rows->Product()->first()->Brand;
                            if (app()->getLocale() == 'ar') {
                                $brandd = $rows->Product()->first()->Brand()->first()->Name;

                            } else {
                                $brandd = $rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        } else {

                            $brandd = "";
                            $branddX = "";

                        }


                        if ($showw->Group_Brand == 1) {

                            if (app()->getLocale() == 'ar') {
                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->Name . ') ';
                            } else {

                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->NameEn . ') ';
                            }
                        } else {
                            $ShowGrBr = '';
                        }


                        if (app()->getLocale() == 'ar') {
                            $PrrroName = $rows->P_Ar_Name;
                            $UniiName = $rr->Unit()->first()->Name;
                            $StoreNemo = $st->Name;

                        } else {
                            $PrrroName = $rows->P_En_Name;
                            $UniiName = $rr->Unit()->first()->NameEn;
                            $StoreNemo = $st->NameEn;

                        }

                        if(!empty($rows->Product()->first()->Image)){
                           $img=$rows->Product()->first()->Image;
                        }else{
                            $img='';
                        }

                        if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions') {
                            $type = 1;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rr->Barcode;
                        } elseif ($rows->Product()->first()->P_Type == 'Serial') {
                            $type = 2;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 1;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {

                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;

                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;

                            }

                            $type = 3;
                            $v_name = $PrrroVName;
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;
                                $PrrroVVName = $rows->V2()->first()->Name;
                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;
                                $PrrroVVName = $rows->V2()->first()->NameEn;
                            }

                            $type = 4;
                            $v_name = $PrrroVName;
                            $vv_name = $PrrroVVName;
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        }
                        if($rows->Product()->first()->Group == $group) {
                        $Filter = [

                            'client' => $client,
                            'store' => $store,
                            'product' => $rows->Product,
                            'id' => $rows->id,
                            'name_ar' => $rows->P_Ar_Name,
                            'name_en' => $rows->P_En_Name,
                            'v1' => $rows->V1,
                            'v2' => $rows->V2,
                            'type' => $type,
                            'PrrroName' => $PrrroName,
                            'UniiName' => $UniiName,
                            'StoreNemo' => $StoreNemo,
                            'weigh' => $weigh,
                            'maxSa' => $maxSa,
                            'P_Code' => $p_code,
                            'qty' => $rows->Qty / $rr->Rate,
                            'Original' => $rows->Original,
                            'Patch_Number' => $rows->Patch_Number,
                            'brandd' => $brandd,
                            'ShowGrBr' => $ShowGrBr,
                            'Higher' => $Higher,
                            'v_name' => $v_name,
                            'vv_name' => $vv_name,
                            'serial' => $serial,
                            'Exp_Date' => $rows->Exp_Date,
                            'pro_store' => $rows->Store,
                            'AdditionsCount'=>$AdditionsCount,
                            'img'=>$img,



                        ];



                        $filter = $service->ItemsFilterResturantCatApi($Filter);

                        if (count($filter) != 0) {
                            array_push($Array, [

                                'row_id' => $filter['row_id'],
                                'product_name' => $filter['product_name'],
                                'product_ar_name' => $filter['product_ar_name'],
                                'product_en_name' => $filter['product_en_name'],
                                'product_id' => $filter['product_id'],
                                'virable_one_id' => $filter['virable_one_id'],
                                'virable_two_id' => $filter['virable_two_id'],
                                'virable_one_name' => $filter['virable_one_name'],
                                'virable_two_name' => $filter['virable_two_name'],
                                'product_code' => $filter['product_code'],
                                'unit_name' => $filter['unit_name'],
                                'unit_id' => $filter['unit_id'],
                                'unit_default' => $filter['unit_default'],
                                'units' => $filter['units'],
                                'code_default' => $filter['code_default'],
                                'tax_rate' => $filter['tax_rate'],
                                'tax_type' => $filter['tax_type'],
                                'tax_id' => $filter['tax_id'],
                                'avalible_qty' => $filter['avalible_qty'],
                                'qty' => $filter['qty'],
                                'price' => $filter['price'],
                                'priceOne' => $filter['priceOne'],
                                'priceTwo' => $filter['priceTwo'],
                                'priceThree' => $filter['priceThree'],
                                'discount' => $filter['discount'],
                                'total_disc_pro' => $filter['total_disc_pro'],
                                'total_before_tax' => $filter['total_before_tax'],
                                'tax_value' => $filter['tax_value'],
                                'total' => $filter['total'],
                                'store_id' => $filter['store_id'],
                                'store_name' => $filter['store_name'],
                                'ExpDate' => $filter['ExpDate'],
                                'serial' => $filter['serial'],
                                'high_disc' => $filter['high_disc'],
                                'cost_price' => $filter['cost_price'],
                                'weight' => $filter['weight'],
                                'max_sales' => $filter['max_sales'],
                                'unit_rate' => $filter['unit_rate'],
                                'sales_pro_desc' => $filter['sales_pro_desc'],
                                'AdditionsCount' => $filter['AdditionsCount'],
                                'img' => $filter['img'],


                            ]);
                        }
                        }

                    }
                }

            }else{

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($data as $rows){


                        $ser_x=1;
                        $ser_y=1;






                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;

                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            if($rows->Product()->first()->Group == $group) {

                                if(!empty($rows->Product()->first()->Image)){
                                    $img=$rows->Product()->first()->Image;
                                }else{
                                    $img='';
                                }
                            $Filter=[

                                'client'=>$client,
                                'store'=>$store,
                                'id'=>$rows->id,
                                'product'=>$rows->Product,
                                'name_ar'=>$rows->P_Ar_Name,
                                'name_en'=>$rows->P_En_Name,
                                'v1'=>$rows->V1,
                                'v2'=>$rows->V2,
                                'type'=>$type,
                                'PrrroName'=>$PrrroName,
                                'UniiName'=>$UniiName,
                                'StoreNemo'=>$StoreNemo,
                                'weigh'=>$weigh,
                                'maxSa'=>$maxSa,
                                'P_Code'=>$p_code,
                                'qty'=>$qty,
                                'Original'=>$rows->Original,
                                'Patch_Number'=>$rows->Patch_Number,
                                'brandd'=>$brandd,
                                'ShowGrBr'=>$ShowGrBr,
                                'Higher'=>$Higher,
                                'v_name'=>$v_name,
                                'vv_name'=>$vv_name,
                                'serial'=>$serial,
                                'Exp_Date'=>$rows->Exp_Date,
                                'cost'=>$cost,
                                'AdditionsCount'=>$AdditionsCount,
                                'AV'=>$avv,
                                'img'=>$img,


                            ];

                            $filter = $service->ItemsFilterTwoResturantCatApi($Filter);
                            if(count($filter) != 0) {
                                array_push($Array, [



                                    'product_name'=>$filter['product_name'],
                                    'product_ar_name'=>$filter['product_ar_name'],
                                    'product_en_name'=>$filter['product_en_name'],
                                    'product_id'=>$filter['product_id'],
                                    'virable_one_id'=>$filter['virable_one_id'],
                                    'virable_two_id'=>$filter['virable_two_id'],
                                    'virable_one_name'=>$filter['virable_one_name'],
                                    'virable_two_name'=>$filter['virable_two_name'],
                                    'product_code'=>$filter['product_code'],
                                    'unit_name'=>$filter['unit_name'],
                                    'unit_id'=>$filter['unit_id'],
                                    'unit_default'=>$filter['unit_default'],
                                    'units'=>$filter['units'],
                                    'code_default'=>$filter['code_default'],
                                    'tax_rate'=>$filter['tax_rate'],
                                    'tax_type'=>$filter['tax_type'],
                                    'tax_id'=>$filter['tax_id'],
                                    'avalible_qty'=>$filter['avalible_qty'],
                                    'qty'=>$filter['qty'],
                                    'price'=>$filter['price'],
                                    'priceOne'=>$filter['priceOne'],
                                    'priceTwo'=>$filter['priceTwo'],
                                    'priceThree'=>$filter['priceThree'],
                                    'discount'=>$filter['discount'],
                                    'total_disc_pro'=>$filter['total_disc_pro'],
                                    'total_before_tax'=>$filter['total_before_tax'],
                                    'tax_value'=>$filter['tax_value'],
                                    'total'=>$filter['total'],
                                    'store_id'=>$filter['store_id'],
                                    'store_name'=>$filter['store_name'],
                                    'ExpDate'=>$filter['ExpDate'],
                                    'serial'=>$filter['serial'],
                                    'high_disc'=>$filter['high_disc'],
                                    'cost_price'=>$filter['cost_price'],
                                    'weight'=>$filter['weight'],
                                    'max_sales'=>$filter['max_sales'],
                                    'unit_rate'=>$filter['unit_rate'],
                                    'sales_pro_desc'=>$filter['sales_pro_desc'],
                                    'id'=>$filter['id'],
                                    'AdditionsCount'=>$filter['AdditionsCount'],
                                    'AV'=>$filter['AV'],
                                    'img'=>$filter['img'],



                                ]);
                            }


                        }
                        }

                    }
                }

            }

        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }

    //SerachProductBrandFilter

    public function SerachResturantProductBrandFilter(Request $request,SalesService $service){


        $group = $request->get('brand');
        $store = $request->get('store_id');
        $client = $request->get('client_id');
        $Brand='';
        $Group='';



        $Prods=$this->FilterSalesProductQtyBrand($group,$store);
        $data=$this->FilterSalesProductBrandResturant($group);


        $total_row = $Prods->count();
        $total_row2 = $data->count();
        $total_row3 = $total_row + $total_row2;
        if($total_row3 > 0)
        {

            if(count($Prods) != 0) {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($Prods as $rows) {


                    if($rows->Store == $store) {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if (!empty($rows->Product()->first()->Weight)) {
                            $weigh = $rows->Product()->first()->Weight;
                        } else {
                            $weigh = 0;
                        }

                        if (!empty($rows->Product()->first()->Maximum_Sales_Qty)) {
                            $maxSa = $rows->Product()->first()->Maximum_Sales_Qty;
                        } else {
                            $maxSa = 0;
                        }

                        if (!empty($rows->Product()->first()->Group()->first()->Discount)) {
                            $Higher = $rows->Product()->first()->Group()->first()->Discount;
                        } else {

                            $Higher = 0;
                        }

                        if (!empty($rows->Product()->first()->Brand)) {

                            $branddX = $rows->Product()->first()->Brand;
                            if (app()->getLocale() == 'ar') {
                                $brandd = $rows->Product()->first()->Brand()->first()->Name;

                            } else {
                                $brandd = $rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        } else {

                            $brandd = "";
                            $branddX = "";

                        }


                        if ($showw->Group_Brand == 1) {

                            if (app()->getLocale() == 'ar') {
                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->Name . ') ';
                            } else {

                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->NameEn . ') ';
                            }
                        } else {
                            $ShowGrBr = '';
                        }


                        if (app()->getLocale() == 'ar') {
                            $PrrroName = $rows->P_Ar_Name;
                            $UniiName = $rr->Unit()->first()->Name;
                            $StoreNemo = $st->Name;

                        } else {
                            $PrrroName = $rows->P_En_Name;
                            $UniiName = $rr->Unit()->first()->NameEn;
                            $StoreNemo = $st->NameEn;

                        }

                        if(!empty($rows->Product()->first()->Image)){
                            $img=$rows->Product()->first()->Image;
                        }else{
                            $img='';
                        }

                        if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions') {
                            $type = 1;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rr->Barcode;
                        } elseif ($rows->Product()->first()->P_Type == 'Serial') {
                            $type = 2;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 1;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {

                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;

                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;

                            }

                            $type = 3;
                            $v_name = $PrrroVName;
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;
                                $PrrroVVName = $rows->V2()->first()->Name;
                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;
                                $PrrroVVName = $rows->V2()->first()->NameEn;
                            }

                            $type = 4;
                            $v_name = $PrrroVName;
                            $vv_name = $PrrroVVName;
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        }
                        if($rows->Product()->first()->Brand == $group) {
                            $Filter = [

                                'client' => $client,
                                'store' => $store,
                                'product' => $rows->Product,
                                'id' => $rows->id,
                                'name_ar' => $rows->P_Ar_Name,
                                'name_en' => $rows->P_En_Name,
                                'v1' => $rows->V1,
                                'v2' => $rows->V2,
                                'type' => $type,
                                'PrrroName' => $PrrroName,
                                'UniiName' => $UniiName,
                                'StoreNemo' => $StoreNemo,
                                'weigh' => $weigh,
                                'maxSa' => $maxSa,
                                'P_Code' => $p_code,
                                'qty' => $rows->Qty / $rr->Rate,
                                'Original' => $rows->Original,
                                'Patch_Number' => $rows->Patch_Number,
                                'brandd' => $brandd,
                                'ShowGrBr' => $ShowGrBr,
                                'Higher' => $Higher,
                                'v_name' => $v_name,
                                'vv_name' => $vv_name,
                                'serial' => $serial,
                                'Exp_Date' => $rows->Exp_Date,
                                'pro_store' => $rows->Store,
                                'AdditionsCount'=>$AdditionsCount,
                                'img'=>$img,



                            ];



                            $filter = $service->ItemsFilterResturantCatApi($Filter);

                            if (count($filter) != 0) {
                                array_push($Array, [

                                    'row_id' => $filter['row_id'],
                                    'product_name' => $filter['product_name'],
                                    'product_ar_name' => $filter['product_ar_name'],
                                    'product_en_name' => $filter['product_en_name'],
                                    'product_id' => $filter['product_id'],
                                    'virable_one_id' => $filter['virable_one_id'],
                                    'virable_two_id' => $filter['virable_two_id'],
                                    'virable_one_name' => $filter['virable_one_name'],
                                    'virable_two_name' => $filter['virable_two_name'],
                                    'product_code' => $filter['product_code'],
                                    'unit_name' => $filter['unit_name'],
                                    'unit_id' => $filter['unit_id'],
                                    'unit_default' => $filter['unit_default'],
                                    'units' => $filter['units'],
                                    'code_default' => $filter['code_default'],
                                    'tax_rate' => $filter['tax_rate'],
                                    'tax_type' => $filter['tax_type'],
                                    'tax_id' => $filter['tax_id'],
                                    'avalible_qty' => $filter['avalible_qty'],
                                    'qty' => $filter['qty'],
                                    'price' => $filter['price'],
                                    'priceOne' => $filter['priceOne'],
                                    'priceTwo' => $filter['priceTwo'],
                                    'priceThree' => $filter['priceThree'],
                                    'discount' => $filter['discount'],
                                    'total_disc_pro' => $filter['total_disc_pro'],
                                    'total_before_tax' => $filter['total_before_tax'],
                                    'tax_value' => $filter['tax_value'],
                                    'total' => $filter['total'],
                                    'store_id' => $filter['store_id'],
                                    'store_name' => $filter['store_name'],
                                    'ExpDate' => $filter['ExpDate'],
                                    'serial' => $filter['serial'],
                                    'high_disc' => $filter['high_disc'],
                                    'cost_price' => $filter['cost_price'],
                                    'weight' => $filter['weight'],
                                    'max_sales' => $filter['max_sales'],
                                    'unit_rate' => $filter['unit_rate'],
                                    'sales_pro_desc' => $filter['sales_pro_desc'],
                                    'AdditionsCount' => $filter['AdditionsCount'],
                                    'img' => $filter['img'],


                                ]);
                            }
                        }

                    }
                }

            }else{

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($data as $rows){


                    $ser_x=1;
                    $ser_y=1;






                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;

                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            if($rows->Product()->first()->Brand == $group) {

                                if(!empty($rows->Product()->first()->Image)){
                                    $img=$rows->Product()->first()->Image;
                                }else{
                                    $img='';
                                }
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'id'=>$rows->id,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'AdditionsCount'=>$AdditionsCount,
                                    'AV'=>$avv,
                                    'img'=>$img,


                                ];

                                $filter = $service->ItemsFilterTwoResturantCatApi($Filter);
                                if(count($filter) != 0) {
                                    array_push($Array, [



                                        'product_name'=>$filter['product_name'],
                                        'product_ar_name'=>$filter['product_ar_name'],
                                        'product_en_name'=>$filter['product_en_name'],
                                        'product_id'=>$filter['product_id'],
                                        'virable_one_id'=>$filter['virable_one_id'],
                                        'virable_two_id'=>$filter['virable_two_id'],
                                        'virable_one_name'=>$filter['virable_one_name'],
                                        'virable_two_name'=>$filter['virable_two_name'],
                                        'product_code'=>$filter['product_code'],
                                        'unit_name'=>$filter['unit_name'],
                                        'unit_id'=>$filter['unit_id'],
                                        'unit_default'=>$filter['unit_default'],
                                        'units'=>$filter['units'],
                                        'code_default'=>$filter['code_default'],
                                        'tax_rate'=>$filter['tax_rate'],
                                        'tax_type'=>$filter['tax_type'],
                                        'tax_id'=>$filter['tax_id'],
                                        'avalible_qty'=>$filter['avalible_qty'],
                                        'qty'=>$filter['qty'],
                                        'price'=>$filter['price'],
                                        'priceOne'=>$filter['priceOne'],
                                        'priceTwo'=>$filter['priceTwo'],
                                        'priceThree'=>$filter['priceThree'],
                                        'discount'=>$filter['discount'],
                                        'total_disc_pro'=>$filter['total_disc_pro'],
                                        'total_before_tax'=>$filter['total_before_tax'],
                                        'tax_value'=>$filter['tax_value'],
                                        'total'=>$filter['total'],
                                        'store_id'=>$filter['store_id'],
                                        'store_name'=>$filter['store_name'],
                                        'ExpDate'=>$filter['ExpDate'],
                                        'serial'=>$filter['serial'],
                                        'high_disc'=>$filter['high_disc'],
                                        'cost_price'=>$filter['cost_price'],
                                        'weight'=>$filter['weight'],
                                        'max_sales'=>$filter['max_sales'],
                                        'unit_rate'=>$filter['unit_rate'],
                                        'sales_pro_desc'=>$filter['sales_pro_desc'],
                                        'id'=>$filter['id'],
                                        'AdditionsCount'=>$filter['AdditionsCount'],
                                        'AV'=>$filter['AV'],
                                        'img'=>$filter['img'],



                                    ]);
                                }


                            }
                        }

                    }
                }

            }

        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }


    //SerachAllProductFilter
    public function SerachResturantAllProductFilter(Request $request,SalesService $service){



        $store = $request->get('store_id');
        $client = $request->get('client_id');
        $Brand='';
        $Group='';



        $Prods=$this->FilterSalesProductQtyAll($store);
        $data=$this->FilterSalesProductAllResturant();



        $total_row = $Prods->count();
        $total_row2 = $data->count();
        $total_row3 = $total_row + $total_row2;
        if($total_row3 > 0)
        {

            if(count($Prods) != 0) {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($Prods as $rows) {


                    if($rows->Store == $store) {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if (!empty($rows->Product()->first()->Weight)) {
                            $weigh = $rows->Product()->first()->Weight;
                        } else {
                            $weigh = 0;
                        }

                        if (!empty($rows->Product()->first()->Maximum_Sales_Qty)) {
                            $maxSa = $rows->Product()->first()->Maximum_Sales_Qty;
                        } else {
                            $maxSa = 0;
                        }

                        if (!empty($rows->Product()->first()->Group()->first()->Discount)) {
                            $Higher = $rows->Product()->first()->Group()->first()->Discount;
                        } else {

                            $Higher = 0;
                        }

                        if (!empty($rows->Product()->first()->Brand)) {

                            $branddX = $rows->Product()->first()->Brand;
                            if (app()->getLocale() == 'ar') {
                                $brandd = $rows->Product()->first()->Brand()->first()->Name;

                            } else {
                                $brandd = $rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        } else {

                            $brandd = "";
                            $branddX = "";

                        }


                        if ($showw->Group_Brand == 1) {

                            if (app()->getLocale() == 'ar') {
                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->Name . ') ';
                            } else {

                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->NameEn . ') ';
                            }
                        } else {
                            $ShowGrBr = '';
                        }


                        if (app()->getLocale() == 'ar') {
                            $PrrroName = $rows->P_Ar_Name;
                            $UniiName = $rr->Unit()->first()->Name;
                            $StoreNemo = $st->Name;

                        } else {
                            $PrrroName = $rows->P_En_Name;
                            $UniiName = $rr->Unit()->first()->NameEn;
                            $StoreNemo = $st->NameEn;

                        }

                        if(!empty($rows->Product()->first()->Image)){
                            $img=$rows->Product()->first()->Image;
                        }else{
                            $img='';
                        }

                        if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions') {
                            $type = 1;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rr->Barcode;
                        } elseif ($rows->Product()->first()->P_Type == 'Serial') {
                            $type = 2;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 1;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {

                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;

                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;

                            }

                            $type = 3;
                            $v_name = $PrrroVName;
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;
                                $PrrroVVName = $rows->V2()->first()->Name;
                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;
                                $PrrroVVName = $rows->V2()->first()->NameEn;
                            }

                            $type = 4;
                            $v_name = $PrrroVName;
                            $vv_name = $PrrroVVName;
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        }

                            $Filter = [

                                'client' => $client,
                                'store' => $store,
                                'product' => $rows->Product,
                                'id' => $rows->id,
                                'name_ar' => $rows->P_Ar_Name,
                                'name_en' => $rows->P_En_Name,
                                'v1' => $rows->V1,
                                'v2' => $rows->V2,
                                'type' => $type,
                                'PrrroName' => $PrrroName,
                                'UniiName' => $UniiName,
                                'StoreNemo' => $StoreNemo,
                                'weigh' => $weigh,
                                'maxSa' => $maxSa,
                                'P_Code' => $p_code,
                                'qty' => $rows->Qty / $rr->Rate,
                                'Original' => $rows->Original,
                                'Patch_Number' => $rows->Patch_Number,
                                'brandd' => $brandd,
                                'ShowGrBr' => $ShowGrBr,
                                'Higher' => $Higher,
                                'v_name' => $v_name,
                                'vv_name' => $vv_name,
                                'serial' => $serial,
                                'Exp_Date' => $rows->Exp_Date,
                                'pro_store' => $rows->Store,
                                'AdditionsCount'=>$AdditionsCount,
                                'img'=>$img,



                            ];



                            $filter = $service->ItemsFilterResturantCatApi($Filter);

                            if (count($filter) != 0) {
                                array_push($Array, [

                                    'row_id' => $filter['row_id'],
                                    'product_name' => $filter['product_name'],
                                    'product_ar_name' => $filter['product_ar_name'],
                                    'product_en_name' => $filter['product_en_name'],
                                    'product_id' => $filter['product_id'],
                                    'virable_one_id' => $filter['virable_one_id'],
                                    'virable_two_id' => $filter['virable_two_id'],
                                    'virable_one_name' => $filter['virable_one_name'],
                                    'virable_two_name' => $filter['virable_two_name'],
                                    'product_code' => $filter['product_code'],
                                    'unit_name' => $filter['unit_name'],
                                    'unit_id' => $filter['unit_id'],
                                    'unit_default' => $filter['unit_default'],
                                    'units' => $filter['units'],
                                    'code_default' => $filter['code_default'],
                                    'tax_rate' => $filter['tax_rate'],
                                    'tax_type' => $filter['tax_type'],
                                    'tax_id' => $filter['tax_id'],
                                    'avalible_qty' => $filter['avalible_qty'],
                                    'qty' => $filter['qty'],
                                    'price' => $filter['price'],
                                    'priceOne' => $filter['priceOne'],
                                    'priceTwo' => $filter['priceTwo'],
                                    'priceThree' => $filter['priceThree'],
                                    'discount' => $filter['discount'],
                                    'total_disc_pro' => $filter['total_disc_pro'],
                                    'total_before_tax' => $filter['total_before_tax'],
                                    'tax_value' => $filter['tax_value'],
                                    'total' => $filter['total'],
                                    'store_id' => $filter['store_id'],
                                    'store_name' => $filter['store_name'],
                                    'ExpDate' => $filter['ExpDate'],
                                    'serial' => $filter['serial'],
                                    'high_disc' => $filter['high_disc'],
                                    'cost_price' => $filter['cost_price'],
                                    'weight' => $filter['weight'],
                                    'max_sales' => $filter['max_sales'],
                                    'unit_rate' => $filter['unit_rate'],
                                    'sales_pro_desc' => $filter['sales_pro_desc'],
                                    'AdditionsCount' => $filter['AdditionsCount'],
                                    'img' => $filter['img'],


                                ]);
                            }


                    }
                }

            }else{

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($data as $rows){


                    $ser_x=1;
                    $ser_y=1;






                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;

                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){



                                if(!empty($rows->Product()->first()->Image)){
                                    $img=$rows->Product()->first()->Image;
                                }else{
                                    $img='';
                                }
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'id'=>$rows->id,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'AdditionsCount'=>$AdditionsCount,
                                    'AV'=>$avv,
                                    'img'=>$img,


                                ];

                                $filter = $service->ItemsFilterTwoResturantCatApi($Filter);
                                if(count($filter) != 0) {
                                    array_push($Array, [



                                        'product_name'=>$filter['product_name'],
                                        'product_ar_name'=>$filter['product_ar_name'],
                                        'product_en_name'=>$filter['product_en_name'],
                                        'product_id'=>$filter['product_id'],
                                        'virable_one_id'=>$filter['virable_one_id'],
                                        'virable_two_id'=>$filter['virable_two_id'],
                                        'virable_one_name'=>$filter['virable_one_name'],
                                        'virable_two_name'=>$filter['virable_two_name'],
                                        'product_code'=>$filter['product_code'],
                                        'unit_name'=>$filter['unit_name'],
                                        'unit_id'=>$filter['unit_id'],
                                        'unit_default'=>$filter['unit_default'],
                                        'units'=>$filter['units'],
                                        'code_default'=>$filter['code_default'],
                                        'tax_rate'=>$filter['tax_rate'],
                                        'tax_type'=>$filter['tax_type'],
                                        'tax_id'=>$filter['tax_id'],
                                        'avalible_qty'=>$filter['avalible_qty'],
                                        'qty'=>$filter['qty'],
                                        'price'=>$filter['price'],
                                        'priceOne'=>$filter['priceOne'],
                                        'priceTwo'=>$filter['priceTwo'],
                                        'priceThree'=>$filter['priceThree'],
                                        'discount'=>$filter['discount'],
                                        'total_disc_pro'=>$filter['total_disc_pro'],
                                        'total_before_tax'=>$filter['total_before_tax'],
                                        'tax_value'=>$filter['tax_value'],
                                        'total'=>$filter['total'],
                                        'store_id'=>$filter['store_id'],
                                        'store_name'=>$filter['store_name'],
                                        'ExpDate'=>$filter['ExpDate'],
                                        'serial'=>$filter['serial'],
                                        'high_disc'=>$filter['high_disc'],
                                        'cost_price'=>$filter['cost_price'],
                                        'weight'=>$filter['weight'],
                                        'max_sales'=>$filter['max_sales'],
                                        'unit_rate'=>$filter['unit_rate'],
                                        'sales_pro_desc'=>$filter['sales_pro_desc'],
                                        'id'=>$filter['id'],
                                        'AdditionsCount'=>$filter['AdditionsCount'],
                                        'AV'=>$filter['AV'],
                                        'img'=>$filter['img'],



                                    ]);
                                }



                        }

                    }
                }

            }

        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }


    //FaveProductFilter
    public function FaveProductFilter(Request $request,SalesService $service){



        $store = $request->get('store_id');
        $client = $request->get('client_id');
        $Brand='';
        $Group='';



        $Prods=$this->FilterSalesProductQtyAll($store);
        $data=$this->FilterSalesProductAllResturant();



        $total_row = $Prods->count();
        $total_row2 = $data->count();
        $total_row3 = $total_row + $total_row2;
        if($total_row3 > 0)
        {

            if(count($Prods) != 0) {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($Prods as $rows) {

if($rows->Product()->first()->Faveorite == 1){
                    if($rows->Store == $store) {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if (!empty($rows->Product()->first()->Weight)) {
                            $weigh = $rows->Product()->first()->Weight;
                        } else {
                            $weigh = 0;
                        }

                        if (!empty($rows->Product()->first()->Maximum_Sales_Qty)) {
                            $maxSa = $rows->Product()->first()->Maximum_Sales_Qty;
                        } else {
                            $maxSa = 0;
                        }

                        if (!empty($rows->Product()->first()->Group()->first()->Discount)) {
                            $Higher = $rows->Product()->first()->Group()->first()->Discount;
                        } else {

                            $Higher = 0;
                        }

                        if (!empty($rows->Product()->first()->Brand)) {

                            $branddX = $rows->Product()->first()->Brand;
                            if (app()->getLocale() == 'ar') {
                                $brandd = $rows->Product()->first()->Brand()->first()->Name;

                            } else {
                                $brandd = $rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        } else {

                            $brandd = "";
                            $branddX = "";

                        }


                        if ($showw->Group_Brand == 1) {

                            if (app()->getLocale() == 'ar') {
                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->Name . ') ';
                            } else {

                                $ShowGrBr = '(' . $brandd . ') (' . $rows->Product()->first()->Group()->first()->NameEn . ') ';
                            }
                        } else {
                            $ShowGrBr = '';
                        }


                        if (app()->getLocale() == 'ar') {
                            $PrrroName = $rows->P_Ar_Name;
                            $UniiName = $rr->Unit()->first()->Name;
                            $StoreNemo = $st->Name;

                        } else {
                            $PrrroName = $rows->P_En_Name;
                            $UniiName = $rr->Unit()->first()->NameEn;
                            $StoreNemo = $st->NameEn;

                        }

                        if(!empty($rows->Product()->first()->Image)){
                            $img=$rows->Product()->first()->Image;
                        }else{
                            $img='';
                        }

                        if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions') {
                            $type = 1;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rr->Barcode;
                        } elseif ($rows->Product()->first()->P_Type == 'Serial') {
                            $type = 2;
                            $v_name = '';
                            $vv_name = '';
                            $serial = 1;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {

                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;

                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;

                            }

                            $type = 3;
                            $v_name = $PrrroVName;
                            $vv_name = '';
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                            if (app()->getLocale() == 'ar') {
                                $PrrroVName = $rows->V1()->first()->Name;
                                $PrrroVVName = $rows->V2()->first()->Name;
                            } else {
                                $PrrroVName = $rows->V1()->first()->NameEn;
                                $PrrroVVName = $rows->V2()->first()->NameEn;
                            }

                            $type = 4;
                            $v_name = $PrrroVName;
                            $vv_name = $PrrroVVName;
                            $serial = 0;
                            $p_code = $rows->P_Code;
                        }

                            $Filter = [

                                'client' => $client,
                                'store' => $store,
                                'product' => $rows->Product,
                                'id' => $rows->id,
                                'name_ar' => $rows->P_Ar_Name,
                                'name_en' => $rows->P_En_Name,
                                'v1' => $rows->V1,
                                'v2' => $rows->V2,
                                'type' => $type,
                                'PrrroName' => $PrrroName,
                                'UniiName' => $UniiName,
                                'StoreNemo' => $StoreNemo,
                                'weigh' => $weigh,
                                'maxSa' => $maxSa,
                                'P_Code' => $p_code,
                                'qty' => $rows->Qty / $rr->Rate,
                                'Original' => $rows->Original,
                                'Patch_Number' => $rows->Patch_Number,
                                'brandd' => $brandd,
                                'ShowGrBr' => $ShowGrBr,
                                'Higher' => $Higher,
                                'v_name' => $v_name,
                                'vv_name' => $vv_name,
                                'serial' => $serial,
                                'Exp_Date' => $rows->Exp_Date,
                                'pro_store' => $rows->Store,
                                'AdditionsCount'=>$AdditionsCount,
                                'img'=>$img,



                            ];



                            $filter = $service->ItemsFilterResturantCatApi($Filter);

                            if (count($filter) != 0) {
                                array_push($Array, [

                                    'row_id' => $filter['row_id'],
                                    'product_name' => $filter['product_name'],
                                    'product_ar_name' => $filter['product_ar_name'],
                                    'product_en_name' => $filter['product_en_name'],
                                    'product_id' => $filter['product_id'],
                                    'virable_one_id' => $filter['virable_one_id'],
                                    'virable_two_id' => $filter['virable_two_id'],
                                    'virable_one_name' => $filter['virable_one_name'],
                                    'virable_two_name' => $filter['virable_two_name'],
                                    'product_code' => $filter['product_code'],
                                    'unit_name' => $filter['unit_name'],
                                    'unit_id' => $filter['unit_id'],
                                    'unit_default' => $filter['unit_default'],
                                    'units' => $filter['units'],
                                    'code_default' => $filter['code_default'],
                                    'tax_rate' => $filter['tax_rate'],
                                    'tax_type' => $filter['tax_type'],
                                    'tax_id' => $filter['tax_id'],
                                    'avalible_qty' => $filter['avalible_qty'],
                                    'qty' => $filter['qty'],
                                    'price' => $filter['price'],
                                    'priceOne' => $filter['priceOne'],
                                    'priceTwo' => $filter['priceTwo'],
                                    'priceThree' => $filter['priceThree'],
                                    'discount' => $filter['discount'],
                                    'total_disc_pro' => $filter['total_disc_pro'],
                                    'total_before_tax' => $filter['total_before_tax'],
                                    'tax_value' => $filter['tax_value'],
                                    'total' => $filter['total'],
                                    'store_id' => $filter['store_id'],
                                    'store_name' => $filter['store_name'],
                                    'ExpDate' => $filter['ExpDate'],
                                    'serial' => $filter['serial'],
                                    'high_disc' => $filter['high_disc'],
                                    'cost_price' => $filter['cost_price'],
                                    'weight' => $filter['weight'],
                                    'max_sales' => $filter['max_sales'],
                                    'unit_rate' => $filter['unit_rate'],
                                    'sales_pro_desc' => $filter['sales_pro_desc'],
                                    'AdditionsCount' => $filter['AdditionsCount'],
                                    'img' => $filter['img'],


                                ]);
                            }


                    }
    
}
                }

            }else{

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                $Array=[];
                foreach($data as $rows){

if($rows->Product()->first()->Faveorite == 1){
                    $ser_x=1;
                    $ser_y=1;






                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;

                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){



                                if(!empty($rows->Product()->first()->Image)){
                                    $img=$rows->Product()->first()->Image;
                                }else{
                                    $img='';
                                }
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'id'=>$rows->id,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'AdditionsCount'=>$AdditionsCount,
                                    'AV'=>$avv,
                                    'img'=>$img,


                                ];

                                $filter = $service->ItemsFilterTwoResturantCatApi($Filter);
                                if(count($filter) != 0) {
                                    array_push($Array, [



                                        'product_name'=>$filter['product_name'],
                                        'product_ar_name'=>$filter['product_ar_name'],
                                        'product_en_name'=>$filter['product_en_name'],
                                        'product_id'=>$filter['product_id'],
                                        'virable_one_id'=>$filter['virable_one_id'],
                                        'virable_two_id'=>$filter['virable_two_id'],
                                        'virable_one_name'=>$filter['virable_one_name'],
                                        'virable_two_name'=>$filter['virable_two_name'],
                                        'product_code'=>$filter['product_code'],
                                        'unit_name'=>$filter['unit_name'],
                                        'unit_id'=>$filter['unit_id'],
                                        'unit_default'=>$filter['unit_default'],
                                        'units'=>$filter['units'],
                                        'code_default'=>$filter['code_default'],
                                        'tax_rate'=>$filter['tax_rate'],
                                        'tax_type'=>$filter['tax_type'],
                                        'tax_id'=>$filter['tax_id'],
                                        'avalible_qty'=>$filter['avalible_qty'],
                                        'qty'=>$filter['qty'],
                                        'price'=>$filter['price'],
                                        'priceOne'=>$filter['priceOne'],
                                        'priceTwo'=>$filter['priceTwo'],
                                        'priceThree'=>$filter['priceThree'],
                                        'discount'=>$filter['discount'],
                                        'total_disc_pro'=>$filter['total_disc_pro'],
                                        'total_before_tax'=>$filter['total_before_tax'],
                                        'tax_value'=>$filter['tax_value'],
                                        'total'=>$filter['total'],
                                        'store_id'=>$filter['store_id'],
                                        'store_name'=>$filter['store_name'],
                                        'ExpDate'=>$filter['ExpDate'],
                                        'serial'=>$filter['serial'],
                                        'high_disc'=>$filter['high_disc'],
                                        'cost_price'=>$filter['cost_price'],
                                        'weight'=>$filter['weight'],
                                        'max_sales'=>$filter['max_sales'],
                                        'unit_rate'=>$filter['unit_rate'],
                                        'sales_pro_desc'=>$filter['sales_pro_desc'],
                                        'id'=>$filter['id'],
                                        'AdditionsCount'=>$filter['AdditionsCount'],
                                        'AV'=>$filter['AV'],
                                        'img'=>$filter['img'],



                                    ]);
                                }



                        }

                    }
                }
                }

            }

        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }


    //ResturantWaiters
    public function ResturantWaiters(Request $request){


        $groups=Employess:: where('Emp_Type','Waiter')->where("EmpSort",1)->where('Active',1)->get();
        $data=EmployessWitersResources::collection($groups);
        return $this->returnData('data', $data);


    }


    //ResturantAdditionsProducts
    public function ResturantAdditionsProducts(Request $request){

        $Pro = $request->get('product_id');
        $Prods=AdditionalProducts::where('Product',$Pro)->get();
        $data=ResturantAdditionsProductsResources::collection($Prods);
        return $this->returnData('data', $data);

    }


    //ResturantVAssemblyQtyFilter
    function ResturantVAssemblyQtyFilter(Request $request,Average $average)
    {

        $pro=request('product_id');
        $store=request('store_id');
        $ProNote=VAPrice::where('Product',$pro)->get();
        $data=ResturantVAssemblyQtyFilterResources::collection($ProNote);
        return $this->returnData('data', $data);

    }



    //  ================  Tables  =======================

    //ResturantReservedTables
    public function ResturantReservedTables(Request $request){

        $Tables=ResturantTables::get();
        $data=ResturantTablesPOSResources::collection($Tables);
        return $this->returnData('data', $data);


    }


    //ResturantAVTables
    public function ResturantAVTables(Request $request){

        $Tables=ResturantTables::get();
        $data=ResturantTablesPOSAVResources::collection($Tables);
        return $this->returnData('data', $data);


    }



//ResturantAddNewTable

    public function ResturantAddNewTable(Request $request){

        try {
            DB::beginTransaction();



        $data['Arabic_Name']=request('TableName');
        $data['English_Name']=request('TableName');
        $data['Place_Ar']=request('TablePlace');
        $data['Place_En']=request('TablePlace');
        $data['Table_Number']=request('TableNumber');
        $data['Chairs_Num']=request('ChairsNum');
        ResturantTables::create($data);

        $table=ResturantTables::orderBy('id','desc')->first();
        $dataa['QR']=URL::to('/ScanQR?Table='.$table->id);
        ResturantTables::where('id',$table->id)->update($dataa);
            DB::commit();

            return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ]);
        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    //AllTablesReservedHall
    public function AllTablesReservedHall(Request $request){

        $Tables=ResturantTables::get();
        $data=ResturantTablesPOSNotAVResources::collection($Tables);
        return $this->returnData('data', $data);

    }


    //PostMergTablesApi

    public function PostMergTablesApi(Request $request){



        try {
            DB::beginTransaction();


            $lang = $request->header('lang', '');


        $Orders=request('order_id');

        $xx=SalesOrder::
        where('Table',request('table_id'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();

        for($i=0 ; $i  < count($Orders) ; $i++ ){

            $SalesOrder=SalesOrder::find($Orders[$i]);

            if($SalesOrder->Table != request('MainTable')){

                $Prodcts=ProductSalesOrder::where('SalesOrder',$SalesOrder->id)->get();

                foreach($Prodcts  as $pro){
                    $uu['Product_Code']=$pro->Product_Code;
                    $uu['P_Ar_Name']=$pro->P_Ar_Name;
                    $uu['P_En_Name']=$pro->P_En_Name;
                    $uu['V_Name']=$pro->V_Name;
                    $uu['VV_Name']=$pro->VV_Name;
                    $uu['Original_Qty']=$pro->Original_Qty;
                    $uu['Qty']=$pro->Qty;
                    $uu['AvQty']=$pro->AvQty;
                    $uu['Price']=$pro->Price;
                    $uu['Discount']=$pro->Discount;
                    $uu['Tax']=$pro->Tax;
                    $uu['Total_Bf_Tax']=$pro->Total_Bf_Tax;
                    $uu['Total_Tax']=$pro->Total_Tax;
                    $uu['Total']=$pro->Total;
                    $uu['Store']=$pro->Store;
                    $uu['Product']=$pro->Product;
                    $uu['Unit']=$pro->Unit;
                    $uu['Exp_Date']=$pro->Exp_Date;
                    $uu['SalesOrder']=$xx->id;
                    $uu['V1']=$pro->V1;
                    $uu['V2']=$pro->V2;
                    $uu['SubVID']=$pro->SubVID;
                    $uu['TDiscount']=$pro->TDiscount;
                    $uu['Pro_Note']=$pro->Pro_Note;
                    ProductSalesOrder::create($uu);
                }



                $xxx=SalesOrder::
                where('Table',request('table_id'))
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();
                $OldOne=SalesOrder::find($Orders[$i]);

                $Product_Numbers=$xxx->Product_Numbers + $OldOne->Product_Numbers;
                $Total_Qty=$xxx->Total_Qty + $OldOne->Total_Qty;
                $Total_Discount=$xxx->Total_Discount + $OldOne->Total_Discount;
                $Total_BF_Taxes=$xxx->Total_BF_Taxes + $OldOne->Total_BF_Taxes;
                $Total_Taxes=$xxx->Total_Taxes + $OldOne->Total_Taxes;
                $Total_Price=$xxx->Total_Price + $OldOne->Total_Price;
                $Pay=$xxx->Pay + $OldOne->Pay;

                SalesOrder::where('id',$xxx->id)->update([
                    'Product_Numbers'=>$Product_Numbers,
                    'Total_Qty'=>$Total_Qty,
                    'Total_Discount'=>$Total_Discount,
                    'Total_BF_Taxes'=>$Total_BF_Taxes,
                    'Total_Taxes'=>$Total_Taxes,
                    'Total_Price'=>$Total_Price,
                    'Pay'=>$Pay,

                ]);

                SalesOrder::where('id',$Orders[$i])->delete();

            }



        }


            DB::commit();

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //PostMovingApi

    public function PostMovingApi(Request $request){

        try {
            DB::beginTransaction();


        $lang = $request->header('lang', '');


        $xx=SalesOrder::
        where('Table',request('table_id'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();


        SalesOrder::where('id',$xx->id)->update(['Table'=>request('MainTable')]);

            DB::commit();
        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);



        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //SeparatingDataTablesApi
    public function SeparatingDataTablesApi(Request $request){


        $Tables=ResturantTables::get();
        $data=SeparatingDataTablesResources::collection($Tables);
        return $this->returnData('data', $data);


    }


    //PostSeparatingApi

    public function PostSeparatingApi(Request $request){

        try {
            DB::beginTransaction();

        $lang = $request->header('lang', '');


        $xx=SalesOrder::find(request('order_id'));

        $ProID=request('pro_id');


        $ID = DB::table('sales_orders')->insertGetId(
            array(


                'Date' => $xx->Date,
                'Draw' =>$xx->Draw,
                'Payment_Method' =>$xx->Payment_Method,
                'Status' => $xx->Status,
                'Refernce_Number' => $xx->Refernce_Number,
                'Note' => $xx->Note,
                'Product_Numbers' =>0,
                'Total_Qty' => 0,
                'Total_Discount' => 0,
                'Total_BF_Taxes' =>0,
                'Total_Taxes' => 0,
                'Total_Price' => 0,
                'Pay' => 0,
                'Safe' => $xx->Safe,
                'ToSales' => 0,
                'Client' => $xx->Client,
                'Delegate' => $xx->Delegate,
                'Executor' => $xx->Executor,
                'Store' =>  $xx->Store,
                'Coin' =>  $xx->Coin,
                'Cost_Center' => null,
                'presenter' =>$xx->presenter,
                'annual_interest' => $xx->annual_interest,
                'monthly_installment' => $xx->monthly_installment,
                'Years_Number' =>$xx->Years_Number,
                'total' => $xx->total,
                'Order_Type' => 'Resturant',

                'TakeawayStatus' => 0,
                'TakeawayTime' => null,
                'Witer' => $xx->Witer,
                'KitchenEnd' => $xx->KitchenEnd,
                'KitchenEndTime' => $xx->KitchenEndTime,
                'RecivedOrder' => 0,
                'RecivedOrderTime' => null,
                'Delivery_Status' =>0,
                'DeliveryTime' => null,
                'ResturantOrderType' => $xx->ResturantOrderType,
                'Table' => request('MainTable'),

                'Quote' => null,
                'Hold' => 1,
                'installment_Num' => $xx->installment_Num,
                'Date_First_installment' => $xx->Date_First_installment,
                'User' => auth()->guard('admin')->user()->id,

            )
        );


        $res=SalesOrder::where('id',$ID)->first();

        $Code=$res->Code;



        for($i=0 ; $i < count($ProID) ; $i++){
            $Prodct=ProductSalesOrder::find($ProID[$i]);

            $uu['Product_Code']=$Prodct->Product_Code;
            $uu['P_Ar_Name']=$Prodct->P_Ar_Name;
            $uu['P_En_Name']=$Prodct->P_En_Name;
            $uu['V_Name']=$Prodct->V_Name;
            $uu['VV_Name']=$Prodct->VV_Name;
            $uu['Original_Qty']=$Prodct->Original_Qty;
            $uu['Qty']=$Prodct->Qty;
            $uu['AvQty']=$Prodct->AvQty;
            $uu['Price']=$Prodct->Price;
            $uu['Discount']=$Prodct->Discount;
            $uu['Tax']=$Prodct->Tax;
            $uu['Total_Bf_Tax']=$Prodct->Total_Bf_Tax;
            $uu['Total_Tax']=$Prodct->Total_Tax;
            $uu['Total']=$Prodct->Total;
            $uu['Store']=$Prodct->Store;
            $uu['Product']=$Prodct->Product;
            $uu['Unit']=$Prodct->Unit;
            $uu['Exp_Date']=$Prodct->Exp_Date;
            $uu['SalesOrder']=$ID;
            $uu['V1']=$Prodct->V1;
            $uu['V2']=$Prodct->V2;
            $uu['SubVID']=$Prodct->SubVID;
            $uu['TDiscount']=$Prodct->TDiscount;
            $uu['Pro_Note']=$Prodct->Pro_Note;
            ProductSalesOrder::create($uu);

            $xxx=SalesOrder::find(request('order_id'));



            $Product_Numbers=$xxx->Product_Numbers - 1;
            $Total_Qty=$xxx->Total_Qty - $Prodct->Qty;
            $Total_Discount=$xxx->Total_Discount - $Prodct->Discount;
            $Total_BF_Taxes=$xxx->Total_BF_Taxes - $Prodct->Total_Bf_Tax;
            $Total_Taxes=$xxx->Total_Taxes - $Prodct->Total_Tax;
            $Total_Price=$xxx->Total_Price - $Prodct->Total;
            $Pay=null;

            SalesOrder::where('id',$xxx->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            $xxxM=SalesOrder::find($ID);


            $Product_NumbersM=$xxxM->Product_Numbers + 1;
            $Total_QtyM=$xxxM->Total_Qty + $Prodct->Qty;
            $Total_DiscountM=$xxxM->Total_Discount + $Prodct->Discount;
            $Total_BF_TaxesM=$xxxM->Total_BF_Taxes + $Prodct->Total_Bf_Tax;
            $Total_TaxesM=$xxxM->Total_Taxes + $Prodct->Total_Tax;
            $Total_PriceM=$xxxM->Total_Price + $Prodct->Total;
            $PayM=null;

            SalesOrder::where('id',$xxxM->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            ProductSalesOrder::where('id',$ProID[$i])->delete();

        }


            DB::commit();

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);


        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //  ================  Sales and Hold  =======================


    //Sales Resturant

    public function ResturantSalesSechdule(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        $items=Sales::latest('id')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->paginate(10);


        $total_cash=Sales::where('Payment_Method','Cash')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_later=Sales::where('Payment_Method','Later')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_check=Sales::where('Payment_Method','Check')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_install=Sales::where('Payment_Method','Installment')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_cash_visa=Sales::where('Payment_Method','Cash_Visa')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_cash_collectionr=Sales::where('Payment_Method','Cash_Collection')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_delivery=Sales::where('Payment_Method','Delivery')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_install_companies=Sales::where('Payment_Method','InstallmentCompanies')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');



        $total_visa=Sales::where('Payment_Method','Visa_Network')->where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Net');


        $total_discount=Sales::where('Delete',0)->where('Edit',0)
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Sale_Type','Resturant')->get()->sum('Total_Discount');

        $total_return=ReturnSales::where('Delegate',$admin->emp)->get()->sum('Total_Return_Value');




        $data=SalesResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_cash'=>$total_cash,
            'total_later'=>$total_later,
            'total_check'=>$total_check,
            'total_install'=>$total_install,
            'total_cash_visa'=>$total_cash_visa,
            'total_cash_collectionr'=>$total_cash_collectionr,
            'total_delivery'=>$total_delivery,
            'total_install_companies'=>$total_install_companies,
            'total_visa'=>$total_visa,
            'total_discount'=>$total_discount,
            'total_return'=>$total_return,

        ];
        return $data->additional($x) ;
    }

    public function FilterResturantSalesSechdule(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        $Code=request('Code');
        $User=request('User');
        $Store=request('Store');
        $Client=request('Client');
        $Coin=request('Coin');
        $Safe=request('Safe');
        $Payment_Method=request('Payment_Method');
        $Cost_Center=request('Cost_Center');
        $Delegate=request('Delegate');
        $Executor=request('Executor');
        $From=request('From');
        $To=request('To');


        $items=Sales::latest('id')->where('Status',1)->where('Sale_Type','Resturant')->where('Delegate',$admin->emp)->where('Delete',0)->where('Edit',0)


            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->paginate(10);



        $total_cash=Sales::where('Payment_Method','Cash')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_later=Sales::where('Payment_Method','Later')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_check=Sales::where('Payment_Method','Check')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_install=Sales::where('Payment_Method','Installment')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_cash_visa=Sales::where('Payment_Method','Cash_Visa')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_cash_collectionr=Sales::where('Payment_Method','Cash_Collection')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_delivery=Sales::where('Payment_Method','Delivery')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_install_companies=Sales::where('Payment_Method','InstallmentCompanies')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');



        $total_visa=Sales::where('Payment_Method','Visa_Network')->where('Sale_Type','Resturant')->where('Delete',0)->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Net');


        $total_discount=Sales::where('Delete',0)->where('Sale_Type','Resturant')->where('Edit',0)
            ->when(!empty($Code), function ($query) use ($Code) {
                $query->where('Code', $Code);
            })


            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                $query->where('Store', $Store);
            })




            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                $query->where('Coin', $Coin);
            })




            ->when(!empty($Safe), function ($query) use ($Safe) {
                $query->where('Safe', $Safe);
            })


            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                $query->where('Payment_Method', $Payment_Method);
            })




            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                $query->where('Cost_Center', $Cost_Center);
            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                $query->where('Delegate', $Delegate);
            })




            ->when(!empty($Executor), function ($query) use ($Executor) {
                $query->where('Executor', $Executor);
            })


            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Status',1)->where('Delegate',$admin->emp)->where('Payment_Method','!=','Delivery')->get()->sum('Total_Discount');

        $total_return=ReturnSales::where('Delegate',$admin->emp)->get()->sum('Total_Return_Value');




        $data=SalesResources::collection($items);
        $x=['status'=>200,'msg'=>trans('admin.Success'),
            'total_cash'=>$total_cash,
            'total_later'=>$total_later,
            'total_check'=>$total_check,
            'total_install'=>$total_install,
            'total_cash_visa'=>$total_cash_visa,
            'total_cash_collectionr'=>$total_cash_collectionr,
            'total_delivery'=>$total_delivery,
            'total_install_companies'=>$total_install_companies,
            'total_visa'=>$total_visa,
            'total_discount'=>$total_discount,
            'total_return'=>$total_return,

        ];
        return $data->additional($x) ;
    }

    public function AddSalesBillResturant(Request $request,SalesService $service){

        try {
            DB::beginTransaction();

            $rules = [
                'Date'=>'required',
                'Store'=>'required',
                'Safe'=>'required',
                'Coin'=>'required',
                'Draw'=>'required',
                'Payment_Method'=>'required',
                'Status'=>'required',
                'Client'=>'required',
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();

            $Sale_Type='Resturant';

            //Service Create New Bill
            $ID=$service->CreateNewSalesBillApi($request->all(),$Sale_Type,$admin->id);



            //Event New Bill

            $result=SalesEventApi::dispatch($request->all(),$ID,$Sale_Type,$admin->id);


            if($result[0] == 5){
                DB::rollBack();
                return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
            }




            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));

        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }




    }

    public function EditResturantSalesApi(Request $request,SalesService $service){

        try {
            DB::beginTransaction();

            $rules = [
                'Date'=>'required',
                'Store'=>'required',
                'Safe'=>'required',
                'Coin'=>'required',
                'Draw'=>'required',
                'Payment_Method'=>'required',
                'Status'=>'required',
                'Client'=>'required',
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();

            $id=request('bill_id');

            $del=Sales::find($id);
            Sales::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);

            $Returns=ReturnSales::where('Sales',$del->id)->get();
            if(!empty($Returns)){

                foreach($Returns as $return){
                    GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->delete();
                    Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                    StoresMoves::where('ID',$return->id)->where('Type','مرتجع مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                    ReturnPurch::where('id',$return->id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                }
            }

            Notifications::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            Event::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            Journalizing::where('Code_Type',$del->Code)->where('Type','المبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            StoresMoves::where('ID',$del->id)->where('Type','مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            Installment::where('Sales',$del->id)->delete();



            $Sale_Type='Resturant';

            //Service Create New Bill
            $ID=$service->CreateNewSalesBillApi($request->all(),$Sale_Type,$admin->id);



            //Event New Bill

            $result=SalesEventApi::dispatch($request->all(),$ID,$Sale_Type,$admin->id);


            if($result[0] == 5){
                DB::rollBack();
                return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
            }




            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>request('Old_Code'),
                'explain_en'=>request('Old_Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));

        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }




    }

    public function DeleteResturantSalesApi(Request $request,SalesService $service){


        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();



            $id=request('bill_id');
            $del=Sales::find($id);
            Sales::where('id',$id)->update(['Delete'=>1]);

            $Returns=ReturnSales::where('Sales',$del->id)->get();
            if(!empty($Returns)){

                foreach($Returns as $return){
                    GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->delete();
                    Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->update(['Delete'=>1]);
                    StoresMoves::where('ID',$return->id)->where('Type','مرتجع مبيعات')->update(['Delete'=>1]);
                    ReturnPurch::where('id',$return->id)->update(['Delete'=>1]);
                }
            }

            Notifications::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            Event::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->update(['Delete'=>1]);
            Journalizing::where('Code_Type',$del->Code)->where('Type','المبيعات')->update(['Delete'=>1]);
            StoresMoves::where('ID',$del->id)->where('Type','مبيعات')->update(['Delete'=>1]);
            Installment::where('Sales',$del->id)->delete();


            //Service

            $service->RemoveQties($id,1,0);


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);


            DB::commit();
            return $this->returnSuccessMessage(trans('admin.Deleted'));
        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }



    }


    // ========== Hold Bills ===================

    //HoldBills
    public function ResturantHoldBills(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if($admin->pos_stores == 0){
            $HoldSales=SalesOrder::where('Delete',0)->where('Edit',0)->where('Order_Type','Resturant')->where('ToSales',0)->where('Hold',1)->where('Store',$admin->store)->get();
        }else{

            $HoldSales=SalesOrder::where('Delete',0)->where('Edit',0)->where('Order_Type','Resturant')->where('ToSales',0)->where('Hold',1)->get();
        }

        $Array=array();
        foreach($HoldSales as $sal){

            if($lang == 'ar'){

                $cliName=$sal->Client()->first()->Name;
                $useName=$sal->User()->first()->name;
            }else{

                $cliName=$sal->Client()->first()->NameEn;
                $useName=$sal->User()->first()->nameEn;

            }

            array_push($Array,[
                'bill_id'=>$sal->id,
                'bill_code'=>$sal->Code,
                'date'=>$sal->Date,
                'client_name'=>$cliName,
                'user_name'=>$useName,
                'total_price'=>$sal->Total_Price,
            ]);
        }
        ;

        return  $this->returnData('data',$Array);

    }


    public function FilterResturantHoldBills(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        $search=request('hold_bill_code');

        if($admin->pos_stores == 0){
            $HoldSales=SalesOrder::where('Delete',0)->where('Edit',0)->where('Order_Type','Resturant')->where('ToSales',0)->where('Hold',1)->where('Code',$search)->where('Store',$admin->store)->get();
        }else{

            $HoldSales=SalesOrder::where('Delete',0)->where('Edit',0)->where('Order_Type','Resturant')->where('ToSales',0)->where('Hold',1)->where('Code',$search)->get();
        }

        $Array=array();
        foreach($HoldSales as $sal){

            if($lang == 'ar'){

                $cliName=$sal->Client()->first()->Name;
                $useName=$sal->User()->first()->name;
            }else{

                $cliName=$sal->Client()->first()->NameEn;
                $useName=$sal->User()->first()->nameEn;

            }


            array_push($Array,[
                'bill_code'=>$sal->Code,
                'date'=>$sal->Date,
                'client_name'=>$cliName,
                'user_name'=>$useName,
                'total_price'=>$sal->Total_Price,
            ]);
        }

        return  $this->returnData('data',$Array);

    }


    public function HoldResturantBillDetails(Request $request){

        $id = $request->get('bill_id');
        $item=SalesOrder::findOrFail($id);
        $data=SalesOrderResources::make($item);
        return $this->returnData('data',$data);


    }


    public function DeleteResturantHoldBill(Request $request,SalesService $service){

        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();



            $id=request('bill_id');
            $del=SalesOrder::find($id);

            SalesOrder::where('id',$id)->update(['Delete'=>1]);
            Event::where('Type_Code',$del->Code)->where('Type','امر البيع')->delete();
            Notifications::where('Type_Code',$del->Code)->where('Type','امر بيع')->delete();

            if($del->Hold_Qty == 1){


                $service->RemoveHoldQties($id);


            }


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'امر بيع',
                'screen_en'=>'Sales Order',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);

            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Deleted'));

        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }




    }

    public function AddResturantHoldBill(Request $request,SalesService $service){

        try {
            DB::beginTransaction();

            $rules = [
                'Date'=>'required',
                'Store'=>'required',
                'Safe'=>'required',
                'Coin'=>'required',
                'Draw'=>'required',
                'Payment_Method'=>'required',
                'Status'=>'required',
                'Client'=>'required',
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();


            $Sale_Type='Resturant';

            $ID=$service->CreateNewSalesOrderApi($request->all(),$Sale_Type,$admin->id);

            //Event New Bill
            $result=SalesOrderEvent::dispatch($request->all(),$ID,$Sale_Type);


            if($result[0] == 5){
                DB::rollBack();
                return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
            }


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'امر بيع',
                'screen_en'=>'Sales Order',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));

        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }




    }


    public function HoldPostResturantPOS(Request $request,SalesService $service){


        try {
            DB::beginTransaction();

            $id=request('bill_id');

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();



            if(request('Hold') == 0){


                $rules = [
                    'Date'=>'required',
                    'Store'=>'required',
                    'Safe'=>'required',
                    'Coin'=>'required',
                    'Draw'=>'required',
                    'Payment_Method'=>'required',
                    'Status'=>'required',
                    'Client'=>'required',
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }

                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }
                $admin=Admin::where('token',$x)->first();


                $del=SalesOrder::find($id);
                SalesOrder::where('id',$id)->update(['ToSales'=>1]);
                Event::where('Type_Code',$del->Code)->where('Type','امر البيع')->delete();
                Notifications::where('Type_Code',$del->Code)->where('Type','امر بيع')->delete();

                if($del->Hold_Qty == 1){
                    $result=$service->RemoveHoldQties($id);

                    if ($result == 5){
                        DB::rollBack();
                        return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));

                    }
                }

                $Sale_Type='Resturant';

                //Service Create New Bill
                $ID=$service->CreateNewSalesBillApi($request->all(),$Sale_Type,$admin->id);



                //Event New Bill

                $result=SalesEventApi::dispatch($request->all(),$ID,$Sale_Type,$admin->id);


                if($result[0] == 5){
                    DB::rollBack();
                    return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
                }




                $dataUser=[
                    'id'=>$admin->id,
                    'screen_ar'=>'المبيعات',
                    'screen_en'=>'Sales',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);

                DB::commit();

                return $this->returnSuccessMessage(trans('admin.Transfered'));

            }else{


                $del=SalesOrder::find($id);

                $NEWCODE=$this->ReturnCode(SalesOrder::class);

                SalesOrder::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>$NEWCODE]);
                Event::where('Type_Code',$del->Code)->where('Type','امر البيع')->delete();
                Notifications::where('Type_Code',$del->Code)->where('Type','امر بيع')->delete();

                if($del->Hold_Qty == 1){


                    $service->RemoveHoldQties($id);


                }

                $Sale_Type='Resturant';

                $ID=$service->CreateNewSalesOrderApi($request->all(),$Sale_Type,$admin->id);

                //Event New Bill
                $result=SalesOrderEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
                }


                $dataUser=[
                    'id'=>$admin->id,
                    'screen_ar'=>'امر بيع',
                    'screen_en'=>'Sales Order',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);


                DB::commit();

                return $this->returnSuccessMessage(trans('admin.Updated'));



            }



        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }





    }


    // ========== Hold Halls Bills ===================

    //More Product in Hall Bill
    public function AddProHallOrder(Request $request){

        try {
            DB::beginTransaction();


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        if(request('Payment_Method') == 'Cash'){

            if(!empty(request('Pay'))){

                $paid = request('Pay') ;

            }else{

                $paid = request('Total_Price') ;
            }



        }elseif(request('Payment_Method') == 'Later'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'Installment'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'Check'){

            $paid = request('Total_Price') ;

        }elseif(request('Payment_Method') == 'Cash_Visa'){

            $paid = request('Total_Price') ;

        }elseif(request('Payment_Method') == 'Cash_Collection'){

            $paid = request('Cash_Collection') ;

        }elseif(request('Payment_Method') == 'Delivery'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'InstallmentCompanies'){

            $paid = request('Total_Price') ;

        }



        if(request('Payment_Method') == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        $ID=request('ID');


        $data['Draw'] = request('Draw');
        $data['Payment_Method'] = request('Payment_Method');
        $data['Status'] = request('Status');
        $data['Refernce_Number'] = request('Refernce_Number');
        $data['Note'] = request('Note');
        $data['Product_Numbers'] = request('Product_Numbers');
        $data['Total_Qty'] = request('Total_Qty');
        $data['Total_Discount'] = request('Total_Discount') + request('DiscountBill');
        $data['Total_BF_Taxes'] = request('Total_BF_Taxes');
        $data['Total_Taxes'] = request('Total_Taxes');
        $data['Total_Price'] = request('Total_Price');
        $data['DiscountBill'] = request('DiscountBill');
        $data['Pay'] = $paid;
        $data['Safe'] = request('Safe');
        $data['ToSales'] = 0;
        $data['Client'] = request('Client');
        $data['Delegate'] = request('Delegate');
        $data['Executor'] = request('Executor');
        $data['Store'] = request('Store');
        $data['Coin'] = request('Coin');
        $data['Cost_Center'] = null;
        $data['presenter'] = request('presenter');
        $data['annual_interest'] = request('annual_interest');
        $data['monthly_installment'] = request('monthly_installment');
        $data['Years_Number'] = request('Years_Number');
        $data['total'] = request('total');
        $data['Order_Type'] = 'Resturant';
        $data['Witer'] = request('Waiter');
        $data['ResturantOrderType'] = request('ResturantOrderType');
        $data['Table'] = request('Table');
        $data['Quote'] = null;
        $data['Hold'] = 1;
        $data['installment_Num'] = request('installment_Num');
        $data['Date_First_installment'] = request('Date_First_installment');
        $data['User'] = auth()->guard('admin')->user()->id;

        SalesOrder::where('id',$ID)->update($data);

        $Code=request('Code');



        if(!empty(request('Unit'))){

            ProductSalesOrder::where('SalesOrder',$ID)->delete();


            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $AvQty=request('AvQty');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $PurchTax=request('PurchTax');
            $Total=request('Total');
            $StorePurch=request('StorePurch');
            $Exp_Date=request('Exp_Date');
            $Product=request('Product');
            $VOne=request('VOne');
            $VTwo=request('VTwo');
            $V_Name=request('V_Name');
            $VV_Name=request('VV_Name');
            $Exp_Date=request('Exp_Date');
            $TDiscount=request('TDiscPro');
            $Pro_Note=request('Pro_Note');
            $SubVID=request('SubVID');
            $MorePro=request('MorePro');
            $CostPrice=request('CostPrice');
            $TotCostNew=request('TotCostNew');
            $Total_Net=request('Total_Net');

            for($i=0 ; $i < count($Unit) ; $i++){


                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['AvQty']=$AvQty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['SalesOrder']=$ID;
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['SubVID']=$SubVID[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['Pro_Note']=$Pro_Note[$i];
                $uu['CostPrice']=$CostPrice[$i];
                $uu['TotCostNew']=$TotCostNew[$i];
                $uu['Total_Net']=$Total_Net[$i];
                ProductSalesOrder::create($uu);


                if($MorePro[$i] == 1){

                    $uuu['Product_Code']=$P_Code[$i];
                    $uuu['P_Ar_Name']=$P_Ar_Name[$i];
                    $uuu['P_En_Name']=$P_En_Name[$i];
                    $uuu['V_Name']=$V_Name[$i];
                    $uuu['VV_Name']=$VV_Name[$i];
                    $uuu['Qty']=$Qty[$i];
                    $uuu['AvQty']=$AvQty[$i];
                    $uuu['Price']=$Price[$i];
                    $uuu['Discount']=$Discount[$i];
                    $uuu['Tax']=$PurchTax[$i];
                    $uuu['Total_Bf_Tax']=$TotalBFTax[$i];
                    $uuu['Total_Tax']=$TotalTax[$i];
                    $uuu['Total']=$Total[$i];
                    $uuu['Store']=$StorePurch[$i];
                    $uuu['Product']=$Product[$i];
                    $uuu['Unit']=$Unit[$i];
                    $uuu['Exp_Date']=$Exp_Date[$i];
                    $uuu['SalesOrder']=$ID;
                    $uuu['V1']=$VOne[$i];
                    $uuu['V2']=$VTwo[$i];
                    $uuu['SubVID']=$SubVID[$i];
                    $uuu['Pro_Note']=$Pro_Note[$i];
                    $uuu['KitchenEnd']=0;
                    MoreProductsHall::create($uuu);

                }




            }


        }


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();

            return $this->returnSuccessMessage(trans('admin.Updated'));



        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }



    }


    //DeleteProHallOrder
    public function DeleteProHallOrder(Request $request){

        try {
            DB::beginTransaction();



        $Email = $request->get('email');
        $Pass = $request->get('pass');
        $ProID = $request->get('product_details_id');

        $admin=Admin::where('email',$Email)->first();

        if(!empty($admin)){

            if (Hash::check($Pass, $admin->password)) {


                $Pro=ProductSalesOrder::find($ProID);


                $uuu['Product_Code']=$Pro->Product_Code;
                $uuu['P_Ar_Name']=$Pro->P_Ar_Name;
                $uuu['P_En_Name']=$Pro->P_En_Name;
                $uuu['V_Name']=$Pro->V_Name;
                $uuu['VV_Name']=$Pro->VV_Name;
                $uuu['Qty']=$Pro->Qty;
                $uuu['AvQty']=$Pro->AvQty;
                $uuu['Price']=$Pro->Price;
                $uuu['Discount']=$Pro->Discount;
                $uuu['Tax']=$Pro->Tax;
                $uuu['Total_Bf_Tax']=$Pro->Total_Bf_Tax;
                $uuu['Total_Tax']=$Pro->Total_Tax;
                $uuu['Total']=$Pro->Total;
                $uuu['Store']=$Pro->Store;
                $uuu['Product']=$Pro->Product;
                $uuu['Unit']=$Pro->Unit;
                $uuu['Exp_Date']=$Pro->Exp_Date;
                $uuu['SalesOrder']=$Pro->SalesOrder;
                $uuu['V1']=$Pro->V1;
                $uuu['V2']=$Pro->V2;
                $uuu['SubVID']=$Pro->SubVID;
                $uuu['Pro_Note']=$Pro->Pro_Note;
                $uuu['KitchenEnd']=0;
                RemoveProductsHall::create($uuu);


                ProductSalesOrder::where('id',$ProID)->delete();


                DB::commit();

                return $this->returnSuccessMessage(trans('admin.Success'));




            }else{

                return response()->json([
                    'status'=>402,
                    'msg'=>trans('admin.Fail'),


                ]);
            }


        }else{

            return response()->json([
                'status'=>402,
                'message'=>trans('admin.Fail'),


            ]);

        }





        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }




    }



    //  ================  Kitchens  =======================

    public function KitchenHallBills(Request $request){


        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->paginate(20);


        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

    public function KitchenDeliveryBills(Request $request){

        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->paginate(20);

        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }

    public function KitchenTakeawayBills(Request $request){

        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->paginate(20);


        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }

    public function KitchenHallMoreBills(Request $request){

        $Halls=MoreProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();

        $data=ResturantKitchensHallOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }

    public function KitchenHallRemoveBills(Request $request){

        $Halls=RemoveProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();

        $data=ResturantKitchensRemoveHallOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }


   // ======  End Kitchens Order ===========

    public function EndKitchenOrderTakeDeliv(Request $request){

        Sales::where('id',request('order_id'))->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);
        return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Ended'),
        ]);


    }

    public function EndKitchenOrderHallApi(Request $request){

        SalesOrder::where('id',request('order_id'))->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);

        return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Ended'),


        ]);

    }

    public function EndKitchenOrderHallMoreApi(Request $request){

        MoreProductsHall::where('SalesOrder',request('order_id'))->update(['KitchenEnd'=>1]);
        return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Ended'),


        ]);

    }

    public function EndKitchenOrderHallRemoveApi(Request $request){


        RemoveProductsHall::where('SalesOrder',request('order_id'))->update(['KitchenEnd'=>1]);
        return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Ended'),


        ]);

    }


    //  ================  Recived  =======================

    public function RecivedHallBills(Request $request){

        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->paginate(20);

        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

    public function RecivedDeliveryBills(Request $request){

        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->paginate(20);

        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }

    public function RecivedTakeawayBills(Request $request){

        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->paginate(20);

        $data=ResturantKitchensOrdersResources::collection($Halls);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;

    }


    // ======  End Recived Order ===========

    //    End Recived Order Take and  Delivery
    public function EndRecivedOrderTakeDeliv(Request $request){

        Sales::where('id',request('order_id'))->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);

        return response()->json([
            'status'=>200,
            'msg'=>trans('admin.Ended'),


        ]);


    }


    //End Hall
    public function PostEndRecivedOrderHallApi(Request $request,SalesService $service){

        try {
            DB::beginTransaction();

            $rules = [
                'Date'=>'required',
                'Store'=>'required',
                'Safe'=>'required',
                'Coin'=>'required',
                'Draw'=>'required',
                'Payment_Method'=>'required',
                'Status'=>'required',
                'Client'=>'required',
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Admin::where('token',$x)->first();


                SalesOrder::where('id',request('ID'))->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);
                $Or=SalesOrder::find(request('ID'));



                $Sale_Type='Resturant';

                //Service Create New Bill
                $ID=$service->CreateNewSalesBillApi($request->all(),$Sale_Type,$admin->id);



                //Event New Bill

                $result=SalesEventApi::dispatch($request->all(),$ID,$Sale_Type,$admin->id);


                if($result[0] == 5){
                    DB::rollBack();
                    return  $this->returnSuccessMessage(trans('admin.Not_Enough_Qty'));
                }




                $dataUser=[
                    'id'=>$admin->id,
                    'screen_ar'=>'المبيعات',
                    'screen_en'=>'Sales',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);


                DB::commit();

                return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        }catch(\Exception $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch(\Error $ex){

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }





    }


    
    
    
    
    //Apps

    public function ResturantAppsApi(Request $request){

        $Tables=DeliveryApps::get();
        $data=DeliveryAppsResources::collection($Tables);
        return $this->returnData('data', $data);


    }

        public function ResturantAppsProPricesApi() {


        $states=[];
       
$app=request('app');
$Product=request('Product');
$P_Code=request('P_Code');
       
           $NewApp=DeliveryApps::find($app);
           
           if($NewApp->Type == 2){
           
           for($i=0 ; $i < count($Product) ; $i++){
               
               $xx=AppsChangePrice::where('App',$app)->where('Product',$Product[$i])->where('Barcode',$P_Code[$i])->latest('id')->first();
               
                    $states +=[$Product[$i] => $xx->Price_One];
               
               
           }
           
           }else{
               
                    for($i=0 ; $i < count($Product) ; $i++){
                 $xx=ProductUnits::where('Product',$Product[$i])->where('Barcode',$P_Code[$i])->where('Def',1)->latest('id')->first();
               
                    $states +=[$Product[$i] => $xx->Price];       
                         
           }
               
           }
   
            
     
          
         return $this->returnData('data', $states);

    }

    

    //========================= End Resturant ============================================================






}
