<?php

namespace App\Http\Controllers;



use App\Models\ReportsSettings;
use App\Models\Students;
use Illuminate\Http\Request;
use App\Models\StoresDefaultData;
use App\Models\ItemsGroups;
use App\Models\Brands;
use App\Models\OutcomManufacturingModel;
use App\Models\ProductsStoresTransfers;
use App\Models\Products;
use App\Models\ProductUnits;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\DefaultDataShowHide;
use App\Models\InstallmentDates;
use App\Models\GroupFilter;
use App\Models\Measuerments;
use App\Models\Admin;
use App\Models\Coins;
use App\Models\ProductsStartPeriods;
use App\Models\ProductSettlement;
use App\Models\ProductsPurchases;
use App\Models\ReturnPurchProducts;
use App\Models\ProductSales;
use App\Models\SafeTransfers;
use App\Models\ProductMoves;
use App\Models\CostCenter;
use App\Models\GeneralDaily;
use App\Models\ReciptVoucherDetails;
use App\Models\PaymentVoucherDetails;
use App\Models\AcccountingManual;
use App\Models\Employess;
use App\Models\Shifts;
use App\Models\Sales;
use App\Models\Customers;
use App\Models\ReciptVoucher;
use App\Models\ExchangeCommissions;
use App\Models\ReturnMaintainceBill;
use App\Models\ReciptMaintaince;
use App\Models\ProductMaintaincBill;
use App\Models\EmpRatio;
use App\Models\PaymentVoucher;
use App\Models\ReturnSales;
use App\Models\ReturnPurch;
use App\Models\SalesDefaultData;
use App\Models\ProductsPurchasesOrder;
use App\Models\Purchases;
use App\Models\ClientFilter;
use App\Models\VendorFilter;
use App\Models\ExecutorFilter;
use App\Models\ReturnSalesProducts;
use App\Models\PurchasesDefaultData;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\SalesPetrol;
use App\Models\Ticket;
use App\Models\IncomChecks;
use App\Models\Settlement;
use App\Models\Borrowa;
use App\Models\Loan;
use App\Models\PaySalary;
use App\Models\ExportChecks;
use App\Models\OpeningEntries;
use App\Models\StorsTransfers;
use App\Models\OpeningEntriesDetails;
use App\Models\InsurancePaper;
use App\Models\StartPeriods;
use App\Models\ExecutingReceiving;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\AssemblyProducts;
use App\Models\ProductSalesOrder;
use Str;
use DB;
use URL;
use App\Traits\GeneralTrait;
use App\Services\Average;
class ReportController extends Controller
{
    use GeneralTrait;


function __construct()
{

$this->middleware('permission:استعلام عن منتج', ['only' => ['Product_InfoPage']]);
$this->middleware('permission:اصناف وصلت حد الطلب', ['only' => ['ProductOrderLimitPage']]);
$this->middleware('permission:تقرير اصناف بدايه فتره', ['only' => ['ReportStartPeriodPage']]);
$this->middleware('permission:تقارير التسويات', ['only' => ['SettlementsReportsPage']]);
$this->middleware('permission:تكلفه المخزون', ['only' => ['StoresCostPage']]);
$this->middleware('permission:جرد المخازن', ['only' => ['StoresInventoryPage']]);
$this->middleware('permission:اصناف راكده', ['only' => ['StagnantItemsPage']]);
$this->middleware('permission:حركه الاصناف', ['only' => ['ItemsMovesPage']]);
$this->middleware('permission:صافي المشتريات', ['only' => ['NetPurchasesPage']]);
$this->middleware('permission:صافي المبيعات', ['only' => ['NetSalesPage']]);
$this->middleware('permission:اجمالي صافي المشتريات', ['only' => ['TotalNetPurchasesPage']]);
$this->middleware('permission:اجمالي صافي المبيعات', ['only' => ['TotalNetSalesPage']]);
$this->middleware('permission:الارباح', ['only' => ['ProfitsPage']]);
$this->middleware('permission:عمولات و خصومات الموظفين', ['only' => ['EmployeeCommissionDiscountsPage']]);
$this->middleware('permission:اسعار الموردين', ['only' => ['VendorPricesReportPage']]);
$this->middleware('permission:مبيعات المجموعات', ['only' => ['GroupsSalesPage']]);
$this->middleware('permission:تحصيل مناديب', ['only' => ['Collection_DelegatesPage']]);
$this->middleware('permission:مبيعات مناديب', ['only' => ['Sales_DelegatesPage']]);
$this->middleware('permission:مبيعات العملاء', ['only' => ['ClientSalesPage']]);
$this->middleware('permission:الحركات اليوميه', ['only' => ['DailyMovesPage']]);
$this->middleware('permission:مشتريات موردين', ['only' => ['VendorPurchasesPage']]);
$this->middleware('permission:مبيعات المنفذ', ['only' => ['ExecutorSales']]);
$this->middleware('permission:الاقساط الغير مدفوعه', ['only' => ['InstallmentReport']]);
$this->middleware('permission:الارباح المتوقعه', ['only' => ['ExceptProfits']]);
$this->middleware('permission:صلاحيات الاصناف', ['only' => ['ExpiredProucts']]);
$this->middleware('permission:اجمالي الحركات اليوميه', ['only' => ['TotalDailyMoves']]);
$this->middleware('permission:مبيعات مناديب تفصيلي', ['only' => ['DelegateSalesDetails']]);
$this->middleware('permission:مبيعات مخازن تفصيلي', ['only' => ['StoresSalesDetails']]);
$this->middleware('permission:مبيعات المجموعات', ['only' => ['ProfitGroupsReport']]);
$this->middleware('permission:كميات صنف تجميعي', ['only' => ['AssemblyProQties']]);
$this->middleware('permission:رصيد المخزون', ['only' => ['CreditStores']]);
$this->middleware('permission:حركات ارصدة مخزون', ['only' => ['StoresBalancesPage']]);
$this->middleware('permission:مبيعات مناديب تفصيلي جديد', ['only' => ['DelegateSalesDetails']]);

}

    //Product Info
    public function Product_InfoPage(){

        return view('admin.Reports.Product_Info');
    }
    
    function ProductInfoFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');

            if($search != '')
            {

                $Prods=Products::
                where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->take(10)
                    ->get();

                $data =ProductUnits::
                where('Barcode', $search)
                    ->take(10)
                    ->get();


                $Prs=ProductsQty::
                where('P_Code', $search)
                    ->orWhere('PP_Code', $search)
                    ->orWhere('PPP_Code', $search)
                    ->orWhere('PPPP_Code', $search)
                    ->take(10)
                    ->get();

            }


            $stores = $Prs->count();
            $total_row = $Prods->count();
            $total_row1 = $data->count();
            $total_row2 = $total_row + $total_row1;
            if($total_row2 > 0)
            {
                foreach($Prods as $rows){

                    $units=ProductUnits::where('Product',$rows->id)->get();


                    foreach($units as $uni){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;
                            $UniiName=$uni->Unit()->first()->Name;

                        }else{
                            $ProoName=$rows->P_En_Name;
                            $UniiName=$uni->Unit()->first()->NameEn;

                        }


                        $output .= '
           <tr>
           <td>
           '.$ProoName.'
          </td>

           <td>
           '.$UniiName.'
          </td>

               <td>
           '.$uni->Barcode.'
          </td>

               <td>
           '.$uni->Price.'
          </td>

               <td>
           '.$uni->Price_Two.'
          </td>

                <td>
           '.$uni->Price_Three.'
          </td>
        </tr>


            ';
                    }

                }

                foreach($data as $row){

                    $units=ProductUnits::where('Product',$row->Product)->get();

                    foreach($units as $uni){
                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$row->Product()->first()->P_Ar_Name;
                            $UniiName=$uni->Unit()->first()->Name;

                        }else{
                            $ProoName=$row->Product()->first()->P_En_Name;
                            $UniiName=$uni->Unit()->first()->NameEn;

                        }


                        $output .= '
           <tr>
           <td>
           '.$ProoName.'
          </td>

           <td>
           '.$UniiName.'
          </td>

               <td>
           '.$uni->Barcode.'
          </td>

               <td>
           '.$uni->Price.'
          </td>

               <td>
           '.$uni->Price_Two.'
          </td>

                <td>
           '.$uni->Price_Three.'
          </td>
        </tr>


            ';
                    }

                }

            }elseif($stores > 0){


                foreach($Prs as $ro){

                    $units=ProductUnits::where('Product',$ro->Product)->get();


                    foreach($units as $uni){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$ro->P_Ar_Name;

                            if(!empty($ro->V1)){
                                $ProoVName=$ro->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($ro->V2)){
                                $ProoVVName=$ro->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }
                            $UniiName=$uni->Unit()->first()->Name;

                        }else{
                            $ProoName=$ro->P_En_Name;

                            if(!empty($ro->V1)){
                                $ProoVName=$ro->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($ro->V2)){
                                $ProoVVName=$ro->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $UniiName=$uni->Unit()->first()->NameEn;

                        }



                        $output .= '
           <tr>
           <td>
           '.$ProoName.' (
           '.$ProoVName.' -
           '.$ProoVVName.'
           )

          </td>

           <td>
           '.$UniiName.'
          </td>

               <td>
           '.$uni->Barcode.'
          </td>

               <td>
           '.$uni->Price.'
          </td>

               <td>
           '.$uni->Price_Two.'
          </td>

                <td>
           '.$uni->Price_Three.'
          </td>
        </tr>


            ';
                    }

                }



            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //Product Order Limit
    public function ProductOrderLimitPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        return view('admin.Reports.ProductOrderLimit',get_defined_vars());
    }

    public function ProductOrderLimitFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Search_Type = $request->get('Search_Type');


        if($Search_Type == 1){

            $Prods =ProductUnits::

            when(!empty($search), function ($query) use ($search) {
                return $query->where('Barcode','ILIKE', "%{$search}%")
                    ->orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ;

            })

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })
                ->paginate(50);


            $ProdsCount=ProductUnits::

            join('products_qties', 'product_units.Product', '=', 'products_qties.Product')
                ->join('products', 'products_qties.Product', '=', 'products.id')

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('product_units.Barcode','ILIKE', "%{$search}%")
                        ->orWhere('product_units.P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('product_units.P_En_Name','ILIKE', "%{$search}%")
                        ;

                })



                ->where('products_qties.Qty','=','products.Minimum')


                ->count();


        }else{

            $Prods=ProductsQty::

            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })

                ->paginate(50);



            $ProdsCount=0;

        }


        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $Search_Type = $request->get('Search_Type');

            foreach($Prods as $rows){

                if($Search_Type == 1){
                    $units=ProductUnits::where('Product',$rows->Product)->get();
                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                    $AllQty=ProductsQty::where('Product',$rows->Product)->get()->sum('Qty');



                    if($AllQty <= $rows->Product()->first()->Minimum){
                        if($group != ''){
                            if($rows->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }


                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->Product.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->Product.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->Product.'" onchange="UnitCodeStart('.$rows->Product.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);


                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->Product.'" class="form-control" value="'.$AllQty.'"  disabled>
       </td>

        </tr>
            ';




                            }
                        }else{

                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->P_Ar_Name;


                            }else{
                                $PrrroName=$rows->P_En_Name;


                            }


                            $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->Product.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->Product.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->Product.'" onchange="UnitCodeStart('.$rows->Product.')">
                <option value="">     '.trans('admin.Choice_Unit').'</option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);


                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->Product.'" class="form-control" value="'.$AllQty.'"  disabled>
       </td>

        </tr>
            ';


                        }
                    }

                }else{

                    $units=ProductUnits::where('Product',$rows->Product)->get();
                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $pro=ProductsQty::where('Product',$rows->Product)->where('Store',$store)->first();

                    if($rows->Qty <= $rows->Product()->first()->Minimum){
                        if($group != ''){
                            if($rows->Product()->first()->Group == $group){


                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);


                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }

                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);


                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;

                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;

                                    }

                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';



                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;

                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;

                                    }

                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">    '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);


                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';

                                }


                            }

                        }else{

                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }


                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);


                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }

                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);


                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;

                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;

                                }

                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);

                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';



                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;
                                    $PrrroVVName=$rows->V2()->first()->Name;

                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;
                                    $PrrroVVName=$rows->V2()->first()->NameEn;

                                }

                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
       <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">    '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);


                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>

          <td>
     '.$rows->Product()->first()->Minimum.'
       </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control" value="'.$rows->Qty.'"  disabled>
       </td>

        </tr>
            ';

                            }


                        }
                    }

                }


            }


            return   $output ;
        }


        return view('admin.Reports.ProductOrderLimitFilterTwo',get_defined_vars());
    }


    //Report Start Period
    public function ReportStartPeriodPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        $Users=Admin::all();
        return view('admin.Reports.ReportStartPeriod',get_defined_vars());
    }

    public function ReportStartPeriodProductsFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        $Users=Admin::all();
        $From = $request->get('From');
        $To = $request->get('To');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $search = $request->get('search');



      $baseProdsQuery = ProductsStartPeriods::query()
            ->whereBetween('Date', [$From, $To])
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($group), function ($query) use ($group) {
                // تأكد أن علاقة 'Product' موجودة في موديل ProductsStartPeriods
                return $query->whereRelation('Product', 'Group', $group);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User', $User);
            })
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('P_Code', 'ILIKE', "%{$search}%");
            });

        // --------------------------------------------------------------------------
        // استخدام الاستعلام الأساسي لتوليد النتائج المختلفة
        // --------------------------------------------------------------------------

        // 1. جلب المنتجات المصفحة (مع Pagination)
        $Prods = $baseProdsQuery->clone()->paginate(100);

        // 2. حساب ProdsCount (كما في الكود الأصلي، يبدو أنه 0 ثابت)
        // إذا كان القصد هو count() عدد المنتجات التي تم جلبها، فيمكنك استخدام $Prods->total()
        // لكن بما أن الكود الأصلي يجعله 0، سنبقى عليه
        $ProdsCount = 0;


        // 3. حساب الإجمالي الكلي للمبالغ (Total)
        $ProdsTotal = $baseProdsQuery->clone()->get()->sum('Total');


        // 4. حساب الإجمالي الكلي للكميات (Qty)
        $ProdsQty = $baseProdsQuery->clone()->get()->sum('Qty');




        $output = '';
        if($request->ajax())
        {

            $From = $request->get('From');
            $To = $request->get('To');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $search = $request->get('search');

            foreach($Prods as $row){

                    if(app()->getLocale() == 'ar'){
                        $ProoName=$row->P_Ar_Name;
                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->Name;
                        }else{
                            $ProoVName='';
                        }
                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->Name;
                        }else{
                            $ProoVVName='';
                        }
                        $UniiName=$row->Unit()->first()->Name;
                        $StoName=$row->Store()->first()->Name;
                        $UserName=$row->User()->first()->name;

                    }else{
                        $ProoName=$row->P_En_Name;
                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->NameEn;
                        }else{
                            $ProoVName='';
                        }
                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->NameEn;
                        }else{
                            $ProoVVName='';
                        }
                        $UniiName=$row->Unit()->first()->NameEn;
                        $StoName=$row->Store()->first()->NameEn;
                        $UserName=$row->User()->first()->nameEn;

                    }

                    $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Total.'</td>
    <td>'.$row->Exp_Date.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';
                }

            return   $output ;
        }


        return view('admin.Reports.ReportStartPeriodProductsFilterTwo',get_defined_vars());
    }

    //Settlements Reports
    public function SettlementsReportsPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        $Users=Admin::all();
        $Coins=Coins::all();

        return view('admin.Reports.SettlementsReports',get_defined_vars());
    }

    public function SettlementsReportsFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        $Users=Admin::all();
        $Coins=Coins::all();


        $From = $request->get('From');
        $To = $request->get('To');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $search = $request->get('search');
        $Coin = $request->get('Coin');
        $Type = $request->get('Type');

           $baseQuery = ProductSettlement::query()
            ->whereBetween('Date', [$From, $To]) // الفلترة بنطاق التاريخ
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store); // الفلترة حسب المتجر
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User', $User); // الفلترة حسب المستخدم
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin', $Coin); // الفلترة حسب العملة
            })
            ->when(!empty($search), function ($query) use ($search) {
                // الفلترة حسب كلمات البحث في الأعمدة المختلفة
                return $query->where(function ($q) use ($search) {
                    $q->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                      ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                      ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                      ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                      ->orWhere('P_Code', 'ILIKE', "%{$search}%");
                });
            });

        // --------------------------------------------------------------------------
        // استخدام الاستعلام الأساسي لتوليد النتائج المختلفة المطلوبة
        // --------------------------------------------------------------------------

        // 1. جلب المنتجات المصفحة (مع Pagination)
        // نستخدم clone() لضمان أن هذا الاستعلام لا يؤثر على الاستخدامات اللاحقة لـ baseQuery
        $Prods = $baseQuery->clone()
            ->paginate(50);

        // 2. تحديد قيمة ProdsCount بناءً على الشروط (group و Type)
        $ProdsCount = 0; // تعيين قيمة افتراضية كما في الكود الأصلي

        if (!empty($group)) {
            // حالة وجود قيمة لـ group
            if ($Type == 0) {
                $ProdsCount = 0; // كما في الكود الأصلي
            } elseif ($Type == 1) {
                // هنا نحتاج لعمل join مع جدول 'products' لفلترة حسب 'Group'
                $ProdsCount = $baseQuery->clone()
                    ->join('products', 'product_settlements.Product', '=', 'products.id')
                    ->where('products.Group', '=', $group) // تطبيق فلتر المجموعة
                    ->where('Deficit', 0) // تطبيق فلتر Deficit
                    ->count();
            }
        } else {
            // حالة عدم وجود قيمة لـ group
            if ($Type == 0) {
                $ProdsCount = $baseQuery->clone()
                    ->where('Excess', 0) // تطبيق فلتر Excess
                    ->count();
            } elseif ($Type == 1) {
                $ProdsCount = $baseQuery->clone()
                    ->where('Deficit', 0) // تطبيق فلتر Deficit
                    ->count();
            }
        }

        $output = '';
        if($request->ajax())
        {
            $From = $request->get('From');
            $To = $request->get('To');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $search = $request->get('search');
            $Coin = $request->get('Coin');
            $Type = $request->get('Type');

            foreach($Prods as $row){


                if($group != '' and $Type == ''){


                    if($row->Product()->first()->Group == $group){


                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$row->P_Ar_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }
                            $UniiName=$row->Unit()->first()->Name;
                            $StoName=$row->Store()->first()->Name;
                            $UserName=$row->User()->first()->name;

                        }else{
                            $ProoName=$row->P_En_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $UniiName=$row->Unit()->first()->NameEn;
                            $StoName=$row->Store()->first()->NameEn;
                            $UserName=$row->User()->first()->nameEn;

                        }



                        $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';
                    }

                }elseif($group == '' and $Type != ''){

                    if($Type == 0){

                        if($row->Excess == 0){
                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;
                                $StoName=$row->Store()->first()->Name;
                                $UserName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;
                                $StoName=$row->Store()->first()->NameEn;
                                $UserName=$row->User()->first()->nameEn;

                            }



                            $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';

                        }

                    }elseif($Type == 1){

                        if($row->Deficit == 0){
                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;
                                $StoName=$row->Store()->first()->Name;
                                $UserName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;
                                $StoName=$row->Store()->first()->NameEn;
                                $UserName=$row->User()->first()->nameEn;

                            }



                            $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';

                        }


                    }

                }elseif($group != '' and $Type != ''){

                    if($row->Product()->first()->Group == $group){

                        if($Type == 0){

                            if($row->Excess == 0){
                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;
                                    $StoName=$row->Store()->first()->Name;
                                    $UserName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;
                                    $StoName=$row->Store()->first()->NameEn;
                                    $UserName=$row->User()->first()->nameEn;

                                }



                                $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';

                            }

                        }elseif($Type == 1){

                            if($row->Deficit == 0){
                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;
                                    $StoName=$row->Store()->first()->Name;
                                    $UserName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;
                                    $StoName=$row->Store()->first()->NameEn;
                                    $UserName=$row->User()->first()->nameEn;

                                }



                                $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';

                            }


                        }

                    }

                }elseif($group == '' and $Type == ''){

                    if(app()->getLocale() == 'ar' ){
                        $ProoName=$row->P_Ar_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->Name;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->Name;
                        }else{
                            $ProoVVName='';
                        }
                        $UniiName=$row->Unit()->first()->Name;
                        $StoName=$row->Store()->first()->Name;
                        $UserName=$row->User()->first()->name;

                    }else{
                        $ProoName=$row->P_En_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->NameEn;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->NameEn;
                        }else{
                            $ProoVVName='';
                        }


                        $UniiName=$row->Unit()->first()->NameEn;
                        $StoName=$row->Store()->first()->NameEn;
                        $UserName=$row->User()->first()->nameEn;

                    }



                    $output .= '
      <tr>
    <td>'.$row->Date.'</td>
    <td>'.$row->P_Code.'</td>
    <td>'.$ProoName.' ( '.$ProoVName.'  -  '.$ProoVVName.')</td>
    <td>'.$UniiName.'</td>
    <td>'.$row->Av_Qty.'</td>
    <td>'.$row->Price.'</td>
    <td>'.$row->Inventory.'</td>
    <td>'.$row->Deficit.'</td>
    <td>'.$row->Excess.'</td>
    <td>'.$StoName.'</td>
    <td>'.$UserName.'</td>
      </tr>
       ';
                }
            }



            return   $output ;
        }

        return view('admin.Reports.SettlementsReportsFilterTwo',get_defined_vars());
    }

    //Stores Cost
    public function StoresCostPage(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();


        return view('admin.Reports.StoresCost',get_defined_vars());
    }

    public function StoresCostFilterTwo(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Zero = $request->get('Zero');
        $GroupSingle = $request->get('GroupSingle');

       $prodsBaseQuery = ProductsQty::query()
            ->orderBy('Group', 'asc')
            ->where('Store', $store)
            ->when(!empty($group), function ($query) use ($group) {
                // فلترة حسب المجموعة عبر العلاقة 'Product'
                return $query->whereRelation('Product', 'Group', $group);
            })
            ->when(!empty($search), function ($query) use ($search) {
                // فلترة البحث المدمجة
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code', 'ILIKE', "%{$search}%");
                });
            });

        if ($Zero == 0) {
            // حالة: عرض جميع المنتجات (بما فيها الصفر)
            $Prods = $prodsBaseQuery->clone()->paginate(100);

            // منطق ProdsCount ثابت ويساوي 0 في كلتا الحالتين هنا
            if (!empty($group)) { $ProdsCount=0;}else{
                $ProdsCount=0;
            }

        } else {
            // حالة: عرض المنتجات التي كميتها لا تساوي صفر فقط
            $Prods = $prodsBaseQuery->clone()
                ->where('Qty', '!=', 0)
                ->paginate(100);

            // منطق ProdsCount ثابت ويساوي 0 في كلتا الحالتين هنا
            if (!empty($group)) { $ProdsCount=0;}else{
                $ProdsCount=0;
            }
        }

        // ----------------------------------------------------------------------
        // 2. بناء الاستعلام الأساسي للإحصائيات (Products_Num, Total_Qty, Total_Cost)
        // ----------------------------------------------------------------------

        if ($Zero == 0) {
            // حالة: الإحصائيات تشمل كل المنتجات في المخزن
            $statsBaseQuery = ProductsQty::query()->where('Store', $store);

            // Products_Num (عدد السجلات)
            $Products_Num = $statsBaseQuery->clone()->count();

            // Total_Qty (إجمالي الكمية)
            $Total_Qty = $statsBaseQuery->clone()->get()->sum('Qty');

            // Total_Cost (إجمالي التكلفة - المنطق المعقد يحافظ عليه)
            $Total_Cost = $statsBaseQuery->clone()
                ->get()
                ->sum(function ($row) use ($average, $store) {
                    $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();
                    $unitCost = $average->AverageCostGetUnit($row->Product, $rr->Barcode, $store, $rr->Unit);
                    return ($row->Qty / $rr->Rate) * $unitCost;
                });

        } else {
            // حالة: الإحصائيات تشمل فقط المنتجات التي كميتها لا تساوي صفر
            $statsBaseQuery = ProductsQty::query()
                ->where('Qty', '!=', 0)
                ->where('Store', $store);

            // Products_Num (عدد السجلات)
            $Products_Num = $statsBaseQuery->clone()->count();

            // Total_Qty (إجمالي الكمية)
            $Total_Qty = $statsBaseQuery->clone()->get()->sum('Qty');

            // Total_Cost (إجمالي التكلفة - المنطق المعقد يحافظ عليه)
            $Total_Cost = $statsBaseQuery->clone()
                ->get()
                ->sum(function ($row) use ($average, $store) {
                    $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();
                    $unitCost = $average->AverageCostGetUnit($row->Product, $rr->Barcode, $store, $rr->Unit);
                    return ($row->Qty / $rr->Rate) * $unitCost;
                });
        }

        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $Zero = $request->get('Zero');

            foreach($Prods as $rows){
                if($store == $rows->Store){
                    $units=ProductUnits::where('Product',$rows->Product)->get();
                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();


                    $def=StoresDefaultData::orderBy('id','desc')->first();
                    if($def->Cost_Price == 2){

                        $AllFifoQty =FifoQty::
                        where('Store',$store)
                            ->where('Product',$rows->Product)
                            ->where('P_Code',$plow->Barcode)
                            ->get();


                        $CostShow='none';
                        $CostTwoShow='block';
                    }else{
                        $AllFifoQty=[];

                        $CostShow='block';
                        $CostTwoShow='none';

                    }

                    if($def->Cost_Price == 2){


                        $totCost=0;





                        $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                        $fifo =FifoQty::orderBy('id','asc')
                            ->where('Store',$store)
                            ->where('Product',$rows->Product)
                            ->where('P_Code',$plow->Barcode)
                            ->where('Qty','!=',0)
                            ->first();



                        if(empty($fifo)){

                            $fifo =FifoQty::orderBy('id','asc')
                                ->where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('PP_Code',$plow->Barcode)
                                ->where('Qty','!=',0)
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::orderBy('id','asc')
                                    ->where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PPP_Code',$plow->Barcode)
                                    ->where('Qty','!=',0)
                                    ->first();


                                if(empty($fifo)){

                                    $fifo =FifoQty::orderBy('id','asc')
                                        ->where('Store',$store)
                                        ->where('Product',$rows->Product)
                                        ->where('PPPP_Code',$plow->Barcode)
                                        ->where('Qty','!=',0)
                                        ->first();

                                }

                            }

                        }




                        if(!empty($fifo)){

                            if($fifo->Qty == 0){



                                $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                if($NNQuntatity == 0){


                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                }else{



                                    if($NNQuntatity >= $rows->Qty){

                                        $totCost += $fifo->Cost_Price * $rows->Qty ;

                                    }else{

                                        $res=$rows->Qty - $NNQuntatity ;


                                        $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }


                                }



                            }else{


                                if($fifo->Qty >= $rows->Qty){

                                    $totCost += $fifo->Cost_Price * $rows->Qty ;

                                }else{

                                    $res=$rows->Qty - $fifo->Qty ;


                                    $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                    $totCost +=$ResdiualCost;

                                }



                            }


                        }




                        $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);


                        $Cost =$totCost ;
                        $SMallAverage =$Average ;









                    }else{
                        $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);
                        $Cost =$Average * ($rows->Qty / $rr->Rate);
                        $SMallAverage =$Average ;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){



                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;


                        }else{
                            $PrrroName=$rows->P_En_Name;

                        }



                        if($store == $rows->Store){

                            $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').' </option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);


                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  readonly>




       </td>


       <td>
       <input style="display:'.$CostShow.'" type="text" readonly id="AVG'.$rows->id.'" value="'.number_format((float)abs($Average), 2, '.', '').'" >
<input style="display:'.$CostShow.'" type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)abs($SMallAverage), 2, '.', '').'" >


          <div class="row" style="display:'.$CostTwoShow.'">

           ';
                            foreach($AllFifoQty as $fffff){

                                $output .= '



             <div class="col-12">
  '.trans("admin.Qty").' :-   '.number_format((float)abs($fffff->Qty), 2, '.', '').'    '.trans("admin.Cost").' :-    '.number_format((float)abs($fffff->Cost_Price), 2, '.', '').'
             </div>



          ';





                            }




                            $output .= '

        </div>
       </td>


           <td>
    <input type="text" id="COST'.$rows->id.'" readonly  class="form-control Tot" value="'.number_format((float)abs($Cost), 2, '.', '').'" >
       </td>


        </tr>
            ';
                        }

                    }elseif($rows->Product()->first()->P_Type == 'Serial'){




                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;


                        }else{
                            $PrrroName=$rows->P_En_Name;


                        }

                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">         '.trans('admin.Choice_Unit').'</option>
              ';

                        foreach($units as $uni){
                            $nam=Measuerments::find($uni->Unit);
                            if(app()->getLocale() == 'ar' ){
                                $UnitNamme=$nam->Name;
                            }else{

                                $UnitNamme=$nam->NameEn;
                            }
                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  readonly>
       </td>


         <td>
       <input style="display:'.$CostShow.'" type="text" readonly id="AVG'.$rows->id.'" value="'.number_format((float)abs($Average), 2, '.', '').'" >
<input style="display:'.$CostShow.'" type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)abs($SMallAverage), 2, '.', '').'" >


          <div class="row" style="display:'.$CostTwoShow.'">

           ';
                        foreach($AllFifoQty as $fffff){

                            $output .= '



             <div class="col-12">
  '.trans("admin.Qty").' :-   '.number_format((float)abs($fffff->Qty), 2, '.', '').'    '.trans("admin.Cost").' :-    '.number_format((float)abs($fffff->Cost_Price), 2, '.', '').'
             </div>



          ';





                        }




                        $output .= '

        </div>
       </td>


           <td>
      <input type="text" id="COST'.$rows->id.'" readonly  class="form-control Tot" value="'.number_format((float)abs($Cost), 2, '.', '').'" >
       </td>

        </tr>
            ';

                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $PrrroVName=$rows->V1()->first()->Name;


                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $PrrroVName=$rows->V1()->first()->NameEn;


                        }

                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                        foreach($units as $uni){
                            $nam=Measuerments::find($uni->Unit);
                            if(app()->getLocale() == 'ar' ){
                                $UnitNamme=$nam->Name;
                            }else{

                                $UnitNamme=$nam->NameEn;
                            }
                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  readonly>
       </td>


    <td>
       <input style="display:'.$CostShow.'" type="text" readonly id="AVG'.$rows->id.'" value="'.number_format((float)abs($Average), 2, '.', '').'" >
<input style="display:'.$CostShow.'" type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)abs($SMallAverage), 2, '.', '').'" >


          <div class="row" style="display:'.$CostTwoShow.'">

           ';
                        foreach($AllFifoQty as $fffff){

                            $output .= '



             <div class="col-12">
  '.trans("admin.Qty").' :-   '.number_format((float)abs($fffff->Qty), 2, '.', '').'    '.trans("admin.Cost").' :-    '.number_format((float)abs($fffff->Cost_Price), 2, '.', '').'
             </div>



          ';





                        }




                        $output .= '

        </div>
       </td>


           <td>
      <input type="text" id="COST'.$rows->id.'" readonly  class="form-control Tot" value="'.number_format((float)abs($Cost), 2, '.', '').'" >
       </td>


        </tr>
            ';


                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){




                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;


                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;


                        }

                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                        foreach($units as $uni){
                            $nam=Measuerments::find($uni->Unit);
                            if(app()->getLocale() == 'ar' ){
                                $UnitNamme=$nam->Name;
                            }else{

                                $UnitNamme=$nam->NameEn;
                            }
                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  readonly>
       </td>


    <td>
       <input style="display:'.$CostShow.'" type="text" readonly id="AVG'.$rows->id.'" value="'.number_format((float)abs($Average), 2, '.', '').'" >
<input style="display:'.$CostShow.'" type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)abs($SMallAverage), 2, '.', '').'" >


          <div class="row" style="display:'.$CostTwoShow.'">

           ';
                        foreach($AllFifoQty as $fffff){

                            $output .= '



             <div class="col-12">
  '.trans("admin.Qty").' :-   '.number_format((float)abs($fffff->Qty), 2, '.', '').'    '.trans("admin.Cost").' :-    '.number_format((float)abs($fffff->Cost_Price), 2, '.', '').'
             </div>



          ';





                        }




                        $output .= '

        </div>
       </td>


           <td>
      <input type="text" id="COST'.$rows->id.'" disabled  class="form-control Tot" value="'.number_format((float)abs($Cost), 2, '.', '').'" >
       </td>


        </tr>
            ';
                    }



                }
            }



            return   $output ;
        }
        $ProdsCount=0;
        return view('admin.Reports.StoresCostFilterTwo',[
            'Stores'=>$Stores,
            'ItemsGroups'=>$ItemsGroups,
            'search'=>$search,
            'store'=>$store,
            'group'=>$group,
            'Zero'=>$Zero,
            'ProdsCount'=>$ProdsCount,
            'GroupSingle'=>$GroupSingle,
            'Products_Num'=>$Products_Num,
            'Total_Qty'=>$Total_Qty,
            'Total_Cost'=>$Total_Cost,
        ]);
    }

    //CreditStores
    public function CreditStores(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        return view('admin.Reports.CreditStores',get_defined_vars());
    }


    public function CreditStoresFilterTwoX(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Zero = $request->get('Zero');

          $baseQuery = ProductsQty::query()
            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })
            ->when(!empty($group), function ($query) use ($group) {
                // الفلترة حسب المجموعة عبر العلاقة 'Product'
                return $query->whereRelation('Product', 'Group', $group);
            })
            ->when(!empty($search), function ($query) use ($search) {
                // فلترة البحث المدمجة (orWhere)
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code', 'ILIKE', "%{$search}%");
                });
            });

        // ----------------------------------------------------------------------
        // 2. تطبيق الشروط الخاصة بـ $Zero وحساب $Prods و $ProdsCount
        // ----------------------------------------------------------------------

        // بناء الاستعلام بناءً على $Zero
        if ($Zero != 0) {
            // حالة: استبعاد المنتجات التي كميتها صفر
            $filteredQuery = $baseQuery->clone()->where('Qty', '!=', 0);
        } else {
            // حالة: تضمين المنتجات التي كميتها صفر
            $filteredQuery = $baseQuery->clone();
        }

        // جلب المنتجات (Pagination)
        $Prods = $filteredQuery->clone()->paginate(100);

        // حساب العدد الإجمالي (Count)
        $ProdsCount = $filteredQuery->clone()->count();
        
        
        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $Zero = $request->get('Zero');

            foreach($Prods as $rows){

                if($store == $rows->Store){



                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();





                $def=StoresDefaultData::orderBy('id','desc')->first();
                if($def->Cost_Price == 2){


                    $totCost=0;





                    $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();



                    $fifo=$this->FifoAvQtyDate($store,$rows->Product,$rr->Barcode);

                    if(!empty($fifo)){

                        if($fifo->Qty == 0){



                            $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            if($NNQuntatity == 0){


                                $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            }else{



                                if($NNQuntatity >= $rows->Qty){

                                    $totCost += $fifo->Cost_Price * $rows->Qty ;

                                }else{

                                    $res=$rows->Qty - $NNQuntatity ;


                                    $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                    $totCost +=$ResdiualCost;

                                }


                            }



                        }else{


                            if($fifo->Qty >= $rows->Qty){

                                $totCost += $fifo->Cost_Price * $rows->Qty ;

                            }else{

                                $res=$rows->Qty - $fifo->Qty ;


                                $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                $totCost +=$ResdiualCost;

                            }



                        }


                    }



                    $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);




                }else{






                    $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);


                    $SMallAverage=$Average;






                }





                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){



                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;


                    }



                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  readonly>
       </td>




        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Serial'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;


                    }

                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  readonly>
       </td>




        </tr>
            ';

                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $PrrroVName=$rows->V1()->first()->Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $PrrroVName=$rows->V1()->first()->NameEn;


                    }

                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  readonly>
       </td>



        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $PrrroVName=$rows->V1()->first()->Name;
                        $PrrroVVName=$rows->V2()->first()->Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $PrrroVName=$rows->V1()->first()->NameEn;
                        $PrrroVVName=$rows->V2()->first()->NameEn;


                    }


                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  readonly>
       </td>




        </tr>
            ';
                }



            }


        }
            return   $output ;
        }
        return view('admin.Reports.CreditStoresFilterTwo',get_defined_vars());
    }


    //Stores Inventory
    public function StoresInventoryPage(){
        $ItemsGroups=ItemsGroups::all();
        $Brands=Brands::all();
        $Stores=Stores::type()->get();
        return view('admin.Reports.StoresInventory',get_defined_vars());
    }


    public function StoresInventoryFilterTwoo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Brands=Brands::all();
        $Stores=Stores::type()->get();
        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $brand = $request->get('brand');
        $Zero = $request->get('Zero');

            $baseQuery = ProductsQty::query()
            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })
            ->when(!empty($group), function ($query) use ($group) {
                // الفلترة حسب المجموعة عبر العلاقة 'Product'
                return $query->whereRelation('Product', 'Group', $group);
            })
            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->where('Brand', $brand);
            })
            ->when(!empty($search), function ($query) use ($search) {
                // فلترة البحث المدمجة (orWhere)
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code', 'ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code', 'ILIKE', "%{$search}%");
                });
            });

        // ----------------------------------------------------------------------
        // 2. تطبيق الشروط الخاصة بـ $Zero وحساب المتغيرات
        // ----------------------------------------------------------------------

        // تحديد الاستعلام المفلتر بناءً على $Zero
        if ($Zero != 0) {
            // حالة: استبعاد المنتجات التي كميتها صفر
            $filteredQuery = $baseQuery->clone()->where('Qty', '!=', 0);
        } else {
            // حالة: تضمين المنتجات التي كميتها صفر
            $filteredQuery = $baseQuery->clone();
        }

        // جلب المنتجات (Pagination)
        $Prods = $filteredQuery->clone()->paginate(100);

        // حساب إجمالي الكمية
        $Total_Qty = $filteredQuery->clone()->get()->sum('Qty');

        // حساب عدد المنتجات (Count)
        $ProdsCount = $filteredQuery->clone()->count();
        
        
        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $brand = $request->get('brand');
            $Zero = $request->get('Zero');



            foreach($Prods as $rows){

                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                if($Zero != ''){
                    if($Zero == 1){
                        if($rows->Qty != 0){


                            if($brand != ''){

                                if($rows->Product()->first()->Brand == $brand){

                                    if($rows->Store == $store){

                                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){




                                            if(app()->getLocale() == 'ar' ){
                                                $PrrroName=$rows->P_Ar_Name;


                                            }else{
                                                $PrrroName=$rows->P_En_Name;


                                            }


                                            $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>

             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                            foreach($units as $uni){
                                                $nam=Measuerments::find($uni->Unit);

                                                if(app()->getLocale() == 'ar' ){
                                                    $UnitNamme=$nam->Name;
                                                }else{

                                                    $UnitNamme=$nam->NameEn;
                                                }
                                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                            }

                                            $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                        }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                            if(app()->getLocale() == 'ar' ){
                                                $PrrroName=$rows->P_Ar_Name;


                                            }else{
                                                $PrrroName=$rows->P_En_Name;


                                            }



                                            $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                            foreach($units as $uni){
                                                $nam=Measuerments::find($uni->Unit);
                                                if(app()->getLocale() == 'ar' ){
                                                    $UnitNamme=$nam->Name;
                                                }else{

                                                    $UnitNamme=$nam->NameEn;
                                                }
                                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                            }

                                            $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                            if(app()->getLocale() == 'ar' ){
                                                $PrrroName=$rows->P_Ar_Name;
                                                $PrrroVName=$rows->V1()->first()->Name;


                                            }else{
                                                $PrrroName=$rows->P_En_Name;
                                                $PrrroVName=$rows->V1()->first()->NameEn;


                                            }



                                            $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                            foreach($units as $uni){
                                                $nam=Measuerments::find($uni->Unit);
                                                if(app()->getLocale() == 'ar' ){
                                                    $UnitNamme=$nam->Name;
                                                }else{

                                                    $UnitNamme=$nam->NameEn;
                                                }
                                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                            }

                                            $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                            if(app()->getLocale() == 'ar' ){
                                                $PrrroName=$rows->P_Ar_Name;
                                                $PrrroVName=$rows->V1()->first()->Name;
                                                $PrrroVVName=$rows->V2()->first()->Name;


                                            }else{
                                                $PrrroName=$rows->P_En_Name;
                                                $PrrroVName=$rows->V1()->first()->NameEn;
                                                $PrrroVVName=$rows->V2()->first()->NameEn;


                                            }


                                            $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                            foreach($units as $uni){
                                                $nam=Measuerments::find($uni->Unit);

                                                if(app()->getLocale() == 'ar' ){
                                                    $UnitNamme=$nam->Name;
                                                }else{

                                                    $UnitNamme=$nam->NameEn;
                                                }
                                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                            }

                                            $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                        }

                                    }


                                }

                            }else{

                                if($rows->Store == $store){

                                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }


                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);

                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }



                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;


                                        }



                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;
                                            $PrrroVVName=$rows->V2()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;
                                            $PrrroVVName=$rows->V2()->first()->NameEn;


                                        }


                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);

                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                    }

                                }



                            }


                        }

                    }else{


                        if($brand != ''){

                            if($rows->Product()->first()->Brand == $brand){
                                if($rows->Store == $store){

                                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }


                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);

                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }



                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;


                                        }



                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;
                                            $PrrroVVName=$rows->V2()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;
                                            $PrrroVVName=$rows->V2()->first()->NameEn;


                                        }


                                        $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);

                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                    }

                                }


                            }


                        }else{

                            if($rows->Store == $store){

                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                }

                            }



                        }




                    }


                }else{



                    if($brand != ''){

                        if($rows->Product()->first()->Brand == $brand){
                            if($rows->Store == $store){

                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                }

                            }


                        }

                    }else{

                        if($rows->Product()->first()->Group == $group){

                            if($rows->Store == $store){

                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rr->Barcode.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'" >
     <input type="hidden"  class="form-control" value="'.$rr->Price.'">
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'">
      <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'">

      <input type="hidden"   value="'.$rr->Barcode.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty / $rr->Rate.'

       </td>

          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>

       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>

       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>

                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
            <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'" >
  <input type="hidden"  class="form-control " value="'.$rr->Price.'" >
    <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'" >
     <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'" >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


          <td id="SalePriceI'.$rows->id.'">
          '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';

                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;


                                    }



                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">

       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'" >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
         <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Two.'"  >
   <input type="hidden"  class="form-control " value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>


             <td id="SalePriceI'.$rows->id.'">
             '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>


        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){





                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;


                                    }


                                    $output .= '

       <tr>

       <td id="CodeStart'.$rows->id.'">
       '.$rows->P_Code.'

       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
                             <input type="hidden"   value="'.$rows->P_Code.'"  >
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
           <input type="hidden"  class="form-control Qun" value="'.$rows->Qty.'"  >
    <input type="hidden"  class="form-control" value="'.$rr->Price.'"  >
     <input type="hidden"  class="form-control" value="'.$rr->Price_Two.'"  >
            <input type="hidden"  class="form-control" value="'.$rr->Price_Three.'"  >
        </td>


         <td id="Qty'.$rows->id.'">
         '.$rows->Qty.'

       </td>

               <td id="SalePriceI'.$rows->id.'">
               '.$rr->Price.'

          </td>
       <td id="SalePriceII'.$rows->id.'">
       '.$rr->Price_Two.'

       </td>
       <td id="SalePriceIII'.$rows->id.'">
       '.$rr->Price_Three.'

       </td>

        </tr>
            ';
                                }

                            }



                        }

                    }



                }

            }

            return   $output ;
        }

        return view('admin.Reports.StoresInventoryFilterTwoo',get_defined_vars());
    }

    //Stagnant Items
    public function StagnantItemsPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        return view('admin.Reports.StagnantItems',get_defined_vars());
    }

    public function StagnantItemsFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        $group = $request->get('group');
        $Store = $request->get('Store');
        $From = $request->get('From');
        $To = $request->get('To');
        $Max = $request->get('Max');
        $search = $request->get('search');


        $Prods=ProductsQty::

        when(!empty($Store), function ($query) use ($Store) {
            return $query->where('Store',$Store);

        })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                    ;

            })

            ->paginate(50);


        $ProdsCount=0;
        foreach($Prods as $rows){

            $count=ProductSales::
            where('Product',$rows->Product)
                ->where('Product_Code',$rows->P_Code)
                ->whereBetween('Date', [$From,$To])
                ->count();
            if($count  <= $Max){
                if($group != ''){
                    if($rows->Product()->first()->Group == $group){
                        $ProdsCount+=1;
                    }
                }else{
                    $ProdsCount+=1;
                }
            }
        }



        $output = '';
        if($request->ajax())
        {

            $group = $request->get('group');
            $Store = $request->get('Store');
            $From = $request->get('From');
            $To = $request->get('To');
            $Max = $request->get('Max');
            $search = $request->get('search');


            foreach($Prods as $rows){

                if($rows->Store == $Store){
                    
                
                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();


                $count=ProductSales::
                where('Product',$rows->Product)
                    ->where('Product_Code',$rows->P_Code)
                    ->whereBetween('Date', [$From,$To])
                    ->count();

                if($count  <= $Max){
                    if($group != ''){

                        if($rows->Product()->first()->Group == $group){
                            $ProdsCount+=1;


                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){




                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }


                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


       <td>
       '.$count.'
       </td>


        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Serial'){



                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }

                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


      <td>
       '.$count.'
       </td>


        </tr>
            ';

                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){



                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;


                                }


                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


          <td>
       '.$count.'
       </td>


        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){



                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;
                                    $PrrroVVName=$rows->V2()->first()->Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;
                                    $PrrroVVName=$rows->V2()->first()->NameEn;


                                }


                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


        <td>
       '.$count.'
       </td>


        </tr>
            ';
                            }




                        }

                    }else{

                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){




                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->P_Ar_Name;


                            }else{
                                $PrrroName=$rows->P_En_Name;


                            }


                            $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);
                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


       <td>
       '.$count.'
       </td>


        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Serial'){



                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->P_Ar_Name;


                            }else{
                                $PrrroName=$rows->P_En_Name;


                            }

                            $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);
                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


      <td>
       '.$count.'
       </td>


        </tr>
            ';

                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){



                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->P_Ar_Name;
                                $PrrroVName=$rows->V1()->first()->Name;


                            }else{
                                $PrrroName=$rows->P_En_Name;
                                $PrrroVName=$rows->V1()->first()->NameEn;


                            }


                            $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);
                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


          <td>
       '.$count.'
       </td>


        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){



                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->P_Ar_Name;
                                $PrrroVName=$rows->V1()->first()->Name;
                                $PrrroVVName=$rows->V2()->first()->Name;


                            }else{
                                $PrrroName=$rows->P_En_Name;
                                $PrrroVName=$rows->V1()->first()->NameEn;
                                $PrrroVVName=$rows->V2()->first()->NameEn;


                            }


                            $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                            foreach($units as $uni){
                                $nam=Measuerments::find($uni->Unit);
                                if(app()->getLocale() == 'ar' ){
                                    $UnitNamme=$nam->Name;
                                }else{

                                    $UnitNamme=$nam->NameEn;
                                }
                                $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                            }

                            $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


        <td>
       '.$count.'
       </td>


        </tr>
            ';
                        }



                    }

                }

            }

            return   $output ;
        }
        
        
        }


        return view('admin.Reports.StagnantItemsFilterTwo',get_defined_vars());
    }

    //Items Moves
    public function ItemsMovesPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        $Users=Admin::all();


        $Types=ProductMoves::select('Type','TypeEn')->distinct(['Type'])->get();
        return view('admin.Reports.ItemsMoves',get_defined_vars());
    }

    public function ItemsMovesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        $Users=Admin::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $From = $request->get('From');
        $To = $request->get('To');
        $User = $request->get('User');
        $Type = $request->get('Type');
        $Balance=0;



        $Prods=ProductMoves::whereBetween('Date', [$From,$To])

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group', $group);

            })


            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })

            ->latest('id')
            ->paginate(50);

            $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $From = $request->get('From');
            $To = $request->get('To');
            $User = $request->get('User');
            $Type = $request->get('Type');
            $Balance=0;



            foreach($Prods as $rows){

                if($rows->Type == 'مشتريات'){
                    $pur=Purchases::find($rows->Bill_Num);
                    if(!empty($pur->Refernce_Number)){
                        $Ref=$pur->Refernce_Number;
                    }else{
                        $Ref='';
                    }


                }else{
                    $Ref='';
                }

                if($rows->Incom != 0){
                    $OneIn =  $rows->CostIn / $rows->Incom;
                }else{

                    $OneIn =  $rows->CostIn / 1;
                }

                if($rows->Outcom != 0){
                    $OneOut =$rows->CostOut * $rows->Outcom;
                }else{
                    $OneOut =$rows->CostOut * 1;
                }

                if($rows->Current != 0){
                    $OneCurrent =$rows->CostCurrent / $rows->Current;
                }else{
                    $OneCurrent =$rows->CostCurrent / 1;
                }

                if(!empty($rows->Group)){
                    if(app()->getLocale() == 'ar' ){
                        $Group=$rows->Group()->first()->Name;
                    }else{

                        $Group=$rows->Group()->first()->NameEn;
                    }
                }else{

                    $Group='';
                }

                if(!empty($rows->Unit)){
                    if(app()->getLocale() == 'ar' ){
                        $Unit=$rows->Unit()->first()->Name;
                    }else{

                        $Unit=$rows->Unit()->first()->NameEn;
                    }
                }else{

                    $Unit='';
                }

                if(!empty($rows->Store)){
                    if(app()->getLocale() == 'ar' ){
                        $SS=$rows->Store()->first()->Name;
                    }else{

                        $SS=$rows->Store()->first()->NameEn;
                    }
                }else{

                    $SS='';
                }

                if(!empty($rows->V1)){
                    if(app()->getLocale() == 'ar' ){
                        $V=$rows->V1()->first()->Name;
                    }else{
                        $V=$rows->V1()->first()->NameEn;
                    }
                }else{

                    $V='';
                }

                if(!empty($rows->V2)){
                    if(app()->getLocale() == 'ar' ){
                        $VV=$rows->V2()->first()->Name;
                    }else{

                        $VV=$rows->V2()->first()->NameEn;
                    }
                }else{

                    $VV='';
                }


                if($rows->Store == $store){


                    if($rows->Edit == 1){ $classX="edited"; }elseif ($rows->Delete == 1){ $classX="deleted"; }else{ $classX=""; }

                    if($rows->Edit == 1){

                        $span='<span class="btn btn-warning">'.trans('admin.Edited_to_New_One').' ('.$rows->Edit_New_Code.')</span>';

                    }elseif($rows->Delete == 1){

                        $span='<span class="btn btn-danger">'.trans('admin.Deleted').'</span>';

                    }else{

                        $span='';
                    }



                    if($group != ''){
                        if($rows->Group == $group){

                            $x=ProductsQty::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->first();
                            $m=ProductMoves::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->count();

                            if(!empty($x)){
                                $Balance += $x->Qty /$m;
                            }else{
                                $Balance += 0;

                            }



                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;
                                    $UiiName=$rows->User()->first()->name;
                                    $TypeName=$rows->Type;

                                }else{
                                    $ProoName=$rows->P_En_Name;
                                    $UiiName=$rows->User()->first()->nameEn;
                                    $TypeName=$rows->TypeEn;

                                }

                                $output .= '

       <tr  class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.'
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

     <td>
          '.$rows->CostIn.'
    </td>

       <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>

        <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>

       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
         '.$rows->CostCurrent.'
    </td>

  <td>
       '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>


            <td>
                '.$span.'
            </td>


        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Serial'){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;
                                    $UiiName=$rows->User()->first()->name;
                                    $TypeName=$rows->Type;

                                }else{
                                    $ProoName=$rows->P_En_Name;
                                    $UiiName=$rows->User()->first()->nameEn;
                                    $TypeName=$rows->TypeEn;

                                }

                                $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.'
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td >
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

         <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td >
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
           <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>

       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
        <td>
         '.$rows->CostCurrent.'
    </td>

        <td>
       '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>

         <td>
                '.$span.'
            </td>


        </tr>
            ';

                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;
                                    $UiiName=$rows->User()->first()->name;
                                    $TypeName=$rows->Type;

                                }else{
                                    $ProoName=$rows->P_En_Name;
                                    $UiiName=$rows->User()->first()->nameEn;
                                    $TypeName=$rows->TypeEn;

                                }

                                $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.' ('.$V.')
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

          <td>
         '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
         <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>


       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
        <td>
         '.$rows->CostCurrent.'
    </td>

       <td>
        '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>

         <td>
                '.$span.'
            </td>


        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;
                                    $UiiName=$rows->User()->first()->name;
                                    $TypeName=$rows->Type;

                                }else{
                                    $ProoName=$rows->P_En_Name;
                                    $UiiName=$rows->User()->first()->nameEn;
                                    $TypeName=$rows->TypeEn;

                                }


                                $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.' ('.$V.') ('.$VV.')
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

          <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
        <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>


       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
<td>
         '.$rows->CostCurrent.'
    </td>

       <td>
        '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>


         <td>
                '.$span.'
            </td>

        </tr>
            ';

                            }


                        }

                    }else{

                        $x=ProductsQty::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->first();
                        $m=ProductMoves::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->count();

                        if(!empty($x)){
                            $Balance += $x->Qty /$m;
                        }else{
                            $Balance += 0;

                        }




                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UiiName=$rows->User()->first()->name;
                                $TypeName=$rows->Type;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UiiName=$rows->User()->first()->nameEn;
                                $TypeName=$rows->TypeEn;

                            }




                            $output .= '

       <tr  class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.'
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

     <td>
          '.$rows->CostIn.'
    </td>

       <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
        <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>

       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
         '.$rows->CostCurrent.'
    </td>

  <td>
       '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>


            <td>
                '.$span.'
            </td>


        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Serial'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UiiName=$rows->User()->first()->name;
                                $TypeName=$rows->Type;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UiiName=$rows->User()->first()->nameEn;
                                $TypeName=$rows->TypeEn;

                            }

                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.'
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td >
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

         <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td >
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
             <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>


       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
        <td>
         '.$rows->CostCurrent.'
    </td>

        <td>
       '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>

         <td>
                '.$span.'
            </td>


        </tr>
            ';

                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UiiName=$rows->User()->first()->name;
                                $TypeName=$rows->Type;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UiiName=$rows->User()->first()->nameEn;
                                $TypeName=$rows->TypeEn;

                            }

                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'  ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.' ('.$V.')
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

          <td>
         '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
          <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>


       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
        <td>
         '.$rows->CostCurrent.'
    </td>

       <td>
        '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>

         <td>
                '.$span.'
            </td>


        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UiiName=$rows->User()->first()->name;
                                $TypeName=$rows->Type;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UiiName=$rows->User()->first()->nameEn;
                                $TypeName=$rows->TypeEn;

                            }


                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'   ('.$rows->id.')
       </td>

        <td>
        '.$ProoName.' ('.$V.') ('.$VV.')
        </td>

        <td>
          '.$Unit.' ('.$rows->QTY.')
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$TypeName.'
        </td>

         <td>
        '.$rows->Bill_Num.' ('.$Ref.')
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>
       <td>
          '.$rows->CostIn.'
    </td>

          <td>
        '.number_format((float)$OneIn, 2, '.', '').'
       </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
         <td>
         '.number_format((float)$OneOut, 2, '.', '').'
    </td>


        <td>
     
       
        '.$rows->CostOut.'
       </td>


       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>
<td>
         '.$rows->CostCurrent.'
    </td>

       <td>
        '.number_format((float)$OneCurrent, 2, '.', '').'
       </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UiiName.'
        </td>


         <td>
                '.$span.'
            </td>

        </tr>
            ';

                        }




                    }

                }


            }


            return   $output ;
        }


        return view('admin.Reports.ItemsMovesFilterTwo',get_defined_vars());
    }


    //Stores Balances
    public function StoresBalancesPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        return view('admin.Reports.StoresBalances',get_defined_vars());
    }


    public function StoresBalancesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();


        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $From = $request->get('From');
        $To = $request->get('To');
        $Balance=0;
        
        $Prods=ProductMoves::whereBetween('Date', [$From,$To])

            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")

                    ;

            })

            ->paginate(10);


        if($group != ''){$ProdsCount=0;}else{
            $ProdsCount=ProductMoves::whereBetween('Date', [$From,$To])

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);

                })

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);

                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")

                        ;

                })



                ->count();

        }

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $From = $request->get('From');
            $To = $request->get('To');
            $Balance=0;

            foreach($Prods as $rows){

                if(!empty($rows->Group)){
                    if(app()->getLocale() == 'ar' ){
                        $Group=$rows->Group()->first()->Name;
                    }else{
                        $Group=$rows->Group()->first()->NameEn;

                    }
                }else{

                    $Group='';
                }

                if(!empty($rows->Unit)){

                    if(app()->getLocale() == 'ar' ){
                        $Unit=$rows->Unit()->first()->Name;
                    }else{
                        $Unit=$rows->Unit()->first()->NameEn;
                    }
                }else{

                    $Unit='';
                }

                if(!empty($rows->Store)){
                    if(app()->getLocale() == 'ar' ){
                        $SS=$rows->Store()->first()->Name;
                    }else{
                        $SS=$rows->Store()->first()->NameEn;
                    }
                }else{

                    $SS='';
                }

                if(!empty($rows->V1)){
                    if(app()->getLocale() == 'ar' ){
                        $V=$rows->V1()->first()->Name;
                    }else{
                        $V=$rows->V1()->first()->NameEn;
                    }
                }else{

                    $V='';
                }

                if(!empty($rows->V2)){
                    if(app()->getLocale() == 'ar' ){
                        $VV=$rows->V2()->first()->Name;
                    }else{

                        $VV=$rows->V2()->first()->NameEn;
                    }
                }else{

                    $VV='';
                }


                if($rows->Edit == 1){ $classX="edited"; }elseif ($rows->Delete == 1){ $classX="deleted"; }else{
                    $classX='';
                }

                if($rows->Edit == 1){

                    $span='<span class="btn btn-warning">'.trans('admin.Edited_to_New_One').' ('.$rows->Edit_New_Code.')</span>';

                }elseif($rows->Delete == 1){

                    $span='<span class="btn btn-danger">'.trans('admin.Deleted').'</span>';

                }else{
                    $span='';
                }





                if($group != ''){
                    if($rows->Group == $group){

                        $x=ProductsQty::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->first();
                        $m=ProductMoves::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->count();

                        if(!empty($x)){
                            $Balance += $x->Qty /$m;
                        }else{
                            $Balance += 0;

                        }



                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions' or $rows->Product()->first()->P_Type == 'Additions'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UseerName=$rows->User()->first()->name;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UseerName=$rows->User()->first()->nameEn;

                            }

                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.'
        <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>


             <td>
'.$span.'
            </td>

        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Serial'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UseerName=$rows->User()->first()->name;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UseerName=$rows->User()->first()->nameEn;

                            }


                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.'
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>

             <td>
'.$span.'
            </td>


        </tr>
            ';

                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UseerName=$rows->User()->first()->name;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UseerName=$rows->User()->first()->nameEn;

                            }
                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.' ('.$V.')
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>

             <td>
'.$span.'
            </td>


        </tr>
            ';


                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;
                                $UseerName=$rows->User()->first()->name;

                            }else{
                                $ProoName=$rows->P_En_Name;
                                $UseerName=$rows->User()->first()->nameEn;

                            }
                            $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.' ('.$V.') ('.$VV.')
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>


             <td>
'.$span.'
            </td>

        </tr>
            ';

                        }

                    }

                }else{

                    $x=ProductsQty::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->first();
                    $m=ProductMoves::where('P_Code',$rows->P_Code)->where('Product',$rows->Product)->count();

                    if(!empty($x)){
                        $Balance += $x->Qty /$m;
                    }else{
                        $Balance += 0;

                    }

                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;
                            $UseerName=$rows->User()->first()->name;

                        }else{
                            $ProoName=$rows->P_En_Name;
                            $UseerName=$rows->User()->first()->nameEn;

                        }

                        $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.'
        <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>

             <td>
'.$span.'
            </td>


        </tr>
            ';


                    }elseif($rows->Product()->first()->P_Type == 'Serial'){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;
                            $UseerName=$rows->User()->first()->name;

                        }else{
                            $ProoName=$rows->P_En_Name;
                            $UseerName=$rows->User()->first()->nameEn;

                        }


                        $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.'
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>


             <td>
'.$span.'
            </td>

        </tr>
            ';

                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;
                            $UseerName=$rows->User()->first()->name;

                        }else{
                            $ProoName=$rows->P_En_Name;
                            $UseerName=$rows->User()->first()->nameEn;

                        }
                        $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.' ('.$V.')
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>


             <td>
'.$span.'
            </td>

        </tr>
            ';


                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;
                            $UseerName=$rows->User()->first()->name;

                        }else{
                            $ProoName=$rows->P_En_Name;
                            $UseerName=$rows->User()->first()->nameEn;

                        }
                        $output .= '

       <tr class='.$classX.'>

       <td>
     '.$rows->P_Code.'
       </td>

        <td>
        '.$ProoName.' ('.$V.') ('.$VV.')
         <img src="'.URL::to($rows->Product()->first()->Image).'" style="width:50%; height:50%;">
        </td>

        <td>
          '.$Unit.'
        </td>

       <td>
        '.$rows->Date.'
        </td>

        <td>
        '.$rows->Type.'
        </td>

         <td>
        '.$rows->Bill_Num.'
        </td>

         <td>
        '.$rows->Incom.'
        <input type="hidden" class="Inc" value="'.$rows->Incom.'">
        </td>

            <td>
        '.$rows->Outcom.'
     <input type="hidden" class="Out" value="'.$rows->Outcom.'">
        </td>
       <td>
        '.$rows->Current.'
         <input type="hidden" class="Bal" value="'.$rows->Current.'">
        </td>

        <td>
        '.$Group.'
        </td>

       <td>
        '.$SS.'
        </td>

           <td>
        '.$UseerName.'
        </td>

             <td>
'.$span.'
            </td>


        </tr>
            ';

                    }


                }

            }



            return   $output ;
        }

        return view('admin.Reports.StoresBalancesFilterTwo',get_defined_vars());
    }

    //Net Purchases
    public function NetPurchasesPage(){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();
        return view('admin.Reports.NetPurchases',get_defined_vars());
    }


    public function NetPurchasesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();

      
              $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $Vendor = $request->get('Vendor');
            $Coin = $request->get('Coin');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Cost_Center = $request->get('Cost_Center');
            $Delegate = $request->get('Delegate');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $Type = $request->get('Type');
            $Code = $request->get('Code');

        
      $basePurchasesQuery = ProductsPurchases::query()
            ->whereBetween('Date', [$From, $To]) // شرط التاريخ الأساسي
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase', 'Vendor', $Vendor);
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase', 'Coin', $Coin);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase', 'Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase', 'Payment_Method', $Payment_Method);
            })
            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase', 'Cost_Center', $Cost_Center);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase', 'Delegate', $Delegate);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase', 'User', $User);
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase', 'Store', $Store);
            })
            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase', 'Type', $Type);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase', 'Code', $Code);
            })
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            })
            // الشروط الثابتة (عدم الحذف أو التعديل)
            ->whereRelation('Purchase', 'Edit', 0)
            ->whereRelation('Purchase', 'Delete', 0);


        // ----------------------------------------------------------------------
        // 2. حساب المتغيرات من ProductsPurchases باستخدام $basePurchasesQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المشتريات المصفحة (Pagination)
        $Purchs = $basePurchasesQuery->clone()->paginate(50);

        // حساب عدد سجلات المشتريات ($PCount)
        $PCount = $basePurchasesQuery->clone()->count();

        // حساب إجمالي الضريبة ($TotalTax)
        $TotalTax = $basePurchasesQuery->clone()->get()->sum('Total_Tax');

        // ملاحظة: المتغير $TotalDiscount كان بقيمة 0 وثابت، لذا لم يتغير.
        $TotalDiscount = 0;


        // ----------------------------------------------------------------------
        // 3. بناء الاستعلام الأساسي لـ ReturnPurchProducts (المرتجعات)
        // ----------------------------------------------------------------------

        // ملاحظة: هذا الاستعلام يستخدم الأعمدة مباشرة (Vendor, Coin, Safe, الخ)
        // بينما استعلام المشتريات يستخدم whereRelation('Purchase', '...')
        $baseReturnsQuery = ReturnPurchProducts::query()
            ->whereBetween('Date', [$From, $To]) // شرط التاريخ الأساسي
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor', $Vendor);
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin', $Coin);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method', $Payment_Method);
            })
            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center', $Cost_Center);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate', $Delegate);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User', $User);
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type', $Type);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code', $Code);
            })
            // شرط المجموعة كان موجودًا في عداد الـ returns (PRCount) ولكن ليس في جلب السجلات ($Returns)، سنضيفه للتوحيد
            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group', $group);
            })
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            });


        // ----------------------------------------------------------------------
        // 4. حساب المتغيرات من ReturnPurchProducts باستخدام $baseReturnsQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المرتجعات المصفحة (Pagination)
        $Returns = $baseReturnsQuery->clone()->paginate(50);

        // حساب عدد سجلات المرتجعات ($PRCount)
        $PRCount = $baseReturnsQuery->clone()->count();


        // ----------------------------------------------------------------------
        // 5. حساب إجمالي الخصم على الفواتير
        // ----------------------------------------------------------------------

        // ملاحظة: هذا الاستعلام لا يتأثر بالفلاتر المعقدة للمنتجات، ولكنه يتأثر بفلاتر فواتير الشراء.
        // بما أن الفلاتر في ProductsPurchases كانت تستخدم whereRelation('Purchase', ...)
        // سنستخدم نفس الفلاتر ولكن مباشرة على موديل Purchases

        $DiscountOnBill = Purchases::query()
            ->whereBetween('Date', [$From, $To])
            ->where('Edit', 0)
            ->where('Delete', 0)
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor', $Vendor);
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin', $Coin);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method', $Payment_Method);
            })
            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center', $Cost_Center);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate', $Delegate);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User', $User);
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type', $Type);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code', $Code);
            })
            // لا يمكن تطبيق فلتر البحث (search) على موديل Purchases بشكل مباشر لأنه يعتمد على أسماء المنتجات (P_Ar_Name, V_Name, الخ)
            // لذا، سنستبعد فلتر البحث من هذا الاستعلام كما هو الحال عادةً.
            ->get()->sum('DiscountBill');


        // ----------------------------------------------------------------------
        // 6. حساب الإجمالي النهائي
        // ----------------------------------------------------------------------

        $ProdsCount = $PCount + $PRCount;
        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $Vendor = $request->get('Vendor');
            $Coin = $request->get('Coin');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Cost_Center = $request->get('Cost_Center');
            $Delegate = $request->get('Delegate');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $Type = $request->get('Type');
            $Code = $request->get('Code');


            foreach($Purchs as $row){

                if(!empty($row->Cost_Center)){
                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){

                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }

                if($row->Purchase()->first()->Payment_Method == 'Cash'){
                    $payment=trans('admin.Cash');
                }elseif($row->Purchase()->first()->Payment_Method == 'Later'){

                    $payment= trans('admin.Later');
                }elseif($row->Purchase()->first()->Payment_Method == 'Check'){

                    $payment= trans('admin.Check');
                }

                $Def=DefaultDataShowHide::orderBy('id','desc')->first();

                if($Def->Code_Report == 1){
                    $opo='';
                }else{

                    $opo='no-print';

                }

                if($Def->Refrence_Number_Print == 1){
                    $opoR='';
                }else{

                    $opoR='no-print';

                }

                if($Def->Unit == 1){
                    $opoU='';
                }else{

                    $opoU='no-print';

                }



                if($row->Purchase()->first()->Status  == 1){

                    if($Payment_Method != ''){

                        if($row->Purchase()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }

                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

           <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }




                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

           <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }

                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }




                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

           <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }




                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

           <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }

            foreach($Returns as $row){

                if(!empty($row->Cost_Center)){

                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){
                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }

                if($row->Return()->first()->Purchase()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Return()->first()->Purchase()->first()->Payment_Method == 'Later'){

                    $payment=  trans('admin.Later');
                }elseif($row->Return()->first()->Purchase()->first()->Payment_Method == 'Check'){

                    $payment=  trans('admin.Check');
                }

                $Def=DefaultDataShowHide::orderBy('id','desc')->first();
                if($Def->Code_Report == 1){
                    $opo='';
                }else{

                    $opo='no-print';

                }

                if($Def->Refrence_Number_Print == 1){
                    $opoR='';
                }else{

                    $opoR='no-print';

                }

                if($Def->Unit == 1){
                    $opoU='';
                }else{

                    $opoU='no-print';

                }
                if($row->Return()->first()->Purchase()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Return()->first()->Purchase()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }

                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

    <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }

                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

    <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';


                            }
                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }

                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

    <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }

                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>

    <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

                   <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';


                        }

                    }

                }
            }

            return   $output ;
        }



        return view('admin.Reports.NetPurchasesFilterTwo',get_defined_vars());
    }



    //Net Sales
    public function NetSalesPage(){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();
        return view('admin.Reports.NetSales',get_defined_vars());
    }

    public function NetSalesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();
        
        
     $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            $Executor = $request->get('Executor');
            $Coin = $request->get('Coin');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Cost_Center = $request->get('Cost_Center');
            $Delegate = $request->get('Delegate');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $Type = $request->get('Type');
            $Code = $request->get('Code');

         $baseProductSalesQuery = ProductSales::query()
            ->whereBetween('Date', [$From, $To]) // شرط التاريخ الأساسي
            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales', 'Client', $Client);
            })
            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales', 'Executor', $Executor);
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Sales', 'Coin', $Coin);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales', 'Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales', 'Payment_Method', $Payment_Method);
            })
            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Sales', 'Cost_Center', $Cost_Center);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales', 'Delegate', $Delegate);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Sales', 'User', $User);
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales', 'Store', $Store);
            })
            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Sales', 'Type', $Type);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales', 'Code', $Code);
            })
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            })
            // الشروط الثابتة (عدم الحذف أو التعديل)
            ->whereRelation('Sales', 'Edit', 0)
            ->whereRelation('Sales', 'Delete', 0);


        // ----------------------------------------------------------------------
        // 2. حساب المتغيرات من ProductSales باستخدام $baseProductSalesQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المبيعات المصفحة (Pagination)
        $Purchs = $baseProductSalesQuery->clone()->paginate(30);

        // حساب عدد سجلات المبيعات ($PCount)
        $PCount = $baseProductSalesQuery->clone()->count();


        // ----------------------------------------------------------------------
        // 3. بناء الاستعلام الأساسي لـ ReturnSalesProducts (المرتجعات)
        // ----------------------------------------------------------------------

        // ملاحظة: هذا الاستعلام يستخدم الأعمدة مباشرة (Client, Executor, الخ)
        // بينما استعلام المبيعات يستخدم whereRelation('Sales', '...')
        $baseReturnSalesQuery = ReturnSalesProducts::query()
            ->whereBetween('Date', [$From, $To]) // شرط التاريخ الأساسي
            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client', $Client);
            })
            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->where('Executor', $Executor);
            })
            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin', $Coin);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method', $Payment_Method);
            })
            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center', $Cost_Center);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate', $Delegate);
            })
            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User', $User);
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type', $Type);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code', $Code);
            })
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            });


        // ----------------------------------------------------------------------
        // 4. حساب المتغيرات من ReturnSalesProducts باستخدام $baseReturnSalesQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المرتجعات المصفحة (Pagination)
        $Returns = $baseReturnSalesQuery->clone()->paginate(30);

        // حساب عدد سجلات المرتجعات ($PRCount)
        $PRCount = $baseReturnSalesQuery->clone()->count();

        // ----------------------------------------------------------------------
        // 5. تهيئة $ProdsCount
        // ----------------------------------------------------------------------
        // بناءً على الكود الأصلي، $ProdsCount كان 0 في النهاية.
        // إذا كنت تقصد جمع $PCount و $PRCount هنا، فيجب أن تعدل ذلك.
        // ولكن للحفاظ على الكود كما هو تمامًا، سنبقيه 0.
        $ProdsCount = 0; // أو $PCount + $PRCount إذا كان هذا هو المقصود

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            $Executor = $request->get('Executor');
            $Coin = $request->get('Coin');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Cost_Center = $request->get('Cost_Center');
            $Delegate = $request->get('Delegate');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $Type = $request->get('Type');
            $Code = $request->get('Code');

            foreach($Purchs as $row){

                if(!empty($row->Cost_Center)){
                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{
                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){

                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{
                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }

                if(!empty($row->Executor)){
                    if(app()->getLocale() == 'ar' ){
                        $exee=$row->Executor()->first()->Name;
                    }else{

                        $exee=$row->Executor()->first()->NameEn;
                    }

                }else{

                    $exee='';
                }

                if($row->Sales()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Sales()->first()->Payment_Method == 'Later'){

                    $payment=  trans('admin.Later');
                }elseif($row->Sales()->first()->Payment_Method == 'Installment'){

                    $payment=  trans('admin.Installment');
                }elseif($row->Sales()->first()->Payment_Method == 'Check'){

                    $payment=  trans('admin.Check');
                }

                $Def=DefaultDataShowHide::orderBy('id','desc')->first();
                if($Def->Code_Report == 1){
                    $opo='';
                }else{

                    $opo='no-print';

                }

                if($Def->Refrence_Number_Print == 1){
                    $opoR='';
                }else{

                    $opoR='no-print';

                }

                if($Def->Unit == 1){
                    $opoU='';
                }else{

                    $opoU='no-print';

                }

                if($row->Sales()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Sales()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }


                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
     <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

        <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>
                  <td class="no-print">
     '.$storName.'
       </td>


        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }


                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
     <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
      '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

        <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>
                  <td class="no-print">
     '.$storName.'
       </td>


        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';



                            }

                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }


                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
     <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

        <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>
                  <td class="no-print">
     '.$storName.'
       </td>


        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }


                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
     <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotR" value="0">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

        <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>
                  <td class="no-print">
     '.$storName.'
       </td>


        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }

            foreach($Returns as $row){

                if(!empty($row->Cost_Center)){
                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){
                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{
                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{


                    $dele='';
                }

                if(!empty($row->Executor)){
                    if(app()->getLocale() == 'ar' ){
                        $exee=$row->Executor()->first()->Name;
                    }else{
                        $exee=$row->Executor()->first()->NameEn;
                    }

                }else{


                    $exee='';
                }

                if($row->Return()->first()->Sales()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Later'){

                    $payment=  trans('admin.Later');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Installment'){


                    $payment=  trans('admin.Installment');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Check'){


                    $payment=  trans('admin.Check');
                }

                $Def=DefaultDataShowHide::orderBy('id','desc')->first();
                if($Def->Code_Report == 1){
                    $opo='';
                }else{

                    $opo='no-print';

                }

                if($Def->Refrence_Number_Print == 1){
                    $opoR='';
                }else{

                    $opoR='no-print';

                }

                if($Def->Unit == 1){
                    $opoU='';
                }else{

                    $opoU='no-print';

                }

                if($row->Return()->first()->Sales()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Return()->first()->Sales()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }




                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
        <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

           <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

              <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }




                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
        <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

           <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

              <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }
                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }




                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
        <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

           <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

              <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }




                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td class="no-print">
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td class="'.$opoR.'">
     '.$row->Refernce_Number.'
       </td>
        <td class="'.$opo.'">
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td class="'.$opoU.'">
     '.$UniiName.'
       </td>

              <td class="no-print">
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="Tot" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotR" value="'.$row->Total.'">
       </td>


      <td class="no-print">
     '.$dele.'

       </td>

           <td class="no-print">
     '.$exee.'

       </td>

             <td class="no-print">
     '.$CoinName.'
       </td>

             <td class="no-print">
     '.$cost.'
       </td>

             <td class="no-print">
     '.$safeName.'
       </td>

              <td class="no-print">
     '.$storName.'
       </td>

        <td class="no-print">
     '.$row->Type.'
       </td>

        <td class="no-print">
     '.$payment.'
       </td>

       <td class="no-print">
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }


            return   $output ;
        }



        return view('admin.Reports.NetSalesFilterTwo',get_defined_vars());
    }



    //Total Net Purchases
    public function TotalNetPurchasesPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        return view('admin.Reports.TotalNetPurchases',get_defined_vars());
    }


    public function TotalNetPurchasesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        
          $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $group = $request->get('group');
            $Store = $request->get('Store');

        
       $basePurchasesQuery = ProductsPurchases::query()
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($group), function ($query) use ($group) {
                // يفترض أن ProductsPurchases لديه علاقة 'Product'
                // وأن موديل Product لديه عمود 'Group'
                return $query->whereRelation('Product', 'Group', $group);
            })
            // شروط ثابتة متعلقة بالعلاقة 'Purchase'
            ->whereRelation('Purchase', 'Edit', 0)
            ->whereRelation('Purchase', 'Delete', 0)
            // شرط نطاق التاريخ
            ->whereBetween('Date', [$From, $To]);


        // ----------------------------------------------------------------------
        // 2. حساب المتغيرات من ProductsPurchases باستخدام $basePurchasesQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المشتريات المصفحة (Pagination)
        // لا يوجد orderBy('id', 'asc') في الكود الأصلي لـ $Purchs، لذا لا نضيفه هنا
        $Purchs = $basePurchasesQuery->clone()->paginate(50);

        // حساب عدد سجلات المشتريات ($ProdsCount)
        // الكود الأصلي لـ $ProdsCount كان يحتوي على orderBy('id', 'asc')
        $ProdsCount = $basePurchasesQuery->clone()->orderBy('id', 'asc')->count();


        // ----------------------------------------------------------------------
        // 3. حساب إجمالي الخصم على الفواتير ($DiscountOnBill)
        // ----------------------------------------------------------------------

        // هذا الاستعلام منفصل ولا يعتمد على الفلاتر المعقدة لمنتجات المشتريات
        // ولكنه يعتمد على فلاتر الوقت والحالة في موديل Purchases
        $DiscountOnBill = Purchases::query()
            ->whereBetween('Date', [$From, $To])
            ->where('Edit', 0)
            ->where('Delete', 0)
            ->get()->sum('DiscountBill');




        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $group = $request->get('group');
            $Store = $request->get('Store');

            foreach($Purchs as $row){


                if($group != ''){
                    if($row->Product()->first()->Group == $group){



                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$row->P_Ar_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }
                            $UniiName=$row->Unit()->first()->Name;

                            $GropName=$row->Product()->first()->Group()->first()->Name;
                            $storName=$row->Store()->first()->Name;


                        }else{
                            $ProoName=$row->P_En_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $UniiName=$row->Unit()->first()->NameEn;
                            $GropName=$row->Product()->first()->Group()->first()->NameEn;
                            $storName=$row->Store()->first()->NameEn;



                        }



                        $output .= '
       <tr>

          <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Qty.'
      <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

        <td>
     '.$storName.'
       </td>


        </tr>
            ';

                    }

                }else{


                    if(app()->getLocale() == 'ar' ){
                        $ProoName=$row->P_Ar_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->Name;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->Name;
                        }else{
                            $ProoVVName='';
                        }
                        $UniiName=$row->Unit()->first()->Name;

                        $GropName=$row->Product()->first()->Group()->first()->Name;
                        $storName=$row->Store()->first()->Name;


                    }else{
                        $ProoName=$row->P_En_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->NameEn;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->NameEn;
                        }else{
                            $ProoVVName='';
                        }


                        $UniiName=$row->Unit()->first()->NameEn;
                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                        $storName=$row->Store()->first()->NameEn;



                    }


                    $output .= '
       <tr>

          <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Qty.'
      <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

        <td>
     '.$storName.'
       </td>


        </tr>
            ';

                }




            }

            return   $output ;
        }

        return view('admin.Reports.TotalNetPurchasesFilterTwo',get_defined_vars());
    }

//TotalNetSales
    public function TotalNetSalesPage(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        return view('admin.Reports.TotalNetSales',get_defined_vars());
    }


    public function TotalNetSalesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $group = $request->get('group');
        $Store = $request->get('Store');


      
        $baseProductSalesQuery = ProductSales::query()
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                        ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
                });
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store', $Store);
            })
            ->when(!empty($group), function ($query) use ($group) {
                // يفترض أن ProductSales لديه علاقة 'Product'
                // وأن موديل Product لديه عمود 'Group'
                return $query->whereRelation('Product', 'Group', $group);
            })
            // شروط ثابتة متعلقة بالعلاقة 'Sales'
            ->whereRelation('Sales', 'Edit', 0)
            ->whereRelation('Sales', 'Delete', 0)
            // شرط نطاق التاريخ
            ->whereBetween('Date', [$From, $To]);


        // ----------------------------------------------------------------------
        // 2. حساب المتغيرات من ProductSales باستخدام $baseProductSalesQuery
        // ----------------------------------------------------------------------

        // جلب سجلات المبيعات المصفحة (Pagination)
        // لا يوجد orderBy('id', 'asc') في الكود الأصلي لـ $Purchs، لذا لا نضيفه هنا
        $Purchs = $baseProductSalesQuery->clone()->paginate(50);

        // حساب عدد سجلات المبيعات ($ProdsCount)
        // الكود الأصلي لـ $ProdsCount كان يحتوي على orderBy('id', 'asc')
        $ProdsCount = $baseProductSalesQuery->clone()->orderBy('id', 'asc')->count();


        // ----------------------------------------------------------------------
        // 3. حساب إجمالي الخصم على الفواتير ($DiscountOnBill)
        // ----------------------------------------------------------------------

        // هذا الاستعلام منفصل ولا يعتمد على الفلاتر المعقدة لمنتجات المبيعات
        // ولكنه يعتمد على فلاتر الوقت والحالة في موديل Sales
        $DiscountOnBill = Sales::query()
            ->whereBetween('Date', [$From, $To])
            ->where('Edit', 0)
            ->where('Delete', 0)
            ->get()->sum('DiscountBill');


        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $group = $request->get('group');
            $Store = $request->get('Store');


            foreach($Purchs as $row){


                if($group != ''){
                    if($row->Product()->first()->Group == $group){



                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$row->P_Ar_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }
                            $UniiName=$row->Unit()->first()->Name;

                            $GropName=$row->Product()->first()->Group()->first()->Name;
                            $storName=$row->Store()->first()->Name;


                        }else{
                            $ProoName=$row->P_En_Name;

                            if(!empty($row->V1)){
                                $ProoVName=$row->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$row->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $UniiName=$row->Unit()->first()->NameEn;
                            $GropName=$row->Product()->first()->Group()->first()->NameEn;
                            $storName=$row->Store()->first()->NameEn;



                        }



                        $output .= '
       <tr>

          <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Qty.'
      <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

        <td>
     '.$storName.'
       </td>


        </tr>
            ';

                    }

                }else{


                    if(app()->getLocale() == 'ar' ){
                        $ProoName=$row->P_Ar_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->Name;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->Name;
                        }else{
                            $ProoVVName='';
                        }
                        $UniiName=$row->Unit()->first()->Name;

                        $GropName=$row->Product()->first()->Group()->first()->Name;
                        $storName=$row->Store()->first()->Name;


                    }else{
                        $ProoName=$row->P_En_Name;

                        if(!empty($row->V1)){
                            $ProoVName=$row->V1()->first()->NameEn;
                        }else{
                            $ProoVName='';
                        }


                        if(!empty($row->V2)){
                            $ProoVVName=$row->V2()->first()->NameEn;
                        }else{
                            $ProoVVName='';
                        }


                        $UniiName=$row->Unit()->first()->NameEn;
                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                        $storName=$row->Store()->first()->NameEn;



                    }


                    $output .= '
       <tr>

          <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Qty.'
      <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="Tot" value="'.$row->Total_Net.'">
       </td>

        <td>
     '.$storName.'
       </td>


        </tr>
            ';

                }




            }

            return   $output ;
        }


        return view('admin.Reports.TotalNetSalesFilterTwo',get_defined_vars());
    }


//Profits
    public function ProfitsPage(){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();

        return view('admin.Reports.Profits',get_defined_vars());
    }


    public function ProfitsFilterTwo(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();

        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $Vendor = $request->get('Vendor');
        $Coin = $request->get('Coin');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Cost_Center = $request->get('Cost_Center');
        $Delegate = $request->get('Delegate');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $Type = $request->get('Type');
        $Code = $request->get('Code');
        $totAvg=0;

        $ProdsCount=0;



        $Purchs=ProductsPurchases::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase','Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)

            ->paginate(10);



        $Returns=ReturnPurchProducts::whereBetween('Date', [$From,$To])
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor',$Vendor);

            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })

  
        

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })



            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })

            ->paginate(10);

        $PurchsS=ProductSales::whereBetween('Date', [$From,$To])
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Sales','Client',$Vendor);

            })



            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Sales','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Sales','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Sales','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Sales','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->paginate(10);

        $ReturnsS=ReturnSalesProducts::whereBetween('Date', [$From,$To])
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Client',$Vendor);

            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })



            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })
            ->paginate(10);


        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $From = $request->get('From');
            $To = $request->get('To');
            $Vendor = $request->get('Vendor');
            $Coin = $request->get('Coin');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Cost_Center = $request->get('Cost_Center');
            $Delegate = $request->get('Delegate');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $Type = $request->get('Type');
            $Code = $request->get('Code');
            $totAvg=0;


            foreach($Purchs as $row){

                if(!empty($row->Cost_Center)){
                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){

                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }

                if($row->Purchase()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Purchase()->first()->Payment_Method == 'Later'){

                    $payment=  trans('admin.Later');
                }elseif($row->Purchase()->first()->Payment_Method == 'Check'){

                    $payment=  trans('admin.Check');
                }

                if($row->Purchase()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Purchase()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){




                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }


                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

           <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'

       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotP" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotPR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }


                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

           <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'

       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotP" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotPR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                            }

                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }


                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

           <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'

       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotP" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotPR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }


                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

           <td>
     '.$row->Product_Code.'
       </td>

            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'

       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotP" value="'.$row->Total_Net.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotPR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }

            foreach($Returns as $row){

                if(!empty($row->Cost_Center)){

                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){
                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }

                if($row->Return()->first()->Purchase()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Return()->first()->Purchase()->first()->Payment_Method == 'Later'){

                    $payment= trans('admin.Later');
                }elseif($row->Return()->first()->Purchase()->first()->Payment_Method == 'Check'){

                    $payment= trans('admin.Check');
                }

                if($row->Return()->first()->Purchase()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Return()->first()->Purchase()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){



                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }



                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

               <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="TotP" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotPR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

               <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="TotP" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotPR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                            }
                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

               <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="TotP" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotPR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }



                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Purchase()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>

               <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Return_Qty.'
       </td>

           <td>
     0
     <input type="hidden" class="TotP" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotPR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>

             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

                   <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }


            foreach($PurchsS as $row){

                if(!empty($row->Cost_Center)){

                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){
                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{

                    $dele='';
                }



                if($row->Sales()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Sales()->first()->Payment_Method == 'Later'){

                    $payment= trans('admin.Later');
                }elseif($row->Sales()->first()->Payment_Method == 'Installment'){

                    $payment= trans('admin.Installment');
                }elseif($row->Sales()->first()->Payment_Method == 'Check'){

                    $payment= trans('admin.Check');
                }


                $plow=ProductUnits::where('Product',$row->Product)->where('Rate',1)->first();
                $unit=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();


                $Averagee=$average->AverageCostGet($row->Product,$plow->Barcode,$row->Store);

                $totAvg+=$Averagee * $row->Qty ;
                if($row->Sales()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Sales()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }



                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
           <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
        '.$row->Total_Net.'
     <input type="hidden" class="TotS" value="'.$row->Total_Net.'">
       <input type="hidden" class="TotCostS" value="'.$row->TotCostNew.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotSR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>


             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>
                  <td>
     '.$storName.'
       </td>


        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
           <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotS" value="'.$row->Total_Net.'">
       <input type="hidden" class="TotCostS" value="'.$row->TotCostNew.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotSR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>


             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>
                  <td>
     '.$storName.'
       </td>


        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                            }

                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
           <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotS" value="'.$row->Total_Net.'">
       <input type="hidden" class="TotCostS" value="'.$row->TotCostNew.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotSR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>


             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>
                  <td>
     '.$storName.'
       </td>


        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }



                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
           <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Qty.'
       <input type="hidden" class="Qun" value="'.$row->Qty.'">
       </td>

           <td>
     '.$row->Total_Net.'
     <input type="hidden" class="TotS" value="'.$row->Total_Net.'">
       <input type="hidden" class="TotCostS" value="'.$row->TotCostNew.'">
       </td>

      <td>
         0
     <input type="hidden" class="TotSR" value="0">
       </td>


      <td>
     '.$dele.'

       </td>


             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>
                  <td>
     '.$storName.'
       </td>


        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }

            foreach($ReturnsS as $row){

                if(!empty($row->Cost_Center)){

                    if(app()->getLocale() == 'ar' ){
                        $cost=$row->Cost_Center()->first()->Arabic_Name;
                    }else{

                        $cost=$row->Cost_Center()->first()->English_Name;
                    }
                }else{

                    $cost='';
                }

                if(!empty($row->Delegate)){
                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{

                        $dele=$row->Delegate()->first()->NameEn;
                    }

                }else{


                    $dele='';
                }



                if($row->Return()->first()->Sales()->first()->Payment_Method == 'Cash'){
                    $payment= trans('admin.Cash');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Later'){

                    $payment= trans('admin.Later');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Installment'){


                    $payment= trans('admin.Installment');
                }elseif($row->Return()->first()->Sales()->first()->Payment_Method == 'Check'){


                    $payment= trans('admin.Check');
                }

                if($row->Return()->first()->Sales()->first()->Status  == 1){

                    if($Payment_Method != ''){
                        if($row->Return()->first()->Sales()->first()->Payment_Method  == $Payment_Method){
                            if($group != ''){
                                if($row->Product()->first()->Group == $group){


                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$row->P_Ar_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$row->Unit()->first()->Name;

                                        $GropName=$row->Product()->first()->Group()->first()->Name;
                                        $CoinName=$row->Coin()->first()->Arabic_Name;
                                        $safeName=$row->Safe()->first()->Name;
                                        $storName=$row->Store()->first()->Name;
                                        $userName=$row->User()->first()->name;

                                    }else{
                                        $ProoName=$row->P_En_Name;

                                        if(!empty($row->V1)){
                                            $ProoVName=$row->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($row->V2)){
                                            $ProoVVName=$row->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }


                                        $UniiName=$row->Unit()->first()->NameEn;

                                        $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                        $CoinName=$row->Coin()->first()->English_Name;
                                        $safeName=$row->Safe()->first()->NameEn;
                                        $storName=$row->Store()->first()->NameEn;
                                        $userName=$row->User()->first()->nameEn;


                                    }



                                    $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
            <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
  <input type="hidden" class="QunR" value="'.$row->Recived_Qty.'">
       </td>

           <td>
     0
     <input type="hidden" class="TotS" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotSR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>



             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

              <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                                }

                            }else{


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
            <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
  <input type="hidden" class="QunR" value="'.$row->Recived_Qty.'">
       </td>

           <td>
     0
     <input type="hidden" class="TotS" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotSR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>



             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

              <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                            }
                        }
                    }else{

                        if($group != ''){
                            if($row->Product()->first()->Group == $group){


                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$row->P_Ar_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$row->Unit()->first()->Name;

                                    $GropName=$row->Product()->first()->Group()->first()->Name;
                                    $CoinName=$row->Coin()->first()->Arabic_Name;
                                    $safeName=$row->Safe()->first()->Name;
                                    $storName=$row->Store()->first()->Name;
                                    $userName=$row->User()->first()->name;

                                }else{
                                    $ProoName=$row->P_En_Name;

                                    if(!empty($row->V1)){
                                        $ProoVName=$row->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($row->V2)){
                                        $ProoVVName=$row->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }


                                    $UniiName=$row->Unit()->first()->NameEn;

                                    $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                    $CoinName=$row->Coin()->first()->English_Name;
                                    $safeName=$row->Safe()->first()->NameEn;
                                    $storName=$row->Store()->first()->NameEn;
                                    $userName=$row->User()->first()->nameEn;


                                }



                                $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
            <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
  <input type="hidden" class="QunR" value="'.$row->Recived_Qty.'">
       </td>

           <td>
     0
     <input type="hidden" class="TotS" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotSR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>



             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

              <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';

                            }

                        }else{


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$row->P_Ar_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$row->Unit()->first()->Name;

                                $GropName=$row->Product()->first()->Group()->first()->Name;
                                $CoinName=$row->Coin()->first()->Arabic_Name;
                                $safeName=$row->Safe()->first()->Name;
                                $storName=$row->Store()->first()->Name;
                                $userName=$row->User()->first()->name;

                            }else{
                                $ProoName=$row->P_En_Name;

                                if(!empty($row->V1)){
                                    $ProoVName=$row->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($row->V2)){
                                    $ProoVVName=$row->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$row->Unit()->first()->NameEn;

                                $GropName=$row->Product()->first()->Group()->first()->NameEn;
                                $CoinName=$row->Coin()->first()->English_Name;
                                $safeName=$row->Safe()->first()->NameEn;
                                $storName=$row->Store()->first()->NameEn;
                                $userName=$row->User()->first()->nameEn;


                            }



                            $output .= '
       <tr>
       <td>
     '.$row->Date.'
       </td>
          <td>
     '.$row->Return()->first()->Sales()->first()->Code.'
       </td>
          <td>
     '.$row->Refernce_Number.'
       </td>
            <td>
     '.$row->Product_Code.'
       </td>
            <td>
     '.$ProoName.' ( '.$ProoVName.' -  '.$ProoVVName.')
       </td>

           <td>
     '.$UniiName.'
       </td>

              <td>
     '.$GropName.'
       </td>


           <td>
     '.$row->Price.'
       </td>

           <td>
     '.$row->Recived_Qty.'
  <input type="hidden" class="QunR" value="'.$row->Recived_Qty.'">
       </td>

           <td>
     0
     <input type="hidden" class="TotS" value="0">
       </td>

      <td>
        '.$row->Total.'
     <input type="hidden" class="TotSR" value="'.$row->Total.'">
       </td>


      <td>
     '.$dele.'

       </td>



             <td>
     '.$CoinName.'
       </td>

             <td>
     '.$cost.'
       </td>

             <td>
     '.$safeName.'
       </td>

              <td>
     '.$storName.'
       </td>

        <td>
     '.$row->Type.'
       </td>

        <td>
     '.$payment.'
       </td>

       <td>
     '.$userName.'
       </td>

        </tr>
            ';



                        }

                    }

                }
            }



            return   $output ;
        }

        return view('admin.Reports.ProfitsFilterTwo',get_defined_vars());
    }

    //ProductProfits
    public function ProductProfits(){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();

        return view('admin.Reports.ProductProfits',get_defined_vars());
    }


    public function ExceptProductProfitsFilterTwo(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();
        $search = $request->get('search');
        $store = $request->get('Store');


      // 2. بناء استعلام Eloquent
        $Prods = ProductsQty::
            
            // تطبيق شرط البحث إذا كان متغير البحث غير فارغ
            when(!empty($search), function ($query) use ($search) {
                // استخدام where/orWhere لتطبيق البحث على حقول متعددة
                // يتم تجميع شروط البحث OR داخل where واحد لتجنب تعارضها مع شروط أخرى
                return $query->where(function ($subQuery) use ($search) {
                    $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                             ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                             ->orWhere('V_Name', 'ILIKE', "%{$search}%")
                             ->orWhere('VV_Name', 'ILIKE', "%{$search}%")
                             ->orWhere('P_Code', 'ILIKE', "%{$search}%")
                             ->orWhere('PP_Code', 'ILIKE', "%{$search}%")
                             ->orWhere('PPP_Code', 'ILIKE', "%{$search}%")
                             ->orWhere('PPPP_Code', 'ILIKE', "%{$search}%");
                });
            })

            // تطبيق شرط التصفية حسب المتجر إذا كان المتغير غير فارغ
            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })

            // 3. تطبيق تقسيم الصفحات
            ->paginate(10);
        
        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $store = $request->get('Store');

            foreach($Prods as $rows){

                if($store == $rows->Store){
                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();



                $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);


                $f=  ($rr->Price * ($rows->Qty / $rr->Rate) )  - ($Average * ($rows->Qty / $rr->Rate));
                $ff=   ($Average * ($rows->Qty / $rr->Rate));
                $fff=  ($rr->Price * ($rows->Qty / $rr->Rate) );

                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $StoreNemo=$rows->Store()->first()->NameEn;

                    }



                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>

        <td>'.$rr->Price.'

         <input type="hidden"  class="form-control TotPr" value="'.$fff.'" >
        </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>


        <td>'.$Average.'
        <input type="hidden"  class="form-control TotC" value="'.$ff.'" >
        </td>
        <td>'.$f .'
         <input type="hidden"  class="form-control TotP" value="'.$f.'" >
        </td>

          <td>
        '.$StoreNemo.'
        </td>

        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Serial'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $StoreNemo=$rows->Store()->first()->NameEn;

                    }





                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);

                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }

                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>

        <td>'.$rr->Price.'

         <input type="hidden"  class="form-control TotPr" value="'.$fff.'" >
        </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>


        <td>'.$Average.'
        <input type="hidden"  class="form-control TotC" value="'.$ff.'" >
        </td>
        <td>'. $f.'
         <input type="hidden"  class="form-control TotP" value="'.$f.'" >
        </td>

          <td>
        '.$StoreNemo.'
        </td>






        </tr>
            ';

                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $StoreNemo=$rows->Store()->first()->NameEn;

                    }





                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$rows->V_Name.')

        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>

        <td>'.$rr->Price.'

         <input type="hidden"  class="form-control TotPr" value="'.$fff.'" >
        </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>


        <td>'.$Average.'
        <input type="hidden"  class="form-control TotC" value="'.$ff.'" >
        </td>
        <td>'.$f .'
         <input type="hidden"  class="form-control TotP" value="'.$f.'" >
        </td>

          <td>
        '.$StoreNemo.'
        </td>






        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $StoreNemo=$rows->Store()->first()->NameEn;

                    }




                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$rows->V_Name.')   ('.$rows->VV_Name.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);

                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>

        <td>'.$rr->Price.'

         <input type="hidden"  class="form-control TotPr" value="'.$fff.'" >
        </td>

         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>


        <td>'.$Average.'
        <input type="hidden"  class="form-control TotC" value="'.$ff.'" >
        </td>
        <td>'.$f .'
         <input type="hidden"  class="form-control TotP" value="'.$f.'" >
        </td>

          <td>
        '.$StoreNemo.'
        </td>






        </tr>
            ';
                }


            }}

            return   $output ;
        }

        return view('admin.Reports.ExceptProductProfitsFilterTwo',get_defined_vars());
    }


    //ProductProfitsNew

    public function ProductProfitsNew(){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::type()->get();
        $Users = Admin::all();


        return view('admin.Reports.ProductProfitsNew',get_defined_vars());
    }

    public function ExceptProductProfitsNewFilterTwo(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::all();

        $search = $request->get('search');
        $store = $request->get('Store');

        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Delegate = $request->get('Delegate');
        $Code = $request->get('Code');


  $baseProductSalesQuery = ProductSales::query()
    // 1. التصفية حسب نطاق التاريخ (موجود في ProductSales)
    ->whereBetween('Date', [$From, $To])

    // 2. تطبيق التصفية على العلاقة 'Sales' (WhereRelation)
    // جميع هذه الشروط تفلتر جدول المبيعات (Sales)
    ->when(!empty($Client), function ($query) use ($Client) {
        return $query->whereRelation('Sales', 'Client', $Client);
    })
    ->when(!empty($Safe), function ($query) use ($Safe) {
        return $query->whereRelation('Sales', 'Safe', $Safe);
    })
    ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
        return $query->whereRelation('Sales', 'Payment_Method', $Payment_Method);
    })
    ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->whereRelation('Sales', 'Delegate', $Delegate);
    })
    // الشرط الصحيح للمتجر: يطبق على حقل 'Store' في جدول المبيعات المرتبط
    ->when(!empty($store), function ($query) use ($store) {
        return $query->whereRelation('Sales', 'Store', $store);
    })
    ->when(!empty($Code), function ($query) use ($Code) {
        return $query->whereRelation('Sales', 'Code', $Code);
    })
    
    // 3. تطبيق شروط البحث النصي (على حقول ProductSales)
    ->when(!empty($search), function ($query) use ($search) {
        // نستخدم تجميع where لضمان أن البحث OR لا يتعارض مع شروط whereRelation أعلاه
        return $query->where(function ($subQuery) use ($search) {
            $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                     ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                     ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
        });
    })
    

    
    // 5. تصفية الحالات (إلغاء المبيعات المعدلة أو المحذوفة)
    ->whereRelation('Sales', 'Edit', 0)
    ->whereRelation('Sales', 'Delete', 0);

        // ----------------------------------------------------------------------
        // 2. جلب المنتجات المصفحة (Pagination)
        // ----------------------------------------------------------------------

        $Prods = $baseProductSalesQuery->clone()->paginate(50);


        // ----------------------------------------------------------------------
        // 3. بناء الاستعلام الأساسي لـ Sales (لـ $BillDiscount)
        // ----------------------------------------------------------------------
        // هذا الاستعلام يفلتر مباشرة على أعمدة موديل Sales
        $baseSalesQuery = Sales::query()
            ->whereBetween('Date', [$From, $To])
            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client', $Client);
            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe', $Safe);
            })
            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method', $Payment_Method);
            })
            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate', $Delegate);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })
            ->when(!empty($Code), function ($query) use ($Code) {
                // ملاحظة: الكود الأصلي هنا كان 'Sales','Code',$Code
                // ولكن بما أننا على موديل Sales نفسه، يجب أن تكون 'Code'
                return $query->where('Code', $Code);
            })
            
            ->where('Edit', 0)
            ->where('Delete', 0);


        // ----------------------------------------------------------------------
        // 4. حساب BillDiscount
        // ----------------------------------------------------------------------

        $BillDiscount = $baseSalesQuery->clone()->get()->sum('DiscountBill');

        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $store = $request->get('Store');
            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            $Safe = $request->get('Safe');
            $Payment_Method = $request->get('Payment_Method');
            $Delegate = $request->get('Delegate');
            $Code = $request->get('Code');
            foreach($Prods as $rows){
   if($store == $rows->Store){
                $f=  $rows->Total_Net  - $rows->TotCostNew;

                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $StoreNemo=$rows->Store()->first()->Name;

                    }


                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->Product_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
          '.$rows->Unit()->first()->Name.'
        </td>

        <td>'.$rows->Price.'


         <input type="hidden"  class="form-control TotPrices" value="'.$rows->Price * $rows->Qty.'" >
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


       <td>
        '.$rows->Discount *  $rows->Qty.'
          <input type="hidden"  class="form-control TotDisc" value="'.$rows->Discount *  $rows->Qty.'" >
        </td>

    <td>

    '.$rows->Total_Net.'
      <input type="hidden"  class="form-control TotPr" value="'.$rows->Total_Net.'" >
        </td>


        <td>'.$rows->CostPrice.'

        </td>


        <td>

        '.number_format($rows->TotCostNew,2).'

      <input type="hidden"  class="form-control TotC" value="'.$rows->TotCostNew.'" >
        </td>


        <td>'.$f .'
         <input type="hidden"  class="form-control TotP" value="'.$f.'" >
        </td>

          <td>
        '.$StoreNemo.'
        </td>






        </tr>
            ';




            }
            return   $output ;
        }}
        return view('admin.Reports.ExceptProductProfitsNewFilterTwo',get_defined_vars());
    }



    //ShiftsReportPage
    public function ShiftsReportPage(){
        $Employess = Employess::type()->get();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        return view('admin.Reports.ShiftsReport',get_defined_vars());
    }

    function ShiftReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';


            $Date = $request->get('Date');
            $Shift = $request->get('Shift');
            $Emp = $request->get('Emp');
            $Store = $request->get('Store');
            $Safe = $request->get('Safe');


            $Purchs=Shifts::latest('id')

                ->when(!empty($Date), function ($query) use ($Date) {
                    return $query->where('Date',$Date);

                })
                ->when(!empty($Shift), function ($query) use ($Shift) {
                    return $query->where('Code',$Shift);

                })
                ->when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->where('Emp',$Emp);

                })
                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe',$Safe);

                })

                ->get();




            $total_row = $Purchs->count();
            if($total_row > 0)
            {

                foreach($Purchs as $row){

                    if(!empty($row->Store)){

                        $Store=$row->Store()->first()->Name;
                    }else{

                        $Store='';
                    }

                    if(!empty($row->Safe)){

                        $Safe=$row->Safe()->first()->Name;
                    }else{

                        $Safe='';
                    }


                    if($row->Close == 1){
                        $salesNumber=Sales::where('Edit',0)->where('Delete',0)->where('Shift_Code',$row->Code)->count();
                        $ClientsNumber=Sales::where('Edit',0)->where('Delete',0)->where('Shift_Code',$row->Code)->distinct(['Client'])->count();

                        if(app()->getLocale() == 'ar' ){
                            $txNamme=$row->Emp()->first()->Name;
                        }else{

                            $txNamme=$row->Emp()->first()->NameEn;
                        }
                        $output .= '
       <tr>
       <td>
     '.$row->Code.'
       </td>
           <td>
     '.$row->Date.'
       </td>
              <td>
     '.$row->Total_Cash.'
     <input type="hidden" class="TotCash" value="'.$row->Total_Cash.'">
       </td>


                     <td>
     '.$row->Total_Later.'
     <input type="hidden" class="TotLater" value="'.$row->Total_Later.'">
       </td>

                     <td>
     '.$row->Total_Later_Not_Paid.'
     <input type="hidden" class="TotLaterNot" value="'.$row->Total_Later_Not_Paid.'">
       </td>

                     <td>
     '.$row->Total_Later_Paid.'
     <input type="hidden" class="TotLaterPaid" value="'.$row->Total_Later_Paid.'">
       </td>

                            <td>
     '.$row->Total_Visa.'
     <input type="hidden" class="Totvisa" value="'.$row->Total_Visa.'">
       </td>


                                <td>
     '.$row->Total_Recipt.'
     <input type="hidden" class="Total_Recipt" value="'.$row->Total_Recipt.'">
       </td>



                                <td>
     '.$row->Total_Installment.'
     <input type="hidden" class="Total_Installment" value="'.$row->Total_Installment.'">
       </td>

                                <td>
     '.$row->Total_Checks.'
     <input type="hidden" class="Total_Checks" value="'.$row->Total_Checks.'">
       </td>

                                <td>
     '.$row->Total_Delivery.'
     <input type="hidden" class="Total_Delivery" value="'.$row->Total_Delivery.'">
       </td>

                                <td>
     '.$row->Total_Installment_Companies.'
     <input type="hidden" class="Total_Installment_Companies" value="'.$row->Total_Installment_Companies.'">
       </td>

                               <td>
     '.$row->Total_Payment.'
     <input type="hidden" class="Total_Payment" value="'.$row->Total_Payment.'">
       </td>

                               <td>
     '.$row->Apps.'
     <input type="hidden" class="Total_Payment" value="'.$row->Total_Payment.'">
       </td>

                            <td>
     '.$row->Total.'
     <input type="hidden" class="Tot" value="'.$row->Total.'">
       </td>

                            <td>
     '.$row->Amount.'
     <input type="hidden" class="Amo" value="'.$row->Amount.'">
       </td>


      <td>
     '.$txNamme.'
       </td>

             <td>
     '.$Store.'
       </td>

             <td>
     '.$Safe.'
       </td>

             <td>
     '.$row->Note.'
       </td>

             <td>
     '.$salesNumber.'
       </td>

             <td>
     '.$ClientsNumber.'
       </td>

             <td>
     '.$row->Close_Date.'
       </td>

        </tr>
            ';

                    }
                }

            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //ShiftsDetailsReportPage
    public function ShiftsDetailsReportPage(){

        $Stores=Stores::type()->get();
        $items=Sales::orderBy('id','desc')
            ->where('Sale_Type','POS')
            ->where('Status',1)
            ->where('Hold',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(100);

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();
        $Recipts=ReciptVoucher::where('Shift','!=',null)->paginate(100);
        $Payments=PaymentVoucher::where('Shift','!=',null)->paginate(100);

        return view('admin.Reports.ShiftsDetailsReport',get_defined_vars());
    }

    public function FilterShiftDetails(){

        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();

$code=request('Code');
$Store=request('Store');
$Safe=request('Safe');
$Delegate=request('Delegate');
$Emp=request('Emp');

        $items=Sales::orderBy('id','desc')
            ->where('Sale_Type','POS')
            ->where('Status',1)
            ->where('Hold',0)
            ->whereBetween('Date', [request('From'), request('To')])
            ->where('Edit',0)
            ->where('Delete',0)


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Shift_Code',$code);

            })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })


            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })


            ->when(!empty($Emp), function ($query) use ($Emp) {
                return $query->where('Executor',$Emp);

            })



            ->paginate(30);


        $Recipts=ReciptVoucher::where('Shift','!=',null)

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Shift',$code);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })




            ->paginate(30);

        $Payments=PaymentVoucher::where('Shift','!=',null)
            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Shift',$code);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })


            ->paginate(30);

        $items->appends(request()->query());
        $Recipts->appends(request()->query());
        $Payments->appends(request()->query());

        return view('admin.Reports.ShiftsDetailsReport',get_defined_vars());
    }

//DailyClosingPage
    public function DailyClosingPage(){
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        return view('admin.Reports.DailyClosing',get_defined_vars());
    }

    function FilterDailyClosing(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $out = '';
            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            if( $safe != ''){

                $PurchCash =Purchases::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');


                $PurchLater =Purchases::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Later')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Pay');


                $Cash =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');


                $Later =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Later')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Pay');

                $CashVisa =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash_Visa')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');


                $Installment =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Installment')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('presenter');


                $Visa =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Visa')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');



                $Check =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Check')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');



                $Cash_Collection =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash_Collection')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');



                $Delivery =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Delivery')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');



                $InstallmentCompanies =Sales::orderBy('id','asc')
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->where('Safe',$safe)
                    ->where('Payment_Method','InstallmentCompanies')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Net');


                $TotSales=  $Cash + $Later +  $CashVisa+ $Installment + $Visa  + $Check  + $Cash_Collection  + $Delivery + $InstallmentCompanies ;
                $TotPurch=  $PurchCash + $PurchLater;


                $ReciptTot =ReciptVoucher::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get()->sum('Total_Creditor');




                $PaymentTot =PaymentVoucher::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get()->sum('Total_Debaitor');


                $DifRP= $ReciptTot - $PaymentTot ;
                $Amount = $DifRP +   $TotSales  ;

                $Discooo =Sales::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get()->sum('Pay');

                $ALLLL =Sales::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get()->sum('Total_Discount');



                $TransferTotTo=SafeTransfers::whereIn('To_Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Amount');



                $TransferTotFrom=SafeTransfers::whereIn('From_Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Amount');

                $Disc=$Cash - $Discooo ;
                $DiscAll=$ALLLL ;



                $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الشيكات الواردة')
                    ->get()->sum('Debitor_Coin');

                $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','تسوية بالعجز')
                    ->get()->sum('Debitor_Coin');

                $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','استلام وصل أمانة')
                    ->get()->sum('Debitor_Coin');


                $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                    ->whereIn('Safe',$safe)
                    ->get()->sum('Total');


                $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','البوليصه')
                    ->get()->sum('Debitor_Coin');


                $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الصيانة')
                    ->get()->sum('Debitor_Coin');




                $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الشيكات الصادرة')
                    ->get()->sum('Creditor_Coin');


                $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','تسوية بالزيادة')
                    ->get()->sum('Creditor_Coin');


                $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','مرتجع الصيانة')
                    ->get()->sum('Creditor_Coin');

                $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','صرف راتب')
                    ->get()->sum('Creditor_Coin');

                $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','سلفه موظف')
                    ->get()->sum('Creditor_Coin');

                $AssetPurch =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','شراء أصل')
                    ->get()->sum('Creditor_Coin');

                $Loan =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','قرض موظف')
                    ->get()->sum('Creditor_Coin');

                $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type',trans('admin.ExchangeCommissions'))
                    ->get()->sum('Creditor_Coin');


                $PurchAsset =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','شراء أصل')
                    ->get()->sum('Creditor_Coin');




            }


            $output .= '
      <tr class="Sales">
            <td>'.trans('admin.Sales').'</td>
        <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalesDet" onclick="DetailsSales()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


            $RCashh =ReturnSales::whereBetween('Date', [$from, $to])->whereIn('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RLaterr =ReturnSales::whereBetween('Date', [$from, $to])->whereIn('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');


            $KhsmMasmou7 =Sales::whereBetween('Date', [$from, $to])
                ->whereIn('Safe',$safe)
                ->get()->sum('Total_Discount');


            $TotallSaless=$TotSales ;
            $output .= '
   <tr class="TotalSales">
     <td>     '.trans('admin.Total_Sales').' </td>
<td style="border: none;text-align: end;">'.$TotallSaless + $KhsmMasmou7.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="RSales">
            <td>  '.trans('admin.Return_Sales').'</td>
           <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RSalesDet" onclick="DetailsRSales()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';

            $RTotSales=  $RCashh + $RLaterr ;


            $output .= '
   <tr class="RTotalSales">
     <td>   '.trans('admin.Total_Return_Sales').' </td>
<td style="border: none;text-align: end;">'.$RTotSales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
   <tr class="TotalSales">
     <td>    '.trans('admin.Discount_Allow').' </td>
<td style="border: none;text-align: end;">'.$KhsmMasmou7.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $SafySales=$TotallSaless - ($RTotSales);

            $output .= '
   <tr class="NetSales">
     <td>       '.trans('admin.Net_Sales').' </td>
<td style="border: none;text-align: end;">'.$SafySales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Recipt">
            <td>    '.trans('admin.Recipt_Vouchers').'</td>
              <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ReciptDet" onclick="DetailsRecipt()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';




            $output .= '
   <tr class="TotalRecipt">
     <td>         '.trans('admin.Total_Recipt_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$ReciptTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Payment">
            <td> '.trans('admin.Safes_Transfer').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TranferToDet" onclick="DetailsTransferTo()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';





            $output .= '
   <tr class="TotalPayment">
     <td>   '.trans('admin.Total_Safes_Transfer').'</td>
<td style="border: none;text-align: end;">'.$TransferTotTo.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $output .= '
      <tr class="ImportCheck">
            <td> '.trans('admin.Incoming_Checks').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ImportCheckDet" onclick="DetailsImportCheck()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';





            $output .= '
   <tr class="ImportCheck">
     <td>  '.trans('admin.Total_Incoming_Checks').'</td>
<td style="border: none;text-align: end;">'.$ImportCheck.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';

            $output .= '
      <tr class="Settlement3agz">
            <td>  '.trans('admin.Disability_Settlement').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Setllement3agzDet" onclick="DetailsSetllement3agz()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Settlement3agz">
     <td>  '.trans('admin.Total_Disability_Settlement').'</td>
<td style="border: none;text-align: end;">'.$Setllement3agz.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $output .= '
      <tr class="WaslAmana">
            <td>   '.trans('admin.Insurance_Paper').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#WaslAmanaDet" onclick="DetailsWaslAmana()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="WaslAmana">
     <td>   '.trans('admin.Total_Insurance_Paper').'</td>
<td style="border: none;text-align: end;">'.$WaslAmana.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';

            $output .= '
      <tr class="SalesPetrol">
            <td>  '.trans('admin.Sales_Petrol').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalesPetrolDet" onclick="DetailsSalesPetrol()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="SalesPetrol">
     <td>    '.trans('admin.Total_Sales_Petrol').'</td>
<td style="border: none;text-align: end;">'.$SalesPetrol.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $output .= '
      <tr class="shippingTicket">
            <td>     '.trans('admin.Shipping_Ticket').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#shippingTicketDet" onclick="DetailsshippingTicket()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="shippingTicket">
     <td>    '.trans('admin.Total_Shipping_Ticket').'</td>
<td style="border: none;text-align: end;">'.$shippingTicket.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $output .= '
      <tr class="Maintaince">
            <td>    '.trans('admin.Maintaince').'   </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#MaintainceDet" onclick="DetailsMaintaince()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Maintaince">
     <td>    '.trans('admin.Total_Maintaince').'</td>
<td style="border: none;text-align: end;">'.$Maintaince.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $Ward= $ReciptTot + $SafySales + $TransferTotTo + $ImportCheck + $Setllement3agz + $WaslAmana + $SalesPetrol + $shippingTicket + $Maintaince ;
            $output .= '
   <tr class="TotWard">
     <td>      '.trans('admin.Total_Incom').' </td>
<td style="border: none;text-align: end;">'.$Ward.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $output .= '
      <tr class="Payment">
            <td>  '.trans('admin.Payment_Vouchers').'</td>
          <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#PaymentDet" onclick="DetailsPayment()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';



            $output .= '
   <tr class="TotalPayment">
     <td>   '.trans('admin.Total_Payment_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$PaymentTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $output .= '
      <tr class="Purch">
            <td>'.trans('admin.Purchases').'</td>
     <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#PurchDet" onclick="DetailsPurch()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


            $RPCash =ReturnPurch::whereBetween('Date', [$from, $to])->whereIn('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RPLater =ReturnPurch::whereBetween('Date', [$from, $to])->whereIn('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');


            $AllP=$TotPurch + $RPCash + $RPLater;
            $output .= '
   <tr class="TotalPurch">
     <td>     '.trans('admin.Total_Purchases').' </td>
<td style="border: none;text-align: end;">'.$AllP.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="RPurch">
            <td> '.trans('admin.Return_Purchases').'</td>
     <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RPurchDet" onclick="DetailsRPurch()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


            $RPTotPurch=  $RPCash + $RPLater ;


            $output .= '
   <tr class="RTotalPurch">
     <td>      '.trans('admin.Total_Return_Purchases').' </td>
<td style="border: none;text-align: end;">'.$RPTotPurch.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $Safy= $AllP - $RPTotPurch ;
            $output .= '
   <tr class="NetSales">
     <td>     '.trans('admin.Net_Purchases').' </td>
<td style="border: none;text-align: end;">'.$Safy.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $output .= '
      <tr class="Payment">
            <td> '.trans('admin.Safes_Transfer').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TransferFromDet" onclick="DetailsTransferFrom()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';






            $output .= '
   <tr class="TotalPayment">
     <td>   '.trans('admin.Total_Safes_Transfer').'</td>
<td style="border: none;text-align: end;">'.$TransferTotFrom.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="ExportCheck">
            <td>   '.trans('admin.Exporting_Checks').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ExportCheckDet" onclick="DetailsExportCheck()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="ExportCheck">
     <td>   '.trans('admin.Total_Exporting_Checks').'</td>
<td style="border: none;text-align: end;">'.$ExportCheck.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $output .= '
      <tr class="SetllementZyada">
            <td>   '.trans('admin.Increment_Settlement').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SetllementZyadaDet" onclick="DetailsSetllementZyada()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="SetllementZyada">
     <td>   '.trans('admin.Total_Increment_Settlement').'</td>
<td style="border: none;text-align: end;">'.$SetllementZyada.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $output .= '
      <tr class="RMaintaince">
            <td> '.trans('admin.Return_Maintaince').'  </td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RMaintainceDet" onclick="DetailsRMaintaince()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="RMaintaince">
     <td>   '.trans('admin.Total_Return_Maintaince').'</td>
<td style="border: none;text-align: end;">'.$RMaintaince.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $output .= '
      <tr class="Salary">
            <td>   '.trans('admin.Salaries').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalaryDet" onclick="DetailsSalary()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Salary">
     <td> '.trans('admin.Total_Salaries').'</td>
<td style="border: none;text-align: end;">'.$Salary.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Borrow">
            <td>   '.trans('admin.Borrows').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#BorrowDet" onclick="DetailsBorrow()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Borrow">
     <td>  '.trans('admin.Total_Borrows').'</td>
<td style="border: none;text-align: end;">'.$Borrow.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Loan">
            <td>   '.trans('admin.Loans').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#LoanDet" onclick="DetailsLoan()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Loan">
     <td> '.trans('admin.Total_Loans').'</td>
<td style="border: none;text-align: end;">'.$Loan.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $output .= '
      <tr class="Loan">
            <td>   '.trans('admin.Assets').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#AssetDet" onclick="DetailsAssets()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Loan">
     <td> '.trans('admin.Total_Assets').'</td>
<td style="border: none;text-align: end;">'.$PurchAsset.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';






            $output .= '
      <tr class="Exchange">
            <td>   '.trans('admin.Exchanges').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ExchangeDet" onclick="DetailsExchange()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


            $output .= '
   <tr class="Exchange">
     <td>   '.trans('admin.Total_Exchanges').'</td>
<td style="border: none;text-align: end;">'.$Exchange.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $Sadr= $Safy + $PaymentTot + $TransferTotFrom + $ExportCheck + $SetllementZyada+ $RMaintaince+ $Salary+ $Borrow+ $Loan+$Exchange;
            $output .= '
   <tr class="TotSadr">
     <td>     '.trans('admin.Total_Export').' </td>
<td style="border: none;text-align: end;">'.$Sadr.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $MOshtryat=$AllP - $RPTotPurch ;


            $AM=   $Ward - $Sadr ;


            $output .= '
   <tr class="TotalSafe">
     <td>    '.trans('admin.total_daily_transactions_in_safe').'   </td>
<td style="border: none;text-align: end;">'.$AM.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $debt=GeneralDaily::whereIn('Account',$safe)->get()->sum('Debitor');
            $crdt=GeneralDaily::whereIn('Account',$safe)->get()->sum('Creditor');
            $dif=$debt - $crdt ;
            $output .= '
   <tr class="SafeF3ly">
     <td>    '.trans('admin.actual_balance_in_safe').' </td>
<td style="border: none;text-align: end;">'.$dif.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

        }
        else
        {
            $output = '
       <tr>
        <td align="center" colspan="5">'.trans('admin.No_Data_Find').'</td>
       </tr>
       ';
        }


        $data = array(
            'table_data'  => $output,

        );
        echo json_encode($data);
    }

    function FilterSalesDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Sales =Sales::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->where('Payment_Method','!=','Check')
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', 0)
                    ->where('Delete', 0)
                    ->get();


                //Sales Details
                foreach($Sales as $sal){

                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Pay;

                    }elseif($sal->Payment_Method == 'Later'){


                        $bill=$sal->Pay;


                    }elseif($sal->Payment_Method == 'Cash_Visa'){
                        $bill=$sal->Pay;

                    }elseif($sal->Payment_Method == 'Installment'){
                        $bill=$sal->Pay;
                    }elseif($sal->Payment_Method == 'Cash_Collection'){

                        $bill=$sal->Pay;

                    }elseif($sal->Payment_Method == 'Delivery'){

                        $bill=$sal->Pay;

                    }elseif($sal->Payment_Method == 'InstallmentCompanies'){

                        $bill=$sal->Pay;

                    }

                    if($sal->Pay !=  null){


                        if(app()->getLocale() == 'ar' ){
                            $xName=$sal->Client()->first()->Name;
                            $SAFE=$sal->Safe()->first()->Name;

                        }else{
                            $xName=$sal->Client()->first()->NameEn;
                            $SAFE=$sal->Safe()->first()->NameEn;

                        }
                        $output .= '
      <tr class="Sales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>
                                                    <td>'.$SAFE.'</td>

    </tr>
        ';
                    }
                }





            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterRSalesDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $ReturnSales =ReturnSales::whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->whereRelation('Sales','Edit', null)
                    ->whereRelation('Sales','Delete', null)
                    ->get();

                $RCash=0;
                $RLater=0;

                //Reurn Sales Details
                foreach($ReturnSales as $sal){

                    if($sal->Sales()->first()->Safe == $safe){
                        if($sal->Payment_Method == 'Cash'){

                            $bill=$sal->Total_Return_Value;
                            $RCash +=$sal->Total_Return_Value;
                        }elseif($sal->Payment_Method == 'Later'){

                            $bill=$sal->Pay;
                            $RLater +=$sal->Pay;
                        }


                        if($sal->Pay !=  null){

                            if(app()->getLocale() == 'ar' ){
                                $xName=$sal->Sales()->first()->Client()->first()->Name;
                                $SAFE=$sal->Sales()->first()->Safe()->first()->Name;
                            }else{
                                $xName=$sal->Sales()->first()->Client()->first()->NameEn;
                                $SAFE=$sal->Sales()->first()->Safe()->first()->NameEn;

                            }

                            $output .= '
      <tr class="RSales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

          <td>'.$SAFE.'</td>

    </tr>
        ';

                        }
                    }
                }




            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterReciptDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get();


                //Recipt Voucher Details
                foreach($ReciptVoucher as $sal){
                    $VVVVV=ReciptVoucherDetails::where('RV_ID',$sal->id)->first();


                    if(app()->getLocale() == 'ar' ){
                        $xName=$VVVVV->Account()->first()->Name;
                        $SAFE=$sal->Safe()->first()->Name;

                    }else{
                        $xName=$VVVVV->Account()->first()->NameEn;
                        $SAFE=$sal->Safe()->first()->NameEn;
                    }

                    $output .= '
      <tr class="Recipt">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Total_Creditor.'</td>
                                                              <td>'.$SAFE.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterTransferTotDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $TransfersTo=SafeTransfers::whereIn('To_Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                //Safe Transfer Details
                foreach($TransfersTo as $trans){

                    if(app()->getLocale() == 'ar' ){
                        $xName=$trans->To_Safe()->first()->Name;

                    }else{
                        $xName=$trans->To_Safe()->first()->NameEn;

                    }
                    $output .= '
      <tr class="Payment">
                                                  <td>'.$trans->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$trans->Amount.'</td>


    </tr>
        ';

                }




            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterPaymenttDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){


                $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', null)
                    ->where('Delete', null)
                    ->get();

                //Payment Voucher Details
                foreach($PaymentVoucher as $sal){

                    $VVVVV=PaymentVoucherDetails::where('PV_ID',$sal->id)->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$VVVVV->Account()->first()->Name;
                        $SAFE=$sal->Safe()->first()->Name;

                    }else{
                        $xName=$VVVVV->Account()->first()->NameEn;
                        $SAFE=$sal->Safe()->first()->NameEn;

                    }
                    $output .= '
      <tr class="Payment">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Total_Debaitor.'</td>
                                                        <td>'.$SAFE.'</td>

    </tr>
        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterPurchasesDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Purchases =Purchases::orderBy('id','asc')
                    ->whereIn('Safe',$safe)
                    ->where('Payment_Method','!=','Check')
                    ->whereBetween('Date', [$from, $to])
                    ->where('Edit', 0)
                    ->where('Delete', 0)
                    ->get();


//Purchases Details
                foreach($Purchases as $purch){

                    if($purch->Payment_Method == 'Cash'){

                        $bill=($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount;
                    }elseif($purch->Payment_Method == 'Later'){

                        $bill=(($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount) - $purch->Pay;
                    }
                    if($purch->Pay !=  null){

                        if(app()->getLocale() == 'ar' ){
                            $xName=$purch->Vendor()->first()->Name;
                            $SAFE=$purch->Safe()->first()->Name;
                        }else{
                            $xName=$purch->Vendor()->first()->NameEn;
                            $SAFE=$purch->Safe()->first()->NameEn;
                        }
                        $output .= '
      <tr class="Purch">
                                                  <td>'.$purch->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

         <td>'.$SAFE.'</td>

    </tr>
        ';

                    }
                }

            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterRPurchasesDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){


                $ReturnPurch =ReturnPurch::whereIn('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->whereRelation('Purchase','Edit', null)
                    ->whereRelation('Purchase','Delete', null)
                    ->get();

                $RPCash=0;
                $RPLater=0;


                //Return Purch Details
                foreach($ReturnPurch as $sal){

                    if($sal->Purchase()->first()->Safe == $safe){
                        if($sal->Payment_Method == 'Cash'){

                            $bill=$sal->Total_Return_Value;
                            $RPCash +=$sal->Total_Return_Value;
                        }elseif($sal->Payment_Method == 'Later'){

                            $bill=$sal->Pay;
                            $RPLater +=$sal->Pay;
                        }

                        if($sal->Pay !=  null){

                            if(app()->getLocale() == 'ar' ){
                                $xName=$sal->Purchase()->first()->Vendor()->first()->Name;
                                $SAFE=$sal->Purchase()->first()->Safe()->first()->Name;
                            }else{
                                $xName=$sal->Purchase()->first()->Vendor()->first()->NameEn;
                                $SAFE=$sal->Purchase()->first()->Safe()->first()->NameEn;
                            }
                            $output .= '
      <tr class="RPurch">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

     <td>'.$SAFE.'</td>

    </tr>
        ';

                        }
                    }
                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterTransferFromDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){




                $TransfersFrom=SafeTransfers::whereIn('From_Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                //Transfer Form Details
                foreach($TransfersFrom as $trans){

                    if(app()->getLocale() == 'ar' ){
                        $xName=$trans->From_Safe()->first()->Name;

                    }else{
                        $xName=$trans->From_Safe()->first()->NameEn;

                    }
                    $output .= '
      <tr class="Payment">
                                                  <td>'.$trans->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$trans->Amount.'</td>


    </tr>
        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterImportChecksDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الشيكات الواردة')
                    ->get();


                foreach($ImportCheck as $sal){

                    $det=IncomChecks::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();


                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Arrest_Account()->first()->Name;

                    }else{
                        $xName=$det->Arrest_Account()->first()->NameEn;

                    }
                    $output .= '
      <tr class="ImportCheck">
                                                  <td>'.$sal->Code_Type.'</td>
                                                  <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterSettlement3agzDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','تسوية بالعجز')
                    ->get();


                foreach($Setllement3agz as $sal){

                    $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Account_Dificit()->first()->Name;

                    }else{
                        $xName=$det->Account_Dificit()->first()->NameEn;

                    }
                    $output .= '
      <tr class="Settlement3agz">
                                                  <td>'.$sal->Code_Type.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterWaslDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','استلام وصل أمانة')
                    ->get();


                foreach($WaslAmana as $sal){

                    $det=InsurancePaper::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();


                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Account()->first()->Name;

                    }else{
                        $xName=$det->Account()->first()->NameEn;

                    }
                    $output .= '
      <tr class="ImportCheck">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterPetrolDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                    ->whereIn('Safe',$safe)
                    ->get();


                foreach($SalesPetrol as $sal){

                    if(app()->getLocale() == 'ar' ){
                        $xName=$sal->Safe()->first()->Name;

                    }else{
                        $xName=$sal->Safe()->first()->NameEn;

                    }

                    $output .= '
      <tr class="SalesPetrol">
                                                  <td>'.$sal->Code.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Total.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterShippingDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','البوليصه')
                    ->get();



                foreach($shippingTicket as $sal){
                    $det=Ticket::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Sender_Name()->first()->Name;

                    }else{
                        $xName=$det->Sender_Name()->first()->NameEn;

                    }

                    $output .= '
      <tr class="shippingTicket">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterMaintainceDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الصيانة')
                    ->get();


                foreach($Maintaince as $sal){
                    $det=ReciptMaintaince::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Account()->first()->Name;

                    }else{
                        $xName=$det->Account()->first()->NameEn;

                    }

                    $output .= '
      <tr class="Maintaince">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterExportChecksDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','الشيكات الصادرة')
                    ->get();


                foreach($ExportCheck as $sal){
                    $det=ExportChecks::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Pay_Account()->first()->Name;

                    }else{
                        $xName=$det->Pay_Account()->first()->NameEn;

                    }
                    $output .= '
      <tr class="ExportCheck">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterSettlementZyadaDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','تسوية بالزيادة')
                    ->get();


                foreach($SetllementZyada as $sal){
                    $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Account_Excess()->first()->Name;

                    }else{
                        $xName=$det->Account_Excess()->first()->NameEn;

                    }

                    $output .= '
      <tr class="SetllementZyada">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterRMaintainceDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','مرتجع الصيانة')
                    ->get();


                foreach($RMaintaince as $sal){
                    $det=ReturnMaintainceBill::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();


                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Account()->first()->Name;

                    }else{
                        $xName=$det->Account()->first()->NameEn;

                    }

                    $output .= '
      <tr class="RMaintaince">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterSalaryDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','صرف راتب')
                    ->get();


                foreach($Salary as $sal){
                    $det=PaySalary::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Emp()->first()->Name;

                    }else{
                        $xName=$det->Emp()->first()->NameEn;

                    }

                    $output .= '
      <tr class="Salary">
                                                  <td>'.$sal->Code.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterBorrowDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','سلفه موظف')
                    ->get();


                foreach($Borrow as $sal){
                    $det=Borrowa::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){

                        if(!empty($det)){
                            $xName=$det->Emp()->first()->Name;
                        }else{
                            $xName='';
                        }


                    }else{


                        if(!empty($det)){
                            $xName=$det->Emp()->first()->NameEn;
                        }else{
                            $xName='';
                        }


                    }

                    $output .= '
      <tr class="Borrow">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterLoanDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Loan =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','قرض موظف')
                    ->get();


                foreach($Loan as $sal){
                    $det=Loan::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Emp()->first()->Name;

                    }else{
                        $xName=$det->Emp()->first()->NameEn;

                    }

                    $output .= '
      <tr class="Loan">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    function FilterExchangeDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type',trans('admin.ExchangeCommissions'))
                    ->get();

                foreach($Exchange as $sal){
                    $det=ExchangeCommissions::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Emp()->first()->Name;

                    }else{
                        $xName=$det->Emp()->first()->NameEn;

                    }
                    $output .= '
      <tr class="Exchange">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }

    public function FilterDailyClosingForm(){

        $from = request('from');
        $to = request('to');
        $safe = request('Safe');

        $RCash=0;
        $RCashh=0;
        $RLater=0;
        $RLaterr=0;
        $RLaterr=0;
        $RPCashh=0;
        $RPLaterr=0;
        $RPCash=0;
        $RPLater=0;


        $Purchases =Purchases::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','!=','Check')
            ->whereBetween('Date', [$from, $to])
            ->get();

        $PurchCash =Purchases::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Cash')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Price');


        $PurchLater =Purchases::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Later')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Pay');


        $ReturnPurch =ReturnPurch::orderBy('id','asc')
            ->whereBetween('Date', [$from, $to])
            ->get();

        $Sales =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','!=','Check')
            ->whereBetween('Date', [$from, $to])
            ->get();

        $ReturnSales =ReturnSales::orderBy('id','asc')
            ->whereBetween('Date', [$from, $to])
            ->get();


        $Cash =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Cash')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Price');


        $Later =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Later')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Pay');

        $CashVisa =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Cash_Visa')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Price');


        $Installment =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Installment')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('presenter');

        $TotSales=  $Cash + $Later +  $CashVisa+ $Installment;
        $TotPurch=  $PurchCash + $PurchLater;
        $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->whereBetween('Date', [$from, $to])
            ->get();

        $ReciptTot =ReciptVoucher::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Creditor');


        $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->whereBetween('Date', [$from, $to])
            ->get();

        $PaymentTot =PaymentVoucher::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Debaitor');


        $DifRP= $ReciptTot - $PaymentTot ;
        $Amount = $DifRP +   $TotSales ;



        $Discooo =Sales::orderBy('id','asc')
            ->whereIn('Safe',$safe)
            ->where('Payment_Method','Cash')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Pay');

        $Disc=$Cash - $Discooo ;


        return view('admin.Reports.DailyClosingPrint',[
            'RCash'=>$RCash,
            'RCashh'=>$RCashh,
            'RLater'=>$RLater,
            'RLaterr'=>$RLaterr,
            'Sales'=>$Sales,
            'ReturnSales'=>$ReturnSales,
            'Cash'=>$Cash,
            'Later'=>$Later,
            'CashVisa'=>$CashVisa,
            'Installment'=>$Installment,
            'TotSales'=>$TotSales,
            'ReciptVoucher'=>$ReciptVoucher,
            'ReciptTot'=>$ReciptTot,
            'PaymentVoucher'=>$PaymentVoucher,
            'PaymentTot'=>$PaymentTot,
            'DifRP'=>$DifRP,
            'Amount'=>$Amount,
            'Discooo'=>$Discooo,
            'Disc'=>$Disc,
            'RPCashh'=>$RPCashh,
            'RPLaterr'=>$RPLaterr,
            'RPCash'=>$RPCash,
            'RPLater'=>$RPLater,
            'Purchases'=>$Purchases,
            'PurchCash'=>$PurchCash,
            'PurchLater'=>$PurchLater,
            'ReturnPurch'=>$ReturnPurch,
            'TotPurch'=>$TotPurch,
            'safe'=>$safe,

        ]);
    }

    function FilterAssetsDetailsDailyClosing(Request $request){

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('from');
            $to = $request->get('to');
            $safe = $request->get('Safe');
            if( $from != '' and $to != '' and $safe != ''){

                $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                    ->whereIn('Account',$safe)
                    ->where('Type','شراء أصل')
                    ->get();


                foreach($Salary as $sal){
                    $det=Assets::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                    if(app()->getLocale() == 'ar' ){
                        $xName=$det->Name;

                    }else{
                        $xName=$det->NameEn;

                    }

                    $output .= '
      <tr class="Salary">
                                                  <td>'.$sal->Code.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>



        ';

                }



            }
            $data = array(
                'table_data'  => $output,

            );
            echo json_encode($data);

        }

    }



//ProductsReportsPage
    public function ProductsReportsPage(){

        $Groups=ItemsGroups::all();
        $Brands=Brands::all();
        $Stores=Stores::type()->get();

        return view('admin.Reports.ProductsReports',get_defined_vars());
    }

    public function ProductsFilterTwo(Request $request,Average $average){

        $Groups=ItemsGroups::all();
        $Brands=Brands::all();
        $Stores=Stores::type()->get();

        $search = $request->get('search');
        $Brand = $request->get('brand');
        $Group = $request->get('group');
        $store = $request->get('store');

        $Prods=
            ProductsQty::orderBy('id','asc')

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                        ;
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);

                })
                ->when(!empty($Group), function ($query) use ($Group) {
                    return $query->where('Group',$Group);

                })


                ->when(!empty($Brand), function ($query) use ($Brand) {
                    return $query->where('Brand',$Brand);

                })

                ->paginate(100);

        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $Brand = $request->get('brand');
            $Group = $request->get('group');
            $store = $request->get('store');

            foreach($Prods as $rows){



                if($Brand != '' and $Group != ''){

                    if($rows->Product()->first()->Brand == $Brand){
                        if($rows->Product()->first()->Group == $Group){

                             if($rows->Status == 0){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->id)->first();

                        $AllQty=ProductsQty::where('Product',$rows->Product)
                            ->where('P_Code',$rows->P_Code)
                            ->orWhere('PP_Code',$rows->P_Code)
                            ->orWhere('PPP_Code',$rows->P_Code)
                            ->orWhere('PPPP_Code',$rows->P_Code)
                            ->get()->sum('Qty');

                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();

                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;




                        if(!empty($rows->Product()->first()->Brand)){
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }
                        }else{

                            $brandd="";

                        }

                        $def=StoresDefaultData::orderBy('id','desc')->first();
                        if($def->Cost_Price == 2){


                            $totCost=0;





                            $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                            $fifo =FifoQty::
                            where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('P_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                                if(empty($fifo)){

                                    $fifo =FifoQty::
                                    where('Store',$store)
                                        ->where('Product',$rows->Product)
                                        ->where('PPP_Code',$plow->Barcode)
                                        ->orderBy('Purchases_Date','asc')
                                        ->first();


                                    if(empty($fifo)){

                                        $fifo =FifoQty::
                                        where('Store',$store)
                                            ->where('Product',$rows->Product)
                                            ->where('PPPP_Code',$plow->Barcode)
                                            ->orderBy('Purchases_Date','asc')
                                            ->first();

                                    }

                                }

                            }

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= $rows->Qty){

                                            $totCost += $fifo->Cost_Price * $rows->Qty ;

                                        }else{

                                            $res=$rows->Qty - $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= $rows->Qty){

                                        $totCost += $fifo->Cost_Price * $rows->Qty ;

                                    }else{

                                        $res=$rows->Qty - $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }









                            $Cost=$totCost;
                            $CostS=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);





                        }else{



                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;



                        }

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }

                            $GropName=$rows->Product()->first()->Group()->first()->Name;


                        }else{
                            $ProoName=$rows->P_En_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$rows->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $GropName=$rows->Product()->first()->Group()->first()->NameEn;



                        }


                        $output .= '

       <tr>
             <td>
        '.$rows->P_Code.'
        </td>

        <td>
        '.$ProoName.'  ('.$ProoVName.')  ('.$ProoVVName.' )
        </td>

             <td>
        '.$GropName.'
        </td>

             <td>
        '.$brandd.'
        </td>

                <td>
        '.$rr->Unit()->first()->Name.'
        </td>

<td>'.$Cost.'</td>
<td>'.$CostS.'</td>

            <td>
        '.$AllQty.'
        </td>

                    <td>
        '.$rr->Price.'
        </td>

        <td>
        '.$rr->Price_Two.'
        </td>

        <td>
        '.$rr->Price_Three.'
        </td>



        </tr>


            ';
                    }

                        }
                    }

                }elseif($Brand != '' and $Group == ''){

                    if($rows->Product()->first()->Brand == $Brand){

                        if($rows->Status == 0){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->id)->first();

                        $AllQty=ProductsQty::where('Product',$rows->Product)
                            ->where('P_Code',$rows->P_Code)
                            ->orWhere('PP_Code',$rows->P_Code)
                            ->orWhere('PPP_Code',$rows->P_Code)
                            ->orWhere('PPPP_Code',$rows->P_Code)
                            ->get()->sum('Qty');

                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();

                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;




                        if(!empty($rows->Product()->first()->Brand)){
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }
                        }else{

                            $brandd="";

                        }

                        $def=StoresDefaultData::orderBy('id','desc')->first();
                        if($def->Cost_Price == 2){


                            $totCost=0;





                            $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                            $fifo =FifoQty::
                            where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('P_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                                if(empty($fifo)){

                                    $fifo =FifoQty::
                                    where('Store',$store)
                                        ->where('Product',$rows->Product)
                                        ->where('PPP_Code',$plow->Barcode)
                                        ->orderBy('Purchases_Date','asc')
                                        ->first();


                                    if(empty($fifo)){

                                        $fifo =FifoQty::
                                        where('Store',$store)
                                            ->where('Product',$rows->Product)
                                            ->where('PPPP_Code',$plow->Barcode)
                                            ->orderBy('Purchases_Date','asc')
                                            ->first();

                                    }

                                }

                            }

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= $rows->Qty){

                                            $totCost += $fifo->Cost_Price * $rows->Qty ;

                                        }else{

                                            $res=$rows->Qty - $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= $rows->Qty){

                                        $totCost += $fifo->Cost_Price * $rows->Qty ;

                                    }else{

                                        $res=$rows->Qty - $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }









                            $Cost=$totCost;
                            $CostS=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);





                        }else{



                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;



                        }

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }

                            $GropName=$rows->Product()->first()->Group()->first()->Name;


                        }else{
                            $ProoName=$rows->P_En_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$rows->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $GropName=$rows->Product()->first()->Group()->first()->NameEn;



                        }


                        $output .= '

       <tr>
             <td>
        '.$rows->P_Code.'
        </td>

        <td>
        '.$ProoName.'  ('.$ProoVName.')  ('.$ProoVVName.' )
        </td>

             <td>
        '.$GropName.'
        </td>

             <td>
        '.$brandd.'
        </td>

                <td>
        '.$rr->Unit()->first()->Name.'
        </td>

<td>'.$Cost.'</td>
<td>'.$CostS.'</td>

            <td>
        '.$AllQty.'
        </td>

                    <td>
        '.$rr->Price.'
        </td>

        <td>
        '.$rr->Price_Two.'
        </td>

        <td>
        '.$rr->Price_Three.'
        </td>



        </tr>


            ';
                    }


                    }

                }elseif($Brand == '' and $Group != ''){

                    if($rows->Product()->first()->Group == $Group){

       if($rows->Status == 0){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->id)->first();

                        $AllQty=ProductsQty::where('Product',$rows->Product)
                            ->where('P_Code',$rows->P_Code)
                            ->orWhere('PP_Code',$rows->P_Code)
                            ->orWhere('PPP_Code',$rows->P_Code)
                            ->orWhere('PPPP_Code',$rows->P_Code)
                            ->get()->sum('Qty');

                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();

                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;




                        if(!empty($rows->Product()->first()->Brand)){
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }
                        }else{

                            $brandd="";

                        }

                        $def=StoresDefaultData::orderBy('id','desc')->first();
                        if($def->Cost_Price == 2){


                            $totCost=0;





                            $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                            $fifo =FifoQty::
                            where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('P_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                                if(empty($fifo)){

                                    $fifo =FifoQty::
                                    where('Store',$store)
                                        ->where('Product',$rows->Product)
                                        ->where('PPP_Code',$plow->Barcode)
                                        ->orderBy('Purchases_Date','asc')
                                        ->first();


                                    if(empty($fifo)){

                                        $fifo =FifoQty::
                                        where('Store',$store)
                                            ->where('Product',$rows->Product)
                                            ->where('PPPP_Code',$plow->Barcode)
                                            ->orderBy('Purchases_Date','asc')
                                            ->first();

                                    }

                                }

                            }

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= $rows->Qty){

                                            $totCost += $fifo->Cost_Price * $rows->Qty ;

                                        }else{

                                            $res=$rows->Qty - $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= $rows->Qty){

                                        $totCost += $fifo->Cost_Price * $rows->Qty ;

                                    }else{

                                        $res=$rows->Qty - $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }









                            $Cost=$totCost;
                            $CostS=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);





                        }else{



                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;



                        }

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }

                            $GropName=$rows->Product()->first()->Group()->first()->Name;


                        }else{
                            $ProoName=$rows->P_En_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$rows->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $GropName=$rows->Product()->first()->Group()->first()->NameEn;



                        }


                        $output .= '

       <tr>
             <td>
        '.$rows->P_Code.'
        </td>

        <td>
        '.$ProoName.'  ('.$ProoVName.')  ('.$ProoVVName.' )
        </td>

             <td>
        '.$GropName.'
        </td>

             <td>
        '.$brandd.'
        </td>

                <td>
        '.$rr->Unit()->first()->Name.'
        </td>

<td>'.$Cost.'</td>
<td>'.$CostS.'</td>

            <td>
        '.$AllQty.'
        </td>

                    <td>
        '.$rr->Price.'
        </td>

        <td>
        '.$rr->Price_Two.'
        </td>

        <td>
        '.$rr->Price_Three.'
        </td>



        </tr>


            ';
                    }


                    }

                }elseif($Brand == '' and $Group == ''){


                    if($rows->Status == 0){

                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->id)->first();

                        $AllQty=ProductsQty::where('Product',$rows->Product)
                            ->where('P_Code',$rows->P_Code)
                            ->orWhere('PP_Code',$rows->P_Code)
                            ->orWhere('PPP_Code',$rows->P_Code)
                            ->orWhere('PPPP_Code',$rows->P_Code)
                            ->get()->sum('Qty');

                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();

                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;




                        if(!empty($rows->Product()->first()->Brand)){
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }
                        }else{

                            $brandd="";

                        }

                        $def=StoresDefaultData::orderBy('id','desc')->first();
                        if($def->Cost_Price == 2){


                            $totCost=0;





                            $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                            $fifo =FifoQty::
                            where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('P_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                                if(empty($fifo)){

                                    $fifo =FifoQty::
                                    where('Store',$store)
                                        ->where('Product',$rows->Product)
                                        ->where('PPP_Code',$plow->Barcode)
                                        ->orderBy('Purchases_Date','asc')
                                        ->first();


                                    if(empty($fifo)){

                                        $fifo =FifoQty::
                                        where('Store',$store)
                                            ->where('Product',$rows->Product)
                                            ->where('PPPP_Code',$plow->Barcode)
                                            ->orderBy('Purchases_Date','asc')
                                            ->first();

                                    }

                                }

                            }

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= $rows->Qty){

                                            $totCost += $fifo->Cost_Price * $rows->Qty ;

                                        }else{

                                            $res=$rows->Qty - $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= $rows->Qty){

                                        $totCost += $fifo->Cost_Price * $rows->Qty ;

                                    }else{

                                        $res=$rows->Qty - $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }









                            $Cost=$totCost;
                            $CostS=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);





                        }else{



                            $Cost = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ;

                            $CostS = $average->AverageCostGetUnit($rows->Product ,$rr->Barcode ,$store,$rr->Unit) ; ;



                        }

                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }

                            $GropName=$rows->Product()->first()->Group()->first()->Name;


                        }else{
                            $ProoName=$rows->P_En_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($row->V2)){
                                $ProoVVName=$rows->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $GropName=$rows->Product()->first()->Group()->first()->NameEn;



                        }


                        $output .= '

       <tr>
             <td>
        '.$rows->P_Code.'
        </td>

        <td>
        '.$ProoName.'  ('.$ProoVName.')  ('.$ProoVVName.' )
        </td>

             <td>
        '.$GropName.'
        </td>

             <td>
        '.$brandd.'
        </td>

                <td>
        '.$rr->Unit()->first()->Name.'
        </td>

<td>'.$Cost.'</td>
<td>'.$CostS.'</td>

            <td>
        '.$AllQty / $rr->Rate.'
        </td>

                    <td>
        '.$rr->Price.'
        </td>

        <td>
        '.$rr->Price_Two.'
        </td>

        <td>
        '.$rr->Price_Three.'
        </td>



        </tr>


            ';
                    }


                }


            }
            return   $output ;
        }

        return view('admin.Reports.ProductsFilterTwo',get_defined_vars());
    }


    //Daily Shifts
    public function DailyShiftsPage(){

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        return view('admin.Reports.DailyShifts',get_defined_vars());
    }

    function DailyShiftsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';


            $Date = $request->get('Date');
            $Safe = $request->get('Safe');

            if($Date != '' and $Safe != ''){


                if($Date != ''){

                    $DateName='where';
                    $DateC='Date';
                    $DateCC=$Date;

                }else{

                    $DateName='orderBy';
                    $DateC='id';
                    $DateCC='desc';

                }

                if($Safe != ''){

                    $SafeName='where';
                    $SafeC='Safe';
                    $SafeCC=$Safe;

                }else{

                    $SafeName='orderBy';
                    $SafeC='id';
                    $SafeCC='desc';

                }

                $Count=Shifts::orderBy('id','desc')
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->count();

                $Total_Cash=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Cash');

                $Total_Later=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Later');

                $Total_LaterNot=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Later_Not_Paid');

                $Total_LaterPaid=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Later_Paid');


                $Total_Visa=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Visa');

                $Total_Recipt=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Recipt');

                $Total_Payment=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Payment');

                $Total=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total');

                $Amount=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Amount');

                $Total_Installment=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Installment');

                $Total_Checks=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Checks');

                $Total_Delivery=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Delivery');

                $Total_Installment_Companies=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Total_Installment_Companies');

                $Total_App=Shifts::where('Close',1)
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get()->sum('Apps');


                $Shifts=Shifts::orderBy('id','desc')
                    ->$DateName($DateC,$DateCC)
                    ->$SafeName($SafeC,$SafeCC)
                    ->get();

                $dif= $Total - $Amount;




            }



            $output .= '
       <tr>

           <td>
     '.$Date.'
       </td>

        <td>
     '.$Count.'
       </td>

              <td>
     '.$Total_Cash.'
       </td>

               <td>
     '.$Total_Later.'
       </td>

               <td>
     '.$Total_LaterNot.'
       </td>

               <td>
     '.$Total_LaterPaid.'
       </td>

               <td>
     '.$Total_Installment.'
       </td>

               <td>
     '.$Total_Checks.'
       </td>

               <td>
     '.$Total_Delivery.'
       </td>

               <td>
     '.$Total_Installment_Companies.'
       </td>

               <td>
     '.$Total_Visa.'
       </td>

               <td>
     '.$Total_Recipt.'
       </td>

               <td>
     '.$Total_Payment.'
       </td>

               <td>
     '.$Total_App.'
       </td>

               <td>
     '.$Total.'
       </td>

               <td>
     '.$Amount.'
       </td>

     <td>
     '.$dif.'
       </td>

  <td>
     '.$Total.'
       </td>



               <td>
                <button  type="button" class="btn btn-block btn-outline-primary waves-effect waves-themed" data-toggle="modal" data-target="#default-example-modal-center-shiftDetails">
                                     '.trans("admin.Shift_Details").'
                                 </button>


             <div class="modal fade" id="default-example-modal-center-shiftDetails" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                              '.trans("admin.Shift_Details").'
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                    ';

            foreach($Shifts as $shift){
                $Diff=$shift->Total - $shift->Amount;

                if(app()->getLocale() == 'ar' ){
                    $StNamme=$shift->Store()->first()->Name;
                    $SafNamme=$shift->Safe()->first()->Name;
                }else{

                    $StNamme=$shift->Store()->first()->NameEn;
                    $SafNamme=$shift->Safe()->first()->NameEn;
                }

                $output .= '
                      <table class="table table-bordered">
                          <tbody>
                                   <tr>
                                  <td>      '.trans("admin.Code").'  </td>
                                  <td>'.$shift->Code.'</td>
                              </tr>
                                      <tr>
                                  <td>      '.trans("admin.Store").'  </td>
                                  <td>'.$StNamme.'</td>
                              </tr>

                                      <tr>
                                  <td>      '.trans("admin.Safe").'  </td>
                                  <td>'.$SafNamme.'</td>
                              </tr>
                              <tr>
                                  <td>      '.trans("admin.Total_Cash").'  </td>
                                  <td>'.$shift->Total_Cash.'</td>
                              </tr>
                              <tr>
                                    <td> '.trans("admin.Total_Later").' </td>
                                  <td>'.$shift->Total_Later.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Later_Not_Paid").' </td>
                                  <td>'.$shift->Total_Later_Not_Paid.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Later_Paid").' </td>
                                  <td>'.$shift->Total_Later_Paid.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Installment").' </td>
                                  <td>'.$shift->Total_Installment.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Checks").' </td>
                                  <td>'.$shift->Total_Checks.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Delivery").' </td>
                                  <td>'.$shift->Total_Delivery.'</td>
                              </tr>           <tr>
                                    <td> '.trans("admin.Total_Installment_Companies").' </td>
                                  <td>'.$shift->Total_Installment_Companies.'</td>
                              </tr>
                              <tr>
                                     <td> '.trans("admin.Total_Visa").' </td>
                                  <td>'.$shift->Total_Visa.'</td>
                              </tr>
                                     <tr>
                                     <td> '.trans("admin.Total_Recipt").'</td>
                                  <td>'.$shift->Total_Recipt.'</td>
                              </tr>

                                     <tr>
                                     <td> '.trans("admin.Total_Payment").'  </td>
                                  <td>'.$shift->Total_Payment.'</td>
                              </tr>
                                     <tr>
                                     <td> '.trans("admin.Apps").'  </td>
                                  <td>'.$shift->Apps.'</td>
                              </tr>
                              <tr>
                                  <td> '.trans("admin.Total").' </td>
                                  <td>'.$shift->Total.'</td>
                              </tr>
                                        <tr>
                                  <td> '.trans("admin.Amount").' </td>
                                  <td>'.$shift->Amount.'</td>
                              </tr>
                                             <tr>
                                  <td> '.trans("admin.Dif").' </td>
                                  <td>'.$Diff.'</td>
                              </tr>
                          </tbody>
                      </table>
         ';
            }
            $output .= '
                    </div>
                    <div class="modal-footer">

                    </div>
                </div>
            </div>
        </div>

                    </td>


                    <td>
   <button  type="button" class="btn btn-block btn-outline-primary waves-effect waves-themed" data-toggle="modal" data-target="#details">
                                     '.trans("admin.Details").'
                                 </button>

         <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content modal-xl">
                    <div class="modal-header">
                        <h4 class="modal-title">
                              '.trans("admin.Details").'
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                    ';

            foreach($Shifts as $shift){

                $RCash=0;
                $RCashh=0;
                $RLater=0;
                $RLaterr=0;


                $Sales =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','!=','Check')
                    ->where('Date', $Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get();

                $ReturnSales =ReturnSales::orderBy('id','asc')
                    ->where('Date', $Date)
                    ->get();


                $Cash =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Cash')
                    ->where('Date', $Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Total_Net');

                $discoo =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Cash')
                    ->where('Date', $Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Pay');


                $Later =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Later')
                    ->where('Date',$Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Pay');


                $CashVisa =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Cash_Visa')
                    ->where('Date',$Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Total_Net');


                $Visa =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Visa')
                    ->where('Date',$Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Total_Net');


                $Installment =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Installment')
                    ->where('Date', $Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('presenter');

                $TotApp =Sales::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Payment_Method','Apps')
                    ->where('Date', $Date)
                    ->where('Shift_Code', $shift->Code)
                    ->get()->sum('Total_Net');

                $TotSales=  $Cash + $Later +  $CashVisa+ $Installment + $Visa + $TotApp;

                $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Date', $Date)
                    ->where('Shift', $shift->Code)
                    ->get();

                $ReciptTot =ReciptVoucher::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Date',$Date)
                    ->where('Shift', $shift->Code)
                    ->get()->sum('Total_Creditor');


                $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Date', $Date)
                    ->where('Shift', $shift->Code)
                    ->get();

                $PaymentTot =PaymentVoucher::orderBy('id','asc')
                    ->where('Safe',$Safe)
                    ->where('Date', $Date)
                    ->where('Shift', $shift->Code)
                    ->get()->sum('Total_Debaitor');


                $DifRP= $ReciptTot - $PaymentTot ;
                $Amount = $DifRP +   $TotSales ;


                $Disc=$discoo;

                $output .= '
                      <table class="table table-bordered">
                          <tbody>
<tr>

       <td> '.trans('admin.Shift_Code').'</td>
       <td>'.$shift->Code.'</td>
          <td></td>
</tr>
      <tr class="Sales">
            <td>'.trans('admin.Sales').'</td>
        <td></td>
          <td></td>
    </tr>
        ';


                foreach($Sales as $sal){

                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Net;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                    }elseif($sal->Payment_Method == 'Cash_Visa'){
                        $bill=$sal->Total_Net;

                    }elseif($sal->Payment_Method == 'Visa'){
                        $bill=$sal->Total_Net;

                    }elseif($sal->Payment_Method == 'Installment'){
                        $bill=$sal->presenter;
                    }


                    $output .= '
      <tr class="Sales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$sal->Client()->first()->Name.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

                }

                foreach($ReturnSales as $sal){

                    if($sal->Sales()->first()->Safe == $Safe){
                        if($sal->Payment_Method == 'Cash'){

                            $RCashh +=$sal->Total_Return_Value;
                        }elseif($sal->Payment_Method == 'Later'){


                            $RLaterr +=$sal->Pay;
                        }

                    }

                }




                $All=$TotSales + $RCashh + $RLaterr;
                $output .= '
   <tr class="TotalSales">
     <td>     '.trans('admin.Total_Sales').' </td>
<td style="border: none;text-align: end;">'.$All.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                $output .= '
      <tr class="RSales">
            <td>  '.trans('admin.Return_Sales').'</td>
        <td></td>
          <td></td>
    </tr>
        ';

                foreach($ReturnSales as $sal){

                    if($sal->Sales()->first()->Safe == $Safe){
                        if($sal->Payment_Method == 'Cash'){

                            $bill=$sal->Total_Return_Value;
                            $RCash +=$sal->Total_Return_Value;
                        }elseif($sal->Payment_Method == 'Later'){

                            $bill=$sal->Pay;
                            $RLater +=$sal->Pay;
                        }


                        if(app()->getLocale() == 'ar' ){
                            $txNamme=$sal->Sales()->first()->Client()->first()->Name;
                        }else{

                            $txNamme=$sal->Sales()->first()->Client()->first()->NameEn;
                        }
                        $output .= '
      <tr class="RSales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

                    }
                }

                $RTotSales=  $RCash + $RLater ;


                $output .= '
   <tr class="RTotalSales">
     <td>      '.trans('admin.Total_return_Sales').' </td>
<td style="border: none;text-align: end;">'.$RTotSales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                $output .= '
   <tr class="TotalSales">
     <td>     '.trans('admin.Discount_Allow').' </td>
<td style="border: none;text-align: end;">'.$Disc.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

                $DISCOUNT=$TotSales - $Disc;

                $output .= '
   <tr class="NetSales">
     <td>      '.trans('admin.Net_Sales').' </td>
<td style="border: none;text-align: end;">'.$DISCOUNT.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                $output .= '
      <tr class="Recipt">
            <td>   '.trans('admin.Recipt_Vouchers').'</td>
        <td></td>
          <td></td>
    </tr>
        ';




                foreach($ReciptVoucher as $sal){
                    $VVVVV=ReciptVoucherDetails::where('RV_ID',$sal->id)->first();
                    if(app()->getLocale() == 'ar' ){
                        $txNamme=$VVVVV->Account()->first()->Name;
                    }else{

                        $txNamme=$VVVVV->Account()->first()->NameEn;
                    }
                    $output .= '
      <tr class="Recipt">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$sal->Total_Creditor.'</td>

    </tr>
        ';

                }

                $output .= '
   <tr class="TotalRecipt">
     <td>      '.trans('admin.Total_Recipt_Vouchers').'  </td>
<td style="border: none;text-align: end;">'.$ReciptTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                $output .= '
      <tr class="Payment">
            <td>    '.trans('admin.Payment_Vouchers').'</td>
        <td></td>
          <td></td>
    </tr>
        ';

                foreach($PaymentVoucher as $sal){

                    $VVVVV=PaymentVoucherDetails::where('PV_ID',$sal->id)->first();

                    if(app()->getLocale() == 'ar' ){
                        $txNamme=$VVVVV->Account()->first()->Name;
                    }else{

                        $txNamme=$VVVVV->Account()->first()->NameEn;
                    }
                    $output .= '
      <tr class="Payment">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$txNamme.'</td>
                                                    <td>'.$sal->Total_Debaitor.'</td>

    </tr>
        ';

                }


                $output .= '
   <tr class="TotalPayment">
     <td>        '.trans('admin.Total_Payment_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$PaymentTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

                $AM=   $Amount - $Disc ;

                $output .= '
   <tr class="TotalSafe">
     <td>      '.trans('admin.Safe_Value').' </td>
<td style="border: none;text-align: end;">'.$AM.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>

                          </tbody>
                      </table>
         ';
            }
            $output .= '
                    </div>
                    <div class="modal-footer">

                    </div>
                </div>
            </div>
        </div>

       </td>

        </tr>
            ';



            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //ExpensesReport
    public function ExpensesReportPage(){

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        return view('admin.Reports.ExpensesReport',get_defined_vars());
    }


    public function ExpensesReportFilterTwo(Request $request){

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();

        $from = $request->get('From');
        $to = $request->get('To');
        $safe = $request->get('Safe');

        $PaymentVoucher =PaymentVoucher::whereBetween('Date',[$from,$to])

            ->where('Safe',$safe)
            ->where('Edit',null)
            ->where('Delete',null)
            ->paginate(10);



        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {
            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            foreach($PaymentVoucher as $pay){
                $VVVVV=PaymentVoucherDetails::where('PV_ID',$pay->id)->first();
                //   if($VVVVV->Account()->first()->Parent == 55){}

                if(app()->getLocale() == 'ar' ){

                    if(!empty($VVVVV->Account)){
                        $xName=$VVVVV->Account()->first()->Name;
                    }else{
                        $xName='';
                    }


                }else{

                    if(!empty($VVVVV->Account)){
                        $xName=$VVVVV->Account()->first()->NameEn;
                    }else{
                        $xName='';
                    }


                }


                $output .= '
      <tr class="Payment">
                                                  <td>'.$pay->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$pay->Total_Debaitor.'
                                                <input type="hidden" class="tot" value="'.$pay->Total_Debaitor.'">
                                                    </td>

    </tr>
        ';


            }



            return   $output ;
        }

        return view('admin.Reports.ExpensesReportFilterTwo',get_defined_vars());
    }


    //DailyProductsPage
    public function DailyProductsPage(){

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess = Employess::type()->get();

        return view('admin.Reports.DailyProducts',get_defined_vars());
    }

    function DailyProductsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';

            $from = $request->get('From');
            $to = $request->get('To');
            $Safe = $request->get('Safe');
            $Dele = $request->get('Dele');
$array=[];

            if($from != '' and $to != ''){

$shift=Shifts::whereBetween('Date',[$from,$to])->latest('id')->get('Code');
foreach($shift as $sh){

    array_push($array,[
        $sh->Code,
    ]);
}


if(!empty($shift)) {
    $Sales = Sales::latest('id')
        ->where('Sale_Type', 'POS')
        ->where('Status', 1)
        ->when(!empty($array), function ($query) use ($array) {
            return $query->whereIn('Shift_Code', $array);

        })
        ->when(!empty($Safe), function ($query) use ($Safe) {
            return $query->where('Safe', $Safe);

        })
        ->when(!empty($Dele), function ($query) use ($Dele) {
            return $query->where('Delegate', $Dele);

        })
        ->get();
}

            }

            foreach($Sales as $sal){
                $Prods=ProductSales::where('Sales',$sal->id)->get();

                $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Date").' </th>
                                                    <th>'.trans("admin.Amount").' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$sal->Code.'
       </td>

               <td>
     '.$sal->Date.'
       </td>

       <td>
     '.$sal->Total_Net.'
       </td>

        </tr>

                <tr style="background-color:darkblue;color:white">
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Notes").' </th>
                                    </tr>

            ';

                foreach($Prods as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $ProoName=$pro->P_Ar_Name;
                        $UniiName=$pro->Unit()->first()->Name;

                    }else{
                        $ProoName=$pro->P_En_Name;
                        $UniiName=$pro->Unit()->first()->NameEn;

                    }


                    $output .= '

        <tr>

        <td>
     '.$pro->Code.'
       </td>

             <td>
     '.$ProoName.'
       </td>
                  <td>
     '.$UniiName.'
       </td>
             <td>
     '.$pro->Qty.'
       </td>

                  <td>
     '.$pro->Price.'
       </td>

                  <td>
     '.$pro->Total.'
       </td>

         <td>

       </td>

        </tr>



            ';


                }



            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //Employee Commission Discounts
    public function EmployeeCommissionDiscountsPage(){
        if(auth()->guard('admin')->user()->emp != 0){
            $Employess=Employess::type()->where('id',auth()->guard('admin')->user()->emp)->get();
        }else{
            $Employess=Employess::type()->get();
        }

        return view('admin.Reports.EmployeeCommissionDiscounts',get_defined_vars());
    }

    function EmpCommisionFilter(Request $request,Average  $average)
    {

        if($request->ajax())
        {
            $output = '';
            $Emp = $request->get('Emp');
            $Date = $request->get('Date');


            if($Emp != ''){

                $EXX=ExchangeCommissions::where('Emp',$Emp)->get()->sum('Amount');
                $returns=ReturnMaintainceBill::where('Eng',$Emp)->get();

                $co=0;
                $s=0;
                $e=0;
                $sR=0;
                $totalcost=0;
                $ReturnCount=0;

                foreach($returns as $ret){

                    $i= $ret->Cost_Precent / 100 ;
                    $ii= $i *  $ret->Total_Cost ;
                    $co += $ii ;

                }

                $sales=Sales::
                where('Status',1)
                    ->where('Delegate',$Emp)
                    ->where('Delete',0)
                    ->where('Edit',0)
                    ->get()->sum('Total_Net');

                $salesCount=Sales::
                where('Status',1)
                    ->where('Delete',0)
                    ->where('Edit',0)
                    ->where('Delegate',$Emp)
                    ->count();

                $ReturnCount=ReturnSales::whereRelation('Sales',$Emp)->count();


                $Executors=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereRelation('Sales','Executor',$Emp)->get()->sum('Total_Net');

                $totalcost=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereRelation('Sales','Executor',$Emp)->get()->sum('TotCostNew');
                $Name=Employess::find($Emp);

                $diff= $Executors   - $totalcost ;

                $Ratios=EmpRatio::where('Emp',$Emp)->get();

                $Recipts=ReciptVoucher::where('Delete',null)->where('Edit',null)->where('Status',1)->where('Collector',$Emp)->get()->sum('Total_Creditor');



                foreach($Ratios as $r){

                    if($r->Typee == 2){

                        if($r->From  <=  $diff  and $r->To  >=  $diff ){

                            $z=$r->Rate  / 100 ;
                            $zz= $z *  $diff ;
                            $e += $zz;

                        }else{

                            $e+=0;

                        }


                    }

                    if($r->Typee == 3){

                        if($r->From  <=  $Recipts  and $r->To  >=  $Recipts ){


                            $xR=$r->Rate  / 100 ;
                            $xxR= $xR *  $Recipts ;
                            $sR+=$xxR;

                        }else{

                            $sR+=0;

                        }


                    }


                }



                $result = ( $s + $e )  -  $co ;

                if(app()->getLocale() == 'ar' ){
                    $neame=$Name->Name;


                }else{

                    $neame=$Name->NameEn;
                }


                $output .= '
       <tr>
        <td>
     '.$neame.'
       </td>
        <td>
     '.$Name->Emp_Type.'
       </td>
     <td>
     '.number_format((float)abs($s), 2, '.', '').'
       </td>
       <td>
     '.number_format((float)abs($e), 2, '.', '').'
       </td>

         <td>
     '.number_format((float)abs($EXX), 2, '.', '').'
       </td>
    <td>
     '.number_format((float)abs($result), 2, '.', '').'
       </td>

           <td>
     '.number_format((float)abs($salesCount), 2, '.', '').'
       </td>
           <td>
     '.number_format((float)abs($ReturnCount), 2, '.', '').'
       </td>
            <td>
     '.number_format((float)abs($sR), 2, '.', '').'
       </td>

           </tr>

            ';
            }else{

                $employes=Employess::where("EmpSort",1)->where('Active',1)->get();

                foreach($employes as $emp){

                    $EXX=ExchangeCommissions::where('Emp',$emp->id)->get()->sum('Amount');
                    $returns=ReturnMaintainceBill::where('Eng',$emp->id)->get();

                    $co=0;
                    $s=0;
                    $e=0;
                    $totalcost=0;
                    $ReturnCount=0;

                    foreach($returns as $ret){

                        $i= $ret->Cost_Precent / 100 ;
                        $ii= $i *  $ret->Total_Cost ;
                        $co += $ii ;

                    }

                    $sales=Sales::
                    where('Status',1)
                        ->where('Delegate',$emp->id)
                        ->get()->sum('Total_Price');

                    $salesCount=Sales::
                    where('Status',1)
                        ->where('Delegate',$emp->id)
                        ->count();

                    $ReturnSales=ReturnSales::all();

                    foreach($ReturnSales as $RS){
                        if($RS->Sales()->first()->Delegate == $emp->id){

                            $ReturnCount +=1;

                        }
                    }

                    $products=ProductSales::where('Executor',$emp->id)->get();
                    $Executors=ProductSales::where('Executor',$emp->id)->get()->sum('Total');
                    $Maintaince=ReciptMaintaince::where('Status',8)->where('Eng',$emp->id)->get()->sum('Total');
                    $MaintainceCount=ReciptMaintaince::where('Status',8)->where('Eng',$emp->id)->count();
                    $ReturnMaintainceCount=ReturnMaintainceBill::where('Eng',$emp->id)->count();
                    $MaintaincProducts=ProductMaintaincBill::all();

                    $Name=Employess::find($emp->id);
                    foreach($products as $pro){

                        $plow=ProductUnits::where('Product',$pro->Product)->where('Rate',1)->first();
                        $unit=ProductUnits::where('Product',$pro->Product)->where('Def',1)->first();




                        $def=StoresDefaultData::orderBy('id','desc')->first();
                        if($def->Cost_Price == 2){


                            $totCost=0;





                            $rr = ProductUnits::where("Unit",$plow->Unit)->where('Product',$pro->Product)->first();


                            $fifo =FifoQty::
                            where('Store',$pro->Store)
                                ->where('Product',$pro->Product)
                                ->where('P_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();

                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$pro->Store)
                                    ->where('Product',$pro->Product)
                                    ->where('PP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                                if(empty($fifo)){

                                    $fifo =FifoQty::
                                    where('Store',$pro->Store)
                                        ->where('Product',$pro->Product)
                                        ->where('PPP_Code',$plow->Barcode)
                                        ->orderBy('Purchases_Date','asc')
                                        ->first();


                                    if(empty($fifo)){

                                        $fifo =FifoQty::
                                        where('Store',$pro->Store)
                                            ->where('Product',$pro->Product)
                                            ->where('PPPP_Code',$plow->Barcode)
                                            ->orderBy('Purchases_Date','asc')
                                            ->first();

                                    }

                                }

                            }

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= $pro->Qty){

                                            $totCost += $fifo->Cost_Price * $pro->Qty ;

                                        }else{

                                            $res=$pro->Qty - $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= $pro->Qty){

                                        $totCost += $fifo->Cost_Price * $pro->Qty ;

                                    }else{

                                        $res=$pro->Qty - $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }



                            $CostS=$average->AverageCostGet($pro->Product,$plow->Barcode,$pro->Store);

                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){




                                $totalcost=$totCost;








                            }else{





                                $CostS=$average->AverageCostGet($pro->Product,$plow->Barcode,$pro->Store);

                                if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){



                                    if($CostS != 0){
                                        $Average = $CostS * $unit->Rate ;
                                        $totalcost += ($Average * $pro->Qty) ;
                                    }else{

                                        $totalcost += ($CostS *  $unit->Rate) * $pro->Qty;
                                    }

                                }else{

                                    $totalcost +=0;
                                }







                            }








                            $Emppp=Employess::find($Emp);

                            if($Emppp->Emp_Type == 'Engineer'){
                                $diff= $sales  - $totalcost ;
                            }else{

                                $diff= $Executors  ;
                            }

                            $Ratios=EmpRatio::where('Emp',$Emp)->get();

                            foreach($Ratios as $r){

                                if($r->Typee == 1){

                                    if($r->From  <=  $sales  and $r->To  >=  $sales ){

                                        $x=$r->Rate  / 100 ;
                                        $xx= $x *  $sales ;
                                        $s+=$xx;

                                    }else{

                                        $s+=0;

                                    }


                                }


                                if($r->Typee == 2){

                                    if($r->From  <=  $diff  and $r->To  >=  $diff ){

                                        $z=$r->Rate  / 100 ;
                                        $zz= $z *  $diff ;
                                        $e += $zz;

                                    }else{

                                        $e+=0;

                                    }


                                }


                            }




                        }



                        $Emppp=Employess::find($emp->id);

                        if($Emppp->Emp_Type == 'Engineer'){
                            $diff= $sales  - $totalcost ;
                        }else{

                            $diff= $Executors  ;
                        }

                        $Ratios=EmpRatio::where('Emp',$Emp)->get();

                        foreach($Ratios as $r){

                            if($r->Typee == 1){

                                if($r->From  <=  $sales  and $r->To  >=  $sales ){

                                    $x=$r->Rate  / 100 ;
                                    $xx= $x *  $sales ;
                                    $s+=$xx;

                                }else{

                                    $s+=0;

                                }


                            }


                            if($r->Typee == 2){

                                if($r->From  <=  $diff  and $r->To  >=  $diff ){

                                    $z=$r->Rate  / 100 ;
                                    $zz= $z *  $diff ;
                                    $e += $zz;

                                }else{

                                    $e+=0;

                                }


                            }


                        }




                    }

                    foreach($MaintaincProducts as $pro){
                        if($pro->Maintaince()->first()->Eng == $emp->id){
                            if($pro->Maintaince()->first()->Status == 8){
                                $plow=ProductUnits::where('Product',$pro->Product)->where('Rate',1)->first();
                                $unit=ProductUnits::where('Product',$pro->Product)->where('Def',1)->first();

                                $CostS=$average->AverageCostGet($pro->Product,$plow->Barcode,$pro->Store);
                                if(!empty($purchs) or !empty($purchsStart) or !empty($OUTCOME) or !empty($storesTransfer)){

                                    if($CostS != 0){
                                        $Average =$CostS * $unit->Rate ;
                                        $totalcost += $Average * $pro->Qty ;
                                    }else{

                                        $totalcost += ($CostS * $unit->Rate) * $pro->Qty;
                                    }

                                }else{

                                    $totalcost +=0;
                                }

                            }
                        }

                    }

                    $diff= ($Executors + $Maintaince)  - $totalcost ;

                    $Ratios=EmpRatio::where('Emp',$emp->id)->get();

                    foreach($Ratios as $r){

                        if($r->Typee == 2){

                            if($r->From  <=  $diff  and $r->To  >=  $diff ){

                                $z=$r->Rate  / 100 ;
                                $zz= $z *  $diff ;
                                $e += $zz;

                            }else{

                                $e+=0;

                            }


                        }


                    }

                    $result = ( $s + $e )  -  $co ;

                    if(app()->getLocale() == 'ar' ){
                        $neame=$Name->Name;


                    }else{

                        $neame=$Name->NameEn;
                    }

                    $output .= '
       <tr>
        <td>
     '.$neame.'
       </td>
        <td>
     '.$Name->Emp_Type.'
       </td>
     <td>
     '.number_format((float)abs($s), 2, '.', '').'
       </td>
       <td>
     '.number_format((float)abs($e), 2, '.', '').'
       </td>
              <td>
     '.number_format((float)abs($co), 2, '.', '').'
       </td>
         <td>
     '.number_format((float)abs($EXX), 2, '.', '').'
       </td>
    <td>
     '.number_format((float)abs($result), 2, '.', '').'
       </td>

           <td>
     '.number_format((float)abs($salesCount), 2, '.', '').'
       </td>
           <td>
     '.number_format((float)abs($ReturnCount), 2, '.', '').'
       </td>

           <td>
     '.number_format((float)abs($MaintainceCount), 2, '.', '').'
       </td>

           <td>
     '.number_format((float)abs($ReturnMaintainceCount), 2, '.', '').'
       </td>




           </tr>

            ';

                }

            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //VendorPricesReport
    public function VendorPricesReportPage(){
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->get();

        return view('admin.Reports.VendorPricesReport',get_defined_vars());
    }

    function VendorPricesReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $Date = $request->get('Date');
            $Vendor = $request->get('Vendor');

            $Prods=ProductsPurchases::

                when(!empty($Date), function ($query) use ($Date) {
                    return $query->where('Date', $Date);

                })
                ->when(!empty($Vendor), function ($query) use ($Vendor) {
                    return $query->whereIn('Vendor', $Vendor);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('Product_Code','ILIKE', "%{$search}%");

                })

                ->whereRelation('Purchase','Edit',0)
                ->whereRelation('Purchase','Delete',0)
                ->get();


            $total_row = $Prods->count();
            if($total_row > 0)
            {

                if($Vendor != ''){
                    foreach($Prods as $rows){


                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;

                                if(!empty($rows->V1)){
                                    $ProoVName=$rows->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($rows->V2)){
                                    $ProoVVName=$rows->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$rows->Vendor()->first()->Name;


                            }else{
                                $ProoName=$rows->P_En_Name;

                                if(!empty($rows->V1)){
                                    $ProoVName=$rows->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($rows->V2)){
                                    $ProoVVName=$rows->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }


                                $UniiName=$rows->Vendor()->first()->NameEn;



                            }


                            $output .= '

       <tr>

       <td>
      '.$rows->Date.'
       </td>

        <td>
      '.$rows->Product_Code.'
       </td>

          <td>
      '.$ProoName.' ('.$ProoVName.')   ('.$ProoVVName.')
       </td>

       <td>
      '.$UniiName.'
       </td>

      <td>
      '.$rows->Price.'
       </td>

        </tr>
            ';



                    }

                }else{

                    foreach($Prods as $rows){



                        if(app()->getLocale() == 'ar' ){
                            $ProoName=$rows->P_Ar_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->Name;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->Name;
                            }else{
                                $ProoVVName='';
                            }
                            $UniiName=$rows->Vendor()->first()->Name;


                        }else{
                            $ProoName=$rows->P_En_Name;

                            if(!empty($rows->V1)){
                                $ProoVName=$rows->V1()->first()->NameEn;
                            }else{
                                $ProoVName='';
                            }


                            if(!empty($rows->V2)){
                                $ProoVVName=$rows->V2()->first()->NameEn;
                            }else{
                                $ProoVVName='';
                            }


                            $UniiName=$rows->Vendor()->first()->NameEn;



                        }


                        $output .= '

       <tr>

       <td>
      '.$rows->Date.'
       </td>

        <td>
      '.$rows->Product_Code.'
       </td>

          <td>
      '.$ProoName.' ('.$ProoVName.')   ('.$ProoVVName.')
       </td>

       <td>
      '.$UniiName.'
       </td>

      <td>
      '.$rows->Price.'
       </td>

        </tr>
            ';

                    }

                }



            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //GroupsSalesPage
    public function GroupsSalesPage(){

        if(auth()->guard('admin')->user()->vend != 0){

            if(!empty(auth()->guard('admin')->user()->vend()->first()->Pro_Group)){
                $Groups=ItemsGroups::where('id',auth()->guard('admin')->user()->vend()->first()->Pro_Group)->get();
            }else{
                $Groups=ItemsGroups::all();
            }


        }else{


            $Groups=ItemsGroups::all();
        }
        return view('admin.Reports.GroupsSales',get_defined_vars());
    }

    function GroupsSalesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Group = $request->get('Group');

            if($Group != ''){

                $Group_Name=ItemsGroups::find($Group);
                $Sales=ProductSales::
                whereRelation('Sales', function ($query) use ($From,$To) {
                    return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                })
                    ->whereRelation('Product','Group',$Group)
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->distinct(['Product_Code'])
                    ->get();


                $qty=ProductSales::
                whereRelation('Product','Group',$Group)
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->whereRelation('Sales', function ($query) use ($From,$To) {
                        return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                    })
                    ->get()->sum('Qty');

                $tot=ProductSales::
                whereRelation('Product','Group',$Group)
                    ->whereRelation('Sales', function ($query) use ($From,$To) {
                        return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');


                if(app()->getLocale() == 'ar' ){
                    $xName=$Group_Name->Name;

                }else{
                    $xName=$Group_Name->Name;

                }
                $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Group").' </th>
                                                    <th>'.trans("admin.Total_Qty").' </th>
                                                    <th>'.trans("admin.Total_Price").' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$xName.'
       </td>

               <td>
     '.$qty.'
       </td>

       <td>
     '.$tot. '
       </td>

        </tr>

                <tr style="background-color:#014b2a;color:white">
                                                    <th>' .trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';


                foreach($Sales as $sal){


                    $Newqty=ProductSales::
                    where('Product',$sal->Product)
                        ->where('Product_Code',$sal->Product_Code)
                        ->whereRelation('Sales', function ($query) use ($From,$To) {
                            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                        })
                        ->whereRelation('Sales','Edit',0)
                        ->whereRelation('Sales','Delete',0)
                        ->get()->sum('Qty');

                    $Newtot=ProductSales::
                    where('Product',$sal->Product)
                        ->where('Product_Code',$sal->Product_Code)
                        ->whereRelation('Sales', function ($query) use ($From,$To) {
                            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                        })
                        ->whereRelation('Sales','Edit',0)
                        ->whereRelation('Sales','Delete',0)
                        ->get()->sum('Total_Net');

                    $output .= ' <tr>

        <td>
     '.$sal->Product_Code.'
       </td>

               <td>
     '.$sal->P_Ar_Name.' ('.$sal->V_Name.') ('.$sal->VV_Name.')
       </td>

        <td>
     '.$sal->Unit()->first()->Name.'
       </td>
             <td>
     '.$Newqty.'
       </td>
             <td>
     '.$sal->Price.'
       </td>
             <td>
     '.$Newtot.'
       </td>


        </tr>
  ';
                }








            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //BrandsSales
    public function BrandsSales(){

        if(auth()->guard('admin')->user()->vend != 0){

            if(!empty(auth()->guard('admin')->user()->vend()->first()->Brand)){
                $Brands=Brands::where('id',auth()->guard('admin')->user()->vend()->first()->Brand)->get();
            }else{
                $Brands=Brands::all();
            }


        }else{


            $Brands=Brands::all();
        }
        return view('admin.Reports.BrandsSales',get_defined_vars());
    }

    function BrandsSalesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Brand = $request->get('Brand');

            if($Brand != ''){

                $Group_Name=Brands::find($Brand);
                $Sales=ProductSales::

                whereRelation('Sales', function ($query) use ($From,$To) {
                    return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                })

                    ->whereRelation('Product','Brand',$Brand)
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->distinct(['Product_Code'])
                    ->get();


                $qty=ProductSales::
                whereRelation('Product','Brand',$Brand)

                    ->whereRelation('Sales', function ($query) use ($From,$To) {
                        return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                    })
                    ->get()->sum('Qty');

                $tot=ProductSales::
                whereRelation('Product','Brand',$Brand)
                    ->whereRelation('Sales', function ($query) use ($From,$To) {
                        return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');


                if(app()->getLocale() == 'ar' ){
                    $xName=$Group_Name->Name;

                }else{
                    $xName=$Group_Name->Name;

                }
                $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Brand").' </th>
                                                    <th>'.trans("admin.Total_Qty").' </th>
                                                    <th>'.trans("admin.Total_Price").' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$xName.'
       </td>

               <td>
     '.$qty.'
       </td>

       <td>
     '.$tot. '
       </td>

        </tr>

                <tr style="background-color:#014b2a;color:white">
                                                    <th>' .trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';


                foreach($Sales as $sal){


                    $Newqty=ProductSales::
                    where('Product',$sal->Product)
                        ->where('Product_Code',$sal->Product_Code)
                        ->whereRelation('Sales', function ($query) use ($From,$To) {
                            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                        })
                        ->whereRelation('Sales','Edit',0)
                        ->whereRelation('Sales','Delete',0)
                        ->get()->sum('Qty');

                    $Newtot=ProductSales::
                    where('Product',$sal->Product)
                        ->where('Product_Code',$sal->Product_Code)
                        ->whereRelation('Sales', function ($query) use ($From,$To) {
                            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

                        })
                        ->whereRelation('Sales','Edit',0)
                        ->whereRelation('Sales','Delete',0)
                        ->get()->sum('Total_Net');

                    $output .= '<tr>

        <td>
     '.$sal->Product_Code.'
       </td>

               <td>
     '.$sal->P_Ar_Name.' ('.$sal->V_Name.') ('.$sal->VV_Name.')
       </td>

        <td>
     '.$sal->Unit()->first()->Name.'
       </td>
             <td>
     '.$Newqty.'
       </td>
             <td>
     '.$sal->Price.'
       </td>
             <td>
     '.$Newtot.'
       </td>


        </tr>
  ';
                }







            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }



    //Collection_Delegates
    public function Collection_DelegatesPage(Request $request){


        if(auth()->guard('admin')->user()->emp == 0){
            $Vendors=Employess::
            whereIn('Emp_Type',['Buyer','Saller'])
                ->where("EmpSort",1)->where('Active',1)
                ->get();

        }else{

            $Vendors=Employess::
            where('id',auth()->guard('admin')->user()->emp)
                ->get();

        }


        return view('admin.Reports.Collection_Delegates',get_defined_vars());
    }

    function FilterCollection_Delegates(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('From');
            $to = $request->get('To');
            $Delegate = $request->get('Delegate');

            $DBBEFORE=0;
            $CRBEFORE=0;
            $DBTOTAL=0;
            $CRTOTAL=0;
            $DBBALANCE=0;
            $CRBALANCE=0;
            if($Delegate != ''){
                $Custs=Customers::where('Responsible',$Delegate)->get();
            }


            $total_row = $Custs->count();
            if($total_row > 0)
            {

                foreach($Custs as $Cu){


                    $DebBef =0;


                    $CredBef =0;

                    $TotalDeb =GeneralDaily::where('Account',$Cu->Account)
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$Cu->Account)
                        ->get()->sum('Creditor_Coin');

                    $lq=GeneralDaily::where('Account',$Cu->Account)
                        ->latest('id')->first();

                    $lb =Sales::where('Client',$Cu->Account)->where('Edit',0)->where('Delete',0)
                        ->latest('id')->first();

                    if(!empty($lq)){
                        $LastQeed=$lq->Date;
                    }else{
                        $LastQeed=0;
                    }
                    if(!empty($lb)){
                        $LastBill=$lb->Date;
                    }else{
                        $LastBill=0;
                    }

                    $account=$Cu->Account;
                    $last =ReciptVoucherDetails::whereRelation('RV_ID', function ($query) use ($Delegate) {

                        return $query->where('Collector',$Delegate);
                    })


                        ->when(!empty($account), function ($query) use ($account)  {
                            return $query->where('Account',$account);

                        })

                        ->latest('id')->first();

                    if(!empty($last)){
                        $LastRecipt=$last->RV_ID()->first()->Date;
                    }else{
                        $LastRecipt=0;
                    }


                    $x= $TotalDeb  - $TotalCred  ;


                    if($x < 0){

                        $y=0;
                        $z=abs($x);
                    }else{

                        $y=$x;
                        $z=0;

                    }

                    $DBBEFORE +=$DebBef;
                    $CRBEFORE +=$CredBef;
                    $DBTOTAL +=$TotalDeb;
                    $CRTOTAL +=$TotalCred;
                    $DBBALANCE +=$y;
                    $CRBALANCE +=$z;

                    if($y != 0){
                        if(app()->getLocale() == 'ar' ){
                            $xName=$Cu->Account()->first()->Name;

                        }else{
                            $xName=$Cu->Account()->first()->NameEn;

                        }
                        $output .= '
        <tr>

                                               <td>'.$xName.'</td>
                                                    <td class="DBBALANCE">'.$y.'</td>
                                                    <td class="CRBALANCE">'.$z.'</td>
                                                    <td>'.$LastQeed.'</td>
                                                    <td>'.$LastBill.'</td>
                                                    <td>'.$LastRecipt.'</td>
                                                </tr>

        ';


                    }



                }
            }
            else
            {
                $output = '
       <tr>
        <td align="center" colspan="5"> '.trans('admin.No_Data_Find').' </td>
       </tr>
       ';
            }
            $data = array(
                'table_data'  => $output,
                'TDB'  => $DBBEFORE,
                'TD'  => $DBTOTAL,
                'TDBL'  => $DBBALANCE,
                'TCB'  => $CRBEFORE,
                'TC'  => $CRTOTAL,
                'TCBL'  => $CRBALANCE,
            );
            echo json_encode($data);
        }
    }

    //Sales_Delegates
    public function Sales_DelegatesPage(){


        if(auth()->guard('admin')->user()->emp == 0){
            $Vendors=Employess::
            whereIn('Emp_Type',['Buyer','Saller'])
                ->type()
                ->get();

        }else{

            $Vendors=Employess::
            where('id',auth()->guard('admin')->user()->emp)
                ->type()
                ->get();

        }



        return view('admin.Reports.Sales_Delegates',get_defined_vars());
    }

    function FilterSales_Delegates(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $from = $request->get('From');
            $to = $request->get('To');
            $Delegate = $request->get('Delegate');

            if($from != null and $to != null and $Delegate != ''){


                $BillNum=Sales::orderBy('id','desc')
                    ->where('Status',1)
                    ->where('Delegate',$Delegate)
                    ->whereBetween('Date',[$from,$to])
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->count();

                $total=Sales::orderBy('id','desc')
                    ->where('Status',1)
                    ->where('Delegate',$Delegate)
                    ->whereBetween('Date',[$from,$to])
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get()->sum('Total_Net');

                $totalCash=Sales::orderBy('id','desc')
                    ->where('Status',1)
                    ->where('Payment_Method','Cash')
                    ->where('Delegate',$Delegate)
                    ->whereBetween('Date',[$from,$to])
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get()->sum('Total_Net');

                $totalLater=Sales::orderBy('id','desc')
                    ->where('Status',1)
                    ->where('Payment_Method','Later')
                    ->where('Delegate',$Delegate)
                    ->whereBetween('Date',[$from,$to])
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get()->sum('Total_Net');

                $totalLaterCollect=Sales::orderBy('id','desc')
                    ->where('Status',1)
                    ->where('Payment_Method','Later')
                    ->where('Later_Collection',1)
                    ->where('Delegate',$Delegate)
                    ->whereBetween('Date',[$from,$to])
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get()->sum('Total_Net');


            }


            $total_row = 1;
            if($total_row > 0)
            {


                $output .= '
        <tr>


                                                    <td class="DBBEFORE">'.$BillNum.'</td>
                                                    <td class="CRBEFORE">'.$total.'</td>
                                                    <td class="DBTOTAL">'.$totalCash.'</td>
                                                    <td class="CRTOTAL">'.$totalLater.'</td>
                                                    <td class="DBBALANCE">'.$totalLaterCollect.'</td>

                                                </tr>

        ';


            }
            else
            {
                $output = '
       <tr>
        <td align="center" colspan="5">'.trans('admin.No_Data_Find').'</td>
       </tr>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //ClientSalesPage
    public function ClientSalesPage(){
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $Groups=ItemsGroups::all();
        if($Def->V_and_C == 0){
            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->get();
        }elseif($Def->V_and_C == 1){


            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->orWhere('Parent',37)
                ->get();


        }

        return view('admin.Reports.ClientSales',get_defined_vars());
    }

    function ClientSalesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            $Group = $request->get('Group');

            if($Client != '' or $Group != ''){

                $qty=ProductSales::

                    when(!empty($From), function ($query) use ($From,$To) {
                        return $query->whereBetween('Date',[$From,$To]);

                    })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Client',$Client);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
->whereRelation('Sales','Edit',0)
->whereRelation('Sales','Delete',0)
               ->get()->sum('Qty');
                $tot=ProductSales::

                    when(!empty($From), function ($query) use ($From,$To) {
                        return $query->whereBetween('Date',[$From,$To]);

                    })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Client',$Client);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
               ->get()->sum('Total_Net');

                $Sales=ProductSales::

                    when(!empty($From), function ($query) use ($From,$To) {
                        return $query->whereBetween('Date',[$From,$To]);

                    })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Client',$Client);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
               ->get();


                        $grb=ItemsGroups::find($Group);
                $cust=AcccountingManual::find($Client);

                if(!empty($grb)){
                    if(app()->getLocale() == 'ar' ){
                        $xName=$grb->Name;

                    }else{
                        $xName=$grb->NameEn;

                    }
                }else{

                    $xName='';

                }

                if(!empty($cust)){
                    if(app()->getLocale() == 'ar' ){
                        $cName=$cust->Name;

                    }else{
                        $cName=$cust->NameEn;

                    }
                }else{

                    $cName='';

                }


                            $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Client").' </th>
                                                    <th>'.trans("admin.Total_Qty").' </th>
                                                    <th>'.trans("admin.Total_Price").' </th>
                                                    <th>'.trans("admin.Group").' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$cName.'
       </td>

               <td>
     '.$qty.'
       </td>

       <td>
     '.$tot.'
       </td>

     <td>
     '.$xName. '
       </td>
        </tr>

                <tr style="background-color:#014b2a;color:#b99400">
                                                    <th>' .trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';




                            foreach($Sales as $sal){

                                    $output .= '            <tr>


        <td>
     '.$sal->Product_Code.'
       </td>
               <td>
     '.$sal->P_Ar_Name.' ('.$sal->VName.') ('.$sal->VVName.')
       </td>

             <td>
     '.$sal->Qty.'
       </td>
             <td>
     '.$sal->Price.'
       </td>
             <td>
     '.$sal->Total_Net.'
       </td>


        </tr>
  ';

                            }

            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //VendorPurchasesPage
    public function VendorPurchasesPage(){

        $Def=PurchasesDefaultData::orderBy('id','desc')->first();

        if($Def->V_and_C == 0){
            $Vendors = AcccountingManual::
            where('Type',1)
                ->where('Parent',37)
                ->get();
        }elseif($Def->V_and_C == 1){

            $Vendors = AcccountingManual::
            where('Type',1)
                ->where('Parent',37)
                ->orWhere('Parent',24)
                ->get();


        }


        return view('admin.Reports.VendorPurchases',get_defined_vars());
    }

    function VendorPurchasesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            VendorFilter::truncate();

            if($Client != ''){

                $qty=ProductsPurchases::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Purchase','Vendor',$Client);

                    })

                    ->whereRelation('Purchase','Edit',0)
                    ->whereRelation('Purchase','Delete',0)
                    ->get()->sum('Qty');
                $tot=ProductsPurchases::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Purchase','Vendor',$Client);

                    })

                    ->whereRelation('Purchase','Edit',0)
                    ->whereRelation('Purchase','Delete',0)
                    ->get()->sum('Total_Net');

                $Sales=ProductsPurchases::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Purchase','Vendor',$Client);

                    })

                    ->whereRelation('Purchase','Edit',0)
                    ->whereRelation('Purchase','Delete',0)
                    ->get();



                $cust=AcccountingManual::find($Client);



                if(!empty($cust)){
                    if(app()->getLocale() == 'ar' ){
                        $cName=$cust->Name;

                    }else{
                        $cName=$cust->NameEn;

                    }
                }else{

                    $cName='';

                }


                $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Vendor").' </th>
                                                    <th>'.trans("admin.Total_Qty").' </th>
                                                    <th>'.trans("admin.Total_Price").' </th>

                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$cName.'
       </td>

               <td>
     '.$qty.'
       </td>

       <td>
     '.$tot.'
       </td>


        </tr>

                <tr style="background-color:#014b2a;color:#b99400">
                                                    <th>' .trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';




                foreach($Sales as $sal){

                    $output .= '            <tr>


        <td>
     '.$sal->Product_Code.'
       </td>
               <td>
     '.$sal->P_Ar_Name.' ('.$sal->VName.') ('.$sal->VVName.')
       </td>

             <td>
     '.$sal->Qty.'
       </td>
             <td>
     '.$sal->Price.'
       </td>
             <td>
     '.$sal->Total_Net.'
       </td>


        </tr>
  ';

                }

            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    //DailyMovesPage
    public function DailyMovesPage(){

        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Stores=Stores::type()->get();

        return view('admin.Reports.DailyMoves',get_defined_vars());
    }

    function DailyMovesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';

            $Date = $request->get('Date');
            $Safe = $request->get('Safe');
            $store = $request->get('store');

            if($Date != ''){


                $Sales=Sales::where('Date',$Date)
                    ->where('Status',1)

                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get();


                $TotalPriceSales=Sales::where('Date',$Date)
                    ->where('Status',1)

                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get()->sum('Total_Net');

                $Purchses=Purchases::where('Date',$Date)
                    ->where('Status',1)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->where('Edit',0)
                    ->where('Delete',0)
                    ->get();

                $TotalPricePurch=Purchases::where('Date',$Date)
                    ->where('Status',1)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Net');



                $ReturnPurchses=ReturnPurch::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();


                $TotalPriceRPurch=ReturnPurch::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Return_Value');

                $ReturnSales=ReturnSales::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();


                $TotalPriceRSales=ReturnSales::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Return_Value');

                $Openings=OpeningEntries::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get();
                $OpeningsDepitor=OpeningEntries::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get()->sum('Total_Debaitor');
                $OpeningsCreditor=OpeningEntries::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get()->sum('Total_Creditor');

                $Payments=PaymentVoucher::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get();
                $PaymentsTotal=PaymentVoucher::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get()->sum('Total_Debaitor');

                $Recipts=ReciptVoucher::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get();
                $ReciptsTotal=ReciptVoucher::where('Edit',null)->where('Delete',null)->where('Date',$Date)->get()->sum('Total_Creditor');

                $SafesTransfers=SafeTransfers::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('From_Safe',$Safe);
                    })
                    ->get();

                $TotalSafesTransfers=SafeTransfers::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('From_Safe',$Safe);
                    })
                    ->get()->sum('Amount');


                $StoresTransfers=StorsTransfers::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('From_Store',$store);

                    })
                    ->get();


                $TotalStoresTransfers=StorsTransfers::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('From_Store',$store);

                    })
                    ->get()->sum('Total_Cost');


                $IncomChecks=IncomChecks::where('Edit',null)->where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get();


                $TotalIncomChecks=IncomChecks::where('Edit',null)->where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get()->sum('Amount');


                $ExportChecks=ExportChecks::where('Edit',null)->where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get();

                $TotalExportChecks=ExportChecks::where('Edit',null)->where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get()->sum('Amount');

                $InsurancePapers=InsurancePaper::where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get();

                $TotalInsurancePapers=InsurancePaper::where('Delete',null)->where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Bank',$Safe);
                    })
                    ->get()->sum('Amount');



                $StartPeriods=StartPeriods::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();


                $TotalStartPeriods=StartPeriods::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Price');

                $Settlement=Settlement::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();



                $TotalDSettlement=Settlement::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Dificit_Price');

                $TotalESettlement=Settlement::where('Date',$Date)
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total_Excess_Price');



                $ReciptMaintaince=ReciptMaintaince::where('Date',$Date)
                    ->where('Status',0)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();

                $TotalReciptMaintaince=ReciptMaintaince::where('Date',$Date)
                    ->where('Status',0)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total');


                $ReturnMaintaince=ReturnMaintainceBill::where('Date',$Date)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();

                $TotalReturnMaintaince=ReturnMaintainceBill::where('Date',$Date)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total');


                $ExecutingReceiving=ExecutingReceiving::where('Date',$Date)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('StoreIn',$store);

                    })
                    ->get();

                $TotalExecutingReceiving=ExecutingReceiving::where('Date',$Date)

                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('StoreIn',$store);

                    })
                    ->get()->sum('Total');

                $SalesPetrol=SalesPetrol::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();


                $TotalSalesPetrol=SalesPetrol::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total');


                $Tickets=Ticket::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get();

                $TotalTickets=Ticket::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })
                    ->when(!empty($store), function ($query) use ($store) {
                        return $query->where('Store',$store);

                    })
                    ->get()->sum('Total');


                $Loans=Loan::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get();

                $TotalLoans=Loan::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get()->sum('Amount');

                $Borrows=Borrowa::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get();

                $TotalBorrows=Borrowa::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get()->sum('Amount');

                $Salary=PaySalary::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get();

                $TotalSalary=PaySalary::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get()->sum('Amount');

                $Exchange=ExchangeCommissions::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get();

                $TotalExchange=ExchangeCommissions::where('Date',$Date)
                    ->when(!empty($Safe), function ($query) use ($Safe) {
                        return $query->where('Safe',$Safe);
                    })

                    ->get()->sum('Amount');



            }


            $output .= '
          <table class="table table-bordered table-hover table-striped w-100 mobile-width SalesClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :  '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").'  :   '.$TotalPriceSales.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Sales").' </th>
                                                </tr>
                                            </thead>
                                        ';

            foreach($Sales as $sal){
                $Prods=ProductSales::where('Sales',$sal->id)->get();

                $output .= '

 <tbody>
                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                                    <th>'.trans("admin.Notes").' </th>
                                    </tr>

            ';

                foreach($Prods as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$pro->P_Ar_Name;
                        $UniiName=$pro->Unit()->first()->Name;
                        $StoreNemo=$pro->Store()->first()->Name;

                    }else{
                        $PrrroName=$pro->P_En_Name;
                        $UniiName=$pro->Unit()->first()->NameEn;
                        $StoreNemo=$pro->Store()->first()->NameEn;

                    }

                    $output .= '

        <tr>
<td> '.$sal->Code.'</td>
        <td>
     '.$pro->Code.'
       </td>

             <td>
     '.$PrrroName.'
       </td>
                  <td>
     '.$UniiName.'
       </td>
             <td>
     '.$pro->Qty.'
       </td>

                  <td>
     '.$pro->Price.'
       </td>

                  <td>
     '.$pro->Total.'
       </td>
                       <td>
     '.$StoreNemo.'
       </td>
         <td>

       </td>

        </tr>


            ';


                }



            }

            $output .= '  </tbody></table>  ';


            $output .= '

                   <table class="table table-bordered table-hover table-striped w-100 mobile-width PurchClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :  '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :  '.$TotalPricePurch.' </th>
                                                    <th style="font-size:20px">'.trans("admin.Purchases").'</th>

                                                </tr>
                                            </thead> ';


            foreach($Purchses as $sal){
                $Prods=ProductsPurchases::where('Purchase',$sal->id)->get();

                $output .= '

    <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                                    <th>'.trans("admin.Notes").' </th>
                                    </tr>

            ';

                foreach($Prods as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$pro->P_Ar_Name;
                        $UniiName=$pro->Unit()->first()->Name;
                        $StoreNemo=$pro->Store()->first()->Name;

                    }else{
                        $PrrroName=$pro->P_En_Name;
                        $UniiName=$pro->Unit()->first()->NameEn;
                        $StoreNemo=$pro->Store()->first()->NameEn;

                    }

                    $output .= '

        <tr>

        <td>
    '.$sal->Code.'
       </td>

       <td>
     '.$pro->Code.'
       </td>

             <td>
     '.$PrrroName.'
       </td>
                  <td>
     '.$UniiName.'
       </td>
             <td>
     '.$pro->Qty.'
       </td>

                  <td>
     '.$pro->Price.'
       </td>

                  <td>
     '.$pro->Total.'
       </td>
                       <td>
     '.$StoreNemo.'
       </td>
         <td>

       </td>

        </tr>


            ';


                }



            }

            $output .= '  </tbody></table>  ';


            $output .= '

                      <table class="table table-bordered table-hover table-striped w-100 mobile-width RPurchClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :   '.$Date.' </th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :  '.$TotalPriceRPurch.' </th>
                                                    <th style="font-size:20px" >'.trans("admin.Return_Purchases").' </th>
                                                </tr>
                                            </thead>';

            foreach($ReturnPurchses as $sal){

                $Prods=ReturnPurchProducts::where('Return',$sal->id)->get();

                $output .= '




             <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Return_Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                                    <th>'.trans("admin.Notes").' </th>
                                    </tr>

            ';


                foreach($Prods as $pro){
                    if($pro->Return_Qty != 0){

                        foreach($Prods as $pro){


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$pro->P_Ar_Name;
                                $UniiName=$pro->Unit()->first()->Name;
                                $StoreNemo=$pro->Store()->first()->Name;

                            }else{
                                $PrrroName=$pro->P_En_Name;
                                $UniiName=$pro->Unit()->first()->NameEn;
                                $StoreNemo=$pro->Store()->first()->NameEn;

                            }

                            $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>

       <td>
     '.$pro->Product_Code.'
       </td>

             <td>
     '.$PrrroName.'
       </td>
                  <td>
     '.$UniiName.'
       </td>
             <td>
     '.$pro->Return_Qty.'
       </td>

                  <td>
     '.$pro->Price.'
       </td>

                  <td>
     '.$pro->Total.'
       </td>
                       <td>
     '.$StoreNemo.'
       </td>
         <td>

       </td>

        </tr>



            ';

                        }
                    }




                }
            }
            $output .= '  </tbody></table>  ';


            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width RSalesClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalPriceRSales.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Return_Sales").' </th>
                                                </tr>
                                            </thead>';

            foreach($ReturnSales as $sal){

                $Prods=ReturnSalesProducts::where('Return',$sal->id)->get();

                $output .= '




               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Return_Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                                    <th>'.trans("admin.Notes").' </th>
                                    </tr>

            ';


                foreach($Prods as $pro){
                    if($pro->Recived_Qty != 0){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$pro->P_Ar_Name;
                            $UniiName=$pro->Unit()->first()->Name;
                            $StoreNemo=$pro->Store()->first()->Name;

                        }else{
                            $PrrroName=$pro->P_En_Name;
                            $UniiName=$pro->Unit()->first()->NameEn;
                            $StoreNemo=$pro->Store()->first()->NameEn;

                        }
                        $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>

       <td>
     '.$pro->Product_Code.'
       </td>

             <td>
     '.$PrrroName.'
       </td>
                  <td>
     '.$UniiName.'
       </td>
             <td>
     '.$pro->Recived_Qty.'
       </td>

                  <td>
     '.$pro->Price.'
       </td>

                  <td>
     '.$pro->Total.'
       </td>
                       <td>
     '.$StoreNemo.'
       </td>
         <td>

       </td>

        </tr>



            ';

                    }
                }



            }
            $output .= '  </tbody></table>  ';



            $output .= '
           <table class="table table-bordered table-hover table-striped w-100 mobile-width OpeningClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :  '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Debaitor").'  :   '.$OpeningsDepitor.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Creditor").'  :   '.$OpeningsCreditor.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Opening_Entries").' </th>
                                                </tr>
                                            </thead>';

            foreach($Openings as $op){
                $details=OpeningEntriesDetails::where('OP_ID',$op->id)->get();

                $output .= '



 <tbody>
                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Debitor").' </th>
                                                    <th>'.trans("admin.Creditor").' </th>
                                                    <th>'.trans("admin.Account_Code").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.Statement").' </th>

                                    </tr>

            ';

                foreach($details as $det){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$det->Account()->first()->Name;


                    }else{
                        $PrrroName=$det->Account()->first()->NameEn;


                    }

                    $output .= '

        <tr>

        <td>
  '.$op->Code.'
       </td>

       <td>
     '.$det->Debitor.'
       </td>

             <td>
     '.$det->Creditor.'
       </td>
                  <td>
     '.$det->Account()->first()->Code.'
       </td>
             <td>
     '.$PrrroName.'
       </td>

                  <td>
     '.$det->Statement.'
       </td>


        </tr>


            ';


                }



            }

            $output .= '  </tbody></table>  ';




            $output .= '
           <table class="table table-bordered table-hover table-striped w-100 mobile-width PaymentsClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :  '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Debaitor").'  :   '.$PaymentsTotal.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Payment_Voucher").' </th>
                                                </tr>
                                            </thead>';

            foreach($Payments as $op){
                $details=PaymentVoucherDetails::where('PV_ID',$op->id)->get();

                $output .= '



 <tbody>
                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Debitor").' </th>
                                                    <th>'.trans("admin.Account_Code").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.Statement").' </th>


                                    </tr>

            ';

                foreach($details as $det){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$det->Account()->first()->Name;


                    }else{
                        $PrrroName=$det->Account()->first()->NameEn;


                    }
                    $output .= '

        <tr>

        <td>
  '.$op->Code.'
       </td>

       <td>
     '.$det->Debitor.'
       </td>


                  <td>
     '.$det->Account()->first()->Code.'
       </td>
             <td>
     '.$PrrroName.'
       </td>

                  <td>
     '.$det->Statement.'
       </td>


        </tr>


            ';


                }



            }

            $output .= '  </tbody></table>  ';



            $output .= '
           <table class="table table-bordered table-hover table-striped w-100 mobile-width ReciptsClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").' :  '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Creditor").'  :   '.$ReciptsTotal.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Receipt_Voucher").' </th>
                                                </tr>
                                            </thead>';

            foreach($Recipts as $op){
                $details=ReciptVoucherDetails::where('RV_ID',$op->id)->get();

                $output .= '



 <tbody>
                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Creditor").' </th>
                                                    <th>'.trans("admin.Account_Code").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.Statement").' </th>

                                    </tr>

            ';

                foreach($details as $det){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$det->Account()->first()->Name;


                    }else{
                        $PrrroName=$det->Account()->first()->NameEn;


                    }

                    $output .= '

        <tr>

        <td>
  '.$op->Code.'
       </td>

             <td>
     '.$det->Creditor.'
       </td>
                  <td>
     '.$det->Account()->first()->Code.'
       </td>
             <td>
     '.$PrrroName.'
       </td>

                  <td>
     '.$det->Statement.'
       </td>


        </tr>


            ';


                }



            }

            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width StoresTClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalStoresTransfers.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Stores_Transfers").' </th>
                                                </tr>
                                            </thead>';

            foreach($StoresTransfers as $sal){

                $Pros=ProductsStoresTransfers::where('ST_ID',$sal->id)->get();

                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.From_Store").' </th>
                                                    <th>'.trans("admin.To_Store").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.P_Code").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Trans_Qty").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Total").' </th>

                                    </tr>

            ';


                foreach($Pros as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $FromName=$sal->From_Store()->first()->Name;
                        $ToName=$sal->To_Store()->first()->Name;
                        $ProoName=$pro->Product()->first()->P_Ar_Name;
                        $UniName=$pro->Unit()->first()->Name;


                    }else{
                        $FromName=$sal->From_Store()->first()->NameEn;
                        $ToName=$sal->To_Store()->first()->NameEn;
                        $ProoName=$pro->Product()->first()->P_En_Name;
                        $UniName=$pro->Unit()->first()->NameEn;


                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>        <td>
     '.$FromName.'
       </td>        <td>
     '.$ToName.'
       </td>

       <td>
     '.$ProoName.'
       </td>

             <td>
     '.$pro->P_Code.'
       </td>
                  <td>
     '.$pro->Price.'
       </td>
             <td>
     '.$pro->Trans_Qty.'
       </td>

                  <td>
     '.$UniName.'
       </td>
       <td>
     '.$pro->Total.'
       </td>


        </tr>








            ';

                }



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width SafesTClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalSafesTransfers.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Safes_Transfer").' </th>
                                                </tr>
                                            </thead>';

            foreach($SafesTransfers as $sal){



                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Amount").' </th>
                                                    <th>'.trans("admin.From_Safe").' </th>
                                                    <th>'.trans("admin.To_Safe").' </th>


                                    </tr>

            ';

                if(app()->getLocale() == 'ar' ){
                    $FromName=$sal->From_Safe()->first()->Name;
                    $ToName=$sal->To_Safe()->first()->Name;



                }else{
                    $FromName=$sal->From_Safe()->first()->NameEn;
                    $ToName=$sal->To_Safe()->first()->NameEn;



                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
         <td>
     '.$sal->Amount.'
       </td>
         <td>
     '.$FromName.'
       </td>
         <td>
     '.$ToName.'
       </td>




        </tr>








            ';



            }
            $output .= '  </tbody></table>  ';


            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width IncomCheckClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalIncomChecks.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Incoming_checks").' </th>
                                                </tr>
                                            </thead>';

            foreach($IncomChecks as $sal){



                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.Bank").' </th>
                                                    <th>'.trans("admin.Check_Num").' </th>
                                                    <th>'.trans("admin.Due_Date").' </th>
                                                    <th>'.trans("admin.Amount").' </th>


                                    </tr>

            ';


                if(app()->getLocale() == 'ar' ){
                    $AccName=$sal->Account()->first()->Name;
                    $BankName=$sal->Bank()->first()->Name;



                }else{
                    $AccName=$sal->Account()->first()->NameEn;
                    $BankName=$sal->Bank()->first()->NameEn;



                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
         <td>
     '.$AccName.'
       </td>
         <td>
     '.$BankName.'
       </td>
         <td>
     '.$sal->Check_Num.'
       </td>
       <td>
     '.$sal->Due_Date.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>

        </tr>








            ';



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width ExportCheckClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalExportChecks.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Exporting_Checks").' </th>
                                                </tr>
                                            </thead>';

            foreach($ExportChecks as $sal){



                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.Bank").' </th>
                                                    <th>'.trans("admin.Check_Num").' </th>
                                                    <th>'.trans("admin.Due_Date").' </th>
                                                    <th>'.trans("admin.Amount").' </th>


                                    </tr>

            ';

                if(app()->getLocale() == 'ar' ){
                    $AccName=$sal->Account()->first()->Name;
                    $BankName=$sal->Bank()->first()->Name;



                }else{
                    $AccName=$sal->Account()->first()->NameEn;
                    $BankName=$sal->Bank()->first()->NameEn;



                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
         <td>
     '.$AccName.'
       </td>
         <td>
     '.$BankName.'
       </td>
         <td>
     '.$sal->Check_Num.'
       </td>
       <td>
     '.$sal->Due_Date.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>

        </tr>








            ';



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width InsuranceClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalInsurancePapers.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Insurance_Paper").' </th>
                                                </tr>
                                            </thead>';

            foreach($InsurancePapers as $sal){



                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Account_Name").' </th>
                                                    <th>'.trans("admin.From").' </th>
                                                    <th>'.trans("admin.To").' </th>
                                                    <th>'.trans("admin.Due_Date").' </th>
                                                    <th>'.trans("admin.Amount").' </th>


                                    </tr>

            ';


                if(app()->getLocale() == 'ar' ){
                    $AccName=$sal->Account()->first()->Name;




                }else{
                    $AccName=$sal->Account()->first()->NameEn;




                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
         <td>
     '.$AccName.'
       </td>
         <td>
     '.$sal->From.'
       </td>
         <td>
     '.$sal->To.'
       </td>
       <td>
     '.$sal->Due_Date.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>

        </tr>








            ';



            }
            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width StartClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalStartPeriods.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Start_Period").' </th>
                                                </tr>
                                            </thead>';

            foreach($StartPeriods as $sal){

                $Pros=ProductsStartPeriods::where('SP_ID',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.P_Code").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>



                                    </tr>

            ';


                foreach($Pros as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $ProName=$pro->Product()->first()->P_Ar_Name;
                        $UniName=$pro->Unit()->first()->Name;
                        $StoName=$pro->Store()->first()->Name;




                    }else{
                        $ProName=$pro->Product()->first()->P_En_Name;
                        $UniName=$pro->Unit()->first()->NameEn;
                        $StoName=$pro->Store()->first()->NameEn;




                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
        <td>
     '.$ProName.'
       </td>
        <td>
     '.$pro->P_Code.'
       </td>
        <td>
     '.$UniName.'
       </td>
       <td>
     '.$pro->Qty.'
       </td>
       <td>
     '.$pro->Price.'
       </td>
       <td>
     '.$pro->Total.'
       </td>
       <td>
     '.$StoName.'
       </td>


        </tr>


            ';

                }



            }
            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width SettlementClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Dificit_Price").' :    '.$TotalDSettlement.' </th>
                                                    <th style="font-size:20px">'.trans("admin.Total_Excess_Price").' :    '.$TotalESettlement.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Settlement").' </th>
                                                </tr>
                                            </thead>';

            foreach($Settlement as $sal){

                $Pros=ProductSettlement::where('Set_ID',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.P_Code").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Inventory").' </th>
                                                    <th>'.trans("admin.Dificit").' </th>
                                                    <th>'.trans("admin.Execess").' </th>



                                    </tr>

            ';


                foreach($Pros as $pro){

                    if(app()->getLocale() == 'ar' ){
                        $ProName=$pro->Product()->first()->P_Ar_Name;
                        $UniName=$pro->Unit()->first()->Name;





                    }else{
                        $ProName=$pro->Product()->first()->P_En_Name;
                        $UniName=$pro->Unit()->first()->NameEn;





                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>

        <td>
     '.$ProName.'
       </td>
       <td>
     '.$pro->P_Code.'
       </td>
       <td>
     '.$pro->Av_Qty.'
       </td>
       <td>
     '.$pro->Price.'
       </td>
         <td>
     '.$UniName.'
       </td>
       <td>
     '.$pro->Inventory.'
       </td>
       <td>
     '.$pro->Deficit.'
       </td>
       <td>
     '.$pro->Excess.'
       </td>


        </tr>


            ';

                }



            }
            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width ReciptMaintainceClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalReciptMaintaince.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Maintaince").' </th>
                                                </tr>
                                            </thead>';

            foreach($ReciptMaintaince as $sal){

                $products=ProductMaintaincBill::where('Maintaince',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                    </tr>

            ';


                foreach($products as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $ProName=$pro->P_Ar_Name;
                        $UniName=$pro->Store()->first()->Name;





                    }else{
                        $ProName=$pro->P_En_Name;
                        $UniName=$pro->Store()->first()->NameEn;





                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$pro->Product_Code.'
       </td>
       <td>
     '.$ProName.'
       </td>
         <td>
     '.$pro->Qty.'
       </td>
       <td>
     '.$pro->Price.'
       </td>
       <td>
     '.$pro->Total.'
       </td>
       <td>
     '.$UniName.'
       </td>


        </tr>


            ';

                }



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width ReturnMaintainceClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalReturnMaintaince.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.ReturnMaintainceBill").' </th>
                                                </tr>
                                            </thead>';

            foreach($ReturnMaintaince as $sal){

                $products=ProductsReturnMaintainceBill::where('Return',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Return_Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                    </tr>

            ';


                foreach($products as $pro){

                    if(app()->getLocale() == 'ar' ){
                        $ProName=$pro->P_Ar_Name;
                        $UniName=$pro->Store()->first()->Name;





                    }else{
                        $ProName=$pro->P_En_Name;
                        $UniName=$pro->Store()->first()->NameEn;





                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$pro->Product_Code.'
       </td>
       <td>
     '.$ProName.'
       </td>
         <td>
     '.$pro->Recived_Qty.'
       </td>
       <td>
     '.$pro->Price.'
       </td>
       <td>
     '.$pro->Total.'
       </td>
       <td>
     '.$UniName.'
       </td>


        </tr>


            ';

                }



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width ExecutingClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalExecutingReceiving.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.ExecutingandReceiving").' </th>
                                                </tr>
                                            </thead>';

            foreach($ExecutingReceiving as $sal){

                $details=ProductsExecutingReceiving::where('Executing',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                    </tr>

            ';


                foreach($details as $pro){
                    if($pro->type ==1){

                        if(app()->getLocale() == 'ar' ){
                            $ProName=$pro->Product()->first()->P_Ar_Name;
                            $UniName=$pro->Unit()->first()->Name;

                        }else{
                            $ProName=$pro->Product()->first()->P_En_Name;
                            $UniName=$pro->Unit()->first()->NameEn;


                        }

                        $output .= '
     <h3>'.trans('admin.Outcome').'</h3>
        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$pro->Product_Code.'
       </td>
       <td>
     '.$ProName.'
       </td>
         <td>
     '.$UniName.'
       </td>
       <td>
     '.$pro->Qty * $sal->Qty.'
       </td>


        </tr>


            ';

                    }
                }

                $output .= '
                        <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Depreciation").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                    </tr>

            ';

                foreach($details as $pro){
                    if($pro->type ==0){


                        if(app()->getLocale() == 'ar' ){
                            $ProName=$pro->Product()->first()->P_Ar_Name;
                            $UniName=$pro->Unit()->first()->Name;
                            $StoName=$pro->Store()->first()->Name;

                        }else{
                            $ProName=$pro->Product()->first()->P_En_Name;
                            $UniName=$pro->Unit()->first()->NameEn;
                            $StoName=$pro->Store()->first()->NameEn;


                        }

                        $output .= '
     <h3>'.trans('admin.Income').'</h3>
        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$pro->Product_Code.'
       </td>
       <td>
     '.$ProName.'
       </td>
         <td>
     '.$UniName.'
       </td>
       <td>
     '.$pro->Dep.'
       </td>
             <td>
     '.$pro->Qty.'
       </td>
       <td>
     '.$pro->Price *  $sal->Qty.'
       </td>
         <td>
     '.$pro->Total *  $sal->Qty.'
       </td>
       <td>
     '.$StoName.'
       </td>


        </tr>


            ';

                    }
                }


            }
            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width SalesPetrolClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalSalesPetrol.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.SalesPetrol").' </th>
                                                </tr>
                                            </thead>';

            foreach($SalesPetrol as $sal){


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Counter").' </th>
                                                    <th>'.trans("admin.Safe").' </th>
                                                    <th>'.trans("admin.Recipient").' </th>
                                                    <th>'.trans("admin.Store").' </th>
                                                    <th>'.trans("admin.Current_Read").' </th>
                                                    <th>'.trans("admin.Consumption").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';


                if(app()->getLocale() == 'ar' ){
                    $CounterName=$sal->Counter()->first()->Name;
                    $SafeName=$sal->Safe()->first()->Name;
                    $RecipientName=$sal->Recipient()->first()->Name;
                    $StoName=$sal->Store()->first()->Name;


                }else{
                    $CounterName=$sal->Counter()->first()->NameEn;
                    $SafeName=$sal->Safe()->first()->NameEn;
                    $RecipientName=$sal->Recipient()->first()->NameEn;
                    $StoName=$sal->Store()->first()->NameEn;


                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$CounterName.'
       </td>
       <td>
     '.$SafeName.'
       </td>
         <td>
     '.$RecipientName.'
       </td>
       <td>
     '.$StoName.'
       </td>
       <td>
     '.$sal->Current_Raed.'
       </td>
       <td>
     '.$sal->Consumption.'
       </td>
              <td>
     '.$sal->Value.'
       </td>
       <td>
     '.$sal->Total.'
       </td>


        </tr>


            ';




            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width TicketsClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalTickets.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Tickets").' </th>
                                                </tr>
                                            </thead>';

            foreach($Tickets as $sal){

                $Prods=TicketProducts::where('Ticket',$sal->id)->get();


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Weight").' </th>
                                                    <th>'.trans("admin.Length").' </th>
                                                    <th>'.trans("admin.Width").' </th>
                                                    <th>'.trans("admin.Height").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Unit").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';


                foreach($Prods as $pro){


                    if(app()->getLocale() == 'ar' ){
                        $ProoName=$pro->P_Ar_Name;
                        $UniiName=$pro->Unit()->first()->Name;



                    }else{
                        $ProoName=$pro->P_En_Name;
                        $UniiName=$pro->Unit()->first()->NameEn;



                    }

                    $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$pro->Product_Code.'
       </td>
       <td>
     '.$ProoName.'
       </td>
         <td>
     '.$pro->Price.'
       </td>
       <td>
     '.$pro->Weight.'
       </td>
       <td>
     '.$pro->Length.'
       </td>
       <td>
     '.$pro->Width.'
       </td>
       <td>
     '.$pro->Height.'
       </td>
       <td>
     '.$pro->Qty.'
       </td>
       <td>
     '.$UniiName.'
       </td>
       <td>
     '.$pro->Total.'
       </td>

        </tr>


            ';

                }



            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width LoanClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalLoans.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Loan").' </th>
                                                </tr>
                                            </thead>';

            foreach($Loans as $sal){


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Amount").' </th>
                                                    <th>'.trans("admin.Years_Number").' </th>
                                                    <th>'.trans("admin.Date_First_installment").' </th>
                                                    <th>'.trans("admin.monthly_installment").' </th>
                                                    <th>'.trans("admin.installment_Num").' </th>
                                                    <th>'.trans("admin.Employee").' </th>
                                                    <th>'.trans("admin.Type").' </th>
                                                    <th>'.trans("admin.Safe").' </th>
                                    </tr>

            ';


                if(app()->getLocale() == 'ar' ){
                    $EmpName=$sal->Emp()->first()->Name;
                    $TypeName=$sal->Type()->first()->Arabic_Name;
                    $SafeName=$sal->Safe()->first()->Name;



                }else{
                    $EmpName=$sal->Emp()->first()->NameEn;
                    $TypeName=$sal->Type()->first()->English_Name;
                    $SafeName=$sal->Safe()->first()->NameEn;



                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>
       <td>
     '.$sal->Years_Number.'
       </td>
         <td>
     '.$sal->First_Date.'
       </td>
       <td>
     '.$sal->Install.'
       </td>
       <td>
     '.$sal->Install_Numbers.'
       </td>
       <td>
     '.$EmpName.'
       </td>
              <td>
     '.$TypeName.'
       </td>
       <td>
     '.$SafeName.'
       </td>


        </tr>


            ';




            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width BorrowsClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalBorrows.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Borrow").' </th>
                                                </tr>
                                            </thead>';

            foreach($Borrows as $sal){


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Month").' </th>
                                                    <th>'.trans("admin.Amount").' </th>
                                                    <th>'.trans("admin.Safe").' </th>
                                                    <th>'.trans("admin.Employee").' </th>

                                    </tr>

            ';


                if(app()->getLocale() == 'ar' ){
                    $SafeName=$sal->Safe()->first()->Name;

                    $EmpName=$sal->Emp()->first()->Name;





                }else{

                    $SafeName=$sal->Safe()->first()->NameEn;
                    $EmpName=$sal->Emp()->first()->NameEn;





                }


                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$sal->Month.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>
         <td>
     '.$SafeName.'
       </td>
       <td>
     '.$EmpName.'
       </td>



        </tr>


            ';




            }
            $output .= '  </tbody></table>  ';



            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width SalaryClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalSalary.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.Salaries").' </th>
                                                </tr>
                                            </thead>';

            foreach($Salary as $sal){


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Month").' </th>
                                                    <th>'.trans("admin.Resduial_Salary").' </th>
                                                    <th>'.trans("admin.Safe").' </th>
                                                    <th>'.trans("admin.Employee").' </th>

                                    </tr>

            ';



                if(app()->getLocale() == 'ar' ){
                    $SafeName=$sal->Safe()->first()->Name;

                    $EmpName=$sal->Emp()->first()->Name;





                }else{

                    $SafeName=$sal->Safe()->first()->NameEn;
                    $EmpName=$sal->Emp()->first()->NameEn;





                }


                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$sal->Month.'
       </td>
       <td>
     '.$sal->Resduial_Salary.'
       </td>
         <td>
     '.$SafeName.'
       </td>
       <td>
     '.$EmpName.'
       </td>



        </tr>


            ';




            }
            $output .= '  </tbody></table>  ';




            $output .= '

                    <table class="table table-bordered table-hover table-striped w-100 mobile-width ExchangeClass">
                    <thead style="background-color:black;color:white">
                                                <tr>

                                                    <th style="font-size:20px">'.trans("admin.Date").'  :      '.$Date.'</th>
                                                    <th style="font-size:20px">'.trans("admin.Total").' :    '.$TotalExchange.' </th>
                                                            <th style="font-size:20px" >'.trans("admin.ExchangeCommissions").' </th>
                                                </tr>
                                            </thead>';

            foreach($Exchange as $sal){


                $output .= '

               <tbody>

                <tr style="background-color:#520b0b;color:white">
                                                    <th>'.trans("admin.Bill_Num").' </th>
                                                    <th>'.trans("admin.Amount").' </th>
                                                    <th>'.trans("admin.Safe").' </th>
                                                    <th>'.trans("admin.Employee").' </th>


                                    </tr>

            ';



                if(app()->getLocale() == 'ar' ){
                    $SafeName=$sal->Safe()->first()->Name;

                    $EmpName=$sal->Emp()->first()->Name;





                }else{

                    $SafeName=$sal->Safe()->first()->NameEn;
                    $EmpName=$sal->Emp()->first()->NameEn;





                }

                $output .= '

        <tr>

        <td>
     '.$sal->Code.'
       </td>
       <td>
     '.$sal->Amount.'
       </td>
       <td>
     '.$SafeName.'
       </td>
         <td>
     '.$EmpName.'
       </td>




        </tr>


            ';




            }
            $output .= '  </tbody></table>  ';





            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //ExecutorSales
    public function ExecutorSales(){

        $Employess=Employess::where("EmpSort",1)->where('Active',1)->get();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if($Def->V_and_C == 0){
            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->get();
        }elseif($Def->V_and_C == 1){


            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->orWhere('Parent',37)
                ->get();


        }

        $Groups=ItemsGroups::all();
        return view('admin.Reports.ExecutorSales',get_defined_vars());
    }

    function ExecutorSalesFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Emp = $request->get('Emp');
            $Group = $request->get('Group');

            if($Emp != '' or $Group != ''){

                $qty=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Emp), function ($query) use ($Emp) {
                        return $query->whereRelation('Sales','Executor',$Emp);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Qty');
                $tot=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Emp), function ($query) use ($Emp) {
                        return $query->whereRelation('Sales','Executor',$Emp);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');

                $Sales=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Emp), function ($query) use ($Emp) {
                        return $query->whereRelation('Sales','Executor',$Emp);

                    })
                    ->when(!empty($Group), function ($query) use ($Group) {
                        return $query->whereRelation('Product','Group',$Group);

                    })
                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get();


                $grb=ItemsGroups::find($Group);
                $cust=Employess::find($Emp);

                if(!empty($grb)){
                    if(app()->getLocale() == 'ar' ){
                        $xName=$grb->Name;

                    }else{
                        $xName=$grb->NameEn;

                    }
                }else{

                    $xName='';

                }

                if(!empty($cust)){
                    if(app()->getLocale() == 'ar' ){
                        $cName=$cust->Name;

                    }else{
                        $cName=$cust->NameEn;

                    }
                }else{

                    $cName='';

                }


                $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>'.trans("admin.Emp").' </th>
                                                    <th>'.trans("admin.Total_Qty").' </th>
                                                    <th>'.trans("admin.Total_Price").' </th>
                                                    <th>'.trans("admin.Group").' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     '.$cName.'
       </td>

               <td>
     '.$qty.'
       </td>

       <td>
     '.$tot.'
       </td>

     <td>
     '.$xName. '
       </td>
        </tr>

                <tr style="background-color:#014b2a;color:#b99400">
                                                    <th>' .trans("admin.Code").' </th>
                                                    <th>'.trans("admin.Name").' </th>
                                                    <th>'.trans("admin.Qty").' </th>
                                                    <th>'.trans("admin.Price").' </th>
                                                    <th>'.trans("admin.Total").' </th>
                                    </tr>

            ';




                foreach($Sales as $sal){

                    $output .= '            <tr>


        <td>
     '.$sal->Product_Code.'
       </td>
               <td>
     '.$sal->P_Ar_Name.' ('.$sal->VName.') ('.$sal->VVName.')
       </td>

             <td>
     '.$sal->Qty.'
       </td>
             <td>
     '.$sal->Price.'
       </td>
             <td>
     '.$sal->Total_Net.'
       </td>


        </tr>
  ';

                }

            }


            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //InstallmentReport
    public function InstallmentReport(){

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if($Def->V_and_C == 0){
            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->get();
        }elseif($Def->V_and_C == 1){


            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->orWhere('Parent',37)
                ->get();


        }


        return view('admin.Reports.InstallmentReport',get_defined_vars());
    }

    public function InstallmentReportFilterTwo(Request $request){

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if($Def->V_and_C == 0){
            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->get();
        }elseif($Def->V_and_C == 1){


            $Clients = AcccountingManual::
            where('Type',1)
                ->where('Parent',24)
                ->orWhere('Parent',37)
                ->get();


        }
        $Client = $request->get('Client');

        $ProdsCount=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->count();

        $ProdsTotal=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->get()->sum('Value');


        $Prods=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->paginate(20);




        $output = '';
        if($request->ajax())
        {
            $Client = $request->get('Client');

            foreach($Prods as $pro){

                if(app()->getLocale() == 'ar' ){
                    $xName=$pro->Client()->first()->Name;

                }else{
                    $xName=$pro->Client()->first()->Name;

                }

                $output .= '
           <tr>
           <td>'.$xName.'</td>
           <td>'.$pro->Install()->first()->Sales()->first()->Code.'</td>
           <td>'.$pro->Date.'</td>
           <td>'.$pro->Value.'</td>
           <tr>';

            }

            return   $output ;
        }

        return view('admin.Reports.InstallmentReportFilterTwo',get_defined_vars());
    }


    //ExceptProfits

    public function ExceptProfits(){
        $ItemsGroups=ItemsGroups::all();
        $Brands=Brands::all();
        $Stores=Stores::type()->get();
        return view('admin.Reports.ExceptProfits',get_defined_vars());
    }

    public function ExceptProfitsFilterTwo(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Brands=Brands::all();
        if(auth()->guard('admin')->user()->emp == 0){

            $Stores=Stores::all();
        }else{

            if(!empty(auth()->guard('admin')->user()->store)){

                if(auth()->guard('admin')->user()->pos_stores == 0){

                    $Stores=Stores::where('id',auth()->guard('admin')->user()->store)->get();
                }else{

                    $Stores=Stores::all();
                }


            }else{

                $Stores=Stores::all();
            }

        }

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $brand = $request->get('brand');

        $Prods=ProductsQty::

        when(!empty($search), function ($query) use ($search) {
            return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('P_Code','ILIKE', "%{$search}%")
                ->orWhere('PP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                ;
        })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group',$group);

            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->where('Brand',$brand);

            })


            ->paginate(10);


        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $brand = $request->get('brand');


            foreach($Prods as $rows){

                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();


                $Average=$average->AverageCostGetUnit($rows->Product , $rr->Barcode,$store , $rr->Unit);


                if($rr->Rate == 1){

                    $SMallAverage=$Average;
                    $Average=$Average;
                }else{

                    $SMallAverage=$Average;
                    $Average=$Average * $rr->Rate;
                }






                $def=StoresDefaultData::orderBy('id','desc')->first();
                if($def->Cost_Price == 2){


                    $totCost=0;





                    $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();
                    $plow = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();


                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$rows->Product)
                        ->where('P_Code',$rr->Barcode)
                        ->orderBy('Purchases_Date','asc')
                        ->first();

                    if(empty($fifo)){

                        $fifo =FifoQty::
                        where('Store',$store)
                            ->where('Product',$rows->Product)
                            ->where('PP_Code',$plow->Barcode)
                            ->orderBy('Purchases_Date','asc')
                            ->first();

                        if(empty($fifo)){

                            $fifo =FifoQty::
                            where('Store',$store)
                                ->where('Product',$rows->Product)
                                ->where('PPP_Code',$plow->Barcode)
                                ->orderBy('Purchases_Date','asc')
                                ->first();


                            if(empty($fifo)){

                                $fifo =FifoQty::
                                where('Store',$store)
                                    ->where('Product',$rows->Product)
                                    ->where('PPPP_Code',$plow->Barcode)
                                    ->orderBy('Purchases_Date','asc')
                                    ->first();

                            }

                        }

                    }

                    if(!empty($fifo)){

                        if($fifo->Qty == 0){



                            $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            if($NNQuntatity == 0){


                                $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            }else{



                                if($NNQuntatity >= $rows->Qty){

                                    $totCost += $fifo->Cost_Price * $rows->Qty ;

                                }else{

                                    $res=$rows->Qty - $NNQuntatity ;


                                    $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                    $totCost +=$ResdiualCost;

                                }


                            }



                        }else{


                            if($fifo->Qty >= $rows->Qty){

                                $totCost += $fifo->Cost_Price * $rows->Qty ;

                            }else{

                                $res=$rows->Qty - $fifo->Qty ;


                                $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                $totCost +=$ResdiualCost;

                            }



                        }


                    }




                    $Average=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);


                    if($rr->Rate == 1){

                        $SMallAverage=$Average;
                        $Average=$Average;
                    }else{

                        $SMallAverage=$Average;
                        $Average=$Average * $rr->Rate;
                    }








                }else{


                    $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();
                    $plow = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();





                    $Average=$average->AverageCostGet($rows->Product,$plow->Barcode,$store);



                    if($rr->Rate == 1){

                        $SMallAverage=$Average;
                        $Average=$Average;
                    }else{

                        $SMallAverage=$Average;
                        $Average=$Average * $rr->Rate;
                    }







                }







                $Cost=$Average;

                $priceO=$rr->Price * ($rows->Qty / $rr->Rate);
                $priceT=$rr->Price_Two  * ($rows->Qty / $rr->Rate);
                $priceTh=$rr->Price_Three * ($rows->Qty / $rr->Rate);


                $profit1=$priceO - ($Cost * ($rows->Qty / $rr->Rate));

                if($profit1 != 0){
                    if($Cost == 0){
                        $profitPrecent1=($profit1 * 100)  ;
                    }else{
                        $profitPrecent1=($profit1 * 100) / ($Cost * ($rows->Qty / $rr->Rate)) ;
                    }

                }else{
                    $profitPrecent1=0 ;
                }

                if(!empty($priceT)){
                    $profit2=$priceT - ($Cost * ($rows->Qty / $rr->Rate));
                    if($profit2 != 0){

                        if($Cost == 0){
                            $profitPrecent2=($profit2 * 100)  ;
                        }else{
                            $profitPrecent2=($profit2 * 100) / ($Cost * ($rows->Qty / $rr->Rate)) ;
                        }

                    }else{
                        $profitPrecent2=0 ;
                    }

                }else{
                    $profit2=0;
                    $profitPrecent2=0;
                }
                if(!empty($priceTh)){
                    $profit3=$priceTh - ($Cost * ($rows->Qty / $rr->Rate));

                    if($profit3 != 0){

                        if($Cost == 0){
                            $profitPrecent3=($profit3 * 100)  ;
                        }else{
                            $profitPrecent3=($profit3 * 100) / ($Cost * ($rows->Qty / $rr->Rate)) ;
                        }

                    }else{
                        $profitPrecent3=0 ;
                    }

                }else{
                    $profit3=0;
                    $profitPrecent3=0;
                }




                if($group != ''){
                    if($brand != ''){

                        if($rows->Product()->first()->Group == $group){
                            if($rows->Product()->first()->Brand == $brand){

                                if($rows->Store == $store){

                                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }



                                        $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>

       <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>

        <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

           <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;


                                        }


                                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
    <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

          <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';

                                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){
                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;


                                        }

                                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);
                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
         <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

    <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';


                                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                        if(app()->getLocale() == 'ar' ){
                                            $PrrroName=$rows->P_Ar_Name;
                                            $PrrroVName=$rows->V1()->first()->Name;
                                            $PrrroVVName=$rows->V2()->first()->Name;


                                        }else{
                                            $PrrroName=$rows->P_En_Name;
                                            $PrrroVName=$rows->V1()->first()->NameEn;
                                            $PrrroVVName=$rows->V2()->first()->NameEn;


                                        }


                                        $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                        foreach($units as $uni){
                                            $nam=Measuerments::find($uni->Unit);

                                            if(app()->getLocale() == 'ar' ){
                                                $UnitNamme=$nam->Name;
                                            }else{

                                                $UnitNamme=$nam->NameEn;
                                            }
                                            $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                        }

                                        $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

        <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
           <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

        <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';
                                    }

                                }

                            }
                        }

                    }else{

                        if($rows->Product()->first()->Group == $group){
                            if($rows->Store == $store){

                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }



                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>

       <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>

        <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

           <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
    <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

          <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';

                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){
                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;


                                    }

                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
         <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

    <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;


                                    }


                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

        <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
           <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

        <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';
                                }

                            }


                        }

                    }


                }else{

                    if($brand != ''){
                        if($rows->Product()->first()->Brand == $brand){

                            if($rows->Store == $store){

                                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }



                                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>

       <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>

        <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

           <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;


                                    }


                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
    <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

          <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';

                                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){
                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;


                                    }

                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
         <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

    <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';


                                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$rows->P_Ar_Name;
                                        $PrrroVName=$rows->V1()->first()->Name;
                                        $PrrroVVName=$rows->V2()->first()->Name;


                                    }else{
                                        $PrrroName=$rows->P_En_Name;
                                        $PrrroVName=$rows->V1()->first()->NameEn;
                                        $PrrroVVName=$rows->V2()->first()->NameEn;


                                    }


                                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);

                                        if(app()->getLocale() == 'ar' ){
                                            $UnitNamme=$nam->Name;
                                        }else{

                                            $UnitNamme=$nam->NameEn;
                                        }
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                    }

                                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

        <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
           <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

        <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';
                                }

                            }

                        }
                    }else{

                        if($rows->Store == $store){

                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }



                                $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value=""> '.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty / $rr->Rate.'"  disabled>
       </td>

       <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>

        <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

           <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Serial'){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;


                                }


                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
    <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

          <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>



  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';

                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){
                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;


                                }

                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);
                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

          <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
         <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

    <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>


        </tr>
            ';


                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$rows->P_Ar_Name;
                                    $PrrroVName=$rows->V1()->first()->Name;
                                    $PrrroVVName=$rows->V2()->first()->Name;


                                }else{
                                    $PrrroName=$rows->P_En_Name;
                                    $PrrroVName=$rows->V1()->first()->NameEn;
                                    $PrrroVVName=$rows->V2()->first()->NameEn;


                                }


                                $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'"  value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

                                foreach($units as $uni){
                                    $nam=Measuerments::find($uni->Unit);

                                    if(app()->getLocale() == 'ar' ){
                                        $UnitNamme=$nam->Name;
                                    }else{

                                        $UnitNamme=$nam->NameEn;
                                    }
                                    $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                                }

                                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="Qun" value="'.$rows->Qty.'"  disabled>
       </td>

        <td> <input type="text" id="PriceO'.$rows->id.'" class="Qun" value="'.$rr->Price.'"  disabled></td>
       <td> <input type="text" id="PriceT'.$rows->id.'" class="Qun" value="'.$rr->Price_Two.'"  disabled></td>
       <td> <input type="text" id="PriceTh'.$rows->id.'" class="Qun" value="'.$rr->Price_Three.'"  disabled></td>
           <td>
       <input type="text" disabled id="AVG'.$rows->id.'" value="'.number_format((float)$Average, 2, '.', '').'" >
<input type="hidden" disabled id="SMALLAVG'.$rows->id.'" value="'.number_format((float)$SMallAverage, 2, '.', '').'" >
       </td>

        <td>
<input type="text" id="COST'.$rows->id.'" disabled  class="TotCost" value="'.number_format((float)$Cost * ($rows->Qty / $rr->Rate), 2, '.', '').'" >
       </td>


  <td> <input type="text" id="TotalPriceO'.$rows->id.'" class="TotPo"  value="'.number_format((float)$priceO, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceT'.$rows->id.'" class="TotPt"  value="'.number_format((float)$priceT, 2, '.', '').'"  disabled></td>
       <td> <input type="text" id="TotalPriceTh'.$rows->id.'" class="TotPth"  value="'.number_format((float)$priceTh, 2, '.', '').'"  disabled></td>

        <td> <input type="text" id="TotalProfitO'.$rows->id.'" class="TotP1"  value="'.number_format((float)$profit1, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent1, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitT'.$rows->id.'" class="TotP2"  value="'.number_format((float)$profit2, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent2, 2, '.', '').'%)</td>

       <td> <input type="text" id="TotalProfitTh'.$rows->id.'" class="TotP3"  value="'.number_format((float)$profit3, 2, '.', '').'"  disabled>('.number_format((float)$profitPrecent3, 2, '.', '').'%)</td>

        </tr>
            ';
                            }

                        }

                    }

                }


            }


            return   $output ;
        }

        return view('admin.Reports.ExceptProfitsFilterTwo',get_defined_vars());
    }

    //ExpiredProucts
    public function ExpiredProucts(){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        return view('admin.Reports.ExpiredProucts',get_defined_vars());
    }

    public function ExpiredProuctsFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $To = $request->get('To');


        $Prods=ExpireDateQty::

        when(!empty($store), function ($query) use ($store) {
            return $query->where('Store',$store);

        })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                    ;

            })



            ->paginate(10);

        $ProdsCount=ExpireDateQty::

        when(!empty($store), function ($query) use ($store) {
            return $query->where('Store',$store);

        })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group',$group);

            })


            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->count();

        $output = '';
        if($request->ajax())
        {
            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $To = $request->get('To');

            foreach($Prods as $rows){

                if($group != ''){
                    if($To != ''){

                        if($rows->Store == $store){
                            if($rows->Product()->first()->Group == $group){
                                if($rows->Exp_Date <= $To){



                                    if(app()->getLocale() == 'ar' ){
                                        $ProoName=$rows->P_Ar_Name;

                                        if(!empty($rows->V1)){
                                            $ProoVName=$rows->V1()->first()->Name;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($rows->V2)){
                                            $ProoVVName=$rows->V2()->first()->Name;
                                        }else{
                                            $ProoVVName='';
                                        }
                                        $UniiName=$rows->Unit()->first()->Name;



                                    }else{
                                        $ProoName=$rows->P_En_Name;

                                        if(!empty($rows->V1)){
                                            $ProoVName=$rows->V1()->first()->NameEn;
                                        }else{
                                            $ProoVName='';
                                        }


                                        if(!empty($rows->V2)){
                                            $ProoVVName=$rows->V2()->first()->NameEn;
                                        }else{
                                            $ProoVVName='';
                                        }





                                    }


                                    $output .= '
       <tr>
       <td>'.$rows->P_Code.'</td>
       <td>'.$ProoName.' ('.$ProoVName.') ('.$ProoVVName.')</td>
          <td>'.$rows->Qty.'</td>
       <td>'.$rows->Exp_Date.'</td>
       </tr>';

                                }
                            }
                        }

                    }else{


                        if($rows->Store == $store){
                            if($rows->Product()->first()->Group == $group){



                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;

                                    if(!empty($rows->V1)){
                                        $ProoVName=$rows->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($rows->V2)){
                                        $ProoVVName=$rows->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$rows->Unit()->first()->Name;



                                }else{
                                    $ProoName=$rows->P_En_Name;

                                    if(!empty($rows->V1)){
                                        $ProoVName=$rows->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($rows->V2)){
                                        $ProoVVName=$rows->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }





                                }


                                $output .= '
       <tr>
       <td>'.$rows->P_Code.'</td>
       <td>'.$ProoName.' ('.$ProoVName.') ('.$ProoVVName.')</td>
          <td>'.$rows->Qty.'</td>
       <td>'.$rows->Exp_Date.'</td>
       </tr>';

                            }
                        }

                    }



                }else{

                    if($To != ''){

                        if($rows->Store == $store){
                            if($rows->Exp_Date <= $To){

                                if(app()->getLocale() == 'ar' ){
                                    $ProoName=$rows->P_Ar_Name;

                                    if(!empty($rows->V1)){
                                        $ProoVName=$rows->V1()->first()->Name;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($rows->V2)){
                                        $ProoVVName=$rows->V2()->first()->Name;
                                    }else{
                                        $ProoVVName='';
                                    }
                                    $UniiName=$rows->Unit()->first()->Name;



                                }else{
                                    $ProoName=$rows->P_En_Name;

                                    if(!empty($rows->V1)){
                                        $ProoVName=$rows->V1()->first()->NameEn;
                                    }else{
                                        $ProoVName='';
                                    }


                                    if(!empty($rows->V2)){
                                        $ProoVVName=$rows->V2()->first()->NameEn;
                                    }else{
                                        $ProoVVName='';
                                    }





                                }


                                $output .= '
       <tr>
       <td>'.$rows->P_Code.'</td>
       <td>'.$ProoName.' ('.$ProoVName.') ('.$ProoVVName.')</td>
          <td>'.$rows->Qty.'</td>
       <td>'.$rows->Exp_Date.'</td>
       </tr>';

                            }
                        }

                    }else{
                        if($rows->Store == $store){

                            if(app()->getLocale() == 'ar' ){
                                $ProoName=$rows->P_Ar_Name;

                                if(!empty($rows->V1)){
                                    $ProoVName=$rows->V1()->first()->Name;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($rows->V2)){
                                    $ProoVVName=$rows->V2()->first()->Name;
                                }else{
                                    $ProoVVName='';
                                }
                                $UniiName=$rows->Unit()->first()->Name;



                            }else{
                                $ProoName=$rows->P_En_Name;

                                if(!empty($rows->V1)){
                                    $ProoVName=$rows->V1()->first()->NameEn;
                                }else{
                                    $ProoVName='';
                                }


                                if(!empty($rows->V2)){
                                    $ProoVVName=$rows->V2()->first()->NameEn;
                                }else{
                                    $ProoVVName='';
                                }





                            }


                            $output .= '
       <tr>
       <td>'.$rows->P_Code.'</td>
       <td>'.$ProoName.' ('.$ProoVName.') ('.$ProoVVName.')</td>
          <td>'.$rows->Qty.'</td>
       <td>'.$rows->Exp_Date.'</td>
       </tr>';

                        }
                    }
                }
            }
            return   $output ;
        }
        return view('admin.Reports.ExpiredProuctsFilterTwo',get_defined_vars());
    }

//TotalDailyMoves
    public function TotalDailyMoves(){
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        return view('admin.Reports.TotalDailyMoves',get_defined_vars());
    }

    function TotalDailyMovesFilter(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $out = '';
            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            if( $safe != ''){

                $RCash=0;
                $RCashh=0;
                $RLater=0;
                $RLaterr=0;
                $RPCashh=0;
                $RPLaterr=0;
                $RPCash=0;
                $RPLater=0;

                $Purchases =Purchases::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','!=','Check')
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                $PurchCash =Purchases::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Price');


                $PurchLater =Purchases::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Later')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Pay');

                $ReturnSales =ReturnSales::orderBy('id','asc')
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                $ReturnPurch =ReturnPurch::orderBy('id','asc')
                    ->whereBetween('Date', [$from, $to])
                    ->get();


                $Sales =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','!=','Check')
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                $ReturnSales =ReturnSales::orderBy('id','asc')
                    ->whereBetween('Date', [$from, $to])
                    ->get();


                $Cash =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Price');


                $Later =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Later')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Pay');

                $CashVisa =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash_Visa')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Price');


                $Installment =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Installment')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('presenter');

                $TotSales=  $Cash + $Later +  $CashVisa+ $Installment;
                $TotPurch=  $PurchCash + $PurchLater;



                $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                $ReciptTot =ReciptVoucher::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Creditor');


                $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get();

                $PaymentTot =PaymentVoucher::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Total_Debaitor');


                $DifRP= $ReciptTot - $PaymentTot ;
                $Amount = $DifRP +   $TotSales  ;

                $Discooo =Sales::orderBy('id','asc')
                    ->where('Safe',$safe)
                    ->where('Payment_Method','Cash')
                    ->whereBetween('Date', [$from, $to])
                    ->get()->sum('Pay');

                $Disc=$Cash - $Discooo ;


            }


            $output .= '
      <tr class="Sales">
            <td>'.trans('admin.Sales').'</td>
        <td></td>
          <td></td>
    </tr>
        ';


            foreach($Sales as $sal){

                if($sal->Payment_Method == 'Cash'){

                    $bill=$sal->Total_Price;
                }elseif($sal->Payment_Method == 'Later'){

                    $bill=$sal->Pay;
                }elseif($sal->Payment_Method == 'Cash_Visa'){
                    $bill=$sal->Total_Price;

                }elseif($sal->Payment_Method == 'Installment'){
                    $bill=$sal->presenter;
                }


                if(app()->getLocale() == 'ar' ){
                    $xName=$sal->Client()->first()->Name;

                }else{
                    $xName=$sal->Client()->first()->NameEn;

                }

                $output .= '
      <tr class="Sales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

            }

            foreach($ReturnSales as $sal){

                if($sal->Sales()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $RCashh +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){


                        $RLaterr +=$sal->Pay;
                    }

                }

            }




            $All=$TotSales + $RCashh + $RLaterr;
            $output .= '
   <tr class="TotalSales">
     <td>     '.trans('admin.Total_Sales').' </td>
<td style="border: none;text-align: end;">'.$All.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="RSales">
            <td>  '.trans('admin.Return_Sales').'</td>
        <td></td>
          <td></td>
    </tr>
        ';

            foreach($ReturnSales as $sal){

                if($sal->Sales()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RLater +=$sal->Pay;
                    }

                    if(app()->getLocale() == 'ar' ){
                        $xName=$sal->Sales()->first()->Client()->first()->Name;

                    }else{
                        $xName=$sal->Sales()->first()->Client()->first()->Name;

                    }

                    $output .= '
      <tr class="RSales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

                }
            }

            $RTotSales=  $RCash + $RLater ;


            $output .= '
   <tr class="RTotalSales">
     <td>      '.trans('admin.Total_Return_Sales').' </td>
<td style="border: none;text-align: end;">'.$RTotSales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
   <tr class="TotalSales">
     <td>      '.trans('admin.Discount_Allow').' </td>
<td style="border: none;text-align: end;">'.$Disc.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $DISCOUNT=$TotSales - $Disc;

            $output .= '
   <tr class="NetSales">
     <td>       '.trans('admin.Net_Sales').' </td>
<td style="border: none;text-align: end;">'.$DISCOUNT.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Recipt">
            <td>     '.trans('admin.Recipt_Vouchers').'</td>
        <td></td>
          <td></td>
    </tr>
        ';




            foreach($ReciptVoucher as $sal){
                $VVVVV=ReciptVoucherDetails::where('RV_ID',$sal->id)->first();

                if(app()->getLocale() == 'ar' ){
                    $xName=$VVVVV->Account()->first()->Name;

                }else{
                    $xName=$VVVVV->Account()->first()->NameEn;

                }
                $output .= '
      <tr class="Recipt">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Total_Creditor.'</td>

    </tr>



        ';

            }

            $output .= '
   <tr class="TotalRecipt">
     <td>        '.trans('admin.Total_Recipt_Vouchers').'>
<td style="border: none;text-align: end;">'.$ReciptTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="Payment">
            <td>   '.trans('admin.Payment_Vouchers').'</td>
        <td></td>
          <td></td>
    </tr>
        ';

            foreach($PaymentVoucher as $sal){

                $VVVVV=PaymentVoucherDetails::where('PV_ID',$sal->id)->first();

                if(app()->getLocale() == 'ar' ){
                    $xName=$VVVVV->Account()->first()->Name;

                }else{
                    $xName=$VVVVV->Account()->first()->NameEn;

                }
                $output .= '
      <tr class="Payment">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Total_Debaitor.'</td>

    </tr>
        ';

            }


            $output .= '
   <tr class="TotalPayment">
     <td>       '.trans('admin.Total_Payment_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$PaymentTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

            $output .= '
      <tr class="Purch">
            <td>  '.trans('admin.Purchases').'</td>
        <td></td>
          <td></td>
    </tr>
        ';



            foreach($Purchases as $purch){

                if($purch->Payment_Method == 'Cash'){

                    $bill=$purch->Total_Price;
                }elseif($purch->Payment_Method == 'Later'){

                    $bill=$purch->Pay;
                }

                if(app()->getLocale() == 'ar' ){
                    $xName=$purch->Vendor()->first()->Name;

                }else{
                    $xName=$purch->Vendor()->first()->NameEn;

                }
                $output .= '
      <tr class="Purch">
                                                  <td>'.$purch->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

            }

            foreach($ReturnPurch as $retP){

                if($retP->Purchase()->first()->Safe == $safe){
                    if($retP->Payment_Method == 'Cash'){

                        $RPCashh +=$retP->Total_Return_Value;
                    }elseif($retP->Payment_Method == 'Later'){


                        $RPLaterr +=$retP->Pay;
                    }

                }

            }




            $AllP=$TotPurch + $RPCashh + $RPLaterr;
            $output .= '
   <tr class="TotalPurch">
     <td>      '.trans('admin.Total_Purchases').' </td>
<td style="border: none;text-align: end;">'.$AllP.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $output .= '
      <tr class="RPurch">
            <td>  '.trans('admin.Return_Purchases').'</td>
        <td></td>
          <td></td>
    </tr>
        ';

            foreach($ReturnPurch as $sal){

                if($sal->Purchase()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RPCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RPLater +=$sal->Pay;
                    }


                    if(app()->getLocale() == 'ar' ){
                        $xName=$sal->Purchase()->first()->Vendor()->first()->Name;

                    }else{
                        $xName=$sal->Purchase()->first()->Vendor()->first()->NameEn;

                    }
                    $output .= '
      <tr class="RPurch">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>

    </tr>
        ';

                }
            }

            $RPTotPurch=  $RPCash + $RPLater ;


            $output .= '
   <tr class="RTotalPurch">
     <td>       '.trans('admin.Total_Return_Purchases').' </td>
<td style="border: none;text-align: end;">'.$RPTotPurch.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


            $MOshtryat=$AllP - $RPTotPurch ;


            $AM=   $Amount - ($Disc + $MOshtryat) ;

            $output .= '
   <tr class="TotalSafe">
     <td>     '.trans('admin.Safe_Value').' </td>
<td style="border: none;text-align: end;">'.$AM.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



        }
        else
        {
            $output = '
       <tr>
        <td align="center" colspan="5">No Data Found</td>
       </tr>
       ';
        }


        $data = array(
            'table_data'  => $output,

        );
        echo json_encode($data);
    }


    //DelegateSalesDetails
    public function DelegateSalesDetails(){
        $Employess=Employess::type()->get();
        return view('admin.Reports.DelegateSalesDetails',get_defined_vars());
    }


    function DelegateSalesDetailsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');

            if($Client != '' ){

                $qty=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Delegate',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Qty');
                $tot=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Delegate',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');

                $Sales=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Delegate',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get();



                $cust=Employess::find($Client);



                if(!empty($cust)){
                    if(app()->getLocale() == 'ar' ){
                        $cName=$cust->Name;

                    }else{
                        $cName=$cust->NameEn;

                    }
                }else{

                    $cName='';

                }


                $output .= '
                  <thead class="bg-highlight">
                                              <tr>
                                                  <th>'.trans("admin.Delegate").' </th>
                                                  <th>'.trans("admin.Total_Qty").' </th>
                                                  <th>'.trans("admin.Total_Price").' </th>

                                              </tr>
                                          </thead>

     <tr>

      <td>
   '.$cName.'
     </td>

             <td>
   '.$qty.'
     </td>

     <td>
   '.$tot.'
     </td>


      </tr>

              <tr style="background-color:#014b2a;color:#b99400">
                                                  <th>' .trans("admin.Code").' </th>
                                                  <th>'.trans("admin.Name").' </th>
                                                  <th>'.trans("admin.Qty").' </th>
                                                  <th>'.trans("admin.Price").' </th>
                                                  <th>'.trans("admin.Total").' </th>
                                  </tr>

          ';




                foreach($Sales as $sal){

                    $output .= '            <tr>


      <td>
   '.$sal->Product_Code.'
     </td>
             <td>
   '.$sal->P_Ar_Name.' ('.$sal->VName.') ('.$sal->VVName.')
     </td>

           <td>
   '.$sal->Qty.'
     </td>
           <td>
   '.$sal->Price.'
     </td>
           <td>
   '.$sal->Total_Net.'
     </td>


      </tr>
';

                }

            }


            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //StoresSalesDetails
    public function StoresSalesDetails(){
        $Stores=Stores::type()->get();
        return view('admin.Reports.StoresSalesDetails',['Stores'=>$Stores]);
    }

    function StoresSalesDetailsFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');

            $Cli=Stores::find($Client);

            if($Client != ''  ){

                $qty=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->where('Store',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Qty');
                $tot=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->where('Store',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');

                $Sales=ProductSales::

                when(!empty($From), function ($query) use ($From,$To) {
                    return $query->whereBetween('Date',[$From,$To]);

                })

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->where('Store',$Client);

                    })

                    ->whereRelation('Sales','Edit',0)
                    ->whereRelation('Sales','Delete',0)
                    ->get();



                $cust=Stores::find($Client);

                if(!empty($cust)){
                    if(app()->getLocale() == 'ar' ){
                        $cName=$cust->Name;

                    }else{
                        $cName=$cust->NameEn;

                    }
                }else{

                    $cName='';

                }


                $output .= '
                  <thead class="bg-highlight">
                                              <tr>
                                                  <th>'.trans("admin.Store").' </th>
                                                  <th>'.trans("admin.Total_Qty").' </th>
                                                  <th>'.trans("admin.Total_Price").' </th>

                                              </tr>
                                          </thead>

     <tr>

      <td>
   '.$cName.'
     </td>

             <td>
   '.$qty.'
     </td>

     <td>
   '.$tot.'
     </td>


      </tr>

              <tr style="background-color:#014b2a;color:#b99400">
                                                  <th>' .trans("admin.Code").' </th>
                                                  <th>'.trans("admin.Name").' </th>
                                                  <th>'.trans("admin.Qty").' </th>
                                                  <th>'.trans("admin.Price").' </th>
                                                  <th>'.trans("admin.Total").' </th>
                                  </tr>

          ';




                foreach($Sales as $sal){

                    $output .= '            <tr>


      <td>
   '.$sal->Product_Code.'
     </td>
             <td>
   '.$sal->P_Ar_Name.' ('.$sal->VName.') ('.$sal->VVName.')
     </td>

           <td>
   '.$sal->Qty.'
     </td>
           <td>
   '.$sal->Price.'
     </td>
           <td>
   '.$sal->Total_Net.'
     </td>


      </tr>
';

                }

            }



            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


       //SalesOrderProductsReport
    public function SalesOrderProductsReport(){

        return view('admin.Reports.SalesOrderProductsReport');
    }

    public function SalesOrderProductsReportFilter(Request $request){

        $search = $request->get('search');
        $from = $request->get('from');
        $to = $request->get('to');
   
        

         
     $Prods = ProductSalesOrder::query()
    
        ->select('Product_Code', 'P_Ar_Name', 'P_En_Name') 
->selectRaw('SUM("product_sales_orders"."Qty"::numeric) AS total_quantity')    

    ->selectRaw('SUM("product_sales_orders"."Total_Net"::numeric) AS total_net_amount')   
        // **مرشحات التاريخ والبحث هنا...**
        ->when(!empty($from) && !empty($to), function ($query) use ($from, $to) {
            return $query->whereRelation('SalesOrder', function ($q) use ($from, $to) {
                $q->whereBetween('Date', [$from, $to]);
            });
        })
        
        ->when(!empty($search), function ($query) use ($search) {
            return $query->where(function ($subQuery) use ($search) {
                $subQuery->where('P_Ar_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name', 'ILIKE', "%{$search}%")
                    ->orWhere('Product_Code', 'ILIKE', "%{$search}%");
            });
        })
        
        // **groupBy هي المسؤولة عن عدم تكرار المنتج وضمان التجميع**
        ->groupBy('Product_Code', 'P_Ar_Name', 'P_En_Name')
        // **تم حذف ->distinct(['Product'])**
        
        ->paginate(30);
  
 
        
        $output = '';
        if($request->ajax())
        {

          $search = $request->get('search');
        $from = $request->get('from');
        $to = $request->get('to');
   


            foreach($Prods as $rows){

        
                      $output .= '

       <tr>
       <td>'.$rows->Product_Code.'</td>
       <td>'.$rows->P_Ar_Name.'</td>
       <td>'.$rows->total_quantity.'</td>
       <td>'.$rows->total_net_amount.'</td>
       </tr>
';
                
                
            }

            return   $output ;
        }

        return view('admin.Reports.SalesOrderProductsReportFilter',get_defined_vars());
    }

    
    
       //PriceShippingSalesBillReport
    public function PriceShippingSalesBillReport(){

        return view('admin.Reports.PriceShippingSalesBillReport');
    }

    

    public function PriceShippingSalesBillReportFilter(Request $request){

        $search = $request->get('search');
        $from = $request->get('from');
        $to = $request->get('to');
   
        

         
     $Products = Sales::query()
    
 
        ->when(!empty($from) && !empty($to), function ($query) use ($from, $to) {
            return $query->whereBetween('Date', [$from, $to]);
        })
        
        ->when(!empty($search), function ($query) use ($search) {
         return $query->where('Code', $search);
        });
  
 $totalPriceShipping=$Products->get()->sum('Shipping_Price');
     
     $Prods=$Products->paginate(20);    

        
        $output = '';
        if($request->ajax())
        {

          $search = $request->get('search');
        $from = $request->get('from');
        $to = $request->get('to');
   


            foreach($Prods as $rows){

                
                if($rows->Payment_Method == 'Cash'){
      $Payment_Method=trans('admin.Cash');
  }elseif ($rows->Payment_Method == 'Later'){

      $Payment_Method=trans('admin.Later');
  }elseif ($rows->Payment_Method == 'Delivery'){

      $Payment_Method=trans('admin.Delivery');
  }elseif ($rows->Payment_Method == 'Cash_Visa'){

      $Payment_Method=trans('admin.Cash_Visa');
  }elseif ($rows->Payment_Method == 'Visa'){

      $Payment_Method=trans('admin.Visa');
  }elseif ($rows->Payment_Method == 'Cash_Collection'){

      $Payment_Method=trans('admin.Cash_Collection');
  }elseif ($rows->Payment_Method == 'Check'){

      $Payment_Method=trans('admin.Check');
  }elseif ($rows->Payment_Method == 'Installment'){

      $Payment_Method=trans('admin.Installment');
  }elseif ($rows->Payment_Method == 'InstallmentCompanies'){

      $Payment_Method=trans('admin.InstallmentCompanies');
      
  }elseif ($rows->Payment_Method == 'Apps'){

      $Payment_Method=trans('admin.App');
  }

        
                      $output .= '

       <tr>
       <td>'.$rows->Code.'</td>
       <td>'.$rows->Total_Net.'</td>
       <td>'.$rows->Shipping_Price.'</td>
       <td>'.$Payment_Method.'</td>
       </tr>
';
                
                
            }

            return   $output ;
        }

        return view('admin.Reports.PriceShippingSalesBillReportFilter',get_defined_vars());
    }

        
        


    
    
    //TotalExpensesSafes
    public function TotalExpensesSafes(){
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $wf=60;
        $Accounts=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wf.'%')->where('Type',1)->get();
        $from='01/01'.date('Y');
        $to=date('Y-m-d');
        return view('admin.Reports.TotalExpensesSafes',get_defined_vars());
    }

    public function TotalExpensesSafesFilter(){
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $wf=60;
        $Accounts=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wf.'%')->where('Type',1)->get();
        $from=request('From');
        $to=request('To');
        return view('admin.Reports.TotalExpensesSafes',get_defined_vars());
    }

    //ProfitGroupsReport
    public function ProfitGroupsReport(){
        $Groups=ItemsGroups::all();
        return view('admin.Reports.ProfitGroupsReport',get_defined_vars());
    }


    function ProfitGroupsReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $From = $request->get('from');
            $To = $request->get('to');
            $group = $request->get('group');



            if($From != '' and $To  != ''and $group != ''){

                $TotalSales=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereBetween('Date',[$From,$To])->where('Group',$group)->get()->sum('Total_Net');
                $TotalCost=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereBetween('Date',[$From,$To])->where('Group',$group)->get()->sum('TotCostNew');

                $TotalSalaries=Employess::where('Pro_Group',$group)->get()->sum('Salary');

                $Debt=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                    ->join('acccounting_manuals', function ($join) {

                        $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                    })
                    ->where('acccounting_manuals.Pro_Group',$group)
                    ->get()->sum('Debitor_Coin');

                $Credtt=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                    ->join('acccounting_manuals', function ($join) {

                        $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                    })
                    ->where('acccounting_manuals.Pro_Group',$group)
                    ->get()->sum('Creditor_Coin');





                $DebtCost=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                    ->join('acccounting_manuals', function ($join) {

                        $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                    })
                    ->where('acccounting_manuals.Pro_Group',$group)
                    ->where('acccounting_manuals.id',52)
                    ->get()->sum('Debitor_Coin');

                $CredttCost=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                    ->join('acccounting_manuals', function ($join) {

                        $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                    })
                    ->where('acccounting_manuals.Pro_Group',$group)
                    ->where('acccounting_manuals.id',52)
                    ->get()->sum('Creditor_Coin');



                $DifCost=   $DebtCost - $CredttCost;
                $DifCost=  $TotalCost;
                $Dif=   $Debt - $Credtt;
                $ProfitSales=   $TotalSales - $DifCost;
                $profit=$ProfitSales -  ($TotalSalaries + $Dif) ;
                $output .= '

                                                <tr>
                                                    <th>'.$TotalSales.' </th>
                                                    <th>'.$DifCost.' </th>
                                                    <th>'.$ProfitSales.' </th>
                                                    <th>'.$TotalSalaries.' </th>
                                                    <th>'.$Dif.' </th>
                                                    <th>'.$profit.' </th>

                                                </tr>



       ';




            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }



    //AssemblyProQties

    public function AssemblyProQties(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        return view('admin.Reports.AssemblyProQties',get_defined_vars());
    }


    public function AssemblyProQtiesFilterTwo(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::type()->get();
        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Zero = $request->get('Zero');


        if(!empty($search)){



            if(!empty($group)){
                $data =ProductUnits::
                orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('Barcode','ILIKE', "%{$search}%")
                    ->where('P_Type','Assembly')
                    ->where('Group',$group)
                    ->paginate(20);
            }else{
                $data =ProductUnits::
                orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('Barcode','ILIKE', "%{$search}%")
                    ->where('P_Type','Assembly')
                    ->paginate(20);
            }





        }else{





            if(!empty($group)){
                $data =ProductUnits::
                where('P_Type','Assembly')
                    ->where('Group',$group)
                    ->paginate(20);
            }else{
                $data =ProductUnits::
                where('P_Type','Assembly')
                    ->paginate(20);
            }




        }




        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $Zero = $request->get('Zero');

            foreach($data as $rows){


                if($rows->Product()->first()->P_Type == 'Assembly' ){

                    $units=ProductUnits::where('Product',$rows->Product)->get();
                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;

                    }

                    $Asembs=AssemblyProducts::where('p_id',$rows->Product)->get();
                    $AvaliableQty=0;

                    foreach($Asembs as $asse){

                        $QuantityAv =ProductsQty::
                        where('Store',$store)
                            ->where('Product',$asse->Product)
                            ->where('P_Code',$asse->P_Code)
                            ->first();

                        if(empty($QuantityAv)){

                            $QuantityAv =ProductsQty::
                            where('Store',$store)
                                ->where('Product',$asse->Product)
                                ->where('PP_Code',$asse->P_Code)
                                ->first();

                            if(empty($QuantityAv)){

                                $QuantityAv =ProductsQty::
                                where('Store',$store)
                                    ->where('Product',$asse->Product)
                                    ->where('PPP_Code',$asse->P_Code)
                                    ->first();


                                if(empty($QuantityAv)){

                                    $QuantityAv =ProductsQty::
                                    where('Store',$store)
                                        ->where('Product',$asse->Product)
                                        ->where('PPPP_Code',$asse->P_Code)
                                        ->first();

                                }

                            }

                        }

                        if(!empty($QuantityAv)){

                            $mta7=$QuantityAv->Qty/$asse->Qty;
                            $AvaliableQty=$mta7;

                        }

                    }



                    if($Zero == 1){
                        if($AvaliableQty > 0){

                            $output .= '

       <tr>
        <td>
        '.$rows->Barcode.'
        </td>
            <td>
        '.$PrrroName.'
        </td>



            <td>

            <input type="text" class="form-control" id="AvQty'.$rows->id.'" value="'.number_format($AvaliableQty,2).'" disabled >

            </td>




        </tr>


            ';

                        }

                    }else{




                        $output .= '

       <tr>
        <td>
        '.$rows->Barcode.'
        </td>
            <td>
        '.$PrrroName.'
        </td>



            <td>

            <input type="text" class="form-control" id="AvQty'.$rows->id.'" value="'.number_format($AvaliableQty,2).'" disabled >

            </td>




        </tr>


            ';

                    }



                }




            }



            return   $output ;
        }
        return view('admin.Reports.AssemblyProQtiesFilterTwo',get_defined_vars());
    }



    //Pages
    public function ItemBalances(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.ItemBalances',get_defined_vars());
    }
    public function ItemsCostsReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.ItemsCosts',get_defined_vars());
    }

    public function ItemsMovesReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.ItemsMoves',get_defined_vars());
    }

    public function ProfitsReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Profits',get_defined_vars());
    }

    public function SalesReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Sales',get_defined_vars());
    }


    public function PurchasesReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Purchases',get_defined_vars());
    }


    public function ShiftsReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Shifts',get_defined_vars());
    }


    public function StoresReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Stores',get_defined_vars());
    }

    public function DelegatesReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Delegates',get_defined_vars());
    }


    public function ReviewReportGroup(Request $request){
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        return view('admin.Reports.Pages.Review',get_defined_vars());
    }








}
