<?php

namespace App\Http\Controllers;

use App\Models\AcccountingManual;
use App\Models\AccountsDefaultData;
use App\Models\Coins;
use App\Models\CostCenter;
use App\Models\Customers;
use App\Models\DefaultDataShowHide;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\RealStates\AbstractsContractor;
use App\Models\RealStates\ContractorsRealProjects;
use App\Models\RealStates\GoodsProductProject;
use App\Models\RealStates\GoodsProject;
use App\Models\Governrate;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\RealStates\ContractStatus;
use App\Models\RealStates\ExpensesTypeProject;
use App\Models\RealStates\PaymentssProductsRealProjects;
use App\Models\RealStates\PaymentssRealProjects;
use App\Models\RealStates\ProjectStatus;
use App\Models\RealStates\RealSateProjects;
use App\Models\RealStates\RealSateProjectsPayments;
use App\Models\SafesBanks;
use App\Models\SalesDefaultData;
use App\Models\Stores;
use App\Models\StoresMoves;
use App\Models\Taxes;
use App\Models\RealStateDefaultData;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Log;
use App\Traits\GeneralTrait;


use DB ;
class RealStatesController extends Controller
{

    use GeneralTrait;
    function __construct()
    {

        $this->middleware('permission:حالات المشاريع', ['only' => ['ProjectStatus']]);
        $this->middleware('permission:حالات العقود', ['only' => ['ContractStatus']]);
        $this->middleware('permission:مشاريع عقارات', ['only' => ['RealStateProjects']]);
        $this->middleware('permission:اضافة مشروع', ['only' => ['AddRealStateProjects']]);
        $this->middleware('permission:تقرير ارباح المشاريع', ['only' => ['ProjectProfitReport']]);

    }


    //======  ProjectStatus =======
    public function ProjectStatus(){
        $items=ProjectStatus::all();
        return view('admin.RealStates.ProjectStatus',['items'=>$items]);
    }

    public function AddProjectStatus(){
            $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'Color'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);

        try {
            DB::beginTransaction();
        

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['Color']=request('Color');
            $data['English_Name']=$english_name;

            ProjectStatus::create($data);

            $dataUser=[
                'screen_ar'=>'حالات المشاريع',
                'screen_en'=>'Project Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditProjectStatus($id){
        
             $data= $this->validate(request(),[
                'Arabic_Name'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);

        try {
            DB::beginTransaction();
       

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Color']=request('Color');
            ProjectStatus::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'حالات المشاريع',
                'screen_en'=>'Project Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }



    public function DeleteProjectStatus($id){
        try {
            DB::beginTransaction();
            $del=ProjectStatus::find($id);

            $result=RealSateProjects::where('Project_Status',$id)->count();
            if ($result != 0 ){

                session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
                return back();

            }


            $dataUser=[
                'screen_ar'=>'حالات المشاريع',
                'screen_en'=>'Project Status',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ProjectStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    //======  ContractStatus =======
    public function ContractStatus(){
        $items=ContractStatus::all();
        return view('admin.RealStates.ContractStatus',['items'=>$items]);
    }

    public function AddContractStatus(){
        
                    $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'Color'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);

        try {
            DB::beginTransaction();


            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['Color']=request('Color');
            $data['English_Name']=$english_name;

            ContractStatus::create($data);

            $dataUser=[
                'screen_ar'=>'حالات العقود',
                'screen_en'=>'Contract Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditContractStatus($id){
        
                 $data= $this->validate(request(),[
                'Arabic_Name'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);

        try {
            DB::beginTransaction();
   

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Color']=request('Color');
            ContractStatus::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'حالات العقود',
                'screen_en'=>'Contract Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteContractStatus($id){
        try {
            DB::beginTransaction();
            $del=ContractStatus::find($id);

            $result=RealSateProjects::where('Contract_Status',$id)->count();
            if ($result != 0 ){

                session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
                return back();

            }


            $dataUser=[
                'screen_ar'=>'حالات العقود',
                'screen_en'=>'Contract Status',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ContractStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


//Projects

    public function RealStateProjects(){


        if(auth()->guard('admin')->user()->emp != 0){

            $items=RealSateProjects::latest('id')->where('Reponsible',auth()->guard('admin')->user()->emp)->paginate(30);
        }else{
            $items=RealSateProjects::latest('id')->paginate(30);
        }

        return view('admin.RealStates.Projects',get_defined_vars());
    }

    public function AddRealStateProjects(){

        $Code=$this->ReturnCode(RealSateProjects::class);

        $Manager=Employess::type()->where('Emp_Type','Manager')->get();
        $Reponsible=Employess::type()->get();
        $Store=Stores::all();
        $Cost_Center=CostCenter::all();
        $Contract_Status=ContractStatus::all();
        $Project_Status=ProjectStatus::all();
        $Governrates=Governrate::all();
        $Coins=Coins::all();
        $CodeUser=$this->ReturnCode(Customers::class);

        $Def=RealStateDefaultData::latest('id')->first();
        return view('admin.RealStates.AddProjects',get_defined_vars());
    }

    public function PostAddRealStatesProject(Request $request){
        
                    $data= $this->validate(request(),[
                'Name'=>'required',
                'Value'=>'required',
                'Client'=>'required',
                'Manager'=>'required',
                'Reponsible'=>'required',
                'Store'=>'required',
              


            ]);



        try {
            DB::beginTransaction();




            $Project_File=request()->file('Project_File');
            $NewPFile=$this->UploadFile($Project_File);
            if(!empty($NewPFile)){

                $PFile=$NewPFile;

            }else{

                $PFile=null;
            }

            $Contract_File=request()->file('Contract_File');
            $NewCFile=$this->UploadFile($Contract_File);
            if(!empty($NewCFile)){

                $CFile=$NewCFile;

            }else{

                $CFile=null;
            }




            $Client_Account=Customers::find(request('Client'))->Account;

            $AccountManual=AcccountingManual::where('Name','مصاريف مشاريع')->first();
            $Acc=$this->CreateAccountMain(request('Name'),request('Name') ,$AccountManual->id ,null);
            $AccGoods=$this->CreateAccount(request('Name').'  بضاعة مشروع  ',request('Name').' Project Goods ' ,$Acc ,null);

            $AccMkwal=$this->CreateAccountMain(request('Name').' مصاريف مقاولين  ',request('Name').'  Contractors Expenses ' ,$Acc ,null);


            $ID = DB::table('real_sate_projects')->insertGetId(
                array(

                    'Code' =>request('Code'),
                    'Name' =>request('Name'),
                    'Start_Date' =>request('Start_Date'),
                    'End_Date' =>request('End_Date'),
                    'Period' =>request('Period'),
                    'Value' =>request('Value'),
                    'Expect_Cost' =>request('Expect_Cost'),
                    'Expect_Profit' =>request('Expect_Profit'),
                    'Project_File' =>$PFile,
                    'Contract_File' =>$CFile,
                    'Contract_Type' =>request('Contract_Type'),
                    'Completed' =>0,
                    'Account' =>$Acc,
                    'Goods_Account' =>$AccGoods,
                    'Client' =>request('Client'),
                    'Client_Account' =>$Client_Account,
                    'Contractor_Account' =>$AccMkwal,
                    'Manager' =>request('Manager'),
                    'Reponsible' =>request('Reponsible'),
                    'Store' =>request('Store'),
                    'Cost_Center' =>request('Cost_Center'),
                    'Contract_Status' =>request('Contract_Status'),
                    'Project_Status' =>request('Project_Status'),
                    'Governrate' =>request('Governrate'),
                    'City' =>request('City'),
                    'Place' =>request('Place'),
                    'Location' =>request('Location'),
                    'Address_Details' =>request('Address_Details'),



                )
            );



            if(!empty(request('Date'))){

                $date=request('Date');
                $value=request('Value_Payment');

                for($i=0 ; $i< count($date) ; $i++){

                    $data['Date']=$date[$i];
                    $data['Value']=$value[$i];
                    $data['Status']=0;
                    $data['Project']=$ID;
                    RealSateProjectsPayments::create($data);

                }

            }




            $dataUser=[
                'screen_ar'=>'مشاريع عقارات',
                'screen_en'=>'Real States Projects',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));

        return back();




        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }

    public function DeleteRealProjects($id){
        try {
            DB::beginTransaction();
            $del=RealSateProjects::find($id);

            $result1=PaymentVoucher::where('Project',$id)->count();
            $result2=ExpensesTypeProject::where('Project',$id)->count();
            $result3=GoodsProject::where('Project',$id)->count();
            $result4=PaymentssRealProjects::where('Project',$id)->count();

            $result=$result1 + $result2 + $result3 + $result4;

            if ($result != 0 ){

                session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
                return back();

            }



            AcccountingManual::where('id',$del->Contractor_Account)->delete();
            AcccountingManual::where('id',$del->Goods_Account)->delete();
            AcccountingManual::where('id',$del->Account)->delete();


            $Contractors=ContractorsRealProjects::where('Project',$id)->get();
foreach($Contractors as $Contractor){

    AcccountingManual::where('id',$Contractor->Merit_Account)->delete();
    AcccountingManual::where('id',$Contractor->Expenses_Account)->delete();

}






            $dataUser=[
                'screen_ar'=>'مشاريع عقارات',
                'screen_en'=>'Real States Projects',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function CompletedRealProjects($id){
        try {
            DB::beginTransaction();

            RealSateProjects::where('id',$id)->update(['Completed'=>1]);

            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function UnCompletedRealProjects($id){
        try {
            DB::beginTransaction();

            RealSateProjects::where('id',$id)->update(['Completed'=>0]);

            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    public function EditRealProjects($id){


        $item=RealSateProjects::find($id);
        $payments=RealSateProjectsPayments::where('Project',$id)->get();
        $Manager=Employess::type()->where('Emp_Type','Manager')->get();
        $Reponsible=Employess::type()->get();
        $Store=Stores::all();
        $Cost_Center=CostCenter::all();
        $Contract_Status=ContractStatus::all();
        $Project_Status=ProjectStatus::all();
        $Governrates=Governrate::all();
        $Coins=Coins::all();


        return view('admin.RealStates.EditProjects',get_defined_vars());
    }

    public function PostEditRealProjects(Request $request,$id){
        
            $data= $this->validate(request(),[
                'Name'=>'required',
                'Value'=>'required',
                'Client'=>'required',
                'Manager'=>'required',
                'Reponsible'=>'required',
                'Store'=>'required',
               


            ]);



        try {
            DB::beginTransaction();


        

            $Project_File=request()->file('Project_File');
            $NewPFile=$this->UploadFile($Project_File);
            if(!empty($NewPFile)){

                $PFile=$NewPFile;

            }else{

                $PFile=request('Project_Files');
            }

            $Contract_File=request()->file('Contract_File');
            $NewCFile=$this->UploadFile($Contract_File);
            if(!empty($NewCFile)){

                $CFile=$NewCFile;

            }else{

                $CFile=request('Contract_Files');
            }


            $item=RealSateProjects::find($id);

    AcccountingManual::where('id',$item->Account)->update(['Name'=>request('Name'),'NameEn'=>request('Name')]);
    AcccountingManual::where('id',$item->Goods_Account)->update(['Name'=>request('Name').'  بضاعة مشروع  ','NameEn'=>request('Name').' Project Goods ']);
    AcccountingManual::where('id',$item->Contractor_Account)->update(['Name'=>request('Name').' مصاريف مقاولين ','NameEn'=>request('Name').' Contractors Expenses ']);
            $Client_Account=Customers::find(request('Client'))->Account;


                    $newData['Code'] =request('Code');
                    $newData['Name'] =request('Name');
                    $newData['Start_Date'] =request('Start_Date');
                    $newData['End_Date'] =request('End_Date');
                    $newData['Period'] =request('Period');
                    $newData['Value'] =request('Value');
                    $newData['Expect_Cost'] =request('Expect_Cost');
                    $newData['Expect_Profit'] =request('Expect_Profit');
                    $newData['Project_File'] =$PFile;
                    $newData['Contract_File'] =$CFile;
                    $newData['Contract_Type'] =request('Contract_Type');
                    $newData['Client'] =request('Client');
                    $newData['Client_Account'] =$Client_Account;
                    $newData['Manager'] =request('Manager');
                    $newData['Reponsible'] =request('Reponsible');
                    $newData['Store'] =request('Store');
                    $newData['Cost_Center'] =request('Cost_Center');
                    $newData['Contract_Status'] =request('Contract_Status');
                    $newData['Project_Status'] =request('Project_Status');
                    $newData['Governrate'] =request('Governrate');
                    $newData['City'] =request('City');
                    $newData['Place'] =request('Place');
                    $newData['Location'] =request('Location');
                    $newData['Address_Details'] =request('Address_Details');


                    RealSateProjects::where('id',$id)->update($newData);


            if(!empty(request('Date'))){

                RealSateProjectsPayments::where('Project',$id)->delete();

                $date=request('Date');
                $value=request('Value_Payment');

                for($i=0 ; $i< count($date) ; $i++){

                    $data['Date']=$date[$i];
                    $data['Value']=$value[$i];
                    $data['Status']=0;
                    $data['Project']=$id;
                    RealSateProjectsPayments::create($data);

                }

            }




            $dataUser=[
                'screen_ar'=>'مشاريع عقارات',
                'screen_en'=>'Real States Projects',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Updated'));

             return redirect('RealStateProjects');


        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }


//ExpensesRealProjects
    public function ExpensesRealProjects($id){
            $item=RealSateProjects::find($id);
        return view('admin.RealStates.ExpensesProject',get_defined_vars());
    }

    public function ExpensesVoucherProject($id){

        $items=PaymentVoucher::where('Project',$id)->paginate(20);
        $data=RealSateProjects::find($id);
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Accounts=AcccountingManual::where('Type',1)->where('Parent',$data->Account)->lazy();

        return view('admin.RealStates.ExpensesVoucherProject',get_defined_vars());
    }

    public function PostExpensesVoucher(){

        try {
            DB::beginTransaction();
        $project=RealSateProjects::find(request('Project'));
        $Branch=SafesBanks::where('Account',request('Safe'))->latest('id')->first()->Branch;

        $IDD = DB::table('payment_vouchers')->insertGetId(

            array(


                'Date' => date('Y-m-d'),
                'Draw' => request('Draw'),
                'Coin' => request('Coin'),
                'Safe' => request('Safe'),
                'Project' => request('Project'),
                'Cost_Center' => $project->Cost_Center,
                'Total_Debaitor' =>request('Debaitor'),
                'Note' =>null,
                'Responsiple' =>$project->Responsiple,
                'Branch'=>$Branch,
                'Status' =>1,
                'File' => null,

            )
        );


            $PRODUCTS['PV_ID']=$IDD;
            $PRODUCTS['Debitor']=request('Debaitor');
            $PRODUCTS['Account']=request('Account');
            $PRODUCTS['Statement']=request('Statement');

            $PRODUCTS['Date']=date('Y-m-d');
            $PRODUCTS['Time']=date("h:i:s a", time());
            $PRODUCTS['Cost_Center']=$project->Cost_Center;
            $PRODUCTS['Coin']=request('Coin');
            $PRODUCTS['User']=auth()->guard('admin')->user()->id;
            $PRODUCTS['Branch']=$Branch;
            $PRODUCTS['Safe']=request('Safe');

            PaymentVoucherDetails::create($PRODUCTS);


        $Code=PaymentVoucher::findOrFail($IDD)->Code;

        $Draw=request('Draw');
$Coin=request('Coin');
$Debitor=request('Debaitor');
$AccountCodee=request('Account');
$STATEMENT=request('Statement');
$Safe=request('Safe');




        $ID = DB::table('journalizings')->insertGetId(



            array(

                'Type' => 'سند صرف',
                'TypeEn' => 'Payment Voucher',
                'Code_Type' => $Code,
                'Date' => date('Y-m-d'),
                'Draw' => $Draw,
                'Coin' => $Coin,
                'Cost_Center' => null,
                'Total_Debaitor' => $Debitor,
                'Total_Creditor' =>$Debitor,
                'Note' => null,

            )
        );


        $Codee=Journalizing::findOrFail($ID)->Code;

        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=$Debitor;
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$AccountCodee;
        $PRODUCTSS['Statement']=$STATEMENT;


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Codee;
        $Gen['Code_Type']=$Code;
        $Gen['Date']=date('Y-m-d');
        $Gen['Type']='سند صرف';
        $Gen['TypeEn']='Payment Voucher';
        $Gen['Debitor']=$Debitor;
        $Gen['Creditor']=0;
        $Gen['Statement']=$STATEMENT;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * $Debitor;
        $Gen['Creditor_Coin']=$Draw * 0;
        $Gen['Account']=$AccountCodee;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);



        $PRODUCTSSS['Joun_ID']=$ID;
        $PRODUCTSSS['Debitor']=0;
        $PRODUCTSSS['Creditor']=$Debitor;
        $PRODUCTSSS['Account']=$Safe;
        $PRODUCTSSS['Statement']=$STATEMENT;
        JournalizingDetails::create($PRODUCTSSS);

        $Genn['Code']=$Codee;
        $Genn['Code_Type']=$Code;
        $Genn['Date']=date('Y-m-d');
        $Genn['Type']='سند صرف';
        $Genn['TypeEn']='Payment Voucher';
        $Genn['Debitor']=0;
        $Genn['Creditor']=$Debitor;
        $Genn['Statement']=$STATEMENT;
        $Genn['Draw']=$Draw;
        $Genn['Debitor_Coin']= $Draw * 0;
        $Genn['Creditor_Coin']=$Draw * $Debitor;
        $Genn['Account']=$Safe;
        $Genn['Coin']= $Coin;
        $Genn['Cost_Center']= null;
        $Genn['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Genn);

            DB::commit();
        return back();

        }catch(\Exception $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RealSateProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function ExpensesTypeProject($id){

        $items=ExpensesTypeProject::where('Project',$id)->paginate(20);
        $data=RealSateProjects::find($id);

        return view('admin.RealStates.ExpensesTypeProject',get_defined_vars());
    }

    public function AddExpensesTypeProject(){
        
             $data= $this->validate(request(),[
                'Arabic_Name'=>'required',



            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);


        try {
            DB::beginTransaction();
       

            $project=RealSateProjects::find(request('Project'));



            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $Acc=$this->CreateAccount(request('Arabic_Name'),$english_name ,$project->Account ,null);


            $data['Arabic_Name']=request('Arabic_Name');
            $data['Project']=request('Project');
            $data['Account']=$Acc;
            $data['English_Name']=$english_name;

            ExpensesTypeProject::create($data);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditExpensesTypeProject($id){
        
                $data= $this->validate(request(),[
                'Arabic_Name'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);


        try {
            DB::beginTransaction();
    

            $item=ExpensesTypeProject::find($id);

            AcccountingManual::where('id',$item->Account)->update(['Name'=>request('Arabic_Name'),'NameEn'=>request('English_Name')]);

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Project']=request('Project');
            ExpensesTypeProject::where('id',$id)->update($data);


            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteExpensesTypeProject($id){
        try {
            DB::beginTransaction();
            $del=ExpensesTypeProject::find($id);

            AcccountingManual::where('id',$del->Account)->delete();


            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    //GoodsRealProjects
    public function GoodsRealProjects($id){
        $data=RealSateProjects::find($id);
        $items=GoodsProject::where('Project',$id)->paginate(40);
        return view('admin.RealStates.GoodsProject',get_defined_vars());
    }

    public function AddGoodsProject($id){

        $Code=$this->ReturnCode(GoodsProject::class);
        $data=RealSateProjects::find($id);
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Reponsible=Employess::type()->get();
        $Coins=Coins::all();
        return view('admin.RealStates.AddGoodsProject',get_defined_vars());
    }

    function GoodsProductsFilter(Request $request,Average $average)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');


            if($search != '' and $store != '')
            {

                $Prods=$this->FilterSalesProductQty($search,$store,null,null);

            }

            $total_row = $Prods->count();
            if($total_row > 0)
            {

                foreach($Prods as $rows){
                    if($rows->Qty != 0){
                        if($rows->Store == $store){


                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial'){

                                if($rows->Product()->first()->Status == 0){

                                    $units=ProductUnits::where('Product',$rows->Product)->get();
                                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                                    $costPrice=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);


                                    $output .= '

       <tr id="Row'.$rows->id.'">
        <td>
        '.$rows->P_Ar_Name.'
 <input type="hidden"  id="P_Ar_Name'.$rows->id.'" value="'.$rows->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$rows->id.'" value="'.$rows->P_En_Name.'">
        <input type="hidden"  id="Product'.$rows->id.'" value="'.$rows->Product.'">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$rows->id.'" onchange="UnitCodePurchh('.$rows->id.')">
                <option value=""> اختر وحده</option>
              ';

                                    foreach($units as $uni){
                                        $nam=Measuerments::find($uni->Unit);
                                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$nam->Name.'</option>
                 ';


                                    }

                                    $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$rows->id.'" value="'.$rr->Unit()->first()->Name.'">
        </td>

                 <td>
        <input type="number" id="AvQty'.$rows->id.'" disabled  class="form-control" value="'.$rows->Qty.'" >

        </td>

        <td>
        <input type="number" id="Qty'.$rows->id.'"   class="form-control" value="1" onclick="ChangeQty('.$rows->id.')" onkeyup="ChangeQty('.$rows->id.')" >
        <input type="hidden" id="Price'.$rows->id.'"   class="form-control" value="'.$costPrice.'" >
        <input type="hidden" id="Total'.$rows->id.'"   class="form-control" value="'.$costPrice.'" >

        </td>



        <td>
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$rows->id.'" onclick="Fun('.$rows->id.')" style="display: none">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';
                                }

                            }




                        }
                    }

                }

            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد صنف كهذا</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    public function PostAddGoodsProject(Average $average){

        try {
            DB::beginTransaction();
            $project=RealSateProjects::find(request('Project'));

            $IDD = DB::table('goods_projects')->insertGetId(

                array(

                    'Code' => request('Code'),
                    'Date' => date('Y-m-d'),
                    'Store' => request('Store'),
                    'Cost_Center' => request('Cost_Center'),
                    'Responsible' => request('Responsible'),
                    'Safe' => request('Safe'),
                    'Coin' => request('Coin'),
                    'Draw' => request('Draw'),
                    'Note' => request('Note'),
                    'Project' => request('Project'),
                    'Product_Numbers' => request('Product_Numbers'),
                    'Total_Qty' => request('Total_Qty'),
                    'Total_Price' => request('Total_Price'),
                )
            );




            if(!empty(request('Qty'))){

                $Product=request('Product');
                $P_Code=request('P_Code');
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $Unit=request('Unit');
                $Qty=request('Qty');
                $AvQty=request('AvQty');
                $Price=request('Price');
                $Total=request('Total');

                for($i=0;$i< count($Qty);$i++){

                    $data['Product']=$Product[$i];
                    $data['P_Code']=$P_Code[$i];
                    $data['P_Ar_Name']=$P_Ar_Name[$i];
                    $data['P_En_Name']=$P_En_Name[$i];
                    $data['Unit']=$Unit[$i];
                    $data['Qty']=$Qty[$i];
                    $data['AvQty']=$AvQty[$i];
                    $data['Price']=$Price[$i];
                    $data['Total']=$Total[$i];
                    $data['Goods']=$IDD;
                    GoodsProductProject::create($data);


                    $Quantity=$this->ProAvQties(request('Store'),$Product[$i],$P_Code[$i]);
                    $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                    $qq= $unit->Rate * $Qty[$i] ;
                    $newqty=$Quantity->Qty -  $qq ;

                    $ty=$Price[$i];


                    $CostTotalSale=$ty ;
                    $prooooo=Products::findOrFail($Product[$i]);
                    $in=0;
                    $out=$CostTotalSale;
                    $current= $newqty *  ($ty / $unit->Rate);
                    $cur=$newqty * ($ty / $unit->Rate) ;


                    ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $Price[$i], 'TotalCost' => $cur]);
                    //Products Moves
                    $move = [

                        'Date' =>date('Y-m-d'),
                        'Type' => 'صرف بضاعة مشاريع',
                        'TypeEn' => 'Goods Project',
                        'Bill_Num' => request('Code'),
                        'Incom' => 0,
                        'Outcom' => $qq,
                        'Current' => $newqty,
                        'CostIn' => number_format((float)$in, 2, '.', ''),
                        'CostOut' => number_format((float)$out, 2, '.', ''),
                        'CostCurrent' => number_format((float)$current, 2, '.', ''),
                        'P_Ar_Name' => $P_Ar_Name[$i],
                        'P_En_Name' => $P_En_Name[$i],
                        'P_Code' => $P_Code[$i],
                        'Unit' => $Unit[$i],
                        'Qty' => $Qty[$i],
                        'Group' => $prooooo->Group,
                        'Store' => request('Store'),
                        'Product' => $Product[$i],
                        'V1' => null,
                        'V2' => null,
                        'Brand' => $prooooo->Brand,
                        'Safe' => request('Safe'),
                        'Branch' => null,
                        'SalePrice' => $Price[$i],
                        'ProductPrice' => null,
                        'Delegate' => request('Responsible'),
                        'Payment_Method' => null,
                        'User' => auth()->guard('admin')->user()->id,

                    ];

                    $this->ProductMoves($move);




                }

            }


            $Code=request('Code');

            $Draw=request('Draw');
$Coin=request('Coin');
$Debitor=request('Total_Price');

$store=Stores::findOrFail(request('Store'));

            $ID = DB::table('journalizings')->insertGetId(



                array(

                    'Type' => 'صرف بضاعة مشاريع',
                    'TypeEn' => 'Goods Project',
                    'Code_Type' => $Code,
                    'Date' => date('Y-m-d'),
                    'Draw' => $Draw,
                    'Coin' => $Coin,
                    'Cost_Center' => null,
                    'Total_Debaitor' => $Debitor,
                    'Total_Creditor' =>$Debitor,
                    'Note' => null,

                )
            );


            $Codee=Journalizing::findOrFail($ID)->Code;

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=$Debitor;
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$project->Goods_Account;
            $PRODUCTSS['Statement']=request('Note');


            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Codee;
            $Gen['Code_Type']=$Code;
            $Gen['Date']=date('Y-m-d');
            $Gen['Type']='صرف بضاعة مشاريع';
            $Gen['TypeEn']='Goods Project';
            $Gen['Debitor']=$Debitor;
            $Gen['Creditor']=0;
            $Gen['Statement']=request('Note');
            $Gen['Draw']=$Draw;
            $Gen['Debitor_Coin']= $Draw * $Debitor;
            $Gen['Creditor_Coin']=$Draw * 0;
            $Gen['Account']=$project->Goods_Account;
            $Gen['Coin']= $Coin;
            $Gen['Cost_Center']= null;
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);



            $PRODUCTSSS['Joun_ID']=$ID;
            $PRODUCTSSS['Debitor']=0;
            $PRODUCTSSS['Creditor']=$Debitor;
            $PRODUCTSSS['Account']=$store->Account;
            $PRODUCTSSS['Statement']=request('Note');
            JournalizingDetails::create($PRODUCTSSS);

            $Genn['Code']=$Codee;
            $Genn['Code_Type']=$Code;
            $Genn['Date']=date('Y-m-d');
            $Genn['Type']='صرف بضاعة مشاريع';
            $Genn['TypeEn']='Goods Project';
            $Genn['Debitor']=0;
            $Genn['Creditor']=$Debitor;
            $Genn['Statement']=request('Note');
            $Genn['Draw']=$Draw;
            $Genn['Debitor_Coin']= $Draw * 0;
            $Genn['Creditor_Coin']=$Draw * $Debitor;
            $Genn['Account']=$store->Account;
            $Genn['Coin']= $Coin;
            $Genn['Cost_Center']= null;
            $Genn['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Genn);

            $dataStMove=[

                'Date'=>date('Y-m-d'),
                'Code'=>request('Code') ,
                'Time'=>date("h:i:s a", time()),
                'Branch'=>null,
                'Store'=>request('Store'),
                'Safe'=>request('Safe'),
                'Type' => 'صرف بضاعة مشاريع',
                'TypeEn' => 'Goods Project',
                'Cost_Center'=>request('Cost_Center'),
                'User'=>auth()->guard('admin')->user()->id,
                'Coin'=>request('Coin'),
                'Note'=>request('Note'),
                'Total_Qty'=>request('Total_Qty'),
                'Total_Price'=>request('Total_Price'),
                'Account'=>null,
                'Ship'=>null,
                'ID'=>$IDD,

            ];

            $this->StoresMoves($dataStMove);




            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            if(request('SP') == 0){  return back(); }elseif(request('SP') == 1){  return redirect('GoodsProjectPrint/'.$ID); }



        }catch(\Exception $ex){

            $MODEL=GoodsProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=GoodsProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function GoodsProjectPrint($id){

        $item=GoodsProject::find($id);
        return view('admin.RealStates.GoodsProjectPrint',get_defined_vars());
    }

    public function EditGoodsProject($id){

        $Code=$this->ReturnCode(GoodsProject::class);
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Reponsible=Employess::type()->get();
        $Coins=Coins::all();
        $item=GoodsProject::find($id);
        $Products=GoodsProductProject::where('Goods',$item->id)->get();
        return view('admin.RealStates.EditGoodsProject',get_defined_vars());
    }
    public function PostEditGoodsProject(Average $average){

        try {
            DB::beginTransaction();
            $project=RealSateProjects::find(request('Project'));

            $IDD=request('ID');

                    $proj['Code'] = request('Code');
                    $proj['Date'] = date('Y-m-d');
                    $proj['Store'] = request('Store');
                    $proj['Cost_Center'] = request('Cost_Center');
                    $proj['Responsible'] = request('Responsible');
                    $proj['Safe'] = request('Safe');
                    $proj['Coin'] = request('Coin');
                    $proj['Draw'] = request('Draw');
                    $proj['Note'] = request('Note');
                    $proj['Project'] = request('Project');
                    $proj['Product_Numbers'] = request('Product_Numbers');
                    $proj['Total_Qty'] = request('Total_Qty');
                    $proj['Total_Price'] = request('Total_Price');

                    GoodsProject::where('id',$IDD)->update($proj);


            $Products=GoodsProductProject::where('Goods',$IDD)->get();

            foreach($Products as $prod){

                if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly' and $prod->P_Type != 'Variable_Aggregate'){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                    $qq= $unit->Rate * $prod->Qty ;

                    $PR = $this->ProAvQties(request('Store'), $prod->Product, $prod->P_Code);

                    if(!empty($PR)){
                        $newqty=$PR->Qty + $qq ;

                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                    }

                    ProductMoves::where('Type', 'صرف بضاعة مشاريع')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->P_Code)
                        ->where('Bill_Num', $prod->Goods()->first()->Code)
                        ->update(['Edit' => 1]);

                }
            }

            GeneralDaily::where('Code_Type',request('Code'))->where('Type','صرف بضاعة مشاريع')->delete();
            Journalizing::where('Code_Type',request('Code'))->where('Type','صرف بضاعة مشاريع')->update(['Edit'=>1]);
            StoresMoves::where('ID',$IDD)->where('Type','صرف بضاعة مشاريع')->update(['Edit'=>1]);



            if(!empty(request('Qty'))){

                GoodsProductProject::where('Goods',$IDD)->delete();

                $Product=request('Product');
                $P_Code=request('P_Code');
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $Unit=request('Unit');
                $Qty=request('Qty');
                $AvQty=request('AvQty');
                $Price=request('Price');
                $Total=request('Total');

                for($i=0;$i< count($Qty);$i++){

                    $data['Product']=$Product[$i];
                    $data['P_Code']=$P_Code[$i];
                    $data['P_Ar_Name']=$P_Ar_Name[$i];
                    $data['P_En_Name']=$P_En_Name[$i];
                    $data['Unit']=$Unit[$i];
                    $data['Qty']=$Qty[$i];
                    $data['AvQty']=$AvQty[$i];
                    $data['Price']=$Price[$i];
                    $data['Total']=$Total[$i];
                    $data['Goods']=$IDD;
                    GoodsProductProject::create($data);


                    $Quantity=$this->ProAvQties(request('Store'),$Product[$i],$P_Code[$i]);
                    $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                    $qq= $unit->Rate * $Qty[$i] ;
                    $newqty=$Quantity->Qty -  $qq ;

                    $ty=$Price[$i];


                    $CostTotalSale=$ty ;
                    $prooooo=Products::findOrFail($Product[$i]);
                    $in=0;
                    $out=$CostTotalSale;
                    $current= $newqty *  ($ty / $unit->Rate);
                    $cur=$newqty * ($ty / $unit->Rate) ;


                    ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $Price[$i], 'TotalCost' => $cur]);
                    //Products Moves
                    $move = [

                        'Date' =>date('Y-m-d'),
                        'Type' => 'صرف بضاعة مشاريع',
                        'TypeEn' => 'Goods Project',
                        'Bill_Num' => request('Code'),
                        'Incom' => 0,
                        'Outcom' => $qq,
                        'Current' => $newqty,
                        'CostIn' => number_format((float)$in, 2, '.', ''),
                        'CostOut' => number_format((float)$out, 2, '.', ''),
                        'CostCurrent' => number_format((float)$current, 2, '.', ''),
                        'P_Ar_Name' => $P_Ar_Name[$i],
                        'P_En_Name' => $P_En_Name[$i],
                        'P_Code' => $P_Code[$i],
                        'Unit' => $Unit[$i],
                        'Qty' => $Qty[$i],
                        'Group' => $prooooo->Group,
                        'Store' => request('Store'),
                        'Product' => $Product[$i],
                        'V1' => null,
                        'V2' => null,
                        'Brand' => $prooooo->Brand,
                        'Safe' => request('Safe'),
                        'Branch' => null,
                        'SalePrice' => $Price[$i],
                        'ProductPrice' => null,
                        'Delegate' => request('Responsible'),
                        'Payment_Method' => null,
                        'User' => auth()->guard('admin')->user()->id,

                    ];

                    $this->ProductMoves($move);




                }

            }


            $Code=request('Code');

            $Draw=request('Draw');
            $Coin=request('Coin');
            $Debitor=request('Total_Price');

            $store=Stores::findOrFail(request('Store'));

            $ID = DB::table('journalizings')->insertGetId(



                array(

                    'Type' => 'صرف بضاعة مشاريع',
                    'TypeEn' => 'Goods Project',
                    'Code_Type' => $Code,
                    'Date' => date('Y-m-d'),
                    'Draw' => $Draw,
                    'Coin' => $Coin,
                    'Cost_Center' => null,
                    'Total_Debaitor' => $Debitor,
                    'Total_Creditor' =>$Debitor,
                    'Note' => null,

                )
            );


            $Codee=Journalizing::findOrFail($ID)->Code;

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=$Debitor;
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$project->Goods_Account;
            $PRODUCTSS['Statement']=request('Note');


            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Codee;
            $Gen['Code_Type']=$Code;
            $Gen['Date']=date('Y-m-d');
            $Gen['Type']='صرف بضاعة مشاريع';
            $Gen['TypeEn']='Goods Project';
            $Gen['Debitor']=$Debitor;
            $Gen['Creditor']=0;
            $Gen['Statement']=request('Note');
            $Gen['Draw']=$Draw;
            $Gen['Debitor_Coin']= $Draw * $Debitor;
            $Gen['Creditor_Coin']=$Draw * 0;
            $Gen['Account']=$project->Goods_Account;
            $Gen['Coin']= $Coin;
            $Gen['Cost_Center']= null;
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);



            $PRODUCTSSS['Joun_ID']=$ID;
            $PRODUCTSSS['Debitor']=0;
            $PRODUCTSSS['Creditor']=$Debitor;
            $PRODUCTSSS['Account']=$store->Account;
            $PRODUCTSSS['Statement']=request('Note');
            JournalizingDetails::create($PRODUCTSSS);

            $Genn['Code']=$Codee;
            $Genn['Code_Type']=$Code;
            $Genn['Date']=date('Y-m-d');
            $Genn['Type']='صرف بضاعة مشاريع';
            $Genn['TypeEn']='Goods Project';
            $Genn['Debitor']=0;
            $Genn['Creditor']=$Debitor;
            $Genn['Statement']=request('Note');
            $Genn['Draw']=$Draw;
            $Genn['Debitor_Coin']= $Draw * 0;
            $Genn['Creditor_Coin']=$Draw * $Debitor;
            $Genn['Account']=$store->Account;
            $Genn['Coin']= $Coin;
            $Genn['Cost_Center']= null;
            $Genn['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Genn);

            $dataStMove=[

                'Date'=>date('Y-m-d'),
                'Code'=>request('Code') ,
                'Time'=>date("h:i:s a", time()),
                'Branch'=>null,
                'Store'=>request('Store'),
                'Safe'=>request('Safe'),
                'Type' => 'صرف بضاعة مشاريع',
                'TypeEn' => 'Goods Project',
                'Cost_Center'=>request('Cost_Center'),
                'User'=>auth()->guard('admin')->user()->id,
                'Coin'=>request('Coin'),
                'Note'=>request('Note'),
                'Total_Qty'=>request('Total_Qty'),
                'Total_Price'=>request('Total_Price'),
                'Account'=>null,
                'Ship'=>null,
                'ID'=>$IDD,

            ];

            $this->StoresMoves($dataStMove);

            DB::commit();
            session()->flash('success',trans('admin.Updated'));

            $id=request('Project');
           return redirect('GoodsRealProjects/'.$id);

        }catch(\Exception $ex){

            $MODEL=GoodsProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=GoodsProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }
    public function DeleteGoodsProject($id){
        try {
            DB::beginTransaction();
            $del=GoodsProject::find($id);



            $Products=GoodsProductProject::where('Goods',$id)->get();

            foreach($Products as $prod){



                if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly' and $prod->P_Type != 'Variable_Aggregate'){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                    $qq= $unit->Rate * $prod->Qty ;

                    $PR = $this->ProAvQties($del->Store, $prod->Product, $prod->P_Code);

                    if(!empty($PR)){
                        $newqty=$PR->Qty + $qq ;

                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                    }

                        ProductMoves::where('Type', 'صرف بضاعة مشاريع')
                            ->where('Product', $prod->Product)
                            ->where('P_Code', $prod->P_Code)
                            ->where('Bill_Num', $prod->Goods()->first()->Code)
                            ->update(['Delete' => 1]);

                }
            }


            GeneralDaily::where('Code_Type',$del->Code)->where('Type','صرف بضاعة مشاريع')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','صرف بضاعة مشاريع')->update(['Delete'=>1]);
            StoresMoves::where('ID',$del->id)->where('Type','صرف بضاعة مشاريع')->update(['Delete'=>1]);


            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    //PaymentssRealProjects
    public function PaymentssRealProjects($id){
        $data=RealSateProjects::find($id);
        $items=PaymentssRealProjects::where('Project',$id)->paginate(40);
        return view('admin.RealStates.PaymentsProject',get_defined_vars());
    }

    public function AddPaymentsProject($id){

        $Code=$this->ReturnCode(PaymentssRealProjects::class);
        $data=RealSateProjects::find($id);
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess=Employess::type()->get();
        $Coins=Coins::all();
        $Taxes=Taxes::all();
        $CodeUser=$this->ReturnCode(Customers::class);
        
          $Def=RealStateDefaultData::latest('id')->first();
        return view('admin.RealStates.AddPaymentProject',get_defined_vars());
    }

    function PaymentProductsFilter(Request $request,SalesService $service)
    {


        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');
            $client = $request->get('client');
            $Brand = null;
            $Group = null;
            $Qut=0;
            if($search != '' and $store != '' and $client != '')
            {


                $data=$this->FilterSalesProduct($search,$Brand,$Group);

            }


            $total_row = $data->count();

            if($total_row > 0)
            {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);


                foreach($data as $rows){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        if(is_numeric($search)){

                            $rr = ProductUnits::where('Product', $rows->Product)->where('Barcode', $search)->first();
                        }else {
                            $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        }


                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();

                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;

                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $cost=0;
                            $qty=100000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if(!empty($Group) and !empty($Brand)){

                            if($rows->Product()->first()->Group == $Group and $branddX == $Brand){

                                if($rows->Product()->first()->P_Type == 'Service'){
                                    $Filter=[

                                        'client'=>$client,
                                        'store'=>$store,
                                        'product'=>$rows->Product,
                                        'name_ar'=>$rows->P_Ar_Name,
                                        'name_en'=>$rows->P_En_Name,
                                        'v1'=>$rows->V1,
                                        'v2'=>$rows->V2,
                                        'type'=>$type,
                                        'PrrroName'=>$PrrroName,
                                        'UniiName'=>$UniiName,
                                        'StoreNemo'=>$StoreNemo,
                                        'weigh'=>$weigh,
                                        'maxSa'=>$maxSa,
                                        'P_Code'=>$p_code,
                                        'qty'=>$qty,
                                        'Original'=>$rows->Original,
                                        'Patch_Number'=>$rows->Patch_Number,
                                        'brandd'=>$brandd,
                                        'ShowGrBr'=>$ShowGrBr,
                                        'Higher'=>$Higher,
                                        'v_name'=>$v_name,
                                        'vv_name'=>$vv_name,
                                        'serial'=>$serial,
                                        'Exp_Date'=>$rows->Exp_Date,
                                        'cost'=>$cost,
                                        'search'=>$search,

                                    ];

                                    $output .=$service->ItemsFilterTwoProjectRealState($Filter);
                                }

                            }


                        }elseif(empty($Group) and !empty($Brand)){


                            if( $branddX == $Brand){

                                if( $rows->Product()->first()->P_Type == 'Service'){
                                    $Filter=[

                                        'client'=>$client,
                                        'store'=>$store,
                                        'product'=>$rows->Product,
                                        'name_ar'=>$rows->P_Ar_Name,
                                        'name_en'=>$rows->P_En_Name,
                                        'v1'=>$rows->V1,
                                        'v2'=>$rows->V2,
                                        'type'=>$type,
                                        'PrrroName'=>$PrrroName,
                                        'UniiName'=>$UniiName,
                                        'StoreNemo'=>$StoreNemo,
                                        'weigh'=>$weigh,
                                        'maxSa'=>$maxSa,
                                        'P_Code'=>$p_code,
                                        'qty'=>$qty,
                                        'Original'=>$rows->Original,
                                        'Patch_Number'=>$rows->Patch_Number,
                                        'brandd'=>$brandd,
                                        'ShowGrBr'=>$ShowGrBr,
                                        'Higher'=>$Higher,
                                        'v_name'=>$v_name,
                                        'vv_name'=>$vv_name,
                                        'serial'=>$serial,
                                        'Exp_Date'=>$rows->Exp_Date,
                                        'cost'=>$cost,
                                        'search'=>$search,
                                    ];

                                    $output .=$service->ItemsFilterTwoProjectRealState($Filter);
                                }



                            }



                        }elseif(!empty($Group) and empty($Brand)){


                            if($rows->Product()->first()->Group == $Group){

                                if( $rows->Product()->first()->P_Type == 'Service'){
                                    $Filter=[

                                        'client'=>$client,
                                        'store'=>$store,
                                        'product'=>$rows->Product,
                                        'name_ar'=>$rows->P_Ar_Name,
                                        'name_en'=>$rows->P_En_Name,
                                        'v1'=>$rows->V1,
                                        'v2'=>$rows->V2,
                                        'type'=>$type,
                                        'PrrroName'=>$PrrroName,
                                        'UniiName'=>$UniiName,
                                        'StoreNemo'=>$StoreNemo,
                                        'weigh'=>$weigh,
                                        'maxSa'=>$maxSa,
                                        'P_Code'=>$p_code,
                                        'qty'=>$qty,
                                        'Original'=>$rows->Original,
                                        'Patch_Number'=>$rows->Patch_Number,
                                        'brandd'=>$brandd,
                                        'ShowGrBr'=>$ShowGrBr,
                                        'Higher'=>$Higher,
                                        'v_name'=>$v_name,
                                        'vv_name'=>$vv_name,
                                        'serial'=>$serial,
                                        'Exp_Date'=>$rows->Exp_Date,
                                        'cost'=>$cost,
                                        'search'=>$search,

                                    ];

                                    $output .=$service->ItemsFilterTwoProjectRealState($Filter);
                                }



                            }



                        }elseif(empty($Group) and empty($Brand)){

                            if($rows->Product()->first()->P_Type == 'Service'){
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'search'=>$search,

                                ];

                                $output .=$service->ItemsFilterTwoProjectRealState($Filter);
                            }



                        }




                    }
                }


            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    public function PostAddPaymentProject(Average $average){

        try {
            DB::beginTransaction();
            $project=RealSateProjects::find(request('Project'));

            $IDD = DB::table('paymentss_real_projects')->insertGetId(

                array(

                    'Code' => request('Code'),
                    'Date' => request('Date'),
                    'Time' => date('h:i:s'),
                    'Branch' => request('Branch'),
                    'Draw' => request('Draw'),
                    'Note' => request('Note'),
                    'Product_Numbers' => request('Product_Numbers'),
                    'Total_Qty' => request('Total_Qty'),
                    'Total_Discount' => request('Total_Discount'),
                    'Total_BF_Taxes' => request('Total_BF_Taxes'),
                    'Total_Taxes' => request('Total_Taxes'),
                    'Total_Price' => request('Total_Price'),
                    'Total_Cost' => request('Total_Cost'),
                    'Total_Net' => request('Total_PriceW'),
                    'DiscountBill' => request('DiscountBill'),
                    'Pay' => request('Pay'),
                    'Safe' => request('Safe'),
                    'Client' => request('Client'),
                    'Delegate' => request('Delegate'),
                    'Store' => request('Store'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => request('Cost_Center'),
                    'User' => auth()->guard('admin')->user()->id,
                    'Edit' => 0,
                    'Delete' =>0,
                    'Edit_New_Code' => null,
                    'Project' => request('Project'),
                )
            );


            if(!empty(request('P_Ar_Name'))){

                $Product_Code=request('P_Code');
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $AvQty=request('AvQty');
                $Qty=request('Qty');
                $Price=request('Price');
                $CostPrice=request('CostPrice');
                $Discount=request('Discount');
                $TDiscount=request('TDiscPro');
                $Tax=request('PurchTax');
                $Total_Bf_Tax=request('TotalBFTax');
                $Total_Tax=request('TotalTax');
                $Total=request('Total');
                $TotCostNew=request('TotCostNew');
                $Total_Net=request('Total_Net');
                $Store=request('Store');
                $Product=request('Product');
                $Unit=request('Unit');
                $Pro_Desc=request('Pro_Desc');


                for($i=0;$i< count($P_Ar_Name);$i++){

                    $data['Product_Code']=$Product_Code[$i];
                    $data['P_Ar_Name']=$P_Ar_Name[$i];
                    $data['P_En_Name']=$P_En_Name[$i];
                    $data['AvQty']=$AvQty[$i];
                    $data['Qty']=$Qty[$i];
                    $data['Price']=$Price[$i];
                    $data['CostPrice']=$CostPrice[$i];
                    $data['Discount']=$Discount[$i];
                    $data['TDiscount']=$TDiscount[$i];
                    $data['Tax']=$Tax[$i];
                    $data['Total_Bf_Tax']=$Total_Bf_Tax[$i];
                    $data['Total_Tax']=$Total_Tax[$i];
                    $data['Total']=$Total[$i];
                    $data['TotCostNew']=$TotCostNew[$i];
                    $data['Total_Net']=$Total_Net[$i];
                    $data['Store']=$Store;
                    $data['Product']=$Product[$i];
                    $data['Unit']=$Unit[$i];
                    $data['Pro_Desc']=$Pro_Desc[$i];
                    $data['Payment']=$IDD;
                    PaymentssProductsRealProjects::create($data);


                }

            }


            $Code=request('Code');
            $Draw=request('Draw');
            $Coin=request('Coin');
            $Safe=request('Safe');
            $Debitor=request('Total_Price');
            $store=Stores::findOrFail(request('Store'));


            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'صرف دفعات مشاريع',
                    'TypeEn' => 'Payments Project',
                    'Code_Type' => $Code,
                    'Date' =>request('Date'),
                    'Draw' => $Draw,
                    'Coin' => $Coin,
                    'Cost_Center' => null,
                    'Total_Debaitor' => $Debitor,
                    'Total_Creditor' =>$Debitor,
                    'Note' => null,

                )
            );


            $Codee=Journalizing::findOrFail($ID)->Code;


           $total_discount=request('Total_Discount') + request('DiscountBill');
           $total_taxes=request('Total_Taxes');


            if($total_discount == 0  and $total_taxes == 0){


            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=$Debitor;
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$Safe;
            $PRODUCTSS['Statement']=request('Note');


            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Codee;
            $Gen['Code_Type']=$Code;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف دفعات مشاريع';
            $Gen['TypeEn']='Payment Project';
            $Gen['Debitor']=$Debitor;
            $Gen['Creditor']=0;
            $Gen['Statement']=request('Note');
            $Gen['Draw']=$Draw;
            $Gen['Debitor_Coin']= $Draw * $Debitor;
            $Gen['Creditor_Coin']=$Draw * 0;
            $Gen['Account']=$Safe;
            $Gen['Coin']= $Coin;
            $Gen['Cost_Center']= null;
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);



            $PRODUCTSSS['Joun_ID']=$ID;
            $PRODUCTSSS['Debitor']=0;
            $PRODUCTSSS['Creditor']=$Debitor;
            $PRODUCTSSS['Account']=request('Client');
            $PRODUCTSSS['Statement']=request('Note');
            JournalizingDetails::create($PRODUCTSSS);

            $Genn['Code']=$Codee;
            $Genn['Code_Type']=$Code;
            $Genn['Date']=request('Date');
            $Genn['Type']='صرف دفعات مشاريع';
            $Genn['TypeEn']='Payment Project';
            $Genn['Debitor']=0;
            $Genn['Creditor']=$Debitor;
            $Genn['Statement']=request('Note');
            $Genn['Draw']=$Draw;
            $Genn['Debitor_Coin']= $Draw * 0;
            $Genn['Creditor_Coin']=$Draw * $Debitor;
            $Genn['Account']=request('Client');
            $Genn['Coin']= $Coin;
            $Genn['Cost_Center']= null;
            $Genn['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Genn);




            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=$Debitor;
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=request('Client');
            $PRODUCTSS['Statement']=request('Note');


            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Codee;
            $Gen['Code_Type']=$Code;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف دفعات مشاريع';
            $Gen['TypeEn']='Payment Project';
            $Gen['Debitor']=$Debitor;
            $Gen['Creditor']=0;
            $Gen['Statement']=request('Note');
            $Gen['Draw']=$Draw;
            $Gen['Debitor_Coin']= $Draw * $Debitor;
            $Gen['Creditor_Coin']=$Draw * 0;
            $Gen['Account']=request('Client');
            $Gen['Coin']= $Coin;
            $Gen['Cost_Center']= null;
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);



            $PRODUCTSSS['Joun_ID']=$ID;
            $PRODUCTSSS['Debitor']=0;
            $PRODUCTSSS['Creditor']=$Debitor;
            $PRODUCTSSS['Account']=48;
            $PRODUCTSSS['Statement']=request('Note');
            JournalizingDetails::create($PRODUCTSSS);

            $Genn['Code']=$Codee;
            $Genn['Code_Type']=$Code;
            $Genn['Date']=request('Date');
            $Genn['Type']='صرف دفعات مشاريع';
            $Genn['TypeEn']='Payment Project';
            $Genn['Debitor']=0;
            $Genn['Creditor']=$Debitor;
            $Genn['Statement']=request('Note');
            $Genn['Draw']=$Draw;
            $Genn['Debitor_Coin']= $Draw * 0;
            $Genn['Creditor_Coin']=$Draw * $Debitor;
            $Genn['Account']=48;
            $Genn['Coin']= $Coin;
            $Genn['Cost_Center']= null;
            $Genn['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Genn);

}


            if($total_discount != 0  and $total_taxes == 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor - $total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor - $total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor - $total_discount);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);

                 $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=50;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $total_discount;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=50;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            if($total_discount == 0  and $total_taxes != 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor + $total_taxes;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor + $total_taxes;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor + $total_taxes);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor + $total_taxes;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor + $total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * ($Debitor + $total_taxes);
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor + $total_taxes;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor + $total_taxes;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor + $total_taxes);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);


                $TTax=Taxes::find($Tax[0]);

      $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$total_taxes;
                $PRODUCTSSS['Account']=$TTax->Account;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $total_taxes;
                $Genn['Account']=$TTax->Account;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            if($total_discount != 0  and $total_taxes != 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor - $total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor - $total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor - $total_discount);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);

                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=50;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $total_discount;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=50;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);


                $TTax=Taxes::find($Tax[0]);

                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$total_taxes;
                $PRODUCTSSS['Account']=$TTax->Account;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $total_taxes;
                $Genn['Account']=$TTax->Account;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            if(request('SP') == 0){  return back(); }elseif(request('SP') == 1){  return redirect('PaymentProjectPrint/'.$IDD); }



        }catch(\Exception $ex){

            $MODEL=PaymentssRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=PaymentssRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function PaymentProjectPrint($id,QRController $qr){
        $item=PaymentssRealProjects::find($id);


        $customer=Customers::where('Account',$item->Client)->first();

        if(!empty($customer)) {
            $seller_name = $customer->Company_Name;
            $vat_number = $customer->Tax_Registration_Number;
            $invoice_date = $item->Date.'T'.date("h:i:s", strtotime($item->Time)).'Z';
            $total_amount = $item->Total_Net;
            $vat_amount = $item->Total_Taxes;
            $qr_options = "store";


            $qr_data = [

                "seller_name" => $seller_name,
                "vat_number" => $vat_number,
                "invoice_date" => $invoice_date,
                "total_amount" => $total_amount,
                "vat_amount" => $vat_amount,
                "qr_options" => $qr_options,

            ];

            $route='PaymentProjectPrint/'.$id;
            $result = $qr->generate($qr_data,$route);
        }

        return view('admin.RealStates.PaymentProjectPrint',get_defined_vars());
    }

    public function DeletePaymentProject($id){
        try {
            DB::beginTransaction();
            $del=PaymentssRealProjects::find($id);




            GeneralDaily::where('Code_Type',$del->Code)->where('Type','صرف دفعات مشاريع')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','صرف دفعات مشاريع')->update(['Delete'=>1]);


            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ExpensesTypeProject::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function EditPaymentProject($id){


        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess=Employess::type()->get();
        $Coins=Coins::all();
        $Taxes=Taxes::all();
        $item=PaymentssRealProjects::find($id);
        $products=PaymentssProductsRealProjects::where('Payment',$id)->get();

        return view('admin.RealStates.EditPaymentProject',get_defined_vars());
    }

    public function PostEditPaymentProject(Average $average){

        try {
            DB::beginTransaction();

            $IDD=request('ID');

            $del=PaymentssRealProjects::find($IDD);


            GeneralDaily::where('Code_Type',$del->Code)->where('Type','صرف دفعات مشاريع')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','صرف دفعات مشاريع')->update(['Edit'=>1]);



            $pay['Code'] = request('Code');
                    $pay['Date'] = request('Date');
                    $pay['Time'] = date('h:i:s');
                    $pay['Branch'] = request('Branch');
                    $pay['Draw'] = request('Draw');
                    $pay['Note'] = request('Note');
                    $pay['Product_Numbers'] = request('Product_Numbers');
                    $pay['Total_Qty'] = request('Total_Qty');
                    $pay['Total_Discount'] = request('Total_Discount');
                    $pay['Total_BF_Taxes'] = request('Total_BF_Taxes');
                    $pay['Total_Taxes'] = request('Total_Taxes');
                    $pay['Total_Price'] = request('Total_Price');
                    $pay['Total_Cost'] = request('Total_Cost');
                    $pay['Total_Net'] = request('Total_PriceW');
                    $pay['DiscountBill'] = request('DiscountBill');
                    $pay['Pay'] = request('Pay');
                    $pay['Safe'] = request('Safe');
                    $pay['Client'] = request('Client');
                    $pay['Delegate'] = request('Delegate');
                    $pay['Store'] = request('Store');
                    $pay['Coin'] = request('Coin');
                    $pay['Cost_Center'] = request('Cost_Center');
                    $pay['User'] = auth()->guard('admin')->user()->id;
                    $pay['Project'] = request('Project');

            PaymentssRealProjects::where('id',$IDD)->update($pay);

            if(!empty(request('P_Ar_Name'))){

                PaymentssProductsRealProjects::where('Payment',$IDD)->delete();

                $Product_Code=request('P_Code');
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $AvQty=request('AvQty');
                $Qty=request('Qty');
                $Price=request('Price');
                $CostPrice=request('CostPrice');
                $Discount=request('Discount');
                $TDiscount=request('TDiscPro');
                $Tax=request('PurchTax');
                $Total_Bf_Tax=request('TotalBFTax');
                $Total_Tax=request('TotalTax');
                $Total=request('Total');
                $TotCostNew=request('TotCostNew');
                $Total_Net=request('Total_Net');
                $Store=request('Store');
                $Product=request('Product');
                $Unit=request('Unit');
                $Pro_Desc=request('Pro_Desc');


                for($i=0;$i< count($P_Ar_Name);$i++){

                    $data['Product_Code']=$Product_Code[$i];
                    $data['P_Ar_Name']=$P_Ar_Name[$i];
                    $data['P_En_Name']=$P_En_Name[$i];
                    $data['AvQty']=$AvQty[$i];
                    $data['Qty']=$Qty[$i];
                    $data['Price']=$Price[$i];
                    $data['CostPrice']=$CostPrice[$i];
                    $data['Discount']=$Discount[$i];
                    $data['TDiscount']=$TDiscount[$i];
                    $data['Tax']=$Tax[$i];
                    $data['Total_Bf_Tax']=$Total_Bf_Tax[$i];
                    $data['Total_Tax']=$Total_Tax[$i];
                    $data['Total']=$Total[$i];
                    $data['TotCostNew']=$TotCostNew[$i];
                    $data['Total_Net']=$Total_Net[$i];
                    $data['Store']=$Store;
                    $data['Product']=$Product[$i];
                    $data['Unit']=$Unit[$i];
                     $data['Pro_Desc']=$Pro_Desc[$i];
                    $data['Payment']=$IDD;
                    PaymentssProductsRealProjects::create($data);


                }

            }


            $Code=request('Code');
            $Draw=request('Draw');
            $Coin=request('Coin');
            $Safe=request('Safe');
            $Debitor=request('Total_PriceW');
            $store=Stores::findOrFail(request('Store'));

            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'صرف دفعات مشاريع',
                    'TypeEn' => 'Payments Project',
                    'Code_Type' => $Code,
                    'Date' => request('Date'),
                    'Draw' => $Draw,
                    'Coin' => $Coin,
                    'Cost_Center' => null,
                    'Total_Debaitor' => $Debitor,
                    'Total_Creditor' =>$Debitor,
                    'Note' => null,

                )
            );


            $Codee=Journalizing::findOrFail($ID)->Code;
            $total_discount=request('Total_Discount') + request('DiscountBill');
            $total_taxes=request('Total_Taxes');

            if($total_discount == 0  and $total_taxes == 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            if($total_discount != 0  and $total_taxes == 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor - $total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor - $total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor - $total_discount);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);

                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=50;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $total_discount;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=50;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            if($total_discount == 0  and $total_taxes != 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor + $total_taxes;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor + $total_taxes;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor + $total_taxes);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor + $total_taxes;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor + $total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * ($Debitor + $total_taxes);
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor + $total_taxes;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor + $total_taxes;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor + $total_taxes);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);


                $TTax=Taxes::find($Tax[0]);

                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$total_taxes;
                $PRODUCTSSS['Account']=$TTax->Account;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $total_taxes;
                $Genn['Account']=$TTax->Account;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }


            if($total_discount != 0  and $total_taxes != 0){


                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Safe;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Safe;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=request('Client');
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=request('Client');
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);




                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor - $total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=request('Client');
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$Debitor - $total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * ($Debitor - $total_discount);
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=request('Client');
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);

                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$total_discount;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=50;
                $PRODUCTSS['Statement']=request('Note');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='صرف دفعات مشاريع';
                $Gen['TypeEn']='Payment Project';
                $Gen['Debitor']=$total_discount;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Note');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $total_discount;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=50;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']=48;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']=48;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);


                $TTax=Taxes::find($Tax[0]);

                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$total_taxes;
                $PRODUCTSSS['Account']=$TTax->Account;
                $PRODUCTSSS['Statement']=request('Note');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='صرف دفعات مشاريع';
                $Genn['TypeEn']='Payment Project';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$total_taxes;
                $Genn['Statement']=request('Note');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $total_taxes;
                $Genn['Account']=$TTax->Account;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);

            }




            DB::commit();
            session()->flash('success',trans('admin.Updated'));

            $ID=request('Project');

             return redirect('PaymentssRealProjects/'.$IDD);



        }catch(\Exception $ex){

            $MODEL=PaymentssRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=PaymentssRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    //ContractorsRealProjects
    public function ContractorsRealProjects($id){
        $data=RealSateProjects::find($id);
        $items=ContractorsRealProjects::where('Project',$id)->paginate(40);
        return view('admin.RealStates.ContractorProject',get_defined_vars());
    }

    public function AddContractor(Request $request){

         $data= $this->validate(request(),[
                'Arabic_Name'=>'required',


            ]);


        try {
            DB::beginTransaction();


           

if(!empty(request('English_Name'))){
    $english_name=request('English_Name');
}else{
    $english_name=request('Arabic_Name');
}


            $merit_Account=AcccountingManual::where('Code',210)->orderBy('id','desc')->first();
            $AccMerit=$this->CreateAccount(request('Arabic_Name').' استحقاق مقاول  ',$english_name.' Contractor Merit  ' ,$merit_Account->id ,null);

            $ex_Account=RealSateProjects::find(request('Project'));
            $AccExpenses=$this->CreateAccount(request('Arabic_Name').' مصاريف مقاول  ',$english_name.' Contractor Expenses  ' ,$ex_Account->Contractor_Account ,null);


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            $data['Expenses_Account']=$AccExpenses;
            $data['Merit_Account']=$AccMerit;
            $data['Project']=request('Project');
            ContractorsRealProjects::create($data);


            $dataUser=[
                'screen_ar'=>'مقاولين مشاريع',
                'screen_en'=>'Projects Contractors',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));

            return back();




        }catch(\Exception $ex){

            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }

    public function EditContractor(Request $request,$id){

            $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'English_Name'=>'required',


            ]);


        try {
            DB::beginTransaction();


        


            $item=ContractorsRealProjects::find($id);
            AcccountingManual::where('id',$item->Merit_Account)->update(['Name'=>request('Arabic_Name').' استحقاق مقاول ','NameEn'=>request('English_Name').' Contractor Merit  ']);
            AcccountingManual::where('id',$item->Expenses_Account)->update(['Name'=>request('Arabic_Name').' مصاريف مقاول ','NameEn'=>request('English_Name').' Contractor Expenses  ']);


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            ContractorsRealProjects::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'مقاولين مشاريع',
                'screen_en'=>'Projects Contractors',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();

            session()->flash('success',trans('admin.Updated'));

            return back();




        }catch(\Exception $ex){

            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }

    public function DeleteContractor($id){
        try {
            DB::beginTransaction();
            $del=ContractorsRealProjects::find($id);


            AcccountingManual::where('id',$del->Merit_Account)->delete();
            AcccountingManual::where('id',$del->Expenses_Account)->delete();


            $dataUser=[
                'screen_ar'=>'مقاولين مشاريع',
                'screen_en'=>'Projects Contractors',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ContractorsRealProjects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    //AbstractsContractor
    public function AbstractsContractor($id){
        $data=ContractorsRealProjects::find($id);
        $items=AbstractsContractor::where('Contractor',$id)->paginate(40);
        $Code=$this->ReturnCode(AbstractsContractor::class);
        return view('admin.RealStates.AbstractsContractor',get_defined_vars());
    }

    public function AddAbstractsContractor(Average $average){

        try {
            DB::beginTransaction();


            $IDD = DB::table('abstracts_contractors')->insertGetId(

                array(

                    'Code' => request('Code'),
                    'Date' => request('Date'),
                    'Name' => request('Name'),
                    'Value' => request('Value'),
                    'Statement' => request('Statement'),
                    'Contractor' => request('Contractor'),
                    'Project' => request('Project'),
                    'Edit' => 0,
                    'Delete' =>0,
                    'Edit_New_Code' => null,

                )
            );



            $Contractor=ContractorsRealProjects::find(request('Contractor'));
            $def=AccountsDefaultData::latest('id')->first();

            $Code=request('Code');
            $Draw=$def->Draw;
            $Coin=$def->Coin;
            $Debitor=request('Value');







            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'مستخلص مقاول',
                    'TypeEn' => 'Abstract Contractor',
                    'Code_Type' => $Code,
                    'Date' =>request('Date'),
                    'Draw' => $Draw,
                    'Coin' => $Coin,
                    'Cost_Center' => null,
                    'Total_Debaitor' => $Debitor,
                    'Total_Creditor' =>$Debitor,
                    'Note' => null,

                )
            );


            $Codee=Journalizing::findOrFail($ID)->Code;



                $PRODUCTSS['Joun_ID']=$ID;
                $PRODUCTSS['Debitor']=$Debitor;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']= $Contractor->Expenses_Account;
                $PRODUCTSS['Statement']=request('Statement');


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Codee;
                $Gen['Code_Type']=$Code;
                $Gen['Date']=request('Date');
                $Gen['Type']='مستخلص مقاول';
                $Gen['TypeEn']='Abstract Contractor';
                $Gen['Debitor']=$Debitor;
                $Gen['Creditor']=0;
                $Gen['Statement']=request('Statement');
                $Gen['Draw']=$Draw;
                $Gen['Debitor_Coin']= $Draw * $Debitor;
                $Gen['Creditor_Coin']=$Draw * 0;
                $Gen['Account']=$Contractor->Expenses_Account;
                $Gen['Coin']= $Coin;
                $Gen['Cost_Center']= null;
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



                $PRODUCTSSS['Joun_ID']=$ID;
                $PRODUCTSSS['Debitor']=0;
                $PRODUCTSSS['Creditor']=$Debitor;
                $PRODUCTSSS['Account']= $Contractor->Merit_Account;
                $PRODUCTSSS['Statement']=request('Statement');
                JournalizingDetails::create($PRODUCTSSS);

                $Genn['Code']=$Codee;
                $Genn['Code_Type']=$Code;
                $Genn['Date']=request('Date');
                $Genn['Type']='مستخلص مقاول';
                 $Genn['TypeEn']='Abstract Contractor';
                $Genn['Debitor']=0;
                $Genn['Creditor']=$Debitor;
                $Genn['Statement']=request('Statement');
                $Genn['Draw']=$Draw;
                $Genn['Debitor_Coin']= $Draw * 0;
                $Genn['Creditor_Coin']=$Draw * $Debitor;
                $Genn['Account']= $Contractor->Merit_Account;
                $Genn['Coin']= $Coin;
                $Genn['Cost_Center']= null;
                $Genn['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Genn);


            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
             return back();



        }catch(\Exception $ex){

            $MODEL=AbstractsContractor::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=AbstractsContractor::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function DeleteAbstractsContractor($id){
        try {
            DB::beginTransaction();
            $del=AbstractsContractor::find($id);

            GeneralDaily::where('Code_Type',$del->Code)->where('Type','مستخلص مقاول')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','مستخلص مقاول')->update(['Delete'=>1]);


            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=AbstractsContractor::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=AbstractsContractor::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }



//Report
    public function ProjectProfitReport(){
        $Projects=RealSateProjects::get();
        return view('admin.RealStates.ProjectReport',get_defined_vars());
    }

    public function FilterProjectProfitReport(Request $request){

        $Project = $request->get('Project');


        if(!empty($Project)) {

          $items=RealSateProjects::when(!empty($Project), function ($query) use ($Project) {
              return $query->where('id', $Project);
          }) ->paginate(20);

        }

        $output = '';
        if($request->ajax())
        {

            $Project = $request->get('Project');

            foreach ($items as $item) {

                $TotalExpenses = PaymentVoucher::where('Project', $Project)->get()->sum('Total_Debaitor');
                $TotalGoods = GoodsProject::where('Project', $Project)->get()->sum('Total_Price');
                $TotalPayments = PaymentssRealProjects::where('Project', $Project)->get()->sum('Total_Net');
                $Profit = $TotalPayments - ($TotalExpenses + $TotalGoods);


                $output .= '

       <tr>

         <td>' . $item->Code . '</td>
         <td>' . $item->Name . '</td>
         <td>' . $item->Start_Date . '</td>
         <td>' . $item->End_Date . '</td>
         <td>' . $item->Value . '</td>
         <td>' . $item->Expect_Cost . '</td>
         <td>' . $item->Expect_Profit . '</td>
         <td>' . $item->Client()->first()->Name . '</td>
         <td>' . $item->Manager()->first()->Name . '</td>
         <td>' . $item->Reponsible()->first()->Name . '</td>
         <td>

               <button class="btn btn-primary" data-toggle="modal" data-target="#ExpDet" type="button" onclick="ExpDet('.$item->id.')">' . $TotalExpenses . '</button>
         <input type="hidden" class="EX" value="' . $TotalExpenses . '">
         </td>
         <td>

         <button class="btn btn-primary" data-toggle="modal" data-target="#GoodsDet" type="button" onclick="GoodsDet('.$item->id.')">' . $TotalGoods . '</button>
                <input type="hidden" class="GO" value="' . $TotalGoods . '">
         </td>
         <td>

      <button class="btn btn-primary" data-toggle="modal" data-target="#PayDet" type="button" onclick="PayDet('.$item->id.')">' . $TotalPayments . '</button>
                <input type="hidden" class="PA" value="' . $TotalPayments . '"></td>
         <td>' . $Profit . '
                <input type="hidden" class="PO" value="' . $Profit . '">
         </td>


        </tr>
            ';





            }

            return   $output ;
        }
        return view('admin.RealStates.ProjectReportFilter',get_defined_vars());
    }

    public function ExpensesDetailsFilter(Request $request){

        if($request->ajax())
        {
            $output = '';
            $Project = $request->get('id');

            if($Project != '')
            {

                $items=PaymentVoucherDetails::whereRelation('PV_ID','Project',$Project)->get();

            }

            $total_row = $items->count();
            if($total_row > 0)
            {

                foreach ($items as $item) {

                    $output .= '

       <tr>

         <td>' . $item->Debitor . '</td>
         <td>' . $item->Account()->first()->Name . '</td>
         <td>' . $item->Statement . '</td>
         <td>' . $item->Date . '</td>
         <td>' . $item->Cost_Center()->first()->Arabic_Name . '</td>
         <td>' . $item->Safe()->first()->Name . '</td>

        </tr>
            ';

                }

            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد  </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }

    }

    public function GoodsDetailsFilter(Request $request){

        if($request->ajax())
        {
            $output = '';
            $Project = $request->get('id');

            if($Project != '')
            {

                $items=GoodsProject::where('Project',$Project)->get();

            }

            $total_row = $items->count();
            if($total_row > 0)
            {

                foreach ($items as $item) {

                    $output .= '

       <tr>

         <td>' . $item->Code . '</td>
         <td>' . $item->Date . '</td>
            <td>' . $item->Cost_Center()->first()->Arabic_Name . '</td>
         <td>' . $item->Responsible()->first()->Name . '</td>
         <td>' . $item->Product_Numbers . '</td>
         <td>' . $item->Total_Qty . '</td>
         <td>' . $item->Total_Price . '</td>
        </tr>
            ';

                }


            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد  </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }

    }

    public function PayDetailsFilter(Request $request){

        if($request->ajax())
        {
            $output = '';
            $Project = $request->get('id');

            if($Project != '')
            {

                $items=PaymentssRealProjects::where('Project',$Project)->get();

            }

            $total_row = $items->count();
            if($total_row > 0)
            {

                foreach ($items as $item) {


                    if(!empty($item->Delegate()->first()->Name)){
                        $dele=$item->Delegate()->first()->Name;
                    }else{
                        $dele='';
                    }
                    $output .= '

       <tr>

         <td>' . $item->Code . '</td>
         <td>' . $item->Date . '</td>
         <td>' . $item->Safe()->first()->Name . '</td>
         <td>' . $item->Client()->first()->Name . '</td>
         <td>' . $dele . '</td>
         <td>' . $item->Cost_Center()->first()->Arabic_Name . '</td>
         <td>' . $item->Total_Qty . '</td>
         <td>' . $item->Total_Net . '</td>
        </tr>
            ';

                }

            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد  </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }

    }



}
