<?php

namespace App\Http\Controllers;

use App\Models\VendorProducts;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\StoresDefaultData;
use App\Models\AcccountingManual;
use App\Models\UsersMoves;
use App\Models\Vendors;
use App\Models\ModuleSettingsNum;
use App\Models\Countris;
use App\Models\PurchasesOrder;
use App\Models\ProductsPurchasesOrder;
use App\Models\CostCenter;
use App\Models\Coins;
use App\Models\Stores;
use App\Models\Employess;
use App\Models\Products;
use App\Models\ManufacturingModel;
use App\Models\ProductUnits;
use App\Models\Measuerments;
use App\Models\ProductsQty;
use App\Models\GeneralDaily;
use App\Models\Taxes;
use App\Models\ProductsVira;
use App\Models\SubVirables;
use App\Models\Purchases;
use App\Models\ProductsPurchases;
use App\Models\ProductSales;
use App\Models\StoreCount;
use App\Models\ProductMoves;
use App\Models\Brands;
use App\Models\ItemsGroups;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\RecivedPurcht;
use App\Models\RecivedPurchProducts;
use App\Models\ReturnPurch;
use App\Models\ReturnPurchProducts;
use App\Models\Admin;
use App\Models\Governrate;
use App\Models\ChecksTypes;
use App\Models\ExportChecks;
use App\Models\Shortcomings;
use App\Models\ProductsShortcomings;
use App\Models\PurchasesDefaultData;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\OutcomManufacturingModel;
use App\Models\IncomManufacturingModel;
use App\Models\Customers;
use App\Models\StoresMoves;
use App\Models\ExpireDateQty;
use App\Models\PermissionToRecivedGoods;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\BarcodeSettings;
use App\Models\BarcodeShow;
use App\Models\BarcodeProducts;
use App\Models\DefaultDataShowHide;
use App\Models\Event;
use App\Models\Notifications;
use App\Models\FifoQty;
use App\Models\CrmDefaultData;
use App\Models\CustomPrint;
use App\Models\CompanyData;
use App\Models\ImportExpensesTypes;
use App\Models\PurchasesExpensesTypes;
use App\Models\PurchasesOrderExpensesTypes;

use App\Events\PurchasesEvent;
use App\Events\ReturnPurchasesEvent;
use App\Services\Average;
use App\Services\PurchasesService;

use App\Http\Requests\NameRequest;
use App\Http\Requests\PurchasesRequest;

use App\Traits\GeneralTrait;

use Str;
class PurchasesController extends Controller
{
      use GeneralTrait;

function __construct()
{

$this->middleware('permission:الموردين', ['only' => ['VendorsPage','AddVendors','EditVendors','DeleteVendors']]);
$this->middleware('permission:اضافه امر شراء', ['only' => ['PurchasesOrderPage','AddPurchasesOrder']]);
$this->middleware('permission:اضافه مشتريات', ['only' => ['PurchasesPage','AddPurchases']]);
$this->middleware('permission:جدول مرتجع المشتريات', ['only' => ['ReturnPurchasesSechdulePage']]);
$this->middleware('permission:جدول آوامر الشراء', ['only' => ['PurchasesOrderSechdule','DeletePurchasesOrder','PurchOrdPrint','EditPurchasesOrder','PostEditPurchasesOrder','TransferToPurchases','PostTransferPurchases']]);
$this->middleware('permission:جدول المشتريات', ['only' => ['PurchasesSechdulePage','PurchPrint']]);
$this->middleware('permission:ارتجاع فاتوره مشتريات', ['only' => ['ReturnPurchPage','PostReturnPurchases']]);
$this->middleware('permission:الفواتير المعلقه مشتريات', ['only' => ['PurchasesHoldPage','RecivedPurchPage','PostRecivedPurchases']]);
$this->middleware('permission:المنتجات المستلمه مشتريات', ['only' => ['Recived_ProductsPage']]);
$this->middleware('permission:النواقص', ['only' => ['ShortcomingsPage']]);
$this->middleware('permission:جدول النواقص', ['only' => ['ShortcomingsSechdulePage']]);

}



    //Vendors
          public function VendorsPage(){
        $items=Vendors::paginate(20);
        $Groups=ItemsGroups::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $Nationality=Countris::all();
        $Code=$this->ReturnCode(Vendors::class);
        $Employess = Employess::type()->lazy();
        $def=CrmDefaultData::orderBy('id','desc')->first();
         return view('admin.Purchases.Vendors',get_defined_vars());
    }

          public function AddVendors(NameRequest $request){

     try {
    DB::beginTransaction();

       $validated = $request->validated();

        if(!empty(request('NameEn'))){

         $english_name=request('NameEn');
         }else{

         $english_name=request('Name');
         }



        $Acc=$this->CreateAccount(request('Name'),$english_name ,37 ,null);

         $dataa['Code']=request('Code');
         $dataa['Name']=request('Name');
         $dataa['NameEn']=$english_name;
         $dataa['Phone']=request('Phone');
         $dataa['Phone2']=request('Phone2');
         $dataa['Governrate']=request('Governrate');
         $dataa['City']=request('City');
         $dataa['Place']=request('Place');
         $dataa['Commercial_Register']=request('Commercial_Register');
         $dataa['Tax_Card']=request('Tax_Card');
         $dataa['Price_Level']=request('Price_Level');
         $dataa['Tax_Registration_Number']=request('Tax_Registration_Number');
         $dataa['Tax_activity_code']=request('Tax_activity_code');
         $dataa['work_nature']=request('work_nature');
         $dataa['Nationality']=request('Nationality');
         $dataa['Buliding_Num']=request('Buliding_Num');
         $dataa['Street']=request('Street');
         $dataa['Postal_Code']=request('Postal_Code');
         $dataa['tax_magistrate']=request('tax_magistrate');
         $dataa['Account']=$Acc;
         $dataa['User']=auth()->guard('admin')->user()->id;
         $dataa['Floor']=request('Floor');
         $dataa['Room']=request('Room');
         $dataa['Landmark']=request('Landmark');
         $dataa['Add_Info']=request('Add_Info');
         $dataa['Responsible']=request('Responsible');
         $dataa['Pro_Group']=request('Pro_Group');
         $dataa['Brand']=request('Brand');
         $dataa['SearchCode']=request('SearchCode');
         $dataa['Credit_Limit']=request('Credit_Limit');
         $dataa['Monthly_Target']=request('Monthly_Target');
         $dataa['Quarterly_Target']=request('Quarterly_Target');
         $dataa['Yearly_Target']=request('Yearly_Target');




         Vendors::create($dataa);


            $dataUser=[
    'screen_ar'=>'الموردين',
    'screen_en'=>'Vendors',
    'explain_ar'=>request('Name'),
    'explain_en'=>$english_name,
    ];
    $this->UserCreateMoves($dataUser);

           DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
             return back();

            }catch(\Exception $ex){

     $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }

          public function EditVendors(NameRequest $request,$id){

     try {
    DB::beginTransaction();

      $validated = $request->validated();

     $safe=Vendors::findOrFail($id);

         AcccountingManual::where('id',$safe->Account)->update(['Name'=>request('Name'),'NameEn'=>request('NameEn')]);


        $dataa['Code']=request('Code');
        $dataa['Name']=request('Name');
        $dataa['NameEn']=request('NameEn');
        $dataa['Phone']=request('Phone');
        $dataa['Phone2']=request('Phone2');
        $dataa['Commercial_Register']=request('Commercial_Register');
        $dataa['Tax_Card']=request('Tax_Card');
        $dataa['Price_Level']=request('Price_Level');
        $dataa['Account']=request('Account');
        $dataa['User']=request('User');
        $dataa['Governrate']=request('Governrate');
        $dataa['City']=request('City');
        $dataa['Place']=request('Place');
        $dataa['Tax_Registration_Number']=request('Tax_Registration_Number');
        $dataa['Tax_activity_code']=request('Tax_activity_code');
        $dataa['work_nature']=request('work_nature');
        $dataa['Nationality']=request('Nationality');
        $dataa['Buliding_Num']=request('Buliding_Num');
        $dataa['Street']=request('Street');
        $dataa['Postal_Code']=request('Postal_Code');
        $dataa['tax_magistrate']=request('tax_magistrate');
        $dataa['Floor']=request('Floor');
        $dataa['Room']=request('Room');
        $dataa['Landmark']=request('Landmark');
        $dataa['Add_Info']=request('Add_Info');
        $dataa['Responsible']=request('Responsible');
        $dataa['Pro_Group']=request('Pro_Group');
        $dataa['Brand']=request('Brand');
        $dataa['SearchCode']=request('SearchCode');
        $dataa['Credit_Limit']=request('Credit_Limit');
        $dataa['Monthly_Target']=request('Monthly_Target');
        $dataa['Quarterly_Target']=request('Quarterly_Target');
        $dataa['Yearly_Target']=request('Yearly_Target');
        Vendors::where('id',$id)->update($dataa);

                     $dataUser=[
                     'screen_ar'=>'الموردين',
                     'screen_en'=>'Vendors',
                     'explain_ar'=>request('Name'),
                     'explain_en'=>request('NameEn'),
                     ];
                     $this->UserUpdateMoves($dataUser);

                     DB::commit();


             session()->flash('success',trans('admin.Updated'));
             return back();

               }catch(\Exception $ex){

     $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }

          public function DeleteVendors(PurchasesService $service,$id){

         try {
    DB::beginTransaction();

        $del=Vendors::find($id);

        $result=$service->VendorIf($id);


             if($result == 1){

                 return back();

             }


    AcccountingManual::where('id',$del->Account)->delete();


                 $dataUser=[
    'screen_ar'=>'الموردين',
    'screen_en'=>'Vendors',
    'explain_ar'=>$del->Name,
    'explain_en'=>$del->NameEn,
    ];
    $this->UserDeleteMoves($dataUser);

        $del->delete();
        DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();



            }catch(\Exception $ex){

     $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Vendors::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



           }


       //VendorProducts
    public function VendorProducts($id){
        $items=VendorProducts::where('Vendor',$id)->paginate(20);
        $vend=Vendors::find($id);

        return view('admin.Purchases.VendorProducts',get_defined_vars());
    }
    public function AddVendorsProducts(Request $request){

        try {
            DB::beginTransaction();


            $dataa['Product_Name']=request('Product_Name');
            $dataa['Product_Weight']=request('Product_Weight');
            $dataa['Product_Height']=request('Product_Height');
            $dataa['Product_Length']=request('Product_Length');
            $dataa['Product_Width']=request('Product_Width');
            $dataa['Qty']=request('Qty');
            $dataa['Price']=request('Price');
            $dataa['Vendor']=request('Vendor');
            VendorProducts::create($dataa);


            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }

    public function EditVendorsProducts(Request $request,$id){

        try {
            DB::beginTransaction();


            $dataa['Product_Name']=request('Product_Name');
            $dataa['Product_Weight']=request('Product_Weight');
            $dataa['Product_Height']=request('Product_Height');
            $dataa['Product_Length']=request('Product_Length');
            $dataa['Product_Width']=request('Product_Width');
            $dataa['Qty']=request('Qty');
            $dataa['Price']=request('Price');
            $dataa['Vendor']=request('Vendor');

            VendorProducts::where('id',$id)->update($dataa);


            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }

    public function DeleteVendorsProducts($id){

        try {
            DB::beginTransaction();

            $del=VendorProducts::find($id);


            $del->delete();
            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();



        }catch(\Exception $ex){

            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=VendorProducts::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }



    //  ============  Filters =================

  function PurchacesProductsFilter(Request $request,PurchasesService $service)
  {

  if($request->ajax())
  {
  $output = '';
  $search = $request->get('search');
  $store = $request->get('store');
  $vendor = $request->get('vendor');
  $Brand = $request->get('Brand');
  $Group = $request->get('Group');

  if($search != '' and $store != '')
  {
  $data =$this->FilterPurchProduct($search,$Brand,$Group);
  }


  $total_row = $data->count();
  if($total_row > 0)
  {

  $st=Stores::find($store);


  foreach($data as $row){

  if($row->P_Type != 'Assembly'){
       if(is_numeric($search)){

     $ser_x=1;
     $ser_y=0;

    }else{


        $ser_x=1;
     $ser_y=1;


 }



 if($row->Def == $ser_x or $row->Def == $ser_y){


  $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();



      if(!empty($row->Product()->first()->Brand)){

          $branddX=$row->Product()->first()->Brand;
          if(app()->getLocale() == 'ar' ){
              $brandd=$row->Product()->first()->Brand()->first()->Name;

          }else{
              $brandd=$row->Product()->first()->Brand()->first()->NameEn;
          }

      }else{

          $brandd="";
          $branddX="";

      }



      if($row->P_Type == 'Completed' or $row->P_Type == 'Raw' or $row->P_Type == 'Service' or $row->P_Type == 'Industrial' or $row->P_Type == 'Additions'){
  $type=1;
  }elseif($row->P_Type == 'Serial'){
  $type=2;
  }elseif($row->P_Type == 'Single_Variable'){
  $type=3;
  }elseif($row->P_Type == 'Duble_Variable'){
  $type=4;

  }

  if(app()->getLocale() == 'ar' ){
  $PrrroName=$row->P_Ar_Name;
  $UniiName=$row->Unit()->first()->Name;
  $StoreNemo=$st->Name;

  }else{
  $PrrroName=$row->P_En_Name;
  $UniiName=$row->Unit()->first()->NameEn;
  $StoreNemo=$st->NameEn;

  }

     if($row->P_Type != 'Service') {
         if (!empty($Group) and !empty($Brand)) {

             if ($row->Product()->first()->Group == $Group and $branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'search'=>$search,

                 ];

                 $output .= $service->ItemsFilter($Filter);

             }

         } elseif (!empty($Group) and empty($Brand)) {


             if ($row->Product()->first()->Group == $Group) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'search'=>$search,

                 ];

                 $output .= $service->ItemsFilter($Filter);

             }


         } elseif (empty($Group) and !empty($Brand)) {

             if ($branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'search'=>$search,

                 ];

                 $output .= $service->ItemsFilter($Filter);

             }


         } elseif (empty($Group) and empty($Brand)) {

             $Filter = [

                 'vendor' => $vendor,
                 'store' => $store,
                 'product' => $row->Product,
                 'name_ar' => $row->P_Ar_Name,
                 'name_en' => $row->P_En_Name,
                 'type' => $type,
                 'PrrroName' => $PrrroName,
                 'UniiName' => $UniiName,
                 'StoreNemo' => $StoreNemo,
                 'search'=>$search,

             ];

             $output .= $service->ItemsFilter($Filter);

         }
     }








  }
  }}


  }else
  {
  $output = '
  <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
  ';
  }
  $data = array(
  'table_data' => $output,
  );
  echo json_encode($data);
  }
  }

  function ShortcomingsProductsFilter(Request $request,PurchasesService $service)
  {

  if($request->ajax())
  {
  $output = '';
  $search = $request->get('search');
  $store = $request->get('store');
  $vendor = $request->get('vendor');
  $Brand = $request->get('Brand');
  $Group = $request->get('Group');

  if($search != '' and $store != '')
  {
  $data =$this->FilterPurchProductShort($search,$Brand,$Group);
  }


  $total_row = $data->count();
  if($total_row > 0)
  {

  $st=Stores::find($store);


  foreach($data as $row){
 if($row->P_Type != 'Assembly'){
       if(is_numeric($search)){

     $ser_x=1;
     $ser_y=0;

    }else{


        $ser_x=1;
     $ser_y=1;


 }



 if($row->Def == $ser_x or $row->Def == $ser_y){


  $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();

      if(!empty($row->Product()->first()->Brand)){

          $branddX=$row->Product()->first()->Brand;
          if(app()->getLocale() == 'ar' ){
              $brandd=$row->Product()->first()->Brand()->first()->Name;

          }else{
              $brandd=$row->Product()->first()->Brand()->first()->NameEn;
          }

      }else{

          $brandd="";
          $branddX="";

      }



  if($row->P_Type == 'Completed' or $row->P_Type == 'Raw' or $row->P_Type == 'Service' or $row->P_Type == 'Industrial' or $row->P_Type == 'Additions'){
  $type=1;
  }elseif($row->P_Type == 'Serial'){
  $type=2;
  }elseif($row->P_Type == 'Single_Variable'){
  $type=3;
  }elseif($row->P_Type == 'Duble_Variable'){
  $type=4;

  }

  if(app()->getLocale() == 'ar' ){
  $PrrroName=$row->P_Ar_Name;
  $UniiName=$row->Unit()->first()->Name;
  $StoreNemo=$st->Name;

  }else{
  $PrrroName=$row->P_En_Name;
  $UniiName=$row->Unit()->first()->NameEn;
  $StoreNemo=$st->NameEn;

  }

    $Av=$this->ProAvQties($store,$row->Product,$rr->Barcode);
      if(!empty($Av->Qty)){
         $AvQty=$Av->Qty;
      }else{

         $AvQty=0;
      }


     if($row->P_Type != 'Service') {
         if (!empty($Group) and !empty($Brand)) {

             if ($row->Product()->first()->Group == $Group and $branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty,
                     'search'=>$search,

                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }

         } elseif (!empty($Group) and empty($Brand)) {


             if ($row->Product()->first()->Group == $Group) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty,
                     'search'=>$search,
                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }


         } elseif (empty($Group) and !empty($Brand)) {

             if ($branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty,
                     'search'=>$search,
                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }


         } elseif (empty($Group) and empty($Brand)) {

             $Filter = [

                 'vendor' => $vendor,
                 'store' => $store,
                 'product' => $row->Product,
                 'name_ar' => $row->P_Ar_Name,
                 'name_en' => $row->P_En_Name,
                 'type' => $type,
                 'PrrroName' => $PrrroName,
                 'UniiName' => $UniiName,
                 'StoreNemo' => $StoreNemo,
                 'AvQty' => $AvQty,
                 'search'=>$search,
             ];

             $output .= $service->ItemsFilterShort($Filter);

         }

     }

  }
  }}


  }else
  {
  $output = '
  <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
  ';
  }
  $data = array(
  'table_data' => $output,
  );
  echo json_encode($data);
  }
  }

  function PurchacesProductsSearchCodeFilter(Request $request,PurchasesService $service)
  {

  if($request->ajax())
  {
  $output = '';
  $search = $request->get('search');
  $store = $request->get('store');
  $vendor = $request->get('vendor');
  $Brand = $request->get('Brand');
  $Group = $request->get('Group');

  if($search != '' and $store != '')
  {
  $data =$this->FilterPurchProductSearchCode($search,$Brand,$Group);
  }


  $total_row = $data->count();
  if($total_row > 0)
  {

  $st=Stores::find($store);


  foreach($data as $row){

       if($row->P_Type != 'Assembly'){
       if(is_numeric($search)){

     $ser_x=1;
     $ser_y=0;

    }else{


        $ser_x=1;
     $ser_y=1;


 }



 if($row->Def == $ser_x or $row->Def == $ser_y){


  $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();

      if(!empty($row->Product()->first()->Brand)){

          $branddX=$row->Product()->first()->Brand;
          if(app()->getLocale() == 'ar' ){
              $brandd=$row->Product()->first()->Brand()->first()->Name;

          }else{
              $brandd=$row->Product()->first()->Brand()->first()->NameEn;
          }

      }else{

          $brandd="";
          $branddX="";

      }



  if($row->P_Type == 'Completed' or $row->P_Type == 'Raw' or $row->P_Type == 'Service' or $row->P_Type == 'Industrial' or $row->P_Type == 'Additions'){
  $type=1;
  }elseif($row->P_Type == 'Serial'){
  $type=2;
  }elseif($row->P_Type == 'Single_Variable'){
  $type=3;
  }elseif($row->P_Type == 'Duble_Variable'){
  $type=4;

  }

  if(app()->getLocale() == 'ar' ){
  $PrrroName=$row->P_Ar_Name;
  $UniiName=$row->Unit()->first()->Name;
  $StoreNemo=$st->Name;

  }else{
  $PrrroName=$row->P_En_Name;
  $UniiName=$row->Unit()->first()->NameEn;
  $StoreNemo=$st->NameEn;

  }

     if($row->P_Type != 'Service') {
         if (!empty($Group) and !empty($Brand)) {

             if ($row->Product()->first()->Group == $Group and $branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,


                 ];

                 $output .= $service->ItemsFilter($Filter);

             }

         } elseif (!empty($Group) and empty($Brand)) {


             if ($row->Product()->first()->Group == $Group) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,


                 ];

                 $output .= $service->ItemsFilter($Filter);

             }


         } elseif (empty($Group) and !empty($Brand)) {

             if ($branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,


                 ];

                 $output .= $service->ItemsFilter($Filter);

             }


         } elseif (empty($Group) and empty($Brand)) {

             $Filter = [

                 'vendor' => $vendor,
                 'store' => $store,
                 'product' => $row->Product,
                 'name_ar' => $row->P_Ar_Name,
                 'name_en' => $row->P_En_Name,
                 'type' => $type,
                 'PrrroName' => $PrrroName,
                 'UniiName' => $UniiName,
                 'StoreNemo' => $StoreNemo,


             ];

             $output .= $service->ItemsFilter($Filter);

         }
     }


  }
  }}


  }else
  {
  $output = '
  <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
  ';
  }
  $data = array(
  'table_data' => $output,
  );
  echo json_encode($data);
  }
  }

 function ShortcomingsProductsSearchCodeFilter(Request $request,PurchasesService $service)
  {

  if($request->ajax())
  {
  $output = '';
  $search = $request->get('search');
  $store = $request->get('store');
  $vendor = $request->get('vendor');
  $Brand = $request->get('Brand');
  $Group = $request->get('Group');

  if($search != '' and $store != '')
  {
  $data =$this->FilterPurchProductSearchCodeShort($search,$Brand,$Group);
  }


  $total_row = $data->count();
  if($total_row > 0)
  {

  $st=Stores::find($store);


  foreach($data as $row){
 if($row->P_Type != 'Assembly'){
       if(is_numeric($search)){

     $ser_x=1;
     $ser_y=0;

    }else{


        $ser_x=1;
     $ser_y=1;


 }



 if($row->Def == $ser_x or $row->Def == $ser_y){


  $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();

      if(!empty($row->Product()->first()->Brand)){

          $branddX=$row->Product()->first()->Brand;
          if(app()->getLocale() == 'ar' ){
              $brandd=$row->Product()->first()->Brand()->first()->Name;

          }else{
              $brandd=$row->Product()->first()->Brand()->first()->NameEn;
          }

      }else{

          $brandd="";
          $branddX="";

      }


      if($row->P_Type == 'Completed' or $row->P_Type == 'Raw' or $row->P_Type == 'Service' or $row->P_Type == 'Industrial' or $row->P_Type == 'Additions'){
  $type=1;
  }elseif($row->P_Type == 'Serial'){
  $type=2;
  }elseif($row->P_Type == 'Single_Variable'){
  $type=3;
  }elseif($row->P_Type == 'Duble_Variable'){
  $type=4;

  }

  if(app()->getLocale() == 'ar' ){
  $PrrroName=$row->P_Ar_Name;
  $UniiName=$row->Unit()->first()->Name;
  $StoreNemo=$st->Name;

  }else{
  $PrrroName=$row->P_En_Name;
  $UniiName=$row->Unit()->first()->NameEn;
  $StoreNemo=$st->NameEn;

  }

         $Av=$this->ProAvQties($store,$row->Product,$rr->Barcode);
      if(!empty($Av->Qty)){
         $AvQty=$Av->Qty;
      }else{

         $AvQty=0;
      }

     if($row->P_Type != 'Service') {
         if (!empty($Group) and !empty($Brand)) {

             if ($row->Product()->first()->Group == $Group and $branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty->Qty,

                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }

         } elseif (!empty($Group) and empty($Brand)) {


             if ($row->Product()->first()->Group == $Group) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty,

                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }


         } elseif (empty($Group) and !empty($Brand)) {

             if ($branddX == $Brand) {

                 $Filter = [

                     'vendor' => $vendor,
                     'store' => $store,
                     'product' => $row->Product,
                     'name_ar' => $row->P_Ar_Name,
                     'name_en' => $row->P_En_Name,
                     'type' => $type,
                     'PrrroName' => $PrrroName,
                     'UniiName' => $UniiName,
                     'StoreNemo' => $StoreNemo,
                     'AvQty' => $AvQty,

                 ];

                 $output .= $service->ItemsFilterShort($Filter);

             }


         } elseif (empty($Group) and empty($Brand)) {

             $Filter = [

                 'vendor' => $vendor,
                 'store' => $store,
                 'product' => $row->Product,
                 'name_ar' => $row->P_Ar_Name,
                 'name_en' => $row->P_En_Name,
                 'type' => $type,
                 'PrrroName' => $PrrroName,
                 'UniiName' => $UniiName,
                 'StoreNemo' => $StoreNemo,
                 'AvQty' => $AvQty,

             ];

             $output .= $service->ItemsFilterShort($Filter);

         }
     }


  }
  }}


  }else
  {
  $output = '
  <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
  ';
  }
  $data = array(
  'table_data' => $output,
  );
  echo json_encode($data);
  }
  }


  public function UnitPurchasesFilter(Average $service) {

  $id=request('countryId');
  $Pro=request('Pro');
  $store=request('store');
  $code=request('code');

  $plow=ProductUnits::where('Product',$Pro)->where('Rate',1)->first();
  $rate = ProductUnits::where("Unit",$id)->where('Product',$Pro)->first();
  $x = ProductsQty::where('Product',$Pro)
  ->where('P_Code',$code)
  ->where('Store',$store)->first();

  if(empty($x)){

  $x = ProductsQty::where('Product',$Pro)
  ->where('PP_Code',$code)
  ->where('Store',$store)->first();

  if(empty($x)){
  $x = ProductsQty::where('Product',$Pro)
  ->where('PPP_Code',$code)
  ->where('Store',$store)->first();


  if(empty($x)){
  $x = ProductsQty::where('Product',$Pro)
  ->where('PPPP_Code',$code)
  ->where('Store',$store)->first();


  }



  }



  }


  $price=$service->AverageCostGetUnit($Pro,$rate->Barcode,$store,$id);

  $states=[];


  if(app()->getLocale() == 'ar' ){
  $states += ["name" => $rate->Unit()->first()->Name ,'code' => $rate->Barcode ,'price' => $price , 'rate' => $rate->Product()->first()->Tax()->first()->Rate , 'type' => $rate->Product()->first()->Tax()->first()->Type ,'tax' => $rate->Product()->first()->Tax ,'priceOne' => $rate->Price ,'priceTwo' => $rate->Price_Two ,'priceThree' => $rate->Price_Three];

  }else{

  $states += ["name" => $rate->Unit()->first()->NameEn ,'code' => $rate->Barcode ,'price' => $price , 'rate' => $rate->Product()->first()->Tax()->first()->Rate , 'type' => $rate->Product()->first()->Tax()->first()->Type ,'tax' => $rate->Product()->first()->Tax ,'priceOne' => $rate->Price ,'priceTwo' => $rate->Price_Two ,'priceThree' => $rate->Price_Three];

  }

  return response()->json($states);

  }

  public function AccountBalanceFilter($id) {

  $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
  $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
  $dif=$debt - $crdt ;


  $states = [$dif,$dif];

  return response()->json($states);

  }


  public function NewAccountBalanceFilter($id) {

  $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
  $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
  $dif=$debt - $crdt ;

  $Cust=Customers::where('Account',$id)->first();
  if(!empty($Cust)){


      if(!empty($Cust->Credit_Limit)){
          $limit=$Cust->Credit_Limit;
      }else{
          $limit=0;
      }


  }else{
      $Vend=Vendors::where('Account',$id)->first();

      if(!empty($Vend)){

          if(!empty($Vend->Credit_Limit)){
              $limit=$Vend->Credit_Limit;
          }else{
              $limit=0;
          }



      }else{
          $limit=0;
      }

  }

      $xx=number_format($dif, 2, '.', ',');

  $states = ['credit'=>$xx,'limit'=>$limit];

  return response()->json($states);

  }


  public function AccountBalanceSFilter($id) {

  $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
  $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
  $dif=$debt - $crdt ;

      $states = [$dif,$dif];


      return response()->json($states);

  }

  public function StoreNamePurchasesFilter($id) {

  $rate = Stores::find($id);


  $states=[];

  if(app()->getLocale() == 'ar' ){
  $states += ["name" => $rate->Name];
  }else{
  $states += ["name" => $rate->NameEn];
  }

  return response()->json($states);

  }

  public function TaxNamePurchasesFilter($id) {

  $rate = Taxes::find($id);

  $states=[];

  $states += ["rate" => $rate->Rate,
      "type"=>$rate->Type,
      "tax" =>$rate->id,
      "AccountCode" =>$rate->Account()->first()->Code,
      "AccountName" =>$rate->Name,
      "Account" =>$rate->Account,
  ];

  return response()->json($states);

  }

  public function StorePricePurchasesFilter(Request $request , Average $service) {


  $Product = $request->get('Product');
  $store = $request->get('Store');
  $Unit = $request->get('Unit');
  $Code = $request->get('Code');

  $states=[];

  $rr=ProductUnits::where('Product',$Product)->where('Def',1)->first();
  $plow=ProductUnits::where('Product',$Product)->where('Rate',1)->first();
      $rate = ProductUnits::where("Unit",$Unit)->where('Product',$Product)->first();
  $pr=$service->AverageCostGetUnit($Product,$rate->Barcode,$store,$Unit);

  $states += ["price" => $pr];

  return response()->json($states);

  }

  public function ViraFilterPurchases($id) {
  $x = ProductsVira::where('Product',$id)->get();

  $states=[];

  foreach($x as $d){

  if(app()->getLocale() == 'ar' ){
  $states += ["$d->V1" => $d->V1()->first()->Name];
  }else{

  $states += ["$d->V1" => $d->V1()->first()->NameEn];
  }

  }


  return response()->json($states);

  }

  public function ViraNamePurchases($id) {

  $x = ProductsVira::where('Product',$id)->get();

  $states=[];

  foreach($x as $d){

  if(app()->getLocale() == 'ar' ){
  $f=$d->V1()->first()->Name;

  $states += [ $d->V1.$d->V2 => $d->V1()->first()->Name. " - " . $d->V2()->first()->Name];
  }else{
  $f=$d->V1()->first()->NameEn;

  $states += [ $d->V1.$d->V2 => $d->V1()->first()->NameEn. " - " . $d->V2()->first()->NameEn];

  }

  }




  return response()->json($states);

  }


  //Change Price Unit Ajax
  public function ChangePriceUnit(){

  $Pone=request('POne');
  $Ptwo=request('PTwo');
  $Pthree=request('PThree');
  $id=request('ID');
  ProductUnits::where('id',$id)->update(['Price'=>$Pone,'Price_Two'=>$Ptwo,'Price_Three'=>$Pthree]);

  $states=['SUCEESS'=>'SUCEESS'];
  return response()->json($states);

  }


  //Add New Vendor by Ajax
  public function AddNewVendor(){


  try {
  DB::beginTransaction();


  $co=request('co');
  $name=request('Name');
  $nameEn=request('NameEn');
  $price=request('PriceLevel');





  $Acc=$this->CreateAccount($name,$nameEn ,37 ,null);

  $CodeUser=$this->ReturnCode(Vendors::class);


  $dataa['Code']=$CodeUser;
  $dataa['Name']=$name;
  $dataa['NameEn']=request('NameEn');
  $dataa['Price_Level']=$price;
  $dataa['Account']=$Acc;
  $dataa['User']=auth()->guard('admin')->user()->id;

  Vendors::create($dataa);


  $dataUser=[
  'screen_ar'=>'الموردين',
  'screen_en'=>'Vendors',
  'explain_ar'=>$name,
  'explain_en'=>$nameEn,
  ];
  $this->UserCreateMoves($dataUser);

  DB::commit();

  $states=['SUCEESS'=>'SUCEESS'];
  return response()->json($states);



  }catch(\Exception $ex){

  $MODEL=Vendors::class;
  DB::rollBack();
  Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

  session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
  return back();

  }catch(\Error $ex){


  $MODEL=Vendors::class;
  DB::rollBack();
  Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

  session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
  return back();

  }


  }


    //  ============ End Filters =================

    //Purchases Order

  public function PurchasesOrderSechdule(){


      $def=PurchasesDefaultData::latest('id')->first();
      $Settung=ModuleSettingsNum::latest('id')->first();
      if($def->Hide_Edit_Delete == 1){
          $items=PurchasesOrder::orderBy('id','desc')->paginate(10);
      }else{

          $items=PurchasesOrder::latest('id')
              ->where('Edit',0)
              ->where('Delete',0)
              ->paginate(10);

      }



      $CostCenters=CostCenter::query();
      $Coins=Coins::query();
      $Stores=Stores::query()->type()->get();
      $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
      $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
      $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
      $Users = Admin::query();
         return view('admin.Purchases.PurchasesOrderSechdule',get_defined_vars());
    }

 public function PurchasesOrderPage(){

         $CostCenters=CostCenter::all();
             $Coins=Coins::all();
             $Stores=Stores::type()->get();
             $Brands=Brands::all();
      $ImportExpensesTypes=ImportExpensesTypes::all();
             $ItemsGroups=ItemsGroups::all();
             $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
             $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
             $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
             $ChecksTypes=ChecksTypes::all();
             $Units=Measuerments::all();
             $Def=PurchasesDefaultData::orderBy('id','desc')->first();
             $show=DefaultDataShowHide::orderBy('id','desc')->first();
             $credStyle="none";
             $title=trans('admin.Purchases_Order');
             $urll=url('AddPurchasesOrder');
             $Code=$this->ReturnCode(PurchasesOrder::class);
             $CodeUser=$this->ReturnCode(Vendors::class);
   $Place='Purchases_Order';
         return view('admin.Purchases.PurchasesOrder',get_defined_vars());
    }

  public function PurchOrderQtyPage($id){
        $item=PurchasesOrder::find($id);
        $details=ProductsPurchasesOrder::where('P_Order',$item->id)->get();
      $CostCenters=CostCenter::query();
      $Coins=Coins::query();
      $Stores=Stores::query()->type()->get();
      $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
      $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
      $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
      $Users = Admin::query();

               if($item->ToPurch == 1){
   session()->flash('error',trans('admin.Already_Done'));
               return redirect('PurchasesOrderSechdule');

                    }
         return view('admin.Purchases.PurchasesOrderQty',get_defined_vars() );
    }

  public function PurchOrdPrint($id){

           $item=PurchasesOrder::findOrFail($id);
         $details=ProductsPurchasesOrder::where('P_Order',$item->id)->get();
         $detailsTwo=ProductsPurchasesOrder::where('P_Order',$item->id)->select('Product')->distinct()->get();
        $title=trans('admin.Purchases_Order');
        $Def=CompanyData::orderBy('id','desc')->first();
        $o=0;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $Print=CustomPrint::orderBy('id','desc')->first();
        $Place='Purchases_Order';


         return view('admin.Purchases.PurchasesOrderPrint',get_defined_vars());
    }

  public function EditPurchasesOrder($id){


          $item=PurchasesOrder::findOrFail($id);
        $details=ProductsPurchasesOrder::where('P_Order',$item->id)->get();
        $Importss=PurchasesOrderExpensesTypes::where('PurchasesOrder',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
       $ImportExpensesTypes=ImportExpensesTypes::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Edit_Purchases_Bill');
        $urll=url('PostEditPurchasesBill/'.$item->id);
        $Code=$this->ReturnCode(PurchasesOrder::class);
        $CodeUser=$this->ReturnCode(Vendors::class);

         $Place='Purchases_Order';


               if($item->ToPurch == 1){
   session()->flash('error',trans('admin.Already_Done'));
               return redirect('PurchasesOrderSechdule');

                    }


         return view('admin.Purchases.EditPurchasesOrder',get_defined_vars());
    }

 public function RenewalPurchasesOrder($id){


      try {
    DB::beginTransaction();

  if(!empty(request('Unit'))){
             ProductsPurchasesOrder::where('P_Order',$id)->delete();
              $P_Ar_Name=request('P_Ar_Name');
              $P_En_Name=request('P_En_Name');
              $Unit=request('Unit');
              $P_Code=request('P_Code');
              $Qty=request('Qty');
              $Price=request('Price');
              $Discount=request('Discount');
              $TotalBFTax=request('TotalBFTax');
              $TotalTax=request('TotalTax');
              $PurchTax=request('PurchTax');
              $Total=request('Total');
              $StorePurch=request('StorePurch');
              $Exp_Date=request('Exp_Date');
              $Product=request('Product');
              $VOne=request('VOne');
              $VTwo=request('VTwo');
              $V_Name=request('V_Name');
              $VV_Name=request('VV_Name');
              $Exp_Date=request('Exp_Date');
              $TDiscount=request('TDiscPro');

            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['P_Order']=$id;
                $uu['Date']=request('Date');
                $uu['Vendor']=request('Vendor');

                if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                $my_value = $V_Name[$i];
                $first_word = explode(' - ',trim($my_value))[0];
                $second_word = explode(' - ',trim($my_value))[1];

                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();


                if(empty($vId)){
                $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                }

                if(empty($vvId)){
                $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                }
                $uu['V1']=$vId->id;
                $uu['V2']=$vvId->id;

                }else{

                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                }

                ProductsPurchasesOrder::create($uu);


                }

          }

     PurchasesOrder::where('id',$id)->update([
         'Quantity'=>1,
         'Quantity_Note'=>request('Quantity_Note'),
         'Product_Numbers'=>request('Product_Numbers'),
         'Total_Qty'=>request('Total_Qty'),
         'Total_Discount'=>request('Total_Discount'),
         'Total_BF_Taxes'=>request('Total_BF_Taxes'),
         'Total_Taxes'=>request('Total_Taxes'),
         'Total_Price'=>request('Total_Price'),
     ]);


            DB::commit();

             session()->flash('success',trans('admin.Updated'));
             return redirect('PurchasesOrderSechdule');


     }catch(\Exception $ex){

     $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



    }

  public function PostQuality($id) {

       try {
    DB::beginTransaction();

          PurchasesOrder::where('id',$id)->update(['Quality'=>request('Quality'),'Quality_Note'=>request('Quality_Note')]);

      DB::commit();
          return back();

            }catch(\Exception $ex){

     $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }

    }


  public function AddPurchasesOrder(PurchasesRequest $request,PurchasesService $service){

            try {
    DB::beginTransaction();


    $validated = $request->validated();

                   $purch = PurchasesDefaultData::orderBy('id', 'desc')->first();

                    if($purch->Quality_Qty == 1){
                    $quality=0;
                    $quantity=0;
                    }else{
                    $quality=1;
                    $quantity=1;
                    }




                    if(request('Payment_Method') == 'Cash'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }elseif(request('Payment_Method') == 'Later'){

                    if(!empty(request('Pay'))){
                    $SafyFatora= request('Pay') ;
                    $paid = request('Pay') ;
                    }else{
                    $SafyFatora= 0 ;
                    $paid = 0 ;
                    }

                    }elseif(request('Payment_Method') == 'Check'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }

                    $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);

                    if($SafeBalance == 1){
                    session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                    return back();

                    }


                    $branch=Stores::find(request('Store'));
                    $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

                    if(!empty($branch)){
                    $BRAAA=$branch->Branch;
                    }else{
                    $BRAAA=null;
                    }

                    if(!empty($custG)){
                    $CUSTGROP=$custG->Group;
                    }else{
                    $CUSTGROP=null;
                    }


                    $image=request()->file('File');
                    $zFile=$this->UploadFile($image);
                $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;


                $ID = DB::table('purchases_orders')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'Check_Type' => request('Check_Type'),
            'ImportTotalCost' => request('ImportTotalCost'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'DiscountBill' =>request('DiscountBill'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'ToPurch' =>0,

            'Edit_New_Code' =>0,
            'Quality' => $quality,
            'Quality_Note' => null,
            'Quantity' => $quantity,
            'Quantity_Note' => null,
            'Purchases_Date' => request('Purchases_Date'),

        )
    );



                 //Purchases Event
         $Bill_Code=PurchasesOrder::findOrFail($ID);




           //Service
                $service->SaveNewPurchOrder($request->all(),$ID);


              $dataUser=[
    'screen_ar'=>'امر الشراء',
    'screen_en'=>'Purchases Order',
    'explain_ar'=>$Bill_Code->Code,
    'explain_en'=>$Bill_Code->Code,
    ];
    $this->UserCreateMoves($dataUser);


         DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));

        if(request('SP') == 0){  return back(); }elseif(request('SP') == 1){  return redirect('PurchOrdPrint/'.$ID); }



                 }catch(\Exception $ex){

     $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }


    }


  public function PostEditPurchasesOrder(PurchasesRequest $request,PurchasesService $service,$id){

            try {
    DB::beginTransaction();


    $validated = $request->validated();



                  $del=PurchasesOrder::find($id);
                Event::where('Type_Code',$del->Code)->where('Type','امر الشراء')->delete();

    Notifications::where('Type_Code',$del->Code)->where('Type','امر شراء')->delete();

     PurchasesOrderExpensesTypes::where('PurchasesOrder',$del->id)->delete();            
            PurchasesOrder::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);

      $purch = PurchasesDefaultData::orderBy('id', 'desc')->first();
                    if($purch->Quality_Qty == 1){
                    $quality=0;
                    $quantity=0;
                    }else{
                    $quality=1;
                    $quantity=1;
                    }

                    $validated = $request->validated();


                    if(request('Payment_Method') == 'Cash'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }elseif(request('Payment_Method') == 'Later'){

                    if(!empty(request('Pay'))){
                    $SafyFatora= request('Pay') ;
                    $paid = request('Pay') ;
                    }else{
                    $SafyFatora= 0 ;
                    $paid = 0 ;
                    }

                    }elseif(request('Payment_Method') == 'Check'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }

                    $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);

                    if($SafeBalance == 1){
                    session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                    return back();

                    }


                    $branch=Stores::find(request('Store'));
                    $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

                    if(!empty($branch)){
                    $BRAAA=$branch->Branch;
                    }else{
                    $BRAAA=null;
                    }

                    if(!empty($custG)){
                    $CUSTGROP=$custG->Group;
                    }else{
                    $CUSTGROP=null;
                    }


                    $image=request()->file('File');
                    $zFile=$this->UploadFile($image);
                $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

           $ID = DB::table('purchases_orders')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'ImportTotalCost' =>request('ImportTotalCost'),
            'DiscountBill' =>request('DiscountBill'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'ToPurch' =>0,
            'Edit_New_Code' =>0,
            'Quality' => $quality,
            'Quality_Note' => null,
            'Quantity' => $quantity,
            'Quantity_Note' => null,
            'Purchases_Date' => request('Purchases_Date'),

        )
    );




                 //Purchases Event
         $Bill_Code=PurchasesOrder::findOrFail($ID);




           //Service
                $service->SaveNewPurchOrder($request->all(),$ID);


              $dataUser=[
    'screen_ar'=>'امر الشراء',
    'screen_en'=>'Purchases Order',
    'explain_ar'=>request('Old_Code'),
    'explain_en'=>request('Old_Code'),
    ];
    $this->UserUpdateMoves($dataUser);


         DB::commit();


             session()->flash('success',trans('admin.Updated'));
             return redirect('PurchasesOrderSechdule');

                 }catch(\Exception $ex){

     $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }


    }


  public function DeletePurchasesOrder($id){

                try {
    DB::beginTransaction();

                        $del=PurchasesOrder::find($id);


                Event::where('Type_Code',$del->Code)->where('Type','امر الشراء')->delete();
    Notifications::where('Type_Code',$del->Code)->where('Type','امر شراء')->delete();
            PurchasesOrder::where('id',$id)->update(['Delete'=>1]);

 PurchasesOrderExpensesTypes::where('PurchasesOrder',$del->id)->delete();

         $dataUser=[
    'screen_ar'=>'امر الشراء',
    'screen_en'=>'Purchases Order',
    'explain_ar'=>$del->Code,
    'explain_en'=>$del->Code,
    ];
    $this->UserDeleteMoves($dataUser);


         DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();


                 }catch(\Exception $ex){

     $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=PurchasesOrder::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }

           }


    //Shortcomings

        public function ShortcomingsPage(){


         $CostCenters=CostCenter::all();
             $Coins=Coins::all();
             $Stores=Stores::type()->get();
             $Brands=Brands::all();
             $ImportExpensesTypes=ImportExpensesTypes::all();
             $ItemsGroups=ItemsGroups::all();
             $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
             $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
             $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
             $ChecksTypes=ChecksTypes::all();
             $Units=Measuerments::all();
             $Def=PurchasesDefaultData::orderBy('id','desc')->first();
             $show=DefaultDataShowHide::orderBy('id','desc')->first();
             $credStyle="none";
             $title=trans('admin.Shortcomings');
             $urll=url('AddShortcomings');
             $Code=$this->ReturnCode(Shortcomings::class);
             $CodeUser=$this->ReturnCode(Vendors::class);
               $Models=ManufacturingModel::all();
            $Place='Shortcomings';
         return view('admin.Purchases.Shortcomings',get_defined_vars());
    }

      public function EditShortcomingsPage(){

          $id=request('ID');
             $item=Shortcomings::find($id);
        $details=ProductsShortcomings::where('Shortmings',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
           $ImportExpensesTypes=ImportExpensesTypes::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.EditShortcomings');
        $urll=url('PostEditShortcomings');
        $Code=$this->ReturnCode(Shortcomings::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
   $Place='Shortcomings';

        $Models=ManufacturingModel::all();



               if($item->ToPurch == 1){
   session()->flash('error',trans('admin.Already_Done'));
               return redirect('ShortcomingsSechdule');

                    }


         return view('admin.Purchases.EditShortcomings',get_defined_vars());
    }

    public function ShortcomingsPrint($id){



               $item=Shortcomings::findOrFail($id);
         $details=ProductsShortcomings::where('Shortmings',$item->id)->get();
         $detailsTwo=ProductsShortcomings::where('Shortmings',$item->id)->select('Product')->distinct()->get();
        $title=trans('admin.Shortmings');
        $Def=CompanyData::orderBy('id','desc')->first();
        $o=0;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $Print=CustomPrint::orderBy('id','desc')->first();
        $Place='Shortcomings';



         return view('admin.Purchases.ShortcomingsPrint',get_defined_vars());
    }

     public function ShortcomingsSechdulePage(){

         $def=PurchasesDefaultData::latest('id')->first();
         if($def->Hide_Edit_Delete == 1){
             $items=Shortcomings::orderBy('id','desc')->paginate(10);
         }else{

             $items=Shortcomings::latest('id')
                 ->where('Edit',0)
                 ->where('Delete',0)
                 ->paginate(10);

         }





         $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();

         return view('admin.Purchases.ShortcomingsSechdule',get_defined_vars());
    }

      public function AddShortcomings(PurchasesRequest $request,PurchasesService $service){
        try {
    DB::beginTransaction();


    $validated = $request->validated();



                    if(request('Payment_Method') == 'Cash'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }elseif(request('Payment_Method') == 'Later'){

                    if(!empty(request('Pay'))){
                    $SafyFatora= request('Pay') ;
                    $paid = request('Pay') ;
                    }else{
                    $SafyFatora= 0 ;
                    $paid = 0 ;
                    }

                    }elseif(request('Payment_Method') == 'Check'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }

                    $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);

                    if($SafeBalance == 1){
                    session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                    return back();

                    }


                    $branch=Stores::find(request('Store'));
                    $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

                    if(!empty($branch)){
                    $BRAAA=$branch->Branch;
                    }else{
                    $BRAAA=null;
                    }

                    if(!empty($custG)){
                    $CUSTGROP=$custG->Group;
                    }else{
                    $CUSTGROP=null;
                    }


                    $image=request()->file('File');
                    $zFile=$this->UploadFile($image);

            $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;


            $ID = DB::table('shortcomings')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'Edit_New_Code' =>0,
            'Purch_Date' => request('Purchases_Date'),
            'ToPurch' => 0,
            'Purch_Reason' => request('CoPurch_Reasonin'),

        )
    );



                 //Purchases Event
         $Bill_Code=Shortcomings::findOrFail($ID);




           //Service
                $service->SaveNewShortmings($request->all(),$ID);



              $dataUser=[
    'screen_ar'=>'النواقص',
    'screen_en'=>'Shortcomings',
    'explain_ar'=>$Bill_Code->Code,
    'explain_en'=>$Bill_Code->Code,
    ];
    $this->UserCreateMoves($dataUser);


         DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
        if(request('SP') == 0){  return back(); }elseif(request('SP') == 1){  return redirect('ShortcomingsPrint/'.$ID); }


                 }catch(\Exception $ex){

     $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



    }

      public function DeleteShortcomings($id){


               try {
    DB::beginTransaction();

        $del=Shortcomings::find($id);
  Event::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();
            Notifications::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();

                    Shortcomings::where('id',$id)->update(['Delete'=>1]);

                      $dataUser=[
    'screen_ar'=>'النواقص',
    'screen_en'=>'Shortcomings',
    'explain_ar'=>$del->Code,
    'explain_en'=>$del->Code,
    ];
    $this->UserDeleteMoves($dataUser);


         DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();


                 }catch(\Exception $ex){

     $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



           }

     public function PostEditShortcomings(PurchasesRequest $request,PurchasesService $service){


            try {
    DB::beginTransaction();


    $validated = $request->validated();


         $id=request('ID');
         $del=Shortcomings::find($id);
         Event::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();
         Notifications::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();

         Shortcomings::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);

                      if(request('Payment_Method') == 'Cash'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }elseif(request('Payment_Method') == 'Later'){

                    if(!empty(request('Pay'))){
                    $SafyFatora= request('Pay') ;
                    $paid = request('Pay') ;
                    }else{
                    $SafyFatora= 0 ;
                    $paid = 0 ;
                    }

                    }elseif(request('Payment_Method') == 'Check'){

                    $paid = request('Total_Price') ;
                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

                    }

                    $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);

                    if($SafeBalance == 1){
                    session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                    return back();

                    }


                    $branch=Stores::find(request('Store'));
                    $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

                    if(!empty($branch)){
                    $BRAAA=$branch->Branch;
                    }else{
                    $BRAAA=null;
                    }

                    if(!empty($custG)){
                    $CUSTGROP=$custG->Group;
                    }else{
                    $CUSTGROP=null;
                    }


                    $image=request()->file('File');
                    $zFile=$this->UploadFile($image);

                $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;


                $ID = DB::table('shortcomings')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'Edit_New_Code' =>0,
            'Purch_Date' => request('Purchases_Date'),
            'ToPurch' => 0,
            'Purch_Reason' => request('CoPurch_Reasonin'),

        )
    );



                 //Purchases Event
         $Bill_Code=Shortcomings::findOrFail($ID);




           //Service
                $service->SaveNewShortmings($request->all(),$ID);



              $dataUser=[
    'screen_ar'=>'النواقص',
    'screen_en'=>'Shortcomings',
    'explain_ar'=>request('Old_Code'),
    'explain_en'=>request('Old_Code'),
    ];
    $this->UserUpdateMoves($dataUser);


         DB::commit();

             session()->flash('success',trans('admin.Update'));
                return redirect('ShortcomingsSechdule');

                 }catch(\Exception $ex){

     $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Shortcomings::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }


       function ManuProdsFilter(Request $request){

         if($request->ajax())
     {
      $output = '';
      $model = $request->get('model');
      $store = $request->get('store');

    if($model != '')
    {


        $Ins=IncomManufacturingModel::where('Model',$model)->get();
        $Insoo=IncomManufacturingModel::where('Model',$model)->pluck('id','id');

     }

         $total_row = $Ins->count();
      if($total_row > 0)
      {

          foreach($Ins as $in){

           $rr=ProductUnits::where('Product',$in->Product)->where('Def',1)->first();
              $plow=ProductUnits::where('Product',$in->Product)->where('Rate',1)->first();


              $Av=$this->ProAvQties($store,$in->Product,$in->Product_Code);
      if(!empty($Av->Qty)){
         $AvQty=$Av->Qty;
      }else{

         $AvQty=0;
      }

              $average = new Average;
            $pr = $average->AverageCostGet($in->Product,$in->Product_Code, $store);
        $st=Stores::find($in->Store);

                  if(app()->getLocale() == 'ar' ){

                      $UniiName=$in->Unit()->first()->Name;
                      $StoreNemo=$st->Name;

                   }else{

                       $UniiName=$in->Unit()->first()->NameEn;
                       $StoreNemo=$st->NameEn;

                   }



              $output .= '
       <tr id="Row'.$in->id.'">


<input type="hidden"  id="P_Ar_Name'.$in->id.'" value="'.$in->P_Ar_Name.'">

        <input type="hidden"  id="P_En_Name'.$in->id.'" value="'.$in->P_En_Name.'">
        <input type="hidden"  id="Product'.$in->id.'" value="'.$in->Product.'">
         <input type="hidden" id="CodePurch'.$in->id.'"  value="'.$in->Product_Code.'">



         <input type="hidden" id="UnitPurchName'.$in->id.'" value="'.$UniiName.'">
         <input type="hidden" id="OLDTAX'.$in->id.'" value="'.$in->Product()->first()->Tax.'">
         <input type="hidden" id="TaxRate'.$in->id.'" value="'.$in->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$in->id.'" value="'.$in->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$in->id.'" value="'.$in->Product()->first()->Tax.'">

 <input type="hidden" id="AvQty'.$in->id.'" value="'.$AvQty.'">

     <input type="hidden" id="Qty'.$in->id.'"   class="form-control" value="1">
 <input type="hidden" id="Price'.$in->id.'" step="any" value="'.$pr.'"  >
 <input type="hidden" id="Price_Sale'.$in->id.'" step="any" value="'.$rr->Price.'"  >
 <input type="hidden" id="Discount'.$in->id.'" step="any" value="'.$in->Discount.'" >
 <input type="hidden" id="TDiscPro'.$in->id.'" step="any" value="'.$in->Discount.'" >
<input type="hidden" id="TotalBFTax'.$in->id.'"  value="'.$pr.'"  >
<input type="hidden" id="Tax'.$in->id.'"    value="0" >
  <input type="hidden" id="Total'.$in->id.'"   value="'.$pr.'" >
  <input type="hidden" id="UnitPurch'.$in->id.'"   value="'.$in->Unit.'" >
  <input type="hidden" id="StorePurch'.$in->id.'"   value="'.$in->Store.'" >
   <input type="hidden" id="StorePurchName'.$in->id.'"   class="form-control"  value="'.$StoreNemo.'" >
   <input type="hidden"  id="AddBtnPur'.$in->id.'" >
   <input type="hidden"  id="ExpDate'.$in->id.'" value="" >


          </tr>';
          }


      }else
      {
       $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
      }
      $data = array(
       't_data'  => $output,
       'ID'  => $Insoo,
      );
      echo json_encode($data);
     }
     }



//Transfer To Purchases


  public function TransferToPurchases($id){

       $item=PurchasesOrder::findOrFail($id);
        $details=ProductsPurchasesOrder::where('P_Order',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Transfer_To_Purchases');
        $urll=url('PostTransferPurchases');
        $Code=$this->ReturnCode(Purchases::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
                  $ImportExpensesTypes=ImportExpensesTypes::all();
              $Importss=PurchasesOrderExpensesTypes::where('PurchasesOrder',$item->id)->get();
  $Place='Purchases_Order';

               if($item->ToPurch == 1){
   session()->flash('error',trans('admin.Already_Done'));
               return redirect('PurchasesOrderSechdule');

                    }

         return view('admin.Purchases.TransferToPurchases',get_defined_vars());
    }

 public function TransferToPurchasesShortcomings($id){
        $item=Shortcomings::find($id);
      $details=ProductsShortcomings::where('Shortmings',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Transfer_To_Purchases');
        $urll=url('PostTransferPurchases');
        $Code=$this->ReturnCode(Purchases::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
        $ImportExpensesTypes=ImportExpensesTypes::all();

            $Place='Shortcomings';
               if($item->ToPurch == 1){
   session()->flash('error',trans('admin.Already_Done'));
               return redirect('PurchasesOrderSechdule');

                    }

         return view('admin.Purchases.TransferToPurchasesShortcomings',get_defined_vars());
    }


  public function PostTransferPurchases(PurchasesRequest $request){

          try {
    DB::beginTransaction();

    $validated = $request->validated();


         if(request('Payment_Method') == 'Cash'){

         $paid = request('Total_Price') ;
        $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

         }elseif(request('Payment_Method') == 'Later'){

             if(!empty(request('Pay'))){
              $SafyFatora= request('Pay') ;
                 $paid = request('Pay') ;
             }else{
               $SafyFatora= 0 ;
                 $paid = 0 ;
             }

         }elseif(request('Payment_Method') == 'Check'){

         $paid = request('Total_Price') ;
        $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

         }


              if(request('Payment_Method') == 'Cash') {
                  $SafeBalance = $this->SafeCredit(request('Safe'), $SafyFatora);

                  if ($SafeBalance == 1) {
                      session()->flash('error', trans('admin.SafeNotEnoughMoney'));
                      return back();

                  }

              }

              $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;
  $branch=Stores::find(request('Store'));
  $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

         if(!empty($branch)){
         $BRAAA=$branch->Branch;
         }else{
         $BRAAA=null;
         }

        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
            }else{
            $CUSTGROP=null;
            }


               $image=request()->file('File');
             $zFile=$this->UploadFile($image);

              $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

           $ID = DB::table('purchases')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'DiscountBill' => request('DiscountBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
                   'ImportTotalCost' => request('ImportTotalCost'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'Edit_New_Code' =>0,

        )
    );



                 //Purchases Event
         $Bill_Code=Purchases::findOrFail($ID);
         PurchasesEvent::dispatch($request->all(),$ID);


      $id=request('ID');
      $TYPE=request('TYPE');


      if($TYPE == 'Order'){
          $del=PurchasesOrder::findOrFail($id);
         PurchasesOrder::where('id',$id)->update(['ToPurch'=>1,'Edit_New_Code'=>request('Code')]);
           Event::where('Type_Code',$del->Code)->where('Type','امر الشراء')->delete();
    Notifications::where('Type_Code',$del->Code)->where('Type','امر شراء')->delete();
      }else{
           $del=Shortcomings::findOrFail($id);
         Shortcomings::where('id',$id)->update(['ToPurch'=>1,'Edit_New_Code'=>request('Code')]);
            Event::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();
            Notifications::where('Type_Code',$del->Code)->where('Type','النواقص')->delete();
      }


    $dataUser=[
    'screen_ar'=>'المشتريات',
    'screen_en'=>'Purchases',
    'explain_ar'=>$Bill_Code->Code,
    'explain_en'=>$Bill_Code->Code,
    ];
    $this->UserCreateMoves($dataUser);

                DB::commit();



             session()->flash('success',trans('admin.Added_Successfully'));
             return redirect('PurchasesSechdule');


              }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



    }


    //Purchases
     public function PurchasesPage(){

             $CostCenters=CostCenter::all();
             $Coins=Coins::all();
             $Stores=Stores::type()->get();
             $Brands=Brands::all();
             $ImportExpensesTypes=ImportExpensesTypes::all();
             $ItemsGroups=ItemsGroups::all();
             $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
             $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
             $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
             $ChecksTypes=ChecksTypes::all();
             $Units=Measuerments::all();
             $Def=PurchasesDefaultData::orderBy('id','desc')->first();
             $show=DefaultDataShowHide::orderBy('id','desc')->first();
             $credStyle="none";
             $title=trans('admin.Purchases');
             $urll=url('AddPurchases');
             $Code=$this->ReturnCode(Purchases::class);
             $CodeUser=$this->ReturnCode(Vendors::class);

          $Place='Purchases';
         return view('admin.Purchases.Purchases',get_defined_vars());
    }

     public function PurchasesSechdulePage(){


         $def=PurchasesDefaultData::latest('id')->first();
         if($def->Hide_Edit_Delete == 1){
             $items=Purchases::orderBy('id','desc')->with('Delegate','Safe','Vendor')->where('Status',1)->paginate(10);


         }else{

             $items=Purchases::orderBy('id','desc')
                 ->with('Delegate','Safe','Vendor')
                 ->where('Edit',0)
                 ->where('Delete',0)
                 ->where('Status',1)->paginate(10);

         }

         $Settung=ModuleSettingsNum::latest('id')->first();

         $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();
         return view('admin.Purchases.PurchasesSechdule',get_defined_vars());
    }

      public function PurchPrint($id){
        $item=Purchases::find($id);
         $details=ProductsPurchases::where('Purchase',$item->id)->get();
         $detailsTwo=ProductsPurchases::where('Purchase',$item->id)->select('Product')->distinct()->get();
        $title=trans('admin.Purchases');
        $Def=CompanyData::orderBy('id','desc')->first();
        $o=0;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $Print=CustomPrint::orderBy('id','desc')->first();
        $Place='Purchases';
         return view('admin.Purchases.PurchasesPrint',get_defined_vars());
    }

      public function EditPuechasesBillPage($id){
        $item=Purchases::find($id);
        $details=ProductsPurchases::where('Purchase',$item->id)->get();
              $Importss=PurchasesExpensesTypes::where('Purchases',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
           $ImportExpensesTypes=ImportExpensesTypes::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Edit_Purchases_Bill');
        $urll=url('PostEditPurchasesBill');
        $Code=$this->ReturnCode(Purchases::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
   $Place='Purchases';

         return view('admin.Purchases.EditPurchasesBill',get_defined_vars());
    }

     public function AddPurchases(PurchasesRequest $request){

          try {
    DB::beginTransaction();

    $validated = $request->validated();


         if(request('Payment_Method') == 'Cash'){

             $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

             $paid = $SafyFatora ;

         }elseif(request('Payment_Method') == 'Later'){

             if(!empty(request('Pay'))){
              $SafyFatora= request('Pay') ;
                 $paid = request('Pay') ;
             }else{
               $SafyFatora= 0 ;
                 $paid = 0 ;
             }

         }elseif(request('Payment_Method') == 'Check'){

             if(!empty(request('Pay'))){
                 $SafyFatora= request('Pay') ;
                 $paid = request('Pay') ;
             }else{
                 $SafyFatora= 0 ;
                 $paid = 0 ;
             }

         }


              $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;


              if(request('Payment_Method') == 'Cash') {
                  $SafeBalance = $this->SafeCredit(request('Safe'), $SafyFatora);

                  if ($SafeBalance == 1) {
                      session()->flash('error', trans('admin.SafeNotEnoughMoney'));
                      return back();

                  }
              }
              $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

              $branch=Stores::find(request('Store'));
  $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

         if(!empty($branch)){
         $BRAAA=$branch->Branch;
         }else{
         $BRAAA=null;
         }

        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
            }else{
            $CUSTGROP=null;
            }


               $image=request()->file('File');
             $zFile=$this->UploadFile($image);


           $ID = DB::table('purchases')->insertGetId(
        array(



            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'DiscountBill' => request('DiscountBill'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'ImportTotalCost' => request('ImportTotalCost'),
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'Edit_New_Code' =>0,

        )
    );



                 //Purchases Event
         $Bill_Code=Purchases::findOrFail($ID);
         PurchasesEvent::dispatch($request->all(),$ID);



   $dataUser=[
    'screen_ar'=>'المشتريات',
   'screen_en'=>'Purchases',
   'explain_ar'=>$Bill_Code->Code,
   'explain_en'=>$Bill_Code->Code,
    ];
  $this->UserCreateMoves($dataUser);

                DB::commit();
             session()->flash('success',trans('admin.Added_Successfully'));

            if(request('SP') == 0){

                return back();

            }elseif(request('SP') == 1){


                return redirect('PurchPrint/'.$ID);

            }


              }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }

    }

    public function PostEditPurchasesBill(PurchasesRequest $request,PurchasesService $service){

                try {
    DB::beginTransaction();

    $validated = $request->validated();

          //  =======  Remove Qties and General Daily      =======
               $id=request('ID');
             $del=Purchases::findOrFail($id);

         Purchases::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
        $Returns=ReturnPurch::where('Purchase',$del->id)->get();

        if(!empty($Returns)){

        foreach($Returns as $return){
       GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع المشتريات')->delete();
       Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع المشتريات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
       StoresMoves::where('ID',$return->id)->where('Type','مرتجع مشتريات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
       ReturnPurch::where('id',$return->id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
        }
        }

       GeneralDaily::where('Code_Type',$del->Code)->where('Type','المشتريات')->delete();
       Journalizing::where('Code_Type',$del->Code)->where('Type','المشتريات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
       StoresMoves::where('ID',$del->id)->where('Type','مشتريات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
        Notifications::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();
        Event::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();

                     PurchasesExpensesTypes::where('Purchases',$del->id)->delete();

            //Service Remove Qties

        $service->RemoveQties($id,0,request('Code'));


                        //  =======  New Event Purchases =======


          if(request('Payment_Method') == 'Cash'){

         $paid = request('Total_Price') ;
        $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

         }elseif(request('Payment_Method') == 'Later'){

             if(!empty(request('Pay'))){
              $SafyFatora= request('Pay') ;
                 $paid = request('Pay') ;
             }else{
               $SafyFatora= 0 ;
                 $paid = 0 ;
             }

         }elseif(request('Payment_Method') == 'Check'){

         $paid = request('Total_Price') ;
        $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

         }

                    if(request('Payment_Method') == 'Cash') {
                        $SafeBalance = $this->SafeCredit(request('Safe'), $SafyFatora);

                        if ($SafeBalance == 1) {
                            session()->flash('error', trans('admin.SafeNotEnoughMoney'));
                            return back();

                        }
                    }

                    $SafyFatora=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

  $branch=Stores::find(request('Store'));
  $custG=Customers::where('Account',request('Vendor'))->orderBy('id','desc')->first();

         if(!empty($branch)){
         $BRAAA=$branch->Branch;
         }else{
         $BRAAA=null;
         }

        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
            }else{
            $CUSTGROP=null;
            }


               $image=request()->file('File');
             $zFile=$this->UploadFile($image);
                    $SafyFatora_Net=(request('Total_Price') + request('Total_Taxes')) - (request('Total_Discount') + request('DiscountBill')) ;

           $ID = DB::table('purchases')->insertGetId(
        array(


            'Date' => request('Date'),
            'Draw' => request('Draw'),
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Vendor_Bill_Date' => request('Vendor_Bill_Date'),
            'Refernce_Number' => request('Refernce_Number'),
            'Note' => request('Note'),
            'Product_Numbers' => request('Product_Numbers'),
            'Total_Qty' => request('Total_Qty'),
            'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Price' => request('Total_Price'),
            'Pay' => $paid,
            'P_Order_Num' => request('P_Order_Num'),
            'Safe' => request('Safe'),
            'Vendor' => request('Vendor'),
            'Delegate' => request('Delegate'),
            'Store' => request('Store'),
            'Coin' => request('Coin'),
            'Ship' => request('Ship'),
            'ImportTotalCost' => request('ImportTotalCost'),
            'TaxBill' => request('TaxBill'),
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'TaxCode' => 1,
            'File' => $zFile,
            'DiscountBill' => request('DiscountBill'),
            'Check_Type' => request('Check_Type'),
            'Due_Date' => request('Due_Date'),
            'Check_Number' => request('Check_Number'),
            'Cost_Center' => request('Cost_Center'),
            'Later_Due' => request('Later_Due'),
            'User' => auth()->guard('admin')->user()->id,
            'Current_Credit' =>request('Current_Credit'),
            'Residual' =>$SafyFatora - $paid,
            'Total_Net' =>$SafyFatora_Net,
            'Edit' =>0,
            'Delete' =>0,
            'Edit_New_Code' =>0,

        )
    );



                 //Purchases Event
         $Bill_Code=Purchases::findOrFail($ID);
         PurchasesEvent::dispatch($request->all(),$ID);



    $dataUser=[
    'screen_ar'=>'المشتريات',
    'screen_en'=>'Purchases',
    'explain_ar'=>request('Old_Code'),
    'explain_en'=>request('Old_Code'),
    ];
    $this->UserUpdateMoves($dataUser);


                            DB::commit();

             session()->flash('success',trans('admin.Updated'));
             return redirect('PurchasesSechdule');

    }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



    }

    public function DeletePurchaseBill($id,PurchasesService $service){

                  try {
    DB::beginTransaction();

        $del=Purchases::findOrFail($id);

          Purchases::where('id',$id)->update(['Delete'=>1]);
        $Returns=ReturnPurch::where('Purchase',$del->id)->get();
         if(!empty($Returns)){

        foreach($Returns as $return){
       GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع المشتريات')->delete();
       Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع المشتريات')->update(['Delete'=>1]);
       StoresMoves::where('ID',$return->id)->where('Type','مرتجع مشتريات')->update(['Delete'=>1]);
       ReturnPurch::where('id',$return->id)->update(['Delete'=>1]);
        }
        }
       GeneralDaily::where('Code_Type',$del->Code)->where('Type','المشتريات')->delete();
       Journalizing::where('Code_Type',$del->Code)->where('Type','المشتريات')->update(['Delete'=>1]);
       StoresMoves::where('ID',$del->id)->where('Type','مشتريات')->update(['Delete'=>1]);
        Notifications::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();
        Event::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();

        PurchasesExpensesTypes::where('Purchases',$del->id)->delete();
        
              
                      
                      
            //Service Remove Qties

        $service->RemoveQties($id,1,0);


              $dataUser=[
    'screen_ar'=>'المشتريات',
    'screen_en'=>'Purchases',
    'explain_ar'=>$del->Code,
    'explain_en'=>$del->Code,
    ];
    $this->UserDeleteMoves($dataUser);



                DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

    }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }


           }

    public function BarcodePage($id){


             try {
    DB::beginTransaction();

          $item=Purchases::find($id);

          $def=StoresDefaultData::orderBy('id','desc')->first();
          $details=ProductsPurchases::where('Purchase',$id)->get();

          BarcodeProducts::truncate();

          foreach($details as $det){


          $uu['Name']=$det->Product()->first()->P_Ar_Name;
          $uu['Code']=$det->Product_Code;
          $uu['Qty']=$det->Qty;
          $uu['Price']=$det->Price;
          $uu['Group']=$det->Product()->first()->Group;
          $uu['Product']=$det->Product;
          $uu['V1']=$det->V1;
          $uu['V2']=$det->V2;
          $uu['Unit']=$det->Unit;

          BarcodeProducts::create($uu);

          }



          if(!empty(request('Show'))){


          BarcodeShow::truncate();

          $uuS['Company_Name']=1;
          $uuS['Product_Name']=1;
          $uuS['Product_Price']=1;
          $uuS['Coin']=1;
          $uuS['Unit']=1;
          $uuS['Group']=1;
          $uuS['Code']=1;
          $uuS['Logo']=1;

          BarcodeShow::create($uuS);

          }

          $Date=$item->Date;
          $Codee=$item->Vendor()->first()->Code;

          $Settings=BarcodeSettings::all();
          $Set=BarcodeSettings::find($def->Style);
          $Show=BarcodeShow::orderBy('id','desc')->first();
          $Pros=BarcodeProducts::all();

          DB::commit();

            return view('admin.Stores.PurchasesBarcode',get_defined_vars());


              }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



    }



      //Filters Purchases and Purchases Order and Purchases Hold

     public function FilterBillPurchases(){


        $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();
 $Settung=ModuleSettingsNum::latest('id')->first();


$Code=request('Code');
$User=request('User');
$Store=request('Store');
$Vendor=request('Vendor');
$Coin=request('Coin');
$Safe=request('Safe');
$Payment_Method=request('Payment_Method');
$Cost_Center=request('Cost_Center');
$Delegate=request('Delegate');
$Refernce_Number=request('Refernce_Number');
$From=request('From');
$To=request('To');

         $def=PurchasesDefaultData::latest('id')->first();
         if($def->Hide_Edit_Delete == 1){
             $items=Purchases::latest('id')
                 ->with('Delegate','Safe','Vendor')
                 ->where('Status',1)


                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->paginate(10);
         }else{

             $items=Purchases::latest('id')
                 ->with('Delegate','Safe','Vendor')
                 ->where('Status',1)


                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->where('Edit',0)
                 ->where('Delete',0)
                 ->paginate(10);



         }




         $items->appends(request()->query());

         return view('admin.Purchases.PurchasesSechdule',get_defined_vars());
    }

     public function FilterBillPurchasesOrder(){


            $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();
 $Settung=ModuleSettingsNum::latest('id')->first();


$Code=request('Code');
$User=request('User');
$Store=request('Store');
$Vendor=request('Vendor');
$Coin=request('Coin');
$Safe=request('Safe');
$Payment_Method=request('Payment_Method');
$Cost_Center=request('Cost_Center');
$Delegate=request('Delegate');
$Refernce_Number=request('Refernce_Number');
$From=request('From');
$To=request('To');


         $def=PurchasesDefaultData::latest('id')->first();
         if($def->Hide_Edit_Delete == 1){
             $items=PurchasesOrder::latest('id')

                 ->with('Delegate','Safe','Vendor')
                 ->where('Status',1)

                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->paginate(10);
         }else{


             $items=PurchasesOrder::latest('id')

                 ->with('Delegate','Safe','Vendor')
                 ->where('Status',1)

                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->where('Edit',0)
                 ->where('Delete',0)
                 ->paginate(10);



         }





         $items->appends(request()->query());
         return view('admin.Purchases.PurchasesOrderSechdule',get_defined_vars());
    }

     public function FilterBillPurchasesHold(){

    $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();

 $Settung=ModuleSettingsNum::latest('id')->first();

$Code=request('Code');
$User=request('User');
$Store=request('Store');
$Vendor=request('Vendor');
$Coin=request('Coin');
$Safe=request('Safe');
$Payment_Method=request('Payment_Method');
$Cost_Center=request('Cost_Center');
$Delegate=request('Delegate');
$Refernce_Number=request('Refernce_Number');
$From=request('From');
$To=request('To');


         $def=PurchasesDefaultData::latest('id')->first();
         if($def->Hide_Edit_Delete == 1){
             $items=Purchases::latest('id')

                 ->with('Delegate','Safe','Vendor')


                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->where('Status',0)
                 ->paginate(10);


         }else{

             $items=Purchases::latest('id')

                 ->with('Delegate','Safe','Vendor')


                 ->when(!empty($Code), function ($query)  use ($Code) {
                     $query->where('Code', $Code);
                 })

                 ->when(!empty($User), function ($query)  use ($User) {
                     $query->where('User', $User);
                 })
                 ->when(!empty($Store), function ($query)  use ($Store) {
                     $query->where('Store', $Store);
                 })

                 ->when(!empty($Vendor), function ($query)  use ($Vendor) {
                     $query->where('Store', $Vendor);
                 })

                 ->when(!empty($Coin), function ($query)  use ($Coin) {
                     $query->where('Store', $Coin);
                 })

                 ->when(!empty($Safe), function ($query)  use ($Safe) {
                     $query->where('Safe', $Safe);
                 })

                 ->when(!empty($Payment_Method), function ($query)  use ($Payment_Method) {
                     $query->where('Payment_Method', $Payment_Method);
                 })

                 ->when(!empty($Cost_Center), function ($query)  use ($Cost_Center) {
                     $query->where('Cost_Center', $Cost_Center);
                 })

                 ->when(!empty($Delegate), function ($query)  use ($Delegate) {
                     $query->where('Delegate', $Delegate);
                 })

                 ->when(!empty($Refernce_Number), function ($query)  use ($Refernce_Number) {
                     $query->where('Refernce_Number', $Refernce_Number);
                 })

                 ->whereBetween('Date',[$From,$To])
                 ->where('Edit',0)
                 ->where('Delete',0)
                 ->where('Status',0)
                 ->paginate(10);



         }



         $items->appends(request()->query());

          return view('admin.Purchases.PurchasesHold',get_defined_vars());
    }


    //Return Purchases

         public function ReturnPurchasesSechdulePage(){
        $items=ReturnPurch::latest('id')->paginate(100);
         return view('admin.Purchases.ReturnPurchasesSechdule',get_defined_vars());
    }

        public function ReturnPurchPage($id){
        $item=Purchases::find($id);
        $details=ProductsPurchases::where('Purchase',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Edit_Purchases_Bill');
        $urll=url('PostEditPurchasesBill');
        $Code=$this->ReturnCode(ReturnPurch::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
        $def=StoresDefaultData::latest('id')->first();

         return view('admin.Purchases.ReturnPurchases',get_defined_vars());
    }

        public function PostReturnPurchases(Request $request,$id){

            try {
    DB::beginTransaction();


       if(request('Payment_Method') == 'Cash'){

                $paid=request('Total_Return_Value');

            }else{

           if(!empty(request('Pay'))){
                $paid=request('Pay');
           }else{
                $paid=0;
           }


            }

                $item=Purchases::find($id);
                $branch=Stores::find($item->Store);
                $custG=Customers::where('Account',$item->Vendor)->orderBy('id','desc')->first();

         if(!empty($branch)){
           $BRAAA=$branch->Branch;
         }else{
             $BRAAA=null;
         }


            if(!empty($custG)){
           $CUSTGROP=$custG->Group;
         }else{
             $CUSTGROP=null;
         }



    $ID = DB::table('return_purches')->insertGetId(
        array(


            'Date' => date('Y-m-d'),
            'Total_Return_Qty' => request('Total_Return_Qty'),
            'Total_Return_Value' => request('Total_Return_Value'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Total_Discount' => request('Total_Discount'),
            'Purchase' => $id,
            'Refernce_Number' =>$item->Refernce_Number,
            'Safe' =>$item->Safe,
            'Vendor' =>$item->Vendor,
            'Delegate' => $item->Delegate,
            'Store' => $item->Store,
            'Coin' =>$item->Coin ,
            'Cost_Center' =>$item->Cost_Center ,
            'Ship' =>$item->Ship ,
            'Later_Due' =>$item->Later_Due ,
            'Pay' => $paid,
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'Payment_Method' => request('Payment_Method'),
            'User' => auth()->guard('admin')->user()->id,

        )
    );



                 //Return Purchases Event
         $Bill_Code=ReturnPurch::findOrFail($ID);
         ReturnPurchasesEvent::dispatch($request->all(),$ID);


    $dataUser=[
    'screen_ar'=>'مرتجع مشتريات',
    'screen_en'=>'Return Purchases',
    'explain_ar'=>$Bill_Code->Code,
    'explain_en'=>$Bill_Code->Code,
    ];
    $this->UserCreateMoves($dataUser);



           $pr=Purchases::find($id);

            $NTQty= $pr->Total_Qty - request('Total_Return_Qty') ;
            $NTBFTax= $pr->Total_BF_Taxes - request('Total_BF_Taxes') ;
            $NTTax= $pr->Total_Taxes - request('Total_Taxes') ;
            $NTPrice= $pr->Total_Price - request('Total_Return_Value') ;

   Purchases::where('id',$id)
       ->update(['Total_Qty'=>$NTQty,'Total_BF_Taxes'=>$NTBFTax,'Total_Taxes'=>$NTTax,'Total_Price'=>$NTPrice]);

                  DB::commit();

             session()->flash('success',trans('admin.Return_Successfully'));
              return redirect('PurchasesSechdule');

              }catch(\Exception $ex){

     $MODEL=ReturnPurch::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=ReturnPurch::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



        }

    public function ReturnPurchPrint($id){

        $item=ReturnPurch::find($id);

        return view('admin.Purchases.ReturnPurchPrint',get_defined_vars());
    }



    //Purchases Hold
      public function PurchasesHoldPage(){


          $def=PurchasesDefaultData::latest('id')->first();
          if($def->Hide_Edit_Delete == 1){
              $items=Purchases::orderBy('id','desc')->where('Status',0)->paginate(100);
          }else{

              $items=Purchases::orderBy('id','desc')
                  ->where('Edit',0)
                  ->where('Delete',0)
                  ->where('Status',0)->paginate(100);


          }

           $Settung=ModuleSettingsNum::latest('id')->first();



          $CostCenters=CostCenter::query();
        $Coins=Coins::query();
        $Stores=Stores::query()->type()->get();
        $Safes = AcccountingManual::query()->where('Type',1)->safetype()->get();
        $Vendors = AcccountingManual::query()->where('Type',1)->accountpurchtype()->get();
        $Employess = Employess::query()->where('Emp_Type','Buyer')->type()->get();
        $Users = Admin::query();

         return view('admin.Purchases.PurchasesHold',get_defined_vars());
    }

      public function RecivedPurchPage($id){

           $item=Purchases::find($id);
        $details=ProductsPurchases::where('Purchase',$item->id)->get();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Brands=Brands::all();
        $ItemsGroups=ItemsGroups::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
        $Employess = Employess::where('Emp_Type','Buyer')->type()->lazy();
        $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
        $ChecksTypes=ChecksTypes::all();
        $Units=Measuerments::all();
        $Def=PurchasesDefaultData::orderBy('id','desc')->first();
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        $credStyle="none";
        $title=trans('admin.Edit_Purchases_Bill');
        $urll=url('PostEditPurchasesBill');
        $Code=$this->ReturnCode(RecivedPurcht::class);
        $CodeUser=$this->ReturnCode(Vendors::class);
        $def=StoresDefaultData::latest('id')->first();

         return view('admin.Purchases.RecivedPurchases',get_defined_vars());
    }

      public function PostRecivedPurchases($id,Average $average){


                      try {
    DB::beginTransaction();

           $ID = DB::table('recived_purchts')->insertGetId(
        array(

            'Code' => request('CodeR'),
            'Date' => date('Y-m-d'),
            'Total_Trans_Qty' => request('Total_Trans_Qty'),
            'Total_Trans_Value' => request('Total_Trans_Value'),
            'Total_BF_Taxes' => request('Total_BF_Taxes'),
            'Total_Taxes' => request('Total_Taxes'),
            'Purchase' => $id,
            'User' => auth()->guard('admin')->user()->id,

        )
    );

            $Bill_Code=Purchases::findOrFail($id);
$branch=Stores::findOrFail($Bill_Code->Store);


          if(!empty(request('Unit'))){

            StoreCount::truncate();

              $P_Ar_Name=request('P_Ar_Name');
              $P_En_Name=request('P_En_Name');
              $Unit=request('Unit');
              $P_Code=request('P_Code');
              $Qty=request('Qty');
              $Price=request('Price');
              $Discount=request('Discount');
              $TotalBFTax=request('TransTotalBF');
              $TotalTax=request('TransTotTax');
              $PurchTax=request('PurchTax');
              $Total=request('TransTotal');
              $StorePurch=request('StorePurch');
              $Exp_Date=request('Exp_Date');
              $Product=request('Product');
              $VOne=request('VOne');
              $VTwo=request('VTwo');
              $V_Name=request('V_Name');
              $VV_Name=request('VV_Name');
              $Exp_Date=request('Exp_Date');
              $OQty=request('Original_Qty');
              $RQty=request('Recived_Qty');

            for($i=0 ; $i < count($Unit) ; $i++) {

                $pp = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();
                $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();

                if ($RQty[$i] != 0) {

                    $uu['Product_Code'] = $P_Code[$i];
                    $uu['P_Ar_Name'] = $P_Ar_Name[$i];
                    $uu['P_En_Name'] = $P_En_Name[$i];
                    $uu['V_Name'] = $V_Name[$i];
                    $uu['VV_Name'] = $VV_Name[$i];
                    $uu['Original_Qty'] = $OQty[$i];
                    $uu['Recived_Qty'] = $RQty[$i];
                    $uu['Qty'] = $Qty[$i];
                    $uu['Price'] = $Price[$i];
                    $uu['Discount'] = $Discount[$i];
                    $uu['Tax'] = $PurchTax[$i];
                    $uu['Total_Bf_Tax'] = $TotalBFTax[$i];
                    $uu['Total_Tax'] = $TotalTax[$i];
                    $uu['Total'] = $Total[$i];
                    $uu['Store'] = $StorePurch[$i];
                    $uu['Product'] = $Product[$i];
                    $uu['Unit'] = $Unit[$i];
                    $uu['Exp_Date'] = $Exp_Date[$i];
                    $uu['Recived'] = $ID;

                    if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                        $my_value = $V_Name[$i];
                        $first_word = explode(' - ', trim($my_value))[0];
                        $second_word = explode(' - ', trim($my_value))[1];

                        $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                        $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                        if (empty($vId)) {
                            $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                        }

                        if (empty($vvId)) {
                            $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                        }
                        $uu['V1'] = $vId->id;
                        $uu['V2'] = $vvId->id;

                    } else {

                        $uu['V1'] = $VOne[$i];
                        $uu['V2'] = $VTwo[$i];
                    }
                    RecivedPurchProducts::create($uu);


                    $Quantity = $this->ProAvQties($StorePurch[$i], $Product[$i], $P_Code[$i]);


                    if (!empty($Quantity)) {

                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                        $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();

                        $qq = $unit->Rate * $RQty[$i];
                        $newqty = $Quantity->Qty + $qq;

                        $ty = $average->AverageCost($Total[$i], $qq, $Product[$i], $P_Code[$i], $StorePurch[$i], request('Date'), $Price[$i]);

                        $prooooo = Products::findOrFail($Product[$i]);
                        if ($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable') {
                            $lastOperation = ProductMoves::latest('id')->where('Delete', 0)->where('Edit', 0)->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
                        } else {
                            $lastOperation = ProductMoves::latest('id')->where('Delete', 0)->where('Edit', 0)->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
                        }


                        $in = $Total[$i];
                        $out = 0;
                        if (!empty($lastOperation)) {
                            $current = $lastOperation->CostCurrent + $Total[$i];
                        } else {
                            $current = $Total[$i];
                        }
                        $cur = $newqty * $ty;

                        //Add Qty to Store
                        ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Exp_Date' => $Exp_Date[$i], 'Price' => $ty, 'TotalCost' => $cur]);

                        $prooooo = Products::find($Product[$i]);

                        //Product Moves
                        $move = [

                            'Date' => request('Date'),
                            'Type' => 'مشتريات',
                            'TypeEn' => 'Purchases',
                            'Bill_Num' => $Bill_Code->Code,
                            'Incom' => $qq,
                            'Outcom' => 0,
                            'Current' => $newqty,
                            'CostIn' => number_format((float)$in, 2, '.', ''),
                            'CostOut' => number_format((float)$out, 2, '.', ''),
                            'CostCurrent' => number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name' => $P_Ar_Name[$i],
                            'P_En_Name' => $P_En_Name[$i],
                            'P_Code' => $P_Code[$i],
                            'Unit' => $Unit[$i],
                            'Qty' => $RQty[$i],
                            'Group' => $prooooo->Group,
                            'Store' => $StorePurch[$i],
                            'Product' => $Product[$i],
                            'V1' => $VOne[$i],
                            'V2' => $VTwo[$i],
                            'Brand' => $prooooo->Brand,
                            'Safe' => request('Safe'),
                            'Branch' => $branch->Branch,
                            'SalePrice' => $plow->Price,
                            'ProductPrice' => null,
                            'Delegate' => request('Delegate'),
                            'Payment_Method' => request('Payment_Method'),
                            'User' => auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    } else {


                        if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ', trim($my_value))[0];
                            $second_word = explode(' - ', trim($my_value))[1];

                            $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                            $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                            if (empty($vId)) {
                                $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                            }

                            if (empty($vvId)) {
                                $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                            }
                            $sNam = $first_word;
                            $sId = $vId->id;
                            $ssNam = $second_word;
                            $ssId = $vvId->id;

                        } else {

                            $sNam = $V_Name[$i];
                            $ssNam = $VV_Name[$i];
                            $sId = $VOne[$i];
                            $ssId = $VTwo[$i];
                        }


                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name[$i],
                                'P_En_Name' => $P_En_Name[$i],
                                'P_Code' => $P_Code[$i],
                                'Exp_Date' => $Exp_Date[$i],
                                'Product' => $Product[$i],
                                'Store' => $StorePurch[$i],
                                'V1' => $sId,
                                'V2' => $ssId,
                                'V_Name' => $sNam,
                                'VV_Name' => $ssNam,

                            )
                        );

                        $prooooo = Products::find($Product[$i]);
                        $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                        $pqty['Exp_Date'] = $Exp_Date[$i];
                        $pqty['P_En_Name'] = $P_En_Name[$i];
                        $pqty['Qty'] = $RQty[$i] * $pp->Rate;
                        $pqty['Price'] = $Price[$i];
                        $pqty['TotalCost'] = $Price[$i] * $RQty[$i];
                        $pqty['Pro_Stores'] = $id_store;
                        $pqty['Store'] = $StorePurch[$i];
                        $pqty['Unit'] = $Unit[$i];
                        $pqty['Low_Unit'] = $plow->Unit;
                        $pqty['Product'] = $Product[$i];
                        $pqty['Price_Sale'] = 0;

                        $pqty['SearchCode1'] = $prooooo->SearchCode1;
                        $pqty['SearchCode2'] = $prooooo->SearchCode2;
                        if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ', trim($my_value))[0];
                            $second_word = explode(' - ', trim($my_value))[1];

                            $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                            $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                            if (empty($vId)) {
                                $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                            }

                            if (empty($vvId)) {
                                $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                            }
                            $pqty['V1'] = $vId->id;
                            $pqty['V2'] = $vvId->id;
                            $pqty['V_Name'] = $first_word;
                            $pqty['VV_Name'] = $second_word;
                            $pqty['P_Code'] = $P_Code[$i];

                        } else {


                            if ($prooooo->P_Type == 'Serial') {

                                $pqty['V1'] = $VOne[$i];
                                $pqty['V2'] = $VTwo[$i];
                                $pqty['V_Name'] = $V_Name[$i];
                                $pqty['VV_Name'] = $VV_Name[$i];
                                $pqty['P_Code'] = $P_Code[$i];

                            } else {


                                if ($prooooo->P_Type == 'Single_Variable') {
                                    $pqty['V1'] = $VOne[$i];
                                    $pqty['V2'] = $VTwo[$i];
                                    $pqty['V_Name'] = $V_Name[$i];
                                    $pqty['VV_Name'] = $VV_Name[$i];
                                    $pqty['P_Code'] = $P_Code[$i];

                                } elseif ($prooooo->P_Type == 'Duble_Variable') {

                                    $pqty['P_Code'] = $P_Code[$i];

                                } else {


                                    $coco = array();
                                    $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                                    foreach ($CodesPrds as $cco) {


                                        array_push($coco, $cco->Barcode);

                                    }

                                    $pqty['V1'] = $VOne[$i];
                                    $pqty['V2'] = $VTwo[$i];
                                    $pqty['V_Name'] = $V_Name[$i];
                                    $pqty['VV_Name'] = $VV_Name[$i];
                                    $pqty['P_Code'] = $coco[0];

                                    if (!empty($coco[1])) {
                                        $pqty['PP_Code'] = $coco[1];
                                    } else {
                                        $pqty['PP_Code'] = null;
                                    }

                                    if (!empty($coco[2])) {
                                        $pqty['PPP_Code'] = $coco[2];
                                    } else {
                                        $pqty['PPP_Code'] = null;
                                    }

                                    if (!empty($coco[3])) {
                                        $pqty['PPPP_Code'] = $coco[3];
                                    } else {
                                        $pqty['PPPP_Code'] = null;
                                    }

                                }


                            }


                        }

                        $proooooStore = Stores::find($StorePurch[$i]);
                        $pqty['Group'] = $prooooo->Group;
                        $pqty['Brand'] = $prooooo->Brand;
                        $pqty['Branch'] = $proooooStore->Branch;
                        ProductsQty::create($pqty);


                        $prooooo = Products::find($Product[$i]);
                        $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();


                        $newQQty = $RQty[$i] * $pp->Rate;
                        $ty = $average->AverageCost($Total[$i], $newQQty, $Product[$i], $plow->Barcode, $StorePurch[$i], request('Date'), $Price[$i]);


                        if ($ty != 0) {
                            $in = ($RQty[$i] * $pp->Rate) * $ty;
                            $out = 0;
                            $current = ($RQty[$i] * $pp->Rate) * $ty;
                        } else {

                            $in = ($RQty[$i] * $pp->Rate) * 1;
                            $out = 0;
                            $current = ($RQty[$i] * $pp->Rate) * 1;

                        }

                        $move['Date'] = request('Date');
                        $move['Type'] = 'مشتريات';
                        $move['TypeEn'] = 'Purchases';
                        $move['Bill_Num'] = $Bill_Code->Code;
                        $move['Incom'] = $RQty[$i] * $pp->Rate;
                        $move['Outcom'] = 0;
                        $move['Current'] = $RQty[$i] * $pp->Rate;
                        $move['CostIn'] = number_format((float)abs($in), 2, '.', '');
                        $move['CostOut'] = number_format((float)abs($out), 2, '.', '');
                        $move['CostCurrent'] = number_format((float)abs($current), 2, '.', '');
                        $move['P_Ar_Name'] = $P_Ar_Name[$i];
                        $move['P_En_Name'] = $P_En_Name[$i];
                        $move['P_Code'] = $P_Code[$i];
                        $move['Unit'] = $Unit[$i];
                        $move['QTY'] = $Qty[$i];
                        $move['Group'] = $prooooo->Group;
                        $move['Store'] = $StorePurch[$i];
                        $move['Product'] = $Product[$i];
                        $move['V1'] = $VOne[$i];
                        $move['V2'] = $VTwo[$i];
                        $move['User'] = auth()->guard('admin')->user()->id;
                        $Sro = Stores::find($StorePurch[$i]);

                        $move['Brand'] = $prooooo->Brand;
                        $move['Safe'] = request('Safe');
                        $move['Branch'] = $Sro->Branch;
                        $move['SalePrice'] = null;
                        $move['ProductPrice'] = null;
                        $move['Delegate'] = request('Delegate');
                        $move['Payment_Method'] = request('Payment_Method');
                        ProductMoves::create($move);


                    }

                    if ($RQty[$i] != 0) {

                        $prooo = ProductsPurchases::where('Purchase', $id)
                            ->where('Product_Code', $P_Code[$i])
                            ->where('Store', $StorePurch[$i])
                            ->where('Product', $Product[$i])
                            ->where('Unit', $Unit[$i])
                            ->first();

                        $NQty = $prooo->Qty - $RQty[$i];
                        ProductsPurchases::where('id', $prooo->id)->update(['Qty' => $NQty]);


                    }


                    if (!empty($Exp_Date[$i])) {


                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                        $EXPO = $this->ExpireAvQties($StorePurch[$i], $Product[$i], $P_Code[$i]);


                        if (!empty($EXPO)) {


                            if ($EXPO->Exp_Date == $Exp_Date[$i]) {

                                $qq = $unit->Rate * $Qty[$i];

                                $NewExpQty = $EXPO->Qty + $qq;
                                ExpireDateQty::where('id', $EXPO->id)->update(['Qty' => $NewExpQty]);

                            } else {


                                $EXNEW['Qty'] = $unit->Rate * $Qty[$i];
                                $EXNEW['P_Ar_Name'] = $EXPO->P_Ar_Name;
                                $EXNEW['P_En_Name'] = $EXPO->P_En_Name;
                                $EXNEW['P_Code'] = $EXPO->P_Code;
                                $EXNEW['PP_Code'] = $EXPO->PP_Code;
                                $EXNEW['PPP_Code'] = $EXPO->PPP_Code;
                                $EXNEW['PPPP_Code'] = $EXPO->PPPP_Code;
                                $EXNEW['V_Name'] = $EXPO->V_Name;
                                $EXNEW['VV_Name'] = $EXPO->VV_Name;
                                $EXNEW['Store'] = $EXPO->Store;
                                $EXNEW['Unit'] = $EXPO->Unit;
                                $EXNEW['Product'] = $EXPO->Product;
                                $EXNEW['V1'] = $EXPO->V1;
                                $EXNEW['V2'] = $EXPO->V2;
                                $EXNEW['Low_Unit'] = $EXPO->Low_Unit;
                                $EXNEW['Exp_Date'] = $Exp_Date[$i];
                                $EXNEW['Group'] = $EXPO->Group;
                                $EXNEW['Brand'] = $EXPO->Brand;
                                $EXNEW['Branch'] = $EXPO->Branch;

                                ExpireDateQty::create($EXNEW);

                            }


                        } else {

                            if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ', trim($my_value))[0];
                                $second_word = explode(' - ', trim($my_value))[1];

                                $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                if (empty($vId)) {
                                    $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                }

                                if (empty($vvId)) {
                                    $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                }
                                $sNam = $first_word;
                                $sId = $vId->id;
                                $ssNam = $second_word;
                                $ssId = $vvId->id;

                            } else {

                                $sNam = $V_Name[$i];
                                $ssNam = $VV_Name[$i];
                                $sId = $VOne[$i];
                                $ssId = $VTwo[$i];
                            }


                            $EXNEW['Qty'] = $unit->Rate * $RQty[$i];
                            $EXNEW['P_Ar_Name'] = $P_Ar_Name[$i];
                            $EXNEW['P_En_Name'] = $P_En_Name[$i];
                            $EXNEW['P_Code'] = $P_Code[$i];
                            $EXNEW['Store'] = $StorePurch[$i];
                            $EXNEW['V1'] = $sId;
                            $EXNEW['V2'] = $ssId;
                            $EXNEW['Exp_Date'] = $Exp_Date[$i];
                            $EXNEW['Unit'] = $Unit[$i];
                            $EXNEW['Product'] = $Product[$i];
                            $EXNEW['V_Name'] = $sNam;
                            $EXNEW['VV_Name'] = $ssNam;

                            $cocoSS = array();
                            $CodesProducts = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                            foreach ($CodesProducts as $ccoPro) {


                                array_push($cocoSS, $ccoPro->Barcode);

                            }

                            $EXNEW['P_Code'] = $cocoSS[0];

                            if (!empty($coco[1])) {
                                $EXNEW['PP_Code'] = $cocoSS[1];
                            } else {
                                $EXNEW['PP_Code'] = null;
                            }

                            if (!empty($coco[2])) {
                                $EXNEW['PPP_Code'] = $cocoSS[2];
                            } else {
                                $EXNEW['PPP_Code'] = null;
                            }

                            if (!empty($coco[3])) {
                                $EXNEW['PPPP_Code'] = $cocoSS[3];
                            } else {
                                $EXNEW['PPPP_Code'] = null;
                            }

                            $prooooo = Products::find($Product[$i]);
                            $proooooStore = Stores::find($StorePurch[$i]);
                            $EXNEW['Group'] = $prooooo->Group;
                            $EXNEW['Brand'] = $prooooo->Brand;
                            $EXNEW['Branch'] = $proooooStore->Branch;

                            $EXNEW['Low_Unit'] = $plow->Unit;


                            ExpireDateQty::create($EXNEW);


                        }


                    }


                    //Fifo
                    $def = StoresDefaultData::orderBy('id', 'desc')->first();
                    if ($def->Cost_Price == 2) {


                        $fifo = $this->FifoAvQty($StorePurch[$i], $Product[$i], $P_Code[$i], request('Date'));


                        if (!empty($fifo)) {

                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                            $qq = $unit->Rate * $RQty[$i];

                            $newqty = $fifo->Qty + $qq;

                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty, 'Original_Qty' => $newqty]);

                        } else {


                            if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ', trim($my_value))[0];
                                $second_word = explode(' - ', trim($my_value))[1];

                                $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                if (empty($vId)) {
                                    $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                }

                                if (empty($vvId)) {
                                    $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                }
                                $sNam = $first_word;
                                $sId = $vId->id;
                                $ssNam = $second_word;
                                $ssId = $vvId->id;

                            } else {

                                $sNam = $V_Name[$i];
                                $ssNam = $VV_Name[$i];
                                $sId = $VOne[$i];
                                $ssId = $VTwo[$i];
                            }


                            $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                            $pqty['Exp_Date'] = $Exp_Date[$i];
                            $pqty['P_En_Name'] = $P_En_Name[$i];
                            $pqty['Qty'] = $RQty[$i] * $pp->Rate;
                            $pqty['Original_Qty'] = $RQty[$i] * $pp->Rate;
                            $pqty['Cost_Price'] = $Price[$i];
                            $pqty['Store'] = $StorePurch[$i];
                            $pqty['Unit'] = $Unit[$i];
                            $pqty['Low_Unit'] = $plow->Unit;
                            $pqty['Product'] = $Product[$i];

                            $prooooo = Products::find($Product[$i]);
                            $pqty['SearchCode1'] = $prooooo->SearchCode1;
                            $pqty['SearchCode2'] = $prooooo->SearchCode2;
                            if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ', trim($my_value))[0];
                                $second_word = explode(' - ', trim($my_value))[1];

                                $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                if (empty($vId)) {
                                    $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                }

                                if (empty($vvId)) {
                                    $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                }
                                $pqty['V1'] = $vId->id;
                                $pqty['V2'] = $vvId->id;
                                $pqty['V_Name'] = $first_word;
                                $pqty['VV_Name'] = $second_word;
                                $pqty['P_Code'] = $P_Code[$i];

                            } else {


                                if ($prooooo->P_Type == 'Serial') {

                                    $pqty['V1'] = $VOne[$i];
                                    $pqty['V2'] = $VTwo[$i];
                                    $pqty['V_Name'] = $V_Name[$i];
                                    $pqty['VV_Name'] = $VV_Name[$i];
                                    $pqty['P_Code'] = $P_Code[$i];

                                } else {


                                    if ($prooooo->P_Type == 'Single_Variable') {
                                        $pqty['V1'] = $VOne[$i];
                                        $pqty['V2'] = $VTwo[$i];
                                        $pqty['V_Name'] = $V_Name[$i];
                                        $pqty['VV_Name'] = $VV_Name[$i];
                                        $pqty['P_Code'] = $P_Code[$i];

                                    } elseif ($prooooo->P_Type == 'Duble_Variable') {

                                        $pqty['P_Code'] = $P_Code[$i];

                                    } else {


                                        $coco = array();
                                        $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                                        foreach ($CodesPrds as $cco) {


                                            array_push($coco, $cco->Barcode);

                                        }

                                        $pqty['V1'] = $VOne[$i];
                                        $pqty['V2'] = $VTwo[$i];
                                        $pqty['V_Name'] = $V_Name[$i];
                                        $pqty['VV_Name'] = $VV_Name[$i];
                                        $pqty['P_Code'] = $coco[0];

                                        if (!empty($coco[1])) {
                                            $pqty['PP_Code'] = $coco[1];
                                        } else {
                                            $pqty['PP_Code'] = null;
                                        }

                                        if (!empty($coco[2])) {
                                            $pqty['PPP_Code'] = $coco[2];
                                        } else {
                                            $pqty['PPP_Code'] = null;
                                        }

                                        if (!empty($coco[3])) {
                                            $pqty['PPPP_Code'] = $coco[3];
                                        } else {
                                            $pqty['PPPP_Code'] = null;
                                        }

                                    }


                                }


                            }

                            $proooooStore = Stores::find($StorePurch[$i]);
                            $pqty['Group'] = $prooooo->Group;
                            $pqty['Brand'] = $prooooo->Brand;
                            $pqty['Branch'] = $proooooStore->Branch;
                            $pqty['Purchases_Date'] = request('Date');
                            FifoQty::create($pqty);


                        }


                    }


                    // if have more stores Calculate each store one by one
                    $Mkhazns = StoreCount::all();
                    if ($RQty[$i] != 0) {
                        if (count($Mkhazns) == 0) {

                            $s['Store'] = $StorePurch[$i];
                            $s['Total'] = $TotalBFTax[$i];
                            $s['Tax'] = $PurchTax[$i];
                            StoreCount::create($s);

                        } else {


                            $m = StoreCount::where('Store', $StorePurch[$i])->first();

                            if (!empty($m)) {

                                $newTot = $m->Total + $TotalBFTax[$i];
                                StoreCount::where('id', $m->id)->update(['Total' => $newTot]);

                            } else {


                                $s['Store'] = $StorePurch[$i];
                                $s['Total'] = $TotalBFTax[$i];
                                $s['Tax'] = $PurchTax[$i];
                                StoreCount::create($s);

                            }

                        }
                    }


                }
            }

          }

            $NewMkhazns=StoreCount::all();

        $JunID = DB::table('journalizings')->insertGetId(

        array(

            'Type' => 'المشتريات',
            'TypeEn' => 'Purchases',
            'Code_Type' =>$Bill_Code->Code,
            'Date' => date('Y-m-d'),
            'Draw' => request('Draw'),
            'Coin' => request('Coin'),
            'Cost_Center' => request('Cost_Center'),
            'Total_Debaitor' => request('Total_Trans_Value'),
            'Total_Creditor' => request('Total_Trans_Value'),
            'Note' => request('Note'),

        )
    );
        $joun_Code=Journalizing::findOrFail($JunID);


          foreach($NewMkhazns as $new){

         $store=Stores::find($new->Store);


        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=$new->Total;
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$store->Account;
        $PRODUCTSS['Statement']=null;


         JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$joun_Code->Code;
        $Gen['Code_Type']=$Bill_Code->Code;
        $Gen['Date']=date('Y-m-d');
        $Gen['Type']='المشتريات';
        $Gen['TypeEn']='Purchases';
        $Gen['Debitor']=$new->Total;
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * $new->Total;
        $Gen['Creditor_Coin']=request('Draw') * 0;
        $Gen['Account']=$store->Account;
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']=request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;
         GeneralDaily::create($Gen);


        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$new->Total;
        $PRODUCTSS['Account']=71;
        $PRODUCTSS['Statement']=null;
         JournalizingDetails::create($PRODUCTSS);

              $Gen['Code']=$joun_Code->Code;
              $Gen['Code_Type']=$Bill_Code->Code;
        $Gen['Date']=date('Y-m-d');
            $Gen['Type']='المشتريات';
        $Gen['TypeEn']='Purchases';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$new->Total;
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * 0;
        $Gen['Creditor_Coin']=request('Draw') * $new->Total;
        $Gen['Account']=71;
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']= request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;
         GeneralDaily::create($Gen);

          }



          //Check if Recived All Qty or Not
        $BBS=ProductsPurchases::where('Purchase',$id)->get();
        $fg=ProductsPurchases::where('Purchase',$id)->get()->sum('Qty');

          if($fg == 0){

            Purchases::where('id',$id)->update(['Status'=>1]);

            foreach($BBS as $b){

           ProductsPurchases::where('id',$b->id)->update(['Qty'=>$b->Original_Qty]);

          }

          }


                $dataUser=[
    'screen_ar'=>' مشتريات',
    'screen_en'=>' Purchases',
    'type_ar'=>'استلام منتجات',
    'type_en'=>'Recived Products',
    'explain_ar'=>$Bill_Code->Code,
    'explain_en'=>$Bill_Code->Code,
    ];
    $this->UserCustomMoves($dataUser);
DB::commit();


             session()->flash('success',trans('admin.Recived'));
              return redirect('PurchasesHold');


      }catch(\Exception $ex){

     $MODEL=RecivedPurcht::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=RecivedPurcht::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }


    //Recived_Products
     public function Recived_ProductsPage(){
        $items=RecivedPurcht::orderBy('id','desc')->paginate(100);

         return view('admin.Purchases.Recived_Products',['items'=>$items]);
    }


    public function DeleteRecivedProducts($id,PurchasesService $service){

                  try {
    DB::beginTransaction();

        $del=Purchases::findOrFail($id);

          Purchases::where('id',$id)->update(['Delete'=>1]);

       GeneralDaily::where('Code_Type',$del->Code)->where('Type','المشتريات')->delete();
       Journalizing::where('Code_Type',$del->Code)->where('Type','المشتريات')->update(['Delete'=>1]);
       StoresMoves::where('ID',$del->id)->where('Type','مشتريات')->update(['Delete'=>1]);
        Notifications::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();
        Event::where('Type_Code',$del->Code)->where('Type','المشتريات')->delete();




              $dataUser=[
    'screen_ar'=>'المشتريات',
    'screen_en'=>'Purchases',
    'explain_ar'=>$del->Code,
    'explain_en'=>$del->Code,
    ];
    $this->UserDeleteMoves($dataUser);



                DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

    }catch(\Exception $ex){

     $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=Purchases::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }


           }



    
    
    
       //ImportExpensesTypes

            public function ImportExpensesTypes(){
        $items=ImportExpensesTypes::paginate(20);
    

         return view('admin.Purchases.ImportExpensesTypes',get_defined_vars());
    }

          public function AddImportExpensesTypes(Request $request){

     try {
    DB::beginTransaction();



        if(!empty(request('English_Name'))){

         $english_name=request('English_Name');
         }else{

         $english_name=request('Arabic_Name');
         }


         $dataa['Arabic_Name']=request('Arabic_Name');
         $dataa['English_Name']=$english_name;
         ImportExpensesTypes::create($dataa);


           DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
             return back();

            }catch(\Exception $ex){

     $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }

          public function EditImportExpensesTypes(Request $request,$id){

     try {
    DB::beginTransaction();

   


             $dataa['Arabic_Name']=request('Arabic_Name');
         $dataa['English_Name']=request('English_Name');
         ImportExpensesTypes::where('id',$id)->update($dataa);



                     DB::commit();


             session()->flash('success',trans('admin.Updated'));
             return back();

               }catch(\Exception $ex){

     $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }




    }

          public function DeleteImportExpensesTypes(PurchasesService $service,$id){

         try {
    DB::beginTransaction();

        $del=ImportExpensesTypes::find($id);

        $del->delete();
        DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();



            }catch(\Exception $ex){

     $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

           session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }catch(\Error $ex){


             $MODEL=ImportExpensesTypes::class;
              DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

         }



           }



    







}
