<?php

namespace App\Http\Controllers;

use App\Models\CoursesHalls;
use App\Models\FifoQty;
use App\Models\ItineraryVisit;
use App\Models\ProductReturnWithoutBill;
use App\Models\Vendors;
use App\Services\Average;
use Illuminate\Http\Request;
use App\Models\StoresDefaultData;
use App\Models\ItemsGroups;
use App\Models\Brands;
use App\Models\OutcomManufacturingModel;
use App\Models\ProductsStoresTransfers;
use App\Models\Products;
use App\Models\ProductUnits;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\DefaultDataShowHide;
use App\Models\InstallmentDates;
use App\Models\GroupFilter;
use App\Models\Measuerments;
use App\Models\Admin;
use App\Models\Coins;
use App\Models\ProductsStartPeriods;
use App\Models\ProductSettlement;
use App\Models\ProductsPurchases;
use App\Models\ReturnPurchProducts;
use App\Models\ProductSales;
use App\Models\ProductMoves;
use App\Models\CostCenter;
use App\Models\GeneralDaily;
use App\Models\ReciptVoucherDetails;
use App\Models\PaymentVoucherDetails;
use App\Models\AcccountingManual;
use App\Models\Employess;
use App\Models\Shifts;
use App\Models\Sales;
use App\Models\Customers;
use App\Models\ReciptVoucher;
use App\Models\ExchangeCommissions;
use App\Models\ReturnMaintainceBill;
use App\Models\ReciptMaintaince;
use App\Models\ProductMaintaincBill;
use App\Models\EmpRatio;
use App\Models\PaymentVoucher;
use App\Models\ReturnSales;
use App\Models\ReturnPurch;
use App\Models\SalesDefaultData;
use App\Models\ProductsPurchasesOrder;
use App\Models\Purchases;
use App\Models\SafesBanks;
use App\Models\ClientFilter;
use App\Models\VendorFilter;
use App\Models\ExecutorFilter;
use App\Models\ReturnSalesProducts;
use App\Models\PurchasesDefaultData;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\Branches;
use App\Models\CustomersGroup;
use App\Models\SalesBillsColumns;
use App\Models\ReturnSalesBillsFilter;
use App\Models\SalesBillsFilter;
use App\Models\InstallmentCompanies;
use App\Models\SalesBillsFilterTwo;
use App\Models\SalesBillsColumnsSechdule;
use App\Models\ReturnSalesBillsFilterTwo;
use App\Models\ReturnPurchBillsFilterTwo;
use App\Models\ReturnPurchBillsFilter;
use App\Models\PurchBillsFilterTwo;
use App\Models\PurchBillsFilter;
use App\Models\PurchBillsColumnsSechdule;
use App\Models\PurchBillsColumns;
use App\Models\ShippingCompany;
use App\Models\SafeTransferColumns;
use App\Models\SafeTransferColumnsSechdule;
use App\Models\StoresTransferColumns;
use App\Models\StoresTransferColumnsSechdule;
use App\Models\SafeTransferFilter;
use App\Models\SafeTransferFilterTwo;
use App\Models\StoreTransferFilter;
use App\Models\StoreTransferFilterTwo;
use App\Models\StorsTransfers;
use App\Models\SafeTransfers;
use App\Models\StoresMovesColumns;
use App\Models\StoresMovesColumnsSechdule;
use App\Models\StoresMovesFilter;
use App\Models\StoresMovesFilterTwo;
use App\Models\StartPeriods;
use App\Models\ExecutingReceiving;
use App\Models\Consists;
use App\Models\Settlement;
use App\Models\ProductMovesFilter;
use App\Models\ProductMovesFilterTwo;
use App\Models\ProductMovesColumns;
use App\Models\ProductMovesColumnsSechdule;
use App\Models\AllGroups;
use App\Models\ComparePricesColumns;
use App\Models\ComparePricesColumnsSechdule;
use App\Models\ComparePricesFilter;
use App\Models\ComparePricesFilterTwo;
use App\Models\StoresMoves;
use App\Models\ProfitSalesProductColumnSechdulr;
use App\Models\ProfitSalesProductColumn;
use App\Models\MostSalesProductsColumn;
use App\Models\MostSalesProductsColumnSechdule;
use App\Models\ClientAccountStatementColumn;
use App\Models\ClientAccountStatementColumnSechdule;
use App\Models\VendorAccountStatementColumn;
use App\Models\VendorAccountStatementColumnSechdule;
use App\Models\ClientsStatementsColumn;
use App\Models\ClientsStatementsColumnSechdule;
use App\Models\VendorsStatementsColumn;
use App\Models\VendorsStatementsColumnSechdule;
use App\Models\ExpensesListColumn;
use App\Models\ExpensesListColumnSechdule;
use App\Models\InstallCompaniesSalesBillsColumns;
use App\Models\InstallCompaniesSalesBillsColumnsSechdule;
use App\Models\ReturnStorsTransfer;
use App\Models\SalesPetrol;
use App\Models\Ticket;
use App\Models\IncomChecks;
use App\Models\Borrowa;
use App\Models\Loan;
use App\Models\PaySalary;
use App\Models\ExportChecks;
use App\Models\TicketProducts;
use App\Models\ReturnWithoutBill;
use App\Models\ProductsReturnMaintainceBill;
use Str;
use DB;
use URL;
use DataTables;
use DateTime;

class NewReportController extends Controller
{
    function __construct()
{


$this->middleware('permission:تقرير فواتير المبيعات', ['only' => ['SalesBills']]);
$this->middleware('permission:تقرير فواتير المشتريات', ['only' => ['PurchasesBills']]);
$this->middleware('permission:تقرير حركات المخازن', ['only' => ['StoresMovesReport']]);
$this->middleware('permission:تقرير تحويلات مخازن', ['only' => ['StoresTransferReport']]);
$this->middleware('permission:تقرير تحويلات خزائن', ['only' => ['SafesTransferReport']]);
$this->middleware('permission:تقرير مقارنه اسعار بيع', ['only' => ['CompareSalesPrice']]);
$this->middleware('permission:تقرير حزكه صنف تفصيلي', ['only' => ['ProductMoveDetails']]);
$this->middleware('permission:تقرير الاصناف الاكثر مبيعا', ['only' => ['MostSalesProducts']]);
$this->middleware('permission:تقرير ربحيه اصناف مباعه', ['only' => ['ProfitSalesProduct']]);
$this->middleware('permission:تقرير كشف حساب عميل مفصل', ['only' => ['ClientAccountStatement']]);
$this->middleware('permission:تقرير كشف حساب مورد مفصل', ['only' => ['VendorAccountStatement']]);
$this->middleware('permission:تقرير كشف حساب عملاء', ['only' => ['ClientsStatement']]);
$this->middleware('permission:تقرير كشف حساب موردين', ['only' => ['VendorsStatement']]);
$this->middleware('permission:تقرير اهداف الموظفين', ['only' => ['EmpGoals']]);
$this->middleware('permission:تقرير قائمه الدخل الفرعي', ['only' => ['ExpensesList']]);
$this->middleware('permission:تقرير قائمه المصاريف', ['only' => ['SubIncomList']]);
$this->middleware('permission:تقرير جرد السيريال', ['only' => ['InventorySerial']]);
$this->middleware('permission:تكلفه المخازن', ['only' => ['StoresCostNew']]);
$this->middleware('permission:تقفيل اليوميه بتفاصيل', ['only' => ['DailyClosingDetails']]);
$this->middleware('permission:اعمار ديون العملاء', ['only' => ['Customer_Debts']]);
$this->middleware('permission:اعمار ديون الموردين', ['only' => ['Vendor_Debts']]);
$this->middleware('permission:مبيعات مجموعات عملاء تفصيلي', ['only' => ['SalesCustomersGroups']]);
$this->middleware('permission:مبيعات الصيانه', ['only' => ['MaintanceSalesReport']]);
$this->middleware('permission:توالف الصيانه', ['only' => ['Maintenance_Tune']]);
$this->middleware('permission:ارصده المخزون', ['only' => ['StoresBalancesNew']]);
$this->middleware('permission:ارصده المخزون', ['only' => ['StoresCosts']]);
$this->middleware('permission:مبيعات شركات التقسيط', ['only' => ['InstallmentCompaniesSales']]);
$this->middleware('permission:ارباح مبيعات مناديب تفصيلي', ['only' => ['ProfitDelegateSalesDetails']]);
$this->middleware('permission:تقرير مبيعات مفصله', ['only' => ['SalesProsMoreDetails']]);
$this->middleware('permission:مبيعات البرندات', ['only' => ['BranchReportStoresFilter']]);
$this->middleware('permission:مبيعات مناديب تفصيلي', ['only' => ['DelegateSalesDetailss']]);
$this->middleware('permission:جرد المخزون', ['only' => ['StoresInventoryNew']]);
$this->middleware('permission:اصناف راكدة جديد', ['only' => ['StagnantItemsTwo']]);
$this->middleware('permission:ارصدة المخزون بالفئات', ['only' => ['StoresBalancesCatNew']]);
$this->middleware('permission:تقرير الفواتير المعدلة و المحذوفة', ['only' => ['EditDeleteBillReport']]);
$this->middleware('permission:الكميات المحجوزة', ['only' => ['HoldQtiesReport']]);
$this->middleware('permission:كميات المخزون', ['only' => ['StoresQtiesReport']]);
$this->middleware('permission:تقرير مرتجع بدون فاتورة', ['only' => ['ReturnWithoutBillReport']]);
$this->middleware('permission:مبيعات الاصناف بالمجموعات', ['only' => ['ProductSalesGroupsReport']]);
$this->middleware('permission:مبيعات الاصناف بالماركات', ['only' => ['ProductSalesBrandsReport']]);
$this->middleware('permission:تقرير نسب الموظفين من الماركات و المجموعات', ['only' => ['EmpPrecentsBrandsGroupsReport']]);
$this->middleware('permission:تقرير مبيعات برندات مفصله', ['only' => ['SalesProsBrandsMoreDetails']]);
$this->middleware('permission:مكافأت الموردين', ['only' => ['VendorBonusReport']]);

}



      //SalesBills
        public function SalesBills(){
            $Branches=Branches::all();
            $CustomersGroup=CustomersGroup::all();
            $CostCenters=CostCenter::all();
            $Coins=Coins::all();
            $Stores=Stores::type()->get();
            $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
            $Employess = Employess::type()->lazy();
            $Executors = Employess::type()->lazy();
            $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
            $Def=SalesDefaultData::orderBy('id','desc')->first();
            $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
            $Users = Admin::where('hidden',0)->get();

         return view('admin.Reports.SalesBills',get_defined_vars());
    }

           public function SalesBillFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Refrence_Number']=request('Refrence_NumberDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Payment_Method']=request('Payment_MethodDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Shipping']=request('ShippingDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['ShiftCode']=request('ShiftCodeDet');
            $data['Executor']=request('ExecutorDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Due_Date']=request('Due_DateDet');
            $data['Delegate']=request('DelegateDet');
            $data['Note']=request('NoteDet');
            $data['Total_Return']=request('Total_ReturnDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Total_Discount']=request('Total_DiscountDet');
            $data['Total_Tax']=request('Total_TaxDet');
            $data['Total_Net']=request('Total_NetDet');
            $data['Paid']=request('PaidDet');
            $data['Residual']=request('ResidualDet');
            $data['Time']=request('TimeDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Av_Qty']=request('Av_QtyDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Discount']=request('DiscountDet');
            $data['Total_BF_Tax']=request('Total_BF_TaxDet');
            $data['Tax']=request('TaxDet');
            $data['Total']=request('TotalDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Exp_Date']=request('Exp_DateDet');
            $data['Product_Store']=request('Product_StoreDet');
                $data['Client']=request('ClientDet');
                $data['Rate']=request('RateDet');
                $data['Name_Width']=request('Name_Width');

           SalesBillsColumnsSechdule::orderBy('id','desc')->update($data);



                             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $clients_Group=request('Clients_Group');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $code=request('Code');
              $shift_Code=request('Shift_Code');
              $refrence_Number=request('Refrence_Number');
              $store=request('Store');
              $safe=request('Safe');
              $client=request('Client');
              $payment_Method=request('Payment_Method');
              $delegate=request('Delegate');
              $executor=request('Executor');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');




    $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'clients_Group'=>$clients_Group
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'code'=>$code
        ,'shift_Code'=>$shift_Code
        ,'refrence_Number'=>$refrence_Number
        ,'store'=>$store
        ,'safe'=>$safe
        ,'client'=>$client
        ,'payment_Method'=>$payment_Method
        ,'delegate'=>$delegate
        ,'executor'=>$executor
        ,'user'=>$user
        ,'shipping_Company'=>$shipping_Company
        ,'types'=>$types

    ]);
        return     redirect('SalesBillFilterNeww');


    }

        public function SaveDefaultColumnsSalesBills(Request $request) {

                 $Date = $request->get('Date');
                 $Code = $request->get('Code');
                 $Refrence_Number = $request->get('Refrence_Number');
                 $Branch = $request->get('Branch');
                 $Store = $request->get('Store');
                 $Payment_Method = $request->get('Payment_Method');
                 $Safe = $request->get('Safe');
                 $Type = $request->get('Type');
                 $Shipping = $request->get('Shipping');
                 $Cost_Center = $request->get('Cost_Center');
                 $ShiftCode = $request->get('ShiftCode');
                 $Executor = $request->get('Executor');
                 $User = $request->get('User');
                 $Coin = $request->get('Coin');
                 $Due_Date = $request->get('Due_Date');
                 $Delegate = $request->get('Delegate');
                 $Note = $request->get('Note');
                 $Total_Return = $request->get('Total_Return');
                 $Total_Price = $request->get('Total_Price');
                 $Total_Discount = $request->get('Total_Discount');
                 $Total_Tax = $request->get('Total_Tax');
                 $Total_Net = $request->get('Total_Net');
                 $Paid = $request->get('Paid');
                 $Residual = $request->get('Residual');
                 $Time = $request->get('Time');
                 $Product_Code = $request->get('Product_Code');
                 $Product_Name = $request->get('Product_Name');
                 $Unit = $request->get('Unit');
                 $Av_Qty = $request->get('Av_Qty');
                 $Qty = $request->get('Qty');
                 $Price = $request->get('Price');
                 $Discount = $request->get('Discount');
                 $Total_BF_Tax = $request->get('Total_BF_Tax');
                 $Tax = $request->get('Tax');
                 $Total = $request->get('Total');
                 $Group = $request->get('Group');
                 $Brand = $request->get('Brand');
                 $Exp_Date = $request->get('Exp_Date');
                 $Product_Store = $request->get('Product_Store');
                 $ClientBill = $request->get('ClientBill');
                 $RateBill = $request->get('RateBill');
                 $Name_Width = $request->get('Name_Width');



            $data['Date']=$Date;
            $data['Code']=$Code;
            $data['Refrence_Number']=$Refrence_Number;
            $data['Branch']=$Branch;
            $data['Store']=$Store;
            $data['Payment_Method']=$Payment_Method;
            $data['Safe']=$Safe;
            $data['Type']=$Type;
            $data['Shipping']=$Shipping;
            $data['Cost_Center']=$Cost_Center;
            $data['ShiftCode']=$ShiftCode;
            $data['Executor']=$Executor;
            $data['User']=$User;
            $data['Coin']=$Coin;
            $data['Due_Date']=$Due_Date;
            $data['Delegate']=$Delegate;
            $data['Note']=$Note;
            $data['Total_Return']=$Total_Return;
            $data['Total_Price']=$Total_Price;
            $data['Total_Discount']=$Total_Discount;
            $data['Total_Tax']=$Total_Tax;
            $data['Total_Net']=$Total_Net;
            $data['Paid']=$Paid;
            $data['Residual']=$Residual;
            $data['Time']=$Time;
            $data['Product_Code']=$Product_Code;
            $data['Product_Name']=$Product_Name;
            $data['Unit']=$Unit;
            $data['Av_Qty']=$Av_Qty;
            $data['Qty']=$Qty;
            $data['Price']=$Price;
            $data['Discount']=$Discount;
            $data['Total_BF_Tax']=$Total_BF_Tax;
            $data['Tax']=$Tax;
            $data['Total']=$Total;
            $data['Group']=$Group;
            $data['Brand']=$Brand;
            $data['Exp_Date']=$Exp_Date;
            $data['Product_Store']=$Product_Store;
            $data['Client']=$ClientBill;
            $data['Rate']=$RateBill;
            $data['Name_Width']=$Name_Width;

           SalesBillsColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

    public function SalesBillsReportPrint($type){

                             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $clients_Group=request('Clients_Group');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $code=request('Code');
              $shift_Code=request('Shift_Code');
              $refrence_Number=request('Refrence_Number');
              $store=request('Store');
              $safe=request('Safe');
              $client=request('Client');
              $payment_Method=request('Payment_Method');
              $delegate=request('Delegate');
              $executor=request('Executor');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');


      $items=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->paginate(100);



      $Returns=ReturnSales::whereBetween('Date',[request('From'),request('To')])
            ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


             ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })



          ->get();

               $colum=SalesBillsColumnsSechdule::orderBy('id','desc')->first();


         $Total_Qty=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


            ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })
          ->get()->sum('Total_Qty');



      $Total_Discount=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Discount');


          $Total_Tax=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })
          ->get()->sum('Total_Taxes');


  $Total_TaxT=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('ProfitTax');



        $Total_Bills=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Price');


     $Total_Return=ReturnSales::whereBetween('Date',[request('From'),request('To')])
            ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


       ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })



          ->get()->sum('Total_Return_Value');



     $Bills_Nums=Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })


              ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
        return $query->where('Shift_Code', $shift_Code);
    })


          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })


           ->when(!empty($executor), function ($query) use ($executor) {
        return $query->whereIn('Executor', $executor);
    })


          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->count();

               $TotalTax= $Total_Tax + $Total_TaxT ;
               $Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;

                  $type=0;


             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $type=1;
                 }elseif($ty[0] == 1){
                         $typeMstlma=1;

                     }elseif($ty[0] == 0){

               $typeMo3l2a=1;
                     }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $type=1;
                 }elseif($ty[1] == 1){
                         $typeMstlma=1;

                     }elseif($ty[1] == 0){

               $typeMo3l2a=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $type=1;
                 }elseif($ty[2] == 1){
                         $typeMstlma=1;

                     }elseif($ty[2] == 0){

               $typeMo3l2a=1;
                     }
                 }

             }



        return view('admin.Reports.SalesBillsPrint',get_defined_vars());

    }


     public function SalesBillFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
              $clients_Group=session()->get('clients_Group');
              $cost_Center=session()->get('cost_Center');
              $coin=session()->get('coin');
              $code=session()->get('code');
              $shift_Code=session()->get('shift_Code');
              $refrence_Number=session()->get('refrence_Number');
              $store=session()->get('store');
              $safe=session()->get('safe');
              $client=session()->get('client');
              $payment_Method=session()->get('payment_Method');
              $delegate=session()->get('delegate');
              $executor=session()->get('executor');
              $user=session()->get('user');
              $shipping_Company=session()->get('shipping_Company');
              $types=session()->get('types');

$buildBaseSalesQuery = function ($model) use ($from, $to, $branch, $clients_Group, $cost_Center, $coin, $code, $shift_Code, $refrence_Number, $store, $safe, $client, $payment_Method, $delegate, $executor, $user, $shipping_Company, $types) {
    return $model::query()
        ->where('Delete', 0)
        ->where('Edit', 0)
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($clients_Group), fn($q) => $q->where('CustomerGroup', $clients_Group))
        ->when(!empty($cost_Center), fn($q) => $q->where('Cost_Center', $cost_Center))
        ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
        ->when(!empty($code), fn($q) => $q->where('Code', $code))
        ->when(!empty($shift_Code), fn($q) => $q->where('Shift_Code', $shift_Code))
        ->when(!empty($refrence_Number), fn($q) => $q->where('Refernce_Number', $refrence_Number))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
        ->when(!empty($client), fn($q) => $q->whereIn('Client', $client))
        ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
        ->when(!empty($executor), fn($q) => $q->whereIn('Executor', $executor))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company))
        ->when(!empty($types), fn($q) => $q->whereIn('Status', $types));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج
// ----------------------------------------------------------------------

// 3.1. $items (الـ Sales المصفحة)
$items = $buildBaseSalesQuery(Sales::class)->paginate(10);

// 3.2. $Returns (الـ ReturnSales)
$Returns = ReturnSales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])
    ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
    ->when(!empty($clients_Group), fn($q) => $q->where('CustomerGroup', $clients_Group))
    ->when(!empty($cost_Center), fn($q) => $q->where('Cost_Center', $cost_Center))
    ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
    ->when(!empty($code), fn($q) => $q->where('Code', $code))
    ->when(!empty($shift_Code), fn($q) => $q->where('Shift_Code', $shift_Code))
    ->when(!empty($refrence_Number), fn($q) => $q->where('Refernce_Number', $refrence_Number))
    ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
    ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
    ->when(!empty($client), fn($q) => $q->whereIn('Client', $client))
    ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
    ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
    ->when(!empty($executor), fn($q) => $q->whereIn('Executor', $executor))
    ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
    ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company))
    // لم يكن هناك فلتر types في ReturnSales في الكود الأصلي
    ->get();

// 3.3. $colum
$colum = SalesBillsColumnsSechdule::orderBy('id', 'desc')->first();


// 3.4. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseSalesQuery(Sales::class)->get()->sum('Total_Qty');

// 3.5. إجمالي الخصم ($Total_Discount)
$Total_Discount = $buildBaseSalesQuery(Sales::class)->get()->sum('Total_Discount');

// 3.6. إجمالي الضريبة ($Total_Tax)
$Total_Tax = $buildBaseSalesQuery(Sales::class)->get()->sum('Total_Taxes');

// 3.7. إجمالي الضريبة الثانية ($Total_TaxT)
$Total_TaxT = $buildBaseSalesQuery(Sales::class)->get()->sum('ProfitTax');

// 3.8. إجمالي قيمة الفواتير ($Total_Bills)
$Total_Bills = $buildBaseSalesQuery(Sales::class)->get()
    ->sum(function ($row) { // <<-- إزالة `use ()` لأن $row يتم تمريره كوسيط
        $TotalReturn = ReturnSales::where('Sales', $row->id)->get()->sum('Total_Return_Value');
        return ($row->Total_Price + $TotalReturn);
    });

     $Total_BillsReturn = $buildBaseSalesQuery(Sales::class)->get()
    ->sum(function ($row) { // <<-- إزالة `use ()` لأن $row يتم تمريره كوسيط
        $TotalReturn = ReturnSales::where('Sales', $row->id)->get()->sum('Total_Return_Value');
        return ($row->Total_Price);
    });

         
         
          
         
// 3.9. إجمالي المدفوع ($Total_Paid)
$Total_Paid = $buildBaseSalesQuery(Sales::class)->get()->sum('Pay');

// 3.10. إجمالي قيمة المرتجعات ($Total_Return)
$Total_Return = ReturnSales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])
    ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
    ->when(!empty($clients_Group), fn($q) => $q->where('CustomerGroup', $clients_Group))
    ->when(!empty($cost_Center), fn($q) => $q->where('Cost_Center', $cost_Center))
    ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
    ->when(!empty($code), fn($q) => $q->where('Code', $code))
    ->when(!empty($shift_Code), fn($q) => $q->where('Shift_Code', $shift_Code))
    ->when(!empty($refrence_Number), fn($q) => $q->where('Refernce_Number', $refrence_Number))
    ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
    ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
    ->when(!empty($client), fn($q) => $q->whereIn('Client', $client))
    ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
    ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
    ->when(!empty($executor), fn($q) => $q->whereIn('Executor', $executor))
    ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
    ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company))
    // لم يكن هناك فلتر types في Total_Return في الكود الأصلي
    ->get()->sum('Total_Return_Value');

// 3.11. عدد الفواتير ($Bills_Nums)
$Bills_Nums = $buildBaseSalesQuery(Sales::class)->count();

// 3.12. إجمالي المرتجعات بدون فاتورة ($Total_Return_Without) و ($Total_Return_Without_Cost)
$baseReturnWithoutBillQuery = ReturnWithoutBill::query()
    ->where('Delete', 0)
    ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
    ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
    ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
    // ملاحظة: الكود الأصلي يستخدم 'Vendor' بدلاً من 'Client' في ReturnWithoutBill
    ->when(!empty($client), fn($q) => $q->whereIn('Vendor', $client))
    ->whereBetween('Date', [$from, $to]);

$Total_Return_Without = $baseReturnWithoutBillQuery->clone()->get()->sum('Total_Price');
$Total_Return_Without_Cost = $baseReturnWithoutBillQuery->clone()->get()->sum('Total_Cost');


// ----------------------------------------------------------------------
// 4. الحسابات النهائية والمتغيرات الإضافية
// ----------------------------------------------------------------------

$TotalTax = $Total_Tax + $Total_TaxT;
$Total_Net = ($TotalTax + $Total_Bills) - $Total_Discount;
$Total_Net_Return = ($TotalTax + $Total_BillsReturn) - $Total_Discount;

   
    
         
         
$type = 0;
// المتغيرات typeMstlma و typeMo3l2a لم يتم تهيئتها في الكود الأصلي
// قبل استخدامها في الكتل الشرطية، لذا يجب تهيئتها مسبقًا:
$typeMstlma = 0;
$typeMo3l2a = 0;

if (!empty(request('Type'))) {
    $ty = request('Type');

    if (!empty($ty[0])) {
        if ($ty[0] == 3) {
            $type = 1;
        } elseif ($ty[0] == 1) {
            $typeMstlma = 1;
        } elseif ($ty[0] == 0) {
            $typeMo3l2a = 1;
        }
    }

    if (!empty($ty[1])) {
        if ($ty[1] == 3) {
            $type = 1;
        } elseif ($ty[1] == 1) {
            $typeMstlma = 1;
        } elseif ($ty[1] == 0) {
            $typeMo3l2a = 1;
        }
    }

    if (!empty($ty[2])) {
        if ($ty[2] == 3) {
            $type = 1;
        } elseif ($ty[2] == 1) {
            $typeMstlma = 1;
        } elseif ($ty[2] == 0) {
            $typeMo3l2a = 1;
        }
    }
}


// ----------------------------------------------------------------------
// 5. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

       return view('admin.Reports.SalesBillsFilter',get_defined_vars());
    }



    //PurchasesBills

           public function PurchasesBills(){

            $Branches=Branches::all();
                 $CostCenters=CostCenter::all();
            $Coins=Coins::all();
               $Stores=Stores::type()->get();
               $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
                      $Def=PurchasesDefaultData::orderBy('id','desc')->first();
               $Vendors = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
               $Employess = Employess::type()->lazy();
               $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
             $Users = Admin::where('hidden',0)->get();

         return view('admin.Reports.PurchasesBills',get_defined_vars());
    }

           public function PurchasesBillsFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Refrence_Number']=request('Refrence_NumberDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Payment_Method']=request('Payment_MethodDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Shipping']=request('ShippingDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Due_Date']=request('Due_DateDet');
            $data['Delegate']=request('DelegateDet');
            $data['Note']=request('NoteDet');
            $data['Total_Return']=request('Total_ReturnDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Total_Discount']=request('Total_DiscountDet');
            $data['Total_Tax']=request('Total_TaxDet');
            $data['Total_Net']=request('Total_NetDet');
            $data['Paid']=request('PaidDet');
            $data['Residual']=request('ResidualDet');
            $data['Time']=request('TimeDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Discount']=request('DiscountDet');
            $data['Total_BF_Tax']=request('Total_BF_TaxDet');
            $data['Tax']=request('TaxDet');
            $data['Total']=request('TotalDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Exp_Date']=request('Exp_DateDet');
            $data['Product_Store']=request('Product_StoreDet');
                $data['Vendor']=request('VendorDet');
                  $data['Rate']=request('RateDet');
                $data['Name_Width']=request('Name_Width');
           PurchBillsColumnsSechdule::orderBy('id','desc')->update($data);




                             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $clients_Group=request('Clients_Group');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $code=request('Code');
              $refrence_Number=request('Refrence_Number');
              $store=request('Store');
              $safe=request('Safe');
              $client=request('Vendor');
              $payment_Method=request('Payment_Method');
              $delegate=request('Delegate');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');

             $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'clients_Group'=>$clients_Group
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'code'=>$code
        ,'refrence_Number'=>$refrence_Number
        ,'store'=>$store
        ,'safe'=>$safe
        ,'client'=>$client
        ,'payment_Method'=>$payment_Method
        ,'delegate'=>$delegate
        ,'user'=>$user
        ,'shipping_Company'=>$shipping_Company
        ,'types'=>$types

    ]);
        return     redirect('PurchasesBillsFilterNeww');


    }

        public function SaveDefaultColumnsPurchasesBills(Request $request) {

                 $Date = $request->get('Date');
                 $Code = $request->get('Code');
                 $Refrence_Number = $request->get('Refrence_Number');
                 $Branch = $request->get('Branch');
                 $Store = $request->get('Store');
                 $Payment_Method = $request->get('Payment_Method');
                 $Safe = $request->get('Safe');
                 $Type = $request->get('Type');
                 $Shipping = $request->get('Shipping');
                 $Cost_Center = $request->get('Cost_Center');
                 $User = $request->get('User');
                 $Coin = $request->get('Coin');
                 $Due_Date = $request->get('Due_Date');
                 $Delegate = $request->get('Delegate');
                 $Note = $request->get('Note');
                 $Total_Return = $request->get('Total_Return');
                 $Total_Price = $request->get('Total_Price');
                 $Total_Discount = $request->get('Total_Discount');
                 $Total_Tax = $request->get('Total_Tax');
                 $Total_Net = $request->get('Total_Net');
                 $Paid = $request->get('Paid');
                 $Residual = $request->get('Residual');
                 $Time = $request->get('Time');
                 $Product_Code = $request->get('Product_Code');
                 $Product_Name = $request->get('Product_Name');
                 $Unit = $request->get('Unit');
                 $Qty = $request->get('Qty');
                 $Price = $request->get('Price');
                 $Discount = $request->get('Discount');
                 $Total_BF_Tax = $request->get('Total_BF_Tax');
                 $Tax = $request->get('Tax');
                 $Total = $request->get('Total');
                 $Group = $request->get('Group');
                 $Brand = $request->get('Brand');
                 $Exp_Date = $request->get('Exp_Date');
                 $Product_Store = $request->get('Product_Store');
                 $ClientBill = $request->get('ClientBill');
                             $RateBill = $request->get('RateBill');
                 $Name_Width = $request->get('Name_Width');

            $data['Date']=$Date;
            $data['Code']=$Code;
            $data['Refrence_Number']=$Refrence_Number;
            $data['Branch']=$Branch;
            $data['Store']=$Store;
            $data['Payment_Method']=$Payment_Method;
            $data['Safe']=$Safe;
            $data['Type']=$Type;
            $data['Shipping']=$Shipping;
            $data['Cost_Center']=$Cost_Center;
            $data['User']=$User;
            $data['Coin']=$Coin;
            $data['Due_Date']=$Due_Date;
            $data['Delegate']=$Delegate;
            $data['Note']=$Note;
            $data['Total_Return']=$Total_Return;
            $data['Total_Price']=$Total_Price;
            $data['Total_Discount']=$Total_Discount;
            $data['Total_Tax']=$Total_Tax;
            $data['Total_Net']=$Total_Net;
            $data['Paid']=$Paid;
            $data['Residual']=$Residual;
            $data['Time']=$Time;
            $data['Product_Code']=$Product_Code;
            $data['Product_Name']=$Product_Name;
            $data['Unit']=$Unit;
            $data['Qty']=$Qty;
            $data['Price']=$Price;
            $data['Discount']=$Discount;
            $data['Total_BF_Tax']=$Total_BF_Tax;
            $data['Tax']=$Tax;
            $data['Total']=$Total;
            $data['Group']=$Group;
            $data['Brand']=$Brand;
            $data['Exp_Date']=$Exp_Date;
            $data['Product_Store']=$Product_Store;
            $data['Vendor']=$ClientBill;
               $data['Rate']=$RateBill;
            $data['Name_Width']=$Name_Width;
           PurchBillsColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

    public function PurchasesBillsReportPrint($type){



$colum=PurchBillsColumnsSechdule::orderBy('id','desc')->first();



                             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $clients_Group=request('Clients_Group');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $code=request('Code');
              $refrence_Number=request('Refrence_Number');
              $store=request('Store');
              $safe=request('Safe');
              $client=request('Vendor');
              $payment_Method=request('Payment_Method');
              $delegate=request('Delegate');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');




      $items=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })



          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })




          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->paginate(10);



      $Returns=ReturnPurch::whereBetween('Date',[request('From'),request('To')])
            ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->wwhereInhere('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

          ->get();


         $Total_Qty=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Qty');



      $Total_Discount=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Discount');


          $Total_Tax=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })




          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Taxes');


  $Total_TaxT=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

             ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })



                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })




          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('ProfitTax');



        $Total_Bills=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })


               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->get()->sum('Total_Price');


     $Total_Return=ReturnPurch::whereBetween('Date',[request('From'),request('To')])
            ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })



               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })




          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

          ->get()->sum('Total_Return_Value');



     $Bills_Nums=Purchases::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


         ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


          ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })




          ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })


           ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })


               ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })


      ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })




          ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

     ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })

    ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })

          ->count();

               $TotalTax= $Total_Tax + $Total_TaxT ;
               $Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;

                  $type=0;


             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $type=1;
                 }elseif($ty[0] == 1){
                         $typeMstlma=1;

                     }elseif($ty[0] == 0){

               $typeMo3l2a=1;
                     }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $type=1;
                 }elseif($ty[1] == 1){
                         $typeMstlma=1;

                     }elseif($ty[1] == 0){

               $typeMo3l2a=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $type=1;
                 }elseif($ty[2] == 1){
                         $typeMstlma=1;

                     }elseif($ty[2] == 0){

               $typeMo3l2a=1;
                     }
                 }

             }

        return view('admin.Reports.PurchBillsPrint',get_defined_vars());

    }

         public function PurchasesBillsFilterNeww(){

                  $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
              $clients_Group=session()->get('clients_Group');
              $cost_Center=session()->get('cost_Center');
              $coin=session()->get('coin');
              $code=session()->get('code');
              $shift_Code=session()->get('shift_Code');
              $refrence_Number=session()->get('refrence_Number');
              $store=session()->get('store');
              $safe=session()->get('safe');
              $client=session()->get('client');
              $payment_Method=session()->get('payment_Method');
              $delegate=session()->get('delegate');
              $executor=session()->get('executor');
              $user=session()->get('user');
              $shipping_Company=session()->get('shipping_Company');
              $types=session()->get('types');
             
             
           $buildPurchasesQuery = function ($model) use ($from, $to, $branch, $clients_Group, $cost_Center, $coin, $code, $refrence_Number, $store, $safe, $client, $payment_Method, $delegate, $user, $shipping_Company, $types) {
    // تبدأ الاستعلام بالـ Date
    $query = $model::query()->whereBetween('Date', [$from, $to]);

    // Apply common filters
    $query->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
          ->when(!empty($clients_Group), fn($q) => $q->where('CustomerGroup', $clients_Group))
          ->when(!empty($cost_Center), fn($q) => $q->where('Cost_Center', $cost_Center))
          ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
          ->when(!empty($code), fn($q) => $q->where('Code', $code))
          ->when(!empty($refrence_Number), fn($q) => $q->where('Refernce_Number', $refrence_Number))
          ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
          ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
          ->when(!empty($client), fn($q) => $q->whereIn('Vendor', $client)) // يستخدم 'Vendor' بدلاً من 'Client'
          ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
          ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
          ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
          ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company));
    
    // فلتر Status لـ Purchases فقط (وليس ReturnPurch في الكود الأصلي)
    if ($model === Purchases::class) {
        $query->when(!empty($types), fn($q) => $q->whereIn('Status', $types));
        $query->where('Edit', 0)->where('Delete', 0); // فلتر Edit و Delete لـ Purchases
    }

    return $query;
};

// ----------------------------------------------------------------------
// 2. تنفيذ الاستعلامات
// ----------------------------------------------------------------------

// 2.1. $colum
$colum=PurchBillsColumnsSechdule::orderBy('id','desc')->first();

// 2.2. $items (قائمة فواتير الشراء المصفحة)
$items = $buildPurchasesQuery(Purchases::class)->paginate(20);

// 2.3. $Returns (مرتجعات الشراء)
// نستخدم الـ buildPurchasesQuery مع بعض التعديلات لـ ReturnPurch
$Returns = ReturnPurch::whereBetween('Date',[$from,$to])
    // نكرر منطق الفلترة يدوياً هنا للتأكد من مطابقة ReturnPurch تماماً للكود الأصلي
    ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })
    ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })
    ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })
    ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })
    ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })
    ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
    ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })
    ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })
    ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })
    ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })
    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })
    ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
    // لا يوجد فلتر Status أو Edit/Delete لـ ReturnPurch في الكود الأصلي
    ->get();

// 2.4. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildPurchasesQuery(Purchases::class)->get()->sum('Total_Qty');

// 2.5. إجمالي الخصم ($Total_Discount)
$Total_Discount = $buildPurchasesQuery(Purchases::class)->get()->sum('Total_Discount');

// 2.6. إجمالي الضريبة ($Total_Tax)
$Total_Tax = $buildPurchasesQuery(Purchases::class)->get()->sum('Total_Taxes');

// 2.7. إجمالي الضريبة الثانية ($Total_TaxT)
$Total_TaxT = $buildPurchasesQuery(Purchases::class)->get()->sum('ProfitTax');

// 2.8. إجمالي قيمة الفواتير ($Total_Bills)
$Total_Bills = $buildPurchasesQuery(Purchases::class)->get()->sum('Total_Price');

// 2.9. إجمالي قيمة المرتجعات ($Total_Return)
// نكرر منطق الفلترة يدوياً هنا للتأكد من مطابقة ReturnPurch تماماً للكود الأصلي
$Total_Return = ReturnPurch::whereBetween('Date',[$from,$to])
    ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })
    ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
        return $query->where('CustomerGroup', $clients_Group);
    })
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })
    ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })
    ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })
    ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
        return $query->where('Refernce_Number', $refrence_Number);
    })
    ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
    ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })
    ->when(!empty($client), function ($query) use ($client) {
        return $query->whereIn('Vendor', $client);
    })
    ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })
    ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })
    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })
    ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
    ->get()->sum('Total_Return_Value');

// 2.10. عدد الفواتير ($Bills_Nums)
$Bills_Nums = $buildPurchasesQuery(Purchases::class)->count();

// ----------------------------------------------------------------------
// 3. الحسابات النهائية ومنطق الفلاتر الإضافية
// ----------------------------------------------------------------------

$TotalTax= $Total_Tax + $Total_TaxT ;
$Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;

// تهيئة المتغيرات المستخدمة في الكتل الشرطية
$type=0;
$typeMstlma=0;
$typeMo3l2a=0;

if(!empty(request('Type'))){
    $ty=request('Type');

    if(!empty($ty[0])){
        if($ty[0] == 3){
            $type=1;
        }elseif($ty[0] == 1){
            $typeMstlma=1;
        }elseif($ty[0] == 0){
            $typeMo3l2a=1;
        }
    }

    if(!empty($ty[1])){
        if($ty[1] == 3){
            $type=1;
        }elseif($ty[1] == 1){
            $typeMstlma=1;
        }elseif($ty[1] == 0){
            $typeMo3l2a=1;
        }
    }

    if(!empty($ty[2])){
        if($ty[2] == 3){
            $type=1;
        }elseif($ty[2] == 1){
            $typeMstlma=1;
        }elseif($ty[2] == 0){
            $typeMo3l2a=1;
        }
    }
}

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

  return view('admin.Reports.PurchBillsFilter',get_defined_vars());


    }


    //StoresTransferReport

        public function StoresTransferReport(){

             $Branches=Branches::all();
            $Stores=Stores::type()->get();
               $Employess = Employess::type()->get();
             $Users = Admin::where('hidden',0)->get();
             $Shippings = ShippingCompany::all();
            $Coins=Coins::all();

         return view('admin.Reports.StoresTransferReport',get_defined_vars());
    }

      public function SaveDefaultColumnsStoresTransferReport(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $CodeBill = $request->get('CodeBill');
                 $BranchBill = $request->get('BranchBill');
                 $TimeBill = $request->get('TimeBill');
                 $AmountBill = $request->get('AmountBill');
                 $From_StoreBill = $request->get('From_StoreBill');
                 $To_StoreBill = $request->get('To_StoreBill');
                 $UserBill = $request->get('UserBill');
                 $CoinBill = $request->get('CoinBill');
                 $ShippingBill = $request->get('ShippingBill');
                 $NoteBill = $request->get('NoteBill');
                 $DelegateBill = $request->get('DelegateBill');
                 $Product_NameBill = $request->get('Product_NameBill');
                 $Product_CodeBill = $request->get('Product_CodeBill');
                 $GroupBill = $request->get('GroupBill');
                 $BrandBill = $request->get('BrandBill');
                 $QtyBill = $request->get('QtyBill');
                 $PriceBill = $request->get('PriceBill');
                 $Trans_QtyBill = $request->get('Trans_QtyBill');
                 $UnitBill = $request->get('UnitBill');
                 $TotalBill = $request->get('TotalBill');



            $data['Date']=$DateBill;
            $data['Code']=$CodeBill;
            $data['Branch']=$BranchBill;
            $data['Time']=$TimeBill;
            $data['Amount']=$AmountBill;
            $data['From_Store']=$From_StoreBill;
            $data['To_Store']=$To_StoreBill;
            $data['User']=$UserBill;
            $data['Coin']=$CoinBill;
            $data['Shipping']=$ShippingBill;
            $data['Note']=$NoteBill;
            $data['Delegate']=$DelegateBill;
            $data['Product_Name']=$Product_NameBill;
            $data['Product_Code']=$Product_CodeBill;
            $data['Group']=$GroupBill;
            $data['Brand']=$BrandBill;
            $data['Qty']=$QtyBill;
            $data['Price']=$PriceBill;
            $data['Trans_Qty']=$Trans_QtyBill;
            $data['Unit']=$UnitBill;
            $data['Total']=$TotalBill;


           StoresTransferColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

           public function StoresTransferReportFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Branch']=request('BranchDet');
            $data['Time']=request('TimeDet');
            $data['Amount']=request('AmountDet');
            $data['From_Store']=request('From_StoreDet');
            $data['To_Store']=request('To_StoreDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Shipping']=request('ShippingDet');
            $data['Note']=request('NoteDet');
            $data['Delegate']=request('DelegateDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Trans_Qty']=request('Trans_QtyDet');
            $data['Unit']=request('UnitDet');
            $data['Total']=request('TotalDet');


           StoresTransferColumnsSechdule::orderBy('id','desc')->update($data);


              $from=request('From');
            $to=request('To');
            $branch=request('Branch');
              $coin=request('Coin');
              $code=request('Code');
              $value=request('Value');
              $qty=request('Qty');
              $fromStore=request('FromStore');
              $toStore=request('ToStore');
              $delegate=request('Delegate');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');


            $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'coin'=>$coin
        ,'code'=>$code
        ,'value'=>$value
        ,'qty'=>$qty
        ,'fromStore'=>$fromStore
        ,'toStore'=>$toStore
        ,'delegate'=>$delegate
        ,'user'=>$user
        ,'shipping_Company'=>$shipping_Company
        ,'types'=>$types


    ]);
        return     redirect('StoresTransferReportFilterNeww');



    }

        public function StoresTransferReportPrint(){

           $from=request('From');
            $to=request('To');
            $branch=request('Branch');
              $coin=request('Coin');
              $code=request('Code');
              $value=request('Value');
              $qty=request('Qty');
              $fromStore=request('FromStore');
              $toStore=request('ToStore');
              $delegate=request('Delegate');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');
                    $edit=0;



             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $edit=1;
                 }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $edit=1;
                 }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $edit=1;
                 }
                 }

                       if(!empty($ty[3])){
                     if($ty[3] == 3){
                     $edit=1;
                 }
                 }

             }


      $items=StorsTransfers::whereBetween('Date',[request('From'),request('To')])

     ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })

         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Total','>=', $value);
    })


                  ->when(!empty($qty), function ($query) use ($qty) {
        return $query->where('TotalQty','>=', $qty);
    })

                                   ->when(!empty($fromStore), function ($query) use ($fromStore) {
        return $query->whereIn('From_Store', $fromStore);
    })

                   ->when(!empty($toStore), function ($query) use ($toStore) {
        return $query->whereIn('To_Store', $toStore);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                  ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whewhereInre('Ship', $shipping_Company);
    })

                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->paginate(10);


                 $Total_Qty=StorsTransfers::whereBetween('Date',[request('From'),request('To')])

     ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })

         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Total','>=', $value);
    })


                  ->when(!empty($qty), function ($query) use ($qty) {
        return $query->where('TotalQty','>=', $qty);
    })

                                   ->when(!empty($fromStore), function ($query) use ($fromStore) {
        return $query->whereIn('From_Store', $fromStore);
    })

                   ->when(!empty($toStore), function ($query) use ($toStore) {
        return $query->whereIn('To_Store', $toStore);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                  ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whewhereInre('Ship', $shipping_Company);
    })

                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->get()->sum('TotalQty');



    $Total_Price=StorsTransfers::whereBetween('Date',[request('From'),request('To')])

     ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })

         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Total','>=', $value);
    })


                  ->when(!empty($qty), function ($query) use ($qty) {
        return $query->where('TotalQty','>=', $qty);
    })

                                   ->when(!empty($fromStore), function ($query) use ($fromStore) {
        return $query->whereIn('From_Store', $fromStore);
    })

                   ->when(!empty($toStore), function ($query) use ($toStore) {
        return $query->whereIn('To_Store', $toStore);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                  ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whewhereInre('Ship', $shipping_Company);
    })

                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->get()->sum('Total');


    $Bills_Nums=StorsTransfers::whereBetween('Date',[request('From'),request('To')])

     ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })

         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Total','>=', $value);
    })


                  ->when(!empty($qty), function ($query) use ($qty) {
        return $query->where('TotalQty','>=', $qty);
    })

                                   ->when(!empty($fromStore), function ($query) use ($fromStore) {
        return $query->whereIn('From_Store', $fromStore);
    })

                   ->when(!empty($toStore), function ($query) use ($toStore) {
        return $query->whereIn('To_Store', $toStore);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                  ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whewhereInre('Ship', $shipping_Company);
    })

                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })



          ->count();


               $colum=StoresTransferColumnsSechdule::orderBy('id','desc')->first();


        return view('admin.Reports.StoresTransferReportPrint',get_defined_vars());

    }

             public function StoresTransferReportFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
              $coin=session()->get('coin');
              $code=session()->get('code');
              $value=session()->get('value');
              $qty=session()->get('qty');
              $fromStore=session()->get('fromStore');
              $toStore=session()->get('toStore');
              $delegate=session()->get('delegate');
              $user=session()->get('user');
              $shipping_Company=session()->get('shipping_Company');
              $types=session()->get('types');



    
$buildBaseStorsTransfersQuery = function () use ($from, $to, $branch, $coin, $code, $value, $qty, $fromStore, $toStore, $delegate, $user, $shipping_Company, $types) {
    return StorsTransfers::query()
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($code), fn($q) => $q->where('Code', $code))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
        ->when(!empty($types), fn($q) => $q->whereIn('Status', $types))
        ->when(!empty($value), fn($q) => $q->where('Total','>=', $value))
        ->when(!empty($qty), fn($q) => $q->where('TotalQty','>=', $qty))
        ->when(!empty($fromStore), fn($q) => $q->whereIn('From_Store', $fromStore))
        ->when(!empty($toStore), fn($q) => $q->whereIn('To_Store', $toStore))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        // تصحيح الخطأ الإملائي هنا: 'whewhereInre' إلى 'whereIn'
        ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (الـ StorsTransfers المصفحة)
$items = $buildBaseStorsTransfersQuery()->paginate(10);

// 3.2. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseStorsTransfersQuery()->get()->sum('TotalQty');

// 3.3. إجمالي السعر/القيمة ($Total_Price)
$Total_Price = $buildBaseStorsTransfersQuery()->get()->sum('Total');

// 3.4. عدد الفواتير/التحويلات ($Bills_Nums)
$Bills_Nums = $buildBaseStorsTransfersQuery()->count();

// 3.5. $colum
$colum=StoresTransferColumnsSechdule::orderBy('id','desc')->first();

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

         return view('admin.Reports.StoresTransferReportFilter',get_defined_vars());


    }


    //SafesTransferReport
        public function SafesTransferReport(){
   $Branches=Branches::all();
  $CostCenters=CostCenter::all();
 $Coins=Coins::all();
            $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
            $Employess = Employess::type()->lazy();
    $Users = Admin::where('hidden',0)->get();
         return view('admin.Reports.SafesTransferReport',get_defined_vars());
    }

        public function SaveDefaultColumnsSafesTransferReport(Request $request) {

                 $Date = $request->get('Date');
                 $Code = $request->get('Code');
                 $Time = $request->get('Time');
                 $Amount = $request->get('Amount');
                 $From_Safe = $request->get('From_Safe');
                 $To_Safe = $request->get('To_Safe');
                 $User = $request->get('User');
                 $Coin = $request->get('Coin');
                 $Cost_Center = $request->get('Cost_Center');
                 $Note = $request->get('Note');
                 $Delegate = $request->get('Delegate');
                 $Branch = $request->get('Branch');



            $data['Date']=$Date;
            $data['Code']=$Code;
            $data['Time']=$Time;
            $data['Amount']=$Amount;
            $data['From_Safe']=$From_Safe;
            $data['To_Safe']=$To_Safe;
            $data['User']=$User;
            $data['Coin']=$Coin;
            $data['Cost_Center']=$Cost_Center;
            $data['Note']=$Note;
            $data['Delegate']=$Delegate;
            $data['Branch']=$Branch;



           SafeTransferColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

              public function SafesTransferReportFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Time']=request('TimeDet');
            $data['Amount']=request('AmountDet');
            $data['From_Safe']=request('From_SafeDet');
            $data['To_Safe']=request('To_SafeDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['Note']=request('NoteDet');
            $data['Delegate']=request('DelegateDet');
            $data['Branch']=request('BranchDet');


           SafeTransferColumnsSechdule::orderBy('id','desc')->update($data);


            $from=request('From');
            $to=request('To');
            $branch=request('Branch');
              $coin=request('Coin');
              $code=request('Code');
              $value=request('Value');
              $fromSafe=request('FromSafe');
              $toSafe=request('ToSafe');
              $delegate=request('Delegate');
              $user=request('User');
              $types=request('Type');

                $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'coin'=>$coin
        ,'code'=>$code
        ,'value'=>$value
        ,'fromSafe'=>$fromSafe
        ,'toSafe'=>$toSafe
        ,'delegate'=>$delegate
        ,'user'=>$user
        ,'types'=>$types


    ]);
        return     redirect('SafesTransferReportFilterNeww');



    }

        public function SafesTransferReportPrint(){
              $from=request('From');
            $to=request('To');
            $branch=request('Branch');
              $coin=request('Coin');
              $code=request('Code');
              $value=request('Value');
              $fromSafe=request('FromSafe');
              $toSafe=request('ToSafe');
              $delegate=request('Delegate');
              $user=request('User');
              $types=request('Type');

      $items=SafeTransfers::whereBetween('Date',[request('From'),request('To')])

             ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })



         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Amount','>=', $value);
    })



                                   ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
        return $query->whereIn('From_Safe', $fromSafe);
    })

                   ->when(!empty($toSafe), function ($query) use ($toSafe) {
        return $query->whereIn('To_Safe', $toSafe);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })



                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })

          ->paginate(10);



      $Bills_Nums=SafeTransfers::whereBetween('Date',[request('From'),request('To')])

             ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })



         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Amount','>=', $value);
    })



                                   ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
        return $query->whereIn('From_Safe', $fromSafe);
    })

                   ->when(!empty($toSafe), function ($query) use ($toSafe) {
        return $query->whereIn('To_Safe', $toSafe);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })



                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })

          ->count();




     $Total_Price=SafeTransfers::whereBetween('Date',[request('From'),request('To')])

             ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code', $code);
    })



         ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })

                  ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                         ->when(!empty($types), function ($query) use ($types) {
        return $query->whereIn('Status', $types);
    })



                    ->when(!empty($value), function ($query) use ($value) {
        return $query->where('Amount','>=', $value);
    })



                                   ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
        return $query->whereIn('From_Safe', $fromSafe);
    })

                   ->when(!empty($toSafe), function ($query) use ($toSafe) {
        return $query->whereIn('To_Safe', $toSafe);
    })

                    ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })



                          ->when(!empty($delegate), function ($query) use ($delegate) {
        return $query->whereIn('Delegate', $delegate);
    })

          ->get()->sum('Amount');

               $colum=SafeTransferColumnsSechdule::orderBy('id','desc')->first();


        return view('admin.Reports.SafesTransferReportPrint',get_defined_vars());

    }

           public function SafesTransferReportFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
              $coin=session()->get('coin');
              $code=session()->get('code');
              $value=session()->get('value');
              $fromSafe=session()->get('fromSafe');
              $toSafe=session()->get('toSafe');
              $delegate=session()->get('delegate');
              $user=session()->get('user');
              $types=session()->get('types');


$buildBaseSafeTransfersQuery = function () use ($from, $to, $branch, $coin, $code, $value, $fromSafe, $toSafe, $delegate, $user, $types) {
    return SafeTransfers::query()
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($code), fn($q) => $q->where('Code', $code))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
        ->when(!empty($types), fn($q) => $q->whereIn('Status', $types))
        ->when(!empty($value), fn($q) => $q->where('Amount','>=', $value))
        ->when(!empty($fromSafe), fn($q) => $q->whereIn('From_Safe', $fromSafe))
        ->when(!empty($toSafe), fn($q) => $q->whereIn('To_Safe', $toSafe))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (الـ SafeTransfers المصفحة)
$items = $buildBaseSafeTransfersQuery()->paginate(10);

// 3.2. عدد التحويلات/الفواتير ($Bills_Nums)
$Bills_Nums = $buildBaseSafeTransfersQuery()->count();

// 3.3. إجمالي المبلغ ($Total_Price)
$Total_Price = $buildBaseSafeTransfersQuery()->get()->sum('Amount');

// 3.4. $colum
$colum=SafeTransferColumnsSechdule::orderBy('id','desc')->first();

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());
               
               
               
         return view('admin.Reports.SafesTransferReportFilter',get_defined_vars());




    }



        //StoresMovesReport

          public function StoresMovesReport(){
               $Branches=Branches::all();
       $CostCenters=CostCenter::all();
            $Coins=Coins::all();
              $Stores=Stores::type()->get();
              $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
              $Accounts = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
              $Employess = Employess::type()->lazy();
              $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
   $Users = Admin::where('hidden',0)->get();
         return view('admin.Reports.StoresMovesReport',get_defined_vars());
    }

        public function SaveDefaultColumnsStoresMovesReport(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $CodeBill = $request->get('CodeBill');
                 $TimeBill = $request->get('TimeBill');
                 $BranchBill = $request->get('BranchBill');
                 $StoreBill = $request->get('StoreBill');
                 $SafeBill = $request->get('SafeBill');
                 $TypeBill = $request->get('TypeBill');
                 $Cost_CenterBill = $request->get('Cost_CenterBill');
                 $UserBill = $request->get('UserBill');
                 $CoinBill = $request->get('CoinBill');
                 $NoteBill = $request->get('NoteBill');
                 $Total_QtyBill = $request->get('Total_QtyBill');
                 $Total_PriceBill = $request->get('Total_PriceBill');
                 $AccountBill = $request->get('AccountBill');
                 $ShipBill = $request->get('ShipBill');



            $data['Date']=$DateBill;
            $data['Code']=$CodeBill;
            $data['Time']=$TimeBill;
            $data['Branch']=$BranchBill;
            $data['Store']=$StoreBill;
            $data['Safe']=$SafeBill;
            $data['Type']=$TypeBill;
            $data['Cost_Center']=$Cost_CenterBill;
            $data['User']=$UserBill;
            $data['Coin']=$CoinBill;
            $data['Note']=$NoteBill;
            $data['Total_Qty']=$Total_QtyBill;
            $data['Total_Price']=$Total_PriceBill;
            $data['Account']=$AccountBill;
            $data['Ship']=$ShipBill;



           StoresMovesColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

           public function StoresMovesReportFilter(Request $request){

           $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Time']=request('TimeDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Note']=request('NoteDet');
            $data['Total_Qty']=request('Total_QtyDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Account']=request('AccountDet');
            $data['Ship']=request('ShipDet');

           StoresMovesColumnsSechdule::orderBy('id','desc')->update($data);

    $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $store=request('Store');
              $safe=request('Safe');
              $account=request('Account');
              $type=request('Type');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $sadr=request('sadr');
              $ward=request('ward');

     $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'store'=>$store
        ,'safe'=>$safe
        ,'account'=>$account
        ,'type'=>$type
        ,'user'=>$user
        ,'shipping_Company'=>$shipping_Company
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'sadr'=>$sadr
        ,'ward'=>$ward

    ]);
        return     redirect('StoresMovesReportFilterNeww');

    }

          public function StoresMovesReportPrint(){

             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $store=request('Store');
              $safe=request('Safe');
              $account=request('Account');
              $type=request('Type');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
           $sadr=request('sadr');
              $ward=request('ward');


      $items=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
          ->paginate(10);



 $Bills_Nums=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
          ->count();


                $Total_Sadr=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($sadr), function ($query) use ($sadr) {
        return $query->whereIn('Type', $sadr);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
           ->get()->sum('Total_Qty');


       $Total_Ward=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($ward), function ($query) use ($ward) {
        return $query->whereIn('Type', $ward);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
           ->get()->sum('Total_Qty');


         $Total_Price_Sadr=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($sadr), function ($query) use ($sadr) {
        return $query->whereIn('Type', $sadr);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
           ->get()->sum('Total_Price');


       $Total_Price_Ward=StoresMoves::whereBetween('Date',[request('From'),request('To')])
             ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch',$branch);
    })


                 ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($ward), function ($query) use ($ward) {
        return $query->whereIn('Type', $ward);
    })


                   ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })


                        ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Account', $account);
    })


                        ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
        return $query->whereIn('Ship', $shipping_Company);
    })
           ->get()->sum('Total_Price');


               $colum=StoresMovesColumnsSechdule::orderBy('id','desc')->first();
    $CreditQty=$Total_Ward - $Total_Sadr ;
   $CreditPrice=$Total_Price_Ward - $Total_Price_Sadr ;
            $items->appends(request()->query());


        return view('admin.Reports.StoresMovesReportPrint',get_defined_vars());

    }

           public function StoresMovesReportFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
              $store=session()->get('store');
              $safe=session()->get('safe');
              $account=session()->get('account');
              $type=session()->get('type');
              $user=session()->get('user');
              $shipping_Company=session()->get('shipping_Company');
              $cost_Center=session()->get('cost_Center');
              $coin=session()->get('coin');
              $sadr=session()->get('sadr');
              $ward=session()->get('ward');

   // تأخذ الدالة معاملاً إضافيًا لتطبيق فلتر 'Type' بناءً على الغرض (items/Bills, sadr, ward)
$buildBaseStoresMovesQuery = function ($custom_type_filter = null) use ($from, $to, $branch, $store, $safe, $account, $type, $user, $shipping_Company, $cost_Center, $coin, $sadr, $ward) {
    // تحديد فلتر النوع المراد استخدامه
    $filter = match (true) {
        $custom_type_filter === 'sadr' => $sadr,
        $custom_type_filter === 'ward' => $ward,
        default => $type, // يُستخدم لـ $items و $Bills_Nums
    };

    return StoresMoves::query()
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
        ->when(!empty($filter), fn($q) => $q->whereIn('Type', $filter)) // استخدام الفلتر المحدد
        ->when(!empty($cost_Center), fn($q) => $q->where('Cost_Center', $cost_Center))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        ->when(!empty($coin), fn($q) => $q->where('Coin', $coin))
        ->when(!empty($account), fn($q) => $q->whereIn('Account', $account))
        ->when(!empty($shipping_Company), fn($q) => $q->whereIn('Ship', $shipping_Company));
};


$items = $buildBaseStoresMovesQuery()->paginate(10);

$Bills_Nums = $buildBaseStoresMovesQuery()->count();

$Total_Sadr = $buildBaseStoresMovesQuery('sadr')->get()->sum('Total_Qty');
               
$Total_Ward = $buildBaseStoresMovesQuery('ward')->get()->sum('Total_Qty');

// 3.5. إجمالي قيمة الصادر ($Total_Price_Sadr) - تستخدم $sadr
$Total_Price_Sadr = $buildBaseStoresMovesQuery('sadr')->get()->sum('Total_Price');

// 3.6. إجمالي قيمة الوارد ($Total_Price_Ward) - تستخدم $ward
$Total_Price_Ward = $buildBaseStoresMovesQuery('ward')->get()->sum('Total_Price');

// ----------------------------------------------------------------------
// 4. الحسابات النهائية
// ----------------------------------------------------------------------

// رصيد الكمية
$CreditQty = $Total_Ward - $Total_Sadr ;
// رصيد القيمة
$CreditPrice = $Total_Price_Ward - $Total_Price_Sadr ;

// 3.7. $colum
$colum=StoresMovesColumnsSechdule::orderBy('id','desc')->first();

// ----------------------------------------------------------------------
// 5. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());


         return view('admin.Reports.StoresMovesReportFilter',get_defined_vars());




    }



//ProductMoveDetails
          public function ProductMoveDetails(){

            $Branches=Branches::all();
            $Brand=Brands::all();
            $Group=ItemsGroups::all();
              $Stores=Stores::type()->get();
              $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $Users = Admin::where('hidden',0)->get();

         return view('admin.Reports.ProductMoveDetails',get_defined_vars());
    }

         public function SaveDefaultColumnsProductMoveDetails(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $Product_CodeBill = $request->get('Product_CodeBill');
                 $Product_NameBill = $request->get('Product_NameBill');
                 $UnitBill = $request->get('UnitBill');
                 $TypeBill = $request->get('TypeBill');
                 $Bill_NumBill = $request->get('Bill_NumBill');
                 $IncomBill = $request->get('IncomBill');
                 $OutcomBill = $request->get('OutcomBill');
                 $CreditBill = $request->get('CreditBill');
                 $GroupBill = $request->get('GroupBill');
                 $BrandBill = $request->get('BrandBill');
                 $StoreBill = $request->get('StoreBill');
                 $UserBill = $request->get('UserBill');
                 $SafeBill = $request->get('SafeBill');
                 $BranchBill = $request->get('BranchBill');



            $data['Date']=$DateBill;
            $data['Product_Code']=$Product_CodeBill;
            $data['Product_Name']=$Product_NameBill;
            $data['Unit']=$UnitBill;
            $data['Type']=$TypeBill;
            $data['Bill_Num']=$Bill_NumBill;
            $data['Incom']=$IncomBill;
            $data['Outcom']=$OutcomBill;
            $data['Credit']=$CreditBill;
            $data['Group']=$GroupBill;
            $data['Brand']=$BrandBill;
            $data['Store']=$StoreBill;
            $data['User']=$UserBill;
            $data['Safe']=$SafeBill;
            $data['Branch']=$BranchBill;



           ProductMovesColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

          public function ProductMoveDetailsFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Type']=request('TypeDet');
            $data['Bill_Num']=request('Bill_NumDet');
            $data['Incom']=request('IncomDet');
            $data['Outcom']=request('OutcomDet');
            $data['Credit']=request('CreditDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Store']=request('StoreDet');
            $data['User']=request('UserDet');
            $data['Safe']=request('SafeDet');
            $data['Branch']=request('BranchDet');
           ProductMovesColumnsSechdule::orderBy('id','desc')->update($data);

                   $from=request('From');
                   $to=request('To');
                   $store=request('Store');
              $type=request('Type');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $user=request('User');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $payment_method=request('Payment_Method');


             $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'store'=>$store
        ,'type'=>$type
        ,'safe'=>$safe
        ,'group'=>$group
        ,'brand'=>$brand
        ,'user'=>$user
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'payment_method'=>$payment_method


    ]);
        return     redirect('ProductMoveDetailsFilterNeww');



    }

           public function ProductMoveDetailsPrint(Request $request){


                         $store=request('Store');
              $type=request('Type');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $user=request('User');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

              $items=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->paginate(10);
      $colum=ProductMovesColumnsSechdule::orderBy('id','desc')->first();


     $CostIn=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostIn');




             $CostOut=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostOut');







         $Credit=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostCurrent');




     $Bills_Nums=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->count();



         return view('admin.Reports.ProductMoveDetailsPrint',get_defined_vars());
   }

        public function ProductMoveDetailsFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $store=session()->get('store');
              $type=session()->get('type');
              $safe=session()->get('safe');
              $group=session()->get('group');
              $brand=session()->get('brand');
              $user=session()->get('user');
              $branch=session()->get('branch');
              $product_Name=session()->get('product_Name');
              $product_Code=session()->get('product_Code');
              $payment_method=session()->get('payment_method');


  $buildBaseProductMovesQuery = function () use ($from, $to, $store, $type, $safe, $group, $brand, $user, $branch, $product_Name, $product_Code, $payment_method) {
    return ProductMoves::query()
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($type), fn($q) => $q->whereIn('Type', $type))
        ->when(!empty($payment_method), fn($q) => $q->whereIn('Payment_Method', $payment_method))
        ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة حركات المنتجات المصفحة)
$items = $buildBaseProductMovesQuery()
    ->orderBy('id', 'desc')
    ->paginate(50);

// 3.2. $colum (جلب إعدادات الأعمدة)
$colum=ProductMovesColumnsSechdule::orderBy('id','desc')->first();

// 3.3. إجمالي قيمة الوارد ($CostIn)
$CostIn = $buildBaseProductMovesQuery()->get()->sum('Incom');

// 3.4. إجمالي قيمة الصادر ($CostOut)
$CostOut = $buildBaseProductMovesQuery()->get()->sum('Outcom');

// 3.5. عدد الحركات ($Bills_Nums)
$Bills_Nums = $buildBaseProductMovesQuery()->count();

// ----------------------------------------------------------------------
// 4. الحساب النهائي
// ----------------------------------------------------------------------

// صافي الحركة (الرصيد)
$Credit = $CostIn - $CostOut ;

// ----------------------------------------------------------------------
// 5. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());


         return view('admin.Reports.ProductMoveDetailsFilter',get_defined_vars());



    }



    //CompareSalesPrice
       public function CompareSalesPrice(){

            $Branches=Branches::all();
            $Brand=Brands::all();
            $Group=ItemsGroups::all();
           $Stores=Stores::type()->get();
           $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $Users = Admin::where('hidden',0)->get();
              $Employess = Employess::type()->get();
         return view('admin.Reports.CompareSalesPrice',get_defined_vars());
    }

            public function SaveDefaultColumnsCompareSalesPrice(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $Product_CodeBill = $request->get('Product_CodeBill');
                 $Product_NameBill = $request->get('Product_NameBill');
                 $UnitBill = $request->get('UnitBill');
                 $TypeBill = $request->get('TypeBill');
                 $Bill_NumBill = $request->get('Bill_NumBill');
                 $IncomBill = $request->get('IncomBill');
                 $OutcomBill = $request->get('OutcomBill');
                 $CreditBill = $request->get('CreditBill');
                 $GroupBill = $request->get('GroupBill');
                 $BrandBill = $request->get('BrandBill');
                 $StoreBill = $request->get('StoreBill');
                 $UserBill = $request->get('UserBill');
                 $SafeBill = $request->get('SafeBill');
                 $BranchBill = $request->get('BranchBill');
                 $SalePriceBill = $request->get('SalePriceBill');
                 $ProductPriceBill = $request->get('ProductPriceBill');



            $data['Date']=$DateBill;
            $data['Product_Code']=$Product_CodeBill;
            $data['Product_Name']=$Product_NameBill;
            $data['Unit']=$UnitBill;
            $data['Type']=$TypeBill;
            $data['Bill_Num']=$Bill_NumBill;
            $data['Incom']=$IncomBill;
            $data['Outcom']=$OutcomBill;
            $data['Credit']=$CreditBill;
            $data['Group']=$GroupBill;
            $data['Brand']=$BrandBill;
            $data['Store']=$StoreBill;
            $data['User']=$UserBill;
            $data['Safe']=$SafeBill;
            $data['Branch']=$BranchBill;
            $data['SalePrice']=$SalePriceBill;
            $data['ProductPrice']=$ProductPriceBill;



           ComparePricesColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

          public function CompareSalesPriceFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Type']=request('TypeDet');
            $data['Bill_Num']=request('Bill_NumDet');
            $data['Incom']=request('IncomDet');
            $data['Outcom']=request('OutcomDet');
            $data['Credit']=request('CreditDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Store']=request('StoreDet');
            $data['User']=request('UserDet');
            $data['Safe']=request('SafeDet');
            $data['Branch']=request('BranchDet');
            $data['SalePrice']=request('SalePriceDet');
            $data['ProductPrice']=request('ProductPriceDet');
           ComparePricesColumnsSechdule::orderBy('id','desc')->update($data);



    $from=request('From');
                   $to=request('To');
                   $store=request('Store');
              $type=request('Type');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $user=request('User');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $delegate=request('Delegate');


            $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'store'=>$store
        ,'type'=>$type
        ,'safe'=>$safe
        ,'group'=>$group
        ,'brand'=>$brand
        ,'user'=>$user
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'delegate'=>$delegate


    ]);
        return     redirect('CompareSalesPriceFilterNeww');


    }

           public function CompareSalesPricePrint(){


          $from=request('From');
                   $to=request('To');
                   $store=request('Store');
              $type=request('Type');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $user=request('User');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

   $items=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })


                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->paginate(50);




               $colum=ComparePricesColumnsSechdule::orderBy('id','desc')->first();


     $CostIn=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostIn');




             $CostOut=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostOut');







         $Credit=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('CostCurrent');




     $Bills_Nums=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->count();

          $TotSalePrice=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('SalePrice');


                $TotProductPrice=ProductMoves::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store', $store);
    })
                 ->when(!empty($type), function ($query) use ($type) {
        return $query->whereIn('Type', $type);
    })

                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                   ->when(!empty($user), function ($query) use ($user) {
        return $query->whereIn('User', $user);
    })

                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
          ->get()->sum('ProductPrice');



         return view('admin.Reports.CompareSalesPricePrint',get_defined_vars());
   }
    
           public function CompareSalesPriceFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $store=session()->get('store');
              $type=session()->get('type');
              $safe=session()->get('safe');
              $group=session()->get('group');
              $brand=session()->get('brand');
              $user=session()->get('user');
              $branch=session()->get('branch');
              $product_Name=session()->get('product_Name');
              $product_Code=session()->get('product_Code');
              $delegate=session()->get('delegate');

$buildBaseProductMovesQuery = function () use ($from, $to, $store, $type, $safe, $group, $brand, $user, $branch, $product_Name, $product_Code, $delegate) {
    return ProductMoves::query()
        ->whereBetween('Date', [$from, $to])
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($type), fn($q) => $q->whereIn('Type', $type))
        ->when(!empty($safe), fn($q) => $q->whereIn('Safe', $safe))
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
        ->when(!empty($user), fn($q) => $q->whereIn('User', $user))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة حركات المنتجات المصفحة)
$items = $buildBaseProductMovesQuery()->paginate(50);

// 3.2. $colum (جلب إعدادات الأعمدة)
$colum=ComparePricesColumnsSechdule::orderBy('id','desc')->first();

// 3.3. إجمالي التكلفة الواردة ($CostIn)
$CostIn = $buildBaseProductMovesQuery()->get()->sum('CostIn');

// 3.4. إجمالي التكلفة الصادرة ($CostOut)
$CostOut = $buildBaseProductMovesQuery()->get()->sum('CostOut');

// 3.5. إجمالي التكلفة الحالية ($Credit)
$Credit = $buildBaseProductMovesQuery()->get()->sum('CostCurrent');

// 3.6. عدد الحركات ($Bills_Nums)
$Bills_Nums = $buildBaseProductMovesQuery()->count();

// 3.7. إجمالي سعر البيع ($TotSalePrice)
$TotSalePrice = $buildBaseProductMovesQuery()->get()->sum('SalePrice');

// 3.8. إجمالي سعر المنتج ($TotProductPrice)
$TotProductPrice = $buildBaseProductMovesQuery()->get()->sum('ProductPrice');


// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());


         return view('admin.Reports.ComparePricesFilter',get_defined_vars());





    }


    //MostSalesProducts
      public function MostSalesProducts(){

            $Branches=Branches::all();
            $Brand=Brands::all();
            $Group=ItemsGroups::all();
          $Stores=Stores::type()->get();
          $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();

         return view('admin.Reports.MostSalesProducts',get_defined_vars());
    }

           public function SaveDefaultColumnsMostSalesProducts(Request $request) {

                 $Product_CodeBill = $request->get('Product_CodeBill');
                 $Product_NameBill = $request->get('Product_NameBill');
                 $QtyBill = $request->get('QtyBill');
                 $PriceBill = $request->get('PriceBill');
                 $DiscountBill = $request->get('DiscountBill');
                 $TaxBill = $request->get('TaxBill');
                 $TotalBill = $request->get('TotalBill');
                 $StoreBill = $request->get('StoreBill');
                 $DateBill = $request->get('DateBill');
                 $UnitBill = $request->get('UnitBill');
                 $SafeBill = $request->get('SafeBill');
                 $BranchBill = $request->get('BranchBill');
                 $GroupBill = $request->get('GroupBill');
                 $BrandBill = $request->get('BrandBill');



            $data['Product_Code']=$Product_CodeBill;
            $data['Product_Name']=$Product_NameBill;
            $data['Qty']=$QtyBill;
            $data['Price']=$PriceBill;
            $data['Discount']=$DiscountBill;
            $data['Tax']=$TaxBill;
            $data['Total']=$TotalBill;
            $data['Store']=$StoreBill;
            $data['Date']=$DateBill;
            $data['Unit']=$UnitBill;
            $data['Safe']=$SafeBill;
            $data['Branch']=$BranchBill;
            $data['Group']=$GroupBill;
            $data['Brand']=$BrandBill;

           MostSalesProductsColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

          public function MostSalesProductsFilter(Request $request){



             $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Discount']=request('DiscountDet');
            $data['Tax']=request('TaxDet');
            $data['Total']=request('TotalDet');
            $data['Store']=request('StoreDet');
            $data['Date']=request('DateDet');
            $data['Unit']=request('UnitDet');
            $data['Safe']=request('SafeDet');
            $data['Branch']=request('BranchDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
           MostSalesProductsColumnSechdule::orderBy('id','desc')->update($data);



    $from=request('From');
                   $to=request('To');
                   $store=request('Store');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');


           $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'store'=>$store
        ,'safe'=>$safe
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code


    ]);
        return     redirect('MostSalesProductsFilterNeww');

    }

           public function MostSalesProductsPrint(){


           $from=request('From');
                   $to=request('To');
                   $store=request('Store');
              $safe=request('Safe');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

   $items=ProductSales::whereBetween('Date',[request('From'),request('To')])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })


                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('Product_Code', $product_Code);
    })
            ->distinct(['Product'])->paginate(10);




               $colum=MostSalesProductsColumnSechdule::orderBy('id','desc')->first();




         return view('admin.Reports.MostSalesProductsPrint',get_defined_vars());
   }
           public function MostSalesProductsFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $store=session()->get('store');
              $safe=session()->get('safe');
              $group=session()->get('group');
              $brand=session()->get('brand');
              $branch=session()->get('branch');
              $product_Name=session()->get('product_Name');
              $product_Code=session()->get('product_Code');


   $items=ProductSales::whereBetween('Date',[$from,$to])
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })


                  ->when(!empty($safe), function ($query) use ($safe) {
        return $query->whereIn('Safe', $safe);
    })


                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('Product_Code', $product_Code);
    })
            ->distinct(['Product'])->paginate(10);




               $colum=MostSalesProductsColumnSechdule::orderBy('id','desc')->first();




           $items->appends(request()->query());


         return view('admin.Reports.MostSalesProductsFilter',get_defined_vars());





    }



    //ProfitSalesProduct
      public function ProfitSalesProduct(){
            $Branches=Branches::all();
            $Brand=Brands::all();
            $Group=ItemsGroups::all();
          $Stores=Stores::type()->get();

          $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
          $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->orWhere('Parent',24)->get();
          $Employess = Employess::type()->get();

         return view('admin.Reports.ProfitSalesProduct',get_defined_vars());
    }


              public function SaveDefaultColumnsProfitSalesProduct(Request $request) {

                 $Product_CodeBill = $request->get('Product_CodeBill');
                 $Product_NameBill = $request->get('Product_NameBill');
                 $UnitBill = $request->get('UnitBill');
                 $QtyBill = $request->get('QtyBill');
                 $PriceBill = $request->get('PriceBill');
                 $CostBill = $request->get('CostBill');
                 $ProfitBill = $request->get('ProfitBill');
                 $StoreBill = $request->get('StoreBill');
                 $BranchBill = $request->get('BranchBill');
                 $GroupBill = $request->get('GroupBill');
                 $BrandBill = $request->get('BrandBill');




            $data['Product_Code']=$Product_CodeBill;
            $data['Product_Name']=$Product_NameBill;
            $data['Unit']=$UnitBill;
            $data['Qty']=$QtyBill;
            $data['Price']=$PriceBill;
            $data['Cost']=$CostBill;
            $data['Profit']=$ProfitBill;
            $data['Store']=$StoreBill;
            $data['Branch']=$BranchBill;
            $data['Group']=$GroupBill;
            $data['Brand']=$BrandBill;

           ProfitSalesProductColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

          public function ProfitSalesProductFilter(Request $request){


             $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Cost']=request('CostDet');
            $data['Profit']=request('ProfitDet');
            $data['Store']=request('StoreDet');
            $data['Branch']=request('BranchDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');

           ProfitSalesProductColumnSechdulr::orderBy('id','desc')->update($data);


              $branch=request('Branch');
              $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $From=request('From');
              $To=request('To');
              $Client=request('Client');
              $Safe=request('Safe');
              $Payment_Method=request('Payment_Method');
              $Delegate=request('Delegate');
              $Code=request('Code');

                  $request->session()->put([
        'branch'=>$branch
        ,'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'From'=>$From
        ,'To'=>$To
        ,'Client'=>$Client
        ,'Safe'=>$Safe
        ,'Payment_Method'=>$Payment_Method
        ,'Delegate'=>$Delegate
        ,'Code'=>$Code


    ]);
        return     redirect('ProfitSalesProductFilterNeww');


    }

           public function ProfitSalesProductPrint(){


            $branch=request('Branch');
              $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

   $items=ProductsQty::orderBy('id','asc')

          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
            ->paginate(10);


               $colum=ProfitSalesProductColumnSechdulr::orderBy('id','desc')->first();




         return view('admin.Reports.ProfitSalesProductPrint',get_defined_vars());
   }
           public function ProfitSalesProductFilterNeww(){


                          $branch=session()->get('branch');
                   $store=session()->get('store');
                   $group=session()->get('group');
              $brand=session()->get('brand');
              $product_Name=session()->get('product_Name');
              $product_Code=session()->get('product_Code');

              $From=session()->get('From');
              $To=session()->get('To');
              $Client=session()->get('Client');
              $Safe=session()->get('Safe');
              $Payment_Method=session()->get('Payment_Method');
              $Delegate=session()->get('Delegate');
              $Code=session()->get('Code');


   $items=ProductsQty::orderBy('id','asc')

          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })



                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
            ->paginate(100);


               $colum=ProfitSalesProductColumnSechdulr::orderBy('id','desc')->first();
           $items->appends(request()->query());


         return view('admin.Reports.ProfitSalesProductFilter',get_defined_vars());


    }


    //ClientAccountStatement
            public function ClientAccountStatement(){
                 $CostCenters=CostCenter::all();
            $Coins=Coins::all();
 $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->orWhere('Parent',37)->get();

         return view('admin.Reports.ClientAccountStatement',get_defined_vars());
    }

           public function ClientAccountStatementFilter(Request $request){



              $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Refrence_Number']=request('Refrence_NumberDet');
            $data['Client']=request('ClientDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Payment_Method']=request('Payment_MethodDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Shipping']=request('ShippingDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['ShiftCode']=request('ShiftCodeDet');
            $data['Executor']=request('ExecutorDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Due_Date']=request('Due_DateDet');
            $data['Delegate']=request('DelegateDet');
            $data['Note']=request('NoteDet');
            $data['Total_Return']=request('Total_ReturnDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Total_Discount']=request('Total_DiscountDet');
            $data['Total_Tax']=request('Total_TaxDet');
            $data['Total_Net']=request('Total_NetDet');
            $data['Paid']=request('PaidDet');
            $data['Residual']=request('ResidualDet');
            $data['Time']=request('TimeDet');

           ClientAccountStatementColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $client=request('Client');
              $payment_Method=request('Payment_Method');
              $types=request('Type');

   $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'client'=>$client
        ,'payment_Method'=>$payment_Method
        ,'types'=>$types

    ]);
        return     redirect('ClientAccountStatementFilterNeww');


    }

        public function SaveDefaultClientStatement(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $CodeBill = $request->get('CodeBill');
                 $Refrence_NumberBill = $request->get('Refrence_NumberBill');
                 $ClientBill = $request->get('ClientBill');
                 $BranchBill = $request->get('BranchBill');
                 $StoreBill = $request->get('StoreBill');
                 $Payment_MethodBill = $request->get('Payment_MethodBill');
                 $SafeBill = $request->get('SafeBill');
                 $TypeBill = $request->get('TypeBill');
                 $Shipping = $request->get('Shipping');
                 $Cost_CenterBill = $request->get('Cost_CenterBill');
                 $ShiftCode = $request->get('ShiftCode');
                 $ExecutorBill = $request->get('ExecutorBill');
                 $UserBill = $request->get('UserBill');
                 $CoinBill = $request->get('CoinBill');
                 $Due_Date = $request->get('Due_Date');
                 $DelegateBill = $request->get('DelegateBill');
                 $Note = $request->get('Note');
                 $Total_Return = $request->get('Total_Return');
                 $Total_Price = $request->get('Total_Price');
                 $Total_Discount = $request->get('Total_Discount');
                 $Total_Tax = $request->get('Total_Tax');
                 $Total_Net = $request->get('Total_Net');
                 $Paid = $request->get('Paid');
                 $Residual = $request->get('Residual');
                 $Time = $request->get('Time');


            $data['Date']=$DateBill;
            $data['Code']=$CodeBill;
            $data['Refrence_Number']=$Refrence_NumberBill;
            $data['Client']=$ClientBill;
            $data['Branch']=$BranchBill;
            $data['Store']=$StoreBill;
            $data['Payment_Method']=$Payment_MethodBill;
            $data['Safe']=$SafeBill;
            $data['Type']=$TypeBill;
            $data['Shipping']=$Shipping;
            $data['Cost_Center']=$Cost_CenterBill;
            $data['ShiftCode']=$ShiftCode;
            $data['Executor']=$ExecutorBill;
            $data['User']=$UserBill;
            $data['Coin']=$CoinBill;
            $data['Due_Date']=$Due_Date;
            $data['Delegate']=$DelegateBill;
            $data['Note']=$Note;
            $data['Total_Return']=$Total_Return;
            $data['Total_Price']=$Total_Price;
            $data['Total_Discount']=$Total_Discount;
            $data['Total_Tax']=$Total_Tax;
            $data['Total_Net']=$Total_Net;
            $data['Paid']=$Paid;
            $data['Residual']=$Residual;
            $data['Time']=$Time;

           ClientAccountStatementColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

    public function ClientAccountStatementPrint(){

                           $from=request('From');
              $to=request('To');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $client=request('Client');
              $payment_Method=request('Payment_Method');
              $types=request('Type');



      $items=Sales::whereBetween('Date',[request('From'),request('To')])

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })

          ->paginate(10);


$sales=0;
$sandQabd=0;
$sandSarf=0;

             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $sandSarf=1;
                 }elseif($ty[0] == 1){
                         $sales=1;

                     }elseif($ty[0] == 2){

               $sandQabd=1;
                     }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $sandSarf=1;
                 }elseif($ty[1] == 1){
                         $sales=1;

                     }elseif($ty[1] == 2){

               $sandQabd=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $sandSarf=1;
                 }elseif($ty[2] == 1){
                         $sales=1;

                     }elseif($ty[2] == 2){

               $sandQabd=1;
                     }
                 }

             }


               if($sandQabd == 1 and $sandSarf=1){
       $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->whereIn('Type', ['سند صرف','سند قبض'])
               ->get();
               }elseif($sandQabd == 1 and $sandSarf=0){
                     $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type','سند قبض')

               ->get();

               }elseif($sandQabd == 0 and $sandSarf=1){

                    $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type', 'سند صرف')
               ->get();

               }elseif($sandQabd == 0 and $sandSarf=0){
                   $Vouchers='';

               }


                  $colum=ClientAccountStatementColumnSechdule::orderBy('id','desc')->first();



        return view('admin.Reports.ClientAccountStatementPrint',get_defined_vars());

    }

           public function ClientAccountStatementFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $cost_Center=session()->get('cost_Center');
              $coin=session()->get('coin');
              $client=session()->get('client');
              $payment_Method=session()->get('payment_Method');
              $types=session()->get('types');



          $items=Sales::whereBetween('Date',[$from,$to])

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Client', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })

          ->paginate(10);


$sales=0;
$sandQabd=0;
$sandSarf=0;
$WaslAmana=0;
$Shekat=0;

               $account=$client;

             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $sandSarf=1;
                 }elseif($ty[0] == 1){
                         $sales=1;

                     }elseif($ty[0] == 2){

               $sandQabd=1;
                     }elseif($ty[0] == 4){

               $WaslAmana=1;
                     }elseif($ty[0] == 5){

               $Shekat=1;
                     }


                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $sandSarf=1;
                 }elseif($ty[1] == 1){
                         $sales=1;

                     }elseif($ty[1] == 2){

               $sandQabd=1;
                     }elseif($ty[1] == 4){

               $WaslAmana=1;
                     }elseif($ty[1] == 5){

               $Shekat=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $sandSarf=1;
                 }elseif($ty[2] == 1){
                         $sales=1;

                     }elseif($ty[2] == 2){

               $sandQabd=1;
                     }elseif($ty[2] == 4){

               $WaslAmana=1;
                     }elseif($ty[2] == 5){

               $Shekat=1;
                     }
                 }


                    if(!empty($ty[3])){
                     if($ty[3] == 3){
                     $sandSarf=1;
                 }elseif($ty[3] == 1){
                         $sales=1;

                     }elseif($ty[3] == 2){

               $sandQabd=1;
                     }elseif($ty[3] == 4){

               $WaslAmana=1;
                     }elseif($ty[3] == 5){

               $Shekat=1;
                     }
                 }


                   if(!empty($ty[4])){
                     if($ty[4] == 3){
                     $sandSarf=1;
                 }elseif($ty[4] == 1){
                         $sales=1;

                     }elseif($ty[4] == 2){

               $sandQabd=1;
                     }elseif($ty[4] == 4){

               $WaslAmana=1;
                     }elseif($ty[4] == 5){

               $Shekat=1;
                     }
                 }

             }



       $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->whereIn('Type', ['سند صرف','سند قبض','الشيكات الصادرة','الشيكات الواردة','وصل أمانة'])
               ->get();


                   $items->appends(request()->query());
                  $colum=ClientAccountStatementColumnSechdule::orderBy('id','desc')->first();


                $debt=GeneralDaily::where('Account',$client)->get()->sum('Debitor');
           $crdt=GeneralDaily::where('Account',$client)->get()->sum('Creditor');
            $Balance=$debt - $crdt ;



               $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })


                   ->get()->sum('Debitor_Coin');

               $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })


                   ->get()->sum('Creditor_Coin');

               $totalAllD=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->where('Account',$account);

               })


                   ->get()->sum('Debitor_Coin');

               $totalAllC=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->where('Account',$account);

               })



                   ->get()->sum('Creditor_Coin');

               $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })


                   ->get()->count();


               $Credit=$totalD - $totalC;
               $CreditAll=$totalAllD - $totalAllC;


               
               return view('admin.Reports.ClientAccountStatementFilter',get_defined_vars());

    }


        //VendorAccountStatement
            public function VendorAccountStatement(){

                 $CostCenters=CostCenter::all();

            $Coins=Coins::all();


 $Clients = AcccountingManual::
             where('Type',1)
              ->where('Parent',24)
              ->orWhere('Parent',37)
              ->get();




         return view('admin.Reports.VendorAccountStatement',get_defined_vars());
    }

           public function VendorAccountStatementFilter(Request $request){



              $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Refrence_Number']=request('Refrence_NumberDet');
            $data['Vendor']=request('ClientDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Payment_Method']=request('Payment_MethodDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Shipping']=request('ShippingDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['ShiftCode']=request('ShiftCodeDet');
            $data['Executor']=request('ExecutorDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Due_Date']=request('Due_DateDet');
            $data['Delegate']=request('DelegateDet');
            $data['Note']=request('NoteDet');
            $data['Total_Return']=request('Total_ReturnDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Total_Discount']=request('Total_DiscountDet');
            $data['Total_Tax']=request('Total_TaxDet');
            $data['Total_Net']=request('Total_NetDet');
            $data['Paid']=request('PaidDet');
            $data['Residual']=request('ResidualDet');
            $data['Time']=request('TimeDet');

           VendorAccountStatementColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $client=request('Vendor');
              $payment_Method=request('Payment_Method');
              $types=request('Type');

 $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'client'=>$client
        ,'payment_Method'=>$payment_Method
        ,'types'=>$types


    ]);
        return     redirect('VendorAccountStatementFilterNeww');


    }

        public function SaveDefaultColumnsVendorAccountStatement(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $CodeBill = $request->get('CodeBill');
                 $Refrence_NumberBill = $request->get('Refrence_NumberBill');
                 $ClientBill = $request->get('ClientBill');
                 $BranchBill = $request->get('BranchBill');
                 $StoreBill = $request->get('StoreBill');
                 $Payment_MethodBill = $request->get('Payment_MethodBill');
                 $SafeBill = $request->get('SafeBill');
                 $TypeBill = $request->get('TypeBill');
                 $Shipping = $request->get('Shipping');
                 $Cost_CenterBill = $request->get('Cost_CenterBill');
                 $ShiftCode = $request->get('ShiftCode');
                 $ExecutorBill = $request->get('ExecutorBill');
                 $UserBill = $request->get('UserBill');
                 $CoinBill = $request->get('CoinBill');
                 $Due_Date = $request->get('Due_Date');
                 $DelegateBill = $request->get('DelegateBill');
                 $Note = $request->get('Note');
                 $Total_Return = $request->get('Total_Return');
                 $Total_Price = $request->get('Total_Price');
                 $Total_Discount = $request->get('Total_Discount');
                 $Total_Tax = $request->get('Total_Tax');
                 $Total_Net = $request->get('Total_Net');
                 $Paid = $request->get('Paid');
                 $Residual = $request->get('Residual');
                 $Time = $request->get('Time');


            $data['Date']=$DateBill;
            $data['Code']=$CodeBill;
            $data['Refrence_Number']=$Refrence_NumberBill;
            $data['Vendor']=$ClientBill;
            $data['Branch']=$BranchBill;
            $data['Store']=$StoreBill;
            $data['Payment_Method']=$Payment_MethodBill;
            $data['Safe']=$SafeBill;
            $data['Type']=$TypeBill;
            $data['Shipping']=$Shipping;
            $data['Cost_Center']=$Cost_CenterBill;
            $data['ShiftCode']=$ShiftCode;
            $data['Executor']=$ExecutorBill;
            $data['User']=$UserBill;
            $data['Coin']=$CoinBill;
            $data['Due_Date']=$Due_Date;
            $data['Delegate']=$DelegateBill;
            $data['Note']=$Note;
            $data['Total_Return']=$Total_Return;
            $data['Total_Price']=$Total_Price;
            $data['Total_Discount']=$Total_Discount;
            $data['Total_Tax']=$Total_Tax;
            $data['Total_Net']=$Total_Net;
            $data['Paid']=$Paid;
            $data['Residual']=$Residual;
            $data['Time']=$Time;

           VendorAccountStatementColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];



       return response()->json($states);

    }

    public function VendorAccountStatementPrint(){

                           $from=request('From');
              $to=request('To');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $client=request('Vendor');
              $payment_Method=request('Payment_Method');
              $types=request('Type');



      $items=Purchases::whereBetween('Date',[request('From'),request('To')])

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })

          ->paginate(10);


$sales=0;
$sandQabd=0;
$sandSarf=0;

             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $sandSarf=1;
                 }elseif($ty[0] == 1){
                         $sales=1;

                     }elseif($ty[0] == 2){

               $sandQabd=1;
                     }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $sandSarf=1;
                 }elseif($ty[1] == 1){
                         $sales=1;

                     }elseif($ty[1] == 2){

               $sandQabd=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $sandSarf=1;
                 }elseif($ty[2] == 1){
                         $sales=1;

                     }elseif($ty[2] == 2){

               $sandQabd=1;
                     }
                 }

             }


               if($sandQabd == 1 and $sandSarf=1){
       $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->whereIn('Type', ['سند صرف','سند قبض'])
               ->get();
               }elseif($sandQabd == 1 and $sandSarf=0){
                     $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type','سند قبض')

               ->get();

               }elseif($sandQabd == 0 and $sandSarf=1){

                    $Vouchers=GeneralDaily::whereBetween('Date',[request('From'),request('To')])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type', 'سند صرف')
               ->get();

               }elseif($sandQabd == 0 and $sandSarf=0){
                   $Vouchers='';

               }


                  $colum=VendorAccountStatementColumnSechdule::orderBy('id','desc')->first();



        return view('admin.Reports.VendorAccountStatementPrint',get_defined_vars());

    }

           public function VendorAccountStatementFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $cost_Center=session()->get('cost_Center');
              $coin=session()->get('coin');
              $client=session()->get('client');
              $payment_Method=session()->get('payment_Method');
              $types=session()->get('types');

         $items=Purchases::whereBetween('Date',[$from,$to])

          ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Vendor', $client);
    })


                  ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
        return $query->whereIn('Payment_Method', $payment_Method);
    })

          ->paginate(10);


$sales=0;
$sandQabd=0;
$sandSarf=0;
               $account=$client;

               $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })



                   ->get()->sum('Debitor_Coin');

               $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })


                   ->get()->sum('Creditor_Coin');


               $totalAllD=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->where('Account',$account);

               })



                   ->get()->sum('Debitor_Coin');

               $totalAllC=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->where('Account',$account);

               })


                   ->get()->sum('Creditor_Coin');

               $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->where('Account',$account);

                   })



                   ->get()->count();


             if(!empty(request('Type'))){
               $ty=request('Type');

                 if(!empty($ty[0])){
                     if($ty[0] == 3){
                     $sandSarf=1;
                 }elseif($ty[0] == 1){
                         $sales=1;

                     }elseif($ty[0] == 2){

               $sandQabd=1;
                     }
                 }

                      if(!empty($ty[1])){
                     if($ty[1] == 3){
                     $sandSarf=1;
                 }elseif($ty[1] == 1){
                         $sales=1;

                     }elseif($ty[1] == 2){

               $sandQabd=1;
                     }
                 }


                      if(!empty($ty[2])){
                     if($ty[2] == 3){
                     $sandSarf=1;
                 }elseif($ty[2] == 1){
                         $sales=1;

                     }elseif($ty[2] == 2){

               $sandQabd=1;
                     }
                 }

             }


               if($sandQabd == 1 and $sandSarf=1){
       $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->whereIn('Type', ['سند صرف','سند قبض'])
               ->get();
               }elseif($sandQabd == 1 and $sandSarf=0){
                     $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type','سند قبض')
               ->get();

               }elseif($sandQabd == 0 and $sandSarf=1){

                    $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
    ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
        return $query->where('Cost_Center', $cost_Center);
    })


          ->when(!empty($coin), function ($query) use ($coin) {
        return $query->where('Coin', $coin);
    })

                  ->when(!empty($client), function ($query) use ($client) {
        return $query->where('Account', $client);
    })


               ->where('Type', 'سند صرف')
               ->get();

               }elseif($sandQabd == 0 and $sandSarf=0){
                   $Vouchers='';

               }

                   $items->appends(request()->query());
                  $colum=VendorAccountStatementColumnSechdule::orderBy('id','desc')->first();
             $debt=GeneralDaily::where('Account',$client)->get()->sum('Debitor');
           $crdt=GeneralDaily::where('Account',$client)->get()->sum('Creditor');
            $Balance=$debt - $crdt ;

               $Credit=$totalD - $totalC;
               $CreditAll=$totalAllD - $totalAllC;

         return view('admin.Reports.VendorAccountStatementFilter',get_defined_vars());


    }

    //ClientsStatement
      public function ClientsStatement(){

 $Clients = AcccountingManual::
             where('Type',1)
              ->where('Parent',24)
              ->get();




         return view('admin.Reports.ClientsStatement',get_defined_vars());
    }

        public function SaveDefaultColumnsClientsStatement(Request $request) {

                 $Account_CodeBill = $request->get('Account_CodeBill');
                 $Account_NameBill = $request->get('Account_NameBill');
                 $Debiator_BeforeBill = $request->get('Debiator_BeforeBill');
                 $Creditor_BeforeBill = $request->get('Creditor_BeforeBill');
                 $Total_DebitorBill = $request->get('Total_DebitorBill');
                 $Total_CreditorBill = $request->get('Total_CreditorBill');
                 $Debitor_BalanceBill = $request->get('Debitor_BalanceBill');
                 $Creditor_BalanceBill = $request->get('Creditor_BalanceBill');



            $data['Account_Code']=$Account_CodeBill;
            $data['Account_Name']=$Account_NameBill;
            $data['Debiator_Before']=$Debiator_BeforeBill;
            $data['Creditor_Before']=$Creditor_BeforeBill;
            $data['Total_Debitor']=$Total_DebitorBill;
            $data['Total_Creditor']=$Total_CreditorBill;
            $data['Debitor_Balance']=$Debitor_BalanceBill;
            $data['Creditor_Balance']=$Creditor_BalanceBill;


           ClientsStatementsColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];



       return response()->json($states);

    }

          public function ClientsStatementFilter(Request $request){



              $data['Account_Code']=request('Account_CodeDet');
            $data['Account_Name']=request('Account_NameDet');
            $data['Debiator_Before']=request('Debiator_BeforeDet');
            $data['Creditor_Before']=request('Creditor_BeforeDet');
            $data['Total_Debitor']=request('Total_DebitorDet');
            $data['Total_Creditor']=request('Total_CreditorDet');
            $data['Debitor_Balance']=request('Debitor_BalanceDet');
            $data['Creditor_Balance']=request('Creditor_BalanceDet');


           ClientsStatementsColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $account=request('Account');


              $request->session()->put(['from'=>$from,'to'=>$to,'account'=>$account]);

          return     redirect('ClientsStatementFilterNew');





    }

         public function ClientsStatementFilterNew(){


              $from=session()->get('from');
              $to=session()->get('to');
              $account=session()->get('account');


$items = AcccountingManual::where('Parent',24)
    ->where('Type', 1)

       ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('id', $account);
    })
          ->paginate(20);



             $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

                 ->when(!empty($account), function ($query) use ($account) {
                     return $query->whereIn('Account',$account);

                 })


                 ->get()->sum('Debitor_Coin');

             $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

                 ->when(!empty($account), function ($query) use ($account) {
                     return $query->whereIn('Account',$account);

                 })


                 ->get()->sum('Creditor_Coin');

             $totalAllD=GeneralDaily::

             when(!empty($account), function ($query) use ($account) {
                 return $query->whereIn('Account',$account);

             })


                 ->get()->sum('Debitor_Coin');

             $totalAllC=GeneralDaily::

             when(!empty($account), function ($query) use ($account) {
                 return $query->whereIn('Account',$account);

             })



                 ->get()->sum('Creditor_Coin');

             $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

                 ->when(!empty($account), function ($query) use ($account) {
                     return $query->whereIn('Account',$account);

                 })


                 ->get()->count();


             $Credit=$totalD - $totalC;
             $CreditAll=$totalAllD - $totalAllC;



                   $items->appends(request()->query());
                  $colum=ClientsStatementsColumnSechdule::orderBy('id','desc')->first();



         return view('admin.Reports.ClientsStatementFilter',get_defined_vars());
    }

       public function ClientsStatementPrint(){

              $from=request('From');
              $to=request('To');
              $account=request('Account');


$items = AcccountingManual::where('Parent',24)
    ->where('Type', 1)

       ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('id', $account);
    })
          ->paginate(10);


                   $items->appends(request()->query());
                  $colum=ClientsStatementsColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.ClientsStatementPrint',get_defined_vars());
    }

    //VendorsStatement
      public function VendorsStatement(){

 $Clients = AcccountingManual::
             where('Type',1)
              ->where('Parent',37)
              ->get();




         return view('admin.Reports.VendorsStatement',get_defined_vars());
    }

        public function SaveDefaultColumnsVendorsStatement(Request $request) {

                 $Account_CodeBill = $request->get('Account_CodeBill');
                 $Account_NameBill = $request->get('Account_NameBill');
                 $Debiator_BeforeBill = $request->get('Debiator_BeforeBill');
                 $Creditor_BeforeBill = $request->get('Creditor_BeforeBill');
                 $Total_DebitorBill = $request->get('Total_DebitorBill');
                 $Total_CreditorBill = $request->get('Total_CreditorBill');
                 $Debitor_BalanceBill = $request->get('Debitor_BalanceBill');
                 $Creditor_BalanceBill = $request->get('Creditor_BalanceBill');



            $data['Account_Code']=$Account_CodeBill;
            $data['Account_Name']=$Account_NameBill;
            $data['Debiator_Before']=$Debiator_BeforeBill;
            $data['Creditor_Before']=$Creditor_BeforeBill;
            $data['Total_Debitor']=$Total_DebitorBill;
            $data['Total_Creditor']=$Total_CreditorBill;
            $data['Debitor_Balance']=$Debitor_BalanceBill;
            $data['Creditor_Balance']=$Creditor_BalanceBill;


           VendorsStatementsColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];



       return response()->json($states);

    }

          public function VendorsStatementFilter(Request $request){



              $data['Account_Code']=request('Account_CodeDet');
            $data['Account_Name']=request('Account_NameDet');
            $data['Debiator_Before']=request('Debiator_BeforeDet');
            $data['Creditor_Before']=request('Creditor_BeforeDet');
            $data['Total_Debitor']=request('Total_DebitorDet');
            $data['Total_Creditor']=request('Total_CreditorDet');
            $data['Debitor_Balance']=request('Debitor_BalanceDet');
            $data['Creditor_Balance']=request('Creditor_BalanceDet');


           VendorsStatementsColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $account=request('Account');

        $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'account'=>$account
    ]);
        return     redirect('VendorsStatementFilterNeww');


    }

       public function VendorsStatementPrint(){

              $from=request('From');
              $to=request('To');
              $account=request('Account');


$items = AcccountingManual::where('Parent',37)
    ->where('Type', 1)

       ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('id', $account);
    })
          ->paginate(10);


                   $items->appends(request()->query());
                  $colum=VendorsStatementsColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.VendorsStatementPrint',get_defined_vars());
    }


           public function VendorsStatementFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $account=session()->get('account');




$items = AcccountingManual::where('Parent',37)
    ->where('Type', 1)

       ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('id', $account);
    })
          ->paginate(100);


               $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->whereIn('Account',$account);

                   })



                   ->get()->sum('Debitor_Coin');

               $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->whereIn('Account',$account);

                   })


                   ->get()->sum('Creditor_Coin');


               $totalAllD=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->whereIn('Account',$account);

               })



                   ->get()->sum('Debitor_Coin');

               $totalAllC=GeneralDaily::

               when(!empty($account), function ($query) use ($account) {
                   return $query->whereIn('Account',$account);

               })


                   ->get()->sum('Creditor_Coin');

               $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

                   ->when(!empty($account), function ($query) use ($account) {
                       return $query->whereIn('Account',$account);

                   })



                   ->get()->count();


               $Credit=$totalD - $totalC;
               $CreditAll=$totalAllD - $totalAllC;


               $items->appends(request()->query());
                  $colum=VendorsStatementsColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.VendorsStatementFilter',get_defined_vars());


    }

    //ExpensesList
       public function ExpensesList(){

            $Branches=Branches::all();
           $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $wfff=60;
  $MainAccounts=AcccountingManual::orderBy('Code','asc')
      ->where('Code','like', $wfff.'%')
      ->where('Type',0)->get();

      $SubAccounts=AcccountingManual::orderBy('Code','asc')
      ->where('Code','like', $wfff.'%')
      ->where('Type',1)->get();

         return view('admin.Reports.ExpensesList',get_defined_vars());
    }

        public function SaveDefaultColumnsExpensesList(Request $request) {

                 $DateBill = $request->get('DateBill');
                 $Code_TypeBill = $request->get('Code_TypeBill');
                 $StatementBill = $request->get('StatementBill');
                 $DebitorBill = $request->get('DebitorBill');
                 $Cost_CenterBill = $request->get('Cost_CenterBill');
                 $CoinBill = $request->get('CoinBill');
                 $UserBill = $request->get('UserBill');
                 $AccountBill = $request->get('AccountBill');
                 $BranchBill = $request->get('BranchBill');



            $data['Date']=$DateBill;
            $data['Code_Type']=$Code_TypeBill;
            $data['Statement']=$StatementBill;
            $data['Debitor']=$DebitorBill;
            $data['Cost_Center']=$Cost_CenterBill;
            $data['Coin']=$CoinBill;
            $data['User']=$UserBill;
            $data['Account']=$AccountBill;
            $data['Branch']=$BranchBill;


           ExpensesListColumn::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];



       return response()->json($states);

    }

           public function ExpensesListFilter(Request $request){



              $data['Date']=request('DateDet');
            $data['Code_Type']=request('Code_TypeDet');
            $data['Statement']=request('StatementDet');
            $data['Debitor']=request('DebitorDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['Coin']=request('CoinDet');
            $data['User']=request('UserDet');
            $data['Account']=request('AccountDet');
            $data['Branch']=request('BranchDet');


           ExpensesListColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $branch=request('Branch');
              $safe=request('Safe');
              $account=request('Account');
              $subAccount=request('SubAccount');

                 $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'safe'=>$safe
        ,'account'=>$account
        ,'subAccount'=>$subAccount



    ]);
        return     redirect('ExpensesListFilterNeww');

    }

       public function ExpensesListPrint(Request $request){


             $data['Date']=request('DateDet');
            $data['Code_Type']=request('Code_TypeDet');
            $data['Statement']=request('StatementDet');
            $data['Debitor']=request('DebitorDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['Coin']=request('CoinDet');
            $data['User']=request('UserDet');
            $data['Account']=request('AccountDet');
            $data['Branch']=request('BranchDet');


           ExpensesListColumnSechdule::orderBy('id','desc')->update($data);



           $from=request('From');
              $to=request('To');
              $branch=request('Branch');
              $safe=request('Safe');
              $account=request('Account');
              $subAccount=request('SubAccount');

                 $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'safe'=>$safe
        ,'account'=>$account
        ,'subAccount'=>$subAccount



    ]);

    return     redirect('ExpensesListFilterNewwPrint');


    }

      public function ExpensesListFilterNeww(Request $request){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
                   $safe=session()->get('safe');
                   $account=session()->get('account');
                   $subAccount=session()->get('subAccount');




$items = AcccountingManual::orderBy('Code','asc')


        ->when(!empty($subAccount), function ($query) use ($subAccount) {
        return $query->whereIn('id', $subAccount);
    })
          ->paginate(50);


                   $items->appends(request()->query());
                  $colum=ExpensesListColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.ExpensesListFilter',get_defined_vars());


    }
          public function ExpensesListFilterNewwPrint(Request $request){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
                   $safe=session()->get('safe');
                   $account=session()->get('account');
                   $subAccount=session()->get('subAccount');




$items = AcccountingManual::orderBy('Code','asc')


        ->when(!empty($subAccount), function ($query) use ($subAccount) {
        return $query->whereIn('id', $subAccount);
    })
          ->paginate(10);


                   $items->appends(request()->query());
                  $colum=ExpensesListColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.ExpensesListPrint',get_defined_vars());


    }


        //IncomListReport
        public function IncomListReport(){

            $Branches=Branches::all();
            $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
             $wfff=10201;
  $MainAccounts=AcccountingManual::orderBy('Code','asc')
      ->where('Code','like', $wfff.'%')
      ->where('Type',0)->get();

      $SubAccounts=AcccountingManual::orderBy('Code','asc')
      ->where('Code','like', $wfff.'%')
      ->where('Type',1)->get();

         return view('admin.Reports.IncomListReport',get_defined_vars());
    }

               public function IncomListReportFilter(Request $request){



              $data['Date']=request('DateDet');
            $data['Code_Type']=request('Code_TypeDet');
            $data['Statement']=request('StatementDet');
            $data['Debitor']=request('DebitorDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['Coin']=request('CoinDet');
            $data['User']=request('UserDet');
            $data['Account']=request('AccountDet');
            $data['Branch']=request('BranchDet');


           ExpensesListColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $branch=request('Branch');
              $safe=request('Safe');
              $account=request('Account');
              $subAccount=request('SubAccount');

                 $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'safe'=>$safe
        ,'account'=>$account
        ,'subAccount'=>$subAccount



    ]);
        return     redirect('IncomListReportFilterNeww');

    }

          public function IncomListReportFilterNeww(){


                          $from=session()->get('from');
                   $to=session()->get('to');
                   $branch=session()->get('branch');
                   $safe=session()->get('safe');
                   $account=session()->get('account');
                   $subAccount=session()->get('subAccount');




$items = AcccountingManual::orderBy('Code','asc')

        ->when(!empty($subAccount), function ($query) use ($subAccount) {
        return $query->whereIn('id', $subAccount);
    })
          ->paginate(10);


                   $items->appends(request()->query());
                  $colum=ExpensesListColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.IncomListFilter',get_defined_vars());


    }


           public function IncomListReportPrint(){


             $data['Date']=request('DateDet');
            $data['Code_Type']=request('Code_TypeDet');
            $data['Statement']=request('StatementDet');
            $data['Debitor']=request('DebitorDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['Coin']=request('CoinDet');
            $data['User']=request('UserDet');
            $data['Account']=request('AccountDet');
            $data['Branch']=request('BranchDet');


           ExpensesListColumnSechdule::orderBy('id','desc')->update($data);



              $from=request('From');
              $to=request('To');
              $branch=request('Branch');
              $safe=request('Safe');
              $account=request('Account');
              $subAccount=request('SubAccount');


$items = AcccountingManual::orderBy('Code','asc')


        ->when(!empty($subAccount), function ($query) use ($subAccount) {
        return $query->whereIn('id', $subAccount);
    })
          ->paginate(10);



                  $colum=ExpensesListColumnSechdule::orderBy('id','desc')->first();

         return view('admin.Reports.IncomListReportPrint',get_defined_vars());
    }



    //SubIncomList
       public function SubIncomList(){

            $Branches=Branches::all();


         return view('admin.Reports.SubIncomList',get_defined_vars());
    }

        public function SubIncomListFilter(){



              $from=request('From');
              $to=request('To');
              $branch=request('Branch');



$TotaslSales =Sales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })

          ->get()->sum('Total_Price');



$TotaslStoresTrans =StorsTransfers::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total');


    $CostStoresTrans =StorsTransfers::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Cost');




            $TotaslReturnStoresTrans =ReturnStorsTransfer::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total');


    $CostReturnStoresTrans =ReturnStorsTransfer::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Cost');





    $TotaslMaintaince =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
           ->where('Status',8)
        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total');


                $TotaslMaintainceDisc =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
           ->where('Status',8)
        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Discount');



                      $TotaslMaintainceCost =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
           ->where('Status',8)
        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Cost');



            $TotaslReturnMaintaince =ReturnMaintainceBill::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total');




            $Total_Taxes =Sales::whereBetween('Date',[request('From'),request('To')])


        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Taxes');


                    $ProfitTax =Sales::whereBetween('Date',[request('From'),request('To')])


        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('ProfitTax');


                 $Total_Discount =Sales::whereBetween('Date',[request('From'),request('To')])


        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Discount');


               $Total_Cost =Sales::whereBetween('Date',[request('From'),request('To')])


        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Cost');



                    $Total_Return_Value =ReturnSales::whereBetween('Date',[request('From'),request('To')])

        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Return_Value');


                                $PaymentVoucher =PaymentVoucher::whereBetween('Date',[request('From'),request('To')])


        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->whereIn('Branch', $branch);
    })
          ->get()->sum('Total_Debaitor');


                 $StoresTransferProfit= $TotaslStoresTrans -  $CostStoresTrans ;

            $total_net=($TotaslSales + $TotaslMaintaince + $Total_Taxes + $ProfitTax + $StoresTransferProfit) - ($Total_Discount + $TotaslMaintainceDisc) ;

            $profit=$total_net - ($Total_Cost + $TotaslMaintainceCost) ;

$profit_net=$profit - $PaymentVoucher ;



         return view('admin.Reports.SubIncomListFilter',get_defined_vars());
    }


    //EmpGoals
          public function EmpGoals(){

            $Employess=Employess::type()->get();


         return view('admin.Reports.EmpGoals',get_defined_vars());
    }

         public function EmpGoalsFilter(Request $request){

              $emp=request('Emp');



                $request->session()->put([
        'emp'=>$emp



    ]);
        return     redirect('EmpGoalsFilterNeww');



    }

          public function EmpGoalsFilterNeww(Request $request){


            $emp=session()->get('emp');

 $items=Employess::orderBy('id','asc')
->type()
        ->when(!empty($emp), function ($query) use ($emp) {
        return $query->whereIn('id', $emp);
    })
               ->paginate(10);
               $items->appends(request()->query());
     return view('admin.Reports.EmpGoalsFilter',get_defined_vars());


    }


//InventorySerial
         public function InventorySerial(){

            $Brand=Brands::all();
            $Group=ItemsGroups::all();

         return view('admin.Reports.InventorySerial',get_defined_vars());
    }

          public function InventorySerialFilter(Request $request){

              $Group=request('Group');
              $Brand=request('Brand');
              $Product_Name=request('Product_Name');
              $Product_Code=request('Product_Code');


                  $request->session()->put([
        'Group'=>$Group
        ,'Brand'=>$Brand
        ,'Product_Name'=>$Product_Name
        ,'Product_Code'=>$Product_Code
    ]);
        return     redirect('InventorySerialFilterNeww');

    }

         public function InventorySerialFilterNeww(Request $request){


            $Group=session()->get('Group');
            $Brand=session()->get('Brand');
            $Product_Name=session()->get('Product_Name');
            $Product_Code=session()->get('Product_Code');


           $items=ProductUnits::where('P_Type','Serial')

                                 ->when(!empty($Group), function ($query) use ($Group) {
        return $query->whereIn('Group', $Group);
    })


                   ->when(!empty($Brand), function ($query) use ($Brand) {
        return $query->whereIn('Brand', $Brand);
    })
                     ->when(!empty($Product_Name), function ($query) use ($Product_Name) {
        return $query->where('P_Ar_Name','ILIKE', "%{$Product_Name}%");
    })

                       ->when(!empty($Product_Code), function ($query) use ($Product_Code) {
        return $query->where('Barcode','ILIKE', "%{$Product_Code}%");
    })

               ->paginate(10);

           $items->appends(request()->query());
         return view('admin.Reports.InventorySerialFilter',get_defined_vars());

    }



    //StoresCostNew
            public function StoresCostNew(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                $Stores=Stores::type()->get();
         return view('admin.Reports.StoresCostNew',get_defined_vars());
    }

           public function StoresCostNewFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

   
               $buildBaseProductsQtyQuery = function () use ($store, $group, $brand, $branch, $product_Name, $product_Code) {
    return ProductsQty::query()
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة المنتجات المصفحة بالكمية)
$items = $buildBaseProductsQtyQuery()
    ->orderBy('Group', 'asc') // الحفاظ على ترتيب الـ $items
    ->paginate(10);

// 3.2. عدد المنتجات ($Products_Num)
$Products_Num = $buildBaseProductsQtyQuery()
    ->orderBy('id', 'asc') // الحفاظ على الترتيب الأصلي إذا كان له معنى
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseProductsQtyQuery()
    ->orderBy('id', 'asc') // الحفاظ على الترتيب الأصلي إذا كان له معنى
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
$Total_Cost = $buildBaseProductsQtyQuery()
    ->orderBy('id', 'asc') // الحفاظ على الترتيب الأصلي إذا كان له معنى
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

         return view('admin.Reports.StoresCostNewFilter',get_defined_vars());
    }


      public function StoresCostNewPrint(){

              $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');

   $items=ProductsQty::orderBy('Group','asc')
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->paginate(10);

        $Products_Num=ProductsQty::orderBy('id','asc')
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->count();



                 $Total_Qty=ProductsQty::orderBy('id','asc')
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->get()->sum('Qty');


                  $Total_Cost=ProductsQty::orderBy('id','asc')
          ->when(!empty($store), function ($query) use ($store) {
        return $query->whereIn('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->get()->sum('TotalCost');




           $items->appends(request()->query());


         return view('admin.Reports.StoresCostNewPrint',get_defined_vars());
    }



    //Filters
         public function BranchReportStoresFilter(Request $request) {

                 $branch = $request->get('Branch');

               if(app()->getLocale() == 'ar' ){
       $states = Stores::where("Branch",$branch)->pluck("Name","id");
               }else{
            $states = Stores::where("Branch",$branch)->pluck("NameEn","id");
               }


       return response()->json($states);

    }

      public function BranchReportSafesFilter(Request $request) {

                 $branch = $request->get('Branch');

              if(app()->getLocale() == 'ar' ){
       $states = SafesBanks::where("Branch",$branch)->pluck("Name","Account");
              }else{
         $states = SafesBanks::where("Branch",$branch)->pluck("NameEn","Account");
              }


       return response()->json($states);

    }

      public function ClientGroupsFilter(Request $request) {

                 $Group = $request->get('Clients_Group');


                if(app()->getLocale() == 'ar' ){
       $states = Customers::where("Group",$Group)->pluck("Name","Account");
                }else{
            $states = Customers::where("Group",$Group)->pluck("NameEn","Account");
                }


       return response()->json($states);

    }


   

    //StoresBalancesNew
             public function StoresBalancesNew(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                 $Stores=Stores::type()->get();
         return view('admin.Reports.StoresBalancesNew',get_defined_vars());
    }

           public function StoresBalancesNewFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $zeros=request('Zero');


                 $request->session()->put([
        'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'zeros'=>$zeros


    ]);
        return     redirect('StoresBalancesNewFilterNeww');




    }


      public function StoresBalancesNewPrint(Request $request){

            $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
   $zeros=request('Zero');
   $items=ProductsQty::orderBy('Group','asc')->

                   when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->paginate(10);


       $artilces = '';
        if ($request->ajax()) {
            $store=$request->get('Store');
            $zeros=$request->get('Zero');
            foreach ($items as $item) {
                  $AllQty=ProductsQty::where('Product',$item->Product)->get()->sum('Qty');
                                                $AllBalance=0;
                                                $AllBalanceTwo=0;
                  for($i=0 ; $i < count($store) ; $i++){
                          $StoreQtyTwo=ProductsQty::where('Product',$item->Product)->where('Store',$store[$i])->get()->sum('Qty');
                                 $AllBalanceTwo += $StoreQtyTwo ;
                  }

                                    if($zeros == 1){
                                            if($AllBalanceTwo != 0){
                                                $artilces.=' <tr>
                                                <td>'.$item->P_Code.'</td>
                                                <td>'.$item->P_Ar_Name.'</td>
                                                <td>'.$AllQty.'</td>
                                                ';

                                                  for($i=0 ; $i < count($store) ; $i++){
                                                      $StoreQty=ProductsQty::where('Product',$item->Product)->where('Store',$store[$i])->get()->sum('Qty');
                                                      $AllBalance += $StoreQty ;
                                                 $artilces.= '<td>'.$StoreQty.' </td> ';

                                                 }

                                     $artilces.='<td>'.$AllBalance.'</td> </tr>';

                                            }
                                            }else{

                                          $artilces.=' <tr>
                                                <td>'.$item->P_Code.'</td>
                                                <td>'.$item->P_Ar_Name.'</td>
                                                <td>'.$AllQty.'</td>
                                                ';

                                                  for($i=0 ; $i < count($store) ; $i++){
                                                      $StoreQty=ProductsQty::where('Product',$item->Product)->where('Store',$store[$i])->get()->sum('Qty');
                                                       $AllBalance += $StoreQty ;
                                                 $artilces.= '<td>'.$StoreQty.' </td> ';

                                                 }

                                     $artilces.='<td>'.$AllBalance.'</td></tr>';

                                    }


                 $AllBalance=0;
                $AllBalanceTwo=0;
            }
            return $artilces;
        }





           $items->appends(request()->query());



         return view('admin.Reports.StoresBalancesNewPrint',get_defined_vars());
    }

             public function StoresBalancesNewFilterNeww(Request $request){


            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $branch=session()->get('branch');
            $product_Name=session()->get('product_Name');
            $product_Code=session()->get('product_Code');
            $zeros=session()->get('zeros');

$buildBaseProductsQtyQuery = function ($apply_qty_filter = false) use ($store, $group, $brand, $branch, $product_Name, $product_Code, $zeros) {
    return ProductsQty::query()
        ->when($apply_qty_filter && $zeros != 0, fn($q) => $q->where('Qty', '!=', 0)) // تطبيق فلتر الكمية إذا لزم الأمر
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة المنتجات المصفحة)
// نستخدم نفس الدالة، ونطبق فلتر الكمية بناءً على قيمة $zeros
$items = $buildBaseProductsQtyQuery(true) // تطبيق فلتر الكمية لـ $items
    ->distinct(['Product'])
    ->paginate(50);

// 3.2. عدد المنتجات ($Products_Num)
// بما أن $Products_Num و $Total_Qty و $Total_Cost كانت كلها تستخدم where('Qty', '!=', 0) بشكل افتراضي،
// سنمرر true لـ $apply_qty_filter.
$Products_Num = $buildBaseProductsQtyQuery(true)
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseProductsQtyQuery(true)
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
$Total_Cost = $buildBaseProductsQtyQuery(true)
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

         return view('admin.Reports.StoresBalancesNewFilter',get_defined_vars());
    }


//StoresBalancesCat
                public function StoresBalancesCat(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                    $Stores=Stores::type()->get();
         return view('admin.Reports.StoresBalancesCat',get_defined_vars());
    }

           public function StoresBalancesCatFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
   $zeros=request('Zero');


                        $request->session()->put([
        'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'zeros'=>$zeros


    ]);
        return     redirect('StoresBalancesCatFilterNeww');



    }

      public function StoresBalancesCatPrint(){

            $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
   $zeros=request('Zero');
   $items=ProductsQty::

                   when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name', $product_Name);
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->paginate(10);






           $items->appends(request()->query());



         return view('admin.Reports.StoresBalancesCatPrint',get_defined_vars());
    }

             public function StoresBalancesCatFilterNeww(Request $request){


            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $branch=session()->get('branch');
            $product_Name=session()->get('product_Name');
            $product_Code=session()->get('product_Code');
            $zeros=session()->get('zeros');

$buildBaseProductsQtyQuery = function () use ($store, $group, $brand, $branch, $product_Name, $product_Code, $zeros) {
    $query = ProductsQty::query()
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));

    // تطبيق شرط 'Qty != 0' إذا كانت $zeros لا تساوي 0
    if ($zeros != 0) {
        $query->where('Qty', '!=', 0);
    }

    return $query;
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة المنتجات المصفحة)
// نستخدم الدالة المساعدة التي تطبق شرط $zeros
$items = $buildBaseProductsQtyQuery()
    ->distinct(['Product'])
    ->paginate(10);

// 3.2. عدد المنتجات ($Products_Num)
// نستخدم الدالة المساعدة التي تطبق شرط $zeros
$Products_Num = $buildBaseProductsQtyQuery()
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
// نستخدم الدالة المساعدة التي تطبق شرط $zeros
$Total_Qty = $buildBaseProductsQtyQuery()
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
// نستخدم الدالة المساعدة التي تطبق شرط $zeros
$Total_Cost = $buildBaseProductsQtyQuery()
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());


         return view('admin.Reports.StoresBalancesCatFilter',get_defined_vars());
    }


    //StoresInventoryNew
                public function StoresInventoryNew(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                    $Stores=Stores::type()->get();
         return view('admin.Reports.StoresInventoryNew',get_defined_vars());
    }

           public function StoresInventoryNewFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $zero=request('Zero');


                          $request->session()->put([
        'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'zero'=>$zero


    ]);
        return     redirect('StoresInventoryNewFilterNeww');


    }


      public function StoresInventoryNewPrint(){

                       $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
   $zero=request('Zero');

               if($zero == 0){

   $items=ProductsQty::
          when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->paginate(100);





        $Products_Num=ProductsQty::
          when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->count();



                 $Total_Qty=ProductsQty::
          when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
        return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->get()->sum('Qty');


                  $Total_Cost=ProductsQty::
          when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
     return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->get()->sum('TotalCost');


               }else{

               $items=ProductsQty::where('Qty','!=',0)
          ->when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
      return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->paginate(100);





        $Products_Num=ProductsQty::where('Qty','!=',0)
          ->when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
      return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->count();



                 $Total_Qty=ProductsQty::where('Qty','!=',0)
          ->when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
         return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->get()->sum('Qty');


                  $Total_Cost=ProductsQty::where('Qty','!=',0)
          ->when(!empty($store), function ($query) use ($store) {
        return $query->where('Store',$store);
    })



                   ->when(!empty($group), function ($query) use ($group) {
        return $query->whereIn('Group', $group);
    })


                   ->when(!empty($brand), function ($query) use ($brand) {
        return $query->whereIn('Brand', $brand);
    })


                        ->when(!empty($branch), function ($query) use ($branch) {
        return $query->where('Branch', $branch);
    })


                        ->when(!empty($product_Name), function ($query) use ($product_Name) {
       return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
    })


                        ->when(!empty($product_Code), function ($query) use ($product_Code) {
        return $query->where('P_Code', $product_Code);
    })
        ->distinct(['Product'])->get()->sum('TotalCost');


               }

           $items->appends(request()->query());





         return view('admin.Reports.StoresInventoryNewPrint',get_defined_vars());
    }


           public function StoresInventoryNewFilterNeww(Request $request){


            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $branch=session()->get('branch');
            $product_Name=session()->get('product_Name');
            $product_Code=session()->get('product_Code');
            $zero=session()->get('zero');

         $buildBaseProductsQtyQuery = function () use ($store, $group, $brand, $branch, $product_Name, $product_Code, $zero) {
    $query = ProductsQty::query()
        ->when(!empty($store), fn($q) => $q->where('Store', $store))
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', 'ILIKE', "%{$product_Name}%"))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));

    // تطبيق شرط 'Qty != 0' إذا كانت $zero لا تساوي 0
    if ($zero != 0) {
        $query->where('Qty', '!=', 0);
    }

    return $query;
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج باستخدام الدالة المساعدة
// ----------------------------------------------------------------------

// 3.1. $items (قائمة المنتجات المصفحة)
// نستخدم الدالة المساعدة التي تطبق شرط $zero
$items = $buildBaseProductsQtyQuery()
    ->distinct(['Product'])
    ->paginate(100);

// 3.2. عدد المنتجات ($Products_Num)
// نستخدم الدالة المساعدة التي تطبق شرط $zero
$Products_Num = $buildBaseProductsQtyQuery()
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
// نستخدم الدالة المساعدة التي تطبق شرط $zero
$Total_Qty = $buildBaseProductsQtyQuery()
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
// نستخدم الدالة المساعدة التي تطبق شرط $zero
$Total_Cost = $buildBaseProductsQtyQuery()
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());


         return view('admin.Reports.StoresInventoryNewFilter',get_defined_vars());


    }


    //ItemCost
            public function ItemCost(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                $Stores=Stores::type()->get();
         return view('admin.Reports.ItemCost',get_defined_vars());
    }

           public function ItemCostNewFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $zero=request('Zero');


                        $request->session()->put([
        'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'zero'=>$zero


    ]);
        return     redirect('ItemCostNewFilterNeww');


    }

      public function ItemCostNewFilterNeww(Request $request){


            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $branch=session()->get('branch');
            $product_Name=session()->get('product_Name');
            $product_Code=session()->get('product_Code');
            $zero=session()->get('zero');

             $buildBaseProductsQtyQuery = function ($apply_nonzero_filter) use ($store, $group, $brand, $branch, $product_Name, $product_Code) {
    $query = ProductsQty::query()
        ->when($apply_nonzero_filter, fn($q) => $q->where('Qty', '!=', 0)) // تطبيق فلتر الكمية غير الصفرية
        ->when(!empty($store), fn($q) => $q->where('Store', $store))
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', 'ILIKE', "%{$product_Name}%"))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
    
    return $query;
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج بناءً على قيمة $zero
// ----------------------------------------------------------------------

// تحديد ما إذا كان يجب تطبيق فلتر 'Qty != 0'
$applyNonZero = ($zero != 0);


// 3.1. $items (قائمة المنتجات المصفحة)
$items = $buildBaseProductsQtyQuery($applyNonZero)
    ->distinct(['Product'])
    ->paginate(100);

// 3.2. عدد المنتجات ($Products_Num)
// بما أن المنتجات التالية (العدد، الإجمالي، التكلفة) كلها كانت تستخدم where('Qty','!=',0) في الكود الأصلي عندما $zero != 0،
// سنقوم بتطبيق نفس منطق الفلترة (استنادًا إلى $zero) للحفاظ على التناسق مع الكود الأصلي.
$Products_Num = $buildBaseProductsQtyQuery($applyNonZero)
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseProductsQtyQuery($applyNonZero)
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
$Total_Cost = $buildBaseProductsQtyQuery($applyNonZero)
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());

          return view('admin.Reports.ItemCostNewFilter',get_defined_vars());


    }

    //DelegateSalesDetailss
              public function DelegateSalesDetailss(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                  $Stores=Stores::type()->get();
                          $Employess = Employess::type()->get();

         return view('admin.Reports.DelegateSalesDetailss',get_defined_vars());
    }

        public function DelegateSalesDetailssFilter(Request $request){


              $from=request('From');
              $to=request('To');
              $delegate=request('Delegate');
              $branch=request('Branch');
              $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $payment_Method=request('Payment_Method');

                    $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'delegate'=>$delegate
        ,'branch'=>$branch
        ,'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'payment_Method'=>$payment_Method


    ]);
        return     redirect('DelegateSalesDetailssFilterNeww');


    }

      public function DelegateSalesDetailssFilterNeww(Request $request){


            $from=session()->get('from');
            $to=session()->get('to');
            $delegate=session()->get('delegate');
            $branch=session()->get('branch');
            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $payment_Method=session()->get('payment_Method');

       $buildBaseProductSalesQuery = function () use ($from, $to, $delegate, $branch, $store, $group, $brand, $payment_Method) {
    return ProductSales::query()
        ->whereBetween('Date', [$from, $to])
        // شروط الفلترة
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
        // شروط الارتباط بالجدول الرئيسي Sales
        ->whereRelation('Sales', 'Edit', 0)
        ->whereRelation('Sales', 'Delete', 0);
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج لـ ProductSales
// ----------------------------------------------------------------------

// 3.1. $items (قائمة تفاصيل المبيعات المصفحة)
$items = $buildBaseProductSalesQuery()
    ->paginate(100);

// 3.2. إجمالي فواتير المبيعات ($Total_Bills)
$Total_Bills = $buildBaseProductSalesQuery()
    ->get()->sum('Total');

// 3.3. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseProductSalesQuery()
    ->get()->sum('Qty');

// 3.4. إجمالي الخصم ($Total_Discount)
$Total_Discount = $buildBaseProductSalesQuery()
    ->get()->sum('TDiscount');

// 3.5. إجمالي الضريبة ($TotalTax)
$TotalTax = $buildBaseProductSalesQuery()
    ->get()->sum('Total_Tax');

// ----------------------------------------------------------------------
// 4. بناء استعلام Total_Return لـ ReturnSalesProducts
// ----------------------------------------------------------------------

$Total_Return = ReturnSalesProducts::query()
    ->whereBetween('Date', [$from, $to])
    ->when(!empty($group), function ($query) use ($group) {
        // شرط العلاقة على حقل Group في جدول Product
        return $query->whereRelation('Product', function ($query) use ($group) {
            return $query->whereIn('Group', $group);
        });
    })
    ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
    // شروط الارتباط بالجدول الرئيسي Return
    ->whereRelation('Return', 'Edit', 0)
    ->whereRelation('Return', 'Delete', 0)
    ->get()->sum('Total');


// ----------------------------------------------------------------------
// 5. حساب إجمالي الصافي ($Total_Net)
// ----------------------------------------------------------------------

$Total_Net = ($Total_Bills + $TotalTax) - $Total_Discount;


// ----------------------------------------------------------------------
// 6. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());
         return view('admin.Reports.DelegateSalesDetailssFilter',get_defined_vars());


    }




    //ProfitDelegateSalesDetails
               public function ProfitDelegateSalesDetails(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                   $Stores=Stores::type()->get();
                   $Employess = Employess::type()->get();

         return view('admin.Reports.ProfitDelegateSalesDetails',get_defined_vars());
    }

        public function ProfitDelegateSalesDetailsFilter(Request $request){


              $from=request('From');
              $to=request('To');
              $delegate=request('Delegate');
              $branch=request('Branch');
              $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $payment_Method=request('Payment_Method');

                             $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'delegate'=>$delegate
        ,'branch'=>$branch
        ,'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'payment_Method'=>$payment_Method


    ]);
        return     redirect('ProfitDelegateSalesDetailsFilterNeww');


    }

  public function ProfitDelegateSalesDetailsFilterNeww(Request $request){


            $from=session()->get('from');
            $to=session()->get('to');
            $delegate=session()->get('delegate');
            $branch=session()->get('branch');
            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $payment_Method=session()->get('payment_Method');


    $buildBaseProductSalesQuery = function () use ($from, $to, $delegate, $branch, $store, $group, $brand, $payment_Method) {
    return ProductSales::query()
        ->whereBetween('Date', [$from, $to])
        // شروط الفلترة
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($payment_Method), fn($q) => $q->whereIn('Payment_Method', $payment_Method))
        ->when(!empty($delegate), fn($q) => $q->whereIn('Delegate', $delegate))
        // شروط الارتباط بالجدول الرئيسي Sales
        ->whereRelation('Sales', 'Edit', 0)
        ->whereRelation('Sales', 'Delete', 0);
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج
// ----------------------------------------------------------------------

// 3.1. $items (قائمة تفاصيل المبيعات المصفحة)
$items = $buildBaseProductSalesQuery()
    ->paginate(20);

// 3.2. إجمالي صافي المبيعات ($total)
$total = $buildBaseProductSalesQuery()
    ->get()->sum('Total_Net');

// 3.3. إجمالي الكمية ($TotQty)
$TotQty = $buildBaseProductSalesQuery()
    ->get()->sum('Qty');


// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());
         return view('admin.Reports.ProfitDelegateSalesDetailsFilter',get_defined_vars());


    }
    
    
    //StoresCosts
            public function StoresCosts(){

            $Branches=Branches::all();

               $Brand=Brands::all();
            $Group=ItemsGroups::all();
                $Stores=Stores::type()->get();

         return view('admin.Reports.StoresCosts',get_defined_vars());
    }

           public function StoresCostsFilter(Request $request){


                $store=request('Store');
              $group=request('Group');
              $brand=request('Brand');
              $branch=request('Branch');
              $product_Name=request('Product_Name');
              $product_Code=request('Product_Code');
              $zeros=request('Zero');


    $request->session()->put([
        'store'=>$store
        ,'group'=>$group
        ,'brand'=>$brand
        ,'branch'=>$branch
        ,'product_Name'=>$product_Name
        ,'product_Code'=>$product_Code
        ,'zeros'=>$zeros


    ]);
        return     redirect('StoresCostsFilterNeww');


    }
    
  public function StoresCostsFilterNeww(Request $request){


            $store=session()->get('store');
            $group=session()->get('group');
            $brand=session()->get('brand');
            $branch=session()->get('branch');
            $product_Name=session()->get('product_Name');
            $product_Code=session()->get('product_Code');
            $zeros=session()->get('zeros');



      $buildBaseProductsQtyQuery = function ($apply_nonzero_filter) use ($store, $group, $brand, $branch, $product_Name, $product_Code) {
    $query = ProductsQty::query()
        ->when($apply_nonzero_filter, fn($q) => $q->where('Qty', '!=', 0)) // تطبيق فلتر الكمية غير الصفرية
        ->when(!empty($group), fn($q) => $q->whereIn('Group', $group))
        ->when(!empty($brand), fn($q) => $q->whereIn('Brand', $brand))
        ->when(!empty($store), fn($q) => $q->whereIn('Store', $store))
        ->when(!empty($branch), fn($q) => $q->where('Branch', $branch))
        ->when(!empty($product_Name), fn($q) => $q->where('P_Ar_Name', $product_Name))
        ->when(!empty($product_Code), fn($q) => $q->where('P_Code', $product_Code));
    
    return $query;
};

// ----------------------------------------------------------------------
// 3. بناء الاستعلامات وتخزين النتائج بناءً على قيمة $zeros
// ----------------------------------------------------------------------

// تحديد ما إذا كان يجب تطبيق فلتر 'Qty != 0'
// القيمة تكون true إذا كانت $zeros != 0، وتكون false إذا كانت $zeros == 0
$applyNonZeroFilter = ($zeros != 0);


// 3.1. $items (قائمة المنتجات المصفحة)
// نطبق الفلتر وفقًا لـ $zeros
$items = $buildBaseProductsQtyQuery($applyNonZeroFilter)
    ->distinct(['Product'])
    ->paginate(10);


// 3.2. عدد المنتجات ($Products_Num)
// في الكود الأصلي، هذه الاستعلامات دائمًا تطبق where('Qty','!=',0)، بغض النظر عن قيمة $zeros.
// لذلك سنمرر true لـ $apply_nonzero_filter لهذه الاستعلامات لتمثيل المنطق الأصلي.
$Products_Num = $buildBaseProductsQtyQuery(true)
    ->count();

// 3.3. إجمالي الكمية ($Total_Qty)
$Total_Qty = $buildBaseProductsQtyQuery(true)
    ->get()->sum('Qty');

// 3.4. إجمالي التكلفة ($Total_Cost)
$Total_Cost = $buildBaseProductsQtyQuery(true)
    ->get()->sum('TotalCost');

// ----------------------------------------------------------------------
// 4. إضافة شروط الاستعلام إلى الروابط المصفحة
// ----------------------------------------------------------------------

$items->appends(request()->query());
         return view('admin.Reports.StoresCostsFilter',get_defined_vars());


    }

    //InstallmentCompaniesSales
        public function InstallmentCompaniesSales(){

            $Branches=Branches::all();
$CustomersGroup=CustomersGroup::all();

                 $CostCenters=CostCenter::all();

            $Coins=Coins::all();

             $Users = Admin::where('hidden',0)->get();
            $Stores=Stores::type()->get();
            $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
            $Employess = Employess::type()->lazy();
            $Executors = Employess::type()->lazy();
            $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
            $Def=SalesDefaultData::orderBy('id','desc')->first();
            $Shippings = AcccountingManual::where('Type',1)->where('Parent',97)->get();
            $Compaines=InstallmentCompanies::all();

         return view('admin.Reports.InstallmentCompaniesSales',get_defined_vars());
    }

           public function InstallmentCompaniesSalesFilter(Request $request){



            $data['Date']=request('DateDet');
            $data['Code']=request('CodeDet');
            $data['Refrence_Number']=request('Refrence_NumberDet');
            $data['Branch']=request('BranchDet');
            $data['Store']=request('StoreDet');
            $data['Payment_Method']=request('Payment_MethodDet');
            $data['Safe']=request('SafeDet');
            $data['Type']=request('TypeDet');
            $data['Shipping']=request('ShippingDet');
            $data['Cost_Center']=request('Cost_CenterDet');
            $data['ShiftCode']=request('ShiftCodeDet');
            $data['Executor']=request('ExecutorDet');
            $data['User']=request('UserDet');
            $data['Coin']=request('CoinDet');
            $data['Due_Date']=request('Due_DateDet');
            $data['Delegate']=request('DelegateDet');
            $data['Note']=request('NoteDet');
            $data['Total_Return']=request('Total_ReturnDet');
            $data['Total_Price']=request('Total_PriceDet');
            $data['Total_Discount']=request('Total_DiscountDet');
            $data['Total_Tax']=request('Total_TaxDet');
            $data['Total_Net']=request('Total_NetDet');
            $data['Paid']=request('PaidDet');
            $data['Residual']=request('ResidualDet');
            $data['Time']=request('TimeDet');
            $data['Product_Code']=request('Product_CodeDet');
            $data['Product_Name']=request('Product_NameDet');
            $data['Unit']=request('UnitDet');
            $data['Av_Qty']=request('Av_QtyDet');
            $data['Qty']=request('QtyDet');
            $data['Price']=request('PriceDet');
            $data['Discount']=request('DiscountDet');
            $data['Total_BF_Tax']=request('Total_BF_TaxDet');
            $data['Tax']=request('TaxDet');
            $data['Total']=request('TotalDet');
            $data['Group']=request('GroupDet');
            $data['Brand']=request('BrandDet');
            $data['Exp_Date']=request('Exp_DateDet');
            $data['Product_Store']=request('Product_StoreDet');
                $data['Client']=request('ClientDet');
             $data['InstallCompany']=request('InstallCompanyDet');
            $data['ContractNumber']=request('ContractNumberDet');
            $data['PayFees']=request('PayFeesDet');
            $data['ServiceFee']=request('ServiceFeeDet');
            $data['CompanyPrecent']=request('CompanyPrecentDet');
           InstallCompaniesSalesBillsColumnsSechdule::orderBy('id','desc')->update($data);



                             $from=request('From');
                   $to=request('To');
                   $branch=request('Branch');
              $clients_Group=request('Clients_Group');
              $cost_Center=request('Cost_Center');
              $coin=request('Coin');
              $code=request('Code');
              $shift_Code=request('Shift_Code');
              $refrence_Number=request('Refrence_Number');
              $store=request('Store');
              $safe=request('Safe');
              $client=request('Client');
              $payment_Method=request('Payment_Method');
              $delegate=request('Delegate');
              $executor=request('Executor');
              $user=request('User');
              $shipping_Company=request('Shipping_Company');
              $types=request('Type');
              $installCompany=request('InstallCompany');
              $contractNumber=request('ContractNumber');
              $payFees=request('PayFees');

                           $request->session()->put([
        'from'=>$from
        ,'to'=>$to
        ,'branch'=>$branch
        ,'clients_Group'=>$clients_Group
        ,'cost_Center'=>$cost_Center
        ,'coin'=>$coin
        ,'code'=>$code
        ,'shift_Code'=>$shift_Code
        ,'refrence_Number'=>$refrence_Number
        ,'store'=>$store
        ,'safe'=>$safe
        ,'client'=>$client
        ,'payment_Method'=>$payment_Method
        ,'delegate'=>$delegate
        ,'executor'=>$executor
        ,'user'=>$user
        ,'shipping_Company'=>$shipping_Company
        ,'types'=>$types
        ,'installCompany'=>$installCompany
        ,'contractNumber'=>$contractNumber
        ,'payFees'=>$payFees


    ]);
        return     redirect('InstallmentCompaniesSalesFilterNeww');


    }

        public function SaveDefaultColumnsInstallmentCompaniesSales(Request $request) {

                 $Date = $request->get('Date');
                 $Code = $request->get('Code');
                 $Refrence_Number = $request->get('Refrence_Number');
                 $Branch = $request->get('Branch');
                 $Store = $request->get('Store');
                 $Payment_Method = $request->get('Payment_Method');
                 $Safe = $request->get('Safe');
                 $Type = $request->get('Type');
                 $Shipping = $request->get('Shipping');
                 $Cost_Center = $request->get('Cost_Center');
                 $ShiftCode = $request->get('ShiftCode');
                 $Executor = $request->get('Executor');
                 $User = $request->get('User');
                 $Coin = $request->get('Coin');
                 $Due_Date = $request->get('Due_Date');
                 $Delegate = $request->get('Delegate');
                 $Note = $request->get('Note');
                 $Total_Return = $request->get('Total_Return');
                 $Total_Price = $request->get('Total_Price');
                 $Total_Discount = $request->get('Total_Discount');
                 $Total_Tax = $request->get('Total_Tax');
                 $Total_Net = $request->get('Total_Net');
                 $Paid = $request->get('Paid');
                 $Residual = $request->get('Residual');
                 $Time = $request->get('Time');
                 $Product_Code = $request->get('Product_Code');
                 $Product_Name = $request->get('Product_Name');
                 $Unit = $request->get('Unit');
                 $Av_Qty = $request->get('Av_Qty');
                 $Qty = $request->get('Qty');
                 $Price = $request->get('Price');
                 $Discount = $request->get('Discount');
                 $Total_BF_Tax = $request->get('Total_BF_Tax');
                 $Tax = $request->get('Tax');
                 $Total = $request->get('Total');
                 $Group = $request->get('Group');
                 $Brand = $request->get('Brand');
                 $Exp_Date = $request->get('Exp_Date');
                 $Product_Store = $request->get('Product_Store');
                 $ClientBill = $request->get('ClientBill');
                 $InstallCompanyBill = $request->get('InstallCompanyBill');
                 $ContractNumberBill = $request->get('ContractNumberBill');
                 $PayFeesBill = $request->get('PayFeesBill');
                 $ServiceFeeBill = $request->get('ServiceFeeBill');
                 $CompanyPrecentBill = $request->get('CompanyPrecentBill');


            $data['Date']=$Date;
            $data['Code']=$Code;
            $data['Refrence_Number']=$Refrence_Number;
            $data['Branch']=$Branch;
            $data['Store']=$Store;
            $data['Payment_Method']=$Payment_Method;
            $data['Safe']=$Safe;
            $data['Type']=$Type;
            $data['Shipping']=$Shipping;
            $data['Cost_Center']=$Cost_Center;
            $data['ShiftCode']=$ShiftCode;
            $data['Executor']=$Executor;
            $data['User']=$User;
            $data['Coin']=$Coin;
            $data['Due_Date']=$Due_Date;
            $data['Delegate']=$Delegate;
            $data['Note']=$Note;
            $data['Total_Return']=$Total_Return;
            $data['Total_Price']=$Total_Price;
            $data['Total_Discount']=$Total_Discount;
            $data['Total_Tax']=$Total_Tax;
            $data['Total_Net']=$Total_Net;
            $data['Paid']=$Paid;
            $data['Residual']=$Residual;
            $data['Time']=$Time;
            $data['Product_Code']=$Product_Code;
            $data['Product_Name']=$Product_Name;
            $data['Unit']=$Unit;
            $data['Av_Qty']=$Av_Qty;
            $data['Qty']=$Qty;
            $data['Price']=$Price;
            $data['Discount']=$Discount;
            $data['Total_BF_Tax']=$Total_BF_Tax;
            $data['Tax']=$Tax;
            $data['Total']=$Total;
            $data['Group']=$Group;
            $data['Brand']=$Brand;
            $data['Exp_Date']=$Exp_Date;
            $data['Product_Store']=$Product_Store;
            $data['Client']=$ClientBill;
            $data['InstallCompany']=$InstallCompanyBill;
            $data['ContractNumber']=$ContractNumberBill;
            $data['PayFees']=$PayFeesBill;
            $data['ServiceFee']=$ServiceFeeBill;
            $data['CompanyPrecent']=$CompanyPrecentBill;

           InstallCompaniesSalesBillsColumns::orderBy('id','desc')->update($data);

       $states = ['Status'=>'Status'];


       return response()->json($states);

    }

      public function InstallmentCompaniesSalesFilterNeww(Request $request){


            $from=session()->get('from');
            $to=session()->get('to');
            $branch=session()->get('branch');
            $clients_Group=session()->get('clients_Group');
            $cost_Center=session()->get('cost_Center');
            $coin=session()->get('coin');
            $code=session()->get('code');
            $shift_Code=session()->get('shift_Code');
            $refrence_Number=session()->get('refrence_Number');
            $store=session()->get('store');
            $safe=session()->get('safe');
            $client=session()->get('client');
            $payment_Method=session()->get('payment_Method');
            $delegate=session()->get('delegate');
            $executor=session()->get('executor');
            $user=session()->get('user');
            $shipping_Company=session()->get('shipping_Company');
            $types=session()->get('types');
            $installCompany=session()->get('installCompany');
            $contractNumber=session()->get('contractNumber');
            $payFees=session()->get('payFees');


      $colum=InstallCompaniesSalesBillsColumnsSechdule::orderBy('id','desc')->first();
          
            $items = Sales::query()
            ->whereBetween('Date', [$from, $to])
            ->when($branch, fn ($query) => $query->where('Branch', $branch))
            ->when($clientsGroup, fn ($query) => $query->where('CustomerGroup', $clientsGroup))
            ->when($costCenter, fn ($query) => $query->where('Cost_Center', $costCenter))
            ->when($coin, fn ($query) => $query->where('Coin', $coin))
            ->when($code, fn ($query) => $query->where('Code', $code))
            ->when($shiftCode, fn ($query) => $query->where('Shift_Code', $shiftCode))
            ->when($referenceNumber, fn ($query) => $query->where('Refernce_Number', $referenceNumber))
            ->when($store, fn ($query) => $query->whereIn('Store', (array) $store)) // Ensure array for whereIn
            ->when($safe, fn ($query) => $query->whereIn('Safe', (array) $safe))
            ->when($client, fn ($query) => $query->whereIn('Client', (array) $client))
            ->when($paymentMethod, fn ($query) => $query->whereIn('Payment_Method', (array) $paymentMethod))
            ->when($delegate, fn ($query) => $query->whereIn('Delegate', (array) $delegate))
            ->when($executor, fn ($query) => $query->whereIn('Executor', (array) $executor))
            ->when($user, fn ($query) => $query->whereIn('User', (array) $user))
            ->when($shippingCompany, fn ($query) => $query->whereIn('Ship', (array) $shippingCompany))
            ->when($types, fn ($query) => $query->whereIn('Status', (array) $types))
            ->when($installCompany, fn ($query) => $query->whereIn('InstallCompany', (array) $installCompany))
            ->when($contractNumber, fn ($query) => $query->where('ContractNumber', $contractNumber))
            ->when($payFees, fn ($query) => $query->where('PayFees', $payFees));

 $items->where('Edit', 1)->where('Delete', 0);

              
  $totalQuery = clone $baseQuery;

        $totalQty = $totalQuery->sum('Total_Qty');
        $totalDiscount = $totalQuery->sum('Total_Discount');
        $totalTax = $totalQuery->sum('Total_Taxes');
        $totalProfitTax = $totalQuery->sum('ProfitTax');
        $totalBillsPrice = $totalQuery->sum('Total_Price');

        $totalCombinedTax = $totalTax + $totalProfitTax;
        $totalNet = ($totalCombinedTax + $totalBillsPrice) - $totalDiscount;

          
          
          
            $statusFlags = [
            'type' => 0, // Default for type 3
            'typeMstlma' => 0, // Default for type 1 (Received)
            'typeMo3l2a' => 0, // Default for type 0 (Pending)
        ];

        // Process 'types' array from request
        if (!empty($types) && is_array($types)) {
            foreach ($types as $typeValue) {
                if ((int)$typeValue === 3) {
                    $statusFlags['type'] = 1;
                } elseif ((int)$typeValue === 1) {
                    $statusFlags['typeMstlma'] = 1;
                } elseif ((int)$typeValue === 0) {
                    $statusFlags['typeMo3l2a'] = 1;
                }
            }
        }
        // Extract to individual variables if needed for view, or pass the array directly
        extract($statusFlags);
          


  $items = $items->paginate(10)->appends($request->query());

         return view('admin.Reports.InstallmentCompaniesSalesFilter',get_defined_vars());


    }

  // DailyClosingDetails
           public function DailyClosingDetails(){
               $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
         return view('admin.Reports.DailyClosingDetails',[
            'Safes'=>$Safes,

         ]);
    }

    function DailyClosingDetailsFilter(Request $request)
    {
     if($request->ajax())
     {
      $output = '';
      $out = '';
       $from = $request->get('From');
      $to = $request->get('To');
      $safe = $request->get('Safe');
      $payment = $request->get('Payment_Method');


    if( $safe != ''){

           $PurchCash =Purchases::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Edit',0)
         ->where('Delete',0)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Net');


            $PurchLater =Purchases::orderBy('id','asc')
                      ->where('Edit',0)
                ->where('Delete',0)
                ->where('Safe',$safe)
         ->where('Payment_Method','Later')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');


            $Cash =Sales::orderBy('id','asc')
                      ->where('Edit',0)
                      ->where('Delete',0)
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Net');


            $Later =Sales::orderBy('id','asc')
             ->where('Edit',0)
             ->where('Delete',0)
         ->where('Safe',$safe)
         ->where('Payment_Method','Later')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');

            $CashVisa =Sales::orderBy('id','asc')
                 ->where('Edit',0)
                 ->where('Delete',0)
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash_Visa')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Net');


          $Installment =Sales::orderBy('id','asc')
               ->where('Edit',0)
               ->where('Delete',0)
         ->where('Safe',$safe)
         ->where('Payment_Method','Installment')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('presenter');


        $Visa =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('Safe',$safe)
            ->where('Payment_Method','Visa')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Net');



        $Check =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('Safe',$safe)
            ->where('Payment_Method','Check')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Net');



        $Cash_Collection =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('Safe',$safe)
            ->where('Payment_Method','Cash_Collection')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Net');



        $Delivery =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('Safe',$safe)
            ->where('Payment_Method','Delivery')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Net');



        $InstallmentCompanies =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('Safe',$safe)
            ->where('Payment_Method','InstallmentCompanies')
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Total_Net');


        $TotSales=  $Cash + $Later +  $CashVisa+ $Installment + $Visa  + $Check  + $Cash_Collection  + $Delivery + $InstallmentCompanies ;
        $TotPurch=  $PurchCash + $PurchLater;





                      $ReciptTot =ReciptVoucher::orderBy('id','asc')
                          ->where('Edit',null)
                          ->where('Delete',null)
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Creditor');




                      $PaymentTot =PaymentVoucher::orderBy('id','asc')
                          ->where('Edit',null)
                          ->where('Delete',null)
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Debaitor');


$DifRP= $ReciptTot - $PaymentTot ;
         $Amount = $DifRP +   $TotSales  ;

        $Discooo =Sales::orderBy('id','asc')
            ->where('Edit',0)
            ->where('Delete',0)
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');

             $ALLLL =Sales::orderBy('id','asc')
                 ->where('Edit',0)
                 ->where('Delete',0)
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Discount');



        $TransferTotTo=SafeTransfers::where('To_Safe',$safe)
            ->whereBetween('Date', [$from, $to])
        ->get()->sum('Amount');



        $TransferTotFrom=SafeTransfers::where('From_Safe',$safe)
            ->whereBetween('Date', [$from, $to])
        ->get()->sum('Amount');

      $Disc=$Cash - $Discooo ;
      $DiscAll=$ALLLL ;



             $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','الشيكات الواردة')
          ->get()->sum('Debitor_Coin');

                   $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','تسوية بالعجز')
          ->get()->sum('Debitor_Coin');

                    $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','استلام وصل أمانة')
          ->get()->sum('Debitor_Coin');


            $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])

         ->where('Safe',$safe)
          ->get()->sum('Total');


                          $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','البوليصه')
          ->get()->sum('Debitor_Coin');


         $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','الصيانة')
          ->get()->sum('Debitor_Coin');




                $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','الشيكات الصادرة')
          ->get()->sum('Creditor_Coin');


                $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','تسوية بالزيادة')
          ->get()->sum('Creditor_Coin');


              $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','مرتجع الصيانة')
          ->get()->sum('Creditor_Coin');

                  $Salary =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','صرف راتب')
          ->get()->sum('Creditor_Coin');

                  $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','سلفة موظف')
          ->get()->sum('Creditor_Coin');

                  $Loan =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','قرض موظف')
          ->get()->sum('Creditor_Coin');

                  $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type',trans('admin.ExchangeCommissions'))
          ->get()->sum('Creditor_Coin');

           }


        $output .= '
      <tr class="Sales">
            <td>'.trans('admin.Sales').'</td>
        <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalesDet" onclick="DetailsSales()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


        $RCashh =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
             ->where('Payment_Method', 'Cash')
          ->get()->sum('Total_Return_Value');

                $RLaterr =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
             ->where('Payment_Method', 'Later')
          ->get()->sum('Pay');

         $KhsmMasmou7 =Sales::whereBetween('Date', [$from, $to])
             ->where('Safe',$safe)
             ->get()->sum('Total_Discount');


         //$TotallSaless=$TotSales + $RCashh + $RLaterr ;
         $TotallSaless=$TotSales;
             $output .= '
   <tr class="TotalSales">
        <td>     '.trans('admin.Total_Sales').' </td>
<td style="border: none;text-align: end;">'.$TotallSaless + $KhsmMasmou7.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


               $output .= '
      <tr class="RSales">
                <td>  '.trans('admin.Return_Sales').'</td>
           <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RSalesDet" onclick="DetailsRSales()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';

       $RTotSales=  $RCashh + $RLaterr ;


             $output .= '
   <tr class="RTotalSales">
     <td>   '.trans('admin.Total_Return_Sales').' </td>
<td style="border: none;text-align: end;">'.$RTotSales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


           $KhsmMasmou7 =Sales::whereBetween('Date', [$from, $to])
         ->where('Safe',$safe)
          ->get()->sum('Total_Discount');

                  $output .= '
   <tr class="TotalSales">
    <td>    '.trans('admin.Discount_Allow').' </td>
<td style="border: none;text-align: end;">'.$KhsmMasmou7.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

         $SafySales=$TotallSaless - ($RTotSales);

                     $output .= '
   <tr class="NetSales">
     <td>       '.trans('admin.Net_Sales').' </td>
<td style="border: none;text-align: end;">'.$SafySales.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                      $output .= '
      <tr class="Recipt">
               <td>    '.trans('admin.Recipt_Vouchers').'</td>
              <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ReciptDet" onclick="DetailsRecipt()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';




             $output .= '
   <tr class="TotalRecipt">
        <td>         '.trans('admin.Total_Recipt_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$ReciptTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


         $output .= '
      <tr class="Payment">
            <td> '.trans('admin.Safes_Transfer').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TranferToDet" onclick="DetailsTransferTo()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';





             $output .= '
   <tr class="TotalPayment">
       <td>   '.trans('admin.Total_Safes_Transfer').'</td>
<td style="border: none;text-align: end;">'.$TransferTotTo.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


            $output .= '
      <tr class="ImportCheck">
             <td> '.trans('admin.Incoming_Checks').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ImportCheckDet" onclick="DetailsImportCheck()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';





             $output .= '
   <tr class="ImportCheck">
     <td>  '.trans('admin.Total_Incoming_Checks').'</td>
<td style="border: none;text-align: end;">'.$ImportCheck.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';

                     $output .= '
      <tr class="Settlement3agz">
            <td>  '.trans('admin.Disability_Settlement').'</td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Setllement3agzDet" onclick="DetailsSetllement3agz()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Settlement3agz">
      <td>  '.trans('admin.Total_Disability_Settlement').'</td>
<td style="border: none;text-align: end;">'.$Setllement3agz.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


                          $output .= '
      <tr class="WaslAmana">
      <td>   '.trans('admin.Insurance_Paper').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#WaslAmanaDet" onclick="DetailsWaslAmana()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="WaslAmana">
       <td>   '.trans('admin.Total_Insurance_Paper').'</td>
<td style="border: none;text-align: end;">'.$WaslAmana.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';

                        $output .= '
      <tr class="SalesPetrol">
        <td>  '.trans('admin.Sales_Petrol').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalesPetrolDet" onclick="DetailsSalesPetrol()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="SalesPetrol">
     <td>    '.trans('admin.Total_Sales_Petrol').'</td>
<td style="border: none;text-align: end;">'.$SalesPetrol.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


                            $output .= '
      <tr class="shippingTicket">
           <td>     '.trans('admin.Shipping_Ticket').' </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#shippingTicketDet" onclick="DetailsshippingTicket()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="shippingTicket">
     <td>    '.trans('admin.Total_Shipping_Ticket').'</td>
<td style="border: none;text-align: end;">'.$shippingTicket.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


                            $output .= '
      <tr class="Maintaince">
        <td>    '.trans('admin.Maintaince').'   </td>
      <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#MaintainceDet" onclick="DetailsMaintaince()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Maintaince">
      <td>    '.trans('admin.Total_Maintaince').'</td>
<td style="border: none;text-align: end;">'.$Maintaince.'</td>
<td style="border: none;text-align: end;"></td>

   </tr>
     ';


         $Ward= $ReciptTot + $SafySales + $TransferTotTo + $ImportCheck + $Setllement3agz + $WaslAmana + $SalesPetrol + $shippingTicket + $Maintaince ;
                     $output .= '
   <tr class="TotWard">
     <td>      '.trans('admin.Total_Incom').' </td>
<td style="border: none;text-align: end;">'.$Ward.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

                          $output .= '
      <tr class="Payment">
         <td>  '.trans('admin.Payment_Vouchers').'</td>
          <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#PaymentDet" onclick="DetailsPayment()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';



             $output .= '
   <tr class="TotalPayment">
  <td>   '.trans('admin.Total_Payment_Vouchers').' </td>
<td style="border: none;text-align: end;">'.$PaymentTot.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

             $output .= '
      <tr class="Purch">
          <td>'.trans('admin.Purchases').'</td>
     <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#PurchDet" onclick="DetailsPurch()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


        $RPCash =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
             ->where('Payment_Method', 'Cash')
          ->get()->sum('Total_Return_Value');

                $RPLater =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
             ->where('Payment_Method', 'Later')
          ->get()->sum('Pay');


         $AllP=$TotPurch + $RPCash + $RPLater;
             $output .= '
   <tr class="TotalPurch">
   <td>     '.trans('admin.Total_Purchases').' </td>
<td style="border: none;text-align: end;">'.$AllP.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


               $output .= '
      <tr class="RPurch">
            <td> '.trans('admin.Return_Purchases').'</td>
     <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RPurchDet" onclick="DetailsRPurch()">'.trans("admin.Details").'</button> </td>
          <td></td>
    </tr>
        ';


       $RPTotPurch=  $RPCash + $RPLater ;


             $output .= '
   <tr class="RTotalPurch">
  <td>      '.trans('admin.Total_Return_Purchases').' </td>
<td style="border: none;text-align: end;">'.$RPTotPurch.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



           $Safy= $AllP - $RPTotPurch ;
                     $output .= '
   <tr class="NetSales">
   <td>     '.trans('admin.Net_Purchases').' </td>
<td style="border: none;text-align: end;">'.$Safy.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

           $output .= '
      <tr class="Payment">
            <td> '.trans('admin.Safes_Transfer').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#TransferFromDet" onclick="DetailsTransferFrom()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';






             $output .= '
   <tr class="TotalPayment">
    <td>   '.trans('admin.Total_Safes_Transfer').'</td>
<td style="border: none;text-align: end;">'.$TransferTotFrom.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


        $output .= '
      <tr class="ExportCheck">
        <td>   '.trans('admin.Exporting_Checks').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ExportCheckDet" onclick="DetailsExportCheck()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="ExportCheck">
     <td>   '.trans('admin.Total_Exporting_Checks').'</td>
<td style="border: none;text-align: end;">'.$ExportCheck.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



        $output .= '
      <tr class="SetllementZyada">
                   <td>   '.trans('admin.Increment_Settlement').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SetllementZyadaDet" onclick="DetailsSetllementZyada()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="SetllementZyada">
    <td>   '.trans('admin.Total_Increment_Settlement').'</td>
<td style="border: none;text-align: end;">'.$SetllementZyada.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



            $output .= '
      <tr class="RMaintaince">
         <td> '.trans('admin.Return_Maintaince').'  </td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#RMaintainceDet" onclick="DetailsRMaintaince()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="RMaintaince">
     <td>   '.trans('admin.Total_Return_Maintaince').'</td>
<td style="border: none;text-align: end;">'.$RMaintaince.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



               $output .= '
      <tr class="Salary">
           <td>   '.trans('admin.Salaries').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SalaryDet" onclick="DetailsSalary()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Salary">
   <td> '.trans('admin.Total_Salaries').'</td>
<td style="border: none;text-align: end;">'.$Salary.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                    $output .= '
      <tr class="Borrow">
             <td>   '.trans('admin.Borrows').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#BorrowDet" onclick="DetailsBorrow()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Borrow">
      <td>  '.trans('admin.Total_Borrows').'</td>
<td style="border: none;text-align: end;">'.$Borrow.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


                    $output .= '
      <tr class="Loan">
             <td>   '.trans('admin.Loans').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#LoanDet" onclick="DetailsLoan()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Loan">
   <td> '.trans('admin.Total_Loans').'</td>
<td style="border: none;text-align: end;">'.$Loan.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';



                    $output .= '
      <tr class="Exchange">
        <td>   '.trans('admin.Exchanges').'</td>
    <td> <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ExchangeDet" onclick="DetailsExchange()">'.trans("admin.Details").'</button> </td>
          <td></td>

    </tr>
        ';


             $output .= '
   <tr class="Exchange">
    <td>   '.trans('admin.Total_Exchanges').'</td>
<td style="border: none;text-align: end;">'.$Exchange.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

              $Sadr= $Safy + $PaymentTot + $TransferTotFrom + $ExportCheck + $SetllementZyada+ $RMaintaince+ $Salary+ $Borrow+ $Loan+$Exchange;
                     $output .= '
   <tr class="TotSadr">
     <td>     '.trans('admin.Total_Export').' </td>
<td style="border: none;text-align: end;">'.$Sadr.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


        $MOshtryat=$AllP - $RPTotPurch ;


     $AM=   $Ward - $Sadr ;

                      $output .= '
   <tr class="TotalSafe">
   <td>    '.trans('admin.total_daily_transactions_in_safe').'   </td>
<td style="border: none;text-align: end;">'.$AM.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';

         $debt=GeneralDaily::where('Account',$safe)->get()->sum('Debitor');
           $crdt=GeneralDaily::where('Account',$safe)->get()->sum('Creditor');
            $dif=$debt - $crdt ;
                            $output .= '
   <tr class="SafeF3ly">
    <td>    '.trans('admin.actual_balance_in_safe').' </td>
<td style="border: none;text-align: end;">'.$dif.'</td>
<td style="border: none;text-align: end;"></td>
   </tr>
     ';


      }
      else
      {
       $output = '
       <tr>
        <td align="center" colspan="5">No Data Found</td>
       </tr>
       ';
      }


      $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);
     }

      public function DailyClosingDetailsFilterPrint(){

      $from = request('from');
      $to = request('to');
      $safe = request('Safe');

             $RCash=0;
             $RCashh=0;
        $RLater=0;
        $RLaterr=0;
               $RLaterr=0;
       $RPCashh=0;
$RPLaterr=0;
        $RPCash=0;
$RPLater=0;


                   $Purchases =Purchases::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','!=','Check')
         ->whereBetween('Date', [$from, $to])
          ->get();

           $PurchCash =Purchases::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Price');


            $PurchLater =Purchases::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Later')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');


                $ReturnPurch =ReturnPurch::orderBy('id','asc')
         ->whereBetween('Date', [$from, $to])
          ->get();

           $Sales =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','!=','Check')
         ->whereBetween('Date', [$from, $to])
          ->get();

              $ReturnSales =ReturnSales::orderBy('id','asc')
         ->whereBetween('Date', [$from, $to])
          ->get();


            $Cash =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Price');


            $Later =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Later')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');

            $CashVisa =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash_Visa')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Price');


          $Installment =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Installment')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('presenter');

        $TotSales=  $Cash + $Later +  $CashVisa+ $Installment;
             $TotPurch=  $PurchCash + $PurchLater;
                  $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get();

                      $ReciptTot =ReciptVoucher::orderBy('id','asc')
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Creditor');


                       $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get();

                      $PaymentTot =PaymentVoucher::orderBy('id','asc')
         ->where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Total_Debaitor');


$DifRP= $ReciptTot - $PaymentTot ;
         $Amount = $DifRP +   $TotSales ;



        $Discooo =Sales::orderBy('id','asc')
         ->where('Safe',$safe)
         ->where('Payment_Method','Cash')
         ->whereBetween('Date', [$from, $to])
          ->get()->sum('Pay');

      $Disc=$Cash - $Discooo ;


         return view('admin.Reports.FilterDailyClosingForm',[
             'RCash'=>$RCash,
             'RCashh'=>$RCashh,
             'RLater'=>$RLater,
             'RLaterr'=>$RLaterr,
             'Sales'=>$Sales,
             'ReturnSales'=>$ReturnSales,
             'Cash'=>$Cash,
             'Later'=>$Later,
             'CashVisa'=>$CashVisa,
             'Installment'=>$Installment,
             'TotSales'=>$TotSales,
             'ReciptVoucher'=>$ReciptVoucher,
             'ReciptTot'=>$ReciptTot,
             'PaymentVoucher'=>$PaymentVoucher,
             'PaymentTot'=>$PaymentTot,
             'DifRP'=>$DifRP,
             'Amount'=>$Amount,
             'Discooo'=>$Discooo,
             'Disc'=>$Disc,
             'RPCashh'=>$RPCashh,
             'RPLaterr'=>$RPLaterr,
             'RPCash'=>$RPCash,
             'RPLater'=>$RPLater,
             'Purchases'=>$Purchases,
             'PurchCash'=>$PurchCash,
             'PurchLater'=>$PurchLater,
             'ReturnPurch'=>$ReturnPurch,
             'TotPurch'=>$TotPurch,
             'safe'=>$safe,

         ]);
    }

          function FilterSalesDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
        $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){



             $Sales =Sales::whereBetween('Date', [$from, $to])
         ->where('Edit',0)
         ->where('Delete',0)
         ->where('Safe',$safe)
                  ->when(!empty($payment), function ($query) use ($payment) {
        return $query->whereIn('Payment_Method', $payment);
    })
         ->where('Payment_Method','!=','Check')
          ->get();

          foreach($Sales as $sal){
             $details=ProductSales::where('Sales',$sal->id)->get();
            if($sal->Payment_Method == 'Cash'){

                $bill=($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount;

            }elseif($sal->Payment_Method == 'Later'){

             $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

            }elseif($sal->Payment_Method == 'Cash_Visa'){
                $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount);

            }elseif($sal->Payment_Method == 'Installment'){
               $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;
            }elseif($sal->Payment_Method == 'Cash_Collection'){

             $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

            }elseif($sal->Payment_Method == 'Delivery'){

             $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

            }elseif($sal->Payment_Method == 'InstallmentCompanies'){

             $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

            }


       if(app()->getLocale() == 'ar' ){
                      $xName=$sal->Client()->first()->Name;

                   }else{
                         $xName=$sal->Client()->first()->NameEn;

                   }

                     $output .= '
      <tr class="Sales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>
                                                    <td>



                                                    </td>




    </tr>
      <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Product_Code').'</th>
     <th>'.trans('admin.Product_Name').'</th>
             <th>'.trans('admin.Unit').'</th>

  <th>'.trans('admin.Qty').'</th>
      <th>'.trans('admin.Price').'</th>
        <th>'.trans('admin.Discount').'</th>

    <th>'.trans('admin.Tax').'</th>
      <th>'.trans('admin.Total').'</th>
            <th>'.trans('admin.Group').'</th>


                                                            </tr>

                                                        <tbody> ';

                           foreach($details as $detail){

                   if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniName=$detail->Unit()->first()->Name;
                      $StoName=$detail->Product()->first()->Group()->first()->Name;

                   }else{
                         $ProoName=$detail->Product()->first()->P_En_Name;
                        $UniName=$detail->Unit()->first()->NameEn;
                      $StoName=$detail->Product()->first()->Group()->first()->NameEn;

                   }

                                   $output .= '
                                   <tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$UniName.'</td>

 <td>'.$detail->Qty.'</td>
  <td>'.$detail->Price.'</td>
  <td>'.$detail->Discount.'</td>

  <td>'.$detail->Total_Tax.'</td>
 <td>'.$detail->Total.'</td>
     <td>
                                       '.$StoName.'
                                    </td>

        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';

         }





             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

       function FilterRSalesDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

                       $ReturnSales =ReturnSales::where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
                     ->when(!empty($payment), function ($query) use ($payment) {
        return $query->whereIn('Payment_Method', $payment);
    })
          ->get();

    $RCash=0;
$RLater=0;

      foreach($ReturnSales as $sal){
             $details=ReturnSalesProducts::where('Return',$sal->id)->get();
                 if($sal->Sales()->first()->Safe == $safe){
            if($sal->Payment_Method == 'Cash'){

                $bill=$sal->Total_Return_Value;
                $RCash +=$sal->Total_Return_Value;
            }elseif($sal->Payment_Method == 'Later'){

                 $bill=$sal->Pay;
                $RLater +=$sal->Pay;
            }


                  if($sal->Pay !=  null){

                      if(app()->getLocale() == 'ar' ){
                      $ProoName=$sal->Product()->first()->P_Ar_Name;
                      $UniName=$sal->Unit()->first()->Name;
                      $StoName=$sal->Product()->first()->Group()->first()->Name;

                   }else{
                         $ProoName=$sal->Product()->first()->P_En_Name;
                        $UniName=$sal->Unit()->first()->NameEn;
                      $StoName=$sal->Product()->first()->Group()->first()->NameEn;

                   }

                             if(app()->getLocale() == 'ar' ){
                      $xName=$sal->Sales()->first()->Client()->first()->Name;

                   }else{
                         $xName=$sal->Sales()->first()->Client()->first()->NameEn;

                   }
                     $output .= '
      <tr class="RSales">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>
                                                                  <td>




                                                    </td>
    </tr>

    <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Product_Code').'</th>
     <th>'.trans('admin.Product_Name').'</th>
             <th>'.trans('admin.Unit').'</th>
         <th>'.trans('admin.Return_Qty').'</th>
  <th>'.trans('admin.Qty').'</th>
      <th>'.trans('admin.Price').'</th>
        <th>'.trans('admin.Discount').'</th>
    <th>'.trans('admin.Total_BF_Tax').'</th>
    <th>'.trans('admin.Tax').'</th>
      <th>'.trans('admin.Total').'</th>
            <th>'.trans('admin.Group').'</th>
        <th>'.trans('admin.Exp_Date').'</th>
        <th>'.trans('admin.Store').'</th>

                                                            </tr>

                                                        <tbody> ';

                           foreach($details as $detail){


                            if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniName=$detail->Unit()->first()->Name;
                      $GropName=$detail->Product()->first()->Group()->first()->Name;
                      $StoName=$detail->Store()->first()->Name;

                   }else{
                         $ProoName=$detail->Product()->first()->P_En_Name;
                        $UniName=$detail->Unit()->first()->NameEn;
                      $GropName=$detail->Product()->first()->Group()->first()->NameEn;
                      $StoName=$detail->Store()->first()->NameEn;

                   }

                                   $output .= '
<tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$UniName.'</td>
 <td>'.$detail->Recived_Qty.'</td>
 <td>'.$detail->Qty.'</td>
  <td>'.$detail->Price.'</td>
  <td>'.$detail->Discount.'</td>
  <td>'.$detail->Total_Bf_Tax.'</td>
  <td>'.$detail->Total_Tax.'</td>
 <td>'.$detail->Total.'</td>
     <td>
                                       '.$GropName.'
                                    </td>

               <td>'.$detail->Exp_Date.'</td>
        <td>'.$StoName.'</td>

        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>
        ';

         }
         }
         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

   function FilterPurchasesDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

            $Purchases =Purchases::orderBy('id','asc')
                ->where('Edit',0)
                ->where('Delete',0)
         ->where('Safe',$safe)
                 ->when(!empty($payment), function ($query) use ($payment) {
        return $query->whereIn('Payment_Method', $payment);
    })
         ->where('Payment_Method','!=','Check')
         ->whereBetween('Date', [$from, $to])
          ->get();



         foreach($Purchases as $purch){
           $details=ProductsPurchases::where('Purchase',$purch->id)->get();
            if($purch->Payment_Method == 'Cash'){

                $bill=($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount;
            }elseif($purch->Payment_Method == 'Later'){

                 $bill=(($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount) - $purch->Pay;
            }
                  if($purch->Pay !=  null){

                             if(app()->getLocale() == 'ar' ){
                      $xName=$purch->Vendor()->first()->Name;

                   }else{
                         $xName=$purch->Vendor()->first()->NameEn;

                   }
                     $output .= '
      <tr class="Purch">
                                                  <td>'.$purch->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>
                                                                  <td>




                                                    </td>

    </tr>
       <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Product_Code').'</th>
     <th>'.trans('admin.Product_Name').'</th>
             <th>'.trans('admin.Unit').'</th>
  <th>'.trans('admin.Qty').'</th>
      <th>'.trans('admin.Price').'</th>
        <th>'.trans('admin.Discount').'</th>

    <th>'.trans('admin.Tax').'</th>
      <th>'.trans('admin.Total').'</th>
            <th>'.trans('admin.Group').'</th>



                                                            </tr>

                                                        <tbody> ';

                           foreach($details as $detail){

                                                if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniName=$detail->Unit()->first()->Name;
                      $GropName=$detail->Product()->first()->Group()->first()->Name;


                   }else{
                         $ProoName=$detail->Product()->first()->P_En_Name;
                        $UniName=$detail->Unit()->first()->NameEn;
                      $GropName=$detail->Product()->first()->Group()->first()->NameEn;


                   }

                                   $output .= '
                                   <tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$UniName.'</td>
 <td>'.$detail->Qty.'</td>
  <td>'.$detail->Price.'</td>
  <td>'.$detail->Discount.'</td>

  <td>'.$detail->Total_Tax.'</td>
 <td>'.$detail->Total.'</td>
     <td>
                                       '.$GropName.'
                                    </td>


        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>
        ';

         }
         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

       function FilterRPurchasesDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){


                    $ReturnPurch =ReturnPurch::where('Safe',$safe)
         ->whereBetween('Date', [$from, $to])
                                     ->when(!empty($payment), function ($query) use ($payment) {
        return $query->whereIn('Payment_Method', $payment);
    })
          ->get();

    $RPCash=0;
$RPLater=0;



             foreach($ReturnPurch as $sal){
                 $details=ReturnPurchProducts::where('Return',$sal->id)->get();
                 if($sal->Purchase()->first()->Safe == $safe){
            if($sal->Payment_Method == 'Cash'){

                $bill=$sal->Total_Return_Value;
                $RPCash +=$sal->Total_Return_Value;
            }elseif($sal->Payment_Method == 'Later'){

                 $bill=$sal->Pay;
                $RPLater +=$sal->Pay;
            }

                  if($sal->Pay !=  null){
                       if(app()->getLocale() == 'ar' ){
                      $xName=$sal->Purchase()->first()->Vendor()->first()->Name;

                   }else{
                         $xName=$sal->Purchase()->first()->Vendor()->first()->NameEn;

                   }
                     $output .= '
      <tr class="RPurch">
                                                  <td>'.$sal->Code.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$bill.'</td>
                                                                            <td>


                                                    </td>

    </tr>
     <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Product_Code').'</th>
     <th>'.trans('admin.Product_Name').'</th>
             <th>'.trans('admin.Unit').'</th>
  <th>'.trans('admin.Return_Qty').'</th>
      <th>'.trans('admin.Price').'</th>
        <th>'.trans('admin.Discount').'</th>
    <th>'.trans('admin.Total_BF_Tax').'</th>
    <th>'.trans('admin.Tax').'</th>
      <th>'.trans('admin.Total').'</th>
            <th>'.trans('admin.Group').'</th>
 <th>'.trans('admin.Exp_Date').'</th>
        <th>'.trans('admin.Store').'</th>


                                                            </tr>

                                                        <tbody> ';

                           foreach($details as $detail){


                                                               if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniName=$detail->Unit()->first()->Name;
                      $GropName=$detail->Product()->first()->Group()->first()->Name;
                      $StoName=$detail->Store()->first()->Name;

                   }else{
                         $ProoName=$detail->Product()->first()->P_En_Name;
                        $UniName=$detail->Unit()->first()->NameEn;
                      $GropName=$detail->Product()->first()->Group()->first()->NameEn;
                      $StoName=$detail->Store()->first()->NameEn;


                   }

                                   $output .= '
                        <tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$UniName.'</td>
 <td>'.$detail->Return_Qty.'</td>
  <td>'.$detail->Price.'</td>
  <td>'.$detail->Discount.'</td>
  <td>'.$detail->Total_Bf_Tax.'</td>
  <td>'.$detail->Total_Tax.'</td>
 <td>'.$detail->Total.'</td>
     <td>
                                       '.$GropName.'
                                    </td>

               <td>'.$detail->Exp_Date.'</td>
        <td>'.$StoName.'</td>
        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>
        ';

         }
         }
         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }


      function FilterSettlement3agzDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

                   $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','تسوية بالعجز')
          ->get();


          foreach($Setllement3agz as $sal){

              $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
               $Pros=ProductSettlement::where('Set_ID',$det->id)->get();

                     if(app()->getLocale() == 'ar' ){
                      $xName=$det->Account_Dificit()->first()->Name;

                   }else{
                         $xName=$det->Account_Dificit()->first()->NameEn;

                   }

                     $output .= '
      <tr class="Settlement3agz">
                                                  <td>'.$sal->Code_Type.'</td>
                                                    <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>

      <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Name').'</th>
     <th>'.trans('admin.P_Code').'</th>
             <th>'.trans('admin.Qty').'</th>

  <th>'.trans('admin.Price').'</th>
      <th>'.trans('admin.Unit').'</th>
        <th>'.trans('admin.Inventory').'</th>

    <th>'.trans('admin.Dificit').'</th>
      <th>'.trans('admin.Execess').'</th>



                                                            </tr>

                                                        <tbody> ';

                           foreach($Pros as $detail){

                                                             if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniName=$detail->Unit()->first()->Name;


                   }else{
                         $ProoName=$detail->Product()->first()->P_En_Name;
                        $UniName=$detail->Unit()->first()->NameEn;


                            }

                                   $output .= '
                                   <tr>
   <td>'.$ProoName.'</td>
   <td>
                            '.$detail->P_Code.'


                                    </td>
    <td>'.$detail->Av_Qty.'</td>

 <td>'.$detail->Price.'</td>
  <td>'.$UniName.'</td>
  <td>'.$detail->Inventory.'</td>

  <td>'.$detail->Deficit.'</td>
 <td>'.$detail->Excess.'</td>


        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';






         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

      function FilterPetrolDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

                $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
         ->where('Safe',$safe)
          ->get();


          foreach($SalesPetrol as $sal){

                     if(app()->getLocale() == 'ar' ){
                      $xName=$sal->Safe()->first()->Name;

                   }else{
                         $xName=$sal->Safe()->first()->NameEn;

                   }
                     $output .= '
      <tr class="SalesPetrol">
                                                  <td>'.$sal->Code.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Total.'</td>

    </tr>



        ';

         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

      function FilterShippingDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

      $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','البوليصه')
          ->get();



          foreach($shippingTicket as $sal){
     $det=Ticket::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
               $Prods=TicketProducts::where('Ticket',$det->id)->get();

                     if(app()->getLocale() == 'ar' ){
                      $xName=$det->Sender_Name()->first()->Name;

                   }else{
                         $xName=$det->Sender_Name()->first()->NameEn;

                   }

                     $output .= '
      <tr class="shippingTicket">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>

<tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Code').'</th>
     <th>'.trans('admin.Name').'</th>
             <th>'.trans('admin.Price').'</th>

  <th>'.trans('admin.Weight').'</th>
      <th>'.trans('admin.Length').'</th>
        <th>'.trans('admin.Width').'</th>

    <th>'.trans('admin.Height').'</th>
      <th>'.trans('admin.Qty').'</th>
            <th>'.trans('admin.Unit').'</th>
            <th>'.trans('admin.Total').'</th>


                                                            </tr>

                                                        <tbody> ';

                           foreach($Prods as $detail){

                           if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->P_Ar_Name;
                      $UniiName=$detail->Unit()->first()->Name;

                   }else{
                                        $ProoName=$detail->P_En_Name;
                      $UniiName=$detail->Unit()->first()->NameEn;

                   }

                                   $output .= '
                                   <tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$detail->Price.'</td>

 <td>'.$detail->Weight.'</td>
  <td>'.$detail->Length.'</td>
  <td>'.$detail->Width.'</td>

  <td>'.$detail->Height.'</td>
 <td>'.$detail->Qty.'</td>
 <td>'.$UniiName.'</td>
 <td>'.$detail->Total.'</td>


        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';

         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

      function FilterMaintainceDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

                $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
         ->where('Account',$safe)
         ->where('Type','الصيانة')
          ->get();


          foreach($Maintaince as $sal){
          $det=ReciptMaintaince::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
               $products=ProductMaintaincBill::where('Maintaince',$det->id)->get();



                     if(app()->getLocale() == 'ar' ){
                      $xName=$det->Account()->first()->Name;

                   }else{
                         $xName=$det->Account()->first()->NameEn;

                   }




                     $output .= '
      <tr class="Maintaince">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Debitor_Coin.'</td>

    </tr>

     <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Code').'</th>
     <th>'.trans('admin.Name').'</th>
             <th>'.trans('admin.Qty').'</th>

  <th>'.trans('admin.Price').'</th>
      <th>'.trans('admin.Total').'</th>
        <th>'.trans('admin.Store').'</th>



                                                            </tr>

                                                        <tbody> ';

                           foreach($products as $detail){


                           if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->P_Ar_Name;
                      $UniiName=$detail->Store()->first()->Name;

                   }else{
                                        $ProoName=$detail->P_En_Name;
                      $UniiName=$detail->Store()->first()->NameEn;

                   }

                                   $output .= '
                                   <tr>
   <td>'.$detail->Product_Code.'</td>
   <td>
                            '.$ProoName.'


                                    </td>
    <td>'.$detail->Qty.'</td>

 <td>'.$detail->Qty.'</td>
  <td>'.$detail->Price.'</td>
  <td>'.$detail->Total.'</td>

  <td>'.$UniiName.'</td>







        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';

         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

       function FilterSettlementZyadaDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

                   $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])

         ->where('Account',$safe)
         ->where('Type','تسوية بالزيادة')
          ->get();


          foreach($SetllementZyada as $sal){
          $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $Pros=ProductSettlement::where('Set_ID',$det->id)->get();


                     if(app()->getLocale() == 'ar' ){
                      $xName=$det->Account_Excess()->first()->Name;

                   }else{
                         $xName=$det->Account_Excess()->first()->NameEn;

                   }

                     $output .= '
      <tr class="SetllementZyada">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>
       <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Name').'</th>
     <th>'.trans('admin.P_Code').'</th>
             <th>'.trans('admin.Qty').'</th>

  <th>'.trans('admin.Price').'</th>
      <th>'.trans('admin.Unit').'</th>
        <th>'.trans('admin.Inventory').'</th>

    <th>'.trans('admin.Dificit').'</th>
      <th>'.trans('admin.Execess').'</th>



                                                            </tr>

                                                        <tbody> ';

                           foreach($Pros as $detail){

                                   if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->Product()->first()->P_Ar_Name;
                      $UniiName=$detail->Unit()->first()->Name;

                   }else{
                      $ProoName=$detail->Product()->first()->P_En_Name;
                      $UniiName=$detail->Unit()->first()->NameEn;

                   }

                                   $output .= '
                                   <tr>
   <td>'.$ProoName.'</td>
   <td>
                            '.$detail->P_Code.'


                                    </td>
    <td>'.$detail->Av_Qty.'</td>

 <td>'.$detail->Price.'</td>
  <td>'.$UniiName.'</td>
  <td>'.$detail->Inventory.'</td>

  <td>'.$detail->Deficit.'</td>
 <td>'.$detail->Excess.'</td>


        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';


         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }

       function FilterRMaintainceDailyClosingDetails(Request $request){

    if($request->ajax())
     {
     $output = '';
      $from = $request->get('from');
      $to = $request->get('to');
      $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');
        if( $from != '' and $to != '' and $safe != ''){

               $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
         ->where('Account',$safe)
         ->where('Type','مرتجع الصيانة')
          ->get();


          foreach($RMaintaince as $sal){
          $det=ReturnMaintainceBill::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
               $products=ProductsReturnMaintainceBill::where('Return',$det->id)->get();


                     if(app()->getLocale() == 'ar' ){
                      $xName=$det->Account()->first()->Name;

                   }else{
                         $xName=$det->Account()->first()->NameEn;

                   }

                     $output .= '
      <tr class="RMaintaince">
                                                  <td>'.$sal->Code_Type.'</td>
                                         <td>'.$xName.'</td>
                                                    <td>'.$sal->Creditor_Coin.'</td>

    </tr>

       <tr>
                              <td colspan="23">

                                       <table class="">

                                                            <tr>
                                                     <th>'.trans('admin.Code').'</th>
     <th>'.trans('admin.Name').'</th>
             <th>'.trans('admin.Return_Qty').'</th>

  <th>'.trans('admin.Price').'</th>
      <th>'.trans('admin.Total').'</th>
        <th>'.trans('admin.Store').'</th>


                                                            </tr>

                                                        <tbody> ';

                           foreach($products as $detail){


                                                   if(app()->getLocale() == 'ar' ){
                      $ProoName=$detail->P_Ar_Name;
                      $UniiName=$detail->Store()->first()->Name;

                   }else{
                      $ProoName=$detail->P_En_Name;
                      $UniiName=$detail->Store()->first()->NameEn;

                   }

                                   $output .= '
                                   <tr>


 <td>'.$detail->Product_Code.'</td>
  <td>'.$ProoName.'</td>
  <td>'.$detail->Recived_Qty.'</td>

  <td>'.$detail->Price.'</td>
 <td>'.$detail->Total.'</td>
 <td>'.$UniiName.'</td>


        ';
                           }
                  $output .= '
                                                        </tbody>
                                                    </table>

                                   </td>
                           </tr>

        ';
         }



             }
             $data = array(
       'table_data'  => $output,

      );
      echo json_encode($data);

        }

    }



    //SalesProsMoreDetails
      public function SalesProsMoreDetails(){

          $Stores=Stores::type()->get();
          $Executors = Employess::type()->lazy();
          $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
          $Employess = Employess::type()->lazy();
          $Groups=ItemsGroups::all();

         return view('admin.Reports.SalesProsMoreDetails',get_defined_vars());
    }

      public function SalesProsMoreDetailsFilter(Request $request){

          $Stores=Stores::type()->get();
          $Executors = Employess::type()->lazy();
          $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
          $Employess = Employess::type()->lazy();
          $Groups=ItemsGroups::all();


          $From = $request->get('From');
      $To = $request->get('To');
      $Client = $request->get('Client');
      $Store = $request->get('Store');
      $Delegate = $request->get('Delegate');
      $Executor = $request->get('Executor');
      $Group = $request->get('Group');

        $Products=Products::

            when(!empty($Group), function ($query) use ($Group) {
        return $query->where('Group', $Group);
    })

        ->paginate(100);

        $output = '';
          if($request->ajax())
     {
      $From = $request->get('From');
      $To = $request->get('To');
      $Client = $request->get('Client');
      $Store = $request->get('Store');
      $Delegate = $request->get('Delegate');
      $Executor = $request->get('Executor');
      $Group = $request->get('Group');

             foreach($Products as $pro){

                 $Code=ProductUnits::where('Product',$pro->id)->where('Def',1)->first();


                 $SalesTotal=ProductSales::where('Product',$pro->id)->whereBetween('Date',[$From,$To])

                             ->when(!empty($Client), function ($query) use ($Client) {
        return $query->whereRelation('Sales','Client', $Client);
    })

                         ->when(!empty($Store), function ($query) use ($Store) {
        return $query->whereRelation('Sales','Store', $Store);
    })

                                 ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->whereRelation('Sales','Delegate', $Delegate);
    })


                             ->when(!empty($Executor), function ($query) use ($Executor) {
        return $query->whereRelation('Sales','Executor', $Executor);
    })

                     ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Total_Net');

                 $SalesQty=ProductSales::where('Product',$pro->id)->whereBetween('Date',[$From,$To])
                     ->when(!empty($Client), function ($query) use ($Client) {
                         return $query->whereRelation('Sales','Client', $Client);
                     })

                     ->when(!empty($Store), function ($query) use ($Store) {
                         return $query->whereRelation('Sales','Store', $Store);
                     })

                     ->when(!empty($Delegate), function ($query) use ($Delegate) {
                         return $query->whereRelation('Sales','Delegate', $Delegate);
                     })


                     ->when(!empty($Executor), function ($query) use ($Executor) {
                         return $query->whereRelation('Sales','Executor', $Executor);
                     })

                     ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Qty');
                if($SalesQty != 0){

                    if($pro->P_Type == 'Serial'){
                        $ProsQty=ProductsQty::where('Product',$pro->id)
             ->when(!empty($Store), function ($query) use ($Store) {
        return $query->where('Store', $Store);
    })
                            ->distinct(['P_Code'])->get();


                   if(app()->getLocale() == 'ar' ){
                      $xName=$pro->P_Ar_Name;

                   }else{
                         $xName=$pro->P_En_Name;

                   }

              $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                  <tr style="background:pink">
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';

                foreach($ProsQty as $qq){

               $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                   ->when(!empty($Client), function ($query) use ($Client) {
                       return $query->whereRelation('Sales','Client', $Client);
                   })

                   ->when(!empty($Store), function ($query) use ($Store) {
                       return $query->whereRelation('Sales','Store', $Store);
                   })

                   ->when(!empty($Delegate), function ($query) use ($Delegate) {
                       return $query->whereRelation('Sales','Delegate', $Delegate);
                   })


                   ->when(!empty($Executor), function ($query) use ($Executor) {
                       return $query->whereRelation('Sales','Executor', $Executor);
                   })

                   ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)

                     ->get()->sum('Total_Net');

                 $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                     ->when(!empty($Client), function ($query) use ($Client) {
                         return $query->whereRelation('Sales','Client', $Client);
                     })

                     ->when(!empty($Store), function ($query) use ($Store) {
                         return $query->whereRelation('Sales','Store', $Store);
                     })

                     ->when(!empty($Delegate), function ($query) use ($Delegate) {
                         return $query->whereRelation('Sales','Delegate', $Delegate);
                     })


                     ->when(!empty($Executor), function ($query) use ($Executor) {
                         return $query->whereRelation('Sales','Executor', $Executor);
                     })

                     ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Qty');

             if($QtySer != 0){

                          if(app()->getLocale() == 'ar' ){
                      $xName=$qq->Store()->first()->Name;

                   }else{
                         $xName=$qq->Store()->first()->NameEn;

                   }

          $output .= '

            <tr style="background:lightgray">
            <td>'.$qq->P_Code.'</td>
            <td>'.$xName.'</td>
            <td class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                }
                }
              $output .= '
              </td>


              </tr>';

                    }elseif($pro->P_Type == 'Single_Variable'){

                          $ProsQty=ProductsQty::where('Product',$pro->id)
             ->when(!empty($Store), function ($query) use ($Store) {
        return $query->where('Store', $Store);
    })
                            ->distinct(['P_Code'])->get();


                if(app()->getLocale() == 'ar' ){
                      $xName=$pro->P_Ar_Name;

                   }else{
                         $xName=$pro->P_En_Name;

                   }

              $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                       <tr style="background:pink">
          <th>'.trans('admin.Virable').'</th>
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';
                foreach($ProsQty as $qq){

               $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                   ->when(!empty($Client), function ($query) use ($Client) {
                       return $query->whereRelation('Sales','Client', $Client);
                   })

                   ->when(!empty($Store), function ($query) use ($Store) {
                       return $query->whereRelation('Sales','Store', $Store);
                   })

                   ->when(!empty($Delegate), function ($query) use ($Delegate) {
                       return $query->whereRelation('Sales','Delegate', $Delegate);
                   })


                   ->when(!empty($Executor), function ($query) use ($Executor) {
                       return $query->whereRelation('Sales','Executor', $Executor);
                   })

                   ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Total_Net');

                 $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                     ->when(!empty($Client), function ($query) use ($Client) {
                         return $query->whereRelation('Sales','Client', $Client);
                     })

                     ->when(!empty($Store), function ($query) use ($Store) {
                         return $query->whereRelation('Sales','Store', $Store);
                     })

                     ->when(!empty($Delegate), function ($query) use ($Delegate) {
                         return $query->whereRelation('Sales','Delegate', $Delegate);
                     })


                     ->when(!empty($Executor), function ($query) use ($Executor) {
                         return $query->whereRelation('Sales','Executor', $Executor);
                     })

                     ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Qty');

             if($QtySer != 0){

                         if(app()->getLocale() == 'ar' ){
                      $VName=$qq->V1()->first()->Name;
                      $StName=$qq->Store()->first()->Name;

                   }else{
                              $VName=$qq->V1()->first()->NameEn;
                      $StName=$qq->Store()->first()->NameEn;


                   }

          $output .= '

            <tr style="background:lightgray">
            <td>'.$VName.'</td>
            <td>'.$qq->P_Code.'</td>
            <td>'.$StName.'</td>
            <td class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                }
                }
              $output .= '
              </td>


              </tr>';

                    }elseif($pro->P_Type == 'Duble_Variable'){

                                 $ProsQty=ProductsQty::where('Product',$pro->id)
             ->when(!empty($Store), function ($query) use ($Store) {
        return $query->where('Store', $Store);
    })
                            ->distinct(['P_Code'])->get();

              $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$pro->P_Ar_Name.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                  <tr style="background:pink">
          <th>'.trans('admin.Virable').'</th>
       <th>'.trans('admin.Virable').'</th>
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';
                foreach($ProsQty as $qq){

               $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                   ->when(!empty($Client), function ($query) use ($Client) {
                       return $query->whereRelation('Sales','Client', $Client);
                   })

                   ->when(!empty($Store), function ($query) use ($Store) {
                       return $query->whereRelation('Sales','Store', $Store);
                   })

                   ->when(!empty($Delegate), function ($query) use ($Delegate) {
                       return $query->whereRelation('Sales','Delegate', $Delegate);
                   })


                   ->when(!empty($Executor), function ($query) use ($Executor) {
                       return $query->whereRelation('Sales','Executor', $Executor);
                   })

                   ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)

                     ->get()->sum('Total_Net');

                 $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                     ->when(!empty($Client), function ($query) use ($Client) {
                         return $query->whereRelation('Sales','Client', $Client);
                     })

                     ->when(!empty($Store), function ($query) use ($Store) {
                         return $query->whereRelation('Sales','Store', $Store);
                     })

                     ->when(!empty($Delegate), function ($query) use ($Delegate) {
                         return $query->whereRelation('Sales','Delegate', $Delegate);
                     })


                     ->when(!empty($Executor), function ($query) use ($Executor) {
                         return $query->whereRelation('Sales','Executor', $Executor);
                     })

                     ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                     ->get()->sum('Qty');

             if($QtySer != 0){

                                 if(app()->getLocale() == 'ar' ){
                      $VName=$qq->V1()->first()->Name;
                      $VVName=$qq->V2()->first()->Name;
                      $StName=$qq->Store()->first()->Name;

                   }else{
                              $VName=$qq->V1()->first()->NameEn;
                              $VVName=$qq->V2()->first()->NameEn;
                      $StName=$qq->Store()->first()->NameEn;


                   }

          $output .= '

            <tr style="background:lightgray">
            <td>'.$VName.'</td>
            <td>'.$VVName.'</td>
            <td>'.$qq->P_Code.'</td>
            <td>'.$StName.'</td>
            <td  class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                }
                }
              $output .= '
              </td>


              </tr>';

                    }else{

                   if(app()->getLocale() == 'ar' ){
                      $xName=$pro->P_Ar_Name;

                   }else{
                         $xName=$pro->P_En_Name;

                   }
                        $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td></td>


              </tr>';


                    }

                }
             }



   return   $output ;
          }



         return view('admin.Reports.SalesProsMoreDetailsFilter',get_defined_vars());
    }

    //SalesProsBrandsMoreDetails
    public function SalesProsBrandsMoreDetails(){

        $Stores=Stores::type()->get();
        $Executors = Employess::type()->lazy();
        $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
        $Employess = Employess::type()->lazy();
        $Brands=Brands::all();

        return view('admin.Reports.SalesProsBrandsMoreDetails',get_defined_vars());
    }

    public function SalesProsBrandsMoreDetailsFilter(Request $request){

        $Stores=Stores::type()->get();
        $Executors = Employess::type()->lazy();
        $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
        $Employess = Employess::type()->lazy();
        $Brands=Brands::all();


        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Store = $request->get('Store');
        $Delegate = $request->get('Delegate');
        $Executor = $request->get('Executor');
        $Brand = $request->get('Brand');

        $Products=Products::

        when(!empty($Brand), function ($query) use ($Brand) {
            return $query->where('Brand', $Brand);
        })

            ->paginate(100);

        $output = '';
        if($request->ajax())
        {
            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Client');
            $Store = $request->get('Store');
            $Delegate = $request->get('Delegate');
            $Executor = $request->get('Executor');
            $Brand = $request->get('Brand');

            foreach($Products as $pro){

                $Code=ProductUnits::where('Product',$pro->id)->where('Def',1)->first();


                $SalesTotal=ProductSales::where('Product',$pro->id)->whereBetween('Date',[$From,$To])

                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Client', $Client);
                    })

                    ->when(!empty($Store), function ($query) use ($Store) {
                        return $query->whereRelation('Sales','Store', $Store);
                    })

                    ->when(!empty($Delegate), function ($query) use ($Delegate) {
                        return $query->whereRelation('Sales','Delegate', $Delegate);
                    })


                    ->when(!empty($Executor), function ($query) use ($Executor) {
                        return $query->whereRelation('Sales','Executor', $Executor);
                    })

                    ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                    ->get()->sum('Total_Net');

                $SalesQty=ProductSales::where('Product',$pro->id)->whereBetween('Date',[$From,$To])
                    ->when(!empty($Client), function ($query) use ($Client) {
                        return $query->whereRelation('Sales','Client', $Client);
                    })

                    ->when(!empty($Store), function ($query) use ($Store) {
                        return $query->whereRelation('Sales','Store', $Store);
                    })

                    ->when(!empty($Delegate), function ($query) use ($Delegate) {
                        return $query->whereRelation('Sales','Delegate', $Delegate);
                    })


                    ->when(!empty($Executor), function ($query) use ($Executor) {
                        return $query->whereRelation('Sales','Executor', $Executor);
                    })

                    ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                    ->get()->sum('Qty');
                if($SalesQty != 0){

                    if($pro->P_Type == 'Serial'){
                        $ProsQty=ProductsQty::where('Product',$pro->id)
                            ->when(!empty($Store), function ($query) use ($Store) {
                                return $query->where('Store', $Store);
                            })
                            ->distinct(['P_Code'])->get();


                        if(app()->getLocale() == 'ar' ){
                            $xName=$pro->P_Ar_Name;

                        }else{
                            $xName=$pro->P_En_Name;

                        }

                        $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                  <tr style="background:pink">
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';

                        foreach($ProsQty as $qq){

                            $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)

                                ->get()->sum('Total_Net');

                            $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                                ->get()->sum('Qty');

                            if($QtySer != 0){

                                if(app()->getLocale() == 'ar' ){
                                    $xName=$qq->Store()->first()->Name;

                                }else{
                                    $xName=$qq->Store()->first()->NameEn;

                                }

                                $output .= '

            <tr style="background:lightgray">
            <td>'.$qq->P_Code.'</td>
            <td>'.$xName.'</td>
            <td class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                            }
                        }
                        $output .= '
              </td>


              </tr>';

                    }elseif($pro->P_Type == 'Single_Variable'){

                        $ProsQty=ProductsQty::where('Product',$pro->id)
                            ->when(!empty($Store), function ($query) use ($Store) {
                                return $query->where('Store', $Store);
                            })
                            ->distinct(['P_Code'])->get();


                        if(app()->getLocale() == 'ar' ){
                            $xName=$pro->P_Ar_Name;

                        }else{
                            $xName=$pro->P_En_Name;

                        }

                        $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                       <tr style="background:pink">
          <th>'.trans('admin.Virable').'</th>
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';
                        foreach($ProsQty as $qq){

                            $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                                ->get()->sum('Total_Net');

                            $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                                ->get()->sum('Qty');

                            if($QtySer != 0){

                                if(app()->getLocale() == 'ar' ){
                                    $VName=$qq->V1()->first()->Name;
                                    $StName=$qq->Store()->first()->Name;

                                }else{
                                    $VName=$qq->V1()->first()->NameEn;
                                    $StName=$qq->Store()->first()->NameEn;


                                }

                                $output .= '

            <tr style="background:lightgray">
            <td>'.$VName.'</td>
            <td>'.$qq->P_Code.'</td>
            <td>'.$StName.'</td>
            <td class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                            }
                        }
                        $output .= '
              </td>


              </tr>';

                    }elseif($pro->P_Type == 'Duble_Variable'){

                        $ProsQty=ProductsQty::where('Product',$pro->id)
                            ->when(!empty($Store), function ($query) use ($Store) {
                                return $query->where('Store', $Store);
                            })
                            ->distinct(['P_Code'])->get();

                        $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$pro->P_Ar_Name.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td>
                  <tr style="background:pink">
          <th>'.trans('admin.Virable').'</th>
       <th>'.trans('admin.Virable').'</th>
          <th>'.trans('admin.Code').'</th>
          <th>'.trans('admin.Store').'</th>
          <th> '.trans('admin.Total_Qty').'</th>
          <th>'.trans('admin.Total').'</th>
          </tr>
              ';
                        foreach($ProsQty as $qq){

                            $TotSer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])

                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)

                                ->get()->sum('Total_Net');

                            $QtySer=ProductSales::where('Product',$qq->Product)->where('Product_Code',$qq->P_Code)->whereBetween('Date',[$From,$To])
                                ->when(!empty($Client), function ($query) use ($Client) {
                                    return $query->whereRelation('Sales','Client', $Client);
                                })

                                ->when(!empty($Store), function ($query) use ($Store) {
                                    return $query->whereRelation('Sales','Store', $Store);
                                })

                                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                                    return $query->whereRelation('Sales','Delegate', $Delegate);
                                })


                                ->when(!empty($Executor), function ($query) use ($Executor) {
                                    return $query->whereRelation('Sales','Executor', $Executor);
                                })

                                ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
                                ->get()->sum('Qty');

                            if($QtySer != 0){

                                if(app()->getLocale() == 'ar' ){
                                    $VName=$qq->V1()->first()->Name;
                                    $VVName=$qq->V2()->first()->Name;
                                    $StName=$qq->Store()->first()->Name;

                                }else{
                                    $VName=$qq->V1()->first()->NameEn;
                                    $VVName=$qq->V2()->first()->NameEn;
                                    $StName=$qq->Store()->first()->NameEn;


                                }

                                $output .= '

            <tr style="background:lightgray">
            <td>'.$VName.'</td>
            <td>'.$VVName.'</td>
            <td>'.$qq->P_Code.'</td>
            <td>'.$StName.'</td>
            <td  class="totQty">'.$QtySer.'</td>
            <td class="tot">'.$TotSer.'</td>
            <tr>
            ';


                            }
                        }
                        $output .= '
              </td>


              </tr>';

                    }else{

                        if(app()->getLocale() == 'ar' ){
                            $xName=$pro->P_Ar_Name;

                        }else{
                            $xName=$pro->P_En_Name;

                        }
                        $output .= '<tr>

              <td>'.$Code->Barcode.'</td>
              <td>'.$xName.'</td>
              <td>'.$Code->Price.'</td>
              <td>'.$SalesQty.'</td>
              <td>'.$SalesTotal.'</td>
              <td></td>


              </tr>';


                    }

                }
            }



            return   $output ;
        }



        return view('admin.Reports.SalesProsBrandsMoreDetailsFilter',get_defined_vars());
    }


//StagnantItemsTwo
      public function StagnantItemsTwo(){
          $ItemsGroups=ItemsGroups::all();
          $Stores=Stores::type()->get();

         return view('admin.Reports.StagnantItemsTwo',get_defined_vars());
    }
 public function StagnantItemsTwoFilter(Request $request){
          $ItemsGroups=ItemsGroups::all();
     $Stores=Stores::type()->get();

             $group = $request->get('group');
      $Store = $request->get('Store');
      $From = $request->get('From');
      $To = $request->get('To');
      $Max = $request->get('Max');
      $search = $request->get('search');


  $Prods=ProductsQty::

              when(!empty($Store), function ($query) use ($Store) {
        return $query->whereIn('Store',$Store);

                })


                                 ->when(!empty($group), function ($query) use ($group) {
        return $query->where('Group', $group);
    })

         ->when(!empty($search), function ($query) use ($search) {
        return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                           ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                           ->orWhere('V_Name','ILIKE', "%{$search}%")
                           ->orWhere('VV_Name','ILIKE', "%{$search}%")
                           ->orWhere('P_Code','ILIKE', "%{$search}%")
                           ->orWhere('PP_Code','ILIKE', "%{$search}%")
                           ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                           ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

            ;

                })



          ->distinct(['Product'])->paginate(10);



         $ProdsCount=0;




                      $output = '';
          if($request->ajax())
     {

     $group = $request->get('group');
      $Store = $request->get('Store');
      $From = $request->get('From');
      $To = $request->get('To');
      $Max = $request->get('Max');
      $search = $request->get('search');


           foreach($Prods as $rows){

                $Qty=ProductsQty::where('Product',$rows->Product)

              ->when(!empty($Store), function ($query) use ($Store) {
        return $query->whereIn('Store',$Store);

                })

          ->get()->sum('Qty');

            $units=ProductUnits::where('Product',$rows->Product)->get();
            $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();


         $count=ProductSales::
             where('Product',$rows->Product)
                ->where('Product_Code',$rows->P_Code)
                 ->whereBetween('Date', [$From,$To])
                 ->count();

          if($count  <= $Max){
      if($group != ''){

      if($rows->Product()->first()->Group == $group){
          $ProdsCount+=1;


    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

            if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;


                   }




        $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);

                     if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


       <td>
       '.$count.'
       </td>


        </tr>
            ';


        }elseif($rows->Product()->first()->P_Type == 'Serial'){



                   if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;


                   }



         $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);
                         if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


      <td>
       '.$count.'
       </td>


        </tr>
            ';

        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){


                   if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;
                                     $PrrroVName=$rows->V1()->first()->Name;



                   }else{
                         $PrrroName=$rows->P_En_Name;
                                     $PrrroVName=$rows->V1()->first()->NameEn;



                   }



      $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">     '.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


          <td>
       '.$count.'
       </td>


        </tr>
            ';


        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                       if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;
                                     $PrrroVName=$rows->V1()->first()->Name;
           $PrrroVVName=$rows->V2()->first()->Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;
                                     $PrrroVName=$rows->V1()->first()->NameEn;
           $PrrroVVName=$rows->V2()->first()->NameEn;


                   }



      $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);



            if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


        <td>
       '.$count.'
       </td>


        </tr>
            ';
        }




      }

      }else{

       if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

            if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;


                   }




        $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);

                     if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


       <td>
       '.$count.'
       </td>


        </tr>
            ';


        }elseif($rows->Product()->first()->P_Type == 'Serial'){



                   if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;


                   }



         $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">'.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);
                         if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


      <td>
       '.$count.'
       </td>


        </tr>
            ';

        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){


                   if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;
                                     $PrrroVName=$rows->V1()->first()->Name;



                   }else{
                         $PrrroName=$rows->P_En_Name;
                                     $PrrroVName=$rows->V1()->first()->NameEn;



                   }



      $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">     '.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


          <td>
       '.$count.'
       </td>


        </tr>
            ';


        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                       if(app()->getLocale() == 'ar' ){
                      $PrrroName=$rows->P_Ar_Name;
                                     $PrrroVName=$rows->V1()->first()->Name;
           $PrrroVVName=$rows->V2()->first()->Name;


                   }else{
                         $PrrroName=$rows->P_En_Name;
                                     $PrrroVName=$rows->V1()->first()->NameEn;
           $PrrroVVName=$rows->V2()->first()->NameEn;


                   }



      $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  disabled>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')">
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

            foreach($units as $uni){
                $nam=Measuerments::find($uni->Unit);



            if(app()->getLocale() == 'ar' ){
                       $UnitNamme=$nam->Name;
                   }else{

                       $UnitNamme=$nam->NameEn;
                   }
                  $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                        }

                $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Qty.'"  disabled>
       </td>


        <td>
       '.$count.'
       </td>


        </tr>
            ';
        }




      }

          }

         }

     return   $output ;
          }


         return view('admin.Reports.StagnantItemsTwoFilter',get_defined_vars());
    }


    //SalesCustomersGroups
     public function SalesCustomersGroups(){
          $ItemsGroups=ItemsGroups::all();
         $CustomersGroup=CustomersGroup::all();
         $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();

         return view('admin.Reports.SalesCustomersGroups',get_defined_vars());
    }

      public function SalesCustomersGroupsFilter(Request $request){

          $From=request('From');
$To=request('To');
$group=request('group');
$Client=request('Client');

                $request->session()->put([
        'From'=>$From
        ,'To'=>$To
        ,'group'=>$group
        ,'Client'=>$Client


    ]);
        return     redirect('SalesCustomersGroupsFilterNeww');


    }


         public function SalesCustomersGroupsFilterNeww(){


                          $From=session()->get('From');
                   $To=session()->get('To');
                   $group=session()->get('group');
              $Client=session()->get('Client');



                   $ItemsGroups=ItemsGroups::all();
         $CustomersGroup=CustomersGroup::all();

 $Clients = AcccountingManual::
             where('Type',1)
              ->where('Parent',24)
              ->get();



          $G=ItemsGroups::find($group);

        $Customers=Customers::
                  when(!empty($Client), function ($query) use ($Client) {
        return $query->whereIn('Account',$Client);

                })

            ->paginate(100);


    $Customers->appends(request()->query());

         return view('admin.Reports.SalesCustomersGroupsFilter',get_defined_vars());



    }



    //Customer_Debts
          public function Customer_Debts(){
              $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
              $Employess = Employess::type()->lazy();
              $Stores=Stores::type()->get();
              $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
              $Branches=Branches::all();

         return view('admin.Reports.Customer_Debts',get_defined_vars());
    }
       public function Customer_DebtsFilterTwo(Request $request){

       $from = $request->get('from');
      $to = $request->get('to');
      $Store = $request->get('Store');
      $Client = $request->get('Client');
      $Delegate = $request->get('Delegate');
      $Safe = $request->get('Safe');
      $Branch = $request->get('Branch');
      $code = $request->get('code');



    $items =Sales::where('Status',1)
        ->where('Payment_Method','Later')
        ->where('Later_Collection',0)
           ->whereBetween('Date', [$from, $to])

                ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code',$code);

                })

        ->when(!empty($Safe), function ($query) use ($Safe) {
        return $query->where('Safe',$Safe);

                })

        ->when(!empty($Client), function ($query) use ($Client) {
        return $query->where('Client',$Client);

                })

        ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->where('Delegate',$Delegate);

                })

        ->when(!empty($Store), function ($query) use ($Store) {
        return $query->where('Store',$Store);

                })


        ->when(!empty($Branch), function ($query) use ($Branch) {
        return $query->where('Branch',$Branch);

                })


        ->where('Edit',0)
        ->where('Delete',0)
          ->paginate(50);



      $output = '';
          if($request->ajax())
     {
       $from = $request->get('from');
      $to = $request->get('to');
      $Store = $request->get('Store');
      $Client = $request->get('Client');
      $Delegate = $request->get('Delegate');
      $Safe = $request->get('Safe');
      $Branch = $request->get('Branch');
      $code = $request->get('code');

       foreach($items as $row)
       {


      if(!empty($row->Delegate()->first()->Name)){
             if(app()->getLocale() == 'ar' ){
          $dele=$row->Delegate()->first()->Name;
             }else{
          $dele=$row->Delegate()->first()->NameEn;
             }
      }else{

        $dele='';
      }
$TotReturn=ReturnSales::where('Sales',$row->id)->get()->sum('Total_Return_Value');


      $TotReciptVoucher=ReciptVoucherDetails::where('Bill_Num',$row->Code)->get()->sum('Creditor');

$fdate = $row->Date;
$tdate = date('Y-m-d');
$datetime1 = new DateTime($fdate);
$datetime2 = new DateTime($tdate);
$interval = $datetime1->diff($datetime2);
$DifDays = $interval->format('%a');


     if(app()->getLocale() == 'ar' ){
                      $StName=$row->Store()->first()->Name;
                      $SafeName=$row->Safe()->first()->Name;
                      $CliName=$row->Client()->first()->Name;


                   }else{
                         $StName=$row->Store()->first()->NameEn;
                      $SafeName=$row->Safe()->first()->NameEn;
                      $CliName=$row->Client()->first()->NameEn;

                   }

$cust=Customers::where('Account',$row->Client)->first();

        $output .= '
        <tr>

                                                    <td>'.$row->Date.'</td>
                                                    <td>'.$row->Code.'</td>
                                                    <td>'.$row->Later_Due.'</td>
                                                    <td>'.$StName.'</td>
                                                    <td>'.$SafeName.'</td>
                                                    <td>'.$CliName.'</td>
                                                    <td>'.$cust->Repayment_Period.'</td>
                                                    <td>'.$dele.'</td>
                                                      <td>'.$row->Total_Net.'</td>
                                                        <td>'.$row->Pay.'</td>
                                                        <td>'.$row->Total_Net - $row->Pay.'</td>
                                                        <td>'.$TotReturn.'</td>
                                                        <td>'.$TotReciptVoucher.'</td>
                                                        <td>'.$row->Total_Net - $TotReciptVoucher.'</td>
                                                        <td>'.$DifDays.'</td>


                                                </tr>

        ';

       }

    return   $output ;
          }

         return view('admin.Reports.Customer_DebtsFilterTwo',get_defined_vars());
    }

    //Vendor_Debts
  public function Vendor_Debts(){

      $Vendors = AcccountingManual::where('Type',1)->accountpurchtype()->lazy();
      $Employess = Employess::type()->lazy();
      $Stores=Stores::type()->get();
      $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
      $Branches=Branches::all();

         return view('admin.Reports.Vendor_Debts',get_defined_vars());
    }
       public function Vendor_DebtsFilterTwo(Request $request){

       $from = $request->get('from');
      $to = $request->get('to');
      $Store = $request->get('Store');
      $Vendor = $request->get('Vendor');
      $Delegate = $request->get('Delegate');
      $Safe = $request->get('Safe');
      $Branch = $request->get('Branch');
      $code = $request->get('code');



    $items =Purchases::where('Status',1)
        ->where('Payment_Method','Later')
           ->whereBetween('Date', [$from, $to])

                ->when(!empty($code), function ($query) use ($code) {
        return $query->where('Code',$code);

                })

        ->when(!empty($Safe), function ($query) use ($Safe) {
        return $query->where('Safe',$Safe);

                })

        ->when(!empty($Vendor), function ($query) use ($Vendor) {
        return $query->where('Vendor',$Vendor);

                })

        ->when(!empty($Delegate), function ($query) use ($Delegate) {
        return $query->where('Delegate',$Delegate);

                })

        ->when(!empty($Store), function ($query) use ($Store) {
        return $query->where('Store',$Store);

                })


        ->when(!empty($Branch), function ($query) use ($Branch) {
        return $query->where('Branch',$Branch);

                })


->where('Edit',0)
->where('Delete',0)
          ->paginate(50);



      $output = '';
          if($request->ajax())
     {
       $from = $request->get('from');
      $to = $request->get('to');
      $Store = $request->get('Store');
    $Vendor = $request->get('Vendor');
      $Delegate = $request->get('Delegate');
      $Safe = $request->get('Safe');
      $Branch = $request->get('Branch');
      $code = $request->get('code');

       foreach($items as $row)
       {


      if(!empty($row->Delegate()->first()->Name)){

             if(app()->getLocale() == 'ar' ){
          $dele=$row->Delegate()->first()->Name;
             }else{
                  $dele=$row->Delegate()->first()->NameEn;
             }
      }else{

        $dele='';
      }
$TotReturn=ReturnPurch::where('Purchase',$row->id)->get()->sum('Total_Return_Value');


             if(app()->getLocale() == 'ar' ){
                      $StName=$row->Store()->first()->Name;
                      $SafeName=$row->Safe()->first()->Name;
                      $CliName=$row->Vendor()->first()->Name;


                   }else{
                         $StName=$row->Store()->first()->NameEn;
                      $SafeName=$row->Safe()->first()->NameEn;
                      $CliName=$row->Vendor()->first()->NameEn;

                   }


           $TotPayVoucher=PaymentVoucherDetails::where('Bill_Num',$row->Code)->get()->sum('Debitor');



        $output .= '
        <tr>

                                                    <td>'.$row->Date.'</td>
                                                    <td>'.$row->Code.'</td>
                                                    <td>'.$row->Later_Due.'</td>
                                                    <td>'.$StName.'</td>
                                                    <td>'.$SafeName.'</td>
                                                    <td>'.$CliName.'</td>
                                                    <td>'.$dele.'</td>
                                                      <td>'.$row->Total_Net.'</td>
                                                        <td>'.$row->Pay.'</td>
                                                        <td>'.$row->Total_Net - $row->Pay.'</td>
                                                        <td>'.$TotReturn.'</td>
                                                         <td>'.$TotPayVoucher.'</td>
                                                        <td>'.$row->Total_Net - $TotPayVoucher.'</td>

                                                </tr>

        ';

       }

    return   $output ;
          }

         return view('admin.Reports.Vendor_DebtsFilterTwo',get_defined_vars());
    }



    //EditDeleteBillReport
    public function EditDeleteBillReport(){

        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess = Employess::type()->delegate()->get();
        $Accounts = AcccountingManual::where('Type',1)->whereIn('Parent',[37,24])->get();
        $Users = Admin::all();
        return view('admin.Reports.EditDeleteBillReport',get_defined_vars());
    }
    public function EditDeleteBillReportFilter(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $Store = $request->get('Store');
        $Account = $request->get('Account');
        $Delegate = $request->get('Delegate');
        $Safe = $request->get('Safe');
        $Coin = $request->get('Coin');
        $User = $request->get('User');
        $Type = $request->get('Type');
        $sort = $request->get('sort');



if($Type == 2) {

    $items = Purchases::where('Status', 1)


        ->whereBetween('Date', [$from, $to])
        ->when(!empty($Safe), function ($query) use ($Safe) {
            return $query->where('Safe', $Safe);

        })
        ->when(!empty($Account), function ($query) use ($Account) {
            return $query->where('Vendor', $Account);

        })
        ->when(!empty($Coin), function ($query) use ($Coin) {
            return $query->where('Coin', $Coin);

        })
        ->when(!empty($User), function ($query) use ($User) {
            return $query->where('User', $User);

        })
        ->when(!empty($Delegate), function ($query) use ($Delegate) {
            return $query->where('Delegate', $Delegate);

        })
        ->when(!empty($Store), function ($query) use ($Store) {
            return $query->where('Store', $Store);

        })
        ->where($sort,'1')


        ->paginate(50);
}else{


    $items = Sales::where('Status', 1)

        ->where($sort,'1')


        ->whereBetween('Date', [$from, $to])
        ->when(!empty($Safe), function ($query) use ($Safe) {
            return $query->where('Safe', $Safe);

        })
        ->when(!empty($Account), function ($query) use ($Account) {
            return $query->where('Client', $Account);

        })
        ->when(!empty($Coin), function ($query) use ($Coin) {
            return $query->where('Coin', $Coin);

        })
        ->when(!empty($User), function ($query) use ($User) {
            return $query->where('User', $User);

        })
        ->when(!empty($Delegate), function ($query) use ($Delegate) {
            return $query->where('Delegate', $Delegate);

        })
        ->when(!empty($Store), function ($query) use ($Store) {
            return $query->where('Store', $Store);

        })



        ->paginate(50);


}


        $output = '';
        if($request->ajax())
        {
            $from = $request->get('from');
            $to = $request->get('to');
            $Store = $request->get('Store');
            $Account = $request->get('Account');
            $Delegate = $request->get('Delegate');
            $Safe = $request->get('Safe');
            $Coin = $request->get('Coin');
            $User = $request->get('User');
            $Type = $request->get('Type');
            $sort = $request->get('sort');

            foreach($items as $row)
            {


                if(!empty($row->Delegate()->first()->Name)){

                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{
                        $dele=$row->Delegate()->first()->NameEn;
                    }
                }else{

                    $dele='';
                }



                if(app()->getLocale() == 'ar' ){
                    $StName=$row->Store()->first()->Name;
                    $SafeName=$row->Safe()->first()->Name;
                    $User=$row->User()->first()->name;

                    if($Type == 1){
                        $CliName = $row->Client()->first()->Name;
                    }else {
                        $CliName = $row->Vendor()->first()->Name;
                    }

                }else{
                    $StName=$row->Store()->first()->NameEn;
                    $SafeName=$row->Safe()->first()->NameEn;
                    if($Type == 1){
                        $CliName = $row->Client()->first()->NameEn;
                    }else {
                        $CliName = $row->Vendor()->first()->NameEn;
                    }

                    $User=$row->User()->first()->nameEn;

                }

                $output .= '
        <tr>

                                                    <td>'.$row->Date.'</td>
                                                    <td>'.$row->Code.'</td>
                                                    <td>'.$StName.'</td>
                                                    <td>'.$SafeName.'</td>
                                                    <td>'.$CliName.'</td>
                                                    <td>'.$dele.'</td>
                                                      <td>'.$row->Total_Net.'</td>
                                                      <td>'.$User.'</td>
                                                </tr>

        ';

            }

            return   $output ;
        }

        return view('admin.Reports.EditDeleteBillReportFilter',get_defined_vars());
    }


//HoldQtiesReport
        public function HoldQtiesReport(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();
        return view('admin.Reports.HoldQtiesReport',get_defined_vars());
    }


    public function HoldQtiesReportFilter(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');

        $Prods=ProductsQty::where('Hold_Qty','!=',0)

            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                    ;
            })

            ->paginate(10);

        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');


            foreach($Prods as $rows){

                $units=ProductUnits::where('Product',$rows->Product)->get();
                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();





                $def=StoresDefaultData::orderBy('id','desc')->first();
                if($def->Cost_Price == 2){


                    $totCost=0;





                    $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();



                    $fifo=$this->FifoAvQtyDate($store,$rows->Product,$rr->Barcode);

                    if(!empty($fifo)){

                        if($fifo->Qty == 0){



                            $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            if($NNQuntatity == 0){


                                $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                            }else{



                                if($NNQuntatity >= $rows->Qty){

                                    $totCost += $fifo->Cost_Price * $rows->Qty ;

                                }else{

                                    $res=$rows->Qty - $NNQuntatity ;


                                    $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                    $totCost +=$ResdiualCost;

                                }


                            }



                        }else{


                            if($fifo->Qty >= $rows->Qty){

                                $totCost += $fifo->Cost_Price * $rows->Qty ;

                            }else{

                                $res=$rows->Qty - $fifo->Qty ;


                                $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                $totCost +=$ResdiualCost;

                            }



                        }


                    }



                    $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);




                }else{






                    $Average=$average->AverageCostGetUnit($rows->Product,$rr->Barcode,$store,$rr->Unit);


                    $SMallAverage=$Average;






                }





                if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial'){



                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;


                    }



                    $output .= '

       <tr>

       <td>
      <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStartt('.$rows->id.')" disabled>
                <option value="">   '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Hold_Qty / $rr->Rate.'"  readonly>
       </td>




        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Serial'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;


                    }

                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.'
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')" disabled>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Hold_Qty.'"  readonly>
       </td>




        </tr>
            ';

                }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $PrrroVName=$rows->V1()->first()->Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $PrrroVName=$rows->V1()->first()->NameEn;


                    }

                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')" disabled>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Hold_Qty.'"  readonly>
       </td>



        </tr>
            ';


                }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){




                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $PrrroVName=$rows->V1()->first()->Name;
                        $PrrroVVName=$rows->V2()->first()->Name;


                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $PrrroVName=$rows->V1()->first()->NameEn;
                        $PrrroVVName=$rows->V2()->first()->NameEn;


                    }


                    $output .= '

       <tr>

       <td>
     <input type="text" id="CodeStart'.$rows->id.'" class="form-control" value="'.$rows->P_Code.'"  readonly>
      <input type="hidden" id="Product'.$rows->id.'"  value="'.$rows->Product.'" >
       </td>

        <td>
        '.$PrrroName.' ('.$PrrroVName.')  ('.$PrrroVVName.')
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart'.$rows->id.'" onchange="UnitCodeStart('.$rows->id.')" disabled>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

                    foreach($units as $uni){
                        $nam=Measuerments::find($uni->Unit);
                        if(app()->getLocale() == 'ar' ){
                            $UnitNamme=$nam->Name;
                        }else{

                            $UnitNamme=$nam->NameEn;
                        }
                        $output .= '
            <option value="'.$uni->Unit.'"       ';  if($uni->Def == 1){    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';
                    }

                    $output .= '

                        </select>
        </td>


         <td>
      <input type="text" id="Qty'.$rows->id.'" class="form-control Qun" value="'.$rows->Hold_Qty.'"  readonly>
       </td>




        </tr>
            ';
                }



            }



            return   $output ;
        }
        return view('admin.Reports.HoldQtiesReportFilter',get_defined_vars());
    }




//StoresQtiesReport
    public function StoresQtiesReport(Request $request){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();


        return view('admin.Reports.StoresQtiesReport',get_defined_vars());
    }

    public function StoresQtiesReportFilter(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Zero = $request->get('Zero');
        $GroupSingle = $request->get('GroupSingle');

        if($Zero == 0){

            $Prods=ProductsQty::orderBy('Group','asc')->

            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })

                ->paginate(100);

            if($group != ''){ $ProdsCount=0;}else{
                $ProdsCount=0;

            }

        }else{

            $Prods=ProductsQty::orderBy('Group','asc')->where('Qty','!=',0)

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store', $store);
                })

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })

                ->paginate(100);


            if($group != ''){ $ProdsCount=0;}else{
                $ProdsCount=0;

            }


        }



        if($Zero == 0){
            $Products_Num=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })


                ->count();



            $Total_Qty=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })

                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })

                ->get()->sum('TotalCost');
        }else{

            $Products_Num=ProductsQty::where('Qty','!=',0)->
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })


                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)->
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })

                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::where('Qty','!=',0)->
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })




                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })

                ->get()->sum('TotalCost');


        }


        $output = '';
        if($request->ajax())
        {

            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $Zero = $request->get('Zero');

            foreach($Prods as $rows){


             if($rows->Store == $store) {
                 $units = ProductUnits::where('Product', $rows->Product)->get();
                 $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                 $plow = ProductUnits::where('Product', $rows->Product)->where('Rate', 1)->first();


                 $def = StoresDefaultData::orderBy('id', 'desc')->first();
                 if ($def->Cost_Price == 2) {

                     $AllFifoQty = FifoQty::
                     where('Store', $store)
                         ->where('Product', $rows->Product)
                         ->where('P_Code', $plow->Barcode)
                         ->get();


                     $CostShow = 'none';
                     $CostTwoShow = 'block';
                 } else {
                     $AllFifoQty = [];

                     $CostShow = 'block';
                     $CostTwoShow = 'none';

                 }

                 if ($def->Cost_Price == 2) {

                     $totCost = 0;

                     $rr = ProductUnits::where("Unit", $rr->Unit)->where('Product', $rows->Product)->first();

                     $fifo = FifoQty::orderBy('id', 'asc')
                         ->where('Store', $store)
                         ->where('Product', $rows->Product)
                         ->where('P_Code', $plow->Barcode)
                         ->where('Qty', '!=', 0)
                         ->first();


                     if (empty($fifo)) {

                         $fifo = FifoQty::orderBy('id', 'asc')
                             ->where('Store', $store)
                             ->where('Product', $rows->Product)
                             ->where('PP_Code', $plow->Barcode)
                             ->where('Qty', '!=', 0)
                             ->first();

                         if (empty($fifo)) {

                             $fifo = FifoQty::orderBy('id', 'asc')
                                 ->where('Store', $store)
                                 ->where('Product', $rows->Product)
                                 ->where('PPP_Code', $plow->Barcode)
                                 ->where('Qty', '!=', 0)
                                 ->first();


                             if (empty($fifo)) {

                                 $fifo = FifoQty::orderBy('id', 'asc')
                                     ->where('Store', $store)
                                     ->where('Product', $rows->Product)
                                     ->where('PPPP_Code', $plow->Barcode)
                                     ->where('Qty', '!=', 0)
                                     ->first();

                             }

                         }

                     }


                     if (!empty($fifo)) {

                         if ($fifo->Qty == 0) {


                             $NNQuntatity = $this->FindQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date);


                             if ($NNQuntatity == 0) {


                                 $NNQuntatity = $this->FindQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date);


                             } else {


                                 if ($NNQuntatity >= $rows->Qty) {

                                     $totCost += $fifo->Cost_Price * $rows->Qty;

                                 } else {

                                     $res = $rows->Qty - $NNQuntatity;


                                     $totCost += $fifo->Cost_Price * $NNQuntatity;

                                     $ResdiualCost = $this->MoreThanQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $res);

                                     $totCost += $ResdiualCost;

                                 }


                             }


                         } else {


                             if ($fifo->Qty >= $rows->Qty) {

                                 $totCost += $fifo->Cost_Price * $rows->Qty;

                             } else {

                                 $res = $rows->Qty - $fifo->Qty;


                                 $totCost += $fifo->Cost_Price * $fifo->Qty;

                                 $ResdiualCost = $this->MoreThanQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $res);

                                 $totCost += $ResdiualCost;

                             }


                         }


                     }

                     $Average = $average->AverageCostGetUnit($rows->Product, $rr->Barcode, $store, $rr->Unit);
                     $Cost = $totCost;
                     $SMallAverage = $Average;


                 } else {

                     $Average = $average->AverageCostGetUnit($rows->Product, $rr->Barcode, $store, $rr->Unit);
                     $Cost = $Average * $rows->Qty;
                     $SMallAverage = $Average;

                 }


                 if ($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial') {


                     if (app()->getLocale() == 'ar') {
                         $PrrroName = $rows->P_Ar_Name;


                     } else {
                         $PrrroName = $rows->P_En_Name;

                     }


                     $output .= '

       <tr>

       <td id="CodeStartText' . $rows->id . '">
       ' . $rr->Barcode . '
       </td>

        <td>
        ' . $PrrroName . '

             <input type="hidden" id="CodeStart' . $rows->id . '" class="form-control" value="' . $rr->Barcode . '"  readonly>
      <input type="hidden" id="Product' . $rows->id . '"  value="' . $rows->Product . '" >
            <input type="hidden" id="Qty' . $rows->id . '" class="form-control Qun" value="' . $rows->Qty / $rr->Rate . '"  readonly>

               <input type="hidden" id="TotCOST"  class="form-control Tot" value="' . $Cost * ($rows->Qty / $rr->Rate) . '"  readonly>
                <input type="hidden" id="COST' . $rows->id . '" readonly  class="form-control " value="' . number_format((float)abs($Cost), 2, '.', '') . '" >

       <input style="display:' . $CostShow . '" type="hidden" readonly id="AVG' . $rows->id . '" value="' . number_format((float)abs($Average), 2, '.', '') . '" >
<input style="display:' . $CostShow . '" type="hidden" disabled id="SMALLAVG' . $rows->id . '" value="' . number_format((float)abs($SMallAverage), 2, '.', '') . '" >
   <input type="hidden" id="TotpriceI"  class="form-control TotPrice" value="' . $rr->Price * ($rows->Qty / $rr->Rate) . '"  readonly>
   <input type="hidden" id="priceI' . $rows->id . '" class="form-control " value="' . $rr->Price . '"  readonly>
   <input type="hidden" id="priceII' . $rows->id . '" class="form-control" value="' . $rr->Price_Two . '"  readonly>
   <input type="hidden" id="priceIII' . $rows->id . '" class="form-control" value="' . $rr->Price_Three . '"  readonly>
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $rows->id . '" onchange="UnitCodeStartt(' . $rows->id . ')">
                <option value="">   ' . trans('admin.Choice_Unit') . ' </option>
              ';

                     foreach ($units as $uni) {
                         $nam = Measuerments::find($uni->Unit);


                         if (app()->getLocale() == 'ar') {
                             $UnitNamme = $nam->Name;
                         } else {

                             $UnitNamme = $nam->NameEn;
                         }
                         $output .= '
            <option value="' . $uni->Unit . '"       ';
                         if ($uni->Def == 1) {
                             $output .= '  selected  ';
                         }
                         $output .= ' > ' . $UnitNamme . '</option>
                 ';
                     }

                     $output .= '

                        </select>
        </td>


         <td id="QtyText' . $rows->id . '">

         ' . $rows->Qty / $rr->Rate . '
       </td>


<td style="display:' . $CostShow . '" id="AVGText' . $rows->id . '">

' . number_format((float)abs($Average), 2, '.', '') . '
</td>
       <td style="display:' . $CostTwoShow . '">



          <div class="row" style="display:' . $CostTwoShow . '">

           ';
                     foreach ($AllFifoQty as $fffff) {

                         $output .= '



             <div class="col-12">
  ' . trans("admin.Qty") . ' :-   ' . number_format((float)abs($fffff->Qty), 2, '.', '') . '    ' . trans("admin.Cost") . ' :-    ' . number_format((float)abs($fffff->Cost_Price), 2, '.', '') . '
             </div>



          ';


                     }


                     $output .= '

        </div>
       </td>


           <td id="COSTText' . $rows->id . '">
           ' . number_format((float)abs($Cost), 2, '.', '') . '

       </td>

           <td id="priceIText' . $rows->id . '">
           ' . $rr->Price . '

       </td>
           <td id="priceIIText' . $rows->id . '">
           ' . $rr->Price_Two . '

       </td>

           <td id="priceIIIText' . $rows->id . '">
           ' . $rr->Price_Three . '

       </td>

        </tr>
            ';


                 } elseif ($rows->Product()->first()->P_Type == 'Serial') {


                     if (app()->getLocale() == 'ar') {
                         $PrrroName = $rows->P_Ar_Name;


                     } else {
                         $PrrroName = $rows->P_En_Name;


                     }

                     $output .= '

       <tr>

       <td id="CodeStartText' . $rows->id . '">

       ' . $rows->P_Code . '

       </td>

        <td>
        ' . $PrrroName . '

             <input type="hidden" id="CodeStart' . $rows->id . '" class="form-control" value="' . $rows->P_Code . '"  readonly>
      <input type="hidden" id="Product' . $rows->id . '"  value="' . $rows->Product . '" >
            <input type="hidden" id="Qty' . $rows->id . '" class="form-control Qun" value="' . $rows->Qty . '"  readonly>
                   <input style="display:' . $CostShow . '" type="hidden" readonly id="AVG' . $rows->id . '" value="' . number_format((float)abs($Average), 2, '.', '') . '" >
<input style="display:' . $CostShow . '" type="hidden" disabled id="SMALLAVG' . $rows->id . '" value="' . number_format((float)abs($SMallAverage), 2, '.', '') . '" >

    <input type="hidden" id="TotCOST"  class="form-control Tot" value="' . $Cost * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="COST' . $rows->id . '" readonly  class="form-control" value="' . number_format((float)abs($Cost), 2, '.', '') . '" >

      <input type="hidden" id="TotpriceI"  class="form-control TotPrice" value="' . $rr->Price * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="priceI' . $rows->id . '" class="form-control " value="' . $rr->Price . '"  readonly>
   <input type="hidden" id="priceII' . $rows->id . '" class="form-control" value="' . $rr->Price_Two . '"  readonly>
   <input type="hidden" id="priceIII' . $rows->id . '" class="form-control" value="' . $rr->Price_Three . '"  readonly>
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $rows->id . '" onchange="UnitCodeStart(' . $rows->id . ')">
                <option value="">         ' . trans('admin.Choice_Unit') . '</option>
              ';

                     foreach ($units as $uni) {
                         $nam = Measuerments::find($uni->Unit);
                         if (app()->getLocale() == 'ar') {
                             $UnitNamme = $nam->Name;
                         } else {

                             $UnitNamme = $nam->NameEn;
                         }
                         $output .= '
            <option value="' . $uni->Unit . '"       ';
                         if ($uni->Def == 1) {
                             $output .= '  selected  ';
                         }
                         $output .= ' > ' . $UnitNamme . '</option>
                 ';
                     }

                     $output .= '

                        </select>
        </td>


         <td id="QtyText' . $rows->id . '">
         ' . $rows->Qty . '

       </td>


         <td style="display:' . $CostShow . '" id="AVGText' . $rows->id . '">

         ' . number_format((float)abs($Average), 2, '.', '') . '

</td>

<td style="display:' . $CostTwoShow . '">
          <div class="row" style="display:' . $CostTwoShow . '">

           ';
                     foreach ($AllFifoQty as $fffff) {

                         $output .= '



             <div class="col-12">
  ' . trans("admin.Qty") . ' :-   ' . number_format((float)abs($fffff->Qty), 2, '.', '') . '    ' . trans("admin.Cost") . ' :-    ' . number_format((float)abs($fffff->Cost_Price), 2, '.', '') . '
             </div>



          ';


                     }


                     $output .= '

        </div>
       </td>


           <td id="COSTText' . $rows->id . '">
           ' . number_format((float)abs($Cost), 2, '.', '') . '

       </td>

          <td id="priceIText' . $rows->id . '">
           ' . $rr->Price . '

       </td>
           <td id="priceIIText' . $rows->id . '">
           ' . $rr->Price_Two . '

       </td>

           <td id="priceIIIText' . $rows->id . '">
           ' . $rr->Price_Three . '

       </td>

        </tr>
            ';

                 } elseif ($rows->Product()->first()->P_Type == 'Single_Variable') {


                     if (app()->getLocale() == 'ar') {
                         $PrrroName = $rows->P_Ar_Name;
                         $PrrroVName = $rows->V1()->first()->Name;


                     } else {
                         $PrrroName = $rows->P_En_Name;
                         $PrrroVName = $rows->V1()->first()->NameEn;


                     }


                     $output .= '

       <tr>

       <td id="CodeStartText' . $rows->id . '">

       ' . $rows->P_Code . '

       </td>

        <td>
        ' . $PrrroName . '   (' . $PrrroVName . ')

             <input type="hidden" id="CodeStart' . $rows->id . '" class="form-control" value="' . $rows->P_Code . '"  readonly>
      <input type="hidden" id="Product' . $rows->id . '"  value="' . $rows->Product . '" >
            <input type="hidden" id="Qty' . $rows->id . '" class="form-control Qun" value="' . $rows->Qty . '"  readonly>
                   <input style="display:' . $CostShow . '" type="hidden" readonly id="AVG' . $rows->id . '" value="' . number_format((float)abs($Average), 2, '.', '') . '" >
<input style="display:' . $CostShow . '" type="hidden" disabled id="SMALLAVG' . $rows->id . '" value="' . number_format((float)abs($SMallAverage), 2, '.', '') . '" >

    <input type="hidden" id="TotCOST"  class="form-control Tot" value="' . $Cost * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="COST' . $rows->id . '" readonly  class="form-control " value="' . number_format((float)abs($Cost), 2, '.', '') . '" >

         <input type="hidden" id="TotpriceI"  class="form-control TotPrice" value="' . $rr->Price * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="priceI' . $rows->id . '" class="form-control" value="' . $rr->Price . '"  readonly>
   <input type="hidden" id="priceII' . $rows->id . '" class="form-control" value="' . $rr->Price_Two . '"  readonly>
   <input type="hidden" id="priceIII' . $rows->id . '" class="form-control" value="' . $rr->Price_Three . '"  readonly>
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $rows->id . '" onchange="UnitCodeStart(' . $rows->id . ')">
                <option value="">         ' . trans('admin.Choice_Unit') . '</option>
              ';

                     foreach ($units as $uni) {
                         $nam = Measuerments::find($uni->Unit);
                         if (app()->getLocale() == 'ar') {
                             $UnitNamme = $nam->Name;
                         } else {

                             $UnitNamme = $nam->NameEn;
                         }
                         $output .= '
            <option value="' . $uni->Unit . '"       ';
                         if ($uni->Def == 1) {
                             $output .= '  selected  ';
                         }
                         $output .= ' > ' . $UnitNamme . '</option>
                 ';
                     }

                     $output .= '

                        </select>
        </td>


         <td id="QtyText' . $rows->id . '">
         ' . $rows->Qty . '

       </td>


         <td style="display:' . $CostShow . '" id="AVGText' . $rows->id . '">

         ' . number_format((float)abs($Average), 2, '.', '') . '

</td>

<td style="display:' . $CostTwoShow . '">
          <div class="row" style="display:' . $CostTwoShow . '">

           ';
                     foreach ($AllFifoQty as $fffff) {

                         $output .= '



             <div class="col-12">
  ' . trans("admin.Qty") . ' :-   ' . number_format((float)abs($fffff->Qty), 2, '.', '') . '    ' . trans("admin.Cost") . ' :-    ' . number_format((float)abs($fffff->Cost_Price), 2, '.', '') . '
             </div>



          ';


                     }


                     $output .= '

        </div>
       </td>


           <td id="COSTText' . $rows->id . '">
           ' . number_format((float)abs($Cost), 2, '.', '') . '

       </td>

          <td id="priceIText' . $rows->id . '">
           ' . $rr->Price . '

       </td>
           <td id="priceIIText' . $rows->id . '">
           ' . $rr->Price_Two . '

       </td>

           <td id="priceIIIText' . $rows->id . '">
           ' . $rr->Price_Three . '

       </td>

        </tr>
            ';


                 } elseif ($rows->Product()->first()->P_Type == 'Duble_Variable') {


                     if (app()->getLocale() == 'ar') {
                         $PrrroName = $rows->P_Ar_Name;
                         $PrrroVName = $rows->V1()->first()->Name;
                         $PrrroVVName = $rows->V2()->first()->Name;


                     } else {
                         $PrrroName = $rows->P_En_Name;
                         $PrrroVName = $rows->V1()->first()->NameEn;
                         $PrrroVVName = $rows->V2()->first()->NameEn;


                     }


                     $output .= '

       <tr>

       <td id="CodeStartText' . $rows->id . '">

       ' . $rows->P_Code . '  (' . $PrrroVName . ')  (' . $PrrroVVName . ')

       </td>

        <td>
        ' . $PrrroName . '   (' . $PrrroVName . ')

             <input type="hidden" id="CodeStart' . $rows->id . '" class="form-control" value="' . $rows->P_Code . '"  readonly>
      <input type="hidden" id="Product' . $rows->id . '"  value="' . $rows->Product . '" >
            <input type="hidden" id="Qty' . $rows->id . '" class="form-control Qun" value="' . $rows->Qty . '"  readonly>
                   <input style="display:' . $CostShow . '" type="hidden" readonly id="AVG' . $rows->id . '" value="' . number_format((float)abs($Average), 2, '.', '') . '" >
<input style="display:' . $CostShow . '" type="hidden" disabled id="SMALLAVG' . $rows->id . '" value="' . number_format((float)abs($SMallAverage), 2, '.', '') . '" >

    <input type="hidden" id="TotCOST"  class="form-control Tot" value="' . $Cost * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="COST' . $rows->id . '" readonly  class="form-control" value="' . number_format((float)abs($Cost), 2, '.', '') . '" >

         <input type="hidden" id="TotpriceI"  class="form-control TotPrice" value="' . $rr->Price * ($rows->Qty / $rr->Rate) . '"  readonly>
      <input type="hidden" id="priceI' . $rows->id . '" class="form-control" value="' . $rr->Price . '"  readonly>
   <input type="hidden" id="priceII' . $rows->id . '" class="form-control" value="' . $rr->Price_Two . '"  readonly>
   <input type="hidden" id="priceIII' . $rows->id . '" class="form-control" value="' . $rr->Price_Three . '"  readonly>
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $rows->id . '" onchange="UnitCodeStart(' . $rows->id . ')">
                <option value="">         ' . trans('admin.Choice_Unit') . '</option>
              ';

                     foreach ($units as $uni) {
                         $nam = Measuerments::find($uni->Unit);
                         if (app()->getLocale() == 'ar') {
                             $UnitNamme = $nam->Name;
                         } else {

                             $UnitNamme = $nam->NameEn;
                         }
                         $output .= '
            <option value="' . $uni->Unit . '"       ';
                         if ($uni->Def == 1) {
                             $output .= '  selected  ';
                         }
                         $output .= ' > ' . $UnitNamme . '</option>
                 ';
                     }

                     $output .= '

                        </select>
        </td>


         <td id="QtyText' . $rows->id . '">
         ' . $rows->Qty . '

       </td>


         <td style="display:' . $CostShow . '" id="AVGText' . $rows->id . '">

         ' . number_format((float)abs($Average), 2, '.', '') . '

</td>

<td style="display:' . $CostTwoShow . '">
          <div class="row" style="display:' . $CostTwoShow . '">

           ';
                     foreach ($AllFifoQty as $fffff) {

                         $output .= '



             <div class="col-12">
  ' . trans("admin.Qty") . ' :-   ' . number_format((float)abs($fffff->Qty), 2, '.', '') . '    ' . trans("admin.Cost") . ' :-    ' . number_format((float)abs($fffff->Cost_Price), 2, '.', '') . '
             </div>



          ';


                     }


                     $output .= '

        </div>
       </td>


           <td id="COSTText' . $rows->id . '">
           ' . number_format((float)abs($Cost), 2, '.', '') . '

       </td>

          <td id="priceIText' . $rows->id . '">
           ' . $rr->Price . '

       </td>
           <td id="priceIIText' . $rows->id . '">
           ' . $rr->Price_Two . '

       </td>

           <td id="priceIIIText' . $rows->id . '">
           ' . $rr->Price_Three . '

       </td>

        </tr>
            ';

                 }

             }

            }



            return   $output ;
        }
        $ProdsCount=0;
        return view('admin.Reports.StoresQtiesReportFilter',get_defined_vars());
    }


//ReturnWithoutBillReport
    public function ReturnWithoutBillReport(){

        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess = Employess::type()->delegate()->get();
        $Groups = ItemsGroups::all();
        $Accounts = AcccountingManual::where('Type',1)->whereIn('Parent',[37,24])->get();
        return view('admin.Reports.ReturnWithoutBillReport',get_defined_vars());
    }
    public function ReturnWithoutBillReportFilter(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $Store = $request->get('Store');
        $Account = $request->get('Account');
        $Delegate = $request->get('Delegate');
        $Safe = $request->get('Safe');
        $Payment = $request->get('Payment_Method');

        
        
         $query = ReturnWithoutBill::query()
             
             ->whereBetween('Date', [$from, $to])

                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Vendor', $Account);

                })

                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })
                ->when(!empty($Payment), function ($query) use ($Payment) {
                    return $query->where('Payment_Method', $Payment);

                })
                ->where('Delete','!=',1);
        
        
        $items=$query->paginate(50);
        $TotalPrice=$query->get()->sum('Total_Price');
        $TotalCost=$query->get()->sum('Total_Cost');
        
        
          

          



        $output = '';
        if($request->ajax())
        {
            $from = $request->get('from');
            $to = $request->get('to');
            $Store = $request->get('Store');
            $Account = $request->get('Account');
            $Delegate = $request->get('Delegate');
            $Safe = $request->get('Safe');
            $Payment = $request->get('Payment_Method');

            foreach($items as $row)
            {


                if(!empty($row->Delegate()->first()->Name)){

                    if(app()->getLocale() == 'ar' ){
                        $dele=$row->Delegate()->first()->Name;
                    }else{
                        $dele=$row->Delegate()->first()->NameEn;
                    }
                }else{

                    $dele='';
                }



                if(app()->getLocale() == 'ar' ){
                    $StName=$row->Store()->first()->Name;
                    $SafeName=$row->Safe()->first()->Name;
                        $CliName = $row->Vendor()->first()->Name;


                }else{
                    $StName=$row->Store()->first()->NameEn;
                    $SafeName=$row->Safe()->first()->NameEn;

                        $CliName = $row->Vendor()->first()->NameEn;




                }


                if($row->Payment_Method == 'Cash'){
                    $payment=trans('admin.Cash');
                }else{

                    $payment=trans('admin.Later');
                }


                $output .= '
        <tr>

                                                    <td>'.$row->Date.'</td>
                                                    <td>'.$row->Code.'</td>
                                                    <td>'.$StName.'</td>
                                                    <td>'.$SafeName.'</td>
                                                    <td>'.$CliName.'</td>
                                                    <td>'.$dele.'</td>
                                                    <td>'.$payment.'</td>
                                                      <td>'.$row->Total_Qty.'</td>
                                                      <td>'.$row->Total_Price.'</td>
                                                      <td>'.$row->Total_Cost.'</td>

                                                </tr>

        ';

            }




            return   $output ;
        }

        return view('admin.Reports.ReturnWithoutBillReportFilter',get_defined_vars());
    }



//ProductSalesGroupsReport
    public function ProductSalesGroupsReport(){

        if(auth()->guard('admin')->user()->vend != 0){

            if(!empty(auth()->guard('admin')->user()->vend()->first()->Pro_Group)){
                $Groups=ItemsGroups::where('id',auth()->guard('admin')->user()->vend()->first()->Pro_Group)->get();
            }else{
                $Groups=ItemsGroups::all();
            }


        }else{


            $Groups=ItemsGroups::all();
        }
        return view('admin.Reports.ProductSalesGroupsReport',[
            'Groups'=>$Groups,
        ]);
    }

    function ProductSalesGroupsReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Group = $request->get('Group');

            if($Group != ''){

                $items=ItemsGroups::whereIn('id',$Group)->get();

foreach ($items as $item) {
    $Group_Name = ItemsGroups::find($item->id);
    $Sales = ProductSales::

    whereRelation('Sales', function ($query) use ($From, $To) {
        return $query->whereBetween('Date', [$From, $To]);

    })
        ->whereRelation('Product', 'Group', $item->id)
        ->distinct(['Product_Code'])
        ->get();


    $qty = ProductSales::
    whereRelation('Product', 'Group', $item->id)
        ->whereRelation('Sales', function ($query) use ($From, $To) {
            return $query->whereBetween('Date', [$From, $To]);

        })
        ->get()->sum('Qty');

    $tot = ProductSales::
    whereRelation('Product', 'Group', $item->id)
        ->whereRelation('Sales', function ($query) use ($From, $To) {
            return $query->whereBetween('Date', [$From, $To]);

        })
        ->get()->sum('Total_Net');


    if (app()->getLocale() == 'ar') {
        $xName = $Group_Name->Name;

    } else {
        $xName = $Group_Name->Name;

    }
    $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>' . trans("admin.Group") . ' </th>
                                                    <th>' . trans("admin.Total_Qty") . ' </th>
                                                    <th>' . trans("admin.Total_Price") . ' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     ' . $xName . '
       </td>

               <td>
     ' . $qty . '
       </td>

       <td>
     ' . $tot . '
       </td>

        </tr>

                <tr style="background-color:#014b2a;color:white">
                                                    <th>' . trans("admin.Code") . ' </th>
                                                    <th>' . trans("admin.Name") . ' </th>
                                                    <th>' . trans("admin.Unit") . ' </th>
                                                    <th>' . trans("admin.Qty") . ' </th>
                                                    <th>' . trans("admin.Price") . ' </th>
                                                    <th>' . trans("admin.Total") . ' </th>
                                    </tr>

            ';


    foreach ($Sales as $sal) {


        $Newqty = ProductSales::
        where('Product', $sal->Product)
            ->where('Product_Code', $sal->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From, $To) {
                return $query->whereBetween('Date', [$From, $To]);

            })
            ->get()->sum('Qty');

        $Newtot = ProductSales::
        where('Product', $sal->Product)
            ->where('Product_Code', $sal->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From, $To) {
                return $query->whereBetween('Date', [$From, $To]);

            })
            ->get()->sum('Total_Net');

        $output .= ' <tr>

        <td>
     ' . $sal->Product_Code . '
       </td>

               <td>
     ' . $sal->P_Ar_Name . ' (' . $sal->V_Name . ') (' . $sal->VV_Name . ')
       </td>

        <td>
     ' . $sal->Unit()->first()->Name . '
       </td>
             <td>
     ' . $Newqty . '
       </td>
             <td>
     ' . $sal->Price . '
       </td>
             <td>
     ' . $Newtot . '
       </td>


        </tr>
  ';
    }


}


            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


//ProductSalesBrandsReport
    public function ProductSalesBrandsReport(){

        if(auth()->guard('admin')->user()->vend != 0){

            if(!empty(auth()->guard('admin')->user()->vend()->first()->Brand)){
                $Brands=Brands::where('id',auth()->guard('admin')->user()->vend()->first()->Brand)->get();
            }else{
                $Brands=Brands::all();
            }


        }else{


            $Brands=Brands::all();
        }
        return view('admin.Reports.ProductSalesBrandsReport',[
            'Brands'=>$Brands,
        ]);
    }

    function ProductSalesBrandsReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Brand = $request->get('Brand');

            if($Brand != ''){

                $items=Brands::whereIn('id',$Brand)->get();

                foreach ($items as $item) {
                    $Group_Name = Brands::find($item->id);
                    $Sales = ProductSales::

                    whereRelation('Sales', function ($query) use ($From, $To) {
                        return $query->whereBetween('Date', [$From, $To]);

                    })
                        ->whereRelation('Product', 'Brand', $item->id)
                        ->distinct(['Product_Code'])
                        ->get();


                    $qty = ProductSales::
                    whereRelation('Product', 'Brand', $item->id)
                        ->whereRelation('Sales', function ($query) use ($From, $To) {
                            return $query->whereBetween('Date', [$From, $To]);

                        })
                        ->get()->sum('Qty');

                    $tot = ProductSales::
                    whereRelation('Product', 'Brand', $item->id)
                        ->whereRelation('Sales', function ($query) use ($From, $To) {
                            return $query->whereBetween('Date', [$From, $To]);

                        })
                        ->get()->sum('Total_Net');


                    if (app()->getLocale() == 'ar') {
                        $xName = $Group_Name->Name;

                    } else {
                        $xName = $Group_Name->Name;

                    }
                    $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>' . trans("admin.Brand") . ' </th>
                                                    <th>' . trans("admin.Total_Qty") . ' </th>
                                                    <th>' . trans("admin.Total_Price") . ' </th>
                                                </tr>
                                            </thead>

       <tr>

        <td>
     ' . $xName . '
       </td>

               <td>
     ' . $qty . '
       </td>

       <td>
     ' . $tot . '
       </td>

        </tr>

                <tr style="background-color:#014b2a;color:white">
                                                    <th>' . trans("admin.Code") . ' </th>
                                                    <th>' . trans("admin.Name") . ' </th>
                                                    <th>' . trans("admin.Unit") . ' </th>
                                                    <th>' . trans("admin.Qty") . ' </th>
                                                    <th>' . trans("admin.Price") . ' </th>
                                                    <th>' . trans("admin.Total") . ' </th>
                                    </tr>

            ';


                    foreach ($Sales as $sal) {


                        $Newqty = ProductSales::
                        where('Product', $sal->Product)
                            ->where('Product_Code', $sal->Product_Code)
                            ->whereRelation('Sales', function ($query) use ($From, $To) {
                                return $query->whereBetween('Date', [$From, $To]);

                            })
                            ->get()->sum('Qty');

                        $Newtot = ProductSales::
                        where('Product', $sal->Product)
                            ->where('Product_Code', $sal->Product_Code)
                            ->whereRelation('Sales', function ($query) use ($From, $To) {
                                return $query->whereBetween('Date', [$From, $To]);

                            })
                            ->get()->sum('Total_Net');

                        $output .= '<tr>

        <td>
     ' . $sal->Product_Code . '
       </td>

               <td>
     ' . $sal->P_Ar_Name . ' (' . $sal->V_Name . ') (' . $sal->VV_Name . ')
       </td>

        <td>
     ' . $sal->Unit()->first()->Name . '
       </td>
             <td>
     ' . $Newqty . '
       </td>
             <td>
     ' . $sal->Price . '
       </td>
             <td>
     ' . $Newtot . '
       </td>


        </tr>
  ';
                    }


                }


            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }



//EmpPrecentsBrandsGroupsReport
    public function EmpPrecentsBrandsGroupsReport(Request $request){
        $Emps=Employess::type()->get();
        $Groups=ItemsGroups::get();
        $Brands=Brands::get();

        return view('admin.Reports.EmpPrecentsBrandsGroupsReport',get_defined_vars());
    }

    public function EmpPrecentsBrandsGroupsReportFilter(Request $request,Average $average){

        $Emp = $request->get('Emp');
        $Group = $request->get('Group');
        $Brand = $request->get('Brand');



            $Prods=Employess::

                when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->where('id', $Emp);
                })

                ->paginate(30);


                $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {

            $Emp = $request->get('Emp');
            $Group = $request->get('Group');
            $Brand = $request->get('Brand');

          foreach($Prods as $row){

              $total_sales=ProductSales::whereRelation('Sales','Delegate',$row->id)->get()->sum('Total_Net');
              $total_sales_group=ProductSales::whereRelation('Sales','Delegate',$row->id)->whereRelation('Product','Group',$Group)->get()->sum('Total_Net');
              $total_sales_brand=ProductSales::whereRelation('Sales','Delegate',$row->id)->whereRelation('Product','Brand',$Brand)->get()->sum('Total_Net');
              $groupp=ItemsGroups::find($Group);
              $brand=Brands::find($Brand);


              $precentGroup=$groupp->Sales_Precet  / 100  ;
              $precentBrand=$brand->Sales_Precet  / 100  ;

              $totPrecGroup= $total_sales_group * $precentGroup ;
              $totPrecBrand= $total_sales_brand * $precentBrand ;

              if (app()->getLocale() == 'ar') {
                  $emp_name = $row->Name;


              } else {
                  $emp_name = $row->NameEn;


              }


              $output .= '

       <tr>


       <td>
       '.$emp_name.'
       </td>


      <td>
       '.$total_sales.'
       </td>

      <td>
       '.$total_sales_group.'
       </td>


      <td>
       '.$totPrecGroup.'
       </td>


      <td>
       '.$total_sales_brand.'
       </td>


      <td>
       '.$totPrecBrand.'
       </td>



        </tr>
            ';
          }



            return   $output ;
        }
        $ProdsCount=0;
        return view('admin.Reports.EmpPrecentsBrandsGroupsReportFilter',get_defined_vars());
    }





//VendorBonusReport
    public function VendorBonusReport(){

        if(auth()->guard('admin')->user()->vend != 0){

            if(!empty(auth()->guard('admin')->user()->vend()->first()->Brand)){
                $Brands=Brands::where('id',auth()->guard('admin')->user()->vend()->first()->Brand)->get();
            }else{
                $Brands=Brands::all();
            }


        }else{


            $Brands=Brands::all();
        }

        $Vendors=Vendors::all();
        return view('admin.Reports.VendorBonusReport',get_defined_vars());
    }

    function VendorBonusReportFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $outputO = '';
            $qty = 0;
            $tot = 0;

            $From = $request->get('From');
            $To = $request->get('To');
            $Brand = $request->get('Brand');
            $Vendor = $request->get('Vendor');
            $Type = $request->get('Type');

            if($Brand != '' and $Vendor != '' and  $Type != '' ){

                $items=Brands::whereIn('id',$Brand)->get();

                $vend=Vendors::find($Vendor);

                if($Type == 'M'){
                    $Target=$vend->Monthly_Target;
                }elseif($Type == 'Q'){
                     $Target=$vend->Quarterly_Target;
                }elseif($Type == 'Y'){
                    $Target=$vend->Yearly_Target;
                }
                $Total_Bonus=0;

                foreach ($items as $item) {
                    $Group_Name = Brands::find($item->id);
                    $Sales = ProductSales::

                    whereRelation('Sales', function ($query) use ($From, $To) {
                        return $query->whereBetween('Date', [$From, $To]);

                    })
                        ->whereRelation('Product', 'Brand', $item->id)
                        ->distinct(['Product_Code'])
                        ->get();


                    $qty = ProductSales::
                    whereRelation('Product', 'Brand', $item->id)
                        ->whereRelation('Sales', function ($query) use ($From, $To) {
                            return $query->whereBetween('Date', [$From, $To]);

                        })
                        ->get()->sum('Qty');

                    $tot = ProductSales::
                    whereRelation('Product', 'Brand', $item->id)
                        ->whereRelation('Sales', function ($query) use ($From, $To) {
                            return $query->whereBetween('Date', [$From, $To]);

                        })
                        ->get()->sum('Total_Net');



                    if (app()->getLocale() == 'ar') {
                        $xName = $Group_Name->Name;

                    } else {
                        $xName = $Group_Name->Name;

                    }
                    $output .= '
                    <thead class="bg-highlight">
                                                <tr>
                                                    <th>' . trans("admin.Brand") . ' </th>
                                                    <th>' . trans("admin.Total_Qty") . ' </th>
                                                    <th>' . trans("admin.Total_Price") . ' </th>
                                                    <th>' . trans("admin.Target") . ' </th>
                                                    <th>' . trans("admin.Differnce") . ' </th>

                                                </tr>
                                            </thead>

       <tr>

        <td>
     ' . $xName . '
       </td>

               <td>
     ' . $qty . '
       </td>

       <td>
     ' . $tot . '
       </td>

       <td>
     ' . $Target . '
       </td>

       <td>
     ' . $tot  - $Target . '
       </td>


        </tr>

                <tr style="background-color:#014b2a;color:white">
                                                    <th>' . trans("admin.Code") . ' </th>
                                                    <th>' . trans("admin.Name") . ' </th>
                                                    <th>' . trans("admin.Unit") . ' </th>
                                                    <th>' . trans("admin.Qty") . ' </th>
                                                    <th>' . trans("admin.Total_Bonus") . ' </th>

                                    </tr>

            ';


                    foreach ($Sales as $sal) {



                        $Newqty = ProductSales::
                        where('Product', $sal->Product)
                            ->where('Product_Code', $sal->Product_Code)
                            ->whereRelation('Sales', function ($query) use ($From, $To) {
                                return $query->whereBetween('Date', [$From, $To]);

                            })
                            ->get()->sum('Qty');

                        $Total_Bonus+=$sal->Product()->first()->Bonus  * $Newqty;


                        $output .= '<tr>

        <td>
     ' . $sal->Product_Code . '
       </td>

               <td>
     ' . $sal->P_Ar_Name . ' (' . $sal->V_Name . ') (' . $sal->VV_Name . ')
       </td>

        <td>
     ' . $sal->Unit()->first()->Name . '
       </td>
             <td>
     ' . $Newqty . '
       </td>

              <td>
     ' . $sal->Product()->first()->Bonus  * $Newqty. '
       </td>


        </tr>
  ';
                    }










                }


            }
            $data = array(
                'table_data'  => $output,
                'total_bonus'  => $Total_Bonus,
            );
            echo json_encode($data);
        }
    }



 //Groups 
 
     public function GroupSingleFilter(Request $request) {

        AllGroups::truncate(); // تفريغ الجدول في البداية

        $Group = $request->get('Group');
        $GroupR = ItemsGroups::find($Group);

        // إذا لم يتم العثور على المجموعة الرئيسية، نرجع استجابة فارغة أو خطأ
        if (!$GroupR) {
            return response()->json([]);
        }

        // تحديد حقل الاسم بناءً على اللغة
        $nameColumn = (app()->getLocale() == 'ar') ? 'Name' : 'NameEn';

        // ----------------------------------------------------------------------
        // 1. تعريف دالة تكرارية لجلب وحفظ المجموعات الفرعية
        // ----------------------------------------------------------------------
        // هذه الدالة ستقوم بإضافة المجموعة الحالية ثم تستدعي نفسها للمجموعات الأبناء
        $processGroupAndChildren = function ($currentGroup) use ($nameColumn, &$processGroupAndChildren) {
            // حفظ المجموعة الحالية
            AllGroups::create([
                'Group' => $currentGroup->id,
                'Name' => $currentGroup->$nameColumn,
            ]);

            // جلب الأبناء لهذه المجموعة
            $children = ItemsGroups::where('Parent', $currentGroup->id)->get();

            // استدعاء الدالة تكرارياً لكل ابن
            foreach ($children as $child) {
                $processGroupAndChildren($child);
            }
        };

        // ----------------------------------------------------------------------
        // 2. بدء عملية التجوال الهرمي من المجموعة الرئيسية
        // ----------------------------------------------------------------------
        $processGroupAndChildren($GroupR);

        // ----------------------------------------------------------------------
        // 3. استرجاع النتائج النهائية من جدول AllGroups
        // ----------------------------------------------------------------------
        $states = AllGroups::orderBy('id', 'asc')->pluck("Name", "Group");

        return response()->json($states);
    }
        public function SubAccountFilter(Request $request) {


             $wfff=60;

       $account = $request->get('Account');


                if(app()->getLocale() == 'ar' ){
    $states=AcccountingManual::orderBy('Code','asc')

           ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Parent', $account);
    })
         ->where('Code','like', $wfff.'%')
      ->where('Type',1)
        ->pluck("Name","id");

                }else{

        $states=AcccountingManual::orderBy('Code','asc')

           ->when(!empty($account), function ($query) use ($account) {
        return $query->whereIn('Parent', $account);
    })
         ->where('Code','like', $wfff.'%')
      ->where('Type',1)
        ->pluck("NameEn","id");


                }


       return response()->json($states);

    }



}
