<?php

namespace App\Http\Controllers;

use App\Events\ManyfacturingEvent;
use App\Http\Requests\ArEnRequest;
use App\Http\Requests\ArRequest;
use App\Http\Requests\ManfacturingRequest;
use App\Services\Average;
use App\Services\ManfacturingService;
use Illuminate\Http\Request;
use App\Models\StoresDefaultData;
use App\Models\UsersMoves;
use App\Models\CostCenter;
use App\Models\Stores;
use App\Models\Coins;
use App\Models\ProductsQty;
use App\Models\Products;
use App\Models\Measuerments;
use App\Models\ProductsPurchases;
use App\Models\ProductsStartPeriods;
use App\Models\ProductMoves;
use App\Models\Branches;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\GeneralDaily;
use App\Models\AcccountingManual;
use App\Models\ManufacturingHalls;
use App\Models\ManufacturingModel;
use App\Models\IncomManufacturingModel;
use App\Models\OutcomManufacturingModel;
use App\Models\ExecutingReceiving;
use App\Models\ManuStoreCount;
use App\Models\ProductsExecutingReceiving;
use App\Models\DefaultDataShowHide;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductUnits;
use App\Models\StoresMoves;
use App\Models\ManufacturingDefaultData;
use App\Models\FifoQty;
use DB;
use Str;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Log;
use App\Traits\GeneralTrait;

class ManufacturingController extends Controller
{
    use GeneralTrait;

    function __construct()
{

$this->middleware('permission:صالات التصنيع', ['only' => ['ManufacturingHallsPage']]);
$this->middleware('permission:اضافه صاله تصنيع', ['only' => ['AddManufacturingHalls']]);
$this->middleware('permission:حذف صاله تصنيع', ['only' => ['DeleteManufacturingHalls']]);
$this->middleware('permission:تعديل صاله تصنيع', ['only' => ['EditManufacturingHalls']]);
$this->middleware('permission:نموذج التصنيع', ['only' => ['ManufacturingModelPage','AddManufacturingModel']]);
$this->middleware('permission:جدول نماذج التصنيع', ['only' => ['ManufacturingModelSechdule']]);
$this->middleware('permission:حذف نموذج تصنيع', ['only' => ['DeleteManufacturingModel']]);
$this->middleware('permission:تعديل نموذج تصنيع', ['only' => ['EditManufacturingModel','PostEditManufacturingModel']]);
$this->middleware('permission:التنفيذ و الاستلام', ['only' => ['ExecutingandReceiving','AddExecutingReceiving']]);
}



             //====== Manufacturing Halls =======
        public function ManufacturingHallsPage(){
        $items=ManufacturingHalls::all();
         return view('admin.Manufacturing.ManufacturingHalls',['items'=>$items]);
    }

     public function AddManufacturingHalls(ArRequest $request){

         try {
             DB::beginTransaction();

             $validated = $request->validated();

             if(!empty(request('English_Name'))){

                 $english_name=request('English_Name');
             }else{

                 $english_name=request('Arabic_Name');
             }

             $data['Arabic_Name']=request('Arabic_Name');
         $data['English_Name']=$english_name;
         ManufacturingHalls::create($data);

             $dataUser=[
                 'screen_ar'=>'صالات التصنيع',
                 'screen_en'=>'Manufacturing Halls',
                 'explain_ar'=>request('Arabic_Name'),
                 'explain_en'=>$english_name,
             ];
             $this->UserCreateMoves($dataUser);
DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
             return back();


         }catch(\Exception $ex){

             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }

     public function EditManufacturingHalls($id,ArEnRequest $request){

         try {
             DB::beginTransaction();

             $validated = $request->validated();

         $data['Arabic_Name']=request('Arabic_Name');
         $data['English_Name']=request('English_Name');
           ManufacturingHalls::where('id',$id)->update($data);

             $dataUser=[
                 'screen_ar'=>'صالات التصنيع',
                 'screen_en'=>'Manufacturing Halls',
                 'explain_ar'=>request('Arabic_Name'),
                 'explain_en'=>request('English_Name'),
             ];
             $this->UserUpdateMoves($dataUser);
             DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }

     public function DeleteManufacturingHalls($id){

         try {
             DB::beginTransaction();

        $del=ManufacturingHalls::find($id);

        $x=ManufacturingModel::where('Hall',$id)->get();

        if(!empty($x)){
            DB::rollBack();
            session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
            return back();
        }


             $dataUser=[
                 'screen_ar'=>'صالات التصنيع',
                 'screen_en'=>'Manufacturing Halls',
                 'explain_ar'=>$del->Arabic_Name,
                 'explain_en'=>$del->English_Name,
             ];
             $this->UserDeleteMoves($dataUser);
             $del->delete();
             DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

         }catch(\Exception $ex){

             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=ManufacturingHalls::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

           }


             //====== Manufacturing Model =======

    public function ManufacturingModelSechdule(){
        $items=ManufacturingModel::paginate(100);
        return view('admin.Manufacturing.ManufacturingModelSechdule',['items'=>$items]);
    }

    public function ManufacturingModelPage(){
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $Code=$this->ReturnCode(ManufacturingModel::class);
         return view('admin.Manufacturing.ManufacturingModel',get_defined_vars());
    }

    public function EditManufacturingModel($id){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $item=ManufacturingModel::find($id);
        $Incoms=IncomManufacturingModel::where('Model',$item->id)->get();
        $Outcoms=OutcomManufacturingModel::where('Model',$item->id)->get();

        return view('admin.Manufacturing.EditManufacturingModel',get_defined_vars());
    }

    public function PrintManufacturingModel($id){

        $item=ManufacturingModel::find($id);
        $Incoms=IncomManufacturingModel::where('Model',$item->id)->get();
        $Outcom=OutcomManufacturingModel::where('Model',$item->id)->orderBy('id','desc')->first();

        return view('admin.Manufacturing.PrintManufacturingModel',get_defined_vars());
    }

    public function AddManufacturingModel(ManfacturingRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $inStor=request('StoreIn');
        $outStor=request('StoreOut');

            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }


            $ID = DB::table('manufacturing_models')->insertGetId(
            array(


                'Date' => request('Date'),
                'Name' => request('Name'),
                'NameEn' => $english_name,
                'Time' => request('Time'),
                'Draw' => request('Draw'),
                'Note' => request('Note'),
                'Product_Numbers' => request('Product_Numbers'),
                'Total_Discount' => request('Total_Discount'),
                'Total_BF_Taxes' => request('Total_BF_Taxes'),
                'Total_Taxes' => request('Total_Taxes'),
                'Total_Price' => request('Total_Price'),
                'Hall' => request('Hall'),
                'Coin' => request('Coin'),
                'Workmanship_Price' => request('Workmanship_Price'),
                'Type' => 1,
                'Cost_Center' => request('Cost_Center'),
                'Incom_Store' => $inStor,
                'Outcom_Store' => $outStor,
                'User' => auth()->guard('admin')->user()->id,

            )
        );


        if(!empty(request('Unit'))){

            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $Totaal=request('Total');
            $StorePurch=request('StorePurch');
            $DeprecPrecent=request('DeprecPrecent');
            $Deprec=request('Deprec');
            $Product=request('Product');
            $PurchTax=request('PurchTax');

            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Cost']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total']=$Totaal[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Depreciation']=$DeprecPrecent[$i];
                $uu['Depreciation_Qty']=$Deprec[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Model']=$ID;


                IncomManufacturingModel::create($uu);


            }


        }

        if(!empty(request('UnitO'))){

            $P_Ar_NameO=request('P_Ar_NameO');
            $P_En_NameO=request('P_En_NameO');
            $UnitO=request('UnitO');
            $P_CodeO=request('P_CodeO');
            $QtyO=request('QtyO');
            $ProductO=request('ProductO');


            for($i=0 ; $i < count($UnitO) ; $i++){

                $pp=ProductUnits::where('Product',$ProductO[$i])->where('Unit',$UnitO[$i])->first();
                $plow=ProductUnits::where('Product',$ProductO[$i])->where('Rate',1)->first();
                $uu['SmallCode']=$plow->Barcode;
                $uu['Product_Code']=$P_CodeO[$i];
                $uu['P_Ar_Name']=$P_Ar_NameO[$i];
                $uu['P_En_Name']=$P_En_NameO[$i];
                $uu['Qty']=$QtyO[$i];
                $uu['SmallQty']=$QtyO[$i] * $pp->Rate;
                $uu['Store']=request('StoreOut');
                $uu['Product']=$ProductO[$i];
                $uu['Unit']=$UnitO[$i];
                $uu['Cost']=request('Total_Price');
                $uu['Model']=$ID;

                OutcomManufacturingModel::create($uu);


            }


        }


            $dataUser=[
                'screen_ar'=>'نموذج التصنيع',
                'screen_en'=>'Manufacturing Model',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));

        if(request('SP') == 0){      return redirect('ManufacturingModelSechdule'); }elseif(request('SP') == 1){  return redirect('ManuExecution/'.$ID); }


        }catch(\Exception $ex){

            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function PostEditManufacturingModel($id,ManfacturingRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $inStor=request('StoreIn');
            $outStor=request('StoreOut');

            $data['Code'] = request('Code');
        $data['Date'] = request('Date');
        $data['Name'] = request('Name');
        $data['NameEn'] = request('NameEn');
        $data['Time'] = request('Time');
        $data['Draw'] = request('Draw');
        $data['Note'] = request('Note');
        $data['Type'] = 1;
        $data['Product_Numbers'] = request('Product_Numbers');
        $data['Total_Discount'] = request('Total_Discount');
        $data['Total_BF_Taxes'] = request('Total_BF_Taxes');
        $data['Total_Taxes'] = request('Total_Taxes');
        $data['Total_Price'] = request('Total_Price');
        $data['Hall'] = request('Hall');
        $data['Coin'] = request('Coin');
        $data['Workmanship_Price'] = request('Workmanship_Price');
        $data['Cost_Center'] = request('Cost_Center');

        $data['Incom_Store'] = $inStor;
        $data['Outcom_Store'] = $outStor;

        $data['User'] = auth()->guard('admin')->user()->id;

        ManufacturingModel::where('id',$id)->update($data);

        if(!empty(request('Unit'))){

            IncomManufacturingModel::where('Model',$id)->delete();

            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $Totaal=request('Total');
            $StorePurch=request('StorePurch');
            $DeprecPrecent=request('DeprecPrecent');
            $Deprec=request('Deprec');
            $Product=request('Product');
            $PurchTax=request('PurchTax');

            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Cost']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total']=$Totaal[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Depreciation']=$DeprecPrecent[$i];
                $uu['Depreciation_Qty']=$Deprec[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Model']=$id;


                IncomManufacturingModel::create($uu);


            }


        }

        if(!empty(request('UnitO'))){
            OutcomManufacturingModel::where('Model',$id)->delete();
            $P_Ar_NameO=request('P_Ar_NameO');
            $P_En_NameO=request('P_En_NameO');
            $UnitO=request('UnitO');
            $P_CodeO=request('P_CodeO');
            $QtyO=request('QtyO');
            $ProductO=request('ProductO');


            for($i=0 ; $i < count($UnitO) ; $i++){

                $pp=ProductUnits::where('Product',$ProductO[$i])->where('Unit',$UnitO[$i])->first();
                $plow=ProductUnits::where('Product',$ProductO[$i])->where('Rate',1)->first();
                $uu['SmallCode']=$plow->Barcode;
                $uu['SmallQty']=$QtyO[$i] * $pp->Rate;
                $uu['Product_Code']=$P_CodeO[$i];
                $uu['P_Ar_Name']=$P_Ar_NameO[$i];
                $uu['P_En_Name']=$P_En_NameO[$i];
                $uu['Qty']=$QtyO[$i];
                $uu['Store']=request('StoreOut');
                $uu['Product']=$ProductO[$i];
                $uu['Unit']=$UnitO[$i];
                $uu['Cost']=request('Total_Price');
                $uu['Model']=$id;

                OutcomManufacturingModel::create($uu);


            }


        }


            $dataUser=[
                'screen_ar'=>'نموذج التصنيع',
                'screen_en'=>'Manufacturing Model',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();
        session()->flash('success',trans('admin.Updated'));
        return redirect('ManufacturingModelSechdule');

        }catch(\Exception $ex){

            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteManufacturingModel($id){

        try {
            DB::beginTransaction();

        $del=ManufacturingModel::find($id);

            $dataUser=[
                'screen_ar'=>'نموذج التصنيع',
                'screen_en'=>'Manufacturing Model',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();


        }catch(\Exception $ex){

            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



             //====== Manufacturing Model Precent =======
    public function ManufacturingModelPrecentPage(){
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $Code=$this->ReturnCode(ManufacturingModel::class);
         return view('admin.Manufacturing.ManufacturingModelPrecent',get_defined_vars());
    }

    public function EditManufacturingModelPrecent($id){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $item=ManufacturingModel::find($id);
        $Incoms=IncomManufacturingModel::where('Model',$item->id)->get();
        $Outcoms=OutcomManufacturingModel::where('Model',$item->id)->get();
        return view('admin.Manufacturing.EditManufacturingModelPrecent',get_defined_vars());
    }

    public function ManuExecutionPage($id){

        $Code=$this->ReturnCode(ExecutingReceiving::class);
        $Model=ManufacturingModel::find($id);
        $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->get();
        $Branches=Branches::all();
        return view('admin.Manufacturing.ManuExecution',get_defined_vars());
    }


    public function AddManufacturingModelPrecent(ManfacturingRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();
            $inStor=request('StoreIn');
            $outStor=request('StoreOut');


            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }
        $ID = DB::table('manufacturing_models')->insertGetId(
            array(


                'Date' => request('Date'),
                'Name' => request('Name'),
                'NameEn' => $english_name,
                'Time' => request('Time'),
                'Draw' => request('Draw'),
                'Note' => request('Note'),
                'Product_Numbers' => request('Product_Numbers'),
                'Total_Discount' => request('Total_Discount'),
                'Total_BF_Taxes' => request('Total_BF_Taxes'),
                'Total_Taxes' => request('Total_Taxes'),
                'Total_Price' => request('Total_Price'),
                'Hall' => request('Hall'),
                'Coin' => request('Coin'),
                'Workmanship_Price' => request('Workmanship_Price'),
                'Type' => 2,
                'Cost_Center' => request('Cost_Center'),
                'Incom_Store' => $inStor,
                'Outcom_Store' => $outStor,
                'User' => auth()->guard('admin')->user()->id,

            )
        );


        if(!empty(request('Unit'))){

            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Precent=request('Precent');
            $Qty=request('Qty');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $Totaal=request('Total');
            $StorePurch=request('StorePurch');
            $DeprecPrecent=request('DeprecPrecent');
            $Deprec=request('Deprec');
            $Product=request('Product');
            $PurchTax=request('PurchTax');

            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Precent']=$Precent[$i];
                $uu['Cost']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total']=$Totaal[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Depreciation']=$DeprecPrecent[$i];
                $uu['Depreciation_Qty']=$Deprec[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Model']=$ID;


                IncomManufacturingModel::create($uu);


            }


        }

        if(!empty(request('UnitO'))){

            $P_Ar_NameO=request('P_Ar_NameO');
            $P_En_NameO=request('P_En_NameO');
            $UnitO=request('UnitO');
            $P_CodeO=request('P_CodeO');
            $QtyO=request('QtyO');
            $ProductO=request('ProductO');


            for($i=0 ; $i < count($UnitO) ; $i++){

                $pp=ProductUnits::where('Product',$ProductO[$i])->where('Unit',$UnitO[$i])->first();
                $plow=ProductUnits::where('Product',$ProductO[$i])->where('Rate',1)->first();
                $uu['SmallCode']=$plow->Barcode;
                $uu['SmallQty']=$QtyO[$i] * $pp->Rate;
                $uu['Product_Code']=$P_CodeO[$i];
                $uu['P_Ar_Name']=$P_Ar_NameO[$i];
                $uu['P_En_Name']=$P_En_NameO[$i];
                $uu['Qty']=$QtyO[$i];
                $uu['Store']=request('StoreOut');
                $uu['Product']=$ProductO[$i];
                $uu['Unit']=$UnitO[$i];
                $uu['Model']=$ID;

                OutcomManufacturingModel::create($uu);


            }


        }


            $dataUser=[
                'screen_ar'=>'نموذج تصنيع بنسبه',
                'screen_en'=>'Manufacturing Model Precent',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        if(request('SP') == 0){      return redirect('ManufacturingModelSechdule'); }elseif(request('SP') == 1){  return redirect('ManuExecution/'.$ID); }

        }catch(\Exception $ex){

            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function PostEditManufacturingModelPrecent($id,ManfacturingRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $inStor=request('StoreIn');
            $outStor=request('StoreOut');

        $data['Code'] = request('Code');
        $data['Date'] = request('Date');
        $data['Name'] = request('Name');
        $data['NameEn'] = request('NameEn');
        $data['Time'] = request('Time');
        $data['Draw'] = request('Draw');
        $data['Note'] = request('Note');
        $data['Type'] = 2;
        $data['Product_Numbers'] = request('Product_Numbers');
        $data['Total_Discount'] = request('Total_Discount');
        $data['Total_BF_Taxes'] = request('Total_BF_Taxes');
        $data['Total_Taxes'] = request('Total_Taxes');
        $data['Total_Price'] = request('Total_Price');
        $data['Hall'] = request('Hall');
        $data['Coin'] = request('Coin');
        $data['Workmanship_Price'] = request('Workmanship_Price');
        $data['Cost_Center'] = request('Cost_Center');
        $data['Incom_Store'] = $inStor;
        $data['Outcom_Store'] = $outStor;
        $data['User'] = auth()->guard('admin')->user()->id;

        ManufacturingModel::where('id',$id)->update($data);

        if(!empty(request('Unit'))){

            IncomManufacturingModel::where('Model',$id)->delete();

            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $Precent=request('Precent');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $Totaal=request('Total');
            $StorePurch=request('StorePurch');
            $DeprecPrecent=request('DeprecPrecent');
            $Deprec=request('Deprec');
            $Product=request('Product');
            $PurchTax=request('PurchTax');

            for($i=0 ; $i < count($Unit) ; $i++){


                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Precent']=$Precent[$i];
                $uu['Cost']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total']=$Totaal[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Depreciation']=$DeprecPrecent[$i];
                $uu['Depreciation_Qty']=$Deprec[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Model']=$id;


                IncomManufacturingModel::create($uu);


            }


        }

        if(!empty(request('UnitO'))){
            OutcomManufacturingModel::where('Model',$id)->delete();
            $P_Ar_NameO=request('P_Ar_NameO');
            $P_En_NameO=request('P_En_NameO');
            $UnitO=request('UnitO');
            $P_CodeO=request('P_CodeO');
            $QtyO=request('QtyO');
            $ProductO=request('ProductO');


            for($i=0 ; $i < count($UnitO) ; $i++){
                $pp=ProductUnits::where('Product',$ProductO[$i])->where('Unit',$UnitO[$i])->first();
                $plow=ProductUnits::where('Product',$ProductO[$i])->where('Rate',1)->first();
                $uu['SmallCode']=$plow->Barcode;
                $uu['SmallQty']=$QtyO[$i] * $pp->Rate;
                $uu['Product_Code']=$P_CodeO[$i];
                $uu['P_Ar_Name']=$P_Ar_NameO[$i];
                $uu['P_En_Name']=$P_En_NameO[$i];
                $uu['Qty']=$QtyO[$i];
                $uu['Store']=request('StoreOut');
                $uu['Product']=$ProductO[$i];
                $uu['Unit']=$UnitO[$i];
                $uu['Model']=$id;

                OutcomManufacturingModel::create($uu);


            }


        }



            $dataUser=[
                'screen_ar'=>'نموذج تصنيع بنسبه',
                'screen_en'=>'Manufacturing Model Precent',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return redirect('ManufacturingModelSechdule');
        }catch(\Exception $ex){

            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ManufacturingModel::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //Copy

    public function CopyManufacturingModel($id){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $item=ManufacturingModel::find($id);
        $Incoms=IncomManufacturingModel::where('Model',$item->id)->get();
        $Outcoms=OutcomManufacturingModel::where('Model',$item->id)->get();
        $Code=$this->ReturnCode(ManufacturingModel::class);
        return view('admin.Manufacturing.CopyManufacturingModel',get_defined_vars());
    }

    public function CopyManufacturingModelPrecent($id){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $ManufacturingHalls=ManufacturingHalls::all();
        $Stores=Stores::type()->get();
        $item=ManufacturingModel::find($id);
        $Incoms=IncomManufacturingModel::where('Model',$item->id)->get();
        $Outcoms=OutcomManufacturingModel::where('Model',$item->id)->get();
        $Code=$this->ReturnCode(ManufacturingModel::class);
        return view('admin.Manufacturing.CopyManufacturingModelPrecent',get_defined_vars());
    }


    //Filters
    function IncomManufacturingProductsFilter(Request $request,Average $average,ManfacturingService  $service)
    {


        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');

            if($search != '' and $store != '')
            {


                $data=$this->FilterManuProduct($search);


            }


            $total_row = $data->count();
            if($total_row > 0)
            {

                foreach($data as $rows){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y) {
                        if ($rows->P_Type == 'Service' or $rows->P_Type == 'Completed' or $rows->P_Type == 'Raw' or $rows->P_Type == 'Industrial') {

                            if ($rows->Product()->first()->Status == 0) {

                                $units = ProductUnits::where('Product', $rows->Product)->get();
                                if(is_numeric($search)){

                                    $rr = ProductUnits::where('Product', $rows->Product)->where('Barcode', $search)->first();
                                }else {
                                    $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                                }


                                $st = Stores::find($store);

                                if (app()->getLocale() == 'ar') {
                                    $PrrroName = $rows->P_Ar_Name;
                                    $UniiName = $rows->Unit()->first()->Name;
                                    $StoreNemo = $st->Name;

                                } else {
                                    $PrrroName = $rows->P_En_Name;
                                    $UniiName = $rows->Unit()->first()->NameEn;
                                    $StoreNemo = $st->NameEn;

                                }

                                $pr = $average->AverageCostGetUnit($rows->Product, $rr->Barcode, $store, $rr->Unit);


                                if($pr == 0){
                                    $pr=1;

                                }

                                $Filter = [


                                    'id' => $rows->id,
                                    'store' => $store,
                                    'product' => $rows->Product,
                                    'PrrroName' => $PrrroName,
                                    'UniiName' => $UniiName,
                                    'StoreNemo' => $StoreNemo,
                                    'name_ar' => $rows->P_Ar_Name,
                                    'name_en' => $rows->P_En_Name,
                                    'v1' => $rows->V1,
                                    'v2' => $rows->V2,
                                    'v_name' => '',
                                    'vv_name' => '',
                                    'P_Code' => $rows->Barcode,
                                    'price' => $pr,
                                    'search'=>$search,

                                ];

                                $output .= $service->ItemsFilter($Filter);


                            }

                        }

                    }
                }


            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function OutcomManufacturingProductsFilter(Request $request,ManfacturingService  $service)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');

            if($search != '' and $store != '')
            {


                $data=$this->FilterManuProduct($search);


            }


            $total_row = $data->count();
            if($total_row > 0)
            {


                foreach($data as $rows){

                    $Stores=Stores::all();
                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y) {
                        if ($rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Completed') {

                            if ($rows->Product()->first()->Status == 0) {

                                $units = ProductUnits::where('Product', $rows->Product)->get();
                                $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();

                                if (app()->getLocale() == 'ar') {
                                    $PrrroName = $rows->P_Ar_Name;
                                    $UniiName = $rows->Unit()->first()->Name;


                                } else {
                                    $PrrroName = $rows->P_En_Name;
                                    $UniiName = $rows->Unit()->first()->NameEn;


                                }


                                $Filter = [


                                    'id' => $rows->id,
                                    'store' => $store,
                                    'product' => $rows->Product,
                                    'PrrroName' => $PrrroName,
                                    'UniiName' => $UniiName,
                                    'name_ar' => $rows->P_Ar_Name,
                                    'name_en' => $rows->P_En_Name,
                                    'P_Code' => $rows->Barcode,
                                    'search'=>$search,
                                ];

                                $output .= $service->ItemsFilterOutcome($Filter);


                            }

                        }
                    }
                }


            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

   function IncomManufacturingProductsFilterPrecent(Request $request,Average $average,ManfacturingService  $service)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');

            if($search != '' and $store != '')
            {

                $data=$this->FilterManuProduct($search);

            }


            $total_row = $data->count();
            if($total_row > 0)
            {

                foreach($data as $rows){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y) {
                        if ($rows->P_Type == 'Service' or $rows->P_Type == 'Completed' or $rows->P_Type == 'Raw' or $rows->P_Type == 'Industrial') {

                            if ($rows->Product()->first()->Status == 0) {

                                $units = ProductUnits::where('Product', $rows->Product)->get();
                                if(is_numeric($search)){

                                    $rr = ProductUnits::where('Product', $rows->Product)->where('Barcode', $search)->first();
                                }else {
                                    $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                                }


                                $st = Stores::find($store);

                                if (app()->getLocale() == 'ar') {
                                    $PrrroName = $rows->P_Ar_Name;
                                    $UniiName = $rows->Unit()->first()->Name;
                                    $StoreNemo = $st->Name;

                                } else {
                                    $PrrroName = $rows->P_En_Name;
                                    $UniiName = $rows->Unit()->first()->NameEn;
                                    $StoreNemo = $st->NameEn;

                                }

                                $pr = $average->AverageCostGetUnit($rows->Product, $rr->Barcode, $store, $rr->Unit);


                                if($pr == 0){
                                    $pr=1;

                                }

                                $Filter = [


                                    'id' => $rows->id,
                                    'store' => $store,
                                    'product' => $rows->Product,
                                    'PrrroName' => $PrrroName,
                                    'UniiName' => $UniiName,
                                    'StoreNemo' => $StoreNemo,
                                    'name_ar' => $rows->P_Ar_Name,
                                    'name_en' => $rows->P_En_Name,
                                    'v1' => $rows->V1,
                                    'v2' => $rows->V2,
                                    'v_name' => '',
                                    'vv_name' => '',
                                    'P_Code' => $rows->Barcode,
                                    'price' => $pr,
                                    'search'=>$search,

                                ];

                                $output .= $service->ItemsFilterPrecent($Filter);


                            }

                        }
                    }
                }


            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function OutcomManufacturingProductsFilterPrecent(Request $request,ManfacturingService  $service)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');

            if($search != '' and $store != '')
            {


                $data=$this->FilterManuProduct($search);


            }


            $total_row = $data->count();
            if($total_row > 0)
            {


                foreach($data as $rows){

                    $Stores=Stores::all();
                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y) {
                        if ($rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Completed') {

                            if ($rows->Product()->first()->Status == 0) {

                                $units = ProductUnits::where('Product', $rows->Product)->get();
                                $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();

                                if (app()->getLocale() == 'ar') {
                                    $PrrroName = $rows->P_Ar_Name;
                                    $UniiName = $rows->Unit()->first()->Name;


                                } else {
                                    $PrrroName = $rows->P_En_Name;
                                    $UniiName = $rows->Unit()->first()->NameEn;


                                }


                                $Filter = [


                                    'id' => $rows->id,
                                    'store' => $store,
                                    'product' => $rows->Product,
                                    'PrrroName' => $PrrroName,
                                    'UniiName' => $UniiName,
                                    'name_ar' => $rows->P_Ar_Name,
                                    'name_en' => $rows->P_En_Name,
                                    'P_Code' => $rows->Barcode,
                                    'search'=>$search,
                                ];

                                $output .= $service->ItemsFilterOutcome($Filter);


                            }

                        }
                    }

                }


            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    //==========  Executing and Receiving  ===============

     public function ExecutingandReceiving(){
        $items=ExecutingReceiving::paginate(100);
         $Code=$this->ReturnCode(ExecutingReceiving::class);
         $Models=ManufacturingModel::all();
         $Branches=Branches::all();
         $Vendors = AcccountingManual::where('Type',1)->where('Parent',37)->get();
         return view('admin.Manufacturing.ExecutingandReceiving',get_defined_vars());
    }

    function ModelExecutingFilter(Request $request,Average $average)
             {

     if($request->ajax())
     {
      $output = '';
      $search = $request->get('search');

    if($search != '')
    {

            $modal=ManufacturingModel::find($search);
            $Def=ManufacturingDefaultData::orderBy('id','desc')->first();

        $Out=OutcomManufacturingModel::where('Model',$search)->first();
        $Ins=IncomManufacturingModel::where('Model',$search)->get();
        $InsCount=IncomManufacturingModel::where('Model',$search)->count();
       $total_cost=0;

              if(app()->getLocale() == 'ar' ){
                      $OutName=$Out->P_Ar_Name;


                   }else{
                         $OutName=$Out->P_En_Name;


                   }


     }

      if(!empty($modal))
      {
  $i=1;

           $output .= '

             <input type="hidden"  name="Product_Code[]" value="'.$Out->Product_Code.'">
             <input type="hidden"  name="P_Ar_Name[]" value="'.$Out->P_Ar_Name.'">
             <input type="hidden"  name="P_En_Name[]" value="'.$Out->P_En_Name.'">
             <input type="hidden" step="any" class="form-control"  name="Qty[]" value="'.$Out->Qty.'">
             <input type="hidden"  name="Price[]" value="'.$modal->Total_Price.'">
             <input type="hidden"  name="Product[]" value="'.$Out->Product.'">
             <input type="hidden"  name="Store[]" value="'.$Out->Store.'">
             <input type="hidden"  name="Unit[]" value="'.$Out->Unit.'">


            ';


        foreach($Ins as $in){


              $Cost=$average->AverageCostGetUnit($in->Product,$in->Product_Code,$in->Store,$in->Unit);
$pro=ProductUnits::where('Product',$in->Product)->where('Unit',$in->Unit)->latest('id')->first();
$proDef=ProductUnits::where('Product',$in->Product)->where('Rate',1)->latest('id')->first();

            $total_cost += $Cost * $in->Qty  ;
                   if($Def->Executing_Qty == 1){
            $RE='';
        }else{
            $RE='readonly';

        }

            if($in->Product()->first()->P_Type != 'Service'){

           $Qunta=ProductsQty::where('Product',$in->Product)
               ->where('P_Code',$in->Product_Code)
               ->where('Store',$in->Store)
               ->get()->sum('Qty');

                if($Qunta == 0){

                      $Qunta=ProductsQty::where('Product',$in->Product)
               ->where('PP_Code',$in->Product_Code)
               ->where('Store',$in->Store)
               ->get()->sum('Qty');


                       if($Qunta == 0){

                                    $Qunta=ProductsQty::where('Product',$in->Product)
               ->where('PPP_Code',$in->Product_Code)
               ->where('Store',$in->Store)
               ->get()->sum('Qty');

                       }


                                  if($Qunta == 0){

                                    $Qunta=ProductsQty::where('Product',$in->Product)
               ->where('PPPP_Code',$in->Product_Code)
               ->where('Store',$in->Store)
               ->get()->sum('Qty');

                       }

                }


            }else{
            $Qunta=1000;
            }


                 if(app()->getLocale() == 'ar' ){
                      $PrrroName=$in->P_Ar_Name;
                      $StoreNemo=$in->Store()->first()->Name;
                      $UniiName=$in->Unit()->first()->Name;

                   }else{
                         $PrrroName=$in->P_En_Name;
                       $StoreNemo=$in->Store()->first()->NameEn;
                      $UniiName=$in->Unit()->first()->NameEn;

                   }

          if(auth()->guard('admin')->user()->can('سعر التكلفة في التصنيع')){

              $Gow='('.$Cost.')';
          }else{

              $Gow='';

          }

               $output .= '
             <tr>
        <td>
        '.$in->Product_Code.'
             <input type="hidden"  name="Product_CodeI[]" value="'.$in->Product_Code.'">
        </td>
            <td>
        '.$PrrroName.'  '.$Gow.'
             <input type="hidden"  name="P_Ar_NameI[]" value="'.$in->P_Ar_Name.'">
             <input type="hidden"  name="P_En_NameI[]" value="'.$in->P_En_Name.'">
        </td>
        <td>'.$Qunta.'  ('.$proDef->Unit()->first()->Name.')
                        <input type="hidden"  id="StoreQty'.$i.'" value="'.$Qunta.'">
        </td>
        <td id="HALK">
    <input type="number" step="any" id="DepreciationQty'.$i.'" class="form-control" name="QtyI[]"   value="'.$in->Depreciation_Qty.'" >
                <input type="hidden" id="OriginalDepreciationQty'.$i.'"   value="'.$in->Depreciation_Qty.'">
        </td>

            <td>
 <input type="number" step="any" id="Qtyy'.$i.'" class="form-control" name="QtyHide[]" onclick="IncomChange('.$i.')" onkeyup="IncomChange('.$i.')"  value="'.$in->Qty * $pro->Rate.'" '.$RE.'>
                <input type="hidden" id="OriginalQtyy'.$i.'"  value="'.$in->Qty * $pro->Rate.'">
                <input type="hidden" class="MO" id="More'.$i.'"  value="0">
('.$proDef->Unit()->first()->Name.')
        </td>

                  <td>
        '.$StoreNemo.'
             <input type="hidden"  name="PriceI[]" value="'.$Cost.'">
             <input type="hidden"  name="ProductI[]" value="'.$in->Product.'">
             <input type="hidden"  name="StoreI[]" value="'.$in->Store.'">
        </td>

                  <td>
        '.$UniiName.'
             <input type="hidden"  name="UnitI[]" value="'.$in->Unit.'">
        </td>

        <td id="ACTIONS">

        <label>'.trans('admin.DUWELTS').'</label>

<select class="select2 form-control" name="inStore[]">
<option value="0">'.trans('admin.No').'</option>
<option value="1">'.trans('admin.Yes').'</option>
</select>
</td>

        </tr>


            ';

      $i++;
        }



      }else
      {
       $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
      }
      $data = array(
       'table_data'  => $output,
       'qty'  => $Out->Qty,
       'tot'  => number_format((float)$total_cost, 2, '.', ''),
       'Outcome'  => $OutName,
       'count'  => $InsCount,
       'workman_ship'  => $modal->Workmanship_Price,
      );
      echo json_encode($data);
     }
    }

      public function AddExecutingReceiving(Request $request){
          
                   $data= $this->validate(request(),[
             'Date'=>'required',
             'Model'=>'required',
               ],[
            'Date.required' => trans('admin.DateRequired'),
         ]);

          try {
              DB::beginTransaction();

     

      $in=IncomManufacturingModel::where('Model',request('Model'))->orderBy('id','asc')->first();
        $out=OutcomManufacturingModel::where('Model',request('Model'))->first();

           $ID = DB::table('executing_receivings')->insertGetId(
        array(

            'Date' => request('Date'),
            'Qty' => request('Qtyy'),
            'Total' => request('Totall')*request('Qtyy'),
            'Model' => request('Model'),
            'User' => auth()->guard('admin')->user()->id,
            'Time' =>date("h:i:s a", time()),
            'Branch' =>request('Branch'),
            'StoreIn' =>$in->Store,
            'StoreOut' =>$out->Store,
            'Sort' =>request('Sort'),
            'Vendor' =>request('Vendor'),
            'Cost_Workmentship' =>request('Cost_Workmentship'),
            'Total_Workmentship' =>request('Total_Workmentship'),

        )
    );


            //Event
              ManyfacturingEvent::dispatch($request->all(),$ID);


              $dataUser=[
                  'screen_ar'=>'تنفيذ و استلام',
                  'screen_en'=>'Executing and Receiving',
                  'explain_ar'=>request('Code'),
                  'explain_en'=>request('Code'),
              ];
              $this->UserCreateMoves($dataUser);
DB::commit();

              session()->flash('success',trans('admin.Added_Successfully'));
             return redirect('ExecutingandReceiving');

          }catch(\Exception $ex){

              $MODEL=ExecutingReceiving::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=ExecutingReceiving::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }



      }







}
