<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\ZatcaService;

class InvoiceController extends Controller
{
    protected $zatcaService;

    public function __construct(ZatcaService $zatcaService)
    {
        $this->zatcaService = $zatcaService;
    }

    /**
     * وظيفة لإنشاء الشهادة والمفتاح الخاص.
     */
    public function generateCertificate()
    {
        try {
            $result = $this->zatcaService->generateCertificateAndPrivateKey();
            return response()->json(['message' => 'تم إنشاء ملفات الشهادة والمفتاح بنجاح.', 'data' => $result]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    /**
     * وظيفة لطلب شهادة التوافق من ZATCA.
     */
    public function requestZatcaCertificate(Request $request)
    {
        // $request->otp: يتم جلب الـ OTP من إدخال المستخدم في الواجهة
        $otp = $request->input('otp');
        if (!$otp) {
            return response()->json(['error' => 'يجب إدخال رمز OTP.'], 400);
        }

        try {
            $result = $this->zatcaService->requestComplianceCertificate($otp);
            return response()->json(['message' => 'تم استلام الشهادة من ZATCA بنجاح.', 'data' => $result]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    /**
     * وظيفة لإنشاء وتوقيع فاتورة.
     */    
    public function createSignAndSubmitInvoice()
    {
        // $invoiceData: يتم جلب البيانات من قاعدة البيانات أو من نموذج
        $invoiceData = [
            'uuid' => '3cf5ee18-ee25-44ea-a444-2c37ba7f28be', // جلب UUID فريد من قاعدة البيانات
            'invoice_number' => 'INV-001', // رقم الفاتورة من قاعدة البيانات
            'issue_date' => '2024-05-20', // تاريخ الفاتورة من قاعدة البيانات
            'issue_time' => '10:00:00', // وقت الفاتورة من قاعدة البيانات
            'invoice_counter_value' => '23', // قيمة عداد الفاتورة من قاعدة البيانات
            'previous_invoice_hash' => 'NWZlY2ViNjZmZmM4NmYzOGQ5NTI3ODZjNmQ2OTZjNzljMmRiYzIzOWRkNGU5MWI0NjcyOWQ3M2EyN2ZiNTdlOQ==', // الهاش من آخر فاتورة في قاعدة البيانات
            'customer' => [ // بيانات العميل من قاعدة البيانات
                'name' => 'John Doe',
                'tax_id' => '311111111101113',
                'address' => '123 Main St.',
                'country' => 'SA',
            ],
            'lines' => [ // أصناف الفاتورة من قاعدة البيانات
                ['id' => 1, 'name' => 'Product A', 'price' => 100, 'quantity' => 2, 'tax_rate' => 15],
                ['id' => 2, 'name' => 'Service B', 'price' => 50, 'quantity' => 1, 'tax_rate' => 15],
            ],
        ];

        try {
            // الخطوة 1: إنشاء وتوقيع الفاتورة
            $signResult = $this->zatcaService->generateAndSignInvoiceXml($invoiceData);

            // الخطوة 2: إرسال الفاتورة الموقعة إلى ZATCA
            $submitResult = $this->zatcaService->submitInvoiceToZatca($signResult['signed_invoice_path']);

            return response()->json([
                'message' => 'تم إنشاء وتوقيع وإرسال الفاتورة بنجاح.',
                'submission_result' => $submitResult
            ]);

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}