<?php

namespace App\Http\Controllers;

use Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use App\Models\AcccountingManual;
use App\Models\UsersMoves;
use App\Models\CostCenter;
use App\Models\Coins;
use App\Models\Branches;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\GeneralDaily;
use App\Models\Admin;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\OpeningEntries;
use App\Models\OpeningEntriesDetails;
use App\Models\ChecksTypes;
use App\Models\ExportChecks;
use App\Models\IncomChecks;
use App\Models\ShippingCompany;
use App\Models\SafesBanks;
use App\Models\Stores;
use App\Models\SafeTransfers;
use App\Models\ItemsGroups;
use App\Models\Employess;
use App\Models\Vendors;
use App\Models\Customers;
use App\Models\AssetsExpenses;
use App\Models\Assets;
use App\Models\Taxes;
use App\Models\CrmDefaultData;
use App\Models\InsurancePaper;
use App\Models\SalesDefaultData;
use App\Models\AccountsDefaultData;
use App\Models\PurchasesDefaultData;
use App\Models\StoresDefaultData;
use App\Models\Event;
use App\Models\City;
use App\Models\Places;
use App\Models\Notifications;
use App\Models\EmpReciptAccounts;
use App\Models\EmpPaymentAccounts;
use App\Models\MaintainceDefaultData;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use DB;
use DateTime;
use Auth;


class FilterController extends Controller
{

    // === Filters ====
    public function AllCoins() {


    if(app()->getLocale() == 'ar' ){
    $states = Coins::orderBy("id",'asc')->pluck("Arabic_Name","id");
    }else{

    $states = Coins::orderBy("id",'asc')->pluck("English_Name","id");

    }

    return response()->json($states);

    }

    public function AllCostss() {


    if(app()->getLocale() == 'ar' ){
    $states = CostCenter::orderBy("id",'asc')->pluck("Arabic_Name","id");
    }else{

    $states = CostCenter::orderBy("id",'asc')->pluck("English_Name","id");

    }

    return response()->json($states);

    }

    public function AllSubAccounts() {


    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('Type',1)->pluck("NameEn","id");
    }
        
  
    return response()->json($states);

    }
    
    public function AllSubAccountsMsrofat() {


    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)->where('Parent',55)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('Type',1)->where('Parent',55)->pluck("NameEn","id");
    }


    return response()->json($states);

    }

    public function AllMainAccounts() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',0)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('Type',0)->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllUsers() {

    if(app()->getLocale() == 'ar' ){
    $states = Admin::where('hidden',0)->pluck("name","id");
    }else{
    $states = Admin::where('hidden',0)->pluck("nameEn","id");
    }
    return response()->json($states);

    }

    public function AllSafes() {


    if(app()->getLocale() == 'ar' ){
    if(auth()->guard('admin')->user()->emp == 0){

    $states = AcccountingManual::
    where('Type',1)
    ->whereIn('Parent',[28,29])
    ->pluck("Name","id");
    }else{

    if(!empty(auth()->guard('admin')->user()->safe)){

    $states = AcccountingManual::
    where('Type',1)
    ->where('id',auth()->guard('admin')->user()->safe)
    ->pluck("Name","id");

    }else{

    $states = AcccountingManual::
    where('Type',1)
        ->whereIn('Parent',[28,29])
    ->pluck("Name","id");
    }

    }

    }else{

    if(auth()->guard('admin')->user()->emp == 0){

    $states = AcccountingManual::
    where('Type',1)
        ->whereIn('Parent',[28,29])
    ->pluck("NameEn","id");
    }else{

    if(!empty(auth()->guard('admin')->user()->safe)){

    $states = AcccountingManual::
    where('Type',1)
    ->where('id',auth()->guard('admin')->user()->safe)
    ->pluck("NameEn","id");

    }else{

    $states = AcccountingManual::
    where('Type',1)
        ->whereIn('Parent',[28,29])
    ->pluck("NameEn","id");
    }

    }


    }


    return response()->json($states);

    }

    public function SafeBalanceFilter($id) {

    $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
    $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
    $dif=$debt - $crdt ;


    $states = [$dif,$dif];

    return response()->json($states);

    }

    public function AccountNameFilter($id) {

    $x = AcccountingManual::where("id",$id)->first();
    $states=[];

    if(app()->getLocale() == 'ar' ){

    $states += ["name" => $x->Name ,'code' => $x->Code ,'ID' => $x->id];
    }else{

    $states += ["name" => $x->NameEn ,'code' => $x->Code ,'ID' => $x->id];
    }


    return response()->json($states);

    }

    public function AllBanksAccounts() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Type',1)
    ->where('Parent',29)
    ->pluck("Name","id");
    }else{
    $states = AcccountingManual::
    where('Type',1)
    ->where('Parent',29)
    ->pluck("NameEn","id");

    }

    return response()->json($states);

    }
    public function AllAccounts() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::orderBy('Code','asc')->pluck("Name","id");
    }else{
    $states = AcccountingManual::orderBy('Code','asc')->pluck("NameEn","id");
    }
    return response()->json($states);

    }

    public function AllCustomers() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Type',1)
    ->where('Parent',24)
    ->pluck("Name","id");
    }else{
    $states = AcccountingManual::
    where('Type',1)
    ->where('Parent',24)
    ->pluck("NameEn","id");

    }

    return response()->json($states);

    }


    public function AllCustomersAndVendors() {

        if(app()->getLocale() == 'ar' ){
            $states = AcccountingManual::
            where('Type',1)
                ->whereIn('Parent',[24,37])
                ->pluck("Name","id");
        }else{
            $states = AcccountingManual::
            where('Type',1)
                ->whereIn('Parent',[24,37])
                ->pluck("NameEn","id");

        }

        return response()->json($states);

    }

    public function AllCustomersAndVendorsJ($id) {

        if(app()->getLocale() == 'ar' ){
            $states = AcccountingManual::
            where('Name','ILIKE', "%{$id}%")
                ->where('Type',1)
                ->whereIn('Parent',[24,37])
                ->pluck("Name","id");
        }else{

            $states = AcccountingManual::
            where('NameEn','ILIKE', "%{$id}%")
                ->where('Type',1)
                ->whereIn('Parent',[24,37])
                ->pluck("NameEn","id");
        }

        return response()->json($states);

    }


    public function AllEmps() {

    if(app()->getLocale() == 'ar' ){
    $states = Employess::latest('id')->type()->pluck("Name","id");
    }else{
        $states = Employess::latest('id')->type()->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllVendors() {

    $Def=PurchasesDefaultData::orderBy('id','desc')->first();

    if(app()->getLocale() == 'ar' ){
    if(auth()->guard('admin')->user()->emp != 0){

        $states=Vendors::where('Responsible',auth()->guard('admin')->user()->emp)->pluck("Name","Account");

    }else{

    if($Def->V_and_C == 1){

    $states = AcccountingManual::where('Type',1)->whereIn('Parent',[37,24])->pluck("Name","id");

    }elseif($Def->V_and_C == 0){

    $states = AcccountingManual::where('Type',1)->whereIn('Parent',[37])->pluck("Name","id");

    }
    }
    }else{
    if(auth()->guard('admin')->user()->emp != 0){

        $states=Vendors::where('Responsible',auth()->guard('admin')->user()->emp)->pluck("Name","Account");

    }else{

    if($Def->V_and_C == 1){

    $states = AcccountingManual::where('Type',1)->whereIn('Parent',[37,24])->pluck("NameEn","id");

    }elseif($Def->V_and_C == 0){

    $states = AcccountingManual::where('Type',1)->whereIn('Parent',[37])->pluck("NameEn","id");

    }
    }

    }

    return response()->json($states);

    }

    public function AllClientsFilter() {

        $DefCr=CrmDefaultData::orderBy('id','desc')->first();
        $states = []; 


        $buildAccountingManualQuery = function ($nameColumn) {
            $Def=SalesDefaultData::orderBy('id','desc')->first();
            $query = AcccountingManual::where('Type', 1)->take(200);

            if ($Def->V_and_C == 1 and $Def->Empp == 1) {
                $query->whereIn('Parent', [24, 37, 53, 55]);
            } elseif ($Def->V_and_C == 1 and $Def->Empp == 0) {
                $query->whereIn('Parent', [24, 37]);
            } elseif ($Def->V_and_C == 0 and $Def->Empp == 1) {
                $query->whereIn('Parent', [24, 53, 55]);
            } elseif ($Def->V_and_C == 0 and $Def->Empp == 0) {
                $query->where('Parent', 24);
            }

            return $query->pluck($nameColumn, "id");
        };

     
        if (app()->getLocale() == 'ar') {
            
            $nameColumn = "Name"; // استخدام حقل الاسم العربي

            if ($DefCr->Client_Delegate == 1) {

                if (auth()->guard('admin')->user()->emp != 0) {
                    // حالة العميل مسؤول عن طريق موظف معين
                    $states = Customers::where('Responsible', auth()->guard('admin')->user()->emp)->limit(200)->pluck("Name", "Account");
                } else {
                    // حالة العميل غير مسؤول عن طريق موظف معين -> بناء استعلام AcccountingManual
                    $states = $buildAccountingManualQuery($nameColumn);
                }

            } else {
                // حالة الـ Client_Delegate != 1 -> بناء استعلام AcccountingManual
                $states = $buildAccountingManualQuery($nameColumn);
            }

        } else {
            
            $nameColumn = "NameEn"; // استخدام حقل الاسم الإنجليزي

            if ($DefCr->Client_Delegate == 1) {

                if (auth()->guard('admin')->user()->emp != 0) {
                    // حالة العميل مسؤول عن طريق موظف معين
                    $states = Customers::where('Responsible', auth()->guard('admin')->user()->emp)->limit(200)->pluck("Name", "Account");
                } else {
                    // حالة العميل غير مسؤول عن طريق موظف معين -> بناء استعلام AcccountingManual
                    $states = $buildAccountingManualQuery($nameColumn);
                }

            } else {
                // حالة الـ Client_Delegate != 1 -> بناء استعلام AcccountingManual
                $states = $buildAccountingManualQuery($nameColumn);
            }
        }

        return response()->json($states);
    }
    
    public function AllShips() {

    if(app()->getLocale() == 'ar' ){
    $states = ShippingCompany::latest('id')->pluck("Name","id");
    }else{
    $states = ShippingCompany::latest('id')->pluck("NameEn","id");

    }

    return response()->json($states);

    }

    public function AllVend() {


    if(app()->getLocale() == 'ar' ){
    $states = Vendors::orderBy('id','asc')->pluck("Name","id");
    }else{
    $states = Vendors::orderBy('id','asc')->pluck("NameEn","id");
    }

    return response()->json($states);

    }

    public function AllCli() {

    if(app()->getLocale() == 'ar' ){
    $states = Customers::orderBy('id','asc')->pluck("Name","id");
    }else{

    $states = Customers::orderBy('id','asc')->pluck("NameEn","id");
    }
    return response()->json($states);

    }

    public function AllMainAssetsAccounts() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',0)->where('Parent',21)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('Type',0)->where('Parent',21)->pluck("NameEn","id");
    }


    return response()->json($states);

    }

    public function AllAccountsExpenses() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)->where('Parent',122)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('Type',1)->where('Parent',122)->pluck("NameEn","id");
    }
    return response()->json($states);

    }

    public function AllAccountsComplex() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)->where('Parent',119)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('Type',1)->where('Parent',119)->pluck("NameEn","id");
    }
    return response()->json($states);

    }


    //Ajax Search Filters

    public function AllMainAssetsAccountsJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Name','ILIKE', "%{$id}%")->where('Type',0)->where('Parent',21)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('NameEn','ILIKE', "%{$id}%")->where('Type',0)->where('Parent',21)->pluck("NameEn","id");

    }

    return response()->json($states);

    }

    public function AllAccountsExpensesJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Name','ILIKE', "%{$id}%")->where('Type',1)->where('Parent',122)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('NameEn','ILIKE', "%{$id}%")->where('Type',1)->where('Parent',122)->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllAccountsComplexJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Name','ILIKE', "%{$id}%")->where('Type',1)->where('Parent',119)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('NameEn','ILIKE', "%{$id}%")->where('Type',1)->where('Parent',119)->pluck("NameEn","id");
    }
    return response()->json($states);

    }

    public function AllVendorsJ($id) {

    $Def=PurchasesDefaultData::orderBy('id','desc')->first();


    if(app()->getLocale() == 'ar' ){

    if($Def->V_and_C == 0){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',37)
    ->pluck("Name","id");

    }elseif($Def->V_and_C == 1){

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent',[37,24])
    ->pluck("Name","id");



    }
    }else{
    if($Def->V_and_C == 0){
    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',37)
    ->pluck("NameEn","id");

    }elseif($Def->V_and_C == 1){

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
        ->whereIn('Parent',[37,24])
    ->pluck("NameEn","id");



    }

    }



    return response()->json($states);

    }

    public function AllClientsFilterJ($id) {


    $Def=SalesDefaultData::orderBy('id','desc')->first();

    if(app()->getLocale() == 'ar' ){
    if($Def->V_and_C == 0){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("Name","id");
    }elseif($Def->V_and_C == 1){

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
    ->pluck("Name","id");



    }
    }else{

    if($Def->V_and_C == 0){
    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("NameEn","id");
    }elseif($Def->V_and_C == 1){

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
    ->pluck("NameEn","id");



    }
    }



    return response()->json($states);

    }

    public function MainAccountss($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{
    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");

    }

    return response()->json($states);

    }

    public function AllSubAccountsJ($id) {


        if(is_numeric($id)){

            if (app()->getLocale() == 'ar') {
                $states = AcccountingManual::orderBy('Code')
                ->where('Code',$id)->where('Type', 1)->pluck("Name", "id");
            } else {
                $states = AcccountingManual::orderBy('Code')
                ->where('Code',$id)->where('Type', 1)->pluck("NameEn", "id");

            }

        }else {

            if (app()->getLocale() == 'ar') {
                $states = AcccountingManual::orderBy('Name')
                ->where('Name', 'ILIKE', "%{$id}%")->where('Type', 1)->pluck("Name", "id");
            } else {
                $states = AcccountingManual::orderBy('NameEn')
                ->where('NameEn', 'ILIKE', "%{$id}%")->where('Type', 1)->pluck("NameEn", "id");

            }
        }
    return response()->json($states);

    }
    
    public function AllSafesJ($id) {


    if(app()->getLocale() == 'ar' ){
    if(auth()->guard('admin')->user()->emp == 0){

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")->where('Type',1)
    ->whereIn('Parent', [28, 29])
    ->pluck("Name","id");
    }else{

    if(!empty(auth()->guard('admin')->user()->safe)){


    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")->where('Type',1)
    ->where('id',auth()->guard('admin')->user()->safe)
    ->pluck("Name","id");



    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")->where('Type',1)
    ->whereIn('Parent', [28, 29])
    ->pluck("Name","id");
    }

    }
    }else{

    if(auth()->guard('admin')->user()->emp == 0){

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")->where('Type',1)
    ->whereIn('Parent', [28, 29])
    ->pluck("NameEn","id");
    }else{

    if(!empty(auth()->guard('admin')->user()->safe)){


    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")->where('Type',1)
    ->where('id',auth()->guard('admin')->user()->safe)
    ->pluck("NameEn","id");



    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")->where('Type',1)
    ->whereIn('Parent', [28, 29])
    ->pluck("NameEn","id");
    }

    }
    }

    return response()->json($states);

    }

    public function AllBanksAccountsJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")->where('Type',1)
    ->where('Parent',29)
    ->pluck("Name","id");
    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")->where('Type',1)
    ->where('Parent',29)
    ->pluck("NameEn","id");
    }

    return response()->json($states);

    }

    public function AllCoinsJ($id) {


    if(app()->getLocale() == 'ar' ){
    $states = Coins::orderBy("id",'asc')->
    where('Arabic_Name','ILIKE', "%{$id}%")->
    pluck("Arabic_Name","id");
    }else{

    $states = Coins::orderBy("id",'asc')->
    where('English_Name','ILIKE', "%{$id}%")
    ->pluck("English_Name","id");

    }

    return response()->json($states);

    }

    public function AllCostssJ($id) {


    if(app()->getLocale() == 'ar' ){
    $states = CostCenter::orderBy("id",'asc')->
    where('Arabic_Name','ILIKE', "%{$id}%")
    ->pluck("Arabic_Name","id");
    }else{

    $states = CostCenter::orderBy("id",'asc')->
    where('English_Name','ILIKE', "%{$id}%")
    ->pluck("English_Name","id");

    }

    return response()->json($states);

    }

    public function AllUsersJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = Admin::
    where('name','ILIKE', "%{$id}%")->where('hidden',0)->pluck("name","id");
    }else{
    $states = Admin::
    where('nameEn','ILIKE', "%{$id}%")->where('hidden',0)->pluck("nameEn","id");

    }
    return response()->json($states);

    }

    public function AllCustomersJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("Name","id");
    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("NameEn","id");
    }

    return response()->json($states);

    }

    public function AllClientsJ($id) {


    if(app()->getLocale() == 'ar' ){
    $states = Customers::
    where('Name','ILIKE', "%{$id}%")
    ->orWhere('Company_Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{

    $states = Customers::
    where('NameEn','ILIKE', "%{$id}%")
    ->orWhere('Company_Name','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");
    }


    return response()->json($states);

    }

    public function AllEmpsJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = Employess::orderBy('id','asc')

    ->where('Name','ILIKE', "%{$id}%")
    ->orWhere('Code','ILIKE', "%{$id}%")
    ->type()
    ->pluck("Name","id");
    }else{

    $states = Employess::orderBy('id','asc')

    ->where('NameEn','ILIKE', "%{$id}%")
    ->orWhere('Code','ILIKE', "%{$id}%")
        ->type()
    ->pluck("NameEn","id");

    }

    return response()->json($states);

    }

    public function AllShipsJ($id) {


    if(app()->getLocale() == 'ar' ){
    $states = ShippingCompany::orderBy('id','asc')
    ->where('Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{
    $states = ShippingCompany::orderBy('id','asc')
    ->where('NameEn','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");

    }

    return response()->json($states);

    }

    public function AllVendJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = Vendors::orderBy('id','asc')
    ->where('Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{
    $states = Vendors::orderBy('id','asc')
    ->where('NameEn','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllCliJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = Customers::orderBy('id','asc')
    ->where('Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{

    $states = Customers::orderBy('id','asc')
    ->where('NameEn','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllVendorsJS($id) {

    $Def=PurchasesDefaultData::orderBy('id','desc')->first();

    if(app()->getLocale() == 'ar' ){
    if(auth()->guard('admin')->user()->emp != 0){


        $states=Vendors::where('Responsible',auth()->guard('admin')->user()->emp)
    ->where('Name','ILIKE', "%{$id}%")
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->orWhere('Code',$id)
        ->pluck("Name","Account");



    }else{
    if($Def->V_and_C == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("Name","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("Name","id");

    }



    }elseif($Def->V_and_C == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();

    if(!empty($Vendo)){


    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("Name","id");


    }else{


    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent', 37)
    ->pluck("Name","id");

    }


    }

    }
    }else{

    if(auth()->guard('admin')->user()->emp != 0){


        $states=Vendors::where('Responsible',auth()->guard('admin')->user()->emp)
    ->where('NameEn','ILIKE', "%{$id}%")
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->orWhere('Code',$id)
        ->pluck("NameEn","Account");



    }else{
    if($Def->V_and_C == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("NameEn","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37])
    ->pluck("NameEn","id");

    }



    }elseif($Def->V_and_C == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone',$id)
    ->first();

    if(!empty($Vendo)){


    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("NameEn","id");


    }else{


    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent', 37)
    ->pluck("NameEn","id");

    }


    }

    }

    }

    return response()->json($states);

    }

    public function AllClientsFilterJS($id) {

    $DefCr=CrmDefaultData::orderBy('id','desc')->first();

    if(app()->getLocale() == 'ar' ){
    if($DefCr->Client_Delegate == 1){

    if(auth()->guard('admin')->user()->emp != 0){


        $states=Customers::where('Responsible',auth()->guard('admin')->user()->emp)
    ->where('Name','ILIKE', "%{$id}%")
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->orWhere('Code',$id)
           ->take(200)
            ->pluck("Name","Account");



    }else{

    $Def=SalesDefaultData::orderBy('id','desc')->first();

    if($Def->V_and_C == 1 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    }elseif($Def->V_and_C == 1 and $Def->Empp == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
        ->take(200)
        ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
        ->take(200)
        ->pluck("Name","id");

    }


    }elseif($Def->V_and_C == 0 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
        ->take(200)
        ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
        ->take(200)
        ->pluck("Name","id");

    }

    }elseif($Def->V_and_C == 0 and $Def->Empp == 0){

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
        ->take(200)
        ->pluck("Name","id");

    }


    }

    }

    }else{

    $Def=SalesDefaultData::orderBy('id','desc')->first();

    if($Def->V_and_C == 1 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
    ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
    ->pluck("Name","id");

    }

    }elseif($Def->V_and_C == 1 and $Def->Empp == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
        ->take(200)
        ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
        ->take(200)
        ->pluck("Name","id");

    }


    }elseif($Def->V_and_C == 0 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
        ->take(200)
        ->pluck("Name","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
        ->take(200)
        ->pluck("Name","id");

    }

    }elseif($Def->V_and_C == 0 and $Def->Empp == 0){

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("Name","id");


    }else{

    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
        ->take(200)
        ->pluck("Name","id");

    }


    }

    }

    }else{

    if($DefCr->Client_Delegate == 1){

    if(auth()->guard('admin')->user()->emp != 0){

        $states=Customers::where('Responsible',auth()->guard('admin')->user()->emp)
    ->where('NameEn','ILIKE', "%{$id}%")
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->orWhere('Code',$id)
            ->take(200)
            ->pluck("NameEn","Account");




    }else{

    $Def=SalesDefaultData::orderBy('id','desc')->first();

    if($Def->V_and_C == 1 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
        ->take(200)
        ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
        ->take(200)
        ->pluck("NameEn","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
        ->take(200)
        ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
        ->take(200)
        ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
        ->take(200)
        ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
        ->take(200)
        ->pluck("NameEn","id");

    }

    }elseif($Def->V_and_C == 1 and $Def->Empp == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
         ->take(200)
    ->pluck("NameEn","id");

    }


    }elseif($Def->V_and_C == 0 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    }elseif($Def->V_and_C == 0 and $Def->Empp == 0){

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
         ->take(200)
    ->pluck("NameEn","id");

    }


    }

    }

    }else{

    $Def=SalesDefaultData::orderBy('id','desc')->first();

    if($Def->V_and_C == 1 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,37,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    }elseif($Def->V_and_C == 1 and $Def->Empp == 0){

    $Vendo=Vendors::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Vendo)){

    $states = AcccountingManual::
    where('id',$Vendo->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24, 37])
         ->take(200)
    ->pluck("NameEn","id");

    }


    }elseif($Def->V_and_C == 0 and $Def->Empp == 1){


    $Emps=Employess::where('Code',$id)
    ->first();

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();


    if(!empty($Emps)){

    $states = AcccountingManual::
    where('id',$Emps->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->whereIn('Parent', [24,53,55])
         ->take(200)
    ->pluck("NameEn","id");

    }

    }elseif($Def->V_and_C == 0 and $Def->Empp == 0){

    $Cust=Customers::where('Code',$id)
    ->orWhere('Phone','ILIKE', "%{$id}%")
    ->first();

    if(!empty($Cust)){

    $states = AcccountingManual::
    where('id',$Cust->Account)
         ->take(200)
    ->pluck("NameEn","id");


    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
         ->take(200)
    ->pluck("NameEn","id");

    }


    }

    }
    }

    return response()->json($states);

    }

    public function AllSubAccountsMsrofatJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)
    ->where('Name','ILIKE', "%{$id}%")
    ->where('Parent',55)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('Type',1)
    ->where('NameEn','ILIKE', "%{$id}%")
    ->where('Parent',55)->pluck("NameEn","id");
    }

    return response()->json($states);

    }

    public function AllSubAccountsMwrden() {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)->where('Parent',37)->pluck("Name","id");
    }else{
    $states = AcccountingManual::where('Type',1)->where('Parent',37)->pluck("NameEn","id");

    }
    return response()->json($states);

    }

    public function AllSubAccountsMwrdenJ($id) {

    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::where('Type',1)
    ->where('Name','ILIKE', "%{$id}%")
    ->where('Parent',37)->pluck("Name","id");
    }else{

    $states = AcccountingManual::where('Type',1)
    ->where('NameEn','ILIKE', "%{$id}%")
    ->where('Parent',37)->pluck("NameEn","id");
    }

    return response()->json($states);

    }


    public function AllCustomersJPhone($id) {



    if(is_numeric($id)){


    $states = Customers::
    where('Phone',$id)
    ->orWhere('Phone2',$id)
    ->pluck("Name","Account");


    }else{



    if(app()->getLocale() == 'ar' ){
    $states = AcccountingManual::
    where('Name','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("Name","id");
    }else{

    $states = AcccountingManual::
    where('NameEn','ILIKE', "%{$id}%")
    ->where('Type',1)
    ->where('Parent',24)
    ->pluck("NameEn","id");
    }

    }

    return response()->json($states);

    }

    public function AllClientsJPhone($id) {

    if(is_numeric($id)){


    $states = Customers::
    where('Phone',$id)
    ->orWhere('Phone2',$id)
    ->pluck("Name","id");


    }else{
    if(app()->getLocale() == 'ar' ){
    $states = Customers::
    where('Name','ILIKE', "%{$id}%")
    ->orWhere('Company_Name','ILIKE', "%{$id}%")
    ->pluck("Name","id");
    }else{

    $states = Customers::
    where('NameEn','ILIKE', "%{$id}%")
    ->orWhere('Company_Name','ILIKE', "%{$id}%")
    ->pluck("NameEn","id");
    }
    }

    return response()->json($states);

    }

    public function AccountBalanceFilter($id) {

        $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
        $dif=$debt - $crdt ;
        $states = [$dif,$dif];

        return response()->json($states);

    }

    public function AccountBalanceSFilter($id) {

        $debt=GeneralDaily::where('Account',$id)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$id)->get()->sum('Creditor');
        $dif=$debt - $crdt ;
        $states = [$dif,$dif];

        return response()->json($states);

    }
    
    
    
    
    //New 
    
       public function NewAllSubAccounts(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = AcccountingManual::where('Type', 1);

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
            if (is_numeric($term)) {
                $query->where('Code', 'LIKE', "%{$term}%"); // البحث بالرقم
            } else {
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
            }
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }

        return response()->json($states);
    }
        
       public function NewAllSubAccountsSpecificEmp(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = EmpReciptAccounts::where('Emp',auth()->guard('admin')->user()->emp);
           
        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {

        $query->where('Account_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي  
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
  
            $states = $query->pluck("Account_Name", "Account");
        } else {

            $states = $query->pluck("Account_Name", "Account");
        }

        return response()->json($states);
    }
    
           
       public function NewAllSubAccountsSpecificEmpPay(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = EmpPaymentAccounts::where('Emp',auth()->guard('admin')->user()->emp);
           
        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {

        $query->where('Account_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي  
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
  
            $states = $query->pluck("Account_Name", "Account");
        } else {

            $states = $query->pluck("Account_Name", "Account");
        }

        return response()->json($states);
    }
    
    
      
       public function NewAllCustomersAndVendors(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = AcccountingManual::where('Type', 1)->whereIn('Parent',[24,37,43]);

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
            if (is_numeric($term)) {
                $query->where('Code', 'LIKE', "%{$term}%"); // البحث بالرقم
            } else {
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
            }
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }
           
           
           
           
         
           

        return response()->json($states);
    }

       public function NewAllCoins(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = Coins::query();

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

        return response()->json($states);
    }
      
       public function NewAllBranches(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = Branches::query();

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

        return response()->json($states);
    }
         
       public function NewAllCostCenter(Request $request) {
        $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = CostCenter::query();

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

        return response()->json($states);
    }
    
   
      
       public function NewAllSafesBanks(Request $request) {
        $term = $request->input('term');

      
             $query = AcccountingManual::where('Type', 1);

    // تحديد اسم العمود بناءً على اللغة
    $nameColumn = (app()->getLocale() == 'ar') ? 'Name' : 'NameEn';

    // الحصول على المستخدم الحالي من الـ guard 'admin'
    $adminUser = Auth::guard('admin')->user();

    // تطبيق الشروط بناءً على نوع المستخدم ووجود الـ 'safe'
    if ($adminUser && $adminUser->emp != 0 && !empty($adminUser->safe)) {
        // لو المستخدم مش 'emp == 0' وعنده 'safe' محدد
        $query->where('id', $adminUser->safe);
    } else {
        // في أي حالة تانية (سواء 'emp == 0' أو 'safe' مش موجود)
        $query->whereIn('Parent', [28, 29]);
    }
           
           
           
        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }

        return response()->json($states);
    }
      
        public function NewAllStores(Request $request) {
        $term = $request->input('term');


        $query = Stores::query();

        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }

        return response()->json($states);
    }
      
      
        public function NewAllCity(Request $request) {
        $term = $request->input('term');


        $query = City::query();

        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

        return response()->json($states);
    }
      
        
        public function NewAllPlaces(Request $request) {
        $term = $request->input('term');
        $City = $request->input('City');

               if ($City) {

        $query = Places::where('City',$City);

        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Arabic_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('English_Name', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        if (app()->getLocale() == 'ar') {
            $query->orderBy('Arabic_Name');
            $states = $query->pluck("Arabic_Name", "id");
        } else {
            $query->orderBy('English_Name');
            $states = $query->pluck("English_Name", "id");
        }

               }
        return response()->json($states);
    }
      
    
        public function NewAllEmps(Request $request) {

        
            
            
       $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = Employess::type();

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }            
            
            
            
    return response()->json($states);

    }
    

        public function NewAllCli(Request $request) {      
                 
       $term = $request->input('term');

        // لو كلمة البحث فاضية، هيرجع كل الحسابات
        // لو مش فاضية، هيعمل بحث
        $query = Customers::query();

        // لو الـ term موجود، هنضيف شرط البحث
        if ($term) {
    
                if (app()->getLocale() == 'ar') {
                    $query->where('Name', 'ILIKE', "%{$term}%"); // البحث بالاسم العربي
                } else {
                    $query->where('NameEn', 'ILIKE', "%{$term}%"); // البحث بالاسم الإنجليزي
                }
           
        }

        // سر الترتيب هنا
        if (app()->getLocale() == 'ar') {
            $query->orderBy('Name');
            $states = $query->pluck("Name", "id");
        } else {
            $query->orderBy('NameEn');
            $states = $query->pluck("NameEn", "id");
        }            
            
      
      
         return response()->json($states);
      

    }


    

    


}
