<?php

namespace App\Http\Controllers;

use App\Http\Requests\ArRequest;
use App\Http\Requests\NameRequest;
use App\Models\Coins;
use App\Models\CommentsClients;
use App\Models\CompanyData;
use App\Models\CustomersGroup;
use App\Models\FollowList;
use App\Models\ItemsGroups;
use App\Models\Itinerary;
use App\Models\ItineraryVisit;
use App\Models\MyFollowList;
use App\Models\Sales;
use App\Models\Stores;
use App\Services\Average;
use App\Services\CRMService;
use DateTime;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\UsersMoves;
use App\Models\AcccountingManual;
use App\Models\Admin;
use App\Models\Governrate;
use App\Models\City;
use App\Models\Activites;
use App\Models\ClientStatus;
use App\Models\Platforms;
use App\Models\Campaigns;
use App\Models\Customers;
use App\Models\CustomersFiles;
use App\Models\Employess;
use App\Models\CustomersTickets;
use App\Models\InterviewsTypes;
use App\Models\Interviews;
use App\Models\CustomerCommentsProducts;
use App\Models\Projects;
use App\Models\ProjectTeam;
use App\Models\Missions;
use App\Models\Countris;
use App\Models\CrmDefaultData;
use App\Models\ShippingCompany;
use App\Models\Places;
use App\Models\Competitors;
use App\Models\CustomerFollowUp;
use App\Models\Event;
use App\Models\Notifications;
use App\Models\CustomersRateTypes;
use App\Models\TicektIssues;
use App\Models\SalesOrder;

use DB;
use Str;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Requests\ArEnRequest;
use App\Traits\GeneralTrait;





class CRMController extends Controller
{

    use GeneralTrait;
    function __construct()
    {

        $this->middleware('permission:المحافظه', ['only' => ['GovernratePage','AddGovernrate','EditGovernrate','DeleteGovernrate','CityPage','AddCity','EditCity','DeleteCity']]);
        $this->middleware('permission:النشاطات', ['only' => ['ActivitesPage','AddActivites','EditActivites','DeleteActivites']]);
        $this->middleware('permission:حالات العملاء', ['only' => ['Clients_StatusPage','AddClients_Status','EditClients_Status','DeleteClients_Status']]);
        $this->middleware('permission:المنصات', ['only' => ['PlatformsPage','AddPlatforms','EditPlatforms','DeletePlatforms','CampaignsPage','AddCampaigns','EditCampaigns','DeleteCampaigns']]);
        $this->middleware('permission:انواع المقابلات', ['only' => ['Interviews_TypesPage','AddInterviews_Types','EditInterviews_Types','DeleteInterviews_Types']]);
        $this->middleware('permission:المقابلات', ['only' => ['InterviewsPage','AddInterviews','EditInterviews','DeleteInterviews']]);
        $this->middleware('permission:مقابلاتي', ['only' => ['MyMettingsPage']]);
        $this->middleware('permission:المشاريع', ['only' => ['ProjectsPage']]);
        $this->middleware('permission:اضافه مشروع', ['only' => ['AddProjects']]);
        $this->middleware('permission:تعديل مشروع', ['only' => ['EditProjects']]);
        $this->middleware('permission:حذف مشروع', ['only' => ['DeleteProjects']]);
        $this->middleware('permission:المهام', ['only' => ['MissionsPage']]);
        $this->middleware('permission:اضافه مهمه', ['only' => ['AddMissions']]);
        $this->middleware('permission:تعديل مهمه', ['only' => ['EditMissions']]);
        $this->middleware('permission:حذف مهمه', ['only' => ['DeleteMissions']]);
        $this->middleware('permission:مهامي', ['only' => ['MyMissions']]);
        $this->middleware('permission:المنافسين', ['only' => ['Competitors']]);
        $this->middleware('permission:متابعه العملاء', ['only' => ['Customerـfollowـup']]);
        $this->middleware('permission:انواع تقيمات العملاء', ['only' => ['CustomersRateTypes']]);
        $this->middleware('permission:اضافة تعليق عميل', ['only' => ['AddCommentCustomer']]);
        $this->middleware('permission:تقرير قياس العملاء', ['only' => ['CustomerPeriodReport']]);
        $this->middleware('permission:تقرير التعليقات', ['only' => ['CommentsReports']]);
        $this->middleware('permission:خط السير', ['only' => ['Itinerary']]);
        $this->middleware('permission:تقرير زيارات المندوب', ['only' => ['DelegateVistsReport']]);
        $this->middleware('permission:قائمة المتابعات', ['only' => ['FollowList']]);
        $this->middleware('permission:متابعاتي', ['only' => ['MyFollowList']]);
        $this->middleware('permission:مشاكل التذاكر', ['only' => ['TicektIssues']]);
        $this->middleware('permission:تحليل الصفقات', ['only' => ['DealsAnalysis']]);
        $this->middleware('permission:تقرير التذاكر', ['only' => ['TicketReport']]);
        $this->middleware('permission:تقرير تعليقات العملاء', ['only' => ['CommentCustomersReport']]);


    }

    

    
        //======  TicektIssues =======
    public function TicektIssues(){
        $items=TicektIssues::all();
        return view('admin.CRM.TicektIssues',get_defined_vars());
    }

    public function AddTicektIssues(){
        
              $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'English_Name'=>'required',
            ]);

        
        try {
            DB::beginTransaction();

      

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
       
            TicektIssues::create($data);

            $dataUser=[
                'screen_ar'=>'مشاكل التذاكر',
                'screen_en'=>'Ticekt Issues',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTicektIssues($id){
        
             $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'English_Name'=>'required',

            ]);



        try {
            DB::beginTransaction();

       

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');

            TicektIssues::where('id',$id)->update($data);

            $dataUser=[
                     'screen_ar'=>'مشاكل التذاكر',
                'screen_en'=>'Ticekt Issues',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteTicektIssues($id,CRMService $service){

        try {
            DB::beginTransaction();

 
            $del=TicektIssues::find($id);


            $dataUser=[
                       'screen_ar'=>'مشاكل التذاكر',
                'screen_en'=>'Ticekt Issues',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();


            session()->flash('error',trans('admin.Deleted'));
            return back();


        }catch(\Exception $ex){

            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=TicektIssues::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }



    //======  Countris =======
    public function CountrisPage(){
        $items=Countris::all();
        $Coins=Coins::all();
        $Stores=Stores::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->get();
        return view('admin.CRM.Countris',get_defined_vars());
    }

    public function AddCountris(){
        
             $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'English_Name'=>'required',
                'Flag'=>'required',
                'Safe'=>'required',
            ],[

            ]);

        
        try {
            DB::beginTransaction();

       

            $image=request()->file('Flag');
            $zFile=$this->UploadFile($image);
            if(!empty($zFile)){

                $data['Flag']=$zFile;

            }else{

                $data['Flag']=null;
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Safe']=request('Safe');
            $data['Store']=request('Store');
            $data['Coin']=request('Coin');
            $data['Code']=request('Code');
            $data['SearchCode']=request('SearchCode');
            Countris::create($data);

            $dataUser=[
                'screen_ar'=>'الدول',
                'screen_en'=>'Countris',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditCountris($id){
        
                 $data= $this->validate(request(),[
                'Arabic_Name'=>'required',
                'English_Name'=>'required',
                'Safe'=>'required',
            ],[


            ]);

        try {
            DB::beginTransaction();

   

            $image=request()->file('Flag');
            $zFile=$this->UploadFile($image);
            if(!empty($zFile)){

                $data['Flag']=$zFile;

            }else{

                $data['Flag']=request('Flags');
            }


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Safe']=request('Safe');
            $data['Coin']=request('Coin');
            $data['Store']=request('Store');
            $data['Code']=request('Code');
            $data['SearchCode']=request('SearchCode');
            Countris::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'الدول',
                'screen_en'=>'Countris',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCountris($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveCountry($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }

            $del=Countris::find($id);


            $dataUser=[
                'screen_ar'=>'الدول',
                'screen_en'=>'Countris',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();


            session()->flash('error',trans('admin.Deleted'));
            return back();


        }catch(\Exception $ex){

            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Countris::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  Governrate =======
    public function GovernratePage(){
        $items=Governrate::all();
        $Countris=Countris::all();
        return view('admin.CRM.Governrate',get_defined_vars());
    }

    public function AddGovernrate(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();


            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $data['Arabic_Name']=request('Arabic_Name');
            $data['Country']=request('Country');
            $data['SearchCode']=request('SearchCode');
            $data['English_Name']=$english_name;
            Governrate::create($data);

            $dataUser=[
                'screen_ar'=>'المحافظات',
                'screen_en'=>'Governrate',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditGovernrate($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['Country']=request('Country');
            $data['SearchCode']=request('SearchCode');

            $data['English_Name']=request('English_Name');


            Governrate::where('id',$id)->update($data);



            $dataUser=[
                'screen_ar'=>'المحافظات',
                'screen_en'=>'Governrate',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteGovernrate($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveGov($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }

            $del=Governrate::find($id);

            $dataUser=[
                'screen_ar'=>'المحافظات',
                'screen_en'=>'Governrate',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();

            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();


        }catch(\Exception $ex){

            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Governrate::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  City =======
    public function CityPage($id){
        $items=City::where('Gov',$id)->get();
        $Shippings=ShippingCompany::all();
        $Gov=Governrate::findOrFail($id);
        return view('admin.CRM.City',get_defined_vars());
    }

    public function AddCity(ArRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();
            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $data['Arabic_Name']=request('Arabic_Name');
            $data['Gov']=request('Gov');
            $data['SearchCode']=request('SearchCode');
            $data['ShippingCode']=request('ShippingCode');


            if(!empty( request('Ship_Price'))) {
                $data['Ship_Price'] = request('Ship_Price');
            }else{
                $data['Ship_Price'] =0;
            }

            $data['Shipping_Company']=request('Shipping_Company');
            $data['English_Name']=$english_name;

            City::create($data);



            $dataUser=[
                'screen_ar'=>'المدن',
                'screen_en'=>'City',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditCity($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Gov']=request('Gov');
            $data['Ship_Price']=request('Ship_Price');
            $data['SearchCode']=request('SearchCode');
            $data['Shipping_Company']=request('Shipping_Company');
            $data['ShippingCode']=request('ShippingCode');
            City::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'المدن',
                'screen_en'=>'City',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCity($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveCity($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }

            $del=City::find($id);

            $dataUser=[
                'screen_ar'=>'المدن',
                'screen_en'=>'City',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();


            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=City::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    //======  Places =======
    public function PlacesPage($id){
        $items=Places::where('City',$id)->get();
        $Employess = Employess::
        where('Emp_Type','Delivery')
            ->where("EmpSort",1)->where('Active',1)
            ->get();
        $City=City::findOrFail($id);
        return view('admin.CRM.Places',get_defined_vars());
    }

    public function AddPlaces(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $data['Arabic_Name']=request('Arabic_Name');
            $data['City']=request('City');
            $data['Delivery']=request('Delivery');
            if(!empty( request('Ship_Price'))) {
                $data['Ship_Price'] = request('Ship_Price');
            }else{
                $data['Ship_Price'] =0;
            }

            $data['SearchCode']=request('SearchCode');
            $data['English_Name']=$english_name;
            Places::create($data);

            $dataUser=[
                'screen_ar'=>'المناطق',
                'screen_en'=>'Places',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();
        }catch(\Exception $ex){

            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditPlaces($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['City']=request('City');
            $data['Ship_Price']=request('Ship_Price');
            $data['Delivery']=request('Delivery');
            $data['SearchCode']=request('SearchCode');
            Places::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'المناطق',
                'screen_en'=>'Places',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeletePlaces($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemovePlace($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }

            $del=Places::find($id);

            $dataUser=[
                'screen_ar'=>'المناطق',
                'screen_en'=>'Places',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Places::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  Activites =======
    public function ActivitesPage(){
        $items=Activites::all();
        return view('admin.CRM.Activites',get_defined_vars());
    }

    public function AddActivites(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            Activites::create($data);

            $dataUser=[
                'screen_ar'=>'النشاطات',
                'screen_en'=>'Activites',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditActivites($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            Activites::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'النشاطات',
                'screen_en'=>'Activites',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteActivites($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveActivity($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }


            $del=Activites::find($id);

            $dataUser=[
                'screen_ar'=>'النشاطات',
                'screen_en'=>'Activites',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);


            $del->delete();

            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Activites::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  Clients Status =======
    public function Clients_StatusPage(){
        $items=ClientStatus::all();
        return view('admin.CRM.ClientStatus',get_defined_vars());
    }

    public function AddClients_Status(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }
            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            ClientStatus::create($data);


            $dataUser=[
                'screen_ar'=>'حالات العملاء',
                'screen_en'=>'Clients Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditClients_Status($id,ArEnRequest $request){


        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            ClientStatus::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'حالات العملاء',
                'screen_en'=>'Clients Status',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteClients_Status($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveClientStatus($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }


            $del=ClientStatus::find($id);


            $dataUser=[
                'screen_ar'=>'حالات العملاء',
                'screen_en'=>'Clients Status',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();


            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ClientStatus::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Platforms =======
    public function PlatformsPage(){
        $items=Platforms::all();
        return view('admin.CRM.Platforms',get_defined_vars());
    }

    public function AddPlatforms(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            Platforms::create($data);

            $dataUser=[
                'screen_ar'=>'المنصات',
                'screen_en'=>'Platforms',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditPlatforms($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            Platforms::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'المنصات',
                'screen_en'=>'Platforms',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeletePlatforms($id,CRMService $service){
        try {
            DB::beginTransaction();

            $result=$service->RemovePlatforms($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }


            $del=Platforms::find($id);

            $dataUser=[
                'screen_ar'=>'المنصات',
                'screen_en'=>'Platforms',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();


            session()->flash('error',trans('admin.Deleted'));
            return back();


        }catch(\Exception $ex){

            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Platforms::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Campaigns =======
    public function CampaignsPage($id){
        $items=Campaigns::where('Platform',$id)->get();
        $Platform=$id;
        return view('admin.CRM.Campaigns',get_defined_vars());
    }

    public function AddCampaigns(ArRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }
            $data['Arabic_Name']=request('Arabic_Name');
            $data['Platform']=request('Platform');
            $data['English_Name']=$english_name;
            Campaigns::create($data);

            $dataUser=[
                'screen_ar'=>'الحملات',
                'screen_en'=>'Campaigns',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditCampaigns($id,ArEnRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Platform']=request('Platform');
            Campaigns::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'الحملات',
                'screen_en'=>'Campaigns',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCampaigns($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveCampaigns($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }

            $del=Campaigns::find($id);

            $dataUser=[
                'screen_ar'=>'الحملات',
                'screen_en'=>'Campaigns',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();

            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Campaigns::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    //======  Interviews Types =======
    public function Interviews_TypesPage(){
        $items=InterviewsTypes::all();
        return view('admin.CRM.InterviewsTypes',get_defined_vars());
    }

    public function AddInterviews_Types(ArRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            InterviewsTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع المقابلات',
                'screen_en'=>'Interviews Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();
        }catch(\Exception $ex){

            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditInterviews_Types($id,ArEnRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            InterviewsTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع المقابلات',
                'screen_en'=>'Interviews Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteInterviews_Types($id,CRMService $service){

        try {
            DB::beginTransaction();

            $result=$service->RemoveInterviews_Types($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }


            $del=InterviewsTypes::find($id);


            $dataUser=[
                'screen_ar'=>'انواع المقابلات',
                'screen_en'=>'Interviews Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();
            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=InterviewsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  CustomersRateTypes =======
    public function CustomersRateTypes(){
        $items=CustomersRateTypes::all();
        return view('admin.CRM.CustomersRateTypes',['items'=>$items]);
    }

    public function AddCustomersRateTypes(ArRequest $request){

        try {
            DB::beginTransaction();
            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }



            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
            $data['Color']=request('Color');

            CustomersRateTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع تقيمات العملاء',
                'screen_en'=>'Cutomers Rates Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);


            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditCustomersRateTypes($id,ArEnRequest $request){

        try {
            DB::beginTransaction();


            $validated = $request->validated();

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
            $data['Color']=request('Color');

            CustomersRateTypes::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'انواع تقيمات العملاء',
                'screen_en'=>'Cutomers Rates Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);


            DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCustomersRateTypes($id,CRMService $service){

        try {
            DB::beginTransaction();


            $result=$service->RemoveCustomersRateTypes($id);

            if($result == 1){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return back();

            }


            $del=CustomersRateTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع تقيمات العملاء',
                'screen_en'=>'Cutomers Rates Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();

            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CustomersRateTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Interviews  =======
    public function InterviewsPage(){
        $items=Interviews::latest('id')->paginate(100);
        $Employess=Employess::type()->get();
        $InterviewsTypes=InterviewsTypes::all();
        $Users=Admin::all();
        $Governrates=Governrate::all();
        $Activites=Activites::all();
        $Platforms=Platforms::all();
        $Cities=City::all();
        $Campaigns=Campaigns::all();
        $Code=$this->ReturnCode(Interviews::class);
        return view('admin.CRM.Interviews',get_defined_vars());
    }

    public function AddInterviews(){
        
               $data= $this->validate(request(),[
                'Emp'=>'required',
                'Client'=>'required',
                'Type'=>'required',
            ],[
            ]);

        try {
            DB::beginTransaction();

     

            $data['Date']=request('Date');
            $data['Time']=request('Time');
            $data['Status']=0;
            $data['Rate']=0;
            $data['Note']=request('Note');
            $data['Emp']=request('Emp');
            $data['Client']=request('Client');
            $data['Type']=request('Type');
            $data['User']=auth()->guard('admin')->user()->id;
            Interviews::create($data);

            $cli=Customers::find(request('Client'));

            $event['Start_Date']=request('Date');
            $event['End_Date']=request('Date');
            $event['Event_Ar_Name']='مقابلة';
            $event['Event_En_Name']='Meet';
            $event['Type']='المقابلات';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Code');
            $event['Emp']=request('Emp');
            $event['Client']=$cli->Account;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);


            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مقابلة جديدة';
            $notii['Noti_En_Name']='New Meet';
            $notii['Type']='المقابلات';
            $notii['TypeEn']='Interviews';
            $notii['Type_Code']=request('Code');
            $notii['Emp']=request('Emp');
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);
            notify()->success(trans('admin.NewMeet'));


            $dataUser=[
                'screen_ar'=>'المقابلات',
                'screen_en'=>'Interviews',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return redirect('Interviews');


        }catch(\Exception $ex){

            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditInterviews($id){
        
                    $data= $this->validate(request(),[
                'Code'=>'required',
                'Emp'=>'required',
                'Client'=>'required',
                'Type'=>'required',


            ],[
                'Code.required' => trans('admin.CodeRequired'),


            ]);


        try {
            DB::beginTransaction();


            $del=Interviews::find($id);

            Event::where('Type_Code',$del->Code)->where('Type','المقابلات')->delete();
            Notifications::where('Type_Code',$del->Code)->where('Type','المقابلات')->delete();


            $data['Code']=request('Code');
            $data['Date']=request('Date');
            $data['Time']=request('Time');
            $data['Status']=request('Status');
            $data['Rate']=request('Rate');
            $data['Note']=request('Note');
            $data['Emp']=request('Emp');
            $data['Client']=request('Client');
            $data['Type']=request('Type');
            $data['User']=request('User');
            Interviews::where('id',$id)->update($data);

            $cli=Customers::find(request('Client'));

            $event['Start_Date']=request('Date');
            $event['End_Date']=request('Date');
            $event['Event_Ar_Name']='مقابلة';
            $event['Event_En_Name']='Meet';
            $event['Type']='المقابلات';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Code');
            $event['Emp']=request('Emp');
            $event['Client']=$cli->Account;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);


            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مقابلة جديدة';
            $notii['Noti_En_Name']='New Meet';
            $notii['Type']='المقابلات';
            $notii['TypeEn']='Interviews';
            $notii['Type_Code']=request('Code');
            $notii['Emp']=request('Emp');
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.NewMeet'));

            $dataUser=[
                'screen_ar'=>'المقابلات',
                'screen_en'=>'Interviews',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('Interviews');

        }catch(\Exception $ex){

            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteInterviews($id){

        try {
            DB::beginTransaction();

            $del=Interviews::find($id);
            Event::where('Type_Code',$del->Code)->where('Type','المقابلات')->delete();
            Notifications::where('Type_Code',$del->Code)->where('Type','المقابلات')->delete();

            $dataUser=[
                'screen_ar'=>'المقابلات',
                'screen_en'=>'Interviews',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function NotDone($id){
        Interviews::where('id',$id)->update(['Status'=>0,'StatusNote'=>null]);
        $del=Interviews::find($id);
        $dataUser=[
            'screen_ar'=>'المقابلات',
            'screen_en'=>'Interviews',
            'type_ar'=>'لم تكتمل',
            'type_en'=>'Not Done',
            'explain_ar'=>$del->Code,
            'explain_en'=>$del->Code,
        ];
        $this->UserCustomMoves($dataUser);
        session()->flash('error',trans('admin.Not_Done'));
        return back();

    }

    public function Done($id){

        Interviews::where('id',$id)->update(['Status'=>1,'StatusNote'=>request('StatusNote')]);
        $del=Interviews::find($id);
        $dataUser=[
            'screen_ar'=>'المقابلات',
            'screen_en'=>'Interviews',
            'type_ar'=>'اكتملت',
            'type_en'=>'Done',
            'explain_ar'=>$del->Code,
            'explain_en'=>$del->Code,
        ];
        $this->UserCustomMoves($dataUser);

        session()->flash('success',trans('admin.Done'));
        return back();

    }

    public function Rate($id){
        Interviews::where('id',$id)->update(['Rate'=>request('Rate')]);
        session()->flash('success',trans('admin.Rated'));
        return back();
    }

    public function AllClients() {

        if(app()->getLocale() == 'ar' ){
            $states = Customers::orderBy('Code','asc')->pluck("Name","id");
        }else{
            $states = Customers::orderBy('Code','asc')->pluck("NameEn","id");
        }

        return response()->json($states);

    }

    public function FilterInterviews(){
        $Employess=Employess::type()->get();
        $InterviewsTypes=InterviewsTypes::all();
        $Users=Admin::all();
        $Code=$this->ReturnCode(Interviews::class);
        $Governrates=Governrate::all();
        $Activites=Activites::all();
        $Platforms=Platforms::all();
        $Cities=City::all();
        $Campaigns=Campaigns::all();

        $SearchCode=request('Code');
        $Status=request('Status');
        $Rateee=request('Rateee');
        $Emp=request('Emp');
        $Client=request('Client');
        $Type=request('Type');
        $User=request('User');
        $From=request('From');
        $To=request('To');


        $items=Interviews::latest('id')

            ->when(!empty($SearchCode), function ($query) use ($SearchCode) {
                $query->where('Code', $SearchCode);
            })

            ->when(!empty($Status), function ($query) use ($Status) {
                $query->where('Status', $Status);
            })

            ->when(!empty($Rateee), function ($query) use ($Rateee) {
                $query->where('Rate', $Rateee);
            })

            ->when(!empty($Emp), function ($query) use ($Emp) {
                $query->where('Emp', $Emp);
            })

            ->when(!empty($Client), function ($query) use ($Client) {
                $query->where('Client', $Client);
            })

            ->when(!empty($Type), function ($query) use ($Type) {
                $query->where('Type', $Type);
            })

            ->when(!empty($User), function ($query) use ($User) {
                $query->where('User', $User);
            })

            ->whereBetween('Date', [$From, $To])
            ->paginate(100);

        return view('admin.CRM.Interviews',get_defined_vars());
    }


    //================================================

    // MyMettings
    public function MyMettingsPage(){

        if(auth()->guard('admin')->user()->emp == 0){
            session()->flash('error',trans('admin.Just_Emp'));
            return back();
        }else{
            $items=Interviews::orderBy('id','desc')
                ->where('Emp',auth()->guard('admin')->user()->emp)
                ->where('Status',0)
                ->paginate(100);
            return view('admin.CRM.MyMettings',get_defined_vars());
        }
    }

    // PerivousMettings
    public function PerivousMettings(){

        if(auth()->guard('admin')->user()->emp == 0){
            session()->flash('error',trans('admin.Just_Emp'));
            return back();
        }else{
            $items=Interviews::latest('id')
                ->where('Emp',auth()->guard('admin')->user()->emp)
                ->where('Status','!=',0)
                ->paginate(100);
            $InterviewsTypes=InterviewsTypes::all();
            $Governrates=Governrate::all();
            $Cities=City::all();
            return view('admin.CRM.PerivousMettings',get_defined_vars());
        }
    }

    public function AddNEWInterviews(){
        
          $data= $this->validate(request(),[

                'Emp'=>'required',
                'Client'=>'required',
                'Type'=>'required',


            ],[
                'Code.required' => trans('admin.CodeRequired'),


            ]);

        try {
            DB::beginTransaction();

          

            $data['Date']=request('Date');
            $data['Time']=request('Time');
            $data['Status']=1;
            $data['Rate']=0;
            $data['Note']=null;
            $data['StatusNote']=request('StatusNote');
            $data['Emp']=request('Emp');
            $data['Client']=request('Client');
            $data['Type']=request('Type');
            $data['User']=auth()->guard('admin')->user()->id;
            Interviews::create($data);

            $cli=Customers::find(request('Client'));

            $event['Start_Date']=request('Date');
            $event['End_Date']=request('Date');
            $event['Event_Ar_Name']='مقابلة';
            $event['Event_En_Name']='Meet';
            $event['Type']='المقابلات';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Code');
            $event['Emp']=request('Emp');
            $event['Client']=$cli->Account;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);


            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مقابلة جديدة';
            $notii['Noti_En_Name']='New Meet';
            $notii['Type']='المقابلات';
            $notii['TypeEn']='Interviews';
            $notii['Type_Code']=request('Code');
            $notii['Emp']=request('Emp');
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);
            notify()->success(trans('admin.NewMeet'));

            $code=Interviews::latest('id')->first()->Code;
            $dataUser=[
                'screen_ar'=>'المقابلات',
                'screen_en'=>'Interviews',
                'explain_ar'=>$code,
                'explain_en'=>$code,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Interviews::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

//========================================================

    //Add New Client by Ajax
    public function AddNewClientAjax(Request $request){

        $data= $this->validate(request(),[
            'Name'=>'required|unique:customers',
        ],[
            'Name.required' => trans('admin.NameRequired'),
        ]);



        $Name=$request->get('Name');
        $NameEn=$request->get('Name');
        $Phone=$request->get('Phone');
        $PriceLevel=$request->get('PriceLevel');
        $Governrate=$request->get('Governrate');
        $City=$request->get('City');
        $Activity=$request->get('Activity');
        $Campagin=$request->get('Campagin');
        $Responsible=$request->get('Responsible');
        $Platform=$request->get('Platform');


        $Acc=$this->CreateAccount($Name,$NameEn ,24 ,null);

        $CodeUser=$this->ReturnCode(Customers::class);

        if(auth()->guard('admin')->user()->emp != 0){
            $data['Responsible']=auth()->guard('admin')->user()->emp;
        }else{
            $data['Responsible']=$Responsible;
        }
        $data['Code']=$CodeUser;
        $data['Date']=date('Y-m-d');
        $data['Name']=$Name;
        $data['NameEn']=request('NameEn');
        $data['Phone']=$Phone;
        $data['Price_Level']=$PriceLevel;
        $data['Account']=$Acc;
        $data['User']=auth()->guard('admin')->user()->id;
        $data['Governrate']=$Governrate;
        $data['City']=$City;
        $data['Activity']=$Activity;
        $data['Campagin']=$Campagin;
        $data['Platform']=$Platform;
        Customers::create($data);

        $dataUser=[
            'screen_ar'=>'العملاء',
            'screen_en'=>'Clients',
            'explain_ar'=>$Name,
            'explain_en'=>$NameEn,
        ];
        $this->UserCreateMoves($dataUser);

        $states=['SUCEESS'=>'SUCEESS'];
        return response()->json($states);

    }


    //======  Projects =======
    public function ProjectsPage(){
        $items=Projects::paginate(100);
        $Employess=Employess::type()->get();
        return view('admin.CRM.Projects',get_defined_vars());
    }

    public function AddProjects(){
        
                  $data= $this->validate(request(),[
                'Name'=>'required',
                'Duration'=>'required',
                'Value'=>'required',
                'Client'=>'required',
                'Manager'=>'required',
                'Start_Date' => 'required|date|after:yesterday',
                'End_Date' => 'required|date|after_or_equal:Start',



            ],[
                'Name.required' => trans('admin.NameRequired'),
                'Duration.required' => trans('admin.DurationRequired'),
                'Value.required' => trans('admin.ValueRequired'),
                'Client.required' => trans('admin.ClientRequired'),
                'Manager.required' => trans('admin.ManagerRequired'),
                'Start_Date.date' => trans('admin.Startdate'),
                'Start_Date.after' => trans('admin.Startafter'),
                'End_Date.required' => trans('admin.EndRequired'),
                'End_Date.date' => trans('admin.Enddate'),
                'End_Date.after_or_equal' => trans('admin.Endafter_or_equal'),

            ]);

        try {
            DB::beginTransaction();

  

            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }

            $file=request()->file('File');
            $zFile=$this->UploadFile($file);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=null;
            }

            $data['Name']=request('Name');
            $data['NameEn']=$english_name;
            $data['Start_Date']=request('Start_Date');
            $data['End_Date']=request('End_Date');
            $data['Duration']=request('Duration');
            $data['Value']=request('Value');
            $data['Client']=request('Client');
            $data['Manager']=request('Manager');
            $data['Status']=0;
            $data['User']=auth()->guard('admin')->user()->id;
            Projects::create($data);

            $last=Projects::latest('id')->first();
            $cli=Customers::find(request('Client'));

            $event['Start_Date']=request('Start_Date');
            $event['End_Date']=request('End_Date');
            $event['Event_Ar_Name']='مشروع';
            $event['Event_En_Name']='Project';
            $event['Type']='المشاريع';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Name');
            $event['Emp']=request('Manager');
            $event['Client']=$cli->Account;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);

            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مشروع جديد';
            $notii['Noti_En_Name']='New Project';
            $notii['Type']='المشاريع';
            $notii['TypeEn']='Projects';
            $notii['Type_Code']=request('Name');
            $notii['Emp']=request('Manager');
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.New_Project'));


            if(!empty(request('Team'))){

                $Member=request('Team');

                for($i=0 ; $i < count($Member) ; $i++){

                    $team['Project']=$last->id;
                    $team['Member']=$Member[$i];

                    ProjectTeam::create($team);

                }


            }


            $dataUser=[
                'screen_ar'=>'المشاريع',
                'screen_en'=>'Projects',
                'explain_ar'=>request('Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditProjects($id){
        
              $data= $this->validate(request(),[
                'Name'=>'required',
                'Duration'=>'required',
                'Value'=>'required',
                'Client'=>'required',
                'Manager'=>'required',
                'Start_Date' => 'required|date|after:yesterday',
                'End_Date' => 'required|date|after_or_equal:Start',



            ],[
                'Name.required' => trans('admin.NameRequired'),
                'Duration.required' => trans('admin.DurationRequired'),
                'Value.required' => trans('admin.ValueRequired'),
                'Client.required' => trans('admin.ClientRequired'),
                'Manager.required' => trans('admin.ManagerRequired'),
                'Start_Date.date' => trans('admin.Startdate'),
                'Start_Date.after' => trans('admin.Startafter'),
                'End_Date.required' => trans('admin.EndRequired'),
                'End_Date.date' => trans('admin.Enddate'),
                'End_Date.after_or_equal' => trans('admin.Endafter_or_equal'),

            ]);
        try {
            DB::beginTransaction();

      

            $file=request()->file('File');
            $zFile=$this->UploadFile($file);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=request('Files');
            }


            $data['Name']=request('Name');
            $data['NameEn']=request('NameEn');
            $data['Start_Date']=request('Start_Date');
            $data['End_Date']=request('End_Date');
            $data['Duration']=request('Duration');
            $data['Value']=request('Value');
            $data['Client']=request('Client');
            $data['Manager']=request('Manager');
            $data['Status']=request('Status');
            $data['User']=auth()->guard('admin')->user()->id;

            Projects::where('id',$id)->update($data);

            $del=Projects::find($id);

            Event::where('Type_Code',$del->Name)->where('Type','المشاريع')->delete();
            Notifications::where('Type_Code',$del->Name)->where('Type','المشاريع')->delete();

            $cli=Customers::find(request('Client'));
            $event['Start_Date']=request('Start_Date');
            $event['End_Date']=request('End_Date');
            $event['Event_Ar_Name']='مشروع';
            $event['Event_En_Name']='Project';
            $event['Type']='المشاريع';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Name');
            $event['Emp']=request('Manager');
            $event['Client']=$cli->Account;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);

            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مشروع جديد';
            $notii['Noti_En_Name']='New Project';
            $notii['Type']='المشاريع';
            $notii['TypeEn']='Projects';
            $notii['Type_Code']=request('Name');
            $notii['Emp']=request('Manager');
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.New_Project'));


            if(!empty(request('Team'))){

                ProjectTeam::where('Project',$id)->delete();

                $Member=request('Team');

                for($i=0 ; $i < count($Member) ; $i++){

                    $team['Project']=$id;
                    $team['Member']=$Member[$i];

                    ProjectTeam::create($team);

                }


            }

            $dataUser=[
                'screen_ar'=>'المشاريع',
                'screen_en'=>'Projects',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('NameEn'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteProjects($id){

        try {
            DB::beginTransaction();

            $del=Projects::find($id);

            Event::where('Type_Code',$del->Name)->where('Type','المشاريع')->delete();
            Notifications::where('Type_Code',$del->Name)->where('Type','المشاريع')->delete();

            $dataUser=[
                'screen_ar'=>'المشاريع',
                'screen_en'=>'Projects',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->NameEn,
            ];
            $this->UserDeleteMoves($dataUser);

            $del->delete();



            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Projects::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EndProject($id){
        Projects::where('id',$id)->update(['Status'=>1]);
        session()->flash('error',trans('admin.Updated'));
        return back();
    }


    //======  Missions =======
    public function MissionsPage(){
        $items=Missions::paginate(100);
        $Employess=Employess::type()->get();
        $Projects=Projects::where('Status',0)->get();
        return view('admin.CRM.Missions',get_defined_vars());
    }

    public function AddMissions(){
        
        
                 $data= $this->validate(request(),[
                'Name'=>'required',
                'Duration'=>'required',
                'Value'=>'required',
                'Task_Owner'=>'required',
                'Observer'=>'required',
                'Project'=>'required',
                'Start_Date' => 'required|date|after:yesterday',
                'End_Date' => 'required|date|after_or_equal:Start',



            ],[
                'Name.required' => trans('admin.NameRequired'),
                'Task_Owner.required' => trans('admin.Task_OwnerRequired'),
                'Observer.required' => trans('admin.ObserverRequired'),
                'Project.required' => trans('admin.ProjectRequired'),
                'Duration.required' => trans('admin.DurationRequired'),
                'Value.required' => trans('admin.ValueRequired'),
                'Client.required' => trans('admin.ClientRequired'),
                'Manager.required' => trans('admin.ManagerRequired'),
                'Start_Date.date' => trans('admin.Startdate'),
                'Start_Date.after' => trans('admin.Startafter'),
                'End_Date.required' => trans('admin.EndRequired'),
                'End_Date.date' => trans('admin.Enddate'),
                'End_Date.after_or_equal' => trans('admin.Endafter_or_equal'),

            ]);

        try {
            DB::beginTransaction();

   

            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }

            $file=request()->file('File');
            $zFile=$this->UploadFile($file);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=null;
            }

            $data['Name']=request('Name');
            $data['NameEn']=$english_name;
            $data['Start_Date']=request('Start_Date');
            $data['End_Date']=request('End_Date');
            $data['Duration']=request('Duration');
            $data['Value']=request('Value');
            $data['Task_Owner']=request('Task_Owner');
            $data['Observer']=request('Observer');
            $data['Desc']=request('Desc');
            $data['Project']=request('Project');
            $data['Status']=0;
            $data['User']=auth()->guard('admin')->user()->id;
            Missions::create($data);



            $event['Start_Date']=request('Start_Date');
            $event['End_Date']=request('End_Date');
            $event['Event_Ar_Name']='مهمة';
            $event['Event_En_Name']='Mission';
            $event['Type']='المهام';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Name');
            $event['Emp']=request('Task_Owner');
            $event['Client']=null;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);



            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مهمة جديدة';
            $notii['Noti_En_Name']='New Mission';
            $notii['Type']='المهام';
            $notii['TypeEn']='Missions';
            $notii['Type_Code']=request('Name');
            $notii['Emp']=request('Task_Owner');
            $notii['Client']=null;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.New_Mission'));

            $dataUser=[
                'screen_ar'=>'المهام',
                'screen_en'=>'Missions',
                'explain_ar'=>request('Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditMissions($id){
        
               $data= $this->validate(request(),[
                'Name'=>'required',
                'Duration'=>'required',
                'Value'=>'required',
                'Task_Owner'=>'required',
                'Observer'=>'required',
                'Project'=>'required',
                'Start_Date' => 'required|date|after:yesterday',
                'End_Date' => 'required|date|after_or_equal:Start',



            ],[
                'Name.required' => trans('admin.NameRequired'),
                'Task_Owner.required' => trans('admin.Task_OwnerRequired'),
                'Observer.required' => trans('admin.ObserverRequired'),
                'Project.required' => trans('admin.ProjectRequired'),
                'Duration.required' => trans('admin.DurationRequired'),
                'Value.required' => trans('admin.ValueRequired'),
                'Client.required' => trans('admin.ClientRequired'),
                'Manager.required' => trans('admin.ManagerRequired'),
                'Start_Date.date' => trans('admin.Startdate'),
                'Start_Date.after' => trans('admin.Startafter'),
                'End_Date.required' => trans('admin.EndRequired'),
                'End_Date.date' => trans('admin.Enddate'),
                'End_Date.after_or_equal' => trans('admin.Endafter_or_equal'),

            ]);


        try {
            DB::beginTransaction();

     

            $file=request()->file('File');
            $zFile=$this->UploadFile($file);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=request('Files');
            }

            $data['Name']=request('Name');
            $data['NameEn']=request('NameEn');
            $data['Start_Date']=request('Start_Date');
            $data['End_Date']=request('End_Date');
            $data['Duration']=request('Duration');
            $data['Value']=request('Value');
            $data['Task_Owner']=request('Task_Owner');
            $data['Observer']=request('Observer');
            $data['Desc']=request('Desc');
            $data['Project']=request('Project');
            $data['Status']=0;
            $data['User']=auth()->guard('admin')->user()->id;

            Missions::where('id',$id)->update($data);



            $del=Missions::find($id);

            Event::where('Type_Code',$del->Name)->where('Type','المهام')->delete();
            Notifications::where('Type_Code',$del->Name)->where('Type','المهام')->delete();
            $event['Start_Date']=request('Start_Date');
            $event['End_Date']=request('End_Date');
            $event['Event_Ar_Name']='مهمة';
            $event['Event_En_Name']='Mission';
            $event['Type']='المهام';
            $event['Type_ID']=null;
            $event['Type_Code']=request('Name');
            $event['Emp']=request('Task_Owner');
            $event['Client']=null;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);


            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='مهمة جديدة';
            $notii['Noti_En_Name']='New Mission';
            $notii['Type']='المهام';
            $notii['TypeEn']='Missions';
            $notii['Type_Code']=request('Name');
            $notii['Emp']=request('Task_Owner');
            $notii['Client']=null;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.New_Mission'));

            $dataUser=[
                'screen_ar'=>'المهام',
                'screen_en'=>'Missions',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('NameEn'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();
        }catch(\Exception $ex){

            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteMissions($id){

        try {
            DB::beginTransaction();
            $del=Missions::find($id);
            Event::where('Type_Code',$del->Name)->where('Type','المهام')->delete();
            Notifications::where('Type_Code',$del->Name)->where('Type','المهام')->delete();


            $dataUser=[
                'screen_ar'=>'المهام',
                'screen_en'=>'Missions',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->NameEn,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();



            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Missions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function SureMission($id){
        Missions::where('id',$id)->update(['Status'=>1]);
        session()->flash('error',trans('admin.Updated'));
        return back();

    }

    public function SureMissionByEmp($id){
        Missions::where('id',$id)->update(['Status'=>2]);
        session()->flash('error',trans('admin.Updated'));
        return back();

    }

    public function AcceptMission(){
        $id=request('ID');
        Missions::where('id',$id)->update(['Status'=>request('Status'),'Value'=>request('Value')]);
        session()->flash('error',trans('admin.Updated'));
        return back();

    }

    public function MyMissions(){
        $items=Missions::where('Status',1)->where('Task_Owner',auth()->guard('admin')->user()->emp)->paginate(100);
        return view('admin.CRM.MyMissions',get_defined_vars());
    }


    //======  Competitors =======

    public function Competitors(){
        $items=Competitors::paginate(100);
        $Countris=Countris::all();
        return view('admin.CRM.Competitors',get_defined_vars());
    }

    public function AddCompetitors(NameRequest $request){


        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }


            $data['Name']=request('Name');
            $data['NameEn']=$english_name;
            $data['Website']=request('Website');
            $data['Facebook']=request('Facebook');
            $data['Instagram']=request('Instagram');
            $data['Twitter']=request('Twitter');
            $data['Pinterest']=request('Pinterest');
            $data['Addtional_Link']=request('Addtional_Link');
            $data['Phone']=request('Phone');
            $data['Whatsapp']=request('Whatsapp');
            $data['Country']=request('Country');

            Competitors::create($data);


            $dataUser=[
                'screen_ar'=>'المنافسين',
                'screen_en'=>'Competitors',
                'explain_ar'=>request('Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditCompetitors($id,NameRequest $request){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            $data['Name']=request('Name');
            $data['NameEn']=request('NameEn');
            $data['Website']=request('Website');
            $data['Facebook']=request('Facebook');
            $data['Instagram']=request('Instagram');
            $data['Twitter']=request('Twitter');
            $data['Pinterest']=request('Pinterest');
            $data['Addtional_Link']=request('Addtional_Link');
            $data['Phone']=request('Phone');
            $data['Whatsapp']=request('Whatsapp');
            $data['Country']=request('Country');
            Competitors::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'المنافسين',
                'screen_en'=>'Competitors',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('NameEn'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteCompetitors($id){
        try {
            DB::beginTransaction();
            $del=Competitors::find($id);

            $dataUser=[
                'screen_ar'=>'المنافسين',
                'screen_en'=>'Competitors',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->NameEn,
            ];
            $this->UserCreateMoves($dataUser);
            $del->delete();
            DB::commit();


            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Competitors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //AddCommentCustomer
    public function AddCommentCustomer(){
        $Code=$this->ReturnCode(CommentsClients::class);
        $Clients=Customers::get();
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        return view('admin.CRM.AddCommentCustomer', get_defined_vars());
    }

    public function PostAddCommentCustomer(){
        
              $data= $this->validate(request(),[
                'Comment'=>'required',

            ],[

            ]);


        try {
            DB::beginTransaction();

      

            if(!empty(request('CommentEn'))){

                $english_name=request('CommentEn');
            }else{

                $english_name=request('Comment');
            }

            $data['Comment']=request('Comment');
            $data['CommentEn']=$english_name;
            $data['Responsible']=auth()->guard('admin')->user()->emp;
            $data['Customer']=request('Customer');
            $data['Code']=request('Code');
            $data['Date']=request('Date');
            $data['Rate']=request('Rate');
            $data['Visit_Cost']=request('Visit_Cost');
            $data['Note']=request('Note');
            $data['Time']=date('H:i:s');
            $data['Type']=request('Type');
            CommentsClients::create($data);



            $dataUser=[
                'screen_ar'=>'تعليقات العملاء',
                'screen_en'=>'Clients Comments',
                'explain_ar'=>request('Comment'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
            return back();


        }catch(\Exception $ex){

            $MODEL=CommentsClients::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CommentsClients::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }


//Customerـfollowـup_Reports
    public function Customerـfollowـup_Reports(){
        $Clients=Customers::get();
        $Governrates=Governrate::get();
        $Cities=City::get();
        $Places=Places::get();
        $Groups=CustomersGroup::get();
        $Activites=Activites::get();
        return view('admin.CRM.Customerـfollowـup_Reports', get_defined_vars());
    }

    public function Customerـfollowـup_ReportsFilter(){

        $Governrate=request('Governrate');
$City=request('City');
$Place=request('Place');
$Group=request('Group');
$Activity=request('Activity');

        $items=Customers::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty(request('Operation_Date')), function ($query) {
                $query->where('Operating_Date', request('Operation_Date'));
            })
            ->when(!empty(request('Customer')), function ($query) {
                $query->where('id', request('Customer'));
            })

            ->when(!empty($Place), function ($query) use ($Place) {
                $query->where('Place',$Place);
            })

            ->when(!empty($City), function ($query) use ($City) {
                $query->where('City',$City);
            })

            ->when(!empty($Governrate), function ($query) use ($Governrate) {
                $query->where('Governrate',$Governrate);
            })

            ->when(!empty($Group), function ($query) use ($Group) {
                $query->where('Group',$Group);
            })

            ->when(!empty($Activity), function ($query) use ($Activity) {
                $query->where('Activity',$Activity);
            })

            ->latest('id')
            ->paginate(20);


        $items->appends(request()->query());
        return view('admin.CRM.Customerـfollowـup_ReportsFilter', get_defined_vars());
    }



    function CustomerFollowCommentsFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $customer = $request->get('customer');
        
            if($customer != '')
            {


                $data=CommentsClients::where('Customer',$customer)->get();

            }


            $total_row = $data->count();

            if($total_row > 0)
            {

     

            foreach ($data as $item) {   

                if(!empty($item->Responsible()->first()->Name)){

                     $responsibleName= $item->Responsible()->first()->Name;
                }else{
                    $responsibleName= '';

                }
               

                $output .= '
                <tr>
                
                    <td>'.$item->Date.'</td>
                      <td>'.$item->Time.'</td>
                        <td>'.$item->Comment.'</td>
                          <td>'.$responsibleName.'</td>
                            <td>'.$item->Note.'</td>

                </tr>
                ';


            }
            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function CustomerFollowProductsFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $customer = $request->get('customer');
        
            if($customer != '')
            {


                $data=CustomerCommentsProducts::whereRelation('Comment','Customer', $customer)->get();

            }


            $total_row = $data->count();

            if($total_row > 0)
            {

     

            foreach ($data as $item) {   

                if(!empty($item->Product()->first()->P_Ar_Name)){

                     $Name= $item->Product()->first()->P_Ar_Name;
                }else{
                    $Name= '';

                }
               

                $output .= '
                <tr>
                
                    <td>'.$Name.'</td>
             

                </tr>
                ';


            }
            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function CustomerFollowSalesOrderShowFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $customer = $request->get('customer');
        
            if($customer != '')
            {


                $cust=Customers::find($customer);
                 $data = SalesOrder::where('Client', $cust->Account)->get();

              

            }


            $total_row = $data->count();

            if($total_row > 0)
            {

     

            foreach ($data as $item) {   

     

                $output .= '
                <tr>
                
                    <td>'.$item->Date.'</td>
                      <td>'.$item->Code.'</td>
                        <td><a href="SalesOrderPrint/'.$item->id.'" class="btn btn-success" target="_blank"><i class="fal fa-arrow-right"></i></a></td>

                </tr>
                ';


            }
            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function CustomerFollowSalesShowFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $customer = $request->get('customer');
        
            if($customer != '')
            {


                $cust=Customers::find($customer);
                 $data = Sales::where('Client', $cust->Account)->get();

              

            }


            $total_row = $data->count();

            if($total_row > 0)
            {

     

            foreach ($data as $item) {   

     

                $output .= '
                <tr>
                
                    <td>'.$item->Date.'</td>
                      <td>'.$item->Code.'</td>
                        <td><a href="SalesPrint/'.$item->id.'" class="btn btn-success" target="_blank"><i class="fal fa-arrow-right"></i></a></td>

                </tr>
                ';


            }
            }else
            {
                $output = '
        <div class="col-md-3">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }





    //CustomerPeriodReport
    public function CustomerPeriodReport(){
        return view('admin.CRM.CustomerPeriodReport', get_defined_vars());
    }

    public function CustomerPeriodReportFilter(){

        $CustmersCount=Customers::whereBetween('Date',[request('From'),request('To')])->count();
        $CommentsCount=CommentsClients::whereBetween('Date',[request('From'),request('To')])->count();
        $SalesCount=Sales::whereBetween('Date',[request('From'),request('To')])->count();
        $SalesTotal=Sales::whereBetween('Date',[request('From'),request('To')])->get()->sum('Total_Net');
        $Governrates=Governrate::all();
        $From=request('From');
        $To=request('To');
        return view('admin.CRM.CustomerPeriodReportFilter', get_defined_vars());
    }

//CommentsReports
    public function CommentsReports(){
        $Clients=Customers::all();
        $Governrates=Governrate::get();
        $Cities=City::get();
        $Places=Places::get();
        $Groups=CustomersGroup::get();
        $Activites=Activites::get();
        $Responsible=Employess::type()->get();
        return view('admin.CRM.CommentsReports',get_defined_vars());
    }

    public function CommentsReportsFilter(){
        $From=request('From');
        $To=request('To');
        $Client=request('Client');
        $Governrate=request('Governrate');
        $City=request('City');
        $Place=request('Place');
        $Group=request('Group');
        $Activity=request('Activity');
        $Responsible=request('Responsible');

  
        
        $Comments=CommentsClients::latest('id')

            ->when(!empty($From), function ($query) use ($From,$To){
                $query->whereBetween('Date', [$From,$To]);
            })

            ->when(!empty($Responsible), function ($query) use ($Responsible){
                $query->where('Responsible', $Responsible);
            })

            ->when(!empty($Client), function ($query) use ($Client){
                $query->where('Customer', $Client);
            })


            ->when(!empty($Governrate), function ($query) use ($Governrate) {
                $query->whereRelation('Customer','Governrate',$Governrate);
            })


            ->when(!empty($Place), function ($query) use ($Place) {
                $query->whereRelation('Customer','Place',$Place);
            })

            ->when(!empty($City), function ($query) use ($City) {
                $query->whereRelation('Customer','City',$City);
            })

            ->when(!empty($Group), function ($query) use ($Group) {
                $query->whereRelation('Customer','Group',$Group);
            })

            ->when(!empty($Activity), function ($query) use ($Activity) {
                $query->whereRelation('Customer','Activity',$Activity);
            })


            ->paginate(30);

  $Comments->appends(request()->query());
        return view('admin.CRM.CommentsReportsFilter', get_defined_vars());
    }


    //======  Customerـfollowـup    (Canceled) =======

    public function Customerـfollowـup(){
        $items=CustomerFollowUp::paginate(100);
        $Clients = AcccountingManual::
        where('Type',1)
            ->where('Parent',24)
            ->get();
        $Employess = Employess::
        where("EmpSort",1)->where('Active',1)
            ->get();

        $ress=CustomerFollowUp::orderBy('id','desc')->first();

        if(!empty($ress->Code)){

            $Code=$ress->Code + 1 ;

        }else{

            $Code=1;

        }


        return view('admin.CRM.CustomerFollowUp',['items'=>$items,'Clients'=>$Clients,'Employess'=>$Employess,'Code'=>$Code]);
    }

    public function FilterCustomerـfollowـup(){

        $From=request('From');
        $To=request('To');
        $Client=request('Client');
        $Rate=request('Rate');
        $Emp=request('Emp');


        $items=CustomerFollowUp::whereBetween('Date',[$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client',$Client);

            })

            ->when(!empty($Rate), function ($query) use ($Rate) {
                return $query->where('Rate',$Rate);

            })


            ->when(!empty($Emp), function ($query) use ($Emp) {
                return $query->where('Emp',$Emp);

            })


            ->paginate(100);



        $Clients = AcccountingManual::
        where('Type',1)
            ->where('Parent',24)
            ->get();
        $Employess = Employess::
        where("EmpSort",1)->where('Active',1)
            ->get();

        $ress=CustomerFollowUp::orderBy('id','desc')->first();

        if(!empty($ress->Code)){

            $Code=$ress->Code + 1 ;

        }else{

            $Code=1;

        }

  $items->appends(request()->query());
        return view('admin.CRM.CustomerFollowUp',['items'=>$items,'Clients'=>$Clients,'Employess'=>$Employess,'Code'=>$Code]);
    }


    public function AddCustomerـfollowـup(){

        $data= $this->validate(request(),[
            'Date'=>'required',
            'Client'=>'required',
            'Subject'=>'required',
            'Emp'=>'required',


        ],[


        ]);



        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Client']=request('Client');
        $data['Subject']=request('Subject');
        $data['Rate']=request('Rate');
        $data['Emp']=request('Emp');
        $data['Visit_Cost']=request('Visit_Cost');
        $data['Note']=request('Note');


        CustomerFollowUp::create($data);



        $dataUser['User']=auth()->guard('admin')->user()->id;
        $dataUser['Date']=date('Y-m-d');
        $dataUser['Time']=date("h:i:s a", time());


        $dataUser['Screen']='متابعه العملاء';
        $dataUser['ScreenEn']='Customer follow up';
        $dataUser['Type']='اضافه جديده';
        $dataUser['TypeEn']='New Add';
        $dataUser['Explain']=request('Code');
        $dataUser['ExplainEn']=request('Code');
        UsersMoves::create($dataUser);

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditCustomerـfollowـup($id){


        $data= $this->validate(request(),[
            'Date'=>'required',
            'Client'=>'required',
            'Subject'=>'required',
            'Emp'=>'required',


        ],[


        ]);



        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Client']=request('Client');
        $data['Subject']=request('Subject');
        $data['Rate']=request('Rate');
        $data['Emp']=request('Emp');
        $data['Visit_Cost']=request('Visit_Cost');
        $data['Note']=request('Note');


        CustomerFollowUp::where('id',$id)->update($data);




        $dataUser['User']=auth()->guard('admin')->user()->id;
        $dataUser['Date']=date('Y-m-d');
        $dataUser['Time']=date("h:i:s a", time());
        $dataUser['Screen']='متابعه العملاء';
        $dataUser['ScreenEn']='Customer follow up';
        $dataUser['Type']='تعديل';
        $dataUser['TypeEn']='Edit';
        $dataUser['Explain']=request('Code');
        $dataUser['ExplainEn']=request('Code');
        UsersMoves::create($dataUser);


        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteCustomerـfollowـup($id){

        $del=CustomerFollowUp::find($id);

        $dataUser['User']=auth()->guard('admin')->user()->id;
        $dataUser['Date']=date('Y-m-d');
        $dataUser['Time']=date("h:i:s a", time());
        $dataUser['Screen']='متابعه العملاء';
        $dataUser['ScreenEn']='Customer follow up';
        $dataUser['Type']='حذف';
        $dataUser['TypeEn']='Delete';
        $dataUser['Explain']=$del->Code;
        $dataUser['ExplainEn']=$del->Code;
        UsersMoves::create($dataUser);

        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }


    //Itinerary

    public function Itinerary(){
        $items=Employess::type()->where('Emp_Type','Saller')->paginate(50);

        return view('admin.CRM.Itinerary',get_defined_vars());
    }

    public function ItineraryEmp($id){
        $items=Itinerary::where('Emp',$id)->orderBy('Time','asc')->get();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();
        $emp = $id;
        return view('admin.CRM.ItineraryEmp',get_defined_vars());
    }


    public function AddItinerary(){
        
            $data= $this->validate(request(),[
                'Emp'=>'required',
                'Day'=>'required',
                'Time'=>'required',
                'Client'=>'required',

            ],[


            ]);

        try {
            DB::beginTransaction();

        

            $data['Emp']=request('Emp');
            $data['Day']=request('Day');
            $data['Time']=request('Time');
            $data['Client']=request('Client');
            Itinerary::create($data);


            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditItinerary($id){
        
              $data= $this->validate(request(),[

                'Time'=>'required',
                'Client'=>'required',

            ],[


            ]);

        try {
            DB::beginTransaction();

      
            $data['Time']=request('Time');
            $data['Client']=request('Client');
            Itinerary::where('id',$id)->update($data);


            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteItinerary($id){

        try {
            DB::beginTransaction();

            $del=Itinerary::find($id);



            $del->delete();



            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Itinerary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

//MyItinerary

    public function MyItinerary(){
        $items=Itinerary::where('Emp',auth()->guard('admin')->user()->emp)->orderBy('Time','asc')->get();
        $Clients = AcccountingManual::where('Type',1)->where('Parent',24)->get();
        $emp = auth()->guard('admin')->user()->emp;
        return view('admin.CRM.ItineraryEmp',get_defined_vars());
    }

    public function DelegateVistsReport(Request $request){
        $Emps=Employess::type()->get();
        $Clients = AcccountingManual::where('Type',1)->whereIn('Parent',[24])->get();
        return view('admin.CRM.DelegateVistsReport',get_defined_vars());
    }

    public function DelegateVistsReportFilter(Request $request,Average $average){
        $ItemsGroups=ItemsGroups::all();
        $Stores=Stores::all();

        $from = $request->get('from');
        $to = $request->get('to');
        $Delegate = $request->get('Delegate');
        $Client = $request->get('Client');


        $Prods=ItineraryVisit::whereBetween('Date',[$from,$to])

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Emp', $Delegate);
            })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client', $Client);
            })


            ->paginate(10);


        $ProdsCount=0;

        $output = '';
        if($request->ajax())
        {

            $from = $request->get('from');
            $to = $request->get('to');
            $Delegate = $request->get('Delegate');
            $Client = $request->get('Client');

            foreach($Prods as $row){
//
//                <td>
//<button class="btn btn-primary" type="button" data-toggle="modal" data-target="#details" onclick="Comments('.$row->Client.','.$row->Emp.','.$row->Date.')" >'.trans('admin.Comments').'</button>
//</td>
//
//

                if (app()->getLocale() == 'ar') {
                    $emp_name = $row->Emp()->first()->Name;
                    $client_name = $row->Client()->first()->Name;

                } else {
                    $emp_name = $row->Emp()->first()->NameEn;
                    $client_name = $row->Client()->first()->NameEn;

                }


                if ($row->Status == 1) {
                    $status=trans('admin.Postive');
                }else{
                    $status=trans('admin.Negative');

                }
                if ($row->Day == 'Sat') {
                    $day=trans('admin.Sat');
                }elseif($row->Day == 'Sun'){
                    $day=trans('admin.Sun');

                }elseif($row->Day == 'Mon'){
                    $day=trans('admin.Mon');

                }elseif($row->Day == 'Tue'){
                    $day=trans('admin.Tue');

                }elseif($row->Day == 'Wed'){
                    $day=trans('admin.Wed');

                }elseif($row->Day == 'Thu'){
                    $day=trans('admin.Thr');

                }elseif($row->Day == 'Fri'){
                    $day=trans('admin.Fri');

                }







                $output .= '

       <tr>

       <td>
       '.$row->Date.'
       </td>

       <td>
       '.$row->Time.'
       </td>


       <td>
       '.$day.'
       </td>

       <td>
       '.$emp_name.'
       </td>

       <td>
       '.$client_name.'
       </td>

       <td>
       '.$status.'
       </td>


      <td>
       '.$row->Note.'
       </td>


        </tr>
            ';
            }



            return   $output ;
        }
        $ProdsCount=0;
        return view('admin.CRM.DelegateVistsReportFilter',get_defined_vars());
    }

    public function CommentsDetailsFilter(Request $request){

        if($request->ajax())
        {
            $output = '';
            $Client = $request->get('client');
            $Responsible = $request->get('Responsible');
            $Date = $request->get('Date');

            if($Client != '')
            {

                $Customer=Customers::where('Account',$Client)->first();

                $items=CommentsClients::where('Customer',$Customer->id)
                    ->where('Responsible',$Responsible)
                    ->where('Date',$Date)
                    ->get();

            }

            $total_row = $items->count();
            if($total_row > 0)
            {

                foreach ($items as $item) {


                    $output .= '

       <tr>

         <td>' . $item->Comment . '</td>
         <td>' . $item->Date . '</td>
            <td>' . $item->Time . '</td>
         <td>' . $item->Rate . '</td>
         <td>' . $item->Visit_Cost . '</td>
         <td>' . $item->Note . '</td>
         <td>' . $item->Type()->first()->Arabic_Name . '</td>
         <td> <iframe src="https://maps.google.com/maps?q='.$item->lat.','.$item->lng.'&hl=en&z=14&amp;output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe></td>
        </tr>
            ';

                }

            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد  </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }

    }


    //FollowList

    public function FollowList(){
        $items=Employess::type()->paginate(50);

        return view('admin.CRM.FollowList',get_defined_vars());
    }

    public function FollowListEmp($id){
        $emp = $id;
        return view('admin.CRM.FollowListEmp',get_defined_vars());
    }

    public function FollowListSat($id){

        $items=FollowList::where('Emp',$id)->where('Day','Sat')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Sat');
        $AddDay = 'Sat';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListSun($id){

        $items=FollowList::where('Emp',$id)->where('Day','Sun')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Sun');
        $AddDay = 'Sun';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListMon($id){

        $items=FollowList::where('Emp',$id)->where('Day','Mon')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Mon');
        $AddDay = 'Mon';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListTue($id){

        $items=FollowList::where('Emp',$id)->where('Day','Tue')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Tue');
        $AddDay = 'Tue';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListWed($id){

        $items=FollowList::where('Emp',$id)->where('Day','Wed')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Wed');
        $AddDay = 'Wed';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListThr($id){

        $items=FollowList::where('Emp',$id)->where('Day','Thr')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Thr');
        $AddDay = 'Thr';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function FollowListFri($id){

        $items=FollowList::where('Emp',$id)->where('Day','Fri')->paginate(20);
        $Code=$this->ReturnCode(CommentsClients::class);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $emp = $id;
        $DAY = trans('admin.Fri');
        $AddDay = 'Fri';
        return view('admin.CRM.FollowListEmpDay',get_defined_vars());
    }

    public function AddFollowList(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
                'Emp'=>'required',
                'Day'=>'required',
                'Time'=>'required',
                'Client'=>'required',

            ],[


            ]);

            $data['Emp']=request('Emp');
            $data['Day']=request('Day');
            $data['Time']=request('Time');
            $data['Client']=request('Client');
            FollowList::create($data);


            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditFollowList($id){
        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[

                'Time'=>'required',
                'Client'=>'required',

            ],[


            ]);

            $data['Time']=request('Time');
            $data['Client']=request('Client');
            FollowList::where('id',$id)->update($data);


            DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();


        }catch(\Exception $ex){

            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteFollowList($id){

        try {
            DB::beginTransaction();

            $del=FollowList::find($id);



            $del->delete();



            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();

        }catch(\Exception $ex){

            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=FollowList::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



//MyFollowList
    public function MyFollowList(){

        $Day=date('D');

        if($Day == 'Thu'){
            $Day='Thr';
        }

        $Follows=FollowList::where('Emp',auth()->guard('admin')->user()->emp)->where('Day',$Day)->get();

        foreach($Follows as $fol){

            $result=MyFollowList::where('Date',date('Y-m-d'))->where('Emp',auth()->guard('admin')->user()->emp)->where('Client',$fol->Client)->get();

            if(count($result) == 0) {
                $data['Date'] = date('Y-m-d');
                $data['Emp'] = auth()->guard('admin')->user()->emp;
                $data['Day'] = $Day;
                $data['Status'] = 0;
                $data['Client'] = $fol->Client;
                MyFollowList::create($data);
            }
        }


$items=MyFollowList::where('Date',date('Y-m-d'))->where('Emp',auth()->guard('admin')->user()->emp)->where('Status',0)->paginate(100);
        return view('admin.CRM.MyFollowList',get_defined_vars());
    }

//AddCommentToClientFollow
    public function AddCommentFollow($id){
        $Code=$this->ReturnCode(CommentsClients::class);
        $item=MyFollowList::find($id);
        $Rates=CustomersRateTypes::all();
        $Types=InterviewsTypes::all();
        $Clients=Customers::get();
        $customer=Customers::where('Account',$item->Client)->first();
        return view('admin.CRM.AddCommentFollow', get_defined_vars());
    }


    public function AddCommentToClientFollow(){


        try {
            DB::beginTransaction();




            if(!empty(request('ID'))) {
                $id = request('ID');
                MyFollowList::where('id', $id)->update(['Status' => 1]);
            }

            if(!empty(request('CommentEn'))){

                $english_name=request('CommentEn');
            }else{

                $english_name=request('Comment');
            }

            $data['Comment']=request('Comment');
            $data['CommentEn']=$english_name;
            $data['Responsible']=auth()->guard('admin')->user()->emp;
            $data['Customer']=request('Customer');
            $data['Code']=request('Code');
            $data['Date']=request('Date');
            $data['Rate']=request('Rate');
            $data['Visit_Cost']=request('Visit_Cost');
            $data['Note']=request('Note');
            $data['Time']=date('H:i:s');
            $data['Type']=request('Type');
            CommentsClients::create($data);



            $dataUser=[
                'screen_ar'=>'تعليقات العملاء',
                'screen_en'=>'Clients Comments',
                'explain_ar'=>request('Comment'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));

            if(!empty(request('ID'))) {
                return redirect('MyFollowList');
            }else{
                return  back();
            }


        }catch(\Exception $ex){

            $MODEL=CommentsClients::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=CommentsClients::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }


    
    //DealsAnalysis
      public function DealsAnalysis(){

             $customersCount = DB::table('customers')->count();
    
     $customers = DB::table('customers')

            ->leftJoin('comments_clients', 'customers.id', '=', 'comments_clients.Customer')

            ->groupBy('customers.id', 'customers.Name', 'customers.Date')
            ->select(
                'customers.id',
                'customers.Name',

                DB::raw('TRUNC(EXTRACT(EPOCH FROM (CAST(MIN("comments_clients"."Date") AS timestamp) - CAST("customers"."Date" AS timestamp))) / 86400) AS days_until_first_comment')
            )
            ->get()->sum('days_until_first_comment');
    
  
    
    
    $AvgAddDateFirstComment=$customers/$customersCount;
    
    
    
         $Salescustomers = DB::table('customers')

            ->leftJoin('sales', 'customers.Account', '=', 'sales.Client')

            ->groupBy('customers.id', 'customers.Name', 'customers.Date')
            ->select(
                'customers.id',
                'customers.Name',

                DB::raw('TRUNC(EXTRACT(EPOCH FROM (CAST(MIN("sales"."Date") AS timestamp) - CAST("customers"."Date" AS timestamp))) / 86400) AS days_until_first_bill')
            )
            ->get()->sum('days_until_first_bill');
    
    
    
    
    $AvgAddDateFirstBill=$Salescustomers/$customersCount;
        
    
         $Operatingcustomers = DB::table('customers')

 ->groupBy('id', 'Name', 'Date')
            ->select(
                'id',
                'Name',

                DB::raw('TRUNC(EXTRACT(EPOCH FROM (CAST(MIN("Operating_Date") AS timestamp) - CAST("Date" AS timestamp))) / 86400) AS days_until_first_operating')
            )
            ->get()->sum('days_until_first_operating');
    
    
    
    
    $AvgAddDateFirstOperating=$Operatingcustomers/$customersCount;
    
    
    
    
    
    //nsbt el 3omlaa el hkikya 
    
             $SalescustomersBillCount = DB::table('customers')
            ->leftJoin('sales', 'customers.Account', '=', 'sales.Client')
             ->distinct(['sales.Client'])
            ->count();
    
    
    $PRECENTCLIENT=($SalescustomersBillCount / $customersCount ) * 100 ;
    
    
    
    //Afdl mwzf maby3n 
  $bestEmpSales = DB::table('employesses')
     
            ->leftJoin('sales', 'employesses.id', '=', 'sales.Delegate')
       
            ->groupBy('employesses.id', 'employesses.Name')
       
            ->select(
                'employesses.id',
                'employesses.Name',
                // نستخدم COALESCE لتحويل أي قيمة NULL في 'Total_Net' إلى 0.
                // ثم نقوم بتحويل القيمة إلى نوع NUMERIC (رقمي) قبل الجمع.
                // هذا يضمن أن دالة SUM ستعمل على الأرقام فقط.
              DB::raw('SUM(CAST(COALESCE("sales"."Total_Net", \'0\') AS NUMERIC)) as total_sales')
            )
            ->orderByDesc('total_sales')
            ->first();

    
    //Aktr mwzf 3aml fwater 

        $employeeInvoices = DB::table('employesses')
            ->leftJoin('sales', 'employesses.id', '=', 'sales.Delegate')

            ->groupBy('employesses.id', 'employesses.Name')
  
            ->select(
                'employesses.id',
                'employesses.Name',
                // نستخدم الدالة COUNT() لعد الفواتير.
                // يتم تجاهل الفواتير التي تحتوي على قيمة NULL.
                DB::raw('COUNT("sales"."id") as invoice_count')
            )

            ->orderByDesc('invoice_count')
            ->first();

      //Aktr mwzf 3aml t3lekat
    
           $employeeComments = DB::table('employesses')
            ->leftJoin('comments_clients', 'employesses.id', '=', 'comments_clients.Responsible')

            ->groupBy('employesses.id', 'employesses.Name')
  
            ->select(
                'employesses.id',
                'employesses.Name',
                // نستخدم الدالة COUNT() لعد الفواتير.
                // يتم تجاهل الفواتير التي تحتوي على قيمة NULL.
                DB::raw('COUNT("comments_clients"."id") as comment_count')
            )

            ->orderByDesc('comment_count')
            ->first();
    
    
    
        //Afdl Mnsa maby3n 
 
     $bestPlatform = DB::table('customers')
   
            ->join('platforms', 'customers.Platform', '=', 'platforms.id')
        
            ->leftJoin('sales', 'customers.Account', '=', 'sales.Client')

            ->groupBy('platforms.id', 'platforms.Arabic_Name')
            ->select(
                'platforms.id',
                'platforms.Arabic_Name',
                DB::raw('SUM(CAST(COALESCE("sales"."Total_Net", \'0\') AS NUMERIC)) as total_sales')
            )

            ->orderByDesc('total_sales')
            ->limit(3)
            ->get();    
    
        //Afdl 7amlat maby3n 
 
     $bestCampaigns = DB::table('customers')
   
            ->join('campaigns', 'customers.Campagin', '=', 'campaigns.id')
        
            ->leftJoin('sales', 'customers.Account', '=', 'sales.Client')

            ->groupBy('campaigns.id', 'campaigns.Arabic_Name')
            ->select(
                'campaigns.id',
                'campaigns.Arabic_Name',
                DB::raw('SUM(CAST(COALESCE("sales"."Total_Net", \'0\') AS NUMERIC)) as total_sales')
            )

            ->orderByDesc('total_sales')
            ->limit(3)
            ->get();
          
          
          //
          $SolvedTickets=CustomersTickets::where('Status',2)->count();
          $UnSolvedTickets=CustomersTickets::where('Status',1)->count();
          
          
  
        return view('admin.CRM.DealsAnalysis',get_defined_vars());
    }

        
        //TicketReport
          public function TicketReport(){

  
        return view('admin.CRM.TicketReport',get_defined_vars());
    }


    
    public function TicketReportFilter(){

        $From=request('From');
        $To=request('To');
        $Customer=request('Customer');
        $Responsible=request('Responsible');



        $items=CustomersTickets::whereBetween('Date',[$From,$To])

            ->when(!empty($Responsible), function ($query) use ($Responsible) {
                return $query->where('Responsible',$Responsible);

            })



            ->when(!empty($Customer), function ($query) use ($Customer) {
                return $query->where('Customer',$Customer);

            })


            ->paginate(100);

  $items->appends(request()->query());

        return view('admin.CRM.TicketReportFilter',get_defined_vars());
    }



        //CommentCustomersReport

             public function CommentCustomersReport(){

  
        return view('admin.CRM.CommentCustomersReport',get_defined_vars());
    }


        public function CommentCustomersReportFilter(){

        $From=request('From');
        $To=request('To');
        $Customer=request('Customer');


            $item=Customers::find($Customer);


        $items=CommentsClients::whereBetween('Date',[$From,$To])

        

            ->when(!empty($Customer), function ($query) use ($Customer) {
                return $query->where('Customer',$Customer);

            })


            ->paginate(100);
            
            
        $visit=CommentsClients::orderBy('id','desc')
            ->where('Customer',$item->id)

            ->count();

        $billNum=Sales::orderBy('id','desc')
            ->where('Client',$item->Account)
            ->count();

        $billTot=Sales::orderBy('id','desc')
            ->where('Client',$item->Account)
            ->get()->sum('Total_Price');        
            

  $items->appends(request()->query());

        return view('admin.CRM.CommentCustomersReportFilter',get_defined_vars());
    }

   


}
