<?php

namespace App\Http\Controllers;

use App\Http\Resources\ECom\BrandsResources;
use App\Http\Resources\ECom\AboutResources;
use App\Http\Resources\ECom\ArticlesDetailsResources;
use App\Http\Resources\ECom\ArticlesResources;
use App\Http\Resources\ECom\CartStoreResources;
use App\Http\Resources\ECom\CategoriesResources;
use App\Http\Resources\ECom\CompareResources;
use App\Http\Resources\ECom\ContactUSResources;
use App\Http\Resources\ECom\CountriesResources;
use App\Http\Resources\ECom\FaqResources;
use App\Http\Resources\ECom\MyAddressesResources;
use App\Http\Resources\ECom\MyOrdersResources;
use App\Http\Resources\ECom\ProductsDetResources;
use App\Http\Resources\ECom\ProductsResources;
use App\Http\Resources\ECom\ProfileResources;
use App\Http\Resources\ECom\SocialResources;
use App\Http\Resources\ECom\TermsResources;
use App\Http\Resources\ECom\WebsliderResources;
use App\Http\Resources\ECom\WishlistResources;
use App\Http\Resources\DBResources;
use App\Http\Resources\ArEnNameResources;
use App\Http\Resources\ProductsSelectResources;
use App\Http\Resources\BillNumbersResources;
use App\Http\Resources\CustomersCRMResources;
use App\Http\Resources\ClientRequestsResources;
use App\Services\Average;
use App\Traits\GeneralTrait;
use Illuminate\Http\Request;
use App\Models\TicektIssues;
use App\Models\CustomersRateTypes;
use App\Models\Admin;
use App\Models\UsersMoves;
use App\Models\Taxes;
use App\Models\Interviews;
use App\Models\InterviewsTypes;
use App\Models\Employess;
use App\Models\Sales;
use App\Models\Activites;
use App\Models\City;
use App\Models\Governrate;
use App\Models\Platforms;
use App\Models\Campaigns;
use App\Models\ClientStatus;
use App\Models\Customers;
use App\Models\AcccountingManual;
use App\Models\CustomersTickets;
use App\Models\ProductSales;
use App\Models\CompanyData;
use App\Models\Shifts;
use App\Models\SalesDefaultData;
use App\Models\CrmDefaultData;
use App\Models\EmpPOSStores;
use App\Models\GeneralDaily;
use App\Models\Addressses;
use App\Models\SalesOrder;
use App\Models\ExportChecks;
use App\Models\ProductUnits;
use App\Models\ProductsQty;
use App\Models\Products;
use App\Models\ProductsPurchases;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductsStartPeriods;
use App\Models\OutcomManufacturingModel;
use App\Models\ProductSalesOrder;
use App\Models\Stores;
use App\Models\Brands;
use App\Models\DefaultDataShowHide;
use App\Models\StoreCountSales;
use App\Models\Coins;
use App\Models\ProductMoves;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\PaymentVoucher;
use App\Models\SafesBanks;
use App\Models\PaymentVoucherDetails;
use App\Models\CommentsClients;
use App\Models\ReturnSales;
use App\Models\ReturnSalesProducts;
use App\Models\InsurancePaper;
use App\Models\Assets;
use App\Models\Measuerments;
use App\Models\ClientFilter;
use App\Models\ExecutorFilter;
use App\Models\GroupFilter;
use App\Models\ItemsGroups;
use App\Models\ReturnPurchProducts;
use App\Models\StorsTransfers;
use App\Models\ReturnStorsTransfer;
use App\Models\ReciptMaintaince;
use App\Models\ReturnMaintainceBill;
use App\Models\DepartureEmp;
use App\Models\Borrowa;
use App\Models\EmpsProducationPoint;
use App\Models\EmpsProducationQuantity;
use App\Models\PaySalary;
use App\Models\Settlement;
use App\Models\EmpRatio;
use App\Models\Deduction;
use App\Models\Entitlement;
use App\Models\EmpInstallmentDetails;
use App\Models\RegOverTime;
use App\Models\Holidays;
use App\Models\AllowencesEmp;
use App\Models\DiscountsEmp;
use App\Models\FAQ;
use App\Models\Polices;
use App\Models\Terms;
use App\Models\Articles;
use App\Models\ContactUS;
use App\Models\SocialMedia;
use App\Models\About;
use App\Models\Webslider;
use App\Models\Countris;
use App\Models\Coin;
use App\Models\CouponCode;
use App\Models\CustomersGroup;
use App\Models\SubImages;
use App\Models\Comments;
use App\Models\ProductsVira;
use App\Models\SubVirables;
use App\Models\Rate;
use App\Models\Purchases;
use App\Models\ReturnPurch;
use App\Models\SafeTransfers;
use App\Models\SalesPetrol;
use App\Models\IncomChecks;
use App\Models\Ticket;
use App\Models\Loan;
use App\Models\ProductSettlement;
use App\Models\TicketProducts;
use App\Models\ProductMaintaincBill;
use App\Models\InstallmentCompaniesRatios;
use App\Models\InstallmentDates;
use App\Models\InstallmentCompanies;
use App\Models\Wishlist;
use App\Models\Compare;
use App\Models\Missions;
use App\Models\StoresDefaultData;
use App\Models\AccountsDefaultData;
use App\Models\PurchasesDefaultData;
use App\Models\Intro;
use App\Models\RabihEducation;
use App\Models\Modules;
use App\Models\ReportsSettings;
use App\Models\StoresMoves;
use App\Models\Vendors;
use App\Models\VAPrice;
use App\Models\ResturantSliders;
use App\Models\ResturantBlogs;
use App\Models\ResturantSocial;
use App\Models\ResturantPrivacy;
use App\Models\ResturantTerms;
use App\Models\ResturantCuponCode;
use App\Models\ResturantGallery;
use App\Models\ResturantReviews;
use App\Models\ResturantReservations;
use App\Models\ResturantStyle;
use App\Models\ResturantHome;
use App\Models\ResturantAbout;
use App\Models\ResturantVideoSection;
use App\Models\ResturantTables;
use App\Models\Notifications;
use App\Models\Quote;
use App\Models\ProductsQuote;
use App\Models\Event;
use App\Models\AssemblyProducts;
use App\Models\MoreProductsHall;
use App\Models\RemoveProductsHall;
use App\Models\CartStore;
use App\Models\ModuleSettingsNum;
use App\Models\CustomerCommentsProducts;
use App\Models\ClientRequests;
use App\Models\ProductsClientRequests;
    use App\Services\SalesService;
use DB ;
use Str ;
use URL ;
use Mail ;
use Hash ;
use Validator ;
use DateTime ;
use File;
use App\Mail\AdminResetPasswordApi;
use Spatie\DbDumper\Databases\PostgreSql;

class ApiController extends Controller
{


    use GeneralTrait;
    public function __construct(Request $request) {

        $header =!empty( $request->header('lang')) ? $request->header('lang') : "ar";
        app()->setLocale($header);

    }



    //==========  E-Commerce =========================================================================================


    //==========================  Auth =======================================


    //UserLogin
    public function UserLogin(Request $request){


        $rules = [
            "email" => "required",
            "password" => "required"

        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            $code = $this->returnCodeAccordingToInput($validator);
            return $this->returnValidationError($code, $validator);
        }



        $rememberme = request('rememberme') == 1?true:false;

        if(auth()->guard('client')->attempt(['email'=>request('email'),'password'=>request('password')],$rememberme)){


            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';
            for ($i = 0; $i < 100 ; $i++) {
                $randomString .= $characters[rand(0, $charactersLength - 1)];
            }

            $ad=Customers::where('email',request('email'))->first();

            Customers::where('id',$ad->id)->update(['token'=>$randomString]);


            $Admin=Customers::where('email',request('email'))->first();
            $data=ProfileResources::make($Admin);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),

            ];

            return $data->additional($x) ;



        }else{

            return response()->json([
                'status'=>401,
                'message'=>trans('admin.incorrect_information_login'),
            ]);

        }

    }

    //User TokenCheck
    public function UserTokenCheck(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();

        if(!empty($admin)){

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>1,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
                'data'=>null,
            ]);

        }






    }


    //User Forget Password
    public function Userforgotpasswordapi(){
        $admin = Customers::where('email',request('email'))->first();
        if(!empty($admin)){

            $code=rand(10,10000);
            Customers::where('id',$admin->id)->update(['code'=>$code]);

            Mail::to($admin->email)->send(new AdminResetPasswordApi(['data'=>$admin,'code'=>$code]));

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Code_Send'),
                'data'=> ['code'=> $code,'email'=>$admin->email],

            ]);


        }else{


            return response()->json([
                'status'=>401,
                'message'=>trans('admin.WrongEmail'),
            ]);

        }


    }

    //User VerifyCode
    public function UserVerifyCode(){
        $admin = Customers::where('email',request('email'))->first();

        if($admin->code == request('code')){

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Code_Success'),

            ]);


        }else{

            return response()->json([
                'status'=>401,
                'message'=>trans('admin.WrongCode'),
            ]);

        }


    }

    //User ResetPasswordApi
    public function UserResetPasswordApi(){

        try {

            DB::beginTransaction();
            $admin = Customers::where('email',request('email'))->first();

            Customers::where('id',$admin->id)->update(['password'=>bcrypt(request('new_password')),'code'=>null]);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.success_reset'),

            ]);

        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }

    }

    //User LogoutApi
    public function UserLogoutApi(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();

        Customers::where('id',$admin->id)->update(['token'=>null]);

        return $this->returnSuccessMessage(trans('admin.LogoutSuccess'));


    }


    //UserRegister
    public function UserRegister(Request $request){

        try {

            DB::beginTransaction();

            $validator = Validator::make($request->all(), [
                'Name'=>'required',
                'email'=>'required|email|unique:customers',
                'Phone'=>'required|unique:customers',
                'password'=>'required|min:6',
            ],[
                'Phone.required' => trans('admin.PhoneRequired'),
                'Name.required' => trans('admin.nameRequired'),
                'email.required' => trans('admin.emailRequired'),
                'email.email' =>trans('admin.emailEmail'),
                'email.unique' =>trans('admin.emailUnique'),
                'password.required' =>trans('admin.passwordRequired'),
                'password.min' => trans('admin.passwordmin_6'),


            ]);

            if ($validator->fails()) {


                return response()->json([
                    'status'=>400,
                    'message'=>$validator->errors()->all(),
                ]);


            }


            $Acc=$this->CreateAccountApi(request('Name'),request('Name') ,24 ,null,1);
            $CCODE=$this->ReturnCode(Customers::class);


            $data['Code']=$CCODE;
            $data['Date']=date('Y-m-d');
            $data['Name']=request('Name');
            $data['NameEn']=request('Name');
            $data['Price_Level']=1;
            $data['Phone']=request('Phone');
            $data['email']=request('email');
            $data['password']=bcrypt(request('password'));
            $data['country']=request('country');
            $data['Account']=$Acc;
            Customers::create($data);

            DB::commit();



            $Admin=Customers::where('email',request('email'))->first();

            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';
            for ($i = 0; $i < 100 ; $i++) {
                $randomString .= $characters[rand(0, $charactersLength - 1)];
            }

            Customers::where('id',$Admin->id)->update(['token'=>$randomString]);




            $data=ProfileResources::make($Admin);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),

            ];

            return $data->additional($x) ;



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }


    //=================================================================


    //==========================  Profile =======================================

    //Profile
    public function Profile(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

        $data=ProfileResources::make($admin);

        return $this->returnData('data', $data);

    }

    public function UpdateMyAccount(Request $request){
        try {

            DB::beginTransaction();

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
            $validator = Validator::make($request->all(), [
                'Name'=>'required',
                'email'=>'required|email|unique:customers,email,'.$admin->id,
                'Phone'=>'required|unique:customers,Phone,'.$admin->id,
            ],[
                'Name.required' => trans('admin.nameRequired'),
                'country.required' => trans('admin.countryRequired'),
                'email.required' => trans('admin.emailRequired'),
                'email.email' =>trans('admin.emailEmail'),
                'email.unique' =>trans('admin.emailUnique'),

            ]);


            if ($validator->fails()) {


                return response()->json([
                    'status'=>400,
                    'message'=>$validator->errors()->all(),
                ]);


            }


            $data['Name']=request('Name');
            $data['NameEn']=request('Name');
            $data['Phone']=request('Phone');
            $data['email']=request('email');
            $data['country']=request('country');
            Customers::where('id',$admin->id)->update($data);

        DB::commit();

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Updated'),
            ]);


    } catch (\Exception $ex) {

DB::rollback();
return $this->returnError($ex->getMessage().' '.$ex->getLine());

}catch (\Error $ex) {
    DB::rollback();
    return $this->returnError($ex->getMessage().' '.$ex->getLine());
}




    }

    public function UpdateMyPassword(Request $request){

        try {

            DB::beginTransaction();

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
            $validator = Validator::make($request->all(), [
                'password'=>'required|min:6|same:Confirm_Password',
            ],[
                'password.required' =>trans('admin.passwordRequired'),
                'password.min' => trans('admin.passwordmin_6'),
                'password.same' => trans('admin.passwordsame'),

            ]);

            if ($validator->fails()) {


                return response()->json([
                    'status'=>400,
                    'message'=>$validator->errors()->all(),
                ]);


            }


            $user= Customers::find($admin->id);



            if (Hash::check(request('CurrentPassword'), $user->password)) {

                $data['password']=bcrypt(request('password'));

                Customers::where('id',$admin->id)->update($data);

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Updated'),
                ]);

            }else{

                return response()->json([
                    'status'=>400,
                    'message'=>trans('admin.CurrentPassWrong'),
                ]);
            }


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    //MyAddresses
    public function MyAddresses(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

            $Addresses=Addressses::where('Customer',$admin->id)->get();

        $data=MyAddressesResources::collection($Addresses);

        return $this->returnData('data', $data);





    }

    public function AddAddress(Request $request){

        try {

            DB::beginTransaction();

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();

            $validator = Validator::make($request->all(), [
                'address_name'=>'required',
                'governrate'=>'required',
                'city'=>'required',
                'place'=>'required',

            ]);


            if ($validator->fails()) {


                return response()->json([
                    'status'=>400,
                    'message'=>$validator->errors()->all(),
                ]);


            }




            $Addr['Address_Name']=request('address_name');
            $Addr['Street']=request('street');
            $Addr['Special_Mark']=request('special_mark');
            $Addr['Buliding']=request('buliding');
            $Addr['Floor']=request('floor');
            $Addr['Flat']=request('flat');
            $Addr['Details']=request('details');
            $Addr['Location']=request('location');
            $Addr['Governrate']=request('governrate');
            $Addr['City']=request('city');
            $Addr['Place']=request('place');
            $Addr['Customer']=$admin->id;
            Addressses::create($Addr);


            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),

            ]);

    } catch (\Exception $ex) {

DB::rollback();
return $this->returnError($ex->getMessage().' '.$ex->getLine());

}catch (\Error $ex) {
    DB::rollback();
    return $this->returnError($ex->getMessage().' '.$ex->getLine());
}



    }

    public function DeleteAddress(Request $request){


        try {

            DB::beginTransaction();


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

            Addressses::where('id',request('address_id'))->delete();

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.delete'),

            ]);

        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }

    public function EditAddressClient(Request $request){

        try {

            DB::beginTransaction();

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');


            $Addr['Address_Name']=request('address_name');
            $Addr['Street']=request('street');
            $Addr['Special_Mark']=request('special_mark');
            $Addr['Buliding']=request('buliding');
            $Addr['Floor']=request('floor');
            $Addr['Flat']=request('flat');
            $Addr['Details']=request('details');
            $Addr['Location']=request('location');
            $Addr['Governrate']=request('governrate');
            $Addr['City']=request('city');
            $Addr['Place']=request('place');
            $Addr['Customer']=$admin->id;

            Addressses::where('id',request('address_id'))->update($Addr);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Updated'),

            ]);

        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }


    //MyOrder
    public function MyOrder(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();

            $Orders=SalesOrder::where('Client',$admin->Account)->paginate(12);
        $data=MyOrdersResources::collection($Orders);


$x=[
'status'=>200,
'msg'=>trans('admin.Success'),
];

return $data->additional($x) ;



    }




    //=================================================================


    //==========================  View =======================================

    //Webslider
        public function Webslider(Request $request){

            $types=Webslider::where('Status',1)->where('Type',1)->get();
            $data=WebsliderResources::collection($types);
            return $this->returnData('data', $data);


        }

    //About
        public function About(Request $request){

            $item=About::orderBy('id','desc')->first();
            $data=AboutResources::make($item);
            return $this->returnData('data', $data);


        }

    //Social

        public function Social(Request $request){

            $item=SocialMedia::orderBy('id','desc')->first();

            $data=SocialResources::make($item);
            return $this->returnData('data', $data);


        }

    //ContactUS
        public function ContactUS(Request $request){

            $item=ContactUS::orderBy('id','desc')->first();
            $data=ContactUSResources::make($item);
            return $this->returnData('data', $data);

        }

    //Articles
        public function Articles(Request $request){

            $items=Articles::paginate(12);


            $data=ArticlesResources::collection($items);


            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;



        }

        //Articles_Details
        public function Articles_Details(Request $request){

            $item=Articles::find(request('article_id'));
            $data=ArticlesDetailsResources::make($item);
            return $this->returnData('data', $data);

        }


    //Terms
        public function Terms(Request $request){

            $item=Terms::orderBy('id','desc')->first();
            $data=TermsResources::make($item);
            return $this->returnData('data', $data);


        }

    //Polices
        public function Polices(Request $request){

            $item=Polices::orderBy('id','desc')->first();
            $data=TermsResources::make($item);
            return $this->returnData('data', $data);


        }

    //FAQ
        public function FAQ(Request $request){

            $items=FAQ::all();
            $data=FaqResources::collection($items);
            return $this->returnData('data', $data);


        }

    //Countries
        public function Countries(Request $request){

            $items=DB::table('countris')->get();
            $data=CountriesResources::collection($items);
            return $this->returnData('data', $data);


        }

    //Categories
        public function Categories(Request $request){

            $groups=DB::table('items_groups')->whereIn('Store_Show',[1,3])->get();
            $data=CategoriesResources::collection($groups);
            return $this->returnData('data', $data);

        }

    //BrandsE
        public function BrandsE(Request $request){

            $groups=DB::table('brands')->whereIn('Store_Show',[1,3])->get();
            $data=BrandsResources::collection($groups);
            return $this->returnData('data', $data);

        }


    //=================================================================



    //============================= Products ====================================

        //ProductsE
        public function ProductsE(Request $request){

            $Products=Products::whereIn('Store_Show',[1,3])
                ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])->paginate(9);

            $data=ProductsResources::collection($Products);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;



        }

        //LastProductsE
        public function LastProductsE(Request $request){


            $Products=Products::whereIn('Store_Show',[1,3])
                ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                ->latest('id')->paginate(9);


            $data=ProductsResources::collection($Products);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;



        }

         //ProductDetails
        public function ProductDetails(Request $request){

            $pro=Products::find(request('product_id'));
            $data=ProductsDetResources::make($pro);
            return $this->returnData('data', $data);

        }

        //Comments  ===================
        public function AddCommentApi(Request $request){

            try {

                DB::beginTransaction();

                $rules = [
                    "comment" => "required",
                    "product_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }



                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }
                $admin=Customers::where('token',$x)->first();

                $data['Product']=request('product_id');
                $data['User']=$admin->id;
                $data['Comment']=request('comment');
                $data['Date']=date('Y-m-d');
                Comments::create($data);

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),
                ]);

            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }



        }

        public function EditCommentApi(Request $request){

            try {

                DB::beginTransaction();

                $rules = [
                    "comment" => "required",
                    "comment_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }


                Comments::where('id',request('comment_id'))->update(['Comment'=>request('comment')]);
                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),
                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }


        }

        public function DeleteCommentApi(Request $request){

            try {

                DB::beginTransaction();

                $del=Comments::find(request('comment_id'));
                $del->delete();
                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Deleted'),
                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }







        }

        //Rate  ===========================
        public function AddRateApi(Request $request){

            try {

                DB::beginTransaction();

                $rules = [
                    "rate" => "required",
                    "product_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }


                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }

                $admin=Customers::where('token',$x)->first();


                $data['Product']=request('product_id');
                $data['User']=$admin->id;
                $data['Rate']=request('rate');
                Rate::create($data);

                $count=Rate::where('Product',request('product_id'))->count();
                $Sumcount=Rate::where('Product',request('product_id'))->get()->sum('Rate');

                $result= $Sumcount / $count ;
                Products::where('id',request('product_id'))->update(['rate'=>$result]);

                DB::commit();

                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),
                ]);




            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }





        }

        public function EditRateApi(Request $request){

            try {

                DB::beginTransaction();

                $rules = [
                    "rate" => "required",
                    "product_id" => "required",
                    "rate_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }



                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }

                $admin=Customers::where('token',$x)->first();


                $data['Rate']=request('rate');
                Rate::where('id',request('rate_id'))->update($data);

                $count=Rate::where('Product',request('product_id'))->count();
                $Sumcount=Rate::where('Product',request('product_id'))->get()->sum('Rate');

                $result= $Sumcount / $count ;
                Products::where('id',request('product_id'))->update(['rate'=>$result]);
                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),
                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }






        }


        //Wishlist =========================
        public function Wishlist(Request $request){

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Customers::where('token',$x)->first();

            $Wishs=Wishlist::where('User',$admin->id)->get();
            $data=WishlistResources::collection($Wishs);
            return $this->returnData('data', $data);


        }

        public function AddWish(Request $request){

            try {

                DB::beginTransaction();

                $rules = [

                    "product_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }


                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }

                $admin=Customers::where('token',$x)->first();


                $Addr['Product']=request('product_id');
                $Addr['User']=$admin->id;
                Wishlist::create($Addr);

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),

                ]);



            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }

        public function DeleteWish(Request $request){

            try {

                DB::beginTransaction();


                Wishlist::where('id',request('wish_id'))->delete();

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.delete'),

                ]);



            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }


        //Compare  ========================
        public function ComparePage(Request $request){


            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }
            $admin=Customers::where('token',$x)->first();
            $lang = $request->header('lang', '');

            $Comps=Compare::where('User',$admin->id)->orderBy('id','desc')->get();
            $data=CompareResources::collection($Comps);
            return $this->returnData('data', $data);



        }

        public function AddCompare(Request $request){

            try {

                DB::beginTransaction();

                $rules = [

                    "product_id" => "required",
                ];

                $validator = Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    $code = $this->returnCodeAccordingToInput($validator);
                    return $this->returnValidationError($code, $validator);
                }



                $header = $request->header('Authorization', '');
                if (Str::startsWith($header, 'Bearer ')) {
                    $x=Str::substr($header, 7);
                }

                $admin=Customers::where('token',$x)->first();
                $lang = $request->header('lang', '');


                $Addr['Product']=request('product_id');
                $Addr['User']=$admin->id;

                Compare::create($Addr);

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),

                ]);



            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }

        public function DeleteCompare(Request $request){


            try {

                DB::beginTransaction();


                Compare::where('id',request('comp_id'))->delete();

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.delete'),

                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }




        //=================================================================



        //==========================  Filters =======================================


        //Filter Products
        public function FilterProductGroup(Request $request){

            $Products=Products::whereIn('Store_Show',[1,3])
                ->where('Group',request('group_id'))
                ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                ->orderBy('id','desc')->get();

            $data=ProductsResources::collection($Products);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;


        }

        public function FilterProductBrand(Request $request){

            $Products=Products::whereIn('Store_Show',[1,3])
                ->where('Brand',request('brand_id'))
                ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                ->orderBy('id','desc')->get();

            $data=ProductsResources::collection($Products);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;


        }

        public function FilterProductName(Request $request){

            $search=request('search_name');
            $Products=Products::whereIn('Store_Show',[1,3])
                ->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                ->orderBy('id','desc')->get();

            $data=ProductsResources::collection($Products);
            $x=[
                'status'=>200,
                'msg'=>trans('admin.Success'),
            ];

            return $data->additional($x) ;


        }


        //GovernrateE
        public function GovernrateE(Request $request){

            $lang = $request->header('lang', '');
            if($lang == 'ar'){
                $govs=DB::table('governrates')
                    ->where('Country',request('country_id'))
                    ->select('Arabic_Name as name','id as id')
                    ->get();
            }else{
                $govs=DB::table('governrates')
                    ->where('Country',request('country_id'))
                    ->select('English_Name as name','id as id')
                    ->get();

            }



            return response()->json([
                'status'=>200,
                'msg'=>trans('admin.Success'),
                'data'=>$govs,

            ]);


        }

        //CiteiesE
        public function CiteiesE(Request $request){

            $lang = $request->header('lang', '');

            if($lang == 'ar'){
                $govs=DB::table('cities')
                    ->where('Gov',request('gov'))
                    ->select('cities.Arabic_Name as name','cities.id as id','cities.Ship_Price  as shipping')
                    ->get();
            }else{
                $govs=DB::table('cities')
                    ->where('Gov',request('gov'))
                    ->select('cities.English_Name as name','cities.id as id','cities.Ship_Price  as shipping')
                    ->get();

            }

            return response()->json([
                'status'=>200,
                'msg'=>trans('admin.Success'),
                'data'=>$govs,

            ]);

        }

        //PlacesE
        public function PlacesE(Request $request){


            $lang = $request->header('lang', '');

            if($lang == 'ar'){
                $govs=DB::table('places')
                    ->where('City',request('city'))
                    ->select('places.Arabic_Name as name','places.id as id','places.Ship_Price  as shipping')
                    ->get();
            }else{
                $govs=DB::table('places')
                    ->where('City',request('city'))
                    ->select('places.English_Name as name','places.id as id','places.Ship_Price  as shipping')
                    ->get();

            }

            return response()->json([
                'status'=>200,
                'msg'=>trans('admin.Success'),
                'data'=>$govs,

            ]);


        }

        //Av Qty
        public function  AvQtyCompleted(Request $request) {


            $CODE = $request->get('product_code');
            $STORE = $request->get('store');
            $PRODUCT = $request->get('product_id');

            $QTY=$this->ProAvQties($STORE,$PRODUCT,$CODE);

            if(!empty($QTY)){

                $AvQty=$QTY->Qty;
                $Code=$QTY->P_Code;

            }else{
                $AvQty=0;
                $Code='';


            }


            return response()->json([
                'status'=>200,
                'msg'=>trans('admin.Success'),
                'qty'=>$AvQty,
                'code'=>$Code,
            ]);



        }

        public function  AvQtyV(Request $request) {

            $V = $request->get('virable');
            $STORE = $request->get('store');
            $PRODUCT = $request->get('product_id');

            $QTY=ProductsQty::
            where('Product',$PRODUCT)
                ->where('Store',$STORE)
                ->where('V1',$V)
                ->first();

            if(!empty($QTY)){

                $AvQty=$QTY->Qty;
                $Code=$QTY->P_Code;
                $price=$QTY->Price_Sale;
            }else{
                $AvQty=0;
                $Code='';
                $price=0;
            }

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'qty'=>$AvQty,
                'code'=>$Code,
                'price'=>$price,
            ]);




        }

        public function  AvQtyVV(Request $request) {

            $V = $request->get('virable');
            $VV = $request->get('virable_two');
            $STORE = $request->get('store');
            $PRODUCT = $request->get('product_id');


            $QTY=ProductsQty::
            where('Product',$PRODUCT)
                ->where('Store',$STORE)
                ->where('V1',$V)
                ->where('V2',$VV)
                ->first();

            if(!empty($QTY)){

                $AvQty=$QTY->Qty;
                $Code=$QTY->P_Code;
                $price=$QTY->Price_Sale;
            }else{
                $AvQty=0;
                $Code='';
                $price=0;
            }


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'qty'=>$AvQty,
                'code'=>$Code,
                'price'=>$price,
            ]);




        }


    //=================================================================



    //============================ Cart and Checkout =====================================



//CartPage
    public function CartPage(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }
        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

        $Comps=CartStore::where('User',$admin->id)->orderBy('id','desc')->get();
        $data=CartStoreResources::collection($Comps);
        return $this->returnData('data', $data);



    }

    public function AddCart(Request $request){

        try {

            DB::beginTransaction();

            $rules = [

                "product_id" => "required",
                "qty" => "required",
                "price" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Customers::where('token',$x)->first();

            $pro=Products::find(request('product_id'));
            $Addr['Product']=request('product_id');
            $Addr['Name']=$pro->P_Ar_Name;
            $Addr['NameEn']=$pro->P_En_Name;
            $Addr['V_Name']=request('v_name');
            $Addr['VV_Name']=request('vv_name');
            $Addr['P_Code']=request('product_code');
            $Addr['AvQty']=request('av_qty');
            $Addr['Qty']=request('qty');
            $Addr['Price']=request('price');
            $Addr['Image']=$pro->Image;
            $Addr['Total']=request('qty') * request('price');
            $Addr['User']=$admin->id;

            CartStore::create($Addr);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),

            ]);



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    public function UpdateCart(Request $request){

        try {

            DB::beginTransaction();

            $rules = [

                "cart_id" => "required",
                "qty" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }


            $cart=CartStore::find(request('cart_id'));

if($cart->AvQty < request('qty')){

    DB::rollback();
    return response()->json([
        'status'=>404,
        'message'=>trans('admin.AvQty_NotEnough'),
    ]);



}

            $Addr['Qty']=request('qty');
            $Addr['Total']=request('qty') * $cart->Price;
            CartStore::where('id',request('cart_id'))->update($Addr);

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),

            ]);



        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    public function DeleteCart(Request $request){


        try {

            DB::beginTransaction();


            CartStore::where('id',request('cart_id'))->delete();

            DB::commit();
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.delete'),

            ]);


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }



    //TestCuponCode
    public function TestCuponCode(Request $request){


        try {

            DB::beginTransaction();

            $rules = [

                "code" => "required",

            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }

            $i=CouponCode::where('Code',request('code'))->first();

            if(!empty($i->id)){

                if($i->Status == 1){

                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }elseif($i->Expire < date('Y-m-d')){


                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }else{


                    if(request('code') != NULL){

                        $y=$i->Used + 1 ;

                        if($y == $i->Num){

                            $Status=1;
                        }else{

                            $Status=0;
                        }
                        CouponCode::where('id',$i->id)->update(['Used'=>$y,'Status'=>$Status]);

                    }

                    DB::commit();
                    return response()->json([
                        'status'=>200,
                        'message'=>trans('admin.Correct_Code'),
                        'discount'=>$i->Amount,
                    ]);

                }


            }else{


                return response()->json([
                    'status'=>400,
                    'message'=>trans('admin.Wrong_Code'),
                ]);


            }




        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }




    }


    //PlaceOrder
         public function PlaceOrder(Request $request,Average $average){

             try {

                 DB::beginTransaction();


                 $rules = [

                     "product_numbers" => "required",
                     "total_qty" => "required",
                     "total_price" => "required",
                     "cupon_code" => "required",
                     "shipping" => "required",
                     "name" => "required",
                     "email" => "required",
                     "phone" => "required",
                 ];

                 $validator = Validator::make($request->all(), $rules);

                 if ($validator->fails()) {
                     $code = $this->returnCodeAccordingToInput($validator);
                     return $this->returnValidationError($code, $validator);
                 }




                 $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
   }

        if(!empty($x)){
            $admin=Customers::where('token',$x)->first();
            $Client=AcccountingManual::where('id',$admin->Account)->first()->id;
        }else{

            $def=SalesDefaultData::latest('id')->first();
            $Client=$def->Client;
        }

              $Ses=Countris::find(request('country_id'));
          $HOLDD=0;

                 $ID = DB::table('sales_orders')->insertGetId(
                     array(
                         'Date' => date('Y-m-d'),
                         'Time' => date("h:i:s a", time()),
                         'Draw' => $Ses->Coin()->first()->Draw,
                         'Payment_Method' => 'Later',
                         'Status' => 1,
                         'Refernce_Number' => null,
                         'Note' => null,
                         'Product_Numbers' => request('product_numbers'),
                         'Total_Qty' => request('total_qty'),
                         'Total_Discount' => 0,
                         'Total_BF_Taxes' => request('total_price'),
                         'Total_Taxes' => 0,
                         'Total_Price' => request('total_price'),
                         'Pay' => 0,
                         'CuponCode' => request('cupon_code'),
                         'Shipping' => request('shipping'),
                         'Delivery_Status' => 0,
                         'Order_Type' => 1,
                         'Name' => request('name'),
                         'Email' => request('email'),
                         'Phone' => request('phone'),
                         'OtherPhone' => request('other_phone'),
                         'Address_Name' => request('address_name'),
                         'Special_MarkAdd' => request('special_mark'),
                         'StreetAdd' => request('street'),
                         'BulidingAdd' => request('buliding'),
                         'FloorAdd' => request('floor'),
                         'FlatAdd' => request('flat'),
                         'Governrate' => request('governrate'),
                         'City' => request('city'),
                         'Place' => request('place'),
                         'LocationAdd' => request('location'),
                         'Address_DetailsAdd' => request('address_details'),
                         'Safe' => $Ses->Safe,
                         'Later_Due' => null,
                         'Sale_Date' => null,
                         'ToSales' => 0,
                         'Client' => $Client,
                         'Delegate' =>null,
                         'Executor' =>null,
                         'Store' => $Ses->Store,
                         'Coin' => $Ses->Coin,
                         'Cost_Center' =>null,
                         'presenter' => null,
                         'annual_interest' =>null,
                         'monthly_installment' => null,
                         'Years_Number' =>null,
                         'total' => null,
                         'Quote' => null,
                         'installment_Num' => null,
                         'Date_First_installment' => null,
                         'User' => 1,
                         'Delegate_Recived' =>0,
                         'Delegate_Recived_Time' =>null,
                         'To_Sales_Time' =>null,
                         'Cancel_Order' =>0,
                         'Cancel_Order_Time' =>null,
                         'Hold_Qty' =>$HOLDD,
                         'Total_Wight_Bill' =>0,
                         'Edit' => 0,
                         'Delete' => 0,
                         'Edit_New_Code' => 0,
                         'Current_Credit' =>0,
                         'Total_Net' => request('total_price'),
                         'Residual' => 0,
                         'ProfitPrecent' =>0,
                         'Total_Cost' =>0 ,



                     )
                 );


                 $CodeT=SalesOrder::findOrFail($ID)->Code;

                 $notii['Date']=date('Y-m-d');
                 $notii['Status']=0;
                 $notii['Noti_Ar_Name']='طلب مبيعات متجر';
                 $notii['Noti_En_Name']='Store Online Order';
                 $notii['Type']='طلب مبيعات متجر';
                 $notii['TypeEn']='Store Online Order';
                 $notii['Type_Code']=$CodeT;
                 $notii['Emp']= null;
                 $notii['Client']=$Client;
                 $notii['Product']=null;
                 $notii['Store']=$Ses->Store;
                 $notii['Safe']=$Ses->Safe;
                 Notifications::create($notii);
                 notify()->success(trans('admin.Online_Order'));




                 $P_Code=request('product_code');
                 $qty=request('qty');
                 $AvQty=request('av_qty');
                 $price=request('price');
                 $total=request('total');
                 $Product=request('product_id');

            for($i=0 ; $i < count($P_Code) ; $i++){


                $QTY=$this->ProAvQties($Ses->Store,$Product[$i],$P_Code[$i]);

                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$QTY->Unit)->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                $rr = ProductUnits::where("Unit",$QTY->Unit)->where('Product',$Product[$i])->first();
                $SS=Stores::find($Ses->Store);
                $PSS=Products::find($Product[$i]);
                $prooooo=Products::find($Product[$i]);
                $costPrice=$average->AverageCostGetUnit($Product[$i],$P_Code[$i],$Ses->Store,$QTY->Unit);



                $uu['Product_Code']=$QTY->P_Code;
                $uu['P_Ar_Name']=$QTY->P_Ar_Name;
                $uu['P_En_Name']=$QTY->P_En_Name;
                $uu['V_Name']=$QTY->V_Name;
                $uu['VV_Name']=$QTY->VV_Name;
                $uu['Original_Qty']=$qty[$i];
                $uu['Qty']=$qty[$i];
                $uu['AvQty']=$AvQty[$i];
                $uu['Price']=$price[$i];
                $uu['Discount']=0;
                $uu['Tax']=1;
                $uu['Total_Bf_Tax']=$total[$i];
                $uu['Total_Tax']=0;
                $uu['Total']=$total[$i];
                $uu['Store']=$Ses->Store;
                $uu['Product']=$Product[$i];
                $uu['Unit']=$QTY->Unit;
                $uu['Exp_Date']=null;
                $uu['SalesOrder']=$ID;
                $uu['V1']=$QTY->V1;
                $uu['V2']=$QTY->V2;
                $uu['Patch_Number']=null;
                $uu['TDiscount']=0;
                $uu['Total_Net']=$total[$i] ;
                $uu['SalesProDesc']=null;
                $uu['SmallCode']=$plow->Barcode;
                $uu['weight']=0;
                $uu['Total_Wight']=0;
                $uu['SmallQty']=$qty[$i] * $pp->Rate;
                $uu['UnitRate']=$pp->Rate;
                $uu['Date']=date('Y-m-d');
                $uu['Branch']=$SS->Branch;
                $uu['Group']=$PSS->Group;
                $uu['Brand']=$PSS->Brand;
                $uu['CostPrice']=$costPrice;
                $uu['TotCostNew']=$costPrice * $qty[$i];
                ProductSalesOrder::create($uu);


            }





                 DB::commit();
            return response()->json([
             'status'=>200,
             'message'=>trans('admin.Success'),
           ]);

             } catch (\Exception $ex) {

                 DB::rollback();
                 return $this->returnError($ex->getMessage().' '.$ex->getLine());

             }catch (\Error $ex) {
                 DB::rollback();
                 return $this->returnError($ex->getMessage().' '.$ex->getLine());
             }



         }






    //========== End E-Commerce ======================================================================================================

    
    
    
        public function RenewSubscribeApi(Request $request){


    
    
                $data['Expire_Date']=request('Expire_Date');
                ModuleSettingsNum::orderBy('id','desc')->update($data);
    
                return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
            ]);



    }
    
        public function BackupDBSpecificApi(){

     

            $def=CompanyData::orderBy('id','desc')->first();

            $backup_name = $def->Name.'-Rabih-' . date('c')  . '.sql';

                  $dumper = PostgreSql::create()
                ->setDbName(env('DB_DATABASE'))
                ->setUserName(env('DB_USERNAME'))
                ->setPassword(env('DB_PASSWORD'));
         $dumper->dumpToFile(public_path('BackupDB/'.$backup_name));
            

            
                return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
            ]);


         
 

    }

        public function AllBackupDB(){

          $Array=array();
 
      $Xs = File::files(public_path('BackupDB'));
            
          
                    foreach($Xs as $x){
             
                   $needle = "public/";
$newString = strstr($x, $needle);
    $lastWord=str_replace('public/', '', $newString);
$lasrString = strstr($lastWord, '.');
 
             
                    if($lasrString == '.sql'){
                        
                        
               array_push($Array,[
                       'DB_url'=>asset($lastWord),
                'DB_Name'=>$lastWord,

                ]);                
                        

        
          }
             
         }
        
            
            
            
                  return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,
            ]);

        
       

    }

  
    
    
    //==========  CRM =========================================================================================
    
    

    //AddClient
    public function AddClientCRM(Request $request){


        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();


            $rules = [
                "name" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }


            if(!empty(request('nameEn'))){

                $english_name=request('nameEn');
            }else{

                $english_name=request('name');
            }


            $Acc=$this->CreateAccountApi(request('name'),$english_name ,24 ,null,$admin->id);
            $Code=$this->ReturnCode(Customers::class);


            $data['Code']=$Code;
            $data['Date']=date('Y-m-d');
            $data['Name']=request('name');
            $data['NameEn']=$english_name;
            $data['Price_Level']=request('price_level');
            $data['Phone']=request('phone');
            $data['Address']=request('address');
            $data['Company_Name']=request('company_name');
            $data['Governrate']=request('governrate_id');
            $data['City']=request('city_id');
            $data['Place']=request('place_id');
            $data['Responsible']=$admin->emp;
            $data['Activity']=request('activity_id');
            $data['Group']=request('group');
            $data['Account']=$Acc;
            $data['User']=$admin->id;
            $data['Phone2']=request('phone2');
            $data['SearchCode']=request('search_code');

            $data['email']=request('email');
            $data['Commercial_Registration_No']=request('Commercial_Registration_No');
            $data['Campagin']=request('Campagin');
            $data['ClientStatus']=request('ClientStatus');
            $data['Platform']=request('Platform');
            $data['Tax_Registration_Number']=request('Tax_Registration_Number');
            $data['Phone3']=request('Phone3');
            $data['Phone4']=request('Phone4');
            $data['Product']=request('Product');
            $data['Warranty']=request('Warranty');
            $data['Operating_Date']=request('Operating_Date');
            $data['Activation_Serial']=request('Activation_Serial');
            $data['Activation_Code']=request('Activation_Code');
            $data['Guarantor']=request('Guarantor');
            Customers::create($data);
            
            
            
            
                 $NaameAddress = request('address_name');
            $Governrate = request('governrate_id');
            $City = request('city_id');
            $Place = request('place_id');
            $Street = request('street');
            $Buliding = request('buliding');
            $Floor = request('floor');
            $Flat = request('flat');
            $Special_Mark = request('special_mark');
            $Location = request('location');
            $Address_Details = request('address_details');
            $lat = request('lat');
            $lng = request('lng');
            
            
          $ID = Customers::latest('id')->first();

            $Addr['Address_Name']=$NaameAddress;
            $Addr['Street']=$Street;
            $Addr['Special_Mark']=$Special_Mark;
            $Addr['Buliding']=$Buliding;
            $Addr['Floor']=$Floor;
            $Addr['Flat']=$Flat;
            $Addr['Details']=$Address_Details;
            $Addr['Location']=$Location;
            $Addr['Governrate']=$Governrate;
            $Addr['City']=$City;
            $Addr['Place']=$Place;
            $Addr['Lat']=$lat;
            $Addr['Lng']=$lng;
            $Addr['Customer']=$ID->id;

            Addressses::create($Addr);
            


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'العملاء',
                'screen_en'=>'Clients',
                'explain_ar'=>request('name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }

    }

    //EditClient
    public function EditClientCRM(Request $request){


        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();


            $rules = [
                "name" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }


            $dataX['Name']=request('name');
            $dataX['NameEn']=request('nameEn');
            AcccountingManual::where('id',request('account_id'))->update($dataX);

            $data['Date']=date('Y-m-d');
            $data['Name']=request('name');
            $data['NameEn']=request('nameEn');
            $data['Price_Level']=request('price_level');
            $data['Phone']=request('phone');
            $data['Address']=request('address');
            $data['Company_Name']=request('company_name');
            $data['Governrate']=request('governrate_id');
            $data['City']=request('city_id');
            $data['Place']=request('place_id');
            $data['Activity']=request('activity_id');
            $data['Group']=request('group');
            $data['Phone2']=request('phone2');
            $data['SearchCode']=request('search_code');
            
                $data['email']=request('email');
            $data['Commercial_Registration_No']=request('Commercial_Registration_No');
            $data['Campagin']=request('Campagin');
            $data['ClientStatus']=request('ClientStatus');
            $data['Platform']=request('Platform');
            $data['Tax_Registration_Number']=request('Tax_Registration_Number');
            $data['Phone3']=request('Phone3');
            $data['Phone4']=request('Phone4');
            $data['Product']=request('Product');
            $data['Warranty']=request('Warranty');
            $data['Operating_Date']=request('Operating_Date');
            $data['Activation_Serial']=request('Activation_Serial');
            $data['Activation_Code']=request('Activation_Code');
            $data['Guarantor']=request('Guarantor');
            Customers::where('id',request('client_id'))->update($data);


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'العملاء',
                'screen_en'=>'Clients',
                'explain_ar'=>request('name'),
                'explain_en'=>request('nameEn'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Updated'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }

    }

    //Inquiry
    public function InquiryStatus(Request $request){


        try {
            DB::beginTransaction();

            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();


            $rules = [
                "SecurityInquiry" => "required",
                "FieldInquiry" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }


   

            $data['SecurityInquiry']=request('SecurityInquiry');
            $data['ReasonSecurityInquiry']=request('ReasonSecurityInquiry');
            $data['FieldInquiry']=request('FieldInquiry');
            $data['ResonFieldInquiry']=request('ResonFieldInquiry');
     


            Customers::where('id',request('client_id'))->update($data);


    
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Updated'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }

    }


  
    
    //AddTicket
    public function AddTicketCRM(Request $request){


        try {
            DB::beginTransaction();

            $rules = [
                "problem" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

            $Code=$this->ReturnCode(CustomersTickets::class);


            if(!empty(request('problemEn'))){

                $english_name=request('problemEn');
            }else{

                $english_name=request('problem');
            }

            $data['Code']=$Code;
                  $data['Date']=date('Y-m-d');
            $data['Problem']=request('problem');
            $data['ProblemEn']=$english_name;
            $data['Status']=1;
            $data['Bill_Number']=request('bill_number');
            $data['Responsible']=$admin->emp;;
            $data['Customer']=request('client_id');
            $data['User']=$admin->id;
                  $data['TicketIssues']=request('TicketIssues');

            CustomersTickets::create($data);


            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'تذاكر العملاء',
                'screen_en'=>'Clients Ticket',
                'explain_ar'=>$Code,
                'explain_en'=>$Code,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }
    
       public function EditTicketCRM(Request $request){


        try {
            DB::beginTransaction();

            $rules = [
                "problem" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

            $Code=$this->ReturnCode(CustomersTickets::class);


            if(!empty(request('problemEn'))){

                $english_name=request('problemEn');
            }else{

                $english_name=request('problem');
            }

       
            $data['Problem']=request('problem');
            $data['ProblemEn']=$english_name;
            $data['Status']=1;
            $data['Bill_Number']=request('bill_number');
            $data['Responsible']=$admin->emp;;
            $data['Customer']=request('client_id');
            $data['User']=$admin->id;
                  $data['TicketIssues']=request('TicketIssues');

            CustomersTickets::where('id',request('ticket_id'))->update($data);


       
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }
    
    
         public function DeleteTicketCRM(Request $request){


            try {

                DB::beginTransaction();


                CustomersTickets::where('id',request('ticket_id'))->delete();

                
                

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.delete'),

                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }



    public function SolveTicketsClientCRM(){


        try {
            DB::beginTransaction();


            $id=request('ticket_id');

            $del=CustomersTickets::find($id);
            CustomersTickets::where('id',$id)->update(['Status'=>2]);



            $cli=Customers::find($del->Customer);

            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='حل تذكرة عميل';
            $notii['Noti_En_Name']='Solve Client Tiecket';
            $notii['Type']='تذاكر عملاء';
            $notii['TypeEn']='Client Tiecket';
            $notii['Type_Code']=$del->Code;
            $notii['Emp']=$del->Responsible;
            $notii['Client']=$cli->Account;
            $notii['Product']=null;
            $notii['Store']=null;
            $notii['Safe']=null;
            Notifications::create($notii);

            notify()->success(trans('admin.SolveTicketClient'));


            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Solved'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }
    
    

    //AddComment
    public function AddCommentCRM(Request $request){

        try {
            DB::beginTransaction();

            $rules = [
                "comment" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

            $Code=$this->ReturnCode(CommentsClients::class);


            if(!empty(request('commentEn'))){

                $english_name=request('commentEn');
            }else{

                $english_name=request('comment');
            }
            
            
            $image=request()->file('Voice');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


            
        if(!empty($image_url)){

            $data['Voice']=$image_url;

        }else{
            $data['Voice']=null;
        }
            

            $data['Code']=$Code;
            $data['Date']=date('Y-m-d');
            $data['Comment']=request('comment');
            $data['CommentEn']=$english_name;
            $data['Responsible']=request('Responsible');
            $data['Customer']=request('client_id');
            $data['Rate']=request('rate');
            $data['Visit_Cost']=request('visit_cost');
            $data['Note']=request('note');
            $data['Time']=date('H:i:s');
            $data['Type']=request('interview_type_id');
            $data['lat']=request('lat');
            $data['lng']=request('lng');

            CommentsClients::create($data);


            
            
                if(!empty(request('Product'))){
            
            $Products=request('Product');
            $ID=CommentsClients::latest('id')->first()->id;
            for($i=0 ; $i < count($Products) ; $i++){
                
                $pro['Product']=$Products[$i];
                $pro['Comment']=$ID;
                
                CustomerCommentsProducts::create($pro);
                
            }
            
            
            
        }
        
            $dataUser=[
                'id'=>$admin->id,
                'screen_ar'=>'تعليقات العملاء',
                'screen_en'=>'Clients Comment',
                'explain_ar'=>$Code,
                'explain_en'=>$Code,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }

    public function EditCommentCRM(Request $request){

        try {
            DB::beginTransaction();

            $rules = [
                "comment" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

            $Code=$this->ReturnCode(CommentsClients::class);


            if(!empty(request('commentEn'))){

                $english_name=request('commentEn');
            }else{

                $english_name=request('comment');
            }

            
            
                     $image=request()->file('Voice');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        if(!empty($image_url)){

            $data['Voice']=$image_url;

        }

            $data['Comment']=request('comment');
            $data['CommentEn']=$english_name;
            $data['Responsible']=request('Responsible');
            $data['Customer']=request('client_id');
            $data['Rate']=request('rate');
            $data['Visit_Cost']=request('visit_cost');
            $data['Note']=request('note');
            $data['Type']=request('interview_type_id');
            $data['lat']=request('lat');
            $data['lng']=request('lng');

            CommentsClients::where('id',request('comment_id'))->update($data);


            
            
                if(!empty(request('Product'))){
            
                        $ID=request('comment_id');
            CustomerCommentsProducts::where('Comment',$ID)->delete();        
                    
            $Products=request('Product');
        
            for($i=0 ; $i < count($Products) ; $i++){
                
                $pro['Product']=$Products[$i];
                $pro['Comment']=$ID;
                
                CustomerCommentsProducts::create($pro);
                
            }
            
            
            
        }
    
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }

   
         public function DeleteCommentCRM(Request $request){


            try {

                DB::beginTransaction();


                CommentsClients::where('id',request('comment_id'))->delete();

                
                

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.delete'),

                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }

       //TicektIssues
        public function TicektIssuesCRM(Request $request){

            $items=TicektIssues::all();
            $data=ArEnNameResources::collection($items);
            return $this->returnData('data', $data);


        }

      
       //InterviewsTypes
        public function InterviewsTypesCRM(Request $request){

            $items=InterviewsTypes::all();
            $data=ArEnNameResources::collection($items);
            return $this->returnData('data', $data);


        }

        
       //CustomersRateTypes
        public function CustomersRateTypesCRM(Request $request){

            $items=CustomersRateTypes::all();
            $data=ArEnNameResources::collection($items);
            return $this->returnData('data', $data);


        }

         
       //ProductsSelect
        public function ProductsSelectCRM(Request $request){

            
            $search=request('search');
            $items=Products::
            
                where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
            
            ->get();
            $data=ProductsSelectResources::collection($items);
            return $this->returnData('data', $data);


        }

    
          public function BillNumbersApi(Request $request){

            
            $client=request('client');
              
               $xx=Customers::find($client);

             $BillNumbers=Sales::where('Client',$xx->Account)->select('Code')->get();
            $data=BillNumbersResources::collection($BillNumbers);
            return $this->returnData('data', $data);


        }
   
      
          public function CustomersCRMApi(Request $request){

            
            $search=request('search');
            $items=Customers::
            
                where('Name','ILIKE', "%{$search}%")
                ->orWhere('NameEn','ILIKE', "%{$search}%")
            
            ->get();
            $data=CustomersCRMResources::collection($items);
            return $this->returnData('data', $data);


        }

    
    
    
    //ClientRequests
       public function AddClientRequestsApi(Request $request){


        try {
            DB::beginTransaction();

            $rules = [
                "Client" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

         

            
         $image=request()->file('File');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


            
        if(!empty($image_url)){

            $zFile=$image_url;

        }else{
            $zFile=null;
        }
            




     $ID = DB::table('client_requests')->insertGetId(
            array(

                'Date' =>date('Y-m-d'),
                'Note' =>request('Note') ,
                'Product_Numbers' =>request('Product_Numbers'),
                'Total_Qty' =>request('Total_Qty'),
                'File' => $zFile,
                'Client' =>request('Client') ,
   
            )
        );

         
  
            
            
        if(!empty(request('Unit'))){


            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $Product=request('Product');
            $VOne=request('VOne');
            $VTwo=request('VTwo');
            $V_Name=request('V_Name');
            $VV_Name=request('VV_Name');
            $Desc=request('Desc');
       

            for($i=0 ; $i < count($Unit) ; $i++){

          
                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['Desc']=$Desc[$i];
                $uu['Request']=$ID;

                ProductsClientRequests::create($uu);


            }


        }
            


   
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Added_Successfully'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }
    
               
         public function DeleteClientRequestsApi(Request $request){


            try {

                DB::beginTransaction();


                $id=request('request_id');
                 $del=ClientRequests::find($id);


    ProductsClientRequests::where('Request',$id)->delete();
       


        $del->delete();  

                DB::commit();
                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.delete'),

                ]);


            } catch (\Exception $ex) {

                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());

            }catch (\Error $ex) {
                DB::rollback();
                return $this->returnError($ex->getMessage().' '.$ex->getLine());
            }




        }

                  public function EditClientRequestsApi(Request $request){


        try {
            DB::beginTransaction();

            $rules = [
                "Client" => "required",
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $header = $request->header('Authorization', '');
            if (Str::startsWith($header, 'Bearer ')) {
                $x=Str::substr($header, 7);
            }

            $admin=Admin::where('token',$x)->first();

         

                            $id=request('request_id');
                 $del=ClientRequests::find($id);


    ProductsClientRequests::where('Request',$id)->delete();
       

            
         $image=request()->file('File');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


            
        if(!empty($image_url)){

            $data['File']=$image_url;

        } 




     $data['Date']=request('Date');
    $data['Note']=request('Note');
    $data['Product_Numbers']=request('Product_Numbers');
    $data['Total_Qty']=request('Total_Qty');
    $data['Client']=request('Client');
    $ID=$id;    
    
    ClientRequests::where('id',$ID)->update($data);
  
            
            
        if(!empty(request('Unit'))){


            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $Product=request('Product');
            $VOne=request('VOne');
            $VTwo=request('VTwo');
            $V_Name=request('V_Name');
            $VV_Name=request('VV_Name');
            $Desc=request('Desc');
       

            for($i=0 ; $i < count($Unit) ; $i++){

          
                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['Desc']=$Desc[$i];
                $uu['Request']=$ID;

                ProductsClientRequests::create($uu);


            }


        }
            


   
            DB::commit();


            return $this->returnSuccessMessage(trans('admin.Updated'));


        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }



    }
    

    
                public function ClientRequestsApi(Request $request){

            $items=ClientRequests::get();
            $data=ClientRequestsResources::collection($items);
            return $this->returnData('data', $data);


        }




    
    //ClientRequestsFilterApi
        public function ClientRequestsFilterApi(Request $request,SalesService $service){

            $Array=array();

            $search = $request->get('search');
            $client = $request->get('client_id');
            $Brand='';
            $Group='';

 
        $data=$this->FilterPurchProduct($search,$Brand,$Group);


   
        $total_row = $data->count();

        if($total_row > 0)
        {

       
            
                foreach($data as $row){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($row->Def == $ser_x or $row->Def == $ser_y){


                        $rr=ProductUnits::where('Product',$row->Product)->where('Def',1)->first();




                        if($row->P_Type == 'Completed' or $row->P_Type == 'Raw' or $row->P_Type == 'Service' or $row->P_Type == 'Industrial' or $row->P_Type == 'Additions'){
                            $type=1;
                        }elseif($row->P_Type == 'Serial'){
                            $type=2;
                        }elseif($row->P_Type == 'Single_Variable'){
                            $type=3;
                        }elseif($row->P_Type == 'Duble_Variable'){
                            $type=4;

                        }

                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$row->P_Ar_Name;
                            $UniiName=$row->Unit()->first()->Name;
                        

                        }else{
                            $PrrroName=$row->P_En_Name;
                            $UniiName=$row->Unit()->first()->NameEn;
                    

                        }

                              $Filter = [

                                    'client' => $client,
                                    'product' => $row->Product,
                                    'name_ar' => $row->P_Ar_Name,
                                    'name_en' => $row->P_En_Name,
                                    'type' => $type,
                                    'PrrroName' => $PrrroName,
                                    'UniiName' => $UniiName,
                                    'search'=>$search,

                                ];

                          

                              $filter = $service->ItemsFilterClientRequestApi($Filter);

                        if (count($filter) != 0) {
                            array_push($Array, [

                          
                                'product_name' => $filter['product_name'],
                                'product_ar_name' => $filter['product_ar_name'],
                                'product_en_name' => $filter['product_en_name'],
                                'product_id' => $filter['product_id'],
                                'product_code' => $filter['product_code'],
                                'unit_name' => $filter['unit_name'],
                                'unit_id' => $filter['unit_id'],
                                'unit_default' => $filter['unit_default'],
                                'units' => $filter['units'],
                                'code_default' => $filter['code_default'],
                                'qty' => $filter['qty'],
                              

                            ]);
                        }






                    }
                }

            
            
            
        }else
        {

            return $this->returnError(trans('admin.No_Data_Find'));

        }

        return $this->returnData('data',$Array);

    }



    
    
    
   
    
    

  
    

    
    
    

}
