<?php

namespace App\Exports;


use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use App\Models\Sales;
use App\Models\GeneralDaily;
use DB ;
class ExportAllCommentsClients implements FromCollection ,WithHeadings
{



    public function collection()
    {



        if(app()->getLocale() == 'ar' ){

            $prods = DB::table('comments_clients')


                ->leftJoin('customers', 'comments_clients.Customer', '=', 'customers.id')

                ->leftJoin('employesses', 'comments_clients.Responsible', '=', 'employesses.id')

                ->select('comments_clients.Comment'
                    ,'customers.Name as custmoer_name'
                    ,'employesses.Name as emp_name'
                    ,'comments_clients.Code'
                    ,'comments_clients.Date'
                    ,'comments_clients.Rate'
                    ,'comments_clients.Visit_Cost'
                    ,'comments_clients.Note'
                    ,'comments_clients.Time'
                    ,'comments_clients.Type'
                    ,'comments_clients.lat'
                    ,'comments_clients.lng'
                )
                ->get();



        }else{


            $prods = DB::table('comments_clients')

                ->leftJoin('customers', 'comments_clients.Customer', '=', 'customers.id')

                ->leftJoin('employesses', 'comments_clients.Responsible', '=', 'employesses.id')

                ->select('comments_clients.CommentEn'
                    ,'customers.NameEn as custmoer_name'
                    ,'employesses.NameEn as emp_name'
                    ,'comments_clients.Code'
                    ,'comments_clients.Date'
                    ,'comments_clients.Rate'
                    ,'comments_clients.Visit_Cost'
                    ,'comments_clients.Note'
                    ,'comments_clients.Time'
                    ,'comments_clients.Type'
                    ,'comments_clients.lat'
                    ,'comments_clients.lng'
                )
                ->get();


        }


        return collect($prods);
    }


    public function headings(): array
    {
        return [
            'Comment',
            'Customer',
            'Responsible',
            'Code',
            'Date',
            'Rate',
            'Visit_Cost',
            'Note',
            'Time',
            'Type',
            'Lat',
            'Lng',

        ];
    }




}
