<?php

namespace App\Exports;


use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use DB ;
class ExportAllAttendence implements FromCollection ,WithHeadings
{



    public function collection()
    {

     // 1. Determine the correct employee name column, ensuring proper quoting for PostgreSQL.
        if (App::getLocale() == 'ar') {
            // FIX: Quote the column name to maintain case sensitivity ("Name")
            $employeeNameColumn = '"employesses"."Name"';
        } else {
            // FIX: Quote the column name to maintain case sensitivity ("NameEn")
            $employeeNameColumn = '"employesses"."NameEn"';
        }

        // 2. Build the single, unified query.
        $prods = DB::table('departure_emps')
            ->leftJoin('employesses', function ($join) {
                $join->on('departure_emps.Emp', '=', 'employesses.id');
            })
            ->select(
                'departure_emps.Date',
                'departure_emps.Month',
                // Use DB::raw() to insert the quoted, case-sensitive column name
                DB::raw("{$employeeNameColumn} as Employee"),
                'departure_emps.In_Time',
                'departure_emps.Out_Time',
                'departure_emps.Hours_Number',
                'departure_emps.Note'
            )
            ->get();


        return collect($prods);
    }


    public function headings(): array
    {
        return [
            'Date',
            'Month',
            'Employee',
            'Attendence_Time',
            'Departure_Time',
            'Hours_Numbers',
            'Note',
          
        ];
    }




}
