<?php

namespace App\Exports;


use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use App\Models\AcccountingManual;
use App\Models\PaymentVoucherDetails;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;

use DB ;
class ExpensesListExport implements FromCollection ,WithHeadings 
{
 
    
     private $from=[] ;

    public function __construct($from=0) 
    {
        $this->from = $from;

       
    }

    
  
    public function collection()
    {
       
    // 1. Extract filter parameters
        $from       = $this->filterParams['from'] ?? null;
        $to         = $this->filterParams['to'] ?? null;
        $branch     = $this->filterParams['branch'] ?? null;
        $safe       = $this->filterParams['safe'] ?? null;
        $subAccount = $this->filterParams['subAccount'] ?? null;

        $locale = App::getLocale();
        $nameColumn = ($locale == 'ar') ? 'Name' : 'NameEn';

        // 2. Build the subquery for SUM("Debitor")
        $paymentTotalsSubquery = PaymentVoucherDetails::select(
                'Account',
                DB::raw('SUM("Debitor"::numeric) as total_debitor') 
            );
           ->whereBetween('Date', [$from, $to]);

        if (!empty($branch)) {
            $paymentTotalsSubquery->where('Branch', $branch);
        }
        if (!empty($safe)) {
            $paymentTotalsSubquery->whereIn('Safe', (array)$safe);
        }
        
        $paymentTotalsSubquery->groupBy('Account');

        // 3. Build the inner query (the core join and selection)
        $innerQuery = AcccountingManual::query()
            ->select(
                'acccounting_manuals.id', 
                'acccounting_manuals.' . $nameColumn . ' as Name',
                'acccounting_manuals.Code',
                // Ensure the alias here matches how we intend to reference it in the outer query
                // Given the hint, 'total' (lowercase) is likely what Postgres expects from the derived table.
                DB::raw('COALESCE(payment_totals.total_debitor, 0) as total') // Changed 'Total' to 'total' here
            )
            ->leftJoinSub($paymentTotalsSubquery, 'payment_totals', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'payment_totals.Account');
            });
            
        // Apply subAccount filter to the inner query
        if (!empty($subAccount)) {
            $innerQuery->whereIn('acccounting_manuals.id', (array)$subAccount);
        }

        // 4. Now, wrap the entire inner query in an outer query
        $finalQuery = DB::query()
            ->fromSub($innerQuery, 'report_data') 
            // Select 'Name' and 'total' from the derived table.
            // Explicitly reference 'total' (lowercase) if that's what PostgreSQL sees.
            ->select('Name', 'total') 
            // Apply the WHERE clause on the lowercase 'total' column from the derived table.
            ->where('total', '!=', 0) 
            ->orderBy('Code', 'asc'); 
        
        return collect($finalQuery->get());
        
    
    }
    

    public function headings(): array
    {
        return [
          'Name',
          'Total'

        
        ];
    }
    
    
    

}
