<?php

namespace App\Enums;

enum ShippingStatus: int
{
    case Pending = 0;
    case Distrbuted = 1;
    case Moves = 2;
    case Delivered = 3;
    case Unloading = 4;
    case CarBack = 5;
    case DelegateProcessing = 6;
    case ClientDelivered = 7;


 
    public function desc(): string
    {
        return match ($this) {
            self::Pending => trans('admin.Pending'),
            self::Distrbuted => trans('admin.Distrbuted'),
            self::Moves => trans('admin.Moved'),
            self::Delivered => trans('admin.Delivered'),
            self::Unloading => trans('admin.Unloading'),
            self::CarBack => trans('admin.CarBack'),
            self::DelegateProcessing => trans('admin.DelegateProcessing'),
            self::ClientDelivered => trans('admin.ClientDelivered'),
          
        };
    }
 
    
    
    
}