<?php

namespace App\Enums;

enum EmpStatues: int
{
    case ACTIVE = 1;
    case INACTIVE = 0;

    public function url(): string
    {
        return match ($this) {
            self::ACTIVE => 'UnActiveEmp',
            self::INACTIVE => 'ActiveEmp',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::ACTIVE => 'fal fa-check',
            self::INACTIVE => 'fal fa-times',
        };
    }
    public function color(): string
    {
        return match ($this) {
            self::ACTIVE => 'btn btn-success',
            self::INACTIVE => 'btn btn-danger',
        };
    }

   
    
    
    
}