--
-- PostgreSQL database dump
--

-- Dumped from database version 12.11
-- Dumped by pg_dump version 12.11

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: rand(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.rand() RETURNS double precision
    LANGUAGE sql
    AS $$SELECT random();$$;


ALTER FUNCTION public.rand() OWNER TO postgres;

--
-- Name: soundex(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.soundex(input text) RETURNS text
    LANGUAGE plpgsql IMMUTABLE STRICT COST 500
    AS $$
DECLARE
  soundex text = '';
  char text;
  symbol text;
  last_symbol text = '';
  pos int = 1;
BEGIN
  WHILE length(soundex) < 4 LOOP
    char = upper(substr(input, pos, 1));
    pos = pos + 1;
    CASE char
    WHEN '' THEN
      -- End of input string
      IF soundex = '' THEN
        RETURN '';
      ELSE
        RETURN rpad(soundex, 4, '0');
      END IF;
    WHEN 'B', 'F', 'P', 'V' THEN
      symbol = '1';
    WHEN 'C', 'G', 'J', 'K', 'Q', 'S', 'X', 'Z' THEN
      symbol = '2';
    WHEN 'D', 'T' THEN
      symbol = '3';
    WHEN 'L' THEN
      symbol = '4';
    WHEN 'M', 'N' THEN
      symbol = '5';
    WHEN 'R' THEN
      symbol = '6';
    ELSE
      -- Not a consonant; no output, but next similar consonant will be re-recorded
      symbol = '';
    END CASE;

    IF soundex = '' THEN
      -- First character; only accept strictly English ASCII characters
      IF char ~>=~ 'A' AND char ~<=~ 'Z' THEN
        soundex = char;
        last_symbol = symbol;
      END IF;
    ELSIF last_symbol != symbol THEN
      soundex = soundex || symbol;
      last_symbol = symbol;
    END IF;
  END LOOP;

  RETURN soundex;
END;
$$;


ALTER FUNCTION public.soundex(input text) OWNER TO postgres;

--
-- Name: substring_index(text, text, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.substring_index(text, text, integer) RETURNS text
    LANGUAGE sql
    AS $_$SELECT array_to_string((string_to_array($1, $2)) [1:$3], $2);$_$;


ALTER FUNCTION public.substring_index(text, text, integer) OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: a_v_pro_check_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.a_v_pro_check_qties (
    id bigint NOT NULL,
    "Product" text,
    "AvQty" text,
    "Qty" text,
    "RequestQty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "OriginalProduct" text,
    "NewRequestQty" text
);


ALTER TABLE public.a_v_pro_check_qties OWNER TO postgres;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.a_v_pro_check_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.a_v_pro_check_qties_id_seq OWNER TO postgres;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.a_v_pro_check_qties_id_seq OWNED BY public.a_v_pro_check_qties.id;


--
-- Name: abouts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.abouts (
    id bigint NOT NULL,
    "Image" text,
    "Image_2" text,
    "Image_3" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.abouts OWNER TO postgres;

--
-- Name: abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.abouts_id_seq OWNER TO postgres;

--
-- Name: abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.abouts_id_seq OWNED BY public.abouts.id;


--
-- Name: abstracts_contractors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.abstracts_contractors (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Name" text,
    "Value" text,
    "Statement" text,
    "Contractor" text,
    "Project" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.abstracts_contractors OWNER TO postgres;

--
-- Name: abstracts_contractors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.abstracts_contractors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.abstracts_contractors_id_seq OWNER TO postgres;

--
-- Name: abstracts_contractors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.abstracts_contractors_id_seq OWNED BY public.abstracts_contractors.id;


--
-- Name: acccounting_manuals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.acccounting_manuals (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account_Code" text,
    "Pro_Group" text,
    "NameEn" text,
    "SearchCode" text
);


ALTER TABLE public.acccounting_manuals OWNER TO postgres;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.acccounting_manuals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.acccounting_manuals_id_seq OWNER TO postgres;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.acccounting_manuals_id_seq OWNED BY public.acccounting_manuals.id;


--
-- Name: accounts_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.accounts_default_data (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sure_Recipts" text,
    "Show_Group" text,
    "Account_Balance" text,
    "Salary" text,
    "Commission" text,
    "Coin_Show" text,
    "Cost_Show" text,
    "Draw_Show" text,
    "Collect_Show" text,
    "Sales_Bill_Show" text,
    "Hide_Edit_Delete" text,
    "Order_Number" text,
    "Tax_Show" text,
    "Cost_Center_Show" text,
    "Emp_Vouchers_Accounts" text
);


ALTER TABLE public.accounts_default_data OWNER TO postgres;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.accounts_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.accounts_default_data_id_seq OWNER TO postgres;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.accounts_default_data_id_seq OWNED BY public.accounts_default_data.id;


--
-- Name: activites; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activites (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.activites OWNER TO postgres;

--
-- Name: activites_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.activites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activites_id_seq OWNER TO postgres;

--
-- Name: activites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.activites_id_seq OWNED BY public.activites.id;


--
-- Name: add_translates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.add_translates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Client_Type" text,
    "From_Lang" text,
    "To_Lang" text,
    "Company" text,
    "Num_Translted_Word" text,
    "ID_Name" text,
    "ID_Profession" text,
    "ID_Martial_Status" text,
    "Passport_Name" text,
    "Passport_Profession" text,
    "Passport_Martial_Status" text,
    "Extracted" text,
    "Extracted_Birthplace" text,
    "Extracted_Issuer" text,
    "CommercialRegistration" text,
    "Commercial_Name" text,
    "Commercial_Type" text,
    "Commercial_Start_Date" text,
    "Commercial_Number" text,
    "Commercial_Capital" text,
    "Commercial_Issuer" text,
    "Commercial_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.add_translates OWNER TO postgres;

--
-- Name: add_translates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.add_translates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.add_translates_id_seq OWNER TO postgres;

--
-- Name: add_translates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.add_translates_id_seq OWNED BY public.add_translates.id;


--
-- Name: additional_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.additional_products (
    id bigint NOT NULL,
    "Additional_Product" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.additional_products OWNER TO postgres;

--
-- Name: additional_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.additional_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.additional_products_id_seq OWNER TO postgres;

--
-- Name: additional_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.additional_products_id_seq OWNED BY public.additional_products.id;


--
-- Name: addressses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.addressses (
    id bigint NOT NULL,
    "Address_Name" text,
    "Street" text,
    "Special_Mark" text,
    "Buliding" text,
    "Floor" text,
    "Flat" text,
    "Details" text,
    "Location" text,
    "Governrate" bigint,
    "City" bigint,
    "Place" bigint,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Lat" text,
    "Lng" text
);


ALTER TABLE public.addressses OWNER TO postgres;

--
-- Name: addressses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.addressses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.addressses_id_seq OWNER TO postgres;

--
-- Name: addressses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.addressses_id_seq OWNED BY public.addressses.id;


--
-- Name: admins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.admins (
    id bigint NOT NULL,
    email character varying(191) NOT NULL,
    name text NOT NULL,
    password text NOT NULL,
    image text,
    phone text,
    hidden text DEFAULT '0'::text NOT NULL,
    emp text DEFAULT '0'::text NOT NULL,
    ship text DEFAULT '0'::text NOT NULL,
    vend text DEFAULT '0'::text NOT NULL,
    status text DEFAULT '0'::text NOT NULL,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    cli bigint DEFAULT 0,
    lat text,
    long text,
    account bigint,
    safe bigint,
    store bigint,
    type text,
    roles_name text,
    code text,
    token text,
    price_sale text,
    discount text,
    price_1 text,
    price_2 text,
    price_3 text,
    pos_pay text,
    executor text,
    cost_price text,
    price_level text,
    guest text,
    pos_stores text,
    pos_hold text,
    cost_price_purch text,
    cost_price_sales text,
    manu_order_precent text,
    pos_product text DEFAULT 0,
    "Cash" text,
    "Later" text,
    "Check" text,
    "Installment" text,
    "Cash_Visa" text,
    "Cash_Collection" text,
    "Delivery" text,
    "InstallmentCompanies" text,
    "Date" text,
    ticket_price text,
    ticket_discount text,
    "nameEn" text,
    package text,
    job_order_price text,
    "Visa_Network" text,
    bill_discount text,
    pos_safes text,
    expire text,
    expire_type text DEFAULT 0,
    attend_date text,
    bank text,
    "Apps" text
);


ALTER TABLE public.admins OWNER TO postgres;

--
-- Name: admins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.admins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admins_id_seq OWNER TO postgres;

--
-- Name: admins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.admins_id_seq OWNED BY public.admins.id;


--
-- Name: all_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.all_groups (
    id bigint NOT NULL,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Name" text
);


ALTER TABLE public.all_groups OWNER TO postgres;

--
-- Name: all_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.all_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.all_groups_id_seq OWNER TO postgres;

--
-- Name: all_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.all_groups_id_seq OWNED BY public.all_groups.id;


--
-- Name: allowences_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.allowences_emps (
    id bigint NOT NULL,
    "AmountAllow" text,
    "Allow" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.allowences_emps OWNER TO postgres;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.allowences_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.allowences_emps_id_seq OWNER TO postgres;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.allowences_emps_id_seq OWNED BY public.allowences_emps.id;


--
-- Name: apps_change_prices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.apps_change_prices (
    id bigint NOT NULL,
    "App" text,
    "Product" text,
    "Price_One" text,
    "Price_Two" text,
    "Price_Three" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text
);


ALTER TABLE public.apps_change_prices OWNER TO postgres;

--
-- Name: apps_change_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.apps_change_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.apps_change_prices_id_seq OWNER TO postgres;

--
-- Name: apps_change_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.apps_change_prices_id_seq OWNED BY public.apps_change_prices.id;


--
-- Name: area_pincode_a_p_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.area_pincode_a_p_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.area_pincode_a_p_id_seq OWNER TO postgres;

--
-- Name: articles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.articles (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.articles OWNER TO postgres;

--
-- Name: articles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.articles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.articles_id_seq OWNER TO postgres;

--
-- Name: articles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.articles_id_seq OWNED BY public.articles.id;


--
-- Name: assembly_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assembly_products (
    id bigint NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Product" bigint,
    p_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assembly_products OWNER TO postgres;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assembly_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assembly_products_id_seq OWNER TO postgres;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.assembly_products_id_seq OWNED BY public.assembly_products.id;


--
-- Name: assets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assets (
    id bigint NOT NULL,
    "Code" text,
    "Name" text,
    "Asset_Type" text,
    "Depreciation_Method" text,
    "Purchases_Date" text,
    "Operation_Date" text,
    "Cost" text,
    "Previous_Depreciation" text,
    "Asset_Net" text,
    "Annual_Depreciation_Ratio" text,
    "Annual_Depreciation" text,
    "Life_Span" text,
    "Image" text,
    "Note" text,
    "Depreciation_Expenses" bigint,
    "Depreciation_Complex" bigint,
    "Main_Account" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Branch" bigint,
    "Sort_Asset" text,
    "Vendor" bigint,
    "Safe" bigint,
    "Ehlak" text,
    "Payment_Method" text,
    "M1" text,
    "M2" text,
    "M3" text,
    "M4" text,
    "M5" text,
    "M6" text,
    "M7" text,
    "M8" text,
    "M9" text,
    "M10" text,
    "M11" text,
    "M12" text,
    "NameEn" text,
    "Asset_Type_En" text,
    "Depreciation_Method_En" text,
    arr bigint,
    "Delete" text,
    "Sale" text,
    "Amount" text,
    "Client" text,
    "CurrentAssetPrice" text,
    "Last_Depreciation_Month" text
);


ALTER TABLE public.assets OWNER TO postgres;

--
-- Name: assets_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_arr_seq OWNER TO postgres;

--
-- Name: assets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.assets_arr_seq OWNED BY public.assets."Code";


--
-- Name: assets_expenses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assets_expenses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Asset" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assets_expenses OWNER TO postgres;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assets_expenses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_expenses_id_seq OWNER TO postgres;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.assets_expenses_id_seq OWNED BY public.assets_expenses.id;


--
-- Name: assets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_id_seq OWNER TO postgres;

--
-- Name: assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.assets_id_seq OWNED BY public.assets.id;


--
-- Name: attend_departure_import; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attend_departure_import (
    id bigint NOT NULL,
    "In_Time" text,
    "Out_Time" text,
    "Date" text,
    "Month" text,
    "Note" text,
    "Attend" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attend_departure_import OWNER TO postgres;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attend_departure_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attend_departure_import_id_seq OWNER TO postgres;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.attend_departure_import_id_seq OWNED BY public.attend_departure_import.id;


--
-- Name: attendance_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendance_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attendance_emps OWNER TO postgres;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendance_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_emps_id_seq OWNER TO postgres;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.attendance_emps_id_seq OWNED BY public.attendance_emps.id;


--
-- Name: attendances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendances (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    arr bigint
);


ALTER TABLE public.attendances OWNER TO postgres;

--
-- Name: attendances_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendances_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_arr_seq OWNER TO postgres;

--
-- Name: attendances_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.attendances_arr_seq OWNED BY public.attendances."Code";


--
-- Name: attendances_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_id_seq OWNER TO postgres;

--
-- Name: attendances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.attendances_id_seq OWNED BY public.attendances.id;


--
-- Name: attendence_policy_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.attendence_policy_emps (
    id bigint NOT NULL,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" integer,
    "To" integer,
    "Discount" numeric
);


ALTER TABLE public.attendence_policy_emps OWNER TO postgres;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.attendence_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendence_policy_emps_id_seq OWNER TO postgres;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.attendence_policy_emps_id_seq OWNED BY public.attendence_policy_emps.id;


--
-- Name: barcode_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.barcode_products (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Group" text
);


ALTER TABLE public.barcode_products OWNER TO postgres;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.barcode_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_products_id_seq OWNER TO postgres;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.barcode_products_id_seq OWNED BY public.barcode_products.id;


--
-- Name: barcode_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.barcode_settings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Direction" text NOT NULL,
    "Width" text NOT NULL,
    "Height" text NOT NULL,
    "Padding_L" text NOT NULL,
    "Padding_R" text NOT NULL,
    "Padding_T" text NOT NULL,
    "Padding_B" text NOT NULL,
    "Margin_L" text NOT NULL,
    "Margin_R" text NOT NULL,
    "Margin_T" text NOT NULL,
    "Margin_B" text NOT NULL,
    "Barcode_Width" text NOT NULL,
    "Barcode_Height" text NOT NULL,
    "Font_Size" text NOT NULL,
    "Line_Height" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Height_Logo" character varying,
    "Width_Logo" character varying,
    "NameEn" text,
    arr bigint
);


ALTER TABLE public.barcode_settings OWNER TO postgres;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.barcode_settings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_arr_seq OWNER TO postgres;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.barcode_settings_arr_seq OWNED BY public.barcode_settings.arr;


--
-- Name: barcode_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.barcode_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_id_seq OWNER TO postgres;

--
-- Name: barcode_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.barcode_settings_id_seq OWNED BY public.barcode_settings.id;


--
-- Name: barcode_shows; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.barcode_shows (
    id bigint NOT NULL,
    "Company_Name" text,
    "Product_Name" text,
    "Product_Price" text,
    "Unit" text,
    "Coin" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Logo" text
);


ALTER TABLE public.barcode_shows OWNER TO postgres;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.barcode_shows_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_shows_id_seq OWNER TO postgres;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.barcode_shows_id_seq OWNED BY public.barcode_shows.id;


--
-- Name: befroe_footers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.befroe_footers (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.befroe_footers OWNER TO postgres;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.befroe_footers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.befroe_footers_id_seq OWNER TO postgres;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.befroe_footers_id_seq OWNED BY public.befroe_footers.id;


--
-- Name: beneftis_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.beneftis_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.beneftis_types OWNER TO postgres;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.beneftis_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.beneftis_types_id_seq OWNER TO postgres;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.beneftis_types_id_seq OWNED BY public.beneftis_types.id;


--
-- Name: bones_sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bones_sales_petrols (
    id bigint NOT NULL,
    "Bone_Amount" text NOT NULL,
    "Bone" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.bones_sales_petrols OWNER TO postgres;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.bones_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_sales_petrols_id_seq OWNER TO postgres;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.bones_sales_petrols_id_seq OWNED BY public.bones_sales_petrols.id;


--
-- Name: bones_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bones_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.bones_types OWNER TO postgres;

--
-- Name: bones_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.bones_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_types_id_seq OWNER TO postgres;

--
-- Name: bones_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.bones_types_id_seq OWNED BY public.bones_types.id;


--
-- Name: borrowas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.borrowas (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Safe" bigint NOT NULL,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.borrowas OWNER TO postgres;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.borrowas_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_arr_seq OWNER TO postgres;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.borrowas_arr_seq OWNED BY public.borrowas."Code";


--
-- Name: borrowas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.borrowas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_id_seq OWNER TO postgres;

--
-- Name: borrowas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.borrowas_id_seq OWNED BY public.borrowas.id;


--
-- Name: branches; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.branches (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Letter" text,
    "Code" text,
    "Location" text,
    "Budget" text,
    "Lat" text,
    "Lang" text
);


ALTER TABLE public.branches OWNER TO postgres;

--
-- Name: branches_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.branches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.branches_id_seq OWNER TO postgres;

--
-- Name: branches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.branches_id_seq OWNED BY public.branches.id;


--
-- Name: brands; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.brands (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Image" text,
    "Sales_Show" text,
    "Store_Show" text,
    "NameEn" text,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.brands OWNER TO postgres;

--
-- Name: brands_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.brands_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.brands_id_seq OWNER TO postgres;

--
-- Name: brands_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.brands_id_seq OWNED BY public.brands.id;


--
-- Name: campaigns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.campaigns (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Platform" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.campaigns OWNER TO postgres;

--
-- Name: campaigns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.campaigns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.campaigns_id_seq OWNER TO postgres;

--
-- Name: campaigns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.campaigns_id_seq OWNED BY public.campaigns.id;


--
-- Name: capital_increases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.capital_increases (
    id bigint NOT NULL,
    "Date" text,
    "Month" text,
    "Value" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.capital_increases OWNER TO postgres;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.capital_increases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capital_increases_id_seq OWNER TO postgres;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.capital_increases_id_seq OWNED BY public.capital_increases.id;


--
-- Name: capitals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.capitals (
    id bigint NOT NULL,
    "Authorized_Capital" text,
    "Source_Capital" text,
    "Shares_Number" text,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Actual_Capital" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Working_Capital" text,
    "New_Shares_Number" text,
    "Capital_Increase" text,
    "New_Source_Capital" text,
    "Total_Investment" text
);


ALTER TABLE public.capitals OWNER TO postgres;

--
-- Name: capitals_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.capitals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capitals_id_seq OWNER TO postgres;

--
-- Name: capitals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.capitals_id_seq OWNED BY public.capitals.id;


--
-- Name: car_shippings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.car_shippings (
    id bigint NOT NULL,
    "Name" text,
    "Max_Load" text,
    "Delegate" text,
    "Driver" text,
    "Car_Number" text,
    "Color" text,
    "Lisence_Expire_Date" text,
    "GPS_Num" text,
    "Car_Type" text,
    "Car_Statue" text,
    "Insurance" text,
    "Ownership" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost_Center" text,
    "Rent_Amount" text,
    "Deal_Type" text,
    "Deal_Amount" text,
    "Account" text,
    "AccountMerit" text,
    "Minimum" text
);


ALTER TABLE public.car_shippings OWNER TO postgres;

--
-- Name: car_shippings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.car_shippings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.car_shippings_id_seq OWNER TO postgres;

--
-- Name: car_shippings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.car_shippings_id_seq OWNED BY public.car_shippings.id;


--
-- Name: cars_sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cars_sales_petrols (
    id bigint NOT NULL,
    "Car_Amount" text NOT NULL,
    "Car" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.cars_sales_petrols OWNER TO postgres;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.cars_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cars_sales_petrols_id_seq OWNER TO postgres;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.cars_sales_petrols_id_seq OWNED BY public.cars_sales_petrols.id;


--
-- Name: cart_stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cart_stores (
    id bigint NOT NULL,
    "Name" text,
    "NameEn" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Image" text,
    "Total" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.cart_stores OWNER TO postgres;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.cart_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cart_stores_id_seq OWNER TO postgres;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.cart_stores_id_seq OWNED BY public.cart_stores.id;


--
-- Name: chat_issues; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.chat_issues (
    id bigint NOT NULL,
    "Name" text,
    "Date" text,
    "Time" text,
    "Desc" text,
    "Image" text,
    "Issue" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Appear" text
);


ALTER TABLE public.chat_issues OWNER TO postgres;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.chat_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.chat_issues_id_seq OWNER TO postgres;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.chat_issues_id_seq OWNED BY public.chat_issues.id;


--
-- Name: checks_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.checks_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.checks_types OWNER TO postgres;

--
-- Name: checks_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.checks_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.checks_types_id_seq OWNER TO postgres;

--
-- Name: checks_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.checks_types_id_seq OWNED BY public.checks_types.id;


--
-- Name: cities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cities (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Gov" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship_Price" text,
    "Shipping_Company" text,
    "SearchCode" text,
    "ShippingCode" text
);


ALTER TABLE public.cities OWNER TO postgres;

--
-- Name: cities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.cities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cities_id_seq OWNER TO postgres;

--
-- Name: cities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.cities_id_seq OWNED BY public.cities.id;


--
-- Name: client_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_column_sechdules OWNER TO postgres;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_account_statement_column_sechdules_id_seq OWNED BY public.client_account_statement_column_sechdules.id;


--
-- Name: client_account_statement_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_columns OWNER TO postgres;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_columns_id_seq OWNER TO postgres;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_account_statement_columns_id_seq OWNED BY public.client_account_statement_columns.id;


--
-- Name: client_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text
);


ALTER TABLE public.client_filters OWNER TO postgres;

--
-- Name: client_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_filters_id_seq OWNER TO postgres;

--
-- Name: client_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_filters_id_seq OWNED BY public.client_filters.id;


--
-- Name: client_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Client" text,
    "File" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_requests OWNER TO postgres;

--
-- Name: client_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_requests_arr_seq OWNER TO postgres;

--
-- Name: client_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_requests_arr_seq OWNED BY public.client_requests."Code";


--
-- Name: client_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_requests_id_seq OWNER TO postgres;

--
-- Name: client_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_requests_id_seq OWNED BY public.client_requests.id;


--
-- Name: client_sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_sales_petrols (
    id bigint NOT NULL,
    "Customer_Amount" text NOT NULL,
    "Customer" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_sales_petrols OWNER TO postgres;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_sales_petrols_id_seq OWNER TO postgres;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_sales_petrols_id_seq OWNED BY public.client_sales_petrols.id;


--
-- Name: client_statuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.client_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_statuses OWNER TO postgres;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.client_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_statuses_id_seq OWNER TO postgres;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.client_statuses_id_seq OWNED BY public.client_statuses.id;


--
-- Name: clients_statements_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.clients_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_column_sechdules OWNER TO postgres;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.clients_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.clients_statements_column_sechdules_id_seq OWNED BY public.clients_statements_column_sechdules.id;


--
-- Name: clients_statements_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.clients_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_columns OWNER TO postgres;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.clients_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_columns_id_seq OWNER TO postgres;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.clients_statements_columns_id_seq OWNED BY public.clients_statements_columns.id;


--
-- Name: coins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.coins (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Symbol" text,
    "Code" text,
    "Image" text
);


ALTER TABLE public.coins OWNER TO postgres;

--
-- Name: coins_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.coins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coins_id_seq OWNER TO postgres;

--
-- Name: coins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.coins_id_seq OWNED BY public.coins.id;


--
-- Name: comments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.comments (
    id bigint NOT NULL,
    "Comment" text NOT NULL,
    "Date" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.comments OWNER TO postgres;

--
-- Name: comments_clients; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.comments_clients (
    id bigint NOT NULL,
    "Comment" text,
    "Responsible" bigint,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CommentEn" text,
    "Code" text,
    "Date" text,
    "Rate" text,
    "Visit_Cost" text,
    "Note" text,
    "Time" text,
    "Type" text,
    lat text,
    lng text,
    "Voice" text
);


ALTER TABLE public.comments_clients OWNER TO postgres;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.comments_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_clients_id_seq OWNER TO postgres;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.comments_clients_id_seq OWNED BY public.comments_clients.id;


--
-- Name: comments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_id_seq OWNER TO postgres;

--
-- Name: comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.comments_id_seq OWNED BY public.comments.id;


--
-- Name: company_cars; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.company_cars (
    id bigint NOT NULL,
    "Name" text,
    "Number" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.company_cars OWNER TO postgres;

--
-- Name: company_cars_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.company_cars_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_cars_id_seq OWNER TO postgres;

--
-- Name: company_cars_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.company_cars_id_seq OWNED BY public.company_cars.id;


--
-- Name: company_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.company_data (
    id bigint NOT NULL,
    "Name" text,
    "Phone1" text,
    "Phone2" text,
    "Address" text,
    "Commercial_Record" text,
    "Tax_File_Number" text,
    "Logo" text,
    "Icon" text,
    "Print_Text" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Print_Text_Footer" text,
    "Seal" text,
    "Print_Text_Footer_Sales" text,
    "Name_Sales_Bill" text,
    "Name_Sales_Order_Bill" text,
    "Print_Text_Footer_Quote" text,
    "Name_Quote_Bill" text,
    "Print_Text_Footer_Secretariat" text,
    "Logo_Store" text,
    "Phone3" text,
    "Phone4" text,
    "Icon_Store" text,
    "View" text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Client_ID" text,
    "Serial_Client_ID" text,
    "Version_Type" text,
    "Computer_SN" text,
    "Invoice_Type" text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Print_Text_Footer_Manufacturing" text,
    "POS_Version" text,
    "Path" text,
    "DB_Backup" text,
    "NameEn" text,
    "Print_Text_En" text,
    "Print_Text_Footer_En" text,
    "Print_Text_Footer_Manufacturing_En" text,
    "Print_Text_Footer_Sales_En" text,
    "Print_Text_Footer_Quote_En" text,
    "Print_Text_Footer_Secretariat_En" text,
    "Name_Sales_Bill_En" text,
    "Name_Sales_Order_Bill_En" text,
    "Name_Quote_Bill_En" text,
    "AddressEn" text,
    "HomeMainScreen" text,
    "PDF" text,
    "Email" text,
    "Location" text,
    "Bill_View" text,
    "Font_Type" text,
    "Welcome_Arabic_Word_App" text,
    "Welcome_English_Word_App" text,
    "Domain" text,
    "Serial_App" text,
    "Attend_Lat" text,
    "Attend_Lng" text,
    "Attend_Space" text,
    "Attend_Time_Before" text,
    "Attend_Time_After" text,
    "Departure_Time_Before" text,
    "Departure_Time_After" text,
    "Verfification_Time" text,
    "Organaziation_Common_Name" text,
    "Organaziation_Name" text,
    "Organaziation_Tax_ID" text,
    "Organaziation_Address" text,
    "Organaziation_Department" text,
    "Organaziation_Category" text,
    "ZATCA_Production" text,
    "OTP_Status" text DEFAULT 0,
    "Use_Zatca" text DEFAULT 0,
    "Backup_Time" text,
    "Purchases_Print_View" text,
    "Purchases_Order_Print_View" text,
    "Sales_Order_Print_View" text,
    "Quote_Print_View" text
);


ALTER TABLE public.company_data OWNER TO postgres;

--
-- Name: company_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.company_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_data_id_seq OWNER TO postgres;

--
-- Name: company_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.company_data_id_seq OWNED BY public.company_data.id;


--
-- Name: compare_prices_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compare_prices_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns OWNER TO postgres;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compare_prices_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_id_seq OWNER TO postgres;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compare_prices_columns_id_seq OWNED BY public.compare_prices_columns.id;


--
-- Name: compare_prices_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compare_prices_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns_sechdules OWNER TO postgres;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compare_prices_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compare_prices_columns_sechdules_id_seq OWNED BY public.compare_prices_columns_sechdules.id;


--
-- Name: compare_prices_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compare_prices_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filter_twos OWNER TO postgres;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compare_prices_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filter_twos_id_seq OWNER TO postgres;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compare_prices_filter_twos_id_seq OWNED BY public.compare_prices_filter_twos.id;


--
-- Name: compare_prices_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compare_prices_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filters OWNER TO postgres;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compare_prices_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filters_id_seq OWNER TO postgres;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compare_prices_filters_id_seq OWNED BY public.compare_prices_filters.id;


--
-- Name: compares; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compares (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compares OWNER TO postgres;

--
-- Name: compares_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compares_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compares_id_seq OWNER TO postgres;

--
-- Name: compares_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compares_id_seq OWNED BY public.compares.id;


--
-- Name: competitors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.competitors (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Name" character varying(191),
    "Country" text,
    "Whatsapp" character varying(191),
    "Addtional_Link" character varying(191),
    "Phone" character varying(191),
    "Pinterest" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    "Website" text
);


ALTER TABLE public.competitors OWNER TO postgres;

--
-- Name: competitors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.competitors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.competitors_id_seq OWNER TO postgres;

--
-- Name: competitors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.competitors_id_seq OWNED BY public.competitors.id;


--
-- Name: consist_maintainces; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.consist_maintainces (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Exp_Date" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Maintaince" text,
    "TDiscount" text,
    "Group" text,
    "Brand" text,
    "Code" text,
    "Date" text,
    "Note" text,
    "Serial_Num" text,
    "Total_Price" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Cost" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Account" text,
    "User" text,
    "Status" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "StoreMain" text,
    "Eng" text,
    "Recipient" text,
    "Branch" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.consist_maintainces OWNER TO postgres;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.consist_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consist_maintainces_id_seq OWNER TO postgres;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.consist_maintainces_id_seq OWNED BY public.consist_maintainces.id;


--
-- Name: consists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.consists (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Darw" text NOT NULL,
    "Products_Number" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    arr bigint,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.consists OWNER TO postgres;

--
-- Name: consists_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.consists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_arr_seq OWNER TO postgres;

--
-- Name: consists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.consists_arr_seq OWNED BY public.consists.arr;


--
-- Name: consists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_id_seq OWNER TO postgres;

--
-- Name: consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.consists_id_seq OWNED BY public.consists.id;


--
-- Name: contact_u_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.contact_u_s (
    id bigint NOT NULL,
    "Map" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Opening_Hours" text,
    "Phone1" text,
    "Phone2" text,
    "Phone_Header" text,
    "Email" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contact_u_s OWNER TO postgres;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.contact_u_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contact_u_s_id_seq OWNER TO postgres;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.contact_u_s_id_seq OWNED BY public.contact_u_s.id;


--
-- Name: contract_statuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.contract_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contract_statuses OWNER TO postgres;

--
-- Name: contract_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.contract_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contract_statuses_id_seq OWNER TO postgres;

--
-- Name: contract_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.contract_statuses_id_seq OWNED BY public.contract_statuses.id;


--
-- Name: contractors_real_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.contractors_real_projects (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Expenses_Account" text,
    "Merit_Account" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contractors_real_projects OWNER TO postgres;

--
-- Name: contractors_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.contractors_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contractors_real_projects_id_seq OWNER TO postgres;

--
-- Name: contractors_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.contractors_real_projects_id_seq OWNED BY public.contractors_real_projects.id;


--
-- Name: cost_centers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cost_centers (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text DEFAULT 0,
    "Type" text DEFAULT 0
);


ALTER TABLE public.cost_centers OWNER TO postgres;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.cost_centers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cost_centers_id_seq OWNER TO postgres;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.cost_centers_id_seq OWNED BY public.cost_centers.id;


--
-- Name: counters_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.counters_types (
    id bigint NOT NULL,
    "Name" text,
    "Current_Read" text,
    "Store" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.counters_types OWNER TO postgres;

--
-- Name: counters_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.counters_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.counters_types_id_seq OWNER TO postgres;

--
-- Name: counters_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.counters_types_id_seq OWNED BY public.counters_types.id;


--
-- Name: countris; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.countris (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    "Flag" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Coin" text,
    "Store" text,
    "Code" text,
    "SearchCode" text
);


ALTER TABLE public.countris OWNER TO postgres;

--
-- Name: countris_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.countris_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.countris_id_seq OWNER TO postgres;

--
-- Name: countris_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.countris_id_seq OWNED BY public.countris.id;


--
-- Name: coupon_codes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.coupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.coupon_codes OWNER TO postgres;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.coupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coupon_codes_id_seq OWNER TO postgres;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.coupon_codes_id_seq OWNED BY public.coupon_codes.id;


--
-- Name: courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Category" text,
    "Lec_Num" text,
    "Hours" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text
);


ALTER TABLE public.courses OWNER TO postgres;

--
-- Name: courses_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses_categories (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_categories OWNER TO postgres;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_categories_id_seq OWNER TO postgres;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_categories_id_seq OWNED BY public.courses_categories.id;


--
-- Name: courses_halls; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses_halls (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Chairs_Num" text,
    "Wiifii" text,
    "Air_Condition" text,
    "Place" text,
    "Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_halls OWNER TO postgres;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_halls_id_seq OWNER TO postgres;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_halls_id_seq OWNED BY public.courses_halls.id;


--
-- Name: courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_id_seq OWNER TO postgres;

--
-- Name: courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_id_seq OWNED BY public.courses.id;


--
-- Name: courses_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_types OWNER TO postgres;

--
-- Name: courses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_types_id_seq OWNER TO postgres;

--
-- Name: courses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_types_id_seq OWNED BY public.courses_types.id;


--
-- Name: crm_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.crm_default_data (
    id bigint NOT NULL,
    "Price_Level" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Platforms" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client_Delegate" text DEFAULT 0,
    "Nationality" text,
    "ClientGroup" text
);


ALTER TABLE public.crm_default_data OWNER TO postgres;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.crm_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crm_default_data_id_seq OWNER TO postgres;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.crm_default_data_id_seq OWNED BY public.crm_default_data.id;


--
-- Name: custom_prints; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.custom_prints (
    id bigint NOT NULL,
    "Sales_Print_Type" text,
    "Sales_Bill_Code" text,
    "Sales_Date" text,
    "Sales_Coin" text,
    "Sales_Draw" text,
    "Sales_Payment_Method" text,
    "Sales_Status" text,
    "Sales_Executor" text,
    "Sales_Refernce_Number" text,
    "Sales_Safe" text,
    "Sales_Client" text,
    "Sales_Delegate" text,
    "Sales_Store" text,
    "Sales_User" text,
    "Sales_Cost_Center" text,
    "Sales_Notes" text,
    "Sales_Pro_Code" text,
    "Sales_Pro_Name" text,
    "Sales_Pro_Unit" text,
    "Sales_Pro_Qty" text,
    "Sales_Pro_Price" text,
    "Sales_Pro_Discount" text,
    "Sales_Pro_Total_Bf_Tax" text,
    "Sales_Pro_Total_Tax" text,
    "Sales_Pro_Total" text,
    "Sales_Pro_Store" text,
    "Sales_Pro_Desc" text,
    "Sales_Pro_Exp_Date" text,
    "Sales_Pro_Weight" text,
    "Sales_Pro_Patch_Number" text,
    "Sales_Product_Numbers" text,
    "Sales_Total_Qty" text,
    "Sales_Total_Discount" text,
    "Sales_Total_Bf_Taxes" text,
    "Sales_Total_Taxes" text,
    "Sales_Total_Price" text,
    "Sales_Paid" text,
    "Sales_Residual" text,
    "Sales_Taknet" text,
    "Sales_Credit" text,
    "Sales_Barcode" text,
    "Sales_Text" text,
    "Sales_Seal" text,
    "Purch_Print_Type" text,
    "Purch_Bill_Code" text,
    "Purch_Date" text,
    "Purch_Vendor_Bill_Date" text,
    "Purch_Coin" text,
    "Purch_Draw" text,
    "Purch_Payment_Method" text,
    "Purch_Status" text,
    "Purch_Refernce_Number" text,
    "Purch_Safe" text,
    "Purch_Vendor" text,
    "Purch_Delegate" text,
    "Purch_Store" text,
    "Purch_User" text,
    "Purch_Cost_Center" text,
    "Purch_Notes" text,
    "Purch_Pro_Code" text,
    "Purch_Pro_Name" text,
    "Purch_Pro_Unit" text,
    "Purch_Pro_Qty" text,
    "Purch_Pro_Price" text,
    "Purch_Pro_Discount" text,
    "Purch_Pro_Total_Bf_Tax" text,
    "Purch_Pro_Total_Tax" text,
    "Purch_Pro_Total" text,
    "Purch_Pro_Store" text,
    "Purch_Pro_Exp_Date" text,
    "Purch_Product_Numbers" text,
    "Purch_Total_Qty" text,
    "Purch_Total_Discount" text,
    "Purch_Total_Bf_Taxes" text,
    "Purch_Total_Taxes" text,
    "Purch_Total_Price" text,
    "Purch_Paid" text,
    "Purch_Residual" text,
    "Purch_Taknet" text,
    "Purch_Credit" text,
    "Purch_Barcode" text,
    "Purch_Text" text,
    "Purch_Seal" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sales_Client_Phone" text,
    "Sales_Resdiual" text,
    "Sales_Total_Return" text,
    "Sales_Client_Address" text,
    "Sales_Pro_Total_Net" text,
    "Purch_Pro_Total_Net" text
);


ALTER TABLE public.custom_prints OWNER TO postgres;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.custom_prints_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.custom_prints_id_seq OWNER TO postgres;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.custom_prints_id_seq OWNED BY public.custom_prints.id;


--
-- Name: customer_comments_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customer_comments_products (
    id bigint NOT NULL,
    "Product" bigint NOT NULL,
    "Comment" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customer_comments_products OWNER TO postgres;

--
-- Name: customer_comments_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customer_comments_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_comments_products_id_seq OWNER TO postgres;

--
-- Name: customer_comments_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customer_comments_products_id_seq OWNED BY public.customer_comments_products.id;


--
-- Name: customer_follow_ups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customer_follow_ups (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Subject" text,
    "Rate" text,
    "Emp" text,
    "Visit_Cost" text,
    "Note" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customer_follow_ups OWNER TO postgres;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customer_follow_ups_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_arr_seq OWNER TO postgres;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customer_follow_ups_arr_seq OWNED BY public.customer_follow_ups.arr;


--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customer_follow_ups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_id_seq OWNER TO postgres;

--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customer_follow_ups_id_seq OWNED BY public.customer_follow_ups.id;


--
-- Name: customers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text,
    "Name" text NOT NULL,
    "Price_Level" text,
    "Phone" text,
    email text,
    password text,
    "ID_Number" text,
    "Address" text,
    "Qualifications" text,
    "Birthdate" text,
    "Social_Status" text,
    "Passport_Number" text,
    "Company_Name" text,
    "Commercial_Registration_No" text,
    "Tax_Card_No" text,
    "Bank_Account" text,
    "Image" text,
    "Next_Time" text,
    "Executions_Status" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Platform" bigint,
    "Contract_Start" text,
    "Contract_End" text,
    code text,
    country text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Warranty" text,
    "Group" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Product" bigint,
    token text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Credit_Limit" text,
    "Respon_Person" text,
    "Respon_Person_Phone" text,
    "Operating_Date" text,
    "Activation_Serial" text,
    "Activation_Code" text,
    "Repayment_Period" text,
    "SecurityInquiry" text,
    "ReasonSecurityInquiry" text,
    "FieldInquiry" text,
    "ResonFieldInquiry" text,
    "Lat" text,
    "Lang" text,
    "Guarantor" text
);


ALTER TABLE public.customers OWNER TO postgres;

--
-- Name: customers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_arr_seq OWNER TO postgres;

--
-- Name: customers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_arr_seq OWNED BY public.customers.arr;


--
-- Name: customers_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customers_files (
    id bigint NOT NULL,
    "File" text NOT NULL,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_files OWNER TO postgres;

--
-- Name: customers_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_files_id_seq OWNER TO postgres;

--
-- Name: customers_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_files_id_seq OWNED BY public.customers_files.id;


--
-- Name: customers_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customers_groups (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text
);


ALTER TABLE public.customers_groups OWNER TO postgres;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_groups_id_seq OWNER TO postgres;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_groups_id_seq OWNED BY public.customers_groups.id;


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_id_seq OWNER TO postgres;

--
-- Name: customers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_id_seq OWNED BY public.customers.id;


--
-- Name: customers_rate_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customers_rate_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_rate_types OWNER TO postgres;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_rate_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_rate_types_id_seq OWNER TO postgres;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_rate_types_id_seq OWNED BY public.customers_rate_types.id;


--
-- Name: customers_tickets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.customers_tickets (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Problem" text NOT NULL,
    "Status" text NOT NULL,
    "Bill_Number" text,
    "Responsible" bigint,
    "Customer" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProblemEn" text,
    arr bigint,
    "TicketIssues" text,
    "Date" text
);


ALTER TABLE public.customers_tickets OWNER TO postgres;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_arr_seq OWNER TO postgres;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_tickets_arr_seq OWNED BY public.customers_tickets.arr;


--
-- Name: customers_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.customers_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_id_seq OWNER TO postgres;

--
-- Name: customers_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.customers_tickets_id_seq OWNED BY public.customers_tickets.id;


--
-- Name: deducations_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.deducations_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deducations_types OWNER TO postgres;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.deducations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deducations_types_id_seq OWNER TO postgres;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.deducations_types_id_seq OWNED BY public.deducations_types.id;


--
-- Name: deductions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.deductions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deductions OWNER TO postgres;

--
-- Name: deductions_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.deductions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_arr_seq OWNER TO postgres;

--
-- Name: deductions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.deductions_arr_seq OWNED BY public.deductions.arr;


--
-- Name: deductions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.deductions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_id_seq OWNER TO postgres;

--
-- Name: deductions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.deductions_id_seq OWNED BY public.deductions.id;


--
-- Name: default_data_show_hides; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.default_data_show_hides (
    id bigint NOT NULL,
    "Status" text,
    "Shipping_Company" text,
    "Vendor_Date" text,
    "Expire_Date" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Coin" text,
    "Draw" text,
    "Delegate_Sale" text,
    "Delegate_Purchase" text,
    "Note" text,
    "Refrence_Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost_Center" text,
    "Branch" text,
    "Serial_Num" text,
    "Pass" text,
    "Pattern_Image" text,
    "Barcode_Print" text,
    "Unit_Print" text,
    "Total_BF_Print" text,
    "Discount_Print" text,
    "Tax_Print" text,
    "A5" text,
    "A4" text,
    "CM8" text,
    "Group_Brand" text,
    "Patch_Number" text,
    "Manufacturing_Model_Shortcomings" text,
    "Search_Typical" text,
    "Validity_Product" text,
    "Executor_Sale" text,
    "Totuch_Screen" text,
    "Tax_POS" text,
    "TotalDiscountPrint" text,
    "TotalTaxPrint" text,
    "ProductsNumber" text,
    "TotalQtyPrint" text,
    "Credit" text,
    "Barcode" text,
    "Taknet" text,
    "Address" text,
    "Phone1" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Text" text,
    "Seal" text,
    "Code_Report" text,
    "Unit" text,
    "Refrence_Number_Print" text,
    "Icon_Payment_Recipt" text,
    "SearchCode" text,
    "TaxOnTotal" text,
    "TotalBfTax" text,
    "AvQty" text,
    "Disc" text,
    "Tax" text,
    "Store" text,
    "TaxBill" text,
    "Change_Way_Stores_Transfer" text,
    "Note_POS" text,
    "Open_Drawer" text,
    client_delivery text,
    "POS_RecivedDate" text,
    "POS_Barcode" text,
    "POS_Qty" text,
    "Show_File_InsurancePaper" text,
    "Show_File_Checks" text,
    "Show_File_Purchases" text,
    "Show_File_Sales" text,
    "Show_File_PaymentVoucher" text,
    "Show_File_ReciptVoucher" text,
    "Show_File_TransferStores" text,
    "Thickness_Print" text,
    "Height_Print" text,
    "Thickness" text,
    "Height" text,
    "Items_Guide_Store_Show" text,
    "Sales_Pro_Desc" text,
    "Show_Barcode" text,
    "Show_Net" text,
    "Show_Unit" text,
    "Show_Total" text,
    "ChassisNumber" text,
    "MotorNumber" text,
    "Shipping_Price" text,
    "OpenInputTransferSales" text DEFAULT 0
);


ALTER TABLE public.default_data_show_hides OWNER TO postgres;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.default_data_show_hides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_data_show_hides_id_seq OWNER TO postgres;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.default_data_show_hides_id_seq OWNED BY public.default_data_show_hides.id;


--
-- Name: delivery_apps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.delivery_apps (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Type" text,
    "Account" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.delivery_apps OWNER TO postgres;

--
-- Name: delivery_apps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.delivery_apps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.delivery_apps_id_seq OWNER TO postgres;

--
-- Name: delivery_apps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.delivery_apps_id_seq OWNED BY public.delivery_apps.id;


--
-- Name: depaarture_policy_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.depaarture_policy_emps (
    id bigint NOT NULL,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" integer,
    "To" integer,
    "Discount" numeric
);


ALTER TABLE public.depaarture_policy_emps OWNER TO postgres;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.depaarture_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.depaarture_policy_emps_id_seq OWNER TO postgres;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.depaarture_policy_emps_id_seq OWNED BY public.depaarture_policy_emps.id;


--
-- Name: departure_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.departure_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Out_Time" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Departure" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Disc_Late" text,
    "Disc_Early" text
);


ALTER TABLE public.departure_emps OWNER TO postgres;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.departure_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departure_emps_id_seq OWNER TO postgres;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.departure_emps_id_seq OWNED BY public.departure_emps.id;


--
-- Name: departures; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.departures (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.departures OWNER TO postgres;

--
-- Name: departures_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.departures_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_arr_seq OWNER TO postgres;

--
-- Name: departures_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.departures_arr_seq OWNED BY public.departures.arr;


--
-- Name: departures_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.departures_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_id_seq OWNER TO postgres;

--
-- Name: departures_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.departures_id_seq OWNED BY public.departures.id;


--
-- Name: desvice_cases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.desvice_cases (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.desvice_cases OWNER TO postgres;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.desvice_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.desvice_cases_id_seq OWNER TO postgres;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.desvice_cases_id_seq OWNED BY public.desvice_cases.id;


--
-- Name: device_descrips; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_descrips (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Sort" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.device_descrips OWNER TO postgres;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_descrips_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_descrips_id_seq OWNER TO postgres;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_descrips_id_seq OWNED BY public.device_descrips.id;


--
-- Name: devices_typesies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.devices_typesies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Company" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.devices_typesies OWNER TO postgres;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.devices_typesies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.devices_typesies_id_seq OWNER TO postgres;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.devices_typesies_id_seq OWNED BY public.devices_typesies.id;


--
-- Name: disclaimers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.disclaimers (
    id bigint NOT NULL,
    "Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.disclaimers OWNER TO postgres;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.disclaimers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.disclaimers_id_seq OWNER TO postgres;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.disclaimers_id_seq OWNED BY public.disclaimers.id;


--
-- Name: discounts_emps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discounts_emps (
    id bigint NOT NULL,
    "AmountDiscount" text,
    "Discount" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.discounts_emps OWNER TO postgres;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discounts_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discounts_emps_id_seq OWNER TO postgres;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.discounts_emps_id_seq OWNED BY public.discounts_emps.id;


--
-- Name: domains; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.domains (
    id integer NOT NULL,
    domain character varying(255) NOT NULL,
    tenant_id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.domains OWNER TO postgres;

--
-- Name: domains_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.domains_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.domains_id_seq OWNER TO postgres;

--
-- Name: domains_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.domains_id_seq OWNED BY public.domains.id;


--
-- Name: emp_covenants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_covenants (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Name" text,
    "Price" text,
    "Reason" text,
    "Life_Expectancy" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_covenants OWNER TO postgres;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_covenants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_covenants_id_seq OWNER TO postgres;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_covenants_id_seq OWNED BY public.emp_covenants.id;


--
-- Name: emp_excs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_excs (
    id bigint NOT NULL,
    "Name" text,
    "Account" text,
    "Emp_Type" text,
    "Salary" text,
    "Phone" text,
    "Job" text,
    "Department" text,
    "Store1" text,
    "Store2" text,
    "Store3" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_excs OWNER TO postgres;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_excs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_excs_id_seq OWNER TO postgres;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_excs_id_seq OWNED BY public.emp_excs.id;


--
-- Name: emp_installment_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_installment_details (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Emp" bigint,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installment_details OWNER TO postgres;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_installment_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installment_details_id_seq OWNER TO postgres;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_installment_details_id_seq OWNED BY public.emp_installment_details.id;


--
-- Name: emp_installments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_installments (
    id bigint NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Status" text NOT NULL,
    "Emp" bigint,
    "Loan" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installments OWNER TO postgres;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installments_id_seq OWNER TO postgres;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_installments_id_seq OWNED BY public.emp_installments.id;


--
-- Name: emp_mails; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_mails (
    id bigint NOT NULL,
    "Message" text,
    "Emp" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_mails OWNER TO postgres;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_mails_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_mails_id_seq OWNER TO postgres;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_mails_id_seq OWNED BY public.emp_mails.id;


--
-- Name: emp_movements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_movements (
    id bigint NOT NULL,
    "Date" text,
    "Time" text,
    "Emp" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_movements OWNER TO postgres;

--
-- Name: emp_movements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_movements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_movements_id_seq OWNER TO postgres;

--
-- Name: emp_movements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_movements_id_seq OWNED BY public.emp_movements.id;


--
-- Name: emp_p_o_s_stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_p_o_s_stores (
    id bigint NOT NULL,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text
);


ALTER TABLE public.emp_p_o_s_stores OWNER TO postgres;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_p_o_s_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_p_o_s_stores_id_seq OWNER TO postgres;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_p_o_s_stores_id_seq OWNED BY public.emp_p_o_s_stores.id;


--
-- Name: emp_payment_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_payment_accounts (
    id bigint NOT NULL,
    "Emp" text,
    "Account" text,
    "Account_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_payment_accounts OWNER TO postgres;

--
-- Name: emp_payment_accounts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_payment_accounts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_payment_accounts_id_seq OWNER TO postgres;

--
-- Name: emp_payment_accounts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_payment_accounts_id_seq OWNED BY public.emp_payment_accounts.id;


--
-- Name: emp_ratios; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_ratios (
    id bigint NOT NULL,
    "Salary" text NOT NULL,
    "Type" text NOT NULL,
    "Emp" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Typee" text,
    "From" integer,
    "To" integer,
    "Rate" numeric(8,2)
);


ALTER TABLE public.emp_ratios OWNER TO postgres;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_ratios_id_seq OWNER TO postgres;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_ratios_id_seq OWNED BY public.emp_ratios.id;


--
-- Name: emp_recipt_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_recipt_accounts (
    id bigint NOT NULL,
    "Emp" text,
    "Account" text,
    "Account_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_recipt_accounts OWNER TO postgres;

--
-- Name: emp_recipt_accounts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_recipt_accounts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_recipt_accounts_id_seq OWNER TO postgres;

--
-- Name: emp_recipt_accounts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_recipt_accounts_id_seq OWNED BY public.emp_recipt_accounts.id;


--
-- Name: emp_safes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emp_safes (
    id bigint NOT NULL,
    "Safe" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_safes OWNER TO postgres;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emp_safes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_safes_id_seq OWNER TO postgres;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emp_safes_id_seq OWNED BY public.emp_safes.id;


--
-- Name: empassies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.empassies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassies OWNER TO postgres;

--
-- Name: empassies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.empassies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassies_id_seq OWNER TO postgres;

--
-- Name: empassies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.empassies_id_seq OWNED BY public.empassies.id;


--
-- Name: empassy_reserve_dates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.empassy_reserve_dates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Purpose" text,
    "Empassy" text,
    "Booking_Date" text,
    "Cost" text,
    "Pay" text,
    "Residual" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassy_reserve_dates OWNER TO postgres;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.empassy_reserve_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassy_reserve_dates_id_seq OWNER TO postgres;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.empassy_reserve_dates_id_seq OWNED BY public.empassy_reserve_dates.id;


--
-- Name: employesses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.employesses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Emp_Type" text,
    "Salary" text,
    "Attendence" text,
    "Departure" text,
    "Hours_Numbers" text,
    "Days_Numbers" text,
    "Day_Price" text,
    "Precentage_of_Sales" text,
    "Precentage_of_Profits" text,
    "Image" text,
    "Bank_Account" text,
    "Qualifications" text,
    "Address" text,
    "Social_Status" text,
    "ID_Number" text,
    "Contract_Start" text,
    "Contract_End" text,
    "Phone" text,
    "Phone2" text,
    "Email" text,
    "Password" text,
    "Job" bigint,
    "Department" bigint,
    "Account" bigint,
    "Account_Emp" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Precentage_of_Execution" text,
    "Covenant" bigint,
    "Commission" bigint,
    "Price_Level" text,
    "Bill_Num" text,
    "NumbersOfBill" text,
    "EmpSort" text DEFAULT 1,
    "CV" text,
    "ID_Image" text,
    "Criminal_status" text,
    "Contract" text,
    health_certificate text,
    "Search_Card" text,
    "Recruitment_certificate" text,
    employee_profile text,
    duration_criminal_investigation text,
    "Birthdate" text,
    "Attitude_recruiting" text,
    "Job_Number" text,
    date_resignation text,
    "Living" text,
    "Branch" text,
    "Level" text,
    "Religion" text,
    "Insurance_salary" text,
    "Insurance_companies" text,
    "Previous_experience" text,
    "Nationality" text,
    "MonthlyTarget" text,
    "QuarterTarget" text,
    "SemiTarget" text,
    "YearlyTarget" text,
    "IDExpireDate" text,
    "LicensExpireDate" text,
    "PassportExpireDate" text,
    "Merit" text,
    "Pro_Group" text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Active" text DEFAULT 1,
    "Delete" text DEFAULT 0,
    "Attendence2" text,
    "Departure2" text,
    "ShippingCollectionType" text,
    "ShippingCollectionValue" text,
    "Other_Shift" text
);


ALTER TABLE public.employesses OWNER TO postgres;

--
-- Name: employesses_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.employesses_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_arr_seq OWNER TO postgres;

--
-- Name: employesses_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.employesses_arr_seq OWNED BY public.employesses.arr;


--
-- Name: employesses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.employesses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_id_seq OWNER TO postgres;

--
-- Name: employesses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.employesses_id_seq OWNED BY public.employesses.id;


--
-- Name: employment_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.employment_levels (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.employment_levels OWNER TO postgres;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.employment_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employment_levels_id_seq OWNER TO postgres;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.employment_levels_id_seq OWNED BY public.employment_levels.id;


--
-- Name: emps_producation_points; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emps_producation_points (
    id bigint NOT NULL,
    "Month" text,
    "Point" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text
);


ALTER TABLE public.emps_producation_points OWNER TO postgres;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emps_producation_points_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_points_id_seq OWNER TO postgres;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emps_producation_points_id_seq OWNED BY public.emps_producation_points.id;


--
-- Name: emps_producation_quantities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emps_producation_quantities (
    id bigint NOT NULL,
    "FromQ" text,
    "ToQ" text,
    "ValueQ" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emps_producation_quantities OWNER TO postgres;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.emps_producation_quantities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_quantities_id_seq OWNER TO postgres;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.emps_producation_quantities_id_seq OWNED BY public.emps_producation_quantities.id;


--
-- Name: entitlements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entitlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.entitlements OWNER TO postgres;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entitlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_arr_seq OWNER TO postgres;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entitlements_arr_seq OWNED BY public.entitlements.arr;


--
-- Name: entitlements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entitlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_id_seq OWNER TO postgres;

--
-- Name: entitlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entitlements_id_seq OWNED BY public.entitlements.id;


--
-- Name: events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.events (
    id bigint NOT NULL,
    "Start_Date" text,
    "End_Date" text,
    "Event_Ar_Name" text,
    "Event_En_Name" text,
    "Type" text,
    "Type_ID" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    "Customer" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.events OWNER TO postgres;

--
-- Name: events_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.events_id_seq OWNER TO postgres;

--
-- Name: events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.events_id_seq OWNED BY public.events.id;


--
-- Name: examinations_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examinations_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Allow_From" text NOT NULL,
    "Allow_To" text NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.examinations_types OWNER TO postgres;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.examinations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.examinations_types_id_seq OWNER TO postgres;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.examinations_types_id_seq OWNED BY public.examinations_types.id;


--
-- Name: exchange_commissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.exchange_commissions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text,
    "Note" text,
    "Return_Maintaince" text,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Commision" text NOT NULL,
    "Pre_Sales" text NOT NULL,
    "Pre_Execu" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Exchange_Commision" text,
    "Collection" text,
    "Delete" text DEFAULT 0,
    "Ship" text
);


ALTER TABLE public.exchange_commissions OWNER TO postgres;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.exchange_commissions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_arr_seq OWNER TO postgres;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.exchange_commissions_arr_seq OWNED BY public.exchange_commissions."Code";


--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.exchange_commissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_id_seq OWNER TO postgres;

--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.exchange_commissions_id_seq OWNED BY public.exchange_commissions.id;


--
-- Name: execute_job_order_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execute_job_order_models (
    id bigint NOT NULL,
    "Model" text,
    "Qty" text,
    "Total_Cost" text,
    "Outcome" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.execute_job_order_models OWNER TO postgres;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.execute_job_order_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_models_id_seq OWNER TO postgres;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.execute_job_order_models_id_seq OWNED BY public.execute_job_order_models.id;


--
-- Name: execute_job_order_workmanships; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execute_job_order_workmanships (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Net" text
);


ALTER TABLE public.execute_job_order_workmanships OWNER TO postgres;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.execute_job_order_workmanships_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_workmanships_id_seq OWNER TO postgres;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.execute_job_order_workmanships_id_seq OWNED BY public.execute_job_order_workmanships.id;


--
-- Name: execute_job_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.execute_job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Note" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "RecivedDate" text,
    "Recipient" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Transfer" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Model" text,
    "Status" text DEFAULT 0
);


ALTER TABLE public.execute_job_orders OWNER TO postgres;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.execute_job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_arr_seq OWNER TO postgres;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.execute_job_orders_arr_seq OWNED BY public.execute_job_orders."Code";


--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.execute_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_id_seq OWNER TO postgres;

--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.execute_job_orders_id_seq OWNED BY public.execute_job_orders.id;


--
-- Name: executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.executing_receiving_secretariats (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Qty" text,
    "Total" text,
    "Model" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "StoreIn" text,
    "StoreOut" text,
    "Client" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Workmanship_Price" text
);


ALTER TABLE public.executing_receiving_secretariats OWNER TO postgres;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.executing_receiving_secretariats_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_arr_seq OWNER TO postgres;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.executing_receiving_secretariats_arr_seq OWNED BY public.executing_receiving_secretariats.arr;


--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_id_seq OWNER TO postgres;

--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.executing_receiving_secretariats_id_seq OWNED BY public.executing_receiving_secretariats.id;


--
-- Name: executing_receivings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.executing_receivings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Qty" text NOT NULL,
    "Total" text NOT NULL,
    "Model" bigint NOT NULL,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Time" text,
    "StoreIn" text,
    "StoreOut" text,
    "Sort" text,
    "Vendor" text,
    "Cost_Workmentship" text,
    "Total_Workmentship" text,
    arr bigint
);


ALTER TABLE public.executing_receivings OWNER TO postgres;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.executing_receivings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_arr_seq OWNER TO postgres;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.executing_receivings_arr_seq OWNED BY public.executing_receivings.arr;


--
-- Name: executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_id_seq OWNER TO postgres;

--
-- Name: executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.executing_receivings_id_seq OWNED BY public.executing_receivings.id;


--
-- Name: executor_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.executor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.executor_filters OWNER TO postgres;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.executor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executor_filters_id_seq OWNER TO postgres;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.executor_filters_id_seq OWNED BY public.executor_filters.id;


--
-- Name: expenses_list_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.expenses_list_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_column_sechdules OWNER TO postgres;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.expenses_list_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.expenses_list_column_sechdules_id_seq OWNED BY public.expenses_list_column_sechdules.id;


--
-- Name: expenses_list_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.expenses_list_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_columns OWNER TO postgres;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.expenses_list_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_columns_id_seq OWNER TO postgres;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.expenses_list_columns_id_seq OWNED BY public.expenses_list_columns.id;


--
-- Name: expenses_type_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.expenses_type_projects (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Project" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_type_projects OWNER TO postgres;

--
-- Name: expenses_type_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.expenses_type_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_type_projects_id_seq OWNER TO postgres;

--
-- Name: expenses_type_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.expenses_type_projects_id_seq OWNED BY public.expenses_type_projects.id;


--
-- Name: expire_date_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.expire_date_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.expire_date_qties OWNER TO postgres;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.expire_date_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expire_date_qties_id_seq OWNER TO postgres;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.expire_date_qties_id_seq OWNED BY public.expire_date_qties.id;


--
-- Name: export_checks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.export_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Pay_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.export_checks OWNER TO postgres;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.export_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_arr_seq OWNER TO postgres;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.export_checks_arr_seq OWNED BY public.export_checks."Code";


--
-- Name: export_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.export_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_id_seq OWNER TO postgres;

--
-- Name: export_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.export_checks_id_seq OWNED BY public.export_checks.id;


--
-- Name: f_a_q_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.f_a_q_s (
    id bigint NOT NULL,
    "Arabic_Question" text NOT NULL,
    "English_Question" text NOT NULL,
    "Arabic_Answer" text NOT NULL,
    "English_Answer" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.f_a_q_s OWNER TO postgres;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.f_a_q_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.f_a_q_s_id_seq OWNER TO postgres;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.f_a_q_s_id_seq OWNED BY public.f_a_q_s.id;


--
-- Name: failed_jobs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.failed_jobs (
    id bigint NOT NULL,
    uuid character varying(191) NOT NULL,
    connection text NOT NULL,
    queue text NOT NULL,
    payload text NOT NULL,
    exception text NOT NULL,
    failed_at timestamp(0) without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.failed_jobs OWNER TO postgres;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.failed_jobs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.failed_jobs_id_seq OWNER TO postgres;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.failed_jobs_id_seq OWNED BY public.failed_jobs.id;


--
-- Name: faults_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.faults_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Note" text,
    "Amount" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.faults_types OWNER TO postgres;

--
-- Name: faults_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.faults_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.faults_types_id_seq OWNER TO postgres;

--
-- Name: faults_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.faults_types_id_seq OWNED BY public.faults_types.id;


--
-- Name: fifo_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fifo_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Cost_Price" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Original_Qty" text,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.fifo_qties OWNER TO postgres;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fifo_qties_id_seq OWNER TO postgres;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fifo_qties_id_seq OWNED BY public.fifo_qties.id;


--
-- Name: firewall_ips; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.firewall_ips (
    id integer NOT NULL,
    ip character varying(191) NOT NULL,
    log_id integer,
    blocked boolean DEFAULT true NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_ips OWNER TO postgres;

--
-- Name: firewall_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.firewall_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.firewall_logs_id_seq OWNER TO postgres;

--
-- Name: firewall_logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.firewall_logs (
    id integer DEFAULT nextval('public.firewall_logs_id_seq'::regclass) NOT NULL,
    ip character varying(191) NOT NULL,
    level character varying(191) DEFAULT 'medium'::character varying NOT NULL,
    middleware character varying(191) NOT NULL,
    user_id integer,
    url text,
    referrer character varying(191),
    request text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_logs OWNER TO postgres;

--
-- Name: follow_lists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.follow_lists (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.follow_lists OWNER TO postgres;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.follow_lists_id_seq OWNER TO postgres;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.follow_lists_id_seq OWNED BY public.follow_lists.id;


--
-- Name: general_dailies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.general_dailies (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Type" text NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Draw" text NOT NULL,
    "Debitor_Coin" text NOT NULL,
    "Creditor_Coin" text NOT NULL,
    "Account" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    userr bigint,
    "Code_Type" text,
    "Branch" text,
    "TypeEn" text,
    arr bigint
);


ALTER TABLE public.general_dailies OWNER TO postgres;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.general_dailies_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_arr_seq OWNER TO postgres;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.general_dailies_arr_seq OWNED BY public.general_dailies.arr;


--
-- Name: general_dailies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.general_dailies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_id_seq OWNER TO postgres;

--
-- Name: general_dailies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.general_dailies_id_seq OWNED BY public.general_dailies.id;


--
-- Name: goods_product_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.goods_product_projects (
    id bigint NOT NULL,
    "Goods" text,
    "Product" text,
    "P_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Unit" text,
    "Qty" text,
    "AvQty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.goods_product_projects OWNER TO postgres;

--
-- Name: goods_product_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.goods_product_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.goods_product_projects_id_seq OWNER TO postgres;

--
-- Name: goods_product_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.goods_product_projects_id_seq OWNED BY public.goods_product_projects.id;


--
-- Name: goods_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.goods_projects (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Store" text,
    "Cost_Center" text,
    "Responsible" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Note" text,
    "Project" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.goods_projects OWNER TO postgres;

--
-- Name: goods_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.goods_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.goods_projects_id_seq OWNER TO postgres;

--
-- Name: goods_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.goods_projects_id_seq OWNED BY public.goods_projects.id;


--
-- Name: governrates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.governrates (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Country" text,
    "SearchCode" text
);


ALTER TABLE public.governrates OWNER TO postgres;

--
-- Name: governrates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.governrates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.governrates_id_seq OWNER TO postgres;

--
-- Name: governrates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.governrates_id_seq OWNED BY public.governrates.id;


--
-- Name: group_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.group_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.group_filters OWNER TO postgres;

--
-- Name: group_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.group_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.group_filters_id_seq OWNER TO postgres;

--
-- Name: group_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.group_filters_id_seq OWNED BY public.group_filters.id;


--
-- Name: holidays; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.holidays (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Num_of_Days" text NOT NULL,
    "Start_Date" text NOT NULL,
    "Discount" text NOT NULL,
    "Status" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.holidays OWNER TO postgres;

--
-- Name: holidays_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.holidays_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_arr_seq OWNER TO postgres;

--
-- Name: holidays_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.holidays_arr_seq OWNED BY public.holidays.arr;


--
-- Name: holidays_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.holidays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_id_seq OWNER TO postgres;

--
-- Name: holidays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.holidays_id_seq OWNED BY public.holidays.id;


--
-- Name: holidays_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.holidays_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Days" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Date" text,
    "To_Date" text
);


ALTER TABLE public.holidays_types OWNER TO postgres;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.holidays_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_types_id_seq OWNER TO postgres;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.holidays_types_id_seq OWNED BY public.holidays_types.id;


--
-- Name: home_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.home_e_com_designs (
    id bigint NOT NULL,
    "Slider_BG_Type" text,
    "Slider_BG_Image" text,
    "Slider_BG_Color" text,
    "Slider_Button_BG_Color" text,
    "Slider_Button_Txt_Color" text,
    "Slider_Button_Hover_BG_Color" text,
    "Slider_Button_Hover_Txt_Color" text,
    "Slider_Title_Txt_Color" text,
    "Slider_Desc_Txt_Color" text,
    "Ads_Top_Img_First_BG_Color" text,
    "Ads_Top_Img_First_Before_BG_Color" text,
    "Ads_Top_Img_Second_BG_Color" text,
    "Ads_Top_Img_Second_Before_BG_Color" text,
    "Ads_Top_Img_Button_BG_Color" text,
    "Ads_Top_Img_Button_Txt_Color" text,
    "Ads_Top_Img_Button_Hover_BG_Color" text,
    "Ads_Top_Img_Button_Hover_Txt_Color" text,
    "Support_Icons_BG_Color" text,
    "Support_Icons_Txt_Color" text,
    "Support_Icons_Color" text,
    "Ads_Bootom_Imgs_BG_Color" text,
    "Ads_Bootom_Imgs_Middle_BG_Color" text,
    "Ads_Bootom_Imgs_Button_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Txt_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_Txt_Color" text,
    "Partners_BG_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.home_e_com_designs OWNER TO postgres;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.home_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.home_e_com_designs_id_seq OWNED BY public.home_e_com_designs.id;


--
-- Name: home_product_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.home_product_e_com_designs (
    id bigint NOT NULL,
    "Special_Offer_Title_BG_Color" text,
    "Special_Offer_Title_Txt_Color" text,
    "Special_Offer_Product_BG_Color" text,
    "Special_Offer_Product_Border_Color" text,
    "Special_Offer_Product_Txt_Color" text,
    "Special_Offer_Product_Price_Color" text,
    "Special_Offer_Product_Rate_Color" text,
    "Best_Sellers_Title_BG_Color" text,
    "Best_Sellers_Title_Txt_Color" text,
    "Best_Sellers_Category_Txt_Color" text,
    "Best_Sellers_Category_Active_Txt_Color" text,
    "Best_Sellers_Product_BG_Color" text,
    "Best_Sellers_Product_Group_BG_Color" text,
    "Best_Sellers_Product_Group_Txt_Color" text,
    "Best_Sellers_Product_Group_Hover_BG_Color" text,
    "Best_Sellers_Product_Group_Hover_Txt_Color" text,
    "Best_Sellers_Product_Icon_BG_Color" text,
    "Best_Sellers_Product_Icon_Txt_Color" text,
    "Best_Sellers_Product_Icon_Hover_BG_Color" text,
    "Best_Sellers_Product_Icon_Hover_Txt_Color" text,
    "Best_Sellers_Product_Txt_Color" text,
    "Best_Sellers_Product_Price_Color" text,
    "Best_Sellers_Product_Rate_Color" text,
    "New_Arrivals_Title_BG_Color" text,
    "New_Arrivals_Title_Txt_Color" text,
    "New_Arrivals_Product_BG_Color" text,
    "New_Arrivals_Product_Group_BG_Color" text,
    "New_Arrivals_Product_Group_Txt_Color" text,
    "New_Arrivals_Product_Group_Hover_BG_Color" text,
    "New_Arrivals_Product_Group_Hover_Txt_Color" text,
    "New_Arrivals_Product_Icon_BG_Color" text,
    "New_Arrivals_Product_Icon_Txt_Color" text,
    "New_Arrivals_Product_Icon_Hover_BG_Color" text,
    "New_Arrivals_Product_Icon_Hover_Txt_Color" text,
    "New_Arrivals_Product_Txt_Color" text,
    "New_Arrivals_Product_Price_Color" text,
    "New_Arrivals_Product_Hover_Price_Color" text,
    "New_Arrivals_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Special_Offer_Product_Txt_Hover_Color" text
);


ALTER TABLE public.home_product_e_com_designs OWNER TO postgres;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.home_product_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_product_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.home_product_e_com_designs_id_seq OWNED BY public.home_product_e_com_designs.id;


--
-- Name: import_expenses_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.import_expenses_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.import_expenses_types OWNER TO postgres;

--
-- Name: import_expenses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.import_expenses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_expenses_types_id_seq OWNER TO postgres;

--
-- Name: import_expenses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.import_expenses_types_id_seq OWNED BY public.import_expenses_types.id;


--
-- Name: import_new_prods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.import_new_prods (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Group" text NOT NULL,
    "Brand" text,
    "Unit" text NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price_1" text NOT NULL,
    "Price_2" text,
    "Price_3" text,
    "Def" text NOT NULL,
    "Num" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text,
    "Search_Code" text
);


ALTER TABLE public.import_new_prods OWNER TO postgres;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.import_new_prods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_id_seq OWNER TO postgres;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.import_new_prods_id_seq OWNED BY public.import_new_prods.id;


--
-- Name: import_new_prods_starts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.import_new_prods_starts (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Group" text,
    "Brand" text,
    "Unit" text,
    "Rate" text,
    "Barcode" text,
    "Price_1" text,
    "Price_2" text,
    "Price_3" text,
    "Def" text,
    "Num" text,
    "Store" text,
    "Qty" text,
    "CostPrice" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text,
    "Search_Code" text
);


ALTER TABLE public.import_new_prods_starts OWNER TO postgres;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.import_new_prods_starts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_starts_id_seq OWNER TO postgres;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.import_new_prods_starts_id_seq OWNED BY public.import_new_prods_starts.id;


--
-- Name: in_out_logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.in_out_logs (
    id bigint NOT NULL,
    user_id integer NOT NULL,
    in_time time(0) without time zone,
    out_time time(0) without time zone,
    time_calc double precision,
    date date,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.in_out_logs OWNER TO postgres;

--
-- Name: in_out_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.in_out_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.in_out_logs_id_seq OWNER TO postgres;

--
-- Name: in_out_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.in_out_logs_id_seq OWNED BY public.in_out_logs.id;


--
-- Name: incom_checks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.incom_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text NOT NULL,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Arrest_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.incom_checks OWNER TO postgres;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.incom_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_arr_seq OWNER TO postgres;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.incom_checks_arr_seq OWNED BY public.incom_checks."Code";


--
-- Name: incom_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.incom_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_id_seq OWNER TO postgres;

--
-- Name: incom_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.incom_checks_id_seq OWNED BY public.incom_checks.id;


--
-- Name: incom_manufacturing_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.incom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Cost" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Depreciation" text NOT NULL,
    "Depreciation_Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.incom_manufacturing_models OWNER TO postgres;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.incom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_models_id_seq OWNER TO postgres;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.incom_manufacturing_models_id_seq OWNED BY public.incom_manufacturing_models.id;


--
-- Name: incom_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.incom_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Precent" text,
    "Qty" text,
    "Cost" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Depreciation" text,
    "Depreciation_Qty" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.incom_manufacturing_secretariat_models OWNER TO postgres;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.incom_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_secretariat_models_id_seq OWNER TO postgres;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.incom_manufacturing_secretariat_models_id_seq OWNED BY public.incom_manufacturing_secretariat_models.id;


--
-- Name: install_companies_sales_bills_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.install_companies_sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns OWNER TO postgres;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_id_seq OWNER TO postgres;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_id_seq OWNED BY public.install_companies_sales_bills_columns.id;


--
-- Name: install_companies_sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.install_companies_sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns_sechdules OWNER TO postgres;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq OWNED BY public.install_companies_sales_bills_columns_sechdules.id;


--
-- Name: installment_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.installment_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Logo" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text,
    "NakdyaAccount" text
);


ALTER TABLE public.installment_companies OWNER TO postgres;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.installment_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_id_seq OWNER TO postgres;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.installment_companies_id_seq OWNED BY public.installment_companies.id;


--
-- Name: installment_companies_ratios; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.installment_companies_ratios (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Service_Fee" text,
    "Company_Precent" text,
    "Company" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_companies_ratios OWNER TO postgres;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.installment_companies_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_ratios_id_seq OWNER TO postgres;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.installment_companies_ratios_id_seq OWNED BY public.installment_companies_ratios.id;


--
-- Name: installment_dates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.installment_dates (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_dates OWNER TO postgres;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.installment_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_dates_id_seq OWNER TO postgres;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.installment_dates_id_seq OWNED BY public.installment_dates.id;


--
-- Name: installments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.installments (
    id bigint NOT NULL,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Residual" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installments OWNER TO postgres;

--
-- Name: installments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installments_id_seq OWNER TO postgres;

--
-- Name: installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.installments_id_seq OWNED BY public.installments.id;


--
-- Name: insurance_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.insurance_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.insurance_companies OWNER TO postgres;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.insurance_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_companies_id_seq OWNER TO postgres;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.insurance_companies_id_seq OWNED BY public.insurance_companies.id;


--
-- Name: insurance_papers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.insurance_papers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint,
    arr bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" text,
    "To" text,
    "File" text,
    "FromEn" text,
    "ToEn" text,
    "Delete" text
);


ALTER TABLE public.insurance_papers OWNER TO postgres;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.insurance_papers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_arr_seq OWNER TO postgres;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.insurance_papers_arr_seq OWNED BY public.insurance_papers."Code";


--
-- Name: insurance_papers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.insurance_papers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_id_seq OWNER TO postgres;

--
-- Name: insurance_papers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.insurance_papers_id_seq OWNED BY public.insurance_papers.id;


--
-- Name: interviews; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.interviews (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Rate" text DEFAULT '0'::text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Client" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "StatusNote" text
);


ALTER TABLE public.interviews OWNER TO postgres;

--
-- Name: interviews_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.interviews_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_arr_seq OWNER TO postgres;

--
-- Name: interviews_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.interviews_arr_seq OWNED BY public.interviews.arr;


--
-- Name: interviews_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.interviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_id_seq OWNER TO postgres;

--
-- Name: interviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.interviews_id_seq OWNED BY public.interviews.id;


--
-- Name: interviews_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.interviews_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.interviews_types OWNER TO postgres;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.interviews_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_types_id_seq OWNER TO postgres;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.interviews_types_id_seq OWNED BY public.interviews_types.id;


--
-- Name: intros; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.intros (
    id bigint NOT NULL,
    "Arabic_About" text,
    "English_About" text,
    "Phone_1" text,
    "Phone_2" text,
    "Phone_3" text,
    "Phone_4" text,
    "Arabic_Terms" text,
    "English_Terms" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Arabic_Privacy" text,
    "English_Privacy" text
);


ALTER TABLE public.intros OWNER TO postgres;

--
-- Name: intros_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.intros_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.intros_id_seq OWNER TO postgres;

--
-- Name: intros_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.intros_id_seq OWNED BY public.intros.id;


--
-- Name: inventories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.inventories (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Settle" character varying DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.inventories OWNER TO postgres;

--
-- Name: inventories_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.inventories_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_arr_seq OWNER TO postgres;

--
-- Name: inventories_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.inventories_arr_seq OWNED BY public.inventories.arr;


--
-- Name: inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_id_seq OWNER TO postgres;

--
-- Name: inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.inventories_id_seq OWNED BY public.inventories.id;


--
-- Name: investors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.investors (
    id bigint NOT NULL,
    "Date" text,
    "Name" text,
    "Investment_Value" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    "Profit_Precent" text,
    "Investment_Period" text,
    "Liquidation_Time" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "End_Date" text,
    "Account" text,
    "Due_Account" text,
    "Expenses_Account" text
);


ALTER TABLE public.investors OWNER TO postgres;

--
-- Name: investors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investors_id_seq OWNER TO postgres;

--
-- Name: investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.investors_id_seq OWNED BY public.investors.id;


--
-- Name: issues; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issues (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Client" text,
    "Link" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.issues OWNER TO postgres;

--
-- Name: issues_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issues_id_seq OWNER TO postgres;

--
-- Name: issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.issues_id_seq OWNED BY public.issues.id;


--
-- Name: items_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.items_groups (
    id bigint NOT NULL,
    "Code" text,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text,
    "Store_Show" text,
    "Sales_Show" text,
    "NameEn" text,
    "Printer" text,
    "Arrange" bigint,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.items_groups OWNER TO postgres;

--
-- Name: items_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.items_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.items_groups_id_seq OWNER TO postgres;

--
-- Name: items_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.items_groups_id_seq OWNED BY public.items_groups.id;


--
-- Name: itineraries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.itineraries (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itineraries OWNER TO postgres;

--
-- Name: itineraries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.itineraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itineraries_id_seq OWNER TO postgres;

--
-- Name: itineraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.itineraries_id_seq OWNED BY public.itineraries.id;


--
-- Name: itinerary_visits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.itinerary_visits (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Day" text,
    "Time" text,
    "Status" text,
    "Note" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itinerary_visits OWNER TO postgres;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.itinerary_visits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_visits_id_seq OWNER TO postgres;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.itinerary_visits_id_seq OWNED BY public.itinerary_visits.id;


--
-- Name: job_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "ShipStatus" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Later_Due" text,
    "Later_Collection" text,
    "TaxBill" text,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "Recipient" text,
    "RecivedVoucherCode" text,
    "TransferOrder" text,
    "ExecuteOrder" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Execute" text
);


ALTER TABLE public.job_orders OWNER TO postgres;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_arr_seq OWNER TO postgres;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.job_orders_arr_seq OWNED BY public.job_orders."Code";


--
-- Name: job_orders_executors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.job_orders_executors (
    id bigint NOT NULL,
    "Product" text,
    "Executor" text,
    "Order" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.job_orders_executors OWNER TO postgres;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.job_orders_executors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_executors_id_seq OWNER TO postgres;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.job_orders_executors_id_seq OWNED BY public.job_orders_executors.id;


--
-- Name: job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_id_seq OWNER TO postgres;

--
-- Name: job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.job_orders_id_seq OWNED BY public.job_orders.id;


--
-- Name: jobs_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.jobs_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.jobs_types OWNER TO postgres;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.jobs_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jobs_types_id_seq OWNER TO postgres;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.jobs_types_id_seq OWNED BY public.jobs_types.id;


--
-- Name: journalizing_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.journalizing_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Account" bigint NOT NULL,
    "Joun_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Statement" text
);


ALTER TABLE public.journalizing_details OWNER TO postgres;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.journalizing_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizing_details_id_seq OWNER TO postgres;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.journalizing_details_id_seq OWNED BY public.journalizing_details.id;


--
-- Name: journalizings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.journalizings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Debaitor" character varying,
    "Total_Creditor" character varying,
    "Note" character varying,
    "Type" character varying,
    "Code_Type" text,
    "Branch" bigint,
    "Status" text,
    "TypeEn" text,
    arr bigint,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Transfer" text
);


ALTER TABLE public.journalizings OWNER TO postgres;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.journalizings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_arr_seq OWNER TO postgres;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.journalizings_arr_seq OWNED BY public.journalizings.arr;


--
-- Name: journalizings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.journalizings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_id_seq OWNER TO postgres;

--
-- Name: journalizings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.journalizings_id_seq OWNED BY public.journalizings.id;


--
-- Name: languages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.languages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.languages OWNER TO postgres;

--
-- Name: languages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.languages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.languages_id_seq OWNER TO postgres;

--
-- Name: languages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.languages_id_seq OWNED BY public.languages.id;


--
-- Name: loan_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.loan_types OWNER TO postgres;

--
-- Name: loan_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_types_id_seq OWNER TO postgres;

--
-- Name: loan_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_types_id_seq OWNED BY public.loan_types.id;


--
-- Name: loans; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loans (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.loans OWNER TO postgres;

--
-- Name: loans_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loans_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_arr_seq OWNER TO postgres;

--
-- Name: loans_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loans_arr_seq OWNED BY public.loans."Code";


--
-- Name: loans_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_id_seq OWNER TO postgres;

--
-- Name: loans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loans_id_seq OWNED BY public.loans.id;


--
-- Name: login_sliders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.login_sliders (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.login_sliders OWNER TO postgres;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.login_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.login_sliders_id_seq OWNER TO postgres;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.login_sliders_id_seq OWNED BY public.login_sliders.id;


--
-- Name: main_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.main_e_com_designs (
    id bigint NOT NULL,
    "Font_Type" text,
    "Pagination_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Body_BG_Type" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text,
    "Sub_Page_BG_Color" text,
    "Breadcumb_BG_Color" text,
    "Breadcumb_Txt_Color" text,
    "Modal_BG_Color" text,
    "Modal_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Modal_Button_Txt_Color" text,
    "Table_Header_BG_Color" text,
    "Table_Header_Txt_Color" text,
    "Table_Body_BG_Color" text,
    "Table_Body_Txt_Color" text,
    "Table_Button_BG_Color" text,
    "Table_Button_Txt_Color" text,
    "CopyRights_Txt_Color" text,
    "CopyRights_Klar_Txt_Color" text,
    "CopyRights_Klar_Hover_Txt_Color" text,
    "Preloader_BG_Color" text,
    "Preloader_Small_Circle_Color" text,
    "Preloader_Large_Circle_Color" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_BG_Color" text,
    "Footer_Social_Hover_Txt_Color" text,
    "Header_Top_BG_Color" text,
    "Header_Top_Txt_Color" text,
    "Header_Top_Txt_Hover_Color" text,
    "Header_Middle_BG_Color" text,
    "Header_Middle_Icon_Color" text,
    "Header_Middle_Icon_Hover_Color" text,
    "Header_SearchBar_BG_Color" text,
    "Header_SearchBar_Txt_Color" text,
    "Header_SearchBar_Icon_BG_Color" text,
    "Header_SearchBar_Icon_Txt_Color" text,
    "Header_SearchBar_Icon_Hover_BG_Color" text,
    "Header_SearchBar_Icon_Hover_Txt_Color" text,
    "Navbar_BG_Color" text,
    "Navbar_Txt_Color" text,
    "Navbar_Hover_BG_Color" text,
    "Navbar_Hover_Txt_Color" text,
    "Navbar_Category_BG_Color" text,
    "Navbar_Category_Txt_Color" text,
    "Navbar_Category_Box_BG_Color" text,
    "Navbar_Category_Box_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Footer_Social_BG_Color" text,
    "Footer_Txt_Hover_Color" text
);


ALTER TABLE public.main_e_com_designs OWNER TO postgres;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.main_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.main_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.main_e_com_designs_id_seq OWNED BY public.main_e_com_designs.id;


--
-- Name: maintainc_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.maintainc_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Total_Price_Errors" text,
    "Totaal" text,
    "Safe" bigint
);


ALTER TABLE public.maintainc_bills OWNER TO postgres;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.maintainc_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_arr_seq OWNER TO postgres;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.maintainc_bills_arr_seq OWNED BY public.maintainc_bills.arr;


--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_id_seq OWNER TO postgres;

--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.maintainc_bills_id_seq OWNED BY public.maintainc_bills.id;


--
-- Name: maintaince_colors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.maintaince_colors (
    id bigint NOT NULL,
    "Refuse" text,
    "Reported_Client" text,
    "Refused_Client" text,
    "Edited" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_colors OWNER TO postgres;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.maintaince_colors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_colors_id_seq OWNER TO postgres;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.maintaince_colors_id_seq OWNED BY public.maintaince_colors.id;


--
-- Name: maintaince_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.maintaince_default_data (
    id bigint NOT NULL,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Draw" text,
    "Client" text,
    "Sure" text,
    "Eng" text,
    "Recipient" text,
    "Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_default_data OWNER TO postgres;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.maintaince_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_default_data_id_seq OWNER TO postgres;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.maintaince_default_data_id_seq OWNED BY public.maintaince_default_data.id;


--
-- Name: manu_store_counts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manu_store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manu_store_counts OWNER TO postgres;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manu_store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manu_store_counts_id_seq OWNER TO postgres;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manu_store_counts_id_seq OWNED BY public.manu_store_counts.id;


--
-- Name: manufacture_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacture_companies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacture_companies OWNER TO postgres;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacture_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacture_companies_id_seq OWNER TO postgres;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacture_companies_id_seq OWNED BY public.manufacture_companies.id;


--
-- Name: manufacturing_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_default_data (
    id bigint NOT NULL,
    "Coin" text,
    "Draw" text,
    "Hall" text,
    "Manu_Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executing_Qty" text
);


ALTER TABLE public.manufacturing_default_data OWNER TO postgres;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_default_data_id_seq OWNER TO postgres;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_default_data_id_seq OWNED BY public.manufacturing_default_data.id;


--
-- Name: manufacturing_executions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_executions (
    id bigint NOT NULL,
    "Code" text,
    "NewCode" text,
    "Date" text,
    "Manu_Order_Code" text,
    "Manu_Order_Date" text,
    "Recived_Date" text,
    "Manu_Request_Code" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Patch_Number" text,
    "Manu_Order_ID" bigint,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "Model" bigint,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_executions OWNER TO postgres;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_executions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_arr_seq OWNER TO postgres;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_executions_arr_seq OWNED BY public.manufacturing_executions.arr;


--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_id_seq OWNER TO postgres;

--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_executions_id_seq OWNED BY public.manufacturing_executions.id;


--
-- Name: manufacturing_halls; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_halls (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_halls OWNER TO postgres;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_halls_id_seq OWNER TO postgres;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_halls_id_seq OWNED BY public.manufacturing_halls.id;


--
-- Name: manufacturing_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_models (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Time" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Hall" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text DEFAULT 1,
    "NameEn" text,
    "Incom_Store" text,
    "Outcom_Store" text,
    "Workmanship_Price" text
);


ALTER TABLE public.manufacturing_models OWNER TO postgres;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_arr_seq OWNER TO postgres;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_models_arr_seq OWNED BY public.manufacturing_models."Code";


--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_id_seq OWNER TO postgres;

--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_models_id_seq OWNED BY public.manufacturing_models.id;


--
-- Name: manufacturing_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Model" text,
    "Name_Outcome" text,
    "Except_Qty" text,
    "Total_Required_Qty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "For_Client" text,
    "Client" bigint,
    "Client_Phone" text,
    "Client_Address" text,
    "Delegate" bigint,
    arr bigint,
    "Delegate_Phone" text,
    "Recived_Date" text,
    "Manufacture_Request_Code" bigint,
    "NewCode" text,
    "Recipient" text
);


ALTER TABLE public.manufacturing_orders OWNER TO postgres;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_arr_seq OWNER TO postgres;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_orders_arr_seq OWNED BY public.manufacturing_orders.arr;


--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_id_seq OWNER TO postgres;

--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_orders_id_seq OWNED BY public.manufacturing_orders.id;


--
-- Name: manufacturing_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Recived_Date" text,
    "Client_Phone" text,
    "Client_Address" text,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Delegate_Phone" text,
    "Payment_Method" text,
    "Later_Due" text,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Store" bigint
);


ALTER TABLE public.manufacturing_requests OWNER TO postgres;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_arr_seq OWNER TO postgres;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_requests_arr_seq OWNED BY public.manufacturing_requests.arr;


--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_id_seq OWNER TO postgres;

--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_requests_id_seq OWNED BY public.manufacturing_requests.id;


--
-- Name: manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Name" text,
    "Time" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Hall" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    arr bigint,
    "Incom_Store" text DEFAULT 0,
    "Outcom_Store" text DEFAULT 0
);


ALTER TABLE public.manufacturing_secretariat_models OWNER TO postgres;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_secretariat_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_arr_seq OWNER TO postgres;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_secretariat_models_arr_seq OWNED BY public.manufacturing_secretariat_models.arr;


--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_id_seq OWNER TO postgres;

--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.manufacturing_secretariat_models_id_seq OWNED BY public.manufacturing_secretariat_models.id;


--
-- Name: measuerments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.measuerments (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "NameEn" text
);


ALTER TABLE public.measuerments OWNER TO postgres;

--
-- Name: measuerments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.measuerments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.measuerments_id_seq OWNER TO postgres;

--
-- Name: measuerments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.measuerments_id_seq OWNED BY public.measuerments.id;


--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 2147483647
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO postgres;

--
-- Name: migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrations (
    id integer DEFAULT nextval('public.migrations_id_seq'::regclass) NOT NULL,
    migration character varying(191),
    batch integer
);


ALTER TABLE public.migrations OWNER TO postgres;

--
-- Name: missions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.missions (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "Status" text NOT NULL,
    "File" text,
    "Desc" text,
    "Task_Owner" bigint,
    "Observer" bigint,
    "Project" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.missions OWNER TO postgres;

--
-- Name: missions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.missions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.missions_id_seq OWNER TO postgres;

--
-- Name: missions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.missions_id_seq OWNED BY public.missions.id;


--
-- Name: model_has_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.model_has_permissions (
    permission_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_permissions OWNER TO postgres;

--
-- Name: model_has_roles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.model_has_roles (
    role_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_roles OWNER TO postgres;

--
-- Name: module_settings_nums; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.module_settings_nums (
    id bigint NOT NULL,
    "Branch_Select" text,
    "Branch_Num" text,
    "Store_Select" text,
    "Store_Num" text,
    "Users_Select" text,
    "Users_Num" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "System" text,
    "Expire_Date" text,
    "Type" text,
    "Price" text,
    "Edit_System" text,
    "Delete_System" text,
    "Fingerprint" text,
    "Fingerprint_IP" text,
    "Fingerprint_Name" text,
    "Fingerprint_Attendence" text
);


ALTER TABLE public.module_settings_nums OWNER TO postgres;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.module_settings_nums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.module_settings_nums_id_seq OWNER TO postgres;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.module_settings_nums_id_seq OWNED BY public.module_settings_nums.id;


--
-- Name: modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.modules (
    id bigint NOT NULL,
    "Capital" text,
    "Accounts" text,
    "Stores" text,
    "CRM" text,
    "HR" text,
    "Manufacturing" text,
    "Maintenance" text,
    "Secretariat" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Petrol" text,
    "ECommerce" text,
    "Shipping" text DEFAULT 0,
    "Bill_Electronic" text,
    "Hotels" text,
    "Resturant" text,
    "Traning_Center" text,
    "Translate" text,
    "Real_States" text DEFAULT 0
);


ALTER TABLE public.modules OWNER TO postgres;

--
-- Name: modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.modules_id_seq OWNER TO postgres;

--
-- Name: modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.modules_id_seq OWNED BY public.modules.id;


--
-- Name: more_products_halls; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.more_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.more_products_halls OWNER TO postgres;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.more_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.more_products_halls_id_seq OWNER TO postgres;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.more_products_halls_id_seq OWNED BY public.more_products_halls.id;


--
-- Name: most_sales_products_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.most_sales_products_column_sechdules (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_column_sechdules OWNER TO postgres;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.most_sales_products_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.most_sales_products_column_sechdules_id_seq OWNED BY public.most_sales_products_column_sechdules.id;


--
-- Name: most_sales_products_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.most_sales_products_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_columns OWNER TO postgres;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.most_sales_products_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_columns_id_seq OWNER TO postgres;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.most_sales_products_columns_id_seq OWNED BY public.most_sales_products_columns.id;


--
-- Name: msg_rqsts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.msg_rqsts (
    id bigint NOT NULL,
    "Name" text,
    "Email" text,
    "Phone" text,
    "Subject" text,
    "Msg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.msg_rqsts OWNER TO postgres;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.msg_rqsts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.msg_rqsts_id_seq OWNER TO postgres;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.msg_rqsts_id_seq OWNED BY public.msg_rqsts.id;


--
-- Name: my_follow_lists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.my_follow_lists (
    id bigint NOT NULL,
    "Date" text,
    "Emp" text,
    "Day" text,
    "Status" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.my_follow_lists OWNER TO postgres;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.my_follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.my_follow_lists_id_seq OWNER TO postgres;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.my_follow_lists_id_seq OWNED BY public.my_follow_lists.id;


--
-- Name: new_shipping_categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.new_shipping_categories (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_categories OWNER TO postgres;

--
-- Name: new_shipping_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.new_shipping_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_categories_id_seq OWNER TO postgres;

--
-- Name: new_shipping_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.new_shipping_categories_id_seq OWNED BY public.new_shipping_categories.id;


--
-- Name: new_shipping_rqst_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.new_shipping_rqst_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_rqst_types OWNER TO postgres;

--
-- Name: new_shipping_rqst_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.new_shipping_rqst_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_rqst_types_id_seq OWNER TO postgres;

--
-- Name: new_shipping_rqst_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.new_shipping_rqst_types_id_seq OWNED BY public.new_shipping_rqst_types.id;


--
-- Name: new_shipping_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.new_shipping_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.new_shipping_types OWNER TO postgres;

--
-- Name: new_shipping_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.new_shipping_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.new_shipping_types_id_seq OWNER TO postgres;

--
-- Name: new_shipping_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.new_shipping_types_id_seq OWNED BY public.new_shipping_types.id;


--
-- Name: notifications; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.notifications (
    id bigint NOT NULL,
    "Date" text,
    "Status" text,
    "Noti_Ar_Name" text,
    "Noti_En_Name" text,
    "Type" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Safe" text,
    "TypeEn" text
);


ALTER TABLE public.notifications OWNER TO postgres;

--
-- Name: notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notifications_id_seq OWNER TO postgres;

--
-- Name: notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.notifications_id_seq OWNED BY public.notifications.id;


--
-- Name: opening_entries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opening_entries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Capital" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SecAccount" bigint,
    "Status" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text
);


ALTER TABLE public.opening_entries OWNER TO postgres;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.opening_entries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_arr_seq OWNER TO postgres;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.opening_entries_arr_seq OWNED BY public.opening_entries.arr;


--
-- Name: opening_entries_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opening_entries_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "OP_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.opening_entries_details OWNER TO postgres;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.opening_entries_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_details_id_seq OWNER TO postgres;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.opening_entries_details_id_seq OWNED BY public.opening_entries_details.id;


--
-- Name: opening_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.opening_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_id_seq OWNER TO postgres;

--
-- Name: opening_entries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.opening_entries_id_seq OWNED BY public.opening_entries.id;


--
-- Name: order_pays; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.order_pays (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Responsible" text,
    "Account" text,
    "Amount" text,
    "Note" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.order_pays OWNER TO postgres;

--
-- Name: order_pays_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.order_pays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.order_pays_id_seq OWNER TO postgres;

--
-- Name: order_pays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.order_pays_id_seq OWNED BY public.order_pays.id;


--
-- Name: outcom_manufacturing_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.outcom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.outcom_manufacturing_models OWNER TO postgres;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.outcom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcom_manufacturing_models_id_seq OWNER TO postgres;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.outcom_manufacturing_models_id_seq OWNED BY public.outcom_manufacturing_models.id;


--
-- Name: outcome_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.outcome_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "SmallQty" text,
    "SmallCode" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    "Cost" text,
    "Workmanship_Price" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.outcome_manufacturing_secretariat_models OWNER TO postgres;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcome_manufacturing_secretariat_models_id_seq OWNER TO postgres;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq OWNED BY public.outcome_manufacturing_secretariat_models.id;


--
-- Name: over_times; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.over_times (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Hour" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.over_times OWNER TO postgres;

--
-- Name: over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.over_times_id_seq OWNER TO postgres;

--
-- Name: over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.over_times_id_seq OWNED BY public.over_times.id;


--
-- Name: pack_prems; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pack_prems (
    id bigint NOT NULL,
    package text,
    premission text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pack_prems OWNER TO postgres;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pack_prems_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pack_prems_id_seq OWNER TO postgres;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pack_prems_id_seq OWNED BY public.pack_prems.id;


--
-- Name: packages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.packages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.packages OWNER TO postgres;

--
-- Name: packages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.packages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.packages_id_seq OWNER TO postgres;

--
-- Name: packages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.packages_id_seq OWNED BY public.packages.id;


--
-- Name: partners; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.partners (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Shares_Number" text NOT NULL,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Profits_Precentage" text,
    "Profits" text,
    "Withdraw_Profits" text,
    "Remaining_Profits" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Gary_Account" text,
    "Recent_Profit_Account" text,
    "Stage_Profit_Account" text,
    "First_Partner_Share" text,
    "Now_Partner_Share" text,
    "Capital_Increase_Rate" text,
    "Capital_Increase_Value" text,
    "Partnership_Ratio" text
);


ALTER TABLE public.partners OWNER TO postgres;

--
-- Name: partners_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.partners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.partners_id_seq OWNER TO postgres;

--
-- Name: partners_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.partners_id_seq OWNED BY public.partners.id;


--
-- Name: password_resets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.password_resets (
    email character varying(191) NOT NULL,
    token character varying(191) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO postgres;

--
-- Name: pay_profit_investors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pay_profit_investors (
    id bigint NOT NULL,
    "Date" text,
    "Profit" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pay_profit_investors OWNER TO postgres;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pay_profit_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_profit_investors_id_seq OWNER TO postgres;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pay_profit_investors_id_seq OWNED BY public.pay_profit_investors.id;


--
-- Name: pay_salaries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pay_salaries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Salary" text NOT NULL,
    "Pre_Sales" text,
    "Pre_Execu" text,
    "Deduction" text NOT NULL,
    "Entitlement" text NOT NULL,
    "Borrow" text NOT NULL,
    "Overtime" text,
    "Attendence_Hours" text,
    "Attendence" text,
    "Loan" text,
    "Holidays" text,
    "Resduial_Salary" text,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Attendence_Discount" text,
    "Holiday_Discount" text,
    "Settlements" text,
    "Later_Sales_Bill" text,
    "Allowances" text,
    "Discounts" text,
    "ProducationPoints" text,
    "DiscountLate" text,
    "DiscountDeparture" text,
    "Shipping_Precent" text,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.pay_salaries OWNER TO postgres;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pay_salaries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_arr_seq OWNER TO postgres;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pay_salaries_arr_seq OWNED BY public.pay_salaries."Code";


--
-- Name: pay_salaries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pay_salaries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_id_seq OWNER TO postgres;

--
-- Name: pay_salaries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pay_salaries_id_seq OWNED BY public.pay_salaries.id;


--
-- Name: payment_voucher_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.payment_voucher_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "PV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Time" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Branch" text,
    "Safe" text,
    "Bill_Num" text,
    "Order_Number" text,
    "Tax" text
);


ALTER TABLE public.payment_voucher_details OWNER TO postgres;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.payment_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_voucher_details_id_seq OWNER TO postgres;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.payment_voucher_details_id_seq OWNED BY public.payment_voucher_details.id;


--
-- Name: payment_vouchers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.payment_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shift" text,
    "Store" text,
    "User" text,
    "Branch" text,
    "Status" text,
    "File" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Responsiple" text,
    "Project" text
);


ALTER TABLE public.payment_vouchers OWNER TO postgres;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.payment_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_arr_seq OWNER TO postgres;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.payment_vouchers_arr_seq OWNED BY public.payment_vouchers.arr;


--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.payment_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_id_seq OWNER TO postgres;

--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.payment_vouchers_id_seq OWNED BY public.payment_vouchers.id;


--
-- Name: paymentss_products_real_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.paymentss_products_real_projects (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "TotCostNew" text,
    "Total_Net" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Payment" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pro_Desc" text
);


ALTER TABLE public.paymentss_products_real_projects OWNER TO postgres;

--
-- Name: paymentss_products_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.paymentss_products_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.paymentss_products_real_projects_id_seq OWNER TO postgres;

--
-- Name: paymentss_products_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.paymentss_products_real_projects_id_seq OWNED BY public.paymentss_products_real_projects.id;


--
-- Name: paymentss_real_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.paymentss_real_projects (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Branch" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Total_Net" text,
    "DiscountBill" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.paymentss_real_projects OWNER TO postgres;

--
-- Name: paymentss_real_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.paymentss_real_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.paymentss_real_projects_id_seq OWNER TO postgres;

--
-- Name: paymentss_real_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.paymentss_real_projects_id_seq OWNED BY public.paymentss_real_projects.id;


--
-- Name: permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permission_to_exchange_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_exchange_goods OWNER TO postgres;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permission_to_exchange_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_arr_seq OWNER TO postgres;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permission_to_exchange_goods_arr_seq OWNED BY public.permission_to_exchange_goods.arr;


--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_id_seq OWNER TO postgres;

--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permission_to_exchange_goods_id_seq OWNED BY public.permission_to_exchange_goods.id;


--
-- Name: permission_to_recived_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permission_to_recived_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_recived_goods OWNER TO postgres;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permission_to_recived_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_arr_seq OWNER TO postgres;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permission_to_recived_goods_arr_seq OWNED BY public.permission_to_recived_goods.arr;


--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_id_seq OWNER TO postgres;

--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permission_to_recived_goods_id_seq OWNED BY public.permission_to_recived_goods.id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permissions (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Main" text,
    "nameEn" text,
    "Package" text
);


ALTER TABLE public.permissions OWNER TO postgres;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO postgres;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: places; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.places (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Ship_Price" text,
    "City" bigint,
    "Delivery" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SearchCode" text
);


ALTER TABLE public.places OWNER TO postgres;

--
-- Name: places_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.places_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.places_id_seq OWNER TO postgres;

--
-- Name: places_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.places_id_seq OWNED BY public.places.id;


--
-- Name: platforms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.platforms (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.platforms OWNER TO postgres;

--
-- Name: platforms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.platforms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.platforms_id_seq OWNER TO postgres;

--
-- Name: platforms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.platforms_id_seq OWNED BY public.platforms.id;


--
-- Name: polices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.polices (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.polices OWNER TO postgres;

--
-- Name: polices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.polices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.polices_id_seq OWNER TO postgres;

--
-- Name: polices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.polices_id_seq OWNED BY public.polices.id;


--
-- Name: pro_details_imgs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pro_details_imgs (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_details_imgs OWNER TO postgres;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pro_details_imgs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_details_imgs_id_seq OWNER TO postgres;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pro_details_imgs_id_seq OWNED BY public.pro_details_imgs.id;


--
-- Name: pro_notes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pro_notes (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_notes OWNER TO postgres;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pro_notes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_notes_id_seq OWNER TO postgres;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pro_notes_id_seq OWNED BY public.pro_notes.id;


--
-- Name: product_details_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_details_e_com_designs (
    id bigint NOT NULL,
    "Title_Color" text,
    "Txt_Color" text,
    "Price_Color" text,
    "Rate_Color" text,
    "Select_BG_Color" text,
    "Select_Txt_Color" text,
    "Qty_BG_Color" text,
    "Qty_Txt_Color" text,
    "Qty_Input_BG_Color" text,
    "Qty_Input_Txt_Color" text,
    "Comment_Input_BG_Color" text,
    "Comment_Button_BG_Color" text,
    "Comment_Button_Txt_Color" text,
    "Comment_Button_BG_Hover_Color" text,
    "Comment_Button_Txt_Hover_Color" text,
    "Related_Title_BG_Color" text,
    "Related_Title_Txt_Color" text,
    "Related_Product_BG_Color" text,
    "Related_Product_Group_BG_Color" text,
    "Related_Product_Group_Txt_Color" text,
    "Related_Product_Group_Hover_BG_Color" text,
    "Related_Product_Group_Hover_Txt_Color" text,
    "Related_Product_Icon_BG_Color" text,
    "Related_Product_Icon_Txt_Color" text,
    "Related_Product_Icon_Hover_BG_Color" text,
    "Related_Product_Icon_Hover_Txt_Color" text,
    "Related_Product_Txt_Color" text,
    "Related_Product_Price_Color" text,
    "Related_Product_Hover_Price_Color" text,
    "Related_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_details_e_com_designs OWNER TO postgres;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_details_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_details_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_details_e_com_designs_id_seq OWNED BY public.product_details_e_com_designs.id;


--
-- Name: product_executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_executing_receiving_secretariats (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Dep" text,
    "Price" text,
    "Workmanship_Price" text,
    "Total" text,
    "StoreIn" text,
    "StoreOut" text,
    "Product" text,
    "Unit" text,
    "Executing" text,
    type text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_executing_receiving_secretariats OWNER TO postgres;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_executing_receiving_secretariats_id_seq OWNER TO postgres;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_executing_receiving_secretariats_id_seq OWNED BY public.product_executing_receiving_secretariats.id;


--
-- Name: product_inventories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_inventories (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Inv_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalExcessP" text,
    "TotalDificitP" text,
    "Exp_Date" text
);


ALTER TABLE public.product_inventories OWNER TO postgres;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_inventories_id_seq OWNER TO postgres;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_inventories_id_seq OWNED BY public.product_inventories.id;


--
-- Name: product_job_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_job_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Thickness" text,
    "Size" text,
    "Product" text,
    "Unit" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executor" text
);


ALTER TABLE public.product_job_orders OWNER TO postgres;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_job_orders_id_seq OWNER TO postgres;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_job_orders_id_seq OWNED BY public.product_job_orders.id;


--
-- Name: product_maintainc_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_maintainc_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Maintaince" bigint NOT NULL,
    "TDiscount" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Date" text
);


ALTER TABLE public.product_maintainc_bills OWNER TO postgres;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_maintainc_bills_id_seq OWNER TO postgres;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_maintainc_bills_id_seq OWNED BY public.product_maintainc_bills.id;


--
-- Name: product_manufacturing_executions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_manufacturing_executions (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Precent" text,
    "RequiredQty" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "ManuExecution" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text
);


ALTER TABLE public.product_manufacturing_executions OWNER TO postgres;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_manufacturing_executions_id_seq OWNER TO postgres;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_manufacturing_executions_id_seq OWNED BY public.product_manufacturing_executions.id;


--
-- Name: product_moves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_moves (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Group" bigint,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "QTY" text,
    "Brand" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    "Delegate" text,
    "Payment_Method" text,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.product_moves OWNER TO postgres;

--
-- Name: product_moves_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns OWNER TO postgres;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_id_seq OWNER TO postgres;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_moves_columns_id_seq OWNED BY public.product_moves_columns.id;


--
-- Name: product_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns_sechdules OWNER TO postgres;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_moves_columns_sechdules_id_seq OWNED BY public.product_moves_columns_sechdules.id;


--
-- Name: product_moves_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filter_twos OWNER TO postgres;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filter_twos_id_seq OWNER TO postgres;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_moves_filter_twos_id_seq OWNED BY public.product_moves_filter_twos.id;


--
-- Name: product_moves_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filters OWNER TO postgres;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filters_id_seq OWNER TO postgres;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_moves_filters_id_seq OWNED BY public.product_moves_filters.id;


--
-- Name: product_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_id_seq OWNER TO postgres;

--
-- Name: product_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_moves_id_seq OWNED BY public.product_moves.id;


--
-- Name: product_quote_images; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_quote_images (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "QuoteImage" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TDiscount" text,
    "Original_Qty" text,
    "AvQty" text,
    "Store" text,
    "Exp_Date" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Patch_Number" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.product_quote_images OWNER TO postgres;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_quote_images_id_seq OWNER TO postgres;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_quote_images_id_seq OWNED BY public.product_quote_images.id;


--
-- Name: product_return_without_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_return_without_bills (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "SmallCode" text,
    "Qty" text,
    "SmallQty" text,
    "Price" text,
    "Cost" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Total_Cost" text,
    "Store" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Payment_Method" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Bill" bigint,
    "Product" bigint
);


ALTER TABLE public.product_return_without_bills OWNER TO postgres;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_return_without_bills_id_seq OWNER TO postgres;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_return_without_bills_id_seq OWNED BY public.product_return_without_bills.id;


--
-- Name: product_sales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_sales (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Delegate" bigint,
    "Client" bigint,
    "Executor" bigint,
    "Refernce_Number" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Ship" bigint,
    "Patch_Number" text,
    "Later_Collection" text DEFAULT 1,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "CostPrice" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Status" text,
    "CustomerGroup" text,
    "Payment_Method" text,
    "CoinCode" text,
    "CoinRate" text,
    "CoinPrice" text,
    "AmountEGP" text,
    "SalesTotal" text,
    "DiscountAmount" text,
    "NetTotal" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "TypeEn" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales OWNER TO postgres;

--
-- Name: product_sales_gifts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_sales_gifts (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Total" text,
    "TotCost" text,
    "Store" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Gift" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.product_sales_gifts OWNER TO postgres;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_gifts_id_seq OWNER TO postgres;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_sales_gifts_id_seq OWNED BY public.product_sales_gifts.id;


--
-- Name: product_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_id_seq OWNER TO postgres;

--
-- Name: product_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_sales_id_seq OWNED BY public.product_sales.id;


--
-- Name: product_sales_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_sales_orders (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "SalesOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text,
    "TDiscount" text,
    "CostPrice" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales_orders OWNER TO postgres;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_orders_id_seq OWNER TO postgres;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_sales_orders_id_seq OWNED BY public.product_sales_orders.id;


--
-- Name: product_sales_subscribes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_sales_subscribes (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Product_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Subscribe" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Date" text,
    "Sub_Type" text
);


ALTER TABLE public.product_sales_subscribes OWNER TO postgres;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_subscribes_id_seq OWNER TO postgres;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_sales_subscribes_id_seq OWNED BY public.product_sales_subscribes.id;


--
-- Name: product_settlements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_settlements (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Set_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalDificitP" text,
    "TotalExcessP" text,
    "Store" bigint,
    "User" bigint,
    "Coin" bigint,
    "Date" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text
);


ALTER TABLE public.product_settlements OWNER TO postgres;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_settlements_id_seq OWNER TO postgres;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_settlements_id_seq OWNED BY public.product_settlements.id;


--
-- Name: product_type_defaults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_type_defaults (
    id bigint NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_type_defaults OWNER TO postgres;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_type_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_type_defaults_id_seq OWNER TO postgres;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_type_defaults_id_seq OWNED BY public.product_type_defaults.id;


--
-- Name: product_units; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.product_units (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price" text NOT NULL,
    "Price_Two" text,
    "Price_Three" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Type" text,
    "Unit" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Def" character varying DEFAULT 0,
    "Brand" text,
    "Group" text
);


ALTER TABLE public.product_units OWNER TO postgres;

--
-- Name: product_units_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.product_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_units_id_seq OWNER TO postgres;

--
-- Name: product_units_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.product_units_id_seq OWNED BY public.product_units.id;


--
-- Name: products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products (
    id bigint NOT NULL,
    "P_Type" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text,
    "Brand" bigint,
    "Group" bigint NOT NULL,
    "Image" text,
    "Minimum" text,
    "Maximum" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Weight" text,
    "Saller_Point" text,
    "Customer_Point" text,
    "Tax" bigint NOT NULL,
    "Validity" text,
    "Days_Notify" text,
    "Ar_Desc" text,
    "En_Desc" text,
    "Ar_Spec" text,
    "En_Spec" text,
    "Store_Show" text,
    "Store_Type" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Cost" character varying,
    subscribe_type bigint,
    "Cas_No" text,
    "HSN" text,
    "Uni_Code" text,
    "Image2" text,
    "Offer" text,
    "OfferPrice" text,
    rate text,
    "Code_Type" text,
    "World_Code" text,
    "Origin_Number" text,
    "Origin_Country" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Space" text,
    "Storage" text,
    "Processor" text,
    "Camera" text,
    "Screen" text,
    "OS" text,
    "Battery" text,
    "Warranty" text,
    "Color" text,
    "Category" text,
    "Model" text,
    "Guess_Price" text,
    "Arrange" bigint,
    "Added" text,
    "Offer_Start_Date" text,
    "Offer_End_Date" text,
    "English_Brief_Desc" text,
    "Arabic_Brief_Desc" text,
    "Show_Other_Store" text,
    "Calories" text,
    "Thickness" text,
    "Maximum_Sales_Qty" text,
    "Delete" text DEFAULT 0,
    "Cost_Price" text DEFAULT 0,
    "Faveorite" text DEFAULT 0,
    "Bonus" text DEFAULT 0
);


ALTER TABLE public.products OWNER TO postgres;

--
-- Name: products_client_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_client_requests (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Desc" text,
    "Product" text,
    "Request" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_client_requests OWNER TO postgres;

--
-- Name: products_client_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_client_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_client_requests_id_seq OWNER TO postgres;

--
-- Name: products_client_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_client_requests_id_seq OWNED BY public.products_client_requests.id;


--
-- Name: products_consists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_consists (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Consist" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Consist_ID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Exp_Date" text
);


ALTER TABLE public.products_consists OWNER TO postgres;

--
-- Name: products_consists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_consists_id_seq OWNER TO postgres;

--
-- Name: products_consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_consists_id_seq OWNED BY public.products_consists.id;


--
-- Name: products_executing_receivings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_executing_receivings (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Executing" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    type text,
    "Dep" text
);


ALTER TABLE public.products_executing_receivings OWNER TO postgres;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_executing_receivings_id_seq OWNER TO postgres;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_executing_receivings_id_seq OWNED BY public.products_executing_receivings.id;


--
-- Name: products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_id_seq OWNER TO postgres;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_id_seq OWNED BY public.products.id;


--
-- Name: products_manufacturing_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_manufacturing_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Store_Qty" text,
    "Required_Qty" text,
    "Qty" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "ManuOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.products_manufacturing_orders OWNER TO postgres;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_orders_id_seq OWNER TO postgres;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_manufacturing_orders_id_seq OWNED BY public.products_manufacturing_orders.id;


--
-- Name: products_manufacturing_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_manufacturing_requests (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Request" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_manufacturing_requests OWNER TO postgres;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_requests_id_seq OWNER TO postgres;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_manufacturing_requests_id_seq OWNED BY public.products_manufacturing_requests.id;


--
-- Name: products_permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_permission_to_exchange_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Exchange" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostPrice" text,
    "TDiscount" text,
    "Patch_Number" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_exchange_goods OWNER TO postgres;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_exchange_goods_id_seq OWNER TO postgres;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_permission_to_exchange_goods_id_seq OWNED BY public.products_permission_to_exchange_goods.id;


--
-- Name: products_permission_to_recived_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_permission_to_recived_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_recived_goods OWNER TO postgres;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_recived_goods_id_seq OWNER TO postgres;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_permission_to_recived_goods_id_seq OWNED BY public.products_permission_to_recived_goods.id;


--
-- Name: products_purchase_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_purchase_petrols (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "Unit" bigint,
    "Petrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SmallCode" text,
    "SmallQty" text
);


ALTER TABLE public.products_purchase_petrols OWNER TO postgres;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchase_petrols_id_seq OWNER TO postgres;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_purchase_petrols_id_seq OWNED BY public.products_purchase_petrols.id;


--
-- Name: products_purchases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_purchases (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Purchase" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "Payment_Method" text,
    "TypeEn" text,
    "Total_Net" text,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_purchases OWNER TO postgres;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_id_seq OWNER TO postgres;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_purchases_id_seq OWNED BY public.products_purchases.id;


--
-- Name: products_purchases_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_purchases_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "P_Order" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Date" text,
    "Vendor" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_purchases_orders OWNER TO postgres;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_orders_id_seq OWNER TO postgres;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_purchases_orders_id_seq OWNED BY public.products_purchases_orders.id;


--
-- Name: products_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_qties (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Price" text,
    "Pro_Stores" bigint,
    "Store" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Low_Unit" bigint,
    "Original" text,
    "Patch_Number" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "Exp_Date" text,
    "Price_Sale" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "TotalCost" text,
    "Hold_Qty" text DEFAULT 0,
    "ChassisNumber" text,
    "MotorNumber" text
);


ALTER TABLE public.products_qties OWNER TO postgres;

--
-- Name: products_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_qties_id_seq OWNER TO postgres;

--
-- Name: products_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_qties_id_seq OWNED BY public.products_qties.id;


--
-- Name: products_quotes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_quotes (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "S_Quote" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Patch_Number" text,
    "TDiscount" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.products_quotes OWNER TO postgres;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_quotes_id_seq OWNER TO postgres;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_quotes_id_seq OWNED BY public.products_quotes.id;


--
-- Name: products_return_maintaince_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_return_maintaince_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Recived_Qty" text,
    "Out" text,
    "Date" text,
    "User" bigint,
    "Eng" bigint,
    "Brand" bigint,
    "Group" bigint,
    "Branch" bigint,
    "Recipient" bigint
);


ALTER TABLE public.products_return_maintaince_bills OWNER TO postgres;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_return_maintaince_bills_id_seq OWNER TO postgres;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_return_maintaince_bills_id_seq OWNED BY public.products_return_maintaince_bills.id;


--
-- Name: products_secretariat_export_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_secretariat_export_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Export" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "RecivedQty" text,
    "Impotence" text,
    "Price" text,
    "Total" text
);


ALTER TABLE public.products_secretariat_export_goods OWNER TO postgres;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_export_goods_id_seq OWNER TO postgres;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_secretariat_export_goods_id_seq OWNED BY public.products_secretariat_export_goods.id;


--
-- Name: products_secretariat_import_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_secretariat_import_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Import" bigint,
    "Unit" bigint,
    "Store" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_secretariat_import_goods OWNER TO postgres;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_import_goods_id_seq OWNER TO postgres;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_secretariat_import_goods_id_seq OWNED BY public.products_secretariat_import_goods.id;


--
-- Name: products_shortcomings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_shortcomings (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Shortmings" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "TDiscount" text,
    "Original_Qty" text,
    "SmallCode" text,
    "SmallQty" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text
);


ALTER TABLE public.products_shortcomings OWNER TO postgres;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_shortcomings_id_seq OWNER TO postgres;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_shortcomings_id_seq OWNED BY public.products_shortcomings.id;


--
-- Name: products_start_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_start_periods (
    id bigint NOT NULL,
    "P_Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Old_Qty" text NOT NULL,
    "Exp_Date" text,
    "SP_ID" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "User" bigint,
    "Store" bigint,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Patch_Number" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.products_start_periods OWNER TO postgres;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_start_periods_id_seq OWNER TO postgres;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_start_periods_id_seq OWNED BY public.products_start_periods.id;


--
-- Name: products_stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_stores (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text,
    "Product" bigint,
    "Store" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_stores OWNER TO postgres;

--
-- Name: products_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_id_seq OWNER TO postgres;

--
-- Name: products_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_stores_id_seq OWNED BY public.products_stores.id;


--
-- Name: products_stores_transfers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "Av_Qty" text,
    "Trans_Qty" text,
    "Total" text,
    "ST_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" text,
    "OldPrice" text,
    "SmallTrans_Qty" text,
    "SmallCode" text,
    "Original_Trans_Qty" text,
    "CostPrice" text,
    "Exp_Date" text
);


ALTER TABLE public.products_stores_transfers OWNER TO postgres;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_transfers_id_seq OWNER TO postgres;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_stores_transfers_id_seq OWNED BY public.products_stores_transfers.id;


--
-- Name: products_viras; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products_viras (
    id bigint NOT NULL,
    "Cost" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_viras OWNER TO postgres;

--
-- Name: products_viras_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_viras_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_viras_id_seq OWNER TO postgres;

--
-- Name: products_viras_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_viras_id_seq OWNED BY public.products_viras.id;


--
-- Name: profit_sales_product_column_sechdulrs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profit_sales_product_column_sechdulrs (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_column_sechdulrs OWNER TO postgres;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_column_sechdulrs_id_seq OWNER TO postgres;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq OWNED BY public.profit_sales_product_column_sechdulrs.id;


--
-- Name: profit_sales_product_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profit_sales_product_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_columns OWNER TO postgres;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.profit_sales_product_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_columns_id_seq OWNER TO postgres;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.profit_sales_product_columns_id_seq OWNED BY public.profit_sales_product_columns.id;


--
-- Name: project_statuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.project_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.project_statuses OWNER TO postgres;

--
-- Name: project_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.project_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.project_statuses_id_seq OWNER TO postgres;

--
-- Name: project_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.project_statuses_id_seq OWNED BY public.project_statuses.id;


--
-- Name: project_teams; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.project_teams (
    id bigint NOT NULL,
    "Member" bigint,
    "Project" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.project_teams OWNER TO postgres;

--
-- Name: project_teams_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.project_teams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.project_teams_id_seq OWNER TO postgres;

--
-- Name: project_teams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.project_teams_id_seq OWNED BY public.project_teams.id;


--
-- Name: projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.projects (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "File" text,
    "Client" bigint NOT NULL,
    "Manager" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "NameEn" text
);


ALTER TABLE public.projects OWNER TO postgres;

--
-- Name: projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.projects_id_seq OWNER TO postgres;

--
-- Name: projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.projects_id_seq OWNED BY public.projects.id;


--
-- Name: purch_bills_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purch_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns OWNER TO postgres;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purch_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_id_seq OWNER TO postgres;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purch_bills_columns_id_seq OWNED BY public.purch_bills_columns.id;


--
-- Name: purch_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purch_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns_sechdules OWNER TO postgres;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purch_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purch_bills_columns_sechdules_id_seq OWNED BY public.purch_bills_columns_sechdules.id;


--
-- Name: purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filter_twos OWNER TO postgres;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filter_twos_id_seq OWNER TO postgres;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purch_bills_filter_twos_id_seq OWNED BY public.purch_bills_filter_twos.id;


--
-- Name: purch_bills_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filters OWNER TO postgres;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filters_id_seq OWNER TO postgres;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purch_bills_filters_id_seq OWNED BY public.purch_bills_filters.id;


--
-- Name: purchase_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchase_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Later_Due" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Draw" text,
    "Payment_Method" text,
    "Note" text,
    "File" text,
    "Car_Number" text,
    "Delivery_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Pay" text,
    "Full" text,
    "Vendor" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "CompanyCar" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Number" text
);


ALTER TABLE public.purchase_petrols OWNER TO postgres;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchase_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_arr_seq OWNER TO postgres;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchase_petrols_arr_seq OWNED BY public.purchase_petrols.arr;


--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_id_seq OWNER TO postgres;

--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchase_petrols_id_seq OWNED BY public.purchase_petrols.id;


--
-- Name: purchases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchases (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0,
    "ImportTotalCost" text
);


ALTER TABLE public.purchases OWNER TO postgres;

--
-- Name: purchases_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_arr_seq OWNER TO postgres;

--
-- Name: purchases_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_arr_seq OWNED BY public.purchases.arr;


--
-- Name: purchases_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchases_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Empp" text,
    "Quality_Qty" text,
    "Discount" text,
    "Hide_Product" text,
    "Hide_Edit_Delete" text,
    "Duplicate_Items" text,
    "Import_Invoice" text,
    "Import_Account" text
);


ALTER TABLE public.purchases_default_data OWNER TO postgres;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_default_data_id_seq OWNER TO postgres;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_default_data_id_seq OWNED BY public.purchases_default_data.id;


--
-- Name: purchases_expenses_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchases_expenses_types (
    id bigint NOT NULL,
    "Type" text,
    "Cost" text,
    "Purchases" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purchases_expenses_types OWNER TO postgres;

--
-- Name: purchases_expenses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_expenses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_expenses_types_id_seq OWNER TO postgres;

--
-- Name: purchases_expenses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_expenses_types_id_seq OWNED BY public.purchases_expenses_types.id;


--
-- Name: purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_id_seq OWNER TO postgres;

--
-- Name: purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_id_seq OWNED BY public.purchases.id;


--
-- Name: purchases_order_expenses_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchases_order_expenses_types (
    id bigint NOT NULL,
    "Type" text,
    "Cost" text,
    "PurchasesOrder" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purchases_order_expenses_types OWNER TO postgres;

--
-- Name: purchases_order_expenses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_order_expenses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_order_expenses_types_id_seq OWNER TO postgres;

--
-- Name: purchases_order_expenses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_order_expenses_types_id_seq OWNED BY public.purchases_order_expenses_types.id;


--
-- Name: purchases_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purchases_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToPurch" text DEFAULT 0,
    "Quality" text DEFAULT 0,
    "Quality_Note" text,
    "Quantity" text DEFAULT 0,
    "Quantity_Note" text,
    "Purchases_Date" text,
    "ShipStatus" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0,
    "ImportTotalCost" text
);


ALTER TABLE public.purchases_orders OWNER TO postgres;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_arr_seq OWNER TO postgres;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_orders_arr_seq OWNED BY public.purchases_orders.arr;


--
-- Name: purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_id_seq OWNER TO postgres;

--
-- Name: purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purchases_orders_id_seq OWNED BY public.purchases_orders.id;


--
-- Name: purpose_travel; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.purpose_travel (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purpose_travel OWNER TO postgres;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.purpose_travel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purpose_travel_id_seq OWNER TO postgres;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.purpose_travel_id_seq OWNED BY public.purpose_travel.id;


--
-- Name: q_r_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.q_r_s (
    id bigint NOT NULL,
    "QR" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.q_r_s OWNER TO postgres;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.q_r_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.q_r_s_id_seq OWNER TO postgres;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.q_r_s_id_seq OWNED BY public.q_r_s.id;


--
-- Name: qualities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.qualities (
    id bigint NOT NULL,
    "Code" text,
    "Execution_Code" text,
    "Date" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "ManuExecution" bigint NOT NULL,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.qualities OWNER TO postgres;

--
-- Name: qualities_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.qualities_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_arr_seq OWNER TO postgres;

--
-- Name: qualities_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.qualities_arr_seq OWNED BY public.qualities.arr;


--
-- Name: qualities_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.qualities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_id_seq OWNER TO postgres;

--
-- Name: qualities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.qualities_id_seq OWNED BY public.qualities.id;


--
-- Name: quality_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quality_details (
    id bigint NOT NULL,
    "Exmine_Type" text,
    "Exmine_Unit" text,
    "Exmine_Allow_From" text,
    "Exmine_Allow_To" text,
    "Result" text,
    "Accept" text,
    "Exmine" bigint,
    "Quality" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.quality_details OWNER TO postgres;

--
-- Name: quality_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quality_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quality_details_id_seq OWNER TO postgres;

--
-- Name: quality_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quality_details_id_seq OWNED BY public.quality_details.id;


--
-- Name: quote_images; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quote_images (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Client" text NOT NULL,
    "User" text NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Safe" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Draw" text,
    "Status" text,
    "Refernce_Number" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Client_Accept" text DEFAULT 0,
    "Done" text DEFAULT 0,
    "EMP_Quote" text
);


ALTER TABLE public.quote_images OWNER TO postgres;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quote_images_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_arr_seq OWNER TO postgres;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quote_images_arr_seq OWNED BY public.quote_images.arr;


--
-- Name: quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_id_seq OWNER TO postgres;

--
-- Name: quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quote_images_id_seq OWNED BY public.quote_images.id;


--
-- Name: quotes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quotes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Shipping_Price" text,
    "Email" text,
    "Phone" text,
    "Expire_Date" text,
    "Care" text,
    "Location" text,
    "Desc" text
);


ALTER TABLE public.quotes OWNER TO postgres;

--
-- Name: quotes_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quotes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_arr_seq OWNER TO postgres;

--
-- Name: quotes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quotes_arr_seq OWNED BY public.quotes.arr;


--
-- Name: quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_id_seq OWNER TO postgres;

--
-- Name: quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quotes_id_seq OWNED BY public.quotes.id;


--
-- Name: rabih_education; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rabih_education (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Video" text,
    "Package" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rabih_education OWNER TO postgres;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rabih_education_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rabih_education_id_seq OWNER TO postgres;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rabih_education_id_seq OWNED BY public.rabih_education.id;


--
-- Name: rates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rates (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rates OWNER TO postgres;

--
-- Name: rates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rates_id_seq OWNER TO postgres;

--
-- Name: rates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rates_id_seq OWNED BY public.rates.id;


--
-- Name: real_sate_projects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.real_sate_projects (
    id bigint NOT NULL,
    "Code" text,
    "Name" text,
    "Start_Date" text,
    "End_Date" text,
    "Period" text,
    "Value" text,
    "Expect_Cost" text,
    "Expect_Profit" text,
    "Project_File" text,
    "Contract_File" text,
    "Contract_Type" text,
    "Completed" text,
    "Account" text,
    "Goods_Account" text,
    "Client" text,
    "Client_Account" text,
    "Manager" text,
    "Reponsible" text,
    "Store" text,
    "Contract_Status" text,
    "Project_Status" text,
    "Cost_Center" text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "Location" text,
    "Address_Details" text,
    "Coin" text,
    "Draw" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Contractor_Account" text
);


ALTER TABLE public.real_sate_projects OWNER TO postgres;

--
-- Name: real_sate_projects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.real_sate_projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_sate_projects_id_seq OWNER TO postgres;

--
-- Name: real_sate_projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.real_sate_projects_id_seq OWNED BY public.real_sate_projects.id;


--
-- Name: real_sate_projects_payments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.real_sate_projects_payments (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Project" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.real_sate_projects_payments OWNER TO postgres;

--
-- Name: real_sate_projects_payments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.real_sate_projects_payments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_sate_projects_payments_id_seq OWNER TO postgres;

--
-- Name: real_sate_projects_payments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.real_sate_projects_payments_id_seq OWNED BY public.real_sate_projects_payments.id;


--
-- Name: real_state_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.real_state_default_data (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" text,
    "Safe" text,
    "Contract_Type" text,
    "Manager" text,
    "Reponsible" text,
    "Store" text,
    "Contract_Status" text,
    "Project_Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.real_state_default_data OWNER TO postgres;

--
-- Name: real_state_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.real_state_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.real_state_default_data_id_seq OWNER TO postgres;

--
-- Name: real_state_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.real_state_default_data_id_seq OWNED BY public.real_state_default_data.id;


--
-- Name: reasons; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reasons (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reasons OWNER TO postgres;

--
-- Name: reasons_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reasons_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reasons_id_seq OWNER TO postgres;

--
-- Name: reasons_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reasons_id_seq OWNED BY public.reasons.id;


--
-- Name: recipt_maintaince_errors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipt_maintaince_errors (
    id bigint NOT NULL,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Error" bigint NOT NULL,
    "Recived" text DEFAULT 0,
    "Eng" text DEFAULT 0
);


ALTER TABLE public.recipt_maintaince_errors OWNER TO postgres;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_maintaince_errors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintaince_errors_id_seq OWNER TO postgres;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_maintaince_errors_id_seq OWNED BY public.recipt_maintaince_errors.id;


--
-- Name: recipt_maintainces; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipt_maintainces (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Total" text NOT NULL,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "Pattern_Image" text,
    "Time" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "Payment_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text DEFAULT 0,
    "CustomerGroup" text,
    "Total_Cost" text
);


ALTER TABLE public.recipt_maintainces OWNER TO postgres;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_maintainces_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_arr_seq OWNER TO postgres;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_maintainces_arr_seq OWNED BY public.recipt_maintainces.arr;


--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_id_seq OWNER TO postgres;

--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_maintainces_id_seq OWNED BY public.recipt_maintainces.id;


--
-- Name: recipt_voucher_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipt_voucher_details (
    id bigint NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "RV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Bill_Num" text
);


ALTER TABLE public.recipt_voucher_details OWNER TO postgres;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_voucher_details_id_seq OWNER TO postgres;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_voucher_details_id_seq OWNED BY public.recipt_voucher_details.id;


--
-- Name: recipt_vouchers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipt_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Shift" text,
    "User" text,
    "Status" text,
    "File" text,
    "Collector" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Sales_Bill" text,
    "Show_Num" text
);


ALTER TABLE public.recipt_vouchers OWNER TO postgres;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_arr_seq OWNER TO postgres;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_vouchers_arr_seq OWNED BY public.recipt_vouchers."Code";


--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipt_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_id_seq OWNER TO postgres;

--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipt_vouchers_id_seq OWNED BY public.recipt_vouchers.id;


--
-- Name: recipts_sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipts_sales_petrols (
    id bigint NOT NULL,
    "Recipt_Amount" text NOT NULL,
    "Recipt" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recipts_sales_petrols OWNER TO postgres;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipts_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_sales_petrols_id_seq OWNER TO postgres;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipts_sales_petrols_id_seq OWNED BY public.recipts_sales_petrols.id;


--
-- Name: recipts_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recipts_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.recipts_types OWNER TO postgres;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recipts_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_types_id_seq OWNER TO postgres;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recipts_types_id_seq OWNED BY public.recipts_types.id;


--
-- Name: recived_purch_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_purch_products OWNER TO postgres;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purch_products_id_seq OWNER TO postgres;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_purch_products_id_seq OWNED BY public.recived_purch_products.id;


--
-- Name: recived_purchts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_purchts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Purchase" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "User" bigint,
    arr bigint
);


ALTER TABLE public.recived_purchts OWNER TO postgres;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_purchts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_arr_seq OWNER TO postgres;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_purchts_arr_seq OWNED BY public.recived_purchts.arr;


--
-- Name: recived_purchts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_purchts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_id_seq OWNER TO postgres;

--
-- Name: recived_purchts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_purchts_id_seq OWNED BY public.recived_purchts.id;


--
-- Name: recived_sales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" bigint
);


ALTER TABLE public.recived_sales OWNER TO postgres;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_arr_seq OWNER TO postgres;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_sales_arr_seq OWNED BY public.recived_sales.arr;


--
-- Name: recived_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_id_seq OWNER TO postgres;

--
-- Name: recived_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_sales_id_seq OWNED BY public.recived_sales.id;


--
-- Name: recived_sales_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_sales_products OWNER TO postgres;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_products_id_seq OWNER TO postgres;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_sales_products_id_seq OWNED BY public.recived_sales_products.id;


--
-- Name: recived_shipment_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_shipment_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Barcode" text,
    "Total_Weight" text,
    "Total_Pieces" text,
    "Total_Cost" text,
    "Client" text,
    "RecivedShipment" text,
    "Status" text,
    "Unloading_Goods_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "PayShip" text
);


ALTER TABLE public.recived_shipment_goods OWNER TO postgres;

--
-- Name: recived_shipment_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_shipment_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipment_goods_id_seq OWNER TO postgres;

--
-- Name: recived_shipment_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_shipment_goods_id_seq OWNED BY public.recived_shipment_goods.id;


--
-- Name: recived_shipments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.recived_shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Store" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Count_Shipmets" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Residual" text
);


ALTER TABLE public.recived_shipments OWNER TO postgres;

--
-- Name: recived_shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipments_arr_seq OWNER TO postgres;

--
-- Name: recived_shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_shipments_arr_seq OWNED BY public.recived_shipments."Code";


--
-- Name: recived_shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.recived_shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_shipments_id_seq OWNER TO postgres;

--
-- Name: recived_shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.recived_shipments_id_seq OWNED BY public.recived_shipments.id;


--
-- Name: reg_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reg_courses (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Hall" text,
    "Reserve_Course" text,
    "Teacher" text,
    "Teacher_Attend" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Teacher_Attend_From" text,
    "Teacher_Attend_To" text,
    "Teacher_Time" text
);


ALTER TABLE public.reg_courses OWNER TO postgres;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reg_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_id_seq OWNER TO postgres;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reg_courses_id_seq OWNED BY public.reg_courses.id;


--
-- Name: reg_courses_students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reg_courses_students (
    id bigint NOT NULL,
    "Student" text,
    "Attend" text,
    "Date" text,
    "Reg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_courses_students OWNER TO postgres;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reg_courses_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_students_id_seq OWNER TO postgres;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reg_courses_students_id_seq OWNED BY public.reg_courses_students.id;


--
-- Name: reg_over_times; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reg_over_times (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Hour_Rate" text NOT NULL,
    "Total_Hours" text NOT NULL,
    "Hour_Cost" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_over_times OWNER TO postgres;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reg_over_times_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_arr_seq OWNER TO postgres;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reg_over_times_arr_seq OWNED BY public.reg_over_times.arr;


--
-- Name: reg_over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reg_over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_id_seq OWNER TO postgres;

--
-- Name: reg_over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reg_over_times_id_seq OWNED BY public.reg_over_times.id;


--
-- Name: remove_products_halls; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.remove_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.remove_products_halls OWNER TO postgres;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.remove_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.remove_products_halls_id_seq OWNER TO postgres;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.remove_products_halls_id_seq OWNED BY public.remove_products_halls.id;


--
-- Name: reports_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reports_settings (
    id bigint NOT NULL,
    "Product_Info" text,
    "Product_Order_Limit" text,
    "ReportStartPeriodProducts" text,
    "SettlementsReports" text,
    "StoresCost" text,
    "StoresInventory" text,
    "Collection_Delegates" text,
    "Sales_Delegates" text,
    "StagnantItems" text,
    "ItemsMoves" text,
    "StoresBalancesTwo" text,
    "NetPurchases" text,
    "NetSales" text,
    "ClientSales" text,
    "ExecutorSales" text,
    "InstallmentReport" text,
    "ExpiredProucts" text,
    "StoresSalesDetails" text,
    "TotalNetPurchases" text,
    "TotalNetSales" text,
    "Profits" text,
    "Shifts" text,
    "Shifts_Details" text,
    "DailyClosing" text,
    "Products" text,
    "DailyShifts" text,
    "ExpensesReport" text,
    "DailyProducts" text,
    "EmployeeCommissionDiscounts" text,
    "VendorPricesReport" text,
    "DailyMoves" text,
    "GroupsSales" text,
    "VendorPurchases" text,
    "ExceptProfits" text,
    "DelegateSalesDetails" text,
    "CreditStores" text,
    "ProductProfits" text,
    "ExceptProductProfits" text,
    "SalesBills" text,
    "PurchasesBills" text,
    "StoresMovesReport" text,
    "StoresTransferReport" text,
    "SafesTransferReport" text,
    "CompareSalesPrice" text,
    "ProductMoveDetails" text,
    "MostSalesProducts" text,
    "ProfitSalesProduct" text,
    "ClientAccountStatement" text,
    "ClientsStatement" text,
    "VendorAccountStatement" text,
    "VendorsStatement" text,
    "EmpGoals" text,
    "InventorySerial" text,
    "TotalExpensesSafes" text,
    "SubIncomList" text,
    "ExpensesList" text,
    "StoresBalances" text,
    "StoresBalancesCat" text,
    "ItemCost" text,
    "StoresInventoryy" text,
    "DelegateSalesDetailss" text,
    "ProfitDelegateSalesDetails" text,
    "InstallmentCompaniesSales" text,
    "StoresCosts" text,
    "DailyClosingDetails" text,
    "SalesProsMoreDetails" text,
    "StagnantItemss" text,
    "SalesCustomersGroups" text,
    "BrandsSales" text,
    "Customer_Debts" text,
    "Vendor_Debts" text,
    "MaintanceSalesReport" text,
    "Maintenance_Tune" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProfitGroupsReport" text,
    "IncomListReport" text,
    "AssemblyProQties" text
);


ALTER TABLE public.reports_settings OWNER TO postgres;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reports_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reports_settings_id_seq OWNER TO postgres;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reports_settings_id_seq OWNED BY public.reports_settings.id;


--
-- Name: reservations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reservations (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "From" text,
    "To" text,
    "Amount" text,
    "Checkout" text,
    "Expire" text,
    "Draw" text,
    "Client" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Room" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" text,
    "Note" text
);


ALTER TABLE public.reservations OWNER TO postgres;

--
-- Name: reservations_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reservations_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_arr_seq OWNER TO postgres;

--
-- Name: reservations_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reservations_arr_seq OWNED BY public.reservations.arr;


--
-- Name: reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_id_seq OWNER TO postgres;

--
-- Name: reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reservations_id_seq OWNED BY public.reservations.id;


--
-- Name: reserve_course_days; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reserve_course_days (
    id bigint NOT NULL,
    "Day" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Time" text,
    "To_Time" text
);


ALTER TABLE public.reserve_course_days OWNER TO postgres;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reserve_course_days_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_days_id_seq OWNER TO postgres;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reserve_course_days_id_seq OWNED BY public.reserve_course_days.id;


--
-- Name: reserve_course_students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reserve_course_students (
    id bigint NOT NULL,
    "Student" text,
    "Pay" text,
    "Cost" text,
    "Residual" text,
    "Constraint" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Dollar_Value" text
);


ALTER TABLE public.reserve_course_students OWNER TO postgres;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reserve_course_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_students_id_seq OWNER TO postgres;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reserve_course_students_id_seq OWNED BY public.reserve_course_students.id;


--
-- Name: reserve_courses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reserve_courses (
    id bigint NOT NULL,
    "Code" text,
    "Course" text,
    "Start_Date" text,
    "End_Date" text,
    "Course_Type" text,
    "Teacher" text,
    "Required_Number" text,
    "Certificate" text,
    "Cost" text,
    "Total_Required" text,
    "Status" text,
    "Days" text,
    "Time" text,
    "Total_Paid" text,
    "Total_Num" text,
    "Total_Cost" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hall" text
);


ALTER TABLE public.reserve_courses OWNER TO postgres;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reserve_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_courses_id_seq OWNER TO postgres;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reserve_courses_id_seq OWNED BY public.reserve_courses.id;


--
-- Name: resignation_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resignation_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Resignation_Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    "Status" text,
    "Reason" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resignation_requests OWNER TO postgres;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resignation_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_arr_seq OWNER TO postgres;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resignation_requests_arr_seq OWNED BY public.resignation_requests."Code";


--
-- Name: resignation_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resignation_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_id_seq OWNER TO postgres;

--
-- Name: resignation_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resignation_requests_id_seq OWNED BY public.resignation_requests.id;


--
-- Name: resturant_abouts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_abouts (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_abouts OWNER TO postgres;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_abouts_id_seq OWNER TO postgres;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_abouts_id_seq OWNED BY public.resturant_abouts.id;


--
-- Name: resturant_blogs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_blogs (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_blogs OWNER TO postgres;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_blogs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_blogs_id_seq OWNER TO postgres;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_blogs_id_seq OWNED BY public.resturant_blogs.id;


--
-- Name: resturant_cart_check_styles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_cart_check_styles (
    id bigint NOT NULL,
    "Cart_BG_Type" text,
    "Cart_BG_Image" text,
    "Cart_BG_Color" text,
    "Cart_Title_Color" text,
    "Cart_Txt_Color" text,
    "Cart_Top_Image" text,
    "Cart_Box_BG" text,
    "Cart_Box_Border" text,
    "Cart_Table_Color" text,
    "Cart_Table_BG" text,
    "Cart_Btn_BG" text,
    "Cart_Btn_Color" text,
    "Checkout_Image" text,
    "Checkout_Title_Color" text,
    "Checkout_BG_Type" text,
    "Checkout_BG_Image" text,
    "Checkout_BG_Color" text,
    "Checkout_Box_BG" text,
    "Checkout_Box_Border" text,
    "Checkout_Input_BG" text,
    "Checkout_Input_Color" text,
    "Checkout_Btn_Color" text,
    "Checkout_Btn_BG" text,
    "Checkout_Txt_Color" text,
    "Checkout_Txt_Hover_Color" text,
    "Checkout_Price_Color" text,
    "MyAccount_BG_Type" text,
    "MyAccount_BG_Image" text,
    "MyAccount_BG_Color" text,
    "MyAccount_Box_BG" text,
    "MyAccount_Box_Border" text,
    "MyAccount_Table_BG" text,
    "MyAccount_Table_Color" text,
    "MyAccount_Table_Head_BG" text,
    "MyAccount_Table_Head_Color" text,
    "MyAccount_Txt_Color" text,
    "MyAccount_Btn_BG" text,
    "MyAccount_Btn_Color" text,
    "MyAccount_Input_BG" text,
    "MyAccount_Input_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Collapse_BG" text,
    "Collapse_Border" text,
    "Collapse_Color" text
);


ALTER TABLE public.resturant_cart_check_styles OWNER TO postgres;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_cart_check_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cart_check_styles_id_seq OWNER TO postgres;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_cart_check_styles_id_seq OWNED BY public.resturant_cart_check_styles.id;


--
-- Name: resturant_carts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_carts (
    id bigint NOT NULL,
    "Product" text,
    "Name" text,
    "NameEn" text,
    "V_ID" text,
    "P_Code" text,
    "Qty" text,
    "Price" text,
    "Image" text,
    "Total" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_carts OWNER TO postgres;

--
-- Name: resturant_carts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_carts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_carts_id_seq OWNER TO postgres;

--
-- Name: resturant_carts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_carts_id_seq OWNED BY public.resturant_carts.id;


--
-- Name: resturant_cupon_codes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_cupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_cupon_codes OWNER TO postgres;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_cupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cupon_codes_id_seq OWNER TO postgres;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_cupon_codes_id_seq OWNED BY public.resturant_cupon_codes.id;


--
-- Name: resturant_galleries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_galleries (
    id bigint NOT NULL,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_galleries OWNER TO postgres;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_galleries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_galleries_id_seq OWNER TO postgres;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_galleries_id_seq OWNED BY public.resturant_galleries.id;


--
-- Name: resturant_homes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_homes (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "English_Sub_Title" text,
    "Arabic_Sub_Title" text,
    "Year" text
);


ALTER TABLE public.resturant_homes OWNER TO postgres;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_homes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_homes_id_seq OWNER TO postgres;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_homes_id_seq OWNED BY public.resturant_homes.id;


--
-- Name: resturant_index_style_i_i_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_index_style_i_i_s (
    id bigint NOT NULL,
    "About_Body_BG_Type" text,
    "About_Body_BG_Image" text,
    "About_Body_BG_Color" text,
    "About_Txt_Color" text,
    "Gallery_Border_Color" text,
    "Reviews_Image_1" text,
    "Reviews_Image_2" text,
    "Reviews_Nxt_Prev_Color" text,
    "Reviews_Nxt_Prev_BG" text,
    "Reviews_Nxt_Prev_Border" text,
    "Reviews_Txt_Color" text,
    "Reviews_Body_BG_Type" text,
    "Reviews_Body_BG_Image" text,
    "Reviews_Body_BG_Color" text,
    "Reservations_Body_BG_Type" text,
    "Reservations_Body_BG_Image" text,
    "Reservations_Body_BG_Color" text,
    "Reservations_Box_BG" text,
    "Reservations_Input_BG" text,
    "Reservations_Input_Color" text,
    "Reservations_Btn_Color" text,
    "Reservations_Btn_BG" text,
    "Blogs_Home_Body_BG_Type" text,
    "Blogs_Home_Body_BG_Image" text,
    "Blogs_Home_Body_BG_Color" text,
    "Blogs_Home_Box_BG_Color" text,
    "Blogs_Home_Box_Border_Color" text,
    "Blogs_Home_Txt_Color" text,
    "Blogs_Home_Txt_Hover_Color" text,
    "Blogs_Home_Btn_BG" text,
    "Blogs_Home_Btn_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_index_style_i_i_s OWNER TO postgres;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_index_style_i_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_i_s_id_seq OWNER TO postgres;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_index_style_i_i_s_id_seq OWNED BY public.resturant_index_style_i_i_s.id;


--
-- Name: resturant_index_style_i_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_index_style_i_s (
    id bigint NOT NULL,
    "Home_1_Nxt_Prev_Color" text,
    "Home_1_Nxt_Prev_BG" text,
    "Home_1_Nxt_Prev_Border" text,
    "Home_2_Image_1" text,
    "Home_2_Image_2" text,
    "Home_2_Image_Arrow" text,
    "Home_2_Number_BG" text,
    "Home_2_Image_Border" text,
    "Home_2_Number_Color" text,
    "Category_Bar_BG" text,
    "Category_Bar_Color" text,
    "Video_Section_Body_BG_Type" text,
    "Video_Section_Body_BG_Image" text,
    "Video_Section_Body_BG_Color" text,
    "Video_Section_Image_1" text,
    "Video_Section_Image_2" text,
    "Menu_Index_Body_BG_Type" text,
    "Menu_Index_Body_BG_Image" text,
    "Menu_Index_Body_BG_Color" text,
    "Menu_Index_Txt_Color" text,
    "Menu_Index_Txt_Hover_Color" text,
    "Menu_Index_Btn_BG" text,
    "Menu_Index_Btn_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Icon_Image" text
);


ALTER TABLE public.resturant_index_style_i_s OWNER TO postgres;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_index_style_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_s_id_seq OWNER TO postgres;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_index_style_i_s_id_seq OWNED BY public.resturant_index_style_i_s.id;


--
-- Name: resturant_menu_styles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_menu_styles (
    id bigint NOT NULL,
    "Menu_1_BG_Type" text,
    "Menu_1_BG_Image" text,
    "Menu_1_BG_Color" text,
    "Menu_1_Image" text,
    "Menu_1_Icon_Image" text,
    "Menu_1_Title" text,
    "Menu_1_Bar_BG" text,
    "Menu_1_Bar_Color" text,
    "Menu_1_Btn_BG" text,
    "Menu_1_Btn_Color" text,
    "Menu_1_Icon_Color" text,
    "Menu_1_Icon_Hover_Color" text,
    "Menu_1_Icon_Active_Color" text,
    "Menu_1_Price_Color" text,
    "Menu_1_Offer_Price_Color" text,
    "Menu_2_Gallery_Border" text,
    "Menu_2_BG_Type" text,
    "Menu_2_BG_Image" text,
    "Menu_2_BG_Color" text,
    "Menu_2_Title" text,
    "Menu_2_Category_Color" text,
    "Menu_2_Category_Hover_Color" text,
    "Menu_2_Category_Active_Color" text,
    "Menu_2_Lines_Color" text,
    "Menu_2_Btn_BG" text,
    "Menu_2_Btn_Color" text,
    "Menu_2_Name_BG" text,
    "Menu_2_Name_Color" text,
    "Menu_2_Icon_Color" text,
    "Menu_2_Icon_Hover_Color" text,
    "Menu_2_Icon_Active_Color" text,
    "Menu_2_Price_Color" text,
    "Menu_2_Offer_Price_Color" text,
    "Menu_3_BG_Type" text,
    "Menu_3_BG_Image" text,
    "Menu_3_BG_Color" text,
    "Menu_3_Image" text,
    "Menu_3_Icon_Image" text,
    "Menu_3_Title" text,
    "Menu_3_Category_Color" text,
    "Menu_3_Category_Hover_Color" text,
    "Menu_3_Category_Active_Color" text,
    "Menu_3_Box_BG" text,
    "Menu_3_Box_Color" text,
    "Menu_3_Btn_BG" text,
    "Menu_3_Btn_Color" text,
    "Menu_3_Icon_Color" text,
    "Menu_3_Icon_Hover_Color" text,
    "Menu_3_Icon_Active_Color" text,
    "Menu_3_Price_Color" text,
    "Menu_3_Offer_Price_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_menu_styles OWNER TO postgres;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_menu_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_menu_styles_id_seq OWNER TO postgres;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_menu_styles_id_seq OWNED BY public.resturant_menu_styles.id;


--
-- Name: resturant_nav_foot_styles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_nav_foot_styles (
    id bigint NOT NULL,
    "Navbar_BG" text,
    "Navbar_Txt_Color" text,
    "Navbar_Txt_Hover_Color" text,
    "Navbar_Btn_BG" text,
    "Navbar_Btn_Color" text,
    "Navbar_Sub_Menu_BG" text,
    "Navbar_Sub_Menu_Color" text,
    "Footer_BG_Type" text,
    "Footer_BG_Color" text,
    "Footer_BG_Image" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_Color" text,
    "Footer_CopyRight_Color" text,
    "Footer_CopyRight_Company_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_nav_foot_styles OWNER TO postgres;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_nav_foot_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_nav_foot_styles_id_seq OWNER TO postgres;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_nav_foot_styles_id_seq OWNED BY public.resturant_nav_foot_styles.id;


--
-- Name: resturant_privacies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_privacies (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_privacies OWNER TO postgres;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_privacies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_privacies_id_seq OWNER TO postgres;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_privacies_id_seq OWNED BY public.resturant_privacies.id;


--
-- Name: resturant_reservations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_reservations (
    id bigint NOT NULL,
    "Name" text,
    "Phone" text,
    "Persons" text,
    "Date" text,
    "Time" text,
    "Message" text,
    "Approve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reservations OWNER TO postgres;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reservations_id_seq OWNER TO postgres;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_reservations_id_seq OWNED BY public.resturant_reservations.id;


--
-- Name: resturant_reviews; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_reviews (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reviews OWNER TO postgres;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_reviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reviews_id_seq OWNER TO postgres;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_reviews_id_seq OWNED BY public.resturant_reviews.id;


--
-- Name: resturant_sliders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_sliders (
    id bigint NOT NULL,
    "Status" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Image" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sliders OWNER TO postgres;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sliders_id_seq OWNER TO postgres;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_sliders_id_seq OWNED BY public.resturant_sliders.id;


--
-- Name: resturant_socials; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_socials (
    id bigint NOT NULL,
    "Facebook" text,
    "Twitter" text,
    "Instagram" text,
    "Youtube" text,
    "Snapchat" text,
    "Whatsapp" text,
    "Google_Plus" text,
    "LinkedIn" text,
    "Pinterest" text,
    "Telegram" text,
    "iOS" text,
    "Android" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_socials OWNER TO postgres;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_socials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_socials_id_seq OWNER TO postgres;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_socials_id_seq OWNED BY public.resturant_socials.id;


--
-- Name: resturant_styles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_styles (
    id bigint NOT NULL,
    "Font" text,
    "Home" text,
    "Menu" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Reviews" text,
    "Privacy" text,
    "Terms" text,
    "Gallery" text,
    "Blogs" text,
    "Cart" text,
    "PDF" text,
    "Reservations" text,
    "Body_BG_Type" text,
    "Modal_Txt_Color" text,
    "Modal_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_BG_Color" text,
    "Body_Title_Color" text,
    "Modal_Button_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Form_Input_Txt_Color" text,
    "Form_Input_BG" text,
    "Form_Txt_Hover_Color" text,
    "Form_Txt_Color" text,
    "Form_Box_Border_Color" text,
    "Form_Box_BG" text,
    "Preloader_Circle_3_Color" text,
    "Preloader_Circle_2_Color" text,
    "Preloader_Circle_1_Color" text,
    "Form_Btn_Txt_Color" text,
    "Form_Btn_BG" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text
);


ALTER TABLE public.resturant_styles OWNER TO postgres;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_styles_id_seq OWNER TO postgres;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_styles_id_seq OWNED BY public.resturant_styles.id;


--
-- Name: resturant_sup_page_styles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_sup_page_styles (
    id bigint NOT NULL,
    "Blogs_BG_Type" text,
    "Blogs_BG_Image" text,
    "Blogs_BG_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Top_Image" text,
    "Blogs_Box_BG" text,
    "Blogs_Box_Border" text,
    "Blogs_Box_Txt_Color" text,
    "Blogs_Box_Txt_Hover_Color" text,
    "Blogs_Btn_Color" text,
    "Blogs_Btn_BG" text,
    "Blogs_Details_Box_BG" text,
    "Blogs_Details_Box_Border" text,
    "Blogs_Details_Box_Txt_Color" text,
    "Reviews_Top_Image" text,
    "Reviews_Title_Color" text,
    "Reviews_BG_Type" text,
    "Reviews_BG_Image" text,
    "Reviews_BG_Color" text,
    "Reviews_Box_BG" text,
    "Reviews_Box_Border" text,
    "Reviews_Icon_Color" text,
    "Gallery_Top_Image" text,
    "Gallery_Title_Color" text,
    "Gallery__BG_Type" text,
    "Gallery__BG_Image" text,
    "Gallery__BG_Color" text,
    "Terms_Privacy_Top_Image" text,
    "Terms_Privacy_Title_Color" text,
    "Terms_Privacy_Box_BG" text,
    "Terms_Privacy_Box_Border" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sup_page_styles OWNER TO postgres;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_sup_page_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sup_page_styles_id_seq OWNER TO postgres;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_sup_page_styles_id_seq OWNED BY public.resturant_sup_page_styles.id;


--
-- Name: resturant_tables; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_tables (
    id bigint NOT NULL,
    "Table_Number" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Place_Ar" text,
    "Place_En" text,
    "Chairs_Num" text,
    "QR" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_tables OWNER TO postgres;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_tables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_tables_id_seq OWNER TO postgres;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_tables_id_seq OWNED BY public.resturant_tables.id;


--
-- Name: resturant_terms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_terms (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_terms OWNER TO postgres;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_terms_id_seq OWNER TO postgres;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_terms_id_seq OWNED BY public.resturant_terms.id;


--
-- Name: resturant_video_sections; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resturant_video_sections (
    id bigint NOT NULL,
    "BG_Image" text,
    "Icon" text,
    "Title_Image" text,
    "Video_Link" text,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Number_1" text,
    "Number_2" text,
    "Number_3" text,
    "Number_4" text,
    "Arabic_Title_1" text,
    "Arabic_Title_2" text,
    "Arabic_Title_3" text,
    "Arabic_Title_4" text,
    "English_Title_1" text,
    "English_Title_2" text,
    "English_Title_3" text,
    "English_Title_4" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_video_sections OWNER TO postgres;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resturant_video_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_video_sections_id_seq OWNER TO postgres;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resturant_video_sections_id_seq OWNED BY public.resturant_video_sections.id;


--
-- Name: return_maintaince_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_maintaince_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Work" text,
    "Total" text,
    "Total_Cost" text,
    "Cost_Precent" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Bill" text,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CustomerGroup" text,
    "Total_Talf" text
);


ALTER TABLE public.return_maintaince_bills OWNER TO postgres;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_maintaince_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_arr_seq OWNER TO postgres;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_maintaince_bills_arr_seq OWNED BY public.return_maintaince_bills.arr;


--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_id_seq OWNER TO postgres;

--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_maintaince_bills_id_seq OWNED BY public.return_maintaince_bills.id;


--
-- Name: return_products_stores_transfers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "OldPrice" text,
    "Av_Qty" text,
    "SmallCode" text,
    "ReturnQty" text,
    "Trans_Qty" text,
    "Original_Trans_Qty" text,
    "SmallTrans_Qty" text,
    "Total" text,
    "ST_ID" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "To_Store" text,
    "CostPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_products_stores_transfers OWNER TO postgres;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_products_stores_transfers_id_seq OWNER TO postgres;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_products_stores_transfers_id_seq OWNED BY public.return_products_stores_transfers.id;


--
-- Name: return_purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filter_twos OWNER TO postgres;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filter_twos_id_seq OWNER TO postgres;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_purch_bills_filter_twos_id_seq OWNED BY public.return_purch_bills_filter_twos.id;


--
-- Name: return_purch_bills_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filters OWNER TO postgres;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filters_id_seq OWNER TO postgres;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_purch_bills_filters_id_seq OWNED BY public.return_purch_bills_filters.id;


--
-- Name: return_purch_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Return_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "TDiscount" text,
    "TypeEn" text
);


ALTER TABLE public.return_purch_products OWNER TO postgres;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_products_id_seq OWNER TO postgres;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_purch_products_id_seq OWNED BY public.return_purch_products.id;


--
-- Name: return_purches; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_purches (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Purchase" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Later_Due" text,
    "Cost_Center" bigint,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.return_purches OWNER TO postgres;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_purches_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_arr_seq OWNER TO postgres;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_purches_arr_seq OWNED BY public.return_purches.arr;


--
-- Name: return_purches_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_purches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_id_seq OWNER TO postgres;

--
-- Name: return_purches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_purches_id_seq OWNED BY public.return_purches.id;


--
-- Name: return_sales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Executor" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    "TaxBill" text,
    "TaxCode" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "Sent" text,
    "Safe" bigint,
    "Cost_Center" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Current_Credit" text,
    "Cost" text,
    "TotalCost" text
);


ALTER TABLE public.return_sales OWNER TO postgres;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_arr_seq OWNER TO postgres;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_sales_arr_seq OWNED BY public.return_sales.arr;


--
-- Name: return_sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.return_sales_bills_filter_twos OWNER TO postgres;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filter_twos_id_seq OWNER TO postgres;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_sales_bills_filter_twos_id_seq OWNED BY public.return_sales_bills_filter_twos.id;


--
-- Name: return_sales_bills_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.return_sales_bills_filters OWNER TO postgres;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filters_id_seq OWNER TO postgres;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_sales_bills_filters_id_seq OWNED BY public.return_sales_bills_filters.id;


--
-- Name: return_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_id_seq OWNER TO postgres;

--
-- Name: return_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_sales_id_seq OWNED BY public.return_sales.id;


--
-- Name: return_sales_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Delegate" bigint,
    "Executor" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Date" text,
    "Client" bigint,
    "Refernce_Number" text,
    "Ship" bigint,
    "Patch_Number" text,
    "CoinCode" text,
    "CoinPrice" text,
    "CoinRate" text,
    "AmountEGP" text,
    "DiscountAmount" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "SalesTotal" text,
    "NetTotal" text
);


ALTER TABLE public.return_sales_products OWNER TO postgres;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_products_id_seq OWNER TO postgres;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_sales_products_id_seq OWNED BY public.return_sales_products.id;


--
-- Name: return_stors_transfers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_stors_transfers (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "OriginalID" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_stors_transfers OWNER TO postgres;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_arr_seq OWNER TO postgres;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_stors_transfers_arr_seq OWNED BY public.return_stors_transfers.arr;


--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_id_seq OWNER TO postgres;

--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_stors_transfers_id_seq OWNED BY public.return_stors_transfers.id;


--
-- Name: return_without_bills; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.return_without_bills (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Deficit_Account" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Due_Date" text,
    "Later_Due" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0,
    "Current_Credit" text
);


ALTER TABLE public.return_without_bills OWNER TO postgres;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_without_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_arr_seq OWNER TO postgres;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_without_bills_arr_seq OWNED BY public.return_without_bills."Code";


--
-- Name: return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_id_seq OWNER TO postgres;

--
-- Name: return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.return_without_bills_id_seq OWNED BY public.return_without_bills.id;


--
-- Name: role_has_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role_has_permissions (
    permission_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE public.role_has_permissions OWNER TO postgres;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.roles (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "nameEn" text
);


ALTER TABLE public.roles OWNER TO postgres;

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO postgres;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: room_reservations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.room_reservations (
    id bigint NOT NULL,
    "Date" text,
    "Room" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.room_reservations OWNER TO postgres;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.room_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.room_reservations_id_seq OWNER TO postgres;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.room_reservations_id_seq OWNED BY public.room_reservations.id;


--
-- Name: rooms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rooms (
    id bigint NOT NULL,
    "Code" text,
    "Floor" text,
    "Bulding_Name" text,
    "Adults_Num" text,
    "Childs_Num" text,
    "Beds_Num" text,
    "Desc" text,
    "Price" text,
    "Reserved" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "RoomsType" text,
    "DescEn" text
);


ALTER TABLE public.rooms OWNER TO postgres;

--
-- Name: rooms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rooms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_id_seq OWNER TO postgres;

--
-- Name: rooms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rooms_id_seq OWNED BY public.rooms.id;


--
-- Name: rooms_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rooms_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rooms_types OWNER TO postgres;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rooms_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_types_id_seq OWNER TO postgres;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rooms_types_id_seq OWNED BY public.rooms_types.id;


--
-- Name: rqst_transports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rqst_transports (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Arrival_Date" text,
    "Arrival_Time" text,
    "Reference_Num" text,
    "Weight" text,
    "Note" text,
    "Payment_Method" text,
    "Insurance" text,
    "Pay" text,
    "Value" text,
    "Type" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Cost_Center" text,
    "Driver" text,
    "Car" text,
    "Driver_Precent" text,
    "Driver_Value" text,
    "Contractor" text,
    "Contractor_Precent" text,
    "Contractor_Value" text,
    "Expenses_Precent" text,
    "Expenses_Value" text,
    "The_Net" text,
    "Sender" text,
    "Received" text,
    "Transfer" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rqst_transports OWNER TO postgres;

--
-- Name: rqst_transports_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rqst_transports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rqst_transports_id_seq OWNER TO postgres;

--
-- Name: rqst_transports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rqst_transports_id_seq OWNED BY public.rqst_transports.id;


--
-- Name: safe_transfer_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safe_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns OWNER TO postgres;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_id_seq OWNER TO postgres;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfer_columns_id_seq OWNED BY public.safe_transfer_columns.id;


--
-- Name: safe_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safe_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns_sechdules OWNER TO postgres;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfer_columns_sechdules_id_seq OWNED BY public.safe_transfer_columns_sechdules.id;


--
-- Name: safe_transfer_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safe_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filter_twos OWNER TO postgres;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filter_twos_id_seq OWNER TO postgres;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfer_filter_twos_id_seq OWNED BY public.safe_transfer_filter_twos.id;


--
-- Name: safe_transfer_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safe_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filters OWNER TO postgres;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filters_id_seq OWNER TO postgres;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfer_filters_id_seq OWNED BY public.safe_transfer_filters.id;


--
-- Name: safe_transfers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safe_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Note" text,
    "From_Safe" bigint NOT NULL,
    "To_Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Time" text,
    "Delegate" bigint,
    arr bigint,
    "Branch" bigint
);


ALTER TABLE public.safe_transfers OWNER TO postgres;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_arr_seq OWNER TO postgres;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfers_arr_seq OWNED BY public.safe_transfers."Code";


--
-- Name: safe_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safe_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_id_seq OWNER TO postgres;

--
-- Name: safe_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safe_transfers_id_seq OWNED BY public.safe_transfers.id;


--
-- Name: safes_banks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.safes_banks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Note" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Service_Fee" text,
    "NameEn" text
);


ALTER TABLE public.safes_banks OWNER TO postgres;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safes_banks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_arr_seq OWNER TO postgres;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safes_banks_arr_seq OWNED BY public.safes_banks."Code";


--
-- Name: safes_banks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.safes_banks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_id_seq OWNER TO postgres;

--
-- Name: safes_banks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.safes_banks_id_seq OWNED BY public.safes_banks.id;


--
-- Name: sales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "SalesOrder" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    arr bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Cash" text,
    "Visa" text,
    "Sale_Type" text,
    "Hold" text,
    "Shift_Code" text,
    emp bigint,
    "Store_Code" text,
    "Later_Due" text,
    "Later_Collection" text DEFAULT 1,
    "Client_Address" text,
    "Delivery" text,
    "Delivery_Status" text,
    "Sale_User" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text DEFAULT 0,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "statusBill" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "InstallCompany" bigint,
    "File" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayTime" text,
    "TakeawayStatus" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountBill" text DEFAULT 0,
    "ServiceType" text,
    "ServiceFees" text,
    "ServiceValue" text,
    bill_lat text,
    bill_lng text,
    "App" bigint,
    "Shipping_Price" text,
    "Warranty_Expire_Date" text,
    "Use_Qty" text DEFAULT 0
);


ALTER TABLE public.sales OWNER TO postgres;

--
-- Name: sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_arr_seq OWNER TO postgres;

--
-- Name: sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_arr_seq OWNED BY public.sales.arr;


--
-- Name: sales_bills_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns OWNER TO postgres;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_id_seq OWNER TO postgres;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_bills_columns_id_seq OWNED BY public.sales_bills_columns.id;


--
-- Name: sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns_sechdules OWNER TO postgres;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_bills_columns_sechdules_id_seq OWNED BY public.sales_bills_columns_sechdules.id;


--
-- Name: sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.sales_bills_filter_twos OWNER TO postgres;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filter_twos_id_seq OWNER TO postgres;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_bills_filter_twos_id_seq OWNED BY public.sales_bills_filter_twos.id;


--
-- Name: sales_bills_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.sales_bills_filters OWNER TO postgres;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filters_id_seq OWNER TO postgres;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_bills_filters_id_seq OWNED BY public.sales_bills_filters.id;


--
-- Name: sales_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Mainus" text,
    "Price_Sale" text,
    "Safe" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Draw" text,
    "Shift_Pass" text,
    "Empp" text,
    "Discount" text,
    "Delivery" text,
    "Execute_Precent" text,
    "StoresQty" text,
    "DelegateEmp" text,
    "TaxType" text,
    "DiscountTaxShow" text,
    "SalesOrderType" text,
    "ECommercceSaleType" text,
    "Kitchen_Order" text,
    "Waiter" text,
    "Hall_Service_Type" text,
    "Hall_Service_Precent" text,
    "CountryResturantWebsite" text,
    "Bank" text,
    "Country" text,
    "SalesLowCostPrice" text,
    "ShowJobOrders" text,
    "LimitSalesQty" text,
    "Total_Wight_Bill" text,
    "Duplicate_Items" text,
    "ExecuteEmp" text,
    "Hide_Product" text,
    "Choice_Collector_POS" text,
    "Hide_Discount_POS" text,
    "Hide_Edit_Delete" text,
    "Daily_Clients" text,
    "Location_Conditon" text,
    "Show_Image_Print" text,
    "InstallmentSystem" text DEFAULT 0,
    "Ecommerce_Sales" text DEFAULT 1,
    "Use_Max_Discount_Group" text,
    "ResturantDeliveryDirect" text,
    "Quote_Expire_Date" text,
    "Quote_Location" text,
    "Quote_Desc" text,
    "Quote_Care" text,
    "Quote_Email" text,
    "Quote_Phone" text,
    "Warranty_Expire_Date" text,
    "Dont_Use_Qty_POS" text
);


ALTER TABLE public.sales_default_data OWNER TO postgres;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_default_data_id_seq OWNER TO postgres;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_default_data_id_seq OWNED BY public.sales_default_data.id;


--
-- Name: sales_fifo_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_fifo_qties OWNER TO postgres;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_fifo_qties_id_seq OWNER TO postgres;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_fifo_qties_id_seq OWNED BY public.sales_fifo_qties.id;


--
-- Name: sales_gifts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_gifts (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Client" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Edit" text DEFAULT '0'::text,
    "Delete" text DEFAULT '0'::text,
    "Edit_New_Code" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text
);


ALTER TABLE public.sales_gifts OWNER TO postgres;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_gifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_arr_seq OWNER TO postgres;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_gifts_arr_seq OWNED BY public.sales_gifts."Code";


--
-- Name: sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_id_seq OWNER TO postgres;

--
-- Name: sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_gifts_id_seq OWNED BY public.sales_gifts.id;


--
-- Name: sales_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_id_seq OWNER TO postgres;

--
-- Name: sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_id_seq OWNED BY public.sales.id;


--
-- Name: sales_maint_fifo_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_maint_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_maint_fifo_qties OWNER TO postgres;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_maint_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_maint_fifo_qties_id_seq OWNER TO postgres;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_maint_fifo_qties_id_seq OWNED BY public.sales_maint_fifo_qties.id;


--
-- Name: sales_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_orders (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToSales" text DEFAULT 0,
    "Hold" text DEFAULT 0,
    "Later_Due" text,
    "Sale_Date" text,
    "CuponCode" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "Name" text,
    "Email" text,
    "Phone" text,
    "OtherPhone" text,
    "Address_Name" text,
    "Special_MarkAdd" text,
    "StreetAdd" text,
    "BulidingAdd" text,
    "FloorAdd" text,
    "FlatAdd" text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "LocationAdd" text,
    "Address_DetailsAdd" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Cancel_Order" text,
    "Time" text,
    "Delegate_Recived" text,
    "Delegate_Recived_Time" text,
    "To_Sales_Time" text,
    "Cancel_Order_Time" text,
    "Hold_Qty" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayStatus" text,
    "TakeawayTime" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Total_Net" text,
    "Residual" text,
    "DiscountTax" text,
    "Current_Credit" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Shipping_Price" text
);


ALTER TABLE public.sales_orders OWNER TO postgres;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_arr_seq OWNER TO postgres;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_orders_arr_seq OWNED BY public.sales_orders.arr;


--
-- Name: sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_id_seq OWNER TO postgres;

--
-- Name: sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_orders_id_seq OWNED BY public.sales_orders.id;


--
-- Name: sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Counter_Name" text,
    "Pervious_Read" text,
    "Petrol_Name" text,
    "Current_Raed" text,
    "Value" text,
    "Total" text,
    "Consumption" text,
    "Cash" text,
    "Calibers" text,
    "Counter" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_petrols OWNER TO postgres;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_arr_seq OWNER TO postgres;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_petrols_arr_seq OWNED BY public.sales_petrols.arr;


--
-- Name: sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_id_seq OWNER TO postgres;

--
-- Name: sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_petrols_id_seq OWNED BY public.sales_petrols.id;


--
-- Name: sales_serial; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_serial
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_serial OWNER TO postgres;

--
-- Name: sales_subscribes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sales_subscribes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text,
    "Later_Due" text,
    "Product_Numbers" text,
    "Total_Price" text,
    "Notes" text,
    "Coin" bigint,
    "Delegate" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text,
    "Current_Credit" text
);


ALTER TABLE public.sales_subscribes OWNER TO postgres;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_subscribes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_arr_seq OWNER TO postgres;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_subscribes_arr_seq OWNED BY public.sales_subscribes.arr;


--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_id_seq OWNER TO postgres;

--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sales_subscribes_id_seq OWNED BY public.sales_subscribes.id;


--
-- Name: scientific_materials; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.scientific_materials (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.scientific_materials OWNER TO postgres;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.scientific_materials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scientific_materials_id_seq OWNER TO postgres;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.scientific_materials_id_seq OWNED BY public.scientific_materials.id;


--
-- Name: secretariat_export_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.secretariat_export_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "StoreGoods" text,
    "Total_Recived_Qty" text,
    "Total_Price" text,
    "Draw" text,
    "Coin" text,
    "Safe" text
);


ALTER TABLE public.secretariat_export_goods OWNER TO postgres;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_export_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_arr_seq OWNER TO postgres;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_export_goods_arr_seq OWNED BY public.secretariat_export_goods."Code";


--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_id_seq OWNER TO postgres;

--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_export_goods_id_seq OWNED BY public.secretariat_export_goods.id;


--
-- Name: secretariat_import_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.secretariat_import_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.secretariat_import_goods OWNER TO postgres;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_import_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_arr_seq OWNER TO postgres;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_import_goods_arr_seq OWNED BY public.secretariat_import_goods.arr;


--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_id_seq OWNER TO postgres;

--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_import_goods_id_seq OWNED BY public.secretariat_import_goods.id;


--
-- Name: secretariat_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.secretariat_qties (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text
);


ALTER TABLE public.secretariat_qties OWNER TO postgres;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_qties_id_seq OWNER TO postgres;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_qties_id_seq OWNED BY public.secretariat_qties.id;


--
-- Name: secretariat_stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.secretariat_stores (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text
);


ALTER TABLE public.secretariat_stores OWNER TO postgres;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.secretariat_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_stores_id_seq OWNER TO postgres;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.secretariat_stores_id_seq OWNED BY public.secretariat_stores.id;


--
-- Name: select_a_p_i_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.select_a_p_i_s (
    id bigint NOT NULL,
    id_ text NOT NULL,
    name text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.select_a_p_i_s OWNER TO postgres;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.select_a_p_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.select_a_p_i_s_id_seq OWNER TO postgres;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.select_a_p_i_s_id_seq OWNED BY public.select_a_p_i_s.id;


--
-- Name: server_d_b_s; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.server_d_b_s (
    id bigint NOT NULL,
    "DB_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.server_d_b_s OWNER TO postgres;

--
-- Name: server_d_b_s_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.server_d_b_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.server_d_b_s_id_seq OWNER TO postgres;

--
-- Name: server_d_b_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.server_d_b_s_id_seq OWNED BY public.server_d_b_s.id;


--
-- Name: settlements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Inv_ID" bigint,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Time" text,
    "Branch" text
);


ALTER TABLE public.settlements OWNER TO postgres;

--
-- Name: settlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.settlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_arr_seq OWNER TO postgres;

--
-- Name: settlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.settlements_arr_seq OWNED BY public.settlements.arr;


--
-- Name: settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_id_seq OWNER TO postgres;

--
-- Name: settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.settlements_id_seq OWNED BY public.settlements.id;


--
-- Name: shifts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shifts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Total_Cash" text DEFAULT 0,
    "Total_Later" text DEFAULT 0,
    "Total_Visa" text DEFAULT 0,
    "Total" text DEFAULT 0,
    "Pass" text,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Close" text,
    "Amount" text,
    "Total_Recipt" text DEFAULT 0,
    "Total_Payment" text DEFAULT 0,
    "Store" text,
    "Safe" text,
    "Total_Later_Not_Paid" text DEFAULT 0,
    "Total_Later_Paid" text DEFAULT 0,
    "Total_Installment" text DEFAULT 0,
    "Total_Checks" text DEFAULT 0,
    "Total_Delivery" text DEFAULT 0,
    "Total_Installment_Companies" text DEFAULT 0,
    "Close_Date" text,
    "Open_Amount" text,
    "Open_Note" text,
    "Apps" text DEFAULT 0
);


ALTER TABLE public.shifts OWNER TO postgres;

--
-- Name: shifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_arr_seq OWNER TO postgres;

--
-- Name: shifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shifts_arr_seq OWNED BY public.shifts.arr;


--
-- Name: shifts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_id_seq OWNER TO postgres;

--
-- Name: shifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shifts_id_seq OWNED BY public.shifts.id;


--
-- Name: shipment_moves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipment_moves (
    id bigint NOT NULL,
    "Code" text,
    "Barcode" text,
    "Date" text,
    "Time" text,
    "Sender" text,
    "Sender_Name" text,
    "Reciver" text,
    "Reciver_Name" text,
    "Status" text,
    "Status_Code" text,
    "Delegate" text,
    "Driver" text,
    "Note" text,
    "User" text,
    "Shipment_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shipment_Dist_ID" text,
    "Shipment_Unload_ID" text,
    "Shipment_Recived_ID" text
);


ALTER TABLE public.shipment_moves OWNER TO postgres;

--
-- Name: shipment_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_moves_id_seq OWNER TO postgres;

--
-- Name: shipment_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_moves_id_seq OWNED BY public.shipment_moves.id;


--
-- Name: shipment_receipts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipment_receipts (
    id bigint NOT NULL,
    "Recived_Store" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    "Status" text,
    "ShippingList" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts OWNER TO postgres;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_arr_seq OWNER TO postgres;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_arr_seq OWNED BY public.shipment_receipts.arr;


--
-- Name: shipment_receipts_clients; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipment_receipts_clients (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "ShipmentReceipts" text,
    "ShipmentReceiptsList" text,
    "Total_Price" text,
    "Total_Qty" text,
    "Pay" text,
    "Payment_Method" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_clients OWNER TO postgres;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_clients_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_arr_seq OWNER TO postgres;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_clients_arr_seq OWNED BY public.shipment_receipts_clients.arr;


--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_id_seq OWNER TO postgres;

--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_clients_id_seq OWNED BY public.shipment_receipts_clients.id;


--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_id_seq OWNER TO postgres;

--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_id_seq OWNED BY public.shipment_receipts.id;


--
-- Name: shipment_receipts_lists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipment_receipts_lists (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    "Ticket" text,
    "ShipmentReceipts" text,
    "Status" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_lists OWNER TO postgres;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_lists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_arr_seq OWNER TO postgres;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_lists_arr_seq OWNED BY public.shipment_receipts_lists.arr;


--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_receipts_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_id_seq OWNER TO postgres;

--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_receipts_lists_id_seq OWNED BY public.shipment_receipts_lists.id;


--
-- Name: shipment_requests; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipment_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Status" text,
    "Pieces_Num" text,
    "Desc" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Note" text,
    "Payment_Method" text,
    "Breakable" text,
    "Delivery_To_Others" text,
    "Opening_Package" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Delegate" text,
    "Sender" text,
    "Received" text,
    "Shipment_Cost" text,
    "Total" text,
    "User" text,
    "Pay" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Transfer" text DEFAULT '0'::text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shipment_Type" text,
    "Receipt_Date" text,
    "Receipt_Time" text,
    "Arrival_Date" text,
    "Arrival_Time" text
);


ALTER TABLE public.shipment_requests OWNER TO postgres;

--
-- Name: shipment_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_requests_arr_seq OWNER TO postgres;

--
-- Name: shipment_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_requests_arr_seq OWNED BY public.shipment_requests."Code";


--
-- Name: shipment_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipment_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_requests_id_seq OWNER TO postgres;

--
-- Name: shipment_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipment_requests_id_seq OWNED BY public.shipment_requests.id;


--
-- Name: shipments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Arrival_Date" text,
    "Arrival_Time" text,
    "Barcode" text,
    "Status" text DEFAULT '0'::text,
    "Pieces_Num" text,
    "Desc" text,
    "Reference_Num" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Note" text,
    "Shipment_Class" text,
    "Payment_Method" text,
    "Breakable" text,
    "Delivery_To_Others" text,
    "Shipping_Costs_Included" text,
    "Opening_Package" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Delegate" text,
    "Driver" text,
    "Sender" text,
    "Received" text,
    "Shipment_Type" text,
    "Shipment_Rqst_Type" text,
    "Shipment_Category" text,
    "Shipment_Cost" text,
    "Goods_Cost" text,
    "Delivery_Cost" text,
    "Overload_Weight_Cost" text,
    "Collection_Commission" text,
    "Delivery_Commission" text,
    "Return_Cost" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" text,
    "Pay" text,
    "Insurance" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Store" text,
    "Car" text,
    "ToStore" text
);


ALTER TABLE public.shipments OWNER TO postgres;

--
-- Name: shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_arr_seq OWNER TO postgres;

--
-- Name: shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_arr_seq OWNED BY public.shipments."Code";


--
-- Name: shipments_distribution_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipments_distribution_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "ShipmentsDistribution" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text,
    "Total_Pieces" text,
    "Status" text DEFAULT 0
);


ALTER TABLE public.shipments_distribution_goods OWNER TO postgres;

--
-- Name: shipments_distribution_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_distribution_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distribution_goods_id_seq OWNER TO postgres;

--
-- Name: shipments_distribution_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_distribution_goods_id_seq OWNED BY public.shipments_distribution_goods.id;


--
-- Name: shipments_distribution_workers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipments_distribution_workers (
    id bigint NOT NULL,
    "Worker" text,
    "ShipmentsDistribution" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipments_distribution_workers OWNER TO postgres;

--
-- Name: shipments_distribution_workers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_distribution_workers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distribution_workers_id_seq OWNER TO postgres;

--
-- Name: shipments_distribution_workers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_distribution_workers_id_seq OWNED BY public.shipments_distribution_workers.id;


--
-- Name: shipments_distributions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipments_distributions (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "FromStore" text,
    "ToStore" text,
    "Car" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Count_Shipmets" text,
    "DriverPrecent" text
);


ALTER TABLE public.shipments_distributions OWNER TO postgres;

--
-- Name: shipments_distributions_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_distributions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distributions_arr_seq OWNER TO postgres;

--
-- Name: shipments_distributions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_distributions_arr_seq OWNED BY public.shipments_distributions."Code";


--
-- Name: shipments_distributions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_distributions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_distributions_id_seq OWNER TO postgres;

--
-- Name: shipments_distributions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_distributions_id_seq OWNED BY public.shipments_distributions.id;


--
-- Name: shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipments_id_seq OWNER TO postgres;

--
-- Name: shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipments_id_seq OWNED BY public.shipments.id;


--
-- Name: shipping_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_companies (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Tax_Card" text,
    "Commercial_Register" text,
    "Account" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.shipping_companies OWNER TO postgres;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_companies_id_seq OWNER TO postgres;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_companies_id_seq OWNED BY public.shipping_companies.id;


--
-- Name: shipping_defaults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_defaults (
    id bigint NOT NULL,
    "Breakable" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Payment_Method" text,
    "Shipment_Class" text,
    "Opening_Package" text,
    "Shipment_Type" text,
    "Shipment_Category" text,
    "Delivery_To_Others" text,
    "Shipping_Costs_Included" text,
    "Insurance" text,
    "Draw" text,
    "Store" text
);


ALTER TABLE public.shipping_defaults OWNER TO postgres;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_defaults_id_seq OWNER TO postgres;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_defaults_id_seq OWNED BY public.shipping_defaults.id;


--
-- Name: shipping_list_tickets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_list_tickets (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ticket" text
);


ALTER TABLE public.shipping_list_tickets OWNER TO postgres;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_list_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_list_tickets_id_seq OWNER TO postgres;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_list_tickets_id_seq OWNED BY public.shipping_list_tickets.id;


--
-- Name: shipping_lists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_lists (
    id bigint NOT NULL,
    "Ticket_Store" text,
    "Driver" text,
    "Car_Store" text,
    "Travel_Area" text,
    "Access_Area" text,
    "Date_Travel" text,
    "Date_Arrival" text,
    "Car_Number" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text
);


ALTER TABLE public.shipping_lists OWNER TO postgres;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_lists_id_seq OWNER TO postgres;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_lists_id_seq OWNED BY public.shipping_lists.id;


--
-- Name: shipping_orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Weight" text,
    "Number" text,
    "Goods_Price" text,
    "Shipping_Price" text,
    "Total" text,
    "Breakable" text,
    "Note" text,
    "Draw" text,
    "Coin" text,
    "Cost_Center" text,
    "Vend" text,
    "Cli" text,
    "Open" text,
    "Paid" text,
    "Ship_Sort" text,
    "Adderss" text,
    "Requests" text,
    "Sure" text,
    "Safe" text,
    "Residual" text,
    "Emp_Note" text,
    "Shipping_Delegate" text,
    "Cancel" text,
    "Cancel_Note" text,
    "Cancel_Pay" text,
    "Cancel_Not_Pay" text,
    "Vendor_Shipping" text,
    "Request_Done" text,
    "Status" bigint,
    "Type" bigint,
    "Delegate" bigint,
    "Vendor" bigint,
    "Client" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_orders OWNER TO postgres;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_arr_seq OWNER TO postgres;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_orders_arr_seq OWNED BY public.shipping_orders.arr;


--
-- Name: shipping_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_id_seq OWNER TO postgres;

--
-- Name: shipping_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_orders_id_seq OWNED BY public.shipping_orders.id;


--
-- Name: shipping_prices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_prices (
    id bigint NOT NULL,
    "Place" text,
    "City" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" integer,
    "To" integer,
    "Price" numeric(8,2)
);


ALTER TABLE public.shipping_prices OWNER TO postgres;

--
-- Name: shipping_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_prices_id_seq OWNER TO postgres;

--
-- Name: shipping_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_prices_id_seq OWNED BY public.shipping_prices.id;


--
-- Name: shipping_statuses; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Color" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_statuses OWNER TO postgres;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_statuses_id_seq OWNER TO postgres;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_statuses_id_seq OWNED BY public.shipping_statuses.id;


--
-- Name: shipping_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shipping_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_types OWNER TO postgres;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shipping_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_types_id_seq OWNER TO postgres;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shipping_types_id_seq OWNED BY public.shipping_types.id;


--
-- Name: shippment_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shippment_products (
    id bigint NOT NULL,
    "P_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V1" text,
    "V2" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Shipment" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shippment_products OWNER TO postgres;

--
-- Name: shippment_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shippment_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shippment_products_id_seq OWNER TO postgres;

--
-- Name: shippment_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shippment_products_id_seq OWNED BY public.shippment_products.id;


--
-- Name: shortcomings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.shortcomings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Pay" text,
    "ToPurch" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Purch_Date" text,
    "Purch_Reason" text,
    "ShipStatus" text,
    "P_Order_Num" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.shortcomings OWNER TO postgres;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shortcomings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_arr_seq OWNER TO postgres;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shortcomings_arr_seq OWNED BY public.shortcomings.arr;


--
-- Name: shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_id_seq OWNER TO postgres;

--
-- Name: shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.shortcomings_id_seq OWNED BY public.shortcomings.id;


--
-- Name: show_print_defaults; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.show_print_defaults (
    id bigint NOT NULL,
    "CompanyName" text NOT NULL,
    "ProductName" text NOT NULL,
    "ProductPrice" text NOT NULL,
    "Coin" text NOT NULL,
    "Unit" text NOT NULL,
    "Group" text NOT NULL,
    "Code" text NOT NULL,
    "Logo" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.show_print_defaults OWNER TO postgres;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.show_print_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.show_print_defaults_id_seq OWNER TO postgres;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.show_print_defaults_id_seq OWNED BY public.show_print_defaults.id;


--
-- Name: social_media; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.social_media (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Youtube" character varying(191),
    "Snapchat" character varying(191),
    "Whatsapp" character varying(191),
    "Google_Plus" character varying(191),
    "LinkedIn" character varying(191),
    "Pinterest" character varying(191),
    "Telegram" character varying(191),
    "iOS" character varying(191),
    "Android" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.social_media OWNER TO postgres;

--
-- Name: social_media_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.social_media_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.social_media_id_seq OWNER TO postgres;

--
-- Name: social_media_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.social_media_id_seq OWNED BY public.social_media.id;


--
-- Name: special_cases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.special_cases (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Discount" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.special_cases OWNER TO postgres;

--
-- Name: special_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.special_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.special_cases_id_seq OWNER TO postgres;

--
-- Name: special_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.special_cases_id_seq OWNED BY public.special_cases.id;


--
-- Name: spend_profits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.spend_profits (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Remaining_Profit" text NOT NULL,
    "Partner" bigint NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Payment_Method" text
);


ALTER TABLE public.spend_profits OWNER TO postgres;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.spend_profits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.spend_profits_id_seq OWNER TO postgres;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.spend_profits_id_seq OWNED BY public.spend_profits.id;


--
-- Name: start_periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.start_periods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Total_Products" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.start_periods OWNER TO postgres;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.start_periods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_arr_seq OWNER TO postgres;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.start_periods_arr_seq OWNED BY public.start_periods."Code";


--
-- Name: start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_id_seq OWNER TO postgres;

--
-- Name: start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.start_periods_id_seq OWNED BY public.start_periods.id;


--
-- Name: store_count_sales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.store_count_sales (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_count_sales OWNER TO postgres;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.store_count_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_count_sales_id_seq OWNER TO postgres;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.store_count_sales_id_seq OWNED BY public.store_count_sales.id;


--
-- Name: store_counts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_counts OWNER TO postgres;

--
-- Name: store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_counts_id_seq OWNER TO postgres;

--
-- Name: store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.store_counts_id_seq OWNED BY public.store_counts.id;


--
-- Name: store_transfer_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.store_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filter_twos OWNER TO postgres;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.store_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filter_twos_id_seq OWNER TO postgres;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.store_transfer_filter_twos_id_seq OWNED BY public.store_transfer_filter_twos.id;


--
-- Name: store_transfer_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.store_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filters OWNER TO postgres;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.store_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filters_id_seq OWNER TO postgres;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.store_transfer_filters_id_seq OWNED BY public.store_transfer_filters.id;


--
-- Name: stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores (
    id bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Address" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Branch" bigint,
    "Letter" text,
    "Account_Client" text,
    "NameEn" text,
    "Lat" text,
    "Lang" text
);


ALTER TABLE public.stores OWNER TO postgres;

--
-- Name: stores_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_arr_seq OWNER TO postgres;

--
-- Name: stores_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_arr_seq OWNED BY public.stores."Code";


--
-- Name: stores_default_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_default_data (
    id bigint NOT NULL,
    "Group" bigint,
    "Unit" bigint,
    "Tax" bigint,
    "Coin" bigint,
    "Account_Excess" bigint,
    "Account_Dificit" bigint,
    "Store" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Style" text,
    "StoresTarnsferPrice" text,
    "Guide_Product_Cost" text,
    "Client_Store_Account" text,
    "Show_Ship" text,
    "StoresTarnsferHide" text,
    "CodeType" text,
    "ReturnStoresTransfer" text,
    "Cost_Price" text,
    "Hide_Product" text,
    "StartPeriod_Show_Product" text,
    "Fictitious_Quantities" text,
    "Qty_With_Add_Product" text
);


ALTER TABLE public.stores_default_data OWNER TO postgres;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_default_data_id_seq OWNER TO postgres;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_default_data_id_seq OWNED BY public.stores_default_data.id;


--
-- Name: stores_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_id_seq OWNER TO postgres;

--
-- Name: stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_id_seq OWNED BY public.stores.id;


--
-- Name: stores_moves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_moves (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Type" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Account" bigint,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stores_moves OWNER TO postgres;

--
-- Name: stores_moves_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns OWNER TO postgres;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_id_seq OWNER TO postgres;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_moves_columns_id_seq OWNED BY public.stores_moves_columns.id;


--
-- Name: stores_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns_sechdules OWNER TO postgres;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_moves_columns_sechdules_id_seq OWNED BY public.stores_moves_columns_sechdules.id;


--
-- Name: stores_moves_filter_twos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filter_twos OWNER TO postgres;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filter_twos_id_seq OWNER TO postgres;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_moves_filter_twos_id_seq OWNED BY public.stores_moves_filter_twos.id;


--
-- Name: stores_moves_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filters OWNER TO postgres;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filters_id_seq OWNER TO postgres;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_moves_filters_id_seq OWNED BY public.stores_moves_filters.id;


--
-- Name: stores_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_id_seq OWNER TO postgres;

--
-- Name: stores_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_moves_id_seq OWNED BY public.stores_moves.id;


--
-- Name: stores_transfer_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns OWNER TO postgres;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_id_seq OWNER TO postgres;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_transfer_columns_id_seq OWNED BY public.stores_transfer_columns.id;


--
-- Name: stores_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns_sechdules OWNER TO postgres;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_sechdules_id_seq OWNER TO postgres;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_transfer_columns_sechdules_id_seq OWNED BY public.stores_transfer_columns_sechdules.id;


--
-- Name: stors_transfers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stors_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total" text NOT NULL,
    "Note" text,
    "From_Store" bigint NOT NULL,
    "To_Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TotalQty" text,
    "Status" text DEFAULT 0,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "Delegate" bigint,
    "Ship" bigint,
    "File" text,
    "Edit_t" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stors_transfers OWNER TO postgres;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_arr_seq OWNER TO postgres;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stors_transfers_arr_seq OWNED BY public.stors_transfers.arr;


--
-- Name: stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_id_seq OWNER TO postgres;

--
-- Name: stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stors_transfers_id_seq OWNED BY public.stors_transfers.id;


--
-- Name: student_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_groups (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.student_groups OWNER TO postgres;

--
-- Name: student_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_groups_id_seq OWNER TO postgres;

--
-- Name: student_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.student_groups_id_seq OWNED BY public.student_groups.id;


--
-- Name: student_importants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_importants (
    id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Student" text,
    "Course" text
);


ALTER TABLE public.student_importants OWNER TO postgres;

--
-- Name: student_importants_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.student_importants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_importants_id_seq OWNER TO postgres;

--
-- Name: student_importants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.student_importants_id_seq OWNED BY public.student_importants.id;


--
-- Name: students; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.students (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Group" text,
    "Phone1" text,
    "Phone2" text,
    "Dad_Phone" text,
    "Mom_Phone" text,
    "Special_Case" text,
    "Case" text,
    "Email" text,
    "Whatsapp" text,
    "Age" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Address" text,
    "Profession" text,
    "Ntional_ID" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.students OWNER TO postgres;

--
-- Name: students_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_id_seq OWNER TO postgres;

--
-- Name: students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.students_id_seq OWNED BY public.students.id;


--
-- Name: sub_images; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sub_images (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sub_images OWNER TO postgres;

--
-- Name: sub_images_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sub_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_images_id_seq OWNER TO postgres;

--
-- Name: sub_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sub_images_id_seq OWNED BY public.sub_images.id;


--
-- Name: sub_virables; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sub_virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "V_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.sub_virables OWNER TO postgres;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sub_virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_virables_id_seq OWNER TO postgres;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sub_virables_id_seq OWNED BY public.sub_virables.id;


--
-- Name: subscribe_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.subscribe_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.subscribe_types OWNER TO postgres;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.subscribe_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_types_id_seq OWNER TO postgres;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.subscribe_types_id_seq OWNED BY public.subscribe_types.id;


--
-- Name: sup_pages_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sup_pages_e_com_designs (
    id bigint NOT NULL,
    "About_Title_Color" text,
    "About_Txt_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Txt_Color" text,
    "Blogs_Hover_Txt_Color" text,
    "Contact_Title_Color" text,
    "Contact_Txt_Color" text,
    "Contact_Form_Input_Border_Color" text,
    "Contact_Form_Input_Txt_Color" text,
    "Contact_Form_Button_BG_Color" text,
    "Contact_Form_Button_Txt_Color" text,
    "Contact_Form_Button_Hover_BG_Color" text,
    "Contact_Form_Button_Hover_Txt_Color" text,
    "Faq_Title_Color" text,
    "Faq_Q_BG_Color" text,
    "Faq_Q_Txt_Color" text,
    "Faq_A_Line_Color" text,
    "Faq_A_BG_Color" text,
    "Faq_A_Txt_Color" text,
    "MyAccount_Box_BG_Color" text,
    "MyAccount_Box_Button_BG_Color" text,
    "MyAccount_Box_Button_Txt_Color" text,
    "MyAccount_Box_Button_Hover_BG_Color" text,
    "MyAccount_Box_Button_Hover_Txt_Color" text,
    "MyAccount_Box_Input_Border_Color" text,
    "MyAccount_Box_Input_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_e_com_designs OWNER TO postgres;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sup_pages_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sup_pages_e_com_designs_id_seq OWNED BY public.sup_pages_e_com_designs.id;


--
-- Name: sup_pages_part_two_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sup_pages_part_two_e_com_designs (
    id bigint NOT NULL,
    "Shop_Product_BG_Color" text,
    "Shop_Product_Group_BG_Color" text,
    "Shop_Product_Group_Txt_Color" text,
    "Shop_Product_Group_Hover_BG_Color" text,
    "Shop_Product_Group_Hover_Txt_Color" text,
    "Shop_Product_Icon_BG_Color" text,
    "Shop_Product_Icon_Txt_Color" text,
    "Shop_Product_Icon_Hover_BG_Color" text,
    "Shop_Product_Icon_Hover_Txt_Color" text,
    "Shop_Product_Txt_Color" text,
    "Shop_Product_Price_Color" text,
    "Shop_Product_Rate_Color" text,
    "Shop_Filter_Title_Color" text,
    "Shop_Filter_Txt_Color" text,
    "Shop_Filter_Search_BG_Color" text,
    "Shop_Filter_Search_Icon_BG_Color" text,
    "Shop_Filter_Search_Icon_Txt_Color" text,
    "Shop_Filter_Search_Icon_BG_Hover_Color" text,
    "Shop_Filter_Search_Icon_Txt_Hover_Color" text,
    "Cart_Button_BG_Color" text,
    "Cart_Button_Txt_Color" text,
    "Cart_Button_BG_Hover_Color" text,
    "Cart_Button_Txt_Hover_Color" text,
    "Cart_Box_BG_Color" text,
    "Cart_Box_Title_Color" text,
    "Cart_Box_Txt_Color" text,
    "Cart_Box_Button_BG_Color" text,
    "Cart_Box_Button_Txt_Color" text,
    "Cart_Box_Button_BG_Hover_Color" text,
    "Cart_Box_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Button_BG_Color" text,
    "Cart_Cupon_Button_Txt_Color" text,
    "Cart_Cupon_Button_BG_Hover_Color" text,
    "Cart_Cupon_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Input_BG_Color" text,
    "Checkout_Box_BG_Color" text,
    "Checkout_Box_Title_Color" text,
    "Checkout_Box_Txt_Color" text,
    "Checkout_Box_Button_BG_Color" text,
    "Checkout_Box_Button_Txt_Color" text,
    "Checkout_Box_Button_BG_Hover_Color" text,
    "Checkout_Box_Button_Txt_Hover_Color" text,
    "Checkout_Head_BG_Color" text,
    "Checkout_Head_Txt_Color" text,
    "Checkout_Input_BG_Color" text,
    "Checkout_Input_Txt_Color" text,
    "Reg_Login_Form_Box_BG_Color" text,
    "Reg_Login_Form_Box_Title_Color" text,
    "Reg_Login_Form_Box_Txt_Color" text,
    "Reg_Login_Form_Box_Txt_Hover_Color" text,
    "Reg_Login_Form_Box_Input_Border_Color" text,
    "Reg_Login_Form_Box_Button_BG_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Color" text,
    "Reg_Login_Form_Box_Button_BG_Hover_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Hover_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_part_two_e_com_designs OWNER TO postgres;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_part_two_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq OWNED BY public.sup_pages_part_two_e_com_designs.id;


--
-- Name: sup_pages_wish_comp_e_com_designs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sup_pages_wish_comp_e_com_designs (
    id bigint NOT NULL,
    "Wish_Title_BG_Color" text,
    "Wish_Title_Txt_Color" text,
    "Wish_Box_BG_Color" text,
    "Wish_Box_Border_Color" text,
    "Wish_Box_Border_Type" text,
    "Wish_Box_Txt_Color" text,
    "Wish_Box_Button_BG_Color" text,
    "Wish_Box_Button_Txt_Color" text,
    "Wish_Box_Button_BG_Hover_Color" text,
    "Wish_Box_Button_Txt_Hover_Color" text,
    "Compare_Box_BG_Color" text,
    "Compare_Box_Txt_Color" text,
    "Compare_Box_Price_Hover_Color" text,
    "Compare_Box_Delete_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_wish_comp_e_com_designs OWNER TO postgres;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_wish_comp_e_com_designs_id_seq OWNER TO postgres;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq OWNED BY public.sup_pages_wish_comp_e_com_designs.id;


--
-- Name: taxes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.taxes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Rate" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hide" character varying DEFAULT 0,
    "Account" bigint,
    arr bigint,
    "CodeTax" text,
    "SubType" text,
    "NameEn" text
);


ALTER TABLE public.taxes OWNER TO postgres;

--
-- Name: taxes_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.taxes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_arr_seq OWNER TO postgres;

--
-- Name: taxes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.taxes_arr_seq OWNED BY public.taxes.arr;


--
-- Name: taxes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.taxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_id_seq OWNER TO postgres;

--
-- Name: taxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.taxes_id_seq OWNED BY public.taxes.id;


--
-- Name: teachers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.teachers (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Image" text,
    "Work_Type" text,
    "Hour_Price" text,
    "Qualification" text,
    "Qualification_Attach" text,
    "National_ID" text,
    "National_ID_Attach" text,
    "CV" text,
    "Nationality" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Address" text,
    "Age" text,
    "Phone1" text,
    "Phone2" text,
    "Whatsapp" text,
    "Facebook" text,
    "Instagram" text,
    "Linked" text,
    "Telegram" text,
    "Arabic_Bio" text,
    "English_Bio" text,
    "Marital_Status" text,
    "Account" text,
    "Covenant" text,
    "Commission" text,
    "Merit" text,
    "Account_Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers OWNER TO postgres;

--
-- Name: teachers_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.teachers_groups (
    id bigint NOT NULL,
    "Teacher" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_groups OWNER TO postgres;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.teachers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_groups_id_seq OWNER TO postgres;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.teachers_groups_id_seq OWNED BY public.teachers_groups.id;


--
-- Name: teachers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.teachers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_id_seq OWNER TO postgres;

--
-- Name: teachers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.teachers_id_seq OWNED BY public.teachers.id;


--
-- Name: teachers_subjects; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.teachers_subjects (
    id bigint NOT NULL,
    "Teacher" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_subjects OWNER TO postgres;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.teachers_subjects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_subjects_id_seq OWNER TO postgres;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.teachers_subjects_id_seq OWNED BY public.teachers_subjects.id;


--
-- Name: tenants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tenants (
    id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    data json
);


ALTER TABLE public.tenants OWNER TO postgres;

--
-- Name: tenants_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tenants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tenants_id_seq OWNER TO postgres;

--
-- Name: tenants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tenants_id_seq OWNED BY public.tenants.id;


--
-- Name: terms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.terms (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.terms OWNER TO postgres;

--
-- Name: terms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_id_seq OWNER TO postgres;

--
-- Name: terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.terms_id_seq OWNED BY public.terms.id;


--
-- Name: terms_maintainces; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.terms_maintainces (
    id bigint NOT NULL,
    "Desc_Work" text NOT NULL,
    "Desc_Not_Work" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Desc_Work_En" text,
    "Desc_Not_Work_En" text
);


ALTER TABLE public.terms_maintainces OWNER TO postgres;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.terms_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_maintainces_id_seq OWNER TO postgres;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.terms_maintainces_id_seq OWNED BY public.terms_maintainces.id;


--
-- Name: testclients; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.testclients (
    id bigint NOT NULL,
    "Name" text,
    "Governrate" text,
    "City" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.testclients OWNER TO postgres;

--
-- Name: testclients_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.testclients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.testclients_id_seq OWNER TO postgres;

--
-- Name: testclients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.testclients_id_seq OWNED BY public.testclients.id;


--
-- Name: ticekt_issues; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ticekt_issues (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.ticekt_issues OWNER TO postgres;

--
-- Name: ticekt_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ticekt_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticekt_issues_id_seq OWNER TO postgres;

--
-- Name: ticekt_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ticekt_issues_id_seq OWNED BY public.ticekt_issues.id;


--
-- Name: ticket_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ticket_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Price" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Qty" text,
    "Unit" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Ticket" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.ticket_products OWNER TO postgres;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ticket_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_products_id_seq OWNER TO postgres;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ticket_products_id_seq OWNED BY public.ticket_products.id;


--
-- Name: tickets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tickets (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Sender_Name" text,
    "Sender_Address" text,
    "Sender_Phone" text,
    "Addressees_Name" text,
    "Addressees_Address" text,
    "Addressees_Phone" text,
    "Notes" text,
    "Sub_Total" text,
    "Discount" text,
    "Total" text,
    "Store" text,
    "Safe" text,
    "Recived" text,
    "Selected" text,
    "Coin" text,
    "Draw" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Access_Area" text,
    "TicketIssues" text
);


ALTER TABLE public.tickets OWNER TO postgres;

--
-- Name: tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_arr_seq OWNER TO postgres;

--
-- Name: tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tickets_arr_seq OWNED BY public.tickets.arr;


--
-- Name: tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_id_seq OWNER TO postgres;

--
-- Name: tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tickets_id_seq OWNED BY public.tickets.id;


--
-- Name: translation_tourism_companies; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.translation_tourism_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Precent" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translation_tourism_companies OWNER TO postgres;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.translation_tourism_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translation_tourism_companies_id_seq OWNER TO postgres;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.translation_tourism_companies_id_seq OWNED BY public.translation_tourism_companies.id;


--
-- Name: translte_modules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.translte_modules (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Lang" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules OWNER TO postgres;

--
-- Name: translte_modules_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.translte_modules_details (
    id bigint NOT NULL,
    "Arabic_Text" text,
    "Translate_Text" text,
    "Module" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules_details OWNER TO postgres;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.translte_modules_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_details_id_seq OWNER TO postgres;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.translte_modules_details_id_seq OWNED BY public.translte_modules_details.id;


--
-- Name: translte_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.translte_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_id_seq OWNER TO postgres;

--
-- Name: translte_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.translte_modules_id_seq OWNED BY public.translte_modules.id;


--
-- Name: transltors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transltors (
    id bigint NOT NULL,
    "Original_Name" text NOT NULL,
    "New_Arabic_Name" text NOT NULL,
    "New_English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.transltors OWNER TO postgres;

--
-- Name: transltors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transltors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transltors_id_seq OWNER TO postgres;

--
-- Name: transltors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transltors_id_seq OWNED BY public.transltors.id;


--
-- Name: transport_contractors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transport_contractors (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Phone" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Merit_Account" text
);


ALTER TABLE public.transport_contractors OWNER TO postgres;

--
-- Name: transport_contractors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transport_contractors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transport_contractors_id_seq OWNER TO postgres;

--
-- Name: transport_contractors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transport_contractors_id_seq OWNED BY public.transport_contractors.id;


--
-- Name: transport_prices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transport_prices (
    id bigint NOT NULL,
    "From_Place" text,
    "To_Place" text,
    "Value" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.transport_prices OWNER TO postgres;

--
-- Name: transport_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transport_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transport_prices_id_seq OWNER TO postgres;

--
-- Name: transport_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transport_prices_id_seq OWNED BY public.transport_prices.id;


--
-- Name: transport_receivers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transport_receivers (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Phone" text,
    "Phone2" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Address" text,
    "Location" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.transport_receivers OWNER TO postgres;

--
-- Name: transport_receivers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transport_receivers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transport_receivers_id_seq OWNER TO postgres;

--
-- Name: transport_receivers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transport_receivers_id_seq OWNED BY public.transport_receivers.id;


--
-- Name: transports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transports (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Arrival_Date" text,
    "Arrival_Time" text,
    "Reference_Num" text,
    "Weight" text,
    "Note" text,
    "Payment_Method" text,
    "Insurance" text,
    "Pay" text,
    "Value" text,
    "Type" text,
    "Sender_Name" text,
    "Sender_Governorate" text,
    "Sender_City" text,
    "Sender_Place" text,
    "Sender_Address" text,
    "Sender_Phone1" text,
    "Sender_Phone2" text,
    "Sender_Location" text,
    "Receiver_Name" text,
    "Receiver_Governorate" text,
    "Receiver_City" text,
    "Receiver_Place" text,
    "Receiver_Address" text,
    "Receiver_Phone1" text,
    "Receiver_Phone2" text,
    "Receiver_Location" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "Cost_Center" text,
    "Driver" text,
    "Car" text,
    "Driver_Precent" text,
    "Driver_Value" text,
    "Contractor" text,
    "Contractor_Precent" text,
    "Contractor_Value" text,
    "Sender" text,
    "Received" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Expenses_Value" text,
    "Expenses_Precent" text,
    "The_Net" text
);


ALTER TABLE public.transports OWNER TO postgres;

--
-- Name: transports_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transports_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transports_arr_seq OWNER TO postgres;

--
-- Name: transports_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transports_arr_seq OWNED BY public.transports."Code";


--
-- Name: transports_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transports_id_seq OWNER TO postgres;

--
-- Name: transports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transports_id_seq OWNED BY public.transports.id;


--
-- Name: unloading_shipments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.unloading_shipments (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    "FromStore" text,
    "ToStore" text,
    "Car" text,
    "Delegate" text,
    "Driver" text,
    "Total_Pieces" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Count_Shipmets" text,
    "Status" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShipmentsDistributionCode" text
);


ALTER TABLE public.unloading_shipments OWNER TO postgres;

--
-- Name: unloading_shipments_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.unloading_shipments_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_arr_seq OWNER TO postgres;

--
-- Name: unloading_shipments_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.unloading_shipments_arr_seq OWNED BY public.unloading_shipments."Code";


--
-- Name: unloading_shipments_goods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.unloading_shipments_goods (
    id bigint NOT NULL,
    "Shipment_ID" text,
    "Code" text,
    "Total_Weight" text,
    "Total_Cost" text,
    "Total_Pieces" text,
    "ShipmentsUnloading" bigint,
    "Status" text DEFAULT 0,
    "Dist_Goods_ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Barcode" text
);


ALTER TABLE public.unloading_shipments_goods OWNER TO postgres;

--
-- Name: unloading_shipments_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.unloading_shipments_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_goods_id_seq OWNER TO postgres;

--
-- Name: unloading_shipments_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.unloading_shipments_goods_id_seq OWNED BY public.unloading_shipments_goods.id;


--
-- Name: unloading_shipments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.unloading_shipments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_id_seq OWNER TO postgres;

--
-- Name: unloading_shipments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.unloading_shipments_id_seq OWNED BY public.unloading_shipments.id;


--
-- Name: unloading_shipments_workers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.unloading_shipments_workers (
    id bigint NOT NULL,
    "Worker" text,
    "ShipmentsUnloading" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.unloading_shipments_workers OWNER TO postgres;

--
-- Name: unloading_shipments_workers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.unloading_shipments_workers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unloading_shipments_workers_id_seq OWNER TO postgres;

--
-- Name: unloading_shipments_workers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.unloading_shipments_workers_id_seq OWNED BY public.unloading_shipments_workers.id;


--
-- Name: update_values_investors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.update_values_investors (
    id bigint NOT NULL,
    "Date" text,
    "Valye" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.update_values_investors OWNER TO postgres;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.update_values_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.update_values_investors_id_seq OWNER TO postgres;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.update_values_investors_id_seq OWNED BY public.update_values_investors.id;


--
-- Name: upload_accountings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.upload_accountings (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Parent" text,
    "Note" text,
    "User" text,
    "Account_Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.upload_accountings OWNER TO postgres;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.upload_accountings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.upload_accountings_id_seq OWNER TO postgres;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.upload_accountings_id_seq OWNED BY public.upload_accountings.id;


--
-- Name: users_moves; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users_moves (
    id bigint NOT NULL,
    "User" bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Screen" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Explain" text,
    "ScreenEn" text,
    "TypeEn" text,
    "ExplainEn" text
);


ALTER TABLE public.users_moves OWNER TO postgres;

--
-- Name: users_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_moves_id_seq OWNER TO postgres;

--
-- Name: users_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.users_moves_id_seq OWNED BY public.users_moves.id;


--
-- Name: v_a_prices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.v_a_prices (
    id bigint NOT NULL,
    "Price" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Offer_Price" text,
    "Added" text,
    "VAProductID" text
);


ALTER TABLE public.v_a_prices OWNER TO postgres;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.v_a_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_prices_id_seq OWNER TO postgres;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.v_a_prices_id_seq OWNED BY public.v_a_prices.id;


--
-- Name: v_a_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.v_a_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Unit" text,
    "Product" bigint,
    "ProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_products OWNER TO postgres;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.v_a_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_products_id_seq OWNER TO postgres;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.v_a_products_id_seq OWNED BY public.v_a_products.id;


--
-- Name: v_a_qties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.v_a_qties (
    id bigint NOT NULL,
    "Qty" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    "ProductID" bigint,
    "VAProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_qties OWNER TO postgres;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.v_a_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_qties_id_seq OWNER TO postgres;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.v_a_qties_id_seq OWNED BY public.v_a_qties.id;


--
-- Name: vendor_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendor_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_column_sechdules OWNER TO postgres;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendor_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendor_account_statement_column_sechdules_id_seq OWNED BY public.vendor_account_statement_column_sechdules.id;


--
-- Name: vendor_account_statement_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendor_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_columns OWNER TO postgres;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendor_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_columns_id_seq OWNER TO postgres;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendor_account_statement_columns_id_seq OWNED BY public.vendor_account_statement_columns.id;


--
-- Name: vendor_filters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendor_filters OWNER TO postgres;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_filters_id_seq OWNER TO postgres;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendor_filters_id_seq OWNED BY public.vendor_filters.id;


--
-- Name: vendor_products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendor_products (
    id bigint NOT NULL,
    "Product_Name" text,
    "Product_Weight" text,
    "Product_Height" text,
    "Product_Length" text,
    "Product_Width" text,
    "Qty" text,
    "Price" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendor_products OWNER TO postgres;

--
-- Name: vendor_products_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendor_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_products_id_seq OWNER TO postgres;

--
-- Name: vendor_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendor_products_id_seq OWNED BY public.vendor_products.id;


--
-- Name: vendors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendors (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Phone2" text,
    "Commercial_Register" text,
    "Tax_Card" text,
    "Price_Level" text,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "City" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Responsible" bigint,
    "Pro_Group" bigint,
    "Brand" bigint,
    "Governrate" bigint,
    "NameEn" text,
    "SearchCode" text,
    "Credit_Limit" text,
    "Monthly_Target" text DEFAULT 0,
    "Quarterly_Target" text DEFAULT 0,
    "Yearly_Target" text DEFAULT 0
);


ALTER TABLE public.vendors OWNER TO postgres;

--
-- Name: vendors_arr_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendors_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_arr_seq OWNER TO postgres;

--
-- Name: vendors_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendors_arr_seq OWNED BY public.vendors.arr;


--
-- Name: vendors_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_id_seq OWNER TO postgres;

--
-- Name: vendors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendors_id_seq OWNED BY public.vendors.id;


--
-- Name: vendors_statements_column_sechdules; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendors_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_column_sechdules OWNER TO postgres;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendors_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_column_sechdules_id_seq OWNER TO postgres;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendors_statements_column_sechdules_id_seq OWNED BY public.vendors_statements_column_sechdules.id;


--
-- Name: vendors_statements_columns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vendors_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_columns OWNER TO postgres;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vendors_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_columns_id_seq OWNER TO postgres;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vendors_statements_columns_id_seq OWNED BY public.vendors_statements_columns.id;


--
-- Name: virables; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.virables OWNER TO postgres;

--
-- Name: virables_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.virables_id_seq OWNER TO postgres;

--
-- Name: virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.virables_id_seq OWNED BY public.virables.id;


--
-- Name: vouchers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vouchers (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" text,
    "Safe" text,
    "Debitor" text,
    "Creditor" text,
    "Account" text,
    "Statement" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vouchers OWNER TO postgres;

--
-- Name: vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vouchers_id_seq OWNER TO postgres;

--
-- Name: vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.vouchers_id_seq OWNED BY public.vouchers.id;


--
-- Name: web_sliders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.web_sliders (
    id bigint NOT NULL,
    "Status" character varying(191) NOT NULL,
    "Arabic_Title" text NOT NULL,
    "English_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text
);


ALTER TABLE public.web_sliders OWNER TO postgres;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.web_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_sliders_id_seq OWNER TO postgres;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.web_sliders_id_seq OWNED BY public.web_sliders.id;


--
-- Name: wishlists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wishlists (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.wishlists OWNER TO postgres;

--
-- Name: wishlists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.wishlists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.wishlists_id_seq OWNER TO postgres;

--
-- Name: wishlists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.wishlists_id_seq OWNED BY public.wishlists.id;


--
-- Name: work_departments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_departments (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Budget" text
);


ALTER TABLE public.work_departments OWNER TO postgres;

--
-- Name: work_departments_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_departments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_departments_id_seq OWNER TO postgres;

--
-- Name: work_departments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_departments_id_seq OWNED BY public.work_departments.id;


--
-- Name: workers_sales_petrols; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.workers_sales_petrols (
    id bigint NOT NULL,
    "Worker" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.workers_sales_petrols OWNER TO postgres;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workers_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workers_sales_petrols_id_seq OWNER TO postgres;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.workers_sales_petrols_id_seq OWNED BY public.workers_sales_petrols.id;


--
-- Name: zkteco_devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.zkteco_devices (
    id bigint NOT NULL,
    ip inet NOT NULL,
    port character varying(10) NOT NULL,
    model_name character varying(191) NOT NULL,
    status smallint DEFAULT '0'::smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.zkteco_devices OWNER TO postgres;

--
-- Name: zkteco_devices_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.zkteco_devices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.zkteco_devices_id_seq OWNER TO postgres;

--
-- Name: zkteco_devices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.zkteco_devices_id_seq OWNED BY public.zkteco_devices.id;


--
-- Name: a_v_pro_check_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.a_v_pro_check_qties ALTER COLUMN id SET DEFAULT nextval('public.a_v_pro_check_qties_id_seq'::regclass);


--
-- Name: abouts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.abouts ALTER COLUMN id SET DEFAULT nextval('public.abouts_id_seq'::regclass);


--
-- Name: abstracts_contractors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.abstracts_contractors ALTER COLUMN id SET DEFAULT nextval('public.abstracts_contractors_id_seq'::regclass);


--
-- Name: acccounting_manuals id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.acccounting_manuals ALTER COLUMN id SET DEFAULT nextval('public.acccounting_manuals_id_seq'::regclass);


--
-- Name: accounts_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.accounts_default_data ALTER COLUMN id SET DEFAULT nextval('public.accounts_default_data_id_seq'::regclass);


--
-- Name: activites id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.activites ALTER COLUMN id SET DEFAULT nextval('public.activites_id_seq'::regclass);


--
-- Name: add_translates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.add_translates ALTER COLUMN id SET DEFAULT nextval('public.add_translates_id_seq'::regclass);


--
-- Name: additional_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.additional_products ALTER COLUMN id SET DEFAULT nextval('public.additional_products_id_seq'::regclass);


--
-- Name: addressses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.addressses ALTER COLUMN id SET DEFAULT nextval('public.addressses_id_seq'::regclass);


--
-- Name: admins id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.admins ALTER COLUMN id SET DEFAULT nextval('public.admins_id_seq'::regclass);


--
-- Name: all_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.all_groups ALTER COLUMN id SET DEFAULT nextval('public.all_groups_id_seq'::regclass);


--
-- Name: allowences_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.allowences_emps ALTER COLUMN id SET DEFAULT nextval('public.allowences_emps_id_seq'::regclass);


--
-- Name: apps_change_prices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.apps_change_prices ALTER COLUMN id SET DEFAULT nextval('public.apps_change_prices_id_seq'::regclass);


--
-- Name: articles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.articles ALTER COLUMN id SET DEFAULT nextval('public.articles_id_seq'::regclass);


--
-- Name: assembly_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assembly_products ALTER COLUMN id SET DEFAULT nextval('public.assembly_products_id_seq'::regclass);


--
-- Name: assets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assets ALTER COLUMN id SET DEFAULT nextval('public.assets_id_seq'::regclass);


--
-- Name: assets Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assets ALTER COLUMN "Code" SET DEFAULT nextval('public.assets_arr_seq'::regclass);


--
-- Name: assets_expenses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assets_expenses ALTER COLUMN id SET DEFAULT nextval('public.assets_expenses_id_seq'::regclass);


--
-- Name: attend_departure_import id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attend_departure_import ALTER COLUMN id SET DEFAULT nextval('public.attend_departure_import_id_seq'::regclass);


--
-- Name: attendance_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attendance_emps ALTER COLUMN id SET DEFAULT nextval('public.attendance_emps_id_seq'::regclass);


--
-- Name: attendances id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attendances ALTER COLUMN id SET DEFAULT nextval('public.attendances_id_seq'::regclass);


--
-- Name: attendances Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attendances ALTER COLUMN "Code" SET DEFAULT nextval('public.attendances_arr_seq'::regclass);


--
-- Name: attendence_policy_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.attendence_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.attendence_policy_emps_id_seq'::regclass);


--
-- Name: barcode_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_products ALTER COLUMN id SET DEFAULT nextval('public.barcode_products_id_seq'::regclass);


--
-- Name: barcode_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN id SET DEFAULT nextval('public.barcode_settings_id_seq'::regclass);


--
-- Name: barcode_settings Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN "Code" SET DEFAULT nextval('public.barcode_settings_arr_seq'::regclass);


--
-- Name: barcode_shows id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_shows ALTER COLUMN id SET DEFAULT nextval('public.barcode_shows_id_seq'::regclass);


--
-- Name: befroe_footers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.befroe_footers ALTER COLUMN id SET DEFAULT nextval('public.befroe_footers_id_seq'::regclass);


--
-- Name: beneftis_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.beneftis_types ALTER COLUMN id SET DEFAULT nextval('public.beneftis_types_id_seq'::regclass);


--
-- Name: bones_sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bones_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.bones_sales_petrols_id_seq'::regclass);


--
-- Name: bones_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bones_types ALTER COLUMN id SET DEFAULT nextval('public.bones_types_id_seq'::regclass);


--
-- Name: borrowas id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN id SET DEFAULT nextval('public.borrowas_id_seq'::regclass);


--
-- Name: borrowas Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN "Code" SET DEFAULT nextval('public.borrowas_arr_seq'::regclass);


--
-- Name: branches id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.branches ALTER COLUMN id SET DEFAULT nextval('public.branches_id_seq'::regclass);


--
-- Name: brands id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.brands ALTER COLUMN id SET DEFAULT nextval('public.brands_id_seq'::regclass);


--
-- Name: campaigns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.campaigns ALTER COLUMN id SET DEFAULT nextval('public.campaigns_id_seq'::regclass);


--
-- Name: capital_increases id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.capital_increases ALTER COLUMN id SET DEFAULT nextval('public.capital_increases_id_seq'::regclass);


--
-- Name: capitals id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.capitals ALTER COLUMN id SET DEFAULT nextval('public.capitals_id_seq'::regclass);


--
-- Name: car_shippings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.car_shippings ALTER COLUMN id SET DEFAULT nextval('public.car_shippings_id_seq'::regclass);


--
-- Name: cars_sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cars_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.cars_sales_petrols_id_seq'::regclass);


--
-- Name: cart_stores id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cart_stores ALTER COLUMN id SET DEFAULT nextval('public.cart_stores_id_seq'::regclass);


--
-- Name: chat_issues id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.chat_issues ALTER COLUMN id SET DEFAULT nextval('public.chat_issues_id_seq'::regclass);


--
-- Name: checks_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.checks_types ALTER COLUMN id SET DEFAULT nextval('public.checks_types_id_seq'::regclass);


--
-- Name: cities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cities ALTER COLUMN id SET DEFAULT nextval('public.cities_id_seq'::regclass);


--
-- Name: client_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: client_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_columns_id_seq'::regclass);


--
-- Name: client_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_filters ALTER COLUMN id SET DEFAULT nextval('public.client_filters_id_seq'::regclass);


--
-- Name: client_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_requests ALTER COLUMN id SET DEFAULT nextval('public.client_requests_id_seq'::regclass);


--
-- Name: client_requests Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.client_requests_arr_seq'::regclass);


--
-- Name: client_sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.client_sales_petrols_id_seq'::regclass);


--
-- Name: client_statuses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.client_statuses ALTER COLUMN id SET DEFAULT nextval('public.client_statuses_id_seq'::regclass);


--
-- Name: clients_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.clients_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_column_sechdules_id_seq'::regclass);


--
-- Name: clients_statements_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.clients_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_columns_id_seq'::regclass);


--
-- Name: coins id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.coins ALTER COLUMN id SET DEFAULT nextval('public.coins_id_seq'::regclass);


--
-- Name: comments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comments ALTER COLUMN id SET DEFAULT nextval('public.comments_id_seq'::regclass);


--
-- Name: comments_clients id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comments_clients ALTER COLUMN id SET DEFAULT nextval('public.comments_clients_id_seq'::regclass);


--
-- Name: company_cars id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company_cars ALTER COLUMN id SET DEFAULT nextval('public.company_cars_id_seq'::regclass);


--
-- Name: company_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company_data ALTER COLUMN id SET DEFAULT nextval('public.company_data_id_seq'::regclass);


--
-- Name: compare_prices_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compare_prices_columns ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_id_seq'::regclass);


--
-- Name: compare_prices_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compare_prices_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_sechdules_id_seq'::regclass);


--
-- Name: compare_prices_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compare_prices_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filter_twos_id_seq'::regclass);


--
-- Name: compare_prices_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compare_prices_filters ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filters_id_seq'::regclass);


--
-- Name: compares id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compares ALTER COLUMN id SET DEFAULT nextval('public.compares_id_seq'::regclass);


--
-- Name: competitors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.competitors ALTER COLUMN id SET DEFAULT nextval('public.competitors_id_seq'::regclass);


--
-- Name: consist_maintainces id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.consist_maintainces ALTER COLUMN id SET DEFAULT nextval('public.consist_maintainces_id_seq'::regclass);


--
-- Name: consists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.consists ALTER COLUMN id SET DEFAULT nextval('public.consists_id_seq'::regclass);


--
-- Name: consists Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.consists ALTER COLUMN "Code" SET DEFAULT nextval('public.consists_arr_seq'::regclass);


--
-- Name: contact_u_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.contact_u_s ALTER COLUMN id SET DEFAULT nextval('public.contact_u_s_id_seq'::regclass);


--
-- Name: contract_statuses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.contract_statuses ALTER COLUMN id SET DEFAULT nextval('public.contract_statuses_id_seq'::regclass);


--
-- Name: contractors_real_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.contractors_real_projects ALTER COLUMN id SET DEFAULT nextval('public.contractors_real_projects_id_seq'::regclass);


--
-- Name: cost_centers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cost_centers ALTER COLUMN id SET DEFAULT nextval('public.cost_centers_id_seq'::regclass);


--
-- Name: counters_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.counters_types ALTER COLUMN id SET DEFAULT nextval('public.counters_types_id_seq'::regclass);


--
-- Name: countris id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.countris ALTER COLUMN id SET DEFAULT nextval('public.countris_id_seq'::regclass);


--
-- Name: coupon_codes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.coupon_codes ALTER COLUMN id SET DEFAULT nextval('public.coupon_codes_id_seq'::regclass);


--
-- Name: courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses ALTER COLUMN id SET DEFAULT nextval('public.courses_id_seq'::regclass);


--
-- Name: courses_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_categories ALTER COLUMN id SET DEFAULT nextval('public.courses_categories_id_seq'::regclass);


--
-- Name: courses_halls id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_halls ALTER COLUMN id SET DEFAULT nextval('public.courses_halls_id_seq'::regclass);


--
-- Name: courses_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_types ALTER COLUMN id SET DEFAULT nextval('public.courses_types_id_seq'::regclass);


--
-- Name: crm_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.crm_default_data ALTER COLUMN id SET DEFAULT nextval('public.crm_default_data_id_seq'::regclass);


--
-- Name: custom_prints id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.custom_prints ALTER COLUMN id SET DEFAULT nextval('public.custom_prints_id_seq'::regclass);


--
-- Name: customer_comments_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customer_comments_products ALTER COLUMN id SET DEFAULT nextval('public.customer_comments_products_id_seq'::regclass);


--
-- Name: customer_follow_ups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN id SET DEFAULT nextval('public.customer_follow_ups_id_seq'::regclass);


--
-- Name: customer_follow_ups Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN "Code" SET DEFAULT nextval('public.customer_follow_ups_arr_seq'::regclass);


--
-- Name: customers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers ALTER COLUMN id SET DEFAULT nextval('public.customers_id_seq'::regclass);


--
-- Name: customers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_arr_seq'::regclass);


--
-- Name: customers_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers_files ALTER COLUMN id SET DEFAULT nextval('public.customers_files_id_seq'::regclass);


--
-- Name: customers_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers_groups ALTER COLUMN id SET DEFAULT nextval('public.customers_groups_id_seq'::regclass);


--
-- Name: customers_rate_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers_rate_types ALTER COLUMN id SET DEFAULT nextval('public.customers_rate_types_id_seq'::regclass);


--
-- Name: customers_tickets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN id SET DEFAULT nextval('public.customers_tickets_id_seq'::regclass);


--
-- Name: customers_tickets Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_tickets_arr_seq'::regclass);


--
-- Name: deducations_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.deducations_types ALTER COLUMN id SET DEFAULT nextval('public.deducations_types_id_seq'::regclass);


--
-- Name: deductions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.deductions ALTER COLUMN id SET DEFAULT nextval('public.deductions_id_seq'::regclass);


--
-- Name: deductions Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.deductions ALTER COLUMN "Code" SET DEFAULT nextval('public.deductions_arr_seq'::regclass);


--
-- Name: default_data_show_hides id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.default_data_show_hides ALTER COLUMN id SET DEFAULT nextval('public.default_data_show_hides_id_seq'::regclass);


--
-- Name: delivery_apps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.delivery_apps ALTER COLUMN id SET DEFAULT nextval('public.delivery_apps_id_seq'::regclass);


--
-- Name: depaarture_policy_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.depaarture_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.depaarture_policy_emps_id_seq'::regclass);


--
-- Name: departure_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.departure_emps ALTER COLUMN id SET DEFAULT nextval('public.departure_emps_id_seq'::regclass);


--
-- Name: departures id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.departures ALTER COLUMN id SET DEFAULT nextval('public.departures_id_seq'::regclass);


--
-- Name: departures Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.departures ALTER COLUMN "Code" SET DEFAULT nextval('public.departures_arr_seq'::regclass);


--
-- Name: desvice_cases id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.desvice_cases ALTER COLUMN id SET DEFAULT nextval('public.desvice_cases_id_seq'::regclass);


--
-- Name: device_descrips id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_descrips ALTER COLUMN id SET DEFAULT nextval('public.device_descrips_id_seq'::regclass);


--
-- Name: devices_typesies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.devices_typesies ALTER COLUMN id SET DEFAULT nextval('public.devices_typesies_id_seq'::regclass);


--
-- Name: disclaimers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.disclaimers ALTER COLUMN id SET DEFAULT nextval('public.disclaimers_id_seq'::regclass);


--
-- Name: discounts_emps id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.discounts_emps ALTER COLUMN id SET DEFAULT nextval('public.discounts_emps_id_seq'::regclass);


--
-- Name: domains id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.domains ALTER COLUMN id SET DEFAULT nextval('public.domains_id_seq'::regclass);


--
-- Name: emp_covenants id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_covenants ALTER COLUMN id SET DEFAULT nextval('public.emp_covenants_id_seq'::regclass);


--
-- Name: emp_excs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_excs ALTER COLUMN id SET DEFAULT nextval('public.emp_excs_id_seq'::regclass);


--
-- Name: emp_installment_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_installment_details ALTER COLUMN id SET DEFAULT nextval('public.emp_installment_details_id_seq'::regclass);


--
-- Name: emp_installments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_installments ALTER COLUMN id SET DEFAULT nextval('public.emp_installments_id_seq'::regclass);


--
-- Name: emp_mails id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_mails ALTER COLUMN id SET DEFAULT nextval('public.emp_mails_id_seq'::regclass);


--
-- Name: emp_movements id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_movements ALTER COLUMN id SET DEFAULT nextval('public.emp_movements_id_seq'::regclass);


--
-- Name: emp_p_o_s_stores id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_p_o_s_stores ALTER COLUMN id SET DEFAULT nextval('public.emp_p_o_s_stores_id_seq'::regclass);


--
-- Name: emp_payment_accounts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_payment_accounts ALTER COLUMN id SET DEFAULT nextval('public.emp_payment_accounts_id_seq'::regclass);


--
-- Name: emp_ratios id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_ratios ALTER COLUMN id SET DEFAULT nextval('public.emp_ratios_id_seq'::regclass);


--
-- Name: emp_recipt_accounts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_recipt_accounts ALTER COLUMN id SET DEFAULT nextval('public.emp_recipt_accounts_id_seq'::regclass);


--
-- Name: emp_safes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emp_safes ALTER COLUMN id SET DEFAULT nextval('public.emp_safes_id_seq'::regclass);


--
-- Name: empassies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empassies ALTER COLUMN id SET DEFAULT nextval('public.empassies_id_seq'::regclass);


--
-- Name: empassy_reserve_dates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empassy_reserve_dates ALTER COLUMN id SET DEFAULT nextval('public.empassy_reserve_dates_id_seq'::regclass);


--
-- Name: employesses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.employesses ALTER COLUMN id SET DEFAULT nextval('public.employesses_id_seq'::regclass);


--
-- Name: employesses Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.employesses ALTER COLUMN "Code" SET DEFAULT nextval('public.employesses_arr_seq'::regclass);


--
-- Name: employment_levels id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.employment_levels ALTER COLUMN id SET DEFAULT nextval('public.employment_levels_id_seq'::regclass);


--
-- Name: emps_producation_points id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emps_producation_points ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_points_id_seq'::regclass);


--
-- Name: emps_producation_quantities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emps_producation_quantities ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_quantities_id_seq'::regclass);


--
-- Name: entitlements id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN id SET DEFAULT nextval('public.entitlements_id_seq'::regclass);


--
-- Name: entitlements Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN "Code" SET DEFAULT nextval('public.entitlements_arr_seq'::regclass);


--
-- Name: events id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.events ALTER COLUMN id SET DEFAULT nextval('public.events_id_seq'::regclass);


--
-- Name: examinations_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examinations_types ALTER COLUMN id SET DEFAULT nextval('public.examinations_types_id_seq'::regclass);


--
-- Name: exchange_commissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN id SET DEFAULT nextval('public.exchange_commissions_id_seq'::regclass);


--
-- Name: exchange_commissions Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN "Code" SET DEFAULT nextval('public.exchange_commissions_arr_seq'::regclass);


--
-- Name: execute_job_order_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execute_job_order_models ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_models_id_seq'::regclass);


--
-- Name: execute_job_order_workmanships id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execute_job_order_workmanships ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_workmanships_id_seq'::regclass);


--
-- Name: execute_job_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN id SET DEFAULT nextval('public.execute_job_orders_id_seq'::regclass);


--
-- Name: execute_job_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.execute_job_orders_arr_seq'::regclass);


--
-- Name: executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: executing_receiving_secretariats Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receiving_secretariats_arr_seq'::regclass);


--
-- Name: executing_receivings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.executing_receivings_id_seq'::regclass);


--
-- Name: executing_receivings Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receivings_arr_seq'::regclass);


--
-- Name: executor_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.executor_filters ALTER COLUMN id SET DEFAULT nextval('public.executor_filters_id_seq'::regclass);


--
-- Name: expenses_list_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.expenses_list_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_column_sechdules_id_seq'::regclass);


--
-- Name: expenses_list_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.expenses_list_columns ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_columns_id_seq'::regclass);


--
-- Name: expenses_type_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.expenses_type_projects ALTER COLUMN id SET DEFAULT nextval('public.expenses_type_projects_id_seq'::regclass);


--
-- Name: expire_date_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.expire_date_qties ALTER COLUMN id SET DEFAULT nextval('public.expire_date_qties_id_seq'::regclass);


--
-- Name: export_checks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN id SET DEFAULT nextval('public.export_checks_id_seq'::regclass);


--
-- Name: export_checks Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.export_checks_arr_seq'::regclass);


--
-- Name: f_a_q_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.f_a_q_s ALTER COLUMN id SET DEFAULT nextval('public.f_a_q_s_id_seq'::regclass);


--
-- Name: failed_jobs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failed_jobs ALTER COLUMN id SET DEFAULT nextval('public.failed_jobs_id_seq'::regclass);


--
-- Name: faults_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faults_types ALTER COLUMN id SET DEFAULT nextval('public.faults_types_id_seq'::regclass);


--
-- Name: fifo_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.fifo_qties_id_seq'::regclass);


--
-- Name: follow_lists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.follow_lists ALTER COLUMN id SET DEFAULT nextval('public.follow_lists_id_seq'::regclass);


--
-- Name: general_dailies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN id SET DEFAULT nextval('public.general_dailies_id_seq'::regclass);


--
-- Name: general_dailies Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN "Code" SET DEFAULT nextval('public.general_dailies_arr_seq'::regclass);


--
-- Name: goods_product_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.goods_product_projects ALTER COLUMN id SET DEFAULT nextval('public.goods_product_projects_id_seq'::regclass);


--
-- Name: goods_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.goods_projects ALTER COLUMN id SET DEFAULT nextval('public.goods_projects_id_seq'::regclass);


--
-- Name: governrates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.governrates ALTER COLUMN id SET DEFAULT nextval('public.governrates_id_seq'::regclass);


--
-- Name: group_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.group_filters ALTER COLUMN id SET DEFAULT nextval('public.group_filters_id_seq'::regclass);


--
-- Name: holidays id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays ALTER COLUMN id SET DEFAULT nextval('public.holidays_id_seq'::regclass);


--
-- Name: holidays Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays ALTER COLUMN "Code" SET DEFAULT nextval('public.holidays_arr_seq'::regclass);


--
-- Name: holidays_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays_types ALTER COLUMN id SET DEFAULT nextval('public.holidays_types_id_seq'::regclass);


--
-- Name: home_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.home_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_e_com_designs_id_seq'::regclass);


--
-- Name: home_product_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.home_product_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_product_e_com_designs_id_seq'::regclass);


--
-- Name: import_expenses_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.import_expenses_types ALTER COLUMN id SET DEFAULT nextval('public.import_expenses_types_id_seq'::regclass);


--
-- Name: import_new_prods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.import_new_prods ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_id_seq'::regclass);


--
-- Name: import_new_prods_starts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.import_new_prods_starts ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_starts_id_seq'::regclass);


--
-- Name: in_out_logs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.in_out_logs ALTER COLUMN id SET DEFAULT nextval('public.in_out_logs_id_seq'::regclass);


--
-- Name: incom_checks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN id SET DEFAULT nextval('public.incom_checks_id_seq'::regclass);


--
-- Name: incom_checks Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.incom_checks_arr_seq'::regclass);


--
-- Name: incom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.incom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_models_id_seq'::regclass);


--
-- Name: incom_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.incom_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: installment_companies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.installment_companies ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_id_seq'::regclass);


--
-- Name: installment_companies_ratios id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.installment_companies_ratios ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_ratios_id_seq'::regclass);


--
-- Name: installment_dates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.installment_dates ALTER COLUMN id SET DEFAULT nextval('public.installment_dates_id_seq'::regclass);


--
-- Name: installments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.installments ALTER COLUMN id SET DEFAULT nextval('public.installments_id_seq'::regclass);


--
-- Name: insurance_companies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.insurance_companies ALTER COLUMN id SET DEFAULT nextval('public.insurance_companies_id_seq'::regclass);


--
-- Name: insurance_papers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN id SET DEFAULT nextval('public.insurance_papers_id_seq'::regclass);


--
-- Name: insurance_papers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN "Code" SET DEFAULT nextval('public.insurance_papers_arr_seq'::regclass);


--
-- Name: interviews id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.interviews ALTER COLUMN id SET DEFAULT nextval('public.interviews_id_seq'::regclass);


--
-- Name: interviews Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.interviews ALTER COLUMN "Code" SET DEFAULT nextval('public.interviews_arr_seq'::regclass);


--
-- Name: interviews_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.interviews_types ALTER COLUMN id SET DEFAULT nextval('public.interviews_types_id_seq'::regclass);


--
-- Name: intros id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.intros ALTER COLUMN id SET DEFAULT nextval('public.intros_id_seq'::regclass);


--
-- Name: inventories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.inventories ALTER COLUMN id SET DEFAULT nextval('public.inventories_id_seq'::regclass);


--
-- Name: inventories Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.inventories ALTER COLUMN "Code" SET DEFAULT nextval('public.inventories_arr_seq'::regclass);


--
-- Name: investors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.investors ALTER COLUMN id SET DEFAULT nextval('public.investors_id_seq'::regclass);


--
-- Name: issues id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issues ALTER COLUMN id SET DEFAULT nextval('public.issues_id_seq'::regclass);


--
-- Name: items_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.items_groups ALTER COLUMN id SET DEFAULT nextval('public.items_groups_id_seq'::regclass);


--
-- Name: itineraries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.itineraries ALTER COLUMN id SET DEFAULT nextval('public.itineraries_id_seq'::regclass);


--
-- Name: itinerary_visits id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.itinerary_visits ALTER COLUMN id SET DEFAULT nextval('public.itinerary_visits_id_seq'::regclass);


--
-- Name: job_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN id SET DEFAULT nextval('public.job_orders_id_seq'::regclass);


--
-- Name: job_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.job_orders_arr_seq'::regclass);


--
-- Name: job_orders_executors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.job_orders_executors ALTER COLUMN id SET DEFAULT nextval('public.job_orders_executors_id_seq'::regclass);


--
-- Name: jobs_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.jobs_types ALTER COLUMN id SET DEFAULT nextval('public.jobs_types_id_seq'::regclass);


--
-- Name: journalizing_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.journalizing_details ALTER COLUMN id SET DEFAULT nextval('public.journalizing_details_id_seq'::regclass);


--
-- Name: journalizings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN id SET DEFAULT nextval('public.journalizings_id_seq'::regclass);


--
-- Name: journalizings Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN "Code" SET DEFAULT nextval('public.journalizings_arr_seq'::regclass);


--
-- Name: languages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.languages ALTER COLUMN id SET DEFAULT nextval('public.languages_id_seq'::regclass);


--
-- Name: loan_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_types ALTER COLUMN id SET DEFAULT nextval('public.loan_types_id_seq'::regclass);


--
-- Name: loans id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loans ALTER COLUMN id SET DEFAULT nextval('public.loans_id_seq'::regclass);


--
-- Name: loans Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loans ALTER COLUMN "Code" SET DEFAULT nextval('public.loans_arr_seq'::regclass);


--
-- Name: login_sliders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_sliders ALTER COLUMN id SET DEFAULT nextval('public.login_sliders_id_seq'::regclass);


--
-- Name: main_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.main_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.main_e_com_designs_id_seq'::regclass);


--
-- Name: maintainc_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.maintainc_bills_id_seq'::regclass);


--
-- Name: maintainc_bills Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.maintainc_bills_arr_seq'::regclass);


--
-- Name: maintaince_colors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.maintaince_colors ALTER COLUMN id SET DEFAULT nextval('public.maintaince_colors_id_seq'::regclass);


--
-- Name: maintaince_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.maintaince_default_data ALTER COLUMN id SET DEFAULT nextval('public.maintaince_default_data_id_seq'::regclass);


--
-- Name: manu_store_counts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manu_store_counts ALTER COLUMN id SET DEFAULT nextval('public.manu_store_counts_id_seq'::regclass);


--
-- Name: manufacture_companies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacture_companies ALTER COLUMN id SET DEFAULT nextval('public.manufacture_companies_id_seq'::regclass);


--
-- Name: manufacturing_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_default_data ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_default_data_id_seq'::regclass);


--
-- Name: manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_executions_id_seq'::regclass);


--
-- Name: manufacturing_executions Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_executions_arr_seq'::regclass);


--
-- Name: manufacturing_halls id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_halls ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_halls_id_seq'::regclass);


--
-- Name: manufacturing_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_models_id_seq'::regclass);


--
-- Name: manufacturing_models Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_models_arr_seq'::regclass);


--
-- Name: manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_orders_id_seq'::regclass);


--
-- Name: manufacturing_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_orders_arr_seq'::regclass);


--
-- Name: manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_requests_id_seq'::regclass);


--
-- Name: manufacturing_requests Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_requests_arr_seq'::regclass);


--
-- Name: manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: manufacturing_secretariat_models Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_secretariat_models_arr_seq'::regclass);


--
-- Name: measuerments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.measuerments ALTER COLUMN id SET DEFAULT nextval('public.measuerments_id_seq'::regclass);


--
-- Name: missions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.missions ALTER COLUMN id SET DEFAULT nextval('public.missions_id_seq'::regclass);


--
-- Name: module_settings_nums id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module_settings_nums ALTER COLUMN id SET DEFAULT nextval('public.module_settings_nums_id_seq'::regclass);


--
-- Name: modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.modules ALTER COLUMN id SET DEFAULT nextval('public.modules_id_seq'::regclass);


--
-- Name: more_products_halls id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.more_products_halls ALTER COLUMN id SET DEFAULT nextval('public.more_products_halls_id_seq'::regclass);


--
-- Name: most_sales_products_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.most_sales_products_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_column_sechdules_id_seq'::regclass);


--
-- Name: most_sales_products_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.most_sales_products_columns ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_columns_id_seq'::regclass);


--
-- Name: msg_rqsts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.msg_rqsts ALTER COLUMN id SET DEFAULT nextval('public.msg_rqsts_id_seq'::regclass);


--
-- Name: my_follow_lists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.my_follow_lists ALTER COLUMN id SET DEFAULT nextval('public.my_follow_lists_id_seq'::regclass);


--
-- Name: new_shipping_categories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.new_shipping_categories ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_categories_id_seq'::regclass);


--
-- Name: new_shipping_rqst_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.new_shipping_rqst_types ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_rqst_types_id_seq'::regclass);


--
-- Name: new_shipping_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.new_shipping_types ALTER COLUMN id SET DEFAULT nextval('public.new_shipping_types_id_seq'::regclass);


--
-- Name: notifications id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.notifications ALTER COLUMN id SET DEFAULT nextval('public.notifications_id_seq'::regclass);


--
-- Name: opening_entries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_id_seq'::regclass);


--
-- Name: opening_entries Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN "Code" SET DEFAULT nextval('public.opening_entries_arr_seq'::regclass);


--
-- Name: opening_entries_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opening_entries_details ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_details_id_seq'::regclass);


--
-- Name: order_pays id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.order_pays ALTER COLUMN id SET DEFAULT nextval('public.order_pays_id_seq'::regclass);


--
-- Name: outcom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.outcom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.outcom_manufacturing_models_id_seq'::regclass);


--
-- Name: outcome_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.outcome_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.outcome_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: over_times id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.over_times ALTER COLUMN id SET DEFAULT nextval('public.over_times_id_seq'::regclass);


--
-- Name: pack_prems id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pack_prems ALTER COLUMN id SET DEFAULT nextval('public.pack_prems_id_seq'::regclass);


--
-- Name: packages id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.packages ALTER COLUMN id SET DEFAULT nextval('public.packages_id_seq'::regclass);


--
-- Name: partners id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.partners ALTER COLUMN id SET DEFAULT nextval('public.partners_id_seq'::regclass);


--
-- Name: pay_profit_investors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pay_profit_investors ALTER COLUMN id SET DEFAULT nextval('public.pay_profit_investors_id_seq'::regclass);


--
-- Name: pay_salaries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN id SET DEFAULT nextval('public.pay_salaries_id_seq'::regclass);


--
-- Name: pay_salaries Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN "Code" SET DEFAULT nextval('public.pay_salaries_arr_seq'::regclass);


--
-- Name: payment_voucher_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.payment_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.payment_voucher_details_id_seq'::regclass);


--
-- Name: payment_vouchers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN id SET DEFAULT nextval('public.payment_vouchers_id_seq'::regclass);


--
-- Name: payment_vouchers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.payment_vouchers_arr_seq'::regclass);


--
-- Name: paymentss_products_real_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.paymentss_products_real_projects ALTER COLUMN id SET DEFAULT nextval('public.paymentss_products_real_projects_id_seq'::regclass);


--
-- Name: paymentss_real_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.paymentss_real_projects ALTER COLUMN id SET DEFAULT nextval('public.paymentss_real_projects_id_seq'::regclass);


--
-- Name: permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: permission_to_exchange_goods Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_exchange_goods_arr_seq'::regclass);


--
-- Name: permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_recived_goods_id_seq'::regclass);


--
-- Name: permission_to_recived_goods Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_recived_goods_arr_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: places id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.places ALTER COLUMN id SET DEFAULT nextval('public.places_id_seq'::regclass);


--
-- Name: platforms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.platforms ALTER COLUMN id SET DEFAULT nextval('public.platforms_id_seq'::regclass);


--
-- Name: polices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.polices ALTER COLUMN id SET DEFAULT nextval('public.polices_id_seq'::regclass);


--
-- Name: pro_details_imgs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pro_details_imgs ALTER COLUMN id SET DEFAULT nextval('public.pro_details_imgs_id_seq'::regclass);


--
-- Name: pro_notes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pro_notes ALTER COLUMN id SET DEFAULT nextval('public.pro_notes_id_seq'::regclass);


--
-- Name: product_details_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_details_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.product_details_e_com_designs_id_seq'::regclass);


--
-- Name: product_executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.product_executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: product_inventories id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_inventories ALTER COLUMN id SET DEFAULT nextval('public.product_inventories_id_seq'::regclass);


--
-- Name: product_job_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_job_orders ALTER COLUMN id SET DEFAULT nextval('public.product_job_orders_id_seq'::regclass);


--
-- Name: product_maintainc_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.product_maintainc_bills_id_seq'::regclass);


--
-- Name: product_manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.product_manufacturing_executions_id_seq'::regclass);


--
-- Name: product_moves id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_moves ALTER COLUMN id SET DEFAULT nextval('public.product_moves_id_seq'::regclass);


--
-- Name: product_moves_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_id_seq'::regclass);


--
-- Name: product_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: product_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filter_twos_id_seq'::regclass);


--
-- Name: product_moves_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filters_id_seq'::regclass);


--
-- Name: product_quote_images id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_quote_images ALTER COLUMN id SET DEFAULT nextval('public.product_quote_images_id_seq'::regclass);


--
-- Name: product_return_without_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.product_return_without_bills_id_seq'::regclass);


--
-- Name: product_sales id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_sales ALTER COLUMN id SET DEFAULT nextval('public.product_sales_id_seq'::regclass);


--
-- Name: product_sales_gifts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.product_sales_gifts_id_seq'::regclass);


--
-- Name: product_sales_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_sales_orders ALTER COLUMN id SET DEFAULT nextval('public.product_sales_orders_id_seq'::regclass);


--
-- Name: product_sales_subscribes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.product_sales_subscribes_id_seq'::regclass);


--
-- Name: product_settlements id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_settlements ALTER COLUMN id SET DEFAULT nextval('public.product_settlements_id_seq'::regclass);


--
-- Name: product_type_defaults id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_type_defaults ALTER COLUMN id SET DEFAULT nextval('public.product_type_defaults_id_seq'::regclass);


--
-- Name: product_units id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.product_units ALTER COLUMN id SET DEFAULT nextval('public.product_units_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products ALTER COLUMN id SET DEFAULT nextval('public.products_id_seq'::regclass);


--
-- Name: products_client_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_client_requests ALTER COLUMN id SET DEFAULT nextval('public.products_client_requests_id_seq'::regclass);


--
-- Name: products_consists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_consists ALTER COLUMN id SET DEFAULT nextval('public.products_consists_id_seq'::regclass);


--
-- Name: products_executing_receivings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.products_executing_receivings_id_seq'::regclass);


--
-- Name: products_manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_orders_id_seq'::regclass);


--
-- Name: products_manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_requests_id_seq'::regclass);


--
-- Name: products_permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: products_permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_recived_goods_id_seq'::regclass);


--
-- Name: products_purchase_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.products_purchase_petrols_id_seq'::regclass);


--
-- Name: products_purchases id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_purchases ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_id_seq'::regclass);


--
-- Name: products_purchases_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_orders_id_seq'::regclass);


--
-- Name: products_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_qties ALTER COLUMN id SET DEFAULT nextval('public.products_qties_id_seq'::regclass);


--
-- Name: products_quotes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_quotes ALTER COLUMN id SET DEFAULT nextval('public.products_quotes_id_seq'::regclass);


--
-- Name: products_return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.products_return_maintaince_bills_id_seq'::regclass);


--
-- Name: products_secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_export_goods_id_seq'::regclass);


--
-- Name: products_secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_import_goods_id_seq'::regclass);


--
-- Name: products_shortcomings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_shortcomings ALTER COLUMN id SET DEFAULT nextval('public.products_shortcomings_id_seq'::regclass);


--
-- Name: products_start_periods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_start_periods ALTER COLUMN id SET DEFAULT nextval('public.products_start_periods_id_seq'::regclass);


--
-- Name: products_stores id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_stores ALTER COLUMN id SET DEFAULT nextval('public.products_stores_id_seq'::regclass);


--
-- Name: products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.products_stores_transfers_id_seq'::regclass);


--
-- Name: products_viras id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products_viras ALTER COLUMN id SET DEFAULT nextval('public.products_viras_id_seq'::regclass);


--
-- Name: profit_sales_product_column_sechdulrs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profit_sales_product_column_sechdulrs ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_column_sechdulrs_id_seq'::regclass);


--
-- Name: profit_sales_product_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profit_sales_product_columns ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_columns_id_seq'::regclass);


--
-- Name: project_statuses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.project_statuses ALTER COLUMN id SET DEFAULT nextval('public.project_statuses_id_seq'::regclass);


--
-- Name: project_teams id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.project_teams ALTER COLUMN id SET DEFAULT nextval('public.project_teams_id_seq'::regclass);


--
-- Name: projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.projects ALTER COLUMN id SET DEFAULT nextval('public.projects_id_seq'::regclass);


--
-- Name: purch_bills_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purch_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_id_seq'::regclass);


--
-- Name: purch_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purch_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filters_id_seq'::regclass);


--
-- Name: purchase_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.purchase_petrols_id_seq'::regclass);


--
-- Name: purchase_petrols Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.purchase_petrols_arr_seq'::regclass);


--
-- Name: purchases id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases ALTER COLUMN id SET DEFAULT nextval('public.purchases_id_seq'::regclass);


--
-- Name: purchases Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_arr_seq'::regclass);


--
-- Name: purchases_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases_default_data ALTER COLUMN id SET DEFAULT nextval('public.purchases_default_data_id_seq'::regclass);


--
-- Name: purchases_expenses_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases_expenses_types ALTER COLUMN id SET DEFAULT nextval('public.purchases_expenses_types_id_seq'::regclass);


--
-- Name: purchases_order_expenses_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases_order_expenses_types ALTER COLUMN id SET DEFAULT nextval('public.purchases_order_expenses_types_id_seq'::regclass);


--
-- Name: purchases_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.purchases_orders_id_seq'::regclass);


--
-- Name: purchases_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_orders_arr_seq'::regclass);


--
-- Name: purpose_travel id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.purpose_travel ALTER COLUMN id SET DEFAULT nextval('public.purpose_travel_id_seq'::regclass);


--
-- Name: q_r_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.q_r_s ALTER COLUMN id SET DEFAULT nextval('public.q_r_s_id_seq'::regclass);


--
-- Name: qualities id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.qualities ALTER COLUMN id SET DEFAULT nextval('public.qualities_id_seq'::regclass);


--
-- Name: qualities Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.qualities ALTER COLUMN "Code" SET DEFAULT nextval('public.qualities_arr_seq'::regclass);


--
-- Name: quality_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quality_details ALTER COLUMN id SET DEFAULT nextval('public.quality_details_id_seq'::regclass);


--
-- Name: quote_images id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN id SET DEFAULT nextval('public.quote_images_id_seq'::regclass);


--
-- Name: quote_images Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN "Code" SET DEFAULT nextval('public.quote_images_arr_seq'::regclass);


--
-- Name: quotes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quotes ALTER COLUMN id SET DEFAULT nextval('public.quotes_id_seq'::regclass);


--
-- Name: quotes Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quotes ALTER COLUMN "Code" SET DEFAULT nextval('public.quotes_arr_seq'::regclass);


--
-- Name: rabih_education id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rabih_education ALTER COLUMN id SET DEFAULT nextval('public.rabih_education_id_seq'::regclass);


--
-- Name: rates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rates ALTER COLUMN id SET DEFAULT nextval('public.rates_id_seq'::regclass);


--
-- Name: real_sate_projects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.real_sate_projects ALTER COLUMN id SET DEFAULT nextval('public.real_sate_projects_id_seq'::regclass);


--
-- Name: real_sate_projects_payments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.real_sate_projects_payments ALTER COLUMN id SET DEFAULT nextval('public.real_sate_projects_payments_id_seq'::regclass);


--
-- Name: real_state_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.real_state_default_data ALTER COLUMN id SET DEFAULT nextval('public.real_state_default_data_id_seq'::regclass);


--
-- Name: reasons id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reasons ALTER COLUMN id SET DEFAULT nextval('public.reasons_id_seq'::regclass);


--
-- Name: recipt_maintaince_errors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_maintaince_errors ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintaince_errors_id_seq'::regclass);


--
-- Name: recipt_maintainces id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintainces_id_seq'::regclass);


--
-- Name: recipt_maintainces Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_maintainces_arr_seq'::regclass);


--
-- Name: recipt_voucher_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.recipt_voucher_details_id_seq'::regclass);


--
-- Name: recipt_vouchers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN id SET DEFAULT nextval('public.recipt_vouchers_id_seq'::regclass);


--
-- Name: recipt_vouchers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_vouchers_arr_seq'::regclass);


--
-- Name: recipts_sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipts_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.recipts_sales_petrols_id_seq'::regclass);


--
-- Name: recipts_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recipts_types ALTER COLUMN id SET DEFAULT nextval('public.recipts_types_id_seq'::regclass);


--
-- Name: recived_purch_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_purch_products ALTER COLUMN id SET DEFAULT nextval('public.recived_purch_products_id_seq'::regclass);


--
-- Name: recived_purchts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN id SET DEFAULT nextval('public.recived_purchts_id_seq'::regclass);


--
-- Name: recived_purchts Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_purchts_arr_seq'::regclass);


--
-- Name: recived_sales id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_id_seq'::regclass);


--
-- Name: recived_sales Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_sales_arr_seq'::regclass);


--
-- Name: recived_sales_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_sales_products ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_products_id_seq'::regclass);


--
-- Name: recived_shipment_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_shipment_goods ALTER COLUMN id SET DEFAULT nextval('public.recived_shipment_goods_id_seq'::regclass);


--
-- Name: recived_shipments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_shipments ALTER COLUMN id SET DEFAULT nextval('public.recived_shipments_id_seq'::regclass);


--
-- Name: recived_shipments Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.recived_shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_shipments_arr_seq'::regclass);


--
-- Name: reg_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reg_courses ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_id_seq'::regclass);


--
-- Name: reg_courses_students id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reg_courses_students ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_students_id_seq'::regclass);


--
-- Name: reg_over_times id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN id SET DEFAULT nextval('public.reg_over_times_id_seq'::regclass);


--
-- Name: reg_over_times Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN "Code" SET DEFAULT nextval('public.reg_over_times_arr_seq'::regclass);


--
-- Name: remove_products_halls id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.remove_products_halls ALTER COLUMN id SET DEFAULT nextval('public.remove_products_halls_id_seq'::regclass);


--
-- Name: reports_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reports_settings ALTER COLUMN id SET DEFAULT nextval('public.reports_settings_id_seq'::regclass);


--
-- Name: reservations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reservations ALTER COLUMN id SET DEFAULT nextval('public.reservations_id_seq'::regclass);


--
-- Name: reservations Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reservations ALTER COLUMN "Code" SET DEFAULT nextval('public.reservations_arr_seq'::regclass);


--
-- Name: reserve_course_days id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reserve_course_days ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_days_id_seq'::regclass);


--
-- Name: reserve_course_students id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reserve_course_students ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_students_id_seq'::regclass);


--
-- Name: reserve_courses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reserve_courses ALTER COLUMN id SET DEFAULT nextval('public.reserve_courses_id_seq'::regclass);


--
-- Name: resignation_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN id SET DEFAULT nextval('public.resignation_requests_id_seq'::regclass);


--
-- Name: resignation_requests Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.resignation_requests_arr_seq'::regclass);


--
-- Name: resturant_abouts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_abouts ALTER COLUMN id SET DEFAULT nextval('public.resturant_abouts_id_seq'::regclass);


--
-- Name: resturant_blogs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_blogs ALTER COLUMN id SET DEFAULT nextval('public.resturant_blogs_id_seq'::regclass);


--
-- Name: resturant_cart_check_styles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_cart_check_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_cart_check_styles_id_seq'::regclass);


--
-- Name: resturant_carts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_carts ALTER COLUMN id SET DEFAULT nextval('public.resturant_carts_id_seq'::regclass);


--
-- Name: resturant_cupon_codes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_cupon_codes ALTER COLUMN id SET DEFAULT nextval('public.resturant_cupon_codes_id_seq'::regclass);


--
-- Name: resturant_galleries id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_galleries ALTER COLUMN id SET DEFAULT nextval('public.resturant_galleries_id_seq'::regclass);


--
-- Name: resturant_homes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_homes ALTER COLUMN id SET DEFAULT nextval('public.resturant_homes_id_seq'::regclass);


--
-- Name: resturant_index_style_i_i_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_index_style_i_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_i_s_id_seq'::regclass);


--
-- Name: resturant_index_style_i_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_index_style_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_s_id_seq'::regclass);


--
-- Name: resturant_menu_styles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_menu_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_menu_styles_id_seq'::regclass);


--
-- Name: resturant_nav_foot_styles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_nav_foot_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_nav_foot_styles_id_seq'::regclass);


--
-- Name: resturant_privacies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_privacies ALTER COLUMN id SET DEFAULT nextval('public.resturant_privacies_id_seq'::regclass);


--
-- Name: resturant_reservations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_reservations ALTER COLUMN id SET DEFAULT nextval('public.resturant_reservations_id_seq'::regclass);


--
-- Name: resturant_reviews id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_reviews ALTER COLUMN id SET DEFAULT nextval('public.resturant_reviews_id_seq'::regclass);


--
-- Name: resturant_sliders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_sliders ALTER COLUMN id SET DEFAULT nextval('public.resturant_sliders_id_seq'::regclass);


--
-- Name: resturant_socials id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_socials ALTER COLUMN id SET DEFAULT nextval('public.resturant_socials_id_seq'::regclass);


--
-- Name: resturant_styles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_styles_id_seq'::regclass);


--
-- Name: resturant_sup_page_styles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_sup_page_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_sup_page_styles_id_seq'::regclass);


--
-- Name: resturant_tables id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_tables ALTER COLUMN id SET DEFAULT nextval('public.resturant_tables_id_seq'::regclass);


--
-- Name: resturant_terms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_terms ALTER COLUMN id SET DEFAULT nextval('public.resturant_terms_id_seq'::regclass);


--
-- Name: resturant_video_sections id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resturant_video_sections ALTER COLUMN id SET DEFAULT nextval('public.resturant_video_sections_id_seq'::regclass);


--
-- Name: return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.return_maintaince_bills_id_seq'::regclass);


--
-- Name: return_maintaince_bills Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_maintaince_bills_arr_seq'::regclass);


--
-- Name: return_products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_products_stores_transfers_id_seq'::regclass);


--
-- Name: return_purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filters_id_seq'::regclass);


--
-- Name: return_purch_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_purch_products ALTER COLUMN id SET DEFAULT nextval('public.return_purch_products_id_seq'::regclass);


--
-- Name: return_purches id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN id SET DEFAULT nextval('public.return_purches_id_seq'::regclass);


--
-- Name: return_purches Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN "Code" SET DEFAULT nextval('public.return_purches_arr_seq'::regclass);


--
-- Name: return_sales id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN id SET DEFAULT nextval('public.return_sales_id_seq'::regclass);


--
-- Name: return_sales Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.return_sales_arr_seq'::regclass);


--
-- Name: return_sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filters_id_seq'::regclass);


--
-- Name: return_sales_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_sales_products ALTER COLUMN id SET DEFAULT nextval('public.return_sales_products_id_seq'::regclass);


--
-- Name: return_stors_transfers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_stors_transfers_id_seq'::regclass);


--
-- Name: return_stors_transfers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.return_stors_transfers_arr_seq'::regclass);


--
-- Name: return_without_bills id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.return_without_bills_id_seq'::regclass);


--
-- Name: return_without_bills Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_without_bills_arr_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: room_reservations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.room_reservations ALTER COLUMN id SET DEFAULT nextval('public.room_reservations_id_seq'::regclass);


--
-- Name: rooms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rooms ALTER COLUMN id SET DEFAULT nextval('public.rooms_id_seq'::regclass);


--
-- Name: rooms_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rooms_types ALTER COLUMN id SET DEFAULT nextval('public.rooms_types_id_seq'::regclass);


--
-- Name: rqst_transports id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rqst_transports ALTER COLUMN id SET DEFAULT nextval('public.rqst_transports_id_seq'::regclass);


--
-- Name: safe_transfer_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_id_seq'::regclass);


--
-- Name: safe_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: safe_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filter_twos_id_seq'::regclass);


--
-- Name: safe_transfer_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filters_id_seq'::regclass);


--
-- Name: safe_transfers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN id SET DEFAULT nextval('public.safe_transfers_id_seq'::regclass);


--
-- Name: safe_transfers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.safe_transfers_arr_seq'::regclass);


--
-- Name: safes_banks id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN id SET DEFAULT nextval('public.safes_banks_id_seq'::regclass);


--
-- Name: safes_banks Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN "Code" SET DEFAULT nextval('public.safes_banks_arr_seq'::regclass);


--
-- Name: sales id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales ALTER COLUMN id SET DEFAULT nextval('public.sales_id_seq'::regclass);


--
-- Name: sales Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_arr_seq'::regclass);


--
-- Name: sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_id_seq'::regclass);


--
-- Name: sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filters_id_seq'::regclass);


--
-- Name: sales_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_default_data ALTER COLUMN id SET DEFAULT nextval('public.sales_default_data_id_seq'::regclass);


--
-- Name: sales_fifo_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_fifo_qties_id_seq'::regclass);


--
-- Name: sales_gifts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.sales_gifts_id_seq'::regclass);


--
-- Name: sales_gifts Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_gifts_arr_seq'::regclass);


--
-- Name: sales_maint_fifo_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_maint_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_maint_fifo_qties_id_seq'::regclass);


--
-- Name: sales_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN id SET DEFAULT nextval('public.sales_orders_id_seq'::regclass);


--
-- Name: sales_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_orders_arr_seq'::regclass);


--
-- Name: sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.sales_petrols_id_seq'::regclass);


--
-- Name: sales_petrols Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_petrols_arr_seq'::regclass);


--
-- Name: sales_subscribes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.sales_subscribes_id_seq'::regclass);


--
-- Name: sales_subscribes Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_subscribes_arr_seq'::regclass);


--
-- Name: scientific_materials id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.scientific_materials ALTER COLUMN id SET DEFAULT nextval('public.scientific_materials_id_seq'::regclass);


--
-- Name: secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_export_goods_id_seq'::regclass);


--
-- Name: secretariat_export_goods Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_export_goods_arr_seq'::regclass);


--
-- Name: secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_import_goods_id_seq'::regclass);


--
-- Name: secretariat_import_goods Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_import_goods_arr_seq'::regclass);


--
-- Name: secretariat_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_qties ALTER COLUMN id SET DEFAULT nextval('public.secretariat_qties_id_seq'::regclass);


--
-- Name: secretariat_stores id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.secretariat_stores ALTER COLUMN id SET DEFAULT nextval('public.secretariat_stores_id_seq'::regclass);


--
-- Name: select_a_p_i_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.select_a_p_i_s ALTER COLUMN id SET DEFAULT nextval('public.select_a_p_i_s_id_seq'::regclass);


--
-- Name: server_d_b_s id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.server_d_b_s ALTER COLUMN id SET DEFAULT nextval('public.server_d_b_s_id_seq'::regclass);


--
-- Name: settlements id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settlements ALTER COLUMN id SET DEFAULT nextval('public.settlements_id_seq'::regclass);


--
-- Name: settlements Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settlements ALTER COLUMN "Code" SET DEFAULT nextval('public.settlements_arr_seq'::regclass);


--
-- Name: shifts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shifts ALTER COLUMN id SET DEFAULT nextval('public.shifts_id_seq'::regclass);


--
-- Name: shifts Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shifts ALTER COLUMN "Code" SET DEFAULT nextval('public.shifts_arr_seq'::regclass);


--
-- Name: shipment_moves id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_moves ALTER COLUMN id SET DEFAULT nextval('public.shipment_moves_id_seq'::regclass);


--
-- Name: shipment_receipts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_id_seq'::regclass);


--
-- Name: shipment_receipts Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_arr_seq'::regclass);


--
-- Name: shipment_receipts_clients id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_clients_id_seq'::regclass);


--
-- Name: shipment_receipts_clients Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_clients_arr_seq'::regclass);


--
-- Name: shipment_receipts_lists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_lists_id_seq'::regclass);


--
-- Name: shipment_receipts_lists Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_lists_arr_seq'::regclass);


--
-- Name: shipment_requests id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_requests ALTER COLUMN id SET DEFAULT nextval('public.shipment_requests_id_seq'::regclass);


--
-- Name: shipment_requests Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipment_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_requests_arr_seq'::regclass);


--
-- Name: shipments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments ALTER COLUMN id SET DEFAULT nextval('public.shipments_id_seq'::regclass);


--
-- Name: shipments Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.shipments_arr_seq'::regclass);


--
-- Name: shipments_distribution_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments_distribution_goods ALTER COLUMN id SET DEFAULT nextval('public.shipments_distribution_goods_id_seq'::regclass);


--
-- Name: shipments_distribution_workers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments_distribution_workers ALTER COLUMN id SET DEFAULT nextval('public.shipments_distribution_workers_id_seq'::regclass);


--
-- Name: shipments_distributions id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments_distributions ALTER COLUMN id SET DEFAULT nextval('public.shipments_distributions_id_seq'::regclass);


--
-- Name: shipments_distributions Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipments_distributions ALTER COLUMN "Code" SET DEFAULT nextval('public.shipments_distributions_arr_seq'::regclass);


--
-- Name: shipping_companies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_companies ALTER COLUMN id SET DEFAULT nextval('public.shipping_companies_id_seq'::regclass);


--
-- Name: shipping_defaults id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_defaults ALTER COLUMN id SET DEFAULT nextval('public.shipping_defaults_id_seq'::regclass);


--
-- Name: shipping_list_tickets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_list_tickets ALTER COLUMN id SET DEFAULT nextval('public.shipping_list_tickets_id_seq'::regclass);


--
-- Name: shipping_lists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_lists ALTER COLUMN id SET DEFAULT nextval('public.shipping_lists_id_seq'::regclass);


--
-- Name: shipping_orders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN id SET DEFAULT nextval('public.shipping_orders_id_seq'::regclass);


--
-- Name: shipping_orders Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.shipping_orders_arr_seq'::regclass);


--
-- Name: shipping_prices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_prices ALTER COLUMN id SET DEFAULT nextval('public.shipping_prices_id_seq'::regclass);


--
-- Name: shipping_statuses id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_statuses ALTER COLUMN id SET DEFAULT nextval('public.shipping_statuses_id_seq'::regclass);


--
-- Name: shipping_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shipping_types ALTER COLUMN id SET DEFAULT nextval('public.shipping_types_id_seq'::regclass);


--
-- Name: shippment_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shippment_products ALTER COLUMN id SET DEFAULT nextval('public.shippment_products_id_seq'::regclass);


--
-- Name: shortcomings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN id SET DEFAULT nextval('public.shortcomings_id_seq'::regclass);


--
-- Name: shortcomings Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN "Code" SET DEFAULT nextval('public.shortcomings_arr_seq'::regclass);


--
-- Name: show_print_defaults id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.show_print_defaults ALTER COLUMN id SET DEFAULT nextval('public.show_print_defaults_id_seq'::regclass);


--
-- Name: social_media id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.social_media ALTER COLUMN id SET DEFAULT nextval('public.social_media_id_seq'::regclass);


--
-- Name: special_cases id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.special_cases ALTER COLUMN id SET DEFAULT nextval('public.special_cases_id_seq'::regclass);


--
-- Name: spend_profits id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.spend_profits ALTER COLUMN id SET DEFAULT nextval('public.spend_profits_id_seq'::regclass);


--
-- Name: start_periods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN id SET DEFAULT nextval('public.start_periods_id_seq'::regclass);


--
-- Name: start_periods Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN "Code" SET DEFAULT nextval('public.start_periods_arr_seq'::regclass);


--
-- Name: store_count_sales id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.store_count_sales ALTER COLUMN id SET DEFAULT nextval('public.store_count_sales_id_seq'::regclass);


--
-- Name: store_counts id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.store_counts ALTER COLUMN id SET DEFAULT nextval('public.store_counts_id_seq'::regclass);


--
-- Name: store_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.store_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filter_twos_id_seq'::regclass);


--
-- Name: store_transfer_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.store_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filters_id_seq'::regclass);


--
-- Name: stores id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores ALTER COLUMN id SET DEFAULT nextval('public.stores_arr_seq'::regclass);


--
-- Name: stores Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores ALTER COLUMN "Code" SET DEFAULT nextval('public.stores_id_seq'::regclass);


--
-- Name: stores_default_data id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_default_data ALTER COLUMN id SET DEFAULT nextval('public.stores_default_data_id_seq'::regclass);


--
-- Name: stores_moves id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_moves ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_id_seq'::regclass);


--
-- Name: stores_moves_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_id_seq'::regclass);


--
-- Name: stores_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: stores_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filter_twos_id_seq'::regclass);


--
-- Name: stores_moves_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filters_id_seq'::regclass);


--
-- Name: stores_transfer_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_id_seq'::regclass);


--
-- Name: stores_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: stors_transfers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.stors_transfers_id_seq'::regclass);


--
-- Name: stors_transfers Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.stors_transfers_arr_seq'::regclass);


--
-- Name: student_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_groups ALTER COLUMN id SET DEFAULT nextval('public.student_groups_id_seq'::regclass);


--
-- Name: student_importants id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_importants ALTER COLUMN id SET DEFAULT nextval('public.student_importants_id_seq'::regclass);


--
-- Name: students id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.students ALTER COLUMN id SET DEFAULT nextval('public.students_id_seq'::regclass);


--
-- Name: sub_images id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_images ALTER COLUMN id SET DEFAULT nextval('public.sub_images_id_seq'::regclass);


--
-- Name: sub_virables id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_virables ALTER COLUMN id SET DEFAULT nextval('public.sub_virables_id_seq'::regclass);


--
-- Name: subscribe_types id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.subscribe_types ALTER COLUMN id SET DEFAULT nextval('public.subscribe_types_id_seq'::regclass);


--
-- Name: sup_pages_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sup_pages_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_part_two_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sup_pages_part_two_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_part_two_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_wish_comp_e_com_designs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sup_pages_wish_comp_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_wish_comp_e_com_designs_id_seq'::regclass);


--
-- Name: taxes id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.taxes ALTER COLUMN id SET DEFAULT nextval('public.taxes_id_seq'::regclass);


--
-- Name: taxes Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.taxes ALTER COLUMN "Code" SET DEFAULT nextval('public.taxes_arr_seq'::regclass);


--
-- Name: teachers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.teachers ALTER COLUMN id SET DEFAULT nextval('public.teachers_id_seq'::regclass);


--
-- Name: teachers_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.teachers_groups ALTER COLUMN id SET DEFAULT nextval('public.teachers_groups_id_seq'::regclass);


--
-- Name: teachers_subjects id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.teachers_subjects ALTER COLUMN id SET DEFAULT nextval('public.teachers_subjects_id_seq'::regclass);


--
-- Name: terms id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.terms ALTER COLUMN id SET DEFAULT nextval('public.terms_id_seq'::regclass);


--
-- Name: terms_maintainces id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.terms_maintainces ALTER COLUMN id SET DEFAULT nextval('public.terms_maintainces_id_seq'::regclass);


--
-- Name: testclients id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.testclients ALTER COLUMN id SET DEFAULT nextval('public.testclients_id_seq'::regclass);


--
-- Name: ticekt_issues id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ticekt_issues ALTER COLUMN id SET DEFAULT nextval('public.ticekt_issues_id_seq'::regclass);


--
-- Name: ticket_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ticket_products ALTER COLUMN id SET DEFAULT nextval('public.ticket_products_id_seq'::regclass);


--
-- Name: tickets id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tickets ALTER COLUMN id SET DEFAULT nextval('public.tickets_id_seq'::regclass);


--
-- Name: tickets Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.tickets_arr_seq'::regclass);


--
-- Name: translation_tourism_companies id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.translation_tourism_companies ALTER COLUMN id SET DEFAULT nextval('public.translation_tourism_companies_id_seq'::regclass);


--
-- Name: translte_modules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.translte_modules ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_id_seq'::regclass);


--
-- Name: translte_modules_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.translte_modules_details ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_details_id_seq'::regclass);


--
-- Name: transltors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transltors ALTER COLUMN id SET DEFAULT nextval('public.transltors_id_seq'::regclass);


--
-- Name: transport_contractors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transport_contractors ALTER COLUMN id SET DEFAULT nextval('public.transport_contractors_id_seq'::regclass);


--
-- Name: transport_prices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transport_prices ALTER COLUMN id SET DEFAULT nextval('public.transport_prices_id_seq'::regclass);


--
-- Name: transport_receivers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transport_receivers ALTER COLUMN id SET DEFAULT nextval('public.transport_receivers_id_seq'::regclass);


--
-- Name: transports id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transports ALTER COLUMN id SET DEFAULT nextval('public.transports_id_seq'::regclass);


--
-- Name: transports Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transports ALTER COLUMN "Code" SET DEFAULT nextval('public.transports_arr_seq'::regclass);


--
-- Name: unloading_shipments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.unloading_shipments ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_id_seq'::regclass);


--
-- Name: unloading_shipments Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.unloading_shipments ALTER COLUMN "Code" SET DEFAULT nextval('public.unloading_shipments_arr_seq'::regclass);


--
-- Name: unloading_shipments_goods id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.unloading_shipments_goods ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_goods_id_seq'::regclass);


--
-- Name: unloading_shipments_workers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.unloading_shipments_workers ALTER COLUMN id SET DEFAULT nextval('public.unloading_shipments_workers_id_seq'::regclass);


--
-- Name: update_values_investors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.update_values_investors ALTER COLUMN id SET DEFAULT nextval('public.update_values_investors_id_seq'::regclass);


--
-- Name: upload_accountings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.upload_accountings ALTER COLUMN id SET DEFAULT nextval('public.upload_accountings_id_seq'::regclass);


--
-- Name: users_moves id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users_moves ALTER COLUMN id SET DEFAULT nextval('public.users_moves_id_seq'::regclass);


--
-- Name: v_a_prices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.v_a_prices ALTER COLUMN id SET DEFAULT nextval('public.v_a_prices_id_seq'::regclass);


--
-- Name: v_a_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.v_a_products ALTER COLUMN id SET DEFAULT nextval('public.v_a_products_id_seq'::regclass);


--
-- Name: v_a_qties id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.v_a_qties ALTER COLUMN id SET DEFAULT nextval('public.v_a_qties_id_seq'::regclass);


--
-- Name: vendor_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendor_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: vendor_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendor_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_columns_id_seq'::regclass);


--
-- Name: vendor_filters id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendor_filters ALTER COLUMN id SET DEFAULT nextval('public.vendor_filters_id_seq'::regclass);


--
-- Name: vendor_products id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendor_products ALTER COLUMN id SET DEFAULT nextval('public.vendor_products_id_seq'::regclass);


--
-- Name: vendors id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendors ALTER COLUMN id SET DEFAULT nextval('public.vendors_id_seq'::regclass);


--
-- Name: vendors Code; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendors ALTER COLUMN "Code" SET DEFAULT nextval('public.vendors_arr_seq'::regclass);


--
-- Name: vendors_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendors_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_column_sechdules_id_seq'::regclass);


--
-- Name: vendors_statements_columns id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vendors_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_columns_id_seq'::regclass);


--
-- Name: virables id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.virables ALTER COLUMN id SET DEFAULT nextval('public.virables_id_seq'::regclass);


--
-- Name: vouchers id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.vouchers ALTER COLUMN id SET DEFAULT nextval('public.vouchers_id_seq'::regclass);


--
-- Name: web_sliders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.web_sliders ALTER COLUMN id SET DEFAULT nextval('public.web_sliders_id_seq'::regclass);


--
-- Name: wishlists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.wishlists ALTER COLUMN id SET DEFAULT nextval('public.wishlists_id_seq'::regclass);


--
-- Name: work_departments id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_departments ALTER COLUMN id SET DEFAULT nextval('public.work_departments_id_seq'::regclass);


--
-- Name: workers_sales_petrols id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.workers_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.workers_sales_petrols_id_seq'::regclass);


--
-- Name: zkteco_devices id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.zkteco_devices ALTER COLUMN id SET DEFAULT nextval('public.zkteco_devices_id_seq'::regclass);


--
-- Data for Name: a_v_pro_check_qties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.a_v_pro_check_qties (id, "Product", "AvQty", "Qty", "RequestQty", created_at, updated_at, "OriginalProduct", "NewRequestQty") FROM stdin;
\.


--
-- Data for Name: abouts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.abouts (id, "Image", "Image_2", "Image_3", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	AboutImages/bTiXmoIvZgg7T3RUX9Y1.jpeg	AboutImages/NqfSP0j3p9wn3n5X4N3s.jpeg	AboutImages/DdpthioSZUZlqRR1szE9.jpeg	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	\N	2022-06-04 15:13:12
\.


--
-- Data for Name: abstracts_contractors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.abstracts_contractors (id, "Code", "Date", "Name", "Value", "Statement", "Contractor", "Project", "Edit", "Delete", "Edit_New_Code", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: acccounting_manuals; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.acccounting_manuals (id, "Code", "Name", "Type", "Parent", "Note", "User", created_at, updated_at, "Account_Code", "Pro_Group", "NameEn", "SearchCode") FROM stdin;
824	606	مصروفات البيع و التوزيع	0	20	\N	1	2022-04-13 19:11:41	2022-10-18 22:42:48	75	\N	Selling and Distribution Expenses	\N
826	403	تحصيل دليفري	1	18	\N	11	2022-05-15 16:52:32	2022-10-18 22:42:47	57	\N	Delivery Service Collection	\N
2523	20102	مورد افتراضي	1	37	\N	11	2024-02-09 00:08:40	2024-02-09 00:08:40	\N	\N	Default Vendor	\N
119	205	مجمع الاهلاك	0	16	\N	1	2021-10-02 08:23:41	2024-02-14 23:12:23	41	\N	Asset Depreciation Accumulator	\N
852	607	رسوم بنوك	0	20	\N	11	2022-11-03 07:48:29	2022-11-03 07:48:29	٠	\N	Bank Fees	\N
853	608	مصاريف شركات التقسيط	0	20	\N	11	2022-11-03 07:49:34	2022-11-03 07:49:34	0	\N	Installment Companies Expenses	\N
854	60701	رسوم خدمه	1	852	\N	11	2022-11-03 07:49:52	2022-11-03 07:49:52	0	\N	Service Charges	\N
856	404	إيردات اخري	0	18	\N	11	2022-11-03 07:55:13	2022-11-03 07:55:13	0	\N	Other Revenues	\N
888	1020103	شركات التقسيط	0	23	\N	11	2022-11-03 07:54:02	2022-11-03 07:54:02	0	\N	Installment Companies	\N
2497	6060204	تكلفه مصنعيه	1	55	\N	11	2022-12-21 02:46:32	2022-12-21 02:46:32	0	\N	Manufacturing Cost	\N
2498	6060205	تالف الصيانه	1	55	\N	11	2023-01-16 18:58:53	2023-01-16 18:58:53	0	\N	Maintenance Damaged	\N
2503	6060107	مندوب مبيعات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Commission 	\N
2505	20401	مندوب مبيعات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Merit 	\N
2513	20403	مهندس افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Merit 	\N
2518	60113	نادل افتراضي	1	53	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter	\N
2502	60109	مندوب مبيعات افتراضي	1	53	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales	\N
2504	102040108	مندوب مبيعات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Custody 	\N
2510	60111	مهندس افتراضي	1	53	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng	\N
2511	6060109	مهندس افتراضي  عموله 	1	164	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Commission 	\N
2512	102040110	مهندس افتراضي  عهده 	1	121	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Custody 	\N
2519	6060111	نادل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Commission 	\N
2520	102040112	نادل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Custody 	\N
2521	20405	نادل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Merit 	\N
2496	405	ايراد مصنعية	1	18	\N	11	2022-12-21 02:46:07	2024-02-14 23:15:25	0	\N	Manufacturing Revenue	\N
895	40401	ايردات رسوم الخدمة	1	856	\N	11	2022-11-03 07:55:46	2024-02-14 23:15:43	0	\N	Service Charges Revenues	\N
2527	209	استحقاق مستثمرين	0	16	\N	11	2024-11-05 12:49:22	2024-11-05 12:49:22	\N	\N	Investors' Eligibility	\N
57	6060202	كهرباء	1	55	\N	1	2021-06-16 01:26:56	2022-10-18 22:42:48	85	\N	Electricity	\N
58	6060203	مصروفات ضيافه	1	55	\N	1	2021-06-16 01:41:37	2022-10-18 22:42:48	86	\N	Hosting Expenses	\N
70	10206	وسيط المخازن	0	22	\N	1	2021-07-16 12:00:41	2022-10-18 22:42:47	29	\N	Intermediate Warehouse Account	\N
71	1020601	وسيط المخازن	1	70	\N	1	2021-07-16 12:01:10	2022-10-18 22:42:47	30	\N	Intermediate Warehouse Account	\N
97	603	شركات الشحن	0	20	\N	1	2021-08-08 10:48:13	2022-10-18 22:42:48	70	\N	Freight Companies	\N
112	20202	بدون ضريبة	1	39	\N	1	2021-08-23 00:16:53	2022-10-18 22:42:47	37	\N	Without Taxes	\N
121	1020401	العهد	0	26	\N	1	2021-10-02 08:24:25	2022-10-18 22:42:47	18	\N	Custody	\N
122	10102	الأثاث المكتبي	0	21	\N	1	2021-10-02 08:25:42	2022-10-18 22:42:47	3	\N	Office Furniture	\N
136	303	الارباح و الخسائر	0	17	\N	1	2021-10-09 12:10:07	2022-10-18 22:42:47	47	\N	Profits and Losses	\N
139	30301	الارباح الحالية	0	136	\N	1	2021-10-13 17:36:17	2022-10-18 22:42:47	48	\N	Current Profits	\N
140	30302	الارباح الرأس مالية	0	136	\N	1	2021-10-13 17:36:41	2022-10-18 22:42:47	49	\N	Capital Profits	\N
141	30303	الارباح المرحلة	0	136	\N	1	2021-10-13 17:37:01	2022-10-18 22:42:47	50	\N	Retained Earnings	\N
147	103	اصول اخري	0	15	\N	1	2021-10-14 17:02:03	2022-10-18 22:42:47	31	\N	Other Assets	\N
148	207	خصوم طويلة الاجل	0	16	\N	1	2021-10-14 17:02:50	2022-10-18 22:42:47	42	\N	Long-Term Liabilities	\N
164	60601	عمولات الموظفين	0	824	\N	1	2021-10-28 09:42:04	2022-10-18 22:42:48	76	\N	Employee Commissions	\N
206	402	خصم مكتسب	1	18	\N	1	2022-02-16 22:01:22	2022-10-18 22:42:47	56	\N	Earned Discount	\N
15	1	الأصول	0	0	\N	1	\N	\N	0	\N	Assets	\N
2499	1020503	مخزن الطلبات	1	27	\N	11	2023-08-30 11:11:31	2023-08-30 11:11:31	\N	\N	Requests Store	\N
16	2	الخصوم	0	0	\N	1	2021-06-16 00:29:12	2022-10-18 22:42:47	32	\N	Liabilities	\N
17	3	حقوق الملكية	0	0	\N	1	2021-06-16 00:29:32	2022-10-18 22:42:47	43	\N	Shareholders equity	\N
18	4	الايرادات	0	0	\N	1	2021-06-16 00:29:56	2022-10-18 22:42:47	51	\N	Revenues	\N
19	5	تكلفة المبيعات	0	0	\N	1	2021-06-16 00:30:22	2022-10-18 22:42:48	58	\N	Cost Of Goods Sold (COGS)	\N
20	6	المصروفات	0	0	\N	1	2021-06-16 00:30:50	2022-10-18 22:42:48	60	\N	Expenses	\N
21	101	أصول ثابتة	0	15	\N	1	2021-06-16 00:31:46	2022-10-18 22:42:47	2	\N	Fixed Assets	\N
22	102	أصول متداولة	0	15	\N	1	2021-06-16 00:32:28	2022-10-18 22:42:47	4	\N	Current Assets	\N
23	10201	النقدية وما في حكمها	0	22	\N	1	2021-06-16 00:34:14	2022-10-18 22:42:47	5	\N	All kinds of cash	\N
24	10202	العملاء	0	22	\N	1	2021-06-16 00:34:53	2022-10-18 22:42:47	11	\N	Customers	\N
25	10203	أوراق قبض	0	22	\N	1	2021-06-16 00:36:12	2022-10-18 22:42:47	15	\N	Notes Receivable	\N
26	10204	مدينين	0	22	\N	1	2021-06-16 00:37:03	2022-10-18 22:42:47	17	\N	Debtors	\N
27	10205	المخزون	0	22	\N	1	2021-06-16 00:37:44	2022-10-18 22:42:47	26	\N	Inventory	\N
28	1020101	الخزينة	0	23	\N	1	2021-06-16 00:38:47	2022-10-18 22:42:47	6	\N	Cash Fund	\N
29	1020102	نقدية بالبنك	0	23	\N	1	2021-06-16 00:40:04	2022-10-18 22:42:47	8	\N	Bank cash	\N
35	1020301	أوراق قبض	1	25	\N	1	2021-06-16 00:46:08	2022-10-18 22:42:47	16	\N	Notes Receivable	\N
37	201	الموردين	0	16	\N	1	2021-06-16 01:12:06	2022-10-18 22:42:47	33	\N	Suppliers	\N
39	202	الضرائب	0	16	\N	1	2021-06-16 01:13:20	2022-10-18 22:42:47	35	\N	Taxes	\N
2525	20501	مجمع اهلاك الاثاث المكتبي	1	119	\N	11	2024-02-14 23:13:11	2024-02-14 23:13:11	0	\N	مجمع اهلاك الاثاث المكتبي	\N
41	203	أوراق دفع	0	16	\N	1	2021-06-16 01:14:38	2022-10-18 22:42:47	38	\N	Notes Payable	\N
42	20301	أوراق دفع	1	41	\N	1	2021-06-16 01:15:16	2022-10-18 22:42:47	39	\N	Notes Payable	\N
43	204	دائنين	0	16	\N	1	2021-06-16 01:15:57	2022-10-18 22:42:47	40	\N	Creditors	\N
44	301	رأس المال	0	17	\N	1	2021-06-16 01:16:55	2022-10-18 22:42:47	44	\N	Capital	\N
45	30101	رأس المال	1	44	\N	1	2021-06-16 01:17:44	2022-10-18 22:42:47	45	\N	Capital	\N
46	302	جاري الشركاء	0	17	\N	1	2021-06-16 01:18:34	2022-10-18 22:42:47	46	\N	Partners Current Account	\N
47	401	إيرادات المبيعات	0	18	\N	1	2021-06-16 01:19:32	2022-10-18 22:42:47	52	\N	Sales Revenue	\N
48	40101	المبيعات	1	47	\N	1	2021-06-16 01:20:15	2022-10-18 22:42:47	53	\N	Sales	\N
49	40102	مردودات المبيعات	1	47	\N	1	2021-06-16 01:20:45	2022-10-18 22:42:47	54	\N	Sales Return	\N
50	60401	خصم مسموح به	1	851	\N	1	2021-06-16 01:21:13	2022-10-18 22:42:48	72	\N	Allowed Discount	\N
51	40104	خدمة صالة	1	47	\N	1	2021-06-16 01:21:57	2022-10-18 22:42:47	55	\N	Lounge Service	\N
52	501	تكلفه بضاعه مباعه	1	19	\N	1	2021-06-16 01:23:13	2022-10-18 22:42:48	59	\N	Cost Of Goods Sold (COGS)	\N
53	601	المرتبات والأجور	0	20	\N	1	2021-06-16 01:24:33	2022-10-18 22:42:48	61	\N	Salaries and Wages	\N
54	60101	الموظفين	0	53	\N	1	2021-06-16 01:25:07	2022-10-18 22:42:48	62	\N	Employees	\N
55	60602	مصروفات التشغيل	0	824	\N	1	2021-06-16 01:25:48	2022-10-18 22:42:48	83	\N	Operating Expenses	\N
56	6060201	الإيجار	1	55	\N	1	2021-06-16 01:26:20	2022-10-18 22:42:48	84	\N	Rentals	\N
188	60501	مصروف اهلاك الاثاث المكتبي	1	120	\N	1	2021-12-29 11:16:16	2024-02-14 23:14:32	74	\N	New Depreciation	\N
2526	208	المستثمرين	0	16	\N	11	2024-11-05 12:49:01	2024-11-05 12:49:01	\N	\N	Investors	\N
2506	60110	مندوب مشتريات افتراضي	1	53	\N	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	Default Purchaser	\N
2522	1020205	عميل افتراضي	1	24	\N	11	2024-02-09 00:08:02	2024-02-09 00:08:02	\N	\N	Default Customer	\N
825	602	مصروفات عمومية وادارية	0	20	\N	1	2022-04-13 19:12:04	2022-10-18 22:42:48	69	\N	General and Administrative Expenses	\N
30	102010101	الخزينة الرئيسية	1	28	\N	1	2021-06-16 00:41:19	2024-02-09 00:18:47	7	\N	Main Safe	\N
830	1020402	حساب معايره	1	26	\N	11	2022-05-21 01:12:14	2022-10-18 22:42:47	25	\N	Calibrated Account	\N
2508	102040109	مندوب مشتريات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Custody 	\N
851	604	خصم مسموح به	0	20	\N	1	\N	2022-10-18 22:42:48	71	\N	Allowed Discount	\N
2500	1020504	المخزن الرئيسي	1	27	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store	\N
2501	1020204	المخزن الرئيسي   عميل مخزن 	1	24	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store    Store Client 	\N
2507	6060108	مندوب مشتريات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Commission 	\N
2509	20402	مندوب مشتريات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Merit 	\N
2514	60112	مندوب توصيل افتراضي	1	53	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery	\N
2515	6060110	مندوب توصيل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Commission 	\N
2516	102040111	مندوب توصيل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Custody 	\N
2517	20404	مندوب توصيل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Merit 	\N
32	102010201	البنك الاهلي	1	29	\N	1	2021-06-16 00:42:58	2024-02-09 00:20:06	9	\N	SNB	\N
2524	60301	زاجل	1	97	\N	11	2024-02-09 00:41:56	2024-02-09 00:41:56	\N	\N	Zagel	\N
40	20201	القيمة المضافة	1	39	\N	1	2021-06-16 01:13:49	2024-02-14 23:10:57	36	\N	VAT	\N
120	605	مصروفات الاهلاك	0	20	\N	1	2021-10-02 08:23:55	2024-02-14 23:13:50	73	\N	Depreciation	\N
2528	304	مصروفات ارباح مستثمرين	0	17	\N	11	2024-11-05 12:49:39	2024-11-13 08:56:22	0	\N	Investors' Dividend Expenses	\N
2529	609	مصاريف مشاريع	0	20	\N	11	2025-02-19 14:49:54	2025-02-19 14:49:54	\N	\N	مصاريف مشاريع	\N
2530	210	استحقاق المقاولين	0	16	\N	11	2025-03-09 13:19:33	2025-03-09 13:19:33	\N	\N	استحقاق المقاولين	\N
2531	610	تطبيقات التوصيل	0	20	\N	11	2025-04-25 13:48:29	2025-04-25 13:48:29	\N	\N	Delivery App	\N
2532	60603	مصاريف السيارات	0	824	\N	11	2025-08-21 06:50:32	2025-08-21 06:50:32	\N	\N	مصاريف السيارات	\N
2533	211	استحقاق سيارات الشحن	0	16	\N	11	2025-08-22 18:27:51	2025-08-22 18:27:51	\N	\N	استحقاق سيارات الشحن	\N
2534	6060206	مصاريف الشحنة	1	55	\N	11	2025-08-22 18:48:23	2025-08-22 18:48:23	\N	\N	مصاريف الشحنة	\N
2535	611	مقاولين النقل	0	20	\N	11	2025-12-19 16:52:08	2025-12-19 16:52:08	\N	\N	Transport Contractors	\N
\.


--
-- Data for Name: accounts_default_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.accounts_default_data (id, "Draw", "Coin", created_at, updated_at, "Sure_Recipts", "Show_Group", "Account_Balance", "Salary", "Commission", "Coin_Show", "Cost_Show", "Draw_Show", "Collect_Show", "Sales_Bill_Show", "Hide_Edit_Delete", "Order_Number", "Tax_Show", "Cost_Center_Show", "Emp_Vouchers_Accounts") FROM stdin;
2	1	1	2021-08-13 16:44:14	2024-09-27 13:08:03	0	0	0	2	2	0	0	0	0	0	\N	\N	\N	\N	\N
\.


--
-- Data for Name: activites; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.activites (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
8	تجاري	Commercial	2022-04-13 02:50:04	2024-02-09 00:52:30
\.


--
-- Data for Name: add_translates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.add_translates (id, "Code", "Date", "Client", "Client_Type", "From_Lang", "To_Lang", "Company", "Num_Translted_Word", "ID_Name", "ID_Profession", "ID_Martial_Status", "Passport_Name", "Passport_Profession", "Passport_Martial_Status", "Extracted", "Extracted_Birthplace", "Extracted_Issuer", "CommercialRegistration", "Commercial_Name", "Commercial_Type", "Commercial_Start_Date", "Commercial_Number", "Commercial_Capital", "Commercial_Issuer", "Commercial_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: additional_products; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.additional_products (id, "Additional_Product", "Product", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: addressses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.addressses (id, "Address_Name", "Street", "Special_Mark", "Buliding", "Floor", "Flat", "Details", "Location", "Governrate", "City", "Place", "Customer", created_at, updated_at, "Lat", "Lng") FROM stdin;
\.


--
-- Data for Name: admins; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.admins (id, email, name, password, image, phone, hidden, emp, ship, vend, status, remember_token, created_at, updated_at, cli, lat, long, account, safe, store, type, roles_name, code, token, price_sale, discount, price_1, price_2, price_3, pos_pay, executor, cost_price, price_level, guest, pos_stores, pos_hold, cost_price_purch, cost_price_sales, manu_order_precent, pos_product, "Cash", "Later", "Check", "Installment", "Cash_Visa", "Cash_Collection", "Delivery", "InstallmentCompanies", "Date", ticket_price, ticket_discount, "nameEn", package, job_order_price, "Visa_Network", bill_discount, pos_safes, expire, expire_type, attend_date, bank, "Apps") FROM stdin;
45	GuestO@test.com	Guest	$2y$10$0DrRyqpJGzxh8sY5lqK8g.u4XXo9VNUUx24bqWiGuFCGidiEF6EvO	AdminsImages/FCad1Zo5eARHkj6f1DwJ.png	23123	1	0	0	0	0	\N	2021-12-14 17:23:09	2024-12-04 22:09:46	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	1	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	1	1	0	\N	0	0	\N	0	\N	\N	\N
46	GuestTw@test.com	Guest T	$2y$10$PvmLA3AHV4DfzXMI2Y3HP.Is4Ulyd0NZU9dasKtR.J4kOOgYxO7EK	AdminsImages/ql9kcuPqE6pjB743YQBg.png	12313	1	0	0	0	0	\N	2021-12-14 17:24:12	2024-12-04 22:09:57	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	2	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	2	1	0	\N	0	0	\N	0	\N	\N	\N
47	GuestTh@test.com	GuestTh	$2y$10$AhaiV.Ao3D236mryP91C4uF.2C/7Ri33vHNN1nn6dF9M1/YCM8vn2	AdminsImages/C1WJh3cJRQs8sOwJarNc.png	31123	1	0	0	0	0	\N	2021-12-14 17:24:51	2024-12-04 22:10:07	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	3	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	3	1	0	\N	0	0	\N	0	\N	\N	\N
11	Klar@test.com	Admin	$2y$10$QnqbBX6.vzR3f.jtAVDl9.grQaOWASw8IxcoJcma4GX0nFaJ3GJga	AdminsImages/zUmg7MdzbQVBLGEt0WE7.png	01062201060	1	0	0	0	0	\N	2021-08-08 10:29:23	2025-12-20 18:38:56	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	10	0	\N	0	0	\N	0	\N	\N	\N
1	admin@rabih.com	Admin	$2y$10$Du3oWudJWDmcAAOj0NvRR.7skrwMZvaOm2WiChLu68irl.aH5eRZu	AdminsImages/PDk0eltFIlYtSRmI0XwM.png	01062201060	1	0	0	0	0	\N	\N	2025-12-20 18:39:05	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	10	0	\N	0	0	\N	0	\N	\N	\N
59	support@rabih.com	Support	$2y$10$KsfE6rtZQAyfCeLnkhHjtOULZ8gAwLi8b23eGoWKLDl3ZKX8KUQzG	\N	\N	1	0	0	0	0	\N	2025-05-12 09:11:50	2025-12-20 18:39:17	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Support	10	0	\N	0	0	\N	0	\N	\N	\N
\.


--
-- Data for Name: all_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.all_groups (id, "Group", created_at, updated_at, "Name") FROM stdin;
\.


--
-- Data for Name: allowences_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.allowences_emps (id, "AmountAllow", "Allow", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: apps_change_prices; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.apps_change_prices (id, "App", "Product", "Price_One", "Price_Two", "Price_Three", created_at, updated_at, "Barcode") FROM stdin;
\.


--
-- Data for Name: articles; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.articles (id, "Image", "Sub_Image", "Date", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	ArticlesImages/Tc4BdtjP1euOSuW9OmoC.jpeg	ArticlesImages/8pWQWSpnZFPjdliv8uuk.jpeg	May 02, 2017	It's all about how you wear	It's all about how you wear	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	2022-06-04 15:34:21	2022-06-04 15:34:21
2	ArticlesImages/hFg38z7lhXhdL5p3YGS4.jpeg	ArticlesImages/0JIkTM2ovwsZJsVLPTag.jpeg	May 02, 2017	IT'S ALL ABOUT HOW YOU WEAR	IT'S ALL ABOUT HOW YOU WEAR	qweqweqwe	qweqeqweqwe	2022-06-06 20:02:53	2022-06-06 20:02:53
\.


--
-- Data for Name: assembly_products; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assembly_products (id, "Qty", "Price", "Total", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Product", p_id, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: assets; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assets (id, "Code", "Name", "Asset_Type", "Depreciation_Method", "Purchases_Date", "Operation_Date", "Cost", "Previous_Depreciation", "Asset_Net", "Annual_Depreciation_Ratio", "Annual_Depreciation", "Life_Span", "Image", "Note", "Depreciation_Expenses", "Depreciation_Complex", "Main_Account", "Account", "User", created_at, updated_at, "Draw", "Coin", "Cost_Center", "Branch", "Sort_Asset", "Vendor", "Safe", "Ehlak", "Payment_Method", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "NameEn", "Asset_Type_En", "Depreciation_Method_En", arr, "Delete", "Sale", "Amount", "Client", "CurrentAssetPrice", "Last_Depreciation_Month") FROM stdin;
\.


--
-- Data for Name: assets_expenses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assets_expenses (id, "Code", "Date", "Name", "Draw", "Amount", "Asset", "Safe", "Coin", "Cost_Center", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: attend_departure_import; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attend_departure_import (id, "In_Time", "Out_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
1	7:30	16:30	01-01-2024	45292	\N	3	33	\N	\N
2	8:30	17:30	01-01-2024	45292	\N	3	34	\N	\N
\.


--
-- Data for Name: attendance_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendance_emps (id, "In_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: attendances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendances (id, "Code", "Date", "Month", "Note", "User", created_at, updated_at, "Status", arr) FROM stdin;
\.


--
-- Data for Name: attendence_policy_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.attendence_policy_emps (id, "Emp", created_at, updated_at, "From", "To", "Discount") FROM stdin;
\.


--
-- Data for Name: barcode_products; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.barcode_products (id, "Name", "Code", "Qty", "Price", "Product", "V1", "V2", "Unit", created_at, updated_at, "Group") FROM stdin;
\.


--
-- Data for Name: barcode_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.barcode_settings (id, "Code", "Name", "Type", "Direction", "Width", "Height", "Padding_L", "Padding_R", "Padding_T", "Padding_B", "Margin_L", "Margin_R", "Margin_T", "Margin_B", "Barcode_Width", "Barcode_Height", "Font_Size", "Line_Height", created_at, updated_at, "Height_Logo", "Width_Logo", "NameEn", arr) FROM stdin;
6	2	الطباعة الافتراضية	2	1	3.8	2.5	.5	.5	.5	.5	.5	.5	.5	.5	3	0.5	6	4	2022-03-09 09:57:35	2024-02-09 00:42:34	0	0	Default Print	\N
\.


--
-- Data for Name: barcode_shows; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.barcode_shows (id, "Company_Name", "Product_Name", "Product_Price", "Unit", "Coin", "Group", created_at, updated_at, "Code", "Logo") FROM stdin;
1	1	\N	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
2	1	1	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
3	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
4	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	1	\N
\.


--
-- Data for Name: befroe_footers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.befroe_footers (id, "Image", "Arabic_Title", "Arabic_Desc", "English_Title", "English_Desc", created_at, updated_at) FROM stdin;
2	<i class="icon anm anm-credit-card-front-r"></i>	SECURE PAYMENTS	All payment are Secured and trusted.	SECURE PAYMENTS	All payment are Secured and trusted.	\N	2022-06-04 19:54:42
3	<i class="icon anm anm-comments-l"></i>	ONLINE SUPPORT	We support online 24/7 on day	ONLINE SUPPORT	We support online 24/7 on day	\N	2022-06-04 19:55:04
4	<i class="icon anm anm-dollar-sign-r"></i>	MONEY GUARANTEE	30 days money back guarantee	MONEY GUARANTEE	30 days money back guarantee	\N	2022-06-04 19:55:16
5	<i class="icon anm anm-truck-l"></i>	FREE SHIPPING & RETURN	Free shipping on all US orders	FREE SHIPPING & RETURN	Free shipping on all US orders	\N	2022-06-04 19:55:29
\.


--
-- Data for Name: beneftis_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.beneftis_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_sales_petrols; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.bones_sales_petrols (id, "Bone_Amount", "Bone", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.bones_types (id, "Name", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: borrowas; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.borrowas (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Safe", "Emp", "Coin", "Cost_Center", "User", arr, created_at, updated_at, "Delete") FROM stdin;
\.


--
-- Data for Name: branches; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.branches (id, "Arabic_Name", "English_Name", created_at, updated_at, "Letter", "Code", "Location", "Budget", "Lat", "Lang") FROM stdin;
3	الفرع الرئيسي	main Branch	2022-10-18 22:34:33	2024-02-09 00:17:43	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: brands; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.brands (id, "Name", "Note", created_at, updated_at, "Image", "Sales_Show", "Store_Show", "NameEn", "Sales_Precet") FROM stdin;
17	الماركة الافتراضية	\N	2022-06-06 19:15:43	2024-02-09 00:27:02	BrandsImages/5hcSrdUnrIK1AmXf3s61.png	1	3	Default Brand	0
\.


--
-- Data for Name: campaigns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.campaigns (id, "Arabic_Name", "English_Name", "Platform", created_at, updated_at) FROM stdin;
7	حملة 2024	حملة 2024	8	2022-04-13 02:50:33	2024-02-09 00:51:37
\.


--
-- Data for Name: capital_increases; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.capital_increases (id, "Date", "Month", "Value", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: capitals; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.capitals (id, "Authorized_Capital", "Source_Capital", "Shares_Number", "Nominal_Value_of_Shares", "Actual_Share_Value", "Actual_Capital", created_at, updated_at, "Working_Capital", "New_Shares_Number", "Capital_Increase", "New_Source_Capital", "Total_Investment") FROM stdin;
1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	100000	150000	10	15000	15000	150000	2021-10-13 15:36:23	2021-10-13 15:36:23	\N	\N	\N	\N	\N
\.


--
-- Data for Name: car_shippings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.car_shippings (id, "Name", "Max_Load", "Delegate", "Driver", "Car_Number", "Color", "Lisence_Expire_Date", "GPS_Num", "Car_Type", "Car_Statue", "Insurance", "Ownership", created_at, updated_at, "Cost_Center", "Rent_Amount", "Deal_Type", "Deal_Amount", "Account", "AccountMerit", "Minimum") FROM stdin;
\.


--
-- Data for Name: cars_sales_petrols; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.cars_sales_petrols (id, "Car_Amount", "Car", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: cart_stores; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.cart_stores (id, "Name", "NameEn", "V_Name", "VV_Name", "P_Code", "AvQty", "Qty", "Price", "Image", "Total", "User", created_at, updated_at, "Product") FROM stdin;
\.


--
-- Data for Name: chat_issues; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.chat_issues (id, "Name", "Date", "Time", "Desc", "Image", "Issue", created_at, updated_at, "Type", "Appear") FROM stdin;
30	Admin	2024-02-04	09-37 PM	\N	AdminsImages/H1fQroGeALye9kfwlLOJ.png	9	2024-02-04 21:37:45	2024-02-04 21:37:45	1	\N
31	Admin	2024-02-04	09-41 PM	\N	AdminsImages/ZUWBoib7IOGJVz5bRYO7.png	9	2024-02-04 21:41:18	2024-02-04 21:41:18	1	\N
\.


--
-- Data for Name: checks_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.checks_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
4	مسطر	Underlined	2022-05-24 00:44:58	2024-02-09 00:22:37
\.


--
-- Data for Name: cities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.cities (id, "Arabic_Name", "English_Name", "Gov", created_at, updated_at, "Ship_Price", "Shipping_Company", "SearchCode", "ShippingCode") FROM stdin;
9	الرياض	Riyadh	5	2024-02-09 00:56:49	2024-02-09 00:56:49	1	5	\N	\N
1	مدينة نصر	Nasr City	2	2021-07-25 23:46:59	2024-02-09 00:58:24	1	5	\N	\N
\.


--
-- Data for Name: client_account_statement_column_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_account_statement_column_sechdules (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-16 21:55:01	1	1
\.


--
-- Data for Name: client_account_statement_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_account_statement_columns (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-16 21:43:33	1	1
\.


--
-- Data for Name: client_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", created_at, updated_at, "Client") FROM stdin;
\.


--
-- Data for Name: client_requests; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_requests (id, "Code", "Date", "Note", "Product_Numbers", "Total_Qty", "Client", "File", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: client_sales_petrols; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_sales_petrols (id, "Customer_Amount", "Customer", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: client_statuses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.client_statuses (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
5	عميل مهم	VIP	2022-03-08 01:33:27	2024-02-09 00:51:55
4	محتمل	Perhaps	2022-02-18 01:19:26	2024-02-09 00:52:13
\.


--
-- Data for Name: clients_statements_column_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.clients_statements_column_sechdules (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2022-10-17 13:26:19
\.


--
-- Data for Name: clients_statements_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.clients_statements_columns (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2022-10-17 13:08:16
\.


--
-- Data for Name: coins; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.coins (id, "Arabic_Name", "English_Name", created_at, updated_at, "Draw", "Symbol", "Code", "Image") FROM stdin;
1	جنيه مصري	Egyptian Pound	2021-06-14 15:44:02	2022-06-08 17:39:50	1	EGP	\N	\N
7	دولار	Dollar	2024-02-09 00:21:32	2024-02-09 00:21:32	3.75	$	$	\N
4	ريال سعودي	SAR	2021-06-16 01:47:03	2024-02-09 00:21:54	1	SAR	1	\N
\.


--
-- Data for Name: comments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.comments (id, "Comment", "Date", "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: comments_clients; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.comments_clients (id, "Comment", "Responsible", "Customer", created_at, updated_at, "CommentEn", "Code", "Date", "Rate", "Visit_Cost", "Note", "Time", "Type", lat, lng, "Voice") FROM stdin;
\.


--
-- Data for Name: company_cars; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.company_cars (id, "Name", "Number", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: company_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.company_data (id, "Name", "Phone1", "Phone2", "Address", "Commercial_Record", "Tax_File_Number", "Logo", "Icon", "Print_Text", created_at, updated_at, "Print_Text_Footer", "Seal", "Print_Text_Footer_Sales", "Name_Sales_Bill", "Name_Sales_Order_Bill", "Print_Text_Footer_Quote", "Name_Quote_Bill", "Print_Text_Footer_Secretariat", "Logo_Store", "Phone3", "Phone4", "Icon_Store", "View", "Tax_Registration_Number", "Tax_activity_code", work_nature, "Governrate", "City", "Place", "Nationality", "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Client_ID", "Serial_Client_ID", "Version_Type", "Computer_SN", "Invoice_Type", "Floor", "Room", "Landmark", "Add_Info", "Print_Text_Footer_Manufacturing", "POS_Version", "Path", "DB_Backup", "NameEn", "Print_Text_En", "Print_Text_Footer_En", "Print_Text_Footer_Manufacturing_En", "Print_Text_Footer_Sales_En", "Print_Text_Footer_Quote_En", "Print_Text_Footer_Secretariat_En", "Name_Sales_Bill_En", "Name_Sales_Order_Bill_En", "Name_Quote_Bill_En", "AddressEn", "HomeMainScreen", "PDF", "Email", "Location", "Bill_View", "Font_Type", "Welcome_Arabic_Word_App", "Welcome_English_Word_App", "Domain", "Serial_App", "Attend_Lat", "Attend_Lng", "Attend_Space", "Attend_Time_Before", "Attend_Time_After", "Departure_Time_Before", "Departure_Time_After", "Verfification_Time", "Organaziation_Common_Name", "Organaziation_Name", "Organaziation_Tax_ID", "Organaziation_Address", "Organaziation_Department", "Organaziation_Category", "ZATCA_Production", "OTP_Status", "Use_Zatca", "Backup_Time", "Purchases_Print_View", "Purchases_Order_Print_View", "Sales_Order_Print_View", "Quote_Print_View") FROM stdin;
1	رابح	00201062201060	00201030086000	المملكة العربية السعودية	1234	1234	LogoImages/Ua0ztVdY9JG0mBswtvoL.png	IconImages/vjhq5ivjwe9QqcwBhSQ9.png	تشرفنا بزيارتكم	2021-08-13 16:30:58	2024-12-04 22:05:49	تشرفنا بزيارتكم	LogoImages/DrZ9IR5TvZPjwUv5GUWp.png	تشرفنا بزيارتكم	فاتورة مبيعات	امر بيع	تشرفنا بزيارتكم	عرض سعر	تشرفنا بزيارتكم	LogoImages/tplmBxjlaVcHdPLteBKi.png	\N	\N	LogoImages/7jZGVUuxAhLjBjGal0Jb.png	0	1	1	P	2	1	6	2	1	1	1	1	1	1	1.0	1	Experimental	1	1	1	1	تشرفنا بزيارتكم	1	1	1	RABIH	Welcome	Welcome	Welcome	Welcome	Welcome	Welcome	Sales Invoice	Sales Order	Quotation	Saudi Arabia	1	\N	info@rabiherp.com	<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d452.9142716996173!2d46.6578223!3d24.750415!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2ee30fcda81b0f%3A0xd2fad773e3b6b328!2sRoyal%20Suits!5e0!3m2!1sen!2seg!4v1707426597227!5m2!1sen!2seg" width="400" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>	1	8	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	0	0	\N	\N	\N	\N	\N
\.


--
-- Data for Name: compare_prices_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compare_prices_columns (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:47:57
\.


--
-- Data for Name: compare_prices_columns_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compare_prices_columns_sechdules (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:48:22
\.


--
-- Data for Name: compare_prices_filter_twos; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compare_prices_filter_twos (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compare_prices_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compare_prices_filters (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compares; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compares (id, "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: competitors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.competitors (id, "Facebook", "Twitter", "Instagram", "Name", "Country", "Whatsapp", "Addtional_Link", "Phone", "Pinterest", created_at, updated_at, "NameEn", "Website") FROM stdin;
\.


--
-- Data for Name: consist_maintainces; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.consist_maintainces (id, "Product_Code", "P_Ar_Name", "P_En_Name", "V_Name", "VV_Name", "Original_Qty", "AvQty", "Qty", "Price", "Discount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Exp_Date", "Store", "Product", "V1", "V2", "Unit", "Maintaince", "TDiscount", "Group", "Brand", "Code", "Date", "Note", "Serial_Num", "Total_Price", "Product_Numbers", "Total_Qty", "Total_Discount", "Total_Cost", "Total_Bf_Taxes", "Total_Taxes", "Draw", "Company", "Device_Type", "Device_Case", "Coin", "Cost_Center", "Account", "User", "Status", "Pattern_Image", "Time", "Payment_Method", "Password", "Pay", "Eng_Note", "Reason", "Report_Client", "Work", "StoreMain", "Eng", "Recipient", "Branch", "RefuseReason", "NoteRecived", "Returned", "CustomerGroup", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: consists; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.consists (id, "Code", "Date", "Darw", "Products_Number", "Total_Qty", "Total_Price", "Account", "Store", "Coin", "User", created_at, updated_at, "Time", "Branch", arr, "Delete") FROM stdin;
\.


--
-- Data for Name: contact_u_s; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.contact_u_s (id, "Map", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", "Opening_Hours", "Phone1", "Phone2", "Phone_Header", "Email", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
1	www.google.com/maps/embed?pb	DROP US A LINE	DROP US A LINE	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Mon - Sat : 9am - 11pm	01062201060	0105206971	01062201060	info@klarapps.com	Cairo,Egypt	Cairo,Egypt	\N	2022-06-04 15:27:21
\.


--
-- Data for Name: contract_statuses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.contract_statuses (id, "Arabic_Name", "English_Name", "Color", created_at, updated_at) FROM stdin;
1	Defaukt	Defaukt	#000000	2025-12-20 18:37:26	2025-12-20 18:37:26
\.


--
-- Data for Name: contractors_real_projects; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.contractors_real_projects (id, "Arabic_Name", "English_Name", "Expenses_Account", "Merit_Account", "Project", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: cost_centers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.cost_centers (id, "Arabic_Name", "English_Name", created_at, updated_at, "Parent", "Type") FROM stdin;
4	مركز تكلفة	Cost Center	2022-02-18 01:22:58	2024-02-09 00:22:59	0	0
\.


--
-- Data for Name: counters_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.counters_types (id, "Name", "Current_Read", "Store", "Product", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: countris; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.countris (id, "Arabic_Name", "English_Name", "Flag", created_at, updated_at, "Safe", "Coin", "Store", "Code", "SearchCode") FROM stdin;
2	مصر	Egypt	CountriesImages/0YNgesTQQDPJblD7725Y.png	2022-06-04 19:37:49	2024-02-09 00:53:35	30	1	21	\N	\N
3	السعوديه	Saudi Arabia	CountriesImages/pgME9vgrOAqViEVToi4i.png	2022-06-04 19:39:05	2024-02-09 00:53:46	32	4	21	\N	\N
\.


--
-- Data for Name: coupon_codes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.coupon_codes (id, "Code", "Amount", "Status", "Num", "Used", "Expire", created_at, updated_at) FROM stdin;
1	224466	100	0	3	2	2022-06-30	2022-06-04 15:19:31	2022-06-10 02:33:22
\.


--
-- Data for Name: courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses (id, "Code", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", "Category", "Lec_Num", "Hours", "Subject", created_at, updated_at, "Note") FROM stdin;
1	1	Course 1	Course 1	Course 1	Course 1	1	8	100	1	2024-01-21 00:37:23	2024-01-21 00:38:01	\N
\.


--
-- Data for Name: courses_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses_categories (id, "Image", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	CoursesCategoryImages/5CCMF4VEBCKWsSvv9ej3.png	فئة ١	فئة ١	فئة ١	فئة ١	2024-01-19 10:58:18	2024-01-19 10:58:18
\.


--
-- Data for Name: courses_halls; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses_halls (id, "Arabic_Name", "English_Name", "Chairs_Num", "Wiifii", "Air_Condition", "Place", "Number", created_at, updated_at) FROM stdin;
1	قاعة ١	قاعة ١	\N	1	1	\N	1	2024-01-19 11:02:53	2024-01-19 11:02:53
\.


--
-- Data for Name: courses_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
1	خاص	خاص	2024-01-19 11:00:19	2024-01-19 11:00:19
2	VIP	VIP	2024-01-19 11:00:30	2024-01-19 11:00:30
3	مجموعة	مجموعة	2024-01-19 11:00:42	2024-01-19 11:00:42
\.


--
-- Data for Name: crm_default_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.crm_default_data (id, "Price_Level", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Platforms", created_at, updated_at, "Client_Delegate", "Nationality", "ClientGroup") FROM stdin;
3	1	2	1	38	8	7	5	8	2022-04-13 02:52:58	2024-02-09 00:55:56	0	2	3
\.


--
-- Data for Name: custom_prints; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.custom_prints (id, "Sales_Print_Type", "Sales_Bill_Code", "Sales_Date", "Sales_Coin", "Sales_Draw", "Sales_Payment_Method", "Sales_Status", "Sales_Executor", "Sales_Refernce_Number", "Sales_Safe", "Sales_Client", "Sales_Delegate", "Sales_Store", "Sales_User", "Sales_Cost_Center", "Sales_Notes", "Sales_Pro_Code", "Sales_Pro_Name", "Sales_Pro_Unit", "Sales_Pro_Qty", "Sales_Pro_Price", "Sales_Pro_Discount", "Sales_Pro_Total_Bf_Tax", "Sales_Pro_Total_Tax", "Sales_Pro_Total", "Sales_Pro_Store", "Sales_Pro_Desc", "Sales_Pro_Exp_Date", "Sales_Pro_Weight", "Sales_Pro_Patch_Number", "Sales_Product_Numbers", "Sales_Total_Qty", "Sales_Total_Discount", "Sales_Total_Bf_Taxes", "Sales_Total_Taxes", "Sales_Total_Price", "Sales_Paid", "Sales_Residual", "Sales_Taknet", "Sales_Credit", "Sales_Barcode", "Sales_Text", "Sales_Seal", "Purch_Print_Type", "Purch_Bill_Code", "Purch_Date", "Purch_Vendor_Bill_Date", "Purch_Coin", "Purch_Draw", "Purch_Payment_Method", "Purch_Status", "Purch_Refernce_Number", "Purch_Safe", "Purch_Vendor", "Purch_Delegate", "Purch_Store", "Purch_User", "Purch_Cost_Center", "Purch_Notes", "Purch_Pro_Code", "Purch_Pro_Name", "Purch_Pro_Unit", "Purch_Pro_Qty", "Purch_Pro_Price", "Purch_Pro_Discount", "Purch_Pro_Total_Bf_Tax", "Purch_Pro_Total_Tax", "Purch_Pro_Total", "Purch_Pro_Store", "Purch_Pro_Exp_Date", "Purch_Product_Numbers", "Purch_Total_Qty", "Purch_Total_Discount", "Purch_Total_Bf_Taxes", "Purch_Total_Taxes", "Purch_Total_Price", "Purch_Paid", "Purch_Residual", "Purch_Taknet", "Purch_Credit", "Purch_Barcode", "Purch_Text", "Purch_Seal", created_at, updated_at, "Sales_Client_Phone", "Sales_Resdiual", "Sales_Total_Return", "Sales_Client_Address", "Sales_Pro_Total_Net", "Purch_Pro_Total_Net") FROM stdin;
1	2	1	1	0	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	1	1	0	0	0	1	0	0	0	0	0	0	0	0	0	1	1	0	0	0	0	1	1	0	2	1	1	0	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	1	1	0	0	0	1	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	2024-04-14 16:57:48	2024-09-27 13:09:04	0	0	0	0	0	0
\.


--
-- Data for Name: customer_comments_products; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customer_comments_products (id, "Product", "Comment", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customer_follow_ups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customer_follow_ups (id, "Code", "Date", "Client", "Subject", "Rate", "Emp", "Visit_Cost", "Note", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customers (id, "Code", "Date", "Name", "Price_Level", "Phone", email, password, "ID_Number", "Address", "Qualifications", "Birthdate", "Social_Status", "Passport_Number", "Company_Name", "Commercial_Registration_No", "Tax_Card_No", "Bank_Account", "Image", "Next_Time", "Executions_Status", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Account", "User", created_at, updated_at, "Platform", "Contract_Start", "Contract_End", code, country, "Tax_Registration_Number", "Tax_activity_code", work_nature, "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Floor", "Room", "Landmark", "Add_Info", "Phone2", "Phone3", "Phone4", "Warranty", "Group", "Place", "Nationality", "Product", token, "NameEn", arr, "SearchCode", "Credit_Limit", "Respon_Person", "Respon_Person_Phone", "Operating_Date", "Activation_Serial", "Activation_Code", "Repayment_Period", "SecurityInquiry", "ReasonSecurityInquiry", "FieldInquiry", "ResonFieldInquiry", "Lat", "Lang", "Guarantor") FROM stdin;
1	1	2024-02-09	عميل افتراضي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2522	11	2024-02-09 00:08:02	2024-02-09 00:08:02	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	Default Customer	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: customers_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customers_files (id, "File", "Customer", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customers_groups (id, "Arabic_Name", "English_Name", created_at, updated_at, "Discount") FROM stdin;
3	مجموعة عامة	General Group	\N	\N	0
\.


--
-- Data for Name: customers_rate_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customers_rate_types (id, "Arabic_Name", "English_Name", "Color", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers_tickets; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.customers_tickets (id, "Code", "Problem", "Status", "Bill_Number", "Responsible", "Customer", "User", created_at, updated_at, "ProblemEn", arr, "TicketIssues", "Date") FROM stdin;
\.


--
-- Data for Name: deducations_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.deducations_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: deductions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.deductions (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: default_data_show_hides; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.default_data_show_hides (id, "Status", "Shipping_Company", "Vendor_Date", "Expire_Date", "Total_BF_Taxes", "Total_Taxes", "Coin", "Draw", "Delegate_Sale", "Delegate_Purchase", "Note", "Refrence_Number", created_at, updated_at, "Cost_Center", "Branch", "Serial_Num", "Pass", "Pattern_Image", "Barcode_Print", "Unit_Print", "Total_BF_Print", "Discount_Print", "Tax_Print", "A5", "A4", "CM8", "Group_Brand", "Patch_Number", "Manufacturing_Model_Shortcomings", "Search_Typical", "Validity_Product", "Executor_Sale", "Totuch_Screen", "Tax_POS", "TotalDiscountPrint", "TotalTaxPrint", "ProductsNumber", "TotalQtyPrint", "Credit", "Barcode", "Taknet", "Address", "Phone1", "Phone2", "Phone3", "Phone4", "Text", "Seal", "Code_Report", "Unit", "Refrence_Number_Print", "Icon_Payment_Recipt", "SearchCode", "TaxOnTotal", "TotalBfTax", "AvQty", "Disc", "Tax", "Store", "TaxBill", "Change_Way_Stores_Transfer", "Note_POS", "Open_Drawer", client_delivery, "POS_RecivedDate", "POS_Barcode", "POS_Qty", "Show_File_InsurancePaper", "Show_File_Checks", "Show_File_Purchases", "Show_File_Sales", "Show_File_PaymentVoucher", "Show_File_ReciptVoucher", "Show_File_TransferStores", "Thickness_Print", "Height_Print", "Thickness", "Height", "Items_Guide_Store_Show", "Sales_Pro_Desc", "Show_Barcode", "Show_Net", "Show_Unit", "Show_Total", "ChassisNumber", "MotorNumber", "Shipping_Price", "OpenInputTransferSales") FROM stdin;
1	0	0	0	0	0	0	0	0	1	1	0	0	2021-12-07 14:08:32	2024-09-27 13:08:55	0	0	0	0	0	0	1	0	1	0	0	1	1	1	0	1	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	0	\N	\N	\N	0
\.


--
-- Data for Name: delivery_apps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.delivery_apps (id, "Arabic_Name", "English_Name", "Type", "Account", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: depaarture_policy_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.depaarture_policy_emps (id, "Emp", created_at, updated_at, "From", "To", "Discount") FROM stdin;
\.


--
-- Data for Name: departure_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.departure_emps (id, "In_Time", "Out_Time", "Hours_Number", "Date", "Month", "Note", "Departure", "Emp", created_at, updated_at, "Disc_Late", "Disc_Early") FROM stdin;
\.


--
-- Data for Name: departures; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.departures (id, "Code", "Date", "Month", "Note", "Attend", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: desvice_cases; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.desvice_cases (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
3	جديد	New	2022-02-18 01:21:48	2024-02-09 01:04:51
\.


--
-- Data for Name: device_descrips; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_descrips (id, "Arabic_Name", "English_Name", "Sort", created_at, updated_at) FROM stdin;
8	جديد	New	0	2022-04-13 02:50:50	2022-04-13 02:50:50
9	مستعمل	Used	1	2022-06-20 21:54:53	2022-06-20 21:54:53
\.


--
-- Data for Name: devices_typesies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.devices_typesies (id, "Arabic_Name", "English_Name", "Company", created_at, updated_at) FROM stdin;
6	Oppo	Oppo	14	2022-04-13 02:50:40	2022-04-13 02:50:40
\.


--
-- Data for Name: disclaimers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.disclaimers (id, "Date", "File", "Emp", "Note", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: discounts_emps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.discounts_emps (id, "AmountDiscount", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: domains; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.domains (id, domain, tenant_id, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_covenants; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_covenants (id, "Emp", "Date", "Name", "Price", "Reason", "Life_Expectancy", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_excs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_excs (id, "Name", "Account", "Emp_Type", "Salary", "Phone", "Job", "Department", "Store1", "Store2", "Store3", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installment_details; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_installment_details (id, "Date", "Value", "Status", "Emp", "Install", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_installments (id, "Amount", "Years_Number", "First_Date", "Install", "Install_Numbers", "Status", "Emp", "Loan", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_mails; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_mails (id, "Message", "Emp", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_movements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_movements (id, "Date", "Time", "Emp", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_p_o_s_stores; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_p_o_s_stores (id, "Emp", created_at, updated_at, "Store") FROM stdin;
19	38	2024-02-08 23:54:43	2024-02-08 23:54:43	21
20	39	2024-02-08 23:55:02	2024-02-08 23:55:02	21
21	40	2024-02-08 23:56:24	2024-02-08 23:56:24	21
22	41	2024-02-08 23:57:46	2024-02-08 23:57:46	21
23	42	2024-02-08 23:58:21	2024-02-08 23:58:21	21
\.


--
-- Data for Name: emp_payment_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_payment_accounts (id, "Emp", "Account", "Account_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_ratios; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_ratios (id, "Salary", "Type", "Emp", created_at, updated_at, "Typee", "From", "To", "Rate") FROM stdin;
\.


--
-- Data for Name: emp_recipt_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_recipt_accounts (id, "Emp", "Account", "Account_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_safes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emp_safes (id, "Safe", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: empassies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.empassies (id, "Arabic_Name", "English_Name", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: empassy_reserve_dates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.empassy_reserve_dates (id, "Code", "Date", "Client", "Purpose", "Empassy", "Booking_Date", "Cost", "Pay", "Residual", "Safe", "Draw", "Coin", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: employesses; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.employesses (id, "Code", "Name", "Emp_Type", "Salary", "Attendence", "Departure", "Hours_Numbers", "Days_Numbers", "Day_Price", "Precentage_of_Sales", "Precentage_of_Profits", "Image", "Bank_Account", "Qualifications", "Address", "Social_Status", "ID_Number", "Contract_Start", "Contract_End", "Phone", "Phone2", "Email", "Password", "Job", "Department", "Account", "Account_Emp", "User", created_at, updated_at, "Note", "Precentage_of_Execution", "Covenant", "Commission", "Price_Level", "Bill_Num", "NumbersOfBill", "EmpSort", "CV", "ID_Image", "Criminal_status", "Contract", health_certificate, "Search_Card", "Recruitment_certificate", employee_profile, duration_criminal_investigation, "Birthdate", "Attitude_recruiting", "Job_Number", date_resignation, "Living", "Branch", "Level", "Religion", "Insurance_salary", "Insurance_companies", "Previous_experience", "Nationality", "MonthlyTarget", "QuarterTarget", "SemiTarget", "YearlyTarget", "IDExpireDate", "LicensExpireDate", "PassportExpireDate", "Merit", "Pro_Group", "NameEn", arr, "SearchCode", "Active", "Delete", "Attendence2", "Departure2", "ShippingCollectionType", "ShippingCollectionValue", "Other_Shift") FROM stdin;
38	5	مندوب مبيعات افتراضي	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	6	53	2502	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	2504	2503	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2505	\N	Default Sales	\N	\N	1	0	\N	\N	\N	\N	\N
39	6	مندوب مشتريات افتراضي	Buyer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2506	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	2508	2507	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2509	\N	Default Purchaser	\N	\N	1	0	\N	\N	\N	\N	\N
40	7	مهندس افتراضي	Engineer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	26	53	2510	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	2512	2511	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2513	\N	Default Eng	\N	\N	1	0	\N	\N	\N	\N	\N
41	8	مندوب توصيل افتراضي	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2514	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	2516	2515	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2517	\N	Default Delivery	\N	\N	1	0	\N	\N	\N	\N	\N
42	9	نادل افتراضي	Waiter	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2518	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	2520	2519	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2521	\N	Default Waiter	\N	\N	1	0	\N	\N	\N	\N	\N
\.


--
-- Data for Name: employment_levels; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.employment_levels (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emps_producation_points; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emps_producation_points (id, "Month", "Point", "Emp", created_at, updated_at, "Date") FROM stdin;
\.


--
-- Data for Name: emps_producation_quantities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.emps_producation_quantities (id, "FromQ", "ToQ", "ValueQ", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: entitlements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.entitlements (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: events; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.events (id, "Start_Date", "End_Date", "Event_Ar_Name", "Event_En_Name", "Type", "Type_ID", "Type_Code", "Emp", "Client", "Product", "Customer", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: examinations_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.examinations_types (id, "Name", "Allow_From", "Allow_To", "Unit", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: exchange_commissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.exchange_commissions (id, "Code", "Date", "Month", "Note", "Return_Maintaince", "Draw", "Amount", "Commision", "Pre_Sales", "Pre_Execu", "Safe", "Coin", "Cost_Center", "Emp", "User", arr, created_at, updated_at, "Total_Exchange_Commision", "Collection", "Delete", "Ship") FROM stdin;
\.


--
-- Data for Name: execute_job_order_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.execute_job_order_models (id, "Model", "Qty", "Total_Cost", "Outcome", "Execute", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: execute_job_order_workmanships; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.execute_job_order_workmanships (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "Price", "Discount", "TDiscount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Store", "Product", "Unit", "Execute", created_at, updated_at, "Total_Net") FROM stdin;
\.


--
-- Data for Name: execute_job_orders; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.execute_job_orders (id, "Code", "Date", "Note", "Client", "Executor", "Delegate", "RecivedDate", "Recipient", "Order", created_at, updated_at, "Transfer", "Edit", "Delete", "Edit_New_Code", "Current_Credit", "Model", "Status") FROM stdin;
\.


--
-- Data for Name: executing_receiving_secretariats; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.executing_receiving_secretariats (id, "Code", "Date", "Qty", "Total", "Model", "User", "Time", "Branch", "StoreIn", "StoreOut", "Client", arr, created_at, updated_at, "Total_Workmanship_Price") FROM stdin;
\.


--
-- Data for Name: executing_receivings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.executing_receivings (id, "Code", "Date", "Qty", "Total", "Model", "User", created_at, updated_at, "Branch", "Time", "StoreIn", "StoreOut", "Sort", "Vendor", "Cost_Workmentship", "Total_Workmentship", arr) FROM stdin;
\.


--
-- Data for Name: executor_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.executor_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: expenses_list_column_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.expenses_list_column_sechdules (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2022-10-17 22:05:11
\.


--
-- Data for Name: expenses_list_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.expenses_list_columns (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	\N	2022-10-17 21:37:09
\.


--
-- Data for Name: expenses_type_projects; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.expenses_type_projects (id, "Arabic_Name", "English_Name", "Project", "Account", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: expire_date_qties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.expire_date_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "Group", "Brand", "Branch", created_at, updated_at, "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: export_checks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.export_checks (id, "Code", "Date", "Draw", "Note", "Check_Num", "Due_Date", "Amount", "Status", "Reason", "Check_Type", "Coin", "Cost_Center", "Account", "Bank", "Pay_Account", "Bene_Account", "User", created_at, updated_at, "File", arr, "Image", "Signture_Name", "Bank_Branch", "Edit", "Edit_New_Code", "Delete", "BankSafe_Account", "Transfer") FROM stdin;
\.


--
-- Data for Name: f_a_q_s; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.f_a_q_s (id, "Arabic_Question", "English_Question", "Arabic_Answer", "English_Answer", created_at, updated_at) FROM stdin;
1	What is Lorem Ipsum?	What is Lorem Ipsum?	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	2022-06-04 19:39:45	2022-06-04 19:39:45
2	Why do we use it?	Why do we use it?	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	2022-06-04 19:40:14	2022-06-04 19:40:14
\.


--
-- Data for Name: failed_jobs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.failed_jobs (id, uuid, connection, queue, payload, exception, failed_at) FROM stdin;
\.


--
-- Data for Name: faults_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.faults_types (id, "Arabic_Name", "English_Name", "Note", "Amount", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: fifo_qties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.fifo_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Cost_Price", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "SearchCode1", "SearchCode2", "Group", "Brand", "Branch", "Purchases_Date", created_at, updated_at, "Original_Qty", "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: firewall_ips; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.firewall_ips (id, ip, log_id, blocked, created_at, updated_at, deleted_at) FROM stdin;
\.


--
-- Data for Name: firewall_logs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.firewall_logs (id, ip, level, middleware, user_id, url, referrer, request, created_at, updated_at, deleted_at) FROM stdin;
1	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=Wh8VUBPPpctrwoHMRWnx1DvypLmxzN1uDIRM22YQ&valid_from=eyJpdiI6IktLMytNc0RnSDlXNC9GdDFndC81ckE9PSIsInZhbHVlIjoielhlUVNtU21YMGtzNE9NSEkrK3Q4dz09IiwibWFjIjoiMTJiMjY5MzIwMGM3YTY4YTEyOGMwOTIyOTM4ZDZkYWVhNzQwOGFmMzZiNDYxODNjMWZmODdlNGNjMWU0M2IzNSJ9&email=Admin@test.com&password=******	2022-02-08 09:54:21	2022-02-08 09:54:21	\N
2	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6IklFWlVxK2pZRCsyUHhZNHd2ZzBWUFE9PSIsInZhbHVlIjoibFQvN1dsb0lreTJFT2FSNHoydkRiQT09IiwibWFjIjoiMjNhODUxNWM3ZjUyZGRlZTAwNWUxMmQyZThjZTJjOWMyOGFhNDdiM2Q5MWI0MjI3ZWY4YTcwZThlODVjZDVlMSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:13	2022-06-01 15:04:13	\N
3	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6InJVNDBPK3J5QWRlcXJCdnc4cTNKc2c9PSIsInZhbHVlIjoiVnhMQUpZanRXdldjYVd1RTZVcDJCUT09IiwibWFjIjoiMTIyMjZmNWY3OTczZjVmMmUwNmViYjBiMTNiYzU0OTQzN2IwNzUyYjkxZGJhMTM1ZTE4OWYwNjJhNDI1MDAxYSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:26	2022-06-01 15:04:26	\N
4	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkgyZEx5V3BDUzBsa1pLcExjUjlhb0E9PSIsInZhbHVlIjoiTmF5UFh0a0lOYXhuS2ErY1h5Mzc4Zz09IiwibWFjIjoiMGQxYzYxMGEyMjlhMWM5NDJhODM2NmJmMDY2NTQ4ZDZjOTk4OTNhYzQyNmU1M2E1NTc0YmJmY2IxNzg3ZGViYyIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:25	2022-06-04 15:25:25	\N
5	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:53	2022-06-04 15:25:53	\N
6	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:34	2022-06-04 15:26:34	\N
7	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:55	2022-06-04 15:26:55	\N
8	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/AddArticles	http://localhost:8888/laravel/ERP/public/Articles	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IlB6U25kQnRaUkZOTHJhOTJwNDIreXc9PSIsInZhbHVlIjoiS2QzTVJwd3paNXNiMUx3UDFGbDAzQT09IiwibWFjIjoiMWQ5NmQ3MThhODI1NDk0NzEyNWZiNTQxYmFlMzQyMTdmMGE0MThmODhkZDE1YmFjNjBkMTUyODBkNGI0YThiOCIsInRhZyI6IiJ9&Date=May 02, 2017&Arabic_Title=IT'S ALL ABOUT HOW YOU WEAR&English_Title=IT'S ALL ABOUT HOW YOU WEAR&Arabic_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>&English_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>	2022-06-06 20:02:03	2022-06-06 20:02:03	\N
9	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6Ik9LaHdHOXluQzBFMlNSWG5qcThncUE9PSIsInZhbHVlIjoicGxudDdPNi9sbThzNTEwYi9URGZCZz09IiwibWFjIjoiMTRhOWMzNmM4MjFjOGZjOTQ4MjU0MzZmNjc4MzliNGFkMzcyZmVhNzk4OTQ0MTgyNzcyZjYxMzhiODhlMGI2MCIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:15	2022-06-06 22:22:15	\N
10	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IkIvaUJZMFBOUStFbXNJZHY5Mmd4dmc9PSIsInZhbHVlIjoickNFdURkM0ZneVlyV3MyZEtSUDc1dz09IiwibWFjIjoiMmFiNjc4OTIyZjM3NjY2M2U3M2U5ZjI3M2RhNWQ3NTQ3ZDZiOTE2ZDU4YzlkNWVmMDM2ZGJhODM1YWExMTQ5MyIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:27	2022-06-06 22:22:27	\N
11	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:05:21	2022-06-07 12:05:21	\N
12	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:18:58	2022-06-07 12:18:58	\N
13	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:27:07	2022-06-07 12:27:07	\N
14	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:03	2022-06-07 12:43:03	\N
15	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:39	2022-06-07 12:43:39	\N
16	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:49:43	2022-06-07 12:49:43	\N
17	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=ddC4WRKEWrRNwcu08j4Dm5icj0Hzo7eNz6RcmiAj&valid_from=eyJpdiI6IndSYXlaeVQ4b2wxQ2lZQ202a1dNUlE9PSIsInZhbHVlIjoiK0JkenBWTzJ1NUdVTHE3RndWYmtSUT09IiwibWFjIjoiZTJkNTc3OTU4ZWI1NTVlOTIzOGRlZjZjNDY0ZTY2ZjFjYzNmMDkzYWM2YjBmOWZhZTUwYzFhM2Y2N2I2MDZhYiIsInRhZyI6IiJ9&email=Alaa@test.com&password=******	2025-04-25 13:47:40	2025-04-25 13:47:40	\N
\.


--
-- Data for Name: follow_lists; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.follow_lists (id, "Emp", "Day", "Time", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: general_dailies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.general_dailies (id, "Code", "Date", "Type", "Debitor", "Creditor", "Statement", "Draw", "Debitor_Coin", "Creditor_Coin", "Account", "Coin", "Cost_Center", created_at, updated_at, userr, "Code_Type", "Branch", "TypeEn", arr) FROM stdin;
\.


--
-- Data for Name: goods_product_projects; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.goods_product_projects (id, "Goods", "Product", "P_Code", "P_Ar_Name", "P_En_Name", "Unit", "Qty", "AvQty", "Price", "Total", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: goods_projects; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.goods_projects (id, "Code", "Date", "Store", "Cost_Center", "Responsible", "Safe", "Coin", "Draw", "Note", "Project", "Product_Numbers", "Total_Qty", "Total_Price", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: governrates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.governrates (id, "Arabic_Name", "English_Name", created_at, updated_at, "Country", "SearchCode") FROM stdin;
5	الرياض	Riyadh	2022-06-06 16:39:56	2022-06-06 16:39:56	3	\N
2	القاهرة	Cairo	2021-07-25 23:45:24	2024-02-09 00:57:40	2	\N
\.


--
-- Data for Name: group_filters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.group_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: holidays; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.holidays (id, "Code", "Date", "Month", "Num_of_Days", "Start_Date", "Discount", "Status", "Note", "Emp", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: holidays_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.holidays_types (id, "Arabic_Name", "English_Name", "Days", created_at, updated_at, "From_Date", "To_Date") FROM stdin;
\.


--
-- Data for Name: home_e_com_designs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.home_e_com_designs (id, "Slider_BG_Type", "Slider_BG_Image", "Slider_BG_Color", "Slider_Button_BG_Color", "Slider_Button_Txt_Color", "Slider_Button_Hover_BG_Color", "Slider_Button_Hover_Txt_Color", "Slider_Title_Txt_Color", "Slider_Desc_Txt_Color", "Ads_Top_Img_First_BG_Color", "Ads_Top_Img_First_Before_BG_Color", "Ads_Top_Img_Second_BG_Color", "Ads_Top_Img_Second_Before_BG_Color", "Ads_Top_Img_Button_BG_Color", "Ads_Top_Img_Button_Txt_Color", "Ads_Top_Img_Button_Hover_BG_Color", "Ads_Top_Img_Button_Hover_Txt_Color", "Support_Icons_BG_Color", "Support_Icons_Txt_Color", "Support_Icons_Color", "Ads_Bootom_Imgs_BG_Color", "Ads_Bootom_Imgs_Middle_BG_Color", "Ads_Bootom_Imgs_Button_BG_Color", "Ads_Bootom_Imgs_Button_Txt_Color", "Ads_Bootom_Imgs_Button_Hover_BG_Color", "Ads_Bootom_Imgs_Button_Hover_Txt_Color", "Partners_BG_Color", created_at, updated_at) FROM stdin;
1	1	\N	#a1bfdd	#113366	#ffffff	#ffffff	#113366	#000000	#000000	#dae4f1	#6e8eb8	#f0e9ea	#ddd0d3	#8a0e00	#ffffff	#113366	#ffffff	#ffffff	#000000	#cd1818	#e3efed	#d3e5e2	#113366	#ffffff	#ffffff	#113366	#cccccc	2023-09-01 14:07:13	2023-09-01 23:19:58
\.


--
-- Data for Name: home_product_e_com_designs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.home_product_e_com_designs (id, "Special_Offer_Title_BG_Color", "Special_Offer_Title_Txt_Color", "Special_Offer_Product_BG_Color", "Special_Offer_Product_Border_Color", "Special_Offer_Product_Txt_Color", "Special_Offer_Product_Price_Color", "Special_Offer_Product_Rate_Color", "Best_Sellers_Title_BG_Color", "Best_Sellers_Title_Txt_Color", "Best_Sellers_Category_Txt_Color", "Best_Sellers_Category_Active_Txt_Color", "Best_Sellers_Product_BG_Color", "Best_Sellers_Product_Group_BG_Color", "Best_Sellers_Product_Group_Txt_Color", "Best_Sellers_Product_Group_Hover_BG_Color", "Best_Sellers_Product_Group_Hover_Txt_Color", "Best_Sellers_Product_Icon_BG_Color", "Best_Sellers_Product_Icon_Txt_Color", "Best_Sellers_Product_Icon_Hover_BG_Color", "Best_Sellers_Product_Icon_Hover_Txt_Color", "Best_Sellers_Product_Txt_Color", "Best_Sellers_Product_Price_Color", "Best_Sellers_Product_Rate_Color", "New_Arrivals_Title_BG_Color", "New_Arrivals_Title_Txt_Color", "New_Arrivals_Product_BG_Color", "New_Arrivals_Product_Group_BG_Color", "New_Arrivals_Product_Group_Txt_Color", "New_Arrivals_Product_Group_Hover_BG_Color", "New_Arrivals_Product_Group_Hover_Txt_Color", "New_Arrivals_Product_Icon_BG_Color", "New_Arrivals_Product_Icon_Txt_Color", "New_Arrivals_Product_Icon_Hover_BG_Color", "New_Arrivals_Product_Icon_Hover_Txt_Color", "New_Arrivals_Product_Txt_Color", "New_Arrivals_Product_Price_Color", "New_Arrivals_Product_Hover_Price_Color", "New_Arrivals_Product_Rate_Color", created_at, updated_at, "Special_Offer_Product_Txt_Hover_Color") FROM stdin;
1	#ffffff	#113366	#ffffff	#000000	#000000	#a30000	#ffb607	#ffffff	#113366	#113366	#a30000	#ffffff	#113366	#ffffff	#ad0000	#ffffff	#ffffff	#113366	#113366	#ffffff	#000000	#000000	#ffb607	#ffffff	#113366	#ffffff	#113366	#ffffff	#b80000	#ffffff	#ffffff	#113366	#113366	#ffffff	#000000	#000000	#a30000	#ffb607	2023-09-01 18:44:18	2023-09-01 23:55:13	#b80000
\.


--
-- Data for Name: import_expenses_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.import_expenses_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: import_new_prods; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.import_new_prods (id, "Name", "Type", "Group", "Brand", "Unit", "Rate", "Barcode", "Price_1", "Price_2", "Price_3", "Def", "Num", created_at, updated_at, "Code_Type", "World_Code", "Weight", "Search_Code") FROM stdin;
\.


--
-- Data for Name: import_new_prods_starts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.import_new_prods_starts (id, "Name", "Type", "Group", "Brand", "Unit", "Rate", "Barcode", "Price_1", "Price_2", "Price_3", "Def", "Num", "Store", "Qty", "CostPrice", "Total", created_at, updated_at, "Code_Type", "World_Code", "Weight", "Search_Code") FROM stdin;
\.


--
-- Data for Name: in_out_logs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.in_out_logs (id, user_id, in_time, out_time, time_calc, date, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: incom_checks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.incom_checks (id, "Code", "Date", "Draw", "Note", "Check_Num", "Due_Date", "Amount", "Status", "Reason", "Check_Type", "Coin", "Cost_Center", "Account", "Bank", "Arrest_Account", "Bene_Account", "User", created_at, updated_at, "File", arr, "Image", "Signture_Name", "Bank_Branch", "Edit", "Edit_New_Code", "Delete", "BankSafe_Account", "Transfer") FROM stdin;
\.


--
-- Data for Name: incom_manufacturing_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.incom_manufacturing_models (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "Cost", "Discount", "Tax", "Total_Bf_Tax", "Total", "Total_Tax", "Depreciation", "Depreciation_Qty", "Store", "Product", "Unit", "Model", created_at, updated_at, "Precent") FROM stdin;
\.


--
-- Data for Name: incom_manufacturing_secretariat_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.incom_manufacturing_secretariat_models (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Precent", "Qty", "Cost", "Discount", "Tax", "Total_Bf_Tax", "Total", "Total_Tax", "Depreciation", "Depreciation_Qty", "Store", "Product", "Unit", "Model", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: install_companies_sales_bills_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.install_companies_sales_bills_columns (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "ShiftCode", "Executor", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", "InstallCompany", "ContractNumber", "PayFees", "ServiceFee", "CompanyPrecent", "Product_Code", "Product_Name", "Unit", "Av_Qty", "Qty", "Price", "Discount", "Total_BF_Tax", "Tax", "Total", "Group", "Brand", "Exp_Date", "Product_Store", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-11-10 09:15:55
\.


--
-- Data for Name: install_companies_sales_bills_columns_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.install_companies_sales_bills_columns_sechdules (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "ShiftCode", "Executor", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", "InstallCompany", "ContractNumber", "PayFees", "ServiceFee", "CompanyPrecent", "Product_Code", "Product_Name", "Unit", "Av_Qty", "Qty", "Price", "Discount", "Total_BF_Tax", "Tax", "Total", "Group", "Brand", "Exp_Date", "Product_Store", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-11-10 09:45:52
\.


--
-- Data for Name: installment_companies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.installment_companies (id, "Arabic_Name", "English_Name", "Logo", created_at, updated_at, "Account", "NakdyaAccount") FROM stdin;
\.


--
-- Data for Name: installment_companies_ratios; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.installment_companies_ratios (id, "From", "To", "Service_Fee", "Company_Precent", "Company", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: installment_dates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.installment_dates (id, "Date", "Value", "Status", "Client", "Install", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: installments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.installments (id, presenter, annual_interest, monthly_installment, "Years_Number", total, "installment_Num", "Date_First_installment", "Residual", "Status", "Client", "Sales", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: insurance_companies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.insurance_companies (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: insurance_papers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.insurance_papers (id, "Code", "Date", "Draw", "Note", "Due_Date", "Amount", "Status", "Coin", "Cost_Center", "Account", "Bank", arr, "User", created_at, updated_at, "From", "To", "File", "FromEn", "ToEn", "Delete") FROM stdin;
\.


--
-- Data for Name: interviews; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.interviews (id, "Code", "Date", "Time", "Status", "Rate", "Note", "Emp", "Client", "Type", "User", arr, created_at, updated_at, "StatusNote") FROM stdin;
\.


--
-- Data for Name: interviews_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.interviews_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
5	المكتب	Office	2022-03-08 01:34:46	2024-02-09 00:49:15
8	تحصيل	Collect	2022-03-08 01:36:36	2024-02-09 00:49:35
3	تليفونيا	Phone	2022-03-08 01:34:24	2024-02-09 00:49:48
7	عرض سعر	Quotation	2022-03-08 01:36:05	2024-02-09 00:50:01
6	لدي العميل	at Customer Place	2022-03-08 01:35:05	2024-02-09 00:50:32
4	واتس اب	Whatsapp	2022-03-08 01:34:32	2024-02-09 00:50:44
\.


--
-- Data for Name: intros; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.intros (id, "Arabic_About", "English_About", "Phone_1", "Phone_2", "Phone_3", "Phone_4", "Arabic_Terms", "English_Terms", created_at, updated_at, "Arabic_Privacy", "English_Privacy") FROM stdin;
1	تعتبر أنظمة تخطيط موارد المؤسسات من الأدوات الحديثة والفعّالة التي تهدف إلى تحسين إدارة العمليات اليومية داخل المؤسسات. يُعد رابح حلاً شاملاً يدمج مختلف الأقسام والوظائف داخل المؤسسة، بدءًا من التخطيط والمشتريات، وصولاً إلى الإنتاج والتوزيع، وحتى إدارة الموارد البشرية والمحاسبة.\r\nمميزات البرنامج:\r\n1.\tتكامل العمليات: يقدم البرنامج تكاملًا فعّالًا لكافة العمليات الداخلية، مما يسهم في تحسين تدفق المعلومات وتفعيل التعاون بين الأقسام المختلفة.\r\n2.\tزيادة الكفاءة: يساعد البرنامج في تحسين كفاءة العمل من خلال أتمتة العمليات المتكررة، مما يقلل من الأخطاء البشرية ويزيد من سرعة استجابة المؤسسة لتغييرات السوق.\r\n3.\tتحسينات في اتخاذ القرارات: يوفر البرنامج تقارير دقيقة ومحدثة، مما يسهم في تمكين القادة من اتخاذ قرارات مستنيرة بناءً على بيانات دقيقة وموثوقة.\r\n4.\tتوفير الوقت والتكاليف: بفضل أتمتة العمليات، يقلل البرنامج من الوقت اللازم لإتمام الأنشطة المختلفة ويقلل من التكاليف الإدارية.\r\n5.\tتعزيز تجربة العميل: يُسهم تكامل العمليات في تحسين تجربة العميل من خلال تحسين جودة الخدمة وتسريع تلبية احتياجاتهم.\r\nباختصار، يعتبر رابح  أداة حيوية لتحسين أداء المؤسسات وتعزيز تنافسيتها في السوق الحديثة.	Enterprise Resource Planning (ERP) systems are considered modern and effective tools aimed at enhancing the management of daily operations within organizations. ERP is a comprehensive solution that integrates various departments and functions within an enterprise, ranging from planning and procurement to production, distribution, human resources management, and accounting.\r\n\r\nFeatures of the program:\r\n\r\nProcess Integration: The program offers effective integration of all internal operations, contributing to the improvement of information flow and collaboration across different departments.\r\n\r\nIncreased Efficiency: The program helps improve work efficiency by automating repetitive processes, reducing human errors, and increasing the organization's responsiveness to market changes.\r\n\r\nDecision-Making Improvements: The program provides accurate and updated reports, empowering leaders to make informed decisions based on precise and reliable data.\r\n\r\nTime and Cost Savings: Through process automation, the program reduces the time required to complete various activities and minimizes administrative costs.\r\n\r\nEnhanced Customer Experience: The integration of processes contributes to improving the customer experience by enhancing service quality and accelerating the fulfillment of their needs.\r\n\r\nIn summary, ERP is a vital tool for improving the performance of organizations and enhancing their competitiveness in the modern market.	00201062201060	00201030086000	\N	\N	استخدام الموقع:\r\n1.1 يُشترط على جميع المستخدمين القراءة والموافقة على شروط وأحكام الاستخدام قبل التفاعل مع الموقع.\r\n1.2 يُمنع استخدام الموقع لأي أغراض غير قانونية أو مسيئة.\r\n\r\nالخصوصية:\r\n2.1 يُلتزم الموقع بحماية خصوصية معلومات المستخدمين وعدم مشاركتها مع أطراف ثالثة دون إذن.\r\n2.2 يُفضل قراءة سياسة الخصوصية لفهم كيفية جمع واستخدام المعلومات الشخصية.\r\n\r\nالمحتوى:\r\n3.1 يُمنع نسخ أو نقل المحتوى من الموقع دون إذن كتابي من الإدارة.\r\n3.2 يُحظر نشر أي محتوى يُعتبر مسيئًا أو ينتهك القوانين السارية.\r\n\r\nالمسؤولية:\r\n4.1 يتحمل المستخدمون المسؤولية الكاملة عن أي تفاعلات أو تبادلات تحدث عبر الموقع.\r\n4.2 يُحظر استخدام الموقع بطرق تعرّض للضرر أو تعطيل الخدمة.\r\n\r\nالتعديلات:\r\n5.1 يحتفظ الموقع بحق تعديل شروط الاستخدام في أي وقت، ويتوجب على المستخدمين مراجعة هذه الشروط بشكل دوري.	Website Usage:\r\n1.1 All users are required to read and agree to the terms and conditions of use before interacting with the website.\r\n1.2 The use of the website for any unlawful or abusive purposes is strictly prohibited.\r\n\r\nPrivacy:\r\n2.1 The website is committed to protecting the privacy of user information and will not share it with third parties without permission.\r\n2.2 It is recommended to read the privacy policy to understand how personal information is collected and used.\r\n\r\nContent:\r\n3.1 Copying or transferring content from the website without written permission from the administration is prohibited.\r\n3.2 Publishing any content deemed abusive or in violation of applicable laws is strictly prohibited.\r\n\r\nResponsibility:\r\n4.1 Users are fully responsible for any interactions or exchanges that occur through the website.\r\n4.2 The use of the website in ways that may cause harm or disrupt the service is prohibited.\r\n\r\nModifications:\r\n5.1 The website reserves the right to modify the terms of use at any time, and users are required to periodically review these terms.	2024-01-17 19:14:10	2024-12-04 22:08:01	\N	\N
\.


--
-- Data for Name: inventories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.inventories (id, "Code", "Date", "Draw", "Total_Dificit", "Total_Excess", "Total_Dificit_Price", "Total_Excess_Price", "Account_Excess", "Account_Dificit", "Store", "Coin", "User", arr, created_at, updated_at, "Note", "Settle", "Edit", "Delete", "Edit_New_Code") FROM stdin;
\.


--
-- Data for Name: investors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.investors (id, "Date", "Name", "Investment_Value", "Safe", "Draw", "Coin", "Profit_Precent", "Investment_Period", "Liquidation_Time", "Status", created_at, updated_at, "End_Date", "Account", "Due_Account", "Expenses_Account") FROM stdin;
\.


--
-- Data for Name: issues; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.issues (id, "Code", "Date", "Time", "Client", "Link", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: items_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.items_groups (id, "Code", "Name", "Type", "Parent", "Note", "Image", created_at, updated_at, "Discount", "Store_Show", "Sales_Show", "NameEn", "Printer", "Arrange", "Sales_Precet") FROM stdin;
33	1	مجموعة عامة	0	0	\N	ItemsGroupsImages/2AcBw7sR23ZoWdqT1RTA.png	2022-04-13 02:47:07	2024-02-09 00:26:06	0	3	1	General Group	\N	1	0
\.


--
-- Data for Name: itineraries; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.itineraries (id, "Emp", "Day", "Time", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: itinerary_visits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.itinerary_visits (id, "Emp", "Date", "Day", "Time", "Status", "Note", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: job_orders; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.job_orders (id, "Code", "Date", "Draw", "Payment_Method", "Status", "Refernce_Number", "Note", "Product_Numbers", "Total_Qty", "Total_Discount", "Total_BF_Taxes", "Total_Taxes", "Total_Price", "Pay", "Safe", "ShipStatus", "Client", "Executor", "Delegate", "Store", "Coin", "Cost_Center", "User", "Later_Due", "Later_Collection", "TaxBill", "TaxCode", "ProfitPrecent", "TaxOnTotal", "TaxOnTotalType", "ProfitTax", "Time", "Branch", "CustomerGroup", "Total_Cost", "DiscountTax", "RecivedDate", "Recipient", "RecivedVoucherCode", "TransferOrder", "ExecuteOrder", created_at, updated_at, "Edit", "Delete", "Edit_New_Code", "Current_Credit", "Execute") FROM stdin;
\.


--
-- Data for Name: job_orders_executors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.job_orders_executors (id, "Product", "Executor", "Order", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: jobs_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.jobs_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
6	فني تركيبات	Technical	2022-03-10 22:37:00	2024-02-08 23:37:15
3	محاسب	Accountant	2022-02-18 01:16:52	2024-02-08 23:38:02
5	مدير الموارد البشرية	HR Manager	2022-03-10 22:36:50	2024-02-08 23:38:20
4	مسئول المبيعات	Head of Sales	2022-03-10 22:36:42	2024-02-08 23:38:40
7	مهندس التركيبات	Technical  Engineer	2022-03-10 22:37:19	2024-02-08 23:38:55
8	مدير	Manager	2024-02-08 23:39:12	2024-02-08 23:39:12
\.


--
-- Data for Name: journalizing_details; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.journalizing_details (id, "Debitor", "Creditor", "Account", "Joun_ID", created_at, updated_at, "Statement") FROM stdin;
\.


--
-- Data for Name: journalizings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.journalizings (id, "Code", "Date", "Draw", "Coin", "Cost_Center", created_at, updated_at, "Total_Debaitor", "Total_Creditor", "Note", "Type", "Code_Type", "Branch", "Status", "TypeEn", arr, "Edit", "Edit_New_Code", "Delete", "Transfer") FROM stdin;
\.


--
-- Data for Name: languages; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.languages (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: loan_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loan_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: loans; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.loans (id, "Code", "Date", "Month", "Amount", "Years_Number", "First_Date", "Install", "Install_Numbers", "Note", "Draw", "Safe", "Coin", "Cost_Center", "Emp", "Type", "User", arr, created_at, updated_at, "Delete") FROM stdin;
\.


--
-- Data for Name: login_sliders; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.login_sliders (id, "Image", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: main_e_com_designs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.main_e_com_designs (id, "Font_Type", "Pagination_BG_Color", "Pagination_Txt_Color", "Pagination_Active_BG_Color", "Pagination_Active_Txt_Color", "Body_BG_Type", "Body_BG_Image", "Body_BG_Color", "Sub_Page_BG_Color", "Breadcumb_BG_Color", "Breadcumb_Txt_Color", "Modal_BG_Color", "Modal_Txt_Color", "Modal_Button_BG_Color", "Modal_Button_Txt_Color", "Table_Header_BG_Color", "Table_Header_Txt_Color", "Table_Body_BG_Color", "Table_Body_Txt_Color", "Table_Button_BG_Color", "Table_Button_Txt_Color", "CopyRights_Txt_Color", "CopyRights_Klar_Txt_Color", "CopyRights_Klar_Hover_Txt_Color", "Preloader_BG_Color", "Preloader_Small_Circle_Color", "Preloader_Large_Circle_Color", "Footer_Title_Color", "Footer_Txt_Color", "Footer_Social_Color", "Footer_Social_Hover_BG_Color", "Footer_Social_Hover_Txt_Color", "Header_Top_BG_Color", "Header_Top_Txt_Color", "Header_Top_Txt_Hover_Color", "Header_Middle_BG_Color", "Header_Middle_Icon_Color", "Header_Middle_Icon_Hover_Color", "Header_SearchBar_BG_Color", "Header_SearchBar_Txt_Color", "Header_SearchBar_Icon_BG_Color", "Header_SearchBar_Icon_Txt_Color", "Header_SearchBar_Icon_Hover_BG_Color", "Header_SearchBar_Icon_Hover_Txt_Color", "Navbar_BG_Color", "Navbar_Txt_Color", "Navbar_Hover_BG_Color", "Navbar_Hover_Txt_Color", "Navbar_Category_BG_Color", "Navbar_Category_Txt_Color", "Navbar_Category_Box_BG_Color", "Navbar_Category_Box_Txt_Color", created_at, updated_at, "Footer_Social_BG_Color", "Footer_Txt_Hover_Color") FROM stdin;
1	3	#113366	#ffffff	#ffffff	#113366	1	LogoImages/f3zzbel3naI4SIJmhLUh.jpg	#ffffff	#ffffff	#dedede	#000000	#ffffff	#000000	#113366	#ffffff	#113366	#ffffff	#ffffff	#000000	#113366	#ffffff	#949494	#000000	#bd0000	#ffffff	#bd0000	#000000	#000000	#000000	#113366	#113366	#ffffff	#113366	#ffffff	#ad0000	#15407f	#ffffff	#b30000	#ffffff	#000000	#113366	#ffffff	#bd0000	#ffffff	#ffffff	#000000	#113366	#ffffff	#113366	#ffffff	#ffffff	#113366	2023-09-01 10:22:07	2023-09-01 22:21:44	#ffffff	#990000
\.


--
-- Data for Name: maintainc_bills; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.maintainc_bills (id, "Code", "Date", "Product_Numbers", "Total_Qty", "Total_Price", "Note", "Serial_Num", "Draw", "Company", "Device_Type", "Device_Case", "Coin", "Cost_Center", "Account", "User", arr, "Recipt", created_at, updated_at, "Store", "Total_Price_Errors", "Totaal", "Safe") FROM stdin;
\.


--
-- Data for Name: maintaince_colors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.maintaince_colors (id, "Refuse", "Reported_Client", "Refused_Client", "Edited", created_at, updated_at) FROM stdin;
3	\N	\N	\N	\N	\N	\N
4	#000000	#000000	#000000	#000000	2022-04-13 02:50:56	2022-04-13 02:50:56
\.


--
-- Data for Name: maintaince_default_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.maintaince_default_data (id, "Company", "Device_Type", "Device_Case", "Coin", "Cost_Center", "Draw", "Client", "Sure", "Eng", "Recipient", "Store", created_at, updated_at) FROM stdin;
4	14	6	3	1	4	1	2522	0	40	38	21	2024-02-08 23:25:20	2024-02-09 00:16:09
\.


--
-- Data for Name: manu_store_counts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manu_store_counts (id, "Store", "Total", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: manufacture_companies; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacture_companies (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
14	الشركة الافتراضية	Default Company	2022-04-13 02:50:26	2024-02-09 01:03:45
\.


--
-- Data for Name: manufacturing_default_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_default_data (id, "Coin", "Draw", "Hall", "Manu_Type", created_at, updated_at, "Executing_Qty") FROM stdin;
1	1	1	4	0	\N	2024-02-09 00:00:36	0
\.


--
-- Data for Name: manufacturing_executions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_executions (id, "Code", "NewCode", "Date", "Manu_Order_Code", "Manu_Order_Date", "Recived_Date", "Manu_Request_Code", "Outcome_Name", "Outcome_Code", "Outcome_Qty", "Except_Qty", "Outcome_Unit", "Outcome_Store", "Patch_Number", "Manu_Order_ID", "Production_Manager", "Quality_Manager", "Model", "Note", "Status", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: manufacturing_halls; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_halls (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
4	صالة افتراضية	Hall Default	2022-04-26 20:37:50	2024-02-09 01:02:09
\.


--
-- Data for Name: manufacturing_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_models (id, "Code", "Date", "Name", "Time", "Draw", "Note", "Product_Numbers", "Total_Discount", "Total_BF_Taxes", "Total_Taxes", "Total_Price", "Hall", "Coin", "Cost_Center", "User", arr, created_at, updated_at, "Type", "NameEn", "Incom_Store", "Outcom_Store", "Workmanship_Price") FROM stdin;
\.


--
-- Data for Name: manufacturing_orders; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_orders (id, "Code", "Date", "Model", "Name_Outcome", "Except_Qty", "Total_Required_Qty", created_at, updated_at, "Status", "For_Client", "Client", "Client_Phone", "Client_Address", "Delegate", arr, "Delegate_Phone", "Recived_Date", "Manufacture_Request_Code", "NewCode", "Recipient") FROM stdin;
\.


--
-- Data for Name: manufacturing_requests; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_requests (id, "Code", "Date", "Recived_Date", "Client_Phone", "Client_Address", "Client", "Delegate", "Delegate_Phone", "Payment_Method", "Later_Due", "Note", "Status", "User", arr, created_at, updated_at, "Product_Numbers", "Total_Qty", "Total_Discount", "Total_BF_Taxes", "Total_Taxes", "Total_Price", "Pay", "Store") FROM stdin;
\.


--
-- Data for Name: manufacturing_secretariat_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.manufacturing_secretariat_models (id, "Code", "Date", "Name", "Time", "Draw", "Note", "Product_Numbers", "Total_Discount", "Total_BF_Taxes", "Total_Taxes", "Total_Price", "Hall", "Coin", "Cost_Center", "User", "Type", created_at, updated_at, "NameEn", arr, "Incom_Store", "Outcom_Store") FROM stdin;
\.


--
-- Data for Name: measuerments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.measuerments (id, "Name", "Note", created_at, updated_at, "Code", "NameEn") FROM stdin;
10	قطعة	\N	2022-04-13 02:46:58	2024-02-09 00:23:56	\N	Piece
11	كيلو جرام	\N	2022-05-22 10:12:03	2024-02-09 00:24:05	\N	KG
12	متر	\N	2024-02-09 00:24:43	2024-02-09 00:24:43	\N	Meter
\.


--
-- Data for Name: migrations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.migrations (id, migration, batch) FROM stdin;
24	2024_08_15_131439_add_new_purch_table	1
25	2024_08_15_131459_add_new_purch_ord_table	1
26	2024_08_15_131508_add_new_short_table	1
27	2024_08_15_131519_add_new_moves_table	1
28	2024_08_15_131526_add_new_pro_pruch_ord_table	1
29	2024_08_15_131541_add_new_pro_pruch_table	1
30	2024_08_21_202625_add_sales	2
31	2024_08_21_202636_add_sales_order	2
32	2024_08_21_202643_add_qoute	2
33	2024_08_21_202650_add_qoute_images	2
34	2024_08_21_202656_add__prosales_order	2
35	2024_08_21_202701_add__pro_quotes	2
36	2024_08_21_202706_add__pro_quotes_images	2
37	2024_09_05_151319_create_customers_rate_types_table	3
38	2024_09_25_151531_create_emp_safes_table	4
39	2024_09_27_072541_create_sales_gifts_table	5
40	2024_09_27_073522_create_product_sales_gifts_table	5
41	2024_10_04_185205_add_privacy_intro_table	6
42	2024_10_04_194307_create_emp_mails_table	7
43	2024_10_23_182646_create_emp_covenants_table	8
44	2024_10_23_191426_create_itineraries_table	9
45	2024_10_24_031019_create_itinerary_visits_table	10
46	2024_11_05_123832_create_investors_table	11
47	2024_11_05_133553_create_update_values_investors_table	12
48	2024_11_05_152520_create_pay_profit_investors_table	13
49	2024_11_14_040231_create_capital_increases_table	14
50	2024_12_13_164649_create_order_pays_table	15
51	2024_12_13_214903_create_follow_lists_table	16
52	2024_12_13_223426_create_my_follow_lists_table	17
53	2025_01_02_133837_create_testclients_table	18
54	2025_01_08_105408_create_cart_stores_table	18
55	2025_02_15_154452_create_project_statuses_table	19
56	2025_02_15_160028_create_contract_statuses_table	19
57	2025_02_15_164907_create_real_sate_projects_table	19
58	2025_02_15_164923_create_real_sate_projects_payments_table	19
59	2025_02_16_194456_create_expenses_type_projects_table	19
60	2025_02_17_184814_create_goods_projects_table	19
61	2025_02_17_184824_create_goods_product_projects_table	19
62	2025_02_18_150802_create_paymentss_real_projects_table	19
63	2025_02_18_150816_create_paymentss_products_real_projects_table	19
64	2025_02_24_220658_change_customer_column_type_in_comments_clients_table	20
65	2025_03_03_184435_create_resturant_carts_table	21
66	2025_03_09_133555_create_contractors_real_projects_table	21
67	2025_03_09_144137_create_abstracts_contractors_table	21
68	2025_04_25_145013_create_delivery_apps_table	22
69	2025_04_26_022832_create_apps_change_prices_table	23
70	2021_08_23_185057_create_zkteco_devices_table	24
71	2021_08_23_185624_create_in_out_logs_table	24
72	2025_07_12_234217_add_app_foreign_key_to_sales_table	24
73	2025_07_12_234904_add__newapp_foreign_key_to_sales_table	24
74	2025_07_16_025200_add__c_c_foreign_key_to_sales_table	25
75	2025_07_19_204007_add_new_data_table	26
76	2025_07_28_083803_create_new_shipping_types_table	27
77	2025_07_28_083900_create_new_shipping_categories_table	27
78	2025_07_28_083919_create_new_shipping_rqst_types_table	27
79	2025_07_29_100516_create_shipping_prices_table	28
80	2025_07_29_112753_create_vendor_products_table	29
81	2025_07_30_121329_create_shipments_table	30
82	2025_07_31_133616_create_shipment_moves_table	31
83	2025_08_06_161110_create_car_shippings_table	32
84	2025_08_07_124318_create_shipments_distributions_table	33
85	2025_08_07_125403_create_shipments_distribution_workers_table	33
86	2025_08_07_125431_create_shipments_distribution_goods_table	33
87	2025_08_09_142548_create_unloading_shipments_table	34
88	2025_08_09_143430_create_unloading_shipments_workers_table	34
89	2025_08_09_143439_create_unloading_shipments_goods_table	34
90	2025_08_09_160512_add_shipments_distribution_id_to_goods_table	35
91	2025_08_11_171244_create_emp_movements_table	36
92	2025_08_11_180837_add_new_company_data_table	37
93	2025_08_12_152658_create_recived_shipments_table	38
94	2025_08_12_152706_create_recived_shipment_goods_table	38
95	2025_08_12_190731_add_new_unloading_shipments_goods_table	39
96	2025_08_12_232658_create_shipment_requests_table	40
97	2025_08_15_135058_add_new_shipping_price_table	41
98	2025_08_19_061119_create_customer_comments_products_table	42
99	2025_08_19_065634_create_ticekt_issues_table	43
100	2025_08_22_223835_add_new_emp_ratios_table	44
101	2025_09_15_154242_add_newshipping_defaults_table	45
102	2025_09_19_020524_create_server_d_b_s_table	46
103	2025_09_23_160519_add_new_sales_default_data_table	47
104	2025_10_01_094211_create_real_state_default_data_table	48
105	2025_10_31_141158_create_client_requests_table	49
106	2025_10_31_141211_create_products_client_requests_table	49
107	2025_11_06_150335_add_newsales_default_data_table	50
108	2025_11_06_151441_add_newquotes_data_table	51
109	2025_11_29_070632_create_import_expenses_types_table	52
110	2025_11_29_113424_create_purchases_expenses_types_table	53
111	2025_11_29_113634_create_purchases_order_expenses_types_table	53
112	2025_12_03_140032_create_shippment_products_table	54
113	2025_12_19_163501_create_transport_contractors_table	55
114	2025_12_19_163518_create_transport_prices_table	55
115	2025_12_19_163533_create_transport_receivers_table	55
116	2025_12_20_034129_create_transports_table	56
117	2025_12_31_150259_create_rqst_transports_table	57
118	2025_12_31_155226_create_emp_recipt_accounts_table	58
119	2025_12_31_155238_create_emp_payment_accounts_table	58
\.


--
-- Data for Name: missions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.missions (id, "Name", "Start_Date", "End_Date", "Duration", "Value", "Status", "File", "Desc", "Task_Owner", "Observer", "Project", "User", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: model_has_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.model_has_permissions (permission_id, model_type, model_id) FROM stdin;
\.


--
-- Data for Name: model_has_roles; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.model_has_roles (role_id, model_type, model_id) FROM stdin;
17	App\\Models\\Admin	14
17	App\\Models\\Admin	35
17	App\\Models\\Admin	36
17	App\\Models\\Admin	37
17	App\\Models\\Admin	38
17	App\\Models\\Admin	39
17	App\\Models\\Admin	40
17	App\\Models\\Admin	41
17	App\\Models\\Admin	42
17	App\\Models\\Admin	43
17	App\\Models\\Admin	44
17	App\\Models\\Admin	48
17	App\\Models\\Admin	49
17	App\\Models\\Admin	54
17	App\\Models\\Admin	55
17	App\\Models\\Admin	56
17	App\\Models\\Admin	57
17	App\\Models\\Admin	58
18	App\\Models\\Admin	45
18	App\\Models\\Admin	46
18	App\\Models\\Admin	47
17	App\\Models\\Admin	11
17	App\\Models\\Admin	1
17	App\\Models\\Admin	59
\.


--
-- Data for Name: module_settings_nums; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.module_settings_nums (id, "Branch_Select", "Branch_Num", "Store_Select", "Store_Num", "Users_Select", "Users_Num", created_at, updated_at, "System", "Expire_Date", "Type", "Price", "Edit_System", "Delete_System", "Fingerprint", "Fingerprint_IP", "Fingerprint_Name", "Fingerprint_Attendence") FROM stdin;
2	1	1	1	2	1	5	2022-04-03 15:27:42	2024-12-04 21:11:27	0	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: modules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.modules (id, "Capital", "Accounts", "Stores", "CRM", "HR", "Manufacturing", "Maintenance", "Secretariat", created_at, updated_at, "Petrol", "ECommerce", "Shipping", "Bill_Electronic", "Hotels", "Resturant", "Traning_Center", "Translate", "Real_States") FROM stdin;
1	0	1	1	1	1	1	1	1	2022-02-16 05:45:05	2025-02-19 14:46:48	1	1	1	1	1	1	1	\N	1
\.


--
-- Data for Name: more_products_halls; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.more_products_halls (id, "Product_Code", "P_Ar_Name", "P_En_Name", "V_Name", "VV_Name", "AvQty", "Qty", "Price", "CostPrice", "Discount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Store", "Product", "Exp_Date", "V1", "V2", "Unit", "SalesOrder", "Pro_Note", "KitchenEnd", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: most_sales_products_column_sechdules; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.most_sales_products_column_sechdules (id, "Product_Code", "Product_Name", "Qty", "Price", "Discount", "Tax", "Total", "Store", "Date", "Unit", "Safe", "Branch", "Group", "Brand", created_at, updated_at) FROM stdin;
1	1	1	1	1	\N	\N	\N	1	\N	1	\N	1	1	1	\N	2022-10-14 19:20:19
\.


--
-- Data for Name: most_sales_products_columns; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.most_sales_products_columns (id, "Product_Code", "Product_Name", "Qty", "Price", "Discount", "Tax", "Total", "Store", "Date", "Unit", "Safe", "Branch", "Group", "Brand", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-14 15:19:14
\.


--
-- Data for Name: msg_rqsts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.msg_rqsts (id, "Name", "Email", "Phone", "Subject", "Msg", created_at, updated_at) FROM stdin;
1	Eslam	sales@yousite.com	123123	sdfsdfsd	fsdfsdfsd	2022-06-06 22:08:06	2022-06-06 22:08:06
\.


--
-- Data for Name: my_follow_lists; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.my_follow_lists (id, "Date", "Emp", "Day", "Status", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: new_shipping_categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.new_shipping_categories (id, "Arabic_Name", "English_Name", "Code", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: new_shipping_rqst_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.new_shipping_rqst_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: new_shipping_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.new_shipping_types (id, "Arabic_Name", "English_Name", "Code", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: notifications; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.notifications (id, "Date", "Status", "Noti_Ar_Name", "Noti_En_Name", "Type", "Type_Code", "Emp", "Client", "Product", created_at, updated_at, "Store", "Safe", "TypeEn") FROM stdin;
\.


--
-- Data for Name: opening_entries; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.opening_entries (id, "Code", "Date", "Draw", "Total_Debaitor", "Total_Creditor", "Note", "Capital", "Coin", "Cost_Center", arr, created_at, updated_at, "SecAccount", "Status", "Edit", "Edit_New_Code", "Delete") FROM stdin;
\.


--
-- Data for Name: opening_entries_details; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.opening_entries_details (id, "Debitor", "Creditor", "Statement", "Account", "OP_ID", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: order_pays; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.order_pays (id, "Code", "Date", "Responsible", "Account", "Amount", "Note", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: outcom_manufacturing_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.outcom_manufacturing_models (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "Store", "Product", "Unit", "Model", created_at, updated_at, "Cost", "SmallQty", "SmallCode") FROM stdin;
\.


--
-- Data for Name: outcome_manufacturing_secretariat_models; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.outcome_manufacturing_secretariat_models (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "SmallQty", "SmallCode", "Store", "Product", "Unit", "Model", "Cost", "Workmanship_Price", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: over_times; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.over_times (id, "Arabic_Name", "English_Name", "Hour", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: pack_prems; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.pack_prems (id, package, premission, created_at, updated_at) FROM stdin;
109	7	14	2023-11-07 00:13:26	2023-11-07 00:13:26
110	7	15	2023-11-07 00:13:26	2023-11-07 00:13:26
111	7	16	2023-11-07 00:13:26	2023-11-07 00:13:26
112	7	17	2023-11-07 00:13:26	2023-11-07 00:13:26
113	7	18	2023-11-07 00:13:26	2023-11-07 00:13:26
114	7	19	2023-11-07 00:13:26	2023-11-07 00:13:26
115	7	21	2023-11-07 00:13:26	2023-11-07 00:13:26
116	7	22	2023-11-07 00:13:26	2023-11-07 00:13:26
117	7	20	2023-11-07 00:13:26	2023-11-07 00:13:26
118	7	23	2023-11-07 00:13:26	2023-11-07 00:13:26
119	7	24	2023-11-07 00:13:26	2023-11-07 00:13:26
120	7	448	2023-11-07 00:13:26	2023-11-07 00:13:26
121	7	441	2023-11-07 00:13:26	2023-11-07 00:13:26
122	7	546	2023-11-07 00:13:26	2023-11-07 00:13:26
123	7	584	2023-11-07 00:13:26	2023-11-07 00:13:26
124	7	614	2023-11-07 00:13:26	2023-11-07 00:13:26
125	7	442	2023-11-07 00:13:26	2023-11-07 00:13:26
126	7	615	2023-11-07 00:13:26	2023-11-07 00:13:26
127	7	224	2023-11-07 00:13:26	2023-11-07 00:13:26
128	7	225	2023-11-07 00:13:26	2023-11-07 00:13:26
129	7	226	2023-11-07 00:13:26	2023-11-07 00:13:26
130	7	227	2023-11-07 00:13:26	2023-11-07 00:13:26
131	7	228	2023-11-07 00:13:26	2023-11-07 00:13:26
132	7	230	2023-11-07 00:13:26	2023-11-07 00:13:26
133	7	232	2023-11-07 00:13:26	2023-11-07 00:13:26
134	7	233	2023-11-07 00:13:26	2023-11-07 00:13:26
135	7	229	2023-11-07 00:13:26	2023-11-07 00:13:26
136	7	359	2023-11-07 00:13:26	2023-11-07 00:13:26
137	7	234	2023-11-07 00:13:26	2023-11-07 00:13:26
138	7	235	2023-11-07 00:13:26	2023-11-07 00:13:26
139	7	236	2023-11-07 00:13:26	2023-11-07 00:13:26
140	7	238	2023-11-07 00:13:26	2023-11-07 00:13:26
141	7	239	2023-11-07 00:13:26	2023-11-07 00:13:26
142	7	240	2023-11-07 00:13:26	2023-11-07 00:13:26
143	7	242	2023-11-07 00:13:26	2023-11-07 00:13:26
144	7	243	2023-11-07 00:13:26	2023-11-07 00:13:26
145	7	244	2023-11-07 00:13:26	2023-11-07 00:13:26
146	7	246	2023-11-07 00:13:26	2023-11-07 00:13:26
147	7	247	2023-11-07 00:13:26	2023-11-07 00:13:26
148	7	248	2023-11-07 00:13:26	2023-11-07 00:13:26
149	7	249	2023-11-07 00:13:26	2023-11-07 00:13:26
150	7	250	2023-11-07 00:13:26	2023-11-07 00:13:26
151	7	251	2023-11-07 00:13:26	2023-11-07 00:13:26
152	7	252	2023-11-07 00:13:26	2023-11-07 00:13:26
153	7	253	2023-11-07 00:13:26	2023-11-07 00:13:26
154	7	254	2023-11-07 00:13:26	2023-11-07 00:13:26
155	7	255	2023-11-07 00:13:26	2023-11-07 00:13:26
156	7	256	2023-11-07 00:13:26	2023-11-07 00:13:26
157	7	257	2023-11-07 00:13:26	2023-11-07 00:13:26
158	7	241	2023-11-07 00:13:26	2023-11-07 00:13:26
159	7	245	2023-11-07 00:13:26	2023-11-07 00:13:26
160	7	258	2023-11-07 00:13:26	2023-11-07 00:13:26
161	7	259	2023-11-07 00:13:26	2023-11-07 00:13:26
162	7	260	2023-11-07 00:13:26	2023-11-07 00:13:26
163	7	261	2023-11-07 00:13:26	2023-11-07 00:13:26
164	7	262	2023-11-07 00:13:26	2023-11-07 00:13:26
165	7	263	2023-11-07 00:13:26	2023-11-07 00:13:26
166	7	264	2023-11-07 00:13:26	2023-11-07 00:13:26
167	7	265	2023-11-07 00:13:26	2023-11-07 00:13:26
168	7	266	2023-11-07 00:13:26	2023-11-07 00:13:26
169	7	267	2023-11-07 00:13:26	2023-11-07 00:13:26
170	7	268	2023-11-07 00:13:26	2023-11-07 00:13:26
171	7	269	2023-11-07 00:13:26	2023-11-07 00:13:26
172	7	270	2023-11-07 00:13:26	2023-11-07 00:13:26
173	7	271	2023-11-07 00:13:26	2023-11-07 00:13:26
174	7	272	2023-11-07 00:13:26	2023-11-07 00:13:26
175	7	273	2023-11-07 00:13:26	2023-11-07 00:13:26
176	7	274	2023-11-07 00:13:26	2023-11-07 00:13:26
177	7	275	2023-11-07 00:13:26	2023-11-07 00:13:26
178	7	276	2023-11-07 00:13:26	2023-11-07 00:13:26
179	7	277	2023-11-07 00:13:26	2023-11-07 00:13:26
180	7	278	2023-11-07 00:13:26	2023-11-07 00:13:26
181	7	279	2023-11-07 00:13:26	2023-11-07 00:13:26
182	7	280	2023-11-07 00:13:26	2023-11-07 00:13:26
183	7	281	2023-11-07 00:13:26	2023-11-07 00:13:26
184	7	282	2023-11-07 00:13:26	2023-11-07 00:13:26
185	7	283	2023-11-07 00:13:26	2023-11-07 00:13:26
186	7	284	2023-11-07 00:13:26	2023-11-07 00:13:26
187	7	285	2023-11-07 00:13:26	2023-11-07 00:13:26
188	7	286	2023-11-07 00:13:26	2023-11-07 00:13:26
189	7	287	2023-11-07 00:13:26	2023-11-07 00:13:26
190	7	288	2023-11-07 00:13:26	2023-11-07 00:13:26
191	7	289	2023-11-07 00:13:26	2023-11-07 00:13:26
192	7	294	2023-11-07 00:13:26	2023-11-07 00:13:26
193	7	295	2023-11-07 00:13:26	2023-11-07 00:13:26
194	7	296	2023-11-07 00:13:26	2023-11-07 00:13:26
195	7	297	2023-11-07 00:13:26	2023-11-07 00:13:26
196	7	500	2023-11-07 00:13:26	2023-11-07 00:13:26
197	7	501	2023-11-07 00:13:26	2023-11-07 00:13:26
198	7	502	2023-11-07 00:13:26	2023-11-07 00:13:26
199	7	509	2023-11-07 00:13:26	2023-11-07 00:13:26
200	7	510	2023-11-07 00:13:26	2023-11-07 00:13:26
201	7	511	2023-11-07 00:13:26	2023-11-07 00:13:26
202	7	512	2023-11-07 00:13:26	2023-11-07 00:13:26
203	7	567	2023-11-07 00:13:26	2023-11-07 00:13:26
204	7	594	2023-11-07 00:13:26	2023-11-07 00:13:26
205	7	231	2023-11-07 00:13:26	2023-11-07 00:13:26
206	7	360	2023-11-07 00:13:26	2023-11-07 00:13:26
207	7	237	2023-11-07 00:13:26	2023-11-07 00:13:26
208	7	298	2023-11-07 00:13:26	2023-11-07 00:13:26
209	7	299	2023-11-07 00:13:26	2023-11-07 00:13:26
210	7	300	2023-11-07 00:13:26	2023-11-07 00:13:26
211	7	310	2023-11-07 00:13:26	2023-11-07 00:13:26
212	7	311	2023-11-07 00:13:26	2023-11-07 00:13:26
213	7	312	2023-11-07 00:13:26	2023-11-07 00:13:26
214	7	313	2023-11-07 00:13:26	2023-11-07 00:13:26
215	7	314	2023-11-07 00:13:26	2023-11-07 00:13:26
216	7	315	2023-11-07 00:13:26	2023-11-07 00:13:26
217	7	316	2023-11-07 00:13:26	2023-11-07 00:13:26
218	7	317	2023-11-07 00:13:26	2023-11-07 00:13:26
219	7	318	2023-11-07 00:13:26	2023-11-07 00:13:26
220	7	358	2023-11-07 00:13:26	2023-11-07 00:13:26
221	7	365	2023-11-07 00:13:26	2023-11-07 00:13:26
222	7	350	2023-11-07 00:13:26	2023-11-07 00:13:26
223	7	351	2023-11-07 00:13:26	2023-11-07 00:13:26
224	7	352	2023-11-07 00:13:26	2023-11-07 00:13:26
225	7	353	2023-11-07 00:13:26	2023-11-07 00:13:26
226	7	354	2023-11-07 00:13:26	2023-11-07 00:13:26
227	7	355	2023-11-07 00:13:26	2023-11-07 00:13:26
228	7	356	2023-11-07 00:13:26	2023-11-07 00:13:26
229	7	357	2023-11-07 00:13:26	2023-11-07 00:13:26
230	7	392	2023-11-07 00:13:26	2023-11-07 00:13:26
231	7	396	2023-11-07 00:13:26	2023-11-07 00:13:26
232	7	301	2023-11-07 00:13:26	2023-11-07 00:13:26
233	7	302	2023-11-07 00:13:26	2023-11-07 00:13:26
234	7	303	2023-11-07 00:13:26	2023-11-07 00:13:26
235	7	304	2023-11-07 00:13:26	2023-11-07 00:13:26
236	7	305	2023-11-07 00:13:26	2023-11-07 00:13:26
237	7	306	2023-11-07 00:13:26	2023-11-07 00:13:26
238	7	307	2023-11-07 00:13:26	2023-11-07 00:13:26
239	7	308	2023-11-07 00:13:26	2023-11-07 00:13:26
240	7	309	2023-11-07 00:13:26	2023-11-07 00:13:26
241	7	319	2023-11-07 00:13:26	2023-11-07 00:13:26
242	7	320	2023-11-07 00:13:26	2023-11-07 00:13:26
243	7	322	2023-11-07 00:13:26	2023-11-07 00:13:26
244	7	323	2023-11-07 00:13:26	2023-11-07 00:13:26
245	7	324	2023-11-07 00:13:26	2023-11-07 00:13:26
246	7	326	2023-11-07 00:13:26	2023-11-07 00:13:26
247	7	327	2023-11-07 00:13:26	2023-11-07 00:13:26
248	7	328	2023-11-07 00:13:26	2023-11-07 00:13:26
249	7	321	2023-11-07 00:13:26	2023-11-07 00:13:26
250	7	325	2023-11-07 00:13:26	2023-11-07 00:13:26
251	7	399	2023-11-07 00:13:26	2023-11-07 00:13:26
252	7	400	2023-11-07 00:13:26	2023-11-07 00:13:26
253	7	401	2023-11-07 00:13:26	2023-11-07 00:13:26
254	7	402	2023-11-07 00:13:26	2023-11-07 00:13:26
255	7	403	2023-11-07 00:13:26	2023-11-07 00:13:26
256	7	404	2023-11-07 00:13:26	2023-11-07 00:13:26
257	7	405	2023-11-07 00:13:26	2023-11-07 00:13:26
258	7	406	2023-11-07 00:13:26	2023-11-07 00:13:26
259	7	407	2023-11-07 00:13:26	2023-11-07 00:13:26
260	7	408	2023-11-07 00:13:26	2023-11-07 00:13:26
261	7	409	2023-11-07 00:13:26	2023-11-07 00:13:26
262	7	410	2023-11-07 00:13:26	2023-11-07 00:13:26
263	7	411	2023-11-07 00:13:26	2023-11-07 00:13:26
264	7	412	2023-11-07 00:13:26	2023-11-07 00:13:26
265	7	413	2023-11-07 00:13:26	2023-11-07 00:13:26
266	7	414	2023-11-07 00:13:26	2023-11-07 00:13:26
267	7	415	2023-11-07 00:13:26	2023-11-07 00:13:26
268	7	416	2023-11-07 00:13:26	2023-11-07 00:13:26
269	7	417	2023-11-07 00:13:26	2023-11-07 00:13:26
270	7	418	2023-11-07 00:13:26	2023-11-07 00:13:26
271	7	419	2023-11-07 00:13:26	2023-11-07 00:13:26
272	7	420	2023-11-07 00:13:26	2023-11-07 00:13:26
273	7	421	2023-11-07 00:13:26	2023-11-07 00:13:26
274	7	422	2023-11-07 00:13:26	2023-11-07 00:13:26
275	7	423	2023-11-07 00:13:26	2023-11-07 00:13:26
276	7	339	2023-11-07 00:13:26	2023-11-07 00:13:26
277	7	340	2023-11-07 00:13:26	2023-11-07 00:13:26
278	7	344	2023-11-07 00:13:26	2023-11-07 00:13:26
279	7	345	2023-11-07 00:13:26	2023-11-07 00:13:26
280	7	385	2023-11-07 00:13:26	2023-11-07 00:13:26
281	7	386	2023-11-07 00:13:26	2023-11-07 00:13:26
282	7	387	2023-11-07 00:13:26	2023-11-07 00:13:26
283	7	388	2023-11-07 00:13:26	2023-11-07 00:13:26
284	7	389	2023-11-07 00:13:26	2023-11-07 00:13:26
285	7	390	2023-11-07 00:13:26	2023-11-07 00:13:26
286	7	391	2023-11-07 00:13:26	2023-11-07 00:13:26
287	7	555	2023-11-07 00:13:26	2023-11-07 00:13:26
288	7	556	2023-11-07 00:13:26	2023-11-07 00:13:26
289	7	557	2023-11-07 00:13:26	2023-11-07 00:13:26
290	7	455	2023-11-07 00:13:26	2023-11-07 00:13:26
291	7	456	2023-11-07 00:13:26	2023-11-07 00:13:26
292	7	458	2023-11-07 00:13:26	2023-11-07 00:13:26
293	7	459	2023-11-07 00:13:26	2023-11-07 00:13:26
294	7	460	2023-11-07 00:13:26	2023-11-07 00:13:26
295	7	462	2023-11-07 00:13:26	2023-11-07 00:13:26
296	7	463	2023-11-07 00:13:26	2023-11-07 00:13:26
297	7	457	2023-11-07 00:13:26	2023-11-07 00:13:26
298	7	461	2023-11-07 00:13:26	2023-11-07 00:13:26
299	7	465	2023-11-07 00:13:26	2023-11-07 00:13:26
300	7	466	2023-11-07 00:13:26	2023-11-07 00:13:26
301	7	467	2023-11-07 00:13:26	2023-11-07 00:13:26
302	7	468	2023-11-07 00:13:26	2023-11-07 00:13:26
303	7	469	2023-11-07 00:13:26	2023-11-07 00:13:26
304	7	470	2023-11-07 00:13:26	2023-11-07 00:13:26
305	7	471	2023-11-07 00:13:26	2023-11-07 00:13:26
306	7	472	2023-11-07 00:13:26	2023-11-07 00:13:26
307	7	473	2023-11-07 00:13:26	2023-11-07 00:13:26
308	7	474	2023-11-07 00:13:26	2023-11-07 00:13:26
309	7	476	2023-11-07 00:13:26	2023-11-07 00:13:26
310	7	478	2023-11-07 00:13:26	2023-11-07 00:13:26
311	7	479	2023-11-07 00:13:26	2023-11-07 00:13:26
312	7	475	2023-11-07 00:13:26	2023-11-07 00:13:26
313	7	480	2023-11-07 00:13:26	2023-11-07 00:13:26
314	7	481	2023-11-07 00:13:26	2023-11-07 00:13:26
315	7	483	2023-11-07 00:13:26	2023-11-07 00:13:26
316	7	484	2023-11-07 00:13:26	2023-11-07 00:13:26
317	7	485	2023-11-07 00:13:26	2023-11-07 00:13:26
318	7	482	2023-11-07 00:13:26	2023-11-07 00:13:26
319	7	486	2023-11-07 00:13:26	2023-11-07 00:13:26
320	7	576	2023-11-07 00:13:26	2023-11-07 00:13:26
321	7	577	2023-11-07 00:13:26	2023-11-07 00:13:26
322	7	578	2023-11-07 00:13:26	2023-11-07 00:13:26
323	7	579	2023-11-07 00:13:26	2023-11-07 00:13:26
324	7	580	2023-11-07 00:13:26	2023-11-07 00:13:26
325	7	581	2023-11-07 00:13:26	2023-11-07 00:13:26
326	7	582	2023-11-07 00:13:26	2023-11-07 00:13:26
327	7	583	2023-11-07 00:13:26	2023-11-07 00:13:26
328	7	25	2023-11-07 00:13:26	2023-11-07 00:13:26
329	7	487	2023-11-07 00:13:26	2023-11-07 00:13:26
330	7	488	2023-11-07 00:13:26	2023-11-07 00:13:26
331	7	489	2023-11-07 00:13:26	2023-11-07 00:13:26
332	7	490	2023-11-07 00:13:26	2023-11-07 00:13:26
333	7	491	2023-11-07 00:13:26	2023-11-07 00:13:26
334	7	551	2023-11-07 00:13:26	2023-11-07 00:13:26
335	7	552	2023-11-07 00:13:26	2023-11-07 00:13:26
336	7	568	2023-11-07 00:13:26	2023-11-07 00:13:26
337	7	569	2023-11-07 00:13:26	2023-11-07 00:13:26
338	7	570	2023-11-07 00:13:26	2023-11-07 00:13:26
339	7	492	2023-11-07 00:13:26	2023-11-07 00:13:26
340	7	493	2023-11-07 00:13:26	2023-11-07 00:13:26
341	7	494	2023-11-07 00:13:26	2023-11-07 00:13:26
342	7	495	2023-11-07 00:13:26	2023-11-07 00:13:26
343	7	497	2023-11-07 00:13:26	2023-11-07 00:13:26
344	7	496	2023-11-07 00:13:26	2023-11-07 00:13:26
345	7	572	2023-11-07 00:13:26	2023-11-07 00:13:26
346	7	573	2023-11-07 00:13:26	2023-11-07 00:13:26
347	7	574	2023-11-07 00:13:26	2023-11-07 00:13:26
348	7	575	2023-11-07 00:13:26	2023-11-07 00:13:26
349	7	595	2023-11-07 00:13:26	2023-11-07 00:13:26
350	7	596	2023-11-07 00:13:26	2023-11-07 00:13:26
351	7	597	2023-11-07 00:13:26	2023-11-07 00:13:26
352	7	598	2023-11-07 00:13:26	2023-11-07 00:13:26
353	7	599	2023-11-07 00:13:26	2023-11-07 00:13:26
354	7	600	2023-11-07 00:13:26	2023-11-07 00:13:26
355	7	601	2023-11-07 00:13:26	2023-11-07 00:13:26
356	7	602	2023-11-07 00:13:26	2023-11-07 00:13:26
357	7	603	2023-11-07 00:13:26	2023-11-07 00:13:26
358	7	604	2023-11-07 00:13:26	2023-11-07 00:13:26
359	7	605	2023-11-07 00:13:26	2023-11-07 00:13:26
360	7	606	2023-11-07 00:13:26	2023-11-07 00:13:26
361	7	607	2023-11-07 00:13:26	2023-11-07 00:13:26
362	7	608	2023-11-07 00:13:26	2023-11-07 00:13:26
363	7	609	2023-11-07 00:13:26	2023-11-07 00:13:26
364	7	610	2023-11-07 00:13:26	2023-11-07 00:13:26
365	7	612	2023-11-07 00:13:26	2023-11-07 00:13:26
366	7	611	2023-11-07 00:13:26	2023-11-07 00:13:26
367	7	613	2023-11-07 00:13:26	2023-11-07 00:13:26
368	7	26	2023-11-07 00:13:26	2023-11-07 00:13:26
369	7	27	2023-11-07 00:13:26	2023-11-07 00:13:26
370	7	28	2023-11-07 00:13:26	2023-11-07 00:13:26
371	7	29	2023-11-07 00:13:26	2023-11-07 00:13:26
372	7	30	2023-11-07 00:13:26	2023-11-07 00:13:26
373	7	31	2023-11-07 00:13:26	2023-11-07 00:13:26
374	7	32	2023-11-07 00:13:26	2023-11-07 00:13:26
375	7	33	2023-11-07 00:13:26	2023-11-07 00:13:26
376	7	367	2023-11-07 00:13:26	2023-11-07 00:13:26
377	7	368	2023-11-07 00:13:26	2023-11-07 00:13:26
378	7	369	2023-11-07 00:13:26	2023-11-07 00:13:26
379	7	370	2023-11-07 00:13:26	2023-11-07 00:13:26
380	7	371	2023-11-07 00:13:26	2023-11-07 00:13:26
381	7	372	2023-11-07 00:13:26	2023-11-07 00:13:26
382	7	373	2023-11-07 00:13:26	2023-11-07 00:13:26
383	7	378	2023-11-07 00:13:26	2023-11-07 00:13:26
384	7	395	2023-11-07 00:13:26	2023-11-07 00:13:26
385	7	379	2023-11-07 00:13:26	2023-11-07 00:13:26
386	7	380	2023-11-07 00:13:26	2023-11-07 00:13:26
387	7	34	2023-11-07 00:13:26	2023-11-07 00:13:26
388	7	35	2023-11-07 00:13:26	2023-11-07 00:13:26
389	7	36	2023-11-07 00:13:26	2023-11-07 00:13:26
390	7	37	2023-11-07 00:13:26	2023-11-07 00:13:26
391	7	38	2023-11-07 00:13:26	2023-11-07 00:13:26
392	7	39	2023-11-07 00:13:26	2023-11-07 00:13:26
393	7	424	2023-11-07 00:13:26	2023-11-07 00:13:26
394	7	425	2023-11-07 00:13:26	2023-11-07 00:13:26
395	7	427	2023-11-07 00:13:26	2023-11-07 00:13:26
396	7	443	2023-11-07 00:13:26	2023-11-07 00:13:26
397	7	449	2023-11-07 00:13:26	2023-11-07 00:13:26
398	7	452	2023-11-07 00:13:26	2023-11-07 00:13:26
399	7	453	2023-11-07 00:13:26	2023-11-07 00:13:26
400	7	454	2023-11-07 00:13:26	2023-11-07 00:13:26
401	7	464	2023-11-07 00:13:26	2023-11-07 00:13:26
402	7	450	2023-11-07 00:13:26	2023-11-07 00:13:26
403	7	498	2023-11-07 00:13:26	2023-11-07 00:13:26
404	7	499	2023-11-07 00:13:26	2023-11-07 00:13:26
405	7	513	2023-11-07 00:13:26	2023-11-07 00:13:26
406	7	514	2023-11-07 00:13:26	2023-11-07 00:13:26
407	7	515	2023-11-07 00:13:26	2023-11-07 00:13:26
408	7	516	2023-11-07 00:13:26	2023-11-07 00:13:26
409	7	517	2023-11-07 00:13:26	2023-11-07 00:13:26
410	7	518	2023-11-07 00:13:26	2023-11-07 00:13:26
411	7	519	2023-11-07 00:13:26	2023-11-07 00:13:26
412	7	520	2023-11-07 00:13:26	2023-11-07 00:13:26
413	7	521	2023-11-07 00:13:26	2023-11-07 00:13:26
414	7	522	2023-11-07 00:13:26	2023-11-07 00:13:26
415	7	523	2023-11-07 00:13:26	2023-11-07 00:13:26
416	7	524	2023-11-07 00:13:26	2023-11-07 00:13:26
417	7	525	2023-11-07 00:13:26	2023-11-07 00:13:26
418	7	526	2023-11-07 00:13:26	2023-11-07 00:13:26
419	7	527	2023-11-07 00:13:26	2023-11-07 00:13:26
420	7	528	2023-11-07 00:13:26	2023-11-07 00:13:26
421	7	529	2023-11-07 00:13:26	2023-11-07 00:13:26
422	7	530	2023-11-07 00:13:26	2023-11-07 00:13:26
423	7	531	2023-11-07 00:13:26	2023-11-07 00:13:26
424	7	547	2023-11-07 00:13:26	2023-11-07 00:13:26
425	7	548	2023-11-07 00:13:26	2023-11-07 00:13:26
426	7	549	2023-11-07 00:13:26	2023-11-07 00:13:26
427	7	550	2023-11-07 00:13:26	2023-11-07 00:13:26
428	7	553	2023-11-07 00:13:26	2023-11-07 00:13:26
429	7	554	2023-11-07 00:13:26	2023-11-07 00:13:26
430	7	586	2023-11-07 00:13:26	2023-11-07 00:13:26
431	7	588	2023-11-07 00:13:26	2023-11-07 00:13:26
432	7	589	2023-11-07 00:13:26	2023-11-07 00:13:26
433	7	590	2023-11-07 00:13:26	2023-11-07 00:13:26
434	7	591	2023-11-07 00:13:26	2023-11-07 00:13:26
435	7	593	2023-11-07 00:13:26	2023-11-07 00:13:26
436	7	616	2023-11-07 00:13:26	2023-11-07 00:13:26
437	7	40	2023-11-07 00:13:26	2023-11-07 00:13:26
438	7	44	2023-11-07 00:13:26	2023-11-07 00:13:26
439	7	45	2023-11-07 00:13:26	2023-11-07 00:13:26
440	7	46	2023-11-07 00:13:26	2023-11-07 00:13:26
441	7	47	2023-11-07 00:13:26	2023-11-07 00:13:26
442	7	48	2023-11-07 00:13:26	2023-11-07 00:13:26
443	7	49	2023-11-07 00:13:26	2023-11-07 00:13:26
444	7	50	2023-11-07 00:13:26	2023-11-07 00:13:26
445	7	51	2023-11-07 00:13:26	2023-11-07 00:13:26
446	7	52	2023-11-07 00:13:26	2023-11-07 00:13:26
447	7	384	2023-11-07 00:13:26	2023-11-07 00:13:26
448	7	41	2023-11-07 00:13:26	2023-11-07 00:13:26
449	7	42	2023-11-07 00:13:26	2023-11-07 00:13:26
450	7	43	2023-11-07 00:13:26	2023-11-07 00:13:26
451	7	587	2023-11-07 00:13:26	2023-11-07 00:13:26
452	7	592	2023-11-07 00:13:26	2023-11-07 00:13:26
453	7	53	2023-11-07 00:13:26	2023-11-07 00:13:26
454	7	54	2023-11-07 00:13:26	2023-11-07 00:13:26
455	7	55	2023-11-07 00:13:26	2023-11-07 00:13:26
456	7	56	2023-11-07 00:13:26	2023-11-07 00:13:26
457	7	57	2023-11-07 00:13:26	2023-11-07 00:13:26
458	7	58	2023-11-07 00:13:26	2023-11-07 00:13:26
459	7	59	2023-11-07 00:13:26	2023-11-07 00:13:26
460	7	60	2023-11-07 00:13:26	2023-11-07 00:13:26
461	7	61	2023-11-07 00:13:26	2023-11-07 00:13:26
462	7	62	2023-11-07 00:13:26	2023-11-07 00:13:26
463	7	63	2023-11-07 00:13:26	2023-11-07 00:13:26
464	7	64	2023-11-07 00:13:26	2023-11-07 00:13:26
465	7	65	2023-11-07 00:13:26	2023-11-07 00:13:26
466	7	66	2023-11-07 00:13:26	2023-11-07 00:13:26
467	7	67	2023-11-07 00:13:26	2023-11-07 00:13:26
468	7	68	2023-11-07 00:13:26	2023-11-07 00:13:26
469	7	69	2023-11-07 00:13:26	2023-11-07 00:13:26
470	7	70	2023-11-07 00:13:26	2023-11-07 00:13:26
471	7	71	2023-11-07 00:13:26	2023-11-07 00:13:26
472	7	72	2023-11-07 00:13:26	2023-11-07 00:13:26
473	7	73	2023-11-07 00:13:26	2023-11-07 00:13:26
474	7	74	2023-11-07 00:13:26	2023-11-07 00:13:26
475	7	75	2023-11-07 00:13:26	2023-11-07 00:13:26
476	7	76	2023-11-07 00:13:26	2023-11-07 00:13:26
477	7	77	2023-11-07 00:13:26	2023-11-07 00:13:26
478	7	432	2023-11-07 00:13:26	2023-11-07 00:13:26
479	7	433	2023-11-07 00:13:26	2023-11-07 00:13:26
480	7	434	2023-11-07 00:13:26	2023-11-07 00:13:26
481	7	435	2023-11-07 00:13:26	2023-11-07 00:13:26
482	7	436	2023-11-07 00:13:26	2023-11-07 00:13:26
483	7	437	2023-11-07 00:13:26	2023-11-07 00:13:26
484	7	438	2023-11-07 00:13:26	2023-11-07 00:13:26
485	7	439	2023-11-07 00:13:26	2023-11-07 00:13:26
486	7	440	2023-11-07 00:13:26	2023-11-07 00:13:26
487	7	451	2023-11-07 00:13:26	2023-11-07 00:13:26
488	7	477	2023-11-07 00:13:26	2023-11-07 00:13:26
489	7	585	2023-11-07 00:13:26	2023-11-07 00:13:26
490	7	78	2023-11-07 00:13:26	2023-11-07 00:13:26
491	7	79	2023-11-07 00:13:26	2023-11-07 00:13:26
492	7	80	2023-11-07 00:13:26	2023-11-07 00:13:26
493	7	81	2023-11-07 00:13:26	2023-11-07 00:13:26
494	7	82	2023-11-07 00:13:26	2023-11-07 00:13:26
495	7	83	2023-11-07 00:13:26	2023-11-07 00:13:26
496	7	84	2023-11-07 00:13:26	2023-11-07 00:13:26
497	7	85	2023-11-07 00:13:26	2023-11-07 00:13:26
498	7	86	2023-11-07 00:13:26	2023-11-07 00:13:26
499	7	87	2023-11-07 00:13:26	2023-11-07 00:13:26
500	7	88	2023-11-07 00:13:26	2023-11-07 00:13:26
501	7	89	2023-11-07 00:13:26	2023-11-07 00:13:26
502	7	90	2023-11-07 00:13:26	2023-11-07 00:13:26
503	7	91	2023-11-07 00:13:26	2023-11-07 00:13:26
504	7	92	2023-11-07 00:13:26	2023-11-07 00:13:26
505	7	93	2023-11-07 00:13:26	2023-11-07 00:13:26
506	7	94	2023-11-07 00:13:26	2023-11-07 00:13:26
507	7	374	2023-11-07 00:13:26	2023-11-07 00:13:26
508	7	375	2023-11-07 00:13:26	2023-11-07 00:13:26
509	7	393	2023-11-07 00:13:26	2023-11-07 00:13:26
510	7	394	2023-11-07 00:13:26	2023-11-07 00:13:26
511	7	397	2023-11-07 00:13:26	2023-11-07 00:13:26
512	7	398	2023-11-07 00:13:26	2023-11-07 00:13:26
513	7	541	2023-11-07 00:13:26	2023-11-07 00:13:26
514	7	543	2023-11-07 00:13:26	2023-11-07 00:13:26
515	7	545	2023-11-07 00:13:26	2023-11-07 00:13:26
516	7	571	2023-11-07 00:13:26	2023-11-07 00:13:26
517	7	95	2023-11-07 00:13:26	2023-11-07 00:13:26
518	7	96	2023-11-07 00:13:26	2023-11-07 00:13:26
519	7	97	2023-11-07 00:13:26	2023-11-07 00:13:26
520	7	98	2023-11-07 00:13:26	2023-11-07 00:13:26
521	7	99	2023-11-07 00:13:26	2023-11-07 00:13:26
522	7	100	2023-11-07 00:13:26	2023-11-07 00:13:26
523	7	101	2023-11-07 00:13:26	2023-11-07 00:13:26
524	7	102	2023-11-07 00:13:26	2023-11-07 00:13:26
525	7	103	2023-11-07 00:13:26	2023-11-07 00:13:26
526	7	104	2023-11-07 00:13:26	2023-11-07 00:13:26
527	7	361	2023-11-07 00:13:26	2023-11-07 00:13:26
528	7	362	2023-11-07 00:13:26	2023-11-07 00:13:26
529	7	363	2023-11-07 00:13:26	2023-11-07 00:13:26
530	7	364	2023-11-07 00:13:26	2023-11-07 00:13:26
531	7	366	2023-11-07 00:13:26	2023-11-07 00:13:26
532	7	376	2023-11-07 00:13:26	2023-11-07 00:13:26
533	7	377	2023-11-07 00:13:26	2023-11-07 00:13:26
534	7	105	2023-11-07 00:13:26	2023-11-07 00:13:26
535	7	106	2023-11-07 00:13:26	2023-11-07 00:13:26
536	7	107	2023-11-07 00:13:26	2023-11-07 00:13:26
537	7	108	2023-11-07 00:13:26	2023-11-07 00:13:26
538	7	109	2023-11-07 00:13:26	2023-11-07 00:13:26
539	7	110	2023-11-07 00:13:26	2023-11-07 00:13:26
540	7	111	2023-11-07 00:13:26	2023-11-07 00:13:26
541	7	112	2023-11-07 00:13:26	2023-11-07 00:13:26
542	7	113	2023-11-07 00:13:26	2023-11-07 00:13:26
543	7	114	2023-11-07 00:13:26	2023-11-07 00:13:26
544	7	115	2023-11-07 00:13:26	2023-11-07 00:13:26
545	7	116	2023-11-07 00:13:26	2023-11-07 00:13:26
546	7	117	2023-11-07 00:13:26	2023-11-07 00:13:26
547	7	428	2023-11-07 00:13:26	2023-11-07 00:13:26
548	7	429	2023-11-07 00:13:26	2023-11-07 00:13:26
549	7	430	2023-11-07 00:13:26	2023-11-07 00:13:26
550	7	431	2023-11-07 00:13:26	2023-11-07 00:13:26
551	7	444	2023-11-07 00:13:26	2023-11-07 00:13:26
552	7	445	2023-11-07 00:13:26	2023-11-07 00:13:26
553	7	446	2023-11-07 00:13:26	2023-11-07 00:13:26
554	7	447	2023-11-07 00:13:26	2023-11-07 00:13:26
555	7	507	2023-11-07 00:13:26	2023-11-07 00:13:26
556	7	508	2023-11-07 00:13:26	2023-11-07 00:13:26
557	7	532	2023-11-07 00:13:26	2023-11-07 00:13:26
558	7	540	2023-11-07 00:13:26	2023-11-07 00:13:26
559	7	542	2023-11-07 00:13:26	2023-11-07 00:13:26
560	7	544	2023-11-07 00:13:26	2023-11-07 00:13:26
561	7	564	2023-11-07 00:13:26	2023-11-07 00:13:26
562	7	565	2023-11-07 00:13:26	2023-11-07 00:13:26
563	7	566	2023-11-07 00:13:26	2023-11-07 00:13:26
564	7	118	2023-11-07 00:13:26	2023-11-07 00:13:26
565	7	119	2023-11-07 00:13:26	2023-11-07 00:13:26
566	7	120	2023-11-07 00:13:26	2023-11-07 00:13:26
567	7	121	2023-11-07 00:13:26	2023-11-07 00:13:26
568	7	122	2023-11-07 00:13:26	2023-11-07 00:13:26
569	7	123	2023-11-07 00:13:26	2023-11-07 00:13:26
570	7	124	2023-11-07 00:13:26	2023-11-07 00:13:26
571	7	125	2023-11-07 00:13:26	2023-11-07 00:13:26
572	7	126	2023-11-07 00:13:26	2023-11-07 00:13:26
573	7	127	2023-11-07 00:13:26	2023-11-07 00:13:26
574	7	128	2023-11-07 00:13:26	2023-11-07 00:13:26
575	7	129	2023-11-07 00:13:26	2023-11-07 00:13:26
576	7	130	2023-11-07 00:13:26	2023-11-07 00:13:26
577	7	329	2023-11-07 00:13:26	2023-11-07 00:13:26
578	7	330	2023-11-07 00:13:26	2023-11-07 00:13:26
579	7	331	2023-11-07 00:13:26	2023-11-07 00:13:26
580	7	332	2023-11-07 00:13:26	2023-11-07 00:13:26
581	7	333	2023-11-07 00:13:26	2023-11-07 00:13:26
582	7	334	2023-11-07 00:13:26	2023-11-07 00:13:26
583	7	131	2023-11-07 00:13:26	2023-11-07 00:13:26
584	7	132	2023-11-07 00:13:26	2023-11-07 00:13:26
585	7	133	2023-11-07 00:13:26	2023-11-07 00:13:26
586	7	134	2023-11-07 00:13:26	2023-11-07 00:13:26
587	7	135	2023-11-07 00:13:26	2023-11-07 00:13:26
588	7	136	2023-11-07 00:13:26	2023-11-07 00:13:26
589	7	137	2023-11-07 00:13:26	2023-11-07 00:13:26
590	7	138	2023-11-07 00:13:26	2023-11-07 00:13:26
591	7	139	2023-11-07 00:13:26	2023-11-07 00:13:26
592	7	140	2023-11-07 00:13:26	2023-11-07 00:13:26
593	7	141	2023-11-07 00:13:26	2023-11-07 00:13:26
594	7	142	2023-11-07 00:13:26	2023-11-07 00:13:26
595	7	143	2023-11-07 00:13:26	2023-11-07 00:13:26
596	7	144	2023-11-07 00:13:26	2023-11-07 00:13:26
597	7	145	2023-11-07 00:13:26	2023-11-07 00:13:26
598	7	146	2023-11-07 00:13:26	2023-11-07 00:13:26
599	7	147	2023-11-07 00:13:26	2023-11-07 00:13:26
600	7	148	2023-11-07 00:13:26	2023-11-07 00:13:26
601	7	149	2023-11-07 00:13:26	2023-11-07 00:13:26
602	7	150	2023-11-07 00:13:26	2023-11-07 00:13:26
603	7	151	2023-11-07 00:13:26	2023-11-07 00:13:26
604	7	152	2023-11-07 00:13:26	2023-11-07 00:13:26
605	7	153	2023-11-07 00:13:26	2023-11-07 00:13:26
606	7	154	2023-11-07 00:13:26	2023-11-07 00:13:26
607	7	155	2023-11-07 00:13:26	2023-11-07 00:13:26
608	7	156	2023-11-07 00:13:26	2023-11-07 00:13:26
609	7	157	2023-11-07 00:13:26	2023-11-07 00:13:26
610	7	158	2023-11-07 00:13:26	2023-11-07 00:13:26
611	7	159	2023-11-07 00:13:26	2023-11-07 00:13:26
612	7	160	2023-11-07 00:13:26	2023-11-07 00:13:26
613	7	161	2023-11-07 00:13:26	2023-11-07 00:13:26
614	7	162	2023-11-07 00:13:26	2023-11-07 00:13:26
615	7	163	2023-11-07 00:13:26	2023-11-07 00:13:26
616	7	164	2023-11-07 00:13:26	2023-11-07 00:13:26
617	7	165	2023-11-07 00:13:26	2023-11-07 00:13:26
618	7	166	2023-11-07 00:13:26	2023-11-07 00:13:26
619	7	167	2023-11-07 00:13:26	2023-11-07 00:13:26
620	7	168	2023-11-07 00:13:26	2023-11-07 00:13:26
621	7	169	2023-11-07 00:13:26	2023-11-07 00:13:26
622	7	170	2023-11-07 00:13:26	2023-11-07 00:13:26
623	7	171	2023-11-07 00:13:26	2023-11-07 00:13:26
624	7	172	2023-11-07 00:13:26	2023-11-07 00:13:26
625	7	173	2023-11-07 00:13:26	2023-11-07 00:13:26
626	7	426	2023-11-07 00:13:26	2023-11-07 00:13:26
627	7	341	2023-11-07 00:13:26	2023-11-07 00:13:26
628	7	342	2023-11-07 00:13:26	2023-11-07 00:13:26
629	7	343	2023-11-07 00:13:26	2023-11-07 00:13:26
630	7	346	2023-11-07 00:13:26	2023-11-07 00:13:26
631	7	347	2023-11-07 00:13:26	2023-11-07 00:13:26
632	7	348	2023-11-07 00:13:26	2023-11-07 00:13:26
633	7	349	2023-11-07 00:13:26	2023-11-07 00:13:26
634	7	536	2023-11-07 00:13:26	2023-11-07 00:13:26
635	7	537	2023-11-07 00:13:26	2023-11-07 00:13:26
636	7	538	2023-11-07 00:13:26	2023-11-07 00:13:26
637	7	560	2023-11-07 00:13:26	2023-11-07 00:13:26
638	7	561	2023-11-07 00:13:26	2023-11-07 00:13:26
639	7	562	2023-11-07 00:13:26	2023-11-07 00:13:26
640	7	563	2023-11-07 00:13:26	2023-11-07 00:13:26
641	7	174	2023-11-07 00:13:26	2023-11-07 00:13:26
642	7	176	2023-11-07 00:13:26	2023-11-07 00:13:26
643	7	178	2023-11-07 00:13:26	2023-11-07 00:13:26
644	7	179	2023-11-07 00:13:26	2023-11-07 00:13:26
645	7	180	2023-11-07 00:13:26	2023-11-07 00:13:26
646	7	182	2023-11-07 00:13:26	2023-11-07 00:13:26
647	7	183	2023-11-07 00:13:26	2023-11-07 00:13:26
648	7	184	2023-11-07 00:13:26	2023-11-07 00:13:26
649	7	186	2023-11-07 00:13:26	2023-11-07 00:13:26
650	7	187	2023-11-07 00:13:26	2023-11-07 00:13:26
651	7	188	2023-11-07 00:13:26	2023-11-07 00:13:26
652	7	190	2023-11-07 00:13:26	2023-11-07 00:13:26
653	7	191	2023-11-07 00:13:26	2023-11-07 00:13:26
654	7	192	2023-11-07 00:13:26	2023-11-07 00:13:26
655	7	194	2023-11-07 00:13:26	2023-11-07 00:13:26
656	7	177	2023-11-07 00:13:26	2023-11-07 00:13:26
657	7	181	2023-11-07 00:13:26	2023-11-07 00:13:26
658	7	185	2023-11-07 00:13:26	2023-11-07 00:13:26
659	7	189	2023-11-07 00:13:26	2023-11-07 00:13:26
660	7	195	2023-11-07 00:13:26	2023-11-07 00:13:26
661	7	196	2023-11-07 00:13:26	2023-11-07 00:13:26
662	7	197	2023-11-07 00:13:26	2023-11-07 00:13:26
663	7	198	2023-11-07 00:13:26	2023-11-07 00:13:26
664	7	199	2023-11-07 00:13:26	2023-11-07 00:13:26
665	7	200	2023-11-07 00:13:26	2023-11-07 00:13:26
666	7	201	2023-11-07 00:13:26	2023-11-07 00:13:26
667	7	202	2023-11-07 00:13:26	2023-11-07 00:13:26
668	7	203	2023-11-07 00:13:26	2023-11-07 00:13:26
669	7	204	2023-11-07 00:13:26	2023-11-07 00:13:26
670	7	205	2023-11-07 00:13:26	2023-11-07 00:13:26
671	7	206	2023-11-07 00:13:26	2023-11-07 00:13:26
672	7	207	2023-11-07 00:13:26	2023-11-07 00:13:26
673	7	208	2023-11-07 00:13:26	2023-11-07 00:13:26
674	7	209	2023-11-07 00:13:26	2023-11-07 00:13:26
675	7	210	2023-11-07 00:13:26	2023-11-07 00:13:26
676	7	211	2023-11-07 00:13:26	2023-11-07 00:13:26
677	7	212	2023-11-07 00:13:26	2023-11-07 00:13:26
678	7	213	2023-11-07 00:13:26	2023-11-07 00:13:26
679	7	215	2023-11-07 00:13:26	2023-11-07 00:13:26
680	7	335	2023-11-07 00:13:26	2023-11-07 00:13:26
681	7	336	2023-11-07 00:13:26	2023-11-07 00:13:26
682	7	337	2023-11-07 00:13:26	2023-11-07 00:13:26
683	7	338	2023-11-07 00:13:26	2023-11-07 00:13:26
684	7	381	2023-11-07 00:13:26	2023-11-07 00:13:26
685	7	382	2023-11-07 00:13:26	2023-11-07 00:13:26
686	7	383	2023-11-07 00:13:26	2023-11-07 00:13:26
687	7	175	2023-11-07 00:13:26	2023-11-07 00:13:26
688	7	214	2023-11-07 00:13:26	2023-11-07 00:13:26
689	7	216	2023-11-07 00:13:26	2023-11-07 00:13:26
690	7	217	2023-11-07 00:13:26	2023-11-07 00:13:26
691	7	218	2023-11-07 00:13:26	2023-11-07 00:13:26
692	7	219	2023-11-07 00:13:26	2023-11-07 00:13:26
693	7	220	2023-11-07 00:13:26	2023-11-07 00:13:26
694	7	221	2023-11-07 00:13:26	2023-11-07 00:13:26
695	7	222	2023-11-07 00:13:26	2023-11-07 00:13:26
696	7	223	2023-11-07 00:13:26	2023-11-07 00:13:26
697	7	533	2023-11-07 00:13:26	2023-11-07 00:13:26
698	7	534	2023-11-07 00:13:26	2023-11-07 00:13:26
699	7	539	2023-11-07 00:13:26	2023-11-07 00:13:26
700	7	535	2023-11-07 00:13:26	2023-11-07 00:13:26
701	7	558	2023-11-07 00:13:26	2023-11-07 00:13:26
702	7	559	2023-11-07 00:13:26	2023-11-07 00:13:26
703	7	193	2023-11-07 00:13:26	2023-11-07 00:13:26
704	8	78	2023-11-07 00:23:40	2023-11-07 00:23:40
705	8	79	2023-11-07 00:23:40	2023-11-07 00:23:40
706	8	80	2023-11-07 00:23:40	2023-11-07 00:23:40
707	8	81	2023-11-07 00:23:40	2023-11-07 00:23:40
708	8	82	2023-11-07 00:23:40	2023-11-07 00:23:40
709	8	83	2023-11-07 00:23:40	2023-11-07 00:23:40
710	8	84	2023-11-07 00:23:40	2023-11-07 00:23:40
711	8	85	2023-11-07 00:23:40	2023-11-07 00:23:40
712	8	86	2023-11-07 00:23:40	2023-11-07 00:23:40
713	8	87	2023-11-07 00:23:40	2023-11-07 00:23:40
714	8	88	2023-11-07 00:23:40	2023-11-07 00:23:40
715	8	89	2023-11-07 00:23:40	2023-11-07 00:23:40
716	8	90	2023-11-07 00:23:40	2023-11-07 00:23:40
717	8	91	2023-11-07 00:23:40	2023-11-07 00:23:40
718	8	92	2023-11-07 00:23:40	2023-11-07 00:23:40
719	8	93	2023-11-07 00:23:40	2023-11-07 00:23:40
720	8	94	2023-11-07 00:23:40	2023-11-07 00:23:40
721	8	374	2023-11-07 00:23:40	2023-11-07 00:23:40
722	8	375	2023-11-07 00:23:40	2023-11-07 00:23:40
723	8	393	2023-11-07 00:23:40	2023-11-07 00:23:40
724	8	394	2023-11-07 00:23:40	2023-11-07 00:23:40
725	8	397	2023-11-07 00:23:40	2023-11-07 00:23:40
726	8	398	2023-11-07 00:23:40	2023-11-07 00:23:40
727	8	541	2023-11-07 00:23:40	2023-11-07 00:23:40
728	8	543	2023-11-07 00:23:40	2023-11-07 00:23:40
729	8	545	2023-11-07 00:23:40	2023-11-07 00:23:40
730	8	571	2023-11-07 00:23:40	2023-11-07 00:23:40
731	8	95	2023-11-07 00:23:40	2023-11-07 00:23:40
732	8	96	2023-11-07 00:23:40	2023-11-07 00:23:40
733	8	97	2023-11-07 00:23:40	2023-11-07 00:23:40
734	8	98	2023-11-07 00:23:40	2023-11-07 00:23:40
735	8	99	2023-11-07 00:23:40	2023-11-07 00:23:40
736	8	100	2023-11-07 00:23:40	2023-11-07 00:23:40
737	8	101	2023-11-07 00:23:40	2023-11-07 00:23:40
738	8	102	2023-11-07 00:23:40	2023-11-07 00:23:40
739	8	103	2023-11-07 00:23:40	2023-11-07 00:23:40
740	8	104	2023-11-07 00:23:40	2023-11-07 00:23:40
741	8	361	2023-11-07 00:23:40	2023-11-07 00:23:40
742	8	362	2023-11-07 00:23:40	2023-11-07 00:23:40
743	8	363	2023-11-07 00:23:40	2023-11-07 00:23:40
744	8	364	2023-11-07 00:23:40	2023-11-07 00:23:40
745	8	366	2023-11-07 00:23:40	2023-11-07 00:23:40
746	8	376	2023-11-07 00:23:40	2023-11-07 00:23:40
747	8	377	2023-11-07 00:23:40	2023-11-07 00:23:40
748	8	105	2023-11-07 00:23:40	2023-11-07 00:23:40
749	8	106	2023-11-07 00:23:40	2023-11-07 00:23:40
750	8	107	2023-11-07 00:23:40	2023-11-07 00:23:40
751	8	108	2023-11-07 00:23:40	2023-11-07 00:23:40
752	8	109	2023-11-07 00:23:40	2023-11-07 00:23:40
753	8	110	2023-11-07 00:23:40	2023-11-07 00:23:40
754	8	111	2023-11-07 00:23:40	2023-11-07 00:23:40
755	8	112	2023-11-07 00:23:40	2023-11-07 00:23:40
756	8	113	2023-11-07 00:23:40	2023-11-07 00:23:40
757	8	114	2023-11-07 00:23:40	2023-11-07 00:23:40
758	8	115	2023-11-07 00:23:40	2023-11-07 00:23:40
759	8	116	2023-11-07 00:23:40	2023-11-07 00:23:40
760	8	117	2023-11-07 00:23:40	2023-11-07 00:23:40
761	8	428	2023-11-07 00:23:40	2023-11-07 00:23:40
762	8	429	2023-11-07 00:23:40	2023-11-07 00:23:40
763	8	430	2023-11-07 00:23:40	2023-11-07 00:23:40
764	8	431	2023-11-07 00:23:40	2023-11-07 00:23:40
765	8	444	2023-11-07 00:23:40	2023-11-07 00:23:40
766	8	445	2023-11-07 00:23:40	2023-11-07 00:23:40
767	8	446	2023-11-07 00:23:40	2023-11-07 00:23:40
768	8	447	2023-11-07 00:23:40	2023-11-07 00:23:40
769	8	507	2023-11-07 00:23:40	2023-11-07 00:23:40
770	8	508	2023-11-07 00:23:40	2023-11-07 00:23:40
771	8	532	2023-11-07 00:23:40	2023-11-07 00:23:40
772	8	540	2023-11-07 00:23:40	2023-11-07 00:23:40
773	8	542	2023-11-07 00:23:40	2023-11-07 00:23:40
774	8	544	2023-11-07 00:23:40	2023-11-07 00:23:40
775	8	564	2023-11-07 00:23:40	2023-11-07 00:23:40
776	8	565	2023-11-07 00:23:40	2023-11-07 00:23:40
777	8	566	2023-11-07 00:23:40	2023-11-07 00:23:40
778	1	14	2023-11-23 15:36:12	2023-11-23 15:36:12
779	1	15	2023-11-23 15:36:12	2023-11-23 15:36:12
780	1	16	2023-11-23 15:36:12	2023-11-23 15:36:12
781	1	17	2023-11-23 15:36:12	2023-11-23 15:36:12
782	1	18	2023-11-23 15:36:12	2023-11-23 15:36:12
783	1	19	2023-11-23 15:36:12	2023-11-23 15:36:12
784	1	20	2023-11-23 15:36:12	2023-11-23 15:36:12
785	1	21	2023-11-23 15:36:12	2023-11-23 15:36:12
786	1	22	2023-11-23 15:36:12	2023-11-23 15:36:12
787	1	23	2023-11-23 15:36:12	2023-11-23 15:36:12
788	1	24	2023-11-23 15:36:12	2023-11-23 15:36:12
789	1	448	2023-11-23 15:36:12	2023-11-23 15:36:12
790	1	441	2023-11-23 15:36:12	2023-11-23 15:36:12
791	1	442	2023-11-23 15:36:12	2023-11-23 15:36:12
792	1	546	2023-11-23 15:36:12	2023-11-23 15:36:12
793	1	584	2023-11-23 15:36:12	2023-11-23 15:36:12
794	1	614	2023-11-23 15:36:12	2023-11-23 15:36:12
795	1	615	2023-11-23 15:36:12	2023-11-23 15:36:12
796	1	617	2023-11-23 15:36:12	2023-11-23 15:36:12
797	1	618	2023-11-23 15:36:12	2023-11-23 15:36:12
798	1	224	2023-11-23 15:36:12	2023-11-23 15:36:12
799	1	261	2023-11-23 15:36:12	2023-11-23 15:36:12
800	1	225	2023-11-23 15:36:12	2023-11-23 15:36:12
801	1	226	2023-11-23 15:36:12	2023-11-23 15:36:12
802	1	227	2023-11-23 15:36:12	2023-11-23 15:36:12
803	1	228	2023-11-23 15:36:12	2023-11-23 15:36:12
804	1	229	2023-11-23 15:36:12	2023-11-23 15:36:12
805	1	230	2023-11-23 15:36:12	2023-11-23 15:36:12
806	1	231	2023-11-23 15:36:12	2023-11-23 15:36:12
807	1	232	2023-11-23 15:36:12	2023-11-23 15:36:12
808	1	233	2023-11-23 15:36:12	2023-11-23 15:36:12
809	1	359	2023-11-23 15:36:12	2023-11-23 15:36:12
810	1	360	2023-11-23 15:36:12	2023-11-23 15:36:12
811	1	234	2023-11-23 15:36:12	2023-11-23 15:36:12
812	1	235	2023-11-23 15:36:12	2023-11-23 15:36:12
813	1	236	2023-11-23 15:36:12	2023-11-23 15:36:12
814	1	237	2023-11-23 15:36:12	2023-11-23 15:36:12
815	1	238	2023-11-23 15:36:12	2023-11-23 15:36:12
816	1	239	2023-11-23 15:36:12	2023-11-23 15:36:12
817	1	240	2023-11-23 15:36:12	2023-11-23 15:36:12
818	1	241	2023-11-23 15:36:12	2023-11-23 15:36:12
819	1	242	2023-11-23 15:36:12	2023-11-23 15:36:12
820	1	243	2023-11-23 15:36:13	2023-11-23 15:36:13
821	1	244	2023-11-23 15:36:13	2023-11-23 15:36:13
822	1	245	2023-11-23 15:36:13	2023-11-23 15:36:13
823	1	246	2023-11-23 15:36:13	2023-11-23 15:36:13
824	1	247	2023-11-23 15:36:13	2023-11-23 15:36:13
825	1	248	2023-11-23 15:36:13	2023-11-23 15:36:13
826	1	249	2023-11-23 15:36:13	2023-11-23 15:36:13
827	1	250	2023-11-23 15:36:13	2023-11-23 15:36:13
828	1	251	2023-11-23 15:36:13	2023-11-23 15:36:13
829	1	252	2023-11-23 15:36:13	2023-11-23 15:36:13
830	1	253	2023-11-23 15:36:13	2023-11-23 15:36:13
831	1	254	2023-11-23 15:36:13	2023-11-23 15:36:13
832	1	255	2023-11-23 15:36:13	2023-11-23 15:36:13
833	1	256	2023-11-23 15:36:13	2023-11-23 15:36:13
834	1	257	2023-11-23 15:36:13	2023-11-23 15:36:13
835	1	258	2023-11-23 15:36:13	2023-11-23 15:36:13
836	1	259	2023-11-23 15:36:13	2023-11-23 15:36:13
837	1	260	2023-11-23 15:36:13	2023-11-23 15:36:13
838	1	262	2023-11-23 15:36:13	2023-11-23 15:36:13
839	1	263	2023-11-23 15:36:13	2023-11-23 15:36:13
840	1	264	2023-11-23 15:36:13	2023-11-23 15:36:13
841	1	509	2023-11-23 15:36:13	2023-11-23 15:36:13
842	1	265	2023-11-23 15:36:13	2023-11-23 15:36:13
843	1	266	2023-11-23 15:36:13	2023-11-23 15:36:13
844	1	267	2023-11-23 15:36:13	2023-11-23 15:36:13
845	1	268	2023-11-23 15:36:13	2023-11-23 15:36:13
846	1	269	2023-11-23 15:36:13	2023-11-23 15:36:13
847	1	270	2023-11-23 15:36:13	2023-11-23 15:36:13
848	1	271	2023-11-23 15:36:13	2023-11-23 15:36:13
849	1	272	2023-11-23 15:36:13	2023-11-23 15:36:13
850	1	273	2023-11-23 15:36:13	2023-11-23 15:36:13
851	1	274	2023-11-23 15:36:13	2023-11-23 15:36:13
852	1	275	2023-11-23 15:36:13	2023-11-23 15:36:13
853	1	276	2023-11-23 15:36:13	2023-11-23 15:36:13
854	1	277	2023-11-23 15:36:13	2023-11-23 15:36:13
855	1	278	2023-11-23 15:36:13	2023-11-23 15:36:13
856	1	279	2023-11-23 15:36:13	2023-11-23 15:36:13
857	1	280	2023-11-23 15:36:13	2023-11-23 15:36:13
858	1	281	2023-11-23 15:36:13	2023-11-23 15:36:13
859	1	282	2023-11-23 15:36:13	2023-11-23 15:36:13
860	1	283	2023-11-23 15:36:13	2023-11-23 15:36:13
861	1	284	2023-11-23 15:36:13	2023-11-23 15:36:13
862	1	285	2023-11-23 15:36:13	2023-11-23 15:36:13
863	1	286	2023-11-23 15:36:13	2023-11-23 15:36:13
864	1	287	2023-11-23 15:36:13	2023-11-23 15:36:13
865	1	288	2023-11-23 15:36:13	2023-11-23 15:36:13
866	1	289	2023-11-23 15:36:13	2023-11-23 15:36:13
867	1	294	2023-11-23 15:36:13	2023-11-23 15:36:13
868	1	295	2023-11-23 15:36:13	2023-11-23 15:36:13
869	1	296	2023-11-23 15:36:13	2023-11-23 15:36:13
870	1	297	2023-11-23 15:36:13	2023-11-23 15:36:13
871	1	500	2023-11-23 15:36:13	2023-11-23 15:36:13
872	1	501	2023-11-23 15:36:13	2023-11-23 15:36:13
873	1	502	2023-11-23 15:36:13	2023-11-23 15:36:13
874	1	510	2023-11-23 15:36:13	2023-11-23 15:36:13
875	1	511	2023-11-23 15:36:13	2023-11-23 15:36:13
876	1	512	2023-11-23 15:36:13	2023-11-23 15:36:13
877	1	567	2023-11-23 15:36:13	2023-11-23 15:36:13
878	1	594	2023-11-23 15:36:13	2023-11-23 15:36:13
879	1	298	2023-11-23 15:36:13	2023-11-23 15:36:13
880	1	299	2023-11-23 15:36:13	2023-11-23 15:36:13
881	1	300	2023-11-23 15:36:13	2023-11-23 15:36:13
882	1	310	2023-11-23 15:36:13	2023-11-23 15:36:13
883	1	311	2023-11-23 15:36:13	2023-11-23 15:36:13
884	1	312	2023-11-23 15:36:13	2023-11-23 15:36:13
885	1	313	2023-11-23 15:36:13	2023-11-23 15:36:13
886	1	314	2023-11-23 15:36:13	2023-11-23 15:36:13
887	1	315	2023-11-23 15:36:13	2023-11-23 15:36:13
888	1	316	2023-11-23 15:36:13	2023-11-23 15:36:13
889	1	317	2023-11-23 15:36:13	2023-11-23 15:36:13
890	1	318	2023-11-23 15:36:13	2023-11-23 15:36:13
891	1	358	2023-11-23 15:36:14	2023-11-23 15:36:14
892	1	365	2023-11-23 15:36:14	2023-11-23 15:36:14
893	1	350	2023-11-23 15:36:14	2023-11-23 15:36:14
894	1	351	2023-11-23 15:36:14	2023-11-23 15:36:14
895	1	352	2023-11-23 15:36:14	2023-11-23 15:36:14
896	1	353	2023-11-23 15:36:14	2023-11-23 15:36:14
897	1	354	2023-11-23 15:36:14	2023-11-23 15:36:14
898	1	355	2023-11-23 15:36:14	2023-11-23 15:36:14
899	1	356	2023-11-23 15:36:14	2023-11-23 15:36:14
900	1	357	2023-11-23 15:36:14	2023-11-23 15:36:14
901	1	392	2023-11-23 15:36:14	2023-11-23 15:36:14
902	1	396	2023-11-23 15:36:14	2023-11-23 15:36:14
903	1	301	2023-11-23 15:36:14	2023-11-23 15:36:14
904	1	302	2023-11-23 15:36:14	2023-11-23 15:36:14
905	1	303	2023-11-23 15:36:14	2023-11-23 15:36:14
906	1	304	2023-11-23 15:36:14	2023-11-23 15:36:14
907	1	305	2023-11-23 15:36:14	2023-11-23 15:36:14
908	1	306	2023-11-23 15:36:14	2023-11-23 15:36:14
909	1	307	2023-11-23 15:36:14	2023-11-23 15:36:14
910	1	308	2023-11-23 15:36:14	2023-11-23 15:36:14
911	1	309	2023-11-23 15:36:14	2023-11-23 15:36:14
912	1	319	2023-11-23 15:36:14	2023-11-23 15:36:14
913	1	320	2023-11-23 15:36:14	2023-11-23 15:36:14
914	1	321	2023-11-23 15:36:14	2023-11-23 15:36:14
915	1	322	2023-11-23 15:36:14	2023-11-23 15:36:14
916	1	323	2023-11-23 15:36:14	2023-11-23 15:36:14
917	1	324	2023-11-23 15:36:14	2023-11-23 15:36:14
918	1	325	2023-11-23 15:36:14	2023-11-23 15:36:14
919	1	326	2023-11-23 15:36:14	2023-11-23 15:36:14
920	1	327	2023-11-23 15:36:14	2023-11-23 15:36:14
921	1	328	2023-11-23 15:36:14	2023-11-23 15:36:14
922	1	399	2023-11-23 15:36:14	2023-11-23 15:36:14
923	1	400	2023-11-23 15:36:14	2023-11-23 15:36:14
924	1	401	2023-11-23 15:36:14	2023-11-23 15:36:14
925	1	402	2023-11-23 15:36:14	2023-11-23 15:36:14
926	1	403	2023-11-23 15:36:14	2023-11-23 15:36:14
927	1	404	2023-11-23 15:36:14	2023-11-23 15:36:14
928	1	405	2023-11-23 15:36:14	2023-11-23 15:36:14
929	1	406	2023-11-23 15:36:14	2023-11-23 15:36:14
930	1	407	2023-11-23 15:36:14	2023-11-23 15:36:14
931	1	408	2023-11-23 15:36:14	2023-11-23 15:36:14
932	1	409	2023-11-23 15:36:14	2023-11-23 15:36:14
933	1	410	2023-11-23 15:36:14	2023-11-23 15:36:14
934	1	411	2023-11-23 15:36:14	2023-11-23 15:36:14
935	1	412	2023-11-23 15:36:14	2023-11-23 15:36:14
936	1	413	2023-11-23 15:36:14	2023-11-23 15:36:14
937	1	414	2023-11-23 15:36:14	2023-11-23 15:36:14
938	1	415	2023-11-23 15:36:14	2023-11-23 15:36:14
939	1	416	2023-11-23 15:36:14	2023-11-23 15:36:14
940	1	417	2023-11-23 15:36:14	2023-11-23 15:36:14
941	1	418	2023-11-23 15:36:14	2023-11-23 15:36:14
942	1	419	2023-11-23 15:36:14	2023-11-23 15:36:14
943	1	420	2023-11-23 15:36:14	2023-11-23 15:36:14
944	1	421	2023-11-23 15:36:14	2023-11-23 15:36:14
945	1	422	2023-11-23 15:36:14	2023-11-23 15:36:14
946	1	423	2023-11-23 15:36:14	2023-11-23 15:36:14
947	1	339	2023-11-23 15:36:14	2023-11-23 15:36:14
948	1	340	2023-11-23 15:36:14	2023-11-23 15:36:14
949	1	344	2023-11-23 15:36:14	2023-11-23 15:36:14
950	1	345	2023-11-23 15:36:14	2023-11-23 15:36:14
951	1	385	2023-11-23 15:36:14	2023-11-23 15:36:14
952	1	386	2023-11-23 15:36:14	2023-11-23 15:36:14
953	1	387	2023-11-23 15:36:14	2023-11-23 15:36:14
954	1	388	2023-11-23 15:36:14	2023-11-23 15:36:14
955	1	389	2023-11-23 15:36:14	2023-11-23 15:36:14
956	1	390	2023-11-23 15:36:14	2023-11-23 15:36:14
957	1	391	2023-11-23 15:36:14	2023-11-23 15:36:14
958	1	555	2023-11-23 15:36:14	2023-11-23 15:36:14
959	1	556	2023-11-23 15:36:14	2023-11-23 15:36:14
960	1	557	2023-11-23 15:36:14	2023-11-23 15:36:14
961	1	455	2023-11-23 15:36:14	2023-11-23 15:36:14
962	1	456	2023-11-23 15:36:14	2023-11-23 15:36:14
963	1	457	2023-11-23 15:36:14	2023-11-23 15:36:14
964	1	458	2023-11-23 15:36:14	2023-11-23 15:36:14
965	1	459	2023-11-23 15:36:15	2023-11-23 15:36:15
966	1	460	2023-11-23 15:36:15	2023-11-23 15:36:15
967	1	461	2023-11-23 15:36:15	2023-11-23 15:36:15
968	1	462	2023-11-23 15:36:15	2023-11-23 15:36:15
969	1	463	2023-11-23 15:36:15	2023-11-23 15:36:15
970	1	465	2023-11-23 15:36:15	2023-11-23 15:36:15
971	1	466	2023-11-23 15:36:15	2023-11-23 15:36:15
972	1	467	2023-11-23 15:36:15	2023-11-23 15:36:15
973	1	468	2023-11-23 15:36:15	2023-11-23 15:36:15
974	1	469	2023-11-23 15:36:15	2023-11-23 15:36:15
975	1	470	2023-11-23 15:36:15	2023-11-23 15:36:15
976	1	471	2023-11-23 15:36:15	2023-11-23 15:36:15
977	1	472	2023-11-23 15:36:15	2023-11-23 15:36:15
978	1	473	2023-11-23 15:36:15	2023-11-23 15:36:15
979	1	474	2023-11-23 15:36:15	2023-11-23 15:36:15
980	1	476	2023-11-23 15:36:15	2023-11-23 15:36:15
981	1	478	2023-11-23 15:36:15	2023-11-23 15:36:15
982	1	479	2023-11-23 15:36:15	2023-11-23 15:36:15
983	1	475	2023-11-23 15:36:15	2023-11-23 15:36:15
984	1	480	2023-11-23 15:36:15	2023-11-23 15:36:15
985	1	481	2023-11-23 15:36:15	2023-11-23 15:36:15
986	1	482	2023-11-23 15:36:15	2023-11-23 15:36:15
987	1	483	2023-11-23 15:36:15	2023-11-23 15:36:15
988	1	484	2023-11-23 15:36:15	2023-11-23 15:36:15
989	1	485	2023-11-23 15:36:15	2023-11-23 15:36:15
990	1	486	2023-11-23 15:36:15	2023-11-23 15:36:15
991	1	576	2023-11-23 15:36:15	2023-11-23 15:36:15
992	1	577	2023-11-23 15:36:15	2023-11-23 15:36:15
993	1	578	2023-11-23 15:36:15	2023-11-23 15:36:15
994	1	579	2023-11-23 15:36:15	2023-11-23 15:36:15
995	1	580	2023-11-23 15:36:15	2023-11-23 15:36:15
996	1	581	2023-11-23 15:36:15	2023-11-23 15:36:15
997	1	582	2023-11-23 15:36:15	2023-11-23 15:36:15
998	1	583	2023-11-23 15:36:15	2023-11-23 15:36:15
999	1	25	2023-11-23 15:36:15	2023-11-23 15:36:15
1000	1	487	2023-11-23 15:36:15	2023-11-23 15:36:15
1001	1	488	2023-11-23 15:36:15	2023-11-23 15:36:15
1002	1	489	2023-11-23 15:36:15	2023-11-23 15:36:15
1003	1	490	2023-11-23 15:36:15	2023-11-23 15:36:15
1004	1	491	2023-11-23 15:36:15	2023-11-23 15:36:15
1005	1	551	2023-11-23 15:36:15	2023-11-23 15:36:15
1006	1	552	2023-11-23 15:36:15	2023-11-23 15:36:15
1007	1	568	2023-11-23 15:36:15	2023-11-23 15:36:15
1008	1	569	2023-11-23 15:36:15	2023-11-23 15:36:15
1009	1	570	2023-11-23 15:36:15	2023-11-23 15:36:15
1010	1	492	2023-11-23 15:36:15	2023-11-23 15:36:15
1011	1	493	2023-11-23 15:36:15	2023-11-23 15:36:15
1012	1	494	2023-11-23 15:36:15	2023-11-23 15:36:15
1013	1	495	2023-11-23 15:36:15	2023-11-23 15:36:15
1014	1	497	2023-11-23 15:36:15	2023-11-23 15:36:15
1015	1	496	2023-11-23 15:36:15	2023-11-23 15:36:15
1016	1	572	2023-11-23 15:36:15	2023-11-23 15:36:15
1017	1	573	2023-11-23 15:36:15	2023-11-23 15:36:15
1018	1	574	2023-11-23 15:36:15	2023-11-23 15:36:15
1019	1	575	2023-11-23 15:36:15	2023-11-23 15:36:15
1020	1	596	2023-11-23 15:36:15	2023-11-23 15:36:15
1021	1	597	2023-11-23 15:36:15	2023-11-23 15:36:15
1022	1	598	2023-11-23 15:36:15	2023-11-23 15:36:15
1023	1	599	2023-11-23 15:36:15	2023-11-23 15:36:15
1024	1	600	2023-11-23 15:36:15	2023-11-23 15:36:15
1025	1	601	2023-11-23 15:36:15	2023-11-23 15:36:15
1026	1	602	2023-11-23 15:36:15	2023-11-23 15:36:15
1027	1	603	2023-11-23 15:36:15	2023-11-23 15:36:15
1028	1	604	2023-11-23 15:36:15	2023-11-23 15:36:15
1029	1	605	2023-11-23 15:36:15	2023-11-23 15:36:15
1030	1	606	2023-11-23 15:36:15	2023-11-23 15:36:15
1031	1	607	2023-11-23 15:36:15	2023-11-23 15:36:15
1032	1	608	2023-11-23 15:36:15	2023-11-23 15:36:15
1033	1	609	2023-11-23 15:36:15	2023-11-23 15:36:15
1034	1	610	2023-11-23 15:36:15	2023-11-23 15:36:15
1035	1	611	2023-11-23 15:36:15	2023-11-23 15:36:15
1036	1	612	2023-11-23 15:36:15	2023-11-23 15:36:15
1037	1	613	2023-11-23 15:36:15	2023-11-23 15:36:15
1038	1	26	2023-11-23 15:36:15	2023-11-23 15:36:15
1039	1	27	2023-11-23 15:36:15	2023-11-23 15:36:15
1040	1	28	2023-11-23 15:36:15	2023-11-23 15:36:15
1041	1	29	2023-11-23 15:36:15	2023-11-23 15:36:15
1042	1	30	2023-11-23 15:36:15	2023-11-23 15:36:15
1043	1	31	2023-11-23 15:36:15	2023-11-23 15:36:15
1044	1	32	2023-11-23 15:36:15	2023-11-23 15:36:15
1045	1	33	2023-11-23 15:36:15	2023-11-23 15:36:15
1046	1	367	2023-11-23 15:36:15	2023-11-23 15:36:15
1047	1	368	2023-11-23 15:36:15	2023-11-23 15:36:15
1048	1	369	2023-11-23 15:36:15	2023-11-23 15:36:15
1049	1	370	2023-11-23 15:36:15	2023-11-23 15:36:15
1050	1	371	2023-11-23 15:36:15	2023-11-23 15:36:15
1051	1	372	2023-11-23 15:36:15	2023-11-23 15:36:15
1052	1	373	2023-11-23 15:36:15	2023-11-23 15:36:15
1053	1	378	2023-11-23 15:36:15	2023-11-23 15:36:15
1054	1	395	2023-11-23 15:36:15	2023-11-23 15:36:15
1055	1	39	2023-11-23 15:36:15	2023-11-23 15:36:15
1056	1	379	2023-11-23 15:36:15	2023-11-23 15:36:15
1057	1	380	2023-11-23 15:36:15	2023-11-23 15:36:15
1058	1	34	2023-11-23 15:36:15	2023-11-23 15:36:15
1059	1	35	2023-11-23 15:36:15	2023-11-23 15:36:15
1060	1	36	2023-11-23 15:36:15	2023-11-23 15:36:15
1061	1	37	2023-11-23 15:36:15	2023-11-23 15:36:15
1062	1	38	2023-11-23 15:36:15	2023-11-23 15:36:15
1063	1	424	2023-11-23 15:36:15	2023-11-23 15:36:15
1064	1	425	2023-11-23 15:36:15	2023-11-23 15:36:15
1065	1	427	2023-11-23 15:36:15	2023-11-23 15:36:15
1066	1	443	2023-11-23 15:36:16	2023-11-23 15:36:16
1067	1	449	2023-11-23 15:36:16	2023-11-23 15:36:16
1068	1	452	2023-11-23 15:36:16	2023-11-23 15:36:16
1069	1	453	2023-11-23 15:36:16	2023-11-23 15:36:16
1070	1	454	2023-11-23 15:36:16	2023-11-23 15:36:16
1071	1	464	2023-11-23 15:36:16	2023-11-23 15:36:16
1072	1	450	2023-11-23 15:36:16	2023-11-23 15:36:16
1073	1	498	2023-11-23 15:36:16	2023-11-23 15:36:16
1074	1	499	2023-11-23 15:36:16	2023-11-23 15:36:16
1075	1	513	2023-11-23 15:36:16	2023-11-23 15:36:16
1076	1	514	2023-11-23 15:36:16	2023-11-23 15:36:16
1077	1	515	2023-11-23 15:36:16	2023-11-23 15:36:16
1078	1	516	2023-11-23 15:36:16	2023-11-23 15:36:16
1079	1	517	2023-11-23 15:36:16	2023-11-23 15:36:16
1080	1	518	2023-11-23 15:36:16	2023-11-23 15:36:16
1081	1	519	2023-11-23 15:36:16	2023-11-23 15:36:16
1082	1	520	2023-11-23 15:36:16	2023-11-23 15:36:16
1083	1	521	2023-11-23 15:36:16	2023-11-23 15:36:16
1084	1	522	2023-11-23 15:36:16	2023-11-23 15:36:16
1085	1	523	2023-11-23 15:36:16	2023-11-23 15:36:16
1086	1	524	2023-11-23 15:36:16	2023-11-23 15:36:16
1087	1	525	2023-11-23 15:36:16	2023-11-23 15:36:16
1088	1	526	2023-11-23 15:36:16	2023-11-23 15:36:16
1089	1	527	2023-11-23 15:36:16	2023-11-23 15:36:16
1090	1	528	2023-11-23 15:36:16	2023-11-23 15:36:16
1091	1	529	2023-11-23 15:36:16	2023-11-23 15:36:16
1092	1	530	2023-11-23 15:36:16	2023-11-23 15:36:16
1093	1	531	2023-11-23 15:36:16	2023-11-23 15:36:16
1094	1	547	2023-11-23 15:36:16	2023-11-23 15:36:16
1095	1	548	2023-11-23 15:36:16	2023-11-23 15:36:16
1096	1	549	2023-11-23 15:36:16	2023-11-23 15:36:16
1097	1	550	2023-11-23 15:36:16	2023-11-23 15:36:16
1098	1	553	2023-11-23 15:36:16	2023-11-23 15:36:16
1099	1	554	2023-11-23 15:36:16	2023-11-23 15:36:16
1100	1	586	2023-11-23 15:36:16	2023-11-23 15:36:16
1101	1	588	2023-11-23 15:36:16	2023-11-23 15:36:16
1102	1	589	2023-11-23 15:36:16	2023-11-23 15:36:16
1103	1	590	2023-11-23 15:36:16	2023-11-23 15:36:16
1104	1	591	2023-11-23 15:36:16	2023-11-23 15:36:16
1105	1	593	2023-11-23 15:36:16	2023-11-23 15:36:16
1106	1	616	2023-11-23 15:36:16	2023-11-23 15:36:16
1107	1	40	2023-11-23 15:36:16	2023-11-23 15:36:16
1108	1	44	2023-11-23 15:36:16	2023-11-23 15:36:16
1109	1	45	2023-11-23 15:36:16	2023-11-23 15:36:16
1110	1	46	2023-11-23 15:36:16	2023-11-23 15:36:16
1111	1	47	2023-11-23 15:36:16	2023-11-23 15:36:16
1112	1	48	2023-11-23 15:36:16	2023-11-23 15:36:16
1113	1	49	2023-11-23 15:36:16	2023-11-23 15:36:16
1114	1	50	2023-11-23 15:36:16	2023-11-23 15:36:16
1115	1	51	2023-11-23 15:36:16	2023-11-23 15:36:16
1116	1	52	2023-11-23 15:36:16	2023-11-23 15:36:16
1117	1	384	2023-11-23 15:36:16	2023-11-23 15:36:16
1118	1	41	2023-11-23 15:36:16	2023-11-23 15:36:16
1119	1	42	2023-11-23 15:36:16	2023-11-23 15:36:16
1120	1	43	2023-11-23 15:36:16	2023-11-23 15:36:16
1121	1	587	2023-11-23 15:36:16	2023-11-23 15:36:16
1122	1	592	2023-11-23 15:36:16	2023-11-23 15:36:16
1123	1	53	2023-11-23 15:36:16	2023-11-23 15:36:16
1124	1	54	2023-11-23 15:36:16	2023-11-23 15:36:16
1125	1	55	2023-11-23 15:36:16	2023-11-23 15:36:16
1126	1	56	2023-11-23 15:36:16	2023-11-23 15:36:16
1127	1	57	2023-11-23 15:36:16	2023-11-23 15:36:16
1128	1	58	2023-11-23 15:36:16	2023-11-23 15:36:16
1129	1	59	2023-11-23 15:36:16	2023-11-23 15:36:16
1130	1	60	2023-11-23 15:36:16	2023-11-23 15:36:16
1131	1	61	2023-11-23 15:36:16	2023-11-23 15:36:16
1132	1	62	2023-11-23 15:36:16	2023-11-23 15:36:16
1133	1	63	2023-11-23 15:36:16	2023-11-23 15:36:16
1134	1	64	2023-11-23 15:36:16	2023-11-23 15:36:16
1135	1	65	2023-11-23 15:36:16	2023-11-23 15:36:16
1136	1	66	2023-11-23 15:36:16	2023-11-23 15:36:16
1137	1	67	2023-11-23 15:36:16	2023-11-23 15:36:16
1138	1	68	2023-11-23 15:36:16	2023-11-23 15:36:16
1139	1	69	2023-11-23 15:36:16	2023-11-23 15:36:16
1140	1	70	2023-11-23 15:36:16	2023-11-23 15:36:16
1141	1	71	2023-11-23 15:36:16	2023-11-23 15:36:16
1142	1	72	2023-11-23 15:36:16	2023-11-23 15:36:16
1143	1	73	2023-11-23 15:36:16	2023-11-23 15:36:16
1144	1	74	2023-11-23 15:36:16	2023-11-23 15:36:16
1145	1	75	2023-11-23 15:36:16	2023-11-23 15:36:16
1146	1	76	2023-11-23 15:36:16	2023-11-23 15:36:16
1147	1	77	2023-11-23 15:36:17	2023-11-23 15:36:17
1148	1	432	2023-11-23 15:36:17	2023-11-23 15:36:17
1149	1	433	2023-11-23 15:36:17	2023-11-23 15:36:17
1150	1	434	2023-11-23 15:36:17	2023-11-23 15:36:17
1151	1	435	2023-11-23 15:36:17	2023-11-23 15:36:17
1152	1	436	2023-11-23 15:36:17	2023-11-23 15:36:17
1153	1	437	2023-11-23 15:36:17	2023-11-23 15:36:17
1154	1	438	2023-11-23 15:36:17	2023-11-23 15:36:17
1155	1	439	2023-11-23 15:36:17	2023-11-23 15:36:17
1156	1	440	2023-11-23 15:36:17	2023-11-23 15:36:17
1157	1	451	2023-11-23 15:36:17	2023-11-23 15:36:17
1158	1	477	2023-11-23 15:36:17	2023-11-23 15:36:17
1159	1	585	2023-11-23 15:36:17	2023-11-23 15:36:17
1160	1	78	2023-11-23 15:36:17	2023-11-23 15:36:17
1161	1	79	2023-11-23 15:36:17	2023-11-23 15:36:17
1162	1	80	2023-11-23 15:36:17	2023-11-23 15:36:17
1163	1	81	2023-11-23 15:36:17	2023-11-23 15:36:17
1164	1	82	2023-11-23 15:36:17	2023-11-23 15:36:17
1165	1	83	2023-11-23 15:36:17	2023-11-23 15:36:17
1166	1	84	2023-11-23 15:36:17	2023-11-23 15:36:17
1167	1	85	2023-11-23 15:36:17	2023-11-23 15:36:17
1168	1	86	2023-11-23 15:36:17	2023-11-23 15:36:17
1169	1	87	2023-11-23 15:36:17	2023-11-23 15:36:17
1170	1	88	2023-11-23 15:36:17	2023-11-23 15:36:17
1171	1	89	2023-11-23 15:36:17	2023-11-23 15:36:17
1172	1	90	2023-11-23 15:36:17	2023-11-23 15:36:17
1173	1	91	2023-11-23 15:36:17	2023-11-23 15:36:17
1174	1	92	2023-11-23 15:36:17	2023-11-23 15:36:17
1175	1	93	2023-11-23 15:36:17	2023-11-23 15:36:17
1176	1	94	2023-11-23 15:36:17	2023-11-23 15:36:17
1177	1	374	2023-11-23 15:36:17	2023-11-23 15:36:17
1178	1	375	2023-11-23 15:36:17	2023-11-23 15:36:17
1179	1	393	2023-11-23 15:36:17	2023-11-23 15:36:17
1180	1	394	2023-11-23 15:36:17	2023-11-23 15:36:17
1181	1	397	2023-11-23 15:36:17	2023-11-23 15:36:17
1182	1	398	2023-11-23 15:36:17	2023-11-23 15:36:17
1183	1	541	2023-11-23 15:36:17	2023-11-23 15:36:17
1184	1	543	2023-11-23 15:36:17	2023-11-23 15:36:17
1185	1	545	2023-11-23 15:36:17	2023-11-23 15:36:17
1186	1	571	2023-11-23 15:36:17	2023-11-23 15:36:17
1187	1	95	2023-11-23 15:36:17	2023-11-23 15:36:17
1188	1	96	2023-11-23 15:36:17	2023-11-23 15:36:17
1189	1	97	2023-11-23 15:36:17	2023-11-23 15:36:17
1190	1	98	2023-11-23 15:36:17	2023-11-23 15:36:17
1191	1	99	2023-11-23 15:36:17	2023-11-23 15:36:17
1192	1	100	2023-11-23 15:36:17	2023-11-23 15:36:17
1193	1	101	2023-11-23 15:36:17	2023-11-23 15:36:17
1194	1	102	2023-11-23 15:36:17	2023-11-23 15:36:17
1195	1	103	2023-11-23 15:36:17	2023-11-23 15:36:17
1196	1	104	2023-11-23 15:36:17	2023-11-23 15:36:17
1197	1	361	2023-11-23 15:36:17	2023-11-23 15:36:17
1198	1	362	2023-11-23 15:36:17	2023-11-23 15:36:17
1199	1	363	2023-11-23 15:36:18	2023-11-23 15:36:18
1200	1	364	2023-11-23 15:36:18	2023-11-23 15:36:18
1201	1	366	2023-11-23 15:36:18	2023-11-23 15:36:18
1202	1	376	2023-11-23 15:36:18	2023-11-23 15:36:18
1203	1	377	2023-11-23 15:36:18	2023-11-23 15:36:18
1204	1	105	2023-11-23 15:36:18	2023-11-23 15:36:18
1205	1	106	2023-11-23 15:36:18	2023-11-23 15:36:18
1206	1	107	2023-11-23 15:36:18	2023-11-23 15:36:18
1207	1	108	2023-11-23 15:36:18	2023-11-23 15:36:18
1208	1	109	2023-11-23 15:36:18	2023-11-23 15:36:18
1209	1	110	2023-11-23 15:36:18	2023-11-23 15:36:18
1210	1	111	2023-11-23 15:36:18	2023-11-23 15:36:18
1211	1	112	2023-11-23 15:36:18	2023-11-23 15:36:18
1212	1	113	2023-11-23 15:36:18	2023-11-23 15:36:18
1213	1	114	2023-11-23 15:36:18	2023-11-23 15:36:18
1214	1	115	2023-11-23 15:36:18	2023-11-23 15:36:18
1215	1	116	2023-11-23 15:36:18	2023-11-23 15:36:18
1216	1	117	2023-11-23 15:36:18	2023-11-23 15:36:18
1217	1	428	2023-11-23 15:36:18	2023-11-23 15:36:18
1218	1	429	2023-11-23 15:36:18	2023-11-23 15:36:18
1219	1	430	2023-11-23 15:36:18	2023-11-23 15:36:18
1220	1	431	2023-11-23 15:36:18	2023-11-23 15:36:18
1221	1	444	2023-11-23 15:36:18	2023-11-23 15:36:18
1222	1	445	2023-11-23 15:36:18	2023-11-23 15:36:18
1223	1	446	2023-11-23 15:36:18	2023-11-23 15:36:18
1224	1	447	2023-11-23 15:36:18	2023-11-23 15:36:18
1225	1	507	2023-11-23 15:36:18	2023-11-23 15:36:18
1226	1	508	2023-11-23 15:36:18	2023-11-23 15:36:18
1227	1	532	2023-11-23 15:36:18	2023-11-23 15:36:18
1228	1	540	2023-11-23 15:36:18	2023-11-23 15:36:18
1229	1	542	2023-11-23 15:36:18	2023-11-23 15:36:18
1230	1	544	2023-11-23 15:36:18	2023-11-23 15:36:18
1231	1	564	2023-11-23 15:36:18	2023-11-23 15:36:18
1232	1	565	2023-11-23 15:36:18	2023-11-23 15:36:18
1233	1	566	2023-11-23 15:36:18	2023-11-23 15:36:18
1234	1	118	2023-11-23 15:36:18	2023-11-23 15:36:18
1235	1	119	2023-11-23 15:36:18	2023-11-23 15:36:18
1236	1	120	2023-11-23 15:36:18	2023-11-23 15:36:18
1237	1	121	2023-11-23 15:36:18	2023-11-23 15:36:18
1238	1	122	2023-11-23 15:36:18	2023-11-23 15:36:18
1239	1	123	2023-11-23 15:36:18	2023-11-23 15:36:18
1240	1	124	2023-11-23 15:36:18	2023-11-23 15:36:18
1241	1	125	2023-11-23 15:36:18	2023-11-23 15:36:18
1242	1	126	2023-11-23 15:36:18	2023-11-23 15:36:18
1243	1	127	2023-11-23 15:36:18	2023-11-23 15:36:18
1244	1	128	2023-11-23 15:36:18	2023-11-23 15:36:18
1245	1	129	2023-11-23 15:36:18	2023-11-23 15:36:18
1246	1	130	2023-11-23 15:36:18	2023-11-23 15:36:18
1247	1	329	2023-11-23 15:36:18	2023-11-23 15:36:18
1248	1	330	2023-11-23 15:36:18	2023-11-23 15:36:18
1249	1	331	2023-11-23 15:36:18	2023-11-23 15:36:18
1250	1	332	2023-11-23 15:36:18	2023-11-23 15:36:18
1251	1	333	2023-11-23 15:36:18	2023-11-23 15:36:18
1252	1	334	2023-11-23 15:36:18	2023-11-23 15:36:18
1253	1	131	2023-11-23 15:36:18	2023-11-23 15:36:18
1254	1	132	2023-11-23 15:36:19	2023-11-23 15:36:19
1255	1	133	2023-11-23 15:36:19	2023-11-23 15:36:19
1256	1	134	2023-11-23 15:36:19	2023-11-23 15:36:19
1257	1	135	2023-11-23 15:36:19	2023-11-23 15:36:19
1258	1	136	2023-11-23 15:36:19	2023-11-23 15:36:19
1259	1	137	2023-11-23 15:36:19	2023-11-23 15:36:19
1260	1	138	2023-11-23 15:36:19	2023-11-23 15:36:19
1261	1	139	2023-11-23 15:36:19	2023-11-23 15:36:19
1262	1	140	2023-11-23 15:36:19	2023-11-23 15:36:19
1263	1	141	2023-11-23 15:36:19	2023-11-23 15:36:19
1264	1	142	2023-11-23 15:36:19	2023-11-23 15:36:19
1265	1	143	2023-11-23 15:36:19	2023-11-23 15:36:19
1266	1	144	2023-11-23 15:36:19	2023-11-23 15:36:19
1267	1	145	2023-11-23 15:36:19	2023-11-23 15:36:19
1268	1	146	2023-11-23 15:36:19	2023-11-23 15:36:19
1269	1	147	2023-11-23 15:36:19	2023-11-23 15:36:19
1270	1	148	2023-11-23 15:36:19	2023-11-23 15:36:19
1271	1	149	2023-11-23 15:36:19	2023-11-23 15:36:19
1272	1	150	2023-11-23 15:36:19	2023-11-23 15:36:19
1273	1	151	2023-11-23 15:36:19	2023-11-23 15:36:19
1274	1	152	2023-11-23 15:36:19	2023-11-23 15:36:19
1275	1	153	2023-11-23 15:36:19	2023-11-23 15:36:19
1276	1	154	2023-11-23 15:36:19	2023-11-23 15:36:19
1277	1	155	2023-11-23 15:36:19	2023-11-23 15:36:19
1278	1	156	2023-11-23 15:36:19	2023-11-23 15:36:19
1279	1	157	2023-11-23 15:36:19	2023-11-23 15:36:19
1280	1	158	2023-11-23 15:36:19	2023-11-23 15:36:19
1281	1	159	2023-11-23 15:36:19	2023-11-23 15:36:19
1282	1	160	2023-11-23 15:36:19	2023-11-23 15:36:19
1283	1	161	2023-11-23 15:36:19	2023-11-23 15:36:19
1284	1	162	2023-11-23 15:36:19	2023-11-23 15:36:19
1285	1	163	2023-11-23 15:36:19	2023-11-23 15:36:19
1286	1	164	2023-11-23 15:36:19	2023-11-23 15:36:19
1287	1	165	2023-11-23 15:36:19	2023-11-23 15:36:19
1288	1	166	2023-11-23 15:36:19	2023-11-23 15:36:19
1289	1	167	2023-11-23 15:36:19	2023-11-23 15:36:19
1290	1	168	2023-11-23 15:36:19	2023-11-23 15:36:19
1291	1	169	2023-11-23 15:36:19	2023-11-23 15:36:19
1292	1	170	2023-11-23 15:36:19	2023-11-23 15:36:19
1293	1	171	2023-11-23 15:36:19	2023-11-23 15:36:19
1294	1	172	2023-11-23 15:36:19	2023-11-23 15:36:19
1295	1	173	2023-11-23 15:36:19	2023-11-23 15:36:19
1296	1	426	2023-11-23 15:36:19	2023-11-23 15:36:19
1297	1	341	2023-11-23 15:36:19	2023-11-23 15:36:19
1298	1	342	2023-11-23 15:36:19	2023-11-23 15:36:19
1299	1	343	2023-11-23 15:36:19	2023-11-23 15:36:19
1300	1	346	2023-11-23 15:36:19	2023-11-23 15:36:19
1301	1	347	2023-11-23 15:36:19	2023-11-23 15:36:19
1302	1	348	2023-11-23 15:36:19	2023-11-23 15:36:19
1303	1	349	2023-11-23 15:36:19	2023-11-23 15:36:19
1304	1	536	2023-11-23 15:36:19	2023-11-23 15:36:19
1305	1	537	2023-11-23 15:36:19	2023-11-23 15:36:19
1306	1	538	2023-11-23 15:36:19	2023-11-23 15:36:19
1307	1	560	2023-11-23 15:36:19	2023-11-23 15:36:19
1308	1	561	2023-11-23 15:36:20	2023-11-23 15:36:20
1309	1	562	2023-11-23 15:36:20	2023-11-23 15:36:20
1310	1	563	2023-11-23 15:36:20	2023-11-23 15:36:20
1311	1	174	2023-11-23 15:36:20	2023-11-23 15:36:20
1312	1	176	2023-11-23 15:36:20	2023-11-23 15:36:20
1313	1	177	2023-11-23 15:36:20	2023-11-23 15:36:20
1314	1	178	2023-11-23 15:36:20	2023-11-23 15:36:20
1315	1	179	2023-11-23 15:36:20	2023-11-23 15:36:20
1316	1	180	2023-11-23 15:36:20	2023-11-23 15:36:20
1317	1	181	2023-11-23 15:36:20	2023-11-23 15:36:20
1318	1	182	2023-11-23 15:36:20	2023-11-23 15:36:20
1319	1	183	2023-11-23 15:36:20	2023-11-23 15:36:20
1320	1	184	2023-11-23 15:36:20	2023-11-23 15:36:20
1321	1	185	2023-11-23 15:36:20	2023-11-23 15:36:20
1322	1	186	2023-11-23 15:36:20	2023-11-23 15:36:20
1323	1	187	2023-11-23 15:36:20	2023-11-23 15:36:20
1324	1	188	2023-11-23 15:36:20	2023-11-23 15:36:20
1325	1	189	2023-11-23 15:36:20	2023-11-23 15:36:20
1326	1	190	2023-11-23 15:36:20	2023-11-23 15:36:20
1327	1	191	2023-11-23 15:36:20	2023-11-23 15:36:20
1328	1	192	2023-11-23 15:36:20	2023-11-23 15:36:20
1329	1	193	2023-11-23 15:36:20	2023-11-23 15:36:20
1330	1	194	2023-11-23 15:36:20	2023-11-23 15:36:20
1331	1	195	2023-11-23 15:36:20	2023-11-23 15:36:20
1332	1	196	2023-11-23 15:36:20	2023-11-23 15:36:20
1333	1	197	2023-11-23 15:36:20	2023-11-23 15:36:20
1334	1	198	2023-11-23 15:36:20	2023-11-23 15:36:20
1335	1	199	2023-11-23 15:36:20	2023-11-23 15:36:20
1336	1	200	2023-11-23 15:36:20	2023-11-23 15:36:20
1337	1	201	2023-11-23 15:36:20	2023-11-23 15:36:20
1338	1	202	2023-11-23 15:36:20	2023-11-23 15:36:20
1339	1	203	2023-11-23 15:36:20	2023-11-23 15:36:20
1340	1	204	2023-11-23 15:36:20	2023-11-23 15:36:20
1341	1	205	2023-11-23 15:36:20	2023-11-23 15:36:20
1342	1	206	2023-11-23 15:36:20	2023-11-23 15:36:20
1343	1	207	2023-11-23 15:36:20	2023-11-23 15:36:20
1344	1	208	2023-11-23 15:36:20	2023-11-23 15:36:20
1345	1	209	2023-11-23 15:36:20	2023-11-23 15:36:20
1346	1	210	2023-11-23 15:36:20	2023-11-23 15:36:20
1347	1	211	2023-11-23 15:36:20	2023-11-23 15:36:20
1348	1	212	2023-11-23 15:36:20	2023-11-23 15:36:20
1349	1	213	2023-11-23 15:36:20	2023-11-23 15:36:20
1350	1	215	2023-11-23 15:36:20	2023-11-23 15:36:20
1351	1	335	2023-11-23 15:36:20	2023-11-23 15:36:20
1352	1	336	2023-11-23 15:36:20	2023-11-23 15:36:20
1353	1	337	2023-11-23 15:36:20	2023-11-23 15:36:20
1354	1	338	2023-11-23 15:36:20	2023-11-23 15:36:20
1355	1	381	2023-11-23 15:36:20	2023-11-23 15:36:20
1356	1	382	2023-11-23 15:36:20	2023-11-23 15:36:20
1357	1	383	2023-11-23 15:36:20	2023-11-23 15:36:20
1358	1	175	2023-11-23 15:36:20	2023-11-23 15:36:20
1359	1	214	2023-11-23 15:36:20	2023-11-23 15:36:20
1360	1	216	2023-11-23 15:36:20	2023-11-23 15:36:20
1361	1	217	2023-11-23 15:36:20	2023-11-23 15:36:20
1362	1	218	2023-11-23 15:36:20	2023-11-23 15:36:20
1363	1	219	2023-11-23 15:36:20	2023-11-23 15:36:20
1364	1	220	2023-11-23 15:36:20	2023-11-23 15:36:20
1365	1	221	2023-11-23 15:36:20	2023-11-23 15:36:20
1366	1	222	2023-11-23 15:36:20	2023-11-23 15:36:20
1367	1	223	2023-11-23 15:36:20	2023-11-23 15:36:20
1368	1	533	2023-11-23 15:36:20	2023-11-23 15:36:20
1369	1	534	2023-11-23 15:36:20	2023-11-23 15:36:20
1370	1	539	2023-11-23 15:36:20	2023-11-23 15:36:20
1371	1	535	2023-11-23 15:36:20	2023-11-23 15:36:20
1372	1	558	2023-11-23 15:36:20	2023-11-23 15:36:20
1373	1	559	2023-11-23 15:36:20	2023-11-23 15:36:20
1374	2	14	2023-11-23 21:38:32	2023-11-23 21:38:32
1375	2	15	2023-11-23 21:38:32	2023-11-23 21:38:32
1376	2	16	2023-11-23 21:38:32	2023-11-23 21:38:32
1377	2	17	2023-11-23 21:38:33	2023-11-23 21:38:33
1378	2	18	2023-11-23 21:38:33	2023-11-23 21:38:33
1379	2	19	2023-11-23 21:38:33	2023-11-23 21:38:33
1380	2	20	2023-11-23 21:38:33	2023-11-23 21:38:33
1381	2	21	2023-11-23 21:38:33	2023-11-23 21:38:33
1382	2	22	2023-11-23 21:38:33	2023-11-23 21:38:33
1383	2	23	2023-11-23 21:38:33	2023-11-23 21:38:33
1384	2	584	2023-11-23 21:38:33	2023-11-23 21:38:33
1385	2	614	2023-11-23 21:38:33	2023-11-23 21:38:33
1386	2	615	2023-11-23 21:38:33	2023-11-23 21:38:33
1387	2	224	2023-11-23 21:38:33	2023-11-23 21:38:33
1388	2	225	2023-11-23 21:38:33	2023-11-23 21:38:33
1389	2	226	2023-11-23 21:38:33	2023-11-23 21:38:33
1390	2	227	2023-11-23 21:38:33	2023-11-23 21:38:33
1391	2	228	2023-11-23 21:38:33	2023-11-23 21:38:33
1392	2	229	2023-11-23 21:38:33	2023-11-23 21:38:33
1393	2	230	2023-11-23 21:38:33	2023-11-23 21:38:33
1394	2	231	2023-11-23 21:38:33	2023-11-23 21:38:33
1395	2	232	2023-11-23 21:38:33	2023-11-23 21:38:33
1396	2	359	2023-11-23 21:38:33	2023-11-23 21:38:33
1397	2	360	2023-11-23 21:38:33	2023-11-23 21:38:33
1398	2	253	2023-11-23 21:38:33	2023-11-23 21:38:33
1399	2	254	2023-11-23 21:38:33	2023-11-23 21:38:33
1400	2	255	2023-11-23 21:38:33	2023-11-23 21:38:33
1401	2	509	2023-11-23 21:38:33	2023-11-23 21:38:33
1402	2	273	2023-11-23 21:38:33	2023-11-23 21:38:33
1403	2	274	2023-11-23 21:38:33	2023-11-23 21:38:33
1404	2	275	2023-11-23 21:38:33	2023-11-23 21:38:33
1405	2	276	2023-11-23 21:38:33	2023-11-23 21:38:33
1406	2	277	2023-11-23 21:38:33	2023-11-23 21:38:33
1407	2	278	2023-11-23 21:38:33	2023-11-23 21:38:33
1408	2	279	2023-11-23 21:38:34	2023-11-23 21:38:34
1409	2	288	2023-11-23 21:38:34	2023-11-23 21:38:34
1410	2	289	2023-11-23 21:38:34	2023-11-23 21:38:34
1411	2	294	2023-11-23 21:38:34	2023-11-23 21:38:34
1412	2	295	2023-11-23 21:38:34	2023-11-23 21:38:34
1413	2	296	2023-11-23 21:38:34	2023-11-23 21:38:34
1414	2	297	2023-11-23 21:38:34	2023-11-23 21:38:34
1415	2	502	2023-11-23 21:38:34	2023-11-23 21:38:34
1416	2	594	2023-11-23 21:38:34	2023-11-23 21:38:34
1417	2	298	2023-11-23 21:38:34	2023-11-23 21:38:34
1418	2	299	2023-11-23 21:38:34	2023-11-23 21:38:34
1419	2	25	2023-11-23 21:38:34	2023-11-23 21:38:34
1420	2	572	2023-11-23 21:38:34	2023-11-23 21:38:34
1421	2	573	2023-11-23 21:38:34	2023-11-23 21:38:34
1422	2	574	2023-11-23 21:38:34	2023-11-23 21:38:34
1423	2	575	2023-11-23 21:38:34	2023-11-23 21:38:34
1424	2	26	2023-11-23 21:38:34	2023-11-23 21:38:34
1425	2	27	2023-11-23 21:38:34	2023-11-23 21:38:34
1426	2	28	2023-11-23 21:38:34	2023-11-23 21:38:34
1427	2	29	2023-11-23 21:38:34	2023-11-23 21:38:34
1428	2	31	2023-11-23 21:38:34	2023-11-23 21:38:34
1429	2	33	2023-11-23 21:38:34	2023-11-23 21:38:34
1430	2	369	2023-11-23 21:38:34	2023-11-23 21:38:34
1431	2	372	2023-11-23 21:38:34	2023-11-23 21:38:34
1432	2	373	2023-11-23 21:38:34	2023-11-23 21:38:34
1433	2	378	2023-11-23 21:38:34	2023-11-23 21:38:34
1434	2	395	2023-11-23 21:38:34	2023-11-23 21:38:34
1435	2	39	2023-11-23 21:38:34	2023-11-23 21:38:34
1436	2	380	2023-11-23 21:38:34	2023-11-23 21:38:34
1437	2	34	2023-11-23 21:38:34	2023-11-23 21:38:34
1438	2	35	2023-11-23 21:38:34	2023-11-23 21:38:34
1439	2	36	2023-11-23 21:38:34	2023-11-23 21:38:34
1440	2	427	2023-11-23 21:38:34	2023-11-23 21:38:34
1441	2	443	2023-11-23 21:38:34	2023-11-23 21:38:34
1442	2	449	2023-11-23 21:38:34	2023-11-23 21:38:34
1443	2	453	2023-11-23 21:38:35	2023-11-23 21:38:35
1444	2	454	2023-11-23 21:38:35	2023-11-23 21:38:35
1445	2	464	2023-11-23 21:38:35	2023-11-23 21:38:35
1446	2	499	2023-11-23 21:38:35	2023-11-23 21:38:35
1447	2	513	2023-11-23 21:38:35	2023-11-23 21:38:35
1448	2	514	2023-11-23 21:38:35	2023-11-23 21:38:35
1449	2	515	2023-11-23 21:38:35	2023-11-23 21:38:35
1450	2	516	2023-11-23 21:38:35	2023-11-23 21:38:35
1451	2	517	2023-11-23 21:38:35	2023-11-23 21:38:35
1452	2	518	2023-11-23 21:38:35	2023-11-23 21:38:35
1453	2	519	2023-11-23 21:38:35	2023-11-23 21:38:35
1454	2	521	2023-11-23 21:38:35	2023-11-23 21:38:35
1455	2	522	2023-11-23 21:38:35	2023-11-23 21:38:35
1456	2	523	2023-11-23 21:38:35	2023-11-23 21:38:35
1457	2	524	2023-11-23 21:38:35	2023-11-23 21:38:35
1458	2	525	2023-11-23 21:38:35	2023-11-23 21:38:35
1459	2	526	2023-11-23 21:38:35	2023-11-23 21:38:35
1460	2	527	2023-11-23 21:38:35	2023-11-23 21:38:35
1461	2	528	2023-11-23 21:38:35	2023-11-23 21:38:35
1462	2	550	2023-11-23 21:38:35	2023-11-23 21:38:35
1463	2	553	2023-11-23 21:38:35	2023-11-23 21:38:35
1464	2	554	2023-11-23 21:38:35	2023-11-23 21:38:35
1465	2	586	2023-11-23 21:38:35	2023-11-23 21:38:35
1466	2	593	2023-11-23 21:38:35	2023-11-23 21:38:35
1467	2	616	2023-11-23 21:38:35	2023-11-23 21:38:35
1468	2	40	2023-11-23 21:38:35	2023-11-23 21:38:35
1469	2	44	2023-11-23 21:38:35	2023-11-23 21:38:35
1470	2	45	2023-11-23 21:38:35	2023-11-23 21:38:35
1471	2	47	2023-11-23 21:38:35	2023-11-23 21:38:35
1472	2	48	2023-11-23 21:38:35	2023-11-23 21:38:35
1473	2	49	2023-11-23 21:38:35	2023-11-23 21:38:35
1474	2	51	2023-11-23 21:38:35	2023-11-23 21:38:35
1475	2	52	2023-11-23 21:38:35	2023-11-23 21:38:35
1476	2	384	2023-11-23 21:38:35	2023-11-23 21:38:35
1477	2	41	2023-11-23 21:38:35	2023-11-23 21:38:35
1478	2	42	2023-11-23 21:38:35	2023-11-23 21:38:35
1479	2	43	2023-11-23 21:38:36	2023-11-23 21:38:36
1480	2	53	2023-11-23 21:38:36	2023-11-23 21:38:36
1481	2	54	2023-11-23 21:38:36	2023-11-23 21:38:36
1482	2	55	2023-11-23 21:38:36	2023-11-23 21:38:36
1483	2	56	2023-11-23 21:38:36	2023-11-23 21:38:36
1484	2	57	2023-11-23 21:38:36	2023-11-23 21:38:36
1485	2	477	2023-11-23 21:38:36	2023-11-23 21:38:36
1486	2	78	2023-11-23 21:38:36	2023-11-23 21:38:36
1487	2	79	2023-11-23 21:38:36	2023-11-23 21:38:36
1488	2	80	2023-11-23 21:38:36	2023-11-23 21:38:36
1489	2	81	2023-11-23 21:38:36	2023-11-23 21:38:36
1490	2	82	2023-11-23 21:38:36	2023-11-23 21:38:36
1491	2	90	2023-11-23 21:38:36	2023-11-23 21:38:36
1492	2	91	2023-11-23 21:38:36	2023-11-23 21:38:36
1493	2	374	2023-11-23 21:38:36	2023-11-23 21:38:36
1494	2	375	2023-11-23 21:38:36	2023-11-23 21:38:36
1495	2	541	2023-11-23 21:38:36	2023-11-23 21:38:36
1496	2	543	2023-11-23 21:38:36	2023-11-23 21:38:36
1497	2	545	2023-11-23 21:38:36	2023-11-23 21:38:36
1498	2	95	2023-11-23 21:38:36	2023-11-23 21:38:36
1499	2	96	2023-11-23 21:38:36	2023-11-23 21:38:36
1500	2	97	2023-11-23 21:38:36	2023-11-23 21:38:36
1501	2	98	2023-11-23 21:38:36	2023-11-23 21:38:36
1502	2	99	2023-11-23 21:38:36	2023-11-23 21:38:36
1503	2	102	2023-11-23 21:38:36	2023-11-23 21:38:36
1504	2	361	2023-11-23 21:38:36	2023-11-23 21:38:36
1505	2	362	2023-11-23 21:38:36	2023-11-23 21:38:36
1506	2	363	2023-11-23 21:38:36	2023-11-23 21:38:36
1507	2	364	2023-11-23 21:38:36	2023-11-23 21:38:36
1508	2	366	2023-11-23 21:38:36	2023-11-23 21:38:36
1509	2	376	2023-11-23 21:38:36	2023-11-23 21:38:36
1510	2	377	2023-11-23 21:38:36	2023-11-23 21:38:36
1511	2	111	2023-11-23 21:38:37	2023-11-23 21:38:37
1512	2	112	2023-11-23 21:38:37	2023-11-23 21:38:37
1513	2	113	2023-11-23 21:38:37	2023-11-23 21:38:37
1514	2	117	2023-11-23 21:38:37	2023-11-23 21:38:37
1515	2	507	2023-11-23 21:38:37	2023-11-23 21:38:37
1516	2	532	2023-11-23 21:38:37	2023-11-23 21:38:37
1517	2	542	2023-11-23 21:38:37	2023-11-23 21:38:37
1518	2	544	2023-11-23 21:38:37	2023-11-23 21:38:37
1519	2	564	2023-11-23 21:38:37	2023-11-23 21:38:37
1520	2	565	2023-11-23 21:38:37	2023-11-23 21:38:37
1521	2	566	2023-11-23 21:38:37	2023-11-23 21:38:37
1522	2	118	2023-11-23 21:38:37	2023-11-23 21:38:37
1523	2	119	2023-11-23 21:38:37	2023-11-23 21:38:37
1524	2	120	2023-11-23 21:38:37	2023-11-23 21:38:37
1525	2	121	2023-11-23 21:38:37	2023-11-23 21:38:37
1526	2	122	2023-11-23 21:38:37	2023-11-23 21:38:37
1527	2	126	2023-11-23 21:38:37	2023-11-23 21:38:37
1528	2	127	2023-11-23 21:38:37	2023-11-23 21:38:37
1529	2	128	2023-11-23 21:38:37	2023-11-23 21:38:37
1530	2	129	2023-11-23 21:38:37	2023-11-23 21:38:37
1531	2	134	2023-11-23 21:38:37	2023-11-23 21:38:37
1532	2	135	2023-11-23 21:38:37	2023-11-23 21:38:37
1533	2	136	2023-11-23 21:38:37	2023-11-23 21:38:37
1534	2	137	2023-11-23 21:38:37	2023-11-23 21:38:37
1535	2	143	2023-11-23 21:38:37	2023-11-23 21:38:37
1536	2	144	2023-11-23 21:38:37	2023-11-23 21:38:37
1537	2	145	2023-11-23 21:38:37	2023-11-23 21:38:37
1538	2	146	2023-11-23 21:38:37	2023-11-23 21:38:37
1539	2	147	2023-11-23 21:38:37	2023-11-23 21:38:37
1540	2	148	2023-11-23 21:38:37	2023-11-23 21:38:37
1541	2	152	2023-11-23 21:38:37	2023-11-23 21:38:37
1542	2	153	2023-11-23 21:38:37	2023-11-23 21:38:37
1543	2	154	2023-11-23 21:38:37	2023-11-23 21:38:37
1544	2	155	2023-11-23 21:38:37	2023-11-23 21:38:37
1545	2	156	2023-11-23 21:38:37	2023-11-23 21:38:37
1546	2	157	2023-11-23 21:38:37	2023-11-23 21:38:37
1547	2	158	2023-11-23 21:38:37	2023-11-23 21:38:37
1548	2	159	2023-11-23 21:38:37	2023-11-23 21:38:37
1549	2	426	2023-11-23 21:38:37	2023-11-23 21:38:37
1550	2	536	2023-11-23 21:38:37	2023-11-23 21:38:37
1551	2	537	2023-11-23 21:38:38	2023-11-23 21:38:38
1552	2	538	2023-11-23 21:38:38	2023-11-23 21:38:38
1553	2	560	2023-11-23 21:38:38	2023-11-23 21:38:38
1554	2	561	2023-11-23 21:38:38	2023-11-23 21:38:38
1555	2	562	2023-11-23 21:38:38	2023-11-23 21:38:38
1556	2	563	2023-11-23 21:38:38	2023-11-23 21:38:38
1557	2	174	2023-11-23 21:38:38	2023-11-23 21:38:38
1558	2	176	2023-11-23 21:38:38	2023-11-23 21:38:38
1559	2	177	2023-11-23 21:38:38	2023-11-23 21:38:38
1560	2	178	2023-11-23 21:38:38	2023-11-23 21:38:38
1561	2	183	2023-11-23 21:38:38	2023-11-23 21:38:38
1562	2	184	2023-11-23 21:38:38	2023-11-23 21:38:38
1563	2	185	2023-11-23 21:38:38	2023-11-23 21:38:38
1564	2	186	2023-11-23 21:38:38	2023-11-23 21:38:38
1565	2	187	2023-11-23 21:38:38	2023-11-23 21:38:38
1566	2	188	2023-11-23 21:38:38	2023-11-23 21:38:38
1567	2	189	2023-11-23 21:38:38	2023-11-23 21:38:38
1568	2	190	2023-11-23 21:38:38	2023-11-23 21:38:38
1569	2	191	2023-11-23 21:38:38	2023-11-23 21:38:38
1570	2	192	2023-11-23 21:38:38	2023-11-23 21:38:38
1571	2	193	2023-11-23 21:38:38	2023-11-23 21:38:38
1572	2	194	2023-11-23 21:38:38	2023-11-23 21:38:38
1573	2	199	2023-11-23 21:38:38	2023-11-23 21:38:38
1574	2	200	2023-11-23 21:38:38	2023-11-23 21:38:38
1575	2	201	2023-11-23 21:38:38	2023-11-23 21:38:38
1576	2	202	2023-11-23 21:38:38	2023-11-23 21:38:38
1577	2	207	2023-11-23 21:38:38	2023-11-23 21:38:38
1578	2	208	2023-11-23 21:38:38	2023-11-23 21:38:38
1579	2	209	2023-11-23 21:38:38	2023-11-23 21:38:38
1580	2	210	2023-11-23 21:38:39	2023-11-23 21:38:39
1581	2	211	2023-11-23 21:38:39	2023-11-23 21:38:39
1582	2	381	2023-11-23 21:38:39	2023-11-23 21:38:39
1583	2	382	2023-11-23 21:38:39	2023-11-23 21:38:39
1584	2	383	2023-11-23 21:38:39	2023-11-23 21:38:39
1585	2	175	2023-11-23 21:38:39	2023-11-23 21:38:39
1586	2	218	2023-11-23 21:38:39	2023-11-23 21:38:39
1587	2	219	2023-11-23 21:38:39	2023-11-23 21:38:39
1588	2	220	2023-11-23 21:38:39	2023-11-23 21:38:39
1589	2	221	2023-11-23 21:38:39	2023-11-23 21:38:39
1590	2	222	2023-11-23 21:38:39	2023-11-23 21:38:39
1591	2	223	2023-11-23 21:38:39	2023-11-23 21:38:39
1592	2	533	2023-11-23 21:38:39	2023-11-23 21:38:39
1593	2	534	2023-11-23 21:38:39	2023-11-23 21:38:39
1594	2	539	2023-11-23 21:38:39	2023-11-23 21:38:39
1595	2	535	2023-11-23 21:38:39	2023-11-23 21:38:39
1596	3	14	2023-11-23 22:27:14	2023-11-23 22:27:14
1597	3	15	2023-11-23 22:27:14	2023-11-23 22:27:14
1598	3	16	2023-11-23 22:27:14	2023-11-23 22:27:14
1599	3	17	2023-11-23 22:27:14	2023-11-23 22:27:14
1600	3	18	2023-11-23 22:27:14	2023-11-23 22:27:14
1601	3	19	2023-11-23 22:27:14	2023-11-23 22:27:14
1602	3	20	2023-11-23 22:27:14	2023-11-23 22:27:14
1603	3	21	2023-11-23 22:27:14	2023-11-23 22:27:14
1604	3	22	2023-11-23 22:27:14	2023-11-23 22:27:14
1605	3	23	2023-11-23 22:27:14	2023-11-23 22:27:14
1606	3	584	2023-11-23 22:27:14	2023-11-23 22:27:14
1607	3	614	2023-11-23 22:27:14	2023-11-23 22:27:14
1608	3	615	2023-11-23 22:27:14	2023-11-23 22:27:14
1609	3	617	2023-11-23 22:27:14	2023-11-23 22:27:14
1610	3	224	2023-11-23 22:27:14	2023-11-23 22:27:14
1611	3	261	2023-11-23 22:27:14	2023-11-23 22:27:14
1612	3	225	2023-11-23 22:27:14	2023-11-23 22:27:14
1613	3	226	2023-11-23 22:27:14	2023-11-23 22:27:14
1614	3	227	2023-11-23 22:27:14	2023-11-23 22:27:14
1615	3	228	2023-11-23 22:27:14	2023-11-23 22:27:14
1616	3	229	2023-11-23 22:27:14	2023-11-23 22:27:14
1617	3	230	2023-11-23 22:27:14	2023-11-23 22:27:14
1618	3	231	2023-11-23 22:27:14	2023-11-23 22:27:14
1619	3	232	2023-11-23 22:27:14	2023-11-23 22:27:14
1620	3	233	2023-11-23 22:27:14	2023-11-23 22:27:14
1621	3	359	2023-11-23 22:27:14	2023-11-23 22:27:14
1622	3	360	2023-11-23 22:27:14	2023-11-23 22:27:14
1623	3	234	2023-11-23 22:27:14	2023-11-23 22:27:14
1624	3	235	2023-11-23 22:27:14	2023-11-23 22:27:14
1625	3	236	2023-11-23 22:27:14	2023-11-23 22:27:14
1626	3	237	2023-11-23 22:27:14	2023-11-23 22:27:14
1627	3	238	2023-11-23 22:27:14	2023-11-23 22:27:14
1628	3	239	2023-11-23 22:27:14	2023-11-23 22:27:14
1629	3	240	2023-11-23 22:27:14	2023-11-23 22:27:14
1630	3	241	2023-11-23 22:27:14	2023-11-23 22:27:14
1631	3	242	2023-11-23 22:27:14	2023-11-23 22:27:14
1632	3	243	2023-11-23 22:27:14	2023-11-23 22:27:14
1633	3	244	2023-11-23 22:27:14	2023-11-23 22:27:14
1634	3	245	2023-11-23 22:27:14	2023-11-23 22:27:14
1635	3	246	2023-11-23 22:27:14	2023-11-23 22:27:14
1636	3	247	2023-11-23 22:27:14	2023-11-23 22:27:14
1637	3	248	2023-11-23 22:27:14	2023-11-23 22:27:14
1638	3	253	2023-11-23 22:27:14	2023-11-23 22:27:14
1639	3	254	2023-11-23 22:27:14	2023-11-23 22:27:14
1640	3	255	2023-11-23 22:27:14	2023-11-23 22:27:14
1641	3	256	2023-11-23 22:27:14	2023-11-23 22:27:14
1642	3	257	2023-11-23 22:27:14	2023-11-23 22:27:14
1643	3	258	2023-11-23 22:27:14	2023-11-23 22:27:14
1644	3	259	2023-11-23 22:27:14	2023-11-23 22:27:14
1645	3	260	2023-11-23 22:27:14	2023-11-23 22:27:14
1646	3	262	2023-11-23 22:27:14	2023-11-23 22:27:14
1647	3	263	2023-11-23 22:27:14	2023-11-23 22:27:14
1648	3	264	2023-11-23 22:27:14	2023-11-23 22:27:14
1649	3	509	2023-11-23 22:27:14	2023-11-23 22:27:14
1650	3	265	2023-11-23 22:27:14	2023-11-23 22:27:14
1651	3	266	2023-11-23 22:27:14	2023-11-23 22:27:14
1652	3	267	2023-11-23 22:27:14	2023-11-23 22:27:14
1653	3	268	2023-11-23 22:27:14	2023-11-23 22:27:14
1654	3	269	2023-11-23 22:27:14	2023-11-23 22:27:14
1655	3	270	2023-11-23 22:27:14	2023-11-23 22:27:14
1656	3	271	2023-11-23 22:27:14	2023-11-23 22:27:14
1657	3	272	2023-11-23 22:27:14	2023-11-23 22:27:14
1658	3	273	2023-11-23 22:27:14	2023-11-23 22:27:14
1659	3	274	2023-11-23 22:27:14	2023-11-23 22:27:14
1660	3	275	2023-11-23 22:27:14	2023-11-23 22:27:14
1661	3	276	2023-11-23 22:27:14	2023-11-23 22:27:14
1662	3	277	2023-11-23 22:27:14	2023-11-23 22:27:14
1663	3	278	2023-11-23 22:27:14	2023-11-23 22:27:14
1664	3	279	2023-11-23 22:27:14	2023-11-23 22:27:14
1665	3	280	2023-11-23 22:27:14	2023-11-23 22:27:14
1666	3	281	2023-11-23 22:27:14	2023-11-23 22:27:14
1667	3	282	2023-11-23 22:27:14	2023-11-23 22:27:14
1668	3	283	2023-11-23 22:27:14	2023-11-23 22:27:14
1669	3	288	2023-11-23 22:27:14	2023-11-23 22:27:14
1670	3	289	2023-11-23 22:27:14	2023-11-23 22:27:14
1671	3	294	2023-11-23 22:27:14	2023-11-23 22:27:14
1672	3	295	2023-11-23 22:27:14	2023-11-23 22:27:14
1673	3	296	2023-11-23 22:27:14	2023-11-23 22:27:14
1674	3	297	2023-11-23 22:27:14	2023-11-23 22:27:14
1675	3	500	2023-11-23 22:27:14	2023-11-23 22:27:14
1676	3	501	2023-11-23 22:27:14	2023-11-23 22:27:14
1677	3	502	2023-11-23 22:27:14	2023-11-23 22:27:14
1678	3	510	2023-11-23 22:27:14	2023-11-23 22:27:14
1679	3	511	2023-11-23 22:27:14	2023-11-23 22:27:14
1680	3	512	2023-11-23 22:27:14	2023-11-23 22:27:14
1681	3	594	2023-11-23 22:27:14	2023-11-23 22:27:14
1682	3	298	2023-11-23 22:27:14	2023-11-23 22:27:14
1683	3	299	2023-11-23 22:27:14	2023-11-23 22:27:14
1684	3	25	2023-11-23 22:27:14	2023-11-23 22:27:14
1685	3	572	2023-11-23 22:27:14	2023-11-23 22:27:14
1686	3	573	2023-11-23 22:27:14	2023-11-23 22:27:14
1687	3	574	2023-11-23 22:27:14	2023-11-23 22:27:14
1688	3	575	2023-11-23 22:27:14	2023-11-23 22:27:14
1689	3	26	2023-11-23 22:27:14	2023-11-23 22:27:14
1690	3	27	2023-11-23 22:27:14	2023-11-23 22:27:14
1691	3	28	2023-11-23 22:27:14	2023-11-23 22:27:14
1692	3	29	2023-11-23 22:27:14	2023-11-23 22:27:14
1693	3	30	2023-11-23 22:27:14	2023-11-23 22:27:14
1694	3	31	2023-11-23 22:27:14	2023-11-23 22:27:14
1695	3	32	2023-11-23 22:27:14	2023-11-23 22:27:14
1696	3	33	2023-11-23 22:27:14	2023-11-23 22:27:14
1697	3	369	2023-11-23 22:27:14	2023-11-23 22:27:14
1698	3	370	2023-11-23 22:27:14	2023-11-23 22:27:14
1699	3	372	2023-11-23 22:27:14	2023-11-23 22:27:14
1700	3	373	2023-11-23 22:27:14	2023-11-23 22:27:14
1701	3	378	2023-11-23 22:27:14	2023-11-23 22:27:14
1702	3	395	2023-11-23 22:27:14	2023-11-23 22:27:14
1703	3	39	2023-11-23 22:27:14	2023-11-23 22:27:14
1704	3	379	2023-11-23 22:27:14	2023-11-23 22:27:14
1705	3	380	2023-11-23 22:27:14	2023-11-23 22:27:14
1706	3	34	2023-11-23 22:27:14	2023-11-23 22:27:14
1707	3	35	2023-11-23 22:27:15	2023-11-23 22:27:15
1708	3	36	2023-11-23 22:27:15	2023-11-23 22:27:15
1709	3	37	2023-11-23 22:27:15	2023-11-23 22:27:15
1710	3	38	2023-11-23 22:27:15	2023-11-23 22:27:15
1711	3	424	2023-11-23 22:27:15	2023-11-23 22:27:15
1712	3	425	2023-11-23 22:27:15	2023-11-23 22:27:15
1713	3	427	2023-11-23 22:27:15	2023-11-23 22:27:15
1714	3	443	2023-11-23 22:27:15	2023-11-23 22:27:15
1715	3	449	2023-11-23 22:27:15	2023-11-23 22:27:15
1716	3	452	2023-11-23 22:27:15	2023-11-23 22:27:15
1717	3	453	2023-11-23 22:27:15	2023-11-23 22:27:15
1718	3	454	2023-11-23 22:27:15	2023-11-23 22:27:15
1719	3	464	2023-11-23 22:27:15	2023-11-23 22:27:15
1720	3	450	2023-11-23 22:27:15	2023-11-23 22:27:15
1721	3	498	2023-11-23 22:27:15	2023-11-23 22:27:15
1722	3	499	2023-11-23 22:27:15	2023-11-23 22:27:15
1723	3	513	2023-11-23 22:27:15	2023-11-23 22:27:15
1724	3	514	2023-11-23 22:27:15	2023-11-23 22:27:15
1725	3	515	2023-11-23 22:27:15	2023-11-23 22:27:15
1726	3	516	2023-11-23 22:27:15	2023-11-23 22:27:15
1727	3	517	2023-11-23 22:27:15	2023-11-23 22:27:15
1728	3	518	2023-11-23 22:27:15	2023-11-23 22:27:15
1729	3	519	2023-11-23 22:27:15	2023-11-23 22:27:15
1730	3	520	2023-11-23 22:27:15	2023-11-23 22:27:15
1731	3	521	2023-11-23 22:27:15	2023-11-23 22:27:15
1732	3	522	2023-11-23 22:27:15	2023-11-23 22:27:15
1733	3	523	2023-11-23 22:27:15	2023-11-23 22:27:15
1734	3	524	2023-11-23 22:27:15	2023-11-23 22:27:15
1735	3	525	2023-11-23 22:27:15	2023-11-23 22:27:15
1736	3	526	2023-11-23 22:27:15	2023-11-23 22:27:15
1737	3	527	2023-11-23 22:27:15	2023-11-23 22:27:15
1738	3	528	2023-11-23 22:27:15	2023-11-23 22:27:15
1739	3	530	2023-11-23 22:27:15	2023-11-23 22:27:15
1740	3	531	2023-11-23 22:27:15	2023-11-23 22:27:15
1741	3	547	2023-11-23 22:27:15	2023-11-23 22:27:15
1742	3	548	2023-11-23 22:27:15	2023-11-23 22:27:15
1743	3	549	2023-11-23 22:27:15	2023-11-23 22:27:15
1744	3	550	2023-11-23 22:27:15	2023-11-23 22:27:15
1745	3	553	2023-11-23 22:27:15	2023-11-23 22:27:15
1746	3	554	2023-11-23 22:27:15	2023-11-23 22:27:15
1747	3	586	2023-11-23 22:27:15	2023-11-23 22:27:15
1748	3	588	2023-11-23 22:27:15	2023-11-23 22:27:15
1749	3	589	2023-11-23 22:27:15	2023-11-23 22:27:15
1750	3	593	2023-11-23 22:27:15	2023-11-23 22:27:15
1751	3	616	2023-11-23 22:27:15	2023-11-23 22:27:15
1752	3	40	2023-11-23 22:27:15	2023-11-23 22:27:15
1753	3	44	2023-11-23 22:27:15	2023-11-23 22:27:15
1754	3	45	2023-11-23 22:27:15	2023-11-23 22:27:15
1755	3	46	2023-11-23 22:27:15	2023-11-23 22:27:15
1756	3	47	2023-11-23 22:27:15	2023-11-23 22:27:15
1757	3	48	2023-11-23 22:27:15	2023-11-23 22:27:15
1758	3	49	2023-11-23 22:27:15	2023-11-23 22:27:15
1759	3	51	2023-11-23 22:27:15	2023-11-23 22:27:15
1760	3	52	2023-11-23 22:27:15	2023-11-23 22:27:15
1761	3	384	2023-11-23 22:27:15	2023-11-23 22:27:15
1762	3	41	2023-11-23 22:27:15	2023-11-23 22:27:15
1763	3	42	2023-11-23 22:27:15	2023-11-23 22:27:15
1764	3	43	2023-11-23 22:27:15	2023-11-23 22:27:15
1765	3	587	2023-11-23 22:27:15	2023-11-23 22:27:15
1766	3	592	2023-11-23 22:27:15	2023-11-23 22:27:15
1767	3	53	2023-11-23 22:27:15	2023-11-23 22:27:15
1768	3	54	2023-11-23 22:27:15	2023-11-23 22:27:15
1769	3	55	2023-11-23 22:27:15	2023-11-23 22:27:15
1770	3	56	2023-11-23 22:27:15	2023-11-23 22:27:15
1771	3	57	2023-11-23 22:27:15	2023-11-23 22:27:15
1772	3	58	2023-11-23 22:27:15	2023-11-23 22:27:15
1773	3	59	2023-11-23 22:27:15	2023-11-23 22:27:15
1774	3	60	2023-11-23 22:27:15	2023-11-23 22:27:15
1775	3	61	2023-11-23 22:27:15	2023-11-23 22:27:15
1776	3	62	2023-11-23 22:27:15	2023-11-23 22:27:15
1777	3	63	2023-11-23 22:27:15	2023-11-23 22:27:15
1778	3	64	2023-11-23 22:27:15	2023-11-23 22:27:15
1779	3	65	2023-11-23 22:27:15	2023-11-23 22:27:15
1780	3	66	2023-11-23 22:27:15	2023-11-23 22:27:15
1781	3	67	2023-11-23 22:27:15	2023-11-23 22:27:15
1782	3	68	2023-11-23 22:27:15	2023-11-23 22:27:15
1783	3	69	2023-11-23 22:27:15	2023-11-23 22:27:15
1784	3	70	2023-11-23 22:27:15	2023-11-23 22:27:15
1785	3	71	2023-11-23 22:27:15	2023-11-23 22:27:15
1786	3	72	2023-11-23 22:27:15	2023-11-23 22:27:15
1787	3	73	2023-11-23 22:27:15	2023-11-23 22:27:15
1788	3	74	2023-11-23 22:27:15	2023-11-23 22:27:15
1789	3	75	2023-11-23 22:27:15	2023-11-23 22:27:15
1790	3	76	2023-11-23 22:27:15	2023-11-23 22:27:15
1791	3	77	2023-11-23 22:27:15	2023-11-23 22:27:15
1792	3	451	2023-11-23 22:27:15	2023-11-23 22:27:15
1793	3	477	2023-11-23 22:27:15	2023-11-23 22:27:15
1794	3	585	2023-11-23 22:27:15	2023-11-23 22:27:15
1795	3	78	2023-11-23 22:27:15	2023-11-23 22:27:15
1796	3	79	2023-11-23 22:27:15	2023-11-23 22:27:15
1797	3	80	2023-11-23 22:27:15	2023-11-23 22:27:15
1798	3	81	2023-11-23 22:27:15	2023-11-23 22:27:15
1799	3	82	2023-11-23 22:27:15	2023-11-23 22:27:15
1800	3	83	2023-11-23 22:27:15	2023-11-23 22:27:15
1801	3	84	2023-11-23 22:27:15	2023-11-23 22:27:15
1802	3	85	2023-11-23 22:27:15	2023-11-23 22:27:15
1803	3	86	2023-11-23 22:27:15	2023-11-23 22:27:15
1804	3	87	2023-11-23 22:27:15	2023-11-23 22:27:15
1805	3	88	2023-11-23 22:27:16	2023-11-23 22:27:16
1806	3	89	2023-11-23 22:27:16	2023-11-23 22:27:16
1807	3	90	2023-11-23 22:27:16	2023-11-23 22:27:16
1808	3	91	2023-11-23 22:27:16	2023-11-23 22:27:16
1809	3	374	2023-11-23 22:27:16	2023-11-23 22:27:16
1810	3	375	2023-11-23 22:27:16	2023-11-23 22:27:16
1811	3	397	2023-11-23 22:27:16	2023-11-23 22:27:16
1812	3	398	2023-11-23 22:27:16	2023-11-23 22:27:16
1813	3	541	2023-11-23 22:27:16	2023-11-23 22:27:16
1814	3	543	2023-11-23 22:27:16	2023-11-23 22:27:16
1815	3	545	2023-11-23 22:27:16	2023-11-23 22:27:16
1816	3	571	2023-11-23 22:27:16	2023-11-23 22:27:16
1817	3	95	2023-11-23 22:27:16	2023-11-23 22:27:16
1818	3	96	2023-11-23 22:27:16	2023-11-23 22:27:16
1819	3	97	2023-11-23 22:27:16	2023-11-23 22:27:16
1820	3	98	2023-11-23 22:27:16	2023-11-23 22:27:16
1821	3	99	2023-11-23 22:27:16	2023-11-23 22:27:16
1822	3	100	2023-11-23 22:27:16	2023-11-23 22:27:16
1823	3	101	2023-11-23 22:27:16	2023-11-23 22:27:16
1824	3	102	2023-11-23 22:27:16	2023-11-23 22:27:16
1825	3	103	2023-11-23 22:27:16	2023-11-23 22:27:16
1826	3	104	2023-11-23 22:27:16	2023-11-23 22:27:16
1827	3	361	2023-11-23 22:27:16	2023-11-23 22:27:16
1828	3	362	2023-11-23 22:27:16	2023-11-23 22:27:16
1829	3	363	2023-11-23 22:27:16	2023-11-23 22:27:16
1830	3	364	2023-11-23 22:27:16	2023-11-23 22:27:16
1831	3	366	2023-11-23 22:27:16	2023-11-23 22:27:16
1832	3	376	2023-11-23 22:27:16	2023-11-23 22:27:16
1833	3	377	2023-11-23 22:27:16	2023-11-23 22:27:16
1834	3	105	2023-11-23 22:27:16	2023-11-23 22:27:16
1835	3	106	2023-11-23 22:27:16	2023-11-23 22:27:16
1836	3	107	2023-11-23 22:27:16	2023-11-23 22:27:16
1837	3	108	2023-11-23 22:27:16	2023-11-23 22:27:16
1838	3	109	2023-11-23 22:27:16	2023-11-23 22:27:16
1839	3	110	2023-11-23 22:27:16	2023-11-23 22:27:16
1840	3	111	2023-11-23 22:27:16	2023-11-23 22:27:16
1841	3	112	2023-11-23 22:27:16	2023-11-23 22:27:16
1842	3	113	2023-11-23 22:27:16	2023-11-23 22:27:16
1843	3	117	2023-11-23 22:27:16	2023-11-23 22:27:16
1844	3	428	2023-11-23 22:27:16	2023-11-23 22:27:16
1845	3	429	2023-11-23 22:27:16	2023-11-23 22:27:16
1846	3	430	2023-11-23 22:27:16	2023-11-23 22:27:16
1847	3	431	2023-11-23 22:27:16	2023-11-23 22:27:16
1848	3	507	2023-11-23 22:27:16	2023-11-23 22:27:16
1849	3	532	2023-11-23 22:27:16	2023-11-23 22:27:16
1850	3	540	2023-11-23 22:27:16	2023-11-23 22:27:16
1851	3	542	2023-11-23 22:27:16	2023-11-23 22:27:16
1852	3	544	2023-11-23 22:27:16	2023-11-23 22:27:16
1853	3	564	2023-11-23 22:27:16	2023-11-23 22:27:16
1854	3	565	2023-11-23 22:27:16	2023-11-23 22:27:16
1855	3	566	2023-11-23 22:27:16	2023-11-23 22:27:16
1856	3	118	2023-11-23 22:27:16	2023-11-23 22:27:16
1857	3	119	2023-11-23 22:27:16	2023-11-23 22:27:16
1858	3	120	2023-11-23 22:27:16	2023-11-23 22:27:16
1859	3	121	2023-11-23 22:27:16	2023-11-23 22:27:16
1860	3	122	2023-11-23 22:27:16	2023-11-23 22:27:16
1861	3	126	2023-11-23 22:27:16	2023-11-23 22:27:16
1862	3	127	2023-11-23 22:27:16	2023-11-23 22:27:16
1863	3	128	2023-11-23 22:27:16	2023-11-23 22:27:16
1864	3	129	2023-11-23 22:27:16	2023-11-23 22:27:16
1865	3	329	2023-11-23 22:27:16	2023-11-23 22:27:16
1866	3	330	2023-11-23 22:27:16	2023-11-23 22:27:16
1867	3	331	2023-11-23 22:27:16	2023-11-23 22:27:16
1868	3	332	2023-11-23 22:27:16	2023-11-23 22:27:16
1869	3	134	2023-11-23 22:27:16	2023-11-23 22:27:16
1870	3	135	2023-11-23 22:27:16	2023-11-23 22:27:16
1871	3	136	2023-11-23 22:27:16	2023-11-23 22:27:16
1872	3	137	2023-11-23 22:27:16	2023-11-23 22:27:16
1873	3	138	2023-11-23 22:27:16	2023-11-23 22:27:16
1874	3	139	2023-11-23 22:27:16	2023-11-23 22:27:16
1875	3	140	2023-11-23 22:27:16	2023-11-23 22:27:16
1876	3	141	2023-11-23 22:27:17	2023-11-23 22:27:17
1877	3	143	2023-11-23 22:27:17	2023-11-23 22:27:17
1878	3	144	2023-11-23 22:27:17	2023-11-23 22:27:17
1879	3	145	2023-11-23 22:27:17	2023-11-23 22:27:17
1880	3	146	2023-11-23 22:27:17	2023-11-23 22:27:17
1881	3	147	2023-11-23 22:27:17	2023-11-23 22:27:17
1882	3	148	2023-11-23 22:27:17	2023-11-23 22:27:17
1883	3	149	2023-11-23 22:27:17	2023-11-23 22:27:17
1884	3	152	2023-11-23 22:27:17	2023-11-23 22:27:17
1885	3	153	2023-11-23 22:27:17	2023-11-23 22:27:17
1886	3	154	2023-11-23 22:27:17	2023-11-23 22:27:17
1887	3	155	2023-11-23 22:27:17	2023-11-23 22:27:17
1888	3	156	2023-11-23 22:27:17	2023-11-23 22:27:17
1889	3	157	2023-11-23 22:27:17	2023-11-23 22:27:17
1890	3	158	2023-11-23 22:27:17	2023-11-23 22:27:17
1891	3	159	2023-11-23 22:27:17	2023-11-23 22:27:17
1892	3	160	2023-11-23 22:27:17	2023-11-23 22:27:17
1893	3	161	2023-11-23 22:27:17	2023-11-23 22:27:17
1894	3	162	2023-11-23 22:27:17	2023-11-23 22:27:17
1895	3	163	2023-11-23 22:27:17	2023-11-23 22:27:17
1896	3	164	2023-11-23 22:27:17	2023-11-23 22:27:17
1897	3	165	2023-11-23 22:27:17	2023-11-23 22:27:17
1898	3	166	2023-11-23 22:27:17	2023-11-23 22:27:17
1899	3	167	2023-11-23 22:27:17	2023-11-23 22:27:17
1900	3	168	2023-11-23 22:27:17	2023-11-23 22:27:17
1901	3	169	2023-11-23 22:27:17	2023-11-23 22:27:17
1902	3	170	2023-11-23 22:27:17	2023-11-23 22:27:17
1903	3	171	2023-11-23 22:27:17	2023-11-23 22:27:17
1904	3	172	2023-11-23 22:27:17	2023-11-23 22:27:17
1905	3	173	2023-11-23 22:27:17	2023-11-23 22:27:17
1906	3	426	2023-11-23 22:27:17	2023-11-23 22:27:17
1907	3	536	2023-11-23 22:27:17	2023-11-23 22:27:17
1908	3	537	2023-11-23 22:27:17	2023-11-23 22:27:17
1909	3	538	2023-11-23 22:27:17	2023-11-23 22:27:17
1910	3	560	2023-11-23 22:27:17	2023-11-23 22:27:17
1911	3	561	2023-11-23 22:27:17	2023-11-23 22:27:17
1912	3	562	2023-11-23 22:27:17	2023-11-23 22:27:17
1913	3	563	2023-11-23 22:27:17	2023-11-23 22:27:17
1914	3	174	2023-11-23 22:27:17	2023-11-23 22:27:17
1915	3	176	2023-11-23 22:27:17	2023-11-23 22:27:17
1916	3	177	2023-11-23 22:27:17	2023-11-23 22:27:17
1917	3	178	2023-11-23 22:27:17	2023-11-23 22:27:17
1918	3	179	2023-11-23 22:27:17	2023-11-23 22:27:17
1919	3	180	2023-11-23 22:27:17	2023-11-23 22:27:17
1920	3	181	2023-11-23 22:27:17	2023-11-23 22:27:17
1921	3	182	2023-11-23 22:27:17	2023-11-23 22:27:17
1922	3	183	2023-11-23 22:27:17	2023-11-23 22:27:17
1923	3	184	2023-11-23 22:27:17	2023-11-23 22:27:17
1924	3	185	2023-11-23 22:27:17	2023-11-23 22:27:17
1925	3	186	2023-11-23 22:27:17	2023-11-23 22:27:17
1926	3	187	2023-11-23 22:27:17	2023-11-23 22:27:17
1927	3	188	2023-11-23 22:27:17	2023-11-23 22:27:17
1928	3	189	2023-11-23 22:27:17	2023-11-23 22:27:17
1929	3	190	2023-11-23 22:27:17	2023-11-23 22:27:17
1930	3	191	2023-11-23 22:27:17	2023-11-23 22:27:17
1931	3	192	2023-11-23 22:27:17	2023-11-23 22:27:17
1932	3	193	2023-11-23 22:27:17	2023-11-23 22:27:17
1933	3	194	2023-11-23 22:27:17	2023-11-23 22:27:17
1934	3	195	2023-11-23 22:27:17	2023-11-23 22:27:17
1935	3	196	2023-11-23 22:27:17	2023-11-23 22:27:17
1936	3	197	2023-11-23 22:27:17	2023-11-23 22:27:17
1937	3	198	2023-11-23 22:27:17	2023-11-23 22:27:17
1938	3	199	2023-11-23 22:27:17	2023-11-23 22:27:17
1939	3	200	2023-11-23 22:27:17	2023-11-23 22:27:17
1940	3	201	2023-11-23 22:27:17	2023-11-23 22:27:17
1941	3	202	2023-11-23 22:27:17	2023-11-23 22:27:17
1942	3	207	2023-11-23 22:27:18	2023-11-23 22:27:18
1943	3	208	2023-11-23 22:27:18	2023-11-23 22:27:18
1944	3	209	2023-11-23 22:27:18	2023-11-23 22:27:18
1945	3	210	2023-11-23 22:27:18	2023-11-23 22:27:18
1946	3	211	2023-11-23 22:27:18	2023-11-23 22:27:18
1947	3	212	2023-11-23 22:27:18	2023-11-23 22:27:18
1948	3	213	2023-11-23 22:27:18	2023-11-23 22:27:18
1949	3	215	2023-11-23 22:27:18	2023-11-23 22:27:18
1950	3	335	2023-11-23 22:27:18	2023-11-23 22:27:18
1951	3	336	2023-11-23 22:27:18	2023-11-23 22:27:18
1952	3	337	2023-11-23 22:27:18	2023-11-23 22:27:18
1953	3	338	2023-11-23 22:27:18	2023-11-23 22:27:18
1954	3	381	2023-11-23 22:27:18	2023-11-23 22:27:18
1955	3	382	2023-11-23 22:27:18	2023-11-23 22:27:18
1956	3	383	2023-11-23 22:27:18	2023-11-23 22:27:18
1957	3	175	2023-11-23 22:27:18	2023-11-23 22:27:18
1958	3	214	2023-11-23 22:27:18	2023-11-23 22:27:18
1959	3	216	2023-11-23 22:27:18	2023-11-23 22:27:18
1960	3	217	2023-11-23 22:27:18	2023-11-23 22:27:18
1961	3	218	2023-11-23 22:27:18	2023-11-23 22:27:18
1962	3	219	2023-11-23 22:27:18	2023-11-23 22:27:18
1963	3	220	2023-11-23 22:27:18	2023-11-23 22:27:18
1964	3	221	2023-11-23 22:27:18	2023-11-23 22:27:18
1965	3	222	2023-11-23 22:27:18	2023-11-23 22:27:18
1966	3	223	2023-11-23 22:27:18	2023-11-23 22:27:18
1967	3	533	2023-11-23 22:27:18	2023-11-23 22:27:18
1968	3	534	2023-11-23 22:27:18	2023-11-23 22:27:18
1969	3	539	2023-11-23 22:27:18	2023-11-23 22:27:18
1970	3	535	2023-11-23 22:27:18	2023-11-23 22:27:18
1971	4	14	2023-11-23 22:44:04	2023-11-23 22:44:04
1972	4	15	2023-11-23 22:44:04	2023-11-23 22:44:04
1973	4	16	2023-11-23 22:44:04	2023-11-23 22:44:04
1974	4	17	2023-11-23 22:44:04	2023-11-23 22:44:04
1975	4	18	2023-11-23 22:44:04	2023-11-23 22:44:04
1976	4	19	2023-11-23 22:44:04	2023-11-23 22:44:04
1977	4	20	2023-11-23 22:44:04	2023-11-23 22:44:04
1978	4	21	2023-11-23 22:44:04	2023-11-23 22:44:04
1979	4	22	2023-11-23 22:44:04	2023-11-23 22:44:04
1980	4	23	2023-11-23 22:44:04	2023-11-23 22:44:04
1981	4	24	2023-11-23 22:44:04	2023-11-23 22:44:04
1982	4	448	2023-11-23 22:44:04	2023-11-23 22:44:04
1983	4	441	2023-11-23 22:44:04	2023-11-23 22:44:04
1984	4	442	2023-11-23 22:44:04	2023-11-23 22:44:04
1985	4	546	2023-11-23 22:44:04	2023-11-23 22:44:04
1986	4	584	2023-11-23 22:44:04	2023-11-23 22:44:04
1987	4	614	2023-11-23 22:44:04	2023-11-23 22:44:04
1988	4	615	2023-11-23 22:44:04	2023-11-23 22:44:04
1989	4	617	2023-11-23 22:44:04	2023-11-23 22:44:04
1990	4	618	2023-11-23 22:44:04	2023-11-23 22:44:04
1991	4	224	2023-11-23 22:44:04	2023-11-23 22:44:04
1992	4	261	2023-11-23 22:44:04	2023-11-23 22:44:04
1993	4	225	2023-11-23 22:44:04	2023-11-23 22:44:04
1994	4	226	2023-11-23 22:44:04	2023-11-23 22:44:04
1995	4	227	2023-11-23 22:44:04	2023-11-23 22:44:04
1996	4	228	2023-11-23 22:44:04	2023-11-23 22:44:04
1997	4	229	2023-11-23 22:44:04	2023-11-23 22:44:04
1998	4	230	2023-11-23 22:44:04	2023-11-23 22:44:04
1999	4	231	2023-11-23 22:44:04	2023-11-23 22:44:04
2000	4	232	2023-11-23 22:44:04	2023-11-23 22:44:04
2001	4	233	2023-11-23 22:44:04	2023-11-23 22:44:04
2002	4	359	2023-11-23 22:44:04	2023-11-23 22:44:04
2003	4	360	2023-11-23 22:44:04	2023-11-23 22:44:04
2004	4	234	2023-11-23 22:44:04	2023-11-23 22:44:04
2005	4	235	2023-11-23 22:44:04	2023-11-23 22:44:04
2006	4	236	2023-11-23 22:44:04	2023-11-23 22:44:04
2007	4	237	2023-11-23 22:44:04	2023-11-23 22:44:04
2008	4	238	2023-11-23 22:44:04	2023-11-23 22:44:04
2009	4	239	2023-11-23 22:44:04	2023-11-23 22:44:04
2010	4	240	2023-11-23 22:44:04	2023-11-23 22:44:04
2011	4	241	2023-11-23 22:44:04	2023-11-23 22:44:04
2012	4	242	2023-11-23 22:44:04	2023-11-23 22:44:04
2013	4	243	2023-11-23 22:44:04	2023-11-23 22:44:04
2014	4	244	2023-11-23 22:44:04	2023-11-23 22:44:04
2015	4	245	2023-11-23 22:44:05	2023-11-23 22:44:05
2016	4	246	2023-11-23 22:44:05	2023-11-23 22:44:05
2017	4	247	2023-11-23 22:44:05	2023-11-23 22:44:05
2018	4	248	2023-11-23 22:44:05	2023-11-23 22:44:05
2019	4	249	2023-11-23 22:44:05	2023-11-23 22:44:05
2020	4	250	2023-11-23 22:44:05	2023-11-23 22:44:05
2021	4	251	2023-11-23 22:44:05	2023-11-23 22:44:05
2022	4	252	2023-11-23 22:44:05	2023-11-23 22:44:05
2023	4	253	2023-11-23 22:44:05	2023-11-23 22:44:05
2024	4	254	2023-11-23 22:44:05	2023-11-23 22:44:05
2025	4	255	2023-11-23 22:44:05	2023-11-23 22:44:05
2026	4	256	2023-11-23 22:44:05	2023-11-23 22:44:05
2027	4	257	2023-11-23 22:44:05	2023-11-23 22:44:05
2028	4	258	2023-11-23 22:44:05	2023-11-23 22:44:05
2029	4	259	2023-11-23 22:44:05	2023-11-23 22:44:05
2030	4	260	2023-11-23 22:44:05	2023-11-23 22:44:05
2031	4	262	2023-11-23 22:44:05	2023-11-23 22:44:05
2032	4	263	2023-11-23 22:44:05	2023-11-23 22:44:05
2033	4	264	2023-11-23 22:44:05	2023-11-23 22:44:05
2034	4	509	2023-11-23 22:44:05	2023-11-23 22:44:05
2035	4	265	2023-11-23 22:44:05	2023-11-23 22:44:05
2036	4	266	2023-11-23 22:44:05	2023-11-23 22:44:05
2037	4	267	2023-11-23 22:44:05	2023-11-23 22:44:05
2038	4	268	2023-11-23 22:44:05	2023-11-23 22:44:05
2039	4	269	2023-11-23 22:44:05	2023-11-23 22:44:05
2040	4	270	2023-11-23 22:44:05	2023-11-23 22:44:05
2041	4	271	2023-11-23 22:44:05	2023-11-23 22:44:05
2042	4	272	2023-11-23 22:44:05	2023-11-23 22:44:05
2043	4	273	2023-11-23 22:44:05	2023-11-23 22:44:05
2044	4	274	2023-11-23 22:44:05	2023-11-23 22:44:05
2045	4	275	2023-11-23 22:44:05	2023-11-23 22:44:05
2046	4	276	2023-11-23 22:44:05	2023-11-23 22:44:05
2047	4	277	2023-11-23 22:44:05	2023-11-23 22:44:05
2048	4	278	2023-11-23 22:44:05	2023-11-23 22:44:05
2049	4	279	2023-11-23 22:44:05	2023-11-23 22:44:05
2050	4	280	2023-11-23 22:44:05	2023-11-23 22:44:05
2051	4	281	2023-11-23 22:44:05	2023-11-23 22:44:05
2052	4	282	2023-11-23 22:44:05	2023-11-23 22:44:05
2053	4	283	2023-11-23 22:44:05	2023-11-23 22:44:05
2054	4	284	2023-11-23 22:44:05	2023-11-23 22:44:05
2055	4	285	2023-11-23 22:44:05	2023-11-23 22:44:05
2056	4	286	2023-11-23 22:44:05	2023-11-23 22:44:05
2057	4	287	2023-11-23 22:44:05	2023-11-23 22:44:05
2058	4	288	2023-11-23 22:44:05	2023-11-23 22:44:05
2059	4	289	2023-11-23 22:44:05	2023-11-23 22:44:05
2060	4	294	2023-11-23 22:44:05	2023-11-23 22:44:05
2061	4	295	2023-11-23 22:44:05	2023-11-23 22:44:05
2062	4	296	2023-11-23 22:44:05	2023-11-23 22:44:05
2063	4	297	2023-11-23 22:44:05	2023-11-23 22:44:05
2064	4	500	2023-11-23 22:44:05	2023-11-23 22:44:05
2065	4	501	2023-11-23 22:44:05	2023-11-23 22:44:05
2066	4	502	2023-11-23 22:44:05	2023-11-23 22:44:05
2067	4	510	2023-11-23 22:44:05	2023-11-23 22:44:05
2068	4	511	2023-11-23 22:44:05	2023-11-23 22:44:05
2069	4	512	2023-11-23 22:44:05	2023-11-23 22:44:05
2070	4	567	2023-11-23 22:44:05	2023-11-23 22:44:05
2071	4	594	2023-11-23 22:44:05	2023-11-23 22:44:05
2072	4	298	2023-11-23 22:44:05	2023-11-23 22:44:05
2073	4	299	2023-11-23 22:44:05	2023-11-23 22:44:05
2074	4	465	2023-11-23 22:44:05	2023-11-23 22:44:05
2075	4	466	2023-11-23 22:44:05	2023-11-23 22:44:05
2076	4	467	2023-11-23 22:44:05	2023-11-23 22:44:05
2077	4	468	2023-11-23 22:44:05	2023-11-23 22:44:05
2078	4	469	2023-11-23 22:44:05	2023-11-23 22:44:05
2079	4	470	2023-11-23 22:44:05	2023-11-23 22:44:05
2080	4	471	2023-11-23 22:44:05	2023-11-23 22:44:05
2081	4	472	2023-11-23 22:44:05	2023-11-23 22:44:05
2082	4	473	2023-11-23 22:44:05	2023-11-23 22:44:05
2083	4	474	2023-11-23 22:44:05	2023-11-23 22:44:05
2084	4	476	2023-11-23 22:44:05	2023-11-23 22:44:05
2085	4	478	2023-11-23 22:44:05	2023-11-23 22:44:05
2086	4	479	2023-11-23 22:44:05	2023-11-23 22:44:05
2087	4	475	2023-11-23 22:44:06	2023-11-23 22:44:06
2088	4	572	2023-11-23 22:44:06	2023-11-23 22:44:06
2089	4	573	2023-11-23 22:44:06	2023-11-23 22:44:06
2090	4	574	2023-11-23 22:44:06	2023-11-23 22:44:06
2091	4	575	2023-11-23 22:44:06	2023-11-23 22:44:06
2092	4	26	2023-11-23 22:44:06	2023-11-23 22:44:06
2093	4	27	2023-11-23 22:44:07	2023-11-23 22:44:07
2094	4	28	2023-11-23 22:44:07	2023-11-23 22:44:07
2095	4	29	2023-11-23 22:44:07	2023-11-23 22:44:07
2096	4	30	2023-11-23 22:44:07	2023-11-23 22:44:07
2097	4	31	2023-11-23 22:44:07	2023-11-23 22:44:07
2098	4	32	2023-11-23 22:44:07	2023-11-23 22:44:07
2099	4	33	2023-11-23 22:44:07	2023-11-23 22:44:07
2100	4	367	2023-11-23 22:44:07	2023-11-23 22:44:07
2101	4	368	2023-11-23 22:44:07	2023-11-23 22:44:07
2102	4	369	2023-11-23 22:44:07	2023-11-23 22:44:07
2103	4	370	2023-11-23 22:44:07	2023-11-23 22:44:07
2104	4	371	2023-11-23 22:44:07	2023-11-23 22:44:07
2105	4	372	2023-11-23 22:44:07	2023-11-23 22:44:07
2106	4	373	2023-11-23 22:44:07	2023-11-23 22:44:07
2107	4	378	2023-11-23 22:44:07	2023-11-23 22:44:07
2108	4	395	2023-11-23 22:44:07	2023-11-23 22:44:07
2109	4	39	2023-11-23 22:44:07	2023-11-23 22:44:07
2110	4	379	2023-11-23 22:44:07	2023-11-23 22:44:07
2111	4	380	2023-11-23 22:44:07	2023-11-23 22:44:07
2112	4	34	2023-11-23 22:44:07	2023-11-23 22:44:07
2113	4	35	2023-11-23 22:44:07	2023-11-23 22:44:07
2114	4	36	2023-11-23 22:44:07	2023-11-23 22:44:07
2115	4	37	2023-11-23 22:44:07	2023-11-23 22:44:07
2116	4	38	2023-11-23 22:44:07	2023-11-23 22:44:07
2117	4	424	2023-11-23 22:44:07	2023-11-23 22:44:07
2118	4	425	2023-11-23 22:44:07	2023-11-23 22:44:07
2119	4	427	2023-11-23 22:44:07	2023-11-23 22:44:07
2120	4	443	2023-11-23 22:44:07	2023-11-23 22:44:07
2121	4	449	2023-11-23 22:44:07	2023-11-23 22:44:07
2122	4	452	2023-11-23 22:44:07	2023-11-23 22:44:07
2123	4	453	2023-11-23 22:44:07	2023-11-23 22:44:07
2124	4	454	2023-11-23 22:44:07	2023-11-23 22:44:07
2125	4	464	2023-11-23 22:44:07	2023-11-23 22:44:07
2126	4	450	2023-11-23 22:44:07	2023-11-23 22:44:07
2127	4	498	2023-11-23 22:44:07	2023-11-23 22:44:07
2128	4	499	2023-11-23 22:44:07	2023-11-23 22:44:07
2129	4	513	2023-11-23 22:44:07	2023-11-23 22:44:07
2130	4	514	2023-11-23 22:44:07	2023-11-23 22:44:07
2131	4	515	2023-11-23 22:44:07	2023-11-23 22:44:07
2132	4	516	2023-11-23 22:44:07	2023-11-23 22:44:07
2133	4	517	2023-11-23 22:44:07	2023-11-23 22:44:07
2134	4	518	2023-11-23 22:44:07	2023-11-23 22:44:07
2135	4	519	2023-11-23 22:44:07	2023-11-23 22:44:07
2136	4	520	2023-11-23 22:44:07	2023-11-23 22:44:07
2137	4	521	2023-11-23 22:44:07	2023-11-23 22:44:07
2138	4	522	2023-11-23 22:44:07	2023-11-23 22:44:07
2139	4	523	2023-11-23 22:44:07	2023-11-23 22:44:07
2140	4	524	2023-11-23 22:44:07	2023-11-23 22:44:07
2141	4	525	2023-11-23 22:44:07	2023-11-23 22:44:07
2142	4	526	2023-11-23 22:44:07	2023-11-23 22:44:07
2143	4	528	2023-11-23 22:44:07	2023-11-23 22:44:07
2144	4	529	2023-11-23 22:44:07	2023-11-23 22:44:07
2145	4	530	2023-11-23 22:44:07	2023-11-23 22:44:07
2146	4	531	2023-11-23 22:44:07	2023-11-23 22:44:07
2147	4	547	2023-11-23 22:44:07	2023-11-23 22:44:07
2148	4	548	2023-11-23 22:44:07	2023-11-23 22:44:07
2149	4	549	2023-11-23 22:44:07	2023-11-23 22:44:07
2150	4	550	2023-11-23 22:44:07	2023-11-23 22:44:07
2151	4	553	2023-11-23 22:44:07	2023-11-23 22:44:07
2152	4	554	2023-11-23 22:44:07	2023-11-23 22:44:07
2153	4	586	2023-11-23 22:44:07	2023-11-23 22:44:07
2154	4	588	2023-11-23 22:44:07	2023-11-23 22:44:07
2155	4	589	2023-11-23 22:44:07	2023-11-23 22:44:07
2156	4	590	2023-11-23 22:44:07	2023-11-23 22:44:07
2157	4	591	2023-11-23 22:44:07	2023-11-23 22:44:07
2158	4	593	2023-11-23 22:44:07	2023-11-23 22:44:07
2159	4	616	2023-11-23 22:44:07	2023-11-23 22:44:07
2160	4	40	2023-11-23 22:44:07	2023-11-23 22:44:07
2161	4	44	2023-11-23 22:44:07	2023-11-23 22:44:07
2162	4	45	2023-11-23 22:44:07	2023-11-23 22:44:07
2163	4	46	2023-11-23 22:44:07	2023-11-23 22:44:07
2164	4	47	2023-11-23 22:44:07	2023-11-23 22:44:07
2165	4	48	2023-11-23 22:44:07	2023-11-23 22:44:07
2166	4	49	2023-11-23 22:44:07	2023-11-23 22:44:07
2167	4	50	2023-11-23 22:44:07	2023-11-23 22:44:07
2168	4	51	2023-11-23 22:44:07	2023-11-23 22:44:07
2169	4	52	2023-11-23 22:44:07	2023-11-23 22:44:07
2170	4	384	2023-11-23 22:44:07	2023-11-23 22:44:07
2171	4	41	2023-11-23 22:44:07	2023-11-23 22:44:07
2172	4	42	2023-11-23 22:44:07	2023-11-23 22:44:07
2173	4	43	2023-11-23 22:44:07	2023-11-23 22:44:07
2174	4	587	2023-11-23 22:44:07	2023-11-23 22:44:07
2175	4	592	2023-11-23 22:44:07	2023-11-23 22:44:07
2176	4	53	2023-11-23 22:44:07	2023-11-23 22:44:07
2177	4	54	2023-11-23 22:44:07	2023-11-23 22:44:07
2178	4	55	2023-11-23 22:44:07	2023-11-23 22:44:07
2179	4	56	2023-11-23 22:44:07	2023-11-23 22:44:07
2180	4	57	2023-11-23 22:44:07	2023-11-23 22:44:07
2181	4	58	2023-11-23 22:44:07	2023-11-23 22:44:07
2182	4	59	2023-11-23 22:44:07	2023-11-23 22:44:07
2183	4	60	2023-11-23 22:44:07	2023-11-23 22:44:07
2184	4	61	2023-11-23 22:44:08	2023-11-23 22:44:08
2185	4	62	2023-11-23 22:44:08	2023-11-23 22:44:08
2186	4	63	2023-11-23 22:44:08	2023-11-23 22:44:08
2187	4	64	2023-11-23 22:44:08	2023-11-23 22:44:08
2188	4	65	2023-11-23 22:44:08	2023-11-23 22:44:08
2189	4	66	2023-11-23 22:44:08	2023-11-23 22:44:08
2190	4	67	2023-11-23 22:44:08	2023-11-23 22:44:08
2191	4	68	2023-11-23 22:44:08	2023-11-23 22:44:08
2192	4	69	2023-11-23 22:44:08	2023-11-23 22:44:08
2193	4	70	2023-11-23 22:44:08	2023-11-23 22:44:08
2194	4	71	2023-11-23 22:44:08	2023-11-23 22:44:08
2195	4	72	2023-11-23 22:44:08	2023-11-23 22:44:08
2196	4	73	2023-11-23 22:44:08	2023-11-23 22:44:08
2197	4	74	2023-11-23 22:44:08	2023-11-23 22:44:08
2198	4	75	2023-11-23 22:44:08	2023-11-23 22:44:08
2199	4	76	2023-11-23 22:44:08	2023-11-23 22:44:08
2200	4	77	2023-11-23 22:44:08	2023-11-23 22:44:08
2201	4	432	2023-11-23 22:44:08	2023-11-23 22:44:08
2202	4	433	2023-11-23 22:44:08	2023-11-23 22:44:08
2203	4	434	2023-11-23 22:44:08	2023-11-23 22:44:08
2204	4	435	2023-11-23 22:44:08	2023-11-23 22:44:08
2205	4	436	2023-11-23 22:44:08	2023-11-23 22:44:08
2206	4	437	2023-11-23 22:44:08	2023-11-23 22:44:08
2207	4	438	2023-11-23 22:44:08	2023-11-23 22:44:08
2208	4	439	2023-11-23 22:44:08	2023-11-23 22:44:08
2209	4	440	2023-11-23 22:44:08	2023-11-23 22:44:08
2210	4	451	2023-11-23 22:44:08	2023-11-23 22:44:08
2211	4	477	2023-11-23 22:44:08	2023-11-23 22:44:08
2212	4	585	2023-11-23 22:44:08	2023-11-23 22:44:08
2213	4	78	2023-11-23 22:44:08	2023-11-23 22:44:08
2214	4	79	2023-11-23 22:44:08	2023-11-23 22:44:08
2215	4	80	2023-11-23 22:44:08	2023-11-23 22:44:08
2216	4	81	2023-11-23 22:44:08	2023-11-23 22:44:08
2217	4	82	2023-11-23 22:44:08	2023-11-23 22:44:08
2218	4	83	2023-11-23 22:44:08	2023-11-23 22:44:08
2219	4	84	2023-11-23 22:44:08	2023-11-23 22:44:08
2220	4	85	2023-11-23 22:44:08	2023-11-23 22:44:08
2221	4	86	2023-11-23 22:44:08	2023-11-23 22:44:08
2222	4	87	2023-11-23 22:44:08	2023-11-23 22:44:08
2223	4	88	2023-11-23 22:44:08	2023-11-23 22:44:08
2224	4	89	2023-11-23 22:44:08	2023-11-23 22:44:08
2225	4	90	2023-11-23 22:44:08	2023-11-23 22:44:08
2226	4	91	2023-11-23 22:44:08	2023-11-23 22:44:08
2227	4	92	2023-11-23 22:44:08	2023-11-23 22:44:08
2228	4	93	2023-11-23 22:44:08	2023-11-23 22:44:08
2229	4	94	2023-11-23 22:44:08	2023-11-23 22:44:08
2230	4	374	2023-11-23 22:44:08	2023-11-23 22:44:08
2231	4	375	2023-11-23 22:44:08	2023-11-23 22:44:08
2232	4	393	2023-11-23 22:44:08	2023-11-23 22:44:08
2233	4	394	2023-11-23 22:44:08	2023-11-23 22:44:08
2234	4	397	2023-11-23 22:44:08	2023-11-23 22:44:08
2235	4	398	2023-11-23 22:44:08	2023-11-23 22:44:08
2236	4	541	2023-11-23 22:44:08	2023-11-23 22:44:08
2237	4	543	2023-11-23 22:44:08	2023-11-23 22:44:08
2238	4	545	2023-11-23 22:44:08	2023-11-23 22:44:08
2239	4	571	2023-11-23 22:44:08	2023-11-23 22:44:08
2240	4	95	2023-11-23 22:44:08	2023-11-23 22:44:08
2241	4	96	2023-11-23 22:44:08	2023-11-23 22:44:08
2242	4	97	2023-11-23 22:44:08	2023-11-23 22:44:08
2243	4	98	2023-11-23 22:44:08	2023-11-23 22:44:08
2244	4	99	2023-11-23 22:44:08	2023-11-23 22:44:08
2245	4	100	2023-11-23 22:44:08	2023-11-23 22:44:08
2246	4	101	2023-11-23 22:44:08	2023-11-23 22:44:08
2247	4	102	2023-11-23 22:44:08	2023-11-23 22:44:08
2248	4	103	2023-11-23 22:44:08	2023-11-23 22:44:08
2249	4	104	2023-11-23 22:44:08	2023-11-23 22:44:08
2250	4	361	2023-11-23 22:44:08	2023-11-23 22:44:08
2251	4	362	2023-11-23 22:44:08	2023-11-23 22:44:08
2252	4	363	2023-11-23 22:44:08	2023-11-23 22:44:08
2253	4	364	2023-11-23 22:44:08	2023-11-23 22:44:08
2254	4	366	2023-11-23 22:44:08	2023-11-23 22:44:08
2255	4	376	2023-11-23 22:44:08	2023-11-23 22:44:08
2256	4	377	2023-11-23 22:44:08	2023-11-23 22:44:08
2257	4	105	2023-11-23 22:44:08	2023-11-23 22:44:08
2258	4	106	2023-11-23 22:44:08	2023-11-23 22:44:08
2259	4	107	2023-11-23 22:44:08	2023-11-23 22:44:08
2260	4	108	2023-11-23 22:44:08	2023-11-23 22:44:08
2261	4	109	2023-11-23 22:44:08	2023-11-23 22:44:08
2262	4	110	2023-11-23 22:44:08	2023-11-23 22:44:08
2263	4	111	2023-11-23 22:44:08	2023-11-23 22:44:08
2264	4	112	2023-11-23 22:44:08	2023-11-23 22:44:08
2265	4	113	2023-11-23 22:44:08	2023-11-23 22:44:08
2266	4	114	2023-11-23 22:44:08	2023-11-23 22:44:08
2267	4	115	2023-11-23 22:44:08	2023-11-23 22:44:08
2268	4	116	2023-11-23 22:44:08	2023-11-23 22:44:08
2269	4	117	2023-11-23 22:44:08	2023-11-23 22:44:08
2270	4	428	2023-11-23 22:44:08	2023-11-23 22:44:08
2271	4	429	2023-11-23 22:44:08	2023-11-23 22:44:08
2272	4	430	2023-11-23 22:44:08	2023-11-23 22:44:08
2273	4	431	2023-11-23 22:44:08	2023-11-23 22:44:08
2274	4	444	2023-11-23 22:44:08	2023-11-23 22:44:08
2275	4	445	2023-11-23 22:44:08	2023-11-23 22:44:08
2276	4	446	2023-11-23 22:44:08	2023-11-23 22:44:08
2277	4	447	2023-11-23 22:44:08	2023-11-23 22:44:08
2278	4	507	2023-11-23 22:44:08	2023-11-23 22:44:08
2279	4	508	2023-11-23 22:44:08	2023-11-23 22:44:08
2280	4	532	2023-11-23 22:44:08	2023-11-23 22:44:08
2281	4	540	2023-11-23 22:44:08	2023-11-23 22:44:08
2282	4	542	2023-11-23 22:44:08	2023-11-23 22:44:08
2283	4	544	2023-11-23 22:44:09	2023-11-23 22:44:09
2284	4	564	2023-11-23 22:44:09	2023-11-23 22:44:09
2285	4	565	2023-11-23 22:44:09	2023-11-23 22:44:09
2286	4	566	2023-11-23 22:44:09	2023-11-23 22:44:09
2287	4	118	2023-11-23 22:44:09	2023-11-23 22:44:09
2288	4	119	2023-11-23 22:44:09	2023-11-23 22:44:09
2289	4	120	2023-11-23 22:44:09	2023-11-23 22:44:09
2290	4	121	2023-11-23 22:44:09	2023-11-23 22:44:09
2291	4	122	2023-11-23 22:44:09	2023-11-23 22:44:09
2292	4	123	2023-11-23 22:44:09	2023-11-23 22:44:09
2293	4	124	2023-11-23 22:44:09	2023-11-23 22:44:09
2294	4	125	2023-11-23 22:44:09	2023-11-23 22:44:09
2295	4	126	2023-11-23 22:44:09	2023-11-23 22:44:09
2296	4	127	2023-11-23 22:44:09	2023-11-23 22:44:09
2297	4	128	2023-11-23 22:44:09	2023-11-23 22:44:09
2298	4	129	2023-11-23 22:44:09	2023-11-23 22:44:09
2299	4	130	2023-11-23 22:44:09	2023-11-23 22:44:09
2300	4	329	2023-11-23 22:44:09	2023-11-23 22:44:09
2301	4	330	2023-11-23 22:44:09	2023-11-23 22:44:09
2302	4	331	2023-11-23 22:44:09	2023-11-23 22:44:09
2303	4	332	2023-11-23 22:44:09	2023-11-23 22:44:09
2304	4	333	2023-11-23 22:44:09	2023-11-23 22:44:09
2305	4	334	2023-11-23 22:44:09	2023-11-23 22:44:09
2306	4	131	2023-11-23 22:44:09	2023-11-23 22:44:09
2307	4	132	2023-11-23 22:44:09	2023-11-23 22:44:09
2308	4	133	2023-11-23 22:44:09	2023-11-23 22:44:09
2309	4	134	2023-11-23 22:44:09	2023-11-23 22:44:09
2310	4	135	2023-11-23 22:44:09	2023-11-23 22:44:09
2311	4	136	2023-11-23 22:44:09	2023-11-23 22:44:09
2312	4	137	2023-11-23 22:44:09	2023-11-23 22:44:09
2313	4	138	2023-11-23 22:44:09	2023-11-23 22:44:09
2314	4	139	2023-11-23 22:44:09	2023-11-23 22:44:09
2315	4	140	2023-11-23 22:44:09	2023-11-23 22:44:09
2316	4	141	2023-11-23 22:44:09	2023-11-23 22:44:09
2317	4	142	2023-11-23 22:44:09	2023-11-23 22:44:09
2318	4	143	2023-11-23 22:44:09	2023-11-23 22:44:09
2319	4	144	2023-11-23 22:44:09	2023-11-23 22:44:09
2320	4	145	2023-11-23 22:44:09	2023-11-23 22:44:09
2321	4	146	2023-11-23 22:44:09	2023-11-23 22:44:09
2322	4	147	2023-11-23 22:44:09	2023-11-23 22:44:09
2323	4	148	2023-11-23 22:44:09	2023-11-23 22:44:09
2324	4	149	2023-11-23 22:44:09	2023-11-23 22:44:09
2325	4	150	2023-11-23 22:44:09	2023-11-23 22:44:09
2326	4	151	2023-11-23 22:44:09	2023-11-23 22:44:09
2327	4	152	2023-11-23 22:44:09	2023-11-23 22:44:09
2328	4	153	2023-11-23 22:44:09	2023-11-23 22:44:09
2329	4	154	2023-11-23 22:44:09	2023-11-23 22:44:09
2330	4	155	2023-11-23 22:44:09	2023-11-23 22:44:09
2331	4	156	2023-11-23 22:44:09	2023-11-23 22:44:09
2332	4	157	2023-11-23 22:44:09	2023-11-23 22:44:09
2333	4	158	2023-11-23 22:44:09	2023-11-23 22:44:09
2334	4	159	2023-11-23 22:44:09	2023-11-23 22:44:09
2335	4	160	2023-11-23 22:44:09	2023-11-23 22:44:09
2336	4	161	2023-11-23 22:44:09	2023-11-23 22:44:09
2337	4	162	2023-11-23 22:44:09	2023-11-23 22:44:09
2338	4	163	2023-11-23 22:44:09	2023-11-23 22:44:09
2339	4	164	2023-11-23 22:44:09	2023-11-23 22:44:09
2340	4	165	2023-11-23 22:44:09	2023-11-23 22:44:09
2341	4	166	2023-11-23 22:44:09	2023-11-23 22:44:09
2342	4	167	2023-11-23 22:44:09	2023-11-23 22:44:09
2343	4	168	2023-11-23 22:44:09	2023-11-23 22:44:09
2344	4	169	2023-11-23 22:44:09	2023-11-23 22:44:09
2345	4	170	2023-11-23 22:44:09	2023-11-23 22:44:09
2346	4	171	2023-11-23 22:44:09	2023-11-23 22:44:09
2347	4	172	2023-11-23 22:44:09	2023-11-23 22:44:09
2348	4	173	2023-11-23 22:44:09	2023-11-23 22:44:09
2349	4	426	2023-11-23 22:44:09	2023-11-23 22:44:09
2350	4	341	2023-11-23 22:44:09	2023-11-23 22:44:09
2351	4	342	2023-11-23 22:44:09	2023-11-23 22:44:09
2352	4	343	2023-11-23 22:44:09	2023-11-23 22:44:09
2353	4	346	2023-11-23 22:44:09	2023-11-23 22:44:09
2354	4	347	2023-11-23 22:44:09	2023-11-23 22:44:09
2355	4	348	2023-11-23 22:44:09	2023-11-23 22:44:09
2356	4	349	2023-11-23 22:44:09	2023-11-23 22:44:09
2357	4	536	2023-11-23 22:44:09	2023-11-23 22:44:09
2358	4	537	2023-11-23 22:44:09	2023-11-23 22:44:09
2359	4	538	2023-11-23 22:44:09	2023-11-23 22:44:09
2360	4	560	2023-11-23 22:44:09	2023-11-23 22:44:09
2361	4	561	2023-11-23 22:44:09	2023-11-23 22:44:09
2362	4	562	2023-11-23 22:44:09	2023-11-23 22:44:09
2363	4	563	2023-11-23 22:44:09	2023-11-23 22:44:09
2364	4	174	2023-11-23 22:44:09	2023-11-23 22:44:09
2365	4	176	2023-11-23 22:44:09	2023-11-23 22:44:09
2366	4	177	2023-11-23 22:44:09	2023-11-23 22:44:09
2367	4	178	2023-11-23 22:44:09	2023-11-23 22:44:09
2368	4	179	2023-11-23 22:44:09	2023-11-23 22:44:09
2369	4	180	2023-11-23 22:44:09	2023-11-23 22:44:09
2370	4	181	2023-11-23 22:44:09	2023-11-23 22:44:09
2371	4	182	2023-11-23 22:44:09	2023-11-23 22:44:09
2372	4	183	2023-11-23 22:44:09	2023-11-23 22:44:09
2373	4	184	2023-11-23 22:44:09	2023-11-23 22:44:09
2374	4	185	2023-11-23 22:44:09	2023-11-23 22:44:09
2375	4	186	2023-11-23 22:44:09	2023-11-23 22:44:09
2376	4	187	2023-11-23 22:44:09	2023-11-23 22:44:09
2377	4	188	2023-11-23 22:44:09	2023-11-23 22:44:09
2378	4	189	2023-11-23 22:44:09	2023-11-23 22:44:09
2379	4	190	2023-11-23 22:44:09	2023-11-23 22:44:09
2380	4	191	2023-11-23 22:44:09	2023-11-23 22:44:09
2381	4	192	2023-11-23 22:44:09	2023-11-23 22:44:09
2382	4	193	2023-11-23 22:44:09	2023-11-23 22:44:09
2383	4	194	2023-11-23 22:44:09	2023-11-23 22:44:09
2384	4	195	2023-11-23 22:44:10	2023-11-23 22:44:10
2385	4	196	2023-11-23 22:44:10	2023-11-23 22:44:10
2386	4	197	2023-11-23 22:44:10	2023-11-23 22:44:10
2387	4	198	2023-11-23 22:44:10	2023-11-23 22:44:10
2388	4	199	2023-11-23 22:44:10	2023-11-23 22:44:10
2389	4	200	2023-11-23 22:44:10	2023-11-23 22:44:10
2390	4	201	2023-11-23 22:44:10	2023-11-23 22:44:10
2391	4	202	2023-11-23 22:44:10	2023-11-23 22:44:10
2392	4	203	2023-11-23 22:44:10	2023-11-23 22:44:10
2393	4	204	2023-11-23 22:44:10	2023-11-23 22:44:10
2394	4	205	2023-11-23 22:44:10	2023-11-23 22:44:10
2395	4	206	2023-11-23 22:44:10	2023-11-23 22:44:10
2396	4	207	2023-11-23 22:44:10	2023-11-23 22:44:10
2397	4	208	2023-11-23 22:44:10	2023-11-23 22:44:10
2398	4	209	2023-11-23 22:44:10	2023-11-23 22:44:10
2399	4	210	2023-11-23 22:44:10	2023-11-23 22:44:10
2400	4	211	2023-11-23 22:44:10	2023-11-23 22:44:10
2401	4	212	2023-11-23 22:44:10	2023-11-23 22:44:10
2402	4	213	2023-11-23 22:44:10	2023-11-23 22:44:10
2403	4	215	2023-11-23 22:44:10	2023-11-23 22:44:10
2404	4	335	2023-11-23 22:44:10	2023-11-23 22:44:10
2405	4	336	2023-11-23 22:44:10	2023-11-23 22:44:10
2406	4	337	2023-11-23 22:44:10	2023-11-23 22:44:10
2407	4	338	2023-11-23 22:44:10	2023-11-23 22:44:10
2408	4	381	2023-11-23 22:44:10	2023-11-23 22:44:10
2409	4	382	2023-11-23 22:44:10	2023-11-23 22:44:10
2410	4	383	2023-11-23 22:44:10	2023-11-23 22:44:10
2411	4	175	2023-11-23 22:44:10	2023-11-23 22:44:10
2412	4	214	2023-11-23 22:44:10	2023-11-23 22:44:10
2413	4	216	2023-11-23 22:44:10	2023-11-23 22:44:10
2414	4	217	2023-11-23 22:44:10	2023-11-23 22:44:10
2415	4	218	2023-11-23 22:44:10	2023-11-23 22:44:10
2416	4	219	2023-11-23 22:44:10	2023-11-23 22:44:10
2417	4	220	2023-11-23 22:44:10	2023-11-23 22:44:10
2418	4	221	2023-11-23 22:44:10	2023-11-23 22:44:10
2419	4	222	2023-11-23 22:44:10	2023-11-23 22:44:10
2420	4	223	2023-11-23 22:44:10	2023-11-23 22:44:10
2421	4	533	2023-11-23 22:44:10	2023-11-23 22:44:10
2422	4	534	2023-11-23 22:44:10	2023-11-23 22:44:10
2423	4	539	2023-11-23 22:44:10	2023-11-23 22:44:10
2424	4	535	2023-11-23 22:44:10	2023-11-23 22:44:10
2425	5	14	2023-11-23 22:52:01	2023-11-23 22:52:01
2426	5	15	2023-11-23 22:52:01	2023-11-23 22:52:01
2427	5	16	2023-11-23 22:52:01	2023-11-23 22:52:01
2428	5	17	2023-11-23 22:52:01	2023-11-23 22:52:01
2429	5	18	2023-11-23 22:52:01	2023-11-23 22:52:01
2430	5	19	2023-11-23 22:52:01	2023-11-23 22:52:01
2431	5	20	2023-11-23 22:52:01	2023-11-23 22:52:01
2432	5	21	2023-11-23 22:52:01	2023-11-23 22:52:01
2433	5	22	2023-11-23 22:52:01	2023-11-23 22:52:01
2434	5	23	2023-11-23 22:52:01	2023-11-23 22:52:01
2435	5	24	2023-11-23 22:52:01	2023-11-23 22:52:01
2436	5	448	2023-11-23 22:52:02	2023-11-23 22:52:02
2437	5	441	2023-11-23 22:52:02	2023-11-23 22:52:02
2438	5	442	2023-11-23 22:52:02	2023-11-23 22:52:02
2439	5	546	2023-11-23 22:52:02	2023-11-23 22:52:02
2440	5	584	2023-11-23 22:52:02	2023-11-23 22:52:02
2441	5	614	2023-11-23 22:52:02	2023-11-23 22:52:02
2442	5	615	2023-11-23 22:52:02	2023-11-23 22:52:02
2443	5	617	2023-11-23 22:52:02	2023-11-23 22:52:02
2444	5	618	2023-11-23 22:52:02	2023-11-23 22:52:02
2445	5	224	2023-11-23 22:52:02	2023-11-23 22:52:02
2446	5	261	2023-11-23 22:52:02	2023-11-23 22:52:02
2447	5	225	2023-11-23 22:52:02	2023-11-23 22:52:02
2448	5	226	2023-11-23 22:52:02	2023-11-23 22:52:02
2449	5	227	2023-11-23 22:52:02	2023-11-23 22:52:02
2450	5	228	2023-11-23 22:52:02	2023-11-23 22:52:02
2451	5	229	2023-11-23 22:52:02	2023-11-23 22:52:02
2452	5	230	2023-11-23 22:52:02	2023-11-23 22:52:02
2453	5	231	2023-11-23 22:52:02	2023-11-23 22:52:02
2454	5	232	2023-11-23 22:52:02	2023-11-23 22:52:02
2455	5	233	2023-11-23 22:52:02	2023-11-23 22:52:02
2456	5	359	2023-11-23 22:52:02	2023-11-23 22:52:02
2457	5	360	2023-11-23 22:52:02	2023-11-23 22:52:02
2458	5	234	2023-11-23 22:52:02	2023-11-23 22:52:02
2459	5	235	2023-11-23 22:52:02	2023-11-23 22:52:02
2460	5	236	2023-11-23 22:52:02	2023-11-23 22:52:02
2461	5	237	2023-11-23 22:52:02	2023-11-23 22:52:02
2462	5	238	2023-11-23 22:52:02	2023-11-23 22:52:02
2463	5	239	2023-11-23 22:52:02	2023-11-23 22:52:02
2464	5	240	2023-11-23 22:52:02	2023-11-23 22:52:02
2465	5	241	2023-11-23 22:52:02	2023-11-23 22:52:02
2466	5	242	2023-11-23 22:52:02	2023-11-23 22:52:02
2467	5	243	2023-11-23 22:52:02	2023-11-23 22:52:02
2468	5	244	2023-11-23 22:52:02	2023-11-23 22:52:02
2469	5	245	2023-11-23 22:52:02	2023-11-23 22:52:02
2470	5	246	2023-11-23 22:52:02	2023-11-23 22:52:02
2471	5	247	2023-11-23 22:52:02	2023-11-23 22:52:02
2472	5	248	2023-11-23 22:52:02	2023-11-23 22:52:02
2473	5	249	2023-11-23 22:52:02	2023-11-23 22:52:02
2474	5	250	2023-11-23 22:52:02	2023-11-23 22:52:02
2475	5	251	2023-11-23 22:52:02	2023-11-23 22:52:02
2476	5	252	2023-11-23 22:52:02	2023-11-23 22:52:02
2477	5	253	2023-11-23 22:52:02	2023-11-23 22:52:02
2478	5	254	2023-11-23 22:52:02	2023-11-23 22:52:02
2479	5	255	2023-11-23 22:52:02	2023-11-23 22:52:02
2480	5	256	2023-11-23 22:52:02	2023-11-23 22:52:02
2481	5	257	2023-11-23 22:52:02	2023-11-23 22:52:02
2482	5	258	2023-11-23 22:52:02	2023-11-23 22:52:02
2483	5	259	2023-11-23 22:52:02	2023-11-23 22:52:02
2484	5	260	2023-11-23 22:52:02	2023-11-23 22:52:02
2485	5	262	2023-11-23 22:52:02	2023-11-23 22:52:02
2486	5	263	2023-11-23 22:52:02	2023-11-23 22:52:02
2487	5	264	2023-11-23 22:52:02	2023-11-23 22:52:02
2488	5	509	2023-11-23 22:52:02	2023-11-23 22:52:02
2489	5	265	2023-11-23 22:52:02	2023-11-23 22:52:02
2490	5	266	2023-11-23 22:52:02	2023-11-23 22:52:02
2491	5	267	2023-11-23 22:52:02	2023-11-23 22:52:02
2492	5	268	2023-11-23 22:52:02	2023-11-23 22:52:02
2493	5	269	2023-11-23 22:52:02	2023-11-23 22:52:02
2494	5	270	2023-11-23 22:52:02	2023-11-23 22:52:02
2495	5	271	2023-11-23 22:52:02	2023-11-23 22:52:02
2496	5	272	2023-11-23 22:52:02	2023-11-23 22:52:02
2497	5	273	2023-11-23 22:52:02	2023-11-23 22:52:02
2498	5	274	2023-11-23 22:52:02	2023-11-23 22:52:02
2499	5	275	2023-11-23 22:52:02	2023-11-23 22:52:02
2500	5	276	2023-11-23 22:52:02	2023-11-23 22:52:02
2501	5	277	2023-11-23 22:52:02	2023-11-23 22:52:02
2502	5	278	2023-11-23 22:52:02	2023-11-23 22:52:02
2503	5	279	2023-11-23 22:52:02	2023-11-23 22:52:02
2504	5	280	2023-11-23 22:52:02	2023-11-23 22:52:02
2505	5	281	2023-11-23 22:52:02	2023-11-23 22:52:02
2506	5	282	2023-11-23 22:52:02	2023-11-23 22:52:02
2507	5	283	2023-11-23 22:52:02	2023-11-23 22:52:02
2508	5	284	2023-11-23 22:52:02	2023-11-23 22:52:02
2509	5	285	2023-11-23 22:52:02	2023-11-23 22:52:02
2510	5	286	2023-11-23 22:52:02	2023-11-23 22:52:02
2511	5	287	2023-11-23 22:52:02	2023-11-23 22:52:02
2512	5	288	2023-11-23 22:52:02	2023-11-23 22:52:02
2513	5	289	2023-11-23 22:52:02	2023-11-23 22:52:02
2514	5	294	2023-11-23 22:52:02	2023-11-23 22:52:02
2515	5	295	2023-11-23 22:52:02	2023-11-23 22:52:02
2516	5	296	2023-11-23 22:52:02	2023-11-23 22:52:02
2517	5	297	2023-11-23 22:52:02	2023-11-23 22:52:02
2518	5	500	2023-11-23 22:52:02	2023-11-23 22:52:02
2519	5	501	2023-11-23 22:52:02	2023-11-23 22:52:02
2520	5	502	2023-11-23 22:52:02	2023-11-23 22:52:02
2521	5	510	2023-11-23 22:52:02	2023-11-23 22:52:02
2522	5	511	2023-11-23 22:52:03	2023-11-23 22:52:03
2523	5	512	2023-11-23 22:52:03	2023-11-23 22:52:03
2524	5	567	2023-11-23 22:52:03	2023-11-23 22:52:03
2525	5	594	2023-11-23 22:52:03	2023-11-23 22:52:03
2526	5	298	2023-11-23 22:52:03	2023-11-23 22:52:03
2527	5	299	2023-11-23 22:52:03	2023-11-23 22:52:03
2528	5	300	2023-11-23 22:52:03	2023-11-23 22:52:03
2529	5	310	2023-11-23 22:52:03	2023-11-23 22:52:03
2530	5	311	2023-11-23 22:52:03	2023-11-23 22:52:03
2531	5	312	2023-11-23 22:52:03	2023-11-23 22:52:03
2532	5	313	2023-11-23 22:52:03	2023-11-23 22:52:03
2533	5	314	2023-11-23 22:52:03	2023-11-23 22:52:03
2534	5	315	2023-11-23 22:52:03	2023-11-23 22:52:03
2535	5	316	2023-11-23 22:52:03	2023-11-23 22:52:03
2536	5	317	2023-11-23 22:52:03	2023-11-23 22:52:03
2537	5	318	2023-11-23 22:52:03	2023-11-23 22:52:03
2538	5	358	2023-11-23 22:52:03	2023-11-23 22:52:03
2539	5	365	2023-11-23 22:52:03	2023-11-23 22:52:03
2540	5	350	2023-11-23 22:52:03	2023-11-23 22:52:03
2541	5	351	2023-11-23 22:52:03	2023-11-23 22:52:03
2542	5	352	2023-11-23 22:52:03	2023-11-23 22:52:03
2543	5	353	2023-11-23 22:52:03	2023-11-23 22:52:03
2544	5	354	2023-11-23 22:52:03	2023-11-23 22:52:03
2545	5	355	2023-11-23 22:52:03	2023-11-23 22:52:03
2546	5	356	2023-11-23 22:52:03	2023-11-23 22:52:03
2547	5	357	2023-11-23 22:52:03	2023-11-23 22:52:03
2548	5	392	2023-11-23 22:52:03	2023-11-23 22:52:03
2549	5	396	2023-11-23 22:52:03	2023-11-23 22:52:03
2550	5	301	2023-11-23 22:52:03	2023-11-23 22:52:03
2551	5	302	2023-11-23 22:52:03	2023-11-23 22:52:03
2552	5	303	2023-11-23 22:52:03	2023-11-23 22:52:03
2553	5	304	2023-11-23 22:52:03	2023-11-23 22:52:03
2554	5	305	2023-11-23 22:52:03	2023-11-23 22:52:03
2555	5	306	2023-11-23 22:52:03	2023-11-23 22:52:03
2556	5	307	2023-11-23 22:52:03	2023-11-23 22:52:03
2557	5	308	2023-11-23 22:52:03	2023-11-23 22:52:03
2558	5	309	2023-11-23 22:52:03	2023-11-23 22:52:03
2559	5	25	2023-11-23 22:52:03	2023-11-23 22:52:03
2560	5	572	2023-11-23 22:52:03	2023-11-23 22:52:03
2561	5	573	2023-11-23 22:52:03	2023-11-23 22:52:03
2562	5	574	2023-11-23 22:52:03	2023-11-23 22:52:03
2563	5	575	2023-11-23 22:52:03	2023-11-23 22:52:03
2564	5	26	2023-11-23 22:52:03	2023-11-23 22:52:03
2565	5	27	2023-11-23 22:52:03	2023-11-23 22:52:03
2566	5	28	2023-11-23 22:52:03	2023-11-23 22:52:03
2567	5	29	2023-11-23 22:52:03	2023-11-23 22:52:03
2568	5	30	2023-11-23 22:52:03	2023-11-23 22:52:03
2569	5	31	2023-11-23 22:52:03	2023-11-23 22:52:03
2570	5	32	2023-11-23 22:52:03	2023-11-23 22:52:03
2571	5	33	2023-11-23 22:52:03	2023-11-23 22:52:03
2572	5	367	2023-11-23 22:52:03	2023-11-23 22:52:03
2573	5	368	2023-11-23 22:52:03	2023-11-23 22:52:03
2574	5	369	2023-11-23 22:52:03	2023-11-23 22:52:03
2575	5	370	2023-11-23 22:52:03	2023-11-23 22:52:03
2576	5	371	2023-11-23 22:52:03	2023-11-23 22:52:03
2577	5	372	2023-11-23 22:52:03	2023-11-23 22:52:03
2578	5	373	2023-11-23 22:52:03	2023-11-23 22:52:03
2579	5	378	2023-11-23 22:52:03	2023-11-23 22:52:03
2580	5	395	2023-11-23 22:52:03	2023-11-23 22:52:03
2581	5	39	2023-11-23 22:52:03	2023-11-23 22:52:03
2582	5	379	2023-11-23 22:52:03	2023-11-23 22:52:03
2583	5	380	2023-11-23 22:52:03	2023-11-23 22:52:03
2584	5	34	2023-11-23 22:52:03	2023-11-23 22:52:03
2585	5	35	2023-11-23 22:52:03	2023-11-23 22:52:03
2586	5	36	2023-11-23 22:52:03	2023-11-23 22:52:03
2587	5	37	2023-11-23 22:52:03	2023-11-23 22:52:03
2588	5	38	2023-11-23 22:52:03	2023-11-23 22:52:03
2589	5	424	2023-11-23 22:52:03	2023-11-23 22:52:03
2590	5	425	2023-11-23 22:52:03	2023-11-23 22:52:03
2591	5	427	2023-11-23 22:52:03	2023-11-23 22:52:03
2592	5	443	2023-11-23 22:52:03	2023-11-23 22:52:03
2593	5	449	2023-11-23 22:52:03	2023-11-23 22:52:03
2594	5	452	2023-11-23 22:52:03	2023-11-23 22:52:03
2595	5	453	2023-11-23 22:52:03	2023-11-23 22:52:03
2596	5	454	2023-11-23 22:52:03	2023-11-23 22:52:03
2597	5	464	2023-11-23 22:52:03	2023-11-23 22:52:03
2598	5	450	2023-11-23 22:52:03	2023-11-23 22:52:03
2599	5	498	2023-11-23 22:52:03	2023-11-23 22:52:03
2600	5	499	2023-11-23 22:52:03	2023-11-23 22:52:03
2601	5	513	2023-11-23 22:52:03	2023-11-23 22:52:03
2602	5	514	2023-11-23 22:52:03	2023-11-23 22:52:03
2603	5	515	2023-11-23 22:52:03	2023-11-23 22:52:03
2604	5	516	2023-11-23 22:52:03	2023-11-23 22:52:03
2605	5	517	2023-11-23 22:52:03	2023-11-23 22:52:03
2606	5	518	2023-11-23 22:52:03	2023-11-23 22:52:03
2607	5	519	2023-11-23 22:52:03	2023-11-23 22:52:03
2608	5	520	2023-11-23 22:52:03	2023-11-23 22:52:03
2609	5	521	2023-11-23 22:52:03	2023-11-23 22:52:03
2610	5	522	2023-11-23 22:52:03	2023-11-23 22:52:03
2611	5	523	2023-11-23 22:52:03	2023-11-23 22:52:03
2612	5	524	2023-11-23 22:52:03	2023-11-23 22:52:03
2613	5	525	2023-11-23 22:52:03	2023-11-23 22:52:03
2614	5	526	2023-11-23 22:52:03	2023-11-23 22:52:03
2615	5	527	2023-11-23 22:52:03	2023-11-23 22:52:03
2616	5	528	2023-11-23 22:52:03	2023-11-23 22:52:03
2617	5	529	2023-11-23 22:52:03	2023-11-23 22:52:03
2618	5	530	2023-11-23 22:52:03	2023-11-23 22:52:03
2619	5	531	2023-11-23 22:52:03	2023-11-23 22:52:03
2620	5	547	2023-11-23 22:52:03	2023-11-23 22:52:03
2621	5	548	2023-11-23 22:52:03	2023-11-23 22:52:03
2622	5	549	2023-11-23 22:52:03	2023-11-23 22:52:03
2623	5	550	2023-11-23 22:52:03	2023-11-23 22:52:03
2624	5	553	2023-11-23 22:52:03	2023-11-23 22:52:03
2625	5	554	2023-11-23 22:52:03	2023-11-23 22:52:03
2626	5	586	2023-11-23 22:52:03	2023-11-23 22:52:03
2627	5	588	2023-11-23 22:52:03	2023-11-23 22:52:03
2628	5	589	2023-11-23 22:52:03	2023-11-23 22:52:03
2629	5	590	2023-11-23 22:52:03	2023-11-23 22:52:03
2630	5	591	2023-11-23 22:52:03	2023-11-23 22:52:03
2631	5	593	2023-11-23 22:52:03	2023-11-23 22:52:03
2632	5	616	2023-11-23 22:52:03	2023-11-23 22:52:03
2633	5	40	2023-11-23 22:52:04	2023-11-23 22:52:04
2634	5	44	2023-11-23 22:52:04	2023-11-23 22:52:04
2635	5	45	2023-11-23 22:52:04	2023-11-23 22:52:04
2636	5	46	2023-11-23 22:52:04	2023-11-23 22:52:04
2637	5	47	2023-11-23 22:52:04	2023-11-23 22:52:04
2638	5	48	2023-11-23 22:52:04	2023-11-23 22:52:04
2639	5	49	2023-11-23 22:52:04	2023-11-23 22:52:04
2640	5	50	2023-11-23 22:52:04	2023-11-23 22:52:04
2641	5	51	2023-11-23 22:52:04	2023-11-23 22:52:04
2642	5	52	2023-11-23 22:52:04	2023-11-23 22:52:04
2643	5	384	2023-11-23 22:52:04	2023-11-23 22:52:04
2644	5	41	2023-11-23 22:52:04	2023-11-23 22:52:04
2645	5	42	2023-11-23 22:52:04	2023-11-23 22:52:04
2646	5	43	2023-11-23 22:52:04	2023-11-23 22:52:04
2647	5	587	2023-11-23 22:52:04	2023-11-23 22:52:04
2648	5	592	2023-11-23 22:52:04	2023-11-23 22:52:04
2649	5	53	2023-11-23 22:52:04	2023-11-23 22:52:04
2650	5	54	2023-11-23 22:52:04	2023-11-23 22:52:04
2651	5	55	2023-11-23 22:52:04	2023-11-23 22:52:04
2652	5	56	2023-11-23 22:52:04	2023-11-23 22:52:04
2653	5	57	2023-11-23 22:52:04	2023-11-23 22:52:04
2654	5	58	2023-11-23 22:52:04	2023-11-23 22:52:04
2655	5	59	2023-11-23 22:52:04	2023-11-23 22:52:04
2656	5	60	2023-11-23 22:52:04	2023-11-23 22:52:04
2657	5	61	2023-11-23 22:52:04	2023-11-23 22:52:04
2658	5	62	2023-11-23 22:52:04	2023-11-23 22:52:04
2659	5	63	2023-11-23 22:52:04	2023-11-23 22:52:04
2660	5	64	2023-11-23 22:52:04	2023-11-23 22:52:04
2661	5	65	2023-11-23 22:52:04	2023-11-23 22:52:04
2662	5	66	2023-11-23 22:52:04	2023-11-23 22:52:04
2663	5	67	2023-11-23 22:52:04	2023-11-23 22:52:04
2664	5	68	2023-11-23 22:52:04	2023-11-23 22:52:04
2665	5	69	2023-11-23 22:52:04	2023-11-23 22:52:04
2666	5	70	2023-11-23 22:52:04	2023-11-23 22:52:04
2667	5	71	2023-11-23 22:52:04	2023-11-23 22:52:04
2668	5	72	2023-11-23 22:52:04	2023-11-23 22:52:04
2669	5	73	2023-11-23 22:52:04	2023-11-23 22:52:04
2670	5	74	2023-11-23 22:52:04	2023-11-23 22:52:04
2671	5	75	2023-11-23 22:52:04	2023-11-23 22:52:04
2672	5	76	2023-11-23 22:52:04	2023-11-23 22:52:04
2673	5	77	2023-11-23 22:52:04	2023-11-23 22:52:04
2674	5	432	2023-11-23 22:52:04	2023-11-23 22:52:04
2675	5	433	2023-11-23 22:52:04	2023-11-23 22:52:04
2676	5	434	2023-11-23 22:52:04	2023-11-23 22:52:04
2677	5	435	2023-11-23 22:52:04	2023-11-23 22:52:04
2678	5	436	2023-11-23 22:52:04	2023-11-23 22:52:04
2679	5	437	2023-11-23 22:52:04	2023-11-23 22:52:04
2680	5	438	2023-11-23 22:52:05	2023-11-23 22:52:05
2681	5	439	2023-11-23 22:52:05	2023-11-23 22:52:05
2682	5	440	2023-11-23 22:52:05	2023-11-23 22:52:05
2683	5	451	2023-11-23 22:52:05	2023-11-23 22:52:05
2684	5	477	2023-11-23 22:52:05	2023-11-23 22:52:05
2685	5	585	2023-11-23 22:52:05	2023-11-23 22:52:05
2686	5	78	2023-11-23 22:52:05	2023-11-23 22:52:05
2687	5	79	2023-11-23 22:52:05	2023-11-23 22:52:05
2688	5	80	2023-11-23 22:52:05	2023-11-23 22:52:05
2689	5	81	2023-11-23 22:52:05	2023-11-23 22:52:05
2690	5	82	2023-11-23 22:52:05	2023-11-23 22:52:05
2691	5	83	2023-11-23 22:52:05	2023-11-23 22:52:05
2692	5	84	2023-11-23 22:52:05	2023-11-23 22:52:05
2693	5	85	2023-11-23 22:52:05	2023-11-23 22:52:05
2694	5	86	2023-11-23 22:52:05	2023-11-23 22:52:05
2695	5	87	2023-11-23 22:52:05	2023-11-23 22:52:05
2696	5	88	2023-11-23 22:52:05	2023-11-23 22:52:05
2697	5	89	2023-11-23 22:52:05	2023-11-23 22:52:05
2698	5	90	2023-11-23 22:52:05	2023-11-23 22:52:05
2699	5	91	2023-11-23 22:52:05	2023-11-23 22:52:05
2700	5	92	2023-11-23 22:52:05	2023-11-23 22:52:05
2701	5	93	2023-11-23 22:52:05	2023-11-23 22:52:05
2702	5	94	2023-11-23 22:52:05	2023-11-23 22:52:05
2703	5	374	2023-11-23 22:52:05	2023-11-23 22:52:05
2704	5	375	2023-11-23 22:52:05	2023-11-23 22:52:05
2705	5	393	2023-11-23 22:52:05	2023-11-23 22:52:05
2706	5	394	2023-11-23 22:52:05	2023-11-23 22:52:05
2707	5	397	2023-11-23 22:52:05	2023-11-23 22:52:05
2708	5	398	2023-11-23 22:52:05	2023-11-23 22:52:05
2709	5	541	2023-11-23 22:52:05	2023-11-23 22:52:05
2710	5	543	2023-11-23 22:52:05	2023-11-23 22:52:05
2711	5	545	2023-11-23 22:52:05	2023-11-23 22:52:05
2712	5	571	2023-11-23 22:52:05	2023-11-23 22:52:05
2713	5	95	2023-11-23 22:52:05	2023-11-23 22:52:05
2714	5	96	2023-11-23 22:52:05	2023-11-23 22:52:05
2715	5	97	2023-11-23 22:52:05	2023-11-23 22:52:05
2716	5	98	2023-11-23 22:52:05	2023-11-23 22:52:05
2717	5	99	2023-11-23 22:52:05	2023-11-23 22:52:05
2718	5	100	2023-11-23 22:52:05	2023-11-23 22:52:05
2719	5	101	2023-11-23 22:52:05	2023-11-23 22:52:05
2720	5	102	2023-11-23 22:52:05	2023-11-23 22:52:05
2721	5	103	2023-11-23 22:52:05	2023-11-23 22:52:05
2722	5	104	2023-11-23 22:52:05	2023-11-23 22:52:05
2723	5	361	2023-11-23 22:52:05	2023-11-23 22:52:05
2724	5	362	2023-11-23 22:52:05	2023-11-23 22:52:05
2725	5	363	2023-11-23 22:52:05	2023-11-23 22:52:05
2726	5	364	2023-11-23 22:52:05	2023-11-23 22:52:05
2727	5	366	2023-11-23 22:52:05	2023-11-23 22:52:05
2728	5	376	2023-11-23 22:52:05	2023-11-23 22:52:05
2729	5	377	2023-11-23 22:52:05	2023-11-23 22:52:05
2730	5	105	2023-11-23 22:52:05	2023-11-23 22:52:05
2731	5	106	2023-11-23 22:52:05	2023-11-23 22:52:05
2732	5	107	2023-11-23 22:52:05	2023-11-23 22:52:05
2733	5	108	2023-11-23 22:52:05	2023-11-23 22:52:05
2734	5	109	2023-11-23 22:52:05	2023-11-23 22:52:05
2735	5	110	2023-11-23 22:52:05	2023-11-23 22:52:05
2736	5	111	2023-11-23 22:52:05	2023-11-23 22:52:05
2737	5	112	2023-11-23 22:52:05	2023-11-23 22:52:05
2738	5	113	2023-11-23 22:52:05	2023-11-23 22:52:05
2739	5	114	2023-11-23 22:52:05	2023-11-23 22:52:05
2740	5	115	2023-11-23 22:52:05	2023-11-23 22:52:05
2741	5	116	2023-11-23 22:52:05	2023-11-23 22:52:05
2742	5	117	2023-11-23 22:52:05	2023-11-23 22:52:05
2743	5	428	2023-11-23 22:52:06	2023-11-23 22:52:06
2744	5	429	2023-11-23 22:52:06	2023-11-23 22:52:06
2745	5	430	2023-11-23 22:52:06	2023-11-23 22:52:06
2746	5	431	2023-11-23 22:52:06	2023-11-23 22:52:06
2747	5	444	2023-11-23 22:52:06	2023-11-23 22:52:06
2748	5	445	2023-11-23 22:52:06	2023-11-23 22:52:06
2749	5	446	2023-11-23 22:52:06	2023-11-23 22:52:06
2750	5	447	2023-11-23 22:52:06	2023-11-23 22:52:06
2751	5	507	2023-11-23 22:52:06	2023-11-23 22:52:06
2752	5	508	2023-11-23 22:52:06	2023-11-23 22:52:06
2753	5	532	2023-11-23 22:52:06	2023-11-23 22:52:06
2754	5	540	2023-11-23 22:52:06	2023-11-23 22:52:06
2755	5	542	2023-11-23 22:52:06	2023-11-23 22:52:06
2756	5	544	2023-11-23 22:52:06	2023-11-23 22:52:06
2757	5	564	2023-11-23 22:52:06	2023-11-23 22:52:06
2758	5	565	2023-11-23 22:52:06	2023-11-23 22:52:06
2759	5	566	2023-11-23 22:52:06	2023-11-23 22:52:06
2760	5	118	2023-11-23 22:52:06	2023-11-23 22:52:06
2761	5	119	2023-11-23 22:52:06	2023-11-23 22:52:06
2762	5	120	2023-11-23 22:52:06	2023-11-23 22:52:06
2763	5	121	2023-11-23 22:52:06	2023-11-23 22:52:06
2764	5	122	2023-11-23 22:52:06	2023-11-23 22:52:06
2765	5	123	2023-11-23 22:52:06	2023-11-23 22:52:06
2766	5	124	2023-11-23 22:52:06	2023-11-23 22:52:06
2767	5	125	2023-11-23 22:52:06	2023-11-23 22:52:06
2768	5	126	2023-11-23 22:52:06	2023-11-23 22:52:06
2769	5	127	2023-11-23 22:52:06	2023-11-23 22:52:06
2770	5	128	2023-11-23 22:52:06	2023-11-23 22:52:06
2771	5	129	2023-11-23 22:52:06	2023-11-23 22:52:06
2772	5	130	2023-11-23 22:52:06	2023-11-23 22:52:06
2773	5	329	2023-11-23 22:52:06	2023-11-23 22:52:06
2774	5	330	2023-11-23 22:52:06	2023-11-23 22:52:06
2775	5	331	2023-11-23 22:52:06	2023-11-23 22:52:06
2776	5	332	2023-11-23 22:52:06	2023-11-23 22:52:06
2777	5	333	2023-11-23 22:52:06	2023-11-23 22:52:06
2778	5	334	2023-11-23 22:52:06	2023-11-23 22:52:06
2779	5	131	2023-11-23 22:52:06	2023-11-23 22:52:06
2780	5	132	2023-11-23 22:52:06	2023-11-23 22:52:06
2781	5	133	2023-11-23 22:52:06	2023-11-23 22:52:06
2782	5	134	2023-11-23 22:52:06	2023-11-23 22:52:06
2783	5	135	2023-11-23 22:52:06	2023-11-23 22:52:06
2784	5	136	2023-11-23 22:52:06	2023-11-23 22:52:06
2785	5	137	2023-11-23 22:52:06	2023-11-23 22:52:06
2786	5	138	2023-11-23 22:52:06	2023-11-23 22:52:06
2787	5	139	2023-11-23 22:52:06	2023-11-23 22:52:06
2788	5	140	2023-11-23 22:52:06	2023-11-23 22:52:06
2789	5	141	2023-11-23 22:52:06	2023-11-23 22:52:06
2790	5	142	2023-11-23 22:52:06	2023-11-23 22:52:06
2791	5	143	2023-11-23 22:52:06	2023-11-23 22:52:06
2792	5	144	2023-11-23 22:52:06	2023-11-23 22:52:06
2793	5	145	2023-11-23 22:52:06	2023-11-23 22:52:06
2794	5	146	2023-11-23 22:52:06	2023-11-23 22:52:06
2795	5	147	2023-11-23 22:52:06	2023-11-23 22:52:06
2796	5	148	2023-11-23 22:52:06	2023-11-23 22:52:06
2797	5	149	2023-11-23 22:52:06	2023-11-23 22:52:06
2798	5	150	2023-11-23 22:52:06	2023-11-23 22:52:06
2799	5	151	2023-11-23 22:52:06	2023-11-23 22:52:06
2800	5	152	2023-11-23 22:52:06	2023-11-23 22:52:06
2801	5	153	2023-11-23 22:52:06	2023-11-23 22:52:06
2802	5	154	2023-11-23 22:52:06	2023-11-23 22:52:06
2803	5	155	2023-11-23 22:52:06	2023-11-23 22:52:06
2804	5	156	2023-11-23 22:52:06	2023-11-23 22:52:06
2805	5	157	2023-11-23 22:52:06	2023-11-23 22:52:06
2806	5	158	2023-11-23 22:52:06	2023-11-23 22:52:06
2807	5	159	2023-11-23 22:52:06	2023-11-23 22:52:06
2808	5	160	2023-11-23 22:52:06	2023-11-23 22:52:06
2809	5	161	2023-11-23 22:52:06	2023-11-23 22:52:06
2810	5	162	2023-11-23 22:52:06	2023-11-23 22:52:06
2811	5	163	2023-11-23 22:52:06	2023-11-23 22:52:06
2812	5	164	2023-11-23 22:52:06	2023-11-23 22:52:06
2813	5	165	2023-11-23 22:52:06	2023-11-23 22:52:06
2814	5	166	2023-11-23 22:52:06	2023-11-23 22:52:06
2815	5	167	2023-11-23 22:52:06	2023-11-23 22:52:06
2816	5	168	2023-11-23 22:52:06	2023-11-23 22:52:06
2817	5	169	2023-11-23 22:52:06	2023-11-23 22:52:06
2818	5	170	2023-11-23 22:52:06	2023-11-23 22:52:06
2819	5	171	2023-11-23 22:52:06	2023-11-23 22:52:06
2820	5	172	2023-11-23 22:52:06	2023-11-23 22:52:06
2821	5	173	2023-11-23 22:52:06	2023-11-23 22:52:06
2822	5	426	2023-11-23 22:52:06	2023-11-23 22:52:06
2823	5	341	2023-11-23 22:52:06	2023-11-23 22:52:06
2824	5	342	2023-11-23 22:52:06	2023-11-23 22:52:06
2825	5	343	2023-11-23 22:52:06	2023-11-23 22:52:06
2826	5	346	2023-11-23 22:52:06	2023-11-23 22:52:06
2827	5	347	2023-11-23 22:52:06	2023-11-23 22:52:06
2828	5	348	2023-11-23 22:52:06	2023-11-23 22:52:06
2829	5	349	2023-11-23 22:52:06	2023-11-23 22:52:06
2830	5	536	2023-11-23 22:52:06	2023-11-23 22:52:06
2831	5	537	2023-11-23 22:52:06	2023-11-23 22:52:06
2832	5	538	2023-11-23 22:52:06	2023-11-23 22:52:06
2833	5	560	2023-11-23 22:52:06	2023-11-23 22:52:06
2834	5	561	2023-11-23 22:52:06	2023-11-23 22:52:06
2835	5	562	2023-11-23 22:52:06	2023-11-23 22:52:06
2836	5	563	2023-11-23 22:52:06	2023-11-23 22:52:06
2837	5	174	2023-11-23 22:52:06	2023-11-23 22:52:06
2838	5	176	2023-11-23 22:52:07	2023-11-23 22:52:07
2839	5	177	2023-11-23 22:52:07	2023-11-23 22:52:07
2840	5	178	2023-11-23 22:52:07	2023-11-23 22:52:07
2841	5	179	2023-11-23 22:52:07	2023-11-23 22:52:07
2842	5	180	2023-11-23 22:52:07	2023-11-23 22:52:07
2843	5	181	2023-11-23 22:52:07	2023-11-23 22:52:07
2844	5	182	2023-11-23 22:52:07	2023-11-23 22:52:07
2845	5	183	2023-11-23 22:52:07	2023-11-23 22:52:07
2846	5	184	2023-11-23 22:52:07	2023-11-23 22:52:07
2847	5	185	2023-11-23 22:52:07	2023-11-23 22:52:07
2848	5	186	2023-11-23 22:52:07	2023-11-23 22:52:07
2849	5	187	2023-11-23 22:52:07	2023-11-23 22:52:07
2850	5	188	2023-11-23 22:52:07	2023-11-23 22:52:07
2851	5	189	2023-11-23 22:52:07	2023-11-23 22:52:07
2852	5	190	2023-11-23 22:52:07	2023-11-23 22:52:07
2853	5	191	2023-11-23 22:52:07	2023-11-23 22:52:07
2854	5	192	2023-11-23 22:52:07	2023-11-23 22:52:07
2855	5	193	2023-11-23 22:52:07	2023-11-23 22:52:07
2856	5	194	2023-11-23 22:52:07	2023-11-23 22:52:07
2857	5	195	2023-11-23 22:52:07	2023-11-23 22:52:07
2858	5	196	2023-11-23 22:52:07	2023-11-23 22:52:07
2859	5	197	2023-11-23 22:52:07	2023-11-23 22:52:07
2860	5	198	2023-11-23 22:52:07	2023-11-23 22:52:07
2861	5	199	2023-11-23 22:52:07	2023-11-23 22:52:07
2862	5	200	2023-11-23 22:52:07	2023-11-23 22:52:07
2863	5	201	2023-11-23 22:52:07	2023-11-23 22:52:07
2864	5	202	2023-11-23 22:52:07	2023-11-23 22:52:07
2865	5	203	2023-11-23 22:52:07	2023-11-23 22:52:07
2866	5	204	2023-11-23 22:52:07	2023-11-23 22:52:07
2867	5	205	2023-11-23 22:52:07	2023-11-23 22:52:07
2868	5	206	2023-11-23 22:52:07	2023-11-23 22:52:07
2869	5	207	2023-11-23 22:52:07	2023-11-23 22:52:07
2870	5	208	2023-11-23 22:52:07	2023-11-23 22:52:07
2871	5	209	2023-11-23 22:52:07	2023-11-23 22:52:07
2872	5	210	2023-11-23 22:52:07	2023-11-23 22:52:07
2873	5	211	2023-11-23 22:52:07	2023-11-23 22:52:07
2874	5	212	2023-11-23 22:52:07	2023-11-23 22:52:07
2875	5	213	2023-11-23 22:52:07	2023-11-23 22:52:07
2876	5	215	2023-11-23 22:52:07	2023-11-23 22:52:07
2877	5	335	2023-11-23 22:52:07	2023-11-23 22:52:07
2878	5	336	2023-11-23 22:52:07	2023-11-23 22:52:07
2879	5	337	2023-11-23 22:52:07	2023-11-23 22:52:07
2880	5	338	2023-11-23 22:52:07	2023-11-23 22:52:07
2881	5	381	2023-11-23 22:52:07	2023-11-23 22:52:07
2882	5	382	2023-11-23 22:52:07	2023-11-23 22:52:07
2883	5	383	2023-11-23 22:52:07	2023-11-23 22:52:07
2884	5	175	2023-11-23 22:52:07	2023-11-23 22:52:07
2885	5	214	2023-11-23 22:52:07	2023-11-23 22:52:07
2886	5	216	2023-11-23 22:52:07	2023-11-23 22:52:07
2887	5	217	2023-11-23 22:52:07	2023-11-23 22:52:07
2888	5	218	2023-11-23 22:52:07	2023-11-23 22:52:07
2889	5	219	2023-11-23 22:52:07	2023-11-23 22:52:07
2890	5	220	2023-11-23 22:52:07	2023-11-23 22:52:07
2891	5	221	2023-11-23 22:52:07	2023-11-23 22:52:07
2892	5	222	2023-11-23 22:52:07	2023-11-23 22:52:07
2893	5	223	2023-11-23 22:52:07	2023-11-23 22:52:07
2894	5	533	2023-11-23 22:52:07	2023-11-23 22:52:07
2895	5	534	2023-11-23 22:52:07	2023-11-23 22:52:07
2896	5	539	2023-11-23 22:52:07	2023-11-23 22:52:07
2897	5	535	2023-11-23 22:52:07	2023-11-23 22:52:07
2898	5	558	2023-11-23 22:52:07	2023-11-23 22:52:07
2899	5	559	2023-11-23 22:52:07	2023-11-23 22:52:07
2900	6	14	2024-12-04 21:52:57	2024-12-04 21:52:57
2901	6	15	2024-12-04 21:52:57	2024-12-04 21:52:57
2902	6	16	2024-12-04 21:52:57	2024-12-04 21:52:57
2903	6	17	2024-12-04 21:52:57	2024-12-04 21:52:57
2904	6	18	2024-12-04 21:52:57	2024-12-04 21:52:57
2905	6	19	2024-12-04 21:52:57	2024-12-04 21:52:57
2906	6	20	2024-12-04 21:52:57	2024-12-04 21:52:57
2907	6	21	2024-12-04 21:52:57	2024-12-04 21:52:57
2908	6	22	2024-12-04 21:52:57	2024-12-04 21:52:57
2909	6	23	2024-12-04 21:52:57	2024-12-04 21:52:57
2910	6	448	2024-12-04 21:52:57	2024-12-04 21:52:57
2911	6	441	2024-12-04 21:52:57	2024-12-04 21:52:57
2912	6	442	2024-12-04 21:52:57	2024-12-04 21:52:57
2913	6	546	2024-12-04 21:52:57	2024-12-04 21:52:57
2914	6	584	2024-12-04 21:52:57	2024-12-04 21:52:57
2915	6	614	2024-12-04 21:52:57	2024-12-04 21:52:57
2916	6	615	2024-12-04 21:52:57	2024-12-04 21:52:57
2917	6	617	2024-12-04 21:52:57	2024-12-04 21:52:57
2918	6	618	2024-12-04 21:52:57	2024-12-04 21:52:57
2919	6	224	2024-12-04 21:52:57	2024-12-04 21:52:57
2920	6	225	2024-12-04 21:52:57	2024-12-04 21:52:57
2921	6	226	2024-12-04 21:52:57	2024-12-04 21:52:57
2922	6	227	2024-12-04 21:52:57	2024-12-04 21:52:57
2923	6	228	2024-12-04 21:52:57	2024-12-04 21:52:57
2924	6	229	2024-12-04 21:52:57	2024-12-04 21:52:57
2925	6	230	2024-12-04 21:52:57	2024-12-04 21:52:57
2926	6	231	2024-12-04 21:52:57	2024-12-04 21:52:57
2927	6	232	2024-12-04 21:52:57	2024-12-04 21:52:57
2928	6	233	2024-12-04 21:52:57	2024-12-04 21:52:57
2929	6	359	2024-12-04 21:52:57	2024-12-04 21:52:57
2930	6	360	2024-12-04 21:52:57	2024-12-04 21:52:57
2931	6	234	2024-12-04 21:52:57	2024-12-04 21:52:57
2932	6	235	2024-12-04 21:52:57	2024-12-04 21:52:57
2933	6	236	2024-12-04 21:52:57	2024-12-04 21:52:57
2934	6	237	2024-12-04 21:52:57	2024-12-04 21:52:57
2935	6	238	2024-12-04 21:52:57	2024-12-04 21:52:57
2936	6	239	2024-12-04 21:52:57	2024-12-04 21:52:57
2937	6	240	2024-12-04 21:52:57	2024-12-04 21:52:57
2938	6	241	2024-12-04 21:52:57	2024-12-04 21:52:57
2939	6	242	2024-12-04 21:52:57	2024-12-04 21:52:57
2940	6	243	2024-12-04 21:52:57	2024-12-04 21:52:57
2941	6	244	2024-12-04 21:52:57	2024-12-04 21:52:57
2942	6	245	2024-12-04 21:52:57	2024-12-04 21:52:57
2943	6	246	2024-12-04 21:52:57	2024-12-04 21:52:57
2944	6	247	2024-12-04 21:52:57	2024-12-04 21:52:57
2945	6	248	2024-12-04 21:52:57	2024-12-04 21:52:57
2946	6	249	2024-12-04 21:52:57	2024-12-04 21:52:57
2947	6	250	2024-12-04 21:52:57	2024-12-04 21:52:57
2948	6	251	2024-12-04 21:52:58	2024-12-04 21:52:58
2949	6	252	2024-12-04 21:52:58	2024-12-04 21:52:58
2950	6	253	2024-12-04 21:52:58	2024-12-04 21:52:58
2951	6	254	2024-12-04 21:52:58	2024-12-04 21:52:58
2952	6	255	2024-12-04 21:52:58	2024-12-04 21:52:58
2953	6	256	2024-12-04 21:52:58	2024-12-04 21:52:58
2954	6	257	2024-12-04 21:52:58	2024-12-04 21:52:58
2955	6	258	2024-12-04 21:52:58	2024-12-04 21:52:58
2956	6	259	2024-12-04 21:52:58	2024-12-04 21:52:58
2957	6	260	2024-12-04 21:52:58	2024-12-04 21:52:58
2958	6	261	2024-12-04 21:52:58	2024-12-04 21:52:58
2959	6	262	2024-12-04 21:52:58	2024-12-04 21:52:58
2960	6	263	2024-12-04 21:52:58	2024-12-04 21:52:58
2961	6	264	2024-12-04 21:52:58	2024-12-04 21:52:58
2962	6	509	2024-12-04 21:52:58	2024-12-04 21:52:58
2963	6	265	2024-12-04 21:52:58	2024-12-04 21:52:58
2964	6	266	2024-12-04 21:52:58	2024-12-04 21:52:58
2965	6	267	2024-12-04 21:52:58	2024-12-04 21:52:58
2966	6	268	2024-12-04 21:52:58	2024-12-04 21:52:58
2967	6	269	2024-12-04 21:52:58	2024-12-04 21:52:58
2968	6	270	2024-12-04 21:52:58	2024-12-04 21:52:58
2969	6	271	2024-12-04 21:52:58	2024-12-04 21:52:58
2970	6	272	2024-12-04 21:52:58	2024-12-04 21:52:58
2971	6	273	2024-12-04 21:52:58	2024-12-04 21:52:58
2972	6	274	2024-12-04 21:52:58	2024-12-04 21:52:58
2973	6	275	2024-12-04 21:52:58	2024-12-04 21:52:58
2974	6	276	2024-12-04 21:52:58	2024-12-04 21:52:58
2975	6	277	2024-12-04 21:52:58	2024-12-04 21:52:58
2976	6	278	2024-12-04 21:52:58	2024-12-04 21:52:58
2977	6	279	2024-12-04 21:52:58	2024-12-04 21:52:58
2978	6	280	2024-12-04 21:52:58	2024-12-04 21:52:58
2979	6	281	2024-12-04 21:52:58	2024-12-04 21:52:58
2980	6	282	2024-12-04 21:52:58	2024-12-04 21:52:58
2981	6	283	2024-12-04 21:52:58	2024-12-04 21:52:58
2982	6	284	2024-12-04 21:52:58	2024-12-04 21:52:58
2983	6	285	2024-12-04 21:52:58	2024-12-04 21:52:58
2984	6	286	2024-12-04 21:52:58	2024-12-04 21:52:58
2985	6	287	2024-12-04 21:52:58	2024-12-04 21:52:58
2986	6	288	2024-12-04 21:52:58	2024-12-04 21:52:58
2987	6	289	2024-12-04 21:52:58	2024-12-04 21:52:58
2988	6	294	2024-12-04 21:52:58	2024-12-04 21:52:58
2989	6	295	2024-12-04 21:52:58	2024-12-04 21:52:58
2990	6	296	2024-12-04 21:52:58	2024-12-04 21:52:58
2991	6	297	2024-12-04 21:52:58	2024-12-04 21:52:58
2992	6	500	2024-12-04 21:52:58	2024-12-04 21:52:58
2993	6	501	2024-12-04 21:52:58	2024-12-04 21:52:58
2994	6	502	2024-12-04 21:52:58	2024-12-04 21:52:58
2995	6	510	2024-12-04 21:52:58	2024-12-04 21:52:58
2996	6	511	2024-12-04 21:52:58	2024-12-04 21:52:58
2997	6	512	2024-12-04 21:52:58	2024-12-04 21:52:58
2998	6	567	2024-12-04 21:52:58	2024-12-04 21:52:58
2999	6	594	2024-12-04 21:52:58	2024-12-04 21:52:58
3000	6	679	2024-12-04 21:52:58	2024-12-04 21:52:58
3001	6	298	2024-12-04 21:52:58	2024-12-04 21:52:58
3002	6	299	2024-12-04 21:52:58	2024-12-04 21:52:58
3003	6	26	2024-12-04 21:52:58	2024-12-04 21:52:58
3004	6	28	2024-12-04 21:52:58	2024-12-04 21:52:58
3005	6	29	2024-12-04 21:52:58	2024-12-04 21:52:58
3006	6	30	2024-12-04 21:52:58	2024-12-04 21:52:58
3007	6	31	2024-12-04 21:52:58	2024-12-04 21:52:58
3008	6	32	2024-12-04 21:52:58	2024-12-04 21:52:58
3009	6	33	2024-12-04 21:52:58	2024-12-04 21:52:58
3010	6	367	2024-12-04 21:52:58	2024-12-04 21:52:58
3011	6	368	2024-12-04 21:52:58	2024-12-04 21:52:58
3012	6	369	2024-12-04 21:52:58	2024-12-04 21:52:58
3013	6	370	2024-12-04 21:52:58	2024-12-04 21:52:58
3014	6	371	2024-12-04 21:52:58	2024-12-04 21:52:58
3015	6	373	2024-12-04 21:52:58	2024-12-04 21:52:58
3016	6	395	2024-12-04 21:52:58	2024-12-04 21:52:58
3017	6	39	2024-12-04 21:52:58	2024-12-04 21:52:58
3018	6	379	2024-12-04 21:52:58	2024-12-04 21:52:58
3019	6	380	2024-12-04 21:52:58	2024-12-04 21:52:58
3020	6	34	2024-12-04 21:52:58	2024-12-04 21:52:58
3021	6	35	2024-12-04 21:52:58	2024-12-04 21:52:58
3022	6	36	2024-12-04 21:52:58	2024-12-04 21:52:58
3023	6	37	2024-12-04 21:52:58	2024-12-04 21:52:58
3024	6	38	2024-12-04 21:52:58	2024-12-04 21:52:58
3025	6	424	2024-12-04 21:52:58	2024-12-04 21:52:58
3026	6	425	2024-12-04 21:52:58	2024-12-04 21:52:58
3027	6	427	2024-12-04 21:52:58	2024-12-04 21:52:58
3028	6	443	2024-12-04 21:52:58	2024-12-04 21:52:58
3029	6	449	2024-12-04 21:52:58	2024-12-04 21:52:58
3030	6	453	2024-12-04 21:52:58	2024-12-04 21:52:58
3031	6	454	2024-12-04 21:52:58	2024-12-04 21:52:58
3032	6	464	2024-12-04 21:52:58	2024-12-04 21:52:58
3033	6	450	2024-12-04 21:52:58	2024-12-04 21:52:58
3034	6	498	2024-12-04 21:52:58	2024-12-04 21:52:58
3035	6	499	2024-12-04 21:52:58	2024-12-04 21:52:58
3036	6	513	2024-12-04 21:52:58	2024-12-04 21:52:58
3037	6	514	2024-12-04 21:52:59	2024-12-04 21:52:59
3038	6	515	2024-12-04 21:52:59	2024-12-04 21:52:59
3039	6	516	2024-12-04 21:52:59	2024-12-04 21:52:59
3040	6	517	2024-12-04 21:52:59	2024-12-04 21:52:59
3041	6	518	2024-12-04 21:52:59	2024-12-04 21:52:59
3042	6	520	2024-12-04 21:52:59	2024-12-04 21:52:59
3043	6	521	2024-12-04 21:52:59	2024-12-04 21:52:59
3044	6	522	2024-12-04 21:52:59	2024-12-04 21:52:59
3045	6	523	2024-12-04 21:52:59	2024-12-04 21:52:59
3046	6	531	2024-12-04 21:52:59	2024-12-04 21:52:59
3047	6	547	2024-12-04 21:52:59	2024-12-04 21:52:59
3048	6	548	2024-12-04 21:52:59	2024-12-04 21:52:59
3049	6	549	2024-12-04 21:52:59	2024-12-04 21:52:59
3050	6	550	2024-12-04 21:52:59	2024-12-04 21:52:59
3051	6	553	2024-12-04 21:52:59	2024-12-04 21:52:59
3052	6	554	2024-12-04 21:52:59	2024-12-04 21:52:59
3053	6	586	2024-12-04 21:52:59	2024-12-04 21:52:59
3054	6	593	2024-12-04 21:52:59	2024-12-04 21:52:59
3055	6	652	2024-12-04 21:52:59	2024-12-04 21:52:59
3056	6	653	2024-12-04 21:52:59	2024-12-04 21:52:59
3057	6	654	2024-12-04 21:52:59	2024-12-04 21:52:59
3058	6	655	2024-12-04 21:52:59	2024-12-04 21:52:59
3059	6	656	2024-12-04 21:52:59	2024-12-04 21:52:59
3060	6	657	2024-12-04 21:52:59	2024-12-04 21:52:59
3061	6	658	2024-12-04 21:52:59	2024-12-04 21:52:59
3062	6	682	2024-12-04 21:52:59	2024-12-04 21:52:59
3063	6	683	2024-12-04 21:52:59	2024-12-04 21:52:59
3064	6	684	2024-12-04 21:52:59	2024-12-04 21:52:59
3065	6	685	2024-12-04 21:52:59	2024-12-04 21:52:59
3066	6	686	2024-12-04 21:52:59	2024-12-04 21:52:59
3067	6	687	2024-12-04 21:52:59	2024-12-04 21:52:59
3068	6	688	2024-12-04 21:52:59	2024-12-04 21:52:59
3069	6	27	2024-12-04 21:52:59	2024-12-04 21:52:59
3070	6	692	2024-12-04 21:52:59	2024-12-04 21:52:59
3071	6	40	2024-12-04 21:52:59	2024-12-04 21:52:59
3072	6	44	2024-12-04 21:52:59	2024-12-04 21:52:59
3073	6	45	2024-12-04 21:52:59	2024-12-04 21:52:59
3074	6	46	2024-12-04 21:52:59	2024-12-04 21:52:59
3075	6	47	2024-12-04 21:52:59	2024-12-04 21:52:59
3076	6	48	2024-12-04 21:52:59	2024-12-04 21:52:59
3077	6	49	2024-12-04 21:52:59	2024-12-04 21:52:59
3078	6	50	2024-12-04 21:52:59	2024-12-04 21:52:59
3079	6	51	2024-12-04 21:52:59	2024-12-04 21:52:59
3080	6	52	2024-12-04 21:52:59	2024-12-04 21:52:59
3081	6	372	2024-12-04 21:52:59	2024-12-04 21:52:59
3082	6	384	2024-12-04 21:52:59	2024-12-04 21:52:59
3083	6	41	2024-12-04 21:52:59	2024-12-04 21:52:59
3084	6	42	2024-12-04 21:52:59	2024-12-04 21:52:59
3085	6	43	2024-12-04 21:52:59	2024-12-04 21:52:59
3086	6	529	2024-12-04 21:52:59	2024-12-04 21:52:59
3087	6	526	2024-12-04 21:52:59	2024-12-04 21:52:59
3088	6	525	2024-12-04 21:52:59	2024-12-04 21:52:59
3089	6	527	2024-12-04 21:52:59	2024-12-04 21:52:59
3090	6	530	2024-12-04 21:52:59	2024-12-04 21:52:59
3091	6	519	2024-12-04 21:52:59	2024-12-04 21:52:59
3092	6	587	2024-12-04 21:52:59	2024-12-04 21:52:59
3093	6	592	2024-12-04 21:52:59	2024-12-04 21:52:59
3094	6	648	2024-12-04 21:52:59	2024-12-04 21:52:59
3095	6	524	2024-12-04 21:52:59	2024-12-04 21:52:59
3096	6	588	2024-12-04 21:52:59	2024-12-04 21:52:59
3097	6	616	2024-12-04 21:52:59	2024-12-04 21:52:59
3098	6	452	2024-12-04 21:52:59	2024-12-04 21:52:59
3099	6	589	2024-12-04 21:52:59	2024-12-04 21:52:59
3100	6	665	2024-12-04 21:52:59	2024-12-04 21:52:59
3101	6	693	2024-12-04 21:52:59	2024-12-04 21:52:59
3102	6	694	2024-12-04 21:52:59	2024-12-04 21:52:59
3103	6	695	2024-12-04 21:52:59	2024-12-04 21:52:59
3104	6	53	2024-12-04 21:52:59	2024-12-04 21:52:59
3105	6	54	2024-12-04 21:52:59	2024-12-04 21:52:59
3106	6	55	2024-12-04 21:52:59	2024-12-04 21:52:59
3107	6	56	2024-12-04 21:52:59	2024-12-04 21:52:59
3108	6	57	2024-12-04 21:52:59	2024-12-04 21:52:59
3109	6	58	2024-12-04 21:52:59	2024-12-04 21:52:59
3110	6	59	2024-12-04 21:52:59	2024-12-04 21:52:59
3111	6	60	2024-12-04 21:52:59	2024-12-04 21:52:59
3112	6	61	2024-12-04 21:52:59	2024-12-04 21:52:59
3113	6	62	2024-12-04 21:52:59	2024-12-04 21:52:59
3114	6	63	2024-12-04 21:52:59	2024-12-04 21:52:59
3115	6	64	2024-12-04 21:52:59	2024-12-04 21:52:59
3116	6	65	2024-12-04 21:52:59	2024-12-04 21:52:59
3117	6	66	2024-12-04 21:52:59	2024-12-04 21:52:59
3118	6	67	2024-12-04 21:52:59	2024-12-04 21:52:59
3119	6	68	2024-12-04 21:52:59	2024-12-04 21:52:59
3120	6	69	2024-12-04 21:52:59	2024-12-04 21:52:59
3121	6	70	2024-12-04 21:52:59	2024-12-04 21:52:59
3122	6	71	2024-12-04 21:52:59	2024-12-04 21:52:59
3123	6	72	2024-12-04 21:52:59	2024-12-04 21:52:59
3124	6	73	2024-12-04 21:52:59	2024-12-04 21:52:59
3125	6	74	2024-12-04 21:52:59	2024-12-04 21:52:59
3126	6	75	2024-12-04 21:52:59	2024-12-04 21:52:59
3127	6	76	2024-12-04 21:52:59	2024-12-04 21:52:59
3128	6	77	2024-12-04 21:52:59	2024-12-04 21:52:59
3129	6	451	2024-12-04 21:52:59	2024-12-04 21:52:59
3130	6	477	2024-12-04 21:52:59	2024-12-04 21:52:59
3131	6	585	2024-12-04 21:52:59	2024-12-04 21:52:59
3132	6	669	2024-12-04 21:52:59	2024-12-04 21:52:59
3133	6	670	2024-12-04 21:52:59	2024-12-04 21:52:59
3134	6	671	2024-12-04 21:52:59	2024-12-04 21:52:59
3135	6	672	2024-12-04 21:52:59	2024-12-04 21:52:59
3136	6	680	2024-12-04 21:52:59	2024-12-04 21:52:59
3137	6	681	2024-12-04 21:52:59	2024-12-04 21:52:59
3138	6	689	2024-12-04 21:52:59	2024-12-04 21:52:59
3139	6	78	2024-12-04 21:52:59	2024-12-04 21:52:59
3140	6	79	2024-12-04 21:52:59	2024-12-04 21:52:59
3141	6	80	2024-12-04 21:52:59	2024-12-04 21:52:59
3142	6	81	2024-12-04 21:52:59	2024-12-04 21:52:59
3143	6	82	2024-12-04 21:52:59	2024-12-04 21:52:59
3144	6	83	2024-12-04 21:52:59	2024-12-04 21:52:59
3145	6	84	2024-12-04 21:53:00	2024-12-04 21:53:00
3146	6	85	2024-12-04 21:53:00	2024-12-04 21:53:00
3147	6	86	2024-12-04 21:53:00	2024-12-04 21:53:00
3148	6	87	2024-12-04 21:53:00	2024-12-04 21:53:00
3149	6	88	2024-12-04 21:53:00	2024-12-04 21:53:00
3150	6	89	2024-12-04 21:53:00	2024-12-04 21:53:00
3151	6	90	2024-12-04 21:53:00	2024-12-04 21:53:00
3152	6	91	2024-12-04 21:53:00	2024-12-04 21:53:00
3153	6	92	2024-12-04 21:53:00	2024-12-04 21:53:00
3154	6	93	2024-12-04 21:53:00	2024-12-04 21:53:00
3155	6	94	2024-12-04 21:53:00	2024-12-04 21:53:00
3156	6	374	2024-12-04 21:53:00	2024-12-04 21:53:00
3157	6	375	2024-12-04 21:53:00	2024-12-04 21:53:00
3158	6	397	2024-12-04 21:53:00	2024-12-04 21:53:00
3159	6	398	2024-12-04 21:53:00	2024-12-04 21:53:00
3160	6	541	2024-12-04 21:53:00	2024-12-04 21:53:00
3161	6	543	2024-12-04 21:53:00	2024-12-04 21:53:00
3162	6	545	2024-12-04 21:53:00	2024-12-04 21:53:00
3163	6	95	2024-12-04 21:53:00	2024-12-04 21:53:00
3164	6	96	2024-12-04 21:53:00	2024-12-04 21:53:00
3165	6	97	2024-12-04 21:53:00	2024-12-04 21:53:00
3166	6	98	2024-12-04 21:53:00	2024-12-04 21:53:00
3167	6	99	2024-12-04 21:53:00	2024-12-04 21:53:00
3168	6	100	2024-12-04 21:53:00	2024-12-04 21:53:00
3169	6	101	2024-12-04 21:53:00	2024-12-04 21:53:00
3170	6	102	2024-12-04 21:53:00	2024-12-04 21:53:00
3171	6	103	2024-12-04 21:53:00	2024-12-04 21:53:00
3172	6	104	2024-12-04 21:53:00	2024-12-04 21:53:00
3173	6	361	2024-12-04 21:53:00	2024-12-04 21:53:00
3174	6	362	2024-12-04 21:53:00	2024-12-04 21:53:00
3175	6	363	2024-12-04 21:53:00	2024-12-04 21:53:00
3176	6	364	2024-12-04 21:53:00	2024-12-04 21:53:00
3177	6	366	2024-12-04 21:53:00	2024-12-04 21:53:00
3178	6	376	2024-12-04 21:53:00	2024-12-04 21:53:00
3179	6	377	2024-12-04 21:53:00	2024-12-04 21:53:00
3180	6	105	2024-12-04 21:53:00	2024-12-04 21:53:00
3181	6	106	2024-12-04 21:53:00	2024-12-04 21:53:00
3182	6	107	2024-12-04 21:53:00	2024-12-04 21:53:00
3183	6	108	2024-12-04 21:53:00	2024-12-04 21:53:00
3184	6	109	2024-12-04 21:53:00	2024-12-04 21:53:00
3185	6	110	2024-12-04 21:53:00	2024-12-04 21:53:00
3186	6	111	2024-12-04 21:53:00	2024-12-04 21:53:00
3187	6	112	2024-12-04 21:53:00	2024-12-04 21:53:00
3188	6	113	2024-12-04 21:53:00	2024-12-04 21:53:00
3189	6	114	2024-12-04 21:53:00	2024-12-04 21:53:00
3190	6	115	2024-12-04 21:53:00	2024-12-04 21:53:00
3191	6	116	2024-12-04 21:53:00	2024-12-04 21:53:00
3192	6	117	2024-12-04 21:53:00	2024-12-04 21:53:00
3193	6	507	2024-12-04 21:53:00	2024-12-04 21:53:00
3194	6	508	2024-12-04 21:53:00	2024-12-04 21:53:00
3195	6	532	2024-12-04 21:53:00	2024-12-04 21:53:00
3196	6	540	2024-12-04 21:53:00	2024-12-04 21:53:00
3197	6	542	2024-12-04 21:53:00	2024-12-04 21:53:00
3198	6	544	2024-12-04 21:53:00	2024-12-04 21:53:00
3199	6	564	2024-12-04 21:53:00	2024-12-04 21:53:00
3200	6	565	2024-12-04 21:53:00	2024-12-04 21:53:00
3201	6	566	2024-12-04 21:53:00	2024-12-04 21:53:00
3202	6	650	2024-12-04 21:53:00	2024-12-04 21:53:00
3203	6	660	2024-12-04 21:53:00	2024-12-04 21:53:00
3204	6	661	2024-12-04 21:53:00	2024-12-04 21:53:00
3205	6	663	2024-12-04 21:53:00	2024-12-04 21:53:00
3206	6	664	2024-12-04 21:53:00	2024-12-04 21:53:00
3207	6	666	2024-12-04 21:53:00	2024-12-04 21:53:00
3208	6	674	2024-12-04 21:53:00	2024-12-04 21:53:00
3209	6	675	2024-12-04 21:53:00	2024-12-04 21:53:00
3210	6	118	2024-12-04 21:53:00	2024-12-04 21:53:00
3211	6	119	2024-12-04 21:53:00	2024-12-04 21:53:00
3212	6	120	2024-12-04 21:53:00	2024-12-04 21:53:00
3213	6	121	2024-12-04 21:53:00	2024-12-04 21:53:00
3214	6	122	2024-12-04 21:53:00	2024-12-04 21:53:00
3215	6	123	2024-12-04 21:53:00	2024-12-04 21:53:00
3216	6	124	2024-12-04 21:53:00	2024-12-04 21:53:00
3217	6	125	2024-12-04 21:53:00	2024-12-04 21:53:00
3218	6	126	2024-12-04 21:53:00	2024-12-04 21:53:00
3219	6	127	2024-12-04 21:53:00	2024-12-04 21:53:00
3220	6	128	2024-12-04 21:53:00	2024-12-04 21:53:00
3221	6	129	2024-12-04 21:53:00	2024-12-04 21:53:00
3222	6	130	2024-12-04 21:53:00	2024-12-04 21:53:00
3223	6	329	2024-12-04 21:53:00	2024-12-04 21:53:00
3224	6	330	2024-12-04 21:53:00	2024-12-04 21:53:00
3225	6	331	2024-12-04 21:53:00	2024-12-04 21:53:00
3226	6	332	2024-12-04 21:53:00	2024-12-04 21:53:00
3227	6	340	2024-12-04 21:53:00	2024-12-04 21:53:00
3228	6	131	2024-12-04 21:53:00	2024-12-04 21:53:00
3229	6	132	2024-12-04 21:53:00	2024-12-04 21:53:00
3230	6	133	2024-12-04 21:53:00	2024-12-04 21:53:00
3231	6	134	2024-12-04 21:53:00	2024-12-04 21:53:00
3232	6	135	2024-12-04 21:53:00	2024-12-04 21:53:00
3233	6	136	2024-12-04 21:53:00	2024-12-04 21:53:00
3234	6	137	2024-12-04 21:53:00	2024-12-04 21:53:00
3235	6	138	2024-12-04 21:53:00	2024-12-04 21:53:00
3236	6	139	2024-12-04 21:53:00	2024-12-04 21:53:00
3237	6	140	2024-12-04 21:53:00	2024-12-04 21:53:00
3238	6	141	2024-12-04 21:53:00	2024-12-04 21:53:00
3239	6	143	2024-12-04 21:53:00	2024-12-04 21:53:00
3240	6	144	2024-12-04 21:53:00	2024-12-04 21:53:00
3241	6	145	2024-12-04 21:53:00	2024-12-04 21:53:00
3242	6	146	2024-12-04 21:53:00	2024-12-04 21:53:00
3243	6	147	2024-12-04 21:53:00	2024-12-04 21:53:00
3244	6	148	2024-12-04 21:53:00	2024-12-04 21:53:00
3245	6	152	2024-12-04 21:53:00	2024-12-04 21:53:00
3246	6	153	2024-12-04 21:53:00	2024-12-04 21:53:00
3247	6	154	2024-12-04 21:53:00	2024-12-04 21:53:00
3248	6	155	2024-12-04 21:53:00	2024-12-04 21:53:00
3249	6	156	2024-12-04 21:53:00	2024-12-04 21:53:00
3250	6	157	2024-12-04 21:53:00	2024-12-04 21:53:00
3251	6	158	2024-12-04 21:53:00	2024-12-04 21:53:00
3252	6	159	2024-12-04 21:53:00	2024-12-04 21:53:00
3253	6	160	2024-12-04 21:53:00	2024-12-04 21:53:00
3254	6	161	2024-12-04 21:53:00	2024-12-04 21:53:00
3255	6	162	2024-12-04 21:53:00	2024-12-04 21:53:00
3256	6	163	2024-12-04 21:53:00	2024-12-04 21:53:00
3257	6	164	2024-12-04 21:53:00	2024-12-04 21:53:00
3258	6	165	2024-12-04 21:53:01	2024-12-04 21:53:01
3259	6	166	2024-12-04 21:53:01	2024-12-04 21:53:01
3260	6	167	2024-12-04 21:53:01	2024-12-04 21:53:01
3261	6	168	2024-12-04 21:53:01	2024-12-04 21:53:01
3262	6	169	2024-12-04 21:53:01	2024-12-04 21:53:01
3263	6	170	2024-12-04 21:53:01	2024-12-04 21:53:01
3264	6	171	2024-12-04 21:53:01	2024-12-04 21:53:01
3265	6	172	2024-12-04 21:53:01	2024-12-04 21:53:01
3266	6	173	2024-12-04 21:53:01	2024-12-04 21:53:01
3267	6	426	2024-12-04 21:53:01	2024-12-04 21:53:01
3268	6	341	2024-12-04 21:53:01	2024-12-04 21:53:01
3269	6	342	2024-12-04 21:53:01	2024-12-04 21:53:01
3270	6	343	2024-12-04 21:53:01	2024-12-04 21:53:01
3271	6	346	2024-12-04 21:53:01	2024-12-04 21:53:01
3272	6	347	2024-12-04 21:53:01	2024-12-04 21:53:01
3273	6	348	2024-12-04 21:53:01	2024-12-04 21:53:01
3274	6	349	2024-12-04 21:53:01	2024-12-04 21:53:01
3275	6	536	2024-12-04 21:53:01	2024-12-04 21:53:01
3276	6	537	2024-12-04 21:53:01	2024-12-04 21:53:01
3277	6	538	2024-12-04 21:53:01	2024-12-04 21:53:01
3278	6	560	2024-12-04 21:53:01	2024-12-04 21:53:01
3279	6	561	2024-12-04 21:53:01	2024-12-04 21:53:01
3280	6	562	2024-12-04 21:53:01	2024-12-04 21:53:01
3281	6	199	2024-12-04 21:53:01	2024-12-04 21:53:01
3282	6	690	2024-12-04 21:53:01	2024-12-04 21:53:01
3283	6	344	2024-12-04 21:53:01	2024-12-04 21:53:01
3284	6	345	2024-12-04 21:53:01	2024-12-04 21:53:01
3285	6	691	2024-12-04 21:53:01	2024-12-04 21:53:01
3286	6	174	2024-12-04 21:53:01	2024-12-04 21:53:01
3287	6	176	2024-12-04 21:53:01	2024-12-04 21:53:01
3288	6	177	2024-12-04 21:53:01	2024-12-04 21:53:01
3289	6	178	2024-12-04 21:53:01	2024-12-04 21:53:01
3290	6	179	2024-12-04 21:53:01	2024-12-04 21:53:01
3291	6	180	2024-12-04 21:53:01	2024-12-04 21:53:01
3292	6	181	2024-12-04 21:53:01	2024-12-04 21:53:01
3293	6	182	2024-12-04 21:53:01	2024-12-04 21:53:01
3294	6	183	2024-12-04 21:53:01	2024-12-04 21:53:01
3295	6	184	2024-12-04 21:53:01	2024-12-04 21:53:01
3296	6	185	2024-12-04 21:53:01	2024-12-04 21:53:01
3297	6	186	2024-12-04 21:53:01	2024-12-04 21:53:01
3298	6	187	2024-12-04 21:53:01	2024-12-04 21:53:01
3299	6	188	2024-12-04 21:53:01	2024-12-04 21:53:01
3300	6	189	2024-12-04 21:53:01	2024-12-04 21:53:01
3301	6	190	2024-12-04 21:53:01	2024-12-04 21:53:01
3302	6	191	2024-12-04 21:53:01	2024-12-04 21:53:01
3303	6	192	2024-12-04 21:53:01	2024-12-04 21:53:01
3304	6	193	2024-12-04 21:53:01	2024-12-04 21:53:01
3305	6	194	2024-12-04 21:53:01	2024-12-04 21:53:01
3306	6	200	2024-12-04 21:53:01	2024-12-04 21:53:01
3307	6	201	2024-12-04 21:53:01	2024-12-04 21:53:01
3308	6	202	2024-12-04 21:53:01	2024-12-04 21:53:01
3309	6	207	2024-12-04 21:53:01	2024-12-04 21:53:01
3310	6	208	2024-12-04 21:53:01	2024-12-04 21:53:01
3311	6	209	2024-12-04 21:53:01	2024-12-04 21:53:01
3312	6	210	2024-12-04 21:53:01	2024-12-04 21:53:01
3313	6	211	2024-12-04 21:53:01	2024-12-04 21:53:01
3314	6	212	2024-12-04 21:53:01	2024-12-04 21:53:01
3315	6	213	2024-12-04 21:53:01	2024-12-04 21:53:01
3316	6	215	2024-12-04 21:53:01	2024-12-04 21:53:01
3317	6	335	2024-12-04 21:53:01	2024-12-04 21:53:01
3318	6	336	2024-12-04 21:53:01	2024-12-04 21:53:01
3319	6	337	2024-12-04 21:53:01	2024-12-04 21:53:01
3320	6	338	2024-12-04 21:53:01	2024-12-04 21:53:01
3321	6	381	2024-12-04 21:53:01	2024-12-04 21:53:01
3322	6	382	2024-12-04 21:53:01	2024-12-04 21:53:01
3323	6	383	2024-12-04 21:53:01	2024-12-04 21:53:01
3324	6	175	2024-12-04 21:53:01	2024-12-04 21:53:01
3325	6	214	2024-12-04 21:53:01	2024-12-04 21:53:01
3326	6	216	2024-12-04 21:53:01	2024-12-04 21:53:01
3327	6	217	2024-12-04 21:53:01	2024-12-04 21:53:01
3328	6	218	2024-12-04 21:53:01	2024-12-04 21:53:01
3329	6	219	2024-12-04 21:53:01	2024-12-04 21:53:01
3330	6	220	2024-12-04 21:53:02	2024-12-04 21:53:02
3331	6	221	2024-12-04 21:53:02	2024-12-04 21:53:02
3332	6	222	2024-12-04 21:53:02	2024-12-04 21:53:02
3333	6	223	2024-12-04 21:53:02	2024-12-04 21:53:02
3334	6	533	2024-12-04 21:53:02	2024-12-04 21:53:02
3335	6	534	2024-12-04 21:53:02	2024-12-04 21:53:02
3336	6	539	2024-12-04 21:53:02	2024-12-04 21:53:02
3337	6	535	2024-12-04 21:53:02	2024-12-04 21:53:02
3338	6	647	2024-12-04 21:53:02	2024-12-04 21:53:02
3339	6	673	2024-12-04 21:53:02	2024-12-04 21:53:02
3340	7	14	2025-05-12 09:12:24	2025-05-12 09:12:24
3341	7	15	2025-05-12 09:12:24	2025-05-12 09:12:24
3342	7	16	2025-05-12 09:12:24	2025-05-12 09:12:24
3343	7	17	2025-05-12 09:12:24	2025-05-12 09:12:24
3344	7	18	2025-05-12 09:12:24	2025-05-12 09:12:24
3345	7	19	2025-05-12 09:12:24	2025-05-12 09:12:24
3346	7	20	2025-05-12 09:12:24	2025-05-12 09:12:24
3347	7	21	2025-05-12 09:12:24	2025-05-12 09:12:24
3348	7	22	2025-05-12 09:12:24	2025-05-12 09:12:24
3349	7	23	2025-05-12 09:12:24	2025-05-12 09:12:24
3350	7	24	2025-05-12 09:12:24	2025-05-12 09:12:24
3351	7	448	2025-05-12 09:12:24	2025-05-12 09:12:24
3352	7	441	2025-05-12 09:12:24	2025-05-12 09:12:24
3353	7	442	2025-05-12 09:12:24	2025-05-12 09:12:24
3354	7	546	2025-05-12 09:12:24	2025-05-12 09:12:24
3355	7	584	2025-05-12 09:12:24	2025-05-12 09:12:24
3356	7	614	2025-05-12 09:12:24	2025-05-12 09:12:24
3357	7	615	2025-05-12 09:12:24	2025-05-12 09:12:24
3358	7	617	2025-05-12 09:12:24	2025-05-12 09:12:24
3359	7	618	2025-05-12 09:12:24	2025-05-12 09:12:24
3360	7	224	2025-05-12 09:12:24	2025-05-12 09:12:24
3361	7	225	2025-05-12 09:12:24	2025-05-12 09:12:24
3362	7	226	2025-05-12 09:12:24	2025-05-12 09:12:24
3363	7	227	2025-05-12 09:12:24	2025-05-12 09:12:24
3364	7	228	2025-05-12 09:12:24	2025-05-12 09:12:24
3365	7	229	2025-05-12 09:12:24	2025-05-12 09:12:24
3366	7	230	2025-05-12 09:12:24	2025-05-12 09:12:24
3367	7	231	2025-05-12 09:12:24	2025-05-12 09:12:24
3368	7	232	2025-05-12 09:12:24	2025-05-12 09:12:24
3369	7	233	2025-05-12 09:12:24	2025-05-12 09:12:24
3370	7	359	2025-05-12 09:12:24	2025-05-12 09:12:24
3371	7	360	2025-05-12 09:12:24	2025-05-12 09:12:24
3372	7	234	2025-05-12 09:12:24	2025-05-12 09:12:24
3373	7	235	2025-05-12 09:12:24	2025-05-12 09:12:24
3374	7	236	2025-05-12 09:12:24	2025-05-12 09:12:24
3375	7	237	2025-05-12 09:12:24	2025-05-12 09:12:24
3376	7	238	2025-05-12 09:12:24	2025-05-12 09:12:24
3377	7	239	2025-05-12 09:12:24	2025-05-12 09:12:24
3378	7	240	2025-05-12 09:12:24	2025-05-12 09:12:24
3379	7	241	2025-05-12 09:12:24	2025-05-12 09:12:24
3380	7	242	2025-05-12 09:12:24	2025-05-12 09:12:24
3381	7	243	2025-05-12 09:12:24	2025-05-12 09:12:24
3382	7	244	2025-05-12 09:12:24	2025-05-12 09:12:24
3383	7	245	2025-05-12 09:12:24	2025-05-12 09:12:24
3384	7	246	2025-05-12 09:12:24	2025-05-12 09:12:24
3385	7	247	2025-05-12 09:12:24	2025-05-12 09:12:24
3386	7	248	2025-05-12 09:12:24	2025-05-12 09:12:24
3387	7	249	2025-05-12 09:12:24	2025-05-12 09:12:24
3388	7	250	2025-05-12 09:12:24	2025-05-12 09:12:24
3389	7	251	2025-05-12 09:12:24	2025-05-12 09:12:24
3390	7	252	2025-05-12 09:12:24	2025-05-12 09:12:24
3391	7	253	2025-05-12 09:12:24	2025-05-12 09:12:24
3392	7	254	2025-05-12 09:12:24	2025-05-12 09:12:24
3393	7	255	2025-05-12 09:12:24	2025-05-12 09:12:24
3394	7	256	2025-05-12 09:12:24	2025-05-12 09:12:24
3395	7	257	2025-05-12 09:12:24	2025-05-12 09:12:24
3396	7	258	2025-05-12 09:12:24	2025-05-12 09:12:24
3397	7	259	2025-05-12 09:12:24	2025-05-12 09:12:24
3398	7	260	2025-05-12 09:12:24	2025-05-12 09:12:24
3399	7	261	2025-05-12 09:12:24	2025-05-12 09:12:24
3400	7	262	2025-05-12 09:12:24	2025-05-12 09:12:24
3401	7	263	2025-05-12 09:12:24	2025-05-12 09:12:24
3402	7	264	2025-05-12 09:12:24	2025-05-12 09:12:24
3403	7	509	2025-05-12 09:12:24	2025-05-12 09:12:24
3404	7	265	2025-05-12 09:12:24	2025-05-12 09:12:24
3405	7	266	2025-05-12 09:12:24	2025-05-12 09:12:24
3406	7	267	2025-05-12 09:12:24	2025-05-12 09:12:24
3407	7	268	2025-05-12 09:12:24	2025-05-12 09:12:24
3408	7	269	2025-05-12 09:12:24	2025-05-12 09:12:24
3409	7	270	2025-05-12 09:12:24	2025-05-12 09:12:24
3410	7	271	2025-05-12 09:12:24	2025-05-12 09:12:24
3411	7	272	2025-05-12 09:12:24	2025-05-12 09:12:24
3412	7	273	2025-05-12 09:12:24	2025-05-12 09:12:24
3413	7	274	2025-05-12 09:12:24	2025-05-12 09:12:24
3414	7	275	2025-05-12 09:12:24	2025-05-12 09:12:24
3415	7	276	2025-05-12 09:12:24	2025-05-12 09:12:24
3416	7	277	2025-05-12 09:12:24	2025-05-12 09:12:24
3417	7	278	2025-05-12 09:12:24	2025-05-12 09:12:24
3418	7	279	2025-05-12 09:12:24	2025-05-12 09:12:24
3419	7	280	2025-05-12 09:12:24	2025-05-12 09:12:24
3420	7	281	2025-05-12 09:12:24	2025-05-12 09:12:24
3421	7	282	2025-05-12 09:12:24	2025-05-12 09:12:24
3422	7	283	2025-05-12 09:12:24	2025-05-12 09:12:24
3423	7	284	2025-05-12 09:12:24	2025-05-12 09:12:24
3424	7	285	2025-05-12 09:12:24	2025-05-12 09:12:24
3425	7	286	2025-05-12 09:12:24	2025-05-12 09:12:24
3426	7	287	2025-05-12 09:12:24	2025-05-12 09:12:24
3427	7	288	2025-05-12 09:12:24	2025-05-12 09:12:24
3428	7	289	2025-05-12 09:12:24	2025-05-12 09:12:24
3429	7	294	2025-05-12 09:12:24	2025-05-12 09:12:24
3430	7	295	2025-05-12 09:12:24	2025-05-12 09:12:24
3431	7	296	2025-05-12 09:12:24	2025-05-12 09:12:24
3432	7	297	2025-05-12 09:12:24	2025-05-12 09:12:24
3433	7	500	2025-05-12 09:12:24	2025-05-12 09:12:24
3434	7	501	2025-05-12 09:12:24	2025-05-12 09:12:24
3435	7	502	2025-05-12 09:12:24	2025-05-12 09:12:24
3436	7	510	2025-05-12 09:12:24	2025-05-12 09:12:24
3437	7	511	2025-05-12 09:12:24	2025-05-12 09:12:24
3438	7	512	2025-05-12 09:12:24	2025-05-12 09:12:24
3439	7	567	2025-05-12 09:12:24	2025-05-12 09:12:24
3440	7	594	2025-05-12 09:12:24	2025-05-12 09:12:24
3441	7	679	2025-05-12 09:12:24	2025-05-12 09:12:24
3442	7	298	2025-05-12 09:12:24	2025-05-12 09:12:24
3443	7	299	2025-05-12 09:12:24	2025-05-12 09:12:24
3444	7	300	2025-05-12 09:12:24	2025-05-12 09:12:24
3445	7	310	2025-05-12 09:12:24	2025-05-12 09:12:24
3446	7	311	2025-05-12 09:12:24	2025-05-12 09:12:24
3447	7	312	2025-05-12 09:12:24	2025-05-12 09:12:24
3448	7	313	2025-05-12 09:12:24	2025-05-12 09:12:24
3449	7	314	2025-05-12 09:12:24	2025-05-12 09:12:24
3450	7	315	2025-05-12 09:12:24	2025-05-12 09:12:24
3451	7	316	2025-05-12 09:12:24	2025-05-12 09:12:24
3452	7	317	2025-05-12 09:12:24	2025-05-12 09:12:24
3453	7	318	2025-05-12 09:12:24	2025-05-12 09:12:24
3454	7	358	2025-05-12 09:12:24	2025-05-12 09:12:24
3455	7	365	2025-05-12 09:12:24	2025-05-12 09:12:24
3456	7	350	2025-05-12 09:12:24	2025-05-12 09:12:24
3457	7	351	2025-05-12 09:12:24	2025-05-12 09:12:24
3458	7	352	2025-05-12 09:12:24	2025-05-12 09:12:24
3459	7	353	2025-05-12 09:12:24	2025-05-12 09:12:24
3460	7	354	2025-05-12 09:12:24	2025-05-12 09:12:24
3461	7	355	2025-05-12 09:12:24	2025-05-12 09:12:24
3462	7	356	2025-05-12 09:12:24	2025-05-12 09:12:24
3463	7	357	2025-05-12 09:12:24	2025-05-12 09:12:24
3464	7	392	2025-05-12 09:12:24	2025-05-12 09:12:24
3465	7	396	2025-05-12 09:12:24	2025-05-12 09:12:24
3466	7	301	2025-05-12 09:12:24	2025-05-12 09:12:24
3467	7	302	2025-05-12 09:12:24	2025-05-12 09:12:24
3468	7	303	2025-05-12 09:12:24	2025-05-12 09:12:24
3469	7	304	2025-05-12 09:12:24	2025-05-12 09:12:24
3470	7	305	2025-05-12 09:12:24	2025-05-12 09:12:24
3471	7	306	2025-05-12 09:12:24	2025-05-12 09:12:24
3472	7	307	2025-05-12 09:12:24	2025-05-12 09:12:24
3473	7	308	2025-05-12 09:12:24	2025-05-12 09:12:24
3474	7	309	2025-05-12 09:12:24	2025-05-12 09:12:24
3475	7	590	2025-05-12 09:12:24	2025-05-12 09:12:24
3476	7	591	2025-05-12 09:12:24	2025-05-12 09:12:24
3477	7	319	2025-05-12 09:12:24	2025-05-12 09:12:24
3478	7	320	2025-05-12 09:12:24	2025-05-12 09:12:24
3479	7	321	2025-05-12 09:12:24	2025-05-12 09:12:24
3480	7	322	2025-05-12 09:12:24	2025-05-12 09:12:24
3481	7	323	2025-05-12 09:12:24	2025-05-12 09:12:24
3482	7	324	2025-05-12 09:12:24	2025-05-12 09:12:24
3483	7	325	2025-05-12 09:12:24	2025-05-12 09:12:24
3484	7	326	2025-05-12 09:12:24	2025-05-12 09:12:24
3485	7	327	2025-05-12 09:12:24	2025-05-12 09:12:24
3486	7	328	2025-05-12 09:12:24	2025-05-12 09:12:24
3487	7	676	2025-05-12 09:12:24	2025-05-12 09:12:24
3488	7	339	2025-05-12 09:12:24	2025-05-12 09:12:24
3489	7	385	2025-05-12 09:12:24	2025-05-12 09:12:24
3490	7	386	2025-05-12 09:12:24	2025-05-12 09:12:24
3491	7	387	2025-05-12 09:12:24	2025-05-12 09:12:24
3492	7	388	2025-05-12 09:12:24	2025-05-12 09:12:24
3493	7	389	2025-05-12 09:12:24	2025-05-12 09:12:24
3494	7	390	2025-05-12 09:12:24	2025-05-12 09:12:24
3495	7	391	2025-05-12 09:12:24	2025-05-12 09:12:24
3496	7	555	2025-05-12 09:12:24	2025-05-12 09:12:24
3497	7	556	2025-05-12 09:12:24	2025-05-12 09:12:24
3498	7	557	2025-05-12 09:12:24	2025-05-12 09:12:24
3499	7	455	2025-05-12 09:12:24	2025-05-12 09:12:24
3500	7	456	2025-05-12 09:12:24	2025-05-12 09:12:24
3501	7	457	2025-05-12 09:12:24	2025-05-12 09:12:24
3502	7	458	2025-05-12 09:12:24	2025-05-12 09:12:24
3503	7	459	2025-05-12 09:12:24	2025-05-12 09:12:24
3504	7	460	2025-05-12 09:12:24	2025-05-12 09:12:24
3505	7	461	2025-05-12 09:12:24	2025-05-12 09:12:24
3506	7	462	2025-05-12 09:12:24	2025-05-12 09:12:24
3507	7	463	2025-05-12 09:12:24	2025-05-12 09:12:24
3508	7	465	2025-05-12 09:12:24	2025-05-12 09:12:24
3509	7	466	2025-05-12 09:12:24	2025-05-12 09:12:24
3510	7	467	2025-05-12 09:12:24	2025-05-12 09:12:24
3511	7	468	2025-05-12 09:12:24	2025-05-12 09:12:24
3512	7	469	2025-05-12 09:12:24	2025-05-12 09:12:24
3513	7	470	2025-05-12 09:12:24	2025-05-12 09:12:24
3514	7	471	2025-05-12 09:12:24	2025-05-12 