@php
use App\Models\ReturnSales;
@endphp
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>{{$title}}</title>

<style>
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');

body {
  font-family: 'Cairo', sans-serif;
  background: #f6f8fa;
  margin: 0;
  padding: 0;
  color: #333;
  direction: rtl;
}

@page {
  size: A4;
  margin: 15mm;
}

.invoice-container {
  width: 210mm;
  min-height: 297mm;
  margin: auto;
  background: #fff;
  border-radius: 8px;
  box-shadow: 0 0 10px rgba(0,0,0,0.08);
  padding: 15mm;
  border-top: 6px solid #0069d9;
  box-sizing: border-box;
}

/* ======= الهيدر ======= */
.invoice-header {
  display: grid;
  grid-template-columns: 3fr 4fr 5fr;
  align-items: center;
  gap: 8px;
  border-bottom: 1px solid #eee;
  padding-bottom: 8px;
  margin-bottom: 12px;
}

.logo img {
  width: 85px;
  height: 85px;
  object-fit: contain;
}

.company-info {
  text-align: center;
  font-size: 12px;
  line-height: 1.4;
}

.company-info h1 {
  font-size: 18px;
  color: #0069d9;
  margin: 0 0 3px 0;
}

.invoice-info {
  border: 1px solid #ddd;
  border-radius: 6px;
  background: #f9fbfc;
  padding: 4px;
  font-size: 12px;
}

.invoice-info td {
  padding: 3px 6px;
  border: 1px solid #eee;
}

/* ======= تفاصيل العميل ======= */
.details-grid {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  border-bottom: 1px solid #eee;
  padding-bottom: 10px;
  margin-bottom: 12px;
}

.buyer-info {
  flex: 1;
  font-size: 12px;
  line-height: 1.4;
}

.buyer-info table td {
  padding: 4px 6px;
  font-size: 12px;
}

.qr-code img {
width: 120px; 
    height: 120px; 
    border: 1px solid #ccc; 
    border-radius: 10px; 
    padding: 5px; 
    background: #fff;    
    
}

/* ======= جدول الأصناف ======= */
.items-table table {
  width: 100%;
  border-collapse: collapse;
  font-size: 12px;
  text-align: center;
}

.items-table th, .items-table td {
  border: 1px solid #ddd;
  padding: 4px;
}

.items-table th {
  background: #e8f1ff;
}

/* ======= الملخص المالي ======= */
.financial-summary {
  margin-top: 12px;
  font-size: 12px;
}

.financial-summary table td {
  padding: 4px;
  border: 1px solid #ccc;
}

/* ======= الملاحظات ======= */
.notes {
  margin-top: 10px;
  border: 1px solid #ddd;
  border-radius: 6px;
  padding: 6px;
  background: #f9fbfc;
  font-size: 12px;
}

/* ======= الطباعة ======= */
@media print {
  body {
    background: #fff;
    margin: 0;
    padding: 0;
  }
  .invoice-container {
    box-shadow: none;
    border: none;
    margin: 0;
    width: 100%;
    padding: 10mm;
  }
  @page {
    size: A4;
    margin: 10mm;
  }
}
</style>

</head>
<body>

  <div class="invoice-container">

    <!-- رأس الفاتورة -->
   <div class="invoice-header">
  <div class="logo">
    <img src="{{URL::to($Def->Logo)}}" alt="شعار الشركة">
  </div>

  <div class="company-info">
    <h1>{{$title}}</h1>
    <strong>
       @if(!empty($Def->Name))
                                                    {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                                                @else
                                                    {{trans('admin.Klar')}}
                                                @endif
      </strong><br>
      <strong>  {{trans('admin.Tax_Num')}} : {{$Def->Organaziation_Tax_ID}}
      
      
      </strong><br>
    <strong>
  {{app()->getLocale() == 'ar' ?$Def->Address :$Def->AddressEn}}    
      
      </strong><br>


  </div>

  <div class="invoice-info" style="padding: 0; border: 1px solid #ddd; border-radius: 6px; background: #f9fbfc;">
  <table class="invoice-table-2col" style="width: 100%; border-collapse: collapse; font-size: 12px;">

  <tr>
    <td><strong>           {{trans('admin.Bill_Num')}}:</strong></td>
    <td>{{$item->Code}}</td>
  </tr>
  <tr>
    <td><strong> {{trans('admin.Payment_Method')}}:</strong></td>
    <td>
     
               @if($item->Payment_Method == 'Cash')
                                                    {{trans('admin.Cash')}}
                                                @elseif($item->Payment_Method == 'Later')
                                                    {{trans('admin.Later')}}
                                                @elseif($item->Payment_Method == 'Delivery')
                                                    {{trans('admin.Delivery')}}
                                                @elseif($item->Payment_Method == 'Cash_Visa')
                                                    {{trans('admin.Cash_Visa')}}
                                                @elseif($item->Payment_Method == 'Visa')
                                                    {{trans('admin.Visa')}}
                                                @elseif($item->Payment_Method == 'Cash_Collection')
                                                    {{trans('admin.Cash_Collection')}}

                                                @elseif($item->Payment_Method == 'Check')

                                                   {{trans('admin.Check')}}
                                                @elseif($item->Payment_Method == 'Installment')

                                                    {{trans('admin.Installment')}}
                                                @elseif($item->Payment_Method == 'InstallmentCompanies')
                                                    {{trans('admin.InstallmentCompanies')}}
                                                @endif
      
      
    </td>
  </tr>
  <tr>
    <td><strong>  {{trans('admin.Date')}}:</strong></td>
    <td>{{$item->Date}}</td>
  </tr>
  <tr>
    <td><strong>{{trans('admin.Due_Date')}}:</strong></td>
    <td>{{$item->Later_Due}}</td>
  </tr>
  <tr>
    <td><strong> {{trans('admin.The_Net')}}:</strong></td>
    <td style="display: flex; align-items: center; gap: 6px;">
      <span>{{$item->Total_Net}}</span>
        
        @if(!empty($item->Coin()->first()->Image))
      <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 14px; height: 14px; object-fit: contain;">
        @endif
    </td>
  </tr>
</table>


  </div>
</div>


   <!-- بيانات العميل والـ QR -->
<div class="details-grid" style="display: flex; justify-content: space-between; align-items: flex-start; gap: 20px; margin-bottom: 20px;">

  <!-- بيانات العميل -->
  <div class="buyer-info" style="flex: 1; direction: rtl; text-align: right; font-family: 'Cairo', sans-serif;">

    <div style="display: flex; align-items: center; width: 100%; margin-bottom: 8px;">
      <div style="background-color: #007bff; color: white; padding: 6px 15px; border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
         {{trans('admin.Client')}} :
      </div>
      <div style="margin-right: 15px; font-weight: bold; color: #000;">
           {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
      </div>
      <div style="flex: 1; background-color: #007bff; height: 32px; border-top-left-radius: 8px; border-bottom-left-radius: 8px;"></div>
    </div>

      
      
        
@if(!empty($cust))
    <!-- جدول بيانات العميل -->
    <table style="width: 100%; border: 1px solid #ccc; border-radius: 12px; border-collapse: separate; border-spacing: 0; font-size: 13px; text-align: right;">
      <tr style="background-color: #fafafa;">
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;"> {{trans('admin.Commercial_Registration_No')}}:</td>
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;">{{$cust->Commercial_Registration_No}}</td>
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;"> {{trans('admin.Tax_Card_No')}}:</td>
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;">{{$cust->Tax_Card_No}}</td>
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;"> {{trans('admin.Email')}}:</td>
        <td style="padding: 5px 8px; border-bottom: 1px solid #ccc;">{{$cust->Email}}</td>
      </tr>
      <tr>
        <td style="padding: 5px 8px;">{{trans('admin.City')}}:</td>
        <td style="padding: 5px 8px;">
          @if(!empty($cust->City()->first()->Arabic_Name))
          {{$cust->City()->first()->Arabic_Name}}
        @endif    
          </td>
        <td style="padding: 5px 8px;">{{trans('admin.Place')}}:</td>
        <td style="padding: 5px 8px;">
          
             @if(!empty($cust->Place()->first()->Arabic_Name))
          {{$cust->Place()->first()->Arabic_Name}}
        @endif        
          </td>
        <td style="padding: 5px 8px;">   {{trans('admin.Phone')}}:</td>
        <td style="padding: 5px 8px;">{{$cust->Phone}}</td>
      </tr>
    </table>
      @endif
  </div>

    



  <!-- كود QR -->
  <div class="qr-code" style="flex-shrink: 0;">
   <!-- <img src="invoice-qr.png" alt="رمز الفاتورة" style="width: 120px; height: 120px; border: 1px solid #ccc; border-radius: 10px; padding: 5px; background: #fff;"> -->
      
         @if(null !== session('file_url'))
                                                {!! session('file_url') !!}
                                            @endif
  </div>

</div>


   <!-- جدول الأصناف -->
<div class="items-table">
  <table style="width: 100%; border-collapse: collapse; text-align: center; font-size: 14px;">
    <thead style="background-color: #f3f3f3;">
      <tr>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Code')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Name')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Unit')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Qty')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Price')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Tax')}}</th>
        <th style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Total')}}</th>
      </tr>
    </thead>
    <tbody>
        
        @foreach($details as $detail)
      <tr>
        <td style="border: 1px solid #ccc; padding: 6px;">
          {{$detail->Product_Code}}
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
                   {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

                   @if(!empty($detail->V1))
                   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}})
                   @endif
                   @if(!empty($detail->V2))
            (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}))
                   @endif
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
                   {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
          {{$detail->Qty}}
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
          {{$detail->Price}}
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
          {{$detail->Total_Tax}}
          </td>
        <td style="border: 1px solid #ccc; padding: 6px;">
          {{$detail->Total_Net}}
          </td>
      </tr>
    @endforeach
    </tbody>
  </table>
</div>

<!-- جدول الملخص المالي -->
<div class="financial-summary" style="margin-top: 20px;">
 <div style="display: flex; justify-content: space-between; gap: 20px; width: 100%; font-size: 14px;">
    @php
                                                            $TotalReturnQty=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Qty');
                                                            $TotalReturnBfTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_BF_Taxes');
                                                            $TotalReturnTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Taxes');
                                                            $TotalReturnDiscount=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Discount');
                                                            $TotalReturn=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                                        @endphp
  <!-- الجدول اليمين -->
  <table style="width: 48%; border-collapse: collapse; text-align: center;">
    <tbody>
      <tr style="background-color: #f3f3f3;">
        <td style="border: 1px solid #ccc; padding: 6px;"> {{trans('admin.Product_Numbers')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;">{{$item->Product_Numbers}}</td>
      </tr>
      <tr>
        <td style="border: 1px solid #ccc; padding: 6px;"> {{trans('admin.Total_Qty')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;">{{$item->Total_Qty + $TotalReturnQty}}</td>
      </tr>
      <tr style="background-color: #f9f9f9;">
        <td style="border: 1px solid #ccc; padding: 6px;"> {{trans('admin.Total_Discount')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;">{{$item->Total_Discount + $TotalReturnDiscount}}</td>
      </tr>
      <tr>
        <td style="border: 1px solid #ccc; padding: 6px;"> {{trans('admin.Total_Return')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;">{{$TotalReturn}}</td>
      </tr>
      <tr style="background-color: #f9f9f9;">
        <td style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Paid')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;"><span>{{$item->Pay}}</span>
            
          @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
    
          
          </td>
      </tr>
      <tr>
        <td style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Residual')}}</td>
        <td style="border: 1px solid #ccc; padding: 6px;"><span>{{$item->Total_Net - $item->Pay}}</span>

                     @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
    
          
          </td>
      </tr>
    </tbody>
  </table>

     

  <!-- الجدول الشمال -->
  <table style="width: 48%; border-collapse: collapse; text-align: center;">
     <tbody>
      <tr style="background-color: #f3f3f3;">
        <td style="border: 1px solid #ccc; padding: 6px;">  {{trans('admin.Total_Bf_Taxes')}}</td> 
        <td style="border: 1px solid #ccc; padding: 6px;"><span>{{$item->Total_BF_Taxes + $TotalReturnBfTax}}	</span>

                   @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
    
          
          </td>
      </tr>
      <tr>
        <td style="border: 1px solid #ccc; padding: 6px;">{{trans('admin.Total_Taxes')}} </td> 
        <td style="border: 1px solid #ccc; padding: 6px;"><span>{{$item->Total_Taxes + $TotalReturnTax}}</span>

                   @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
    
          
          </td>
      </tr>
      <tr style="background-color: #f9f9f9;">
        <td style="border: 1px solid #ccc; padding: 6px;">   {{trans('admin.Total_Net')}} </td> 
        <td style="border: 1px solid #ccc; padding: 6px;"><span>{{$item->Total_Net}}</span>

                   @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
    
          
          </td>
   
      </tr>
      <tr style="background-color: #f9f9f9;">
  <td colspan="2" style="border: 1px solid #ccc; padding: 6px; text-align: center; font-weight: bold;">
   @if(app()->getLocale() == 'ar' )
                                            @php
                                                $xx=($item->Total_Net);
                                              $f = new NumberFormatter("ar", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            @endphp
                                        @else
                                            @php
                                                $xx=($item->Total_Net);
                                              $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            @endphp
                                        @endif
      
      
      {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
      
  </td>
</tr>
    </tbody>
    <!-- المبلغ بالحروف -->

  </table>

</div>

</div>



    <!-- الملاحظات -->
    <div class="notes">
      <strong>{{trans('admin.Note')}}:</strong>
      <p> {{$item->Note}}</p>
    </div>

    <div class="notes">
 
        
        
                 @if(!empty($Def->Print_Text_Footer_Sales))             
                {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Sales :$Def->Print_Text_Footer_Sales_En !!}
                 @endif
        
        
    </div>
      
      
      
            <div class="btn-group btn-group-justified row" role="group" aria-label="...">
                  <div class="btn-group col-md-6" role="group">
                     <button onclick="window.print();" class="btn btn-block btn-primary">{{trans('admin.Print')}}</button>
                  </div>
                  <div class="btn-group col-md-6" role="group">
                     <a href="{{ url()->previous() }}" class="btn btn-default" data-dismiss="modal">{{trans('admin.Back')}}</a>
                  </div>
       
               </div>

  </div>
    
    
    
   

</body>
</html>





