@extends('admin.index')
@section('content')
    @php
        use App\Models\ProductQuoteImage;
        use App\Models\ProductSalesOrder;
        use App\Models\ProductsQuote;
        use App\Models\ProductUnits;
        use App\Models\ProductSales;
        use App\Models\ReturnSales;
    @endphp
    <title>{{$title}}</title>

    @if($size == 'A4')
        @if($Print->Sales_Print_Type == 1)
            <style>

                .page-content {
                    color: black !important;
                    font-weight: bold;
                }

                .table-bordered {
                    border: 2px solid black;
                }

                .table-bordered {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                @media print {


                    .page-content {
                        color: black !important;
                        font-weight: bold;
                    }

                    .table-bordered {
                        border: 2px solid black;
                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }


                    @page {

                        size: A4 landscape !important;
                        color: black;
                        overflow: visible;


                    }


                    table {
                        page-break-inside: auto
                    }

                    tr {
                        page-break-inside: avoid;
                        page-break-after: auto
                    }

                    thead {
                        display: table-header-group;
                    }

                    tfoot {
                        display: table-footer-group;
                    }


                    .NAME {
                        width: 80%;
                    }


                    .UNIT {
                        width: 40%;
                    }

                    .table-bordered {
                        border: 2px solid black;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black;
                    }


                }

                .table-bordered {
                    border: 2px solid black;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black;
                }
            </style>
        @else
            <style>
                .page-content {
                    color: black !important;
                    font-weight: bold;
                }

                .table-bordered {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                @media print {


                    .NAME {
                        width: 80%;
                    }


                    .UNIT {
                        width: 40%;
                    }


                    .page-content {
                        color: black !important;

                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    @page {

                        size: A4 portrait !important;
                        margin: unset !important;
                        page-break-after: always ;
                        overflow: visible;

                    }

                    .PrintCenter {
                        text-align: center;
                        display: flex;
                        flex-wrap: wrap;
                        justify-content: center;
                        align-items: center;
                        align-content: center;
                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }
                }

            </style>
        @endif
    @else

        @if($Print->Sales_Print_Type == 1)
            <style>

                .page-content {
                    color: black !important;
                    font-weight: bold;
                }

                .table-bordered {
                    border: 2px solid black;
                }

                .table-bordered {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                @media print {


                    .page-content {
                        color: black !important;
                        font-weight: bold;
                    }

                    .table-bordered {
                        border: 2px solid black;
                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }


                    @page {

                        size: A5 landscape !important;
                        color: black;
                        overflow: visible;


                    }


                    table {
                        page-break-inside: auto
                    }

                    tr {
                        page-break-inside: avoid;
                        page-break-after: auto
                    }

                    thead {
                        display: table-header-group;
                    }

                    tfoot {
                        display: table-footer-group;
                    }


                    .NAME {
                        width: 80%;
                    }


                    .UNIT {
                        width: 40%;
                    }

                    .table-bordered {
                        border: 2px solid black;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black;
                    }


                }

                .table-bordered {
                    border: 2px solid black;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black;
                }
            </style>
        @else
            <style>
                .page-content {
                    color: black !important;
                    font-weight: bold;
                }

                .table-bordered {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }

                @media print {


                    .NAME {
                        width: 80%;
                    }


                    .UNIT {
                        width: 40%;
                    }


                    .page-content {
                        color: black !important;

                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    @page {

                        size: A5 portrait !important;
                        margin: unset !important;
                        page-break-after: always ;
                        overflow: visible;

                    }

                    .PrintCenter {
                        text-align: center;
                        display: flex;
                        flex-wrap: wrap;
                        justify-content: center;
                        align-items: center;
                        align-content: center;
                    }

                    .table-bordered {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }

                    .table-bordered th, .table-bordered td {
                        border: 2px solid black !important;
                    }
                }

            </style>
        @endif

    @endif

    <style>
        .style-info {
            text-align: -webkit-center;
        }

        .cen {
            text-align: -webkit-center;

        }

        .title {
            font-size: 70px !important;
        }
    </style>
 
        <main id="js-page-content" role="main" class="page-content">
            <ol class="breadcrumb page-breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
                <li class="breadcrumb-item active"> {{$title}}</li>
                <li class="position-absolute pos-top pos-right d-none d-sm-block">
                    <span class="js-get-date"></span></li>
            </ol>

            <!-- data entry -->

            <div class="row hide-table">
                <div class="col-xl-12">
                    <div id="panel-1" class="panel">
                        <div class="modal-body">
                            <div data-size="A4" class="cen">
                                <div class="row invoive-info" style="margin-bottom:20px;">
                                    <div style="text-align: center; font-size: 20px"
                                         class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                        <div class="style-info">
                                            <h1 style="text-align: center;" class="m-0">
                                                @if(!empty($Def->Name))
                                                    {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                                                @else
                                                    {{trans('admin.Klar')}}
                                                @endif
                                            </h1>
                                            <h3 style="text-align: center;" class="m-10">
                                                @if(!empty($Def->Print_Text))
                                                    {{app()->getLocale() == 'ar' ?$Def->Print_Text :$Def->Print_Text_En}}
                                                @endif
                                            </h3>

                                            <div class="row">
                                                <div
                                                    class="col-md-12">{{app()->getLocale() == 'ar' ?$Def->Address :$Def->AddressEn}}</div>

                                                <div class="col-md-6">{{$Def->Phone1}}</div>
                                                <div class="col-md-6">{{$Def->Phone2}}</div>


                                            </div>
                                        </div>
                                    </div>
                                    <div style="text-align: center;font-size: 60px"
                                         class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                        @if($Place == 'Sales')
                                            @if(!empty($Def->Name_Sales_Bill))
                                                <h1>    {{app()->getLocale() == 'ar' ?$Def->Name_Sales_Bill :$Def->Name_Sales_Bill_En}}     </h1>
                                            @else
                                                <h1>{{$title}}</h1>
                                            @endif
                                        @else



                                            @if($Place == 'Quote')
                                                @if(!empty($Def->Name_Quote_Bill))
                                                    <h1>    {{app()->getLocale() == 'ar' ?$Def->Name_Quote_Bill :$Def->Name_Quote_Bill_En}}     </h1>
                                                @else
                                                    <h1>{{$title}}</h1>
                                                @endif

                                            @elseif($Place == 'SalesOrder')

                                                @if(!empty($Def->Name_Sales_Order_Bill))
                                                    <h1>    {{app()->getLocale() == 'ar' ?$Def->Name_Sales_Order_Bill :$Def->Name_Sales_Order_Bill_En}}     </h1>
                                                @else
                                                    <h1>{{$title}}</h1>
                                                @endif
                                            @else
                                                <h1>{{$title}}</h1>
                                            @endif

                                        @endif
                                    </div>
                                    <div style="text-align: center;"
                                         class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                        <div class="style-info" style="height: 100px">
                                            @if(!empty($Def->Logo))
                                                <img style="height: 100px; " class="img-fluid"
                                                     src="{{URL::to($Def->Logo)}}" alt="Logo"/>

                                            @else
                                                <img style="height: 50px; " class="img-fluid"
                                                     src="https://klarerp.com/site/img/theme/logo.png" alt="Logo"/>
                                            @endif

                                        </div>
                                    </div>
                                </div>
                                <hr/>
                                <div class="row"></div>

                                <div class="row cen">
                               
                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Code')}} : <span class="style-data">
                                            {{$item->Code}}
                                                </span></h5>
                                        </div>
                          

                         
                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Date')}} : <span
                                                    class="style-data">{{$item->Date}}</span></h5>
                                        </div>
                              

                             
                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Coin')}} : <span class="style-data">
                                                {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                    </span></h5>
                                        </div>
                                  


                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Draw')}} : <span
                                                    class="style-data"> {{$item->Draw}}    </span></h5>
                                        </div>
                                   


                             

                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Payment_Method')}} : <span class="style-data">       @if($item->Payment_Method == 'Cash')
                                                        {{trans('admin.Cash')}}
                                                    @elseif($item->Payment_Method == 'Later')
                                                        {{trans('admin.Later')}}
                                                    @elseif($item->Payment_Method == 'Installment')
                                                        {{trans('admin.Installment')}}
                                                    @endif      </span></h5>
                                        </div>

                                        @if($item->Payment_Method == 'Installment')
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.Presenter')}} :


                                                    <span class="style-data">


                 {{$item->presenter}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.annual_interest')}} :


                                                    <span class="style-data">


                 {{$item->annual_interest}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.monthly_installment')}} :


                                                    <span class="style-data">


                 {{$item->monthly_installment}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.Years_Number')}} :


                                                    <span class="style-data">


                 {{$item->Years_Number}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.total')}} :


                                                    <span class="style-data">


                 {{$item->total}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.installment_Num')}} :


                                                    <span class="style-data">


                 {{$item->installment_Num}}


            </span>
                                                </h5>
                                            </div>
                                            <div class="col-md-3 col-3">

                                                <h5> {{trans('admin.Date_First_installment')}} :


                                                    <span class="style-data">


                 {{$item->Date_First_installment}}


            </span>
                                                </h5>
                                            </div>
                                        @endif

                          


                                
                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Status')}} : <span class="style-data">          @if($item->Status == 1)
                                                        {{trans('admin.Recived')}}
                                                    @elseif($item->Status == 0)
                                                        {{trans('admin.Pending')}}
                                                    @endif     </span></h5>
                                        </div>
                                 


                                

                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Executor')}} : <span class="style-data">
                                                 @if(!empty($item->Executor))
                                                        {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                    @endif
                                                    </span></h5>
                                        </div>
                              


                                  
                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Refernce_Number')}} : <span
                                                    class="style-data"> {{$item->Refernce_Number}}    </span></h5>
                                        </div>
                                    

                          
                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Safe')}} : <span
                                                    class="style-data">       {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}       </span>
                                            </h5>
                                        </div>
                               

                           
                                        <div class="col-md-3 col-3">
                                            <h5> {{trans('admin.Client')}} : <span class="style-data">
                                                    {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                                    </span></h5>
                                        </div>
                          

                                
                                        <div class="col-md-3 col-3">


                                            <h5> {{trans('admin.Phone')}} : <span class="style-data">
                                                   @if(!empty($cust))

                                                        {{$cust->Phone}}
                                                    @endif

                                                    </span></h5>
                                        </div>
                              


                                 
                                        <div class="col-md-3 col-3">


                                            <h5> {{trans('admin.Address')}} : <span class="style-data">
                                                   @if(!empty($cust))

                                                        {{$cust->Address}}
                                                    @endif

                                                    </span></h5>
                                        </div>
                           




                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Delegate')}} : <span class="style-data">
                                                     @if(!empty($item->Delegate))
                                                        {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                    @endif
                                                    </span></h5>
                                        </div>
                                  


                                   
                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Store')}} : <span
                                                    class="style-data">     {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}       </span>
                                            </h5>
                                        </div>
                            

                              

                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.User')}} : <span
                                                    class="style-data">    {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}        </span>
                                            </h5>
                                        </div>
                          

                                </div>


                                <div class="row cen">
                        
                                        <div class="col-md-3 col-3 ">
                                            <h5> {{trans('admin.Cost_Center')}} : <span class="style-data">
                                         @if(!empty($item->Cost_Center))
                                                        {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                    @endif
                                         </span></h5>
                                        </div>
                                 
                            
                                        <div class="col-md-6 col-6">
                                            <h5> {{trans('admin.Notes')}} : <span class="style-data">
                                                {{$item->Note}}
                                                    </span></h5>
                                        </div>
                                 
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive-lg">
                                            <table class="table table-bordered mt-5">
                                                <thead>
                                                <tr>

                                               

                                               
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Code')}}</th>
                                             
                                                
                                                        <th class="border-top-0 table-scale-border-bottom fw-700 NAME"> {{trans('admin.Name')}}</th>
                                     
                                                        <th class="border-top-0 table-scale-border-bottom fw-700 UNIT">  {{trans('admin.Unit')}}</th>
                                                  
                                                   
                                                        <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Qty')}}</th>
                                            
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Price')}}</th>
                                                   

                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Discount')}}</th>
                                                 
                                                  
                                                        <th class="border-top-0 table-scale-border-bottom fw-700 "> {{trans('admin.Total_Bf_Tax')}}</th>
                                                  
                                                
                                                        <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Total_Tax')}}</th>
                                      
                                                        <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Total')}}</th>
                                       
                                                        <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.The_Net')}}</th>
                                  
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Store')}}</th>
                                        
                                                
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Desc')}}</th>
                                           
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Exp_Date')}}</th>
                                               
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Weight')}}</th>
                                     
                                                        <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Patch_Number')}}</th>
                                         


                                                </tr>
                                                </thead>


                                                <tbody>
                                                @php  $bonus=0; @endphp

                                                @foreach($details as $detail)
                                                    @if($detail->Product()->first()->P_Type != 'Serial')
                                                        @php
                                                            if($detail->Price == $detail->Discount){
                                           $bonus +=   $detail->Discount * $detail->Qty ;
                                           }
                                                        @endphp

                                                        <tr>

                                               
                                                                <td>{{$detail->Product_Code}}</td>

                                                                <td class="NAME">
                                                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

                                                                    @if(!empty($detail->V1))
                                                                        ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}
                                                                        )
                                                                    @endif
                                                                    @if(!empty($detail->V2))
                                                                        (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}
                                                                        ))
                                                                    @endif
                                                                </td>
                                                  
                                                   
                                                                @php
                                                                    $Raty=ProductUnits::where('Product',$detail->Product)->where('Unit',$detail->Unit)->first();
                                                                @endphp
                                                                <td class="UNIT">
                                                                    {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
                                                                    ({{$Raty->Rate}})
                                                                </td>
                                                     
                                                                <td>{{$detail->Qty}}</td>
                                                         

                                                                <td>{{$detail->Price}}</td>
                                                      


                                                         
                                                                <td>{{$detail->Discount}}</td>
                                              
                                                                <td>{{$detail->Total_Bf_Tax}}</td>
                                           
                                                                <td>{{$detail->Total_Tax}}</td>
                                                      
                                                                <td>{{$detail->Total}}</td>
                                              
                                                                <td>{{$detail->Total_Net}}</td>
                                                
                                                                <td>{{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}</td>
                                                
                                                                <td>{{$detail->SalesProDesc}}</td>
                                            
                                                                <td>{{$detail->Exp_Date}}</td>
                                                   
                                                                <td>{{$detail->weight}}</td>
                                                  
                                                                <td>{{$detail->Patch_Number}}</td>
                                                         


                                                        </tr>
                                                    @endif
                                                @endforeach



                                                @foreach($detailsTwo as $detail)

                                                    @if($detail->Product()->first()->P_Type == 'Serial')

                                                        @if($Place == 'Sales')
                                                            @php
                                                                $d=ProductSales::where('Sales',$item->id)->where('Product',$detail->Product)->orderBy('id','desc')->first();

                                                                            $details=ProductSales::where('Sales',$item->id)->where('Product',$detail->Product)->get();
                                                                                        $qqqty=0;
                                                                                    $Disscc=0;
                                                                                    $BFTAX=0;
                                                                                    $TOTTAX=0;
                                                                                    $TOTAAAAL=0;
                                                                                         $TOTAAAALNET=0;
                                                            @endphp

                                                        @elseif($Place == 'Quote')

                                                            @php
                                                                $d=ProductsQuote::where('S_Quote',$item->id)->where('Product',$detail->Product)->orderBy('id','desc')->first();

                                                                            $details=ProductsQuote::where('S_Quote',$item->id)->where('Product',$detail->Product)->get();
                                                                                        $qqqty=0;
                                                                                    $Disscc=0;
                                                                                    $BFTAX=0;
                                                                                    $TOTTAX=0;
                                                                                    $TOTAAAAL=0;
                                                                                         $TOTAAAALNET=0;
                                                            @endphp
                                                        @elseif($Place == 'Quote_Image')

                                                            @php
                                                                $d=ProductQuoteImage::where('QuoteImage',$item->id)->where('Product',$detail->Product)->orderBy('id','desc')->first();

                                                                            $details=ProductQuoteImage::where('QuoteImage',$item->id)->where('Product',$detail->Product)->get();
                                                                                        $qqqty=0;
                                                                                    $Disscc=0;
                                                                                    $BFTAX=0;
                                                                                    $TOTTAX=0;
                                                                                    $TOTAAAAL=0;
                                                                                         $TOTAAAALNET=0;
                                                            @endphp
                                                        @elseif($Place == 'SalesOrder')

                                                            @php
                                                                $d=ProductSalesOrder::where('SalesOrder',$item->id)->where('Product',$detail->Product)->orderBy('id','desc')->first();

                                                                            $details=ProductSalesOrder::where('SalesOrder',$item->id)->where('Product',$detail->Product)->get();
                                                                                        $qqqty=0;
                                                                                    $Disscc=0;
                                                                                    $BFTAX=0;
                                                                                    $TOTTAX=0;
                                                                                    $TOTAAAAL=0;
                                                                                    $TOTAAAALNET=0;
                                                            @endphp

                                                        @endif

                                                    
                                                    
                                                    
                                                    
                                                    <!--  لو صنف سيريال   --->
                                                        @foreach($details as $detail)
                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                @php $qqqty +=$detail->Qty;  @endphp
                                                                @php $Disscc +=$detail->Discount; @endphp
                                                                @php $BFTAX +=$detail->Total_Bf_Tax; @endphp
                                                                @php $TOTTAX +=$detail->Total_Tax; @endphp
                                                                @php $TOTAAAAL +=$detail->Total; @endphp
                                                                @php $TOTAAAALNET +=$detail->Total_Net; @endphp
                                                            @endif
                                                        @endforeach


                                                        <tr>

                                                     

                                                          
                                                                <td>

                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Product_Code}}
                                                                                </div>
                                                                                @php $qqqty +=$detail->Qty;  @endphp
                                                                                @php $Disscc +=$detail->Discount; @endphp
                                                                                @php $BFTAX +=$detail->Total_Bf_Tax; @endphp
                                                                                @php $TOTTAX +=$detail->Total_Tax; @endphp
                                                                                @php $TOTAAAAL +=$detail->Total; @endphp
                                                                                @php $TOTAAAALNET +=$detail->Total_Net; @endphp
                                                                            @endif
                                                                        @endforeach
                                                                    </div>

                                                                </td>

                                                    

                                                                <td class="NAME">
                                                                    {{app()->getLocale() == 'ar' ?$d->Product()->first()->P_Ar_Name :$d->Product()->first()->P_En_Name}}

                                                                    @if(!empty($d->V1))
                                                                        ({{app()->getLocale() == 'ar' ?$d->V1()->first()->Name :$d->V1()->first()->NameEn}}
                                                                        )
                                                                    @endif
                                                                    @if(!empty($d->V2))
                                                                        (({{app()->getLocale() == 'ar' ?$d->V2()->first()->Name :$d->V2()->first()->NameEn}}
                                                                        ))
                                                                    @endif
                                                                </td>
                                                         

                                                                @php
                                                                    $Raty=ProductUnits::where('Product',$d->Product)->where('Unit',$d->Unit)->first();
                                                                @endphp

                                                                <td class="UNIT">
                                                                    {{app()->getLocale() == 'ar' ?$d->Unit()->first()->Name :$d->Unit()->first()->NameEn}}

                                                                    ({{$Raty->Rate}})
                                                                </td>
                                                     

                                                                <td>{{$qqqty}}</td>
                                                    


                                                                <td>{{$d->Price}}</td>
                                                     


                                                                <td>{{$Disscc}}</td>
                                                  
                                                                <td>{{$BFTAX}}</td>
                                                   
                                                                <td>{{$TOTTAX}}</td>
                                                        

                                                                <td>{{$TOTAAAAL}}</td>
                                                       

                                                                <td>{{$TOTAAAALNET}}</td>
                                                      

                                                                <td class="">{{app()->getLocale() == 'ar' ?$d->Store()->first()->Name :$d->Store()->first()->NameEn}}</td>
                                                            

                                                         
                                                                <td>{{$detail->SalesProDesc}}</td>
                                                  
                                                                <td>{{$detail->Exp_Date}}</td>
                                                       

                                                       
                                                                <td>{{$detail->weight}}</td>
                                                        

                                                        
                                                                <td>{{$detail->Patch_Number}}</td>
                                                         

                                                        </tr>

                                                    @endif
                                                @endforeach


                                                </tbody>

                                            </table>


                                                <div style="overflow:auto">
                                                    <table class="table table-bordered table-hover table-striped mt-4">
                                                        <tbody>
                                                        @php
                                                            $TotalReturnQty=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Qty');
                                                            $TotalReturnBfTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_BF_Taxes');
                                                            $TotalReturnTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Taxes');
                                                            $TotalReturnDiscount=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Discount');
                                                            $TotalReturn=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                                        @endphp
                                                        <tr>
                                                      
                                                                <td>{{trans('admin.Product_Numbers')}}</td>
                                                                <td>{{$item->Product_Numbers}}</td>
                                                         

                                                         
                                                                <td>{{trans('admin.Total_Qty')}}</td>
                                                                <td>{{$item->Total_Qty + $TotalReturnQty}}</td>
                                                     

                                                         
                                                                <td>{{trans('admin.Total_Price')}}</td>
                                                                <td>{{number_format((float)$item->Total_Price + $TotalReturn  , 2, '.', '')}}</td>
                                                          

                                                        </tr>

                                                        <tr>

                                                        
                                                                <td>{{trans('admin.Total_Discount')}}</td>
                                                                <td>{{$item->Total_Discount + $TotalReturnDiscount}}</td>
                                                        

                                                                <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                                                <td>{{$item->Total_BF_Taxes + $TotalReturnBfTax}}</td>
                                                         
                                                          
                                                                <td>{{trans('admin.Total_Taxes')}}</td>
                                                                <td>{{$item->Total_Taxes + $TotalReturnTax}}</td>
                                                        

                                                        </tr>

                                                        <tr>



                                                                <td>{{trans('admin.Total_Net')}}</td>
                                                                <td>{{$item->Total_Net}}</td>
                                                        

                                                    
                                                                <td>{{trans('admin.Paid')}}</td>
                                                                <td>{{$item->Pay}}</td>
                                                     

                                                         
                                                                <td>{{trans('admin.Residual')}}</td>
                                                                <td>{{$item->Total_Net - $item->Pay}}</td>
                                                       

                                                        </tr>




                                                        <tr>
                                                        
                                                                <td>{{trans('admin.Total_Return')}}</td>

                                                                <td>{{$TotalReturn}}</td>
                                                      

                                                         
                                                                <td>{{trans('admin.TotalNetReturn')}}</td>

                                                                <td>{{$item->Total_Net - $TotalReturn}}</td>
                                                      
                                                        </tr>









                                                        </tbody>
                                                    </table>
                                                </div>


                                        
                                                <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-striped table-condensed">
                                                    <tbody>
                                                    @if($item->Payment_Method == 'Delivery')

                                                        <td class="text-center"> {{trans('admin.Total_Bf_Delivery')}} </td>
                                                        <td class="text-center"> {{number_format((float)$item->Total_Price, 2, '.', '')}} </td>
                                                        <td class="text-center"> {{trans('admin.Delivery_Amount')}} </td>
                                                        <td class="text-center">{{number_format((float)$Address->Place()->first()->Ship_Price, 2, '.', '')}} </td>
                                                        <td class="text-center"> {{trans('admin.The_Net')}} </td>
                                                        <td class="text-center">{{number_format((float)$item->Pay, 2, '.', '')}} </td>
                                                    </tbody>
                                                </table>
                                                <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-striped table-condensed">
                                                    <tbody>
                                                    <td class="text-center"> {{trans('admin.Total_Af_Delivery')}} </td>
                                                    <td class="text-center">{{number_format((float)$item->Total_Price + $Address->Place()->first()->Ship_Price, 2, '.', '')}}  </td>
                                                    <td class="text-center">    {{trans('admin.Total_Pay_With_Delivery')}} </td>
                                                    <td class="text-center">{{number_format((float)$item->Pay + $Address->Place()->first()->Ship_Price, 2, '.', '')}}  </td>
                                                    @else
                                                        <tr>
                                                            <td class="text-center"> {{trans('admin.Total_Price')}} </td>
                                                            <td class="text-center">{{number_format((float)$item->Total_Price, 2, '.', '')}} </td>

                                                            <td class="text-center"> {{trans('admin.The_Net')}} </td>
                                                            <td class="text-center">{{number_format((float)$item->Pay, 2, '.', '')}} </td>
                                                        </tr>
                                                    @endif
                                                    </tbody>
                                                </table>

                                   
                                        </div>
                                    </div>
                                </div>
                             

                                    <div class="row">

                                        @if(app()->getLocale() == 'ar' )
                                            @php
                                                $xx=($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount;
                                              $f = new NumberFormatter("ar", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            @endphp
                                        @else
                                            @php
                                                $xx=($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount;
                                              $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            @endphp
                                        @endif
                                    </div>

                           


                                <div class="row">
                               
                                        <div class="col-md-4 col-sm-4 col-4 invoice-client-info text-center">
                                            <p class="mt-2 text-muted mb-0">
                                                {{trans('admin.Previous_Credit')}} : <span>{{$item->Current_Credit}}</span> <br>
                                                {{trans('admin.Credit')}} : <span id="AccountCredit"></span>
                                                <input type="hidden" id="Credit" value="{{$item->Client}}">

                                            </p>
                                        </div>
                                 
                                
                                        <div class="col-md-4 col-sm-4 col-4 invoice-client-info text-center">

                                            @php
                                                $x=$item->Code;
                                                $y=DNS1D::getBarcodePNG($x, 'C39');
                                            @endphp
                                            <img src="data:image/png;base64,{{$y}}" id="barcode" class="height-3 mt-1"/>

                                        </div>
                                 

                              
                                        <div class="col-md-4 col-sm-4 col-4 invoice-client-info text-center" >

                                            @if(null !== session('file_url'))
                                                {!! session('file_url') !!}
                                            @endif
                                        </div>
                             


                                </div>


                            </div>

                        </div>
                    </div>


         
                        <div class="row">

                            @if(!empty($Def->Print_Text_Footer_Sales))

                                @if($Place == 'Sales')
                                    {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Sales :$Def->Print_Text_Footer_Sales_En !!}
                                @elseif($Place == 'Quote')
                                    {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Quote :$Def->Print_Text_Footer_Quote !!}
                                @else
                                    {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Sales :$Def->Print_Text_Footer_Sales_En !!}
                                @endif

                            @endif
                        </div>
              

              
                        <div class="row">

                            @if(!empty($Def->Seal))

                                <img src="{{URL::to($Def->Seal)}}" class="img-fluid"/>
                            @endif


                        </div>
                


                    <div class="modal-footer">
                        <div class="row">
                            <div class="col-md-9">
                                <a href="{{url('KlarAdmin')}}" class="btn btn-secondary"
                                   data-dismiss="modal">{{trans('admin.Back')}}</a>
                                <button type="button" class="btn btn-default" onclick="window.print()"><i
                                        class="fal fa-print"></i></button>
                            </div>
                            <div class="col-md-3">
                                @if(!empty($item->Edit))
                                    @if($item->Edit == 1)

                                        <img src="{{asset('Admin/Edit.png')}}" class="img-fluid"
                                             style="width: 50%"/>
                                    @endif
                                @endif
                                @if(!empty($item->Delete))
                                    @if($item->Delete == 1)

                                        <img src="{{asset('Admin/Cancel.png')}}" class="img-fluid"
                                             style="width: 50%"/>
                                    @endif
                                @endif
                                @if(!empty($item->Transfer))
                                    @if($item->Transfer == 1)

                                        <img src="{{asset('Admin/Tarnsfer.png')}}" class="img-fluid"
                                             style="width: 50%"/>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>

                </div>
            </div>
    
        </main>


@endsection
@push('js')


    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/page-invoice.css')}}">

    <style>
        th {
            width: 135px !important;
        }
    </style>

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <script>
        $(document).ready(function () {
            $(function () {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function (elm) {
                            return elm
                        }
                    });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2(
                    {
                        ajax:
                            {
                                url: "https://api.github.com/search/repositories",
                                dataType: 'json',
                                delay: 250,
                                data: function (params) {
                                    return {
                                        q: params.term, // search term
                                        page: params.page
                                    };
                                },
                                processResults: function (data, params) {
                                    // parse the results into the format expected by Select2
                                    // since we are using custom formatting functions we do not need to
                                    // alter the remote JSON data, except to indicate that infinite
                                    // scrolling can be used
                                    params.page = params.page || 1;

                                    return {
                                        results: data.items,
                                        pagination:
                                            {
                                                more: (params.page * 30) < data.total_count
                                            }
                                    };
                                },
                                cache: true
                            },
                        placeholder: 'Search for a repository',
                        escapeMarkup: function (markup) {
                            return markup;
                        }, // let our custom formatter work
                        minimumInputLength: 1,
                        templateResult: formatRepo,
                        templateSelection: formatRepoSelection
                    });

                function formatRepo(repo) {
                    if (repo.loading) {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description) {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo) {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function () {
            interval = setInterval(function () {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function () {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function () {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function () {
            //init default
            $('.js-summernote').summernote(
                {
                    height: 200,
                    tabsize: 2,
                    placeholder: "Type here...",
                    dialogsFade: true,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']]
                            ['table', ['table']],
                        ['insert', ['link', 'picture', 'video']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ],
                    callbacks:
                        {
                            //restore from localStorage
                            onInit: function (e) {
                                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                            },
                            onChange: function (contents, $editable) {
                                clearInterval(interval);
                                timer();
                            }
                        }
                });

            //load emojis
            $.ajax(
                {
                    url: 'https://api.github.com/emojis',
                    async: false
                }).then(function (data) {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: 'type starting with : and any alphabet',
                    hint:
                        {
                            match: /:([\-+\w]+)$/,
                            search: function (keyword, callback) {
                                callback($.grep(emojis, function (item) {
                                    return item.indexOf(keyword) === 0;
                                }));
                            },
                            template: function (item) {
                                var content = emojiUrls[item];
                                return '<img src="' + content + '" width="20" /> :' + item + ':';
                            },
                            content: function (item) {
                                var url = emojiUrls[item];
                                if (url) {
                                    return $('<img />').attr('src', url).css('width', 20)[0];
                                }
                                return '';
                            }
                        }
                });

            //init mentions example
            $(".js-hint2mention").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: "type starting with @",
                    hint:
                        {
                            mentions: ['jayden', 'sam', 'alvin', 'david'],
                            match: /\B@(\w*)$/,
                            search: function (keyword, callback) {
                                callback($.grep(this.mentions, function (item) {
                                    return item.indexOf(keyword) == 0;
                                }));
                            },
                            content: function (item) {
                                return '@' + item;
                            }
                        }
                });

        });

    </script>
    <script type="text/javascript">


        $(".show-table").click(function () {
            $(".hide-table").show();
        });

    </script>


    <!-- Account Balance -->
    <script>
        $(document).ready(function () {

            var countryId = $('#Credit').val();
            if (countryId) {
                $.ajax({
                    url: 'AccountBalanceFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function () {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function (data) {
                        $.each(data, function (key, value) {

                            $('#AccountCredit').text(parseFloat(key).toFixed(2));
                            $('#AccountCredit').text(parseFloat(value).toFixed(2));


                        });


                        window.print();

                    },
                    complete: function () {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }


        });
    </script>

@endpush
