@extends('admin.index')
@section('content')
    @php
        use App\Models\Stores;
        use App\Models\ProductSalesOrder;
        use App\Models\CompanyData;
        use App\Models\GeneralDaily;
        $Def=CompanyData::orderBy('id','desc')->first();
        use App\Models\DefaultDataShowHide;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
    @endphp
    <title>{{trans('admin.SalesOrderHoldSechdule')}}</title>


    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
            <li class="breadcrumb-item active"> {{trans('admin.SalesOrderHoldSechdule')}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>


        <!-- Data -->
        <div class="row hide-table">
            <div class="col-xl-12">
                <div id="panel-1" class="panel second-color">
                    <div class="panel-hdr">
                        <h2>
                            {{trans('admin.SalesOrderHoldSechdule')}}
                        </h2>

                        <div class="panel-toolbar">
                            <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                Style</button>
                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                            <!-- datatable start -->
                            <div style="overflow:auto;">
                                <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Executor')}} </th>
                                        <th> {{trans('admin.Safe')}} </th>
                                        <th> {{trans('admin.Client')}} </th>
                                        <th> {{trans('admin.Delegate')}} </th>
                                        <th> {{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.ProfitPrecent')}}</th>
                                        <th class="text-center">{{trans('admin.Actions')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($items as $item)
                                        <tr @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted"  @endif >
                                            <td>{{$item->Code}}</td>

                                            <td>{{$item->Date}}</td>

                                            <td>

                                                @if($item->Payment_Method == 'Cash')
                                                    {{trans('admin.Cash')}}
                                                @elseif($item->Payment_Method == 'Later')
                                                    {{trans('admin.Later')}}
                                                @elseif($item->Payment_Method == 'Delivery')
                                                    {{trans('admin.Delivery')}}
                                                @elseif($item->Payment_Method == 'Cash_Visa')
                                                    {{trans('admin.Cash_Visa')}}
                                                @elseif($item->Payment_Method == 'Cash_Collection')
                                                    {{trans('admin.Cash_Collection')}}

                                                @elseif($item->Payment_Method == 'Check')

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Check{{$item->id}}">{{trans('admin.Check')}} </button>
                                                @elseif($item->Payment_Method == 'Installment')

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Installment{{$item->id}}">{{trans('admin.Installment')}} </button>
                                                @elseif($item->Payment_Method == 'InstallmentCompanies')

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#InstallmentCompanies{{$item->id}}">{{trans('admin.InstallmentCompanies')}} </button>
                                                @endif
                                            </td>

                                            <td>
                                                @if(!empty($item->Executor()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                @endif
                                            </td>



                                            <td>

                                                @if(!empty($item->Safe()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Client()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Delegate()->first()->Name))

                                                    {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Store()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                @endif
                                            </td>






                                            <td>
                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                    {{trans('admin.Details')}}
                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                    {{trans('admin.Data')}}
                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ProfitPrecent{{$item->id}}">
                                                    {{trans('admin.ProfitPrecent')}}
                                                </button>
                                            </td>
                                            <td class="text-center">


                                                <a href="{{url('SalesOrderPrint/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print"></i>
                                                </a>


                                                @if($item->Edit == 0 and $item->Delete == 0)

                                                    @if($item->ToSales != 1)

                                                        @if($item->Hold_Qty == 1)
                                                            @if($item->Cancel_Order == 0)

                                                                @if($item->Delegate_Recived == 0)
                                                                    <a href="{{url('DelegateRecivedAccept/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-handshake"></i></a>

                                                                    <a href="{{url('CancelSalesOrder/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-times"></i></a>
                                                                @endif



                                                                @if($item->Delegate_Recived == 1)

                                                                    ({{$item->Delegate_Recived_Time}})


                                                                    @can('تحويل امر البيع')
                                                                        <a href="{{url('HoldSale/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-arrow-left"></i></a>
                                                                    @endcan



                                                                    @can('حذف امر البيع')
                                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                                    @endcan



                                                                @endif



                                                            @else

                                                             ({{$item->Cancel_Order_Time}})
                                                                {{trans('admin.Canceled')}}

                                                            @endif

                                                        @else

                                                            @can('تحويل امر البيع')
                                                                <a href="{{url('HoldSale/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-arrow-left"></i></a>
                                                            @endcan

                                                            @can('حذف امر البيع')
                                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                            @endcan


                                                        @endif


                                                    @endif
                                                @endif

                                                @if($item->Edit == 1)
                                                    <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                @elseif($item->Delete == 1)

                                                    <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                                @endif



                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Executor')}} </th>
                                        <th> {{trans('admin.Safe')}} </th>
                                        <th> {{trans('admin.Client')}} </th>
                                        <th> {{trans('admin.Delegate')}} </th>
                                        <th> {{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.ProfitPrecent')}}</th>
                                        <th class="text-center">{{trans('admin.Actions')}} </th>
                                    </tr>
                                    </tfoot>

                                </table>

                                {{$items->Links()}}
                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    @foreach($items as $item)

        <!-- Modal Delete -->
        <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                        <a href="{{url('DeleteSalesOrder/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Details -->
        <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
             aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Details')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">


                        @php
                            $details=ProductSalesOrder::where('SalesOrder',$item->id)->get();
                        @endphp
                        <div class="mt-3">
                            <div style="overflow:auto">
                                <table id=""
                                       class="table table-bordered table-hover table-striped" >
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Code')}} </th>
                                        @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                        @endif
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.AvQty')}} </th>
                                        <th>{{trans('admin.Qty')}} </th>
                                        <th>{{trans('admin.Price')}} </th>
                                        <th>{{trans('admin.Discount')}} </th>
                                        <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                        <th>{{trans('admin.Total_Tax')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Exp_Date')}} </th>
                                        <th>{{trans('admin.Desc')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    @foreach($details as $detail)
                                        <tr>
                                            <td>{{$detail->Product_Code}}</td>
                                            @if($show->Patch_Number == 1)
                                                <td>{{$detail->Patch_Number}}</td>
                                            @endif
                                            <td>
                                                {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

                                                @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                                @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                                            </td>
                                            <td>
                                                @if(!empty($detail->Product()->first()->Group))       {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}    @endif
                                            </td>
                                            <td>
                                                @if(!empty($detail->Product()->first()->Brand))
                                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>{{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>
                                            <td>{{$detail->AvQty}}</td>
                                            <td>{{$detail->Qty}}</td>
                                            <td>{{$detail->Price}}</td>
                                            <td>{{$detail->Discount}}</td>
                                            <td>{{$detail->Total_Bf_Tax}}</td>
                                            <td>{{$detail->Total_Tax}}</td>
                                            <td>{{$detail->Total}}</td>
                                            <td>  {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}</td>
                                            <td>{{$detail->Exp_Date}}</td>
                                            <td>{{$detail->SalesProDesc}}</td>

                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}} </th>
                                        @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                        @endif
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.AvQty')}} </th>
                                        <th>{{trans('admin.Qty')}} </th>
                                        <th>{{trans('admin.Price')}} </th>
                                        <th>{{trans('admin.Discount')}} </th>
                                        <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                        <th>{{trans('admin.Total_Tax')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Exp_Date')}} </th>
                                        <th>{{trans('admin.Desc')}} </th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div style="overflow:auto">
                                <table class="table table-bordered table-hover table-striped mt-4" >
                                    <tbody>
                                    <tr>
                                        <td>{{trans('admin.Product_Numbers')}}</td>
                                        <td>{{$item->Product_Numbers}}</td>

                                        <td>{{trans('admin.Total_Qty')}}</td>
                                        <td>{{$item->Total_Qty}}</td>

                                        <td>{{trans('admin.Total_Discount')}}</td>
                                        <td>{{$item->Total_Discount}}</td>

                                        <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                        <td>{{$item->Total_BF_Taxes}}</td>

                                        <td>{{trans('admin.Total_Taxes')}}</td>
                                        <td>{{$item->Total_Taxes}}</td>

                                        <td>{{trans('admin.Total_Price')}}</td>
                                        <td>{{$item->Total_Price}}</td>

                                        <td>{{trans('admin.Paid')}}</td>
                                        <td>{{$item->Pay}}</td>

                                        <td>{{trans('admin.Total_Net')}}</td>
                                        <td>

                                            @if(is_numeric($item->Total_Price))

                                                @php $tot=$item->Total_Price;   @endphp



                                            @else
                                                @php $tot=0;   @endphp
                                            @endif

                                            @if(is_numeric($item->Total_Taxes))

                                                @php $totTax=$item->Total_Taxes;   @endphp



                                            @else
                                                @php $totTax=0;   @endphp
                                            @endif

                                            @if(is_numeric($item->Total_Discount))

                                                @php $disc=$item->Total_Discount;   @endphp



                                            @else
                                                @php $disc=0;   @endphp
                                            @endif





                                            {{$tot + $totTax - $disc}}

                                        </td>


                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <a class="btn btn-primary" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>
                        </div>
                    </div>
                </div>
            </div>

        </div>



        <!-- Modal Installment -->
        <div class="modal fade" id="Installment{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{trans('admin.Presenter')}}</label>
                                    <span>{{$item->presenter}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.annual_interest')}}</label>
                                    <span>{{$item->annual_interest}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.monthly_installment')}}</label>
                                    <span>{{$item->monthly_installment}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Years_Number')}}</label>
                                    <span>{{$item->Years_Number}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.total')}}</label>
                                    <span>{{$item->total}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.installment_Num')}}</label>
                                    <span>{{$item->installment_Num}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Date_First_installment')}}</label>
                                    <span>{{$item->Date_First_installment}}</span>
                                </div>

                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Check -->
        <div class="modal fade" id="Check{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-4">
                                    <label>{{trans('admin.Check_Type')}}</label>
                                    @if(!empty($item->Check_Type()->first()->Arabic_Name))
                                        <span>

                                {{app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name}}
                            </span>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <label>{{trans('admin.Due_Date')}}</label>
                                    <span>{{$item->Due_Date}}</span>
                                </div>

                                <div class="col-md-4">
                                    <label>{{trans('admin.Check_Number')}}</label>
                                    <span>{{$item->Check_Number}}</span>
                                </div>


                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal InstallmentCompanies -->
        <div class="modal fade" id="InstallmentCompanies{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{trans('admin.InstallCompany')}}</label>
                                    <span>@if(!empty($item->InstallCompany()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->InstallCompany()->first()->Arabic_Name :$item->InstallCompany()->first()->English_Name}}
                                        @endif</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.ContractNumber')}}</label>
                                    <span>{{$item->ContractNumber}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.PayFees')}}</label>
                                    <span>{{$item->PayFees}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.ServiceFee')}}</label>
                                    <span>{{$item->ServiceFee}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.CompanyPrecent')}}</label>
                                    <span>{{$item->CompanyPrecent}}</span>
                                </div>



                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal show data -->
        <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Data')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">
                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Store_Code')}}</th>
                                    <th> {{trans('admin.Draw')}} </th>
                                    <th>{{trans('admin.Status')}} </th>
                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                    <th> {{trans('admin.Notes')}} </th>
                                    <th> {{trans('admin.Later_Due')}} </th>
                                    <th> {{trans('admin.Coin')}} </th>
                                    <th> {{trans('admin.Cost_Center')}} </th>
                                    <th> {{trans('admin.Shipping_Compaines')}} </th>
                                    <th> {{trans('admin.User')}} </th>

                                    <th> {{trans('admin.ResturantOrderType')}} </th>
                                    <th> {{trans('admin.Table')}} </th>
                                    <th> {{trans('admin.File')}} </th>




                                </tr>
                                </thead>
                                <tbody>

                                <tr>

                                    <td>{{$item->Store_Code}}</td>
                                    <td>{{$item->Draw}}</td>

                                    <td>

                                        @if($item->Status == 1)
                                            {{trans('admin.Recived')}}
                                        @elseif($item->Status == 0)
                                            {{trans('admin.Pending')}}
                                        @endif
                                    </td>
                                    <td>{{$item->Refernce_Number}}</td>
                                    <td>{{$item->Note}}</td>
                                    <td>

                                        {{$item->Later_Due}}
                                    </td>
                                    <td>

                                        @if(!empty($item->Coin()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}

                                        @endif
                                    </td>
                                    <td>
                                        @if(!empty($item->Cost_Center()->first()->Arabic_Name ))
                                            {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                        @endif
                                    </td>

                                    <td>
                                        @if(!empty($item->Ship()->first()->Name))


                                            {{app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn}}
                                        @endif
                                    </td>

                                    <td>

                                        @if(!empty($item->User()->first()->name))
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                        @endif
                                    </td>


                                    <td>


                                        {{trans('admin.'.$item->ResturantOrderType)}}

                                    </td>
                                    <td>
                                        @if(!empty($item->Table()->first()->Arabic_Name))
                                            {{app()->getLocale() == 'ar' ?$item->Table()->first()->Arabic_Name :$item->Table()->first()->English_Name}}
                                        @endif
                                    </td>



                                    <td>
                                        @if(!empty($item->File))
                                            <a href="{{URL::to($item->File)}}" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                        @endif
                                    </td>
                                </tr>


                                </tbody>


                            </table>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>


        <!-- Modal ProfitPrecent -->
        <div class="modal fade" id="ProfitPrecent{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.ProfitPrecent')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">



                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Total_Cost')}}</th>
                                    <th>{{trans('admin.Total_Price')}}</th>
                                    <th> {{trans('admin.Profit')}} </th>
                                    <th>{{trans('admin.ProfitPrecent')}} </th>


                                </tr>
                                </thead>
                                <tbody>

                                <tr>

                                    <td>
                                        @if(is_numeric($item->Total_Cost))
                                            {{$item->Total_Cost}}
                                        @else
                                            0
                                        @endif
                                    </td>



                                    @if($show->TaxOnTotal == 1)


                                        <td>{{($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount}}</td>

                                    @else


                                        <td>{{$item->Total_Price + $item->Total_Taxes - $item->Total_Discount}}</td>
                                    @endif

                                    <td>
                                        @if($show->TaxOnTotal == 1)

                                            @php $rab7=($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount; @endphp


                                            @if(is_numeric($item->Total_Cost))

                                                {{ $rab7 - $item->Total_Cost}}
                                            @else
                                                {{ $rab7  }}

                                            @endif

                                        @else



                                            @php $rab7=$item->Total_Price + $item->Total_Taxes - $item->Total_Discount; @endphp

                                            @if(is_numeric($item->Total_Cost))

                                                {{ $rab7 - $item->Total_Cost}}
                                            @else
                                                {{ $rab7 }}

                                            @endif


                                        @endif

                                    </td>


                                    @if(is_numeric($item->Total_Cost))
                                        <td>

                                            @php

                                                if($item->Total_Cost != 0){

                                                $Nsbtrab7=(($rab7 - $item->Total_Cost) * 100) / $item->Total_Cost ;
                                                }else{

                                                $Nsbtrab7=(($rab7) * 100) / 1 ;

                                                }

                                            @endphp

                                            {{ round($Nsbtrab7)  }} %
                                        </td>
                                    @else

                                        <td>

                                            @php


                                                $Nsbtrab7=(($rab7)) ;



                                            @endphp

                                            {{ round($Nsbtrab7)  }} %
                                        </td>
                                    @endif

                                </tr>


                                </tbody>


                            </table>


                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>




    @endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function()
        {
            interval = setInterval(function()
            {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function()
        {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function()
        {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function()
        {
            //init default
            $('.js-summernote').summernote(
                {
                    height: 200,
                    tabsize: 2,
                    placeholder: "Type here...",
                    dialogsFade: true,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']]
                            ['table', ['table']],
                        ['insert', ['link', 'picture', 'video']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ],
                    callbacks:
                        {
                            //restore from localStorage
                            onInit: function(e)
                            {
                                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                            },
                            onChange: function(contents, $editable)
                            {
                                clearInterval(interval);
                                timer();
                            }
                        }
                });

            //load emojis
            $.ajax(
                {
                    url: 'https://api.github.com/emojis',
                    async: false
                }).then(function(data)
            {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: 'type starting with : and any alphabet',
                    hint:
                        {
                            match: /:([\-+\w]+)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(emojis, function(item)
                                {
                                    return item.indexOf(keyword) === 0;
                                }));
                            },
                            template: function(item)
                            {
                                var content = emojiUrls[item];
                                return '<img src="' + content + '" width="20" /> :' + item + ':';
                            },
                            content: function(item)
                            {
                                var url = emojiUrls[item];
                                if (url)
                                {
                                    return $('<img />').attr('src', url).css('width', 20)[0];
                                }
                                return '';
                            }
                        }
                });

            //init mentions example
            $(".js-hint2mention").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: "type starting with @",
                    hint:
                        {
                            mentions: ['jayden', 'sam', 'alvin', 'david'],
                            match: /\B@(\w*)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(this.mentions, function(item)
                                {
                                    return item.indexOf(keyword) == 0;
                                }));
                            },
                            content: function(item)
                            {
                                return '@' + item;
                            }
                        }
                });

        });

    </script>
    <script type="text/javascript">


        $(".show-table").click(function(){
            $(".hide-table").show();
        });

    </script>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            .modal-content * {
                visibility: visible;
                overflow: visible;
            }
            .main-page * {
                display: none;
            }
            .modal {
                position: absolute;
                left: 0;
                top: -180px;
                margin: 0;
                padding: 0;
                min-height: 550px;
                visibility: visible;
                overflow: visible !important; /* Remove scrollbar for printing. */
            }
            .modal-dialog {
                visibility: visible !important;
                overflow: visible !important; /* Remove scrollbar for printing. */
            }

            .page-content{
                display:none;
            }
            @page {

                size: a4;

            }

        }
    </style>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {
                            var query = {
                                search: params.term,
                            };
                            if (params.term == "*") query.items = [];
                            return { json: JSON.stringify(query) };
                        },
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });
            });
        });
    </script>



@endpush
