@extends('admin.index')
@section('content')
@php
use App\Models\InstallmentDates;
@endphp
  <title>{{trans('admin.InstallmentSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.InstallmentSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

         <!-- Filter -->
         <div class="row">
             <div class="col-lg-12">
                 <div id="panel-2" class="panel first-color">
                     <div class="panel-hdr">
                         <h2>
                             <span class="fw-300"><i> {{trans('admin.Filter')}} </i></span>
                         </h2>
                     </div>
                     <div class="panel-container show">
                         <div class="panel-content">
                             <form action="{{url('FilterInstallmentSechdule')}}" method="get" class="form-row">


                                 <div class="form-group col-md-2">
                                     <label class="form-label" for=""> {{trans('admin.Account')}} </label>
                                     <select class="select2 form-control w-100" id="client" name="Client">
                                         <option value=""> {{trans('admin.Account')}}</option>

                                     </select>
                                 </div>


                                 <div class="form-group col-lg-2">
                                     <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                     <input type="text" name="Code" class="form-control">
                                 </div>


                                 <div class="form-group col-lg-2">
                                     <label class="form-label" for="simpleinput">{{trans('admin.Date_First_installment')}} </label>
                                     <input type="date" name="Date_First_installment" class="form-control">
                                 </div>



                                 <div class="form-group col-md-2" style="display: none">
                                     <label class="form-label" for=""> {{trans('admin.Type')}} </label>
                                     <select class="select2 form-control w-100" name="Type">
                                         <option value=""> {{trans('admin.Type')}}</option>
                                         <option value="Today">{{trans('admin.Today')}} </option>
                                         <option value="Month">{{trans('admin.ThisMonth')}}</option>

                                     </select>
                                 </div>


                                 <div class="form-group col-md-2">
                                     <div class="buttons mt-4">
                                         <button type="submit" class="btn btn-primary show-table w-100"><i
                                                 class="fal fa-folder"></i> {{trans('admin.Show')}}</button>
                                     </div>
                                 </div>

                             </form>
                         </div>
                     </div>
                 </div>
             </div>
         </div>

            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.InstallmentSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                      @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table id="dt-basic-example" class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Guarantor')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>
                                                    <th>{{trans('admin.Sales_Bill_Num')}}</th>
                                                    <th>{{trans('admin.monthly_installment')}}</th>
                                                    <th>{{trans('admin.installment_Num')}}</th>
                                                    <th>{{trans('admin.Residual')}}</th>
                                                    <th>{{trans('admin.Remaining_interest')}}</th>


                                                    <th>{{trans('admin.Presenter')}}</th>
                                                    <th>{{trans('admin.annual_interest')}}</th>
                                                    <th>{{trans('admin.Years_Number')}}</th>
                                                    <th>{{trans('admin.total')}}</th>
                                                    <th>{{trans('admin.Date_First_installment')}}</th>

                                                    <th>{{trans('admin.Status')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>



                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)

                                                    @php  $customer=\App\Models\Customers::where('Account',$item->Client)->first();   @endphp
                                                <tr>
                                                    <td>
                                             {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                    </td>
                                                    <td>
                                                        @if(!empty($customer))
                                                        @if(!empty($customer->Guarantor()->first()->Name))

                                                            {{$customer->Guarantor()->first()->Name}}

                                                        @endif
                                                        @endif


                                                    </td>
                                                    <td>
                                                        @if(!empty($customer))


                                                            {{$customer->Phone}}<br>
                                                            {{$customer->Phone2}}<br>


                                                        @endif


                                                    </td>
                                                    <td>{{$item->Sales()->first()->Code}}</td>
                                                    <td>{{$item->monthly_installment}}</td>
                                                    <td>{{$item->installment_Num}}</td>
                                                    <td>{{$item->Residual}}</td>
                                                    <td>{{$item->monthly_installment * $item->installment_Num}}</td>


                                                    <td>{{$item->presenter}}</td>
                                                      <td>{{$item->annual_interest}}</td>
                                                    <td>

                                                    {{number_format($item->Years_Number,2,'.')}}
                                                    </td>
                                                      <td>{{$item->total}}</td>
                                                      <td>{{$item->Date_First_installment}}</td>

                                                    <td>
                                                @if($item->Status == 0)
                     <a class="btn btn-danger" href="{{url('InstallBillDone/'.$item->id)}}">
                                                <i class="fal fa-times"></i>
                                                        </a>
                                                @elseif($item->Status == 1)
                    <a class="btn btn-primary" href="{{url('UnInstallBill/'.$item->id)}}">
                                                <i class="fal fa-check"></i>
                                                        </a>
                                                @endif
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Guarantor')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>
                                                    <th>{{trans('admin.Sales_Bill_Num')}}</th>
                                                    <th>{{trans('admin.monthly_installment')}}</th>
                                                    <th>{{trans('admin.installment_Num')}}</th>
                                                    <th>{{trans('admin.Residual')}}</th>
                                                    <th>{{trans('admin.Remaining_interest')}}</th>
                                                    <th>{{trans('admin.Presenter')}}</th>
                                                    <th>{{trans('admin.annual_interest')}}</th>
                                                    <th>{{trans('admin.Years_Number')}}</th>
                                                    <th>{{trans('admin.total')}}</th>
                                                    <th>{{trans('admin.Date_First_installment')}}</th>

                                                    <th>{{trans('admin.Status')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>


                                                </tr>
                                            </tfoot>
                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)

                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                @php
                $details=InstallmentDates::where('Install',$item->id)->orderBy('id','asc')->get();
                @endphp
                        <div class="mt-3">
                            <table id=""
                            class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Date_Install')}} </th>
                                    <th>{{trans('admin.Value_Install')}} </th>
                                     <th>{{trans('admin.Status')}} </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr @if($detail->Status == 1) style="background-color: #3c763d; color: white" @endif>

                                    <td>{{$detail->Date}}</td>
                                    <td>{{$detail->Value}}</td>
                                     <td>
                                                @if($detail->Status == 0)

                              <button type="button" class="btn btn-default" data-toggle="modal" data-target="#ReciptTwo{{$detail->id}}">
                                              <i class="fal fa-times"></i>
                                                        </button>
                                                @elseif($detail->Status == 1)
                                                <i class="fal fa-check"></i>
                                                @endif
                                     </td>


         <div class="modal fade" id="ReciptTwo{{$detail->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
{{trans('admin.InstallmentCollect')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <form action="{{url('InstallDone')}}" method="post">
                    @csrf
                   <input type="hidden" name="ID" value="{{$detail->id}}">

                    <div class="modal-body">
                        <div class="row">


                <div class="col-md-6">
                <label>{{trans('admin.Creditor')}}</label>
        <input type="number" step="any" class="form-control"  name="Creditor" value="{{$detail->Value}}" required >

                        </div>

                        <div class="col-md-6">
                <label>{{trans('admin.Account')}}</label>
                <select class="select2 form-control w-100"  disabled >
                                <option value=""> {{trans('admin.Account')}}</option>
                                           @foreach($Clients as $cli)
                  <option value="{{$cli->id}}" @if($cli->id == $item->Client) selected @endif>

                      {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}
                                                </option>
                                            @endforeach
                          </select>
                            <input type="hidden" name="Account" value="{{$item->Client}}">
                        </div>

                                         <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" >
                                    <option value="">{{trans('admin.Currency')}}</option>
                                                @foreach($Coins as $coin)
                         <option value="{{$coin->id}}" @if($Def->Coin == $coin->id) selected @endif>
                       {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                       <input type="number" step="any" name="Draw" value="1" class="form-control"  />
                                        </div>


                                                 <div class="form-group col-lg-4">

                                                <label class="form-label" for="">{{trans('admin.Safe')}} </label>
                             <select class="select2 form-control w-100" name="Safe" >
                                             <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>

                                            {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>



                        </div>
                    </div>

                    <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-dismiss="modal">   {{trans('admin.Close')}}</button>
             <button type="submit" class="btn btn-secondary">   {{trans('admin.Save')}}</button>
                    </div>
                     </form>

                </div>
            </div>
        </div>




                                </tr>
                                 @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>{{trans('admin.Date')}} </th>
                                    <th>{{trans('admin.Value')}} </th>
                                     <th>{{trans('admin.Status')}} </th>
                                </tr>
                            </tfoot>
                        </table>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            </div>



@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('#Emp').empty();
                                    $.each(data, function (key, value) {

                                        $('#Emp').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $("#client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllClientsFilter",
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {

                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function(params) {

                            $.ajax({
                                url: 'AllClientsFilterJS/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#client').empty();
                                    $.each(data, function(key, value) {

                                        $('#client').append('<option value="' + key + '">' + value + '</option>');

                                    });

                                    var countryId = $('#client').val();
                                    if (countryId) {
                                        $.ajax({
                                            url: 'NewAccountBalanceSOFilter/' + countryId,
                                            type: "GET",
                                            dataType: "json",
                                            beforeSend: function() {
                                                $('#loader').css("visibility", "visible");
                                            },

                                            success: function(data) {

                                                $('#AccountCredit').val(data.credit);
                                                $('#Credit_Limit').val(data.limit);

                                            },
                                            complete: function() {
                                                $('#loader').css("visibility", "hidden");
                                            }
                                        });
                                    } else {

                                        $('select[name="state"]').empty();
                                    }



                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#client").on("select2:select", function(e) {
                    console.log("select done", e.params.data);
                });


            });
        });

    </script>

<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: 0;
			margin: 0;
			padding: 0;
			min-height: 550px;
			visibility: visible;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}


	}
	</style>

@endpush
