@extends('admin.index')
@section('content')
@php
use App\Models\CustomerCommentsProducts;
@endphp
<title>{{trans('admin.CommentsClients')}}</title>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Sales')}}</a></li>
        <li class="breadcrumb-item active">{{trans('admin.CommentsClients')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="row">
         <div class="col-xl-12 text-center">
               <h1 class="text-center" style="font-size: 20px">{{$NAME}}</h1>
        </div>
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                
                    <h2>
                        <span class="fw-300"><i>{{trans('admin.CommentsClients')}}</i></span>
                        
                        
                       
                    </h2>

                    <div class="panel-toolbar">
                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                        @include('admin.layouts.toolbar')
                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <!-- datatable start -->
                        
                      
                        
                        <div id="mobile-overflow">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                <thead class="bg-highlight">
                                    <tr>

                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Time')}}</th>
                                        <th>{{trans('admin.Interview_Type')}}</th>
                                        <th>{{trans('admin.Rate_Interview')}}</th>
                                        <th>{{trans('admin.Visit_Cost')}}</th>
                                        <th>{{trans('admin.Note')}}</th>
                                        <th>{{trans('admin.Arabic_Comment')}}</th>
                                        <th>{{trans('admin.English_Comment')}}</th>
                                        <th>{{trans('admin.Responsible')}}</th>
                                        <th> {{trans('admin.Location')}}</th>
                                        <th> {{trans('admin.Voice')}}</th>
                                        <th> {{trans('admin.Products')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach($items as $item)
                                    <tr   @if(!empty($item->Rate()->first()->Color)) style="background-color: {{$item->Rate()->first()->Color}}; color: white" @endif>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
                                        <td>
                                            @if(!empty($item->Type()->first()->Arabic_Name))
                                            {{app()->getLocale() == 'ar' ?$item->Type()->first()->Arabic_Name :$item->Type()->first()->English_Name}}
                                            @endif
                                        </td>
                                        <td>

                                            @if(!empty($item->Rate()->first()->Arabic_Name))
                                                {{app()->getLocale() == 'ar' ?$item->Rate()->first()->Arabic_Name :$item->Rate()->first()->English_Name}}
                                            @endif


                                        </td>
                                        <td>{{$item->Visit_Cost}}</td>
                                        <td>{{$item->Note}}</td>
                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Problem{{$item->id}}">
                                                {{trans('admin.Arabic_Comment')}}
                                            </button>
                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#ProblemEn{{$item->id}}">
                                                {{trans('admin.English_Comment')}}
                                            </button>
                                        </td>
                                        <td>
                                            @if(!empty($item->Responsible()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$item->Responsible()->first()->Name :$item->Responsible()->first()->NameEn}}
                                            @endif

                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Loc{{$item->id}}">{{trans('admin.Location')}}</button>
                                        </td>
                                      <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Voice{{$item->id}}">{{trans('admin.Voice')}}</button>
                                        </td>
                                        
                                        
                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Products{{$item->id}}">{{trans('admin.Products')}}</button>
                                        </td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                        </td>
                                    </tr>
                                    @endforeach


                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Time')}}</th>
                                        <th>{{trans('admin.Rate_Interview')}}</th>
                                        <th>{{trans('admin.Interview_Type')}}</th>
                                        <th>{{trans('admin.Visit_Cost')}}</th>
                                        <th>{{trans('admin.Note')}}</th>
                                        <th>{{trans('admin.Arabic_Comment')}}</th>
                                        <th>{{trans('admin.English_Comment')}}</th>
                                        <th>{{trans('admin.Responsible')}}</th>
                                        <th> {{trans('admin.Location')}}</th>
                                        <th> {{trans('admin.Voice')}}</th>
                                        <th> {{trans('admin.Products')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- datatable end -->
                        {{$items->Links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Add-->
    <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.AddNew')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('AddCommentsClient')}}" method="post">
                        {!! csrf_field() !!}
                        @honeypot
                        <input type="hidden" name="Customer" value="{{$customer}}">
                        <div class="form-row">



                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                <input type="text" value="{{$Code}}" class="form-control " disabled>
                                <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Rate_Interview')}}</label>
                                <select class="select2 form-control w-100" name="Rate" >
                                    <option value="">{{trans('admin.Rate_Interview')}}</option>
                                    @foreach($Rates as $rate)
                                        <option value="{{$rate->id}}">
                                            {{app()->getLocale() == 'ar' ?$rate->Arabic_Name :$rate->English_Name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Interview_Type')}}</label>
                                <select class="select2 form-control w-100" name="Type" >
                                    <option value="">{{trans('admin.Interview_Type')}}</option>
                                    @foreach($Types as $type)
                                        <option value="{{$type->id}}">
                                            {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-4">
                                <label class="form-label" for=""> {{trans('admin.Responsible')}}</label>
                                <select class="select2 form-control w-100" name="Responsible" required>
                                    <option value="">{{trans('admin.Responsible')}}</option>
                                    @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}">
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            
                            
                            
                            
                                                <div class="form-group col-lg-12">
                                                    <label class="form-label" for=""> ({{trans('admin.Product')}})</label>
                                                    <select class="select2 form-control w-100" multiple id="product" name="Product[]">

                                                    </select>
                                                </div>

                            
                            
                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Visit_Cost')}}</label>
                                <input type="number" step="any" name="Visit_Cost" value="{{old('Visit_Cost')}}" class="form-control" >
                            </div>

                            
                            
                            
                            
                            

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Note')}}</label>
                                <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                            </div>

                            
                            
                            
                   
                            
                            

                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Comment')}}</label>
                                <textarea type="text" name="Comment" class="form-control" required>
                                {{old('Comment')}}
                                </textarea>
                            </div>

                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Comment')}}</label>
                                <textarea type="text" name="CommentEn" class="form-control">
                                {{old('CommentEn')}}
                                </textarea>
                            </div>

                        </div>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>



    @foreach($items as $item)
    <!-- Modal Edit-->
    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.Edit')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                             @php
                        
                            $Pros=CustomerCommentsProducts::where('Comment',$item->id)->get();
        
                        @endphp
                <div class="modal-body">
                    <form action="{{url('EditCommentsClient/'.$item->id)}}" method="post">
                        {!! csrf_field() !!}
                        @honeypot
                        <input type="hidden" name="Customer" value="{{$customer}}">
                        <div class="form-row">


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                <input type="text" value="{{$item->Code}}" class="form-control " disabled>
                                <input type="hidden" name="Code" value="{{$item->Code}}" class="form-control">
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Rate_Interview')}}</label>
                                <select class="select2 form-control w-100" name="Rate" >
                                    <option value="">{{trans('admin.Rate_Interview')}}</option>
                                    @foreach($Rates as $rate)
                                        <option value="{{$rate->id}}" @if($item->Rate == $rate->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$rate->Arabic_Name :$rate->English_Name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Interview_Type')}}</label>
                                <select class="select2 form-control w-100" name="Type" >
                                    <option value="">{{trans('admin.Interview_Type')}}</option>
                                    @foreach($Types as $type)
                                        <option value="{{$type->id}}" @if($item->Type == $type->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label class="form-label" for=""> {{trans('admin.Responsible')}}</label>
                                <select class="select2 form-control w-100" name="Responsible" required>
                                    <option value="">{{trans('admin.Responsible')}}</option>
                                    @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if($item->Responsible == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            
                        
    
                                                <div class="form-group col-lg-12">
                                                    <label class="form-label" for=""> ({{trans('admin.Product')}})</label>
                                                    <select class="select2 form-control w-100 product" multiple  name="Product[]">

                                                        @foreach($Pros as $pro)
                                                        
                                                             @if(!empty($pro->Product()->first()->P_Ar_Name))       
                                                        <option value="{{$pro->Product}}" selected>
                                                        
                                                       {{$pro->Product()->first()->P_Ar_Name}}   
                                                        </option>
                                                        @endif
                                                        @endforeach
                                                    </select>
                                                </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Visit_Cost')}}</label>
                                <input type="number" step="any" name="Visit_Cost" value="{{$item->Visit_Cost}}" class="form-control" >
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Note')}}</label>
                                <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                            </div>




                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Comment')}}</label>
                                <textarea type="text" name="Comment" class="form-control" required>
                                {{$item->Comment}}
                                </textarea>
                            </div>

                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Comment')}}</label>
                                <textarea type="text" name="CommentEn" class="form-control" required>
                                {{$item->CommentEn}}
                                </textarea>
                            </div>

                        </div>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                    <a href="{{url('DeleteCommentsClient/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Comment -->
    <div class="modal fade" id="Problem{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        <strong>{{$item->Comment}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Cancel')}}</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Comment English-->
    <div class="modal fade" id="ProblemEn{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        <strong>{{$item->CommentEn}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Cancel')}}</button>
                </div>
            </div>
        </div>
    </div>


        <!-- Modal Location -->
        <div class="modal fade" id="Loc{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">



                        <iframe src="https://maps.google.com/maps?q={{$item->lat}},{{$item->lng}}&hl=en&z=14&amp;output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Voice -->
        <div class="modal fade" id="Voice{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">



                <audio controls>

        <source src="{{URL::to($item->Voice) }}" type="audio/webm">
        Your browser does not support the audio element.
    </audio>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Products -->
        <div class="modal fade" id="Products{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">

                        @php
                        
                            $Pros=CustomerCommentsProducts::where('Comment',$item->id)->get();
        
                        @endphp
                        <ul>
                 
                            @foreach($Pros as $pro)
                        <li>
                            
                        @if(!empty($pro->Product()->first()->P_Ar_Name))    
                            
                    {{$pro->Product()->first()->P_Ar_Name}}
                        @endif    
                        </li>
                @endforeach
                        
                        
                        
                        </ul>
 
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>


    @endforeach
</main>

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }



                   
            
            $('#product').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: '1/NewAllProClientFilter',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

       
            $('.product').select2({
    placeholder: "اختار...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: '1/NewAllProClientFilter',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 




        });
    });

</script>

@endpush
