@extends('admin.index')
@section('content')

<title>{{trans('admin.ShiftsReportGroup')}}</title>

<style>
/* ===========================
   ستايل الزرار الأزرق
=========================== */
.btn-report {
  display: inline-block;
  width: 100%;
  max-width: 260px;
  height: 65px;
  line-height: 60px;
  font-size: 18px;
  font-weight: 600;
  border-radius: 15px;
   background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff;
  text-align: center;
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
  text-decoration: none;
}

/* إزالة اللون الذهبي من اللمعان */
.btn-report::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(120deg,
    rgba(255, 255, 255, 0.3) 0%,
    rgba(255, 255, 255, 0.1) 50%,
    transparent 100%);
  transition: all 0.6s ease;
}

.btn-report:hover::before {
  left: 100%;
}

.btn-report:hover {
  transform: translateY(-4px) scale(1.03);
 background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  color: #fff; /* اللون الأبيض على الهوفر */
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
}

.btn-report:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
  margin-bottom: 0;
  text-align: center;
  width: 100%;
}
</style>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Reports')}} </a></li>
        <li class="breadcrumb-item active">{{trans('admin.ShiftsReportGroup')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="subheader"></div>

    <div class="row justify-content-center">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2><span class="fw-300"><i>  {{trans('admin.ShiftsReportGroup')}}</i></span></h2>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="row justify-content-center">

                            @if($ReportsSettings->DailyProducts == 1)
                                @can('الاصناف اليوميه')
                                    <div class="col-md-3 mt-2 text-center">
                                        <a href="{{url('DailyProducts')}}" class="btn-report">
                                            {{trans('admin.DailyProducts')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->Shifts == 1)
                                @can('الورديات')
                                    <div class="col-md-3 mt-2 text-center">
                                        <a href="{{url('ShiftsReport')}}" class="btn-report">
                                            {{trans('admin.Shifts')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->Shifts_Details == 1)
                                @can('تفاصيل الورديات')
                                    <div class="col-md-3 mt-2 text-center">
                                        <a href="{{url('ShiftsDetailsReport')}}" class="btn-report">
                                            {{trans('admin.Shifts_Details')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->DailyShifts == 1)
                                @can('الورديات اليوميه')
                                    <div class="col-md-3 mt-2 text-center">
                                        <a href="{{url('DailyShifts')}}" class="btn-report">
                                            {{trans('admin.DailyShifts')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

@endsection
