@extends('admin.index')
@section('content')

<title>{{trans('admin.SalesReportGroup')}}</title>

<style>

/* ===========================
   ستايل الأزرار الكبير + hover
=========================== */
.btn-report {
  display: inline-block;
  width: 100%;
  max-width: 260px;
  height: 65px;
  line-height: 60px;
  font-size: 18px;
  font-weight: 600;
  border-radius: 15px;
  background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff; /* نص أبيض */
  text-align: center;
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
  text-decoration: none;
}

.btn-report::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(120deg,
    rgba(255, 255, 255, 0.3) 0%,
    rgba(255, 255, 255, 0.1) 50%,
    transparent 100%); /* لمعة بيضاء */
  transition: all 0.6s ease;
}

.btn-report:hover::before {
  left: 100%;
}

.btn-report:hover {
  transform: translateY(-4px) scale(1.03);
 background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
  color: #fff; /* نص أبيض عند الهوفر */
}

.btn-report:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
  margin-bottom: 0;
  text-align: center;
  width: 100%;
}

</style>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Reports')}} </a></li>
        <li class="breadcrumb-item active">{{trans('admin.SalesReportGroup')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="subheader"></div>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2><span class="fw-300"><i>  {{trans('admin.SalesReportGroup')}}</i></span></h2>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="row">

                            {{-- زرار كل التقارير --}}
                            @if($ReportsSettings->StagnantItemss == 1)
                                @can('اصناف راكدة جديد')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('StagnantItemsTwo')}}" class="btn-report">
                                            {{trans('admin.StagnantItems')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->StagnantItems == 1)
                                @can('اصناف راكده')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('StagnantItems')}}" class="btn-report">
                                            {{trans('admin.StagnantItems')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->MostSalesProducts == 1)
                                @can('تقرير الاصناف الاكثر مبيعا')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('MostSalesProducts')}}" class="btn-report">
                                            {{trans('admin.MostSalesProducts')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->SalesBills == 1)
                                @can('تقرير فواتير المبيعات')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('SalesBills')}}" class="btn-report">
                                            {{trans('admin.SalesBills')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->GroupsSales == 1)
                                @can('مبيعات المجموعات')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('GroupsSales')}}" class="btn-report">
                                            {{trans('admin.GroupsSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->SalesCustomersGroups == 1)
                                @can('مبيعات مجموعات عملاء تفصيلي')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('SalesCustomersGroups')}}" class="btn-report">
                                            {{trans('admin.SalesCustomersGroups')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->BrandsSales == 1)
                                @can('مبيعات البرندات')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('BrandsSales')}}" class="btn-report">
                                            {{trans('admin.BrandsSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->NetSales == 1)
                                @can('صافي المبيعات')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('NetSales')}}" class="btn-report">
                                            {{trans('admin.NetSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->TotalNetSales == 1)
                                @can('اجمالي صافي المبيعات')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('TotalNetSales')}}" class="btn-report">
                                            {{trans('admin.TotalNetSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->StoresSalesDetails == 1)
                                @can('مبيعات مخازن تفصيلي')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('StoresSalesDetails')}}" class="btn-report">
                                            {{trans('admin.StoresSalesDetails')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->InstallmentCompaniesSales == 1)
                                @can('مبيعات شركات التقسيط')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('InstallmentCompaniesSales')}}" class="btn-report">
                                            {{trans('admin.InstallmentCompaniesSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->SalesProsMoreDetails == 1)
                                @can('تقرير مبيعات مفصله')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('SalesProsMoreDetails')}}" class="btn-report">
                                            {{trans('admin.SalesProsMoreDetails')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @can('تقرير مبيعات برندات مفصله')
                                <div class="col-md-3 mt-2">
                                    <a href="{{url('SalesProsBrandsMoreDetails')}}" class="btn-report">
                                        {{trans('admin.SalesProsBrandsMoreDetails')}}
                                    </a>
                                </div>
                            @endcan

                            @if($ReportsSettings->ClientSales == 1)
                                @can('مبيعات العملاء')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('ClientSales')}}" class="btn-report">
                                            {{trans('admin.ClientSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @if($ReportsSettings->ExecutorSales == 1)
                                @can('مبيعات المنفذ')
                                    <div class="col-md-3 mt-2">
                                        <a href="{{url('ExecutorSales')}}" class="btn-report">
                                            {{trans('admin.ExecutorSales')}}
                                        </a>
                                    </div>
                                @endcan
                            @endif

                            @can('مبيعات الاصناف بالمجموعات')
                                <div class="col-md-3 mt-2">
                                    <a href="{{url('ProductSalesGroupsReport')}}" class="btn-report">
                                        {{trans('admin.ProductSalesGroupsReport')}}
                                    </a>
                                </div>
                            @endcan

                            @can('مبيعات الاصناف بالماركات')
                                <div class="col-md-3 mt-2">
                                    <a href="{{url('ProductSalesBrandsReport')}}" class="btn-report">
                                        {{trans('admin.ProductSalesBrandsReport')}}
                                    </a>
                                </div>
                            @endcan

                            @can('تقرير اصناف اوامر البيع')
                                <div class="col-md-3 mt-2">
                                    <a href="{{url('SalesOrderProductsReport')}}" class="btn-report">
                                        {{trans('admin.SalesOrderProductsReport')}}
                                    </a>
                                </div>
                            @endcan

                            @can('اسعار شحن فواتير المبيعات')
                                <div class="col-md-3 mt-2">
                                    <a href="{{url('PriceShippingSalesBillReport')}}" class="btn-report">
                                        {{trans('admin.PriceShippingSalesBillReport')}}
                                    </a>
                                </div>
                            @endcan

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

@endsection
