@extends('admin.index')
@section('content')

<title>{{trans('admin.ItemsCostsReportGroup')}}</title>

<style>
/* ===========================
   🎨 نسخ نفس الستايل من الصفحة الأولى بالكامل
=========================== */

/* شكل الأزرار */
.btn.btn-primary {
  display: inline-block;
  width: 230px !important;
  height: 70px;
  line-height: 55px;
  font-size: 20px;
  font-weight: 600;
  border-radius: 15px;
   background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff;
  text-align: center;
  text-transform: none;
  letter-spacing: 0.5px;
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
}

.btn.btn-primary::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(
    120deg,
    rgba(255, 255, 255, 0.3) 0%,
    rgba(255, 255, 255, 0.1) 50%,
    transparent 100%
  );
  transition: all 0.6s ease;
}

.btn.btn-primary:hover::before {
  left: 100%;
}

.btn.btn-primary:hover {
  transform: translateY(-4px) scale(1.03);
  background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
}

.btn.btn-primary:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}

/* ترتيب الأزرار */
.col-md-4.mt-2, .col-md-3.mt-2 {
  display: flex;
  justify-content: center;
  align-items: center;
  margin-bottom: 25px;
}

/* حركة الظهور */
.btn.btn-primary {
  animation: fadeInUp 0.6s ease both;
}

@keyframes fadeInUp {
  from {
    opacity: 0;
    transform: translateY(25px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

/* خلفية الصفحة */
body {
  background: linear-gradient(135deg, #e9f0ff 0%, #f9fbff 100%);
  font-family: 'Cairo', sans-serif;
  transition: background 0.5s ease-in-out;
  min-height: 100vh;
}

/* شكل البانيل */
.panel {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.07);
  padding: 25px;
  transition: all 0.3s ease;
}

.panel:hover {
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.12);
}

/* تأثير خفيف في الخلفية */
body::before {
  content: "";
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-image: radial-gradient(circle at 20% 20%, rgba(0, 120, 255, 0.08), transparent 70%),
                    radial-gradient(circle at 80% 80%, rgba(0, 150, 255, 0.08), transparent 70%);
  z-index: -1;
  pointer-events: none;
}

/* تنسيق العناوين */
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}
</style>

<main id="js-page-content" role="main" class="page-content">
  <ol class="breadcrumb page-breadcrumb no-print">
    <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Reports')}} </a></li>
    <li class="breadcrumb-item active">{{trans('admin.ItemsCostsReportGroup')}}</li>
    <li class="position-absolute pos-top pos-right d-none d-sm-block">
      <span class="js-get-date"></span>
    </li>
  </ol>

  <div class="subheader"></div>

  <div class="row">
    <div class="col-xl-12">
      <div id="panel-1" class="panel">
        <div class="panel-hdr">
          <h2><span class="fw-300"><i>{{trans('admin.ItemsCostsReportGroup')}}</i></span></h2>
        </div>

        <div class="panel-container show">
          <div class="panel-content">
            <div class="row">

              <div class="col-md-4 mt-2">
                @if($ReportsSettings->Products == 1)
                  @can('تقرير المنتجات')
                    <a href="{{url('ProductsReports')}}" class="btn btn-primary" title="{{trans('admin.Products')}}">
                      {{trans('admin.Products')}}
                    </a>
                  @endcan
                @endif
              </div>

              <div class="col-md-4 mt-2">
                @if($ReportsSettings->StoresCost == 1)
                  @can('تكلفه المخزون')
                    <a href="{{url('StoresCost')}}" class="btn btn-primary" title="{{trans('admin.StoresCost')}}">
                      {{trans('admin.StoresCost')}}
                    </a>
                  @endcan
                @endif
              </div>

              <div class="col-md-4 mt-2">
                @if($ReportsSettings->StoresCosts == 1)
                  @can('تكلفه المخازن')
                    <a href="{{url('StoresCosts')}}" class="btn btn-primary" title="{{trans('admin.StoresCosts')}}">
                      {{trans('admin.StoresCosts')}}
                    </a>
                  @endcan
                @endif
              </div>

              <div class="col-md-4 mt-2">
                @if($ReportsSettings->ItemCost == 1)
                  @can('جرد المخازن')
                    <a href="{{url('ItemCost')}}" class="btn btn-primary" title="{{trans('admin.ItemCost')}}">
                      {{trans('admin.ItemCost')}}
                    </a>
                  @endcan
                @endif
              </div>

              <div class="col-md-4 mt-2">
                @can('كميات المخزون')
                  <a href="{{url('StoresQtiesReport')}}" class="btn btn-primary" title="{{trans('admin.StoresQtiesReport')}}">
                    {{trans('admin.StoresQtiesReport')}}
                  </a>
                @endcan
              </div>

            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</main>

@endsection
